//#define XERR
#include "costs.ih"

Costs::Costs(Scenario const &scenario)
{
                                            // try specifications via config
    auto single = scenario.find(s_id);    

    if (single.iter == scenario.end())
    {
        scenario.error(single.src, 0, COSTS_SIZE);
        return;        
    }

    istringstream in{ single.iter->tail() };    // costs-specification

    in >> d_referenceAge >> d_discountProportion >> d_biop;

    double lastAge = -1;                            // ages must increase
    try
    {
        CostPair spec;
        while (in >> spec.first)                    // begin diameter
        {
            if (spec.first <= lastAge)              // not increasing
                throw false;

            if (not (in.ignore() >> spec.second))   // followed by treatment
                throw false;                        // cost. Throws at an
                                                    // incomplete entry
            d_treatment.push_back(spec);
            lastAge = spec.first;
        }

        if (
            d_treatment.size() == 0 
            or 
            not Globals::isNonNegZero(d_treatment.front().first)
        )
            throw false;
    }
    catch (bool)
    {
        scenario.error(single.src, single.iter->lineNr(),   //  (
                                    Err::SPECIFICATION) << s_id << "')\n";
    }
}


// xerr("from " << d_treatment.back().first << " to " << [backslash]
// d_treatment.back().second);

