//#define XERR
#include "conffile.ih"

size_t ConfFile::value(char const *id, Config const &specs) const
{
    auto iter = specs.findID(id);

    try
    {
        return iter != specs.end() ? stoul(iter->value()) : value(id);
    }
    catch (...)
    {
        Error::instance()(CONFIG, iter->lineNr(), MISSING_NR) << id << "')\n";
        return 0;
    }
}
