#ifndef INCLUDED_CONFFILE_
#define INCLUDED_CONFFILE_

#include <fstream>
#include <bobcat/config>

#include "../options/options.h"

class ConfFile
{
    mutable FBB::Config d_config;

    public:
        typedef FBB::Config::const_iterator         const_iterator;
        typedef FBB::Config::CIVect::const_iterator IDiterator;
        typedef std::pair<IDiterator, IDiterator>   IDpair;

        ConfFile();
        void load();                                                    // .h

                                                // numeric param., 0 if not
        size_t value(char const *id) const;     // provided.            // 1

                                                // same, but first try specs
        size_t value(char const *id, FBB::Config const &scenario) const; // 2

        IDpair lines(char const *id) const;
        const_iterator end() const;
        const_iterator find(char const *id) const;
};
        
#include "end.f"
#include "find.f"
#include "load.f"
#include "lines.f"

#endif
