#ifndef INCLUDED_SURVIVAL_
#define INCLUDED_SURVIVAL_

        //  (e.g., CumTumorDeathProb.txt)
//                 type    value       spread      dist:
// types a..d are made available as [0..3] in the returned vector
//
// tumorSurvival:  a       0.00004475  0.000004392 Normal  
// tumorSurvival:  b       1.85867     0.0420      Normal
// tumorSurvival:  c       -0.271      0.0101      Normal
// tumorSurvival:  d       2.0167      0.0366      Normal

#include "../vsd/vsd.h"
#include "../scenario/scenario.h"

class Random;

class Survival: public Spread
{
    Random &d_random;

    typedef std::vector<VSD> VSDvect;

    VSDvect d_vsd;
    static char const s_id[];

    public:
        Survival(Random &random, Scenario const &scenario);

        void refresh();
        VSD const &operator[](size_t idx) const;

        void writeParameters(std::ostream &out) const;
};
        
inline VSD const &Survival::operator[](size_t idx) const
{
    return d_vsd[idx];
}

#endif


