//#define XERR
#include "screening.ih"

void Screening::writeParameters(ostream &out) const
{
    out <<
        "   screening:\n"
        "      systematicError:" << setw(8) << d_sysErr.value() << "\n"
        "      attendanceRate: " << setw(8) << d_rate.value() << "\n";


    for (size_t idx = 0; idx != 4; ++idx)
        out <<         "      beta" << idx << ": " << setw(8) << 
                                                d_beta[idx].value() << "\n";

    out <<
        "      m: " << setw(12) << d_m.value() << "\n"
        "      n rounds: " << d_rounds.size() << '\n';

    for (auto const &round: d_rounds)
        out << "         " << round << '\n';

    out.put('\n');
}
