//#define XERR
#include "screening.ih"

void Screening::setRounds(Scenario const &scenario)
{
    auto ret = scenario.lines(s_roundID);

    if (ret.pair.first == ret.pair.second)
        wmsg << "No " << s_roundID << " specifications " << endl;

    for (auto iter = ret.pair.first; iter != ret.pair.second; ++iter)
    {
        if (not addRound(*iter))      
            scenario.error(ret.src, (*iter)->lineNr(),   // filler:  (
                                    SPECIFICATION) << s_roundID << "')\n";
    }
}
