#ifndef INCLUDED_SCREENING_
#define INCLUDED_SCREENING_


// # screening         value   distribution:
// systematicError:    0       Normal  
// attendanceRate:     0.8     Normal  

// # screeningRound :  age mammo tomo 
// #   e.g.:
// # screeningRound:   50  1     1
// # screeningRound:   52  1     1

#include <iosfwd>

#include "../scenario/scenario.h"
#include "../round/round.h"
#include "../globals/globals.h"

class Random;
class Modalities;

struct Screening: public Globals
{
    class Spec
    {
        friend class Screening;

        double    d_value;
        uint16_t  d_dist;

        public:
            double   value() const;
            uint16_t dist() const;
    };

    private:
        Random &d_random;

        Spec d_sysErr;
        Spec d_rate;

        Spec d_beta[4];
        Spec d_m;

        double const *d_beir7dose;      // set from Screening using 
                                        // beir7dose() 

        RoundVect d_rounds;

        static char const s_errorID[];
        static char const s_attendanceID[];
        static char const s_roundID[];
        static char const *s_betaID[];
        static char const s_mID[];

    public:
        Screening(Random &random, Scenario const &scenario);

        Spec const &error() const;
        Spec const &rate() const;
        Spec const &beta(size_t idx) const;
        Spec const &m() const;

        DoubleVect radiationRisk(
                            Modalities const &modalities,
                            Uint16Vect const &indices,
                            double beta, double eta);     // beir7 values

//        DoubleVect const &radiationRisk();

        void beir7dose(double const *dose);                         //  .h

        void writeParameters(std::ostream &out) const;

        uint16_t nRounds() const;


        RoundVect const &rounds() const;
        DoubleVect ages() const;      // vector of ages for the rounds

                                        // roundIdx is, e.g. Loop::d_round
        Round const &round(size_t roundIdx) const;  // individual values
        double age(size_t idx) const;   
 
    private:
        void set(Spec *dest,
                 Scenario const &scenario, char const *id);

        void setSystematicError(Scenario const &scenario);
        void setAttendanceRate(Scenario const &scenario);
        void setBeta(Scenario const &scenario);
        void setM(Scenario const &scenario);
                                                        // 2
        static bool set(Spec *dest, Scenario::const_iterator const &iter);

        void setRounds(Scenario const &scenario);
        bool addRound(Scenario::const_iterator const &info);   // true: added

        static double beir7Err(Round const &round, uint16_t idx, double beta, 
                               double eta, Modalities const &modalities);
};


inline RoundVect const &Screening::rounds() const
{
    return d_rounds;
}

inline Round const &Screening::round(size_t idx) const
{
    return d_rounds[idx];
}

inline double Screening::age(size_t idx) const
{
    return d_rounds[idx].age();
}

inline uint16_t Screening::nRounds() const
{
    return d_rounds.size();
}

inline Screening::Spec const &Screening::error() const
{
    return d_sysErr;
}

inline Screening::Spec const &Screening::rate() const
{
    return d_rate;
}

inline Screening::Spec const &Screening::beta(size_t idx) const
{
    return d_beta[idx];
}

inline Screening::Spec const &Screening::m() const
{
    return d_m;
}

inline void Screening::beir7dose(double const *dose)
{
    d_beir7dose = dose;
}

inline double Screening::Spec::value() const
{
    return d_value;
}

#endif

