//#define XERR
#include "screening.ih"

        // called from loop/initialize.cc

DoubleVect Screening::radiationRisk(
                                Modalities const &modalities,
                                Uint16Vect const &indices,
                                double beta, double eta)   // beir7 values
{
    double screeningRate = d_rate.d_value;
    DoubleVect radiationRisk = DoubleVect(END_AGE, 1);

//xerr("in");

xerr("screeningRate: " << screeningRate);

    for (size_t rndIdx = 0, end = d_rounds.size(); rndIdx != end; ++rndIdx)
    {
        auto const &round = d_rounds[rndIdx];

        uint16_t idx = indices[round.idx()];

// xerr("rndIdx: " << rndIdx << ", idx: " << idx << ", pool rnd: " << d_pool.attendance(rndIdx));

        if (d_random.uniform() > screeningRate)
            continue;

//xerr("calling beir7Err");

        double error = beir7Err(round, idx, beta, eta, modalities);

xerr("beir7Err: " << error);

        for 
        (
            uint16_t age = round.rndAge() + 1; 
                age != END_AGE; 
                    ++age
        )
{
            radiationRisk[age] *= error;

}

//cerr << "radrisk: " << radiationRisk[END_AGE - 1] << '\n';

//xerr("for loop completed");
    }

xerr("out");

    return radiationRisk;
}







