#ifndef INCLUDED_ROUND_
#define INCLUDED_ROUND_

#include <cmath>
#include <istream>
#include <ostream>
#include <vector>

    // contains a round specification from the config file

#include "../typedefs/typedefs.h"

class Round
{
    friend std::istream &operator>>(std::istream &in, Round &round);
    friend std::ostream &operator<<(std::ostream &out, Round const &round);

    double d_age;
    uint16_t d_idx;
    StringVect d_modalities;

    public:
        double age() const;
        uint16_t rndAge() const;                // rounded double age value

                                                // modality IDs used by this
        StringVect const &modalityIDs() const;  // screening round
        uint16_t idx() const;

    private:
        std::istream &extract(std::istream &in);
        std::ostream &insert(std::ostream &out) const;
};
    

inline  StringVect const &Round::modalityIDs() const
{
    return d_modalities;
}

inline double Round::age() const
{
    return d_age;
}

inline uint16_t Round::rndAge() const
{
    return round(d_age);
}

inline uint16_t Round::idx() const
{
    return d_idx;
}

inline std::istream &operator>>(std::istream &in, Round &round)
{
    return round.extract(in);
}

inline std::ostream &operator<<(std::ostream &out, Round const &round)
{
    return round.insert(out);
}

typedef std::vector<Round> RoundVect;
        
#endif
