#ifndef INCLUDED_MODBASE_
#define INCLUDED_MODBASE_

#include <iomanip>

#include "../typedefs/typedefs.h"

class ModBase
{
    friend std::ostream &operator<<(std::ostream &, ModBase const &);

    std::string const d_id;

    uint16_t d_cost = 0;
    uint16_t d_nr;
    SizeVect d_count;
    uint16_t d_falsePositives;

    static uint16_t s_nr;
    
    public:
        ModBase(std::string const &id);
        virtual ~ModBase();

        double sensitivity(size_t idx) const;
        double specificity(double age) const;
        uint16_t cost() const;
        uint16_t nr() const;
        void resetCounters(size_t nRounds);
        void count(size_t round);
        void falsePositive();
        std::string const &id() const;
        double const *dose() const;
        double dose(uint16_t idx) const;

        void roundHeader(std::ostream &out) const;
        void count(std::ostream &out, size_t round) const;

    protected:
        void setCost(uint16_t cost);
        
    private:
//        virtual void vInitialize(size_t nRounds) = 0;

        virtual double const *vDose() const = 0;
        virtual double vDose(uint16_t idx) const = 0;
        virtual void vInsert(std::ostream &out) const = 0;
        virtual double vSensitivity(size_t idx) const = 0;
        virtual double vSpecificity(double age) const = 0;
};

inline void ModBase::count(size_t round)
{
    ++d_count[round];
}

inline void ModBase::count(std::ostream &out, size_t round) const
{
    out << ',' << std::setw(7) << d_count[round];
}

inline uint16_t ModBase::nr() const
{
    return d_nr;
}

inline uint16_t ModBase::cost() const
{
    return d_cost;
}

inline void ModBase::falsePositive()
{
    ++d_falsePositives;
}

inline void ModBase::setCost(uint16_t cost)
{
    d_cost = cost;
}

inline std::string const &ModBase::id() const
{
    return d_id;
}

inline double const *ModBase::dose() const
{
    return vDose();
}

inline double ModBase::dose(uint16_t idx) const
{
    return vDose(idx);
}


inline double ModBase::sensitivity(size_t idx) const
{
    return vSensitivity(idx);
}

inline double ModBase::specificity(double age) const
{
    return vSpecificity(age);
}

inline void ModBase::roundHeader(std::ostream &out) const
{
    out << ", #" << d_id;
}    

#endif

