#ifndef INCLUDED_MODALITIES_
#define INCLUDED_MODALITIES_

// config format:
// modalities      cost dose    sensitivity         specificity
//            id:                              agegroup value (repeated)
// modality:  Mammo 64  3 3 3 3 0.87 0.84 0.73 0.65 0-40:    0.961 
// modality:  MRI   64          0.00                0.00

#include <iosfwd>
#include <vector>

#include <unordered_map>
#include <unordered_set>

#include "../enums/enums.h"
#include "../scenario/scenario.h"

class Error;
class ModBase;

struct Modalities   //: public Globals
{
    typedef ModBase *(*MakeModBase)(std::string const &, std::istream &);
    typedef std::unordered_map<std::string, MakeModBase> Map;

    std::vector<ModBase *> d_modBase;               // active modalities
    std::unordered_set<std::string> d_specified;    // defined modality IDs

    Error &d_error;

    static Map s_map;
    static char const s_ID[];

    public:
        Modalities(Scenario const &scenario);
        ~Modalities();

                            // visit all modalities and initialize
                            // their data, see loop/initialize
            // see also Loop::d_nModalityFP: modality specific, to become
            //      a size_t variables in each used modality
        void resetCounters(size_t nRounds);  

// double specificity(age) const: age may not be negative

            // return a vector of ModBase ptrs matching the names specified
            //  in 'active'
        std::vector<ModBase *> use(StringVect const &active) const;

        double const *hasDose(StringVect const &ids) const;

        void writeParameters(std::ostream &out) const;

        void roundHeaders(std::ostream &out) const;
        void writeRounds(std::ostream &out, size_t round) const;

    private:
        void add(ConfigSrc src, Scenario::const_iterator const &info);

                                                // Tomo/Mammo ptr
        static ModBase *tmPtr(std::string const &, std::istream &in);
                                                // MRI ptr
        static ModBase *mriPtr(std::string const &, std::istream &in);   
};


////////////////////////////////////////////////////////////////////
//            // 1st dimension is the type index, 
//            // 2nd dimension is the id dimension
//        ParamsVect2 d_modality;
//
//        static Map s_type;
//        static Map s_id;
//
//    class Params
//    {
//        friend class Modalities;
//
//        double d_dose[N_DOSES];
//        double   d_sens[N_SENS];            // sensitivities
//        SpecVect d_spec;                    // specificities
//    
//        public:
//            double const *dose() const;
//            double const *sens() const;
//
//            double dose(size_t idx) const;
//            double   sens(size_t idx) const;
//            Specificity const &operator[](size_t idx) const;
//    };
//
//    typedef std::vector<Params> ParamsVect;
//    typedef std::vector<ParamsVect> ParamsVect2;
//
//
//
//        ParamsVect const &operator[](size_t idx) const;
//
//        Params const &mammoParams() const;
//        Params const &tomoParams() const;
//
//        void writeParameters(std::ostream &out) const;                 // 1
//
//    private:
//        void params(std::ostream &out, char const *label, Constants type) 
//                                                                        const;
//        void birads(std::ostream &out, char const *label, 
//                    double const *value, Constants count) const;
//
//
//        void makeRoom(uint16_t typeIdx, uint16_t idIdx);
//
//        static bool readSpecificities(std::istream &in, Params &params);



// inline Modalities::ParamsVect const &Modalities::operator[](size_t idx) const
// {
//     return d_modality[idx];
// }
// 
// inline Modalities::Params const &Modalities::mammoParams() const
// {
//     return d_modality[XRAY][MAMMO];
// }
// 
// inline Modalities::Params const &Modalities::tomoParams() const
// {
//     return d_modality[XRAY][TOMO];
// }
// 
// inline uint16_t Modalities::Specificity::beginAge() const
// {
//     return d_beginAge;
// }
// 
// inline uint16_t Modalities::Specificity::endAge() const
// {
//     return d_endAge;
// }
// 
// inline double Modalities::Specificity::value() const
// {
//     return d_value;
// }
// 
// inline double Modalities::Params::dose(size_t idx) const
// {
//     return d_dose[idx];
// }
// 
// inline double const *Modalities::Params::dose() const
// {
//     return d_dose;
// }
// 
// inline double   Modalities::Params::sens(size_t idx) const
// {
//     return d_sens[idx];
// }
// 
// inline double const *Modalities::Params::sens() const
// {
//     return d_sens;
// }
// 
// inline Modalities::Specificity 
//             const &Modalities::Params::operator[](size_t idx) const
// {
//     return d_spec[idx];
// }

#endif


