//#define XERR
#include "modalities.ih"

double const *Modalities::hasDose(StringVect const &ids) const
{
    for (auto const &id: ids)       // modalities used in a screening round
    {                               // return 1st ptr to available dose
        for (ModBase const *modBase: d_modBase)
        {
            if (
                double const *dose = modBase->dose(); 
                dose != 0 and modBase->id() == id
            )
                return dose;
        }
    }

    return 0;
}
