//#define XERR
#include "modalities.ih"

// config format:
//   modalities         dose    sensitivity         specificity
//                id:                              agegroup value (repeated)
// modality:      Mammo 3 3 3 3 0.87 0.84 0.73 0.65 0-40: 0.961  
// modality:      MRI           0.0                 0.0

void Modalities::add(ConfigSrc src, Scenario::const_iterator const &iter)
try
{
    istringstream in{ iter->tail() };
    uint16_t lineNr = iter->lineNr();

    string id;
    in >> id;                               // e.g. Mammo, Tomo, MRI

    auto mapIter = s_map.find(id);          // find the matching function ptr
    
    if (mapIter == s_map.end())             // unknown id
        throw lineNr;

    if (d_specified.find(id) != d_specified.end())
    {
        d_error(src, iter->lineNr(), MULTIPLY_SPECIFIED) << s_ID << ": " << 
                                                            id << " ...\n";

        return;                     // this Modality id is already available
    }
                                    // this modality is now specified
    d_specified.insert(d_specified.begin(), id); 

        // create a new ModBase derived object, if its specifications are
        // correctly read then add it, otherwise throw the offending line nr.
    if (ModBase *ptr = (*mapIter->second)(id, in); ptr == 0)
        throw lineNr;
    else
        d_modBase.push_back(ptr);

}
catch (uint16_t lineNr)
{
    d_error(src, lineNr,                  // (
                 SPECIFICATION) << s_ID << "')\n";
}








