#ifndef INCLUDED_MAMMOTOMO_
#define INCLUDED_MAMMOTOMO_

#include "../modbase/modbase.h"

// config format:
// modalities      cost dose    sensitivity         specificity
//            id:                                   agegroup value (repeated)
// modality: Mammo 64   3 3 3 3 0.87 0.84 0.73 0.65 0-40:    0.961 

class MammoTomo: public ModBase
{
    enum 
    {
        N_DOSES = 4,
        N_SENS = 4
    };

//    class Specificity
    struct Specificity
    {
//        friend class MammoTomo;

        uint16_t    d_beginAge;
        uint16_t    d_endAge;
        double      d_value;

//        public:
//            uint16_t    beginAge() const;
//            uint16_t    endAge() const;
//            double      value() const;
    };

    typedef std::vector<Specificity> SpecVect;


    double d_dose[N_DOSES];
    double d_sens[N_SENS];

    SpecVect d_spec;

    public:
        MammoTomo(std::string const &id, std::istream &in);
        ~MammoTomo() override;

    private:
        void readSpecificities(std::istream &in);
        void birads(std::ostream &out, char const *label, 
                    double const *value, size_t ount) const;

//        void vInitialize(size_t nRounds) override;

        double const *vDose() const override;               // 1
        double vDose(uint16_t) const override;              // 2
        void vInsert(std::ostream &out) const override;
        double vSensitivity(size_t idx) const override;
        double vSpecificity(double age) const override;

};
        
#endif




