#define XERR
#include "loop.ih"

void Loop::writeData(ostream &out, size_t idx) const
{
    if (not out)
        return;

    setPrecision(out, 2) << 
        setw(6) << 
            idx << ',' <<
        setw(8) << 
            (d_status >= TUMOR_PRE ? "Tumor" : "Natural") << ',' <<
        setw(7) << 
            d_deathAge << ',';
// << ',' <<
//' ' << d_sumDeathAge 

    d_tumor.writeData(out);

    out << 
        setw(7) << 
            d_naturalDeathAge << ',' <<
        setw(2) << 
            d_status << ',' <<
        setw(5) << 
            static_cast<size_t>(round(d_caseCost)) << ',' <<
//' ' << d_totalCost << ',' <<
        setw(2) << 
            d_selfDetected << ',' <<
        setw(2) << 
            d_roundDetected << ',' <<
        '\n';

//    for (double cost: d_roundCost)
//        out << setw(10) << static_cast<size_t>(round(cost)) << ',';
//
//    for (uint16_t index: d_indices)
//        out << setw(12) << (index + 1) << ','; // see also loop/loop.h and
//                                                // modifications
//    out << '\n';
}




