//#define XERR
#include "loop.ih"

// -> ORG/womanloop.cpp

void Loop::womenLoop(size_t iter)
{
    ofstream data = headerData(iter);           

    bool showAll = not d_options.specificAges() and d_options.lastCase() == 0;

//    d_random.reset(d_scenario.seed());

    for (
        size_t idx = 0, 
               end =
                    d_options.lastCase() != 0 ? d_options.lastCase()    :
                    d_options.specificAges()  ? 1                       :
                                                d_scenario.nWomen();
            idx != end; 
                ++idx
    )
    {
        initialize(idx);

        preScreen();        // no action unless screening rounds are specified
        screening();        // same
        postScreen();

        d_sumDeathAge += d_deathAge;
        d_totalCost += d_caseCost;

        if (showAll or idx + 1 == end)
            writeData(data, idx);
    }
}

// In the original womanloop function a test is performed whether the
// woman has died or not. This test is superfluous because if the woman enters
// postScreen with status PRESENT then in postScreen the status either changes
// to LEFT_POST or TUMOR_POST.

