//#define XERR
#include "loop.ih"

void Loop::parameters(size_t iter) const
{
    ofstream out{ d_scenario.parametersFile(iter) };

    if (not out)
        return;

    labels(out);            // timestamp and scenatio explanatory labels

    setPrecision(out, 3);

    d_scenario.writeParameters(out, iter + 1);
    d_costs.writeParameters(out);      
    d_screening.writeParameters(out);      
    d_densities.writeParameters(out);
    d_modalities.writeParameters(out);
    d_tumorInfo.writeParameters(out);
}
