//#define XERR
#include "loop.ih"

void Loop::maybeDetect(ModBase *modBase, double screeningAge)
{
    // the check for tumor.diameter() >= 1 is omitted, since
    // all tumors have at least 1 mm diameter 
    // (see also Marcel: Tue, 30 Jun 2020 10:46:05 +0000)

    if (betaFunction(modBase->nr()))
    {
        // Found a tumor during the screening -> no need to call
        // diameterCheck() 
        
        d_tumor.detected();
        ++d_nDetections[d_round];

        addCost(d_costs.treatment(screeningAge, d_tumor.diameter()));  
        d_tumor.setDeathAge(screeningAge);

        d_roundDetected = d_round;

        if (d_naturalDeathAge < d_tumor.deathAge()) 
{
xerr("NATURAL DURING");
                                // A tumor was found, but the woman dies of 
                                // natural causes before she died of the tumor 
            setStatus(LEFT_DURING, d_naturalDeathAge);
}
        else
            setStatus(TUMOR_DURING, d_tumor.deathAge());
    }

    if (d_random.uniform() > sensitivity(modBase))
        ++d_nRoundFN[d_round];
}


