//#define XERR
#include "loop.ih"

    // -> ORG/niterationsloop.cpp

void Loop::iterate()
{
    ofstream sensitivity = headerSensitivity();

    if (d_scenario.seedType() == RANDOM_SEED)
        d_random.reset(time(0));
    else
        d_seed = d_scenario.seed();

    for (size_t idx = 0, end = d_scenario.iterations(); idx != end; ++idx)
    {
        checkSeed();
                                    // maybe refresh the parameters
        d_tumorInfo.refresh(d_random, d_scenario.spread());   
                                                   
        parameters(idx);            // write the actual parameter values,

        ofstream rounds = headerRounds(idx);

        resetCounters();

        womenLoop(idx);

        writeRounds(rounds);        // -> ORG/loopendout.cpp
        writeSensitivity(sensitivity, idx);
    }
}





