//#define XERR
#include "loop.ih"

// called from maybeDetect, called from screen: screen calls maybeDetect
// when there is a tumor -> no need to check whether the tumor is present:
// just request its diameter.

//code
bool Loop::betaFunction(uint16_t modalityNr)
{
    double diameter = d_tumor.diameter();
    double mValue = d_screening.m().value();

    double expBeta = 
        exp(
            d_screening.beta(0).value() +
            d_screening.beta(1).value() * diameter +
            d_screening.beta(2).value() * mValue +
            d_screening.beta(3).value() * mValue / (diameter * diameter)
        );
    
    return d_random.uniform() <= 0.9 * expBeta / (1 + expBeta);
}
//=
