//#define XERR
#include "incidence.ih"

bool Incidence::addProbabilities(double *sumProb, 
                                 Scenario::Range const &range)
{
    bool ok = true;
    size_t idx = 0;

    for (auto iter = range.pair.first; iter != range.pair.second; ++iter)
    {
        if (double prob = add(*iter); prob >= 0)
        {
            *sumProb += prob;
            d_cumProb[idx] = *sumProb;
        }
        else
        {
            ok = false;
            d_scenario.error(range.src,                 // filler:    (
                       (*iter)->lineNr(), SPECIFICATION) << s_id << "')\n";
        }
        ++idx;
    }

    return ok;
}




