//#define XERR
#include "incidence.ih"

//                              lifeTimeRisk (VSD) meanAge (VSD) std.dev (VSD)
//                 carier       -----------------  ------------- -------------
//                 name    prob value spread dist. 
// tumorIncidence: Normal  1    0.226 0.0053 Normal  
//
//  values are set to 0 if the prob. equals 0

double Incidence::add(Scenario::const_iterator const &line)
{
    istringstream in{ line->tail() };

    Params params;
    string name;

    in >> name >> params.d_prob;

    if (not isZero(params.d_prob))
        in >> params.d_risk >> params.d_mean >> params.d_stdDev;

    params.d_idx = xlatDist(name);

    if (not in or params.d_idx == string::npos)
        return -1;                              // specification error

    d_params.push_back(params);

    return params.d_prob;
}



