//#define XERR
#include "growth.ih"

Growth::Growth(Scenario const &scenario)
:
    d_error(scenario.error())
{
    auto range = scenario.lines(s_id);

    bool ok = true;
    for (auto iter = range.pair.first; iter != range.pair.second; ++iter)
    {
        if (not parse(range.src, *iter))
            ok = false;
    }

    if (not ok)
        return;

    if (d_start.dist() == NO_DIST)
        d_error(range.src, 0, TUMORGROWTH_STARTDIAM);

    if (d_ageGroups.empty())
        d_error(range.src, 0, TUMORGROWTH_AGEGROUPS);
}








