
#ifndef INCLUDED_GROWTH_
#define INCLUDED_GROWTH_

// the first encountered specifications are used
//
// #            VSD                 VSD                 VSD
// #            startDiameter       selfDetectDiam. Mu  selfDetectDiam.Sigma
// #            value spread dist.  value spread dist.  value spread dist.     
// tumorGrowth: 5     0      Normal 2.92  0.084  Normal 0.70  0      Normal
//                 
// #                         VSD                  VSD
// #doublingTime:  agegroup  mean spread  dist.   stdev   spread  dist.
// tumorGrowth:    0-50      4.38 0.43    Normal  0.61    0       Normal  
// tumorGrowth:    50-70     5.06 0.17    Normal  0.26    0       Normal  
// tumorGrowth:    70-100    5.24 0.23    Normal  0.45    0       Normal  

#include <sstream>

#include "../vsd/vsd.h"
#include "../scenario/scenario.h"

class Random;

struct Growth: public Spread
{   
    class AgeGroup
    {
        friend class Growth;

        uint16_t d_beginAge;
        uint16_t d_endAge;
        VSD      d_mean;
        VSD      d_stdDev;

        public:
            uint16_t beginAge() const;
            uint16_t endAge() const;
            VSD      const &mean() const;
            VSD      const &stdDev() const;
    };

    typedef std::vector<AgeGroup> AgeGroupVect;

    private:
        Error &d_error;

        VSD d_start;        // startDiameter
        VSD d_selfMu;       // self detect MU
        VSD d_selfSigma;    // self detect Sigma
    
        std::istringstream d_in;
        AgeGroupVect d_ageGroups;

        static char const s_id[];

    public:
        Growth(Scenario const &scenario);

        AgeGroup const &group(uint16_t idx) const;

        void refresh(Random &random);

        VSD const &start() const;
        VSD const &selfMu() const;
        VSD const &selfSigma() const;

        void writeParameters(std::ostream &out) const;

    private:
        bool parse(ConfigSrc src, Scenario::const_iterator const &iter);
        bool ageGroup(ConfigSrc src, uint16_t lineNr, std::istream &in);

        static void writeDiameter(std::ostream &out, char const *name,
                                  double value);
        static void writeDT(std::ostream &out, char const *name,
                            size_t idx, double value);
};

inline Growth::AgeGroup const &Growth::group(uint16_t idx) const
{
    return d_ageGroups[idx];
}

inline VSD const &Growth::start() const
{
    return d_start;
}

inline VSD const &Growth::selfMu() const
{
    return d_selfMu;
}

inline VSD const &Growth::selfSigma() const
{
    return d_selfSigma;
}

inline VSD const &Growth::AgeGroup::mean() const
{
    return d_mean;
}

inline VSD const &Growth::AgeGroup::stdDev() const
{
    return d_stdDev;
}

inline uint16_t Growth::AgeGroup::beginAge() const
{
    return d_beginAge;
}

inline uint16_t Growth::AgeGroup::endAge() const
{
    return d_endAge;
}

#endif







