//#define XERR
#include "growth.ih"

bool Growth::ageGroup(ConfigSrc src, uint16_t lineNr, istream &in)
{
    in.clear();                         // clear the fail-state
    in.seekg(0);                        // start again from the beginning

    AgeGroup ag;
    char sep;

    d_in >> ag.d_beginAge >> sep >> ag.d_endAge >> ag.d_mean >> ag.d_stdDev;

    if (not d_in)
        throw lineNr;

    if (                                    // only store new definitions
        find_if(d_ageGroups.begin(), d_ageGroups.end(), 
            [&](AgeGroup const &element)
            {
                return element.beginAge() == ag.beginAge();
            }
        )
        == d_ageGroups.end()
    )
    {
        d_ageGroups.push_back(ag);
        return true;
    }

    d_error(src, lineNr, MULTIPLY_SPECIFIED) << "agegroup " <<  
                ag.beginAge() << '-' << ag.endAge() << '\n';

    return false;
}

