#ifndef INCLUDED_ERROR_
#define INCLUDED_ERROR_

#include <iosfwd>
#include <cstdint>

#include "../enums/enums.h"

class Error
{
    uint16_t d_count = 0;

    static char const *s_error[];
    static char const *s_src[];

    public:
        std::ostream &operator()(ConfigSrc type, uint16_t lineNr, Err value);
        uint16_t count() const;
        static char const *src(ConfigSrc type);
};

inline uint16_t Error::count() const
{
    return d_count;
}

inline char const *Error::src(ConfigSrc type)
{
    return s_src[type];
}
        
#endif
