#ifndef INCLUDED_DENSITIES_
#define INCLUDED_DENSITIES_

// config format:
//                     agegroup    birads1 birads2 birads3 birads4
// breastDensities:    0  - 40     0.05    0.30    0.48    0.17

#include <iosfwd>

#include "../enums/enums.h"
#include "../typedefs/typedefs.h"
#include "../scenario/scenario.h"

class Random;
//class Error;

struct Densities
{
    class Density
    {
        friend class Densities;

        uint16_t    d_beginAge;
        uint16_t    d_endAge;
        double      d_birads[N_BIRADS];
        double      d_cumBirads[N_BIRADS];

        public:
            uint16_t  beginAge();
            uint16_t  endAge();
            double    birads(size_t idx);

        private:
            bool contains(double age) const;                            // .ih
            uint16_t indexOf(double prob) const;
            void insertInto(std::ostream &out) const;
    };
    typedef std::vector<Density> DensityVect;   // ensure sorted by end-age
                                                // and that the full range is
                                                // covered
    private:
        Error &d_error;
        DensityVect d_densities;

        static char const s_id[];

    public:
        Densities(Scenario const &scenario);

        DensityVect const &densities() const;
        Uint16Vect indices(Random &random, DoubleVect const &ages) const;

        void writeParameters(std::ostream &out) const;

    private:
        void add(ConfigSrc src, Scenario::const_iterator const &info);

                                                // birads idx for age, given 
        uint16_t biradsIdx(double age, double prob) const;  // its probability
};
        
inline Densities::DensityVect const &Densities::densities() const
{
    return d_densities;
}

inline uint16_t Densities::Density::beginAge()
{
    return d_beginAge;
}

inline uint16_t Densities::Density::endAge()
{
    return d_endAge;
}

inline double Densities::Density::birads(size_t idx)
{
    return d_birads[idx];
}


#endif



