//#define XERR
#include "densities.ih"

void Densities::add(ConfigSrc src, Scenario::const_iterator const &iter)
{
    istringstream in{ iter->tail() };

    Density density;
    char sep;

    in >> density.d_beginAge >> sep >> density.d_endAge;

    if (
        d_densities.end() != 
            find_if(d_densities.begin(), d_densities.end(), 
                [&](Density const &element)
                {
                    return element.d_beginAge == density.d_beginAge;
                }
            )
    )
    {                             
        d_error(src, iter->lineNr(), MULTIPLY_SPECIFIED) << s_id << ": " << 
                                            density.d_beginAge << " - ...\n";
        return;
    }

    double cumProp = 0;
    for (size_t idx = 0; idx != N_BIRADS; ++idx)
    {
        double proportion;
        in >> proportion;

        density.d_birads[idx] = proportion;

        cumProp += proportion;
        density.d_cumBirads[idx] = cumProp;
    }

    if (not in)
    {                                                //  (
        d_error(src, iter->lineNr(), SPECIFICATION) << s_id << "')\n";        
        return;
    }

    d_densities.push_back(density);
}
