//#define XERR
#include "costs.ih"

Costs::Costs(Scenario const &scenario)
{
                                            // try specifications via config
    auto single = scenario.find(s_id);    

    if (single.iter == scenario.end())
    {
        scenario.error(single.src, 0, COSTS_SIZE);
        return;        
    }

    istringstream in{ single.iter->tail() };

    in >> d_discountAge >> d_discount >> d_biop;

    try
    {
        CostPair spec;
        while (in >> spec.first)
        {
            if (not (in.ignore() >> spec.second))
                throw false;                    // incomplete entry
            
            d_treatment.push_back(spec);

            xerr("from " << d_treatment.back().first << " to " << d_treatment.back().second);

        }
        if (
            d_treatment.size() == 0 
            or 
            not Globals::isNonNegZero(d_treatment.front().first)
        )
            throw false;
    }
    catch (bool)
    {
        scenario.error(single.src, single.iter->lineNr(),   //  (
                                    Err::SPECIFICATION) << s_id << "')\n";
    }
}

