#ifndef INCLUDED_COSTS_
#define INCLUDED_COSTS_

//           cost_<2  cost_2-5  cost_>5  cost_biop  discount
// costs:    6438     7128      7701     176        0.00

#include <iosfwd>
#include <cstdint>
#include <cstddef>
#include <vector>

#include "../enums/enums.h"

class Scenario;

class Costs
{
              // lower diam., cost
    typedef std::pair<double, uint16_t>     CostPair;
                    
                                            // costs of treatments given
    std::vector<CostPair> d_treatment;      // tumor diam.
 
    double d_discountAge;     
    uint16_t d_discount;
    uint16_t d_biop;                        // biopsy cost

    static char const s_id[];

    public:
        Costs(Scenario const &scenario);

        double treatment(double age, double diameter) const;        //  .h
        double screening(double age, uint16_t cost) const;
        double biopsy(double age) const;

        void writeParameters(std::ostream &out) const;

    private:
        uint16_t cost(double diameter) const;
        double discount(size_t cost, double age) const;          
};


inline double Costs::biopsy(double age) const
{
    return discount(d_biop, age);
}

inline double Costs::treatment(double age, double diameter) const
{
    return discount(biopsy(age) + cost(diameter), age);
}


#endif




