var NAVTREE =
[
  [ "SimGrid", "index.html", [
    [ "Installing Simgrid", "install.html", [
      [ "Installing the SimGrid library", "install.html#install_cmake", [
        [ "Some generality", "install.html#install_intro", [
          [ "What is Cmake?", "install.html#install_intro1", null ],
          [ "Why cmake?", "install.html#install_intro2", null ],
          [ "What cmake need?", "install.html#install_intro3", null ],
          [ "Liste of options", "install.html#install_cmakeoption1", null ],
          [ "Options explaination", "install.html#install_cmakeoption2", null ],
          [ "Initialisation", "install.html#install_cmakeoption3", null ],
          [ "Option's cache and how to reset?", "install.html#install_cmakeoption4", null ]
        ] ],
        [ "Cmake compilation", "install.html#install_cmakecompilation", [
          [ "With command line.", "install.html#install_cmakecompilation1", null ],
          [ "With ccmake tool.", "install.html#install_cmakecompilation2", null ],
          [ "Build out of source.", "install.html#install_cmakecompilation2bis", null ],
          [ "Resume of command line", "install.html#install_cmakecompilation3", null ]
        ] ],
        [ "How to install with cmake?", "install.html#install_cmakeinstall", [
          [ "From Git.", "install.html#install_cmakeinstall1", null ],
          [ "From a distrib", "install.html#install_cmakeinstall2", null ]
        ] ]
      ] ],
      [ "Installing the SimGrid framework on Windows", "install.html#install_Win", [
        [ "Installing SimGrid with the automatic installer", "install.html#install_Win_install", null ],
        [ "Compile a project \"HelloWorld\"", "install.html#install_Win_compile1", null ],
        [ "How to add and compile a new example", "install.html#install_Win_compile2", null ],
        [ "Setup a virtualbox to use SimGrid-Ruby on windows", "install.html#install_Win_ruby", null ]
      ] ],
      [ "Installing the SimGrid framework on Mac OS X", "install.html#install_mac", null ],
      [ "Setting up your own MSG code", "install.html#install_setting_MSG", null ]
    ] ],
    [ "Using SimGrid", "use.html", [
      [ "Using MSG", "use.html#using_msg", [
        [ "Basic examples and features", "use.html#MSG_ex_basics", [
          [ "Asynchronous communications", "use.html#MSG_ex_asynchronous_communications", [
            [ "Code of the application", "use.html#MSG_ext_icomms_code", null ],
            [ "Preliminary declarations", "use.html#MSG_ext_icomms_preliminary", null ],
            [ "Sender function", "use.html#MSG_ext_icomms_Sender", null ],
            [ "Receiver function", "use.html#MSG_ext_icomms_Receiver", null ],
            [ "Simulation core", "use.html#MSG_ext_icomms_core", null ],
            [ "Main function", "use.html#MSG_ext_icomms_Main", null ],
            [ "Waitall function for sender", "use.html#MSG_ext_icomms_fct_Waitall", null ],
            [ "Waitany function", "use.html#MSG_ext_icomms_fct_Waitany", null ],
            [ "From a sender", "use.html#MSG_ext_icomms_fct_Waitany_sender", null ],
            [ "From a receiver", "use.html#MSG_ext_icomms_fct_Waitany_receiver", null ]
          ] ],
          [ "Basic Master/Slaves", "use.html#MSG_ex_master_slave", [
            [ "Table of contents:", "use.html#MSG_ex_ms_TOC", null ],
            [ "Preliminary declarations", "use.html#MSG_ext_ms_preliminary", null ],
            [ "Master code", "use.html#MSG_ext_ms_master", null ],
            [ "Slave code", "use.html#MSG_ext_ms_slave", null ],
            [ "Forwarder code", "use.html#MSG_ext_ms_forwarder", null ],
            [ "Simulation core", "use.html#MSG_ext_ms_core", null ],
            [ "Main() function", "use.html#MSG_ext_ms_main", null ]
          ] ],
          [ "Helping files", "use.html#MSG_ext_ms_helping", [
            [ "Example of application file", "use.html#MSG_ext_ms_application", null ],
            [ "Example of platform file", "use.html#MSG_ext_ms_platform", null ]
          ] ]
        ] ]
      ] ],
      [ "Using GRAS", "use.html#using_gras", [
        [ "Ping-Pong", "use.html#GRAS_ex_ping", [
          [ "Table of contents of the ping example", "use.html#GRAS_ex_ping_toc", null ],
          [ "1) Common code to the client and the server", "use.html#GRAS_ex_ping_common", [
            [ "1.a) Initial settings", "use.html#GRAS_ex_ping_initial", null ],
            [ "1.b) Register the messages", "use.html#GRAS_ex_ping_register", null ]
          ] ],
          [ "2) Server's code", "use.html#GRAS_ex_ping_server", [
            [ "2.a) The server's globals", "use.html#GRAS_ex_ping_serdata", null ],
            [ "2.b) The callback to the ping message", "use.html#GRAS_ex_ping_sercb", null ],
            [ "2.c) The \"main\" of the server", "use.html#GRAS_ex_ping_sermain", null ]
          ] ],
          [ "3) Client's code", "use.html#GRAS_ex_ping_client", [
            [ "3.a) Client's \"main\" function", "use.html#GRAS_ex_ping_climain", null ]
          ] ]
        ] ],
        [ "Token Ring example", "use.html#GRAS_ex_token", null ],
        [ "1) Deployment file", "use.html#GRAS_ex_stoken_deploy", null ],
        [ "2) Global definition", "use.html#GRAS_ex_stoken_global", null ],
        [ "3) The callback", "use.html#GRAS_ex_stoken_callback", null ],
        [ "4) The main function", "use.html#GRAS_ex_stoken_main", null ],
        [ "A simple RPC for matrix multiplication", "use.html#GRAS_ex_mmrpc", [
          [ "Table of contents of the mmrpc example", "use.html#GRAS_ex_mmrpc_toc", null ],
          [ "1) Common code to the client and the server (mmrpc_common.c and mmrpc.h)", "use.html#GRAS_ex_mmrpc_common", [
            [ "1.a) Module header (mmrpc.h)", "use.html#GRAS_ex_mmrpc_header", null ],
            [ "1.b) Register the data types (mmrpc.h)", "use.html#GRAS_ex_mmrpc_dataregister", null ],
            [ "1.c) Logging category definition (mmrpc_common.c)", "use.html#GRAS_ex_mmrpc_logdef", null ],
            [ "1.d) Register the messages (mmrpc_common.c)", "use.html#GRAS_ex_mmrpc_msgregister", null ]
          ] ],
          [ "2) Server's code (mmrpc_server.c)", "use.html#GRAS_ex_mmrpc_server", [
            [ "2.a) Server intial settings", "use.html#GRAS_ex_mmrpc_serinc", null ],
            [ "2.b) The callback to the mmrpc message", "use.html#GRAS_ex_mmrpc_sercb", null ],
            [ "2.c) The \"main\" of the server", "use.html#GRAS_ex_mmrpc_sermain", null ]
          ] ],
          [ "3) Client's code (mmrpc_client.c)", "use.html#GRAS_ex_mmrpc_client", [
            [ "2.a) Server intial settings", "use.html#GRAS_ex_mmrpc_cliinc", null ],
            [ "3.b) Client's \"main\" function", "use.html#GRAS_ex_mmrpc_climain", null ]
          ] ]
        ] ],
        [ "Some timer games", "use.html#GRAS_ex_timer", [
          [ "1. Declarations and headers", "use.html#GRAS_ex_timer_decl", null ],
          [ "2. Source code of the delayed action", "use.html#GRAS_ex_timer_delay", null ],
          [ "3. Source code of the repetitive action", "use.html#GRAS_ex_timer_repeat", null ],
          [ "4. Source code of main function", "use.html#GRAS_ex_timer_main", null ]
        ] ]
      ] ],
      [ "Using SMPI", "use.html#using_smpi", null ],
      [ "Using Model Checking", "use.html#using_MC", null ],
      [ "Using Trace", "use.html#using_trace", null ],
      [ "Using SimDag", "use.html#using_simdag", null ],
      [ "Using SIMIX", "use.html#using_simix", null ]
    ] ],
    [ "Simgrid options and configurations", "options.html", [
      [ "Passing configuration options to the simulators", "options.html#options_using", null ],
      [ "Configuring the platform models", "options.html#options_model", [
        [ "Selecting the platform models", "options.html#options_model_select", null ],
        [ "Optimization level of the platform models", "options.html#options_model_optim", null ],
        [ "Numerical precision of the platform models", "options.html#options_model_precision", null ],
        [ "Parallel threads for model updates", "options.html#options_model_nthreads", null ],
        [ "Configuring the Network model", "options.html#options_model_network", [
          [ "Maximal TCP window size", "options.html#options_model_network_gamma", null ],
          [ "Corrective simulation factors", "options.html#options_model_network_coefs", null ],
          [ "Simulating cross-traffic", "options.html#options_model_network_crosstraffic", null ],
          [ "Coordinated-based network models", "options.html#options_model_network_coord", null ],
          [ "Simulating sender gap", "options.html#options_model_network_sendergap", null ],
          [ "Configuring packet-level pseudo-models", "options.html#options_pls", null ]
        ] ]
      ] ],
      [ "Configuring the Model-Checking", "options.html#options_modelchecking", [
        [ "Specifying a liveness property", "options.html#options_modelchecking_liveness", null ],
        [ "Going for stateful verification", "options.html#options_modelchecking_steps", null ],
        [ "Specifying the kind of reduction", "options.html#options_modelchecking_reduction", null ]
      ] ],
      [ "Configuring the User Process Virtualization", "options.html#options_virt", [
        [ "Selecting the virtualization factory", "options.html#options_virt_factory", null ],
        [ "Adapting the used stack size", "options.html#options_virt_stacksize", null ],
        [ "Running user code in parallel", "options.html#options_virt_parallel", null ]
      ] ],
      [ "Configuring the tracing subsystem", "options.html#options_tracing", null ],
      [ "Configuring SMPI", "options.html#options_smpi", [
        [ "Automatic benchmarking of SMPI code", "options.html#options_smpi_bench", null ],
        [ "Reporting simulation time", "options.html#options_smpi_timing", null ]
      ] ],
      [ "Configuring other aspects of SimGrid", "options.html#options_generic", [
        [ "XML file inclusion path", "options.html#options_generic_path", null ],
        [ "Behavior on Ctrl-C", "options.html#options_generic_exit", null ]
      ] ],
      [ "Logging Configuration", "options.html#options_log", null ],
      [ "Index of all existing configuration items", "options.html#options_index", null ]
    ] ],
    [ "Platform Description", "platform.html", [
      [ "Some words about XML and DTD", "platform.html#pf_overview", null ],
      [ "Basic concepts", "platform.html#pf_basics", null ],
      [ "Describing resources and their organization", "platform.html#pf_pftags", [
        [ "Platform organization tag : AS", "platform.html#pf_As", null ],
        [ "Computing resources: hosts, clusters and peers.", "platform.html#pf_Cr", [
          [ "host", "platform.html#pf_host", null ],
          [ "cluster", "platform.html#pf_cluster", null ],
          [ "peer", "platform.html#pf_peer", null ]
        ] ],
        [ "Network equipments: links and routers", "platform.html#pf_ne", [
          [ "router", "platform.html#pf_router", null ],
          [ "link", "platform.html#pf_link", null ]
        ] ],
        [ "Storage", "platform.html#pf_storage", [
          [ "Storage Main concepts", "platform.html#pf_sto_conc", null ],
          [ "storage_type", "platform.html#pf_sto_sttp", null ],
          [ "storage", "platform.html#pf_sto_st", null ],
          [ "mount", "platform.html#pf_sto_mo", null ],
          [ "mstorage", "platform.html#pf_sto_mst", null ]
        ] ]
      ] ],
      [ "Routing", "platform.html#pf_routing", [
        [ "Routing models", "platform.html#pf_rm", [
          [ "The router affair", "platform.html#pf_raf", null ],
          [ "Shortest-path based models", "platform.html#pf_rm_sh", null ],
          [ "Manually-entered route models", "platform.html#pf_rm_me", null ],
          [ "Simple/fast models", "platform.html#pf_rm_sf", null ]
        ] ],
        [ "Defining routes", "platform.html#ps_dec", [
          [ "link_ctn", "platform.html#pf_linkctn", null ],
          [ "ASroute", "platform.html#pf_asro", null ],
          [ "route", "platform.html#pf_ro", null ],
          [ "bypassRoute", "platform.html#pf_byro", null ]
        ] ],
        [ "Basic Routing Example", "platform.html#pb_baroex", null ]
      ] ],
      [ "Tags not (directly) describing the platform", "platform.html#pf_other_tags", [
        [ "config", "platform.html#pf_conf", null ],
        [ "random", "platform.html#pf_rand", null ],
        [ "include", "platform.html#pf_incl", null ],
        [ "trace and trace_connect", "platform.html#pf_tra", null ]
      ] ],
      [ "Hints and tips, or how to write a platform efficiently", "platform.html#pf_hints", [
        [ "AS Hierarchy", "platform.html#pf_as_h", null ],
        [ "Exit AS: why and how", "platform.html#pf_exit_as", null ],
        [ "P2P or how to use coordinates", "platform.html#pf_P2P_tags", null ],
        [ "Choosing wisely the routing model to use", "platform.html#pf_wisely", null ],
        [ "Hey, I want to describe a switch but there is no switch tag !", "platform.html#pf_switch", null ],
        [ "How to express multipath routing in platform files?", "platform.html#pf_platform_multipath", null ]
      ] ],
      [ "Bypassing the XML parser with your own C functions", "platform.html#pf_flexml_bypassing", null ]
    ] ],
    [ "Deployment Description", "deployment.html", [
      [ "Overview", "deployment.html#dep_over", null ],
      [ "An example", "deployment.html#dep_ex", null ],
      [ "Process", "deployment.html#process_tag", null ]
    ] ],
    [ "Tracing Simulations for Visualization", "tracing.html", [
      [ "How it works", "tracing.html#tracing_tracing_howitworks", null ],
      [ "Enabling using CMake", "tracing.html#tracing_tracing_enabling", null ],
      [ "Tracing categories functions", "tracing.html#instr_category_functions", null ],
      [ "Tracing marks functions", "tracing.html#instr_mark_functions", null ],
      [ "Tracing user variables functions", "tracing.html#instr_uservariables_functions", null ],
      [ "Tracing configuration Options", "tracing.html#tracing_tracing_options", null ],
      [ "Case studies", "tracing.html#tracing_tracing_example_parameters", null ],
      [ "Example of Instrumentation", "tracing.html#tracing_tracing_example", null ],
      [ "Analyzing the SimGrid Traces", "tracing.html#tracing_tracing_analyzing", null ]
    ] ],
    [ "Packet level simulation", "pls.html", [
      [ "Using GTNetS", "pls.html#pls_simgrid_configuration_gtnets", null ],
      [ "Using NS3", "pls.html#pls_simgrid_configuration_ns3", null ]
    ] ],
    [ "Bindings", "bindings.html", [
      [ "Java Binding", "bindings.html#bindings_binding_Java", null ],
      [ "Ruby Binding", "bindings.html#bindings_binding_Ruby", null ],
      [ "Lua Binding", "bindings.html#bindings_binding_lua", [
        [ "What is lua ?", "bindings.html#bindings_binding_lua_about", [
          [ "Why lua ?", "bindings.html#bindings_binding_lua_why", null ],
          [ "How to use lua in Simgrid ?", "bindings.html#bindings_binding_lua_simgrid", null ]
        ] ],
        [ "Master/Slave Example", "bindings.html#bindings_binding_lua_example_master_slave", null ],
        [ "Exchanging Data", "bindings.html#bindings_binding_lua_example_data", null ],
        [ "Bypass XML", "bindings.html#bindings_binding_lua_example_bypass", null ],
        [ "Master/slave Lua application", "bindings.html#MSG_ex_master_slave_lua", [
          [ "Master code", "bindings.html#MSG_ext_ms_master_lua", null ],
          [ "Slave code", "bindings.html#MSG_ext_ms_slave_lua", null ],
          [ "Simulation core", "bindings.html#MSG_ext_ms_core_lua", null ]
        ] ],
        [ "Master/slave Bypass Lua application", "bindings.html#MSG_ex_master_slave_lua_bypass", [
          [ "Master code", "bindings.html#MSG_ext_ms_bp_master_lua", null ],
          [ "Slave code", "bindings.html#MSG_ext_ms_bp_slave_lua", null ],
          [ "Simulation core", "bindings.html#MSG_ext_ms_bp_core_lua", null ]
        ] ]
      ] ]
    ] ],
    [ "Data Structures", "annotated.html", "annotated" ],
    [ "Examples description", "modules.html", "modules" ],
    [ "SimGrid User Guide", "index.html", null ]
  ] ]
];

var NAVTREEINDEX =
[
"annotated.html"
];

var navTreeSubIndices = new Array();

function getData(varName)
{
  var i = varName.lastIndexOf('/');
  var n = i>=0 ? varName.substring(i+1) : varName;
  return eval(n.replace(/\-/g,'_'));
}

function stripPath(uri)
{
  return uri.substring(uri.lastIndexOf('/')+1);
}

function stripPath2(uri)
{
  var i = uri.lastIndexOf('/');
  var s = uri.substring(i+1);
  var m = uri.substring(0,i+1).match(/\/d\w\/d\w\w\/$/);
  return m ? uri.substring(i-6) : s;
}

function localStorageSupported()
{
  return 'localStorage' in window && window['localStorage'] !== null;
}

function storeLink(link)
{
  if (!$("#nav-sync").hasClass('sync') && localStorageSupported()) {
      window.localStorage.setItem('navpath',link);
  }
}

function deleteLink()
{
  if (localStorageSupported()) {
    window.localStorage.setItem('navpath','');
  } 
}

function cachedLink()
{
  if (localStorageSupported()) {
    return window.localStorage.getItem('navpath');
  } else {
    return '';
  }
}

function getScript(scriptName,func,show)
{
  var head = document.getElementsByTagName("head")[0]; 
  var script = document.createElement('script');
  script.id = scriptName;
  script.type = 'text/javascript';
  script.onload = func; 
  script.src = scriptName+'.js'; 
  if ($.browser.msie && $.browser.version<=8) { 
    // script.onload does work with older versions of IE
    script.onreadystatechange = function() {
      if (script.readyState=='complete' || script.readyState=='loaded') { 
        func(); if (show) showRoot(); 
      }
    }
  }
  head.appendChild(script); 
}

function createIndent(o,domNode,node,level)
{
  if (node.parentNode && node.parentNode.parentNode) {
    createIndent(o,domNode,node.parentNode,level+1);
  }
  var imgNode = document.createElement("img");
  imgNode.width = 16;
  imgNode.height = 22;
  if (level==0 && node.childrenData) {
    node.plus_img = imgNode;
    node.expandToggle = document.createElement("a");
    node.expandToggle.href = "javascript:void(0)";
    node.expandToggle.onclick = function() {
      if (node.expanded) {
        $(node.getChildrenUL()).slideUp("fast");
        if (node.isLast) {
          node.plus_img.src = node.relpath+"ftv2plastnode.png";
        } else {
          node.plus_img.src = node.relpath+"ftv2pnode.png";
        }
        node.expanded = false;
      } else {
        expandNode(o, node, false, false);
      }
    }
    node.expandToggle.appendChild(imgNode);
    domNode.appendChild(node.expandToggle);
  } else {
    domNode.appendChild(imgNode);
  }
  if (level==0) {
    if (node.isLast) {
      if (node.childrenData) {
        imgNode.src = node.relpath+"ftv2plastnode.png";
      } else {
        imgNode.src = node.relpath+"ftv2lastnode.png";
        domNode.appendChild(imgNode);
      }
    } else {
      if (node.childrenData) {
        imgNode.src = node.relpath+"ftv2pnode.png";
      } else {
        imgNode.src = node.relpath+"ftv2node.png";
        domNode.appendChild(imgNode);
      }
    }
  } else {
    if (node.isLast) {
      imgNode.src = node.relpath+"ftv2blank.png";
    } else {
      imgNode.src = node.relpath+"ftv2vertline.png";
    }
  }
  imgNode.border = "0";
}

function newNode(o, po, text, link, childrenData, lastNode)
{
  var node = new Object();
  node.children = Array();
  node.childrenData = childrenData;
  node.depth = po.depth + 1;
  node.relpath = po.relpath;
  node.isLast = lastNode;

  node.li = document.createElement("li");
  po.getChildrenUL().appendChild(node.li);
  node.parentNode = po;

  node.itemDiv = document.createElement("div");
  node.itemDiv.className = "item";

  node.labelSpan = document.createElement("span");
  node.labelSpan.className = "label";

  createIndent(o,node.itemDiv,node,0);
  node.itemDiv.appendChild(node.labelSpan);
  node.li.appendChild(node.itemDiv);

  var a = document.createElement("a");
  node.labelSpan.appendChild(a);
  node.label = document.createTextNode(text);
  node.expanded = false;
  a.appendChild(node.label);
  if (link) {
    var url;
    if (link.substring(0,1)=='^') {
      url = link.substring(1);
      link = url;
    } else {
      url = node.relpath+link;
    }
    a.className = stripPath(link.replace('#',':'));
    if (link.indexOf('#')!=-1) {
      var aname = '#'+link.split('#')[1];
      var srcPage = stripPath($(location).attr('pathname'));
      var targetPage = stripPath(link.split('#')[0]);
      a.href = srcPage!=targetPage ? url : '#';
      a.onclick = function(){
        storeLink(link);
        if (!$(a).parent().parent().hasClass('selected'))
        {
          $('.item').removeClass('selected');
          $('.item').removeAttr('id');
          $(a).parent().parent().addClass('selected');
          $(a).parent().parent().attr('id','selected');
        }
        var pos, anchor = $(aname), docContent = $('#doc-content');
        if (anchor.parent().attr('class')=='memItemLeft') {
          pos = anchor.parent().position().top;
        } else if (anchor.position()) {
          pos = anchor.position().top;
        }
        if (pos) {
          var dist = Math.abs(Math.min(
                     pos-docContent.offset().top,
                     docContent[0].scrollHeight-
                     docContent.height()-docContent.scrollTop()));
          docContent.animate({
            scrollTop: pos + docContent.scrollTop() - docContent.offset().top
          },Math.max(50,Math.min(500,dist)),function(){
            window.location.replace(aname);
          });
        }
      };
    } else {
      a.href = url;
      a.onclick = function() { storeLink(link); }
    }
  } else {
    if (childrenData != null) 
    {
      a.className = "nolink";
      a.href = "javascript:void(0)";
      a.onclick = node.expandToggle.onclick;
    }
  }

  node.childrenUL = null;
  node.getChildrenUL = function() {
    if (!node.childrenUL) {
      node.childrenUL = document.createElement("ul");
      node.childrenUL.className = "children_ul";
      node.childrenUL.style.display = "none";
      node.li.appendChild(node.childrenUL);
    }
    return node.childrenUL;
  };

  return node;
}

function showRoot()
{
  var headerHeight = $("#top").height();
  var footerHeight = $("#nav-path").height();
  var windowHeight = $(window).height() - headerHeight - footerHeight;
  (function (){ // retry until we can scroll to the selected item
    try {
      var navtree=$('#nav-tree');
      navtree.scrollTo('#selected',0,{offset:-windowHeight/2});
    } catch (err) {
      setTimeout(arguments.callee, 0);
    }
  })();
}

function expandNode(o, node, imm, showRoot)
{
  if (node.childrenData && !node.expanded) {
    if (typeof(node.childrenData)==='string') {
      var varName    = node.childrenData;
      getScript(node.relpath+varName,function(){
        node.childrenData = getData(varName);
        expandNode(o, node, imm, showRoot);
      }, showRoot);
    } else {
      if (!node.childrenVisited) {
        getNode(o, node);
      } if (imm || ($.browser.msie && $.browser.version>8)) { 
        // somehow slideDown jumps to the start of tree for IE9 :-(
        $(node.getChildrenUL()).show();
      } else {
        $(node.getChildrenUL()).slideDown("fast");
      }
      if (node.isLast) {
        node.plus_img.src = node.relpath+"ftv2mlastnode.png";
      } else {
        node.plus_img.src = node.relpath+"ftv2mnode.png";
      }
      node.expanded = true;
    }
  }
}

function glowEffect(n,duration)
{
  n.addClass('glow').delay(duration).queue(function(next){
    $(this).removeClass('glow');next();
  });
}

function highlightAnchor()
{
  var anchor = $($(location).attr('hash'));
  if (anchor.parent().attr('class')=='memItemLeft'){
    var rows = $('.memberdecls tr[class$="'+
               window.location.hash.substring(1)+'"]');
    glowEffect(rows.children(),300); // member without details
  } else if (anchor.parents().slice(2).prop('tagName')=='TR') {
    glowEffect(anchor.parents('div.memitem'),1000); // enum value
  } else if (anchor.parent().attr('class')=='fieldtype'){
    glowEffect(anchor.parent().parent(),1000); // struct field
  } else if (anchor.parent().is(":header")) {
    glowEffect(anchor.parent(),1000); // section header
  } else {
    glowEffect(anchor.next(),1000); // normal member
  }
}

function selectAndHighlight(hash,n)
{
  var a;
  if (hash) {
    var link=stripPath($(location).attr('pathname'))+':'+hash.substring(1);
    a=$('.item a[class$="'+link+'"]');
  }
  if (a && a.length) {
    a.parent().parent().addClass('selected');
    a.parent().parent().attr('id','selected');
    highlightAnchor();
  } else if (n) {
    $(n.itemDiv).addClass('selected');
    $(n.itemDiv).attr('id','selected');
  }
  showRoot();
}

function showNode(o, node, index, hash)
{
  if (node && node.childrenData) {
    if (typeof(node.childrenData)==='string') {
      var varName    = node.childrenData;
      getScript(node.relpath+varName,function(){
        node.childrenData = getData(varName);
        showNode(o,node,index,hash);
      },true);
    } else {
      if (!node.childrenVisited) {
        getNode(o, node);
      }
      $(node.getChildrenUL()).show();
      if (node.isLast) {
        node.plus_img.src = node.relpath+"ftv2mlastnode.png";
      } else {
        node.plus_img.src = node.relpath+"ftv2mnode.png";
      }
      node.expanded = true;
      var n = node.children[o.breadcrumbs[index]];
      if (index+1<o.breadcrumbs.length) {
        showNode(o,n,index+1,hash);
      } else {
        if (typeof(n.childrenData)==='string') {
          var varName = n.childrenData;
          getScript(n.relpath+varName,function(){
            n.childrenData = getData(varName);
            node.expanded=false;
            showNode(o,node,index,hash); // retry with child node expanded
          },true);
        } else {
          var rootBase = stripPath(o.toroot.replace(/\..+$/, ''));
          if (rootBase=="index" || rootBase=="pages") {
            expandNode(o, n, true, true);
          }
          selectAndHighlight(hash,n);
        }
      }
    }
  } else {
    selectAndHighlight(hash);
  }
}

function getNode(o, po)
{
  po.childrenVisited = true;
  var l = po.childrenData.length-1;
  for (var i in po.childrenData) {
    var nodeData = po.childrenData[i];
    po.children[i] = newNode(o, po, nodeData[0], nodeData[1], nodeData[2],
      i==l);
  }
}

function gotoNode(o,subIndex,root,hash,relpath)
{
  var nti = navTreeSubIndices[subIndex][root+hash];
  o.breadcrumbs = $.extend(true, [], nti ? nti : navTreeSubIndices[subIndex][root]);
  if (!o.breadcrumbs && root!=NAVTREE[0][1]) { // fallback: show index
    navTo(o,NAVTREE[0][1],"",relpath);
    $('.item').removeClass('selected');
    $('.item').removeAttr('id');
  }
  if (o.breadcrumbs) {
    o.breadcrumbs.unshift(0); // add 0 for root node
    showNode(o, o.node, 0, hash);
  }
}

function navTo(o,root,hash,relpath)
{
  var link = cachedLink();
  if (link) {
    var parts = link.split('#');
    root = parts[0];
    if (parts.length>1) hash = '#'+parts[1];
    else hash='';
  }
  if (root==NAVTREE[0][1]) {
    $('#nav-sync').css('top','30px');
  } else {
    $('#nav-sync').css('top','5px');
  }
  if (hash.match(/^#l\d+$/)) {
    var anchor=$('a[name='+hash.substring(1)+']');
    glowEffect(anchor.parent(),1000); // line number
    hash=''; // strip line number anchors
    //root=root.replace(/_source\./,'.'); // source link to doc link
  }
  var url=root+hash;
  var i=-1;
  while (NAVTREEINDEX[i+1]<=url) i++;
  if (navTreeSubIndices[i]) {
    gotoNode(o,i,root,hash,relpath)
  } else {
    getScript(relpath+'navtreeindex'+i,function(){
      navTreeSubIndices[i] = eval('NAVTREEINDEX'+i);
      if (navTreeSubIndices[i]) {
        gotoNode(o,i,root,hash,relpath);
      }
    },true);
  }
}

function toggleSyncButton(relpath)
{
  var navSync = $('#nav-sync');
  if (navSync.hasClass('sync')) {
    navSync.removeClass('sync');
    navSync.html('<img src="'+relpath+'sync_off.png"/>');
    storeLink(stripPath2($(location).attr('pathname'))+$(location).attr('hash'));
  } else {
    navSync.addClass('sync');
    navSync.html('<img src="'+relpath+'sync_on.png"/>');
    deleteLink();
  }
}

function initNavTree(toroot,relpath)
{
  var o = new Object();
  o.toroot = toroot;
  o.node = new Object();
  o.node.li = document.getElementById("nav-tree-contents");
  o.node.childrenData = NAVTREE;
  o.node.children = new Array();
  o.node.childrenUL = document.createElement("ul");
  o.node.getChildrenUL = function() { return o.node.childrenUL; };
  o.node.li.appendChild(o.node.childrenUL);
  o.node.depth = 0;
  o.node.relpath = relpath;
  o.node.expanded = false;
  o.node.isLast = true;
  o.node.plus_img = document.createElement("img");
  o.node.plus_img.src = relpath+"ftv2pnode.png";
  o.node.plus_img.width = 16;
  o.node.plus_img.height = 22;

  if (localStorageSupported()) {
    var navSync = $('#nav-sync');
    if (cachedLink()) {
      navSync.html('<img src="'+relpath+'sync_off.png"/>');
      navSync.removeClass('sync');
    } else {
      navSync.html('<img src="'+relpath+'sync_on.png"/>');
    }
    navSync.click(function(){ toggleSyncButton(relpath); });
  }

  navTo(o,toroot,window.location.hash,relpath);

  $(window).bind('hashchange', function(){
     if (window.location.hash && window.location.hash.length>1){
       var a;
       if ($(location).attr('hash')){
         var clslink=stripPath($(location).attr('pathname'))+':'+
                               $(location).attr('hash').substring(1);
         a=$('.item a[class$="'+clslink+'"]');
       }
       if (a==null || !$(a).parent().parent().hasClass('selected')){
         $('.item').removeClass('selected');
         $('.item').removeAttr('id');
       }
       var link=stripPath2($(location).attr('pathname'));
       navTo(o,link,$(location).attr('hash'),relpath);
     }
  })

  $(window).load(showRoot);
}

