<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>
<tagfile>
  <compound kind="group">
    <name>XBT_API</name>
    <title>XBT</title>
    <filename>group__XBT__API.html</filename>
    <subgroup>XBT_grounding</subgroup>
    <subgroup>XBT_adt</subgroup>
    <subgroup>XBT_misc</subgroup>
  </compound>
  <compound kind="group">
    <name>MSG_API</name>
    <title>MSG</title>
    <filename>group__MSG__API.html</filename>
    <subgroup>msg_simulation</subgroup>
    <subgroup>m_process_management</subgroup>
    <subgroup>m_host_management</subgroup>
    <subgroup>m_task_management</subgroup>
    <subgroup>msg_mailbox_management</subgroup>
    <subgroup>msg_task_usage</subgroup>
    <subgroup>msg_VMs</subgroup>
    <subgroup>msg_file_management</subgroup>
    <subgroup>msg_trace_driven</subgroup>
    <subgroup>MSG_LUA</subgroup>
    <subgroup>msg_deprecated_functions</subgroup>
    <docanchor file="group__MSG__API">MSG_who</docanchor>
    <docanchor file="/tmp/toward_3.8.1/simgrid-git-upstream/doc/ref_guide/doxygen/module-msg.doc">jMSG_who</docanchor>
    <docanchor file="group__MSG__API">MSG_funct</docanchor>
  </compound>
  <compound kind="group">
    <name>SIMIX_API</name>
    <title>SIMIX</title>
    <filename>group__SIMIX__API.html</filename>
    <subgroup>m_datatypes_management_details</subgroup>
    <subgroup>simix_process_management</subgroup>
    <subgroup>simix_host_management</subgroup>
    <subgroup>simix_rdv_management</subgroup>
    <subgroup>simix_comm_management</subgroup>
    <subgroup>simix_synchro_management</subgroup>
    <subgroup>simix_file_management</subgroup>
    <member kind="function">
      <type>void</type>
      <name>SIMIX_global_init</name>
      <anchorfile>group__SIMIX__API.html</anchorfile>
      <anchor>ga61a5c57ccf08e71bac21571b94ec1a38</anchor>
      <arglist>(int *argc, char **argv)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>SIMIX_clean</name>
      <anchorfile>group__SIMIX__API.html</anchorfile>
      <anchor>gaf764507fe3726a890a8657d5db2eaffc</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>SIMIX_get_clock</name>
      <anchorfile>group__SIMIX__API.html</anchorfile>
      <anchor>ga8298a6bf3cdb667f2aca7b1cfd9b2eb8</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>SIMIX_run</name>
      <anchorfile>group__SIMIX__API.html</anchorfile>
      <anchor>gaebdd718ef8f26134756d5fa6de1ff854</anchor>
      <arglist>(void)</arglist>
    </member>
    <docanchor file="group__SIMIX__API">Coming</docanchor>
  </compound>
  <compound kind="group">
    <name>GRAS_API</name>
    <title>GRAS</title>
    <filename>group__GRAS__API.html</filename>
    <subgroup>GRAS_comm</subgroup>
    <subgroup>GRAS_run</subgroup>
    <member kind="function">
      <type>void</type>
      <name>gras_init</name>
      <anchorfile>group__GRAS__API.html</anchorfile>
      <anchor>ga2f7e006b4b7297a5d8979e299ddf9112</anchor>
      <arglist>(int *argc, char **argv)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gras_exit</name>
      <anchorfile>group__GRAS__API.html</anchorfile>
      <anchor>gaee47a46ba8da34d67242a80552252dbe</anchor>
      <arglist>(void)</arglist>
    </member>
    <docanchor file="group__GRAS__API">GRAS_who</docanchor>
    <docanchor file="group__GRAS__API">GRAS_funct</docanchor>
  </compound>
  <compound kind="group">
    <name>AMOK_API</name>
    <title>AMOK</title>
    <filename>group__AMOK__API.html</filename>
    <subgroup>AMOK_bw</subgroup>
    <subgroup>AMOK_pm</subgroup>
  </compound>
  <compound kind="group">
    <name>SMPI_API</name>
    <title>SMPI</title>
    <filename>group__SMPI__API.html</filename>
    <docanchor file="group__SMPI__API">SMPI_who</docanchor>
    <docanchor file="group__SMPI__API">SMPI_what</docanchor>
    <docanchor file="group__SMPI__API">SMPI_adapting</docanchor>
    <docanchor file="group__SMPI__API">SMPI_compiling</docanchor>
    <docanchor file="group__SMPI__API">SMPI_executing</docanchor>
  </compound>
  <compound kind="group">
    <name>SD_API</name>
    <title>SimDag</title>
    <filename>group__SD__API.html</filename>
    <subgroup>SD_datatypes_management</subgroup>
    <subgroup>SD_workstation_management</subgroup>
    <subgroup>SD_link_management</subgroup>
    <subgroup>SD_task_management</subgroup>
    <subgroup>SD_task_dependency_management</subgroup>
    <subgroup>SD_simulation</subgroup>
    <docanchor file="group__SD__API">SD_who</docanchor>
    <docanchor file="group__SD__API">SD_func</docanchor>
  </compound>
  <compound kind="group">
    <name>SURF_API</name>
    <title>SURF</title>
    <filename>group__SURF__API.html</filename>
    <subgroup>SURF_simulation</subgroup>
    <subgroup>SURF_actions</subgroup>
    <subgroup>SURF_resources</subgroup>
    <subgroup>SURF_build_api</subgroup>
    <docanchor file="group__SURF__API">SURF_doc</docanchor>
  </compound>
  <compound kind="group">
    <name>TRACE_API</name>
    <title>TRACE</title>
    <filename>group__TRACE__API.html</filename>
    <subgroup>TRACE_category</subgroup>
    <subgroup>TRACE_mark</subgroup>
    <subgroup>TRACE_user_variables</subgroup>
    <member kind="function">
      <type>int</type>
      <name>TRACE_platform_graph_export_graphviz</name>
      <anchorfile>group__TRACE__API.html</anchorfile>
      <anchor>ga77e1127c6602edd4f233ca62d6de36e0</anchor>
      <arglist>(const char *filename)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dynar_t</type>
      <name>TRACE_get_node_types</name>
      <anchorfile>group__TRACE__API.html</anchorfile>
      <anchor>ga845e0cfbd8042ac70adf394df024e350</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dynar_t</type>
      <name>TRACE_get_edge_types</name>
      <anchorfile>group__TRACE__API.html</anchorfile>
      <anchor>gaf5542d615046120aa8a3526268b9fa7f</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_pause</name>
      <anchorfile>group__TRACE__API.html</anchorfile>
      <anchor>ga61801e88fcc9c8963c3ec77d78522f74</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_resume</name>
      <anchorfile>group__TRACE__API.html</anchorfile>
      <anchor>ga636015c91ac56d3942f83321708d9105</anchor>
      <arglist>(void)</arglist>
    </member>
    <docanchor file="group__TRACE__API">TRACE_doc</docanchor>
  </compound>
  <compound kind="group">
    <name>XBT_grounding</name>
    <title>Grounding features</title>
    <filename>group__XBT__grounding.html</filename>
    <subgroup>XBT_syscall</subgroup>
    <subgroup>XBT_str</subgroup>
    <subgroup>XBT_ex</subgroup>
    <subgroup>XBT_log</subgroup>
    <subgroup>XBT_error</subgroup>
    <subgroup>XBT_config</subgroup>
    <subgroup>XBT_mallocator</subgroup>
  </compound>
  <compound kind="group">
    <name>XBT_adt</name>
    <title>Usual data structures</title>
    <filename>group__XBT__adt.html</filename>
    <subgroup>XBT_dynar</subgroup>
    <subgroup>XBT_dict</subgroup>
    <subgroup>XBT_set</subgroup>
    <subgroup>XBT_fifo</subgroup>
    <subgroup>XBT_swag</subgroup>
    <subgroup>XBT_heap</subgroup>
    <subgroup>XBT_dd</subgroup>
  </compound>
  <compound kind="group">
    <name>XBT_misc</name>
    <title>Misc general purposes library components</title>
    <filename>group__XBT__misc.html</filename>
    <subgroup>XBT_graph</subgroup>
    <subgroup>XBT_parmap</subgroup>
    <subgroup>XBT_peer</subgroup>
    <subgroup>XBT_queue</subgroup>
    <subgroup>XBT_sock</subgroup>
    <subgroup>XBT_synchro</subgroup>
    <subgroup>XBT_thread</subgroup>
    <subgroup>XBT_context</subgroup>
    <subgroup>XBT_replay</subgroup>
  </compound>
  <compound kind="group">
    <name>XBT_syscall</name>
    <title>Malloc and friends</title>
    <filename>group__XBT__syscall.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>xbt_new</name>
      <anchorfile>group__XBT__syscall.html</anchorfile>
      <anchor>ga1d356d21c8a37c3e19de37d5f7896810</anchor>
      <arglist>(type, count)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>xbt_new0</name>
      <anchorfile>group__XBT__syscall.html</anchorfile>
      <anchor>gaaea21518b543392c869f6564c36cdc2b</anchor>
      <arglist>(type, count)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static</type>
      <name>__attribute__</name>
      <anchorfile>group__XBT__syscall.html</anchorfile>
      <anchor>gab6d5dfd5b7461f3942dfdd1eda223237</anchor>
      <arglist>((always_inline)) char *xbt_strdup(const char *s)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_backtrace_display_current</name>
      <anchorfile>group__XBT__syscall.html</anchorfile>
      <anchor>ga36813e215c49af92c8a62dd8286d6421</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_free_ref</name>
      <anchorfile>group__XBT__syscall.html</anchorfile>
      <anchor>gadc6cc4c3185be3635bb1ef2d9528f67a</anchor>
      <arglist>(void *d)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_str</name>
    <title>String related functions</title>
    <filename>group__XBT__str.html</filename>
    <member kind="typedef">
      <type>char *</type>
      <name>xbt_string_t</name>
      <anchorfile>group__XBT__str.html</anchorfile>
      <anchor>ga1537bf8b2602e0aeeb87032803a72389</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_str_rtrim</name>
      <anchorfile>group__XBT__str.html</anchorfile>
      <anchor>ga9d7c43274b5a6339adfc724e2efd0ead</anchor>
      <arglist>(char *s, const char *char_list)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_str_ltrim</name>
      <anchorfile>group__XBT__str.html</anchorfile>
      <anchor>gaeb745f202229799d900aa3a20953186f</anchor>
      <arglist>(char *s, const char *char_list)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_str_trim</name>
      <anchorfile>group__XBT__str.html</anchorfile>
      <anchor>ga5259c70a74df4d63f39e68cc5fe8f1b3</anchor>
      <arglist>(char *s, const char *char_list)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dynar_t</type>
      <name>xbt_str_split</name>
      <anchorfile>group__XBT__str.html</anchorfile>
      <anchor>ga91672ded3b13340f1dfa6fb5ce64fb42</anchor>
      <arglist>(const char *s, const char *sep)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dynar_t</type>
      <name>xbt_str_split_quoted</name>
      <anchorfile>group__XBT__str.html</anchorfile>
      <anchor>gaa6839f81f1789acf3865eeade8c23c77</anchor>
      <arglist>(const char *s)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dynar_t</type>
      <name>xbt_str_split_quoted_in_place</name>
      <anchorfile>group__XBT__str.html</anchorfile>
      <anchor>ga2454f448cda4a1ba94409196a2f31d78</anchor>
      <arglist>(char *s)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dynar_t</type>
      <name>xbt_str_split_str</name>
      <anchorfile>group__XBT__str.html</anchorfile>
      <anchor>ga84523a36aef41594015c8c2a22256385</anchor>
      <arglist>(const char *s, const char *sep)</arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>xbt_str_join</name>
      <anchorfile>group__XBT__str.html</anchorfile>
      <anchor>ga1271575a77363ce72fbdf65298a49622</anchor>
      <arglist>(xbt_dynar_t dynar, const char *sep)</arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>xbt_str_join_array</name>
      <anchorfile>group__XBT__str.html</anchorfile>
      <anchor>ga17585fd9f6432df9f84db21059486900</anchor>
      <arglist>(const char *const *strs, const char *sep)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_str_subst</name>
      <anchorfile>group__XBT__str.html</anchorfile>
      <anchor>ga2aaaa9b7cdc3e30d0a2b85c7561ad0e6</anchor>
      <arglist>(char *str, char from, char to, int amount)</arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>xbt_str_varsubst</name>
      <anchorfile>group__XBT__str.html</anchorfile>
      <anchor>ga42a82b549ada759cfc7ec4e0999dde1e</anchor>
      <arglist>(const char *str, xbt_dict_t patterns)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_str_strip_spaces</name>
      <anchorfile>group__XBT__str.html</anchorfile>
      <anchor>ga5b8c3f04c5bd47a54c6700c634c48d40</anchor>
      <arglist>(char *)</arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>xbt_str_diff</name>
      <anchorfile>group__XBT__str.html</anchorfile>
      <anchor>gadfd8938aaade2e991b8b51bed5aea886</anchor>
      <arglist>(const char *a, const char *b)</arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>xbt_str_from_file</name>
      <anchorfile>group__XBT__str.html</anchorfile>
      <anchor>ga3d0726833fdc157351600358cc67097c</anchor>
      <arglist>(FILE *file)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static unsigned int</type>
      <name>xbt_str_hash_ext</name>
      <anchorfile>group__XBT__str.html</anchorfile>
      <anchor>ga10c19e31b7f944a5f426a7d436a44e6d</anchor>
      <arglist>(const char *str, int str_len)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static unsigned int</type>
      <name>xbt_str_hash</name>
      <anchorfile>group__XBT__str.html</anchorfile>
      <anchor>ga7b484f038534879efb07619091341977</anchor>
      <arglist>(const char *str)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_ex</name>
    <title>Exception support</title>
    <filename>group__XBT__ex.html</filename>
    <class kind="struct">xbt_ex_t</class>
    <member kind="define">
      <type>#define</type>
      <name>TRY</name>
      <anchorfile>group__XBT__ex.html</anchorfile>
      <anchor>gad2746371528bdf15c3910b7bf217dac0</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>TRY_CLEANUP</name>
      <anchorfile>group__XBT__ex.html</anchorfile>
      <anchor>ga24540d57ce6a4e72e2c2150327972fc6</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>CATCH</name>
      <anchorfile>group__XBT__ex.html</anchorfile>
      <anchor>gab3271e393133e395129cc74272f9fae2</anchor>
      <arglist>(e)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>CATCH_ANONYMOUS</name>
      <anchorfile>group__XBT__ex.html</anchorfile>
      <anchor>ga070f91546c08b1e31c1d7184c3c9b345</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>THROW_PREPARE</name>
      <anchorfile>group__XBT__ex.html</anchorfile>
      <anchor>ga26394bf7f63640059e73dc55b5911a9b</anchor>
      <arglist>(_throw_ctx, c, v, m)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>THROW</name>
      <anchorfile>group__XBT__ex.html</anchorfile>
      <anchor>gae18641b6be3a88a74eb003978399fe90</anchor>
      <arglist>(c, v)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>THROWF</name>
      <anchorfile>group__XBT__ex.html</anchorfile>
      <anchor>gaf104c05a68884bf85630ef40ca8ae774</anchor>
      <arglist>(c, v,...)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>RETHROW</name>
      <anchorfile>group__XBT__ex.html</anchorfile>
      <anchor>ga241d764fad0bff69d31c12b3066c276c</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>RETHROWF</name>
      <anchorfile>group__XBT__ex.html</anchorfile>
      <anchor>ga4826ac71c1c4d2ec13eeac8320898dc9</anchor>
      <arglist>(...)</arglist>
    </member>
    <member kind="enumeration">
      <name>xbt_errcat_t</name>
      <anchorfile>group__XBT__ex.html</anchorfile>
      <anchor>gaa45fec59aa57056784554a7f998f0854</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>unknown_error</name>
      <anchorfile>group__XBT__ex.html</anchorfile>
      <anchor>ggaa45fec59aa57056784554a7f998f0854a38ca7f2d055a68295cbd837470325f46</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>arg_error</name>
      <anchorfile>group__XBT__ex.html</anchorfile>
      <anchor>ggaa45fec59aa57056784554a7f998f0854a1d6d5b33334f960325a65e5c021aca16</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>bound_error</name>
      <anchorfile>group__XBT__ex.html</anchorfile>
      <anchor>ggaa45fec59aa57056784554a7f998f0854ae2954a4c5a79d65f9f68675fea93376b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>mismatch_error</name>
      <anchorfile>group__XBT__ex.html</anchorfile>
      <anchor>ggaa45fec59aa57056784554a7f998f0854aad84e78423b0ba9b3df634f564a38586</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>not_found_error</name>
      <anchorfile>group__XBT__ex.html</anchorfile>
      <anchor>ggaa45fec59aa57056784554a7f998f0854a2a966e9e887d3ab79628272781200439</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>system_error</name>
      <anchorfile>group__XBT__ex.html</anchorfile>
      <anchor>ggaa45fec59aa57056784554a7f998f0854a0cc55923f6bdf388d75ac17681055815</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>network_error</name>
      <anchorfile>group__XBT__ex.html</anchorfile>
      <anchor>ggaa45fec59aa57056784554a7f998f0854afa15abb01e5f46363458529588f0d871</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>timeout_error</name>
      <anchorfile>group__XBT__ex.html</anchorfile>
      <anchor>ggaa45fec59aa57056784554a7f998f0854acbb4310f650e6fddbbad783293eff676</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>cancel_error</name>
      <anchorfile>group__XBT__ex.html</anchorfile>
      <anchor>ggaa45fec59aa57056784554a7f998f0854a78725e8318a373565146a9c29698eb30</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>thread_error</name>
      <anchorfile>group__XBT__ex.html</anchorfile>
      <anchor>ggaa45fec59aa57056784554a7f998f0854a2d90a8bed8343426b9732511aa2cb34c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>host_error</name>
      <anchorfile>group__XBT__ex.html</anchorfile>
      <anchor>ggaa45fec59aa57056784554a7f998f0854a1486a4899ea0336633c33a77c636eea8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>tracing_error</name>
      <anchorfile>group__XBT__ex.html</anchorfile>
      <anchor>ggaa45fec59aa57056784554a7f998f0854a288db5d5a882653cc5466f62369ab676</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>io_error</name>
      <anchorfile>group__XBT__ex.html</anchorfile>
      <anchor>ggaa45fec59aa57056784554a7f998f0854a7867239bb18a1f74d007fd1cc5f2202c</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>xbt_ex_catname</name>
      <anchorfile>group__XBT__ex.html</anchorfile>
      <anchor>gad584839e617fbfe728225fc7bcfcda9f</anchor>
      <arglist>(xbt_errcat_t cat)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_ex_free</name>
      <anchorfile>group__XBT__ex.html</anchorfile>
      <anchor>ga9a7c9f33be5ab51ff734142b07178553</anchor>
      <arglist>(xbt_ex_t e)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_backtrace_display_current</name>
      <anchorfile>group__XBT__ex.html</anchorfile>
      <anchor>ga36813e215c49af92c8a62dd8286d6421</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>xbt_backtrace_no_malloc</name>
      <anchorfile>group__XBT__ex.html</anchorfile>
      <anchor>gadb6f0cc90ede2c80fff99a2f3a8ea02f</anchor>
      <arglist>(void **bt, int size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_backtrace_current</name>
      <anchorfile>group__XBT__ex.html</anchorfile>
      <anchor>ga3f9f1d5af6de5e90e5501e105b0e593c</anchor>
      <arglist>(xbt_ex_t *e)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_backtrace_display</name>
      <anchorfile>group__XBT__ex.html</anchorfile>
      <anchor>gaea1e39d44bcaaebb91a34f6ef053c60c</anchor>
      <arglist>(xbt_ex_t *e)</arglist>
    </member>
    <docanchor file="group__XBT__ex">XBT_ex_toc</docanchor>
    <docanchor file="group__XBT__ex">XBT_ex_intro</docanchor>
    <docanchor file="group__XBT__ex">XBT_ex_base</docanchor>
    <docanchor file="group__XBT__ex">XBT_ex_pitfalls</docanchor>
  </compound>
  <compound kind="group">
    <name>XBT_log</name>
    <title>Logging support</title>
    <filename>group__XBT__log.html</filename>
    <subgroup>XBT_log_cats</subgroup>
    <member kind="define">
      <type>#define</type>
      <name>XBT_LOG_STATIC_THRESHOLD</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>ga78721bb3ac4ce5dcddb5b102d03ec9ad</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>XBT_LOG_NEW_SUBCATEGORY</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>ga1cd0df7ea8110bd27c2843812f4c93ee</anchor>
      <arglist>(catName, parent, desc)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>XBT_LOG_NEW_CATEGORY</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>ga9e4d4fda6d921febf75e85f9cd9d611a</anchor>
      <arglist>(catName, desc)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>XBT_LOG_DEFAULT_CATEGORY</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>gaa23cb30f6de5c9e0a26a6516817c7e20</anchor>
      <arglist>(cname)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>XBT_LOG_NEW_DEFAULT_CATEGORY</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>ga5094a0e812d0012e6ee4d2257b1a13f1</anchor>
      <arglist>(cname, desc)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>XBT_LOG_NEW_DEFAULT_SUBCATEGORY</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>ga8a4327fc994afcfb2eaebea0c4d1b00a</anchor>
      <arglist>(cname, parent, desc)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>XBT_LOG_EXTERNAL_CATEGORY</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>ga7db05649e5c3c7aba06909409e470143</anchor>
      <arglist>(cname)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>XBT_LOG_EXTERNAL_DEFAULT_CATEGORY</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>ga28625f3f3aa5986954a2b90f029c2e96</anchor>
      <arglist>(cname)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>XBT_LOG_ISENABLED</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>ga6c9d37281690342c607e30b1f0b59aed</anchor>
      <arglist>(catName, priority)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>XBT_CDEBUG</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>ga08edef341742c903623742c6e05d54ee</anchor>
      <arglist>(c,...)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>XBT_CVERB</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>ga2c0bed18aac8cf41d8f3480513f564bc</anchor>
      <arglist>(c,...)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>XBT_CINFO</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>gac2f65621104f3bcff51738a12d5c2921</anchor>
      <arglist>(c,...)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>XBT_CWARN</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>ga2c14b44f6b1abbf73104d17727315e3b</anchor>
      <arglist>(c,...)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>XBT_CERROR</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>ga0cd5463eb5b259b005b5c3f87db1709a</anchor>
      <arglist>(c,...)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>XBT_CCRITICAL</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>ga4b5b9ad4a5086e2e9bd2ee47b3c03c9c</anchor>
      <arglist>(c,...)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>XBT_DEBUG</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>gaec7da836fa1482fcda89227dfb1284d9</anchor>
      <arglist>(...)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>XBT_VERB</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>gab9815968eb142e81c5e661ececb1f0f3</anchor>
      <arglist>(...)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>XBT_INFO</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>ga57f4469c36aeb5f44b5786882b364af8</anchor>
      <arglist>(...)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>XBT_WARN</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>ga6accdad9dccecd8d220a479ea0202827</anchor>
      <arglist>(...)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>XBT_ERROR</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>ga46c64033e6f2d9f309f498bbb2c475f5</anchor>
      <arglist>(...)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>XBT_CRITICAL</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>gadb4c7510140f9e4437be797baf5122a2</anchor>
      <arglist>(...)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>XBT_IN</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>ga20e7ed6a7dd096897446901c39e1194f</anchor>
      <arglist>(...)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>XBT_OUT</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>gaec5266e036c60029988444fcfdb91e6c</anchor>
      <arglist>(...)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>XBT_HERE</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>gaed62d764d379720d6ce03d2a0d9c3c32</anchor>
      <arglist>(...)</arglist>
    </member>
    <member kind="enumeration">
      <name>e_xbt_log_priority_t</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>ga01ff08eb23b4f14bb759c676bcf8df82</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>xbt_log_priority_trace</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>gga01ff08eb23b4f14bb759c676bcf8df82a1b9b706830e4aa1405157d20117aa5cd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>xbt_log_priority_debug</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>gga01ff08eb23b4f14bb759c676bcf8df82aac8ecdd32b640581940959e6f9ed1588</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>xbt_log_priority_verbose</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>gga01ff08eb23b4f14bb759c676bcf8df82afef8e3f2e237f8de9c839a2f5c875fc7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>xbt_log_priority_info</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>gga01ff08eb23b4f14bb759c676bcf8df82af28091fa16fda657d0768baaab6f4c27</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>xbt_log_priority_warning</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>gga01ff08eb23b4f14bb759c676bcf8df82ac87b95b266f551288e8d9faec534baa9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>xbt_log_priority_error</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>gga01ff08eb23b4f14bb759c676bcf8df82a32afa42aab40395dbabb07cafbf84eb5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>xbt_log_priority_critical</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>gga01ff08eb23b4f14bb759c676bcf8df82a8bd5d340adeae3a8e5a3182912c230f3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>xbt_log_priority_infinite</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>gga01ff08eb23b4f14bb759c676bcf8df82a875884ddb873e6613178c5b3c71b8a77</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_log_control_set</name>
      <anchorfile>group__XBT__log.html</anchorfile>
      <anchor>ga2289997893363b1ad5f7ff32cbfbf432</anchor>
      <arglist>(const char *control_string)</arglist>
    </member>
    <docanchor file="group__XBT__log">XBT_log_toc</docanchor>
    <docanchor file="group__XBT__log">log_overview</docanchor>
    <docanchor file="group__XBT__log">log_cat</docanchor>
    <docanchor file="group__XBT__log">log_pri</docanchor>
    <docanchor file="group__XBT__log">log_app</docanchor>
    <docanchor file="group__XBT__log">log_lay</docanchor>
    <docanchor file="group__XBT__log">log_hist</docanchor>
    <docanchor file="group__XBT__log">log_API</docanchor>
    <docanchor file="group__XBT__log">log_API_cat</docanchor>
    <docanchor file="group__XBT__log">log_API_pri</docanchor>
    <docanchor file="group__XBT__log">log_API_isenabled</docanchor>
    <docanchor file="group__XBT__log">log_API_subcat</docanchor>
    <docanchor file="group__XBT__log">log_API_easy</docanchor>
    <docanchor file="group__XBT__log">log_API_example</docanchor>
    <docanchor file="group__XBT__log">log_user</docanchor>
    <docanchor file="group__XBT__log">log_use_conf</docanchor>
    <docanchor file="group__XBT__log">log_use_conf_thres</docanchor>
    <docanchor file="group__XBT__log">log_use_conf_multi</docanchor>
    <docanchor file="group__XBT__log">log_use_conf_fmt</docanchor>
    <docanchor file="group__XBT__log">log_use_conf_app</docanchor>
    <docanchor file="group__XBT__log">log_use_conf_add</docanchor>
    <docanchor file="group__XBT__log">log_use_misc</docanchor>
    <docanchor file="group__XBT__log">log_internals</docanchor>
    <docanchor file="group__XBT__log">log_in_perf</docanchor>
    <docanchor file="group__XBT__log">log_in_app</docanchor>
  </compound>
  <compound kind="group">
    <name>XBT_error</name>
    <title>Assert macro familly</title>
    <filename>group__XBT__error.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>xbt_assert</name>
      <anchorfile>group__XBT__error.html</anchorfile>
      <anchor>gadd837b8bf67480aea409a8580072f0be</anchor>
      <arglist>(...)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>xbt_abort</name>
      <anchorfile>group__XBT__error.html</anchorfile>
      <anchor>gaca8531c4c752e94c638c030c80528021</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>xbt_die</name>
      <anchorfile>group__XBT__error.html</anchorfile>
      <anchor>ga9bf4916de59dbf2c5bc790e85df7c189</anchor>
      <arglist>(...)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_config</name>
    <title>Configuration support</title>
    <filename>group__XBT__config.html</filename>
    <subgroup>XBT_cfg_use</subgroup>
    <subgroup>XBT_cfg_decl</subgroup>
    <subgroup>XBT_cfg_register</subgroup>
    <subgroup>XBT_cfg_get</subgroup>
    <docanchor file="group__XBT__config">XBT_cfg_ex</docanchor>
  </compound>
  <compound kind="group">
    <name>XBT_mallocator</name>
    <title>Mallocators</title>
    <filename>group__XBT__mallocator.html</filename>
    <subgroup>XBT_mallocator_cons</subgroup>
    <subgroup>XBT_mallocator_objects</subgroup>
  </compound>
  <compound kind="group">
    <name>XBT_dynar</name>
    <title>Dynar: generic dynamic array</title>
    <filename>group__XBT__dynar.html</filename>
    <subgroup>XBT_dynar_cons</subgroup>
    <subgroup>XBT_dynar_array</subgroup>
    <subgroup>XBT_dynar_misc</subgroup>
    <subgroup>XBT_dynar_perl</subgroup>
    <subgroup>XBT_dynar_ctn</subgroup>
    <subgroup>XBT_dynar_speed</subgroup>
    <subgroup>XBT_dynar_cursor</subgroup>
    <docanchor file="group__XBT__dynar">XBT_dynar_exscal</docanchor>
    <docanchor file="group__XBT__dynar">XBT_dynar_exptr</docanchor>
  </compound>
  <compound kind="group">
    <name>XBT_dict</name>
    <title>Dict: generic dictionnary</title>
    <filename>group__XBT__dict.html</filename>
    <subgroup>XBT_dict_cons</subgroup>
    <subgroup>XBT_dict_basic</subgroup>
    <subgroup>XBT_dict_nnul</subgroup>
    <subgroup>XBT_dict_curs</subgroup>
  </compound>
  <compound kind="group">
    <name>XBT_set</name>
    <title>Set: generic set datatype</title>
    <filename>group__XBT__set.html</filename>
    <subgroup>XBT_set_cons</subgroup>
    <subgroup>XBT_set_basic</subgroup>
    <subgroup>XBT_set_curs</subgroup>
  </compound>
  <compound kind="group">
    <name>XBT_fifo</name>
    <title>Fifo: generic workqueue</title>
    <filename>group__XBT__fifo.html</filename>
    <subgroup>XBT_fifo_cons</subgroup>
    <subgroup>XBT_fifo_perl</subgroup>
    <subgroup>XBT_fifo_direct</subgroup>
    <subgroup>XBT_fifo_misc</subgroup>
  </compound>
  <compound kind="group">
    <name>XBT_swag</name>
    <title>Swag: O(1) set datatype</title>
    <filename>group__XBT__swag.html</filename>
    <subgroup>XBT_swag_type</subgroup>
    <subgroup>XBT_swag_func</subgroup>
    <subgroup>XBT_swag_curs</subgroup>
  </compound>
  <compound kind="group">
    <name>XBT_heap</name>
    <title>Heap: generic heap data structure</title>
    <filename>group__XBT__heap.html</filename>
    <member kind="function">
      <type>xbt_heap_t</type>
      <name>xbt_heap_new</name>
      <anchorfile>group__XBT__heap.html</anchorfile>
      <anchor>gaa4b5f8cfee32bb2df3cb2b5d6649b114</anchor>
      <arglist>(int init_size, void_f_pvoid_t const free_func)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_heap_free</name>
      <anchorfile>group__XBT__heap.html</anchorfile>
      <anchor>gace5e6cc225d3698de6af159229c94587</anchor>
      <arglist>(xbt_heap_t H)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>xbt_heap_size</name>
      <anchorfile>group__XBT__heap.html</anchorfile>
      <anchor>ga21ef0cccfab2e937012f1286cc3ecb66</anchor>
      <arglist>(xbt_heap_t H)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_heap_push</name>
      <anchorfile>group__XBT__heap.html</anchorfile>
      <anchor>ga5e44b85be2d2ba1d7ed9d400546f43dd</anchor>
      <arglist>(xbt_heap_t H, void *content, double key)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>xbt_heap_pop</name>
      <anchorfile>group__XBT__heap.html</anchorfile>
      <anchor>ga61f5e2665882b14b15a48bf66e9631a4</anchor>
      <arglist>(xbt_heap_t H)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>xbt_heap_maxkey</name>
      <anchorfile>group__XBT__heap.html</anchorfile>
      <anchor>gaecf9ff064287ee533e166d631aced6df</anchor>
      <arglist>(xbt_heap_t H)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>xbt_heap_maxcontent</name>
      <anchorfile>group__XBT__heap.html</anchorfile>
      <anchor>ga804cb0f43208ddf228b515ec14f13965</anchor>
      <arglist>(xbt_heap_t H)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_heap_set_update_callback</name>
      <anchorfile>group__XBT__heap.html</anchorfile>
      <anchor>ga0617a1f1c3f63f951f17698e783bc24d</anchor>
      <arglist>(xbt_heap_t H, void(*update_callback)(void *, int))</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>xbt_heap_remove</name>
      <anchorfile>group__XBT__heap.html</anchorfile>
      <anchor>ga2035074b0de4d7a74fc5f9a22c148437</anchor>
      <arglist>(xbt_heap_t H, int i)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_dd</name>
    <title>Data description</title>
    <filename>group__XBT__dd.html</filename>
    <subgroup>XBT_dd_basic</subgroup>
    <subgroup>XBT_dd_auto</subgroup>
    <subgroup>XBT_dd_manual</subgroup>
    <subgroup>XBT_dd_cb_simple</subgroup>
    <subgroup>XBT_dd_cb_full</subgroup>
  </compound>
  <compound kind="group">
    <name>XBT_graph</name>
    <title>General purpose graph library</title>
    <filename>group__XBT__graph.html</filename>
    <member kind="function">
      <type>xbt_graph_t</type>
      <name>xbt_graph_new_graph</name>
      <anchorfile>group__XBT__graph.html</anchorfile>
      <anchor>ga782dba2130eee76b8bd4e6934098fd8f</anchor>
      <arglist>(unsigned short int directed, void *data)</arglist>
    </member>
    <member kind="function">
      <type>xbt_node_t</type>
      <name>xbt_graph_new_node</name>
      <anchorfile>group__XBT__graph.html</anchorfile>
      <anchor>ga95d8d120c9be3efbed1880700458d8ca</anchor>
      <arglist>(xbt_graph_t g, void *data)</arglist>
    </member>
    <member kind="function">
      <type>xbt_edge_t</type>
      <name>xbt_graph_new_edge</name>
      <anchorfile>group__XBT__graph.html</anchorfile>
      <anchor>gaec90776579173b58de9b89868abbda0f</anchor>
      <arglist>(xbt_graph_t g, xbt_node_t src, xbt_node_t dst, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>xbt_graph_node_get_data</name>
      <anchorfile>group__XBT__graph.html</anchorfile>
      <anchor>gaed845d52f5432f7940e1bceb336d3c38</anchor>
      <arglist>(xbt_node_t node)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_graph_node_set_data</name>
      <anchorfile>group__XBT__graph.html</anchorfile>
      <anchor>gaa100e0fe6d317aa185dffe89b3a9deae</anchor>
      <arglist>(xbt_node_t node, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>xbt_graph_edge_get_data</name>
      <anchorfile>group__XBT__graph.html</anchorfile>
      <anchor>ga7105c211e327da8f90b432224451cfb3</anchor>
      <arglist>(xbt_edge_t edge)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_graph_edge_set_data</name>
      <anchorfile>group__XBT__graph.html</anchorfile>
      <anchor>ga9cbe4fe591cf0d6746909db9ae2cd2aa</anchor>
      <arglist>(xbt_edge_t edge, void *data)</arglist>
    </member>
    <member kind="function">
      <type>xbt_edge_t</type>
      <name>xbt_graph_get_edge</name>
      <anchorfile>group__XBT__graph.html</anchorfile>
      <anchor>ga4a037e91f75ccee400b51b5564720693</anchor>
      <arglist>(xbt_graph_t g, xbt_node_t src, xbt_node_t dst)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_graph_edge_set_length</name>
      <anchorfile>group__XBT__graph.html</anchorfile>
      <anchor>ga68339a976c82e67edf79fa59d4619396</anchor>
      <arglist>(xbt_edge_t e, double length)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>xbt_graph_edge_get_length</name>
      <anchorfile>group__XBT__graph.html</anchorfile>
      <anchor>gac906c4328b3d910457c960cd64d70784</anchor>
      <arglist>(xbt_edge_t e)</arglist>
    </member>
    <member kind="function">
      <type>double *</type>
      <name>xbt_graph_get_length_matrix</name>
      <anchorfile>group__XBT__graph.html</anchorfile>
      <anchor>ga3c4697edd9ee89142ec85ed882aad249</anchor>
      <arglist>(xbt_graph_t g)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_graph_free_node</name>
      <anchorfile>group__XBT__graph.html</anchorfile>
      <anchor>ga966d2089b5392e5f556a6d149bdc112c</anchor>
      <arglist>(xbt_graph_t g, xbt_node_t n, void_f_pvoid_t node_free_function, void_f_pvoid_t edge_free_function)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_graph_free_edge</name>
      <anchorfile>group__XBT__graph.html</anchorfile>
      <anchor>ga6b9895d6065b7e122bc55c71e32da821</anchor>
      <arglist>(xbt_graph_t g, xbt_edge_t e, void_f_pvoid_t free_function)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_graph_free_graph</name>
      <anchorfile>group__XBT__graph.html</anchorfile>
      <anchor>gad290d4c3fa3f0c82f7f6cc18a3506546</anchor>
      <arglist>(xbt_graph_t g, void_f_pvoid_t node_free_function, void_f_pvoid_t edge_free_function, void_f_pvoid_t graph_free_function)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dynar_t</type>
      <name>xbt_graph_get_nodes</name>
      <anchorfile>group__XBT__graph.html</anchorfile>
      <anchor>gada4b1109afba1fe3a8f046a45694c707</anchor>
      <arglist>(xbt_graph_t g)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dynar_t</type>
      <name>xbt_graph_get_edges</name>
      <anchorfile>group__XBT__graph.html</anchorfile>
      <anchor>ga1c292fb71d5119d59496a89d90a8ba30</anchor>
      <arglist>(xbt_graph_t g)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dynar_t</type>
      <name>xbt_graph_node_get_outedges</name>
      <anchorfile>group__XBT__graph.html</anchorfile>
      <anchor>gac8dd5691103f6c69b8f773a5937c2a8a</anchor>
      <arglist>(xbt_node_t n)</arglist>
    </member>
    <member kind="function">
      <type>xbt_node_t</type>
      <name>xbt_graph_edge_get_source</name>
      <anchorfile>group__XBT__graph.html</anchorfile>
      <anchor>ga8946bd8838820677e2e44e793be2c9e6</anchor>
      <arglist>(xbt_edge_t e)</arglist>
    </member>
    <member kind="function">
      <type>xbt_node_t</type>
      <name>xbt_graph_edge_get_target</name>
      <anchorfile>group__XBT__graph.html</anchorfile>
      <anchor>ga137cf4ffadf401a1080795664d99834a</anchor>
      <arglist>(xbt_edge_t e)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_graph_export_graphviz</name>
      <anchorfile>group__XBT__graph.html</anchorfile>
      <anchor>gacbbb619bcd7032ba6c0f8e932126d26b</anchor>
      <arglist>(xbt_graph_t g, const char *filename, const char *(node_name)(xbt_node_t), const char *(edge_name)(xbt_edge_t))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_graph_export_graphxml</name>
      <anchorfile>group__XBT__graph.html</anchorfile>
      <anchor>ga59db9ffe13c1c4e4012e61fe38525363</anchor>
      <arglist>(xbt_graph_t g, const char *filename, const char *(node_name)(xbt_node_t), const char *(edge_name)(xbt_edge_t), const char *(node_data_print)(void *), const char *(edge_data_print)(void *))</arglist>
    </member>
    <member kind="function">
      <type>xbt_graph_t</type>
      <name>xbt_graph_load</name>
      <anchorfile>group__XBT__graph.html</anchorfile>
      <anchor>ga11cca6af16cef8e4ea7f5f340da517dd</anchor>
      <arglist>(const char *filename)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_graph_save</name>
      <anchorfile>group__XBT__graph.html</anchorfile>
      <anchor>ga2b6d7cfdc45b1df905eba88fdc1d8c18</anchor>
      <arglist>(xbt_graph_t span, const char *filename, const char *(nname)(xbt_node_t), const char *(ename)(xbt_edge_t))</arglist>
    </member>
    <member kind="function">
      <type>xbt_node_t *</type>
      <name>xbt_graph_shortest_paths</name>
      <anchorfile>group__XBT__graph.html</anchorfile>
      <anchor>gaa5d7e658935aa26a17acaa1cdcd575a4</anchor>
      <arglist>(xbt_graph_t g)</arglist>
    </member>
    <member kind="function">
      <type>xbt_node_t *</type>
      <name>xbt_graph_topo_sort</name>
      <anchorfile>group__XBT__graph.html</anchorfile>
      <anchor>ga80c9aa63aac343d7b3ba246a6e4f6297</anchor>
      <arglist>(xbt_graph_t g)</arglist>
    </member>
    <member kind="function">
      <type>xbt_edge_t *</type>
      <name>xbt_graph_spanning_tree_prim</name>
      <anchorfile>group__XBT__graph.html</anchorfile>
      <anchor>gac305eb0dfe08abbe849f2a74dfa3a3a4</anchor>
      <arglist>(xbt_graph_t g)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_parmap</name>
    <title>Parallel map</title>
    <filename>group__XBT__parmap.html</filename>
    <member kind="typedef">
      <type>struct s_xbt_parmap *</type>
      <name>xbt_parmap_t</name>
      <anchorfile>group__XBT__parmap.html</anchorfile>
      <anchor>gaebe875868080812c5e303884551ced62</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>e_xbt_parmap_mode_t</name>
      <anchorfile>group__XBT__parmap.html</anchorfile>
      <anchor>gacbdbf85f704718b8680f13e56c618e7a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>XBT_PARMAP_POSIX</name>
      <anchorfile>group__XBT__parmap.html</anchorfile>
      <anchor>ggacbdbf85f704718b8680f13e56c618e7aaa076c8a9592fd4f8656a078483688700</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>XBT_PARMAP_FUTEX</name>
      <anchorfile>group__XBT__parmap.html</anchorfile>
      <anchor>ggacbdbf85f704718b8680f13e56c618e7aaec7bc115136c58098a826d86296d2f7d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>XBT_PARMAP_BUSY_WAIT</name>
      <anchorfile>group__XBT__parmap.html</anchorfile>
      <anchor>ggacbdbf85f704718b8680f13e56c618e7aafd6884f2f0271777d1e8ea1db1b29229</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>XBT_PARMAP_DEFAULT</name>
      <anchorfile>group__XBT__parmap.html</anchorfile>
      <anchor>ggacbdbf85f704718b8680f13e56c618e7aa0329f52f37cdb070e8d64330c7a1b395</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>xbt_parmap_t</type>
      <name>xbt_parmap_new</name>
      <anchorfile>group__XBT__parmap.html</anchorfile>
      <anchor>ga939a0ab549af87ff1df13642396d5087</anchor>
      <arglist>(unsigned int num_workers, e_xbt_parmap_mode_t mode)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_parmap_destroy</name>
      <anchorfile>group__XBT__parmap.html</anchorfile>
      <anchor>ga3e1c75bd9e1a502350a2d2098dc316bb</anchor>
      <arglist>(xbt_parmap_t parmap)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_parmap_apply</name>
      <anchorfile>group__XBT__parmap.html</anchorfile>
      <anchor>ga7d2b99167edbcbccb7a514451042f09f</anchor>
      <arglist>(xbt_parmap_t parmap, void_f_pvoid_t fun, xbt_dynar_t data)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>xbt_parmap_next</name>
      <anchorfile>group__XBT__parmap.html</anchorfile>
      <anchor>gac667744f002bbf8d1d8dc32e36d0d308</anchor>
      <arglist>(xbt_parmap_t parmap)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_peer</name>
    <title>Peer</title>
    <filename>group__XBT__peer.html</filename>
    <class kind="struct">s_xbt_peer</class>
    <member kind="typedef">
      <type>struct s_xbt_peer *</type>
      <name>xbt_peer_t</name>
      <anchorfile>group__XBT__peer.html</anchorfile>
      <anchor>gad2304165af1ed80fe6d82eb14343eca7</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct s_xbt_peer</type>
      <name>s_xbt_peer_t</name>
      <anchorfile>group__XBT__peer.html</anchorfile>
      <anchor>ga6d62b8bce4ac8f6206f66f8dd34d2532</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>xbt_peer_t</type>
      <name>xbt_peer_new</name>
      <anchorfile>group__XBT__peer.html</anchorfile>
      <anchor>ga2d87fccb2ac0c6f71db29ed857b01eb2</anchor>
      <arglist>(const char *name, int port)</arglist>
    </member>
    <member kind="function">
      <type>xbt_peer_t</type>
      <name>xbt_peer_from_string</name>
      <anchorfile>group__XBT__peer.html</anchorfile>
      <anchor>ga0d8d75aed70cb99a925b8974ce8ce4e4</anchor>
      <arglist>(const char *peerport)</arglist>
    </member>
    <member kind="function">
      <type>xbt_peer_t</type>
      <name>xbt_peer_copy</name>
      <anchorfile>group__XBT__peer.html</anchorfile>
      <anchor>ga9bc5b54374abccaff888cd3852c85702</anchor>
      <arglist>(xbt_peer_t h)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_peer_free</name>
      <anchorfile>group__XBT__peer.html</anchorfile>
      <anchor>ga251d6140c311d7c04e503e3d463adba4</anchor>
      <arglist>(xbt_peer_t peer)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_peer_free_voidp</name>
      <anchorfile>group__XBT__peer.html</anchorfile>
      <anchor>ga793bb9b0c2ee6221c8e9b7d3c886dbb9</anchor>
      <arglist>(void *d)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_queue</name>
    <title>Queue</title>
    <filename>group__XBT__queue.html</filename>
    <member kind="typedef">
      <type>struct s_xbt_queue_ *</type>
      <name>xbt_queue_t</name>
      <anchorfile>group__XBT__queue.html</anchorfile>
      <anchor>gae44d114ab24c5175b9500f0a80058f4f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>xbt_queue_t</type>
      <name>xbt_queue_new</name>
      <anchorfile>group__XBT__queue.html</anchorfile>
      <anchor>ga04f81fdbf3a660617deb9f6f48234161</anchor>
      <arglist>(int capacity, unsigned long elm_size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_queue_free</name>
      <anchorfile>group__XBT__queue.html</anchorfile>
      <anchor>gae4509298241a6179e0b61667faebe613</anchor>
      <arglist>(xbt_queue_t *queue)</arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>xbt_queue_length</name>
      <anchorfile>group__XBT__queue.html</anchorfile>
      <anchor>ga49cfb91b2f730487bd31f2f9ffb974fa</anchor>
      <arglist>(const xbt_queue_t queue)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_queue_push</name>
      <anchorfile>group__XBT__queue.html</anchorfile>
      <anchor>ga687d865601b586f65162cde66b944163</anchor>
      <arglist>(xbt_queue_t queue, const void *src)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_queue_pop</name>
      <anchorfile>group__XBT__queue.html</anchorfile>
      <anchor>ga368e7ef82906e1c5baefa8083879c215</anchor>
      <arglist>(xbt_queue_t queue, void *const dst)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_queue_unshift</name>
      <anchorfile>group__XBT__queue.html</anchorfile>
      <anchor>gaba17464ddde9dec336376a2e4e9f3a4e</anchor>
      <arglist>(xbt_queue_t queue, const void *src)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_queue_shift</name>
      <anchorfile>group__XBT__queue.html</anchorfile>
      <anchor>ga60a1272bb4a1463b8254cf857b8d7441</anchor>
      <arglist>(xbt_queue_t queue, void *const dst)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_queue_push_timed</name>
      <anchorfile>group__XBT__queue.html</anchorfile>
      <anchor>gab68bab7ad2af3afc35130971d668c2b3</anchor>
      <arglist>(xbt_queue_t queue, const void *src, double delay)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_queue_unshift_timed</name>
      <anchorfile>group__XBT__queue.html</anchorfile>
      <anchor>ga9a868b5c72f70f207999b8a0beefed84</anchor>
      <arglist>(xbt_queue_t queue, const void *src, double delay)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_queue_shift_timed</name>
      <anchorfile>group__XBT__queue.html</anchorfile>
      <anchor>ga48988a7bf6134fc397147b16408c0778</anchor>
      <arglist>(xbt_queue_t queue, void *const dst, double delay)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_queue_pop_timed</name>
      <anchorfile>group__XBT__queue.html</anchorfile>
      <anchor>ga99d1d70f1a59f3f45bcd4e5d35b77f51</anchor>
      <arglist>(xbt_queue_t queue, void *const dst, double delay)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_sock</name>
    <title>Sock</title>
    <filename>group__XBT__sock.html</filename>
    <subgroup>XBT_sock_create</subgroup>
    <subgroup>XBT_sock_info</subgroup>
    <subgroup>XBT_sock_meas</subgroup>
    <subgroup>XBT_sock_plugin</subgroup>
  </compound>
  <compound kind="group">
    <name>XBT_synchro</name>
    <title>Synchro stuff</title>
    <filename>group__XBT__synchro.html</filename>
    <member kind="typedef">
      <type>struct s_xbt_thread_ *</type>
      <name>xbt_thread_t</name>
      <anchorfile>group__XBT__synchro.html</anchorfile>
      <anchor>gabe2e83a69fdb54e7513cfde241a8b6e9</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct s_xbt_mutex_ *</type>
      <name>xbt_mutex_t</name>
      <anchorfile>group__XBT__synchro.html</anchorfile>
      <anchor>ga6e01b815cfcb1b932c9ad5c334ee82cd</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct s_xbt_cond_ *</type>
      <name>xbt_cond_t</name>
      <anchorfile>group__XBT__synchro.html</anchorfile>
      <anchor>gace9e6b68048d41411b38765f614c1301</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>xbt_thread_t</type>
      <name>xbt_thread_create</name>
      <anchorfile>group__XBT__synchro.html</anchorfile>
      <anchor>ga7faf7010fd7bc47cd1487fe7bfba2214</anchor>
      <arglist>(const char *name, void_f_pvoid_t start_routine, void *param, int joinable)</arglist>
    </member>
    <member kind="function">
      <type>xbt_thread_t</type>
      <name>xbt_thread_self</name>
      <anchorfile>group__XBT__synchro.html</anchorfile>
      <anchor>gab781e679c968c3a7ae12d32ffa3dd63e</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>xbt_thread_name</name>
      <anchorfile>group__XBT__synchro.html</anchorfile>
      <anchor>ga3b74bd7c7a6fbdf1ef7e4a9c9f6035c0</anchor>
      <arglist>(xbt_thread_t t)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>xbt_thread_self_name</name>
      <anchorfile>group__XBT__synchro.html</anchorfile>
      <anchor>ga44f3eaa106769bb7bd269b95e4dc46e8</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_thread_join</name>
      <anchorfile>group__XBT__synchro.html</anchorfile>
      <anchor>ga4633b9357c418a88723d3a11f02b9280</anchor>
      <arglist>(xbt_thread_t thread)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_thread_cancel</name>
      <anchorfile>group__XBT__synchro.html</anchorfile>
      <anchor>gaeaeb76bcf1386f57104957ffe50dd913</anchor>
      <arglist>(xbt_thread_t thread)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_thread_exit</name>
      <anchorfile>group__XBT__synchro.html</anchorfile>
      <anchor>ga2c8ac4c62ee9788b889dd135db67871f</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_thread_yield</name>
      <anchorfile>group__XBT__synchro.html</anchorfile>
      <anchor>gad94ddaafcea741ad2cce5b97184ccb1f</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>xbt_mutex_t</type>
      <name>xbt_mutex_init</name>
      <anchorfile>group__XBT__synchro.html</anchorfile>
      <anchor>ga2b5f21533b44d2dd61c9335d0db48e93</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_mutex_acquire</name>
      <anchorfile>group__XBT__synchro.html</anchorfile>
      <anchor>gaa6e5de3feee929f5212a988cc67159b5</anchor>
      <arglist>(xbt_mutex_t mutex)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_mutex_release</name>
      <anchorfile>group__XBT__synchro.html</anchorfile>
      <anchor>ga90c18013e0a7a19ee22cb668b6082b39</anchor>
      <arglist>(xbt_mutex_t mutex)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_mutex_timedacquire</name>
      <anchorfile>group__XBT__synchro.html</anchorfile>
      <anchor>ga898fab3b59879e858fc8b6aac6b06fd6</anchor>
      <arglist>(xbt_mutex_t mutex, double delay)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_mutex_destroy</name>
      <anchorfile>group__XBT__synchro.html</anchorfile>
      <anchor>ga4deb9869591b5673738ae97a7d12dd10</anchor>
      <arglist>(xbt_mutex_t mutex)</arglist>
    </member>
    <member kind="function">
      <type>xbt_cond_t</type>
      <name>xbt_cond_init</name>
      <anchorfile>group__XBT__synchro.html</anchorfile>
      <anchor>ga9ec2fa18ad2edb1356034fb6c488a9a3</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cond_wait</name>
      <anchorfile>group__XBT__synchro.html</anchorfile>
      <anchor>ga083997cea536a10a81ed9cbdee741ab4</anchor>
      <arglist>(xbt_cond_t cond, xbt_mutex_t mutex)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cond_timedwait</name>
      <anchorfile>group__XBT__synchro.html</anchorfile>
      <anchor>ga2283204fd8b68891a404c4101542a7e3</anchor>
      <arglist>(xbt_cond_t cond, xbt_mutex_t mutex, double delay)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cond_signal</name>
      <anchorfile>group__XBT__synchro.html</anchorfile>
      <anchor>ga20471db1f98e58b75d8d58ed66e48438</anchor>
      <arglist>(xbt_cond_t cond)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cond_broadcast</name>
      <anchorfile>group__XBT__synchro.html</anchorfile>
      <anchor>ga0d3469f3d7692423b82786ffa4e30c70</anchor>
      <arglist>(xbt_cond_t cond)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cond_destroy</name>
      <anchorfile>group__XBT__synchro.html</anchorfile>
      <anchor>ga8382820073c787494cafa0634e86c96f</anchor>
      <arglist>(xbt_cond_t cond)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_thread</name>
    <title>Thread stuff</title>
    <filename>group__XBT__thread.html</filename>
    <member kind="typedef">
      <type>struct xbt_os_thread_ *</type>
      <name>xbt_os_thread_t</name>
      <anchorfile>group__XBT__thread.html</anchorfile>
      <anchor>ga7994e3241b60f854c77043c49a83873c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct xbt_os_mutex_ *</type>
      <name>xbt_os_mutex_t</name>
      <anchorfile>group__XBT__thread.html</anchorfile>
      <anchor>ga51b6d74f9dcfa8d7563ddf6386f9bd89</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct xbt_os_rmutex_ *</type>
      <name>xbt_os_rmutex_t</name>
      <anchorfile>group__XBT__thread.html</anchorfile>
      <anchor>gaac45eea7caeae848b86cf78d989d9aee</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct xbt_os_cond_ *</type>
      <name>xbt_os_cond_t</name>
      <anchorfile>group__XBT__thread.html</anchorfile>
      <anchor>ga2c6224cb25614dc8b972aca6288ebe60</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct xbt_os_sem_ *</type>
      <name>xbt_os_sem_t</name>
      <anchorfile>group__XBT__thread.html</anchorfile>
      <anchor>gab48cac979eebc8c1e26ca7adc7cec0ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>xbt_os_thread_atfork</name>
      <anchorfile>group__XBT__thread.html</anchorfile>
      <anchor>gad4f77b979102bcbb4dc49538481146ac</anchor>
      <arglist>(void(*prepare)(void), void(*parent)(void), void(*child)(void))</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>xbt_os_get_numcores</name>
      <anchorfile>group__XBT__thread.html</anchorfile>
      <anchor>ga737321f05368f70c51d5d4c939b3aa11</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_context</name>
    <title>Portable context implementation</title>
    <filename>group__XBT__context.html</filename>
  </compound>
  <compound kind="group">
    <name>XBT_replay</name>
    <title>Replay</title>
    <filename>group__XBT__replay.html</filename>
    <member kind="function">
      <type>void</type>
      <name>xbt_replay_action_register</name>
      <anchorfile>group__XBT__replay.html</anchorfile>
      <anchor>ga994ddcd8aa680aabc58762d8965f93ef</anchor>
      <arglist>(const char *action_name, action_fun function)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_replay_action_unregister</name>
      <anchorfile>group__XBT__replay.html</anchorfile>
      <anchor>ga83842574c19fdf7d056cdfeacd64dae7</anchor>
      <arglist>(const char *action_name)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>xbt_replay_action_runner</name>
      <anchorfile>group__XBT__replay.html</anchorfile>
      <anchor>ga1a034387ae8f039bca99f6fc44518da0</anchor>
      <arglist>(int argc, char *argv[])</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>msg_simulation</name>
    <title>Main MSG simulation Functions</title>
    <filename>group__msg__simulation.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>MSG_init</name>
      <anchorfile>group__msg__simulation.html</anchorfile>
      <anchor>gab394a1043a25ec62f498c097d805f0a1</anchor>
      <arglist>(argc, argv)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>MSG_launch_application</name>
      <anchorfile>group__msg__simulation.html</anchorfile>
      <anchor>ga012d470de7974da7262d0020e00117e9</anchor>
      <arglist>(const char *file)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>MSG_function_register</name>
      <anchorfile>group__msg__simulation.html</anchorfile>
      <anchor>ga21e94a4e7b26dea140b0c71a2a4f4352</anchor>
      <arglist>(const char *name, xbt_main_func_t code)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>MSG_function_register_default</name>
      <anchorfile>group__msg__simulation.html</anchorfile>
      <anchor>ga698d00aec4b3d7f8cf90c4d1a4595c9c</anchor>
      <arglist>(xbt_main_func_t code)</arglist>
    </member>
    <member kind="function">
      <type>xbt_main_func_t</type>
      <name>MSG_get_registered_function</name>
      <anchorfile>group__msg__simulation.html</anchorfile>
      <anchor>ga61b2e271c59ff50d38de7a0f9858b4b1</anchor>
      <arglist>(const char *name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>MSG_create_environment</name>
      <anchorfile>group__msg__simulation.html</anchorfile>
      <anchor>gae08e089d52a2928680e0957e7152d79d</anchor>
      <arglist>(const char *file)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>MSG_init_nocheck</name>
      <anchorfile>group__msg__simulation.html</anchorfile>
      <anchor>ga0dbc6fabf0391c4f193b33befeb8a22e</anchor>
      <arglist>(int *argc, char **argv)</arglist>
    </member>
    <member kind="function">
      <type>msg_error_t</type>
      <name>MSG_main</name>
      <anchorfile>group__msg__simulation.html</anchorfile>
      <anchor>ga638072e92edcf9c5aed498daefed010c</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>MSG_process_killall</name>
      <anchorfile>group__msg__simulation.html</anchorfile>
      <anchor>ga0dedd7962cd7d916406ef45c471f6134</anchor>
      <arglist>(int reset_PIDs)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>MSG_get_clock</name>
      <anchorfile>group__msg__simulation.html</anchorfile>
      <anchor>gacfeb7fa281abd0ff74b0591937cbb574</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="enumeration">
      <name>msg_error_t</name>
      <anchorfile>group__msg__simulation.html</anchorfile>
      <anchor>gaf79b56c0bd3b78b539b0cb4c12e56425</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MSG_OK</name>
      <anchorfile>group__msg__simulation.html</anchorfile>
      <anchor>ggaf79b56c0bd3b78b539b0cb4c12e56425a7db209a18c6374183567534787dccc1b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MSG_TIMEOUT</name>
      <anchorfile>group__msg__simulation.html</anchorfile>
      <anchor>ggaf79b56c0bd3b78b539b0cb4c12e56425a2f90300a07b9b18285e1897b1fabfd06</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MSG_TRANSFER_FAILURE</name>
      <anchorfile>group__msg__simulation.html</anchorfile>
      <anchor>ggaf79b56c0bd3b78b539b0cb4c12e56425a373b92dc6a498dea6ab408fb1670386f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MSG_HOST_FAILURE</name>
      <anchorfile>group__msg__simulation.html</anchorfile>
      <anchor>ggaf79b56c0bd3b78b539b0cb4c12e56425a69965b44e0393c3ba81482bb975c55e5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MSG_TASK_CANCELED</name>
      <anchorfile>group__msg__simulation.html</anchorfile>
      <anchor>ggaf79b56c0bd3b78b539b0cb4c12e56425a115b6882d73de65d775aa8c7f1abaf70</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>m_process_management</name>
    <title>Process Management Functions</title>
    <filename>group__m__process__management.html</filename>
    <member kind="typedef">
      <type>struct s_smx_process *</type>
      <name>msg_process_t</name>
      <anchorfile>group__m__process__management.html</anchorfile>
      <anchor>ga49407197cb1ba4a2b1943285786eacec</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>msg_process_t</type>
      <name>MSG_process_create</name>
      <anchorfile>group__m__process__management.html</anchorfile>
      <anchor>ga943d27b38754b2af9f78e80cc29db306</anchor>
      <arglist>(const char *name, xbt_main_func_t code, void *data, msg_host_t host)</arglist>
    </member>
    <member kind="function">
      <type>msg_process_t</type>
      <name>MSG_process_create_with_arguments</name>
      <anchorfile>group__m__process__management.html</anchorfile>
      <anchor>ga1540ef18107c4d2387a937017dcf97c5</anchor>
      <arglist>(const char *name, xbt_main_func_t code, void *data, msg_host_t host, int argc, char **argv)</arglist>
    </member>
    <member kind="function">
      <type>msg_process_t</type>
      <name>MSG_process_create_with_environment</name>
      <anchorfile>group__m__process__management.html</anchorfile>
      <anchor>ga640b4cc9200796bc211e6d8b794ba922</anchor>
      <arglist>(const char *name, xbt_main_func_t code, void *data, msg_host_t host, int argc, char **argv, xbt_dict_t properties)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>MSG_process_kill</name>
      <anchorfile>group__m__process__management.html</anchorfile>
      <anchor>gab7ed321f5bf4776d42e1d91158d67b8d</anchor>
      <arglist>(msg_process_t process)</arglist>
    </member>
    <member kind="function">
      <type>msg_error_t</type>
      <name>MSG_process_migrate</name>
      <anchorfile>group__m__process__management.html</anchorfile>
      <anchor>ga6651c72dff79c7f1aa6eff05db5b3063</anchor>
      <arglist>(msg_process_t process, msg_host_t host)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>MSG_process_get_data</name>
      <anchorfile>group__m__process__management.html</anchorfile>
      <anchor>ga2a510fa3957f963a04eaf6b483bfc6a9</anchor>
      <arglist>(msg_process_t process)</arglist>
    </member>
    <member kind="function">
      <type>msg_error_t</type>
      <name>MSG_process_set_data</name>
      <anchorfile>group__m__process__management.html</anchorfile>
      <anchor>gad1ad359bc57b8a7008435ee29e1da681</anchor>
      <arglist>(msg_process_t process, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>MSG_process_set_data_cleanup</name>
      <anchorfile>group__m__process__management.html</anchorfile>
      <anchor>ga2c75b91ef5b61cad66a7fa3a72d122d0</anchor>
      <arglist>(void_f_pvoid_t data_cleanup)</arglist>
    </member>
    <member kind="function">
      <type>msg_host_t</type>
      <name>MSG_process_get_host</name>
      <anchorfile>group__m__process__management.html</anchorfile>
      <anchor>ga7b74e6c2c40a8365b4bed0e37c798ea5</anchor>
      <arglist>(msg_process_t process)</arglist>
    </member>
    <member kind="function">
      <type>msg_process_t</type>
      <name>MSG_process_from_PID</name>
      <anchorfile>group__m__process__management.html</anchorfile>
      <anchor>ga842d26b5c9352aea228378d8ef12209b</anchor>
      <arglist>(int PID)</arglist>
    </member>
    <member kind="function">
      <type>msg_error_t</type>
      <name>MSG_process_set_kill_time</name>
      <anchorfile>group__m__process__management.html</anchorfile>
      <anchor>ga090d763945c2286f7227f1fe069efb79</anchor>
      <arglist>(msg_process_t process, double kill_time)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>MSG_process_get_PID</name>
      <anchorfile>group__m__process__management.html</anchorfile>
      <anchor>ga180e1dbb474bda1958a409825e2928cb</anchor>
      <arglist>(msg_process_t process)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>MSG_process_get_PPID</name>
      <anchorfile>group__m__process__management.html</anchorfile>
      <anchor>ga9f28a934b5e2e220093131c7c93d63c4</anchor>
      <arglist>(msg_process_t process)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>MSG_process_get_name</name>
      <anchorfile>group__m__process__management.html</anchorfile>
      <anchor>gaf22fa3dcf713f37e292397eea9744e7a</anchor>
      <arglist>(msg_process_t process)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>MSG_process_get_property_value</name>
      <anchorfile>group__m__process__management.html</anchorfile>
      <anchor>ga7894a7c080a4821b49b17d0b6abd46ae</anchor>
      <arglist>(msg_process_t process, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dict_t</type>
      <name>MSG_process_get_properties</name>
      <anchorfile>group__m__process__management.html</anchorfile>
      <anchor>gad7570aff7510cbed3fc1dc3b97d0231b</anchor>
      <arglist>(msg_process_t process)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>MSG_process_self_PID</name>
      <anchorfile>group__m__process__management.html</anchorfile>
      <anchor>ga2eea811c91c7e85a21160b53d65ec79c</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>MSG_process_self_PPID</name>
      <anchorfile>group__m__process__management.html</anchorfile>
      <anchor>ga0b6f46d91ad8f9e6862e26d8a89d2047</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>msg_process_t</type>
      <name>MSG_process_self</name>
      <anchorfile>group__m__process__management.html</anchorfile>
      <anchor>gaf76911391b5116a7d1775e74185e64d5</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>msg_error_t</type>
      <name>MSG_process_suspend</name>
      <anchorfile>group__m__process__management.html</anchorfile>
      <anchor>gac00bbc4ebc824d14a3f6719de8190618</anchor>
      <arglist>(msg_process_t process)</arglist>
    </member>
    <member kind="function">
      <type>msg_error_t</type>
      <name>MSG_process_resume</name>
      <anchorfile>group__m__process__management.html</anchorfile>
      <anchor>ga9f25a30269f39c7683d18f9d4e1fd331</anchor>
      <arglist>(msg_process_t process)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>MSG_process_is_suspended</name>
      <anchorfile>group__m__process__management.html</anchorfile>
      <anchor>ga4fd646e5d31bdecfc5e93405a2c32d56</anchor>
      <arglist>(msg_process_t process)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>MSG_process_on_exit</name>
      <anchorfile>group__m__process__management.html</anchorfile>
      <anchor>ga42cde2901797dfce3db7d13e0bcc02d5</anchor>
      <arglist>(int_f_pvoid_t fun, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>MSG_process_auto_restart_set</name>
      <anchorfile>group__m__process__management.html</anchorfile>
      <anchor>gaa8489360976ff79e94e3db2254e5b7db</anchor>
      <arglist>(msg_process_t process, int auto_restart)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>m_host_management</name>
    <title>Host Management Functions</title>
    <filename>group__m__host__management.html</filename>
    <member kind="typedef">
      <type>struct msg_host *</type>
      <name>msg_host_t</name>
      <anchorfile>group__m__host__management.html</anchorfile>
      <anchor>ga2b74231d9a675492b9881234be47ca76</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>msg_error_t</type>
      <name>MSG_host_set_data</name>
      <anchorfile>group__m__host__management.html</anchorfile>
      <anchor>gab52e164f5e7710facf114234152cfe85</anchor>
      <arglist>(msg_host_t host, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>MSG_host_get_data</name>
      <anchorfile>group__m__host__management.html</anchorfile>
      <anchor>ga074e447602d8c0eab3f442c78a1dfe5f</anchor>
      <arglist>(msg_host_t host)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>MSG_host_get_name</name>
      <anchorfile>group__m__host__management.html</anchorfile>
      <anchor>gad4daf43406f4dce8caae5310cdf40bde</anchor>
      <arglist>(msg_host_t host)</arglist>
    </member>
    <member kind="function">
      <type>msg_host_t</type>
      <name>MSG_host_self</name>
      <anchorfile>group__m__host__management.html</anchorfile>
      <anchor>ga8552d95b844f896978eca735cbd73e9f</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>MSG_get_host_number</name>
      <anchorfile>group__m__host__management.html</anchorfile>
      <anchor>gaafceb2773bb9e39878592ff9a9a81a01</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dynar_t</type>
      <name>MSG_hosts_as_dynar</name>
      <anchorfile>group__m__host__management.html</anchorfile>
      <anchor>gaa886b8367e635efe11211b2aca5a1d43</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>MSG_get_host_msgload</name>
      <anchorfile>group__m__host__management.html</anchorfile>
      <anchor>ga94b03ec6fe7c2bbf3c6c7bef2f89ee0b</anchor>
      <arglist>(msg_host_t h)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>MSG_get_host_speed</name>
      <anchorfile>group__m__host__management.html</anchorfile>
      <anchor>ga6e910e3a884ebbe0b8ccae3277619374</anchor>
      <arglist>(msg_host_t h)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>MSG_host_get_property_value</name>
      <anchorfile>group__m__host__management.html</anchorfile>
      <anchor>gadcefcdecf27f1dfb19a5c2ac5a775402</anchor>
      <arglist>(msg_host_t host, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dict_t</type>
      <name>MSG_host_get_properties</name>
      <anchorfile>group__m__host__management.html</anchorfile>
      <anchor>gac5d6359399bb8c8daba83cf62f47785f</anchor>
      <arglist>(msg_host_t host)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>MSG_host_set_property_value</name>
      <anchorfile>group__m__host__management.html</anchorfile>
      <anchor>ga1b84e13e966d6ec0a2c013144d33f194</anchor>
      <arglist>(msg_host_t host, const char *name, char *value, void_f_pvoid_t free_ctn)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>m_task_management</name>
    <title>Task Management Functions</title>
    <filename>group__m__task__management.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>MSG_TASK_UNINITIALIZED</name>
      <anchorfile>group__m__task__management.html</anchorfile>
      <anchor>ga13f8ac858abd957f5cb2e9a54ad98d76</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct msg_task *</type>
      <name>msg_task_t</name>
      <anchorfile>group__m__task__management.html</anchorfile>
      <anchor>gaa7cd89c7f542d19fd817a614d1c1cc95</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct msg_gpu_task *</type>
      <name>msg_gpu_task_t</name>
      <anchorfile>group__m__task__management.html</anchorfile>
      <anchor>ga3ab366f5db21f52c90a265fe83c5c2dd</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>msg_task_t</type>
      <name>MSG_task_create</name>
      <anchorfile>group__m__task__management.html</anchorfile>
      <anchor>gaafe2ccabd38b13d1734323f86e40706a</anchor>
      <arglist>(const char *name, double compute_duration, double message_size, void *data)</arglist>
    </member>
    <member kind="function">
      <type>msg_task_t</type>
      <name>MSG_parallel_task_create</name>
      <anchorfile>group__m__task__management.html</anchorfile>
      <anchor>ga54412e440ff859933bbbcb0204aa5a75</anchor>
      <arglist>(const char *name, int host_nb, const msg_host_t *host_list, double *computation_amount, double *communication_amount, void *data)</arglist>
    </member>
    <member kind="function">
      <type>msg_gpu_task_t</type>
      <name>MSG_gpu_task_create</name>
      <anchorfile>group__m__task__management.html</anchorfile>
      <anchor>ga4ed297ea1a968b31be47d45f5f908580</anchor>
      <arglist>(const char *name, double compute_duration, double dispatch_latency, double collect_latency)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>MSG_task_get_data</name>
      <anchorfile>group__m__task__management.html</anchorfile>
      <anchor>gab0ef7c694fcc69282cf4da632ae64d5b</anchor>
      <arglist>(msg_task_t task)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>MSG_task_set_data</name>
      <anchorfile>group__m__task__management.html</anchorfile>
      <anchor>ga5a2984b6a34bb725b52ee31cdece56a2</anchor>
      <arglist>(msg_task_t task, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>MSG_task_set_copy_callback</name>
      <anchorfile>group__m__task__management.html</anchorfile>
      <anchor>gab4fd7f315f6f7d9297eaad64e67fbf90</anchor>
      <arglist>(void(*callback)(msg_task_t task, msg_process_t sender, msg_process_t receiver))</arglist>
    </member>
    <member kind="function">
      <type>msg_process_t</type>
      <name>MSG_task_get_sender</name>
      <anchorfile>group__m__task__management.html</anchorfile>
      <anchor>ga90a38af4ae02895a5e656c6d2555a63b</anchor>
      <arglist>(msg_task_t task)</arglist>
    </member>
    <member kind="function">
      <type>msg_host_t</type>
      <name>MSG_task_get_source</name>
      <anchorfile>group__m__task__management.html</anchorfile>
      <anchor>gabb8f9c3289b341b68af5c789ea659c1e</anchor>
      <arglist>(msg_task_t task)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>MSG_task_get_name</name>
      <anchorfile>group__m__task__management.html</anchorfile>
      <anchor>ga2adce7c9dbe8ecab1d6db1fdc420ea80</anchor>
      <arglist>(msg_task_t task)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>MSG_task_set_name</name>
      <anchorfile>group__m__task__management.html</anchorfile>
      <anchor>gaa97b99e0176424e3f0afdf239e2f3f32</anchor>
      <arglist>(msg_task_t task, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>msg_error_t</type>
      <name>MSG_task_destroy</name>
      <anchorfile>group__m__task__management.html</anchorfile>
      <anchor>gaf6369e840095c428218e494bf8b6dee6</anchor>
      <arglist>(msg_task_t task)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>MSG_task_get_compute_duration</name>
      <anchorfile>group__m__task__management.html</anchorfile>
      <anchor>gae6c900f519f6280a9e7a615a2e47cb96</anchor>
      <arglist>(msg_task_t task)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>MSG_task_set_compute_duration</name>
      <anchorfile>group__m__task__management.html</anchorfile>
      <anchor>gab54a9cc669db50dc7229389ac3dc7f1f</anchor>
      <arglist>(msg_task_t task, double computation_amount)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>MSG_task_get_remaining_computation</name>
      <anchorfile>group__m__task__management.html</anchorfile>
      <anchor>gada131788294fe436d9cc1044319b111f</anchor>
      <arglist>(msg_task_t task)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>MSG_task_get_remaining_communication</name>
      <anchorfile>group__m__task__management.html</anchorfile>
      <anchor>ga1f3d2d85e2a7415e26fa12f05b71fc34</anchor>
      <arglist>(msg_task_t task)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>MSG_task_get_data_size</name>
      <anchorfile>group__m__task__management.html</anchorfile>
      <anchor>ga5d7514ea11b8a51bad0cbc7ad0636856</anchor>
      <arglist>(msg_task_t task)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>MSG_task_set_priority</name>
      <anchorfile>group__m__task__management.html</anchorfile>
      <anchor>ga22cf2562fbb9cad8c5860914c0d8d6dc</anchor>
      <arglist>(msg_task_t task, double priority)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>msg_mailbox_management</name>
    <title>Mailbox Management Functions</title>
    <filename>group__msg__mailbox__management.html</filename>
    <member kind="function">
      <type>msg_error_t</type>
      <name>MSG_mailbox_get_task_ext</name>
      <anchorfile>group__msg__mailbox__management.html</anchorfile>
      <anchor>ga0ccdeb3f9337c9fa505ed39c74bd27a1</anchor>
      <arglist>(msg_mailbox_t mailbox, msg_task_t *task, msg_host_t host, double timeout)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>msg_task_usage</name>
    <title>Task Actions</title>
    <filename>group__msg__task__usage.html</filename>
    <member kind="typedef">
      <type>struct s_smx_rvpoint *</type>
      <name>msg_mailbox_t</name>
      <anchorfile>group__msg__task__usage.html</anchorfile>
      <anchor>gae2f7e0cd1e5707f78b4694abeef695d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct msg_comm *</type>
      <name>msg_comm_t</name>
      <anchorfile>group__msg__task__usage.html</anchorfile>
      <anchor>gafe19e97b54682048a5b2f1c79add21cf</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>msg_error_t</type>
      <name>MSG_task_execute</name>
      <anchorfile>group__msg__task__usage.html</anchorfile>
      <anchor>ga6ebbb75fe9ff779eac6ca57c5ad5bfe3</anchor>
      <arglist>(msg_task_t task)</arglist>
    </member>
    <member kind="function">
      <type>msg_error_t</type>
      <name>MSG_parallel_task_execute</name>
      <anchorfile>group__msg__task__usage.html</anchorfile>
      <anchor>ga97bd13baa799b73b12599b3d6f7b849f</anchor>
      <arglist>(msg_task_t task)</arglist>
    </member>
    <member kind="function">
      <type>msg_error_t</type>
      <name>MSG_process_sleep</name>
      <anchorfile>group__msg__task__usage.html</anchorfile>
      <anchor>gab7c18061b167e38f28886512ea73be6b</anchor>
      <arglist>(double nb_sec)</arglist>
    </member>
    <member kind="function">
      <type>msg_error_t</type>
      <name>MSG_task_receive_from_host</name>
      <anchorfile>group__msg__task__usage.html</anchorfile>
      <anchor>gae41e58a499fddc40b4b0de9a59894b29</anchor>
      <arglist>(msg_task_t *task, const char *alias, msg_host_t host)</arglist>
    </member>
    <member kind="function">
      <type>msg_error_t</type>
      <name>MSG_task_receive</name>
      <anchorfile>group__msg__task__usage.html</anchorfile>
      <anchor>ga710ee9d4ea587ab6ae66014913ac91e1</anchor>
      <arglist>(msg_task_t *task, const char *alias)</arglist>
    </member>
    <member kind="function">
      <type>msg_error_t</type>
      <name>MSG_task_receive_with_timeout</name>
      <anchorfile>group__msg__task__usage.html</anchorfile>
      <anchor>ga19687ebde0e9a07cb99fc73e7dfa7a03</anchor>
      <arglist>(msg_task_t *task, const char *alias, double timeout)</arglist>
    </member>
    <member kind="function">
      <type>msg_error_t</type>
      <name>MSG_task_receive_ext</name>
      <anchorfile>group__msg__task__usage.html</anchorfile>
      <anchor>ga1e2f86298cf00ea3ced4d263d31e2890</anchor>
      <arglist>(msg_task_t *task, const char *alias, double timeout, msg_host_t host)</arglist>
    </member>
    <member kind="function">
      <type>msg_comm_t</type>
      <name>MSG_task_isend</name>
      <anchorfile>group__msg__task__usage.html</anchorfile>
      <anchor>gaa280111a523d70bb36061e6e52ca1b42</anchor>
      <arglist>(msg_task_t task, const char *alias)</arglist>
    </member>
    <member kind="function">
      <type>msg_comm_t</type>
      <name>MSG_task_isend_with_matching</name>
      <anchorfile>group__msg__task__usage.html</anchorfile>
      <anchor>gabab3742eeb92d3e9a03aa7068f7d5d7f</anchor>
      <arglist>(msg_task_t task, const char *alias, int(*match_fun)(void *, void *, smx_action_t), void *match_data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>MSG_task_dsend</name>
      <anchorfile>group__msg__task__usage.html</anchorfile>
      <anchor>ga7e292abd2fac532430ecb51a170a004a</anchor>
      <arglist>(msg_task_t task, const char *alias, void_f_pvoid_t cleanup)</arglist>
    </member>
    <member kind="function">
      <type>msg_comm_t</type>
      <name>MSG_task_irecv</name>
      <anchorfile>group__msg__task__usage.html</anchorfile>
      <anchor>gadb4623d587d75ad3b078928f0f1b27a5</anchor>
      <arglist>(msg_task_t *task, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>MSG_comm_test</name>
      <anchorfile>group__msg__task__usage.html</anchorfile>
      <anchor>gafd22dad001b95804f5e93aa146c84fd3</anchor>
      <arglist>(msg_comm_t comm)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>MSG_comm_testany</name>
      <anchorfile>group__msg__task__usage.html</anchorfile>
      <anchor>gacd787fdda2fd925a1e4e0114cb4eb82e</anchor>
      <arglist>(xbt_dynar_t comms)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>MSG_comm_destroy</name>
      <anchorfile>group__msg__task__usage.html</anchorfile>
      <anchor>gaa1b107438e7a295058e098a8c2c1bc4a</anchor>
      <arglist>(msg_comm_t comm)</arglist>
    </member>
    <member kind="function">
      <type>msg_error_t</type>
      <name>MSG_comm_wait</name>
      <anchorfile>group__msg__task__usage.html</anchorfile>
      <anchor>ga2ae956f1e7a1014652d85b5f8db42aa3</anchor>
      <arglist>(msg_comm_t comm, double timeout)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>MSG_comm_waitall</name>
      <anchorfile>group__msg__task__usage.html</anchorfile>
      <anchor>ga01ce9097c976b96664e6785f6ab5d4b6</anchor>
      <arglist>(msg_comm_t *comm, int nb_elem, double timeout)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>MSG_comm_waitany</name>
      <anchorfile>group__msg__task__usage.html</anchorfile>
      <anchor>ga62772e7b378bc485c114231af4b8f596</anchor>
      <arglist>(xbt_dynar_t comms)</arglist>
    </member>
    <member kind="function">
      <type>msg_error_t</type>
      <name>MSG_comm_get_status</name>
      <anchorfile>group__msg__task__usage.html</anchorfile>
      <anchor>ga6a872b2d96bdd22d28b851f1072792f5</anchor>
      <arglist>(msg_comm_t comm)</arglist>
    </member>
    <member kind="function">
      <type>msg_task_t</type>
      <name>MSG_comm_get_task</name>
      <anchorfile>group__msg__task__usage.html</anchorfile>
      <anchor>gaf4fbe7c481859674d29475a0085d7333</anchor>
      <arglist>(msg_comm_t comm)</arglist>
    </member>
    <member kind="function">
      <type>msg_error_t</type>
      <name>MSG_task_send</name>
      <anchorfile>group__msg__task__usage.html</anchorfile>
      <anchor>ga33c924177135850888f25378b8e0b3cf</anchor>
      <arglist>(msg_task_t task, const char *alias)</arglist>
    </member>
    <member kind="function">
      <type>msg_error_t</type>
      <name>MSG_task_send_bounded</name>
      <anchorfile>group__msg__task__usage.html</anchorfile>
      <anchor>ga77f5e9bbbdb4a478cd3479d86678b7ab</anchor>
      <arglist>(msg_task_t task, const char *alias, double maxrate)</arglist>
    </member>
    <member kind="function">
      <type>msg_error_t</type>
      <name>MSG_task_send_with_timeout</name>
      <anchorfile>group__msg__task__usage.html</anchorfile>
      <anchor>gae1fb84e33c47ad59862188845ececdf5</anchor>
      <arglist>(msg_task_t task, const char *alias, double timeout)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>MSG_task_listen</name>
      <anchorfile>group__msg__task__usage.html</anchorfile>
      <anchor>ga297e41ae363db652f2075d7e9d164bb5</anchor>
      <arglist>(const char *alias)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>MSG_task_listen_from_host</name>
      <anchorfile>group__msg__task__usage.html</anchorfile>
      <anchor>ga26ca8f6eb20767098104786a15f19fb8</anchor>
      <arglist>(const char *alias, msg_host_t host)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>MSG_task_listen_from</name>
      <anchorfile>group__msg__task__usage.html</anchorfile>
      <anchor>ga7646951835a1ac861b6a35b41741a268</anchor>
      <arglist>(const char *alias)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>MSG_task_set_category</name>
      <anchorfile>group__msg__task__usage.html</anchorfile>
      <anchor>gaff6a660d1f3a37ff7ee3daee0e3ae3b7</anchor>
      <arglist>(msg_task_t task, const char *category)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>MSG_task_get_category</name>
      <anchorfile>group__msg__task__usage.html</anchorfile>
      <anchor>ga4d8a840bc4a7f1b28ba351069de9b9c3</anchor>
      <arglist>(msg_task_t task)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>msg_VMs</name>
    <title>VMs</title>
    <filename>group__msg__VMs.html</filename>
    <member kind="typedef">
      <type>struct msg_vm *</type>
      <name>msg_vm_t</name>
      <anchorfile>group__msg__VMs.html</anchorfile>
      <anchor>ga3226d0cd7c9a8133d09e4b3535892c5e</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>msg_vm_t</type>
      <name>MSG_vm_start</name>
      <anchorfile>group__msg__VMs.html</anchorfile>
      <anchor>ga33eea8260c55c2ef8980f30d59bc1871</anchor>
      <arglist>(msg_host_t location, int coreAmount)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dynar_t</type>
      <name>MSG_vms_as_dynar</name>
      <anchorfile>group__msg__VMs.html</anchorfile>
      <anchor>ga9d66095e9599545ab4cdd787a38f6b8e</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>MSG_vm_is_suspended</name>
      <anchorfile>group__msg__VMs.html</anchorfile>
      <anchor>gac7919295b7c197a43717e367f9c115c5</anchor>
      <arglist>(msg_vm_t vm)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>MSG_vm_is_running</name>
      <anchorfile>group__msg__VMs.html</anchorfile>
      <anchor>ga6ba8320c7a90ed67d3c8e2079460b8a9</anchor>
      <arglist>(msg_vm_t vm)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>MSG_vm_bind</name>
      <anchorfile>group__msg__VMs.html</anchorfile>
      <anchor>ga21d8a296f64c7190dcbcfd0c249b4275</anchor>
      <arglist>(msg_vm_t vm, msg_process_t process)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>MSG_vm_unbind</name>
      <anchorfile>group__msg__VMs.html</anchorfile>
      <anchor>gaf65aa7a4497fceaa50414caff2772a05</anchor>
      <arglist>(msg_vm_t vm, msg_process_t process)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>MSG_vm_migrate</name>
      <anchorfile>group__msg__VMs.html</anchorfile>
      <anchor>ga0b701b7e5a4b0459f1b9326e188e19b0</anchor>
      <arglist>(msg_vm_t vm, msg_host_t destination)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>MSG_vm_suspend</name>
      <anchorfile>group__msg__VMs.html</anchorfile>
      <anchor>ga32243e8be24c253c0367c81d0289e057</anchor>
      <arglist>(msg_vm_t vm)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>MSG_vm_resume</name>
      <anchorfile>group__msg__VMs.html</anchorfile>
      <anchor>ga9815e54a5e6cdf849d4847803d377e19</anchor>
      <arglist>(msg_vm_t vm)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>MSG_vm_shutdown</name>
      <anchorfile>group__msg__VMs.html</anchorfile>
      <anchor>ga1a40d2652506f4576408e35346cd3cff</anchor>
      <arglist>(msg_vm_t vm)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>MSG_vm_reboot</name>
      <anchorfile>group__msg__VMs.html</anchorfile>
      <anchor>ga6e665c9d3b9c0a6b3e9a97a419a7861f</anchor>
      <arglist>(msg_vm_t vm)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>MSG_vm_destroy</name>
      <anchorfile>group__msg__VMs.html</anchorfile>
      <anchor>gae493c978235ba8efeee6d8b5a5286e5b</anchor>
      <arglist>(msg_vm_t vm)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>msg_file_management</name>
    <title>File Management Functions</title>
    <filename>group__msg__file__management.html</filename>
    <class kind="struct">file_stat</class>
    <member kind="typedef">
      <type>struct msg_file *</type>
      <name>msg_file_t</name>
      <anchorfile>group__msg__file__management.html</anchorfile>
      <anchor>ga87e0d76d9428e822d9a67e676c8a2775</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>s_file_stat_t</type>
      <name>s_msg_stat_t</name>
      <anchorfile>group__msg__file__management.html</anchorfile>
      <anchor>gaab93dbdfe9f16fb0bb4913d0a4cd228b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct file_stat</type>
      <name>s_file_stat_t</name>
      <anchorfile>group__msg__file__management.html</anchorfile>
      <anchor>ga477ef283ddcf854d0252594b60afc236</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>MSG_file_read</name>
      <anchorfile>group__msg__file__management.html</anchorfile>
      <anchor>gaca68959cb9f41860848edb9b1eb5dbe1</anchor>
      <arglist>(void *ptr, size_t size, size_t nmemb, msg_file_t stream)</arglist>
    </member>
    <member kind="function">
      <type>size_t</type>
      <name>MSG_file_write</name>
      <anchorfile>group__msg__file__management.html</anchorfile>
      <anchor>ga365e9ede50d35d2915265e9f7dd696a7</anchor>
      <arglist>(const void *ptr, size_t size, size_t nmemb, msg_file_t stream)</arglist>
    </member>
    <member kind="function">
      <type>msg_file_t</type>
      <name>MSG_file_open</name>
      <anchorfile>group__msg__file__management.html</anchorfile>
      <anchor>ga4c104f2348c26866bd7b66c7acfd47a1</anchor>
      <arglist>(const char *mount, const char *path, const char *mode)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>MSG_file_close</name>
      <anchorfile>group__msg__file__management.html</anchorfile>
      <anchor>ga6ecd87b7d357c117eab2b8551fbc248e</anchor>
      <arglist>(msg_file_t fp)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>MSG_file_stat</name>
      <anchorfile>group__msg__file__management.html</anchorfile>
      <anchor>ga7bfc17d0cad09e215d4b90be06933e62</anchor>
      <arglist>(msg_file_t fd, s_msg_stat_t *buf)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>MSG_file_free_stat</name>
      <anchorfile>group__msg__file__management.html</anchorfile>
      <anchor>ga932679a1e3cd5a5cb83bf812741cf1e3</anchor>
      <arglist>(s_msg_stat_t *stat)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>MSG_file_unlink</name>
      <anchorfile>group__msg__file__management.html</anchorfile>
      <anchor>ga886ea23939db224929e122d363ed91cb</anchor>
      <arglist>(msg_file_t fd)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dict_t</type>
      <name>MSG_file_ls</name>
      <anchorfile>group__msg__file__management.html</anchorfile>
      <anchor>gad55ef25a4f6e484f4874d9cdc306c869</anchor>
      <arglist>(const char *mount, const char *path)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>msg_trace_driven</name>
    <title>Trace-driven simulations</title>
    <filename>group__msg__trace__driven.html</filename>
    <member kind="function">
      <type>msg_error_t</type>
      <name>MSG_action_trace_run</name>
      <anchorfile>group__msg__trace__driven.html</anchorfile>
      <anchor>gaff3ae0c6d1fc712f2162cc199086731f</anchor>
      <arglist>(char *path)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>MSG_LUA</name>
    <title>Lua bindings</title>
    <filename>group__MSG__LUA.html</filename>
    <member kind="function">
      <type>void</type>
      <name>MSG_load_platform_script</name>
      <anchorfile>group__MSG__LUA.html</anchorfile>
      <anchor>ga2923710a7784b2d2b019ebfd6ace7eb9</anchor>
      <arglist>(const char *script_file)</arglist>
    </member>
    <docanchor file="group__MSG__LUA">lMSG_who</docanchor>
    <docanchor file="group__MSG__LUA">MSG_Lua_funct</docanchor>
    <docanchor file="group__MSG__LUA">Lua_examples</docanchor>
  </compound>
  <compound kind="group">
    <name>msg_deprecated_functions</name>
    <title>MSG Deprecated</title>
    <filename>group__msg__deprecated__functions.html</filename>
    <member kind="function">
      <type>msg_error_t</type>
      <name>MSG_get_errno</name>
      <anchorfile>group__msg__deprecated__functions.html</anchorfile>
      <anchor>ga4abdb2c7da1b9d89187ce51211db3f25</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>msg_error_t</type>
      <name>MSG_task_put</name>
      <anchorfile>group__msg__deprecated__functions.html</anchorfile>
      <anchor>ga3e310a2bf7efc32d3aac8dad2eacd71d</anchor>
      <arglist>(msg_task_t task, msg_host_t dest, m_channel_t channel)</arglist>
    </member>
    <member kind="function">
      <type>msg_error_t</type>
      <name>MSG_task_put_bounded</name>
      <anchorfile>group__msg__deprecated__functions.html</anchorfile>
      <anchor>ga6e5db824a4317c3a1279eeaa79b6511d</anchor>
      <arglist>(msg_task_t task, msg_host_t dest, m_channel_t channel, double maxrate)</arglist>
    </member>
    <member kind="function">
      <type>msg_error_t</type>
      <name>MSG_task_put_with_timeout</name>
      <anchorfile>group__msg__deprecated__functions.html</anchorfile>
      <anchor>gac979ed68d1b602dd04169cbed23828a9</anchor>
      <arglist>(msg_task_t task, msg_host_t dest, m_channel_t channel, double timeout)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>MSG_task_probe_from</name>
      <anchorfile>group__msg__deprecated__functions.html</anchorfile>
      <anchor>ga99bfe9edc985c6d2cce3947f81780660</anchor>
      <arglist>(m_channel_t channel)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>MSG_task_Iprobe</name>
      <anchorfile>group__msg__deprecated__functions.html</anchorfile>
      <anchor>gae72af17e16cda4efcfad301a4170accd</anchor>
      <arglist>(m_channel_t channel)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>MSG_task_probe_from_host</name>
      <anchorfile>group__msg__deprecated__functions.html</anchorfile>
      <anchor>gaa44c47c7ed2f78243eca7379437e1cc0</anchor>
      <arglist>(int channel, msg_host_t host)</arglist>
    </member>
    <member kind="function">
      <type>msg_error_t</type>
      <name>MSG_task_get_from_host</name>
      <anchorfile>group__msg__deprecated__functions.html</anchorfile>
      <anchor>gad09e64171486db6b0004653125313971</anchor>
      <arglist>(msg_task_t *task, m_channel_t channel, msg_host_t host)</arglist>
    </member>
    <member kind="function">
      <type>msg_error_t</type>
      <name>MSG_task_get</name>
      <anchorfile>group__msg__deprecated__functions.html</anchorfile>
      <anchor>ga1ae6d2a80ca4f35d7a19215f409ce00f</anchor>
      <arglist>(msg_task_t *task, m_channel_t channel)</arglist>
    </member>
    <member kind="function">
      <type>msg_error_t</type>
      <name>MSG_task_get_with_timeout</name>
      <anchorfile>group__msg__deprecated__functions.html</anchorfile>
      <anchor>ga48bf7268e2f079ba1ad51a00209028cd</anchor>
      <arglist>(msg_task_t *task, m_channel_t channel, double max_duration)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>GRAS_comm</name>
    <title>Communication facilities</title>
    <filename>group__GRAS__comm.html</filename>
    <subgroup>GRAS_dd</subgroup>
    <subgroup>GRAS_sock</subgroup>
    <subgroup>GRAS_msg</subgroup>
    <subgroup>GRAS_timer</subgroup>
  </compound>
  <compound kind="group">
    <name>GRAS_run</name>
    <title>Virtualization</title>
    <filename>group__GRAS__run.html</filename>
    <subgroup>GRAS_globals</subgroup>
    <subgroup>GRAS_emul</subgroup>
    <subgroup>GRAS_virtu</subgroup>
  </compound>
  <compound kind="group">
    <name>GRAS_dd</name>
    <title>Data description</title>
    <filename>group__GRAS__dd.html</filename>
  </compound>
  <compound kind="group">
    <name>GRAS_sock</name>
    <title>Sockets</title>
    <filename>group__GRAS__sock.html</filename>
    <subgroup>GRAS_sock_create</subgroup>
    <subgroup>GRAS_sock_file</subgroup>
  </compound>
  <compound kind="group">
    <name>GRAS_msg</name>
    <title>Messages</title>
    <filename>group__GRAS__msg.html</filename>
    <subgroup>GRAS_msg_decl</subgroup>
    <subgroup>GRAS_msg_cb</subgroup>
    <subgroup>GRAS_msg_exchange</subgroup>
    <subgroup>GRAS_msg_rpc</subgroup>
    <subgroup>GRAS_msg_exchangeadv</subgroup>
  </compound>
  <compound kind="group">
    <name>GRAS_timer</name>
    <title>Timers</title>
    <filename>group__GRAS__timer.html</filename>
    <member kind="function">
      <type>void</type>
      <name>gras_timer_delay</name>
      <anchorfile>group__GRAS__timer.html</anchorfile>
      <anchor>gaba1a13793d801fdfc59731bfc6153ff6</anchor>
      <arglist>(double delay, void_f_void_t action)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gras_timer_repeat</name>
      <anchorfile>group__GRAS__timer.html</anchorfile>
      <anchor>gaace02a90a340b8fb00e13adbf1b4de52</anchor>
      <arglist>(double interval, void_f_void_t action)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gras_timer_cancel_delay</name>
      <anchorfile>group__GRAS__timer.html</anchorfile>
      <anchor>ga67dc4dd9df7bf9fe4c65d7b3fcdb083a</anchor>
      <arglist>(double interval, void_f_void_t action)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gras_timer_cancel_repeat</name>
      <anchorfile>group__GRAS__timer.html</anchorfile>
      <anchor>ga12a106f2b68208d5036c1cc170a1f654</anchor>
      <arglist>(double interval, void_f_void_t action)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gras_timer_cancel_delay_all</name>
      <anchorfile>group__GRAS__timer.html</anchorfile>
      <anchor>ga479153eb34c997d51efb0583e5b50c0a</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gras_timer_cancel_repeat_all</name>
      <anchorfile>group__GRAS__timer.html</anchorfile>
      <anchor>gaa0970ec0e243f9dc9b2a121d5d2ee964</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gras_timer_cancel_all</name>
      <anchorfile>group__GRAS__timer.html</anchorfile>
      <anchor>ga7c4a535d25652e71085918d4e11825b7</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>GRAS_globals</name>
    <title>Globals</title>
    <filename>group__GRAS__globals.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>gras_userdata_new</name>
      <anchorfile>group__GRAS__globals.html</anchorfile>
      <anchor>ga7d5d5973e9d4f19b415d6c7aa8787844</anchor>
      <arglist>(type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gras_agent_spawn</name>
      <anchorfile>group__GRAS__globals.html</anchorfile>
      <anchor>gaf783b0f28fc5ab9831f0e587c70d9ad5</anchor>
      <arglist>(const char *name, xbt_main_func_t code, int argc, char *argv[], xbt_dict_t properties)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>gras_userdata_get</name>
      <anchorfile>group__GRAS__globals.html</anchorfile>
      <anchor>ga32fe737117c1ab1f3acbfbbce4190fa6</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>gras_userdata_set</name>
      <anchorfile>group__GRAS__globals.html</anchorfile>
      <anchor>ga2dd44669c0da2d976a97cc8e3596d0e0</anchor>
      <arglist>(void *ud)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>GRAS_emul</name>
    <title>Emulation support</title>
    <filename>group__GRAS__emul.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>GRAS_BENCH_ALWAYS_BEGIN</name>
      <anchorfile>group__GRAS__emul.html</anchorfile>
      <anchor>gaf5288e6a4edcbc9e43b576cd75d8a7cc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GRAS_BENCH_ALWAYS_END</name>
      <anchorfile>group__GRAS__emul.html</anchorfile>
      <anchor>ga565913301f1f31bdb920b6a15cd0c796</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GRAS_BENCH_ONCE_RUN_ALWAYS_BEGIN</name>
      <anchorfile>group__GRAS__emul.html</anchorfile>
      <anchor>gabdef676ca890d83cf18cae21d882267a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GRAS_BENCH_ONCE_RUN_ALWAYS_END</name>
      <anchorfile>group__GRAS__emul.html</anchorfile>
      <anchor>gad0867810b5e25399c38b022db7b50804</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GRAS_BENCH_ONCE_RUN_ONCE_BEGIN</name>
      <anchorfile>group__GRAS__emul.html</anchorfile>
      <anchor>ga8e1dfbcab4676d56607bd7b3de2f06a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>GRAS_BENCH_ONCE_RUN_ONCE_END</name>
      <anchorfile>group__GRAS__emul.html</anchorfile>
      <anchor>gacf85af9c1eb78c13fcaff234129bc90d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>gras_if_RL</name>
      <anchorfile>group__GRAS__emul.html</anchorfile>
      <anchor>ga7536bfeabf829c3af4e4bbd062ae68a5</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>gras_if_SG</name>
      <anchorfile>group__GRAS__emul.html</anchorfile>
      <anchor>ga9fc0d36a51aa4cbaf7e3ec50c0e54431</anchor>
      <arglist>(void)</arglist>
    </member>
    <docanchor file="group__GRAS__emul">GRAS_emul_virtualization</docanchor>
    <docanchor file="group__GRAS__emul">GRAS_emul_timing</docanchor>
  </compound>
  <compound kind="group">
    <name>GRAS_virtu</name>
    <title>Syscalls</title>
    <filename>group__GRAS__virtu.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>gras_os_time</name>
      <anchorfile>group__GRAS__virtu.html</anchorfile>
      <anchor>ga690fb7390ae0f7a8622dd36c4f2854ce</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>gras_os_sleep</name>
      <anchorfile>group__GRAS__virtu.html</anchorfile>
      <anchor>ga759c02d11cdd774f4c2c3ce0a7aa876c</anchor>
      <arglist>(sec)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>gras_os_myname</name>
      <anchorfile>group__GRAS__virtu.html</anchorfile>
      <anchor>gaa69615408108cd37c02ece6942419037</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>gras_os_myport</name>
      <anchorfile>group__GRAS__virtu.html</anchorfile>
      <anchor>ga698d1a1611cb1a88ff59c4d81d471c1a</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>gras_os_hostport</name>
      <anchorfile>group__GRAS__virtu.html</anchorfile>
      <anchor>ga95df45ae7ca3f51b880e48ba92fd32e7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>gras_os_getpid</name>
      <anchorfile>group__GRAS__virtu.html</anchorfile>
      <anchor>ga19eab254893273bc41d1a1db30cf4d80</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dict_t</type>
      <name>gras_process_properties</name>
      <anchorfile>group__GRAS__virtu.html</anchorfile>
      <anchor>ga8a51ce2b1ea4d27a023ae9afacced2c9</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>gras_process_property_value</name>
      <anchorfile>group__GRAS__virtu.html</anchorfile>
      <anchor>gad612739673c7c153741b117c0ace75b1</anchor>
      <arglist>(const char *name)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dict_t</type>
      <name>gras_os_host_properties</name>
      <anchorfile>group__GRAS__virtu.html</anchorfile>
      <anchor>ga86a3de9cbbf171a8528679effae5f713</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>gras_os_host_property_value</name>
      <anchorfile>group__GRAS__virtu.html</anchorfile>
      <anchor>gaf8f2523b96280e2c42af6df8b16f961e</anchor>
      <arglist>(const char *name)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>AMOK_bw</name>
    <title>Bandwidth</title>
    <filename>group__AMOK__bw.html</filename>
    <member kind="function">
      <type>void</type>
      <name>amok_bw_init</name>
      <anchorfile>group__AMOK__bw.html</anchorfile>
      <anchor>ga1d9b3605e503ec3b21d1758c5e8d112e</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>amok_bw_exit</name>
      <anchorfile>group__AMOK__bw.html</anchorfile>
      <anchor>ga93f1ff0879c7285c421a0e5b7167231a</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>amok_bw_test</name>
      <anchorfile>group__AMOK__bw.html</anchorfile>
      <anchor>ga6c2a98957e14b6bfcf85a2d6f0af0b99</anchor>
      <arglist>(xbt_socket_t peer, unsigned long int buf_size, unsigned long int msg_size, unsigned long int msg_amount, double min_duration, double *sec, double *bw)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>amok_bw_request</name>
      <anchorfile>group__AMOK__bw.html</anchorfile>
      <anchor>gaa2c757dbada44a4ae5cebeaf865ae506</anchor>
      <arglist>(const char *from_name, unsigned int from_port, const char *to_name, unsigned int to_port, unsigned long int buf_size, unsigned long int msg_size, unsigned long int msg_amount, double min_duration, double *sec, double *bw)</arglist>
    </member>
    <member kind="function">
      <type>double *</type>
      <name>amok_bw_matrix</name>
      <anchorfile>group__AMOK__bw.html</anchorfile>
      <anchor>ga5bb189513fb6a3c51736fa1099d3b90d</anchor>
      <arglist>(xbt_dynar_t hosts, int buf_size_bw, int msg_size_bw, int msg_amount_bw, double min_duration)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>amok_bw_saturate_start</name>
      <anchorfile>group__AMOK__bw.html</anchorfile>
      <anchor>ga10b58cad9989ba3c854bc76a0e0828f2</anchor>
      <arglist>(const char *from_name, unsigned int from_port, const char *to_name, unsigned int to_port, unsigned int msg_size, double duration)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>amok_bw_saturate_begin</name>
      <anchorfile>group__AMOK__bw.html</anchorfile>
      <anchor>ga7dfba88c734e8b5022ec34e221201281</anchor>
      <arglist>(const char *to_name, unsigned int to_port, unsigned int msg_size, double duration, double *elapsed, double *bw)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>amok_bw_saturate_stop</name>
      <anchorfile>group__AMOK__bw.html</anchorfile>
      <anchor>ga4de46f2b9b19125420a0a2ee9e65a107</anchor>
      <arglist>(const char *from_name, unsigned int from_port, double *time, double *bw)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>AMOK_pm</name>
    <title>Peer Management</title>
    <filename>group__AMOK__pm.html</filename>
    <member kind="function">
      <type>void</type>
      <name>amok_pm_init</name>
      <anchorfile>group__AMOK__pm.html</anchorfile>
      <anchor>gaed462119f2f6b19b2ed40e1be7f0335a</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>amok_pm_exit</name>
      <anchorfile>group__AMOK__pm.html</anchorfile>
      <anchor>ga04b9833b202d77261a75d9b68556188a</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>amok_pm_mainloop</name>
      <anchorfile>group__AMOK__pm.html</anchorfile>
      <anchor>gaedf9cf9552f2e4111bdadcabcbbda1f5</anchor>
      <arglist>(double timeOut)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>amok_pm_kill_hp</name>
      <anchorfile>group__AMOK__pm.html</anchorfile>
      <anchor>ga2be8f4946dbdfaaf0550af6f9051e1a5</anchor>
      <arglist>(char *name, int port)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>amok_pm_kill</name>
      <anchorfile>group__AMOK__pm.html</anchorfile>
      <anchor>ga6cac965bd11e5c468f169ca3bcaaaa8e</anchor>
      <arglist>(xbt_socket_t buddy)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>amok_pm_kill_sync</name>
      <anchorfile>group__AMOK__pm.html</anchorfile>
      <anchor>ga6d2e69b1db096e39f9c73ebe1f6c929c</anchor>
      <arglist>(xbt_socket_t buddy)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dynar_t</type>
      <name>amok_pm_group_new</name>
      <anchorfile>group__AMOK__pm.html</anchorfile>
      <anchor>ga7fb9d82b0c9ec0b2edcc32dfb6c93be0</anchor>
      <arglist>(const char *group_name)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dynar_t</type>
      <name>amok_pm_group_get</name>
      <anchorfile>group__AMOK__pm.html</anchorfile>
      <anchor>gafb74e776c3e5ad6d1e48ee3953ee659f</anchor>
      <arglist>(xbt_socket_t master, const char *group_name)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>amok_pm_group_join</name>
      <anchorfile>group__AMOK__pm.html</anchorfile>
      <anchor>gac1f63273d15168041792b1196a15dd62</anchor>
      <arglist>(xbt_socket_t master, const char *group_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>amok_pm_group_leave</name>
      <anchorfile>group__AMOK__pm.html</anchorfile>
      <anchor>gac3951c4fd6f2791ac52e751470ebe186</anchor>
      <arglist>(xbt_socket_t master, const char *group_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>amok_pm_group_shutdown</name>
      <anchorfile>group__AMOK__pm.html</anchorfile>
      <anchor>ga52ff73f644f73c225a45b50bd7bf2ca7</anchor>
      <arglist>(const char *group_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>amok_pm_group_shutdown_remote</name>
      <anchorfile>group__AMOK__pm.html</anchorfile>
      <anchor>ga71a8af9c1276de6a7b64ec175d3d73f7</anchor>
      <arglist>(xbt_socket_t master, const char *group_name)</arglist>
    </member>
    <docanchor file="group__AMOK__pm">AMOK_pm_compat</docanchor>
  </compound>
  <compound kind="group">
    <name>SD_datatypes_management</name>
    <title>SD Data Types</title>
    <filename>group__SD__datatypes__management.html</filename>
    <member kind="typedef">
      <type>struct SD_workstation *</type>
      <name>SD_workstation_t</name>
      <anchorfile>group__SD__datatypes__management.html</anchorfile>
      <anchor>gaeae4130240138543efa9f414ef09173b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct SD_link *</type>
      <name>SD_link_t</name>
      <anchorfile>group__SD__datatypes__management.html</anchorfile>
      <anchor>ga0b4ef9c55c15ac2612409087d89d8415</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct SD_task *</type>
      <name>SD_task_t</name>
      <anchorfile>group__SD__datatypes__management.html</anchorfile>
      <anchor>gabe39904e3bf5f57456382cfcd3814352</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>e_SD_workstation_access_mode_t</name>
      <anchorfile>group__SD__datatypes__management.html</anchorfile>
      <anchor>ga6eb21649841a9b045552f3aa810e05f5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SD_WORKSTATION_SHARED_ACCESS</name>
      <anchorfile>group__SD__datatypes__management.html</anchorfile>
      <anchor>gga6eb21649841a9b045552f3aa810e05f5a6615a65c696b373eef6500a7b8f43c4e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SD_WORKSTATION_SEQUENTIAL_ACCESS</name>
      <anchorfile>group__SD__datatypes__management.html</anchorfile>
      <anchor>gga6eb21649841a9b045552f3aa810e05f5a722f0fd2ff6e52a77206f879e50714df</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>e_SD_task_state_t</name>
      <anchorfile>group__SD__datatypes__management.html</anchorfile>
      <anchor>ga49c04f3f117a8a1f8f1d0bedadefcfa5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SD_NOT_SCHEDULED</name>
      <anchorfile>group__SD__datatypes__management.html</anchorfile>
      <anchor>gga49c04f3f117a8a1f8f1d0bedadefcfa5aec1d4dfae04f63ec58dd8ab7941a8801</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SD_SCHEDULABLE</name>
      <anchorfile>group__SD__datatypes__management.html</anchorfile>
      <anchor>gga49c04f3f117a8a1f8f1d0bedadefcfa5a2c3f70794cc8b27495bd2c7b6b6872af</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SD_SCHEDULED</name>
      <anchorfile>group__SD__datatypes__management.html</anchorfile>
      <anchor>gga49c04f3f117a8a1f8f1d0bedadefcfa5a626549e8ac33c3142d9b3ab66abcc374</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SD_RUNNABLE</name>
      <anchorfile>group__SD__datatypes__management.html</anchorfile>
      <anchor>gga49c04f3f117a8a1f8f1d0bedadefcfa5a4deae4c6080598bd869d22fa4d35328d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SD_IN_FIFO</name>
      <anchorfile>group__SD__datatypes__management.html</anchorfile>
      <anchor>gga49c04f3f117a8a1f8f1d0bedadefcfa5ac055f0cd1ac85271cc31d0340acc8c4c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SD_RUNNING</name>
      <anchorfile>group__SD__datatypes__management.html</anchorfile>
      <anchor>gga49c04f3f117a8a1f8f1d0bedadefcfa5a79dc5ff4b6f36bfae26b9666feb4ba78</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SD_DONE</name>
      <anchorfile>group__SD__datatypes__management.html</anchorfile>
      <anchor>gga49c04f3f117a8a1f8f1d0bedadefcfa5ae654935882dec5b2345a3128aed69632</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SD_FAILED</name>
      <anchorfile>group__SD__datatypes__management.html</anchorfile>
      <anchor>gga49c04f3f117a8a1f8f1d0bedadefcfa5adda3fbec6b0da252275f20c79044201c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>e_SD_task_kind_t</name>
      <anchorfile>group__SD__datatypes__management.html</anchorfile>
      <anchor>ga242a90ba979257e3245553f149b74880</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SD_TASK_NOT_TYPED</name>
      <anchorfile>group__SD__datatypes__management.html</anchorfile>
      <anchor>gga242a90ba979257e3245553f149b74880a8c1896c3c033bea7ecf469a75f83d5f4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SD_TASK_COMM_E2E</name>
      <anchorfile>group__SD__datatypes__management.html</anchorfile>
      <anchor>gga242a90ba979257e3245553f149b74880a9add1089dc99e90c905ec491db980d76</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SD_TASK_COMP_SEQ</name>
      <anchorfile>group__SD__datatypes__management.html</anchorfile>
      <anchor>gga242a90ba979257e3245553f149b74880a3fb8ac37142196af9ac8e97e27f2c59c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SD_TASK_COMP_PAR_AMDAHL</name>
      <anchorfile>group__SD__datatypes__management.html</anchorfile>
      <anchor>gga242a90ba979257e3245553f149b74880a60c8326cd59d07e45a3910594478dba9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SD_TASK_COMM_PAR_MXN_1D_BLOCK</name>
      <anchorfile>group__SD__datatypes__management.html</anchorfile>
      <anchor>gga242a90ba979257e3245553f149b74880a6c7da099fce2770ab770c40a0d32e93d</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>SURF_simulation</name>
    <title>Simulation</title>
    <filename>group__SURF__simulation.html</filename>
    <member kind="function">
      <type>void</type>
      <name>surf_init</name>
      <anchorfile>group__SURF__simulation.html</anchorfile>
      <anchor>ga403868865b66138187c3db30521e1bbe</anchor>
      <arglist>(int *argc, char **argv)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>surf_presolve</name>
      <anchorfile>group__SURF__simulation.html</anchorfile>
      <anchor>ga9b7e7ceba73ff5ce637ecb58f1e2edc9</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>surf_solve</name>
      <anchorfile>group__SURF__simulation.html</anchorfile>
      <anchor>gaa723e3f55eb26355d00de5bf07c6d373</anchor>
      <arglist>(double max_date)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>surf_get_clock</name>
      <anchorfile>group__SURF__simulation.html</anchorfile>
      <anchor>gafa85b9ba47f47d599353b872d2cb93d3</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>surf_exit</name>
      <anchorfile>group__SURF__simulation.html</anchorfile>
      <anchor>ga1179497a5f822209f22b5735e0fb1104</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>SURF_actions</name>
    <title>SURF actions</title>
    <filename>group__SURF__actions.html</filename>
    <class kind="struct">surf_action</class>
    <class kind="struct">surf_action_state</class>
    <member kind="typedef">
      <type>struct surf_action *</type>
      <name>surf_action_t</name>
      <anchorfile>group__SURF__actions.html</anchorfile>
      <anchor>ga260ee2edb62de03ee69190f03a9b7eba</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct surf_action</type>
      <name>s_surf_action_t</name>
      <anchorfile>group__SURF__actions.html</anchorfile>
      <anchor>gae49733011b74942c0a896745bc825e92</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct surf_action_state</type>
      <name>s_surf_action_state_t</name>
      <anchorfile>group__SURF__actions.html</anchorfile>
      <anchor>gafbcc9ab9767482d92f8709d78858d2ae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>e_surf_action_state_t</name>
      <anchorfile>group__SURF__actions.html</anchorfile>
      <anchor>gab9ef4042b1b038be1b792366de0121b2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SURF_ACTION_READY</name>
      <anchorfile>group__SURF__actions.html</anchorfile>
      <anchor>ggab9ef4042b1b038be1b792366de0121b2a6caf5e4bd35cab4890c662fdaf8d3812</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SURF_ACTION_RUNNING</name>
      <anchorfile>group__SURF__actions.html</anchorfile>
      <anchor>ggab9ef4042b1b038be1b792366de0121b2a101d6224ad7c2a615c452c8c36d8a7e7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SURF_ACTION_FAILED</name>
      <anchorfile>group__SURF__actions.html</anchorfile>
      <anchor>ggab9ef4042b1b038be1b792366de0121b2abf420e6385e8eeda58721c3e28bd919e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SURF_ACTION_DONE</name>
      <anchorfile>group__SURF__actions.html</anchorfile>
      <anchor>ggab9ef4042b1b038be1b792366de0121b2acef3187aad961798010f295bbbd932bf</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SURF_ACTION_TO_FREE</name>
      <anchorfile>group__SURF__actions.html</anchorfile>
      <anchor>ggab9ef4042b1b038be1b792366de0121b2aa66f387221d049fbce374c4dc27629c8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SURF_ACTION_NOT_IN_THE_SYSTEM</name>
      <anchorfile>group__SURF__actions.html</anchorfile>
      <anchor>ggab9ef4042b1b038be1b792366de0121b2a20a007bd143ea5c870c26a389ffe95e9</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>SURF_resources</name>
    <title>SURF resources</title>
    <filename>group__SURF__resources.html</filename>
  </compound>
  <compound kind="group">
    <name>SURF_build_api</name>
    <title>Create a new API</title>
    <filename>group__SURF__build__api.html</filename>
    <member kind="variable">
      <type>xbt_lib_t</type>
      <name>host_lib</name>
      <anchorfile>group__SURF__build__api.html</anchorfile>
      <anchor>gac90f96dce1a69464b09a9b79b1405da5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>xbt_lib_t</type>
      <name>link_lib</name>
      <anchorfile>group__SURF__build__api.html</anchorfile>
      <anchor>gaa55c4d6b7466ca2b40deef1f47a24063</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>m_datatypes_management_details</name>
    <title>SIMIX datatypes management details</title>
    <filename>group__m__datatypes__management__details.html</filename>
  </compound>
  <compound kind="group">
    <name>simix_process_management</name>
    <title>Process Management Functions</title>
    <filename>group__simix__process__management.html</filename>
    <member kind="function">
      <type>void</type>
      <name>simcall_process_create</name>
      <anchorfile>group__simix__process__management.html</anchorfile>
      <anchor>gaf19a836d7ea387f1526fc48231726dc9</anchor>
      <arglist>(smx_process_t *process, const char *name, xbt_main_func_t code, void *data, const char *hostname, double kill_time, int argc, char **argv, xbt_dict_t properties, int auto_restart)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>simcall_process_kill</name>
      <anchorfile>group__simix__process__management.html</anchorfile>
      <anchor>ga2fd1c21b67cdf31506f5cd2a94d91313</anchor>
      <arglist>(smx_process_t process)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>simcall_process_killall</name>
      <anchorfile>group__simix__process__management.html</anchorfile>
      <anchor>ga22b0556e0d053615b459e235b7f5ca00</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>simcall_process_cleanup</name>
      <anchorfile>group__simix__process__management.html</anchorfile>
      <anchor>gabbc2bb1e3346602a7e7ce8af2f9963b0</anchor>
      <arglist>(smx_process_t process)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>simcall_process_change_host</name>
      <anchorfile>group__simix__process__management.html</anchorfile>
      <anchor>gab10c8ebfd02973f5556bada2bb0a2915</anchor>
      <arglist>(smx_process_t process, smx_host_t dest)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>simcall_process_suspend</name>
      <anchorfile>group__simix__process__management.html</anchorfile>
      <anchor>ga9fdb4fa34e26498e410db9794f0fe1a7</anchor>
      <arglist>(smx_process_t process)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>simcall_process_resume</name>
      <anchorfile>group__simix__process__management.html</anchorfile>
      <anchor>ga2e9bb138e7ba7f7e588cb662be3b1757</anchor>
      <arglist>(smx_process_t process)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>simcall_process_count</name>
      <anchorfile>group__simix__process__management.html</anchorfile>
      <anchor>gae7ec2e782070e190356478e8c88a0cc5</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>simcall_process_get_data</name>
      <anchorfile>group__simix__process__management.html</anchorfile>
      <anchor>ga3ef2cbb5679f4f103f1d56b0e4e74f6b</anchor>
      <arglist>(smx_process_t process)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>simcall_process_set_data</name>
      <anchorfile>group__simix__process__management.html</anchorfile>
      <anchor>ga18c58debc643922bf68b5d8de563e4c5</anchor>
      <arglist>(smx_process_t process, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>simcall_process_set_kill_time</name>
      <anchorfile>group__simix__process__management.html</anchorfile>
      <anchor>gac55e617472e645926ca1cdcea8533508</anchor>
      <arglist>(smx_process_t process, double kill_time)</arglist>
    </member>
    <member kind="function">
      <type>smx_host_t</type>
      <name>simcall_process_get_host</name>
      <anchorfile>group__simix__process__management.html</anchorfile>
      <anchor>gada27408ad1425a1a1f94e8d9dbab31ee</anchor>
      <arglist>(smx_process_t process)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>simcall_process_get_name</name>
      <anchorfile>group__simix__process__management.html</anchorfile>
      <anchor>ga86836c7ddd8864c4662a384014959a76</anchor>
      <arglist>(smx_process_t process)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>simcall_process_is_suspended</name>
      <anchorfile>group__simix__process__management.html</anchorfile>
      <anchor>ga5ba7792648b97d73a68a0472f756bf17</anchor>
      <arglist>(smx_process_t process)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dict_t</type>
      <name>simcall_process_get_properties</name>
      <anchorfile>group__simix__process__management.html</anchorfile>
      <anchor>gad0cdca75425dbbb863121e44b1462612</anchor>
      <arglist>(smx_process_t process)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>simcall_process_on_exit</name>
      <anchorfile>group__simix__process__management.html</anchorfile>
      <anchor>ga3e5f4a672ee15995a110ef2bff287b00</anchor>
      <arglist>(smx_process_t process, int_f_pvoid_t fun, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>simcall_process_auto_restart_set</name>
      <anchorfile>group__simix__process__management.html</anchorfile>
      <anchor>ga433713db62cee73ad3006d2d3eabc702</anchor>
      <arglist>(smx_process_t process, int auto_restart)</arglist>
    </member>
    <member kind="function">
      <type>smx_process_t</type>
      <name>simcall_process_restart</name>
      <anchorfile>group__simix__process__management.html</anchorfile>
      <anchor>gaf4fd76982573c1f58d3eed172ba2d64c</anchor>
      <arglist>(smx_process_t process)</arglist>
    </member>
    <member kind="function">
      <type>e_smx_state_t</type>
      <name>simcall_process_sleep</name>
      <anchorfile>group__simix__process__management.html</anchorfile>
      <anchor>ga7e5cce2d1b8238c587b9e3be60c26b26</anchor>
      <arglist>(double duration)</arglist>
    </member>
    <member kind="typedef">
      <type>struct s_smx_process *</type>
      <name>smx_process_t</name>
      <anchorfile>group__simix__process__management.html</anchorfile>
      <anchor>ga9496f5abef32b4e9d1ef03298d7446e6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>simix_host_management</name>
    <title>Host Management Functions</title>
    <filename>group__simix__host__management.html</filename>
    <member kind="function">
      <type>smx_host_t</type>
      <name>simcall_host_get_by_name</name>
      <anchorfile>group__simix__host__management.html</anchorfile>
      <anchor>ga22bd604a7c15c1980e0ed09281141472</anchor>
      <arglist>(const char *name)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>simcall_host_get_name</name>
      <anchorfile>group__simix__host__management.html</anchorfile>
      <anchor>gac627f752c965060cb592ebda7ff5e8ce</anchor>
      <arglist>(smx_host_t host)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dict_t</type>
      <name>simcall_host_get_properties</name>
      <anchorfile>group__simix__host__management.html</anchorfile>
      <anchor>ga03e97c1154f4925d1fb378d68dd5a888</anchor>
      <arglist>(smx_host_t host)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dict_t</type>
      <name>simcall_asr_get_properties</name>
      <anchorfile>group__simix__host__management.html</anchorfile>
      <anchor>ga1a3288b39aba9f321caca13166518cc0</anchor>
      <arglist>(const char *name)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>simcall_host_get_speed</name>
      <anchorfile>group__simix__host__management.html</anchorfile>
      <anchor>gaa45133ec4a6376f0de1efb4e08746f2c</anchor>
      <arglist>(smx_host_t host)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>simcall_host_get_available_speed</name>
      <anchorfile>group__simix__host__management.html</anchorfile>
      <anchor>gaa93a5302ec2a513b76498b91428fefe2</anchor>
      <arglist>(smx_host_t host)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>simcall_host_get_state</name>
      <anchorfile>group__simix__host__management.html</anchorfile>
      <anchor>ga2683ae7336c84958f9fba0c2a8e502fd</anchor>
      <arglist>(smx_host_t host)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>simcall_host_get_data</name>
      <anchorfile>group__simix__host__management.html</anchorfile>
      <anchor>ga6acb64cfef3e7284442f6e20bee9317d</anchor>
      <arglist>(smx_host_t host)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>simcall_host_set_data</name>
      <anchorfile>group__simix__host__management.html</anchorfile>
      <anchor>ga8201c0350e48d696ef915e4fe668014b</anchor>
      <arglist>(smx_host_t host, void *data)</arglist>
    </member>
    <member kind="function">
      <type>smx_action_t</type>
      <name>simcall_host_execute</name>
      <anchorfile>group__simix__host__management.html</anchorfile>
      <anchor>ga5257c159ed0002779a0d88a1e067bd20</anchor>
      <arglist>(const char *name, smx_host_t host, double computation_amount, double priority)</arglist>
    </member>
    <member kind="function">
      <type>smx_action_t</type>
      <name>simcall_host_parallel_execute</name>
      <anchorfile>group__simix__host__management.html</anchorfile>
      <anchor>ga57ef6dbb3d85979561de1881d3cba1bb</anchor>
      <arglist>(const char *name, int host_nb, smx_host_t *host_list, double *computation_amount, double *communication_amount, double amount, double rate)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>simcall_host_execution_destroy</name>
      <anchorfile>group__simix__host__management.html</anchorfile>
      <anchor>gaf31f9cd17e99f88b734b37a91f25d476</anchor>
      <arglist>(smx_action_t execution)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>simcall_host_execution_cancel</name>
      <anchorfile>group__simix__host__management.html</anchorfile>
      <anchor>gab177e0a327bde207864adbb4abf90e57</anchor>
      <arglist>(smx_action_t execution)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>simcall_host_execution_get_remains</name>
      <anchorfile>group__simix__host__management.html</anchorfile>
      <anchor>ga23839f5acd57bb8d12620d0e1bad56c1</anchor>
      <arglist>(smx_action_t execution)</arglist>
    </member>
    <member kind="function">
      <type>e_smx_state_t</type>
      <name>simcall_host_execution_get_state</name>
      <anchorfile>group__simix__host__management.html</anchorfile>
      <anchor>ga66026abb4f24bd3a528a9bcc41200c4f</anchor>
      <arglist>(smx_action_t execution)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>simcall_host_execution_set_priority</name>
      <anchorfile>group__simix__host__management.html</anchorfile>
      <anchor>ga3df7d10c87185d6c03c90cfa3b62cc43</anchor>
      <arglist>(smx_action_t execution, double priority)</arglist>
    </member>
    <member kind="function">
      <type>e_smx_state_t</type>
      <name>simcall_host_execution_wait</name>
      <anchorfile>group__simix__host__management.html</anchorfile>
      <anchor>ga8760a71314f39b57eafca4782251369f</anchor>
      <arglist>(smx_action_t execution)</arglist>
    </member>
    <member kind="typedef">
      <type>struct s_smx_host *</type>
      <name>smx_host_t</name>
      <anchorfile>group__simix__host__management.html</anchorfile>
      <anchor>ga94e127b19ef1ae4659d9cd7c45e32db7</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>simix_rdv_management</name>
    <title>RDV Management Functions</title>
    <filename>group__simix__rdv__management.html</filename>
    <member kind="function">
      <type>smx_rdv_t</type>
      <name>simcall_rdv_create</name>
      <anchorfile>group__simix__rdv__management.html</anchorfile>
      <anchor>ga76202b8bd49aa89a5427267cb4528636</anchor>
      <arglist>(const char *name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>simcall_rdv_destroy</name>
      <anchorfile>group__simix__rdv__management.html</anchorfile>
      <anchor>ga9e244ad91daf47c0e9b45b004dd6e3d6</anchor>
      <arglist>(smx_rdv_t rdv)</arglist>
    </member>
    <member kind="function">
      <type>smx_rdv_t</type>
      <name>simcall_rdv_get_by_name</name>
      <anchorfile>group__simix__rdv__management.html</anchorfile>
      <anchor>ga417b16e55a7b5fad902bde9b9f263ead</anchor>
      <arglist>(const char *name)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>simcall_rdv_comm_count_by_host</name>
      <anchorfile>group__simix__rdv__management.html</anchorfile>
      <anchor>ga3be3b0b7647b63da38063e9df674f29e</anchor>
      <arglist>(smx_rdv_t rdv, smx_host_t host)</arglist>
    </member>
    <member kind="function">
      <type>smx_action_t</type>
      <name>simcall_rdv_get_head</name>
      <anchorfile>group__simix__rdv__management.html</anchorfile>
      <anchor>ga79a92d3223cd9d41ba694044d3f308ac</anchor>
      <arglist>(smx_rdv_t rdv)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>simix_comm_management</name>
    <title>Communication Management Functions</title>
    <filename>group__simix__comm__management.html</filename>
  </compound>
  <compound kind="group">
    <name>simix_synchro_management</name>
    <title>Synchronisation Management Functions</title>
    <filename>group__simix__synchro__management.html</filename>
  </compound>
  <compound kind="group">
    <name>simix_file_management</name>
    <title>File Management Functions</title>
    <filename>group__simix__file__management.html</filename>
  </compound>
  <compound kind="group">
    <name>TRACE_category</name>
    <title>Tracing categories</title>
    <filename>group__TRACE__category.html</filename>
    <member kind="function">
      <type>void</type>
      <name>TRACE_category</name>
      <anchorfile>group__TRACE__category.html</anchorfile>
      <anchor>ga2c341df9553b432c507d4ab2a87e8685</anchor>
      <arglist>(const char *category)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_category_with_color</name>
      <anchorfile>group__TRACE__category.html</anchorfile>
      <anchor>ga5abe9661fe1a1382c9be63984fea6931</anchor>
      <arglist>(const char *category, const char *color)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dynar_t</type>
      <name>TRACE_get_categories</name>
      <anchorfile>group__TRACE__category.html</anchorfile>
      <anchor>ga87115c4173e0a6451fd7161fa4545572</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>TRACE_mark</name>
    <title>Tracing marks</title>
    <filename>group__TRACE__mark.html</filename>
    <member kind="function">
      <type>void</type>
      <name>TRACE_declare_mark</name>
      <anchorfile>group__TRACE__mark.html</anchorfile>
      <anchor>gacd215a0072a5d4ec7c5b11610b7bef20</anchor>
      <arglist>(const char *mark_type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_declare_mark_value_with_color</name>
      <anchorfile>group__TRACE__mark.html</anchorfile>
      <anchor>gae5b5c2eab1fdca9122a8902f1f106649</anchor>
      <arglist>(const char *mark_type, const char *mark_value, const char *mark_color)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_declare_mark_value</name>
      <anchorfile>group__TRACE__mark.html</anchorfile>
      <anchor>ga01bdd85d46330578010dd77cf0e9df88</anchor>
      <arglist>(const char *mark_type, const char *mark_value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_mark</name>
      <anchorfile>group__TRACE__mark.html</anchorfile>
      <anchor>gac8f263e9033090c2e73c7a2e2a98088a</anchor>
      <arglist>(const char *mark_type, const char *mark_value)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dynar_t</type>
      <name>TRACE_get_marks</name>
      <anchorfile>group__TRACE__mark.html</anchorfile>
      <anchor>ga6012125dd57ddf958895a8007280bbf5</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>TRACE_user_variables</name>
    <title>Tracing user variables</title>
    <filename>group__TRACE__user__variables.html</filename>
    <member kind="function">
      <type>void</type>
      <name>TRACE_host_variable_declare</name>
      <anchorfile>group__TRACE__user__variables.html</anchorfile>
      <anchor>ga1672865b1bc48cff5bdb759edf0a7c90</anchor>
      <arglist>(const char *variable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_host_variable_declare_with_color</name>
      <anchorfile>group__TRACE__user__variables.html</anchorfile>
      <anchor>gaacaaa40fa93265cc87dc804edb6a61b3</anchor>
      <arglist>(const char *variable, const char *color)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_host_variable_set</name>
      <anchorfile>group__TRACE__user__variables.html</anchorfile>
      <anchor>ga650d08f8e0547ffe3d3c5a6a6ceebcdf</anchor>
      <arglist>(const char *host, const char *variable, double value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_host_variable_add</name>
      <anchorfile>group__TRACE__user__variables.html</anchorfile>
      <anchor>gae0a8625485d9cffc5c12676b65cd959c</anchor>
      <arglist>(const char *host, const char *variable, double value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_host_variable_sub</name>
      <anchorfile>group__TRACE__user__variables.html</anchorfile>
      <anchor>ga287fcd04c563ff2f795460850e4fc5d6</anchor>
      <arglist>(const char *host, const char *variable, double value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_host_variable_set_with_time</name>
      <anchorfile>group__TRACE__user__variables.html</anchorfile>
      <anchor>ga3adacb71a4ab331c93efdf250f73cbfc</anchor>
      <arglist>(double time, const char *host, const char *variable, double value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_host_variable_add_with_time</name>
      <anchorfile>group__TRACE__user__variables.html</anchorfile>
      <anchor>gab6e7856a8181341e524cb4c9920c24ba</anchor>
      <arglist>(double time, const char *host, const char *variable, double value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_host_variable_sub_with_time</name>
      <anchorfile>group__TRACE__user__variables.html</anchorfile>
      <anchor>gae9ab3b84945d21bd06529d6705471d65</anchor>
      <arglist>(double time, const char *host, const char *variable, double value)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dynar_t</type>
      <name>TRACE_get_host_variables</name>
      <anchorfile>group__TRACE__user__variables.html</anchorfile>
      <anchor>ga421836b9a1d435300ff777cd04b68f4c</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_link_variable_declare</name>
      <anchorfile>group__TRACE__user__variables.html</anchorfile>
      <anchor>ga0b79340b330704fc7f30596988ce937c</anchor>
      <arglist>(const char *variable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_link_variable_declare_with_color</name>
      <anchorfile>group__TRACE__user__variables.html</anchorfile>
      <anchor>ga1c3d1a22e56a7a9a2fa6e5e6feb7978e</anchor>
      <arglist>(const char *variable, const char *color)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_link_variable_set</name>
      <anchorfile>group__TRACE__user__variables.html</anchorfile>
      <anchor>ga5a521dffa1a5705e9e65d77053ef0cfa</anchor>
      <arglist>(const char *link, const char *variable, double value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_link_variable_add</name>
      <anchorfile>group__TRACE__user__variables.html</anchorfile>
      <anchor>gabbc55f2a3e25e49248be7d9b71f15cb8</anchor>
      <arglist>(const char *link, const char *variable, double value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_link_variable_sub</name>
      <anchorfile>group__TRACE__user__variables.html</anchorfile>
      <anchor>ga009ecbc92025f7f2106386e5c8822e0b</anchor>
      <arglist>(const char *link, const char *variable, double value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_link_variable_set_with_time</name>
      <anchorfile>group__TRACE__user__variables.html</anchorfile>
      <anchor>gaccafa87e0e58f2f3e282a7d23e56d792</anchor>
      <arglist>(double time, const char *link, const char *variable, double value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_link_variable_add_with_time</name>
      <anchorfile>group__TRACE__user__variables.html</anchorfile>
      <anchor>ga139bde27fec64c468d16b5231fc41118</anchor>
      <arglist>(double time, const char *link, const char *variable, double value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_link_variable_sub_with_time</name>
      <anchorfile>group__TRACE__user__variables.html</anchorfile>
      <anchor>gae6b2b2b1f2ad80588d5b4eccb7d5ab6c</anchor>
      <arglist>(double time, const char *link, const char *variable, double value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_link_srcdst_variable_set</name>
      <anchorfile>group__TRACE__user__variables.html</anchorfile>
      <anchor>gab93d0d4ffb907c4d4b43cdc53cbe4f8c</anchor>
      <arglist>(const char *src, const char *dst, const char *variable, double value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_link_srcdst_variable_add</name>
      <anchorfile>group__TRACE__user__variables.html</anchorfile>
      <anchor>gae19a0f01ea6240ceaba534dab0f15919</anchor>
      <arglist>(const char *src, const char *dst, const char *variable, double value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_link_srcdst_variable_sub</name>
      <anchorfile>group__TRACE__user__variables.html</anchorfile>
      <anchor>gaa0af1adaf2ee2e0ea3b045e8ef5c4edf</anchor>
      <arglist>(const char *src, const char *dst, const char *variable, double value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_link_srcdst_variable_set_with_time</name>
      <anchorfile>group__TRACE__user__variables.html</anchorfile>
      <anchor>ga1abd4aeafd36e40fd2aa8f15566df013</anchor>
      <arglist>(double time, const char *src, const char *dst, const char *variable, double value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_link_srcdst_variable_add_with_time</name>
      <anchorfile>group__TRACE__user__variables.html</anchorfile>
      <anchor>ga0fec5f8d16e8d8ba4c82b2dba1ba6234</anchor>
      <arglist>(double time, const char *src, const char *dst, const char *variable, double value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_link_srcdst_variable_sub_with_time</name>
      <anchorfile>group__TRACE__user__variables.html</anchorfile>
      <anchor>ga37278937e06f41f0a0b06b6b91bbdfa6</anchor>
      <arglist>(double time, const char *src, const char *dst, const char *variable, double value)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dynar_t</type>
      <name>TRACE_get_link_variables</name>
      <anchorfile>group__TRACE__user__variables.html</anchorfile>
      <anchor>ga4b07c188420bbc143deea8dcdce06642</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_host_state_declare</name>
      <anchorfile>group__TRACE__user__variables.html</anchorfile>
      <anchor>ga65a9ce22195518352da785b36527864d</anchor>
      <arglist>(const char *state)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_host_state_declare_value</name>
      <anchorfile>group__TRACE__user__variables.html</anchorfile>
      <anchor>gae5c66eb6918e75c5f38e06727d43e7bc</anchor>
      <arglist>(const char *state, const char *value, const char *color)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_host_set_state</name>
      <anchorfile>group__TRACE__user__variables.html</anchorfile>
      <anchor>gacc421a6483570671a916a1d402add564</anchor>
      <arglist>(const char *host, const char *state, const char *value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_host_push_state</name>
      <anchorfile>group__TRACE__user__variables.html</anchorfile>
      <anchor>gab74f50cb9ed31f4436663acd34ed044a</anchor>
      <arglist>(const char *host, const char *state, const char *value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_host_pop_state</name>
      <anchorfile>group__TRACE__user__variables.html</anchorfile>
      <anchor>ga111dc1b94c7f69e999f98163922332a6</anchor>
      <arglist>(const char *host, const char *state)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>TRACE_host_reset_state</name>
      <anchorfile>group__TRACE__user__variables.html</anchorfile>
      <anchor>ga995ecd02343b09fd5ecdce8b8b1cd0d7</anchor>
      <arglist>(const char *host, const char *state)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>API_index</name>
    <title>Full Index</title>
    <filename>group__API__index.html</filename>
  </compound>
  <compound kind="group">
    <name>GRAS_msg_decl</name>
    <title>Message declaration and retrival</title>
    <filename>group__GRAS__msg__decl.html</filename>
    <member kind="typedef">
      <type>struct s_gras_msgtype *</type>
      <name>gras_msgtype_t</name>
      <anchorfile>group__GRAS__msg__decl.html</anchorfile>
      <anchor>ga3dde338b0ab6736d2d6c51078c03bd96</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gras_msgtype_declare</name>
      <anchorfile>group__GRAS__msg__decl.html</anchorfile>
      <anchor>ga7857c6d519073e49604d59fa957bdc4d</anchor>
      <arglist>(const char *name, xbt_datadesc_type_t payload)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gras_msgtype_declare_v</name>
      <anchorfile>group__GRAS__msg__decl.html</anchorfile>
      <anchor>ga64643f72bc46f7a40244d64a2977956b</anchor>
      <arglist>(const char *name, short int version, xbt_datadesc_type_t payload)</arglist>
    </member>
    <member kind="function">
      <type>gras_msgtype_t</type>
      <name>gras_msgtype_by_name</name>
      <anchorfile>group__GRAS__msg__decl.html</anchorfile>
      <anchor>gaeffd42d9b2606a8b19501bd191efd6b4</anchor>
      <arglist>(const char *name)</arglist>
    </member>
    <member kind="function">
      <type>gras_msgtype_t</type>
      <name>gras_msgtype_by_name_or_null</name>
      <anchorfile>group__GRAS__msg__decl.html</anchorfile>
      <anchor>ga169be5759644b6ce19e35ae736b79345</anchor>
      <arglist>(const char *name)</arglist>
    </member>
    <member kind="function">
      <type>gras_msgtype_t</type>
      <name>gras_msgtype_by_namev</name>
      <anchorfile>group__GRAS__msg__decl.html</anchorfile>
      <anchor>ga674feae414ddeef58edc7f4597a0dd80</anchor>
      <arglist>(const char *name, short int version)</arglist>
    </member>
    <member kind="function">
      <type>gras_msgtype_t</type>
      <name>gras_msgtype_by_id</name>
      <anchorfile>group__GRAS__msg__decl.html</anchorfile>
      <anchor>ga01e5352457b7ba0d9504c3bf25367d16</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gras_msgtype_dumpall</name>
      <anchorfile>group__GRAS__msg__decl.html</anchorfile>
      <anchor>ga5b7341eb7a6a5a5a827b21cb23e09248</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>GRAS_msg_cb</name>
    <title>Callback declaration and use</title>
    <filename>group__GRAS__msg__cb.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>gras_cb_register</name>
      <anchorfile>group__GRAS__msg__cb.html</anchorfile>
      <anchor>gada679e069d5516d632542a963a5e921c</anchor>
      <arglist>(msgtype_name, cb)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>gras_cb_unregister</name>
      <anchorfile>group__GRAS__msg__cb.html</anchorfile>
      <anchor>ga56559a8e94aa53115e16c5d42d052c79</anchor>
      <arglist>(msgtype_name, cb)</arglist>
    </member>
    <member kind="typedef">
      <type>struct s_gras_msg_cb_ctx *</type>
      <name>gras_msg_cb_ctx_t</name>
      <anchorfile>group__GRAS__msg__cb.html</anchorfile>
      <anchor>gac198167fc3b407c9a5d13104944bd1eb</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int(*</type>
      <name>gras_msg_cb_t</name>
      <anchorfile>group__GRAS__msg__cb.html</anchorfile>
      <anchor>ga4def53ea1c94af2e6ebec7b058fd5e17</anchor>
      <arglist>)(gras_msg_cb_ctx_t ctx, void *payload)</arglist>
    </member>
    <member kind="function">
      <type>xbt_socket_t</type>
      <name>gras_msg_cb_ctx_from</name>
      <anchorfile>group__GRAS__msg__cb.html</anchorfile>
      <anchor>ga06d07c39a4ab161ef6307f5b947f7687</anchor>
      <arglist>(gras_msg_cb_ctx_t ctx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gras_cb_register_</name>
      <anchorfile>group__GRAS__msg__cb.html</anchorfile>
      <anchor>ga18ec958edecee152b5c7227a062556b7</anchor>
      <arglist>(gras_msgtype_t msgtype, gras_msg_cb_t cb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gras_cb_unregister_</name>
      <anchorfile>group__GRAS__msg__cb.html</anchorfile>
      <anchor>ga0dbe20c04bc541c025115b42cab5a8b5</anchor>
      <arglist>(gras_msgtype_t msgtype, gras_msg_cb_t cb)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>GRAS_msg_exchange</name>
    <title>Message exchange</title>
    <filename>group__GRAS__msg__exchange.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>gras_msg_send</name>
      <anchorfile>group__GRAS__msg__exchange.html</anchorfile>
      <anchor>ga4530e0a98262b6371dc30aa76df1f21a</anchor>
      <arglist>(sock, name, payload)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>gras_msg_wait</name>
      <anchorfile>group__GRAS__msg__exchange.html</anchorfile>
      <anchor>ga9ec85c89a6e59334939d4483c2e04374</anchor>
      <arglist>(timeout, msgt_want, expeditor, payload)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gras_msg_send_</name>
      <anchorfile>group__GRAS__msg__exchange.html</anchorfile>
      <anchor>ga67984c86652a02a790c3833dbcc821e2</anchor>
      <arglist>(xbt_socket_t sock, gras_msgtype_t msgtype, void *payload)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gras_msg_wait_</name>
      <anchorfile>group__GRAS__msg__exchange.html</anchorfile>
      <anchor>ga514adfffdfb2117532be23878ba7a04e</anchor>
      <arglist>(double timeout, gras_msgtype_t msgt_want, xbt_socket_t *expeditor, void *payload)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gras_msg_handleall</name>
      <anchorfile>group__GRAS__msg__exchange.html</anchorfile>
      <anchor>gae4bf51c90fd4f84a66f9e1f44fe1dac5</anchor>
      <arglist>(double period)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gras_msg_handle</name>
      <anchorfile>group__GRAS__msg__exchange.html</anchorfile>
      <anchor>ga734f74309ee66358e60f6926084e46c5</anchor>
      <arglist>(double timeOut)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>GRAS_msg_rpc</name>
    <title>RPC specific functions</title>
    <filename>group__GRAS__msg__rpc.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>gras_msg_rpccall</name>
      <anchorfile>group__GRAS__msg__rpc.html</anchorfile>
      <anchor>ga5a63b79b8d8af705c8bdf7ef2b40dfd0</anchor>
      <arglist>(server, timeout, msg, req, ans)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>gras_msg_rpc_async_call</name>
      <anchorfile>group__GRAS__msg__rpc.html</anchorfile>
      <anchor>ga36a36ad46c0ccdab7e512c65c3c7276c</anchor>
      <arglist>(server, timeout, msg, req)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gras_msgtype_declare_rpc</name>
      <anchorfile>group__GRAS__msg__rpc.html</anchorfile>
      <anchor>gaf53fe8f369590ea67e56880d46e32b35</anchor>
      <arglist>(const char *name, xbt_datadesc_type_t payload_request, xbt_datadesc_type_t payload_answer)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gras_msgtype_declare_rpc_v</name>
      <anchorfile>group__GRAS__msg__rpc.html</anchorfile>
      <anchor>gaa32491ce5b761886d2bb772501114052</anchor>
      <arglist>(const char *name, short int version, xbt_datadesc_type_t payload_request, xbt_datadesc_type_t payload_answer)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gras_msg_rpccall_</name>
      <anchorfile>group__GRAS__msg__rpc.html</anchorfile>
      <anchor>gaacda3b53f080544460ae85116119628c</anchor>
      <arglist>(xbt_socket_t server, double timeOut, gras_msgtype_t msgtype, void *request, void *answer)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>gras_msg_rpc_async_call_</name>
      <anchorfile>group__GRAS__msg__rpc.html</anchorfile>
      <anchor>ga62a3bf4ce9bd90d37730cb860d76e5d9</anchor>
      <arglist>(xbt_socket_t server, double timeOut, gras_msgtype_t msgtype, void *request)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gras_msg_rpc_async_wait</name>
      <anchorfile>group__GRAS__msg__rpc.html</anchorfile>
      <anchor>ga610a80ac29440bc3e4e2383aa3210ddd</anchor>
      <arglist>(gras_msg_cb_ctx_t ctx, void *answer)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gras_msg_rpcreturn</name>
      <anchorfile>group__GRAS__msg__rpc.html</anchorfile>
      <anchor>ga618a3c7ac8ce43b4b1f3cdbaf05789d9</anchor>
      <arglist>(double timeOut, gras_msg_cb_ctx_t ctx, void *answer)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>GRAS_msg_exchangeadv</name>
    <title>Message exchange (advanced interface)</title>
    <filename>group__GRAS__msg__exchangeadv.html</filename>
    <class kind="struct">s_gras_msg_t</class>
    <member kind="enumeration">
      <name>e_gras_msg_kind_t</name>
      <anchorfile>group__GRAS__msg__exchangeadv.html</anchorfile>
      <anchor>gaa618b4aea46cb45d82f44d43dfda5d3f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>e_gras_msg_kind_oneway</name>
      <anchorfile>group__GRAS__msg__exchangeadv.html</anchorfile>
      <anchor>ggaa618b4aea46cb45d82f44d43dfda5d3fa8c1e9f73450086e01bd48c9c7b75667f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>e_gras_msg_kind_rpccall</name>
      <anchorfile>group__GRAS__msg__exchangeadv.html</anchorfile>
      <anchor>ggaa618b4aea46cb45d82f44d43dfda5d3fa7b1f487086684d796b50e5307e2e379b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>e_gras_msg_kind_rpcanswer</name>
      <anchorfile>group__GRAS__msg__exchangeadv.html</anchorfile>
      <anchor>ggaa618b4aea46cb45d82f44d43dfda5d3fa96a7ea9ad35e76121d2aeeb2340600f4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>e_gras_msg_kind_rpcerror</name>
      <anchorfile>group__GRAS__msg__exchangeadv.html</anchorfile>
      <anchor>ggaa618b4aea46cb45d82f44d43dfda5d3fa2a93cb274ce45489193b19620c152060</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gras_msg_wait_ext_</name>
      <anchorfile>group__GRAS__msg__exchangeadv.html</anchorfile>
      <anchor>ga2cd92f12bc72c476438b6bd96f1c9bd5</anchor>
      <arglist>(double timeout, gras_msgtype_t msgt_want, xbt_socket_t expe_want, gras_msg_filter_t filter, void *filter_ctx, gras_msg_t msg_got)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gras_msg_wait_or</name>
      <anchorfile>group__GRAS__msg__exchangeadv.html</anchorfile>
      <anchor>ga8d4ce7267e4057b0001e9ed5f37bde59</anchor>
      <arglist>(double timeout, xbt_dynar_t msgt_want, gras_msg_cb_ctx_t *ctx, int *msgt_got, void *payload)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>GRAS_sock_create</name>
    <title>Socket creation functions</title>
    <filename>group__GRAS__sock__create.html</filename>
    <member kind="function">
      <type>xbt_socket_t</type>
      <name>gras_socket_client</name>
      <anchorfile>group__GRAS__sock__create.html</anchorfile>
      <anchor>ga1dad2be5438de05743501352f144fad5</anchor>
      <arglist>(const char *host, unsigned short port)</arglist>
    </member>
    <member kind="function">
      <type>xbt_socket_t</type>
      <name>gras_socket_client_from_string</name>
      <anchorfile>group__GRAS__sock__create.html</anchorfile>
      <anchor>ga6bd1f0bb2497eed9756b8c9557d27f85</anchor>
      <arglist>(const char *host)</arglist>
    </member>
    <member kind="function">
      <type>xbt_socket_t</type>
      <name>gras_socket_server</name>
      <anchorfile>group__GRAS__sock__create.html</anchorfile>
      <anchor>gafaf3628fe9e0afd023b7c29a167cce75</anchor>
      <arglist>(unsigned short port)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>gras_socket_close</name>
      <anchorfile>group__GRAS__sock__create.html</anchorfile>
      <anchor>gabdbbaf32ef66a8006ceb812393cbe591</anchor>
      <arglist>(xbt_socket_t sd)</arglist>
    </member>
    <member kind="function">
      <type>xbt_socket_t</type>
      <name>gras_socket_client_ext</name>
      <anchorfile>group__GRAS__sock__create.html</anchorfile>
      <anchor>ga33c42cee0950aa1649f4cd1a7a4d48e2</anchor>
      <arglist>(const char *host, unsigned short port, unsigned long int bufSize, int measurement)</arglist>
    </member>
    <member kind="function">
      <type>xbt_socket_t</type>
      <name>gras_socket_server_ext</name>
      <anchorfile>group__GRAS__sock__create.html</anchorfile>
      <anchor>ga3d9e49e5b0d4287926f2d8192868ee90</anchor>
      <arglist>(unsigned short port, unsigned long int bufSize, int measurement)</arglist>
    </member>
    <member kind="function">
      <type>xbt_socket_t</type>
      <name>gras_socket_server_range</name>
      <anchorfile>group__GRAS__sock__create.html</anchorfile>
      <anchor>ga9c81857e1e860a757eb9b8b5c004225c</anchor>
      <arglist>(unsigned short minport, unsigned short maxport, unsigned long int buf_size, int measurement)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>GRAS_sock_file</name>
    <title>Using files as sockets</title>
    <filename>group__GRAS__sock__file.html</filename>
    <member kind="function">
      <type>xbt_socket_t</type>
      <name>gras_socket_client_from_file</name>
      <anchorfile>group__GRAS__sock__file.html</anchorfile>
      <anchor>ga95fd1ae1909dbc2fcd370875cbcd664e</anchor>
      <arglist>(const char *path)</arglist>
    </member>
    <member kind="function">
      <type>xbt_socket_t</type>
      <name>gras_socket_server_from_file</name>
      <anchorfile>group__GRAS__sock__file.html</anchorfile>
      <anchor>gacd1b93d813440fc5c427864682ee7831</anchor>
      <arglist>(const char *path)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_cfg_use</name>
    <title>User interface: changing values</title>
    <filename>group__XBT__cfg__use.html</filename>
    <member kind="typedef">
      <type>void *</type>
      <name>xbt_cfg_t</name>
      <anchorfile>group__XBT__cfg__use.html</anchorfile>
      <anchor>gac5894d3947cb042db07d729ebfe064ca</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cfg_set</name>
      <anchorfile>group__XBT__cfg__use.html</anchorfile>
      <anchor>ga7abcc7c8e0c839f5430ccc5bb04cd29b</anchor>
      <arglist>(xbt_cfg_t cfg, const char *name,...)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cfg_set_vargs</name>
      <anchorfile>group__XBT__cfg__use.html</anchorfile>
      <anchor>gad36ce933af452e3f74373b7a88b097bd</anchor>
      <arglist>(xbt_cfg_t cfg, const char *name, va_list pa)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cfg_set_parse</name>
      <anchorfile>group__XBT__cfg__use.html</anchorfile>
      <anchor>ga660f47d0af70382a502cee9734e32229</anchor>
      <arglist>(xbt_cfg_t cfg, const char *options)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cfg_set_int</name>
      <anchorfile>group__XBT__cfg__use.html</anchorfile>
      <anchor>ga593f941aa66b21104ebdaa2786a0265e</anchor>
      <arglist>(xbt_cfg_t cfg, const char *name, int val)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cfg_set_double</name>
      <anchorfile>group__XBT__cfg__use.html</anchorfile>
      <anchor>ga660807bb21d0d7a3a0ac9219e2330dbe</anchor>
      <arglist>(xbt_cfg_t cfg, const char *name, double val)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cfg_set_string</name>
      <anchorfile>group__XBT__cfg__use.html</anchorfile>
      <anchor>gaf42b4fd31ad45646a03638ef32fc5a26</anchor>
      <arglist>(xbt_cfg_t cfg, const char *name, const char *val)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cfg_set_peer</name>
      <anchorfile>group__XBT__cfg__use.html</anchorfile>
      <anchor>ga3ec95e8fb08cc7dffdc32fd7cb05f679</anchor>
      <arglist>(xbt_cfg_t cfg, const char *name, const char *peer, int port)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cfg_setdefault_int</name>
      <anchorfile>group__XBT__cfg__use.html</anchorfile>
      <anchor>ga56c8db370b0a3ae4c638867a0e0911c0</anchor>
      <arglist>(xbt_cfg_t cfg, const char *name, int val)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cfg_setdefault_double</name>
      <anchorfile>group__XBT__cfg__use.html</anchorfile>
      <anchor>gafa60b1f2d2e1351522f977cce3b54d99</anchor>
      <arglist>(xbt_cfg_t cfg, const char *name, double val)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cfg_setdefault_string</name>
      <anchorfile>group__XBT__cfg__use.html</anchorfile>
      <anchor>ga10751dc480c2ea9b0c9637c68ed359e6</anchor>
      <arglist>(xbt_cfg_t cfg, const char *name, const char *val)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cfg_setdefault_peer</name>
      <anchorfile>group__XBT__cfg__use.html</anchorfile>
      <anchor>ga304c927c166b217d29eee9e18cb1e969</anchor>
      <arglist>(xbt_cfg_t cfg, const char *name, const char *host, int port)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cfg_rm_int</name>
      <anchorfile>group__XBT__cfg__use.html</anchorfile>
      <anchor>ga6dd959a8fc5ea496641f329423964681</anchor>
      <arglist>(xbt_cfg_t cfg, const char *name, int val)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cfg_rm_double</name>
      <anchorfile>group__XBT__cfg__use.html</anchorfile>
      <anchor>gaca2fa14bf75f51960538227132d696d5</anchor>
      <arglist>(xbt_cfg_t cfg, const char *name, double val)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cfg_rm_string</name>
      <anchorfile>group__XBT__cfg__use.html</anchorfile>
      <anchor>ga6b96677e59c03e920f616ef8f6f03db3</anchor>
      <arglist>(xbt_cfg_t cfg, const char *name, const char *val)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cfg_rm_peer</name>
      <anchorfile>group__XBT__cfg__use.html</anchorfile>
      <anchor>ga495c3de5609e29eb4a5a2edaff1e9119</anchor>
      <arglist>(xbt_cfg_t cfg, const char *name, const char *peer, int port)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cfg_rm_at</name>
      <anchorfile>group__XBT__cfg__use.html</anchorfile>
      <anchor>gaf90fa7699759834310e5fc90d4cf2594</anchor>
      <arglist>(xbt_cfg_t cfg, const char *name, int pos)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cfg_empty</name>
      <anchorfile>group__XBT__cfg__use.html</anchorfile>
      <anchor>gabefb42525b7f81c273a9e15ebc2fc401</anchor>
      <arglist>(xbt_cfg_t cfg, const char *name)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_cfg_decl</name>
    <title>Configuration type declaration and memory management</title>
    <filename>group__XBT__cfg__decl.html</filename>
    <member kind="typedef">
      <type>void(*</type>
      <name>xbt_cfg_cb_t</name>
      <anchorfile>group__XBT__cfg__decl.html</anchorfile>
      <anchor>ga4080887ffe36fb58611ee70094c003be</anchor>
      <arglist>)(const char *, int)</arglist>
    </member>
    <member kind="enumeration">
      <name>e_xbt_cfgelm_type_t</name>
      <anchorfile>group__XBT__cfg__decl.html</anchorfile>
      <anchor>gaae016e87dc6935ed51617bbea7b8aa6c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>xbt_cfgelm_int</name>
      <anchorfile>group__XBT__cfg__decl.html</anchorfile>
      <anchor>ggaae016e87dc6935ed51617bbea7b8aa6caf101f0c7af43525d4a07e9bcb5d3b7f2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>xbt_cfgelm_double</name>
      <anchorfile>group__XBT__cfg__decl.html</anchorfile>
      <anchor>ggaae016e87dc6935ed51617bbea7b8aa6ca35412ca92ec3591c76f5403810aed6f3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>xbt_cfgelm_string</name>
      <anchorfile>group__XBT__cfg__decl.html</anchorfile>
      <anchor>ggaae016e87dc6935ed51617bbea7b8aa6cac8df732d454a4bc85379de2c154a737e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>xbt_cfgelm_peer</name>
      <anchorfile>group__XBT__cfg__decl.html</anchorfile>
      <anchor>ggaae016e87dc6935ed51617bbea7b8aa6ca79bd0045369cbc55fe7191a28d31d168</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>xbt_cfg_t</type>
      <name>xbt_cfg_new</name>
      <anchorfile>group__XBT__cfg__decl.html</anchorfile>
      <anchor>ga25f767ddf162fcf5cf45c2aac58f47b8</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cfg_cpy</name>
      <anchorfile>group__XBT__cfg__decl.html</anchorfile>
      <anchor>gac679f68b23823dc08aceaefaf9b372da</anchor>
      <arglist>(xbt_cfg_t tocopy, xbt_cfg_t *whereto)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cfg_free</name>
      <anchorfile>group__XBT__cfg__decl.html</anchorfile>
      <anchor>ga67592bfbe600c89f45f40ceeb7df2c9a</anchor>
      <arglist>(xbt_cfg_t *cfg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cfg_dump</name>
      <anchorfile>group__XBT__cfg__decl.html</anchorfile>
      <anchor>ga9ef64a88e6fa46d78938b32247a29528</anchor>
      <arglist>(const char *name, const char *indent, xbt_cfg_t cfg)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_cfg_register</name>
    <title>Registering stuff</title>
    <filename>group__XBT__cfg__register.html</filename>
    <member kind="function">
      <type>void</type>
      <name>xbt_cfg_register</name>
      <anchorfile>group__XBT__cfg__register.html</anchorfile>
      <anchor>gadfab99b0002e20fc701ca606e784a018</anchor>
      <arglist>(xbt_cfg_t *cfg, const char *name, const char *description, e_xbt_cfgelm_type_t type, void *default_value, int min, int max, xbt_cfg_cb_t cb_set, xbt_cfg_cb_t cb_rm)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cfg_unregister</name>
      <anchorfile>group__XBT__cfg__register.html</anchorfile>
      <anchor>gaec318f1ce663340e84726e5eb88ae81b</anchor>
      <arglist>(xbt_cfg_t cfg, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cfg_register_str</name>
      <anchorfile>group__XBT__cfg__register.html</anchorfile>
      <anchor>ga0dd096bfc41dc388b5d82a670dfe23f7</anchor>
      <arglist>(xbt_cfg_t *cfg, const char *entry)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cfg_help</name>
      <anchorfile>group__XBT__cfg__register.html</anchorfile>
      <anchor>ga20967f829423faa8b91e35978ef46252</anchor>
      <arglist>(xbt_cfg_t cfg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cfg_check</name>
      <anchorfile>group__XBT__cfg__register.html</anchorfile>
      <anchor>ga6c53f538a2901ceca585e075e43e3c3e</anchor>
      <arglist>(xbt_cfg_t cfg)</arglist>
    </member>
    <member kind="function">
      <type>e_xbt_cfgelm_type_t</type>
      <name>xbt_cfg_get_type</name>
      <anchorfile>group__XBT__cfg__register.html</anchorfile>
      <anchor>ga754d4928f875979d3fe3dadbb5c3d32e</anchor>
      <arglist>(xbt_cfg_t cfg, const char *name)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_cfg_get</name>
    <title>Getting the stored values</title>
    <filename>group__XBT__cfg__get.html</filename>
    <member kind="function">
      <type>int</type>
      <name>xbt_cfg_get_int</name>
      <anchorfile>group__XBT__cfg__get.html</anchorfile>
      <anchor>gaf058b35acfe7f058412fece263b9bede</anchor>
      <arglist>(xbt_cfg_t cfg, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>xbt_cfg_get_double</name>
      <anchorfile>group__XBT__cfg__get.html</anchorfile>
      <anchor>ga31012ed478ffd718fafac27b66f653b2</anchor>
      <arglist>(xbt_cfg_t cfg, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>xbt_cfg_get_string</name>
      <anchorfile>group__XBT__cfg__get.html</anchorfile>
      <anchor>ga6e8854c299ca293a8531f3ac477babdd</anchor>
      <arglist>(xbt_cfg_t cfg, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cfg_get_peer</name>
      <anchorfile>group__XBT__cfg__get.html</anchorfile>
      <anchor>gad5690b3e30986f2b43e0fd0a92b3b553</anchor>
      <arglist>(xbt_cfg_t cfg, const char *name, char **peer, int *port)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dynar_t</type>
      <name>xbt_cfg_get_dynar</name>
      <anchorfile>group__XBT__cfg__get.html</anchorfile>
      <anchor>gab69701ad4dbc805b23573f0e4ac02a6f</anchor>
      <arglist>(xbt_cfg_t cfg, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>xbt_cfg_get_int_at</name>
      <anchorfile>group__XBT__cfg__get.html</anchorfile>
      <anchor>gae59bb89c4d59bcc7a47193444369141f</anchor>
      <arglist>(xbt_cfg_t cfg, const char *name, int pos)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>xbt_cfg_get_double_at</name>
      <anchorfile>group__XBT__cfg__get.html</anchorfile>
      <anchor>gab893722f0ee3b17a6fe0ae7534f60d73</anchor>
      <arglist>(xbt_cfg_t cfg, const char *name, int pos)</arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>xbt_cfg_get_string_at</name>
      <anchorfile>group__XBT__cfg__get.html</anchorfile>
      <anchor>ga436a50804f44ad8d4cb7e3b4282c3cf4</anchor>
      <arglist>(xbt_cfg_t cfg, const char *name, int pos)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cfg_get_peer_at</name>
      <anchorfile>group__XBT__cfg__get.html</anchorfile>
      <anchor>ga0555ea640404cc5214c7243e6e91b070</anchor>
      <arglist>(xbt_cfg_t cfg, const char *name, int pos, char **peer, int *port)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_dd_basic</name>
    <title>Basic operations on data descriptions</title>
    <filename>group__XBT__dd__basic.html</filename>
    <member kind="typedef">
      <type>struct s_xbt_datadesc_type *</type>
      <name>xbt_datadesc_type_t</name>
      <anchorfile>group__XBT__dd__basic.html</anchorfile>
      <anchor>gad201506c459504f0a27213aded48730d</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>xbt_datadesc_type_t</type>
      <name>xbt_datadesc_by_name</name>
      <anchorfile>group__XBT__dd__basic.html</anchorfile>
      <anchor>gaf4b2d699b60f60645c04e294337d93cd</anchor>
      <arglist>(const char *name)</arglist>
    </member>
    <member kind="function">
      <type>xbt_datadesc_type_t</type>
      <name>xbt_datadesc_by_name_or_null</name>
      <anchorfile>group__XBT__dd__basic.html</anchorfile>
      <anchor>ga2a531cee40b9d62672ace670f531ce94</anchor>
      <arglist>(const char *name)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_dd_auto</name>
    <title>Automatic parsing of data descriptions</title>
    <filename>group__XBT__dd__auto.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>XBT_DEFINE_TYPE</name>
      <anchorfile>group__XBT__dd__auto.html</anchorfile>
      <anchor>ga582dcac822dd60778b8c94de58d4f8b2</anchor>
      <arglist>(name, def)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>XBT_DEFINE_TYPE_EXTERN</name>
      <anchorfile>group__XBT__dd__auto.html</anchorfile>
      <anchor>ga8603e34575afb07e3399e940b29caffc</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>XBT_DEFINE_TYPE_LOCAL</name>
      <anchorfile>group__XBT__dd__auto.html</anchorfile>
      <anchor>gafdbc20cdd4b241eb9b560fb7ba715a5e</anchor>
      <arglist>(name, def)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>xbt_datadesc_by_symbol</name>
      <anchorfile>group__XBT__dd__auto.html</anchorfile>
      <anchor>gad252370e735aa0e3074915a638538a73</anchor>
      <arglist>(name)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>XBT_ANNOTE</name>
      <anchorfile>group__XBT__dd__auto.html</anchorfile>
      <anchor>gad5f58245365718043c805436acafcd1b</anchor>
      <arglist>(key, val)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_datadesc_set_const</name>
      <anchorfile>group__XBT__dd__auto.html</anchorfile>
      <anchor>ga3e265dfcbdfeae45b43b46b39e594484</anchor>
      <arglist>(const char *name, int value)</arglist>
    </member>
    <docanchor file="group__XBT__dd__auto">xbt_dd_define</docanchor>
    <docanchor file="group__XBT__dd__auto">XBT_dd_multidim</docanchor>
    <docanchor file="group__XBT__dd__auto">XBT_dd_multifile</docanchor>
  </compound>
  <compound kind="group">
    <name>XBT_dd_manual</name>
    <title>Simple manual data description</title>
    <filename>group__XBT__dd__manual.html</filename>
    <member kind="typedef">
      <type>struct s_xbt_cbps *</type>
      <name>xbt_cbps_t</name>
      <anchorfile>group__XBT__dd__manual.html</anchorfile>
      <anchor>ga3a51060ed7049a956ab9d12a224bbd1f</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>void(*</type>
      <name>xbt_datadesc_type_cb_void_t</name>
      <anchorfile>group__XBT__dd__manual.html</anchorfile>
      <anchor>gaa7427668b318c0f8ca8ca67f471d49fc</anchor>
      <arglist>)(xbt_datadesc_type_t typedesc, xbt_cbps_t vars, void *data)</arglist>
    </member>
    <member kind="typedef">
      <type>int(*</type>
      <name>xbt_datadesc_type_cb_int_t</name>
      <anchorfile>group__XBT__dd__manual.html</anchorfile>
      <anchor>ga16b64d35c0899e0368506c17eb49957f</anchor>
      <arglist>)(xbt_datadesc_type_t typedesc, xbt_cbps_t vars, void *data)</arglist>
    </member>
    <member kind="typedef">
      <type>xbt_datadesc_type_t(*</type>
      <name>xbt_datadesc_selector_t</name>
      <anchorfile>group__XBT__dd__manual.html</anchorfile>
      <anchor>gaf9e432079185cddf94a9ae6f96baa103</anchor>
      <arglist>)(xbt_datadesc_type_t typedesc, xbt_cbps_t vars, void *data)</arglist>
    </member>
    <member kind="function">
      <type>xbt_datadesc_type_t</type>
      <name>xbt_datadesc_struct</name>
      <anchorfile>group__XBT__dd__manual.html</anchorfile>
      <anchor>gaf75f82f979b1b7971a7db551cb15a963</anchor>
      <arglist>(const char *name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_datadesc_struct_append</name>
      <anchorfile>group__XBT__dd__manual.html</anchorfile>
      <anchor>ga9b85aa5ae3699cbb2627f12045046b2a</anchor>
      <arglist>(xbt_datadesc_type_t struct_type, const char *name, xbt_datadesc_type_t field_type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_datadesc_struct_close</name>
      <anchorfile>group__XBT__dd__manual.html</anchorfile>
      <anchor>gaa55fef3826bb7cecd44a779506902362</anchor>
      <arglist>(xbt_datadesc_type_t struct_type)</arglist>
    </member>
    <member kind="function">
      <type>xbt_datadesc_type_t</type>
      <name>xbt_datadesc_union</name>
      <anchorfile>group__XBT__dd__manual.html</anchorfile>
      <anchor>ga11a8790485111d8e0209acfe68d00f1f</anchor>
      <arglist>(const char *name, xbt_datadesc_type_cb_int_t selector)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_datadesc_union_append</name>
      <anchorfile>group__XBT__dd__manual.html</anchorfile>
      <anchor>gaaccd7a5195f2eac5e28f29aad39543a8</anchor>
      <arglist>(xbt_datadesc_type_t union_type, const char *name, xbt_datadesc_type_t field_type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_datadesc_union_close</name>
      <anchorfile>group__XBT__dd__manual.html</anchorfile>
      <anchor>ga111a053bea3c30e3db309e20157b84ac</anchor>
      <arglist>(xbt_datadesc_type_t union_type)</arglist>
    </member>
    <member kind="function">
      <type>xbt_datadesc_type_t</type>
      <name>xbt_datadesc_ref</name>
      <anchorfile>group__XBT__dd__manual.html</anchorfile>
      <anchor>ga653cdcf0625d1f0eb0eb982f05eb7aa1</anchor>
      <arglist>(const char *name, xbt_datadesc_type_t referenced_type)</arglist>
    </member>
    <member kind="function">
      <type>xbt_datadesc_type_t</type>
      <name>xbt_datadesc_copy</name>
      <anchorfile>group__XBT__dd__manual.html</anchorfile>
      <anchor>ga656cdef0ef1a94d69886338aa48cf732</anchor>
      <arglist>(const char *name, xbt_datadesc_type_t copied_type)</arglist>
    </member>
    <member kind="function">
      <type>xbt_datadesc_type_t</type>
      <name>xbt_datadesc_ref_generic</name>
      <anchorfile>group__XBT__dd__manual.html</anchorfile>
      <anchor>gadf51c5c0bcdbcf5288d275516274ee8f</anchor>
      <arglist>(const char *name, xbt_datadesc_selector_t selector)</arglist>
    </member>
    <member kind="function">
      <type>xbt_datadesc_type_t</type>
      <name>xbt_datadesc_array_fixed</name>
      <anchorfile>group__XBT__dd__manual.html</anchorfile>
      <anchor>gaf510d71d8b3b55c07d5adece8a80da17</anchor>
      <arglist>(const char *name, xbt_datadesc_type_t element_type, long int fixed_size)</arglist>
    </member>
    <member kind="function">
      <type>xbt_datadesc_type_t</type>
      <name>xbt_datadesc_array_dyn</name>
      <anchorfile>group__XBT__dd__manual.html</anchorfile>
      <anchor>gaaff88d9b0344325dbbe863050f84c14a</anchor>
      <arglist>(const char *name, xbt_datadesc_type_t element_type, xbt_datadesc_type_cb_int_t dynamic_size)</arglist>
    </member>
    <member kind="function">
      <type>xbt_datadesc_type_t</type>
      <name>xbt_datadesc_ref_pop_arr</name>
      <anchorfile>group__XBT__dd__manual.html</anchorfile>
      <anchor>ga7ba9e0d3c6e7ef82576583947d507138</anchor>
      <arglist>(xbt_datadesc_type_t element_type)</arglist>
    </member>
    <member kind="function">
      <type>xbt_datadesc_type_t</type>
      <name>xbt_datadesc_dynar</name>
      <anchorfile>group__XBT__dd__manual.html</anchorfile>
      <anchor>ga8b6e44623a1831c588409dc824b4fa36</anchor>
      <arglist>(xbt_datadesc_type_t elm_t, void_f_pvoid_t free_func)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_datadesc_cycle_set</name>
      <anchorfile>group__XBT__dd__manual.html</anchorfile>
      <anchor>ga909c5a7089072d87af2f46a21edaf4cf</anchor>
      <arglist>(xbt_datadesc_type_t type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_datadesc_cycle_unset</name>
      <anchorfile>group__XBT__dd__manual.html</anchorfile>
      <anchor>gae2a2d83da317afbdf9466f0f9ff9090b</anchor>
      <arglist>(xbt_datadesc_type_t type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_datadesc_cb_send</name>
      <anchorfile>group__XBT__dd__manual.html</anchorfile>
      <anchor>ga60a592741d03dc571767768f774b299d</anchor>
      <arglist>(xbt_datadesc_type_t type, xbt_datadesc_type_cb_void_t pre)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_datadesc_cb_recv</name>
      <anchorfile>group__XBT__dd__manual.html</anchorfile>
      <anchor>gab26b9ab42ef8ced0aef32a3309792121</anchor>
      <arglist>(xbt_datadesc_type_t type, xbt_datadesc_type_cb_void_t post)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_datadesc_cb_field_send</name>
      <anchorfile>group__XBT__dd__manual.html</anchorfile>
      <anchor>ga7bd02e7b15648f8983d6c72a2b25d962</anchor>
      <arglist>(xbt_datadesc_type_t type, const char *field_name, xbt_datadesc_type_cb_void_t pre)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_datadesc_cb_field_recv</name>
      <anchorfile>group__XBT__dd__manual.html</anchorfile>
      <anchor>gaf63643937275aad57fe4fed88b97571b</anchor>
      <arglist>(xbt_datadesc_type_t type, const char *field_name, xbt_datadesc_type_cb_void_t post)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_datadesc_cb_field_push</name>
      <anchorfile>group__XBT__dd__manual.html</anchorfile>
      <anchor>gac7164024fb65fb115069e7f332489c37</anchor>
      <arglist>(xbt_datadesc_type_t type, const char *field_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_datadesc_cb_field_push_multiplier</name>
      <anchorfile>group__XBT__dd__manual.html</anchorfile>
      <anchor>ga4c981559a5cfc9bb525f64ba8b486dc7</anchor>
      <arglist>(xbt_datadesc_type_t type, const char *field_name)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>xbt_datadesc_get_name</name>
      <anchorfile>group__XBT__dd__manual.html</anchorfile>
      <anchor>ga9a155b7653576fcb8322b49bfc4b577a</anchor>
      <arglist>(xbt_datadesc_type_t ddt)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>xbt_datadesc_get_id</name>
      <anchorfile>group__XBT__dd__manual.html</anchorfile>
      <anchor>ga02ed879c83ec6dc9c99c243f89a535d9</anchor>
      <arglist>(xbt_datadesc_type_t ddt)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_dd_cb_simple</name>
    <title>Data description with Callback Persistant State: Simple push/pop mechanism</title>
    <filename>group__XBT__dd__cb__simple.html</filename>
    <member kind="function">
      <type>void</type>
      <name>xbt_cbps_i_push</name>
      <anchorfile>group__XBT__dd__cb__simple.html</anchorfile>
      <anchor>ga3dd84dfbb6becd7112acbb8523f3fd79</anchor>
      <arglist>(xbt_cbps_t ps, int val)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>xbt_cbps_i_pop</name>
      <anchorfile>group__XBT__dd__cb__simple.html</anchorfile>
      <anchor>gacc7da7574aecc1bf53b858a012397311</anchor>
      <arglist>(xbt_cbps_t ps)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>xbt_datadesc_cb_pop</name>
      <anchorfile>group__XBT__dd__cb__simple.html</anchorfile>
      <anchor>ga465740817b43345fc9c9c0c4085d7016</anchor>
      <arglist>(xbt_datadesc_type_t typedesc, xbt_cbps_t vars, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_datadesc_cb_push_int</name>
      <anchorfile>group__XBT__dd__cb__simple.html</anchorfile>
      <anchor>ga6545b0ef382856115f0c5803b1f054e4</anchor>
      <arglist>(xbt_datadesc_type_t typedesc, xbt_cbps_t vars, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_datadesc_cb_push_uint</name>
      <anchorfile>group__XBT__dd__cb__simple.html</anchorfile>
      <anchor>ga9e6f4c9b54914e98db3d21f82244d22c</anchor>
      <arglist>(xbt_datadesc_type_t typedesc, xbt_cbps_t vars, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_datadesc_cb_push_lint</name>
      <anchorfile>group__XBT__dd__cb__simple.html</anchorfile>
      <anchor>gaccf30925e498ba7147eb756318a925a4</anchor>
      <arglist>(xbt_datadesc_type_t typedesc, xbt_cbps_t vars, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_datadesc_cb_push_ulint</name>
      <anchorfile>group__XBT__dd__cb__simple.html</anchorfile>
      <anchor>gae5bdef15e98af3125c846dcf7188f566</anchor>
      <arglist>(xbt_datadesc_type_t typedesc, xbt_cbps_t vars, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_datadesc_cb_push_int_mult</name>
      <anchorfile>group__XBT__dd__cb__simple.html</anchorfile>
      <anchor>ga0ee280a32ce28ccdedeae2a61ba3a5b0</anchor>
      <arglist>(xbt_datadesc_type_t typedesc, xbt_cbps_t vars, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_datadesc_cb_push_uint_mult</name>
      <anchorfile>group__XBT__dd__cb__simple.html</anchorfile>
      <anchor>gae902804a474a7f7ad03bb5591c8a766d</anchor>
      <arglist>(xbt_datadesc_type_t typedesc, xbt_cbps_t vars, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_datadesc_cb_push_lint_mult</name>
      <anchorfile>group__XBT__dd__cb__simple.html</anchorfile>
      <anchor>gab7285f0b6dce3b1e13aeed378d6a2655</anchor>
      <arglist>(xbt_datadesc_type_t typedesc, xbt_cbps_t vars, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_datadesc_cb_push_ulint_mult</name>
      <anchorfile>group__XBT__dd__cb__simple.html</anchorfile>
      <anchor>ga9af60a3ad5310086d20bd167b610a65b</anchor>
      <arglist>(xbt_datadesc_type_t typedesc, xbt_cbps_t vars, void *data)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_dd_cb_full</name>
    <title>Data description with Callback Persistant State: Full featured interface</title>
    <filename>group__XBT__dd__cb__full.html</filename>
    <member kind="function">
      <type>void</type>
      <name>xbt_cbps_v_pop</name>
      <anchorfile>group__XBT__dd__cb__full.html</anchorfile>
      <anchor>gac395ca0b2355cd1244ae31c50d8f91a7</anchor>
      <arglist>(xbt_cbps_t ps, const char *name, xbt_datadesc_type_t *ddt, void **res)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cbps_v_push</name>
      <anchorfile>group__XBT__dd__cb__full.html</anchorfile>
      <anchor>ga5a353875fc01c709c556cbe21db447c0</anchor>
      <arglist>(xbt_cbps_t ps, const char *name, void *data, xbt_datadesc_type_t ddt)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cbps_v_set</name>
      <anchorfile>group__XBT__dd__cb__full.html</anchorfile>
      <anchor>ga5d81d2ecc51f55a4f04a98b13c900c70</anchor>
      <arglist>(xbt_cbps_t ps, const char *name, void *data, xbt_datadesc_type_t ddt)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>xbt_cbps_v_get</name>
      <anchorfile>group__XBT__dd__cb__full.html</anchorfile>
      <anchor>gadbfa50f7a3c6c21152e10f3f8a33e528</anchor>
      <arglist>(xbt_cbps_t ps, const char *name, xbt_datadesc_type_t *ddt)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cbps_block_begin</name>
      <anchorfile>group__XBT__dd__cb__full.html</anchorfile>
      <anchor>ga04e9fc964f9d1a65cb5462f81f0ad1f1</anchor>
      <arglist>(xbt_cbps_t ps)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_cbps_block_end</name>
      <anchorfile>group__XBT__dd__cb__full.html</anchorfile>
      <anchor>ga8b0dd35ac64431d80772d5c185d11a19</anchor>
      <arglist>(xbt_cbps_t ps)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_dict_cons</name>
    <title>Dict constructor and destructor</title>
    <filename>group__XBT__dict__cons.html</filename>
    <member kind="typedef">
      <type>struct s_xbt_dict *</type>
      <name>xbt_dict_t</name>
      <anchorfile>group__XBT__dict__cons.html</anchorfile>
      <anchor>gac60ea15fce6ea593be308de876712f04</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>xbt_dict_t</type>
      <name>xbt_dict_new</name>
      <anchorfile>group__XBT__dict__cons.html</anchorfile>
      <anchor>ga3f03623cb96849ab40db9b9af25ac38c</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dict_t</type>
      <name>xbt_dict_new_homogeneous</name>
      <anchorfile>group__XBT__dict__cons.html</anchorfile>
      <anchor>ga99fe5eb49d3fa9f1f31fb6d519fb7197</anchor>
      <arglist>(void_f_pvoid_t free_ctn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_dict_free</name>
      <anchorfile>group__XBT__dict__cons.html</anchorfile>
      <anchor>ga35d2edf4086c13f0c096621aaf421c7d</anchor>
      <arglist>(xbt_dict_t *dict)</arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>xbt_dict_size</name>
      <anchorfile>group__XBT__dict__cons.html</anchorfile>
      <anchor>ga79130ac36df5cbdc334a3424a92eff5d</anchor>
      <arglist>(xbt_dict_t dict)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_dict_basic</name>
    <title>Dictionaries basic usage</title>
    <filename>group__XBT__dict__basic.html</filename>
    <member kind="function">
      <type>void</type>
      <name>xbt_dict_set</name>
      <anchorfile>group__XBT__dict__basic.html</anchorfile>
      <anchor>ga5167ca9336b1c9d5e2a3dacd6b702055</anchor>
      <arglist>(xbt_dict_t dict, const char *key, void *data, void_f_pvoid_t free_ctn)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>xbt_dict_get</name>
      <anchorfile>group__XBT__dict__basic.html</anchorfile>
      <anchor>gadc5080181f23fa2802b17b0982d76115</anchor>
      <arglist>(xbt_dict_t dict, const char *key)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>xbt_dict_get_or_null</name>
      <anchorfile>group__XBT__dict__basic.html</anchorfile>
      <anchor>gac1398f8a025c0f22195e74f2bd5522fa</anchor>
      <arglist>(xbt_dict_t dict, const char *key)</arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>xbt_dict_get_key</name>
      <anchorfile>group__XBT__dict__basic.html</anchorfile>
      <anchor>ga16e3ad7d2a93d89b95582ad82d1ce100</anchor>
      <arglist>(xbt_dict_t dict, const void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_dict_remove</name>
      <anchorfile>group__XBT__dict__basic.html</anchorfile>
      <anchor>gac8befeb2dc3ba97fb0ff1d3da83f21fb</anchor>
      <arglist>(xbt_dict_t dict, const char *key)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_dict_reset</name>
      <anchorfile>group__XBT__dict__basic.html</anchorfile>
      <anchor>ga0fe854e3c13798e32ebc642c00be6ad4</anchor>
      <arglist>(xbt_dict_t dict)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>xbt_dict_length</name>
      <anchorfile>group__XBT__dict__basic.html</anchorfile>
      <anchor>gac0cf96e5e13da996aac831d8d10f0985</anchor>
      <arglist>(xbt_dict_t dict)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_dict_dump_output_string</name>
      <anchorfile>group__XBT__dict__basic.html</anchorfile>
      <anchor>ga38d0003fc16ce9d437c9cb1c7b2e4a8e</anchor>
      <arglist>(void *s)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_dict_dump</name>
      <anchorfile>group__XBT__dict__basic.html</anchorfile>
      <anchor>ga7d8b3282a0599ed922bbac9c0686e456</anchor>
      <arglist>(xbt_dict_t dict, void(*output)(void *))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_dict_dump_sizes</name>
      <anchorfile>group__XBT__dict__basic.html</anchorfile>
      <anchor>gaa8c1e5beb5655c030df76fbcce9c9bbc</anchor>
      <arglist>(xbt_dict_t dict)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>xbt_dict_is_empty</name>
      <anchorfile>group__XBT__dict__basic.html</anchorfile>
      <anchor>ga68fb97981b63d246769f4b6fbbcb3eaf</anchor>
      <arglist>(xbt_dict_t dict)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_dict_nnul</name>
    <title>Dictionaries with non-nul terminated keys</title>
    <filename>group__XBT__dict__nnul.html</filename>
    <member kind="function">
      <type>void</type>
      <name>xbt_dict_set_ext</name>
      <anchorfile>group__XBT__dict__nnul.html</anchorfile>
      <anchor>gac10a4d2fd3a86576c1be1b61811317d8</anchor>
      <arglist>(xbt_dict_t dict, const char *key, int key_len, void *data, void_f_pvoid_t free_ctn)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>xbt_dict_get_ext</name>
      <anchorfile>group__XBT__dict__nnul.html</anchorfile>
      <anchor>ga7e5810ce5387ee78e25bb92c206deacd</anchor>
      <arglist>(xbt_dict_t dict, const char *key, int key_len)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>xbt_dict_get_or_null_ext</name>
      <anchorfile>group__XBT__dict__nnul.html</anchorfile>
      <anchor>gabfcc7b250b01f46a4397946a7a104fd1</anchor>
      <arglist>(xbt_dict_t dict, const char *key, int key_len)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_dict_remove_ext</name>
      <anchorfile>group__XBT__dict__nnul.html</anchorfile>
      <anchor>gad36d0be75e939e85ee17a9756332b6c4</anchor>
      <arglist>(xbt_dict_t dict, const char *key, int key_len)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_dict_curs</name>
    <title>Cursors on dictionaries</title>
    <filename>group__XBT__dict__curs.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>xbt_dict_foreach</name>
      <anchorfile>group__XBT__dict__curs.html</anchorfile>
      <anchor>ga3124aa46173fbf9fc703b748cebd4b70</anchor>
      <arglist>(dict, cursor, key, data)</arglist>
    </member>
    <member kind="typedef">
      <type>struct s_xbt_dict_cursor *</type>
      <name>xbt_dict_cursor_t</name>
      <anchorfile>group__XBT__dict__curs.html</anchorfile>
      <anchor>gae611da46e5289c03ea69e551e4d6f6b5</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>xbt_dict_cursor_t</type>
      <name>xbt_dict_cursor_new</name>
      <anchorfile>group__XBT__dict__curs.html</anchorfile>
      <anchor>ga5c29813d0de67603640f948b2d712209</anchor>
      <arglist>(const xbt_dict_t dict)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_dict_cursor_free</name>
      <anchorfile>group__XBT__dict__curs.html</anchorfile>
      <anchor>ga88eb8699e8778f9d1c5821da0bab1849</anchor>
      <arglist>(xbt_dict_cursor_t *cursor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_dict_cursor_rewind</name>
      <anchorfile>group__XBT__dict__curs.html</anchorfile>
      <anchor>ga0f0f7f26eef7dca0f3d837bac985a0ff</anchor>
      <arglist>(xbt_dict_cursor_t cursor)</arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>xbt_dict_cursor_get_key</name>
      <anchorfile>group__XBT__dict__curs.html</anchorfile>
      <anchor>ga86b45796b83225553370f1ed2298bdba</anchor>
      <arglist>(xbt_dict_cursor_t cursor)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>xbt_dict_cursor_get_data</name>
      <anchorfile>group__XBT__dict__curs.html</anchorfile>
      <anchor>ga2ebcfc14c62baafab95b9c994a2e6012</anchor>
      <arglist>(xbt_dict_cursor_t cursor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_dict_cursor_set_data</name>
      <anchorfile>group__XBT__dict__curs.html</anchorfile>
      <anchor>ga714c4490d2187b042a6993c68e860fad</anchor>
      <arglist>(xbt_dict_cursor_t cursor, void *data, void_f_pvoid_t free_ctn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_dict_cursor_first</name>
      <anchorfile>group__XBT__dict__curs.html</anchorfile>
      <anchor>gaed25ac933321fa3837877f2210979db7</anchor>
      <arglist>(const xbt_dict_t dict, xbt_dict_cursor_t *cursor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_dict_cursor_step</name>
      <anchorfile>group__XBT__dict__curs.html</anchorfile>
      <anchor>ga9871423165388f7637dd67116b68044a</anchor>
      <arglist>(xbt_dict_cursor_t cursor)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>xbt_dict_cursor_get_or_free</name>
      <anchorfile>group__XBT__dict__curs.html</anchorfile>
      <anchor>gad8ef9a04e0c50a3ed9a2dfa7ca36d599</anchor>
      <arglist>(xbt_dict_cursor_t *cursor, char **key, void **data)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_dynar_cons</name>
    <title>Dynar constructor and destructor</title>
    <filename>group__XBT__dynar__cons.html</filename>
    <member kind="typedef">
      <type>struct xbt_dynar_s *</type>
      <name>xbt_dynar_t</name>
      <anchorfile>group__XBT__dynar__cons.html</anchorfile>
      <anchor>gac826571988d2b63ae225e5c62ecdbc79</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>xbt_dynar_t</type>
      <name>xbt_dynar_new</name>
      <anchorfile>group__XBT__dynar__cons.html</anchorfile>
      <anchor>ga69ab371f667dfe5aa51fb612b9afaca5</anchor>
      <arglist>(const unsigned long elm_size, void_f_pvoid_t const free_f)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dynar_t</type>
      <name>xbt_dynar_new_sync</name>
      <anchorfile>group__XBT__dynar__cons.html</anchorfile>
      <anchor>ga34979efcf4d9e68ab3d817368ff453ac</anchor>
      <arglist>(const unsigned long elm_size, void_f_pvoid_t const free_f)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_dynar_free</name>
      <anchorfile>group__XBT__dynar__cons.html</anchorfile>
      <anchor>ga9b7808eb7a87dcf331a467f323ae16a6</anchor>
      <arglist>(xbt_dynar_t *dynar)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_dynar_free_voidp</name>
      <anchorfile>group__XBT__dynar__cons.html</anchorfile>
      <anchor>gacab2aaa46863a53beaa1637bd41995aa</anchor>
      <arglist>(void *dynar)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_dynar_free_container</name>
      <anchorfile>group__XBT__dynar__cons.html</anchorfile>
      <anchor>ga7bc3c4dffd7740c9c1ea129d1167c0bc</anchor>
      <arglist>(xbt_dynar_t *dynar)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_dynar_shrink</name>
      <anchorfile>group__XBT__dynar__cons.html</anchorfile>
      <anchor>ga8c1a192e8119147d92eaf873a2861fc0</anchor>
      <arglist>(xbt_dynar_t dynar, int empty_slots)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_dynar_array</name>
    <title>Dynar as a regular array</title>
    <filename>group__XBT__dynar__array.html</filename>
    <member kind="function">
      <type>void</type>
      <name>xbt_dynar_get_cpy</name>
      <anchorfile>group__XBT__dynar__array.html</anchorfile>
      <anchor>ga21d02c5fc8289c0bfc6c7d57222bcf90</anchor>
      <arglist>(const xbt_dynar_t dynar, const unsigned long idx, void *const dst)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_dynar_set</name>
      <anchorfile>group__XBT__dynar__array.html</anchorfile>
      <anchor>ga145c591bf6e4e58edaeeda85e639ff8e</anchor>
      <arglist>(xbt_dynar_t dynar, const int idx, const void *src)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_dynar_replace</name>
      <anchorfile>group__XBT__dynar__array.html</anchorfile>
      <anchor>ga22ccf4f0b47dd4a187af2e0a05abd323</anchor>
      <arglist>(xbt_dynar_t dynar, const unsigned long idx, const void *object)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_dynar_insert_at</name>
      <anchorfile>group__XBT__dynar__array.html</anchorfile>
      <anchor>ga26fe1c942bfecc8261d3fd9bc4df9bab</anchor>
      <arglist>(xbt_dynar_t const dynar, const int idx, const void *src)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_dynar_remove_at</name>
      <anchorfile>group__XBT__dynar__array.html</anchorfile>
      <anchor>ga32a7eaf157e28533482cda7d84460705</anchor>
      <arglist>(xbt_dynar_t const dynar, const int idx, void *const dst)</arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>xbt_dynar_search</name>
      <anchorfile>group__XBT__dynar__array.html</anchorfile>
      <anchor>ga0ec08fdba0bad2c1ef0e07269564edcd</anchor>
      <arglist>(xbt_dynar_t const dynar, void *elem)</arglist>
    </member>
    <member kind="function">
      <type>signed int</type>
      <name>xbt_dynar_search_or_negative</name>
      <anchorfile>group__XBT__dynar__array.html</anchorfile>
      <anchor>gafff87cf8f67e2cc57e783a7c740a476e</anchor>
      <arglist>(xbt_dynar_t const dynar, void *const elem)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>xbt_dynar_member</name>
      <anchorfile>group__XBT__dynar__array.html</anchorfile>
      <anchor>gaa1f2f12b574997619e36d46ac747f880</anchor>
      <arglist>(xbt_dynar_t const dynar, void *elem)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_dynar_sort</name>
      <anchorfile>group__XBT__dynar__array.html</anchorfile>
      <anchor>ga666d4ca5510ffa9f2cc9a1463c19e935</anchor>
      <arglist>(xbt_dynar_t const dynar, int_f_cpvoid_cpvoid_t compar_fn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_dynar_three_way_partition</name>
      <anchorfile>group__XBT__dynar__array.html</anchorfile>
      <anchor>ga136826efe107769033d82e9d162ff65d</anchor>
      <arglist>(xbt_dynar_t const dynar, int_f_pvoid_t color)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>xbt_dynar_to_array</name>
      <anchorfile>group__XBT__dynar__array.html</anchorfile>
      <anchor>ga8fb5745b688cae53556f69b8e728ef70</anchor>
      <arglist>(xbt_dynar_t dynar)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_dynar_misc</name>
    <title>Dynar miscellaneous functions</title>
    <filename>group__XBT__dynar__misc.html</filename>
    <member kind="function">
      <type>unsigned long</type>
      <name>xbt_dynar_length</name>
      <anchorfile>group__XBT__dynar__misc.html</anchorfile>
      <anchor>ga3beec123eb77ceda5b750f6f2ca48e18</anchor>
      <arglist>(const xbt_dynar_t dynar)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>xbt_dynar_is_empty</name>
      <anchorfile>group__XBT__dynar__misc.html</anchorfile>
      <anchor>ga57aab83ad4ff1a1df5a1c293627c41d8</anchor>
      <arglist>(const xbt_dynar_t dynar)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_dynar_reset</name>
      <anchorfile>group__XBT__dynar__misc.html</anchorfile>
      <anchor>gadbe6a462084ca281bab5ac3a1585097e</anchor>
      <arglist>(xbt_dynar_t const dynar)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_dynar_merge</name>
      <anchorfile>group__XBT__dynar__misc.html</anchorfile>
      <anchor>ga92e52b3898cb02ad47244b88ab7895e4</anchor>
      <arglist>(xbt_dynar_t *d1, xbt_dynar_t *d2)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_dynar_perl</name>
    <title>Perl-like use of dynars</title>
    <filename>group__XBT__dynar__perl.html</filename>
    <member kind="function">
      <type>void</type>
      <name>xbt_dynar_push</name>
      <anchorfile>group__XBT__dynar__perl.html</anchorfile>
      <anchor>gac89da4c2c302218759c7fe477d8eacc0</anchor>
      <arglist>(xbt_dynar_t const dynar, const void *src)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_dynar_pop</name>
      <anchorfile>group__XBT__dynar__perl.html</anchorfile>
      <anchor>ga37d2b11c522e02ede79a12a89575ceb1</anchor>
      <arglist>(xbt_dynar_t const dynar, void *const dst)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_dynar_unshift</name>
      <anchorfile>group__XBT__dynar__perl.html</anchorfile>
      <anchor>ga3499315d48944f3bfaf6aeea1e2c75e8</anchor>
      <arglist>(xbt_dynar_t const dynar, const void *src)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_dynar_shift</name>
      <anchorfile>group__XBT__dynar__perl.html</anchorfile>
      <anchor>ga2966d02b350ef985447c4053c258a1a0</anchor>
      <arglist>(xbt_dynar_t const dynar, void *const dst)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_dynar_map</name>
      <anchorfile>group__XBT__dynar__perl.html</anchorfile>
      <anchor>ga02bb7b95aaa0fe03c26222f65566e744</anchor>
      <arglist>(const xbt_dynar_t dynar, void_f_pvoid_t const op)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_dynar_ctn</name>
    <title>Direct manipulation to the dynars content</title>
    <filename>group__XBT__dynar__ctn.html</filename>
    <member kind="function">
      <type>void *</type>
      <name>xbt_dynar_get_ptr</name>
      <anchorfile>group__XBT__dynar__ctn.html</anchorfile>
      <anchor>ga7cee77666f148fc987bbdeca3d10bdc2</anchor>
      <arglist>(const xbt_dynar_t dynar, const unsigned long idx)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>xbt_dynar_insert_at_ptr</name>
      <anchorfile>group__XBT__dynar__ctn.html</anchorfile>
      <anchor>ga06afc0831b210b5323e61a9a217d6158</anchor>
      <arglist>(xbt_dynar_t const dynar, const int idx)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>xbt_dynar_push_ptr</name>
      <anchorfile>group__XBT__dynar__ctn.html</anchorfile>
      <anchor>ga35272457aa299d326977767a00e01ffe</anchor>
      <arglist>(xbt_dynar_t const dynar)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>xbt_dynar_pop_ptr</name>
      <anchorfile>group__XBT__dynar__ctn.html</anchorfile>
      <anchor>ga4f1ef94eae8a2060697a9674d46f0c2f</anchor>
      <arglist>(xbt_dynar_t const dynar)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_dynar_speed</name>
    <title>Speed optimized access to dynars of scalars</title>
    <filename>group__XBT__dynar__speed.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>xbt_dynar_get_as</name>
      <anchorfile>group__XBT__dynar__speed.html</anchorfile>
      <anchor>ga5604d34153e9c96ac193245757f63085</anchor>
      <arglist>(dynar, idx, type)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>xbt_dynar_set_as</name>
      <anchorfile>group__XBT__dynar__speed.html</anchorfile>
      <anchor>gafee03470eed0dc5e8eb240288ba8b11b</anchor>
      <arglist>(dynar, idx, type, val)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>xbt_dynar_getlast_as</name>
      <anchorfile>group__XBT__dynar__speed.html</anchorfile>
      <anchor>gac056cfe5092e40327377547abd9995ee</anchor>
      <arglist>(dynar, type)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>xbt_dynar_getfirst_as</name>
      <anchorfile>group__XBT__dynar__speed.html</anchorfile>
      <anchor>ga209a34611a295f0e3516536e753893c3</anchor>
      <arglist>(dynar, type)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>xbt_dynar_insert_at_as</name>
      <anchorfile>group__XBT__dynar__speed.html</anchorfile>
      <anchor>ga767cbdbaddd71fb98140eb78309b5739</anchor>
      <arglist>(dynar, idx, type, value)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>xbt_dynar_push_as</name>
      <anchorfile>group__XBT__dynar__speed.html</anchorfile>
      <anchor>ga50d763465a98678a3e83afa6b5ecd243</anchor>
      <arglist>(dynar, type, value)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>xbt_dynar_pop_as</name>
      <anchorfile>group__XBT__dynar__speed.html</anchorfile>
      <anchor>gab6dd8b8802c7ad0b12a81ecd806370cc</anchor>
      <arglist>(dynar, type)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_dynar_cursor</name>
    <title>Cursors on dynar</title>
    <filename>group__XBT__dynar__cursor.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>xbt_dynar_foreach</name>
      <anchorfile>group__XBT__dynar__cursor.html</anchorfile>
      <anchor>ga315906139864e84a34aa5610ba0be1fc</anchor>
      <arglist>(_dynar, _cursor, _data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_dynar_cursor_rm</name>
      <anchorfile>group__XBT__dynar__cursor.html</anchorfile>
      <anchor>ga478b49fe9e8280b4c73b9ccd208a4f78</anchor>
      <arglist>(xbt_dynar_t dynar, unsigned int *const cursor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_dynar_cursor_unlock</name>
      <anchorfile>group__XBT__dynar__cursor.html</anchorfile>
      <anchor>ga44f885719301510ce99d93937dc35e0b</anchor>
      <arglist>(xbt_dynar_t dynar)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_fifo_cons</name>
    <title>Fifo constructor and destructor</title>
    <filename>group__XBT__fifo__cons.html</filename>
    <member kind="typedef">
      <type>struct xbt_fifo_item *</type>
      <name>xbt_fifo_item_t</name>
      <anchorfile>group__XBT__fifo__cons.html</anchorfile>
      <anchor>ga58e96f4a3637f7ff6bb1a9f53e7865c8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct xbt_fifo *</type>
      <name>xbt_fifo_t</name>
      <anchorfile>group__XBT__fifo__cons.html</anchorfile>
      <anchor>ga24efbdc1db204e1a628958ce7509a312</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>xbt_fifo_t</type>
      <name>xbt_fifo_new</name>
      <anchorfile>group__XBT__fifo__cons.html</anchorfile>
      <anchor>ga2797ae0ae47b096ffdd99fbd60d8402d</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_fifo_free</name>
      <anchorfile>group__XBT__fifo__cons.html</anchorfile>
      <anchor>ga7e4e0a12b0bb5a0cc761e926a6ec8ea7</anchor>
      <arglist>(xbt_fifo_t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_fifo_reset</name>
      <anchorfile>group__XBT__fifo__cons.html</anchorfile>
      <anchor>ga028b8b135de99c5526269b5c124093cf</anchor>
      <arglist>(xbt_fifo_t)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_fifo_perl</name>
    <title>Fifo perl-like functions</title>
    <filename>group__XBT__fifo__perl.html</filename>
    <member kind="function">
      <type>xbt_fifo_item_t</type>
      <name>xbt_fifo_push</name>
      <anchorfile>group__XBT__fifo__perl.html</anchorfile>
      <anchor>ga62606f494627c7be494082bb2a239f7a</anchor>
      <arglist>(xbt_fifo_t, void *)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>xbt_fifo_pop</name>
      <anchorfile>group__XBT__fifo__perl.html</anchorfile>
      <anchor>gaa8ae3369665727b54c3c3d0f5c1e91be</anchor>
      <arglist>(xbt_fifo_t)</arglist>
    </member>
    <member kind="function">
      <type>xbt_fifo_item_t</type>
      <name>xbt_fifo_unshift</name>
      <anchorfile>group__XBT__fifo__perl.html</anchorfile>
      <anchor>gad165b0eb7ea833480776eb02062da45f</anchor>
      <arglist>(xbt_fifo_t, void *)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>xbt_fifo_shift</name>
      <anchorfile>group__XBT__fifo__perl.html</anchorfile>
      <anchor>ga79a99aa3de3fb2d15836fffca5e28c83</anchor>
      <arglist>(xbt_fifo_t)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>xbt_fifo_size</name>
      <anchorfile>group__XBT__fifo__perl.html</anchorfile>
      <anchor>gad7fdf56ec51e0c1ec442225b3e3ccc07</anchor>
      <arglist>(xbt_fifo_t)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>xbt_fifo_is_in</name>
      <anchorfile>group__XBT__fifo__perl.html</anchorfile>
      <anchor>ga29753ca3f59d8e810bcee69304cd8b42</anchor>
      <arglist>(xbt_fifo_t, void *)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_fifo_direct</name>
    <title>Direct access to fifo elements</title>
    <filename>group__XBT__fifo__direct.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>xbt_fifo_foreach</name>
      <anchorfile>group__XBT__fifo__direct.html</anchorfile>
      <anchor>ga7062f0aae3a97fa72fcf86673675d434</anchor>
      <arglist>(f, i, n, type)</arglist>
    </member>
    <member kind="function">
      <type>xbt_fifo_item_t</type>
      <name>xbt_fifo_new_item</name>
      <anchorfile>group__XBT__fifo__direct.html</anchorfile>
      <anchor>gad9f577f95ac147ed876083d60166a662</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_fifo_set_item_content</name>
      <anchorfile>group__XBT__fifo__direct.html</anchorfile>
      <anchor>ga3a95882cc4858a10fa29216c939eb1b4</anchor>
      <arglist>(xbt_fifo_item_t, void *)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>xbt_fifo_get_item_content</name>
      <anchorfile>group__XBT__fifo__direct.html</anchorfile>
      <anchor>ga601af16f78f6f1753477ce8e91eece01</anchor>
      <arglist>(xbt_fifo_item_t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_fifo_free_item</name>
      <anchorfile>group__XBT__fifo__direct.html</anchorfile>
      <anchor>ga4bfc376902e2e15da4acb31c2ac77d84</anchor>
      <arglist>(xbt_fifo_item_t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_fifo_push_item</name>
      <anchorfile>group__XBT__fifo__direct.html</anchorfile>
      <anchor>gae1266d2dc81fc9d46334500682756b93</anchor>
      <arglist>(xbt_fifo_t, xbt_fifo_item_t)</arglist>
    </member>
    <member kind="function">
      <type>xbt_fifo_item_t</type>
      <name>xbt_fifo_pop_item</name>
      <anchorfile>group__XBT__fifo__direct.html</anchorfile>
      <anchor>ga32cfb8161a224dafafbf3f667d8257aa</anchor>
      <arglist>(xbt_fifo_t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_fifo_unshift_item</name>
      <anchorfile>group__XBT__fifo__direct.html</anchorfile>
      <anchor>gab5d6b760390ffc095f35f50e5bfd890a</anchor>
      <arglist>(xbt_fifo_t, xbt_fifo_item_t)</arglist>
    </member>
    <member kind="function">
      <type>xbt_fifo_item_t</type>
      <name>xbt_fifo_shift_item</name>
      <anchorfile>group__XBT__fifo__direct.html</anchorfile>
      <anchor>ga46dbde2e3359af8a79f2d4da7582d18c</anchor>
      <arglist>(xbt_fifo_t)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>xbt_fifo_remove</name>
      <anchorfile>group__XBT__fifo__direct.html</anchorfile>
      <anchor>gafae46252cee20c382f9ce4f2e2573135</anchor>
      <arglist>(xbt_fifo_t, void *)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>xbt_fifo_remove_all</name>
      <anchorfile>group__XBT__fifo__direct.html</anchorfile>
      <anchor>ga0662ae632f8f72753074f0cf234f8c46</anchor>
      <arglist>(xbt_fifo_t, void *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_fifo_remove_item</name>
      <anchorfile>group__XBT__fifo__direct.html</anchorfile>
      <anchor>gabd68f9b13a5e4984224760e9e5afed3b</anchor>
      <arglist>(xbt_fifo_t, xbt_fifo_item_t)</arglist>
    </member>
    <member kind="function">
      <type>xbt_fifo_item_t</type>
      <name>xbt_fifo_get_first_item</name>
      <anchorfile>group__XBT__fifo__direct.html</anchorfile>
      <anchor>gadde4755e50e84bf3235182227cdc1580</anchor>
      <arglist>(xbt_fifo_t l)</arglist>
    </member>
    <member kind="function">
      <type>xbt_fifo_item_t</type>
      <name>xbt_fifo_get_last_item</name>
      <anchorfile>group__XBT__fifo__direct.html</anchorfile>
      <anchor>ga8cbb245158703f78cab3d076804eaa61</anchor>
      <arglist>(xbt_fifo_t l)</arglist>
    </member>
    <member kind="function">
      <type>xbt_fifo_item_t</type>
      <name>xbt_fifo_get_next_item</name>
      <anchorfile>group__XBT__fifo__direct.html</anchorfile>
      <anchor>ga6fde465c7d19469ee07e28d7ae5f611b</anchor>
      <arglist>(xbt_fifo_item_t i)</arglist>
    </member>
    <member kind="function">
      <type>xbt_fifo_item_t</type>
      <name>xbt_fifo_get_prev_item</name>
      <anchorfile>group__XBT__fifo__direct.html</anchorfile>
      <anchor>gac47a383a08e9c08cc4dd5bf29cd50994</anchor>
      <arglist>(xbt_fifo_item_t i)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_fifo_misc</name>
    <title>Misc fifo functions</title>
    <filename>group__XBT__fifo__misc.html</filename>
    <member kind="function">
      <type>void **</type>
      <name>xbt_fifo_to_array</name>
      <anchorfile>group__XBT__fifo__misc.html</anchorfile>
      <anchor>ga0a85e5e8e1e0774885f73614f3a40770</anchor>
      <arglist>(xbt_fifo_t)</arglist>
    </member>
    <member kind="function">
      <type>xbt_fifo_t</type>
      <name>xbt_fifo_copy</name>
      <anchorfile>group__XBT__fifo__misc.html</anchorfile>
      <anchor>ga9fc2652fb4c1d80adbf4f8e7267846fd</anchor>
      <arglist>(xbt_fifo_t)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_log_cats</name>
    <title>Existing log categories</title>
    <filename>group__XBT__log__cats.html</filename>
  </compound>
  <compound kind="group">
    <name>XBT_mallocator_cons</name>
    <title>Mallocator constructor and destructor</title>
    <filename>group__XBT__mallocator__cons.html</filename>
    <member kind="typedef">
      <type>struct s_xbt_mallocator *</type>
      <name>xbt_mallocator_t</name>
      <anchorfile>group__XBT__mallocator__cons.html</anchorfile>
      <anchor>gab949b93743d06b31bbdf3828d34a72ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>xbt_mallocator_t</type>
      <name>xbt_mallocator_new</name>
      <anchorfile>group__XBT__mallocator__cons.html</anchorfile>
      <anchor>ga31b8b348c6b44d730c915c5442a64637</anchor>
      <arglist>(int size, pvoid_f_void_t new_f, void_f_pvoid_t free_f, void_f_pvoid_t reset_f)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_mallocator_free</name>
      <anchorfile>group__XBT__mallocator__cons.html</anchorfile>
      <anchor>gaa884a3ef269f0709b9b2e025708f2e95</anchor>
      <arglist>(xbt_mallocator_t mallocator)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_mallocator_objects</name>
    <title>Mallocator object handling</title>
    <filename>group__XBT__mallocator__objects.html</filename>
    <member kind="function">
      <type>void *</type>
      <name>xbt_mallocator_get</name>
      <anchorfile>group__XBT__mallocator__objects.html</anchorfile>
      <anchor>ga3e52409c5b24294ef98367b56cad4c7b</anchor>
      <arglist>(xbt_mallocator_t mallocator)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_mallocator_release</name>
      <anchorfile>group__XBT__mallocator__objects.html</anchorfile>
      <anchor>gaf33e29b8ca5ab081c3ab323cf42fd244</anchor>
      <arglist>(xbt_mallocator_t mallocator, void *object)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_mallocator_initialization_is_done</name>
      <anchorfile>group__XBT__mallocator__objects.html</anchorfile>
      <anchor>ga6ff2a64845cb33bc1727423155fcc9f2</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_set_cons</name>
    <title>Set and set elements, constructor/destructor</title>
    <filename>group__XBT__set__cons.html</filename>
    <class kind="struct">xbt_set_elm_</class>
    <member kind="typedef">
      <type>struct xbt_set_ *</type>
      <name>xbt_set_t</name>
      <anchorfile>group__XBT__set__cons.html</anchorfile>
      <anchor>ga5a56bcacbc9efbb918abb6be2f7c8b7d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct xbt_set_elm_</type>
      <name>s_xbt_set_elm_t</name>
      <anchorfile>group__XBT__set__cons.html</anchorfile>
      <anchor>gaf8bb4c0082689473e7aa16791283a38e</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>xbt_set_t</type>
      <name>xbt_set_new</name>
      <anchorfile>group__XBT__set__cons.html</anchorfile>
      <anchor>ga2cb4e125f22594bb8f7a2726464fed3d</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_set_free</name>
      <anchorfile>group__XBT__set__cons.html</anchorfile>
      <anchor>ga268b2b486920b5f0a580b3d1bed6875a</anchor>
      <arglist>(xbt_set_t *set)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_set_basic</name>
    <title>Sets basic usage</title>
    <filename>group__XBT__set__basic.html</filename>
    <member kind="function">
      <type>void</type>
      <name>xbt_set_add</name>
      <anchorfile>group__XBT__set__basic.html</anchorfile>
      <anchor>ga1db2802704edc8b5d404ca204fc5b34d</anchor>
      <arglist>(xbt_set_t set, xbt_set_elm_t elm, void_f_pvoid_t free_func)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_set_remove</name>
      <anchorfile>group__XBT__set__basic.html</anchorfile>
      <anchor>gadd31f4f1a5a5fdce54f3a8bfbc37de8a</anchor>
      <arglist>(xbt_set_t set, xbt_set_elm_t elm)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_set_remove_by_name</name>
      <anchorfile>group__XBT__set__basic.html</anchorfile>
      <anchor>gac5ac26bcb50f5a22c1b2af1f8a1f49c4</anchor>
      <arglist>(xbt_set_t set, const char *key)</arglist>
    </member>
    <member kind="function">
      <type>xbt_set_elm_t</type>
      <name>xbt_set_get_by_name_or_null</name>
      <anchorfile>group__XBT__set__basic.html</anchorfile>
      <anchor>ga02fb94d3aa9fcfaae688f61a0ca9cdc2</anchor>
      <arglist>(xbt_set_t set, const char *key)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_set_remove_by_name_ext</name>
      <anchorfile>group__XBT__set__basic.html</anchorfile>
      <anchor>gabda240bc3fa5bc0ac6983b19f4caa5f8</anchor>
      <arglist>(xbt_set_t set, const char *key, int key_len)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_set_remove_by_id</name>
      <anchorfile>group__XBT__set__basic.html</anchorfile>
      <anchor>ga917c20ea5adb57ca287dd1d48ca12ec7</anchor>
      <arglist>(xbt_set_t set, int id)</arglist>
    </member>
    <member kind="function">
      <type>xbt_set_elm_t</type>
      <name>xbt_set_get_by_name</name>
      <anchorfile>group__XBT__set__basic.html</anchorfile>
      <anchor>gaa5ebcac05554bc6c20129b437851b12e</anchor>
      <arglist>(xbt_set_t set, const char *key)</arglist>
    </member>
    <member kind="function">
      <type>xbt_set_elm_t</type>
      <name>xbt_set_get_by_name_ext</name>
      <anchorfile>group__XBT__set__basic.html</anchorfile>
      <anchor>ga6a7bc28b3bedbcb05e2a60297c9df8f0</anchor>
      <arglist>(xbt_set_t set, const char *key, int key_len)</arglist>
    </member>
    <member kind="function">
      <type>xbt_set_elm_t</type>
      <name>xbt_set_get_by_id</name>
      <anchorfile>group__XBT__set__basic.html</anchorfile>
      <anchor>ga19df8b5e26799112d5aba9f677739138</anchor>
      <arglist>(xbt_set_t set, int id)</arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>xbt_set_length</name>
      <anchorfile>group__XBT__set__basic.html</anchorfile>
      <anchor>ga5a1935dab5ad9e2f3c9820e6db7889a7</anchor>
      <arglist>(const xbt_set_t set)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_set_curs</name>
    <title>Sets cursors</title>
    <filename>group__XBT__set__curs.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>xbt_set_foreach</name>
      <anchorfile>group__XBT__set__curs.html</anchorfile>
      <anchor>ga58f50aee97a03985e1af193fbdea92ba</anchor>
      <arglist>(set, cursor, elm)</arglist>
    </member>
    <member kind="typedef">
      <type>struct xbt_set_cursor_ *</type>
      <name>xbt_set_cursor_t</name>
      <anchorfile>group__XBT__set__curs.html</anchorfile>
      <anchor>ga07bc36055121d6d2b49a483608033827</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_set_cursor_first</name>
      <anchorfile>group__XBT__set__curs.html</anchorfile>
      <anchor>ga0ae677ad09fbf19fc8f9343dcc647dc2</anchor>
      <arglist>(xbt_set_t set, xbt_set_cursor_t *cursor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_set_cursor_step</name>
      <anchorfile>group__XBT__set__curs.html</anchorfile>
      <anchor>ga1e42bd77295716cac5d3a38f4b7419b1</anchor>
      <arglist>(xbt_set_cursor_t cursor)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>xbt_set_cursor_get_or_free</name>
      <anchorfile>group__XBT__set__curs.html</anchorfile>
      <anchor>gac4c1fa14c3207e4ad1c9973db97147d5</anchor>
      <arglist>(xbt_set_cursor_t *cursor, xbt_set_elm_t *elm)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_sock_create</name>
    <title>Socket creation functions</title>
    <filename>group__XBT__sock__create.html</filename>
    <member kind="typedef">
      <type>struct s_xbt_socket *</type>
      <name>xbt_socket_t</name>
      <anchorfile>group__XBT__sock__create.html</anchorfile>
      <anchor>ga490f317ed9bc4b6d7f0b78bf91e6f184</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_socket_new</name>
      <anchorfile>group__XBT__sock__create.html</anchorfile>
      <anchor>ga74063187ff4613e222182d2d15470b8b</anchor>
      <arglist>(int incoming, xbt_socket_t *dst)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_socket_new_ext</name>
      <anchorfile>group__XBT__sock__create.html</anchorfile>
      <anchor>ga2a1ab2bf2abddc36a185271d5c7eec28</anchor>
      <arglist>(int incoming, xbt_socket_t *dst, xbt_trp_plugin_t plugin, unsigned long int buf_size, int measurement)</arglist>
    </member>
    <member kind="function">
      <type>xbt_socket_t</type>
      <name>xbt_socket_tcp_client</name>
      <anchorfile>group__XBT__sock__create.html</anchorfile>
      <anchor>ga5e8064902e221d58babcc5e9e29486fb</anchor>
      <arglist>(const char *host, unsigned short port)</arglist>
    </member>
    <member kind="function">
      <type>xbt_socket_t</type>
      <name>xbt_socket_tcp_server</name>
      <anchorfile>group__XBT__sock__create.html</anchorfile>
      <anchor>ga51c2d089498cd0b624dfd0dc4c951b4f</anchor>
      <arglist>(unsigned short port)</arglist>
    </member>
    <member kind="function">
      <type>xbt_socket_t</type>
      <name>xbt_socket_tcp_client_ext</name>
      <anchorfile>group__XBT__sock__create.html</anchorfile>
      <anchor>ga8b7a8ef98dedacec480e81d269c9cf15</anchor>
      <arglist>(const char *host, unsigned short port, unsigned long int bufSize, int measurement)</arglist>
    </member>
    <member kind="function">
      <type>xbt_socket_t</type>
      <name>xbt_socket_tcp_server_ext</name>
      <anchorfile>group__XBT__sock__create.html</anchorfile>
      <anchor>ga2e65b16a680eb855b2cd81358972facb</anchor>
      <arglist>(unsigned short portcp_t, unsigned long int bufSize, int measurement)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_sock_info</name>
    <title>Retrieving data about sockets and peers</title>
    <filename>group__XBT__sock__info.html</filename>
    <member kind="function">
      <type>int</type>
      <name>xbt_socket_my_port</name>
      <anchorfile>group__XBT__sock__info.html</anchorfile>
      <anchor>gafe4ba785c1b995f3508423b064ad6527</anchor>
      <arglist>(xbt_socket_t sock)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>xbt_socket_peer_port</name>
      <anchorfile>group__XBT__sock__info.html</anchorfile>
      <anchor>ga261ce2b45f820b18c6cf9efc46257f13</anchor>
      <arglist>(xbt_socket_t sock)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>xbt_socket_peer_name</name>
      <anchorfile>group__XBT__sock__info.html</anchorfile>
      <anchor>ga333dd4cc354fc99c54661967b58efe27</anchor>
      <arglist>(xbt_socket_t sock)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>xbt_socket_peer_proc</name>
      <anchorfile>group__XBT__sock__info.html</anchorfile>
      <anchor>ga9a749edc9efe22f95cbdabdbfe8c123a</anchor>
      <arglist>(xbt_socket_t sock)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_sock_meas</name>
    <title>Using measurement sockets</title>
    <filename>group__XBT__sock__meas.html</filename>
    <member kind="function">
      <type>int</type>
      <name>xbt_socket_is_meas</name>
      <anchorfile>group__XBT__sock__meas.html</anchorfile>
      <anchor>ga6123c76b9debccd4338a856cce5896d8</anchor>
      <arglist>(xbt_socket_t sock)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_socket_meas_send</name>
      <anchorfile>group__XBT__sock__meas.html</anchorfile>
      <anchor>ga2702c9f2e738cde0bbbce90c6647b334</anchor>
      <arglist>(xbt_socket_t peer, unsigned int timeout, unsigned long int msgSize, unsigned long int msgAmount)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_socket_meas_recv</name>
      <anchorfile>group__XBT__sock__meas.html</anchorfile>
      <anchor>gabaff122cfcb3bd3f6c991d0b2d50b710</anchor>
      <arglist>(xbt_socket_t peer, unsigned int timeout, unsigned long int msgSize, unsigned long int msgAmount)</arglist>
    </member>
    <member kind="function">
      <type>xbt_socket_t</type>
      <name>xbt_socket_meas_accept</name>
      <anchorfile>group__XBT__sock__meas.html</anchorfile>
      <anchor>ga4b3de4557dde69d3862c9657fbfb07a7</anchor>
      <arglist>(xbt_socket_t peer)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_sock_plugin</name>
    <title>Plugin mechanism</title>
    <filename>group__XBT__sock__plugin.html</filename>
  </compound>
  <compound kind="group">
    <name>XBT_swag_type</name>
    <title>Swag types</title>
    <filename>group__XBT__swag__type.html</filename>
    <member kind="typedef">
      <type>struct xbt_swag_hookup</type>
      <name>s_xbt_swag_hookup_t</name>
      <anchorfile>group__XBT__swag__type.html</anchorfile>
      <anchor>ga1cb9298c552ff2834e5dad4848311692</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct xbt_swag *</type>
      <name>xbt_swag_t</name>
      <anchorfile>group__XBT__swag__type.html</anchorfile>
      <anchor>gae08645c9a236bae019fb12ab374dc17f</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_swag_func</name>
    <title>SWAG functions</title>
    <filename>group__XBT__swag__func.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>xbt_swag_reset</name>
      <anchorfile>group__XBT__swag__func.html</anchorfile>
      <anchor>ga178b8841e1a3e2561f5b73fbfdecdfa1</anchor>
      <arglist>(swag)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>xbt_swag_insert</name>
      <anchorfile>group__XBT__swag__func.html</anchorfile>
      <anchor>ga1bb1fb6d0e53c58a6d5c9ceac94339b6</anchor>
      <arglist>(obj, swag)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>xbt_swag_offset</name>
      <anchorfile>group__XBT__swag__func.html</anchorfile>
      <anchor>ga96193348bca3b2b0840cbc122d8516f7</anchor>
      <arglist>(var, field)</arglist>
    </member>
    <member kind="function">
      <type>xbt_swag_t</type>
      <name>xbt_swag_new</name>
      <anchorfile>group__XBT__swag__func.html</anchorfile>
      <anchor>ga11b0c605fb84243e1c399831c9efbf6c</anchor>
      <arglist>(size_t offset)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_swag_free</name>
      <anchorfile>group__XBT__swag__func.html</anchorfile>
      <anchor>ga936859aae1ee95f8cfb9f32047dc482d</anchor>
      <arglist>(xbt_swag_t swag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_swag_init</name>
      <anchorfile>group__XBT__swag__func.html</anchorfile>
      <anchor>ga08da2ee0936e19da57695b5d99007c64</anchor>
      <arglist>(xbt_swag_t swag, size_t offset)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_swag_insert_at_head</name>
      <anchorfile>group__XBT__swag__func.html</anchorfile>
      <anchor>ga19c8dc8c1637bb0fce94c4bc38b7d088</anchor>
      <arglist>(void *obj, xbt_swag_t swag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xbt_swag_insert_at_tail</name>
      <anchorfile>group__XBT__swag__func.html</anchorfile>
      <anchor>gae5919f7e25c402ac3079d792e033a1fb</anchor>
      <arglist>(void *obj, xbt_swag_t swag)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>xbt_swag_remove</name>
      <anchorfile>group__XBT__swag__func.html</anchorfile>
      <anchor>gabce3d24a60fbd2e2cbd31df6612418a3</anchor>
      <arglist>(void *obj, xbt_swag_t swag)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>xbt_swag_extract</name>
      <anchorfile>group__XBT__swag__func.html</anchorfile>
      <anchor>ga008f75ad3c220b326121e44a6cadb6d3</anchor>
      <arglist>(xbt_swag_t swag)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>xbt_swag_size</name>
      <anchorfile>group__XBT__swag__func.html</anchorfile>
      <anchor>gaef55e706dcbabb605cf71e522caa82e6</anchor>
      <arglist>(xbt_swag_t swag)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>XBT_swag_curs</name>
    <title>Swag cursor</title>
    <filename>group__XBT__swag__curs.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>xbt_swag_foreach</name>
      <anchorfile>group__XBT__swag__curs.html</anchorfile>
      <anchor>gad0579732a4cf176b7812381b85c1df42</anchor>
      <arglist>(obj, swag)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>xbt_swag_foreach_safe</name>
      <anchorfile>group__XBT__swag__curs.html</anchorfile>
      <anchor>ga1cd81b745c6799a768b8f08c5d4c7974</anchor>
      <arglist>(obj, obj_next, swag)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>SD_link_management</name>
    <title>Links</title>
    <filename>group__SD__link__management.html</filename>
    <member kind="function">
      <type>const SD_link_t *</type>
      <name>SD_link_get_list</name>
      <anchorfile>group__SD__link__management.html</anchorfile>
      <anchor>gae6a4a20a3269c3595a195d24f220fb40</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>SD_link_get_number</name>
      <anchorfile>group__SD__link__management.html</anchorfile>
      <anchor>ga8f5ff7ea86c621aa77f44e913222613d</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>SD_link_get_data</name>
      <anchorfile>group__SD__link__management.html</anchorfile>
      <anchor>ga4f56602832da18405e8d0e2653f0744c</anchor>
      <arglist>(SD_link_t link)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>SD_link_set_data</name>
      <anchorfile>group__SD__link__management.html</anchorfile>
      <anchor>ga180c8056827783104c4cecce3acc9b23</anchor>
      <arglist>(SD_link_t link, void *data)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>SD_link_get_name</name>
      <anchorfile>group__SD__link__management.html</anchorfile>
      <anchor>gace788d7f0b4b57c5af0b8a5025929780</anchor>
      <arglist>(SD_link_t link)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>SD_link_get_current_bandwidth</name>
      <anchorfile>group__SD__link__management.html</anchorfile>
      <anchor>ga4bdb09a991d2366f38c303ed2e48c885</anchor>
      <arglist>(SD_link_t link)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>SD_link_get_current_latency</name>
      <anchorfile>group__SD__link__management.html</anchorfile>
      <anchor>ga61b0106214ae990e8f4c9aaecfbc0779</anchor>
      <arglist>(SD_link_t link)</arglist>
    </member>
    <member kind="function">
      <type>e_SD_link_sharing_policy_t</type>
      <name>SD_link_get_sharing_policy</name>
      <anchorfile>group__SD__link__management.html</anchorfile>
      <anchor>gaab6c4e1b06d62ed57157b508561b28c8</anchor>
      <arglist>(SD_link_t link)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>SD_workstation_management</name>
    <title>Workstations</title>
    <filename>group__SD__workstation__management.html</filename>
    <member kind="function">
      <type>SD_workstation_t</type>
      <name>SD_workstation_get_by_name</name>
      <anchorfile>group__SD__workstation__management.html</anchorfile>
      <anchor>ga1c912ef7ecda05d307afefad0fc759b6</anchor>
      <arglist>(const char *name)</arglist>
    </member>
    <member kind="function">
      <type>const SD_workstation_t *</type>
      <name>SD_workstation_get_list</name>
      <anchorfile>group__SD__workstation__management.html</anchorfile>
      <anchor>ga2849ed01ae4dc580923fbd6782d9ccf4</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>SD_workstation_get_number</name>
      <anchorfile>group__SD__workstation__management.html</anchorfile>
      <anchor>gacdc811bb1046b88da230d51c68533ba2</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>SD_workstation_set_data</name>
      <anchorfile>group__SD__workstation__management.html</anchorfile>
      <anchor>ga63c39639777faf77a8e6c0bd41694fa1</anchor>
      <arglist>(SD_workstation_t workstation, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>SD_workstation_get_data</name>
      <anchorfile>group__SD__workstation__management.html</anchorfile>
      <anchor>gaed29af2c807f986fccf6d3ad4bf15156</anchor>
      <arglist>(SD_workstation_t workstation)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>SD_workstation_get_name</name>
      <anchorfile>group__SD__workstation__management.html</anchorfile>
      <anchor>ga229affb29b5472c8f62f054b0def9547</anchor>
      <arglist>(SD_workstation_t workstation)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dict_t</type>
      <name>SD_workstation_get_properties</name>
      <anchorfile>group__SD__workstation__management.html</anchorfile>
      <anchor>ga24a4f207e56f070fa83c56d8bb0c35c1</anchor>
      <arglist>(SD_workstation_t workstation)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>SD_workstation_get_property_value</name>
      <anchorfile>group__SD__workstation__management.html</anchorfile>
      <anchor>ga6977e577293bd72f9e191dd2613b650f</anchor>
      <arglist>(SD_workstation_t workstation, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>SD_workstation_dump</name>
      <anchorfile>group__SD__workstation__management.html</anchorfile>
      <anchor>ga71b72259a6d31b4445700eb1d21a087a</anchor>
      <arglist>(SD_workstation_t ws)</arglist>
    </member>
    <member kind="function">
      <type>const SD_link_t *</type>
      <name>SD_route_get_list</name>
      <anchorfile>group__SD__workstation__management.html</anchorfile>
      <anchor>gaa9522a1e095218a426cf6c70315fdc9d</anchor>
      <arglist>(SD_workstation_t src, SD_workstation_t dst)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>SD_route_get_size</name>
      <anchorfile>group__SD__workstation__management.html</anchorfile>
      <anchor>gad28c1465fa8cc17f0d73668ed8dbca4a</anchor>
      <arglist>(SD_workstation_t src, SD_workstation_t dst)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>SD_workstation_get_power</name>
      <anchorfile>group__SD__workstation__management.html</anchorfile>
      <anchor>ga324f3ae1cea2ae9e52bfb70448361f26</anchor>
      <arglist>(SD_workstation_t workstation)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>SD_workstation_get_available_power</name>
      <anchorfile>group__SD__workstation__management.html</anchorfile>
      <anchor>gadfd3673bc4bc5011babfd0247d45ef28</anchor>
      <arglist>(SD_workstation_t workstation)</arglist>
    </member>
    <member kind="function">
      <type>e_SD_workstation_access_mode_t</type>
      <name>SD_workstation_get_access_mode</name>
      <anchorfile>group__SD__workstation__management.html</anchorfile>
      <anchor>ga68c974556d55dc2ae760fde9408a32e6</anchor>
      <arglist>(SD_workstation_t workstation)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>SD_workstation_set_access_mode</name>
      <anchorfile>group__SD__workstation__management.html</anchorfile>
      <anchor>gac00d8cc9c460d532aedfb9ba8fc49c66</anchor>
      <arglist>(SD_workstation_t workstation, e_SD_workstation_access_mode_t access_mode)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>SD_workstation_get_computation_time</name>
      <anchorfile>group__SD__workstation__management.html</anchorfile>
      <anchor>ga9caaba45417c65427ee74da841dd14e2</anchor>
      <arglist>(SD_workstation_t workstation, double computation_amount)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>SD_route_get_current_latency</name>
      <anchorfile>group__SD__workstation__management.html</anchorfile>
      <anchor>ga224866561ec8000a495faea7c5e25b48</anchor>
      <arglist>(SD_workstation_t src, SD_workstation_t dst)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>SD_route_get_current_bandwidth</name>
      <anchorfile>group__SD__workstation__management.html</anchorfile>
      <anchor>gad52c195122d5cd98331a3838c52d4d81</anchor>
      <arglist>(SD_workstation_t src, SD_workstation_t dst)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>SD_route_get_communication_time</name>
      <anchorfile>group__SD__workstation__management.html</anchorfile>
      <anchor>ga0983ee235addaee99467ef4c4f97966b</anchor>
      <arglist>(SD_workstation_t src, SD_workstation_t dst, double communication_amount)</arglist>
    </member>
    <member kind="function">
      <type>SD_task_t</type>
      <name>SD_workstation_get_current_task</name>
      <anchorfile>group__SD__workstation__management.html</anchorfile>
      <anchor>ga0e4d5fa0f15423b8c1e55abfecd25164</anchor>
      <arglist>(SD_workstation_t workstation)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>SD_task_management</name>
    <title>Tasks</title>
    <filename>group__SD__task__management.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>SD_SCHED_NO_COST</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>ga430717fbd36bb2d92b85e4c47a96ffa0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>SD_task_t</type>
      <name>SD_task_create</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>ga4ac4414bf72fd959333848d88562502f</anchor>
      <arglist>(const char *name, void *data, double amount)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>SD_task_get_data</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>ga766539121eadc77886003186e1b45e83</anchor>
      <arglist>(SD_task_t task)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>SD_task_set_data</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>ga8f5b24ab48696ea78998b42ace35900a</anchor>
      <arglist>(SD_task_t task, void *data)</arglist>
    </member>
    <member kind="function">
      <type>e_SD_task_state_t</type>
      <name>SD_task_get_state</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>ga2b320214a7e5a1c74cf50b236453b288</anchor>
      <arglist>(SD_task_t task)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>SD_task_get_name</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>gaf1f33ccbe8a0568836387a46d444473d</anchor>
      <arglist>(SD_task_t task)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>SD_task_set_name</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>gaea6138e1ab09935b8a575e1ccbea045c</anchor>
      <arglist>(SD_task_t task, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>SD_task_set_rate</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>ga5763ec9afe02f381bd1ae9b0be8cb64a</anchor>
      <arglist>(SD_task_t task, double rate)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>SD_task_watch</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>ga7853f1943b540ff9d3d7078ed46206cb</anchor>
      <arglist>(SD_task_t task, e_SD_task_state_t state)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>SD_task_unwatch</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>ga5cc2370b3d1c43b298a0d5512d8d9312</anchor>
      <arglist>(SD_task_t task, e_SD_task_state_t state)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>SD_task_get_amount</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>gaff407e0ad880fe3e34e0905bbbc1568a</anchor>
      <arglist>(SD_task_t task)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>SD_task_get_remaining_amount</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>ga4f8d27d92e9fc813c44b5a64adb24410</anchor>
      <arglist>(SD_task_t task)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>SD_task_get_execution_time</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>ga6c7f9b54e7f061555f07c6ade5fc1e9f</anchor>
      <arglist>(SD_task_t task, int workstation_nb, const SD_workstation_t *workstation_list, const double *computation_amount, const double *communication_amount)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>SD_task_schedule</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>ga30a5dbfc2983c1700375075f16c22364</anchor>
      <arglist>(SD_task_t task, int workstation_nb, const SD_workstation_t *workstation_list, const double *computation_amount, const double *communication_amount, double rate)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>SD_task_unschedule</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>ga5f1619e6ed05db349d89ea12944f64ba</anchor>
      <arglist>(SD_task_t task)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>SD_task_get_start_time</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>ga1cc17b4c7857521fc4b679bff63446b6</anchor>
      <arglist>(SD_task_t task)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>SD_task_get_finish_time</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>ga9ed01cda917f36b4da719f0594fbe9ee</anchor>
      <arglist>(SD_task_t task)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dynar_t</type>
      <name>SD_task_get_parents</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>ga8e6a82c3100081945a6afc650975dee3</anchor>
      <arglist>(SD_task_t task)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dynar_t</type>
      <name>SD_task_get_children</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>gabcb438f55dd8fb525a6753576c8c4069</anchor>
      <arglist>(SD_task_t task)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>SD_task_get_workstation_count</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>ga4092ccda7d10951ffaf47b65a2da4ae3</anchor>
      <arglist>(SD_task_t task)</arglist>
    </member>
    <member kind="function">
      <type>SD_workstation_t *</type>
      <name>SD_task_get_workstation_list</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>ga773124574884bcff102efa3adc9b6120</anchor>
      <arglist>(SD_task_t task)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>SD_task_destroy</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>ga0cffb2af680086f53fb1599db6ae3c42</anchor>
      <arglist>(SD_task_t task)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>SD_task_dump</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>ga9ea8bd4d42155b26f17a875ce24a9ca0</anchor>
      <arglist>(SD_task_t task)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>SD_task_dotty</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>gab29f36e954266588b46c3f2e76e4afe3</anchor>
      <arglist>(SD_task_t task, void *out_FILE)</arglist>
    </member>
    <member kind="function">
      <type>SD_task_t</type>
      <name>SD_task_create_comp_seq</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>ga3f6480d75795a3309c0c026e540d86e0</anchor>
      <arglist>(const char *name, void *data, double amount)</arglist>
    </member>
    <member kind="function">
      <type>SD_task_t</type>
      <name>SD_task_create_comp_par_amdahl</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>ga39c7eb7e2db73d0c022c78bf0d4a64a2</anchor>
      <arglist>(const char *name, void *data, double amount, double alpha)</arglist>
    </member>
    <member kind="function">
      <type>SD_task_t</type>
      <name>SD_task_create_comm_e2e</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>ga5690de45db3666e42b97c171f952df15</anchor>
      <arglist>(const char *name, void *data, double amount)</arglist>
    </member>
    <member kind="function">
      <type>SD_task_t</type>
      <name>SD_task_create_comm_par_mxn_1d_block</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>gaaa2a2ba19ce7315069ec4642b6aa16a2</anchor>
      <arglist>(const char *name, void *data, double amount)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>SD_task_distribute_comp_amdhal</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>gac3aba9d592abda234b32dc3e1d5f2af3</anchor>
      <arglist>(SD_task_t task, int ws_count)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>SD_task_schedulev</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>gab0ec206f43cda6a8cbdb4aaa8d1a9d02</anchor>
      <arglist>(SD_task_t task, int count, const SD_workstation_t *list)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>SD_task_schedulel</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>ga35bc9c3b6f25462bacb8f467605f87bb</anchor>
      <arglist>(SD_task_t task, int count,...)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>SD_task_set_category</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>gae070a8d12815166eaefe016b54553287</anchor>
      <arglist>(SD_task_t task, const char *category)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>SD_task_get_category</name>
      <anchorfile>group__SD__task__management.html</anchorfile>
      <anchor>ga9bfc296f5fd292edb7d1047756371346</anchor>
      <arglist>(SD_task_t task)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>SD_task_dependency_management</name>
    <title>Tasks dependencies</title>
    <filename>group__SD__task__dependency__management.html</filename>
    <member kind="function">
      <type>void</type>
      <name>SD_task_dependency_add</name>
      <anchorfile>group__SD__task__dependency__management.html</anchorfile>
      <anchor>gaeaa883b0561beefb647c5c4280299138</anchor>
      <arglist>(const char *name, void *data, SD_task_t src, SD_task_t dst)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>SD_task_dependency_remove</name>
      <anchorfile>group__SD__task__dependency__management.html</anchorfile>
      <anchor>ga3a22709b38b7a4eb86317e334a8110e0</anchor>
      <arglist>(SD_task_t src, SD_task_t dst)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>SD_task_dependency_get_data</name>
      <anchorfile>group__SD__task__dependency__management.html</anchorfile>
      <anchor>gaa1bdcdfefbf9b19e03cf90376d6fbbb0</anchor>
      <arglist>(SD_task_t src, SD_task_t dst)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>SD_task_dependency_exists</name>
      <anchorfile>group__SD__task__dependency__management.html</anchorfile>
      <anchor>gad492251b41fcd05684d88359c26656e1</anchor>
      <arglist>(SD_task_t src, SD_task_t dst)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>SD_simulation</name>
    <title>Simulation</title>
    <filename>group__SD__simulation.html</filename>
    <member kind="function">
      <type>void</type>
      <name>SD_init</name>
      <anchorfile>group__SD__simulation.html</anchorfile>
      <anchor>gaa4c19ede9d99b8925e62f30c52f1e65f</anchor>
      <arglist>(int *argc, char **argv)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>SD_application_reinit</name>
      <anchorfile>group__SD__simulation.html</anchorfile>
      <anchor>ga8c9fdcd05effacd9b20c0ea75c5c5f7e</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>SD_create_environment</name>
      <anchorfile>group__SD__simulation.html</anchorfile>
      <anchor>gac961eff01737333623e3b5343e78a269</anchor>
      <arglist>(const char *platform_file)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>SD_load_environment_script</name>
      <anchorfile>group__SD__simulation.html</anchorfile>
      <anchor>gaeb0b621a2ac717745e76d7df49931933</anchor>
      <arglist>(const char *script_file)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dynar_t</type>
      <name>SD_simulate</name>
      <anchorfile>group__SD__simulation.html</anchorfile>
      <anchor>ga5a1f4e7f674374210de13181acbd98d3</anchor>
      <arglist>(double how_long)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>SD_get_clock</name>
      <anchorfile>group__SD__simulation.html</anchorfile>
      <anchor>gafc34707cae382f245f7a33d1eb202392</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>SD_exit</name>
      <anchorfile>group__SD__simulation.html</anchorfile>
      <anchor>gad1a92b51e423aad6d47be2b82c6536ba</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dynar_t</type>
      <name>SD_daxload</name>
      <anchorfile>group__SD__simulation.html</anchorfile>
      <anchor>ga1882fd299f53829a131dd01c83ed5471</anchor>
      <arglist>(const char *filename)</arglist>
    </member>
    <member kind="function">
      <type>xbt_dynar_t</type>
      <name>SD_dotload</name>
      <anchorfile>group__SD__simulation.html</anchorfile>
      <anchor>ga35de259bc832b4926a310d0359a36dd6</anchor>
      <arglist>(const char *filename)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>amok_result_t</name>
    <filename>structamok__result__t.html</filename>
  </compound>
  <compound kind="struct">
    <name>DataDescriptorStruct</name>
    <filename>structDataDescriptorStruct.html</filename>
  </compound>
  <compound kind="struct">
    <name>file_stat</name>
    <filename>structfile__stat.html</filename>
  </compound>
  <compound kind="struct">
    <name>gras_procdata_t</name>
    <filename>structgras__procdata__t.html</filename>
  </compound>
  <compound kind="struct">
    <name>s_gras_cblist</name>
    <filename>structs__gras__cblist.html</filename>
  </compound>
  <compound kind="struct">
    <name>s_gras_msg_cb_ctx</name>
    <filename>structs__gras__msg__cb__ctx.html</filename>
  </compound>
  <compound kind="struct">
    <name>s_gras_msg_t</name>
    <filename>structs__gras__msg__t.html</filename>
  </compound>
  <compound kind="struct">
    <name>s_gras_msgtype</name>
    <filename>structs__gras__msgtype.html</filename>
  </compound>
  <compound kind="struct">
    <name>s_model_type</name>
    <filename>structs__model__type.html</filename>
  </compound>
  <compound kind="struct">
    <name>s_smx_action</name>
    <filename>structs__smx__action.html</filename>
  </compound>
  <compound kind="struct">
    <name>s_smx_host</name>
    <filename>structs__smx__host.html</filename>
    <member kind="variable">
      <type>char *</type>
      <name>name</name>
      <anchorfile>structs__smx__host.html</anchorfile>
      <anchor>a5cc8b4e4cee6068286c16bd63fa212a6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>void *</type>
      <name>data</name>
      <anchorfile>structs__smx__host.html</anchorfile>
      <anchor>af7239e861f698e1d7ad1817d94903492</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>s_smx_process</name>
    <filename>structs__smx__process.html</filename>
    <member kind="variable">
      <type>char *</type>
      <name>name</name>
      <anchorfile>structs__smx__process.html</anchorfile>
      <anchor>a5c047926058308fa200c609bbd6e4d27</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>s_smx_rvpoint</name>
    <filename>structs__smx__rvpoint.html</filename>
  </compound>
  <compound kind="struct">
    <name>s_smx_simcall</name>
    <filename>structs__smx__simcall.html</filename>
  </compound>
  <compound kind="struct">
    <name>s_smx_timer</name>
    <filename>structs__smx__timer.html</filename>
  </compound>
  <compound kind="struct">
    <name>s_surf_metric_t</name>
    <filename>structs__surf__metric__t.html</filename>
  </compound>
  <compound kind="struct">
    <name>s_xbt_datadesc_type</name>
    <filename>structs__xbt__datadesc__type.html</filename>
  </compound>
  <compound kind="struct">
    <name>s_xbt_dd_cat_array</name>
    <filename>structs__xbt__dd__cat__array.html</filename>
  </compound>
  <compound kind="struct">
    <name>s_xbt_dd_cat_field</name>
    <filename>structs__xbt__dd__cat__field.html</filename>
  </compound>
  <compound kind="struct">
    <name>s_xbt_dd_cat_ref</name>
    <filename>structs__xbt__dd__cat__ref.html</filename>
  </compound>
  <compound kind="struct">
    <name>s_xbt_dd_cat_struct</name>
    <filename>structs__xbt__dd__cat__struct.html</filename>
  </compound>
  <compound kind="struct">
    <name>s_xbt_dd_cat_union</name>
    <filename>structs__xbt__dd__cat__union.html</filename>
  </compound>
  <compound kind="struct">
    <name>s_xbt_parmap</name>
    <filename>structs__xbt__parmap.html</filename>
    <member kind="variable">
      <type>e_xbt_parmap_flag_t</type>
      <name>status</name>
      <anchorfile>structs__xbt__parmap.html</anchorfile>
      <anchor>afe6c4afdbdfecc9dc4cc141e264e1fa7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned</type>
      <name>work</name>
      <anchorfile>structs__xbt__parmap.html</anchorfile>
      <anchor>acbf2e11c9c8d053907e5bc6f8e4d396d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned</type>
      <name>thread_counter</name>
      <anchorfile>structs__xbt__parmap.html</anchorfile>
      <anchor>a4cb1478d076f1df7aa59518292b9300e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned int</type>
      <name>num_workers</name>
      <anchorfile>structs__xbt__parmap.html</anchorfile>
      <anchor>a4610f24b4081b535323b5ae767221137</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>void_f_pvoid_t</type>
      <name>fun</name>
      <anchorfile>structs__xbt__parmap.html</anchorfile>
      <anchor>ab41017148fff9bfd45f1e4562cd8881f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>xbt_dynar_t</type>
      <name>data</name>
      <anchorfile>structs__xbt__parmap.html</anchorfile>
      <anchor>ae218d5ac5ff8b9a5910f445627cb248e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned int</type>
      <name>index</name>
      <anchorfile>structs__xbt__parmap.html</anchorfile>
      <anchor>ac583971bdbd4b8d9693e6bb539da69fe</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>e_xbt_parmap_mode_t</type>
      <name>mode</name>
      <anchorfile>structs__xbt__parmap.html</anchorfile>
      <anchor>ac414c60f2d3a61b47e436bfb96245969</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>void(*</type>
      <name>master_wait_f</name>
      <anchorfile>structs__xbt__parmap.html</anchorfile>
      <anchor>a675dabf4d9e2117c079aa3dcf1c82678</anchor>
      <arglist>)(xbt_parmap_t)</arglist>
    </member>
    <member kind="variable">
      <type>void(*</type>
      <name>worker_signal_f</name>
      <anchorfile>structs__xbt__parmap.html</anchorfile>
      <anchor>a9ba6b2ab3c8e1f943d9308c77c4f13ec</anchor>
      <arglist>)(xbt_parmap_t)</arglist>
    </member>
    <member kind="variable">
      <type>void(*</type>
      <name>master_signal_f</name>
      <anchorfile>structs__xbt__parmap.html</anchorfile>
      <anchor>a5cf66c7f69b8cf8e5546561d5feddfb5</anchor>
      <arglist>)(xbt_parmap_t)</arglist>
    </member>
    <member kind="variable">
      <type>void(*</type>
      <name>worker_wait_f</name>
      <anchorfile>structs__xbt__parmap.html</anchorfile>
      <anchor>a5524248ea1a35b7094e3c898e293bf0d</anchor>
      <arglist>)(xbt_parmap_t, unsigned)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>s_xbt_peer</name>
    <filename>structs__xbt__peer.html</filename>
  </compound>
  <compound kind="struct">
    <name>s_xbt_strbuff_t</name>
    <filename>structs__xbt__strbuff__t.html</filename>
  </compound>
  <compound kind="struct">
    <name>surf_action</name>
    <filename>structsurf__action.html</filename>
    <member kind="variable">
      <type>double</type>
      <name>cost</name>
      <anchorfile>structsurf__action.html</anchorfile>
      <anchor>a240981003cb7b2ef07b822b07a3e9973</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>double</type>
      <name>priority</name>
      <anchorfile>structsurf__action.html</anchorfile>
      <anchor>ad856ef7cb77971a29ce0691b52bfd89e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>double</type>
      <name>max_duration</name>
      <anchorfile>structsurf__action.html</anchorfile>
      <anchor>ab18a20606e4b5393b305f7b0e5ca8fbf</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>double</type>
      <name>remains</name>
      <anchorfile>structsurf__action.html</anchorfile>
      <anchor>a524498b274bd63b350e368a57105f47f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>double</type>
      <name>start</name>
      <anchorfile>structsurf__action.html</anchorfile>
      <anchor>ab81d9f768089a74b58910ad81f50d5f7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>double</type>
      <name>finish</name>
      <anchorfile>structsurf__action.html</anchorfile>
      <anchor>a4999b0d857d5e2e56431de7308909fbb</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>void *</type>
      <name>data</name>
      <anchorfile>structsurf__action.html</anchorfile>
      <anchor>a0f6bd3843542d60168febd743a659c6b</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>char *</type>
      <name>category</name>
      <anchorfile>structsurf__action.html</anchorfile>
      <anchor>ad4acecd52a2d4699e5f2145225fc890d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>surf_file_t</type>
      <name>file</name>
      <anchorfile>structsurf__action.html</anchorfile>
      <anchor>aa9ca06fd7e5854befa6036abda2365b4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>s_file_stat_t</type>
      <name>stat</name>
      <anchorfile>structsurf__action.html</anchorfile>
      <anchor>ab8bdf1c1badb49555ac0d1c327c4bc3a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>surf_action_state</name>
    <filename>structsurf__action__state.html</filename>
    <member kind="variable">
      <type>xbt_swag_t</type>
      <name>ready_action_set</name>
      <anchorfile>structsurf__action__state.html</anchorfile>
      <anchor>a037da16821384bfb2364d03d7bc7c6b2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>xbt_swag_t</type>
      <name>running_action_set</name>
      <anchorfile>structsurf__action__state.html</anchorfile>
      <anchor>a25766c647f7fadf3b54cdd5f7ab81957</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>xbt_swag_t</type>
      <name>failed_action_set</name>
      <anchorfile>structsurf__action__state.html</anchorfile>
      <anchor>afd75fc8c3f9c0427127d33cf6c0514d8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>xbt_swag_t</type>
      <name>done_action_set</name>
      <anchorfile>structsurf__action__state.html</anchorfile>
      <anchor>ae22e8832c0918dc4942f1d918103e186</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>surf_cpu_model_extension_public</name>
    <filename>structsurf__cpu__model__extension__public.html</filename>
  </compound>
  <compound kind="struct">
    <name>surf_model</name>
    <filename>structsurf__model.html</filename>
    <member kind="variable">
      <type>const char *</type>
      <name>name</name>
      <anchorfile>structsurf__model.html</anchorfile>
      <anchor>a285237be60a0c75c56d50f754f10ca1b</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>s_surf_action_state_t</type>
      <name>states</name>
      <anchorfile>structsurf__model.html</anchorfile>
      <anchor>a0e84008d3c39ef70dbdb98a9de1bcf48</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>e_surf_action_state_t(*</type>
      <name>action_state_get</name>
      <anchorfile>structsurf__model.html</anchorfile>
      <anchor>ad6398c4a857042569f6943e95d4dcec4</anchor>
      <arglist>)(surf_action_t action)</arglist>
    </member>
    <member kind="variable">
      <type>void(*</type>
      <name>action_state_set</name>
      <anchorfile>structsurf__model.html</anchorfile>
      <anchor>a969312b9fd1533e9fb8488059522d760</anchor>
      <arglist>)(surf_action_t action, e_surf_action_state_t state)</arglist>
    </member>
    <member kind="variable">
      <type>double(*</type>
      <name>action_get_start_time</name>
      <anchorfile>structsurf__model.html</anchorfile>
      <anchor>a2ab1dc2a56a9950a1fc5afd4b09013f9</anchor>
      <arglist>)(surf_action_t action)</arglist>
    </member>
    <member kind="variable">
      <type>double(*</type>
      <name>action_get_finish_time</name>
      <anchorfile>structsurf__model.html</anchorfile>
      <anchor>a9bcb1343173e301eb3e861d8cefe30c1</anchor>
      <arglist>)(surf_action_t action)</arglist>
    </member>
    <member kind="variable">
      <type>int(*</type>
      <name>action_unref</name>
      <anchorfile>structsurf__model.html</anchorfile>
      <anchor>acb6cffe534dbfcfb5c3fefc5b714e623</anchor>
      <arglist>)(surf_action_t action)</arglist>
    </member>
    <member kind="variable">
      <type>void(*</type>
      <name>action_cancel</name>
      <anchorfile>structsurf__model.html</anchorfile>
      <anchor>aae5c7f6115a8e8f0c2c7dbd168dd8a8e</anchor>
      <arglist>)(surf_action_t action)</arglist>
    </member>
    <member kind="variable">
      <type>void(*</type>
      <name>action_recycle</name>
      <anchorfile>structsurf__model.html</anchorfile>
      <anchor>afdbd4f9c98ca4af207c89ebb29c9d8bb</anchor>
      <arglist>)(surf_action_t action)</arglist>
    </member>
    <member kind="variable">
      <type>void(*</type>
      <name>action_data_set</name>
      <anchorfile>structsurf__model.html</anchorfile>
      <anchor>ade0d9846b3a3e6321e87a51fc257116b</anchor>
      <arglist>)(surf_action_t action, void *data)</arglist>
    </member>
    <member kind="variable">
      <type>void(*</type>
      <name>suspend</name>
      <anchorfile>structsurf__model.html</anchorfile>
      <anchor>a90af557a210c80ed385fc4a0f4b3a882</anchor>
      <arglist>)(surf_action_t action)</arglist>
    </member>
    <member kind="variable">
      <type>void(*</type>
      <name>resume</name>
      <anchorfile>structsurf__model.html</anchorfile>
      <anchor>a8f0b61e06575462b3c5cbf1a22f3e859</anchor>
      <arglist>)(surf_action_t action)</arglist>
    </member>
    <member kind="variable">
      <type>int(*</type>
      <name>is_suspended</name>
      <anchorfile>structsurf__model.html</anchorfile>
      <anchor>af65ddbc8ce59a3e2e7e26098b5ba6552</anchor>
      <arglist>)(surf_action_t action)</arglist>
    </member>
    <member kind="variable">
      <type>void(*</type>
      <name>set_max_duration</name>
      <anchorfile>structsurf__model.html</anchorfile>
      <anchor>a4702f5e90dc62742ec188695e0ff1c72</anchor>
      <arglist>)(surf_action_t action, double duration)</arglist>
    </member>
    <member kind="variable">
      <type>void(*</type>
      <name>set_priority</name>
      <anchorfile>structsurf__model.html</anchorfile>
      <anchor>a34f89ec266f457c37000f52cdd354a08</anchor>
      <arglist>)(surf_action_t action, double priority)</arglist>
    </member>
    <member kind="variable">
      <type>void(*</type>
      <name>set_category</name>
      <anchorfile>structsurf__model.html</anchorfile>
      <anchor>a2fe3155ae5dfb3782e1e7b01dc90a988</anchor>
      <arglist>)(surf_action_t action, const char *category)</arglist>
    </member>
    <member kind="variable">
      <type>double(*</type>
      <name>get_remains</name>
      <anchorfile>structsurf__model.html</anchorfile>
      <anchor>adf9644f3b9b404f36973a25bfee0e761</anchor>
      <arglist>)(surf_action_t action)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>surf_model_description</name>
    <filename>structsurf__model__description.html</filename>
  </compound>
  <compound kind="struct">
    <name>surf_network_model_extension_public</name>
    <filename>structsurf__network__model__extension__public.html</filename>
  </compound>
  <compound kind="struct">
    <name>surf_storage_model_extension_public</name>
    <filename>structsurf__storage__model__extension__public.html</filename>
  </compound>
  <compound kind="struct">
    <name>surf_workstation_model_extension_public</name>
    <filename>structsurf__workstation__model__extension__public.html</filename>
    <member kind="variable">
      <type>surf_action_t(*</type>
      <name>execute</name>
      <anchorfile>structsurf__workstation__model__extension__public.html</anchorfile>
      <anchor>ad44708cb6550651107c38f4cccf0262f</anchor>
      <arglist>)(void *workstation, double size)</arglist>
    </member>
    <member kind="variable">
      <type>surf_action_t(*</type>
      <name>sleep</name>
      <anchorfile>structsurf__workstation__model__extension__public.html</anchorfile>
      <anchor>a21f808bbbafa9bf838c71b5e54501465</anchor>
      <arglist>)(void *workstation, double duration)</arglist>
    </member>
    <member kind="variable">
      <type>e_surf_resource_state_t(*</type>
      <name>get_state</name>
      <anchorfile>structsurf__workstation__model__extension__public.html</anchorfile>
      <anchor>a13bf38fd96228f099d5edbe6f55dafff</anchor>
      <arglist>)(void *workstation)</arglist>
    </member>
    <member kind="variable">
      <type>double(*</type>
      <name>get_speed</name>
      <anchorfile>structsurf__workstation__model__extension__public.html</anchorfile>
      <anchor>a4360bd7e469801b2adc37c56edccfeca</anchor>
      <arglist>)(void *workstation, double load)</arglist>
    </member>
    <member kind="variable">
      <type>double(*</type>
      <name>get_available_speed</name>
      <anchorfile>structsurf__workstation__model__extension__public.html</anchorfile>
      <anchor>ae6ed8c858e3d713fc7f1ba8f04bd1008</anchor>
      <arglist>)(void *workstation)</arglist>
    </member>
    <member kind="variable">
      <type>xbt_dynar_t(*</type>
      <name>get_route</name>
      <anchorfile>structsurf__workstation__model__extension__public.html</anchorfile>
      <anchor>a84cdf3b9de17ceef028da789296fd1ae</anchor>
      <arglist>)(void *workstation_src, void *workstation_dst)</arglist>
    </member>
    <member kind="variable">
      <type>double(*</type>
      <name>get_link_bandwidth</name>
      <anchorfile>structsurf__workstation__model__extension__public.html</anchorfile>
      <anchor>a564334f9eb1e783fa1f561bdf3a5aae0</anchor>
      <arglist>)(const void *link)</arglist>
    </member>
    <member kind="variable">
      <type>double(*</type>
      <name>get_link_latency</name>
      <anchorfile>structsurf__workstation__model__extension__public.html</anchorfile>
      <anchor>a660cd47d3c8ef9bdd3dcb1bfd81f8e57</anchor>
      <arglist>)(const void *link)</arglist>
    </member>
  </compound>
  <compound kind="union">
    <name>u_xbt_datadesc_category</name>
    <filename>unionu__xbt__datadesc__category.html</filename>
  </compound>
  <compound kind="struct">
    <name>xbt_ex_t</name>
    <filename>structxbt__ex__t.html</filename>
    <member kind="variable">
      <type>char *</type>
      <name>msg</name>
      <anchorfile>structxbt__ex__t.html</anchorfile>
      <anchor>ad0a0a10d1bb3838b5b205fc005693ec3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>xbt_errcat_t</type>
      <name>category</name>
      <anchorfile>structxbt__ex__t.html</anchorfile>
      <anchor>a2fdd312ae1d96663701d743283404924</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>value</name>
      <anchorfile>structxbt__ex__t.html</anchorfile>
      <anchor>a9bb9f8aef46f7821ab7c0ccd04b52f4f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>short int</type>
      <name>remote</name>
      <anchorfile>structxbt__ex__t.html</anchorfile>
      <anchor>a64d5ce4fa8dee32083ee85d800d0328c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>char *</type>
      <name>host</name>
      <anchorfile>structxbt__ex__t.html</anchorfile>
      <anchor>a18608979c3ac00dbd1f2980d7f3989d7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>char *</type>
      <name>procname</name>
      <anchorfile>structxbt__ex__t.html</anchorfile>
      <anchor>a2b10084a06349fff9725b7de494027a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>pid</name>
      <anchorfile>structxbt__ex__t.html</anchorfile>
      <anchor>a1d67c080063f5af389c3b23c381c240f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>char *</type>
      <name>file</name>
      <anchorfile>structxbt__ex__t.html</anchorfile>
      <anchor>a699c25f08a1720fd3d669706e0765782</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>line</name>
      <anchorfile>structxbt__ex__t.html</anchorfile>
      <anchor>ab5dd68c13c396302ebd7e98f76ff825d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>char *</type>
      <name>func</name>
      <anchorfile>structxbt__ex__t.html</anchorfile>
      <anchor>a83dc86da4901fc1589688824301eb929</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>xbt_set_elm_</name>
    <filename>structxbt__set__elm__.html</filename>
    <member kind="variable">
      <type>unsigned int</type>
      <name>ID</name>
      <anchorfile>structxbt__set__elm__.html</anchorfile>
      <anchor>ad72fec45d8f1714b7465f1b951095746</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>char *</type>
      <name>name</name>
      <anchorfile>structxbt__set__elm__.html</anchorfile>
      <anchor>a5a2ab800a2ad4e62739c13ff4f7d6104</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned int</type>
      <name>name_len</name>
      <anchorfile>structxbt__set__elm__.html</anchorfile>
      <anchor>a6896ad1af2ffaa976b0aa3850bd0a9c9</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="dir">
    <name>amok/</name>
    <path>/tmp/toward_3.8.1/simgrid-git-upstream/src/amok/</path>
    <filename>dir_28324c62742e8219e629ef8429d682ae.html</filename>
    <dir>amok/Bandwidth/</dir>
    <dir>amok/PeerManagement/</dir>
    <file>amok_base.c</file>
    <file>amok_modinter.h</file>
  </compound>
  <compound kind="dir">
    <name>/tmp/toward_3.8.1/simgrid-git-upstream/include/amok/</name>
    <path>/tmp/toward_3.8.1/simgrid-git-upstream/include/amok/</path>
    <filename>dir_8e6715976bd84905621294d5b7c395a7.html</filename>
    <file>bandwidth.h</file>
    <file>base.h</file>
    <file>peermanagement.h</file>
  </compound>
  <compound kind="dir">
    <name>amok/Bandwidth/</name>
    <path>/tmp/toward_3.8.1/simgrid-git-upstream/src/amok/Bandwidth/</path>
    <filename>dir_a4438f769462b65fc63e554f16d88c52.html</filename>
    <file>bandwidth.c</file>
    <file>bandwidth_private.h</file>
    <file>saturate.c</file>
  </compound>
  <compound kind="dir">
    <name>xbt/datadesc/</name>
    <path>/tmp/toward_3.8.1/simgrid-git-upstream/src/xbt/datadesc/</path>
    <filename>dir_91a0a405ac108847b4126db2a2aa8ab1.html</filename>
    <file>cbps.c</file>
    <file>datadesc.c</file>
    <file>datadesc_interface.h</file>
    <file>datadesc_private.h</file>
    <file>ddt_convert.c</file>
    <file>ddt_create.c</file>
    <file>ddt_exchange.c</file>
    <file>ddt_parse.c</file>
    <file>ddt_parse.yy.c</file>
    <file>ddt_parse.yy.h</file>
  </compound>
  <compound kind="dir">
    <name>gras/</name>
    <path>/tmp/toward_3.8.1/simgrid-git-upstream/src/gras/</path>
    <filename>dir_693401973e97b5bdb5ec6440f05de278.html</filename>
    <dir>gras/Msg/</dir>
    <dir>gras/Transport/</dir>
    <dir>gras/Virtu/</dir>
    <file>gras.c</file>
    <file>rl_stubs.c</file>
  </compound>
  <compound kind="dir">
    <name>/tmp/toward_3.8.1/simgrid-git-upstream/include/gras/</name>
    <path>/tmp/toward_3.8.1/simgrid-git-upstream/include/gras/</path>
    <filename>dir_c863d7564cb82afc86a94aec0f2d92aa.html</filename>
    <file>emul.h</file>
    <file>messages.h</file>
    <file>module.h</file>
    <file>process.h</file>
    <file>timer.h</file>
    <file>transport.h</file>
    <file>virtu.h</file>
  </compound>
  <compound kind="dir">
    <name>include/</name>
    <path>/tmp/toward_3.8.1/simgrid-git-upstream/src/include/</path>
    <filename>dir_b0856f6b0d80ccb263b2f415c91f9e17.html</filename>
    <dir>include/surf/</dir>
  </compound>
  <compound kind="dir">
    <name>/tmp/toward_3.8.1/simgrid-git-upstream/include/</name>
    <path>/tmp/toward_3.8.1/simgrid-git-upstream/include/</path>
    <filename>dir_d44c64559bbebec7f509842c48db8b23.html</filename>
    <dir>/tmp/toward_3.8.1/simgrid-git-upstream/include/amok/</dir>
    <dir>/tmp/toward_3.8.1/simgrid-git-upstream/include/gras/</dir>
    <dir>/tmp/toward_3.8.1/simgrid-git-upstream/include/msg/</dir>
    <dir>/tmp/toward_3.8.1/simgrid-git-upstream/include/simdag/</dir>
    <dir>/tmp/toward_3.8.1/simgrid-git-upstream/include/simgrid/</dir>
    <dir>/tmp/toward_3.8.1/simgrid-git-upstream/include/xbt/</dir>
    <file>gras.h</file>
    <file>xbt.h</file>
  </compound>
  <compound kind="dir">
    <name>instr/</name>
    <path>/tmp/toward_3.8.1/simgrid-git-upstream/src/instr/</path>
    <filename>dir_e4627dd4e1973fdf9f4e2b34f6210e6e.html</filename>
    <file>instr_config.c</file>
    <file>instr_interface.c</file>
    <file>instr_msg_process.c</file>
    <file>instr_msg_task.c</file>
    <file>instr_paje_containers.c</file>
    <file>instr_paje_header.c</file>
    <file>instr_paje_trace.c</file>
    <file>instr_paje_types.c</file>
    <file>instr_paje_values.c</file>
    <file>instr_private.h</file>
    <file>instr_resource_utilization.c</file>
    <file>instr_routing.c</file>
    <file>instr_smpi.c</file>
    <file>instr_surf.c</file>
  </compound>
  <compound kind="dir">
    <name>msg/</name>
    <path>/tmp/toward_3.8.1/simgrid-git-upstream/src/msg/</path>
    <filename>dir_92db932c96b71876a62b1386c1d468d9.html</filename>
    <file>msg_actions.c</file>
    <file>msg_config.c</file>
    <file>msg_deployment.c</file>
    <file>msg_environment.c</file>
    <file>msg_global.c</file>
    <file>msg_gos.c</file>
    <file>msg_host.c</file>
    <file>msg_io.c</file>
    <file>msg_mailbox.c</file>
    <file>msg_mailbox.h</file>
    <file>msg_new_api.c</file>
    <file>msg_private.h</file>
    <file>msg_process.c</file>
    <file>msg_task.c</file>
    <file>msg_vm.c</file>
  </compound>
  <compound kind="dir">
    <name>gras/Msg/</name>
    <path>/tmp/toward_3.8.1/simgrid-git-upstream/src/gras/Msg/</path>
    <filename>dir_76dbdff3ff126b3f08d70b314c25c289.html</filename>
    <file>gras_msg_exchange.c</file>
    <file>gras_msg_listener.c</file>
    <file>gras_msg_mod.c</file>
    <file>gras_msg_types.c</file>
    <file>msg_interface.h</file>
    <file>msg_private.h</file>
    <file>rl_msg.c</file>
    <file>rpc.c</file>
    <file>sg_msg.c</file>
    <file>timer.c</file>
  </compound>
  <compound kind="dir">
    <name>/tmp/toward_3.8.1/simgrid-git-upstream/include/msg/</name>
    <path>/tmp/toward_3.8.1/simgrid-git-upstream/include/msg/</path>
    <filename>dir_f4a0ada2a696f9fa1f0722f1cc886f9d.html</filename>
    <file>datatypes.h</file>
    <file>msg.h</file>
  </compound>
  <compound kind="dir">
    <name>amok/PeerManagement/</name>
    <path>/tmp/toward_3.8.1/simgrid-git-upstream/src/amok/PeerManagement/</path>
    <filename>dir_575d2cfac7ed40e52ed71ff63d36a6fc.html</filename>
    <file>peermanagement.c</file>
  </compound>
  <compound kind="dir">
    <name>simdag/</name>
    <path>/tmp/toward_3.8.1/simgrid-git-upstream/src/simdag/</path>
    <filename>dir_5b50adeb297f828a350356408820bb9d.html</filename>
    <file>dax_dtd.c</file>
    <file>dax_dtd.h</file>
    <file>private.h</file>
    <file>sd_daxloader.c</file>
    <file>sd_dotloader.c</file>
    <file>sd_global.c</file>
    <file>sd_link.c</file>
    <file>sd_task.c</file>
    <file>sd_workstation.c</file>
  </compound>
  <compound kind="dir">
    <name>/tmp/toward_3.8.1/simgrid-git-upstream/include/simdag/</name>
    <path>/tmp/toward_3.8.1/simgrid-git-upstream/include/simdag/</path>
    <filename>dir_0263ee954995510870faa4b1fe8ff434.html</filename>
    <file>datatypes.h</file>
    <file>simdag.h</file>
  </compound>
  <compound kind="dir">
    <name>/tmp/toward_3.8.1/simgrid-git-upstream/include/simgrid/</name>
    <path>/tmp/toward_3.8.1/simgrid-git-upstream/include/simgrid/</path>
    <filename>dir_6a74bcf2fcf62215754778ceca10f2c7.html</filename>
    <file>modelchecker.h</file>
    <file>platf.h</file>
    <file>platf_generator.h</file>
    <file>simix.h</file>
  </compound>
  <compound kind="dir">
    <name>simix/</name>
    <path>/tmp/toward_3.8.1/simgrid-git-upstream/src/simix/</path>
    <filename>dir_96d409525d77f9a64d47cab50cea52e6.html</filename>
    <file>smx_context.c</file>
    <file>smx_context_base.c</file>
    <file>smx_context_raw.c</file>
    <file>smx_context_sysv.c</file>
    <file>smx_context_thread.c</file>
    <file>smx_deployment.c</file>
    <file>smx_environment.c</file>
    <file>smx_global.c</file>
    <file>smx_host.c</file>
    <file>smx_host_private.h</file>
    <file>smx_io.c</file>
    <file>smx_io_private.h</file>
    <file>smx_network.c</file>
    <file>smx_network_private.h</file>
    <file>smx_new_api.c</file>
    <file>smx_new_api_private.h</file>
    <file>smx_private.h</file>
    <file>smx_process.c</file>
    <file>smx_process_private.h</file>
    <file>smx_smurf.c</file>
    <file>smx_smurf_private.h</file>
    <file>smx_synchro.c</file>
    <file>smx_synchro_private.h</file>
    <file>smx_user.c</file>
  </compound>
  <compound kind="dir">
    <name>surf/</name>
    <path>/tmp/toward_3.8.1/simgrid-git-upstream/src/surf/</path>
    <filename>dir_c640365a1f2b97689859d021e20abcd7.html</filename>
    <file>cpu_cas01.c</file>
    <file>cpu_ti.c</file>
    <file>cpu_ti_private.h</file>
    <file>fair_bottleneck.c</file>
    <file>lagrange.c</file>
    <file>maxmin.c</file>
    <file>maxmin_private.h</file>
    <file>network.c</file>
    <file>network_constant.c</file>
    <file>network_gtnets.c</file>
    <file>network_gtnets_private.h</file>
    <file>network_ns3.c</file>
    <file>network_ns3_private.h</file>
    <file>network_private.h</file>
    <file>new_model.c</file>
    <file>new_model_private.h</file>
    <file>platf_generator.c</file>
    <file>platf_generator_private.h</file>
    <file>random_mgr.c</file>
    <file>sg_platf.c</file>
    <file>simgrid_dtd.c</file>
    <file>storage.c</file>
    <file>storage_private.h</file>
    <file>surf.c</file>
    <file>surf_action.c</file>
    <file>surf_config.c</file>
    <file>surf_model.c</file>
    <file>surf_private.h</file>
    <file>surf_routing.c</file>
    <file>surf_routing_cluster.c</file>
    <file>surf_routing_dijkstra.c</file>
    <file>surf_routing_floyd.c</file>
    <file>surf_routing_full.c</file>
    <file>surf_routing_generic.c</file>
    <file>surf_routing_none.c</file>
    <file>surf_routing_private.h</file>
    <file>surf_routing_rulebased.c</file>
    <file>surf_routing_vivaldi.c</file>
    <file>surfxml_parse.c</file>
    <file>surfxml_parseplatf.c</file>
    <file>trace_mgr.c</file>
    <file>trace_mgr_private.h</file>
    <file>workstation.c</file>
    <file>workstation_ptask_L07.c</file>
  </compound>
  <compound kind="dir">
    <name>include/surf/</name>
    <path>/tmp/toward_3.8.1/simgrid-git-upstream/src/include/surf/</path>
    <filename>dir_7b471f56678bcaf979e1c230a94e387e.html</filename>
    <file>datatypes.h</file>
    <file>maxmin.h</file>
    <file>random_mgr.h</file>
    <file>surf.h</file>
    <file>surf_resource.h</file>
    <file>surf_resource_lmm.h</file>
    <file>surfxml_parse_values.h</file>
    <file>trace_mgr.h</file>
  </compound>
  <compound kind="dir">
    <name>gras/Transport/</name>
    <path>/tmp/toward_3.8.1/simgrid-git-upstream/src/gras/Transport/</path>
    <filename>dir_894d9574e027c3b1963687a8dd798986.html</filename>
    <file>rl_transport.c</file>
    <file>sg_transport.c</file>
    <file>transport.c</file>
    <file>transport_interface.h</file>
    <file>transport_plugin_file.c</file>
    <file>transport_plugin_sg.c</file>
    <file>transport_private.h</file>
  </compound>
  <compound kind="dir">
    <name>gras/Virtu/</name>
    <path>/tmp/toward_3.8.1/simgrid-git-upstream/src/gras/Virtu/</path>
    <filename>dir_9c5d41195325f39faff256e4fa61e37c.html</filename>
    <file>gras_module.c</file>
    <file>process.c</file>
    <file>rl_dns.c</file>
    <file>rl_emul.c</file>
    <file>rl_process.c</file>
    <file>sg_dns.c</file>
    <file>sg_emul.c</file>
    <file>sg_process.c</file>
    <file>virtu_interface.h</file>
    <file>virtu_private.h</file>
    <file>virtu_rl.h</file>
    <file>virtu_sg.h</file>
  </compound>
  <compound kind="dir">
    <name>xbt/</name>
    <path>/tmp/toward_3.8.1/simgrid-git-upstream/src/xbt/</path>
    <filename>dir_0fa1f9f9bfded4011a1639113cabffc9.html</filename>
    <dir>xbt/datadesc/</dir>
    <file>backtrace_dummy.c</file>
    <file>backtrace_linux.c</file>
    <file>backtrace_windows.c</file>
    <file>config.c</file>
    <file>cunit.c</file>
    <file>dict.c</file>
    <file>dict_cursor.c</file>
    <file>dict_elm.c</file>
    <file>dict_multi.c</file>
    <file>dict_private.h</file>
    <file>dynar.c</file>
    <file>ex.c</file>
    <file>ex_interface.h</file>
    <file>fifo.c</file>
    <file>fifo_private.h</file>
    <file>graph.c</file>
    <file>graph_private.h</file>
    <file>graphxml.c</file>
    <file>graphxml_parse.c</file>
    <file>heap.c</file>
    <file>heap_private.h</file>
    <file>lib.c</file>
    <file>log.c</file>
    <file>log_private.h</file>
    <file>mallocator.c</file>
    <file>mallocator_private.h</file>
    <file>parmap.c</file>
    <file>RngStream.c</file>
    <file>set.c</file>
    <file>setset.c</file>
    <file>setset_private.h</file>
    <file>snprintf.c</file>
    <file>swag.c</file>
    <file>win32_ucontext.c</file>
    <file>xbt_log_appender_file.c</file>
    <file>xbt_log_layout_format.c</file>
    <file>xbt_log_layout_simple.c</file>
    <file>xbt_main.c</file>
    <file>xbt_matrix.c</file>
    <file>xbt_os_thread.c</file>
    <file>xbt_os_time.c</file>
    <file>xbt_peer.c</file>
    <file>xbt_queue.c</file>
    <file>xbt_replay.c</file>
    <file>xbt_rl_synchro.c</file>
    <file>xbt_rl_time.c</file>
    <file>xbt_sg_stubs.c</file>
    <file>xbt_sg_synchro.c</file>
    <file>xbt_sg_time.c</file>
    <file>xbt_sha.c</file>
    <file>xbt_socket.c</file>
    <file>xbt_socket_private.h</file>
    <file>xbt_str.c</file>
    <file>xbt_strbuff.c</file>
    <file>xbt_synchro.c</file>
    <file>xbt_trp_plugin_tcp.c</file>
    <file>xbt_virtu.c</file>
  </compound>
  <compound kind="dir">
    <name>/tmp/toward_3.8.1/simgrid-git-upstream/include/xbt/</name>
    <path>/tmp/toward_3.8.1/simgrid-git-upstream/include/xbt/</path>
    <filename>dir_abfd4b05a641ac2679f98816407469af.html</filename>
    <file>asserts.h</file>
    <file>automaton.h</file>
    <file>config.h</file>
    <file>cunit.h</file>
    <file>datadesc.h</file>
    <file>dict.h</file>
    <file>dynar.h</file>
    <file>ex.h</file>
    <file>fifo.h</file>
    <file>file_stat.h</file>
    <file>function_types.h</file>
    <file>graph.h</file>
    <file>graphxml.h</file>
    <file>graphxml_parse.h</file>
    <file>hash.h</file>
    <file>heap.h</file>
    <file>lib.h</file>
    <file>log.h</file>
    <file>mallocator.h</file>
    <file>matrix.h</file>
    <file>misc.h</file>
    <file>mmalloc.h</file>
    <file>module.h</file>
    <file>parmap.h</file>
    <file>peer.h</file>
    <file>queue.h</file>
    <file>replay.h</file>
    <file>RngStream.h</file>
    <file>set.h</file>
    <file>setset.h</file>
    <file>socket.h</file>
    <file>str.h</file>
    <file>strbuff.h</file>
    <file>swag.h</file>
    <file>synchro.h</file>
    <file>synchro_core.h</file>
    <file>sysdep.h</file>
    <file>time.h</file>
    <file>virtu.h</file>
    <file>win32_ucontext.h</file>
    <file>xbt_os_thread.h</file>
  </compound>
  <compound kind="page">
    <name>index</name>
    <title>SimGrid Reference Manual</title>
    <filename>index</filename>
    <docanchor file="index">ref_guide_welcome</docanchor>
    <docanchor file="index">a_quick_glance</docanchor>
    <docanchor file="index">overview</docanchor>
    <docanchor file="index">overview_envs</docanchor>
    <docanchor file="index">overview_kernel</docanchor>
    <docanchor file="index">overview_fondation</docanchor>
    <docanchor file="index">lucas_layer</docanchor>
  </compound>
</tagfile>
