### define source packages

set(EXTRA_DIST
  src/amok/Bandwidth/bandwidth_private.h
  src/amok/amok_modinter.h
  src/gras/Transport/transport_interface.h
  src/gras/Virtu/virtu_interface.h
  src/gras/Virtu/virtu_private.h
  src/gras/Virtu/virtu_rl.h
  src/gras/Virtu/virtu_sg.h
  src/include/mc/datatypes.h
  src/include/mc/mc.h
  src/include/simgrid/platf_interface.h
  src/include/surf/datatypes.h
  src/include/surf/maxmin.h
  src/include/surf/random_mgr.h
  src/include/surf/surf.h
  src/include/surf/surf_resource.h
  src/include/surf/surf_resource_lmm.h
  src/include/surf/surfxml_parse_values.h
  src/include/surf/trace_mgr.h
  src/include/xbt/wine_dbghelp.h
  src/include/xbt/xbt_os_time.h
  src/mk_supernovae.pl
  src/msg/msg_mailbox.h
  src/msg/msg_private.h
  src/portable.h
  src/simdag/dax.dtd
  src/simdag/dax_dtd.c
  src/simdag/dax_dtd.h
  src/simdag/private.h
  src/simix/smx_host_private.h
  src/simix/smx_io_private.h
  src/simix/smx_network_private.h
  src/simix/smx_private.h
  src/simix/smx_process_private.h
  src/simix/smx_smurf_private.h
  src/simix/smx_synchro_private.h
  src/smpi/README
  src/smpi/private.h
  src/smpi/smpi_mpi_dt_private.h
  src/surf/cpu_ti_private.h
  src/surf/platf_generator_private.h
  src/surf/gtnets/gtnets_interface.h
  src/surf/gtnets/gtnets_simulator.h
  src/surf/gtnets/gtnets_topology.h
  src/surf/maxmin_private.h
  src/surf/network_gtnets_private.h
  src/surf/network_ns3_private.h
  src/surf/network_private.h
  src/surf/ns3/my-point-to-point-helper.h
  src/surf/ns3/ns3_interface.h
  src/surf/ns3/ns3_simulator.h
  src/surf/ns3/red-queue.h
  src/surf/simgrid.dtd
  src/surf/simgrid_dtd.c
  src/surf/storage_private.h
  src/surf/surf_private.h
  src/surf/surf_routing_private.h
  src/surf/surfxml_parse.c
  src/surf/trace_mgr_private.h
  src/xbt/automaton/automaton_lexer.yy.c
  src/xbt/automaton/parserPromela.lex
  src/xbt/automaton/parserPromela.tab.cacc
  src/xbt/automaton/parserPromela.tab.hacc
  src/xbt/automaton/parserPromela.yacc
  src/xbt/backtrace_dummy.c
  src/xbt/backtrace_linux.c
  src/xbt/backtrace_windows.c
  src/xbt/datadesc/ddt_parse.yy.h
  src/xbt/datadesc/ddt_parse.yy.l
  src/xbt/dict_private.h
  src/xbt/ex_interface.h
  src/xbt/fifo_private.h
  src/xbt/graph_private.h
  src/xbt/graphxml.c
  src/xbt/graphxml.dtd
  src/xbt/graphxml_parse.c
  src/xbt/heap_private.h
  src/xbt/log_private.h
  src/xbt/mallocator_private.h
  src/xbt/mmalloc/mfree.c
  src/xbt/mmalloc/mm.c
  src/xbt/mmalloc/mm_diff.c
  src/xbt/mmalloc/mm_legacy.c
  src/xbt/mmalloc/mm_module.c
  src/xbt/mmalloc/mmalloc.c
  src/xbt/mmalloc/mmalloc.info
  src/xbt/mmalloc/mmalloc.texi
  src/xbt/mmalloc/mmorecore.c
  src/xbt/mmalloc/mmprivate.h
  src/xbt/mmalloc/mmtrace.awk
  src/xbt/mmalloc/mrealloc.c
  src/xbt/setset_private.h
  tools/gras/gras_stub_generator.h
  tools/tesh/run_context.h
  tools/tesh/tesh.h
  )

set(XBT_RL_SRC
  src/xbt/xbt_rl_synchro.c
  src/xbt/xbt_rl_time.c
  )

set(XBT_SG_SRC
  src/xbt/xbt_sg_synchro.c
  src/xbt/xbt_sg_time.c
  )

set(SMPI_SRC
  src/smpi/smpi_base.c
  src/smpi/smpi_bench.c
  src/smpi/smpi_c99.c
  src/smpi/smpi_coll.c
  src/smpi/smpi_comm.c
  src/smpi/smpi_global.c
  src/smpi/smpi_group.c
  src/smpi/smpi_mpi.c
  src/smpi/smpi_mpi_dt.c
  src/smpi/smpi_pmpi.c
  src/smpi/smpi_replay.c
  )
  
if(SMPI_F2C)
  set(SMPI_SRC
    ${SMPI_SRC}
    src/smpi/smpi_f77.c
    )
else(SMPI_F2C)
  set(EXTRA_DIST
    ${EXTRA_DIST}
    src/smpi/smpi_f77.c
  )
endif(SMPI_F2C)

set(GRAS_RL_SRC
  ${XBT_RL_SRC}
  src/gras/Msg/rl_msg.c
  src/gras/Transport/rl_transport.c
  src/gras/Virtu/rl_dns.c
  src/gras/Virtu/rl_emul.c
  src/gras/Virtu/rl_process.c
  src/gras/rl_stubs.c
  src/xbt/xbt_os_thread.c
  )

set(XBT_SRC
  src/gras_modinter.h
  src/xbt/RngStream.c
  src/xbt/automaton/automaton.c
  src/xbt/automaton/automatonparse_promela.c
  src/xbt/config.c
  src/xbt/cunit.c
  src/xbt/datadesc/cbps.c
  src/xbt/datadesc/datadesc.c
  src/xbt/datadesc/datadesc_interface.h
  src/xbt/datadesc/datadesc_private.h
  src/xbt/datadesc/ddt_convert.c
  src/xbt/datadesc/ddt_create.c
  src/xbt/datadesc/ddt_exchange.c
  src/xbt/datadesc/ddt_parse.c
  src/xbt/datadesc/ddt_parse.yy.c
  src/xbt/dict.c
  src/xbt/dict_cursor.c
  src/xbt/dict_elm.c
  src/xbt/dict_multi.c
  src/xbt/dynar.c
  src/xbt/ex.c
  src/xbt/fifo.c
  src/xbt/graph.c
  src/xbt/graphxml_parse.c
  src/xbt/heap.c
  src/xbt/lib.c
  src/xbt/log.c
  src/xbt/mallocator.c
  src/xbt/parmap.c
  src/xbt/set.c
  src/xbt/setset.c
  src/xbt/snprintf.c
  src/xbt/swag.c
  src/xbt/xbt_log_appender_file.c
  src/xbt/xbt_log_layout_format.c
  src/xbt/xbt_log_layout_simple.c
  src/xbt/xbt_main.c
  src/xbt/xbt_matrix.c
  src/xbt/xbt_os_time.c
  src/xbt/xbt_peer.c
  src/xbt/xbt_queue.c
  src/xbt/xbt_replay.c
  src/xbt/xbt_sha.c
  src/xbt/xbt_socket.c
  src/xbt/xbt_socket_private.h
  src/xbt/xbt_str.c
  src/xbt/xbt_strbuff.c
  src/xbt/xbt_synchro.c
  src/xbt/xbt_trp_plugin_tcp.c
  src/xbt/xbt_virtu.c
  src/xbt_modinter.h
  )

if(HAVE_MMAP)
  set(XBT_SRC
    ${XBT_SRC}
    src/xbt/mmalloc/mm.c
    )
endif(HAVE_MMAP)

set(GTNETS_SRC
  src/surf/gtnets/gtnets_interface.cc
  src/surf/gtnets/gtnets_simulator.cc
  src/surf/gtnets/gtnets_topology.cc
  src/surf/network_gtnets.c
  )

set(NS3_SRC
  src/surf/network_ns3.c
  src/surf/ns3/my-point-to-point-helper.cc
  src/surf/ns3/ns3_interface.cc
  src/surf/ns3/ns3_simulator.cc
  src/surf/ns3/red-queue.cc
  )

set(SURF_SRC
  src/surf/cpu_cas01.c
  src/surf/cpu_ti.c
  src/surf/fair_bottleneck.c
  src/surf/lagrange.c
  src/surf/maxmin.c
  src/surf/network.c
  src/surf/network_constant.c
  src/surf/platf_generator.c
  src/surf/random_mgr.c
  src/surf/sg_platf.c
  src/surf/storage.c
  src/surf/surf.c
  src/surf/surf_action.c
  src/surf/surf_config.c
  src/surf/surf_model.c
  src/surf/surf_routing.c
  src/surf/surf_routing_cluster.c
  src/surf/surf_routing_dijkstra.c
  src/surf/surf_routing_floyd.c
  src/surf/surf_routing_full.c
  src/surf/surf_routing_generic.c
  src/surf/surf_routing_none.c
  src/surf/surf_routing_rulebased.c
  src/surf/surf_routing_vivaldi.c
  src/surf/surfxml_parse.c
  src/surf/surfxml_parseplatf.c
  src/surf/trace_mgr.c
  src/surf/workstation.c
  src/surf/workstation_ptask_L07.c
  src/xbt/xbt_sg_stubs.c
  )

set(SIMIX_SRC
  src/simix/smx_context.c
  src/simix/smx_context_base.c
  src/simix/smx_context_raw.c
  src/simix/smx_deployment.c
  src/simix/smx_environment.c
  src/simix/smx_global.c
  src/simix/smx_host.c
  src/simix/smx_io.c
  src/simix/smx_network.c
  src/simix/smx_process.c
  src/simix/smx_smurf.c
  src/simix/smx_synchro.c
  src/simix/smx_user.c
  )

set(MSG_SRC
  src/msg/msg_actions.c
  src/msg/msg_config.c
  src/msg/msg_deployment.c
  src/msg/msg_environment.c
  src/msg/msg_global.c
  src/msg/msg_gos.c
  src/msg/msg_host.c
  src/msg/msg_io.c
  src/msg/msg_mailbox.c
  src/msg/msg_process.c
  src/msg/msg_task.c
  src/msg/msg_vm.c
  )

#* ****************************************************************************************** *#
#* TUTORIAL: New API                                                                          *#

set(MSG_SRC
  ${MSG_SRC}
  src/msg/msg_new_api.c
  )
set(EXTRA_DIST
  ${EXTRA_DIST}
  src/simix/smx_new_api_private.h
  )
set(SIMIX_SRC
  ${SIMIX_SRC}
  src/simix/smx_new_api.c
)
#* ****************************************************************************************** *#

#* ****************************************************************************************** *#
#* TUTORIAL: New Model                                                                        *#

set(SURF_SRC
  ${SURF_SRC}
  src/surf/new_model.c
  )
set(EXTRA_DIST
  ${EXTRA_DIST}
  src/surf/new_model_private.h
  )
#* ****************************************************************************************** *#

set(SIMDAG_SRC
  src/simdag/sd_daxloader.c
  src/simdag/sd_global.c
  src/simdag/sd_link.c
  src/simdag/sd_task.c
  src/simdag/sd_workstation.c
  )
if(HAVE_GRAPHVIZ)
  set(SIMDAG_SRC
    ${SIMDAG_SRC} src/simdag/sd_dotloader.c
    )
else(HAVE_GRAPHVIZ)
  set(EXTRA_DIST
    ${EXTRA_DIST} src/simdag/sd_dotloader.c
    )
endif(HAVE_GRAPHVIZ)

set(GRAS_COMMON_SRC
  src/gras/Msg/gras_msg_exchange.c
  src/gras/Msg/gras_msg_listener.c
  src/gras/Msg/gras_msg_mod.c
  src/gras/Msg/gras_msg_types.c
  src/gras/Msg/msg_interface.h
  src/gras/Msg/msg_private.h
  src/gras/Msg/rpc.c
  src/gras/Msg/timer.c
  src/gras/Transport/transport.c
  src/gras/Transport/transport_plugin_file.c
  src/gras/Transport/transport_private.h
  src/gras/Virtu/gras_module.c
  src/gras/Virtu/process.c
  src/gras/gras.c
  )

set(GRAS_SG_SRC
  ${XBT_SG_SRC}
  src/gras/Msg/sg_msg.c
  src/gras/Transport/sg_transport.c
  src/gras/Transport/transport_plugin_sg.c
  src/gras/Virtu/sg_dns.c
  src/gras/Virtu/sg_emul.c
  src/gras/Virtu/sg_process.c
  )

set(AMOK_SRC
  src/amok/Bandwidth/bandwidth.c
  src/amok/Bandwidth/saturate.c
  src/amok/PeerManagement/peermanagement.c
  src/amok/amok_base.c
  )

set(BINDINGS_SRC
  src/bindings/bindings_global.c
  src/bindings/lua/lua_private.h
  src/bindings/lua/lua_state_cloner.h
  src/bindings/lua/lua_utils.h
  src/bindings/lua/simgrid_lua.h
  )

set(LUA_SRC
  src/bindings/lua/lua_comm.c
  src/bindings/lua/lua_host.c
  src/bindings/lua/lua_platf.c
  src/bindings/lua/lua_process.c
  src/bindings/lua/lua_state_cloner.c
  src/bindings/lua/lua_stub_generator.c
  src/bindings/lua/lua_task.c
  src/bindings/lua/lua_utils.c
  src/bindings/lua/simgrid_lua.c
  )

set(TRACING_SRC
  src/instr/instr_config.c
  src/instr/instr_interface.c
  src/instr/instr_msg_process.c
  src/instr/instr_msg_task.c
  src/instr/instr_paje_containers.c
  src/instr/instr_paje_trace.c
  src/instr/instr_paje_header.c
  src/instr/instr_paje_types.c
  src/instr/instr_paje_values.c
  src/instr/instr_private.h
  src/instr/instr_resource_utilization.c
  src/instr/instr_routing.c
  src/instr/instr_smpi.c
  src/instr/instr_surf.c
  )

set(JEDULE_SRC
  include/instr/jedule/jedule_events.h
  include/instr/jedule/jedule_output.h
  include/instr/jedule/jedule_platform.h
  include/instr/jedule/jedule_sd_binding.h
  src/instr/jedule/jedule_events.c
  src/instr/jedule/jedule_output.c
  src/instr/jedule/jedule_platform.c
  src/instr/jedule/jedule_sd_binding.c
  )

set(MC_SRC
  src/mc/mc_checkpoint.c
  src/mc/mc_compare.c
  src/mc/mc_dpor.c
  src/mc/mc_global.c
  src/mc/mc_liveness.c
  src/mc/mc_memory.c
  src/mc/mc_private.h
  src/mc/mc_request.c
  src/mc/mc_state.c
  src/mc/memory_map.c
  src/mc/test/heap_comparison.c
  )

set(headers_to_install
  include/amok/bandwidth.h
  include/amok/peermanagement.h
  include/gras.h
  include/gras/emul.h
  include/gras/messages.h
  include/gras/module.h
  include/gras/process.h
  include/gras/timer.h
  include/gras/transport.h
  include/gras/virtu.h
  include/instr/instr.h
  include/msg/datatypes.h
  include/msg/msg.h
  include/simdag/datatypes.h
  include/simdag/simdag.h
  include/simgrid/modelchecker.h
  include/simgrid/platf.h
  include/simgrid/platf_generator.h
  include/simgrid/simix.h
  include/smpi/mpi.h
  include/smpi/mpif.h
  include/smpi/smpi.h
  include/smpi/smpi_cocci.h
  include/surf/simgrid_dtd.h
  include/surf/surf_routing.h
  include/surf/surfxml_parse.h
  include/xbt.h
  include/xbt/RngStream.h
  include/xbt/asserts.h
  include/xbt/automaton.h
  include/xbt/config.h
  include/xbt/cunit.h
  include/xbt/datadesc.h
  include/xbt/dict.h
  include/xbt/dynar.h
  include/xbt/ex.h
  include/xbt/fifo.h
  include/xbt/file_stat.h
  include/xbt/function_types.h
  include/xbt/graph.h
  include/xbt/graphxml.h
  include/xbt/graphxml_parse.h
  include/xbt/hash.h
  include/xbt/heap.h
  include/xbt/lib.h
  include/xbt/log.h
  include/xbt/mallocator.h
  include/xbt/matrix.h
  include/xbt/misc.h
  include/xbt/mmalloc.h
  include/xbt/module.h
  include/xbt/parmap.h
  include/xbt/peer.h
  include/xbt/queue.h
  include/xbt/replay.h
  include/xbt/set.h
  include/xbt/setset.h
  include/xbt/socket.h
  include/xbt/str.h
  include/xbt/strbuff.h
  include/xbt/swag.h
  include/xbt/synchro.h
  include/xbt/synchro_core.h
  include/xbt/sysdep.h
  include/xbt/time.h
  include/xbt/virtu.h
  include/xbt/xbt_os_thread.h
  )
set(source_of_generated_headers
  include/simgrid_config.h.in
  include/smpi/smpif.h.in
  src/context_sysv_config.h.in)

### depend of some variables setted upper
# -->CONTEXT_THREADS CONTEXT_UCONTEXT
if(${CONTEXT_THREADS}) #pthread
  set(SURF_SRC
    ${SURF_SRC}
    src/simix/smx_context_thread.c
    src/xbt/xbt_os_thread.c
    )
else(${CONTEXT_THREADS}) # NOT pthread
  set(EXTRA_DIST
    ${EXTRA_DIST}
    src/simix/smx_context_thread.c
    src/xbt/xbt_os_thread.c
    )
endif(${CONTEXT_THREADS})

if(${CONTEXT_UCONTEXT}) #ucontext
  set(SURF_SRC
    ${SURF_SRC}
    src/simix/smx_context_sysv.c
    )
else(${CONTEXT_UCONTEXT}) # NOT ucontext
  set(EXTRA_DIST
    ${EXTRA_DIST}
    src/simix/smx_context_sysv.c
    )
endif(${CONTEXT_UCONTEXT})

# -->HAVE_GTNETS
if(HAVE_GTNETS)
  set(GTNETS_USED
    ${GTNETS_SRC}
    )
else(HAVE_GTNETS)
  set(GTNETS_USED "")
  set(EXTRA_DIST
    ${EXTRA_DIST}
    ${GTNETS_SRC}
    )
endif(HAVE_GTNETS)

### Simgrid Lib sources
set(simgrid_sources
  ${AMOK_SRC}
  ${BINDINGS_SRC}
  ${GRAS_COMMON_SRC}
  ${GRAS_SG_SRC}
  ${GTNETS_USED}
  ${JEDULE_SRC}
  ${MSG_SRC}
  ${SIMDAG_SRC}
  ${SIMIX_SRC}
  ${SURF_SRC}
  ${TRACING_SRC}
  ${XBT_SRC}
  )

if(HAVE_MC)
  set(simgrid_sources
    ${simgrid_sources}
    ${MC_SRC}
    )
endif(HAVE_MC)

if(HAVE_NS3)
  set(simgrid_sources
    ${simgrid_sources}
    ${NS3_SRC}
    )
endif(HAVE_NS3)

# WINDOWS
if(WIN32)
  set(simgrid_sources
    ${simgrid_sources}
    src/simix/smx_context_thread.c
    src/xbt/win32_ucontext.c
    src/xbt/xbt_os_thread.c
    )
endif(WIN32)

### Gras Lib sources
set(gras_sources
  ${AMOK_SRC}
  ${GRAS_COMMON_SRC}
  ${GRAS_RL_SRC}
  ${XBT_SRC}
  )

if(${HAVE_LUA})
  set(simgrid_sources
    ${simgrid_sources}
    ${LUA_SRC}
    )
else(${HAVE_LUA})
  set(EXTRA_DIST
    ${EXTRA_DIST}
    ${LUA_SRC}
    )
endif(${HAVE_LUA})

set(DOC_SOURCES
  doc/amok_bw_sat.png
  doc/amok_bw_test.png
  doc/AS_hierarchy.png
  doc/gras_comm.png
  doc/sg_thread_model.fig
  doc/simix.fig
  doc/surf_nutshell.fig
  doc/Doxyfile.in
  doc/FAQ.doc
  doc/index.doc
  doc/simgrid.css
  doc/SimgridDoxygenLayout.xml
  doc/triva-graph_configuration.png
  doc/triva-graph_visualization.png
  doc/triva-time_interval.png
  )

set(DOC_FIGS
  ${CMAKE_HOME_DIRECTORY}/doc/shared/fig/simgrid_modules.fig
  ${CMAKE_HOME_DIRECTORY}/doc/shared/fig/simgrid_modules2.fig
  )
  
set(DOC_SHARED_TAG
  doc/shared/doxygen/simgriddevguide.tag
  doc/shared/doxygen/simgridrefguide.tag
  doc/shared/doxygen/simgriduserguide.tag
  )
  
set(DOC_TOOLS
  tools/doxygen/fig2dev_postprocessor.pl
  tools/doxygen/index_create.pl
  tools/doxygen/xbt_log_extract_hierarchy.pl
  )

set(DOC_GTUT_SRC
  doc/gtut-files/01-bones.c
  doc/gtut-files/01-bones.output
  doc/gtut-files/02-simple.c
  doc/gtut-files/02-simple.output
  doc/gtut-files/03-args.c
  doc/gtut-files/03-args.output
  doc/gtut-files/03-args.xml
  doc/gtut-files/04-callback.c
  doc/gtut-files/04-callback.output
  doc/gtut-files/05-globals.c
  doc/gtut-files/05-globals.output
  doc/gtut-files/06-logs.c
  doc/gtut-files/06-logs.output
  doc/gtut-files/06-logs.output.error
  doc/gtut-files/06-logs.output.fmt
  doc/gtut-files/06-logs.output.fmt-bt
  doc/gtut-files/06-logs.output.verbose
  doc/gtut-files/07-timers.c
  doc/gtut-files/07-timers.output
  doc/gtut-files/08-exceptions.c
  doc/gtut-files/08-exceptions.output
  doc/gtut-files/09-datatype-dump.c
  doc/gtut-files/09-simpledata.c
  doc/gtut-files/09-simpledata.output
  doc/gtut-files/10-rpc.c
  doc/gtut-files/10-rpc.output
  doc/gtut-files/11-explicitwait.c
  doc/gtut-files/11-explicitwait.output
  doc/gtut-files/11-explicitwait.xml
  doc/gtut-files/gtut-platform-3nodes.xml
  doc/gtut-files/gtut-platform.xml
  doc/gtut-files/Makefile
  doc/gtut-files/README
  doc/gtut-files/test.xml
)

set(USER_GUIDE_SOURCES
  doc/user_guide/doxygen/footer.html
  doc/user_guide/doxygen/header.html
  doc/user_guide/doxygen/UserGuideDoxyfile.in
  doc/user_guide/doxygen/UserGuideDoxygenLayout.xml
  doc/user_guide/doxygen/bindings.doc
  doc/user_guide/doxygen/deployment.doc
  doc/user_guide/doxygen/examples.doc
  doc/user_guide/doxygen/index.doc
  doc/user_guide/doxygen/install.doc
  doc/user_guide/doxygen/options.doc
  doc/user_guide/doxygen/platform.doc
  doc/user_guide/doxygen/pls.doc
  doc/user_guide/doxygen/tracing.doc
  doc/user_guide/doxygen/use.doc
  doc/user_guide/doxygen/stylesheet.css
  )
  
set(LISTE_GTUT
    doc/gtut-files/gtut-tour-00-install.doc
    doc/gtut-files/gtut-tour-01-bones.doc
    doc/gtut-files/gtut-tour-02-simple.doc
    doc/gtut-files/gtut-tour-03-args.doc
    doc/gtut-files/gtut-tour-04-callback.doc
    doc/gtut-files/gtut-tour-05-globals.doc
    doc/gtut-files/gtut-tour-06-logs.doc
    doc/gtut-files/gtut-tour-07-timers.doc
    doc/gtut-files/gtut-tour-08-exceptions.doc
    doc/gtut-files/gtut-tour-09-simpledata.doc
    doc/gtut-files/gtut-tour-10-rpc.doc
    doc/gtut-files/gtut-tour-11-explicitwait.doc
    doc/gtut-files/gtut-tour-12-staticstruct.doc
    doc/gtut-files/gtut-tour-13-pointers.doc
    doc/gtut-files/gtut-tour-14-dynar.doc
    doc/gtut-files/gtut-tour-15-manualdatadef.doc
    doc/gtut-files/gtut-tour-16-exchangecb.doc
    doc/gtut-files/gtut-tour.doc
    doc/gtut-files/gtut-tour-recap-messages.doc
  )

set(EXTRA_LISTE_GTUT
    doc/gtut-files/01-bones.output
    doc/gtut-files/02-simple.output
    doc/gtut-files/03-args.output
    doc/gtut-files/03-args.xml
    doc/gtut-files/04-callback.output
    doc/gtut-files/05-globals.output
    doc/gtut-files/06-logs.output
    doc/gtut-files/06-logs.output.error
    doc/gtut-files/06-logs.output.fmt
    doc/gtut-files/06-logs.output.fmt-bt
    doc/gtut-files/06-logs.output.verbose
    doc/gtut-files/07-timers.output
    doc/gtut-files/08-exceptions.output
    doc/gtut-files/09-simpledata.output
    doc/gtut-files/10-rpc.output
    doc/gtut-files/11-explicitwait.output
    doc/gtut-files/11-explicitwait.xml
    doc/gtut-files/gtut-howto-design.doc
    doc/gtut-files/gtut-howto.doc
    doc/gtut-files/gtut-introduction.doc
    doc/gtut-files/gtut-main.doc
    doc/gtut-files/gtut-platform-3nodes.xml
    doc/gtut-files/gtut-platform.xml
    doc/gtut-files/README
    doc/gtut-files/test.xml
    )
  
set(REF_GUIDE_SOURCES
  doc/ref_guide/doxygen/footer.html
  doc/ref_guide/doxygen/header.html
  doc/ref_guide/doxygen/main.doc
  doc/ref_guide/doxygen/module-amok.doc
  doc/ref_guide/doxygen/module-gras.doc
  doc/ref_guide/doxygen/module-msg.doc
  doc/ref_guide/doxygen/module-sd.doc
  doc/ref_guide/doxygen/module-simix.doc
  doc/ref_guide/doxygen/module-surf.doc
  doc/ref_guide/doxygen/module-trace.doc
  doc/ref_guide/doxygen/module-xbt.doc
  doc/ref_guide/doxygen/modules.doc
  doc/ref_guide/doxygen/RefGuideDoxyfile.in
  doc/ref_guide/doxygen/RefGuideDoxygenLayout.xml
  doc/ref_guide/doxygen/stylesheet.css
  )

set(DEV_GUIDE_SOURCES
  doc/dev_guide/doxygen/footer.html
  doc/dev_guide/doxygen/header.html
  doc/dev_guide/doxygen/index.doc
  doc/dev_guide/doxygen/cmake.doc
  doc/dev_guide/doxygen/simgrid.doc
  doc/dev_guide/doxygen/xps.doc
  doc/dev_guide/doxygen/DevGuideDoxyfile.in
  doc/dev_guide/doxygen/DevGuideDoxygenLayout.xml
  doc/dev_guide/doxygen/stylesheet.css
  )

set(DOC_IMG
${CMAKE_HOME_DIRECTORY}/doc/webcruft/awstats_logo3.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/Paje_MSG_screenshot.jpg
${CMAKE_HOME_DIRECTORY}/doc/webcruft/Paje_MSG_screenshot_thn.jpg
${CMAKE_HOME_DIRECTORY}/doc/webcruft/poster_thumbnail.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/README
${CMAKE_HOME_DIRECTORY}/doc/webcruft/SGicon.gif
${CMAKE_HOME_DIRECTORY}/doc/webcruft/SGicon.icns
${CMAKE_HOME_DIRECTORY}/doc/webcruft/SGicon.ico
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101_001.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101_002.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101_003.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101_004.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101_005.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101_006.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101_007.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101_008.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101_009.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101_010.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101_011.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101_012.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101_013.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101_014.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101_015.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101_016.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101_017.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101_018.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101_019.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101_020.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101_021.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101_022.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101_023.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101_024.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101_025.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101_026.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101_027.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101_028.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101_029.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101_030.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid-101.pdf
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid_logo_2011.gif
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid_logo_2011.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid_logo_2011_small.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid_logo_win_2011.bmp
${CMAKE_HOME_DIRECTORY}/doc/webcruft/simgrid_logo_win.bmp
${CMAKE_HOME_DIRECTORY}/doc/webcruft/win_install_01.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/win_install_02.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/win_install_03.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/win_install_04.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/win_install_05.png
${CMAKE_HOME_DIRECTORY}/doc/webcruft/win_install_06.png
)

set(bin_files
  ${bin_files}
  src/smpi/smpicc.in
  src/smpi/smpif2c.in
  src/smpi/smpiff.in
  src/smpi/smpirun.in
  )

set(txt_files
  ${txt_files}
  AUTHORS
  COPYING
  ChangeLog
  INSTALL
  LICENSE-LGPL-2.1
  NEWS
  TODO
  configure
  )

set(EXAMPLES_CMAKEFILES_TXT
  examples/amok/bandwidth/CMakeLists.txt
  examples/amok/saturate/CMakeLists.txt
  examples/gras/all2all/CMakeLists.txt
  examples/gras/chrono/CMakeLists.txt
  examples/gras/console/CMakeLists.txt
  examples/gras/mmrpc/CMakeLists.txt
  examples/gras/mutual_exclusion/simple_token/CMakeLists.txt
  examples/gras/ping/CMakeLists.txt
  examples/gras/pmm/CMakeLists.txt
  examples/gras/properties/CMakeLists.txt
  examples/gras/rpc/CMakeLists.txt
  examples/gras/spawn/CMakeLists.txt
  examples/gras/synchro/CMakeLists.txt
  examples/gras/timer/CMakeLists.txt
  examples/lua/CMakeLists.txt
  examples/msg/CMakeLists.txt
  examples/msg/actions/CMakeLists.txt
  examples/msg/bittorrent/CMakeLists.txt
  examples/msg/chord/CMakeLists.txt
  examples/msg/cloud/CMakeLists.txt
  examples/msg/gpu/CMakeLists.txt
  examples/msg/gtnets/CMakeLists.txt
  examples/msg/icomms/CMakeLists.txt
  examples/msg/io/CMakeLists.txt
  examples/msg/kademlia/CMakeLists.txt
  examples/msg/masterslave/CMakeLists.txt
  examples/msg/mc/CMakeLists.txt
  examples/msg/migration/CMakeLists.txt
  examples/msg/ns3/CMakeLists.txt
  examples/msg/parallel_task/CMakeLists.txt
  examples/msg/pmm/CMakeLists.txt
  examples/msg/priority/CMakeLists.txt
  examples/msg/properties/CMakeLists.txt
  examples/msg/sendrecv/CMakeLists.txt
  examples/msg/start_kill_time/CMakeLists.txt
  examples/msg/suspend/CMakeLists.txt
  examples/msg/token_ring/CMakeLists.txt
  examples/msg/tracing/CMakeLists.txt
  examples/simdag/CMakeLists.txt
  examples/simdag/dax/CMakeLists.txt
  examples/simdag/dot/CMakeLists.txt
  examples/simdag/goal/CMakeLists.txt
  examples/simdag/metaxml/CMakeLists.txt
  examples/simdag/properties/CMakeLists.txt
  examples/simdag/scheduling/CMakeLists.txt
  examples/smpi/CMakeLists.txt
  examples/smpi/MM/CMakeLists.txt
  examples/xbt/CMakeLists.txt
  )

set(TESHSUITE_CMAKEFILES_TXT
  teshsuite/CMakeLists.txt
  teshsuite/gras/CMakeLists.txt
  teshsuite/gras/datadesc/CMakeLists.txt
  teshsuite/gras/empty_main/CMakeLists.txt
  teshsuite/gras/msg_handle/CMakeLists.txt
  teshsuite/gras/small_sleep/CMakeLists.txt
  teshsuite/msg/CMakeLists.txt
  teshsuite/msg/trace/CMakeLists.txt
  teshsuite/simdag/CMakeLists.txt
  teshsuite/simdag/network/CMakeLists.txt
  teshsuite/simdag/network/mxn/CMakeLists.txt
  teshsuite/simdag/network/p2p/CMakeLists.txt
  teshsuite/simdag/partask/CMakeLists.txt
  teshsuite/simdag/platforms/CMakeLists.txt
  teshsuite/xbt/CMakeLists.txt
  teshsuite/smpi/CMakeLists.txt
  )

set(TOOLS_CMAKEFILES_TXT
  tools/CMakeLists.txt
  tools/graphicator/CMakeLists.txt
  tools/gras/CMakeLists.txt
  tools/tesh/CMakeLists.txt
  )

set(TESTSUITE_CMAKEFILES_TXT
  testsuite/surf/CMakeLists.txt
  testsuite/xbt/CMakeLists.txt
  )

set(CMAKE_SOURCE_FILES
  CMakeLists.txt
  buildtools/Cmake/AddTests.cmake
  buildtools/Cmake/CTestConfig.cmake
  buildtools/Cmake/CompleteInFiles.cmake
  buildtools/Cmake/DefinePackages.cmake
  buildtools/Cmake/Distrib.cmake
  buildtools/Cmake/Flags.cmake
  buildtools/Cmake/GenerateDoc.cmake
  buildtools/Cmake/GenerateDocWin.cmake
  buildtools/Cmake/GenerateRefGuide.cmake
  buildtools/Cmake/GenerateUserGuide.cmake
  buildtools/Cmake/GenerateDevGuide.cmake
  buildtools/Cmake/MaintainerMode.cmake
  buildtools/Cmake/MakeExe.cmake
  buildtools/Cmake/MakeLib.cmake
  buildtools/Cmake/MakeLibWin.cmake
  buildtools/Cmake/Modules/FindF2c.cmake
  buildtools/Cmake/Modules/FindGTnets.cmake
  buildtools/Cmake/Modules/FindGraphviz.cmake
  buildtools/Cmake/Modules/FindLua51Simgrid.cmake
  buildtools/Cmake/Modules/FindNS3.cmake
  buildtools/Cmake/Modules/FindPCRE.cmake
  buildtools/Cmake/Modules/FindPcreWin.cmake
  buildtools/Cmake/Modules/FindRngStream.cmake
  buildtools/Cmake/Modules/FindRubySimgrid.cmake
  buildtools/Cmake/Modules/FindSimGrid.cmake
  buildtools/Cmake/Modules/FindValgrind.cmake
  buildtools/Cmake/Modules/FindLibunwind.cmake
  buildtools/Cmake/Option.cmake
  buildtools/Cmake/Pipol.cmake
  buildtools/Cmake/PrintArgs.cmake
  buildtools/Cmake/Scripts/Diff.pm
  buildtools/Cmake/Scripts/Makefile.default
  buildtools/Cmake/Scripts/SimGrid.packproj
  buildtools/Cmake/Scripts/generate_memcheck_tests.pl
  buildtools/Cmake/Scripts/generate_new_tests.pl
  buildtools/Cmake/Scripts/my_valgrind.pl
  buildtools/Cmake/Scripts/postinstall.sh
  buildtools/Cmake/Scripts/preinstall.sh
  buildtools/Cmake/Scripts/tesh.pl
  buildtools/Cmake/Scripts/test_java.sh
  buildtools/Cmake/Scripts/update_tesh.pl
  buildtools/Cmake/Supernovae.cmake
  buildtools/Cmake/UnitTesting.cmake
  buildtools/Cmake/src/gras_config.h.in
  buildtools/Cmake/src/simgrid.nsi.in
  buildtools/Cmake/test_prog/prog_AC_CHECK_MCSC.c
  buildtools/Cmake/test_prog/prog_GRAS_ARCH.c
  buildtools/Cmake/test_prog/prog_GRAS_CHECK_STRUCT_COMPACTION.c
  buildtools/Cmake/test_prog/prog_getline.c
  buildtools/Cmake/test_prog/prog_max_size.c
  buildtools/Cmake/test_prog/prog_mutex_timedlock.c
  buildtools/Cmake/test_prog/prog_printf_null.c
  buildtools/Cmake/test_prog/prog_sem_init.c
  buildtools/Cmake/test_prog/prog_sem_open.c
  buildtools/Cmake/test_prog/prog_sem_timedwait.c
  buildtools/Cmake/test_prog/prog_snprintf.c
  buildtools/Cmake/test_prog/prog_stackgrowth.c
  buildtools/Cmake/test_prog/prog_stacksetup.c
  buildtools/Cmake/test_prog/prog_thread_storage.c
  buildtools/Cmake/test_prog/prog_va_copy.c
  buildtools/Cmake/test_prog/prog_vsnprintf.c
  )

set(PLATFORMS_EXAMPLES
  examples/platforms/bypassASroute.xml
  examples/platforms/bypassRoute.xml
  examples/platforms/cloud.xml
  examples/platforms/cluster.xml
  examples/platforms/cluster_and_one_host.xml
  examples/platforms/cluster_no_backbone.xml
  examples/platforms/cluster_routing_rulebased.xml
  examples/platforms/clusters_routing_full.xml
  examples/platforms/conf/gridpp_grid_2004.conf
  examples/platforms/conf/gridpp_grid_2004.xml
  examples/platforms/conf/lcg_sept2004_grid.conf
  examples/platforms/conf/lcg_sept2004_grid.xml
  examples/platforms/conf/transform_optorsim_platform.pl
  examples/platforms/config.xml
  examples/platforms/content/storage_content.txt
  examples/platforms/data_center.xml
  examples/platforms/g5k.xml
  examples/platforms/generation_scripts/create_hierarchical_clusters.pl
  examples/platforms/generation_scripts/enhancedDTDwithHierarchicalCluster.pl
  examples/platforms/generation_scripts/generate_g5k_platform.pl
  examples/platforms/generation_scripts/generate_g5k_platform_cabinets.pl
  examples/platforms/griffon.xml
  examples/platforms/multicore_machine.xml
  examples/platforms/prop.xml
  examples/platforms/storage.xml
  examples/platforms/syscoord/generate_peer_platform.pl
  examples/platforms/syscoord/median_harvard.syscoord
  examples/platforms/syscoord/median_harvard.xml
  examples/platforms/syscoord/median_meridian.syscoord
  examples/platforms/syscoord/median_meridian.xml
  examples/platforms/syscoord/median_p2psim.syscoord
  examples/platforms/syscoord/median_p2psim.xml
  examples/platforms/vivaldi.xml
  examples/platforms/routing_cluster.xml
  examples/platforms/meta_cluster.xml
  examples/platforms/two_peers.xml
  )

set(generated_src_files
  ${CMAKE_HOME_DIRECTORY}/src/xbt/datadesc/ddt_parse.yy.c
  src/xbt/automaton/automaton_lexer.yy.c
  src/xbt/automaton/parserPromela.tab.cacc
  src/xbt/automaton/parserPromela.tab.hacc
  )

foreach(file ${generated_src_files})
  set_source_files_properties(${file} PROPERTIES GENERATED true)
endforeach(file ${generated_src_files})
