### define source packages

set(EXTRA_DIST 
	src/portable.h
	src/xbt/mallocator_private.h
	src/xbt/dict_private.h
	src/xbt/heap_private.h
	src/xbt/fifo_private.h
	src/xbt/graph_private.h
	src/xbt/graphxml_parse.c
	src/xbt/graphxml.c
	src/xbt/graphxml.dtd
	src/xbt/log_private.h
	src/xbt/ex_interface.h
	src/xbt/backtrace_linux.c
	src/xbt/backtrace_windows.c
	src/xbt/backtrace_dummy.c
	src/xbt/setset_private.h
	src/xbt/automatonparse_promela.c
	src/xbt/mmalloc/mfree.c
	src/xbt/mmalloc/mmalloc.c
	src/xbt/mmalloc/mmalloc.info
	src/xbt/mmalloc/mmalloc.texi
	src/xbt/mmalloc/mm.c
    src/xbt/mmalloc/mm_diff.c
	src/xbt/mmalloc/mm_legacy.c
	src/xbt/mmalloc/mm_module.c
	src/xbt/mmalloc/mmorecore.c
	src/xbt/mmalloc/mmprivate.h		
	src/xbt/mmalloc/mmtrace.awk
	src/xbt/mmalloc/mrealloc.c	
	src/xbt/mmalloc/test/mmalloc_test.c
	src/xbt/datadesc/ddt_parse.yy.l
	src/xbt/datadesc/ddt_parse.yy.h
	src/surf/maxmin_private.h
	src/surf/trace_mgr_private.h
	src/surf/surf_private.h
	src/surf/surfxml_parse.c
	src/surf/simgrid_dtd.c
	src/surf/simgrid.dtd
	src/surf/network_private.h
	src/surf/storage_private.h
	src/surf/network_gtnets_private.h
	src/surf/gtnets/gtnets_interface.h
	src/surf/gtnets/gtnets_simulator.h
	src/surf/gtnets/gtnets_topology.h
	src/surf/cpu_ti_private.h
	src/surf/surf_routing_private.h
	src/include/simgrid/platf_interface.h
	src/include/surf/surf_resource.h
	src/include/surf/datatypes.h
	src/include/surf/maxmin.h
	src/include/surf/trace_mgr.h
	src/include/surf/surf.h
	src/include/surf/surfxml_parse_values.h
	src/include/surf/random_mgr.h
	src/include/surf/surf_resource_lmm.h
	src/include/xbt/wine_dbghelp.h
	src/include/xbt/xbt_os_time.h
	src/include/mc/datatypes.h
	src/include/mc/mc.h
	src/msg/msg_private.h
	src/msg/msg_mailbox.h
	src/simdag/private.h
	src/simdag/dax.dtd
	src/simdag/dax_dtd.h
	src/simdag/dax_dtd.c
	src/gras/Virtu/virtu_rl.h
	src/gras/Virtu/virtu_sg.h
	src/gras/Virtu/virtu_interface.h
	src/gras/Virtu/virtu_private.h
	src/gras/Transport/transport_interface.h
	src/amok/Bandwidth/bandwidth_private.h
	src/amok/amok_modinter.h
	src/simix/smx_private.h
	src/simix/smx_process_private.h
	src/simix/smx_host_private.h
	src/simix/smx_network_private.h
	src/simix/smx_smurf_private.h
	src/simix/smx_synchro_private.h
	src/simix/smx_io_private.h
	
	src/smpi/private.h
	src/smpi/smpi_mpi_dt_private.h
	src/smpi/README
	src/mk_supernovae.pl
	
	examples/gras/ping/ping.h
	examples/gras/console/ping.h
	examples/gras/mmrpc/mmrpc.h
	
    examples/msg/mc/parserPromela.yacc
    examples/msg/mc/parserPromela.lex
    examples/msg/mc/automaton.h
    examples/msg/mc/bugged1_liveness.h
    examples/msg/mc/centralized_liveness.h
    examples/msg/mc/automatonparse_promela.h
    examples/msg/mc/bugged2_liveness.h
    examples/msg/mc/y.tab.h

    examples/platforms/content/storage_content.txt

	tools/gras/gras_stub_generator.h
	tools/tesh/run_context.h  
	tools/tesh/tesh.h
	
	src/surf/network_ns3_private.h
	src/surf/ns3/ns3_interface.h
	src/surf/ns3/ns3_simulator.h
	src/surf/ns3/my-point-to-point-helper.h
	src/surf/ns3/red-queue.h
)

set(XBT_RL_SRC 
	src/xbt/xbt_rl_synchro.c
	src/xbt/xbt_rl_time.c
)

set(XBT_SG_SRC 
	src/xbt/xbt_sg_synchro.c
	src/xbt/xbt_sg_time.c
)     

set(SMPI_SRC
	src/smpi/smpi_base.c
	src/smpi/smpi_bench.c
	src/smpi/smpi_global.c
	src/smpi/smpi_mpi.c
	src/smpi/smpi_pmpi.c
	src/smpi/smpi_c99.c
	src/smpi/smpi_f77.c
	src/smpi/smpi_comm.c
	src/smpi/smpi_group.c
	src/smpi/smpi_coll.c
	src/smpi/smpi_mpi_dt.c
)


set(GRAS_RL_SRC
	src/gras/rl_stubs.c
	src/xbt/xbt_os_thread.c
	src/gras/Transport/rl_transport.c
	src/gras/Virtu/rl_emul.c
	src/gras/Virtu/rl_process.c
	src/gras/Virtu/rl_dns.c
	src/gras/Msg/rl_msg.c
	${XBT_RL_SRC}
)

set(XBT_SRC 
	src/xbt/snprintf.c
	src/xbt/xbt_str.c
	src/xbt/xbt_strbuff.c
	src/xbt/xbt_sha.c
	src/xbt/ex.c
	src/xbt_modinter.h
	src/gras_modinter.h
	src/xbt/xbt_virtu.c
	src/xbt/xbt_os_time.c
	src/xbt/log.c
	src/xbt/xbt_log_appender_file.c
	src/xbt/xbt_log_layout_simple.c
	src/xbt/xbt_log_layout_format.c
	src/xbt/mallocator.c
	src/xbt/dynar.c
	src/xbt/dict.c
	src/xbt/dict_elm.c
	src/xbt/dict_cursor.c
	src/xbt/dict_multi.c
	src/xbt/heap.c
	src/xbt/fifo.c
	src/xbt/swag.c
	src/xbt/graph.c
	src/xbt/set.c
	src/xbt/xbt_matrix.c
	src/xbt/xbt_queue.c
	src/xbt/xbt_synchro.c
	src/xbt/xbt_peer.c
	src/xbt/xbt_main.c
	src/xbt/config.c
	src/xbt/cunit.c
	src/xbt/graphxml_parse.c
	src/xbt/setset.c
	src/xbt/parmap.c
	src/xbt/xbt_replay_trace_reader.c
	src/xbt/lib.c
	src/xbt/automaton.c
	src/xbt/datadesc/ddt_create.c
	src/xbt/datadesc/ddt_convert.c
	src/xbt/datadesc/ddt_exchange.c
	src/xbt/datadesc/cbps.c
	src/xbt/datadesc/datadesc.c
	src/xbt/datadesc/datadesc_interface.h
	src/xbt/datadesc/datadesc_private.h
	src/xbt/datadesc/ddt_parse.c
	src/xbt/datadesc/ddt_parse.yy.c
	src/xbt/xbt_socket.c
	src/xbt/xbt_socket_private.h
	src/xbt/xbt_trp_plugin_tcp.c
)

if(HAVE_MMAP)
	set(XBT_SRC
	${XBT_SRC}
	src/xbt/mmalloc/mm.c	
	)
endif(HAVE_MMAP)

set(GTNETS_SRC 
	src/surf/gtnets/gtnets_simulator.cc
	src/surf/gtnets/gtnets_topology.cc
	src/surf/gtnets/gtnets_interface.cc
	src/surf/network_gtnets.c
)

set(NS3_SRC
	src/surf/network_ns3.c
	src/surf/ns3/ns3_interface.cc
	src/surf/ns3/ns3_simulator.cc
	src/surf/ns3/red-queue.cc
	src/surf/ns3/my-point-to-point-helper.cc
)
	
set(SURF_SRC 
	src/surf/surf_model.c
	src/surf/surf_action.c
	src/surf/surf_routing.c
	src/surf/surf_routing_none.c
	src/surf/surf_routing_generic.c
	src/surf/surf_routing_full.c
	src/surf/surf_routing_floyd.c
	src/surf/surf_routing_rulebased.c
	src/surf/surf_routing_dijkstra.c
	src/surf/surf_routing_cluster.c
	src/surf/surf_routing_vivaldi.c
	src/surf/surf_config.c
	src/surf/maxmin.c
	src/surf/fair_bottleneck.c
	src/surf/lagrange.c
	src/surf/trace_mgr.c
	src/surf/random_mgr.c
	src/surf/surf.c
	src/surf/surfxml_parse.c
	src/surf/surfxml_parseplatf.c
	src/surf/network.c
	src/surf/network_constant.c
	src/surf/workstation.c
	src/surf/workstation_ptask_L07.c
	src/surf/cpu_ti.c
	src/surf/cpu_cas01.c
	src/surf/sg_platf.c
	src/surf/storage.c
	src/xbt/xbt_sg_stubs.c
)

set(SIMIX_SRC 
	src/simix/smx_global.c
	src/simix/smx_deployment.c
	src/simix/smx_environment.c
	src/simix/smx_host.c
	src/simix/smx_process.c
	src/simix/smx_context.c
	src/simix/smx_synchro.c
	src/simix/smx_network.c
	src/simix/smx_context_base.c
	src/simix/smx_user.c
	src/simix/smx_smurf.c
	src/simix/smx_context_raw.c
	src/simix/smx_io.c
)

set(MSG_SRC
	src/msg/msg_config.c
	src/msg/msg_task.c
	src/msg/msg_host.c
	src/msg/msg_io.c
	src/msg/msg_process.c
	src/msg/msg_gos.c
	src/msg/msg_global.c
	src/msg/msg_environment.c
	src/msg/msg_deployment.c
	src/msg/msg_mailbox.c
	src/msg/msg_actions.c
)

set(SIMDAG_SRC
	src/simdag/sd_global.c
	src/simdag/sd_link.c
	src/simdag/sd_task.c
	src/simdag/sd_workstation.c
	src/simdag/sd_daxloader.c
)
if(HAVE_GRAPHVIZ)
	set(SIMDAG_SRC 
	    ${SIMDAG_SRC} src/simdag/sd_dotloader.c
	)
else(HAVE_GRAPHVIZ)
	set(EXTRA_DIST
	    ${EXTRA_DIST} src/simdag/sd_dotloader.c
	)
endif(HAVE_GRAPHVIZ)

set(GRAS_COMMON_SRC
	src/gras/gras.c
	src/gras/Transport/transport.c
	src/gras/Transport/transport_private.h
	src/gras/Transport/transport_plugin_file.c
	src/gras/Msg/gras_msg_mod.c
	src/gras/Msg/gras_msg_types.c
	src/gras/Msg/gras_msg_exchange.c
	src/gras/Msg/gras_msg_listener.c
	src/gras/Msg/rpc.c 
	src/gras/Msg/timer.c
	src/gras/Msg/msg_interface.h
	src/gras/Msg/msg_private.h
	src/gras/Virtu/process.c
	src/gras/Virtu/gras_module.c
)

set(GRAS_SG_SRC
	src/gras/Transport/sg_transport.c
	src/gras/Transport/transport_plugin_sg.c
	src/gras/Virtu/sg_emul.c
	src/gras/Virtu/sg_process.c
	src/gras/Virtu/sg_dns.c
	src/gras/Msg/sg_msg.c
	${XBT_SG_SRC}
)

set(AMOK_SRC
	src/amok/amok_base.c
	src/amok/Bandwidth/bandwidth.c
	src/amok/Bandwidth/saturate.c
	src/amok/PeerManagement/peermanagement.c
)

set(BINDINGS_SRC
	src/bindings/bindings_global.c
)

set(LUA_SRC
	src/bindings/lua/simgrid_lua.c
	src/bindings/lua/lua_task.c
	src/bindings/lua/lua_comm.c
	src/bindings/lua/lua_host.c
	src/bindings/lua/lua_process.c
	src/bindings/lua/lua_platf.c
        src/bindings/lua/lua_utils.c
        src/bindings/lua/lua_state_cloner.c
	src/bindings/lua/lua_stub_generator.c
)

set(TRACING_SRC
	src/instr/instr_routing.c
	src/instr/instr_config.c
	src/instr/instr_interface.c
	src/instr/instr_paje_trace.c
	src/instr/instr_paje_types.c
	src/instr/instr_paje_values.c
	src/instr/instr_paje_containers.c
	src/instr/instr_msg_task.c
	src/instr/instr_msg_process.c
	src/instr/instr_surf.c
	src/instr/instr_smpi.c
	src/instr/instr_resource_utilization.c
	src/instr/instr_private.h
)


set(JEDULE_SRC
	include/instr/jedule/jedule_events.h
	include/instr/jedule/jedule_output.h
	include/instr/jedule/jedule_platform.h
	include/instr/jedule/jedule_sd_binding.h
	src/instr/jedule/jedule_events.c
	src/instr/jedule/jedule_output.c
	src/instr/jedule/jedule_platform.c
	src/instr/jedule/jedule_sd_binding.c
)

set(MC_SRC
	src/mc/mc_memory.c
	src/mc/mc_checkpoint.c
	src/mc/mc_state.c
	src/mc/memory_map.c
	src/mc/mc_global.c
	src/mc/mc_dpor.c
	src/mc/mc_request.c
	src/mc/mc_private.h
	src/mc/mc_liveness.c
)

set(RNGSTREAM_SRC
	src/rngstreams/RngStream.h
	src/rngstreams/RngStream.c
)

set(headers_to_install
	include/xbt/misc.h
	include/xbt/sysdep.h
	include/xbt/virtu.h
	include/xbt/str.h
	include/xbt/strbuff.h
	include/xbt/hash.h
	include/xbt/function_types.h
	include/xbt/asserts.h 
	include/xbt/ex.h
	include/xbt/log.h
	include/xbt/module.h
	include/xbt/mallocator.h
	include/xbt/dynar.h
	include/xbt/dict.h
	include/xbt/set.h
	include/xbt/heap.h
	include/xbt/graph.h
	include/xbt/fifo.h
	include/xbt/swag.h
	include/xbt/lib.h
	include/xbt/matrix.h
	include/xbt/peer.h
	include/xbt/config.h
	include/xbt/cunit.h
	include/xbt/graphxml_parse.h
	include/xbt/graphxml.h
	include/xbt/time.h
	include/xbt/synchro.h
	include/xbt/synchro_core.h
	include/xbt/queue.h
	include/xbt/setset.h
	include/xbt/mmalloc.h
	include/xbt/replay_trace_reader.h
	include/xbt/parmap.h
	include/xbt/automaton.h
	include/xbt/automatonparse_promela.h
	include/xbt/datadesc.h
	include/xbt/socket.h
	include/xbt/file_stat.h
	include/xbt/xbt_os_thread.h
	include/simgrid/platf.h
	include/simgrid/modelchecker.h
	include/simgrid/simix.h
	include/msg/msg.h
	include/msg/datatypes.h
	include/simdag/simdag.h
	include/simdag/datatypes.h
	include/smpi/smpi.h
	include/smpi/mpi.h
	include/smpi/mpif.h
	include/smpi/smpi_cocci.h
	include/surf/surfxml_parse.h
	include/surf/simgrid_dtd.h
	include/surf/surf_routing.h
	include/gras/transport.h
	include/gras/virtu.h
	include/gras/emul.h
	include/gras/process.h
	include/gras/module.h
	include/gras/messages.h
	include/gras/timer.h
	include/amok/peermanagement.h
	include/amok/bandwidth.h
	include/instr/instr.h
	include/gras.h 
	include/xbt.h
)
set(source_of_generated_headers
	include/simgrid_config.h.in
	include/smpi/smpif.h.in
	src/context_sysv_config.h.in)

### depend of some variables setted upper
# -->CONTEXT_THREADS CONTEXT_UCONTEXT
if(${CONTEXT_THREADS}) #pthread
	set(SURF_SRC
		${SURF_SRC}
		src/xbt/xbt_os_thread.c
		src/simix/smx_context_thread.c
		)
else(${CONTEXT_THREADS}) # NOT pthread
	set(EXTRA_DIST
		${EXTRA_DIST}
		src/xbt/xbt_os_thread.c
		src/simix/smx_context_thread.c
		)
endif(${CONTEXT_THREADS})

if(${CONTEXT_UCONTEXT}) #ucontext
	set(SURF_SRC
		${SURF_SRC}
		src/simix/smx_context_sysv.c
	)
else(${CONTEXT_UCONTEXT}) # NOT ucontext
	set(EXTRA_DIST
		${EXTRA_DIST}
		src/simix/smx_context_sysv.c
	)
endif(${CONTEXT_UCONTEXT})

# -->HAVE_GTNETS
if(HAVE_GTNETS)
  	set(GTNETS_USED 
		${GTNETS_SRC}
	)
else(HAVE_GTNETS)
  	set(GTNETS_USED "")
	set(EXTRA_DIST
		${EXTRA_DIST}
		${GTNETS_SRC}
	)
endif(HAVE_GTNETS)

### Simgrid Lib sources
set(simgrid_sources
	${XBT_SRC}
	${SURF_SRC}
	${GTNETS_USED}
	${SIMIX_SRC}
	${MSG_SRC}
	${TRACING_SRC}
	${SIMDAG_SRC}
	${GRAS_COMMON_SRC}
	${GRAS_SG_SRC}
	${AMOK_SRC}
	${BINDINGS_SRC}
	${JEDULE_SRC}
	${RNGSTREAM_SRC}
)

if(HAVE_MC)
	set(simgrid_sources
		${simgrid_sources}
		${MC_SRC}
		)
endif(HAVE_MC)

if(HAVE_NS3)
	set(simgrid_sources
		${simgrid_sources}
		${NS3_SRC}
	)
endif(HAVE_NS3)

# WINDOWS
if(WIN32)
	set(simgrid_sources
		${simgrid_sources}
		src/xbt/win32_ucontext.c
		src/xbt/xbt_os_thread.c
		src/simix/smx_context_thread.c
		)
endif(WIN32)

### Gras Lib sources
set(gras_sources
	${XBT_SRC}
	${GRAS_COMMON_SRC}
	${GRAS_RL_SRC}
	${AMOK_SRC}
)

if(${HAVE_LUA})
  	set(simgrid_sources
		${simgrid_sources}
		${LUA_SRC}
	)
elseif(${HAVE_LUA})
  	set(EXTRA_DIST
		${EXTRA_DIST}
		${LUA_SRC}
	)
endif(${HAVE_LUA})

file(GLOB_RECURSE examples_to_install_in_doc
"examples/*.c"
"examples/*.h"
"examples/*yacc"
"examples/*lex"
"examples/*.cxx"
"examples/*.hpp"
"examples/*.rb"
"examples/*.lua"
"examples/*.java"
"examples/*.xml"
"examples/*README"
)
    
set(DOC_SOURCES
	doc/install.doc
	doc/bindings.doc
	doc/options.doc
	doc/use.doc
	doc/tracing.doc
	doc/pls.doc
	doc/gtut-howto-design.doc
	doc/gtut-howto.doc
	doc/gtut-introduction.doc
	doc/gtut-main.doc
	doc/gtut-tour-00-install.doc
	doc/gtut-tour-01-bones.doc
	doc/gtut-tour-02-simple.doc
	doc/gtut-tour-03-args.doc
	doc/gtut-tour-04-callback.doc
	doc/gtut-tour-05-globals.doc
	doc/gtut-tour-06-logs.doc
	doc/gtut-tour-07-timers.doc
	doc/gtut-tour-08-exceptions.doc
	doc/gtut-tour-09-simpledata.doc
	doc/gtut-tour-10-rpc.doc
	doc/gtut-tour-11-explicitwait.doc
	doc/gtut-tour-12-staticstruct.doc
	doc/gtut-tour-13-pointers.doc
	doc/gtut-tour-14-dynar.doc
	doc/gtut-tour-15-manualdatadef.doc
	doc/gtut-tour-16-exchangecb.doc
	doc/gtut-tour.doc
	doc/gtut-tour-recap-messages.doc
	
	#doc/index-API.doc
	doc/index.doc
	${CMAKE_HOME_DIRECTORY}/doc/logcategories.doc
	doc/module-amok.doc
	doc/module-gras.doc
	doc/module-msg.doc
	doc/module-sd.doc
	doc/modules.doc
	doc/module-surf.doc
	doc/module-xbt.doc
	
	doc/gtut-files/01-bones.c
	doc/gtut-files/01-bones.output
	doc/gtut-files/02-simple.c
	doc/gtut-files/02-simple.output
	doc/gtut-files/03-args.c
	doc/gtut-files/03-args.output
	doc/gtut-files/03-args.xml
	doc/gtut-files/04-callback.c
	doc/gtut-files/04-callback.output
	doc/gtut-files/05-globals.c
	doc/gtut-files/05-globals.output
	doc/gtut-files/06-logs.c
	doc/gtut-files/06-logs.output
	doc/gtut-files/06-logs.output.error
	doc/gtut-files/06-logs.output.fmt
	doc/gtut-files/06-logs.output.fmt-bt
	doc/gtut-files/06-logs.output.verbose
	doc/gtut-files/07-timers.c
	doc/gtut-files/07-timers.output
	doc/gtut-files/08-exceptions.c
	doc/gtut-files/08-exceptions.output
	doc/gtut-files/09-datatype-dump.c
	doc/gtut-files/09-simpledata.c
	doc/gtut-files/09-simpledata.output
	doc/gtut-files/10-rpc.c
	doc/gtut-files/10-rpc.output
	doc/gtut-files/11-explicitwait.c
	doc/gtut-files/11-explicitwait.output
	doc/gtut-files/11-explicitwait.xml
	doc/gtut-files/gtut-platform-3nodes.xml
	doc/gtut-files/gtut-platform.xml
	doc/gtut-files/Makefile
	doc/gtut-files/README
	doc/gtut-files/test.xml
	
	doc/webcruft/awstats_logo3.png
	doc/webcruft/Paje_MSG_screenshot.jpg
	doc/webcruft/Paje_MSG_screenshot_thn.jpg
	doc/webcruft/poster_thumbnail.png
	doc/webcruft/simgrid_logo_2011.png
	doc/webcruft/simgrid_logo_small.png
	doc/triva-graph_configuration.png
	doc/triva-graph_visualization.png
	doc/simgrid.css
	
	doc/Doxyfile.in
	doc/footer.html.in
	
	tools/doxygen/doxygen_postprocesser.pl
	tools/doxygen/index_create.pl
	tools/doxygen/toc_create.pl
	tools/doxygen/bibtex2html_wrapper.pl
	tools/doxygen/fig2dev_postprocessor.pl
	tools/doxygen/xbt_log_extract_hierarchy.pl
)

set(DOC_FIGS
	${CMAKE_HOME_DIRECTORY}/doc/fig/simgrid_modules.fig
	${CMAKE_HOME_DIRECTORY}/doc/fig/simgrid_modules2.fig
	${CMAKE_HOME_DIRECTORY}/doc/fig/amok_bw_test.fig
	${CMAKE_HOME_DIRECTORY}/doc/fig/amok_bw_sat.fig
	${CMAKE_HOME_DIRECTORY}/doc/fig/gras_comm.fig
)

file(GLOB_RECURSE add_src_files
"teshsuite/*.c"
"teshsuite/*.cxx"
"teshsuite/*CMakeLists.txt"
"testsuite/*.c"
"testsuite/*.cxx"
"testsuite/*CMakeLists.txt"
"tools/*.c"
"tools/*.cxx"
"tools/*CMakeLists.txt"
"examples/*.c"
"examples/*.cxx"
"examples/*.lua"
"examples/*.rb"
"examples/*CMakeLists.txt"
"src/bindings/*.lua"
"src/bindings/*.rb"
"src/bindings/*.c"
"src/bindings/*.h"
"src/bindings/*CMakeLists.txt"
)
set(add_src_files
	${add_src_files}
        CMakeLists.txt
	src/smpi/smpicc.in
	src/smpi/smpif2c.in
	src/smpi/smpiff.in
	src/smpi/smpirun.in
)

file(GLOB_RECURSE xml_files
"examples/*.xml"
"include/*.xml"
"src/*.xml"
"teshsuite/*.xml"
"testsuite/*.xml"
"tools/*.xml"
)

file(GLOB_RECURSE tesh_files
"examples/*.tesh"
"include/*.tesh"
"src/*.tesh"
"teshsuite/*.tesh"
"testsuite/*.tesh"
"tools/*.tesh"
)

set(txt_files
"testsuite/surf/trace_A_failure.txt"
"testsuite/surf/trace_A.txt"
"testsuite/surf/trace_B.txt"
"examples/smpi/hostfile"
"examples/msg/link5_state.trace"
"examples/msg/fafard_state.trace"
"examples/msg/jupiter_state.trace"
"examples/msg/actions/actions_allReduce.txt"
"examples/msg/actions/actions_reduce.txt"
"examples/msg/actions/actions.txt"
"examples/msg/actions/actions_barrier.txt"
"examples/msg/actions/actions_split_p0.txt"
"examples/msg/actions/actions_with_isend.txt"
"examples/msg/actions/actions_bcast.txt"
"examples/msg/actions/actions_split_p1.txt"
"examples/msg/actions/CMakeLists.txt"
"examples/msg/migration/migration.deploy"
"teshsuite/gras/datadesc/datadesc.little32_4"
"teshsuite/gras/datadesc/datadesc.little64"
"teshsuite/gras/datadesc/datadesc.big32_8_4"
"teshsuite/gras/datadesc/mk_datadesc_structs.pl"
"teshsuite/gras/msg_handle/test_rl.tesh"
"teshsuite/gras/msg_handle/test_sg_32.tesh"
"teshsuite/gras/msg_handle/test_sg_64.tesh"
"teshsuite/gras/empty_main/test_rl.tesh"
"teshsuite/gras/empty_main/test_sg.tesh"
"teshsuite/gras/small_sleep/test_sg_32.tesh"
"teshsuite/gras/small_sleep/test_sg_64.tesh"
"teshsuite/msg/trace/file.trace"
"teshsuite/simdag/platforms/bob.fail"
"teshsuite/simdag/platforms/bob.trace"
"teshsuite/simdag/platforms/bob0_availability_file.trace"
"teshsuite/simdag/platforms/bob0_state_file.trace"
"teshsuite/simdag/platforms/bob2_availability_file.trace"
"teshsuite/simdag/platforms/bob2_state_file.trace"
"teshsuite/simdag/platforms/link1.bw"
"teshsuite/simdag/platforms/link1.fail"
"teshsuite/simdag/platforms/link1.lat"
"examples/gras/ping/test_rl.tesh"
"examples/gras/rpc/test_rl.tesh"
"examples/gras/spawn/test_rl.tesh"
"examples/gras/timer/test_rl.tesh"
"examples/gras/chrono/test_rl.tesh"
"examples/gras/mutual_exclusion/simple_token/test_rl.tesh"
"examples/gras/mmrpc/test_rl.tesh"
"examples/gras/all2all/test_rl.tesh"
"examples/gras/pmm/test_rl.tesh"
"examples/gras/synchro/test_rl.tesh"
"examples/gras/properties/test_rl.tesh"
"examples/gras/ping/test_sg_32.tesh"
"examples/gras/rpc/test_sg_32.tesh"
"examples/gras/spawn/test_sg_32.tesh"
"examples/gras/timer/test_sg_32.tesh"
"examples/gras/chrono/test_sg_32.tesh"
"examples/gras/mutual_exclusion/simple_token/test_sg_32.tesh"
"examples/gras/mmrpc/test_sg_32.tesh"
"examples/gras/all2all/test_sg_32.tesh"
"examples/gras/pmm/test_sg_32.tesh"
"examples/gras/synchro/test_sg_32.tesh"
"examples/gras/ping/test_sg_64.tesh"
"examples/gras/rpc/test_sg_64.tesh"
"examples/gras/spawn/test_sg_64.tesh"
"examples/gras/timer/test_sg_64.tesh"
"examples/gras/chrono/test_sg_64.tesh"
"examples/gras/mutual_exclusion/simple_token/test_sg_64.tesh"
"examples/gras/mmrpc/test_sg_64.tesh"
"examples/gras/all2all/test_sg_64.tesh"
"examples/gras/pmm/test_sg_64.tesh"
"examples/gras/synchro/test_sg_64.tesh"
"examples/gras/properties/test_sg.tesh"
)

set(txt_files
	${txt_files}
	AUTHORS
	ChangeLog
	COPYING
	LICENSE-LGPL-2.1
	NEWS
	TODO
	configure
	INSTALL
)

file(GLOB_RECURSE README_files
"*README"
)
	
string(REPLACE "${CMAKE_HOME_DIRECTORY}/" "" README_files "${README_files}")

file(GLOB_RECURSE CMAKE_SOURCE_FILES
"buildtools/Cmake/Makefile.default"
"buildtools/Cmake/test_java.sh"
"buildtools/Cmake/*.cmake"
"buildtools/Cmake/*.h.in"
"buildtools/Cmake/*.pl"
"buildtools/Cmake/*.sh"
"buildtools/Cmake/test_prog/*.c"
"buildtools/Cmake/test_prog/*.cpp"
)

set(bin_files
tools/MSG_visualization/colorize.pl
tools/sg_unit_extractor.pl
tools/simgrid_update_xml.pl
buildtools/Cmake/tesh.pl
)

# This is the complete list of what will be added to the source archive
set(source_to_pack	
	${headers_to_install}
	${source_of_generated_headers}
	${XBT_RL_SRC}
	${EXTRA_DIST}
	${SMPI_SRC}
	${GRAS_RL_SRC}
	${XBT_SRC}
	${GTNETS_SRC}
	${NS3_SRC}
	${SURF_SRC}
	${SIMIX_SRC}
	${TRACING_SRC}
	${MSG_SRC}
	${SIMDAG_SRC}
	${GRAS_COMMON_SRC}
	${GRAS_SG_SRC}
	${AMOK_SRC}
	${LUA_SRC}
	${MC_SRC}
	${JEDULE_SRC}
	${RNGSTREAM_SRC}
	${add_src_files}
	${xml_files}
	${tesh_files}
	${txt_files}
	${CMAKE_SOURCE_FILES}
	${bin_files}
	${DOC_SOURCES}
	${DOC_FIGS}
	${README_files}
	buildtools/Cmake/simgrid.nsi.in 
)
