
# teshsuite/xbt
ADD_TEST(memcheck-tesh-log-large-0 ${CMAKE_BINARY_DIR}/teshsuite/xbt/log_large_test "--log=root.fmt:%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-log-large-1 ${CMAKE_BINARY_DIR}/teshsuite/xbt/log_large_test "--log=root.fmt:%m%n"  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-log-parallel-0 ${CMAKE_BINARY_DIR}/teshsuite/xbt/parallel_log_crashtest "--log=root.fmt:%m%n"  --cd ${CMAKE_BINARY_DIR}/teshsuite/)

# teshsuite/gras/datadesc directory
ADD_TEST(memcheck-tesh-gras-dd-mem-0 ${CMAKE_BINARY_DIR}/teshsuite/gras/datadesc/datadesc_usage --copy "--log=root.fmt:%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-gras-dd-rw-0 rm -f datadesc_usage.out --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-gras-dd-rw-1 ${CMAKE_BINARY_DIR}/teshsuite/gras/datadesc/datadesc_usage --write "--log=root.fmt:%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-gras-dd-rw-2 ${CMAKE_BINARY_DIR}/teshsuite/gras/datadesc/datadesc_usage --read "--log=root.fmt:%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-gras-dd-r-little32-4-0 ${CMAKE_BINARY_DIR}/teshsuite/gras/datadesc/datadesc_usage --read ${CMAKE_BINARY_DIR}/teshsuite/gras/datadesc/datadesc.little32_4 "--log=root.fmt:%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-gras-dd-r-little64-0 ${CMAKE_BINARY_DIR}/teshsuite/gras/datadesc/datadesc_usage --read ${CMAKE_BINARY_DIR}/teshsuite/gras/datadesc/datadesc.little64 "--log=root.fmt:%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-gras-dd-r-big32-8-4-0 ${CMAKE_BINARY_DIR}/teshsuite/gras/datadesc/datadesc_usage --read ${CMAKE_BINARY_DIR}/teshsuite/gras/datadesc/datadesc.big32_8_4 "--log=root.fmt:%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)

IF(${ARCH_32_BITS})
ADD_TEST(memcheck-tesh-gras-msg-handle-sg-32-0 ${CMAKE_BINARY_DIR}/teshsuite/gras/msg_handle/msg_handle_simulator ${CMAKE_BINARY_DIR}/teshsuite/../examples/msg/small_platform.xml ${CMAKE_BINARY_DIR}/teshsuite/gras/msg_handle/msg_handle.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ELSE(${ARCH_32_BITS})
ADD_TEST(memcheck-tesh-gras-msg-handle-sg-64-0 ${CMAKE_BINARY_DIR}/teshsuite/gras/msg_handle/msg_handle_simulator ${CMAKE_BINARY_DIR}/teshsuite/../examples/msg/small_platform.xml ${CMAKE_BINARY_DIR}/teshsuite/gras/msg_handle/msg_handle.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ENDIF(${ARCH_32_BITS})

ADD_TEST(memcheck-tesh-gras-empty-main-sg-0 ${CMAKE_BINARY_DIR}/teshsuite/gras/empty_main/empty_main_simulator /../examples/msg/small_platform.xml /gras/empty_main/empty_main.xml --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/)

IF(${ARCH_32_BITS})
ADD_TEST(memcheck-tesh-gras-small-sleep-sg-32-0 ${CMAKE_BINARY_DIR}/teshsuite/gras/small_sleep/small_sleep_simulator /../examples/msg/small_platform.xml /gras/small_sleep/small_sleep.xml --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/)
ELSE(${ARCH_32_BITS})
ADD_TEST(memcheck-tesh-gras-small-sleep-sg-64-0 ${CMAKE_BINARY_DIR}/teshsuite/gras/small_sleep/small_sleep_simulator /../examples/msg/small_platform.xml /gras/small_sleep/small_sleep.xml --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/)
ENDIF(${ARCH_32_BITS})

# GRAS examples
ADD_TEST(memcheck-gras-spawn-rl-0 ${CMAKE_BINARY_DIR}/examples/gras/spawn/spawn_server --log=root.fmt=%m%n --cd ${CMAKE_BINARY_DIR}/examples/gras/spawn/)
ADD_TEST(memcheck-gras-timer-rl-0 ${CMAKE_BINARY_DIR}/examples/gras/timer/timer_client --log=root.fmt:%m%n --cd ${CMAKE_BINARY_DIR}/examples/gras/timer/)
ADD_TEST(memcheck-gras-chrono-rl-0 ${CMAKE_BINARY_DIR}/examples/gras/chrono/chrono_multiplier --log=root.fmt:%m%n --cd ${CMAKE_BINARY_DIR}/examples/gras/chrono/)
ADD_TEST(memcheck-gras-synchro-rl-0 ${CMAKE_BINARY_DIR}/examples/gras/synchro/synchro_philosopher 4 --log=root.fmt=%m%n --cd ${CMAKE_BINARY_DIR}/examples/gras/synchro/)
ADD_TEST(memcheck-gras-properties-rl-0 ${CMAKE_BINARY_DIR}/examples/gras/properties/properties_alice --log=root.fmt=%P:%t%e%m%n --cd ${CMAKE_BINARY_DIR}/examples/gras/properties/)
ADD_TEST(memcheck-gras-properties-rl-1 ${CMAKE_BINARY_DIR}/examples/gras/properties/properties_bob --log=root.fmt=%P:%t%e%m%n --cd ${CMAKE_BINARY_DIR}/examples/gras/properties/)

# BEGIN CONTEXTS FACTORY
ADD_TEST(memcheck-tesh-msg-get-sender-raw-0 ${CMAKE_BINARY_DIR}/teshsuite/msg/get_sender ${CMAKE_BINARY_DIR}/teshsuite/msg/get_sender.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-msg-get-sender-thread-0 ${CMAKE_BINARY_DIR}/teshsuite/msg/get_sender ${CMAKE_BINARY_DIR}/teshsuite/msg/get_sender.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-msg-get-sender-ucontext-0 ${CMAKE_BINARY_DIR}/teshsuite/msg/get_sender ${CMAKE_BINARY_DIR}/teshsuite/msg/get_sender.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-reinit-costs-raw-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/test_reinit_costs ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/platform_2p_1sl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-reinit-costs-thread-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/test_reinit_costs ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/platform_2p_1sl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-reinit-costs-ucontext-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/test_reinit_costs ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/platform_2p_1sl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-parser-raw-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_cluster.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-raw-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host_availability.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-raw-2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host_properties.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-raw-3 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host_state_file.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-raw-4 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host_state_off.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-raw-5 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host_state_on.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-raw-6 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host_trace_file.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-raw-7 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host_trace_inside.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-raw-8 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-raw-9 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_link_availability.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-raw-10 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_link_fatpipe.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-raw-11 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_link_shared.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-raw-12 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_link_state_file.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-raw-13 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test three_hosts_non_symmetric_route.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-raw-14 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test two_clusters.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-raw-15 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test two_hosts_multi_hop.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-raw-16 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test two_hosts_one_link.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-raw-17 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ./four_hosts_floyd.xml --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-raw-18 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ./four_hosts_floyd_bis.xml --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-raw-19 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ./properties.xml --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-raw-20 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ./properties.xml --cfg=cpu/model:CpuTI --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-raw-21 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ./one_cluster_file.xml --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-raw-22 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/is_router_test ./test_of_is_router.xml --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-thread-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_cluster.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-thread-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host_availability.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-thread-2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host_properties.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-thread-3 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host_state_file.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-thread-4 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host_state_off.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-thread-5 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host_state_on.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-thread-6 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host_trace_file.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-thread-7 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host_trace_inside.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-thread-8 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-thread-9 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_link_availability.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-thread-10 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_link_fatpipe.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-thread-11 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_link_shared.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-thread-12 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_link_state_file.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-thread-13 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test three_hosts_non_symmetric_route.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-thread-14 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test two_clusters.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-thread-15 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test two_hosts_multi_hop.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-thread-16 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test two_hosts_one_link.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-thread-17 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ./four_hosts_floyd.xml --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-thread-18 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ./four_hosts_floyd_bis.xml --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-thread-19 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ./properties.xml --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-thread-20 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ./properties.xml --cfg=cpu/model:CpuTI --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-thread-21 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ./one_cluster_file.xml --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-thread-22 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/is_router_test ./test_of_is_router.xml --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-ucontext-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_cluster.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-ucontext-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host_availability.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-ucontext-2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host_properties.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-ucontext-3 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host_state_file.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-ucontext-4 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host_state_off.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-ucontext-5 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host_state_on.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-ucontext-6 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host_trace_file.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-ucontext-7 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host_trace_inside.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-ucontext-8 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_host.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-ucontext-9 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_link_availability.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-ucontext-10 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_link_fatpipe.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-ucontext-11 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_link_shared.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-ucontext-12 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_link_state_file.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-ucontext-13 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test three_hosts_non_symmetric_route.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-ucontext-14 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test two_clusters.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-ucontext-15 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test two_hosts_multi_hop.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-ucontext-16 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test two_hosts_one_link.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-ucontext-17 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ./four_hosts_floyd.xml --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-ucontext-18 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ./four_hosts_floyd_bis.xml --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-ucontext-19 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ./properties.xml --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-ucontext-20 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ./properties.xml --cfg=cpu/model:CpuTI --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-ucontext-21 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ./one_cluster_file.xml --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-ucontext-22 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/is_router_test ./test_of_is_router.xml --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-bogus-symmetric-raw-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier two_hosts_asymetric_BOGUS.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-bogus-symmetric-raw-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier two_hosts_asymetric_BOGUS2.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-bogus-symmetric-thread-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier two_hosts_asymetric_BOGUS.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-bogus-symmetric-thread-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier two_hosts_asymetric_BOGUS2.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-bogus-symmetric-ucontext-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier two_hosts_asymetric_BOGUS.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-bogus-symmetric-ucontext-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier two_hosts_asymetric_BOGUS2.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-sym-full-raw-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_cluster_fullduplex.xml FULL_LINK "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-sym-full-raw-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test two_clusters_symmetric.xml FULL_LINK "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-sym-full-raw-2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test two_hosts_one_link_symmetrical.xml FULL_LINK "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-sym-full-raw-3 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test two_hosts_one_link_fullduplex.xml FULL_LINK "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-sym-full-raw-4 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test Dijkstra.xml FULL_LINK --log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-sym-full-thread-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_cluster_fullduplex.xml FULL_LINK "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-sym-full-thread-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test two_clusters_symmetric.xml FULL_LINK "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-sym-full-thread-2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test two_hosts_one_link_symmetrical.xml FULL_LINK "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-sym-full-thread-3 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test two_hosts_one_link_fullduplex.xml FULL_LINK "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-sym-full-thread-4 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test Dijkstra.xml FULL_LINK --log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-sym-full-ucontext-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test one_cluster_fullduplex.xml FULL_LINK "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-sym-full-ucontext-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test two_clusters_symmetric.xml FULL_LINK "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-sym-full-ucontext-2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test two_hosts_one_link_symmetrical.xml FULL_LINK "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-sym-full-ucontext-3 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test two_hosts_one_link_fullduplex.xml FULL_LINK "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-parser-sym-full-ucontext-4 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test Dijkstra.xml FULL_LINK --log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-raw-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_cluster.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-raw-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host_availability.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-raw-2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host_properties.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-raw-3 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host_state_file.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-raw-4 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host_state_off.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-raw-5 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host_state_on.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-raw-6 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host_trace_file.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-raw-7 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host_trace_inside.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-raw-8 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-raw-9 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_link_availability.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-raw-10 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_link_fatpipe.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-raw-11 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_link_shared.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-raw-12 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_link_state_file.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-raw-13 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier three_hosts_non_symmetric_route.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-raw-14 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier two_clusters.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-raw-15 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier two_hosts_multi_hop.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-raw-16 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier two_hosts_one_link.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-thread-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_cluster.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-thread-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host_availability.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-thread-2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host_properties.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-thread-3 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host_state_file.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-thread-4 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host_state_off.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-thread-5 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host_state_on.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-thread-6 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host_trace_file.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-thread-7 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host_trace_inside.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-thread-8 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-thread-9 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_link_availability.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-thread-10 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_link_fatpipe.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-thread-11 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_link_shared.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-thread-12 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_link_state_file.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-thread-13 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier three_hosts_non_symmetric_route.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-thread-14 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier two_clusters.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-thread-15 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier two_hosts_multi_hop.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-thread-16 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier two_hosts_one_link.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-ucontext-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_cluster.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-ucontext-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host_availability.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-ucontext-2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host_properties.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-ucontext-3 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host_state_file.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-ucontext-4 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host_state_off.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-ucontext-5 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host_state_on.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-ucontext-6 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host_trace_file.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-ucontext-7 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host_trace_inside.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-ucontext-8 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_host.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-ucontext-9 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_link_availability.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-ucontext-10 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_link_fatpipe.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-ucontext-11 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_link_shared.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-ucontext-12 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier one_link_state_file.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-ucontext-13 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier three_hosts_non_symmetric_route.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-ucontext-14 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier two_clusters.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-ucontext-15 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier two_hosts_multi_hop.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-flatifier-ucontext-16 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/flatifier two_hosts_one_link.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-full-links-raw-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ./four_hosts_floyd.xml FULL_LINK --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-full-links-raw-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ./four_hosts_floyd_bis.xml FULL_LINK --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-full-links-thread-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ./four_hosts_floyd.xml FULL_LINK --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-full-links-thread-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ./four_hosts_floyd_bis.xml FULL_LINK --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-full-links-ucontext-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ./four_hosts_floyd.xml FULL_LINK --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-full-links-ucontext-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/platforms/basic_parsing_test ./four_hosts_floyd_bis.xml FULL_LINK --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/teshsuite/simdag/platforms/)
ADD_TEST(memcheck-tesh-simdag-basic0-raw-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic_platform.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-basic0-thread-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic_platform.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-basic0-ucontext-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic_platform.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-basic1-raw-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic_platform.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-basic1-thread-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic_platform.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-basic1-ucontext-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic_platform.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-basic2-raw-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic_platform.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-basic2-thread-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic_platform.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-basic2-ucontext-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic_platform.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-basic3-raw-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic3 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic_platform.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-basic3-thread-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic3 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic_platform.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-basic3-ucontext-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic3 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic_platform.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-basic4-raw-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic4 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic_platform.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-basic4-thread-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic4 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic_platform.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-basic4-ucontext-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic4 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic_platform.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-basic5-raw-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic5 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic_platform.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-basic5-thread-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic5 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic_platform.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-basic5-ucontext-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic5 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic_platform.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-basic6-raw-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic6 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1sl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-basic6-thread-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic6 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1sl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-basic6-ucontext-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/basic6 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1sl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-1-raw-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1sl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-1-raw-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1fl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-1-raw-2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1switch.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-1-thread-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1sl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-1-thread-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1fl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-1-thread-2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1switch.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-1-ucontext-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1sl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-1-ucontext-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1fl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-1-ucontext-2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1switch.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-2-raw-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1sl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-2-raw-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1fl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-2-raw-2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1switch.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-2-thread-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1sl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-2-thread-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1fl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-2-thread-2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1switch.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-2-ucontext-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1sl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-2-ucontext-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1fl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-2-ucontext-2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1switch.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-3-raw-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency3 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1sl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-3-raw-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency3 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1fl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-3-raw-2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency3 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1switch.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-3-thread-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency3 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1sl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-3-thread-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency3 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1fl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-3-thread-2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency3 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1switch.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-3-ucontext-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency3 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1sl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-3-ucontext-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency3 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1fl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-3-ucontext-2 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency3 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1switch.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-4-raw-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency_bound ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1bb.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-4-thread-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency_bound ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1bb.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-p2p-4-ucontext-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/test_latency_bound ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/p2p/platform_2p_1bb.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-mxn-1-raw-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/mxn/test_intra_all2all ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/mxn/platform_4p_1switch.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-mxn-1-thread-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/mxn/test_intra_all2all ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/mxn/platform_4p_1switch.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-mxn-1-ucontext-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/mxn/test_intra_all2all ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/mxn/platform_4p_1switch.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-mxn-2-raw-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/mxn/test_intra_independent_comm ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/mxn/platform_4p_1switch.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-mxn-2-thread-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/mxn/test_intra_independent_comm ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/mxn/platform_4p_1switch.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-mxn-2-ucontext-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/mxn/test_intra_independent_comm ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/mxn/platform_4p_1switch.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-mxn-3-raw-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/mxn/test_intra_scatter ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/mxn/platform_4p_1switch.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-mxn-3-thread-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/mxn/test_intra_scatter ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/mxn/platform_4p_1switch.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-mxn-3-ucontext-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/mxn/test_intra_scatter ${CMAKE_BINARY_DIR}/teshsuite/simdag/network/mxn/platform_4p_1switch.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-par-1-raw-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/partask/test_comp_only_seq ${CMAKE_BINARY_DIR}/teshsuite/simdag/partask/platform_2p_1sl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-par-1-thread-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/partask/test_comp_only_seq ${CMAKE_BINARY_DIR}/teshsuite/simdag/partask/platform_2p_1sl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-par-1-ucontext-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/partask/test_comp_only_seq ${CMAKE_BINARY_DIR}/teshsuite/simdag/partask/platform_2p_1sl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-par-2-raw-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/partask/test_comp_only_par ${CMAKE_BINARY_DIR}/teshsuite/simdag/partask/platform_2p_1sl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-par-2-raw-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/partask/test_comp_only_par ${CMAKE_BINARY_DIR}/teshsuite/simdag/partask/platform_2p_1sl_hetero.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-par-2-thread-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/partask/test_comp_only_par ${CMAKE_BINARY_DIR}/teshsuite/simdag/partask/platform_2p_1sl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-par-2-thread-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/partask/test_comp_only_par ${CMAKE_BINARY_DIR}/teshsuite/simdag/partask/platform_2p_1sl_hetero.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-par-2-ucontext-0 ${CMAKE_BINARY_DIR}/teshsuite/simdag/partask/test_comp_only_par ${CMAKE_BINARY_DIR}/teshsuite/simdag/partask/platform_2p_1sl.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/teshsuite/)
ADD_TEST(memcheck-tesh-simdag-par-2-ucontext-1 ${CMAKE_BINARY_DIR}/teshsuite/simdag/partask/test_comp_only_par ${CMAKE_BINARY_DIR}/teshsuite/simdag/partask/platform_2p_1sl_hetero.xml --surf-path=${CMAKE_HOME_DIRECTORY}/src --log=sd_kernel.thres=warning "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/teshsuite/)

# MSG examples
ADD_TEST(memcheck-msg-sendrecv-CLM03-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/sendrecv ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/platform_sendrecv.xml ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/deployment_sendrecv.xml --cfg=workstation/model:CLM03 --cfg=cpu/model:Cas01 --cfg=network/model:CM02 "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-sendrecv-CLM03-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/sendrecv ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/platform_sendrecv.xml ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/deployment_sendrecv.xml --cfg=workstation/model:CLM03 --cfg=cpu/model:Cas01 --cfg=network/model:CM02 "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-sendrecv-CLM03-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/sendrecv ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/platform_sendrecv.xml ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/deployment_sendrecv.xml --cfg=workstation/model:CLM03 --cfg=cpu/model:Cas01 --cfg=network/model:CM02 "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-sendrecv-Vegas-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/sendrecv ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/platform_sendrecv.xml ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/deployment_sendrecv.xml "--cfg=workstation/model:compound cpu/model:Cas01 network/model:Vegas" "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-sendrecv-Vegas-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/sendrecv ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/platform_sendrecv.xml ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/deployment_sendrecv.xml "--cfg=workstation/model:compound cpu/model:Cas01 network/model:Vegas" "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-sendrecv-Vegas-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/sendrecv ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/platform_sendrecv.xml ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/deployment_sendrecv.xml "--cfg=workstation/model:compound cpu/model:Cas01 network/model:Vegas" "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-sendrecv-Reno-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/sendrecv ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/platform_sendrecv.xml ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/deployment_sendrecv.xml "--cfg=workstation/model:compound cpu/model:Cas01 network/model:Reno" --log=surf_lagrange.thres=critical "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-sendrecv-Reno-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/sendrecv ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/platform_sendrecv.xml ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/deployment_sendrecv.xml "--cfg=workstation/model:compound cpu/model:Cas01 network/model:Reno" --log=surf_lagrange.thres=critical "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-sendrecv-Reno-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/sendrecv ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/platform_sendrecv.xml ${CMAKE_BINARY_DIR}/examples/msg/sendrecv/deployment_sendrecv.xml "--cfg=workstation/model:compound cpu/model:Cas01 network/model:Reno" --log=surf_lagrange.thres=critical "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-suspend-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/suspend/suspend ${CMAKE_BINARY_DIR}/examples/msg/msg_platform.xml ${CMAKE_BINARY_DIR}/examples/msg/suspend/deployment_suspend.xml  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-suspend-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/suspend/suspend ${CMAKE_BINARY_DIR}/examples/msg/msg_platform.xml ${CMAKE_BINARY_DIR}/examples/msg/suspend/deployment_suspend.xml  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-suspend-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/suspend/suspend ${CMAKE_BINARY_DIR}/examples/msg/msg_platform.xml ${CMAKE_BINARY_DIR}/examples/msg/suspend/deployment_suspend.xml  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_forwarder ${CMAKE_BINARY_DIR}/examples/msg/small_platform_with_routers.xml ${CMAKE_BINARY_DIR}/examples/msg/masterslave/deployment_masterslave.xml --trace "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_forwarder ${CMAKE_BINARY_DIR}/examples/msg/small_platform_with_routers.xml ${CMAKE_BINARY_DIR}/examples/msg/masterslave/deployment_masterslave.xml --trace "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_forwarder ${CMAKE_BINARY_DIR}/examples/msg/small_platform_with_routers.xml ${CMAKE_BINARY_DIR}/examples/msg/masterslave/deployment_masterslave.xml --trace "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-forwarder-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_forwarder ${CMAKE_BINARY_DIR}/examples/msg/msg_platform.xml ${CMAKE_BINARY_DIR}/examples/msg/masterslave/deployment_masterslave_forwarder.xml  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-forwarder-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_forwarder ${CMAKE_BINARY_DIR}/examples/msg/msg_platform.xml ${CMAKE_BINARY_DIR}/examples/msg/masterslave/deployment_masterslave_forwarder.xml  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-forwarder-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_forwarder ${CMAKE_BINARY_DIR}/examples/msg/msg_platform.xml ${CMAKE_BINARY_DIR}/examples/msg/masterslave/deployment_masterslave_forwarder.xml  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-failure-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_failure --log=xbt_cfg.thres:critical --log=no_loc ${CMAKE_BINARY_DIR}/examples/msg/small_platform_with_failures.xml ${CMAKE_BINARY_DIR}/examples/msg/masterslave/deployment_masterslave.xml --cfg=path:${CMAKE_HOME_DIRECTORY}/src "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-failure-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_failure --log=xbt_cfg.thres:critical --log=no_loc ${CMAKE_BINARY_DIR}/examples/msg/small_platform_with_failures.xml ${CMAKE_BINARY_DIR}/examples/msg/masterslave/deployment_masterslave.xml --cfg=path:${CMAKE_HOME_DIRECTORY}/src "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-failure-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_failure --log=xbt_cfg.thres:critical --log=no_loc ${CMAKE_BINARY_DIR}/examples/msg/small_platform_with_failures.xml ${CMAKE_BINARY_DIR}/examples/msg/masterslave/deployment_masterslave.xml --cfg=path:${CMAKE_HOME_DIRECTORY}/src "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-bypass-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_bypass --log=no_loc  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-bypass-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_bypass --log=no_loc  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-bypass-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_bypass --log=no_loc  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-mailbox-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_mailbox ${CMAKE_BINARY_DIR}/examples/msg/small_platform_with_routers.xml ${CMAKE_BINARY_DIR}/examples/msg/masterslave/deployment_masterslave_mailbox.xml --trace "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-mailbox-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_mailbox ${CMAKE_BINARY_DIR}/examples/msg/small_platform_with_routers.xml ${CMAKE_BINARY_DIR}/examples/msg/masterslave/deployment_masterslave_mailbox.xml --trace "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-mailbox-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_mailbox ${CMAKE_BINARY_DIR}/examples/msg/small_platform_with_routers.xml ${CMAKE_BINARY_DIR}/examples/msg/masterslave/deployment_masterslave_mailbox.xml --trace "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-vivaldi-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_mailbox  ${CMAKE_BINARY_DIR}/examples/msg/../platforms/vivaldi.xml ${CMAKE_BINARY_DIR}/examples/msg/masterslave/deployment_masterslave_vivaldi.xml --cfg=network/latency_factor:1.0 --cfg=network/bandwidth_factor:1.0 --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-vivaldi-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_mailbox  ${CMAKE_BINARY_DIR}/examples/msg/../platforms/vivaldi.xml ${CMAKE_BINARY_DIR}/examples/msg/masterslave/deployment_masterslave_vivaldi.xml --cfg=network/latency_factor:1.0 --cfg=network/bandwidth_factor:1.0 --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-vivaldi-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_mailbox  ${CMAKE_BINARY_DIR}/examples/msg/../platforms/vivaldi.xml ${CMAKE_BINARY_DIR}/examples/msg/masterslave/deployment_masterslave_vivaldi.xml --cfg=network/latency_factor:1.0 --cfg=network/bandwidth_factor:1.0 --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-multicore-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_mailbox ${CMAKE_BINARY_DIR}/examples/msg/../platforms/multicore_machine.xml ${CMAKE_BINARY_DIR}/examples/msg/masterslave/deployment_masterslave_mailbox_multicore.xml --cfg=cpu/model:Cas01_fullupdate --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-multicore-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_mailbox ${CMAKE_BINARY_DIR}/examples/msg/../platforms/multicore_machine.xml ${CMAKE_BINARY_DIR}/examples/msg/masterslave/deployment_masterslave_mailbox_multicore.xml --cfg=cpu/model:Cas01_fullupdate --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-multicore-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_mailbox ${CMAKE_BINARY_DIR}/examples/msg/../platforms/multicore_machine.xml ${CMAKE_BINARY_DIR}/examples/msg/masterslave/deployment_masterslave_mailbox_multicore.xml --cfg=cpu/model:Cas01_fullupdate --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-migration-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/migration/migration ${CMAKE_BINARY_DIR}/examples/msg/msg_platform.xml ${CMAKE_BINARY_DIR}/examples/msg/migration/migration.deploy  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-migration-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/migration/migration ${CMAKE_BINARY_DIR}/examples/msg/msg_platform.xml ${CMAKE_BINARY_DIR}/examples/msg/migration/migration.deploy  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-migration-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/migration/migration ${CMAKE_BINARY_DIR}/examples/msg/msg_platform.xml ${CMAKE_BINARY_DIR}/examples/msg/migration/migration.deploy  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-ptask-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/parallel_task/parallel_task ${CMAKE_BINARY_DIR}/examples/msg/small_platform.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-ptask-raw-1 ${CMAKE_BINARY_DIR}/examples/msg/parallel_task/test_ptask ${CMAKE_BINARY_DIR}/examples/msg/parallel_task/test_ptask_platform.xml ${CMAKE_BINARY_DIR}/examples/msg/parallel_task/test_ptask_deployment.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-ptask-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/parallel_task/parallel_task ${CMAKE_BINARY_DIR}/examples/msg/small_platform.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-ptask-thread-1 ${CMAKE_BINARY_DIR}/examples/msg/parallel_task/test_ptask ${CMAKE_BINARY_DIR}/examples/msg/parallel_task/test_ptask_platform.xml ${CMAKE_BINARY_DIR}/examples/msg/parallel_task/test_ptask_deployment.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-ptask-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/parallel_task/parallel_task ${CMAKE_BINARY_DIR}/examples/msg/small_platform.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-ptask-ucontext-1 ${CMAKE_BINARY_DIR}/examples/msg/parallel_task/test_ptask ${CMAKE_BINARY_DIR}/examples/msg/parallel_task/test_ptask_platform.xml ${CMAKE_BINARY_DIR}/examples/msg/parallel_task/test_ptask_deployment.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-priority-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/priority/priority ${CMAKE_BINARY_DIR}/examples/msg/small_platform.xml  ${CMAKE_BINARY_DIR}/examples/msg/priority/deployment_priority.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-priority-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/priority/priority ${CMAKE_BINARY_DIR}/examples/msg/small_platform.xml  ${CMAKE_BINARY_DIR}/examples/msg/priority/deployment_priority.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-priority-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/priority/priority ${CMAKE_BINARY_DIR}/examples/msg/small_platform.xml  ${CMAKE_BINARY_DIR}/examples/msg/priority/deployment_priority.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-properties-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/properties/msg_prop ${CMAKE_BINARY_DIR}/examples/msg/../platforms/prop.xml ${CMAKE_BINARY_DIR}/examples/msg/properties/deployment_properties.xml  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-properties-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/properties/msg_prop ${CMAKE_BINARY_DIR}/examples/msg/../platforms/prop.xml ${CMAKE_BINARY_DIR}/examples/msg/properties/deployment_properties.xml  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-properties-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/properties/msg_prop ${CMAKE_BINARY_DIR}/examples/msg/../platforms/prop.xml ${CMAKE_BINARY_DIR}/examples/msg/properties/deployment_properties.xml  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-icomms-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/icomms/peer ${CMAKE_BINARY_DIR}/examples/msg/icomms/small_platform.xml ${CMAKE_BINARY_DIR}/examples/msg/icomms/deployment_peer01.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/icomms/)
ADD_TEST(memcheck-msg-icomms-raw-1 ${CMAKE_BINARY_DIR}/examples/msg/icomms/peer ${CMAKE_BINARY_DIR}/examples/msg/icomms/small_platform.xml ${CMAKE_BINARY_DIR}/examples/msg/icomms/deployment_peer02.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/icomms/)
ADD_TEST(memcheck-msg-icomms-raw-2 ${CMAKE_BINARY_DIR}/examples/msg/icomms/peer ${CMAKE_BINARY_DIR}/examples/msg/icomms/small_platform.xml ${CMAKE_BINARY_DIR}/examples/msg/icomms/deployment_peer03.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/icomms/)
ADD_TEST(memcheck-msg-icomms-raw-3 ${CMAKE_BINARY_DIR}/examples/msg/icomms/peer ${CMAKE_BINARY_DIR}/examples/msg/icomms/small_platform.xml ${CMAKE_BINARY_DIR}/examples/msg/icomms/deployment_peer04.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/icomms/)
ADD_TEST(memcheck-msg-icomms-raw-4 ${CMAKE_BINARY_DIR}/examples/msg/icomms/peer2 ${CMAKE_BINARY_DIR}/examples/msg/icomms/small_platform.xml ${CMAKE_BINARY_DIR}/examples/msg/icomms/deployment_peer.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/icomms/)
ADD_TEST(memcheck-msg-icomms-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/icomms/peer ${CMAKE_BINARY_DIR}/examples/msg/icomms/small_platform.xml ${CMAKE_BINARY_DIR}/examples/msg/icomms/deployment_peer01.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/icomms/)
ADD_TEST(memcheck-msg-icomms-thread-1 ${CMAKE_BINARY_DIR}/examples/msg/icomms/peer ${CMAKE_BINARY_DIR}/examples/msg/icomms/small_platform.xml ${CMAKE_BINARY_DIR}/examples/msg/icomms/deployment_peer02.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/icomms/)
ADD_TEST(memcheck-msg-icomms-thread-2 ${CMAKE_BINARY_DIR}/examples/msg/icomms/peer ${CMAKE_BINARY_DIR}/examples/msg/icomms/small_platform.xml ${CMAKE_BINARY_DIR}/examples/msg/icomms/deployment_peer03.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/icomms/)
ADD_TEST(memcheck-msg-icomms-thread-3 ${CMAKE_BINARY_DIR}/examples/msg/icomms/peer ${CMAKE_BINARY_DIR}/examples/msg/icomms/small_platform.xml ${CMAKE_BINARY_DIR}/examples/msg/icomms/deployment_peer04.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/icomms/)
ADD_TEST(memcheck-msg-icomms-thread-4 ${CMAKE_BINARY_DIR}/examples/msg/icomms/peer2 ${CMAKE_BINARY_DIR}/examples/msg/icomms/small_platform.xml ${CMAKE_BINARY_DIR}/examples/msg/icomms/deployment_peer.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/icomms/)
ADD_TEST(memcheck-msg-icomms-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/icomms/peer ${CMAKE_BINARY_DIR}/examples/msg/icomms/small_platform.xml ${CMAKE_BINARY_DIR}/examples/msg/icomms/deployment_peer01.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/icomms/)
ADD_TEST(memcheck-msg-icomms-ucontext-1 ${CMAKE_BINARY_DIR}/examples/msg/icomms/peer ${CMAKE_BINARY_DIR}/examples/msg/icomms/small_platform.xml ${CMAKE_BINARY_DIR}/examples/msg/icomms/deployment_peer02.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/icomms/)
ADD_TEST(memcheck-msg-icomms-ucontext-2 ${CMAKE_BINARY_DIR}/examples/msg/icomms/peer ${CMAKE_BINARY_DIR}/examples/msg/icomms/small_platform.xml ${CMAKE_BINARY_DIR}/examples/msg/icomms/deployment_peer03.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/icomms/)
ADD_TEST(memcheck-msg-icomms-ucontext-3 ${CMAKE_BINARY_DIR}/examples/msg/icomms/peer ${CMAKE_BINARY_DIR}/examples/msg/icomms/small_platform.xml ${CMAKE_BINARY_DIR}/examples/msg/icomms/deployment_peer04.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/icomms/)
ADD_TEST(memcheck-msg-icomms-ucontext-4 ${CMAKE_BINARY_DIR}/examples/msg/icomms/peer2 ${CMAKE_BINARY_DIR}/examples/msg/icomms/small_platform.xml ${CMAKE_BINARY_DIR}/examples/msg/icomms/deployment_peer.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/icomms/)
ADD_TEST(memcheck-msg-actions-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment_split.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-raw-1 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment.xml actions_allReduce.txt "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-raw-2 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment.xml actions_barrier.txt "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-raw-3 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment.xml actions_bcast.txt "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-raw-4 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment.xml actions_reduce.txt "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-raw-5 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment.xml actions_with_isend.txt "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment_split.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-thread-1 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment.xml actions_allReduce.txt "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-thread-2 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment.xml actions_barrier.txt "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-thread-3 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment.xml actions_bcast.txt "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-thread-4 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment.xml actions_reduce.txt "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-thread-5 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment.xml actions_with_isend.txt "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment_split.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-ucontext-1 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment.xml actions_allReduce.txt "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-ucontext-2 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment.xml actions_barrier.txt "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-ucontext-3 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment.xml actions_bcast.txt "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-ucontext-4 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment.xml actions_reduce.txt "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/actions/)
ADD_TEST(memcheck-msg-actions-ucontext-5 ${CMAKE_BINARY_DIR}/examples/msg/actions/actions --log=actions.thres=verbose homogeneous_3_hosts.xml deployment.xml actions_with_isend.txt "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/actions/)
ADD_TEST(memcheck-msg-masterslave-cpu-ti-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_forwarder small_platform.xml masterslave/deployment_masterslave.xml --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-cpu-ti-raw-1 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_forwarder msg_platform.xml masterslave/deployment_masterslave_forwarder.xml --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-cpu-ti-raw-2 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_failure --log=xbt_cfg.thres:critical --log=no_loc small_platform_with_failures.xml masterslave/deployment_masterslave.xml --cfg=path:${CMAKE_HOME_DIRECTORY}/src --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-cpu-ti-raw-3 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_bypass --log=no_loc --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-cpu-ti-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_forwarder small_platform.xml masterslave/deployment_masterslave.xml --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-cpu-ti-thread-1 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_forwarder msg_platform.xml masterslave/deployment_masterslave_forwarder.xml --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-cpu-ti-thread-2 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_failure --log=xbt_cfg.thres:critical --log=no_loc small_platform_with_failures.xml masterslave/deployment_masterslave.xml --cfg=path:${CMAKE_HOME_DIRECTORY}/src --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-cpu-ti-thread-3 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_bypass --log=no_loc --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-cpu-ti-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_forwarder small_platform.xml masterslave/deployment_masterslave.xml --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-cpu-ti-ucontext-1 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_forwarder msg_platform.xml masterslave/deployment_masterslave_forwarder.xml --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-cpu-ti-ucontext-2 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_failure --log=xbt_cfg.thres:critical --log=no_loc small_platform_with_failures.xml masterslave/deployment_masterslave.xml --cfg=path:${CMAKE_HOME_DIRECTORY}/src --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-masterslave-cpu-ti-ucontext-3 ${CMAKE_BINARY_DIR}/examples/msg/masterslave/masterslave_bypass --log=no_loc --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test1.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-raw-1 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test2.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-raw-2 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test3.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-raw-3 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test4.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-raw-4 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test5.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-raw-5 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test6.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-raw-6 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test7.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-raw-7 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test8.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-raw-8 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test9.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-raw-9 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test10.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-raw-10 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test11.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test1.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-thread-1 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test2.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-thread-2 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test3.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-thread-3 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test4.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-thread-4 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test5.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-thread-5 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test6.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-thread-6 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test7.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-thread-7 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test8.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-thread-8 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test9.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-thread-9 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test10.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-thread-10 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test11.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test1.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-ucontext-1 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test2.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-ucontext-2 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test3.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-ucontext-3 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test4.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-ucontext-4 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test5.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-ucontext-5 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test6.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-ucontext-6 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test7.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-ucontext-7 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test8.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-ucontext-8 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test9.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-ucontext-9 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test10.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-trace-ucontext-10 ${CMAKE_BINARY_DIR}/examples/msg/trace/test_trace_integration ./trace/test11.xml --cfg=workstation/model:compound --cfg=network/model:CM02 --cfg=cpu/model:CpuTI "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-msg-token-ring-raw-0 token_ring ${CMAKE_BINARY_DIR}/examples/msg/token_ring/two_clusters.xml --log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n  --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/token_ring/)
ADD_TEST(memcheck-msg-token-ring-raw-1 token_ring ${CMAKE_BINARY_DIR}/examples/msg/token_ring/two_peers.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/token_ring/)
ADD_TEST(memcheck-msg-token-ring-thread-0 token_ring ${CMAKE_BINARY_DIR}/examples/msg/token_ring/two_clusters.xml --log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n  --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/token_ring/)
ADD_TEST(memcheck-msg-token-ring-thread-1 token_ring ${CMAKE_BINARY_DIR}/examples/msg/token_ring/two_peers.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/token_ring/)
ADD_TEST(memcheck-msg-token-ring-ucontext-0 token_ring ${CMAKE_BINARY_DIR}/examples/msg/token_ring/two_clusters.xml --log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n  --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/token_ring/)
ADD_TEST(memcheck-msg-token-ring-ucontext-1 token_ring ${CMAKE_BINARY_DIR}/examples/msg/token_ring/two_peers.xml "--log=root.fmt:[%10.6r]%e[%i:%P@%h]%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/token_ring/)

IF(${ARCH_32_BITS})
ADD_TEST(memcheck-gras-ping-sg-32-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/ping/ping_simulator ${CMAKE_BINARY_DIR}/examples/gras/ping/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/ping/ping.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/ping/)
ADD_TEST(memcheck-gras-ping-sg-32-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/ping/ping_simulator ${CMAKE_BINARY_DIR}/examples/gras/ping/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/ping/ping.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/ping/)
ADD_TEST(memcheck-gras-ping-sg-32-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/ping/ping_simulator ${CMAKE_BINARY_DIR}/examples/gras/ping/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/ping/ping.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/ping/)
ADD_TEST(memcheck-gras-rpc-sg-32-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/rpc/rpc_simulator ${CMAKE_BINARY_DIR}/examples/gras/rpc/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/rpc/rpc.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/rpc/)
ADD_TEST(memcheck-gras-rpc-sg-32-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/rpc/rpc_simulator ${CMAKE_BINARY_DIR}/examples/gras/rpc/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/rpc/rpc.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/rpc/)
ADD_TEST(memcheck-gras-rpc-sg-32-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/rpc/rpc_simulator ${CMAKE_BINARY_DIR}/examples/gras/rpc/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/rpc/rpc.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/rpc/)
ADD_TEST(memcheck-gras-spawn-sg-32-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/spawn/spawn_simulator ${CMAKE_BINARY_DIR}/examples/gras/spawn/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/spawn/spawn.xml --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/spawn/)
ADD_TEST(memcheck-gras-spawn-sg-32-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/spawn/spawn_simulator ${CMAKE_BINARY_DIR}/examples/gras/spawn/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/spawn/spawn.xml --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/spawn/)
ADD_TEST(memcheck-gras-spawn-sg-32-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/spawn/spawn_simulator ${CMAKE_BINARY_DIR}/examples/gras/spawn/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/spawn/spawn.xml --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/spawn/)
ADD_TEST(memcheck-gras-timer-sg-32-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/timer/timer_simulator ${CMAKE_BINARY_DIR}/examples/gras/timer/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/timer/timer.xml --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/timer/)
ADD_TEST(memcheck-gras-timer-sg-32-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/timer/timer_simulator ${CMAKE_BINARY_DIR}/examples/gras/timer/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/timer/timer.xml --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/timer/)
ADD_TEST(memcheck-gras-timer-sg-32-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/timer/timer_simulator ${CMAKE_BINARY_DIR}/examples/gras/timer/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/timer/timer.xml --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/timer/)
ADD_TEST(memcheck-gras-chrono-sg-32-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/chrono/chrono_simulator ${CMAKE_BINARY_DIR}/examples/gras/chrono/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/chrono/chrono.xml --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/chrono/)
ADD_TEST(memcheck-gras-chrono-sg-32-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/chrono/chrono_simulator ${CMAKE_BINARY_DIR}/examples/gras/chrono/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/chrono/chrono.xml --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/chrono/)
ADD_TEST(memcheck-gras-chrono-sg-32-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/chrono/chrono_simulator ${CMAKE_BINARY_DIR}/examples/gras/chrono/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/chrono/chrono.xml --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/chrono/)
ADD_TEST(memcheck-gras-simple-token-sg-32-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/simple_token_simulator ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/../../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/simple_token.xml  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/)
ADD_TEST(memcheck-gras-simple-token-sg-32-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/simple_token_simulator ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/../../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/simple_token.xml  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/)
ADD_TEST(memcheck-gras-simple-token-sg-32-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/simple_token_simulator ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/../../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/simple_token.xml  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/)
ADD_TEST(memcheck-gras-mmrpc-sg-32-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/mmrpc_simulator ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/mmrpc.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/)
ADD_TEST(memcheck-gras-mmrpc-sg-32-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/mmrpc_simulator ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/mmrpc.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/)
ADD_TEST(memcheck-gras-mmrpc-sg-32-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/mmrpc_simulator ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/mmrpc.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/)
ADD_TEST(memcheck-gras-all2all-sg-32-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/all2all/all2all_simulator ${CMAKE_BINARY_DIR}/examples/gras/all2all/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/all2all/all2all.xml "--log=root.fmt:[%10.6r]%e(%.2i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/all2all/)
ADD_TEST(memcheck-gras-all2all-sg-32-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/all2all/all2all_simulator ${CMAKE_BINARY_DIR}/examples/gras/all2all/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/all2all/all2all.xml "--log=root.fmt:[%10.6r]%e(%.2i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/all2all/)
ADD_TEST(memcheck-gras-all2all-sg-32-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/all2all/all2all_simulator ${CMAKE_BINARY_DIR}/examples/gras/all2all/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/all2all/all2all.xml "--log=root.fmt:[%10.6r]%e(%.2i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/all2all/)
ADD_TEST(memcheck-gras-pmm-sg-32-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/pmm/pmm_simulator ${CMAKE_BINARY_DIR}/examples/gras/pmm/../../msg/msg_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/pmm/pmm.xml "--log=root.fmt:[%10.6r]%e(%2i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/pmm/)
ADD_TEST(memcheck-gras-pmm-sg-32-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/pmm/pmm_simulator ${CMAKE_BINARY_DIR}/examples/gras/pmm/../../msg/msg_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/pmm/pmm.xml "--log=root.fmt:[%10.6r]%e(%2i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/pmm/)
ADD_TEST(memcheck-gras-pmm-sg-32-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/pmm/pmm_simulator ${CMAKE_BINARY_DIR}/examples/gras/pmm/../../msg/msg_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/pmm/pmm.xml "--log=root.fmt:[%10.6r]%e(%2i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/pmm/)
ADD_TEST(memcheck-gras-synchro-sg-32-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/synchro/synchro_simulator ${CMAKE_BINARY_DIR}/examples/gras/synchro/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/synchro/synchro.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/synchro/)
ADD_TEST(memcheck-gras-synchro-sg-32-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/synchro/synchro_simulator ${CMAKE_BINARY_DIR}/examples/gras/synchro/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/synchro/synchro.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/synchro/)
ADD_TEST(memcheck-gras-synchro-sg-32-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/synchro/synchro_simulator ${CMAKE_BINARY_DIR}/examples/gras/synchro/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/synchro/synchro.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/synchro/)
ELSE(${ARCH_32_BITS})
ADD_TEST(memcheck-gras-ping-sg-64-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/ping/ping_simulator ${CMAKE_BINARY_DIR}/examples/gras/ping/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/ping/ping.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/ping/)
ADD_TEST(memcheck-gras-ping-sg-64-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/ping/ping_simulator ${CMAKE_BINARY_DIR}/examples/gras/ping/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/ping/ping.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/ping/)
ADD_TEST(memcheck-gras-ping-sg-64-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/ping/ping_simulator ${CMAKE_BINARY_DIR}/examples/gras/ping/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/ping/ping.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/ping/)
ADD_TEST(memcheck-gras-rpc-sg-64-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/rpc/rpc_simulator ${CMAKE_BINARY_DIR}/examples/gras/rpc/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/rpc/rpc.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/rpc/)
ADD_TEST(memcheck-gras-rpc-sg-64-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/rpc/rpc_simulator ${CMAKE_BINARY_DIR}/examples/gras/rpc/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/rpc/rpc.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/rpc/)
ADD_TEST(memcheck-gras-rpc-sg-64-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/rpc/rpc_simulator ${CMAKE_BINARY_DIR}/examples/gras/rpc/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/rpc/rpc.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/rpc/)
ADD_TEST(memcheck-gras-spawn-sg-64-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/spawn/spawn_simulator ${CMAKE_BINARY_DIR}/examples/gras/spawn/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/spawn/spawn.xml --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/spawn/)
ADD_TEST(memcheck-gras-spawn-sg-64-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/spawn/spawn_simulator ${CMAKE_BINARY_DIR}/examples/gras/spawn/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/spawn/spawn.xml --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/spawn/)
ADD_TEST(memcheck-gras-spawn-sg-64-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/spawn/spawn_simulator ${CMAKE_BINARY_DIR}/examples/gras/spawn/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/spawn/spawn.xml --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/spawn/)
ADD_TEST(memcheck-gras-timer-sg-64-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/timer/timer_simulator ${CMAKE_BINARY_DIR}/examples/gras/timer/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/timer/timer.xml --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/timer/)
ADD_TEST(memcheck-gras-timer-sg-64-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/timer/timer_simulator ${CMAKE_BINARY_DIR}/examples/gras/timer/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/timer/timer.xml --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/timer/)
ADD_TEST(memcheck-gras-timer-sg-64-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/timer/timer_simulator ${CMAKE_BINARY_DIR}/examples/gras/timer/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/timer/timer.xml --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/timer/)
ADD_TEST(memcheck-gras-chrono-sg-64-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/chrono/chrono_simulator ${CMAKE_BINARY_DIR}/examples/gras/chrono/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/chrono/chrono.xml --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/chrono/)
ADD_TEST(memcheck-gras-chrono-sg-64-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/chrono/chrono_simulator ${CMAKE_BINARY_DIR}/examples/gras/chrono/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/chrono/chrono.xml --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/chrono/)
ADD_TEST(memcheck-gras-chrono-sg-64-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/chrono/chrono_simulator ${CMAKE_BINARY_DIR}/examples/gras/chrono/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/chrono/chrono.xml --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/chrono/)
ADD_TEST(memcheck-gras-simple-token-sg-64-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/simple_token_simulator ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/../../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/simple_token.xml  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/)
ADD_TEST(memcheck-gras-simple-token-sg-64-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/simple_token_simulator ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/../../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/simple_token.xml  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/)
ADD_TEST(memcheck-gras-simple-token-sg-64-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/simple_token_simulator ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/../../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/simple_token.xml  "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/mutual_exclusion/simple_token/)
ADD_TEST(memcheck-gras-mmrpc-sg-64-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/mmrpc_simulator ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/mmrpc.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/)
ADD_TEST(memcheck-gras-mmrpc-sg-64-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/mmrpc_simulator ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/mmrpc.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/)
ADD_TEST(memcheck-gras-mmrpc-sg-64-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/mmrpc_simulator ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/mmrpc.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/mmrpc/)
ADD_TEST(memcheck-gras-all2all-sg-64-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/all2all/all2all_simulator ${CMAKE_BINARY_DIR}/examples/gras/all2all/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/all2all/all2all.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/all2all/)
ADD_TEST(memcheck-gras-all2all-sg-64-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/all2all/all2all_simulator ${CMAKE_BINARY_DIR}/examples/gras/all2all/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/all2all/all2all.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/all2all/)
ADD_TEST(memcheck-gras-all2all-sg-64-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/all2all/all2all_simulator ${CMAKE_BINARY_DIR}/examples/gras/all2all/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/all2all/all2all.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/all2all/)
ADD_TEST(memcheck-gras-pmm-sg-64-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/pmm/pmm_simulator ${CMAKE_BINARY_DIR}/examples/gras/pmm/../../msg/msg_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/pmm/pmm.xml "--log=root.fmt:[%10.6r]%e(%2i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/pmm/)
ADD_TEST(memcheck-gras-pmm-sg-64-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/pmm/pmm_simulator ${CMAKE_BINARY_DIR}/examples/gras/pmm/../../msg/msg_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/pmm/pmm.xml "--log=root.fmt:[%10.6r]%e(%2i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/pmm/)
ADD_TEST(memcheck-gras-pmm-sg-64-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/pmm/pmm_simulator ${CMAKE_BINARY_DIR}/examples/gras/pmm/../../msg/msg_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/pmm/pmm.xml "--log=root.fmt:[%10.6r]%e(%2i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/pmm/)
ADD_TEST(memcheck-gras-synchro-sg-64-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/synchro/synchro_simulator ${CMAKE_BINARY_DIR}/examples/gras/synchro/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/synchro/synchro.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/synchro/)
ADD_TEST(memcheck-gras-synchro-sg-64-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/synchro/synchro_simulator ${CMAKE_BINARY_DIR}/examples/gras/synchro/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/synchro/synchro.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/synchro/)
ADD_TEST(memcheck-gras-synchro-sg-64-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/synchro/synchro_simulator ${CMAKE_BINARY_DIR}/examples/gras/synchro/../../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/gras/synchro/synchro.xml "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/synchro/)
ENDIF(${ARCH_32_BITS})
ADD_TEST(memcheck-gras-properties-sg-raw-0 ${CMAKE_BINARY_DIR}/examples/gras/properties/properties_simulator ${CMAKE_BINARY_DIR}/examples/gras/properties/../../platforms/prop.xml ${CMAKE_BINARY_DIR}/examples/gras/properties/properties.xml --log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/gras/properties/)
ADD_TEST(memcheck-gras-properties-sg-thread-0 ${CMAKE_BINARY_DIR}/examples/gras/properties/properties_simulator ${CMAKE_BINARY_DIR}/examples/gras/properties/../../platforms/prop.xml ${CMAKE_BINARY_DIR}/examples/gras/properties/properties.xml --log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/gras/properties/)
ADD_TEST(memcheck-gras-properties-sg-ucontext-0 ${CMAKE_BINARY_DIR}/examples/gras/properties/properties_simulator ${CMAKE_BINARY_DIR}/examples/gras/properties/../../platforms/prop.xml ${CMAKE_BINARY_DIR}/examples/gras/properties/properties.xml --log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/gras/properties/)

# amok examples
IF(${ARCH_32_BITS})
ADD_TEST(memcheck-amok-bandwidth-sg-32-raw-0 ${CMAKE_BINARY_DIR}/examples/amok/bandwidth/bandwidth_simulator ${CMAKE_BINARY_DIR}/examples/amok/../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/amok/bandwidth/bandwidth.xml --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/amok/)
ADD_TEST(memcheck-amok-bandwidth-sg-32-thread-0 ${CMAKE_BINARY_DIR}/examples/amok/bandwidth/bandwidth_simulator ${CMAKE_BINARY_DIR}/examples/amok/../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/amok/bandwidth/bandwidth.xml --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/amok/)
ADD_TEST(memcheck-amok-bandwidth-sg-32-ucontext-0 ${CMAKE_BINARY_DIR}/examples/amok/bandwidth/bandwidth_simulator ${CMAKE_BINARY_DIR}/examples/amok/../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/amok/bandwidth/bandwidth.xml --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/amok/)
ADD_TEST(memcheck-amok-saturate-sg-32-raw-0 ${CMAKE_BINARY_DIR}/examples/amok/saturate/saturate_simulator ${CMAKE_BINARY_DIR}/examples/amok/../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/amok/saturate/saturate.xml --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/amok/)
ADD_TEST(memcheck-amok-saturate-sg-32-thread-0 ${CMAKE_BINARY_DIR}/examples/amok/saturate/saturate_simulator ${CMAKE_BINARY_DIR}/examples/amok/../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/amok/saturate/saturate.xml --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/amok/)
ADD_TEST(memcheck-amok-saturate-sg-32-ucontext-0 ${CMAKE_BINARY_DIR}/examples/amok/saturate/saturate_simulator ${CMAKE_BINARY_DIR}/examples/amok/../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/amok/saturate/saturate.xml --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/amok/)
ELSE(${ARCH_32_BITS})
ADD_TEST(memcheck-amok-bandwidth-sg-64-raw-0 ${CMAKE_BINARY_DIR}/examples/amok/bandwidth/bandwidth_simulator ${CMAKE_BINARY_DIR}/examples/amok/../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/amok/bandwidth/bandwidth.xml --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/amok/)
ADD_TEST(memcheck-amok-bandwidth-sg-64-thread-0 ${CMAKE_BINARY_DIR}/examples/amok/bandwidth/bandwidth_simulator ${CMAKE_BINARY_DIR}/examples/amok/../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/amok/bandwidth/bandwidth.xml --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/amok/)
ADD_TEST(memcheck-amok-bandwidth-sg-64-ucontext-0 ${CMAKE_BINARY_DIR}/examples/amok/bandwidth/bandwidth_simulator ${CMAKE_BINARY_DIR}/examples/amok/../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/amok/bandwidth/bandwidth.xml --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/amok/)
ADD_TEST(memcheck-amok-saturate-sg-64-raw-0 ${CMAKE_BINARY_DIR}/examples/amok/saturate/saturate_simulator ${CMAKE_BINARY_DIR}/examples/amok/../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/amok/saturate/saturate.xml --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/amok/)
ADD_TEST(memcheck-amok-saturate-sg-64-thread-0 ${CMAKE_BINARY_DIR}/examples/amok/saturate/saturate_simulator ${CMAKE_BINARY_DIR}/examples/amok/../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/amok/saturate/saturate.xml --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/amok/)
ADD_TEST(memcheck-amok-saturate-sg-64-ucontext-0 ${CMAKE_BINARY_DIR}/examples/amok/saturate/saturate_simulator ${CMAKE_BINARY_DIR}/examples/amok/../msg/small_platform.xml ${CMAKE_BINARY_DIR}/examples/amok/saturate/saturate.xml --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/amok/)
ENDIF(${ARCH_32_BITS})

# simdag examples
ADD_TEST(memcheck-simdag-test-simdag-raw-0 ${CMAKE_BINARY_DIR}/examples/simdag/sd_test ${CMAKE_BINARY_DIR}/examples/simdag/../msg/msg_platform.xml --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/simdag/)
ADD_TEST(memcheck-simdag-test-simdag-thread-0 ${CMAKE_BINARY_DIR}/examples/simdag/sd_test ${CMAKE_BINARY_DIR}/examples/simdag/../msg/msg_platform.xml --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/simdag/)
ADD_TEST(memcheck-simdag-test-simdag-ucontext-0 ${CMAKE_BINARY_DIR}/examples/simdag/sd_test ${CMAKE_BINARY_DIR}/examples/simdag/../msg/msg_platform.xml --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/simdag/)
ADD_TEST(memcheck-simdag-test-simdag2-raw-0 ${CMAKE_BINARY_DIR}/examples/simdag/sd_test2 ${CMAKE_BINARY_DIR}/examples/simdag/2clusters.xml --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/simdag/)
ADD_TEST(memcheck-simdag-test-simdag2-thread-0 ${CMAKE_BINARY_DIR}/examples/simdag/sd_test2 ${CMAKE_BINARY_DIR}/examples/simdag/2clusters.xml --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/simdag/)
ADD_TEST(memcheck-simdag-test-simdag2-ucontext-0 ${CMAKE_BINARY_DIR}/examples/simdag/sd_test2 ${CMAKE_BINARY_DIR}/examples/simdag/2clusters.xml --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/simdag/)
ADD_TEST(memcheck-simdag-test-simdag-seq-access-raw-0 ${CMAKE_BINARY_DIR}/examples/simdag/sd_seq_access ${CMAKE_BINARY_DIR}/examples/simdag/2clusters.xml --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/simdag/)
ADD_TEST(memcheck-simdag-test-simdag-seq-access-thread-0 ${CMAKE_BINARY_DIR}/examples/simdag/sd_seq_access ${CMAKE_BINARY_DIR}/examples/simdag/2clusters.xml --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/simdag/)
ADD_TEST(memcheck-simdag-test-simdag-seq-access-ucontext-0 ${CMAKE_BINARY_DIR}/examples/simdag/sd_seq_access ${CMAKE_BINARY_DIR}/examples/simdag/2clusters.xml --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/simdag/)
ADD_TEST(memcheck-simdag-test-prop-raw-0 ${CMAKE_BINARY_DIR}/examples/simdag/properties/sd_prop ${CMAKE_BINARY_DIR}/examples/simdag/../platforms/prop.xml --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/simdag/)
ADD_TEST(memcheck-simdag-test-prop-thread-0 ${CMAKE_BINARY_DIR}/examples/simdag/properties/sd_prop ${CMAKE_BINARY_DIR}/examples/simdag/../platforms/prop.xml --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/simdag/)
ADD_TEST(memcheck-simdag-test-prop-ucontext-0 ${CMAKE_BINARY_DIR}/examples/simdag/properties/sd_prop ${CMAKE_BINARY_DIR}/examples/simdag/../platforms/prop.xml --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/simdag/)
ADD_TEST(memcheck-simdag-minmin-test-raw-0 ${CMAKE_BINARY_DIR}/examples/simdag/scheduling/minmin_test --log=sd_daxparse.thresh:critical /simulacrum_7_hosts.xml /Montage_25.xml --cfg contexts/factory:raw  --cd /home/navarrop/simgrid/simgrid/trunk/examples/simdag/scheduling/)
ADD_TEST(memcheck-simdag-minmin-test-thread-0 ${CMAKE_BINARY_DIR}/examples/simdag/scheduling/minmin_test --log=sd_daxparse.thresh:critical /simulacrum_7_hosts.xml /Montage_25.xml --cfg contexts/factory:thread  --cd /home/navarrop/simgrid/simgrid/trunk/examples/simdag/scheduling/)
ADD_TEST(memcheck-simdag-minmin-test-ucontext-0 ${CMAKE_BINARY_DIR}/examples/simdag/scheduling/minmin_test --log=sd_daxparse.thresh:critical /simulacrum_7_hosts.xml /Montage_25.xml --cfg contexts/factory:ucontext  --cd /home/navarrop/simgrid/simgrid/trunk/examples/simdag/scheduling/)

if(HAVE_GTNETS)
ADD_TEST(memcheck-msg-gtnets-waxman-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_BINARY_DIR}/examples/msg/gtnets/waxman-p.xml ${CMAKE_BINARY_DIR}/examples/msg/gtnets/waxman-d.xml --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:GTNets --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-waxman-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_BINARY_DIR}/examples/msg/gtnets/waxman-p.xml ${CMAKE_BINARY_DIR}/examples/msg/gtnets/waxman-d.xml --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:GTNets --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-waxman-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_BINARY_DIR}/examples/msg/gtnets/waxman-p.xml ${CMAKE_BINARY_DIR}/examples/msg/gtnets/waxman-d.xml --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:GTNets --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-dogbone-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_BINARY_DIR}/examples/msg/gtnets/dogbone-p.xml ${CMAKE_BINARY_DIR}/examples/msg/gtnets/dogbone-d.xml --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:GTNets --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-dogbone-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_BINARY_DIR}/examples/msg/gtnets/dogbone-p.xml ${CMAKE_BINARY_DIR}/examples/msg/gtnets/dogbone-d.xml --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:GTNets --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-dogbone-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_BINARY_DIR}/examples/msg/gtnets/dogbone-p.xml ${CMAKE_BINARY_DIR}/examples/msg/gtnets/dogbone-d.xml --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:GTNets --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-onelink-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_BINARY_DIR}/examples/msg/gtnets/onelink-p.xml ${CMAKE_BINARY_DIR}/examples/msg/gtnets/onelink-d.xml --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:GTNets --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-onelink-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_BINARY_DIR}/examples/msg/gtnets/onelink-p.xml ${CMAKE_BINARY_DIR}/examples/msg/gtnets/onelink-d.xml --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:GTNets --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-onelink-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_BINARY_DIR}/examples/msg/gtnets/onelink-p.xml ${CMAKE_BINARY_DIR}/examples/msg/gtnets/onelink-d.xml --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:GTNets --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-dogbone-lv08-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_BINARY_DIR}/examples/msg/gtnets/dogbone-p.xml ${CMAKE_BINARY_DIR}/examples/msg/gtnets/dogbone-d.xml --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:LV08 --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-dogbone-lv08-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_BINARY_DIR}/examples/msg/gtnets/dogbone-p.xml ${CMAKE_BINARY_DIR}/examples/msg/gtnets/dogbone-d.xml --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:LV08 --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-dogbone-lv08-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_BINARY_DIR}/examples/msg/gtnets/dogbone-p.xml ${CMAKE_BINARY_DIR}/examples/msg/gtnets/dogbone-d.xml --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:LV08 --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-onelink-lv08-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_BINARY_DIR}/examples/msg/gtnets/onelink-p.xml ${CMAKE_BINARY_DIR}/examples/msg/gtnets/onelink-d.xml --cfg=workstation/model:compound --cfg=cpu/model:Cas01  --cfg=network/model:LV08 2>&1 | grep --color=auto -v root/INFO | grep -v simix_network/INFO --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-onelink-lv08-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_BINARY_DIR}/examples/msg/gtnets/onelink-p.xml ${CMAKE_BINARY_DIR}/examples/msg/gtnets/onelink-d.xml --cfg=workstation/model:compound --cfg=cpu/model:Cas01  --cfg=network/model:LV08 2>&1 | grep --color=auto -v root/INFO | grep -v simix_network/INFO --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-onelink-lv08-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_BINARY_DIR}/examples/msg/gtnets/onelink-p.xml ${CMAKE_BINARY_DIR}/examples/msg/gtnets/onelink-d.xml --cfg=workstation/model:compound --cfg=cpu/model:Cas01  --cfg=network/model:LV08 2>&1 | grep --color=auto -v root/INFO | grep -v simix_network/INFO --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-fullduplex-raw-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_BINARY_DIR}/examples/msg/gtnets/fullduplex-p.xml ${CMAKE_BINARY_DIR}/examples/msg/gtnets/fullduplex-d.xml --cfg=fullduplex:0 --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-fullduplex-raw-1 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_BINARY_DIR}/examples/msg/gtnets/fullduplex-p.xml ${CMAKE_BINARY_DIR}/examples/msg/gtnets/fullduplex-d.xml --cfg=fullduplex:1 --cfg contexts/factory:raw  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-fullduplex-thread-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_BINARY_DIR}/examples/msg/gtnets/fullduplex-p.xml ${CMAKE_BINARY_DIR}/examples/msg/gtnets/fullduplex-d.xml --cfg=fullduplex:0 --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-fullduplex-thread-1 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_BINARY_DIR}/examples/msg/gtnets/fullduplex-p.xml ${CMAKE_BINARY_DIR}/examples/msg/gtnets/fullduplex-d.xml --cfg=fullduplex:1 --cfg contexts/factory:thread  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-fullduplex-ucontext-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_BINARY_DIR}/examples/msg/gtnets/fullduplex-p.xml ${CMAKE_BINARY_DIR}/examples/msg/gtnets/fullduplex-d.xml --cfg=fullduplex:0 --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-gtnets-fullduplex-ucontext-1 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_BINARY_DIR}/examples/msg/gtnets/fullduplex-p.xml ${CMAKE_BINARY_DIR}/examples/msg/gtnets/fullduplex-d.xml --cfg=fullduplex:1 --cfg contexts/factory:ucontext  --cd ${CMAKE_BINARY_DIR}/examples/msg/)
  if(HAVE_TRACING)
ADD_TEST(memcheck-msg-tracing-gtnets-waxman-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_BINARY_DIR}/examples/msg/gtnets/waxman-p.xml ${CMAKE_BINARY_DIR}/examples/msg/gtnets/waxman-d.xml --cfg=tracing/filename:waxman_gtnets.trace --cfg=tracing/categorized:1 --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:GTNets --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-tracing-gtnets-dogbone-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_BINARY_DIR}/examples/msg/gtnets/dogbone-p.xml ${CMAKE_BINARY_DIR}/examples/msg/gtnets/dogbone-d.xml --cfg=tracing/filename:dogbone_gtnets.trace --cfg=tracing/categorized:1 --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:GTNets --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-tracing-gtnets-onelink-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_BINARY_DIR}/examples/msg/gtnets/onelink-p.xml ${CMAKE_BINARY_DIR}/examples/msg/gtnets/onelink-d.xml --cfg=tracing/filename:onelink_gtnets.trace --cfg=tracing/categorized:1 --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:GTNets --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-tracing-gtnets-dogbone-lv08-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_BINARY_DIR}/examples/msg/gtnets/dogbone-p.xml ${CMAKE_BINARY_DIR}/examples/msg/gtnets/dogbone-d.xml --cfg=tracing/filename:dogbone_lv08.trace --cfg=tracing/categorized:1 --cfg=workstation/model:compound --cfg=cpu/model:Cas01 --cfg=network/model:LV08 --cd ${CMAKE_BINARY_DIR}/examples/msg/)
ADD_TEST(memcheck-msg-tracing-gtnets-onelink-lv08-0 ${CMAKE_BINARY_DIR}/examples/msg/gtnets/gtnets ${CMAKE_BINARY_DIR}/examples/msg/gtnets/onelink-p.xml ${CMAKE_BINARY_DIR}/examples/msg/gtnets/onelink-d.xml --cfg=tracing/filename:onelink_lv08.trace --cfg=tracing/categorized:1 --cfg=workstation/model:compound --cfg=cpu/model:Cas01  --cfg=network/model:LV08 2>&1 | grep --color=auto -v root/INFO | grep -v simix_network/INFO --cd ${CMAKE_BINARY_DIR}/examples/msg/)
  endif(HAVE_TRACING)
endif(HAVE_GTNETS)

IF(HAVE_TRACING)
ADD_TEST(memcheck-tracing-ms-0 ${CMAKE_BINARY_DIR}/examples/msg/tracing/ms --cfg=tracing:1 --cfg=tracing/filename:tracing/ms.trace --cfg=tracing/categorized:1 --cfg=tracing/uncategorized:1 --cfg=triva/categorized:tracing/ms.cat.plist --cfg=triva/uncategorized:tracing/ms.uncat.plist --log=instr_paje.thres:debug --log=instr_paje_trace.thres:debug "--log=root.fmt:[%10.6r]%e\(%i:%P@%h\)%e%m%n" /tracing/platform.xml /tracing/deployment.xml --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-tracing-ms-1 cat tracing/ms.trace --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-tracing-ms-2 cat tracing/ms.uncat.plist --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-tracing-ms-3 rm -rf tracing/ms.trace tracing/ms.cat.plist tracing/ms.uncat.plist --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-tracing-categories-0 ${CMAKE_BINARY_DIR}/examples/msg/tracing/categories --cfg=tracing:1 --cfg=tracing/filename:tracing/categories.trace --cfg=tracing/categorized:1 --cfg=tracing/uncategorized:1 --cfg=triva/categorized:tracing/categories.cat.plist --cfg=triva/uncategorized:tracing/categories.uncat.plist /tracing/platform.xml /tracing/deployment.xml --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-tracing-categories-1 cat tracing/categories.trace --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-tracing-categories-2 rm -rf tracing/categories.trace tracing/categories.cat.plist tracing/categories.uncat.plist --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-tracing-tasks-0 ${CMAKE_BINARY_DIR}/examples/msg/tracing/tasks --cfg=tracing:1 --cfg=tracing/msg/task:1 --cfg=tracing/filename:tracing/tasks.trace /tracing/platform.xml /tracing/deployment.xml --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-tracing-tasks-1 cat tracing/tasks.trace --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-tracing-tasks-2 rm -rf tracing/tasks.trace --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-tracing-process-migration-0 ${CMAKE_BINARY_DIR}/examples/msg/tracing/procmig --cfg=tracing:1 --cfg=tracing/filename:tracing/procmig.trace --cfg=tracing/msg/process:1 /tracing/platform.xml /tracing/procmig-deploy.xml --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-tracing-process-migration-1 cat tracing/procmig.trace --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ADD_TEST(memcheck-tracing-process-migration-2 rm -rf tracing/procmig.trace --cd /home/navarrop/simgrid/simgrid/trunk/examples/msg/)
ENDIF(HAVE_TRACING)

# Lua examples
if(HAVE_LUA)
ADD_TEST(memcheck-lua-masterslave-0 lua master_slave.lua --cd /home/navarrop/simgrid/simgrid/trunk/examples/lua/)
ADD_TEST(memcheck-lua-mult-matrix-0 lua mult_matrix.lua "--log=root.fmt:[%10.6r]%e(%i:%P@%h)%e%m%n" --cd /home/navarrop/simgrid/simgrid/trunk/examples/lua/)
ADD_TEST(memcheck-lua-masterslave-bypass-0 lua master_slave.lua --log=surf_parse.thres:critical --cd /home/navarrop/simgrid/simgrid/trunk/examples/lua/)
ADD_TEST(memcheck-lua-msg-masterslave-console-0 masterslave_console ${CMAKE_BINARY_DIR}/examples/msg/masterslave/platform_script.lua --log=surf_parse.thres:critical "--log=root.fmt:[%11.6r]%e(%i:%P@%h)%e%m%n" --cd ${CMAKE_BINARY_DIR}/examples/msg/masterslave/)
set_tests_properties(memcheck-lua-masterslave-0 				PROPERTIES ENVIRONMENT "LUA_CPATH=${CMAKE_BINARY_DIR}/examples/lua/?.so")
set_tests_properties(memcheck-lua-mult-matrix-0  				PROPERTIES ENVIRONMENT "LUA_CPATH=${CMAKE_BINARY_DIR}/examples/lua/?.so")
set_tests_properties(memcheck-lua-masterslave-bypass-0  		PROPERTIES ENVIRONMENT "LUA_CPATH=${CMAKE_BINARY_DIR}/examples/lua/?.so")
set_tests_properties(memcheck-lua-msg-masterslave-console-0  	PROPERTIES ENVIRONMENT "LUA_CPATH=${CMAKE_BINARY_DIR}/examples/lua/?.so")
endif(HAVE_LUA)

