/* $Id$ */

/* simgrid_config.h - Results of the configure made visible to user code    */

/* Copyright (c) 2009, 2010, 2011. Da SimGrid team. All rights reserved.    */

/* This program is free software; you can redistribute it and/or modify it
 * under the terms of the license (GNU LGPL) which comes with this package. */

#include "xbt/misc.h"           /* XBT_PUBLIC */

#ifndef SIMGRID_PUBLIC_CONFIG_H
#define SIMGRID_PUBLIC_CONFIG_H
SG_BEGIN_DECL()


/* Version X.Y.Z will get version number XYZ: all digits concatenated without dots
 * (with Y and Z must be on two positions)*/

#define MAKE_SIMGRID_VERSION(major, minor, patch)       \
  (100UL * (100UL * (major) + (minor)) + (patch))

#define SIMGRID_VERSION_MAJOR 3
#define SIMGRID_VERSION_MINOR 5
#define SIMGRID_VERSION_PATCH 94

#define SIMGRID_VERSION MAKE_SIMGRID_VERSION(SIMGRID_VERSION_MAJOR, \
                                             SIMGRID_VERSION_MINOR, \
                                             SIMGRID_VERSION_PATCH)

/* take care of DLL usage madness */

#ifdef _XBT_DLL_EXPORT
	#define DLL_EXPORT
#else
	#ifdef _XBT_DLL_STATIC
		#define DLL_STATIC
	#else
		#define DLL_IMPORT
	#endif
#endif

/* #undef _XBT_WIN32 */
/* #undef _WIN32 */
/* #undef _WIN64 */
/* #undef __VISUALC__ */
/* #undef __BORLANDC__ */
#ifdef _XBT_WIN32
	#ifndef __GNUC__
/* #undef __GNUC__ */
	#endif
#endif


/* Define to 1 if you have the `mmap' function. */
#define HAVE_MMAP 1

/* Get the config */
#undef SIMGRID_NEED_GETLINE
#undef SIMGRID_NEED_ASPRINTF
#undef SIMGRID_NEED_VASPRINTF




/* Use that config to declare missing elements */
#ifdef SIMGRID_NEED_GETLINE
#include <stdlib.h> /* size_t */
#include <stdio.h>  /* FILE*  */
XBT_PUBLIC(long) getline(char **lineptr, size_t * n, FILE * stream);
#else
#ifndef _GNU_SOURCE
	#define _GNU_SOURCE
#endif
#include <stdio.h>
#endif
#include <stdarg.h>

/* snprintf related functions */
/** @addtogroup XBT_str
  * @{ */
/** @brief print to allocated string (reimplemented when not provided by the system)
 *
 * The functions asprintf() and vasprintf() are analogues of
 * sprintf() and vsprintf(), except that they allocate a string large
 * enough to hold the output including the terminating null byte, and
 * return a pointer to it via the first parameter.  This pointer
 * should be passed to free(3) to release the allocated storage when
 * it is no longer needed.
 */
#if defined(SIMGRID_NEED_ASPRINTF)||defined(DOXYGEN)
XBT_PUBLIC(int) asprintf(char **ptr, const char *fmt,   /*args */
                         ...) _XBT_GNUC_PRINTF(2, 3);
#endif
/** @brief print to allocated string (reimplemented when not provided by the system)
 *
 * See asprintf()
 */
#if defined(SIMGRID_NEED_VASPRINTF)||defined(DOXYGEN)
XBT_PUBLIC(int) vasprintf(char **ptr, const char *fmt, va_list ap);
#endif
/** @brief print to allocated string
 *
 * Works just like vasprintf(), but returns a pointer to the newly
 * created string, or aborts on error.
 */
XBT_PUBLIC(char *) bvprintf(const char *fmt, va_list ap);
/** @brief print to allocated string
 *
 * Works just like asprintf(), but returns a pointer to the newly
 * created string, or aborts on error.
 */
XBT_PUBLIC(char *) bprintf(const char *fmt, ...) _XBT_GNUC_PRINTF(1, 2);
/** @} */

/* Define if xbt contexts are based on our threads implementation or not */
#define CONTEXT_THREADS 1

/* Tracing SimGrid */
#define HAVE_TRACING 1

/* Jedule output  */
/* #undef HAVE_JEDULE */

/* Tracking of latency bound */
#define HAVE_LATENCY_BOUND_TRACKING 1

/* If __thread is available */
#define HAVE_THREAD_LOCAL_STORAGE 1


SG_END_DECL()
#endif /* SIMGRID_PUBLIC_CONFIG_H */
