/* Validating XML processor for src/simdag/dax.dtd.
 *
 * This program was generated with the FleXML XML processor generator.
 * FleXML is Copyright (C) 1999-2005 Kristoffer Rose.  All rights reserved.
 * FleXML is Copyright (C) 2003-2006 Martin Quinson.  All rights reserved.
 * (Id: flexml.pl,v 1.62 2007/10/11 10:00:14 mquinson Exp).
 * 
 * There are two, intertwined parts to this program, part A and part B.
 *
 * Part A
 * ------
 * 
 * Some parts, here collectively called "Part A", are found in the 
 * FleXML package.  They are Copyright (C) 1999-2005 Kristoffer Rose
 * and Copyright (C) 2003-2006 Martin Quinson. All rights reserved.
 *
 * You can redistribute, use, perform, display and/or modify "Part A"
 * provided the following two conditions hold:
 *
 * 1. The program is distributed WITHOUT ANY WARRANTY from the author of
 *    FleXML; without even the implied warranty of MERCHANTABILITY or
 *    FITNESS FOR A PARTICULAR PURPOSE.
 *
 * 2. The program distribution conditions do not in any way affect the
 *    distribution conditions of the FleXML system used to generate this
 *    file or any version of FleXML derived from that system.
 *
 * Notice that these are explicit rights granted to you for files
 * generated by the FleXML system.  For your rights in connection with
 * the FleXML system itself please consult the GNU General Public License.
 * 
 * Part B
 * ------
 * 
 * The other parts, here collectively called "Part B", and which came 
 * from the DTD used by FleXML to generate this program, can be 
 * distributed (or not, as the case may be) under the terms of whoever
 * wrote them, provided these terms respect and obey the two conditions 
 * above under the heading "Part A".
 *
 * The author of and contributors to FleXML specifically disclaim
 * any copyright interest in "Part B", unless "Part B" was written 
 * by the author of or contributors to FleXML.
 * 
 */

%{

/* Version strings. */
const char rcs_dax__flexml_skeleton[] =
 "$" "Id: skel,v 1.40 2007/10/11 09:57:24 mquinson Exp $";
const char rcs_dax__flexml[] =
 "$" "Id: flexml.pl,v 1.62 2007/10/11 10:00:14 mquinson Exp $";

/* ANSI headers. */
#include <stdlib.h> /* for realloc() -- needed here when using flex 2.5.4 */
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <stdarg.h>
#include <ctype.h>
     
#if defined(_XBT_WIN32) || defined(__WIN32__) || defined(WIN32) || defined(__TOS_WIN__)
# ifndef __STRICT_ANSI__
#  include <io.h>
#  include <process.h>
# endif
#else
# include <unistd.h>
#endif
     
#ifndef FLEXML_INDEXSTACKSIZE
#define FLEXML_INDEXSTACKSIZE 1000
#endif

/* Generated definitions. */
#define FLEXML_yylineno
#ifndef FLEXML_BUFFERSTACKSIZE
#define FLEXML_BUFFERSTACKSIZE 1000000
#endif
#define FLEXML_NEED_BUFFERLIT

/* XML processor api. */
/* FleXML-provided data. */
int dax__pcdata_ix;
extern char *dax__bufferstack;
#define dax__pcdata (dax__bufferstack + dax__pcdata_ix)
AT_dax__adag_version AX_dax__adag_version;
#define A_dax__adag_version (dax__bufferstack + AX_dax__adag_version)
AT_dax__uses_type AX_dax__uses_type;
#define A_dax__uses_type (dax__bufferstack + AX_dax__uses_type)
AT_dax__uses_optional AX_dax__uses_optional;
#define A_dax__uses_optional AX_dax__uses_optional
AT_dax__adag_name AX_dax__adag_name;
#define A_dax__adag_name (dax__bufferstack + AX_dax__adag_name)
AT_dax__child_ref AX_dax__child_ref;
#define A_dax__child_ref (dax__bufferstack + AX_dax__child_ref)
AT_dax__adag_xmlns AX_dax__adag_xmlns;
#define A_dax__adag_xmlns (dax__bufferstack + AX_dax__adag_xmlns)
AT_dax__uses_transfer AX_dax__uses_transfer;
#define A_dax__uses_transfer AX_dax__uses_transfer
AT_dax__job_id AX_dax__job_id;
#define A_dax__job_id (dax__bufferstack + AX_dax__job_id)
AT_dax__uses_file AX_dax__uses_file;
#define A_dax__uses_file (dax__bufferstack + AX_dax__uses_file)
AT_dax__parent_ref AX_dax__parent_ref;
#define A_dax__parent_ref (dax__bufferstack + AX_dax__parent_ref)
AT_dax__adag_count AX_dax__adag_count;
#define A_dax__adag_count (dax__bufferstack + AX_dax__adag_count)
AT_dax__adag_xmlns_c_xsi AX_dax__adag_xmlns_c_xsi;
#define A_dax__adag_xmlns_c_xsi (dax__bufferstack + AX_dax__adag_xmlns_c_xsi)
AT_dax__adag_index AX_dax__adag_index;
#define A_dax__adag_index (dax__bufferstack + AX_dax__adag_index)
AT_dax__uses_size AX_dax__uses_size;
#define A_dax__uses_size (dax__bufferstack + AX_dax__uses_size)
AT_dax__adag_childCount AX_dax__adag_childCount;
#define A_dax__adag_childCount (dax__bufferstack + AX_dax__adag_childCount)
AT_dax__uses_link AX_dax__uses_link;
#define A_dax__uses_link AX_dax__uses_link
AT_dax__job_runtime AX_dax__job_runtime;
#define A_dax__job_runtime (dax__bufferstack + AX_dax__job_runtime)
AT_dax__job_level AX_dax__job_level;
#define A_dax__job_level (dax__bufferstack + AX_dax__job_level)
AT_dax__job_namespace AX_dax__job_namespace;
#define A_dax__job_namespace (dax__bufferstack + AX_dax__job_namespace)
AT_dax__job_name AX_dax__job_name;
#define A_dax__job_name (dax__bufferstack + AX_dax__job_name)
AT_dax__adag_jobCount AX_dax__adag_jobCount;
#define A_dax__adag_jobCount (dax__bufferstack + AX_dax__adag_jobCount)
AT_dax__job_version AX_dax__job_version;
#define A_dax__job_version (dax__bufferstack + AX_dax__job_version)
AT_dax__adag_xsi_c_schemaLocation AX_dax__adag_xsi_c_schemaLocation;
#define A_dax__adag_xsi_c_schemaLocation (dax__bufferstack + AX_dax__adag_xsi_c_schemaLocation)
AT_dax__uses_register AX_dax__uses_register;
#define A_dax__uses_register AX_dax__uses_register
AT_dax__adag_fileCount AX_dax__adag_fileCount;
#define A_dax__adag_fileCount (dax__bufferstack + AX_dax__adag_fileCount)

/* XML state. */
#ifdef FLEX_DEBUG
# define ENTER(state)	debug_enter(state,#state)
# define LEAVE		debug_leave()
# define SET(state)	debug_set(state,#state)
  static void debug_enter(int, const char*);
  static void debug_leave(void);
  static void debug_set(int, const char*);
#else
# define ENTER(state)	(yy_push_state(state))
# define LEAVE		(yy_pop_state())
# define SET(state)	BEGIN(state)
#endif

/* Generic actions. */
#define SKIP	/*skip*/
#define SUCCEED        CLEANUP; return 0

#define FAIL	return fail
static int fail(const char*, ...);

enum {flexml_max_err_msg_size = 512};
static char flexml_err_msg[flexml_max_err_msg_size];
const char * dax__parse_err_msg()
{
    return flexml_err_msg;
}
static void reset_dax__parse_err_msg()
{
    flexml_err_msg[0] = '\0';
}

/* Cleanup */
static void cleanup(void);
#define CLEANUP  cleanup()

/* Text buffer stack handling. */
char *dax__bufferstack = NULL;
static int blimit = FLEXML_BUFFERSTACKSIZE;
static int bnext = 1;

static int *indexstack = NULL;
static int ilimit = FLEXML_INDEXSTACKSIZE;
static int inext = 1;

#define BUFFERSET(P)  (P = bnext)
#define BUFFERPUTC(C) (ck_blimit(), dax__bufferstack[bnext++] = (C))
#define BUFFERDONE    (BUFFERPUTC('\0'))

#define BUFFERLITERAL(C, P) dax__bufferliteral(C, &(P), yytext)

/* after this is called, there are at least 2 slots left in the stack */
static int ck_blimit()
{
     if (bnext >= blimit) {
	 blimit += FLEXML_BUFFERSTACKSIZE + 2;
	 {
	     char *temp = (char *) realloc(dax__bufferstack, blimit);
	     assert(temp);
	     dax__bufferstack = temp;
	 }
     }
     return 0;
}

/* after this is called, there are at least 2 slots left in the stack */
static int ck_ilimit()
{
     if (inext >= ilimit) {
	 ilimit += FLEXML_INDEXSTACKSIZE + 2;
	 {
	     int *temp = (int *) realloc(indexstack, ilimit);
	     assert(temp);
	     indexstack = temp;
	 }
     }
     return 0;
}

#ifdef FLEXML_NEED_BUFFERLIT
static void dax__bufferliteral(char c, int* pp, const char* text)
{
  const char *s = (c ? strchr(text,c) : text-1), *e = strrchr(text,c);
  assert(s <= e); BUFFERSET(*pp);
  while (++s<e) {
    if (isspace(*s) && c) { BUFFERPUTC(' '); while (isspace(*s)) ++s; }
    else BUFFERPUTC(*s);
  }
  BUFFERDONE;
}
#endif

static void pushbuffer(int p)
{
    ck_ilimit();
    indexstack[inext++] = p;
    indexstack[inext++] = bnext;    
}

static int popbuffer(void)
{
    assert(inext >= 2);
    bnext = indexstack[--inext];
    return indexstack[--inext];
}

/* General internal entities are `unput' back onto the input stream... */
#define ENTITYTEXT(T) \
  { char *s = (T), *e = s+strlen(s);\
    while (--e >= s) { unput(*e); }}


%}

/* Flex standard options. */
%option stack
%option noyy_top_state
%option noinput
%option noreject
%option noyymore
%option noyywrap

/* Flex user-requested options. */
%option yylineno
%option nounput

/* XML character classes (currently restricted to ASCII). */

/* "Common syntactic structures." */
S		[ \t\n\r\f]+
s		[ \t\n\r\f]*

/* "Names and Tokens." */
NameChar	[A-Za-z0-9.:_-]
Name		[A-Za-z_:]{NameChar}*
Names 		{Name}({S}{Name})*
Nmtoken		({NameChar})+
Nmtokens 	{Nmtoken}({S}{Nmtoken})*

/* Miscellaneous. */
VersionNum	[a-zA-Z0-9_.:-]+
Eq		{s}"="{s}
Literal		\'[^'']*\'|\"[^""]*\"

/* Parser states (flex `exclusive start conditions'):
 *
 * PROLOG	the XML prolog of the document before <?xml...>
 * DOCTYPE	the XML prolog of the document after <?xml...>
 * EPILOG	after the root element
 * INCOMMENT	inside an XML comment <!--....-->
 * INPI		inside an XML PI <?...?>
 * VALUE1	inside a '...'-delimited literal
 * VALUE2	inside a "..."-delimited literal
 * CDATA	inside a <![CDATA[...] ]> section.
 * ROOT_<tag>	expect root element <tag>
 * AL_<tag>	inside the attribute list for <tag>
 * IN_<tag>	inside a <tag> with element contents (ready for end tag)
 * IMPOSSIBLE	dummy to permit disabling rules; must be last
 */
%x PROLOG DOCTYPE EPILOG INCOMMENT INPI VALUE1 VALUE2 CDATA
%x ROOT_dax__adag AL_dax__adag S_dax__adag S_dax__adag_1 S_dax__adag_2 S_dax__adag_3 S_dax__adag_4 S_dax__adag_5 E_dax__adag
%x AL_dax__job S_dax__job S_dax__job_1 S_dax__job_2 E_dax__job
%x AL_dax__uses E_dax__uses
%x AL_dax__child S_dax__child S_dax__child_1 S_dax__child_2 E_dax__child
%x AL_dax__parent E_dax__parent
%x IMPOSSIBLE

%{
/* State names. */
const char* *dax__statenames=NULL;
%}

%%

 /* Bypass Flex's default INITIAL state and begin by parsing the XML prolog. */
 SET(PROLOG);
 reset_dax__parse_err_msg();
 dax__bufferstack = (char *) malloc(FLEXML_BUFFERSTACKSIZE);
 assert(dax__bufferstack);
 #ifdef FLEX_DEBUG
 {
     int i;
     for (i = 0; i < blimit; i++) {
         dax__bufferstack[i] = '\377';
     }
 }
 #endif
 dax__bufferstack[0] = '\0';
 indexstack = (int *) malloc(FLEXML_INDEXSTACKSIZE * sizeof(int));
 assert(indexstack);
 indexstack[0] = 0;

  /* FleXML_init */
  bnext = inext = 1;
  dax__bufferliteral('\0', &bnext, "http://pegasus.isi.edu/schema/DAX");
  dax__bufferliteral('\0', &bnext, "http://www.w3.org/2001/XMLSchema-instance");
  dax__bufferliteral('\0', &bnext, "http://pegasus.isi.edu/schema/DAX http://pegasus.isi.edu/schema/dax-2.1.xsd");
  dax__bufferliteral('\0', &bnext, "1.0");
  dax__bufferliteral('\0', &bnext, "0.0");
  dax__bufferliteral('\0', &bnext, "data");
  if(!dax__statenames) {dax__statenames= (const char **)calloc(IMPOSSIBLE,sizeof(char*));
  dax__statenames[PROLOG] = NULL;
  dax__statenames[DOCTYPE] = NULL;
  dax__statenames[EPILOG] = NULL;
  dax__statenames[INCOMMENT] = NULL;
  dax__statenames[INPI] = NULL;
  dax__statenames[VALUE1] = NULL;
  dax__statenames[VALUE2] = NULL;
  dax__statenames[CDATA] = NULL;
  dax__statenames[ROOT_dax__adag] = NULL;
  dax__statenames[AL_dax__adag] = NULL;
  dax__statenames[S_dax__adag] = "adag";
  dax__statenames[S_dax__adag_1] = "adag";
  dax__statenames[S_dax__adag_2] = "adag";
  dax__statenames[S_dax__adag_3] = "adag";
  dax__statenames[S_dax__adag_4] = "adag";
  dax__statenames[S_dax__adag_5] = "adag";
  dax__statenames[E_dax__adag] = "adag";
  dax__statenames[AL_dax__job] = NULL;
  dax__statenames[S_dax__job] = "job";
  dax__statenames[S_dax__job_1] = "job";
  dax__statenames[S_dax__job_2] = "job";
  dax__statenames[E_dax__job] = "job";
  dax__statenames[AL_dax__uses] = NULL;
  dax__statenames[E_dax__uses] = "uses";
  dax__statenames[AL_dax__child] = NULL;
  dax__statenames[S_dax__child] = "child";
  dax__statenames[S_dax__child_1] = "child";
  dax__statenames[S_dax__child_2] = "child";
  dax__statenames[E_dax__child] = "child";
  dax__statenames[AL_dax__parent] = NULL;
  dax__statenames[E_dax__parent] = "parent";
  }

 /* COMMENTS and PIs: handled uniformly for efficiency. */

<ROOT_dax__adag,AL_dax__adag,S_dax__adag,S_dax__adag_1,S_dax__adag_2,S_dax__adag_3,S_dax__adag_4,S_dax__adag_5,E_dax__adag,AL_dax__job,S_dax__job,S_dax__job_1,S_dax__job_2,E_dax__job,AL_dax__uses,E_dax__uses,AL_dax__child,S_dax__child,S_dax__child_1,S_dax__child_2,E_dax__child,AL_dax__parent,E_dax__parent,PROLOG,DOCTYPE,EPILOG>{
 "<!--" ENTER(INCOMMENT);
 "<?" ENTER(INPI);
}
<INCOMMENT>{
 "-->"		LEAVE;
 "--"		|
 .		|
 \n		SKIP;
 <<EOF>>	FAIL("EOF in comment.");
}
<INPI>{
 "?>"		LEAVE;
 .		|
 \n		SKIP;
 <<EOF>>	FAIL("EOF in PI (processing instruction).");
}

 /* SPACES: skipped uniformly */

<ROOT_dax__adag,AL_dax__adag,S_dax__adag,S_dax__adag_1,S_dax__adag_2,S_dax__adag_3,S_dax__adag_4,S_dax__adag_5,E_dax__adag,AL_dax__job,S_dax__job,S_dax__job_1,S_dax__job_2,E_dax__job,AL_dax__uses,E_dax__uses,AL_dax__child,S_dax__child,S_dax__child_1,S_dax__child_2,E_dax__child,AL_dax__parent,E_dax__parent,PROLOG,DOCTYPE,EPILOG>{S} SKIP;

 /* PROLOG: determine root element and process it. */

<PROLOG>{
 "<?xml"({S}version{Eq}(\'{VersionNum}\'|\"{VersionNum}\"))?({S}encoding{Eq}(\'[^']*\'|\"[^"]*\"))?"?>" SET(ROOT_dax__adag); 
 "<?xml"[^>]*">" FAIL("Bad declaration %s.",yytext);
}

<PROLOG,DOCTYPE>{
 "<!DOCTYPE"{S}"adag"{S}SYSTEM{S}("'dax.dtd'"|"\"dax.dtd\""){s}">" SET(ROOT_dax__adag);
 "<!"[^>-][^>]*">" FAIL("Bad declaration %s.",yytext);
 . 		FAIL("Unexpected character `%c' in prolog.", yytext[0]);
 <<EOF>> 	FAIL("EOF in prolog.");
}

 /* RULES DERIVED FROM DTD. */

 /* <!-- Small DTD for DAX files. -->  */

<S_dax__child_1,S_dax__job,S_dax__adag_3,S_dax__child_2,S_dax__adag_5,S_dax__job_1,E_dax__job,E_dax__adag,S_dax__child,S_dax__adag_4,S_dax__job_2,S_dax__adag,S_dax__adag_2,S_dax__adag_1,E_dax__child>"<adag"{s} FAIL("Starting tag <adag> is not allowed here.");

<ROOT_dax__adag>"<adag"{s} {
  AX_dax__adag_xmlns = 1;
  AX_dax__adag_xmlns_c_xsi = 35;
  AX_dax__adag_xsi_c_schemaLocation = 77;
  AX_dax__adag_version = 153;
  AX_dax__adag_count = 0;
  AX_dax__adag_index = 0;
  AX_dax__adag_name = 0;
  AX_dax__adag_jobCount = 0;
  AX_dax__adag_fileCount = 0;
  AX_dax__adag_childCount = 0;
  ENTER(AL_dax__adag); pushbuffer(0);
  }

<AL_dax__adag>{
 "xmlns"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_dax__adag_xmlns);
 "xmlns"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_dax__adag_xmlns);

 "xmlns:xsi"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_dax__adag_xmlns_c_xsi);
 "xmlns:xsi"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_dax__adag_xmlns_c_xsi);

 "xsi:schemaLocation"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_dax__adag_xsi_c_schemaLocation);
 "xsi:schemaLocation"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_dax__adag_xsi_c_schemaLocation);

 "version"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_dax__adag_version);
 "version"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_dax__adag_version);

 "count"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_dax__adag_count);
 "count"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_dax__adag_count);

 "index"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_dax__adag_index);
 "index"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_dax__adag_index);

 "name"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_dax__adag_name);
 "name"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_dax__adag_name);

 "jobCount"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_dax__adag_jobCount);
 "jobCount"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_dax__adag_jobCount);

 "fileCount"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_dax__adag_fileCount);
 "fileCount"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_dax__adag_fileCount);

 "childCount"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_dax__adag_childCount);
 "childCount"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_dax__adag_childCount);

 ">" {
  LEAVE; STag_dax__adag();dax__pcdata_ix = 0; ENTER(S_dax__adag);
 }
 "/>" {
  LEAVE; STag_dax__adag(); dax__pcdata_ix = 0; ETag_dax__adag(); popbuffer(); /* attribute */
  switch (YY_START) {
   case ROOT_dax__adag: SET(EPILOG); break;
  }
 }
 .       FAIL("Unexpected character `%c' in attribute list of adag element.", yytext[0]);
 {Name} FAIL("Bad attribute `%s' in `adag' element start tag.",yytext);
 <<EOF>> FAIL("EOF in attribute list of `adag' element.");
}

<S_dax__adag_1,S_dax__adag_5,E_dax__adag,S_dax__adag_3,S_dax__adag>{
 "</adag"{s}">" {
  LEAVE;
  ETag_dax__adag();
  popbuffer(); /* attribute */
  switch (YY_START) {
   case ROOT_dax__adag: SET(EPILOG); break;
  }
 }
 "</"{Name}{s}">" FAIL("Unexpected end-tag `%s': `</adag>' expected.",yytext);
 .       FAIL("Unexpected character `%c': `</adag>' expected.",yytext[0]);
 <<EOF>> FAIL("Premature EOF: `</adag>' expected.");
}

<S_dax__child_1,S_dax__job,S_dax__child_2,ROOT_dax__job,S_dax__adag_5,S_dax__job_1,E_dax__job,E_dax__adag,S_dax__child,S_dax__adag_4,S_dax__job_2,E_dax__child,S_dax__adag_1>"<job"{s} FAIL("Starting tag <job> is not allowed here.");

<S_dax__adag_2,S_dax__adag_3,S_dax__adag>"<job"{s} {
  AX_dax__job_id = 0;
  AX_dax__job_namespace = 0;
  AX_dax__job_name = 0;
  AX_dax__job_version = 157;
  AX_dax__job_runtime = 0;
  AX_dax__job_level = 0;
  ENTER(AL_dax__job); pushbuffer(0);
  }

<AL_dax__job>{
 "id"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_dax__job_id);
 "id"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_dax__job_id);

 "namespace"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_dax__job_namespace);
 "namespace"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_dax__job_namespace);

 "name"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_dax__job_name);
 "name"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_dax__job_name);

 "version"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_dax__job_version);
 "version"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_dax__job_version);

 "runtime"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_dax__job_runtime);
 "runtime"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_dax__job_runtime);

 "level"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_dax__job_level);
 "level"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_dax__job_level);

 ">" {
  if (!AX_dax__job_id) FAIL("Required attribute `id' not set for `job' element.");
  if (!AX_dax__job_name) FAIL("Required attribute `name' not set for `job' element.");
  if (!AX_dax__job_runtime) FAIL("Required attribute `runtime' not set for `job' element.");
  LEAVE; STag_dax__job();dax__pcdata_ix = 0; ENTER(S_dax__job);
 }
 "/>" {
  if (!AX_dax__job_id) FAIL("Required attribute `id' not set for `job' element.");
  if (!AX_dax__job_name) FAIL("Required attribute `name' not set for `job' element.");
  if (!AX_dax__job_runtime) FAIL("Required attribute `runtime' not set for `job' element.");
  LEAVE; STag_dax__job(); dax__pcdata_ix = 0; ETag_dax__job(); popbuffer(); /* attribute */
  switch (YY_START) {
   case S_dax__adag_2: case S_dax__adag_3: case S_dax__adag: SET(S_dax__adag_3); break;
  }
 }
 .       FAIL("Unexpected character `%c' in attribute list of job element.", yytext[0]);
 {Name} FAIL("Bad attribute `%s' in `job' element start tag.",yytext);
 <<EOF>> FAIL("EOF in attribute list of `job' element.");
}

<S_dax__job,E_dax__job,S_dax__job_2>{
 "</job"{s}">" {
  LEAVE;
  ETag_dax__job();
  popbuffer(); /* attribute */
  switch (YY_START) {
   case S_dax__adag_2: case S_dax__adag_3: case S_dax__adag: SET(S_dax__adag_3); break;
  }
 }
 "</"{Name}{s}">" FAIL("Unexpected end-tag `%s': `</job>' expected.",yytext);
 .       FAIL("Unexpected character `%c': `</job>' expected.",yytext[0]);
 <<EOF>> FAIL("Premature EOF: `</job>' expected.");
}

 /* <!-- ignored -->
  * <!-- ignored -->  */

<S_dax__child_1,S_dax__adag_3,S_dax__child_2,S_dax__adag_5,E_dax__job,E_dax__adag,S_dax__child,S_dax__adag_4,ROOT_dax__uses,S_dax__adag,S_dax__adag_2,E_dax__child,S_dax__adag_1>"<uses"{s} FAIL("Starting tag <uses> is not allowed here.");

<S_dax__job,S_dax__job_2,S_dax__job_1>"<uses"{s} {
  AX_dax__uses_file = 0;
  AX_dax__uses_link = AU_dax__uses_link;
  AX_dax__uses_register = A_dax__uses_register_true;
  AX_dax__uses_transfer = A_dax__uses_transfer_true;
  AX_dax__uses_optional = A_dax__uses_optional_false;
  AX_dax__uses_type = 161;
  AX_dax__uses_size = 0;
  ENTER(AL_dax__uses); pushbuffer(0);
  }

<AL_dax__uses>{
 "file"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_dax__uses_file);
 "file"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_dax__uses_file);

 "link"{Eq}"'input'" |
 "link"{Eq}"\"input\"" A_dax__uses_link = A_dax__uses_link_input;
 "link"{Eq}"'output'" |
 "link"{Eq}"\"output\"" A_dax__uses_link = A_dax__uses_link_output;

 "register"{Eq}"'false'" |
 "register"{Eq}"\"false\"" A_dax__uses_register = A_dax__uses_register_false;
 "register"{Eq}"'true'" |
 "register"{Eq}"\"true\"" A_dax__uses_register = A_dax__uses_register_true;

 "transfer"{Eq}"'false'" |
 "transfer"{Eq}"\"false\"" A_dax__uses_transfer = A_dax__uses_transfer_false;
 "transfer"{Eq}"'true'" |
 "transfer"{Eq}"\"true\"" A_dax__uses_transfer = A_dax__uses_transfer_true;

 "optional"{Eq}"'false'" |
 "optional"{Eq}"\"false\"" A_dax__uses_optional = A_dax__uses_optional_false;
 "optional"{Eq}"'true'" |
 "optional"{Eq}"\"true\"" A_dax__uses_optional = A_dax__uses_optional_true;

 "type"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_dax__uses_type);
 "type"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_dax__uses_type);

 "size"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_dax__uses_size);
 "size"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_dax__uses_size);

 ">" {
  if (!AX_dax__uses_file) FAIL("Required attribute `file' not set for `uses' element.");
  if (!AX_dax__uses_size) FAIL("Required attribute `size' not set for `uses' element.");
  LEAVE; STag_dax__uses();dax__pcdata_ix = 0; ENTER(E_dax__uses);
 }
 "/>" {
  if (!AX_dax__uses_file) FAIL("Required attribute `file' not set for `uses' element.");
  if (!AX_dax__uses_size) FAIL("Required attribute `size' not set for `uses' element.");
  LEAVE; STag_dax__uses(); dax__pcdata_ix = 0; ETag_dax__uses(); popbuffer(); /* attribute */
  switch (YY_START) {
   case S_dax__job: case S_dax__job_2: case S_dax__job_1: SET(S_dax__job_2); break;
  }
 }
 .       FAIL("Unexpected character `%c' in attribute list of uses element.", yytext[0]);
 {Name} FAIL("Bad attribute `%s' in `uses' element start tag.",yytext);
 <<EOF>> FAIL("EOF in attribute list of `uses' element.");
}

<E_dax__uses>{
 "</uses"{s}">" {
  LEAVE;
  ETag_dax__uses();
  popbuffer(); /* attribute */
  switch (YY_START) {
   case S_dax__job: case S_dax__job_2: case S_dax__job_1: SET(S_dax__job_2); break;
  }
 }
 "</"{Name}{s}">" FAIL("Unexpected end-tag `%s': `</uses>' expected.",yytext);
 .       FAIL("Unexpected character `%c': `</uses>' expected.",yytext[0]);
 <<EOF>> FAIL("Premature EOF: `</uses>' expected.");
}

<S_dax__child_1,S_dax__job,S_dax__child_2,S_dax__job_1,E_dax__job,E_dax__adag,S_dax__child,S_dax__job_2,S_dax__adag_2,E_dax__child,ROOT_dax__child>"<child"{s} FAIL("Starting tag <child> is not allowed here.");

<S_dax__adag_1,S_dax__adag_4,S_dax__adag_5,S_dax__adag_3,S_dax__adag>"<child"{s} {
  AX_dax__child_ref = 0;
  ENTER(AL_dax__child); pushbuffer(0);
  }

<AL_dax__child>{
 "ref"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_dax__child_ref);
 "ref"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_dax__child_ref);

 ">" {
  if (!AX_dax__child_ref) FAIL("Required attribute `ref' not set for `child' element.");
  LEAVE; STag_dax__child();dax__pcdata_ix = 0; ENTER(S_dax__child);
 }
 "/>" {
  if (!AX_dax__child_ref) FAIL("Required attribute `ref' not set for `child' element.");
  LEAVE; STag_dax__child(); dax__pcdata_ix = 0; ETag_dax__child(); popbuffer(); /* attribute */
  switch (YY_START) {
   case S_dax__adag_1: case S_dax__adag_4: case S_dax__adag_5: case S_dax__adag_3: case S_dax__adag: SET(S_dax__adag_5); break;
  }
 }
 .       FAIL("Unexpected character `%c' in attribute list of child element.", yytext[0]);
 {Name} FAIL("Bad attribute `%s' in `child' element start tag.",yytext);
 <<EOF>> FAIL("EOF in attribute list of `child' element.");
}

<S_dax__child_2,E_dax__child,S_dax__child>{
 "</child"{s}">" {
  LEAVE;
  ETag_dax__child();
  popbuffer(); /* attribute */
  switch (YY_START) {
   case S_dax__adag_1: case S_dax__adag_4: case S_dax__adag_5: case S_dax__adag_3: case S_dax__adag: SET(S_dax__adag_5); break;
  }
 }
 "</"{Name}{s}">" FAIL("Unexpected end-tag `%s': `</child>' expected.",yytext);
 .       FAIL("Unexpected character `%c': `</child>' expected.",yytext[0]);
 <<EOF>> FAIL("Premature EOF: `</child>' expected.");
}

<S_dax__job,S_dax__adag_3,S_dax__adag_5,S_dax__job_1,E_dax__job,E_dax__adag,S_dax__adag_4,ROOT_dax__parent,S_dax__job_2,S_dax__adag,S_dax__adag_2,E_dax__child,S_dax__adag_1>"<parent"{s} FAIL("Starting tag <parent> is not allowed here.");

<S_dax__child_2,S_dax__child,S_dax__child_1>"<parent"{s} {
  AX_dax__parent_ref = 0;
  ENTER(AL_dax__parent); pushbuffer(0);
  }

<AL_dax__parent>{
 "ref"{Eq}\' ENTER(VALUE1); BUFFERSET(AX_dax__parent_ref);
 "ref"{Eq}\" ENTER(VALUE2); BUFFERSET(AX_dax__parent_ref);

 ">" {
  if (!AX_dax__parent_ref) FAIL("Required attribute `ref' not set for `parent' element.");
  LEAVE; STag_dax__parent();dax__pcdata_ix = 0; ENTER(E_dax__parent);
 }
 "/>" {
  if (!AX_dax__parent_ref) FAIL("Required attribute `ref' not set for `parent' element.");
  LEAVE; STag_dax__parent(); dax__pcdata_ix = 0; ETag_dax__parent(); popbuffer(); /* attribute */
  switch (YY_START) {
   case S_dax__child_2: case S_dax__child: case S_dax__child_1: SET(S_dax__child_2); break;
  }
 }
 .       FAIL("Unexpected character `%c' in attribute list of parent element.", yytext[0]);
 {Name} FAIL("Bad attribute `%s' in `parent' element start tag.",yytext);
 <<EOF>> FAIL("EOF in attribute list of `parent' element.");
}

<E_dax__parent>{
 "</parent"{s}">" {
  LEAVE;
  ETag_dax__parent();
  popbuffer(); /* attribute */
  switch (YY_START) {
   case S_dax__child_2: case S_dax__child: case S_dax__child_1: SET(S_dax__child_2); break;
  }
 }
 "</"{Name}{s}">" FAIL("Unexpected end-tag `%s': `</parent>' expected.",yytext);
 .       FAIL("Unexpected character `%c': `</parent>' expected.",yytext[0]);
 <<EOF>> FAIL("Premature EOF: `</parent>' expected.");
}

 /* EPILOG: after the root element. */

<EPILOG>{
 . {SET(PROLOG); yyless(0); CLEANUP; return -1;}
 <<EOF>> 	SUCCEED;
}

 /* CHARACTER DATA. */

<IMPOSSIBLE,VALUE1,VALUE2>{
 /* Non-defined standard entities... */
"&amp;"  BUFFERPUTC('&');
"&lt;"   BUFFERPUTC('<');
"&gt;"   BUFFERPUTC('>');
"&apos;" BUFFERPUTC('\'');
"&quot;" BUFFERPUTC('"');

 /* Character entities. */
 "&#"[[:digit:]]+";"	BUFFERPUTC((unsigned char)atoi(yytext+2));
 "&#x"[[:xdigit:]]+";"	BUFFERPUTC((unsigned char)strtol(yytext+3,NULL,16));
}

<IMPOSSIBLE,VALUE1,VALUE2,CDATA>{
 "\n"		|
 "\r"		|
 "\r\n"		|
 "\n\r"		BUFFERPUTC('\n');
}

<IMPOSSIBLE>{
 "<![CDATA["	ENTER(CDATA);
 "]""]>"		FAIL("Unexpected `]""]>' in character data.");
}

<VALUE1>{
 \'		BUFFERDONE; LEAVE;
 <<EOF>>	FAIL("EOF in literal (\"'\" expected).");
}

<VALUE2>{
 \"		BUFFERDONE; LEAVE;
 <<EOF>>	FAIL("EOF in literal (`\"' expected).");
}

<IMPOSSIBLE,VALUE1,VALUE2>{
 [^<&]		BUFFERPUTC(yytext[0]);
 [<&]		FAIL("Spurious `%c' in character data.",yytext[0]);
}

<CDATA>{
 "]""]>"		LEAVE;
 /* "]""]"		BUFFERPUTC(yytext[0]); BUFFERPUTC(yytext[1]); */
 .		BUFFERPUTC(yytext[0]);
 <<EOF>>	FAIL("EOF in CDATA section.");
}

 /* Impossible rules to avoid warnings from flex(1). */
 /* Ideally, this should be replaced by code in flexml.pl that
    generates just the states not covered by other rules. */
<*>{
 .|[\n] FAIL("Syntax error on character `%c'.", yytext[0]);
}

%%

/* Element context stack lookup. */
int dax__element_context(int i)
{
  return (0<i && i<yy_start_stack_depth
	  ? yy_start_stack[yy_start_stack_ptr - i]
	  : 0);
}

#ifdef FLEX_DEBUG
void print_yy_stack(char* fmt, ...)
{
  int i = 0; va_list ap; va_start(ap, fmt);
  vfprintf(stderr, fmt, ap);
  if (dax__statenames) {
      for (i=1; i<yy_start_stack_ptr; i++) {
          fprintf(stderr, "%s/", dax__statenames[yy_start_stack[i] ]);
      }
      fprintf(stderr,"%s\n", dax__statenames[YY_START]);
  }
  va_end(ap);
}

void print_dax__bufferstack()
{
    int i;
    fputs("Buffer: ", stderr);
    for (i = 0; i < blimit; i++) {
       if ( dax__bufferstack[i] == '\377' ) break;
         putc(dax__bufferstack[i], stderr);
    }
    putc('\n', stderr);
}

static void debug_enter(int state, const char* statename) {
  yy_push_state(state);
  if (yy_flex_debug) {
       print_yy_stack("--ENTER(%s) : ",statename);
       print_dax__bufferstack();
  }
}

static void debug_leave(void) {
    if (yy_flex_debug) {
        print_yy_stack("--LEAVE : ");
	print_dax__bufferstack();
    }
  yy_pop_state();
}

static void debug_set(int state, const char* statename) {
  BEGIN(state);
  if (yy_flex_debug) print_yy_stack("--SET(%s) : ",statename);
}
#endif


static void cleanup(void)
{
    if (dax__statenames) {
        free(dax__statenames);
	dax__statenames = NULL;
    }
    free(dax__bufferstack);
    dax__bufferstack = NULL;

    free(indexstack);
    indexstack = NULL;
}


static int fail(const char* fmt, ...)
{
    int chars_left, used;
    va_list ap; va_start(ap, fmt);
#ifdef FLEXML_yylineno
    used = sprintf(flexml_err_msg,
		   "Invalid XML (XML input line %d, state %d): ",
		   yylineno, YY_START);
#else
    used = sprintf(flexml_err_msg,
		   "Invalid XML (state %d): ",
		   YY_START);
#endif
    chars_left = flexml_max_err_msg_size - used - 1;
    vsnprintf(flexml_err_msg + used, chars_left, fmt, ap);
    va_end(ap);

#ifndef FLEXML_quiet_parser
    /* print directly to sdterr */
    fprintf(stderr, "%s\n", flexml_err_msg);
    flexml_err_msg[0] = '\0';
#endif

    cleanup();

    return 1;
}
