#! /usr/bin/python3
import os
import sys
import generator_utils as gen

template = """// @{generatedby}@
/* ///////////////////////// The MPI Bugs Initiative ////////////////////////

  Origin: @{origin}@

  Description: @{shortdesc}@
    @{longdesc}@

    Version of MPI: Conforms to MPI 1.1, does not require MPI 2 implementation

BEGIN_MPI_FEATURES
    P2P!basic: Yes
    P2P!nonblocking: Lacking
    P2P!persistent: Lacking
    COLL!basic: Lacking
    COLL!nonblocking: Lacking
    COLL!persistent: Lacking
    COLL!tools: Lacking
    RMA: Lacking
END_MPI_FEATURES

BEGIN_MBI_TESTS
  $ mpirun -np 3 ${EXE}
  | @{outcome}@
  | @{errormsg}@
END_MBI_TESTS
//////////////////////       End of MBI headers        /////////////////// */

#include <mpi.h>
#include <stdio.h>
#include <stdlib.h>

#define N 10

int main(int argc, char **argv) {
  int nprocs = -1 , rank = -1;

  MPI_Init(&argc, &argv);
  MPI_Comm_size(MPI_COMM_WORLD, &nprocs);
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);

  if (nprocs < 3)
    printf("MBI ERROR: This test needs at least 3 processes to produce a bug!\\n");

  MPI_Comm newcom = MPI_COMM_WORLD;
  MPI_Datatype type = MPI_INT;

  int src = 0; int dest = 0;
  int stag = 1; int rtag = 1;
  int buff_size = N;

  @{init1}@
  @{init2}@
  @{init3}@

  if (rank == 0) {
    src = 1;
    @{start1}@
    @{operation1}@
    @{fini1}@
  } else if (rank == 1) {
    src = 2; dest = 0;
    @{start2}@
    @{change_arg}@
    @{operation2}@
    @{fini2}@
  } else if (rank == 2) {
    dest = 1;
    @{start3}@
    @{operation3}@
    @{fini3}@
  }

  @{free1}@
  @{free2}@
  @{free3}@

  MPI_Finalize();
  printf("Rank %d finished normally\\n", rank);
  return 0;
}
"""

for s in gen.send:
    for r in gen.recv:
        for sr in gen.sendrecv:
            patterns = {}
            patterns = {'s': s, 'r': r, 'sr': sr}
            patterns['origin'] = "RTED"
            patterns['generatedby'] = f'DO NOT EDIT: this file was generated by {os.path.basename(sys.argv[0])}. DO NOT EDIT.'

            patterns['init1'] = gen.init[r]("1").replace("buf1=-1", "buf1[N]={-1}")
            patterns['start1'] = gen.start[r]("1")
            patterns['operation1'] = gen.operation[r]("1")
            patterns['fini1'] = gen.fini[r]("1")
            patterns['free1'] = gen.free[r]("1")

            patterns['init2'] = gen.init[sr]("2")
            patterns['start2'] = gen.start[sr]("2")
            patterns['operation2'] = gen.operation[sr]("2")
            patterns['fini2'] = gen.fini[sr]("2")
            patterns['free2'] = gen.free[sr]("2")

            patterns['init3'] = gen.init[s]("3").replace("buf3=rank", "buf3[N]={rank}")
            patterns['start3'] = gen.start[s]("3")
            patterns['operation3'] = gen.operation[s]("3")
            patterns['fini3'] = gen.fini[s]("3")
            patterns['free3'] = gen.free[s]("3")

            patterns['change_arg'] = ''

            # Generate a code with distinct buffer
            replace = patterns.copy()
            replace['origin'] = 'MBI'
            replace['shortdesc'] = 'Correct usage of Sendrecv function.'
            replace['longdesc'] = 'Correct usage of Sendrecv function.'
            replace['outcome'] = 'OK'
            replace['errormsg'] = 'OK'
            gen.make_file(template, f'InvalidParam_Buffer_{s}_{sr}_{r}_ok.c', replace)

            # Generate a code with non distinct buffer
            replace = patterns.copy()
            replace['shortdesc'] = 'Invalid buffer on Sendrecv function.'
            replace['longdesc'] = 'Invalid buffer on Sendrecv, the tow buffers must be distinct.'
            replace['outcome'] = 'ERROR: InvalidBuffer'
            replace['errormsg'] = '@{sr}@ at @{filename}@:@{line:MBIERROR}@ send buffer and recv buffer must be distinct.'
            replace['change_arg'] = gen.write[sr]("2")
            replace['operation2'] = gen.operation[sr]("2")  + " /* MBIERROR */"
            gen.make_file(template, f'InvalidParam_Buffer_{s}_{sr}_{r}_nok.c', replace)
