/* Copyright (c) 2010, 2012-2015. The SimGrid Team.
 * All rights reserved.                                                     */

/* This program is free software; you can redistribute it and/or modify it
 * under the terms of the license (GNU LGPL) which comes with this package. */

#include "src/instr/instr_private.h"
#include "simgrid/sg_config.h"

XBT_LOG_NEW_DEFAULT_SUBCATEGORY(instr_paje_header, instr, "Paje tracing event system (header)");

extern FILE *tracing_file;

static void TRACE_header_PajeDefineContainerType (int basic, int size)
{
  fprintf(tracing_file, "%%EventDef PajeDefineContainerType %d\n", simgrid::instr::PAJE_DefineContainerType);
  fprintf(tracing_file, "%%       Alias string\n");
  if (basic){
    fprintf(tracing_file, "%%       ContainerType string\n");
  }else{
    fprintf(tracing_file, "%%       Type string\n");
  }
  fprintf(tracing_file, "%%       Name string\n");
  fprintf(tracing_file, "%%EndEventDef\n");
}

static void TRACE_header_PajeDefineVariableType (int basic, int size)
{
  fprintf(tracing_file, "%%EventDef PajeDefineVariableType %d\n", simgrid::instr::PAJE_DefineVariableType);
  fprintf(tracing_file, "%%       Alias string\n");
  if (basic){
    fprintf(tracing_file, "%%       ContainerType string\n");
  }else{
    fprintf(tracing_file, "%%       Type string\n");
  }
  fprintf(tracing_file, "%%       Name string\n");
  fprintf(tracing_file, "%%       Color color\n");
  fprintf(tracing_file, "%%EndEventDef\n");
}

static void TRACE_header_PajeDefineStateType (int basic, int size)
{
  fprintf(tracing_file, "%%EventDef PajeDefineStateType %d\n", simgrid::instr::PAJE_DefineStateType);
  fprintf(tracing_file, "%%       Alias string\n");
  if (basic){
    fprintf(tracing_file, "%%       ContainerType string\n");
  }else{
    fprintf(tracing_file, "%%       Type string\n");
  }
  fprintf(tracing_file, "%%       Name string\n");
  fprintf(tracing_file, "%%EndEventDef\n");
}

static void TRACE_header_PajeDefineEventType (int basic, int size)
{
  fprintf(tracing_file, "%%EventDef PajeDefineEventType %d\n", simgrid::instr::PAJE_DefineEventType);
  fprintf(tracing_file, "%%       Alias string\n");
  if (basic){
    fprintf(tracing_file, "%%       ContainerType string\n");
  }else{
    fprintf(tracing_file, "%%       Type string\n");
  }
  fprintf(tracing_file, "%%       Name string\n");
  fprintf(tracing_file, "%%EndEventDef\n");
}

static void TRACE_header_PajeDefineLinkType (int basic, int size)
{
  fprintf(tracing_file, "%%EventDef PajeDefineLinkType %d\n", simgrid::instr::PAJE_DefineLinkType);
  fprintf(tracing_file, "%%       Alias string\n");
  if (basic){
    fprintf(tracing_file, "%%       ContainerType string\n");
    fprintf(tracing_file, "%%       SourceContainerType string\n");
    fprintf(tracing_file, "%%       DestContainerType string\n");
  }else{
    fprintf(tracing_file, "%%       Type string\n");
    fprintf(tracing_file, "%%       StartContainerType string\n");
    fprintf(tracing_file, "%%       EndContainerType string\n");
  }
  fprintf(tracing_file, "%%       Name string\n");
  fprintf(tracing_file, "%%EndEventDef\n");
}

static void TRACE_header_PajeDefineEntityValue (int basic, int size)
{
  fprintf(tracing_file, "%%EventDef PajeDefineEntityValue %d\n", simgrid::instr::PAJE_DefineEntityValue);
  fprintf(tracing_file, "%%       Alias string\n");
  if (basic){
    fprintf(tracing_file, "%%       EntityType string\n");
  }else{
    fprintf(tracing_file, "%%       Type string\n");
  }
  fprintf(tracing_file, "%%       Name string\n");
  fprintf(tracing_file, "%%       Color color\n");
  fprintf(tracing_file, "%%EndEventDef\n");
}

static void TRACE_header_PajeCreateContainer (int basic, int size)
{
  fprintf(tracing_file, "%%EventDef PajeCreateContainer %d\n", simgrid::instr::PAJE_CreateContainer);
  fprintf(tracing_file, "%%       Time date\n");
  fprintf(tracing_file, "%%       Alias string\n");
  fprintf(tracing_file, "%%       Type string\n");
  fprintf(tracing_file, "%%       Container string\n");
  fprintf(tracing_file, "%%       Name string\n");
  fprintf(tracing_file, "%%EndEventDef\n");
}

static void TRACE_header_PajeDestroyContainer (int basic, int size)
{
  fprintf(tracing_file, "%%EventDef PajeDestroyContainer %d\n", simgrid::instr::PAJE_DestroyContainer);
  fprintf(tracing_file, "%%       Time date\n");
  fprintf(tracing_file, "%%       Type string\n");
  fprintf(tracing_file, "%%       Name string\n");
  fprintf(tracing_file, "%%EndEventDef\n");
}

static void TRACE_header_PajeSetVariable (int basic, int size)
{
  fprintf(tracing_file, "%%EventDef PajeSetVariable %d\n", simgrid::instr::PAJE_SetVariable);
  fprintf(tracing_file, "%%       Time date\n");
  fprintf(tracing_file, "%%       Type string\n");
  fprintf(tracing_file, "%%       Container string\n");
  fprintf(tracing_file, "%%       Value double\n");
  fprintf(tracing_file, "%%EndEventDef\n");
}

static void TRACE_header_PajeAddVariable (int basic, int size)
{
  fprintf(tracing_file, "%%EventDef PajeAddVariable %d\n", simgrid::instr::PAJE_AddVariable);
  fprintf(tracing_file, "%%       Time date\n");
  fprintf(tracing_file, "%%       Type string\n");
  fprintf(tracing_file, "%%       Container string\n");
  fprintf(tracing_file, "%%       Value double\n");
  fprintf(tracing_file, "%%EndEventDef\n");
}

static void TRACE_header_PajeSubVariable (int basic, int size)
{
  fprintf(tracing_file, "%%EventDef PajeSubVariable %d\n", simgrid::instr::PAJE_SubVariable);
  fprintf(tracing_file, "%%       Time date\n");
  fprintf(tracing_file, "%%       Type string\n");
  fprintf(tracing_file, "%%       Container string\n");
  fprintf(tracing_file, "%%       Value double\n");
  fprintf(tracing_file, "%%EndEventDef\n");
}


static void TRACE_header_PajeSetState (int basic, int size)
{
  fprintf(tracing_file, "%%EventDef PajeSetState %d\n", simgrid::instr::PAJE_SetState);
  fprintf(tracing_file, "%%       Time date\n");
  fprintf(tracing_file, "%%       Type string\n");
  fprintf(tracing_file, "%%       Container string\n");
  fprintf(tracing_file, "%%       Value string\n");
  fprintf(tracing_file, "%%EndEventDef\n");
}

static void TRACE_header_PajePushState (int basic, int size)
{
  fprintf(tracing_file, "%%EventDef PajePushState %d\n", simgrid::instr::PAJE_PushState);
  fprintf(tracing_file, "%%       Time date\n");
  fprintf(tracing_file, "%%       Type string\n");
  fprintf(tracing_file, "%%       Container string\n");
  fprintf(tracing_file, "%%       Value string\n");
  if (size) fprintf(tracing_file, "%%       Size int\n");
#if HAVE_SMPI
  if (xbt_cfg_get_boolean("smpi/trace-call-location")) {
    /**
     * paje currently (May 2016) uses "Filename" and "Linenumber" as
     * reserved words. We cannot use them...
     */
    fprintf(tracing_file, "%%       Fname string\n");
    fprintf(tracing_file, "%%       Lnumber int\n");
  }
#endif
  fprintf(tracing_file, "%%EndEventDef\n");
}

static void TRACE_header_PajePopState (int basic, int size)
{
  fprintf(tracing_file, "%%EventDef PajePopState %d\n", simgrid::instr::PAJE_PopState);
  fprintf(tracing_file, "%%       Time date\n");
  fprintf(tracing_file, "%%       Type string\n");
  fprintf(tracing_file, "%%       Container string\n");
  fprintf(tracing_file, "%%EndEventDef\n");
}

static void TRACE_header_PajeResetState (int basic, int size)
{
  if (basic) return;

  fprintf(tracing_file, "%%EventDef PajeResetState %d\n", simgrid::instr::PAJE_ResetState);
  fprintf(tracing_file, "%%       Time date\n");
  fprintf(tracing_file, "%%       Type string\n");
  fprintf(tracing_file, "%%       Container string\n");
  fprintf(tracing_file, "%%EndEventDef\n");
}

static void TRACE_header_PajeStartLink (int basic, int size)
{
  fprintf(tracing_file, "%%EventDef PajeStartLink %d\n", simgrid::instr::PAJE_StartLink);
  fprintf(tracing_file, "%%       Time date\n");
  fprintf(tracing_file, "%%       Type string\n");
  fprintf(tracing_file, "%%       Container string\n");
  fprintf(tracing_file, "%%       Value string\n");
  if (basic){
    fprintf(tracing_file, "%%       SourceContainer string\n");
  }else{
    fprintf(tracing_file, "%%       StartContainer string\n");
  }
  fprintf(tracing_file, "%%       Key string\n");
  if (size) fprintf(tracing_file, "%%       Size int\n");
  fprintf(tracing_file, "%%EndEventDef\n");
}

static void TRACE_header_PajeEndLink (int basic, int size)
{
  fprintf(tracing_file, "%%EventDef PajeEndLink %d\n", simgrid::instr::PAJE_EndLink);
  fprintf(tracing_file, "%%       Time date\n");
  fprintf(tracing_file, "%%       Type string\n");
  fprintf(tracing_file, "%%       Container string\n");
  fprintf(tracing_file, "%%       Value string\n");
  if (basic){
    fprintf(tracing_file, "%%       DestContainer string\n");
  }else{
    fprintf(tracing_file, "%%       EndContainer string\n");
  }
  fprintf(tracing_file, "%%       Key string\n");
  fprintf(tracing_file, "%%EndEventDef\n");
}

static void TRACE_header_PajeNewEvent (int basic, int size)
{
  fprintf(tracing_file, "%%EventDef PajeNewEvent %d\n", simgrid::instr::PAJE_NewEvent);
  fprintf(tracing_file, "%%       Time date\n");
  fprintf(tracing_file, "%%       Type string\n");
  fprintf(tracing_file, "%%       Container string\n");
  fprintf(tracing_file, "%%       Value string\n");
  fprintf(tracing_file, "%%EndEventDef\n");
}

void TRACE_header(int basic, int size)
{
  XBT_DEBUG ("Define paje header");
  TRACE_header_PajeDefineContainerType (basic, size);
  TRACE_header_PajeDefineVariableType (basic, size);
  TRACE_header_PajeDefineStateType (basic, size);
  TRACE_header_PajeDefineEventType (basic, size);
  TRACE_header_PajeDefineLinkType (basic, size);
  TRACE_header_PajeDefineEntityValue (basic, size);
  TRACE_header_PajeCreateContainer (basic, size);
  TRACE_header_PajeDestroyContainer (basic, size);
  TRACE_header_PajeSetVariable (basic, size);
  TRACE_header_PajeAddVariable (basic, size);
  TRACE_header_PajeSubVariable (basic, size);
  TRACE_header_PajeSetState (basic, size);
  TRACE_header_PajePushState (basic, size);
  TRACE_header_PajePopState (basic, size);
  TRACE_header_PajeResetState (basic, size);
  TRACE_header_PajeStartLink (basic, size);
  TRACE_header_PajeEndLink (basic, size);
  TRACE_header_PajeNewEvent (basic, size);
}
