/**********************************************************************/
/* File generated by src/simix/simcalls.py from src/simix/simcalls.in */
/*                                                                    */
/*                    DO NOT EVER CHANGE THIS FILE                    */
/*                                                                    */
/* change simcalls specification in src/simix/simcalls.in             */
/**********************************************************************/

/*
 * Note that the name comes from http://en.wikipedia.org/wiki/Popping
 * Indeed, the control flow is doing a strange dance in there.
 *
 * That's not about http://en.wikipedia.org/wiki/Poop, despite the odor :)
 */

#include <xbt/base.h>
#include "smx_private.h"
#if HAVE_MC
#include "src/mc/mc_forward.hpp"
#endif

XBT_LOG_EXTERNAL_DEFAULT_CATEGORY(simix_popping);

/** @brief Simcalls' names (generated from src/simix/simcalls.in) */
const char* simcall_names[] = {
   "SIMCALL_NONE",  "SIMCALL_VM_SUSPEND",
  "SIMCALL_VM_RESUME",
  "SIMCALL_VM_SHUTDOWN",
  "SIMCALL_VM_SAVE",
  "SIMCALL_VM_RESTORE",
  "SIMCALL_PROCESS_CREATE",
  "SIMCALL_PROCESS_KILL",
  "SIMCALL_PROCESS_KILLALL",
  "SIMCALL_PROCESS_CLEANUP",
  "SIMCALL_PROCESS_SUSPEND",
  "SIMCALL_PROCESS_RESUME",
  "SIMCALL_PROCESS_SET_HOST",
  "SIMCALL_PROCESS_IS_SUSPENDED",
  "SIMCALL_PROCESS_JOIN",
  "SIMCALL_PROCESS_SLEEP",
  "SIMCALL_EXECUTION_START",
  "SIMCALL_EXECUTION_PARALLEL_START",
  "SIMCALL_EXECUTION_DESTROY",
  "SIMCALL_EXECUTION_CANCEL",
  "SIMCALL_EXECUTION_GET_REMAINS",
  "SIMCALL_EXECUTION_GET_STATE",
  "SIMCALL_EXECUTION_SET_PRIORITY",
  "SIMCALL_EXECUTION_SET_BOUND",
  "SIMCALL_EXECUTION_SET_AFFINITY",
  "SIMCALL_EXECUTION_WAIT",
  "SIMCALL_PROCESS_ON_EXIT",
  "SIMCALL_PROCESS_AUTO_RESTART_SET",
  "SIMCALL_PROCESS_RESTART",
  "SIMCALL_MBOX_CREATE",
  "SIMCALL_MBOX_GET_HEAD",
  "SIMCALL_MBOX_SET_RECEIVER",
  "SIMCALL_MBOX_GET_RECEIVER",
  "SIMCALL_COMM_IPROBE",
  "SIMCALL_COMM_SEND",
  "SIMCALL_COMM_ISEND",
  "SIMCALL_COMM_RECV",
  "SIMCALL_COMM_IRECV",
  "SIMCALL_COMM_CANCEL",
  "SIMCALL_COMM_WAITANY",
  "SIMCALL_COMM_WAIT",
  "SIMCALL_COMM_TEST",
  "SIMCALL_COMM_TESTANY",
  "SIMCALL_COMM_GET_REMAINS",
  "SIMCALL_COMM_GET_STATE",
  "SIMCALL_COMM_GET_SRC_DATA",
  "SIMCALL_COMM_GET_DST_DATA",
  "SIMCALL_COMM_GET_SRC_PROC",
  "SIMCALL_COMM_GET_DST_PROC",
  "SIMCALL_MUTEX_INIT",
  "SIMCALL_MUTEX_LOCK",
  "SIMCALL_MUTEX_TRYLOCK",
  "SIMCALL_MUTEX_UNLOCK",
  "SIMCALL_COND_INIT",
  "SIMCALL_COND_SIGNAL",
  "SIMCALL_COND_WAIT",
  "SIMCALL_COND_WAIT_TIMEOUT",
  "SIMCALL_COND_BROADCAST",
  "SIMCALL_SEM_INIT",
  "SIMCALL_SEM_RELEASE",
  "SIMCALL_SEM_WOULD_BLOCK",
  "SIMCALL_SEM_ACQUIRE",
  "SIMCALL_SEM_ACQUIRE_TIMEOUT",
  "SIMCALL_SEM_GET_CAPACITY",
  "SIMCALL_FILE_READ",
  "SIMCALL_FILE_WRITE",
  "SIMCALL_FILE_OPEN",
  "SIMCALL_FILE_CLOSE",
  "SIMCALL_FILE_UNLINK",
  "SIMCALL_FILE_GET_SIZE",
  "SIMCALL_FILE_TELL",
  "SIMCALL_FILE_SEEK",
  "SIMCALL_FILE_GET_INFO",
  "SIMCALL_FILE_MOVE",
  "SIMCALL_STORAGE_GET_FREE_SIZE",
  "SIMCALL_STORAGE_GET_USED_SIZE",
  "SIMCALL_STORAGE_GET_PROPERTIES",
  "SIMCALL_STORAGE_GET_CONTENT",
  "SIMCALL_ASR_GET_PROPERTIES",
  "SIMCALL_MC_RANDOM",
  "SIMCALL_SET_CATEGORY",
  "SIMCALL_RUN_KERNEL",};

/**
 * @brief (in kernel mode) unpack the simcall and activate the handler
 * 
 * This function is generated from src/simix/simcalls.in
 */
void SIMIX_simcall_handle(smx_simcall_t simcall, int value) {
  XBT_DEBUG("Handling simcall %p: %s", simcall, SIMIX_simcall_name(simcall->call));
  SIMCALL_SET_MC_VALUE(simcall, value);
  if (simcall->issuer->context->iwannadie && simcall->call != SIMCALL_PROCESS_CLEANUP)
    return;
  switch (simcall->call) {
case SIMCALL_VM_SUSPEND:
       simcall_HANDLER_vm_suspend(simcall , (sg_host_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_VM_RESUME:
       simcall_HANDLER_vm_resume(simcall , (sg_host_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_VM_SHUTDOWN:
       simcall_HANDLER_vm_shutdown(simcall , (sg_host_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_VM_SAVE:
       simcall_HANDLER_vm_save(simcall , (sg_host_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_VM_RESTORE:
       simcall_HANDLER_vm_restore(simcall , (sg_host_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_CREATE:
      simcall->result.dp = simcall_HANDLER_process_create(simcall ,  simcall->args[0].cc, (xbt_main_func_t) simcall->args[1].fp,  simcall->args[2].dp,  simcall->args[3].cc,  simcall->args[4].d,  simcall->args[5].i, (char**) simcall->args[6].dp, (xbt_dict_t) simcall->args[7].dp,  simcall->args[8].i);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_KILL:
       simcall_HANDLER_process_kill(simcall , (smx_process_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_KILLALL:
       simcall_HANDLER_process_killall(simcall ,  simcall->args[0].i);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_CLEANUP:
       SIMIX_process_cleanup((smx_process_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_SUSPEND:
       simcall_HANDLER_process_suspend(simcall , (smx_process_t) simcall->args[0].dp);
       break;  

case SIMCALL_PROCESS_RESUME:
       simcall_HANDLER_process_resume(simcall , (smx_process_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_SET_HOST:
       simcall_HANDLER_process_set_host(simcall , (smx_process_t) simcall->args[0].dp, (sg_host_t) simcall->args[1].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_IS_SUSPENDED:
      simcall->result.i = SIMIX_process_is_suspended((smx_process_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_JOIN:
       simcall_HANDLER_process_join(simcall , (smx_process_t) simcall->args[0].dp,  simcall->args[1].d);
       break;  

case SIMCALL_PROCESS_SLEEP:
       simcall_HANDLER_process_sleep(simcall ,  simcall->args[0].d);
       break;  

case SIMCALL_EXECUTION_START:
      simcall->result.dp = simcall_HANDLER_execution_start(simcall ,  simcall->args[0].cc,  simcall->args[1].d,  simcall->args[2].d,  simcall->args[3].d,  simcall->args[4].ul);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_EXECUTION_PARALLEL_START:
      simcall->result.dp = SIMIX_execution_parallel_start( simcall->args[0].cc, simcall->args[1].i,(sg_host_t*) simcall->args[2].dp,(double*) simcall->args[3].dp,(double*) simcall->args[4].dp, simcall->args[5].d, simcall->args[6].d);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_EXECUTION_DESTROY:
       SIMIX_execution_destroy((smx_synchro_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_EXECUTION_CANCEL:
       SIMIX_execution_cancel((smx_synchro_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_EXECUTION_GET_REMAINS:
      simcall->result.d = SIMIX_execution_get_remains((smx_synchro_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_EXECUTION_GET_STATE:
      simcall->result.i = SIMIX_execution_get_state((smx_synchro_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_EXECUTION_SET_PRIORITY:
       SIMIX_execution_set_priority((smx_synchro_t) simcall->args[0].dp, simcall->args[1].d);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_EXECUTION_SET_BOUND:
       SIMIX_execution_set_bound((smx_synchro_t) simcall->args[0].dp, simcall->args[1].d);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_EXECUTION_SET_AFFINITY:
       SIMIX_execution_set_affinity((smx_synchro_t) simcall->args[0].dp,(sg_host_t) simcall->args[1].dp, simcall->args[2].ul);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_EXECUTION_WAIT:
       simcall_HANDLER_execution_wait(simcall , (smx_synchro_t) simcall->args[0].dp);
       break;  

case SIMCALL_PROCESS_ON_EXIT:
       SIMIX_process_on_exit((smx_process_t) simcall->args[0].dp,(int_f_pvoid_pvoid_t) simcall->args[1].fp, simcall->args[2].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_AUTO_RESTART_SET:
       SIMIX_process_auto_restart_set((smx_process_t) simcall->args[0].dp, simcall->args[1].i);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_PROCESS_RESTART:
      simcall->result.dp = simcall_HANDLER_process_restart(simcall , (smx_process_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_MBOX_CREATE:
      simcall->result.dp = SIMIX_mbox_create( simcall->args[0].cc);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_MBOX_GET_HEAD:
      simcall->result.dp = SIMIX_mbox_get_head((smx_mailbox_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_MBOX_SET_RECEIVER:
       SIMIX_mbox_set_receiver((smx_mailbox_t) simcall->args[0].dp,(smx_process_t) simcall->args[1].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_MBOX_GET_RECEIVER:
      simcall->result.dp = SIMIX_mbox_get_receiver((smx_mailbox_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_COMM_IPROBE:
      simcall->result.dp = simcall_HANDLER_comm_iprobe(simcall , (smx_mailbox_t) simcall->args[0].dp,  simcall->args[1].i,  simcall->args[2].i,  simcall->args[3].i, (simix_match_func_t) simcall->args[4].fp,  simcall->args[5].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_COMM_SEND:
       simcall_HANDLER_comm_send(simcall , (smx_process_t) simcall->args[0].dp, (smx_mailbox_t) simcall->args[1].dp,  simcall->args[2].d,  simcall->args[3].d,  simcall->args[4].dp,  simcall->args[5].sz, (simix_match_func_t) simcall->args[6].fp, (simix_copy_data_func_t) simcall->args[7].fp,  simcall->args[8].dp,  simcall->args[9].d);
       break;  

case SIMCALL_COMM_ISEND:
      simcall->result.dp = simcall_HANDLER_comm_isend(simcall , (smx_process_t) simcall->args[0].dp, (smx_mailbox_t) simcall->args[1].dp,  simcall->args[2].d,  simcall->args[3].d,  simcall->args[4].dp,  simcall->args[5].sz, (simix_match_func_t) simcall->args[6].fp, (simix_clean_func_t) simcall->args[7].fp, (simix_copy_data_func_t) simcall->args[8].fp,  simcall->args[9].dp,  simcall->args[10].i);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_COMM_RECV:
       simcall_HANDLER_comm_recv(simcall , (smx_process_t) simcall->args[0].dp, (smx_mailbox_t) simcall->args[1].dp,  simcall->args[2].dp, (size_t*) simcall->args[3].dp, (simix_match_func_t) simcall->args[4].fp, (simix_copy_data_func_t) simcall->args[5].fp,  simcall->args[6].dp,  simcall->args[7].d,  simcall->args[8].d);
       break;  

case SIMCALL_COMM_IRECV:
      simcall->result.dp = simcall_HANDLER_comm_irecv(simcall , (smx_process_t) simcall->args[0].dp, (smx_mailbox_t) simcall->args[1].dp,  simcall->args[2].dp, (size_t*) simcall->args[3].dp, (simix_match_func_t) simcall->args[4].fp, (simix_copy_data_func_t) simcall->args[5].fp,  simcall->args[6].dp,  simcall->args[7].d);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_COMM_CANCEL:
       SIMIX_comm_cancel((smx_synchro_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_COMM_WAITANY:
       simcall_HANDLER_comm_waitany(simcall , (xbt_dynar_t) simcall->args[0].dp);
       break;  

case SIMCALL_COMM_WAIT:
       simcall_HANDLER_comm_wait(simcall , (smx_synchro_t) simcall->args[0].dp,  simcall->args[1].d);
       break;  

case SIMCALL_COMM_TEST:
       simcall_HANDLER_comm_test(simcall , (smx_synchro_t) simcall->args[0].dp);
       break;  

case SIMCALL_COMM_TESTANY:
       simcall_HANDLER_comm_testany(simcall , (xbt_dynar_t) simcall->args[0].dp);
       break;  

case SIMCALL_COMM_GET_REMAINS:
      simcall->result.d = SIMIX_comm_get_remains((smx_synchro_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_COMM_GET_STATE:
      simcall->result.i = SIMIX_comm_get_state((smx_synchro_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_COMM_GET_SRC_DATA:
      simcall->result.dp = SIMIX_comm_get_src_data((smx_synchro_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_COMM_GET_DST_DATA:
      simcall->result.dp = SIMIX_comm_get_dst_data((smx_synchro_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_COMM_GET_SRC_PROC:
      simcall->result.dp = SIMIX_comm_get_src_proc((smx_synchro_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_COMM_GET_DST_PROC:
      simcall->result.dp = SIMIX_comm_get_dst_proc((smx_synchro_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_MUTEX_INIT:
      simcall->result.dp = simcall_HANDLER_mutex_init(simcall );
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_MUTEX_LOCK:
       simcall_HANDLER_mutex_lock(simcall , (smx_mutex_t) simcall->args[0].dp);
       break;  

case SIMCALL_MUTEX_TRYLOCK:
      simcall->result.i = simcall_HANDLER_mutex_trylock(simcall , (smx_mutex_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_MUTEX_UNLOCK:
       simcall_HANDLER_mutex_unlock(simcall , (smx_mutex_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_COND_INIT:
      simcall->result.dp = SIMIX_cond_init();
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_COND_SIGNAL:
       SIMIX_cond_signal((smx_cond_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_COND_WAIT:
       simcall_HANDLER_cond_wait(simcall , (smx_cond_t) simcall->args[0].dp, (smx_mutex_t) simcall->args[1].dp);
       break;  

case SIMCALL_COND_WAIT_TIMEOUT:
       simcall_HANDLER_cond_wait_timeout(simcall , (smx_cond_t) simcall->args[0].dp, (smx_mutex_t) simcall->args[1].dp,  simcall->args[2].d);
       break;  

case SIMCALL_COND_BROADCAST:
       SIMIX_cond_broadcast((smx_cond_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_SEM_INIT:
      simcall->result.dp = SIMIX_sem_init( simcall->args[0].ui);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_SEM_RELEASE:
       simcall_HANDLER_sem_release(simcall , (smx_sem_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_SEM_WOULD_BLOCK:
      simcall->result.i = simcall_HANDLER_sem_would_block(simcall , (smx_sem_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_SEM_ACQUIRE:
       simcall_HANDLER_sem_acquire(simcall , (smx_sem_t) simcall->args[0].dp);
       break;  

case SIMCALL_SEM_ACQUIRE_TIMEOUT:
       simcall_HANDLER_sem_acquire_timeout(simcall , (smx_sem_t) simcall->args[0].dp,  simcall->args[1].d);
       break;  

case SIMCALL_SEM_GET_CAPACITY:
      simcall->result.i = simcall_HANDLER_sem_get_capacity(simcall , (smx_sem_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_FILE_READ:
       simcall_HANDLER_file_read(simcall , (smx_file_t) simcall->args[0].dp,  simcall->args[1].sgsz, (sg_host_t) simcall->args[2].dp);
       break;  

case SIMCALL_FILE_WRITE:
       simcall_HANDLER_file_write(simcall , (smx_file_t) simcall->args[0].dp,  simcall->args[1].sgsz, (sg_host_t) simcall->args[2].dp);
       break;  

case SIMCALL_FILE_OPEN:
       simcall_HANDLER_file_open(simcall ,  simcall->args[0].cc, (sg_host_t) simcall->args[1].dp);
       break;  

case SIMCALL_FILE_CLOSE:
       simcall_HANDLER_file_close(simcall , (smx_file_t) simcall->args[0].dp, (sg_host_t) simcall->args[1].dp);
       break;  

case SIMCALL_FILE_UNLINK:
      simcall->result.i = SIMIX_file_unlink((smx_file_t) simcall->args[0].dp,(sg_host_t) simcall->args[1].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_FILE_GET_SIZE:
      simcall->result.sgsz = simcall_HANDLER_file_get_size(simcall , (smx_file_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_FILE_TELL:
      simcall->result.sgsz = simcall_HANDLER_file_tell(simcall , (smx_file_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_FILE_SEEK:
      simcall->result.i = simcall_HANDLER_file_seek(simcall , (smx_file_t) simcall->args[0].dp,  simcall->args[1].sgoff,  simcall->args[2].i);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_FILE_GET_INFO:
      simcall->result.dp = simcall_HANDLER_file_get_info(simcall , (smx_file_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_FILE_MOVE:
      simcall->result.i = simcall_HANDLER_file_move(simcall , (smx_file_t) simcall->args[0].dp,  simcall->args[1].cc);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_STORAGE_GET_FREE_SIZE:
      simcall->result.sgsz = simcall_HANDLER_storage_get_free_size(simcall , (smx_storage_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_STORAGE_GET_USED_SIZE:
      simcall->result.sgsz = simcall_HANDLER_storage_get_used_size(simcall , (smx_storage_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_STORAGE_GET_PROPERTIES:
      simcall->result.dp = SIMIX_storage_get_properties((smx_storage_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_STORAGE_GET_CONTENT:
      simcall->result.dp = SIMIX_storage_get_content((smx_storage_t) simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_ASR_GET_PROPERTIES:
      simcall->result.dp = simcall_HANDLER_asr_get_properties(simcall ,  simcall->args[0].cc);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_MC_RANDOM:
      simcall->result.i = simcall_HANDLER_mc_random(simcall ,  simcall->args[0].i,  simcall->args[1].i);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_SET_CATEGORY:
       SIMIX_set_category((smx_synchro_t) simcall->args[0].dp, simcall->args[1].cc);
      SIMIX_simcall_answer(simcall);
      break;  

case SIMCALL_RUN_KERNEL:
       SIMIX_run_kernel( simcall->args[0].dp);
      SIMIX_simcall_answer(simcall);
      break;  
    case NUM_SIMCALLS:
      break;
    case SIMCALL_NONE:
      THROWF(arg_error,0,"Asked to do the noop syscall on %s@%s",
          SIMIX_process_get_name(simcall->issuer),
          sg_host_get_name(SIMIX_process_get_host(simcall->issuer))
          );
      break;

  }
}
