/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.11
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */

#define SWIGJAVA
#define SWIG_DIRECTORS


#ifdef __cplusplus
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigMovePointer {
    T *ptr;
    SwigMovePointer(T *p) : ptr(p) { }
    ~SwigMovePointer() { delete ptr; }
    SwigMovePointer& operator=(SwigMovePointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigMovePointer tmp(new T(t)); pointer = tmp; return *this; }
  operator T&() const { return *pointer.ptr; }
  T *operator&() { return pointer.ptr; }
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#  ifndef GCC_HASCLASSVISIBILITY
#    define GCC_HASCLASSVISIBILITY
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif



/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTEL_COMPILER)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" }
  };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else

/* -----------------------------------------------------------------------------
 * director.swg
 *
 * This file contains support for director classes that proxy
 * method calls from C++ to Java extensions.
 * ----------------------------------------------------------------------------- */

#ifdef __cplusplus

#if defined(DEBUG_DIRECTOR_OWNED)
#include <iostream>
#endif

namespace Swig {
  /* Java object wrapper */
  class JObjectWrapper {
  public:
    JObjectWrapper() : jthis_(NULL), weak_global_(true) {
    }

    ~JObjectWrapper() {
      jthis_ = NULL;
      weak_global_ = true;
    }

    bool set(JNIEnv *jenv, jobject jobj, bool mem_own, bool weak_global) {
      if (!jthis_) {
        weak_global_ = weak_global || !mem_own; // hold as weak global if explicitly requested or not owned
        if (jobj)
          jthis_ = weak_global_ ? jenv->NewWeakGlobalRef(jobj) : jenv->NewGlobalRef(jobj);
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> " << jthis_ << std::endl;
#endif
        return true;
      } else {
#if defined(DEBUG_DIRECTOR_OWNED)
        std::cout << "JObjectWrapper::set(" << jobj << ", " << (weak_global ? "weak_global" : "global_ref") << ") -> already set" << std::endl;
#endif
        return false;
      }
    }

    jobject get(JNIEnv *jenv) const {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::get(";
      if (jthis_)
        std::cout << jthis_;
      else
        std::cout << "null";
      std::cout << ") -> return new local ref" << std::endl;
#endif
      return (jthis_ ? jenv->NewLocalRef(jthis_) : jthis_);
    }

    void release(JNIEnv *jenv) {
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "JObjectWrapper::release(" << jthis_ << "): " << (weak_global_ ? "weak global ref" : "global ref") << std::endl;
#endif
      if (jthis_) {
        if (weak_global_) {
          if (jenv->IsSameObject(jthis_, NULL) == JNI_FALSE)
            jenv->DeleteWeakGlobalRef((jweak)jthis_);
        } else
          jenv->DeleteGlobalRef(jthis_);
      }

      jthis_ = NULL;
      weak_global_ = true;
    }

    /* Only call peek if you know what you are doing wrt to weak/global references */
    jobject peek() {
      return jthis_;
    }

    /* Java proxy releases ownership of C++ object, C++ object is now
       responsible for destruction (creates NewGlobalRef to pin Java
       proxy) */
    void java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      if (take_or_release) {  /* Java takes ownership of C++ object's lifetime. */
        if (!weak_global_) {
          jenv->DeleteGlobalRef(jthis_);
          jthis_ = jenv->NewWeakGlobalRef(jself);
          weak_global_ = true;
        }
      } else { /* Java releases ownership of C++ object's lifetime */
        if (weak_global_) {
          jenv->DeleteWeakGlobalRef((jweak)jthis_);
          jthis_ = jenv->NewGlobalRef(jself);
          weak_global_ = false;
        }
      }
    }

  private:
    /* pointer to Java object */
    jobject jthis_;
    /* Local or global reference flag */
    bool weak_global_;
  };

  /* director base class */
  class Director {
    /* pointer to Java virtual machine */
    JavaVM *swig_jvm_;

  protected:
#if defined (_MSC_VER) && (_MSC_VER<1300)
    class JNIEnvWrapper;
    friend class JNIEnvWrapper;
#endif
    /* Utility class for managing the JNI environment */
    class JNIEnvWrapper {
      const Director *director_;
      JNIEnv *jenv_;
      int env_status;
    public:
      JNIEnvWrapper(const Director *director) : director_(director), jenv_(0), env_status(0) {
#if defined(__ANDROID__)
        JNIEnv **jenv = &jenv_;
#else
        void **jenv = (void **)&jenv_;
#endif
        env_status = director_->swig_jvm_->GetEnv((void **)&jenv_, JNI_VERSION_1_2);
#if defined(SWIG_JAVA_ATTACH_CURRENT_THREAD_AS_DAEMON)
        // Attach a daemon thread to the JVM. Useful when the JVM should not wait for 
        // the thread to exit upon shutdown. Only for jdk-1.4 and later.
        director_->swig_jvm_->AttachCurrentThreadAsDaemon(jenv, NULL);
#else
        director_->swig_jvm_->AttachCurrentThread(jenv, NULL);
#endif
      }
      ~JNIEnvWrapper() {
#if !defined(SWIG_JAVA_NO_DETACH_CURRENT_THREAD)
        // Some JVMs, eg jdk-1.4.2 and lower on Solaris have a bug and crash with the DetachCurrentThread call.
        // However, without this call, the JVM hangs on exit when the thread was not created by the JVM and creates a memory leak.
        if (env_status == JNI_EDETACHED)
          director_->swig_jvm_->DetachCurrentThread();
#endif
      }
      JNIEnv *getJNIEnv() const {
        return jenv_;
      }
    };

    /* Java object wrapper */
    JObjectWrapper swig_self_;

    /* Disconnect director from Java object */
    void swig_disconnect_director_self(const char *disconn_method) {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      jobject jobj = swig_self_.get(jenv);
#if defined(DEBUG_DIRECTOR_OWNED)
      std::cout << "Swig::Director::disconnect_director_self(" << jobj << ")" << std::endl;
#endif
      if (jobj && jenv->IsSameObject(jobj, NULL) == JNI_FALSE) {
        jmethodID disconn_meth = jenv->GetMethodID(jenv->GetObjectClass(jobj), disconn_method, "()V");
        if (disconn_meth) {
#if defined(DEBUG_DIRECTOR_OWNED)
          std::cout << "Swig::Director::disconnect_director_self upcall to " << disconn_method << std::endl;
#endif
          jenv->CallVoidMethod(jobj, disconn_meth);
        }
      }
      jenv->DeleteLocalRef(jobj);
    }

  public:
    Director(JNIEnv *jenv) : swig_jvm_((JavaVM *) NULL), swig_self_() {
      /* Acquire the Java VM pointer */
      jenv->GetJavaVM(&swig_jvm_);
    }

    virtual ~Director() {
      JNIEnvWrapper jnienv(this) ;
      JNIEnv *jenv = jnienv.getJNIEnv() ;
      swig_self_.release(jenv);
    }

    bool swig_set_self(JNIEnv *jenv, jobject jself, bool mem_own, bool weak_global) {
      return swig_self_.set(jenv, jself, mem_own, weak_global);
    }

    jobject swig_get_self(JNIEnv *jenv) const {
      return swig_self_.get(jenv);
    }

    // Change C++ object's ownership, relative to Java
    void swig_java_change_ownership(JNIEnv *jenv, jobject jself, bool take_or_release) {
      swig_self_.java_change_ownership(jenv, jself, take_or_release);
    }
  };
}

#endif /* __cplusplus */


namespace Swig {
  namespace {
    jclass jclass_SurfJNI = NULL;
    jmethodID director_methids[33];
  }
}

#if defined(SWIG_NOINCLUDE) || defined(SWIG_NOARRAYS)


static int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input);
static void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input);
static jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz);


static int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input);
static void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input);
static jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz);


static int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input);
static void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input);
static jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz);


static int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input);
static void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input);
static jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz);


static int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input);
static void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input);
static jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz);


static int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input);
static void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input);
static jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz);


static int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input);
static void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz);


static int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input);
static void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input);
static jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz);


static int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input);
static void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz);


static int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input);
static void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input);
static jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz);


static int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input);
static void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input);
static jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz);


static int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input);
static void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input);
static jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz);


#else


/* bool[] support */
static int SWIG_JavaArrayInBool (JNIEnv *jenv, jboolean **jarr, bool **carr, jbooleanArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetBooleanArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new bool[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = ((*jarr)[i] != 0);
  return 1;
}

static void SWIG_JavaArrayArgoutBool (JNIEnv *jenv, jboolean *jarr, bool *carr, jbooleanArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jboolean)carr[i];
  jenv->ReleaseBooleanArrayElements(input, jarr, 0);
}

static jbooleanArray SWIG_JavaArrayOutBool (JNIEnv *jenv, bool *result, jsize sz) {
  jboolean *arr;
  int i;
  jbooleanArray jresult = jenv->NewBooleanArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetBooleanArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jboolean)result[i];
  jenv->ReleaseBooleanArrayElements(jresult, arr, 0);
  return jresult;
}


/* signed char[] support */
static int SWIG_JavaArrayInSchar (JNIEnv *jenv, jbyte **jarr, signed char **carr, jbyteArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetByteArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new signed char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (signed char)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutSchar (JNIEnv *jenv, jbyte *jarr, signed char *carr, jbyteArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jbyte)carr[i];
  jenv->ReleaseByteArrayElements(input, jarr, 0);
}

static jbyteArray SWIG_JavaArrayOutSchar (JNIEnv *jenv, signed char *result, jsize sz) {
  jbyte *arr;
  int i;
  jbyteArray jresult = jenv->NewByteArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetByteArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jbyte)result[i];
  jenv->ReleaseByteArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned char[] support */
static int SWIG_JavaArrayInUchar (JNIEnv *jenv, jshort **jarr, unsigned char **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned char[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned char)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUchar (JNIEnv *jenv, jshort *jarr, unsigned char *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

static jshortArray SWIG_JavaArrayOutUchar (JNIEnv *jenv, unsigned char *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* short[] support */
static int SWIG_JavaArrayInShort (JNIEnv *jenv, jshort **jarr, short **carr, jshortArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetShortArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (short)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutShort (JNIEnv *jenv, jshort *jarr, short *carr, jshortArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jshort)carr[i];
  jenv->ReleaseShortArrayElements(input, jarr, 0);
}

static jshortArray SWIG_JavaArrayOutShort (JNIEnv *jenv, short *result, jsize sz) {
  jshort *arr;
  int i;
  jshortArray jresult = jenv->NewShortArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetShortArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jshort)result[i];
  jenv->ReleaseShortArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned short[] support */
static int SWIG_JavaArrayInUshort (JNIEnv *jenv, jint **jarr, unsigned short **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned short[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned short)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUshort (JNIEnv *jenv, jint *jarr, unsigned short *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutUshort (JNIEnv *jenv, unsigned short *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* int[] support */
static int SWIG_JavaArrayInInt (JNIEnv *jenv, jint **jarr, int **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (int)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutInt (JNIEnv *jenv, jint *jarr, int *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutInt (JNIEnv *jenv, int *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned int[] support */
static int SWIG_JavaArrayInUint (JNIEnv *jenv, jlong **jarr, unsigned int **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned int[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned int)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUint (JNIEnv *jenv, jlong *jarr, unsigned int *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutUint (JNIEnv *jenv, unsigned int *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* long[] support */
static int SWIG_JavaArrayInLong (JNIEnv *jenv, jint **jarr, long **carr, jintArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetIntArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (long)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutLong (JNIEnv *jenv, jint *jarr, long *carr, jintArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jint)carr[i];
  jenv->ReleaseIntArrayElements(input, jarr, 0);
}

static jintArray SWIG_JavaArrayOutLong (JNIEnv *jenv, long *result, jsize sz) {
  jint *arr;
  int i;
  jintArray jresult = jenv->NewIntArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetIntArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jint)result[i];
  jenv->ReleaseIntArrayElements(jresult, arr, 0);
  return jresult;
}


/* unsigned long[] support */
static int SWIG_JavaArrayInUlong (JNIEnv *jenv, jlong **jarr, unsigned long **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new unsigned long[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (unsigned long)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutUlong (JNIEnv *jenv, jlong *jarr, unsigned long *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutUlong (JNIEnv *jenv, unsigned long *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* jlong[] support */
static int SWIG_JavaArrayInLonglong (JNIEnv *jenv, jlong **jarr, jlong **carr, jlongArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetLongArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new jlong[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (jlong)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutLonglong (JNIEnv *jenv, jlong *jarr, jlong *carr, jlongArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jlong)carr[i];
  jenv->ReleaseLongArrayElements(input, jarr, 0);
}

static jlongArray SWIG_JavaArrayOutLonglong (JNIEnv *jenv, jlong *result, jsize sz) {
  jlong *arr;
  int i;
  jlongArray jresult = jenv->NewLongArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetLongArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jlong)result[i];
  jenv->ReleaseLongArrayElements(jresult, arr, 0);
  return jresult;
}


/* float[] support */
static int SWIG_JavaArrayInFloat (JNIEnv *jenv, jfloat **jarr, float **carr, jfloatArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetFloatArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new float[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (float)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutFloat (JNIEnv *jenv, jfloat *jarr, float *carr, jfloatArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jfloat)carr[i];
  jenv->ReleaseFloatArrayElements(input, jarr, 0);
}

static jfloatArray SWIG_JavaArrayOutFloat (JNIEnv *jenv, float *result, jsize sz) {
  jfloat *arr;
  int i;
  jfloatArray jresult = jenv->NewFloatArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetFloatArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jfloat)result[i];
  jenv->ReleaseFloatArrayElements(jresult, arr, 0);
  return jresult;
}


/* double[] support */
static int SWIG_JavaArrayInDouble (JNIEnv *jenv, jdouble **jarr, double **carr, jdoubleArray input) {
  int i;
  jsize sz;
  if (!input) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null array");
    return 0;
  }
  sz = jenv->GetArrayLength(input);
  *jarr = jenv->GetDoubleArrayElements(input, 0);
  if (!*jarr)
    return 0; 
  *carr = new double[sz]; 
  if (!*carr) {
    SWIG_JavaThrowException(jenv, SWIG_JavaOutOfMemoryError, "array memory allocation failed");
    return 0;
  }
  for (i=0; i<sz; i++)
    (*carr)[i] = (double)(*jarr)[i];
  return 1;
}

static void SWIG_JavaArrayArgoutDouble (JNIEnv *jenv, jdouble *jarr, double *carr, jdoubleArray input) {
  int i;
  jsize sz = jenv->GetArrayLength(input);
  for (i=0; i<sz; i++)
    jarr[i] = (jdouble)carr[i];
  jenv->ReleaseDoubleArrayElements(input, jarr, 0);
}

static jdoubleArray SWIG_JavaArrayOutDouble (JNIEnv *jenv, double *result, jsize sz) {
  jdouble *arr;
  int i;
  jdoubleArray jresult = jenv->NewDoubleArray(sz);
  if (!jresult)
    return NULL;
  arr = jenv->GetDoubleArrayElements(jresult, 0);
  if (!arr)
    return NULL;
  for (i=0; i<sz; i++)
    arr[i] = (jdouble)result[i];
  jenv->ReleaseDoubleArrayElements(jresult, arr, 0);
  return jresult;
}


#endif


#include <string>


#include "src/surf/surf_interface.hpp"
#include "src/surf/cpu_interface.hpp"
#include "src/surf/network_interface.hpp"
#include "src/surf/trace_mgr_private.h"
#include "src/bindings/java/surf_swig.hpp"
#include "src/xbt/dict_private.h"

typedef struct lmm_constraint *lmm_constraint_t;
typedef xbt_dynar_t DoubleDynar;

SWIGINTERN ActionArrayPtr ActionList_getArray(ActionList *self){
    return self;
  }
SWIGINTERN unsigned int tmgr_trace_event_getIdx(tmgr_trace_event *self){return 0;}
SWIGINTERN Cpu *CpuAction_getCpu(CpuAction *self){return getActionCpu(self);}
SWIGINTERN double NetworkAction_getLatency(NetworkAction *self){return self->m_latency;}
SWIGINTERN double lmm_constraint_getUsage(lmm_constraint *self){return lmm_constraint_get_usage(self);}
SWIGINTERN double lmm_variable_getValue(lmm_variable *self){return lmm_variable_getvalue(self);}
SWIGINTERN char *s_xbt_dict_getValue(s_xbt_dict *self,char *key){return (char*)xbt_dict_get_or_null(self, key);}


/* ---------------------------------------------------
 * C++ director class methods
 * --------------------------------------------------- */

#include "surfJAVA_wrap.h"

SwigDirector_Plugin::SwigDirector_Plugin(JNIEnv *jenv) : Plugin(), Swig::Director(jenv) {
}

SwigDirector_Plugin::~SwigDirector_Plugin() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


void SwigDirector_Plugin::cpuCreatedCallback(Cpu *cpu) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcpu = 0 ;
  
  if (!swig_override[0]) {
    Plugin::cpuCreatedCallback(cpu);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((Cpu **)&jcpu) = (Cpu *) cpu; 
    jenv->CallStaticVoidMethod(Swig::jclass_SurfJNI, Swig::director_methids[0], swigjobj, jcpu);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_Plugin::cpuDestructedCallback(Cpu *cpu) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcpu = 0 ;
  
  if (!swig_override[1]) {
    Plugin::cpuDestructedCallback(cpu);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((Cpu **)&jcpu) = (Cpu *) cpu; 
    jenv->CallStaticVoidMethod(Swig::jclass_SurfJNI, Swig::director_methids[1], swigjobj, jcpu);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_Plugin::cpuStateChangedCallback(Cpu *cpu, e_surf_resource_state_t arg1, e_surf_resource_state_t arg2) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jcpu = 0 ;
  jint jarg1  ;
  jint jarg2  ;
  
  if (!swig_override[2]) {
    Plugin::cpuStateChangedCallback(cpu,arg1,arg2);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((Cpu **)&jcpu) = (Cpu *) cpu; 
    jarg1 = (jint) arg1;
    jarg2 = (jint) arg2;
    jenv->CallStaticVoidMethod(Swig::jclass_SurfJNI, Swig::director_methids[2], swigjobj, jcpu, jarg1, jarg2);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_Plugin::cpuActionStateChangedCallback(CpuAction *action, e_surf_action_state_t arg1, e_surf_action_state_t arg2) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jaction = 0 ;
  jint jarg1  ;
  jint jarg2  ;
  
  if (!swig_override[3]) {
    Plugin::cpuActionStateChangedCallback(action,arg1,arg2);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((CpuAction **)&jaction) = (CpuAction *) action; 
    jarg1 = (jint) arg1;
    jarg2 = (jint) arg2;
    jenv->CallStaticVoidMethod(Swig::jclass_SurfJNI, Swig::director_methids[3], swigjobj, jaction, jarg1, jarg2);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_Plugin::networkLinkCreatedCallback(NetworkLink *link) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jlink = 0 ;
  
  if (!swig_override[4]) {
    Plugin::networkLinkCreatedCallback(link);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((NetworkLink **)&jlink) = (NetworkLink *) link; 
    jenv->CallStaticVoidMethod(Swig::jclass_SurfJNI, Swig::director_methids[4], swigjobj, jlink);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_Plugin::networkLinkDestructedCallback(NetworkLink *link) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jlink = 0 ;
  
  if (!swig_override[5]) {
    Plugin::networkLinkDestructedCallback(link);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((NetworkLink **)&jlink) = (NetworkLink *) link; 
    jenv->CallStaticVoidMethod(Swig::jclass_SurfJNI, Swig::director_methids[5], swigjobj, jlink);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_Plugin::networkLinkStateChangedCallback(NetworkLink *link, e_surf_resource_state_t arg1, e_surf_resource_state_t arg2) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jlink = 0 ;
  jint jarg1  ;
  jint jarg2  ;
  
  if (!swig_override[6]) {
    Plugin::networkLinkStateChangedCallback(link,arg1,arg2);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((NetworkLink **)&jlink) = (NetworkLink *) link; 
    jarg1 = (jint) arg1;
    jarg2 = (jint) arg2;
    jenv->CallStaticVoidMethod(Swig::jclass_SurfJNI, Swig::director_methids[6], swigjobj, jlink, jarg1, jarg2);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_Plugin::networkActionStateChangedCallback(NetworkAction *action, e_surf_action_state_t old, e_surf_action_state_t cur) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jaction = 0 ;
  jint jold  ;
  jint jcur  ;
  
  if (!swig_override[7]) {
    Plugin::networkActionStateChangedCallback(action,old,cur);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((NetworkAction **)&jaction) = (NetworkAction *) action; 
    jold = (jint) old;
    jcur = (jint) cur;
    jenv->CallStaticVoidMethod(Swig::jclass_SurfJNI, Swig::director_methids[7], swigjobj, jaction, jold, jcur);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_Plugin::networkCommunicateCallback(NetworkAction *action, RoutingEdge *src, RoutingEdge *dst, double size, double rate) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jaction = 0 ;
  jlong jsrc = 0 ;
  jlong jdst = 0 ;
  jdouble jsize  ;
  jdouble jrate  ;
  
  if (!swig_override[8]) {
    Plugin::networkCommunicateCallback(action,src,dst,size,rate);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((NetworkAction **)&jaction) = (NetworkAction *) action; 
    *((RoutingEdge **)&jsrc) = (RoutingEdge *) src; 
    *((RoutingEdge **)&jdst) = (RoutingEdge *) dst; 
    jsize = (jdouble) size;
    jrate = (jdouble) rate;
    jenv->CallStaticVoidMethod(Swig::jclass_SurfJNI, Swig::director_methids[8], swigjobj, jaction, jsrc, jdst, jsize, jrate);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_Plugin::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "cpuCreatedCallback", "(Lorg/simgrid/surf/Cpu;)V", NULL 
    },
    {
      "cpuDestructedCallback", "(Lorg/simgrid/surf/Cpu;)V", NULL 
    },
    {
      "cpuStateChangedCallback", "(Lorg/simgrid/surf/Cpu;Lorg/simgrid/surf/ResourceState;Lorg/simgrid/surf/ResourceState;)V", NULL 
    },
    {
      "cpuActionStateChangedCallback", "(Lorg/simgrid/surf/CpuAction;Lorg/simgrid/surf/ActionState;Lorg/simgrid/surf/ActionState;)V", NULL 
    },
    {
      "networkLinkCreatedCallback", "(Lorg/simgrid/surf/NetworkLink;)V", NULL 
    },
    {
      "networkLinkDestructedCallback", "(Lorg/simgrid/surf/NetworkLink;)V", NULL 
    },
    {
      "networkLinkStateChangedCallback", "(Lorg/simgrid/surf/NetworkLink;Lorg/simgrid/surf/ResourceState;Lorg/simgrid/surf/ResourceState;)V", NULL 
    },
    {
      "networkActionStateChangedCallback", "(Lorg/simgrid/surf/NetworkAction;Lorg/simgrid/surf/ActionState;Lorg/simgrid/surf/ActionState;)V", NULL 
    },
    {
      "networkCommunicateCallback", "(Lorg/simgrid/surf/NetworkAction;Lorg/simgrid/surf/RoutingEdge;Lorg/simgrid/surf/RoutingEdge;DD)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/simgrid/surf/Plugin");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 9; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_CpuModel::SwigDirector_CpuModel(JNIEnv *jenv, char const *name) : CpuModel(name), Swig::Director(jenv) {
}

double SwigDirector_CpuModel::shareResources(double now) {
  double c_result = SwigValueInit< double >() ;
  jdouble jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jdouble jnow  ;
  
  if (!swig_override[0]) {
    return Model::shareResources(now);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jnow = (jdouble) now;
    jresult = (jdouble) jenv->CallStaticDoubleMethod(Swig::jclass_SurfJNI, Swig::director_methids[9], swigjobj, jnow);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (double)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

double SwigDirector_CpuModel::shareResourcesLazy(double now) {
  double c_result = SwigValueInit< double >() ;
  jdouble jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jdouble jnow  ;
  
  if (!swig_override[1]) {
    return Model::shareResourcesLazy(now);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jnow = (jdouble) now;
    jresult = (jdouble) jenv->CallStaticDoubleMethod(Swig::jclass_SurfJNI, Swig::director_methids[10], swigjobj, jnow);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (double)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

double SwigDirector_CpuModel::shareResourcesFull(double now) {
  double c_result = SwigValueInit< double >() ;
  jdouble jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jdouble jnow  ;
  
  if (!swig_override[2]) {
    return Model::shareResourcesFull(now);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jnow = (jdouble) now;
    jresult = (jdouble) jenv->CallStaticDoubleMethod(Swig::jclass_SurfJNI, Swig::director_methids[11], swigjobj, jnow);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (double)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_CpuModel::updateActionsState(double now, double delta) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jdouble jnow  ;
  jdouble jdelta  ;
  
  if (!swig_override[3]) {
    Model::updateActionsState(now,delta);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jnow = (jdouble) now;
    jdelta = (jdouble) delta;
    jenv->CallStaticVoidMethod(Swig::jclass_SurfJNI, Swig::director_methids[12], swigjobj, jnow, jdelta);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_CpuModel::updateActionsStateLazy(double now, double delta) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jdouble jnow  ;
  jdouble jdelta  ;
  
  if (!swig_override[4]) {
    Model::updateActionsStateLazy(now,delta);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jnow = (jdouble) now;
    jdelta = (jdouble) delta;
    jenv->CallStaticVoidMethod(Swig::jclass_SurfJNI, Swig::director_methids[13], swigjobj, jnow, jdelta);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_CpuModel::updateActionsStateFull(double now, double delta) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jdouble jnow  ;
  jdouble jdelta  ;
  
  if (!swig_override[5]) {
    Model::updateActionsStateFull(now,delta);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jnow = (jdouble) now;
    jdelta = (jdouble) delta;
    jenv->CallStaticVoidMethod(Swig::jclass_SurfJNI, Swig::director_methids[14], swigjobj, jnow, jdelta);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

ActionList *SwigDirector_CpuModel::getRunningActionSet() {
  ActionList *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[6]) {
    return Model::getRunningActionSet();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_SurfJNI, Swig::director_methids[15], swigjobj);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(ActionList **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_CpuModel::addTraces() {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[7]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method CpuModel::addTraces.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jenv->CallStaticVoidMethod(Swig::jclass_SurfJNI, Swig::director_methids[16], swigjobj);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

SwigDirector_CpuModel::~SwigDirector_CpuModel() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


Cpu *SwigDirector_CpuModel::createCpu(char const *name, DoubleDynar power_peak, int pstate, double power_scale, tmgr_trace *power_trace, int core, e_surf_resource_state_t state_initial, tmgr_trace *state_trace, s_xbt_dict *cpu_properties) {
  Cpu *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jstring jname = 0 ;
  jdoubleArray jpower_peak  ;
  jint jpstate  ;
  jdouble jpower_scale  ;
  jlong jpower_trace = 0 ;
  jint jcore  ;
  jint jstate_initial  ;
  jlong jstate_trace = 0 ;
  jlong jcpu_properties = 0 ;
  
  if (!swig_override[8]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method CpuModel::createCpu.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jname = 0;
    if (name) {
      jname = jenv->NewStringUTF((const char *)name);
      if (!jname) return c_result;
    }
    
    long l = xbt_dynar_length(power_peak);
    jpower_peak = jenv->NewDoubleArray(l);
    double *lout = (double *)xbt_dynar_to_array(power_peak);
    jenv->SetDoubleArrayRegion(jpower_peak, 0, l, (const jdouble*)lout);
    free(lout);
    
    jpstate = (jint) pstate;
    jpower_scale = (jdouble) power_scale;
    *((tmgr_trace **)&jpower_trace) = (tmgr_trace *) power_trace; 
    jcore = (jint) core;
    jstate_initial = (jint) state_initial;
    *((tmgr_trace **)&jstate_trace) = (tmgr_trace *) state_trace; 
    *((s_xbt_dict **)&jcpu_properties) = (s_xbt_dict *) cpu_properties; 
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_SurfJNI, Swig::director_methids[17], swigjobj, jname, jpower_peak, jpstate, jpower_scale, jpower_trace, jcore, jstate_initial, jstate_trace, jcpu_properties);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(Cpu **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_CpuModel::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "shareResources", "(D)D", NULL 
    },
    {
      "shareResourcesLazy", "(D)D", NULL 
    },
    {
      "shareResourcesFull", "(D)D", NULL 
    },
    {
      "updateActionsState", "(DD)V", NULL 
    },
    {
      "updateActionsStateLazy", "(DD)V", NULL 
    },
    {
      "updateActionsStateFull", "(DD)V", NULL 
    },
    {
      "getRunningActionSet", "()Lorg/simgrid/surf/ActionList;", NULL 
    },
    {
      "addTraces", "()V", NULL 
    },
    {
      "createCpu", "(Ljava/lang/String;[DIDLorg/simgrid/surf/TmgrTrace;ILorg/simgrid/surf/ResourceState;Lorg/simgrid/surf/TmgrTrace;Lorg/simgrid/surf/XbtDict;)Lorg/simgrid/surf/Cpu;", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/simgrid/surf/CpuModel");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 9; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_Cpu::SwigDirector_Cpu(JNIEnv *jenv, Model *model, char const *name, s_xbt_dict *props, lmm_constraint *constraint, int core, double powerPeak, double powerScale) : Cpu(model, name, props, constraint, core, powerPeak, powerScale), Swig::Director(jenv) {
}

SwigDirector_Cpu::SwigDirector_Cpu(JNIEnv *jenv, Model *model, char const *name, s_xbt_dict *props, int core, double powerPeak, double powerScale) : Cpu(model, name, props, core, powerPeak, powerScale), Swig::Director(jenv) {
}

bool SwigDirector_Cpu::isUsed() {
  bool c_result = SwigValueInit< bool >() ;
  jboolean jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Cpu::isUsed.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jboolean) jenv->CallStaticBooleanMethod(Swig::jclass_SurfJNI, Swig::director_methids[18], swigjobj);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = jresult ? true : false; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

e_surf_resource_state_t SwigDirector_Cpu::getState() {
  e_surf_resource_state_t c_result = SwigValueInit< e_surf_resource_state_t >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[1]) {
    return Resource::getState();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_SurfJNI, Swig::director_methids[19], swigjobj);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (e_surf_resource_state_t)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_Cpu::updateState(tmgr_trace_event *event_type, double value, double date) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jlong jevent_type = 0 ;
  jdouble jvalue  ;
  jdouble jdate  ;
  
  if (!swig_override[2]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Cpu::updateState.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    *((tmgr_trace_event **)&jevent_type) = (tmgr_trace_event *) event_type; 
    jvalue = (jdouble) value;
    jdate = (jdouble) date;
    jenv->CallStaticVoidMethod(Swig::jclass_SurfJNI, Swig::director_methids[20], swigjobj, jevent_type, jvalue, jdate);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

SwigDirector_Cpu::~SwigDirector_Cpu() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


double SwigDirector_Cpu::getCurrentPowerPeak() {
  double c_result = SwigValueInit< double >() ;
  jdouble jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[3]) {
    return Cpu::getCurrentPowerPeak();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jdouble) jenv->CallStaticDoubleMethod(Swig::jclass_SurfJNI, Swig::director_methids[21], swigjobj);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (double)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

CpuAction *SwigDirector_Cpu::execute(double size) {
  CpuAction *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jdouble jsize  ;
  
  if (!swig_override[4]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Cpu::execute.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jsize = (jdouble) size;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_SurfJNI, Swig::director_methids[22], swigjobj, jsize);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(CpuAction **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

CpuAction *SwigDirector_Cpu::sleep(double duration) {
  CpuAction *c_result = 0 ;
  jlong jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jdouble jduration  ;
  
  if (!swig_override[5]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Cpu::sleep.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jduration = (jdouble) duration;
    jresult = (jlong) jenv->CallStaticLongMethod(Swig::jclass_SurfJNI, Swig::director_methids[23], swigjobj, jduration);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = *(CpuAction **)&jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_Cpu::getCore() {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[6]) {
    return Cpu::getCore();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_SurfJNI, Swig::director_methids[24], swigjobj);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

double SwigDirector_Cpu::getSpeed(double load) {
  double c_result = SwigValueInit< double >() ;
  jdouble jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jdouble jload  ;
  
  if (!swig_override[7]) {
    return Cpu::getSpeed(load);
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jload = (jdouble) load;
    jresult = (jdouble) jenv->CallStaticDoubleMethod(Swig::jclass_SurfJNI, Swig::director_methids[25], swigjobj, jload);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (double)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

double SwigDirector_Cpu::getAvailableSpeed() {
  double c_result = SwigValueInit< double >() ;
  jdouble jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[8]) {
    return Cpu::getAvailableSpeed();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jdouble) jenv->CallStaticDoubleMethod(Swig::jclass_SurfJNI, Swig::director_methids[26], swigjobj);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (double)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

double SwigDirector_Cpu::getPowerPeakAt(int pstate_index) {
  double c_result = SwigValueInit< double >() ;
  jdouble jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint jpstate_index  ;
  
  if (!swig_override[9]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Cpu::getPowerPeakAt.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jpstate_index = (jint) pstate_index;
    jresult = (jdouble) jenv->CallStaticDoubleMethod(Swig::jclass_SurfJNI, Swig::director_methids[27], swigjobj, jpstate_index);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (double)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

int SwigDirector_Cpu::getNbPstates() {
  int c_result = SwigValueInit< int >() ;
  jint jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[10]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Cpu::getNbPstates.");
    return c_result;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jint) jenv->CallStaticIntMethod(Swig::jclass_SurfJNI, Swig::director_methids[28], swigjobj);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (int)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_Cpu::setPowerPeakAt(int pstate_index) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint jpstate_index  ;
  
  if (!swig_override[11]) {
    SWIG_JavaThrowException(JNIEnvWrapper(this).getJNIEnv(), SWIG_JavaDirectorPureVirtual, "Attempted to invoke pure virtual method Cpu::setPowerPeakAt.");
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jpstate_index = (jint) pstate_index;
    jenv->CallStaticVoidMethod(Swig::jclass_SurfJNI, Swig::director_methids[29], swigjobj, jpstate_index);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_Cpu::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "isUsed", "()Z", NULL 
    },
    {
      "getState", "()Lorg/simgrid/surf/ResourceState;", NULL 
    },
    {
      "updateState", "(Lorg/simgrid/surf/TmgrTraceEvent;DD)V", NULL 
    },
    {
      "getCurrentPowerPeak", "()D", NULL 
    },
    {
      "execute", "(D)Lorg/simgrid/surf/CpuAction;", NULL 
    },
    {
      "sleep", "(D)Lorg/simgrid/surf/CpuAction;", NULL 
    },
    {
      "getCore", "()I", NULL 
    },
    {
      "getSpeed", "(D)D", NULL 
    },
    {
      "getAvailableSpeed", "()D", NULL 
    },
    {
      "getPowerPeakAt", "(I)D", NULL 
    },
    {
      "getNbPstates", "()I", NULL 
    },
    {
      "setPowerPeakAt", "(I)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/simgrid/surf/Cpu");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 12; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}


SwigDirector_CpuAction::SwigDirector_CpuAction(JNIEnv *jenv, Model *model, double cost, bool failed) : CpuAction(model, cost, failed), Swig::Director(jenv) {
}

SwigDirector_CpuAction::~SwigDirector_CpuAction() {
  swig_disconnect_director_self("swigDirectorDisconnect");
}


double SwigDirector_CpuAction::getRemains() {
  double c_result = SwigValueInit< double >() ;
  jdouble jresult = 0 ;
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  
  if (!swig_override[0]) {
    return Action::getRemains();
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jresult = (jdouble) jenv->CallStaticDoubleMethod(Swig::jclass_SurfJNI, Swig::director_methids[30], swigjobj);
    if (jenv->ExceptionCheck() == JNI_TRUE) return c_result;
    c_result = (double)jresult; 
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
  return c_result;
}

void SwigDirector_CpuAction::setPriority(double priority) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jdouble jpriority  ;
  
  if (!swig_override[1]) {
    Action::setPriority(priority);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jpriority = (jdouble) priority;
    jenv->CallStaticVoidMethod(Swig::jclass_SurfJNI, Swig::director_methids[31], swigjobj, jpriority);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_CpuAction::setState(e_surf_action_state_t state) {
  JNIEnvWrapper swigjnienv(this) ;
  JNIEnv * jenv = swigjnienv.getJNIEnv() ;
  jobject swigjobj = (jobject) NULL ;
  jint jstate  ;
  
  if (!swig_override[2]) {
    Action::setState(state);
    return;
  }
  swigjobj = swig_get_self(jenv);
  if (swigjobj && jenv->IsSameObject(swigjobj, NULL) == JNI_FALSE) {
    jstate = (jint) state;
    jenv->CallStaticVoidMethod(Swig::jclass_SurfJNI, Swig::director_methids[32], swigjobj, jstate);
    if (jenv->ExceptionCheck() == JNI_TRUE) return ;
  } else {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "null upcall object");
  }
  if (swigjobj) jenv->DeleteLocalRef(swigjobj);
}

void SwigDirector_CpuAction::swig_connect_director(JNIEnv *jenv, jobject jself, jclass jcls, bool swig_mem_own, bool weak_global) {
  static struct {
    const char *mname;
    const char *mdesc;
    jmethodID base_methid;
  } methods[] = {
    {
      "getRemains", "()D", NULL 
    },
    {
      "setPriority", "(D)V", NULL 
    },
    {
      "setState", "(Lorg/simgrid/surf/ActionState;)V", NULL 
    }
  };
  
  static jclass baseclass = 0 ;
  
  if (swig_set_self(jenv, jself, swig_mem_own, weak_global)) {
    if (!baseclass) {
      baseclass = jenv->FindClass("org/simgrid/surf/CpuAction");
      if (!baseclass) return;
      baseclass = (jclass) jenv->NewGlobalRef(baseclass);
    }
    bool derived = (jenv->IsSameObject(baseclass, jcls) ? false : true);
    for (int i = 0; i < 3; ++i) {
      if (!methods[i].base_methid) {
        methods[i].base_methid = jenv->GetMethodID(baseclass, methods[i].mname, methods[i].mdesc);
        if (!methods[i].base_methid) return;
      }
      swig_override[i] = false;
      if (derived) {
        jmethodID methid = jenv->GetMethodID(jcls, methods[i].mname, methods[i].mdesc);
        swig_override[i] = (methid != methods[i].base_methid);
        jenv->ExceptionClear();
      }
    }
  }
}



#ifdef __cplusplus
extern "C" {
#endif


#ifdef __cplusplus
extern "C" {
#endif

JNIEXPORT jobject JNICALL Java_org_simgrid_surf_SurfJNI_getAction(JNIEnv *env, jclass cls, jlong jarg1) {
  Action * action = (Action *)jarg1;
  jobject res;
  CpuAction *cpu_action = dynamic_cast<CpuAction*>(action);
  if (cpu_action) {
    SwigDirector_CpuAction *dir_cpu_action = dynamic_cast<SwigDirector_CpuAction*>(cpu_action);
    if (dir_cpu_action) {
      res = dir_cpu_action->swig_get_self(env);\
    } else {
      jclass clss = env->FindClass("org/simgrid/surf/CpuAction");\
      jmethodID constru = env->GetMethodID(clss, "<init>", "()V");\
      res = env->NewObject(clss, constru);\
      res = env->NewGlobalRef(res);\
    }
  } else {
    jclass clss = env->FindClass("org/simgrid/surf/Action");\
    jmethodID constru = env->GetMethodID(clss, "<init>", "()V");\
    res = env->NewObject(clss, constru);\
    res = env->NewGlobalRef(res);\
  }
  return res;
}

#define GETDIRECTOR(NAME) \
JNIEXPORT jobject JNICALL Java_org_simgrid_surf_SurfJNI_get## NAME ## Director(JNIEnv *env, jclass cls, jlong jarg1)\
{\
  NAME * arg1 = (NAME*)jarg1;\
  SwigDirector_ ##NAME *director = dynamic_cast<SwigDirector_ ##NAME *>(arg1);\
  jobject res;\
  if (director) {\
    res = director->swig_get_self(env);\
  } else {\
    jclass clss = env->FindClass("org/simgrid/surf/NAME");\
    jmethodID constru = env->GetMethodID(clss, "<init>", "()V");\
    res = env->NewObject(clss, constru);\
    res = env->NewGlobalRef(res);\
  }\
  return res;\
}

GETDIRECTOR(CpuModel)
GETDIRECTOR(Cpu)
GETDIRECTOR(CpuAction)

#ifdef __cplusplus
}
#endif


SWIGEXPORT jlongArray JNICALL Java_org_simgrid_surf_SurfJNI_ActionList_1getArray(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlongArray jresult = 0 ;
  ActionList *arg1 = (ActionList *) 0 ;
  ActionArrayPtr result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(ActionList **)&jarg1; 
  result = (ActionArrayPtr)ActionList_getArray(arg1);
  {
    long l = 0;
    for(ActionList::iterator it(result->begin()), itend(result->end()); it != itend ; ++it) {
      l++;
    }
    jresult = jenv->NewLongArray(l);
    jlong *elts = jenv->GetLongArrayElements(jresult, NULL);
    l = 0;
    for(ActionList::iterator it(result->begin()), itend(result->end()); it != itend ; ++it) {
      elts[l++] = (jlong)static_cast<ActionPtr>(&*it);
    }
    jenv->ReleaseLongArrayElements(jresult, elts, 0);
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_simgrid_surf_SurfJNI_new_1ActionList(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  ActionList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (ActionList *)new ActionList();
  *(ActionList **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_delete_1ActionList(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  ActionList *arg1 = (ActionList *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(ActionList **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jdouble JNICALL Java_org_simgrid_surf_SurfJNI_getClock(JNIEnv *jenv, jclass jcls) {
  jdouble jresult = 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  result = (double)getClock();
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_clean(JNIEnv *jenv, jclass jcls) {
  (void)jenv;
  (void)jcls;
  clean();
}


SWIGEXPORT jlong JNICALL Java_org_simgrid_surf_SurfJNI_getCpuModel(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  CpuModel *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (CpuModel *)getCpuModel();
  *(CpuModel **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_setCpuModel(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  CpuModel *arg1 = (CpuModel *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CpuModel **)&jarg1; 
  setCpuModel(arg1);
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_setCpu(JNIEnv *jenv, jclass jcls, jstring jarg1, jlong jarg2, jobject jarg2_) {
  char *arg1 = (char *) 0 ;
  Cpu *arg2 = (Cpu *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg2_;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return ;
  }
  arg2 = *(Cpu **)&jarg2; 
  setCpu(arg1,arg2);
  {
    
  }
}


SWIGEXPORT jlongArray JNICALL Java_org_simgrid_surf_SurfJNI_getRoute(JNIEnv *jenv, jclass jcls, jstring jarg1, jstring jarg2) {
  jlongArray jresult = 0 ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  NetworkLinkDynar result;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = getRoute(arg1,arg2);
  {
    long l = xbt_dynar_length(result);
    jresult = jenv->NewLongArray(l);
    unsigned i;
    NetworkLink *link;
    jlong *elts = jenv->GetLongArrayElements(jresult, NULL);
    xbt_dynar_foreach(result, i, link) {
      elts[i] = (jlong)link;
    }
    jenv->ReleaseLongArrayElements(jresult, elts, 0);
    xbt_dynar_free(&result);
  }
  if (arg1) jenv->ReleaseStringUTFChars(jarg1, (const char *)arg1);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_delete_1Plugin(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Plugin *arg1 = (Plugin *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Plugin **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Plugin_1activateCpuCreatedCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Plugin *arg1 = (Plugin *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Plugin **)&jarg1; 
  (arg1)->activateCpuCreatedCallback();
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Plugin_1cpuCreatedCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Plugin *arg1 = (Plugin *) 0 ;
  Cpu *arg2 = (Cpu *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Plugin **)&jarg1; 
  arg2 = *(Cpu **)&jarg2; 
  (arg1)->cpuCreatedCallback(arg2);
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Plugin_1cpuCreatedCallbackSwigExplicitPlugin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Plugin *arg1 = (Plugin *) 0 ;
  Cpu *arg2 = (Cpu *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Plugin **)&jarg1; 
  arg2 = *(Cpu **)&jarg2; 
  (arg1)->Plugin::cpuCreatedCallback(arg2);
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Plugin_1activateCpuDestructedCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Plugin *arg1 = (Plugin *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Plugin **)&jarg1; 
  (arg1)->activateCpuDestructedCallback();
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Plugin_1cpuDestructedCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Plugin *arg1 = (Plugin *) 0 ;
  Cpu *arg2 = (Cpu *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Plugin **)&jarg1; 
  arg2 = *(Cpu **)&jarg2; 
  (arg1)->cpuDestructedCallback(arg2);
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Plugin_1cpuDestructedCallbackSwigExplicitPlugin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Plugin *arg1 = (Plugin *) 0 ;
  Cpu *arg2 = (Cpu *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Plugin **)&jarg1; 
  arg2 = *(Cpu **)&jarg2; 
  (arg1)->Plugin::cpuDestructedCallback(arg2);
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Plugin_1activateCpuStateChangedCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Plugin *arg1 = (Plugin *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Plugin **)&jarg1; 
  (arg1)->activateCpuStateChangedCallback();
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Plugin_1cpuStateChangedCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  Plugin *arg1 = (Plugin *) 0 ;
  Cpu *arg2 = (Cpu *) 0 ;
  e_surf_resource_state_t arg3 ;
  e_surf_resource_state_t arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Plugin **)&jarg1; 
  arg2 = *(Cpu **)&jarg2; 
  arg3 = (e_surf_resource_state_t)jarg3; 
  arg4 = (e_surf_resource_state_t)jarg4; 
  (arg1)->cpuStateChangedCallback(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Plugin_1cpuStateChangedCallbackSwigExplicitPlugin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  Plugin *arg1 = (Plugin *) 0 ;
  Cpu *arg2 = (Cpu *) 0 ;
  e_surf_resource_state_t arg3 ;
  e_surf_resource_state_t arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Plugin **)&jarg1; 
  arg2 = *(Cpu **)&jarg2; 
  arg3 = (e_surf_resource_state_t)jarg3; 
  arg4 = (e_surf_resource_state_t)jarg4; 
  (arg1)->Plugin::cpuStateChangedCallback(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Plugin_1activateCpuActionStateChangedCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Plugin *arg1 = (Plugin *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Plugin **)&jarg1; 
  (arg1)->activateCpuActionStateChangedCallback();
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Plugin_1cpuActionStateChangedCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  Plugin *arg1 = (Plugin *) 0 ;
  CpuAction *arg2 = (CpuAction *) 0 ;
  e_surf_action_state_t arg3 ;
  e_surf_action_state_t arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Plugin **)&jarg1; 
  arg2 = *(CpuAction **)&jarg2; 
  arg3 = (e_surf_action_state_t)jarg3; 
  arg4 = (e_surf_action_state_t)jarg4; 
  (arg1)->cpuActionStateChangedCallback(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Plugin_1cpuActionStateChangedCallbackSwigExplicitPlugin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  Plugin *arg1 = (Plugin *) 0 ;
  CpuAction *arg2 = (CpuAction *) 0 ;
  e_surf_action_state_t arg3 ;
  e_surf_action_state_t arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Plugin **)&jarg1; 
  arg2 = *(CpuAction **)&jarg2; 
  arg3 = (e_surf_action_state_t)jarg3; 
  arg4 = (e_surf_action_state_t)jarg4; 
  (arg1)->Plugin::cpuActionStateChangedCallback(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Plugin_1activateNetworkLinkCreatedCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Plugin *arg1 = (Plugin *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Plugin **)&jarg1; 
  (arg1)->activateNetworkLinkCreatedCallback();
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Plugin_1networkLinkCreatedCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Plugin *arg1 = (Plugin *) 0 ;
  NetworkLink *arg2 = (NetworkLink *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Plugin **)&jarg1; 
  arg2 = *(NetworkLink **)&jarg2; 
  (arg1)->networkLinkCreatedCallback(arg2);
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Plugin_1networkLinkCreatedCallbackSwigExplicitPlugin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Plugin *arg1 = (Plugin *) 0 ;
  NetworkLink *arg2 = (NetworkLink *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Plugin **)&jarg1; 
  arg2 = *(NetworkLink **)&jarg2; 
  (arg1)->Plugin::networkLinkCreatedCallback(arg2);
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Plugin_1activateNetworkLinkDestructedCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Plugin *arg1 = (Plugin *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Plugin **)&jarg1; 
  (arg1)->activateNetworkLinkDestructedCallback();
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Plugin_1networkLinkDestructedCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Plugin *arg1 = (Plugin *) 0 ;
  NetworkLink *arg2 = (NetworkLink *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Plugin **)&jarg1; 
  arg2 = *(NetworkLink **)&jarg2; 
  (arg1)->networkLinkDestructedCallback(arg2);
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Plugin_1networkLinkDestructedCallbackSwigExplicitPlugin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_) {
  Plugin *arg1 = (Plugin *) 0 ;
  NetworkLink *arg2 = (NetworkLink *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Plugin **)&jarg1; 
  arg2 = *(NetworkLink **)&jarg2; 
  (arg1)->Plugin::networkLinkDestructedCallback(arg2);
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Plugin_1activateNetworkLinkStateChangedCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Plugin *arg1 = (Plugin *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Plugin **)&jarg1; 
  (arg1)->activateNetworkLinkStateChangedCallback();
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Plugin_1networkLinkStateChangedCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  Plugin *arg1 = (Plugin *) 0 ;
  NetworkLink *arg2 = (NetworkLink *) 0 ;
  e_surf_resource_state_t arg3 ;
  e_surf_resource_state_t arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Plugin **)&jarg1; 
  arg2 = *(NetworkLink **)&jarg2; 
  arg3 = (e_surf_resource_state_t)jarg3; 
  arg4 = (e_surf_resource_state_t)jarg4; 
  (arg1)->networkLinkStateChangedCallback(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Plugin_1networkLinkStateChangedCallbackSwigExplicitPlugin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  Plugin *arg1 = (Plugin *) 0 ;
  NetworkLink *arg2 = (NetworkLink *) 0 ;
  e_surf_resource_state_t arg3 ;
  e_surf_resource_state_t arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Plugin **)&jarg1; 
  arg2 = *(NetworkLink **)&jarg2; 
  arg3 = (e_surf_resource_state_t)jarg3; 
  arg4 = (e_surf_resource_state_t)jarg4; 
  (arg1)->Plugin::networkLinkStateChangedCallback(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Plugin_1activateNetworkActionStateChangedCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Plugin *arg1 = (Plugin *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Plugin **)&jarg1; 
  (arg1)->activateNetworkActionStateChangedCallback();
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Plugin_1networkActionStateChangedCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  Plugin *arg1 = (Plugin *) 0 ;
  NetworkAction *arg2 = (NetworkAction *) 0 ;
  e_surf_action_state_t arg3 ;
  e_surf_action_state_t arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Plugin **)&jarg1; 
  arg2 = *(NetworkAction **)&jarg2; 
  arg3 = (e_surf_action_state_t)jarg3; 
  arg4 = (e_surf_action_state_t)jarg4; 
  (arg1)->networkActionStateChangedCallback(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Plugin_1networkActionStateChangedCallbackSwigExplicitPlugin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jint jarg3, jint jarg4) {
  Plugin *arg1 = (Plugin *) 0 ;
  NetworkAction *arg2 = (NetworkAction *) 0 ;
  e_surf_action_state_t arg3 ;
  e_surf_action_state_t arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Plugin **)&jarg1; 
  arg2 = *(NetworkAction **)&jarg2; 
  arg3 = (e_surf_action_state_t)jarg3; 
  arg4 = (e_surf_action_state_t)jarg4; 
  (arg1)->Plugin::networkActionStateChangedCallback(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Plugin_1activateNetworkCommunicateCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Plugin *arg1 = (Plugin *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Plugin **)&jarg1; 
  (arg1)->activateNetworkCommunicateCallback();
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Plugin_1networkCommunicateCallback(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jdouble jarg5, jdouble jarg6) {
  Plugin *arg1 = (Plugin *) 0 ;
  NetworkAction *arg2 = (NetworkAction *) 0 ;
  RoutingEdge *arg3 = (RoutingEdge *) 0 ;
  RoutingEdge *arg4 = (RoutingEdge *) 0 ;
  double arg5 ;
  double arg6 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(Plugin **)&jarg1; 
  arg2 = *(NetworkAction **)&jarg2; 
  arg3 = *(RoutingEdge **)&jarg3; 
  arg4 = *(RoutingEdge **)&jarg4; 
  arg5 = (double)jarg5; 
  arg6 = (double)jarg6; 
  (arg1)->networkCommunicateCallback(arg2,arg3,arg4,arg5,arg6);
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Plugin_1networkCommunicateCallbackSwigExplicitPlugin(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jdouble jarg5, jdouble jarg6) {
  Plugin *arg1 = (Plugin *) 0 ;
  NetworkAction *arg2 = (NetworkAction *) 0 ;
  RoutingEdge *arg3 = (RoutingEdge *) 0 ;
  RoutingEdge *arg4 = (RoutingEdge *) 0 ;
  double arg5 ;
  double arg6 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(Plugin **)&jarg1; 
  arg2 = *(NetworkAction **)&jarg2; 
  arg3 = *(RoutingEdge **)&jarg3; 
  arg4 = *(RoutingEdge **)&jarg4; 
  arg5 = (double)jarg5; 
  arg6 = (double)jarg6; 
  (arg1)->Plugin::networkCommunicateCallback(arg2,arg3,arg4,arg5,arg6);
}


SWIGEXPORT jlong JNICALL Java_org_simgrid_surf_SurfJNI_new_1Plugin(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  Plugin *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (Plugin *)new SwigDirector_Plugin(jenv);
  *(Plugin **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Plugin_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  Plugin *obj = *((Plugin **)&objarg);
  (void)jcls;
  SwigDirector_Plugin *director = dynamic_cast<SwigDirector_Plugin *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Plugin_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  Plugin *obj = *((Plugin **)&objarg);
  SwigDirector_Plugin *director = dynamic_cast<SwigDirector_Plugin *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_delete_1TmgrTrace(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  tmgr_trace *arg1 = (tmgr_trace *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(tmgr_trace **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_simgrid_surf_SurfJNI_TmgrTraceEvent_1getIdx(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  tmgr_trace_event *arg1 = (tmgr_trace_event *) 0 ;
  unsigned int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(tmgr_trace_event **)&jarg1; 
  result = (unsigned int)tmgr_trace_event_getIdx(arg1);
  jresult = (jlong)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_delete_1TmgrTraceEvent(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  tmgr_trace_event *arg1 = (tmgr_trace_event *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(tmgr_trace_event **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jstring JNICALL Java_org_simgrid_surf_SurfJNI_Model_1getName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Model *arg1 = (Model *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Model **)&jarg1; 
  result = (char *)(arg1)->getName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_simgrid_surf_SurfJNI_Model_1shareResources(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  Model *arg1 = (Model *) 0 ;
  double arg2 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Model **)&jarg1; 
  arg2 = (double)jarg2; 
  result = (double)(arg1)->shareResources(arg2);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_simgrid_surf_SurfJNI_Model_1shareResourcesLazy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  Model *arg1 = (Model *) 0 ;
  double arg2 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Model **)&jarg1; 
  arg2 = (double)jarg2; 
  result = (double)(arg1)->shareResourcesLazy(arg2);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_simgrid_surf_SurfJNI_Model_1shareResourcesFull(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  Model *arg1 = (Model *) 0 ;
  double arg2 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Model **)&jarg1; 
  arg2 = (double)jarg2; 
  result = (double)(arg1)->shareResourcesFull(arg2);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Model_1updateActionsState(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3) {
  Model *arg1 = (Model *) 0 ;
  double arg2 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Model **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  (arg1)->updateActionsState(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Model_1updateActionsStateLazy(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3) {
  Model *arg1 = (Model *) 0 ;
  double arg2 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Model **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  (arg1)->updateActionsStateLazy(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Model_1updateActionsStateFull(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3) {
  Model *arg1 = (Model *) 0 ;
  double arg2 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Model **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  (arg1)->updateActionsStateFull(arg2,arg3);
}


SWIGEXPORT jlong JNICALL Java_org_simgrid_surf_SurfJNI_Model_1getRunningActionSet(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Model *arg1 = (Model *) 0 ;
  ActionList *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Model **)&jarg1; 
  result = (ActionList *)(arg1)->getRunningActionSet();
  *(ActionList **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Model_1addTraces(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  Model *arg1 = (Model *) 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Model **)&jarg1; 
  (arg1)->addTraces();
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_delete_1Model(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Model *arg1 = (Model *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Model **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_simgrid_surf_SurfJNI_new_1CpuModel(JNIEnv *jenv, jclass jcls, jstring jarg1) {
  jlong jresult = 0 ;
  char *arg1 = (char *) 0 ;
  CpuModel *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = 0;
  if (jarg1) {
    arg1 = (char *)jenv->GetStringUTFChars(jarg1, 0);
    if (!arg1) return 0;
  }
  result = (CpuModel *)new SwigDirector_CpuModel(jenv,(char const *)arg1);
  *(CpuModel **)&jresult = result; 
  {
    
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_delete_1CpuModel(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CpuModel *arg1 = (CpuModel *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CpuModel **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_simgrid_surf_SurfJNI_CpuModel_1createCpu(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jdoubleArray jarg3, jint jarg4, jdouble jarg5, jlong jarg6, jobject jarg6_, jint jarg7, jint jarg8, jlong jarg9, jobject jarg9_, jlong jarg10, jobject jarg10_) {
  jlong jresult = 0 ;
  CpuModel *arg1 = (CpuModel *) 0 ;
  char *arg2 = (char *) 0 ;
  DoubleDynar arg3 ;
  int arg4 ;
  double arg5 ;
  tmgr_trace *arg6 = (tmgr_trace *) 0 ;
  int arg7 ;
  e_surf_resource_state_t arg8 ;
  tmgr_trace *arg9 = (tmgr_trace *) 0 ;
  s_xbt_dict *arg10 = (s_xbt_dict *) 0 ;
  DoubleDynar *argp3 ;
  Cpu *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg6_;
  (void)jarg9_;
  (void)jarg10_;
  arg1 = *(CpuModel **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  argp3 = *(DoubleDynar **)&jarg3; 
  if (!argp3) {
    SWIG_JavaThrowException(jenv, SWIG_JavaNullPointerException, "Attempt to dereference null DoubleDynar");
    return 0;
  }
  arg3 = *argp3; 
  arg4 = (int)jarg4; 
  arg5 = (double)jarg5; 
  arg6 = *(tmgr_trace **)&jarg6; 
  arg7 = (int)jarg7; 
  arg8 = (e_surf_resource_state_t)jarg8; 
  arg9 = *(tmgr_trace **)&jarg9; 
  arg10 = *(s_xbt_dict **)&jarg10; 
  result = (Cpu *)(arg1)->createCpu((char const *)arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
  *(Cpu **)&jresult = result; 
  {
    
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_CpuModel_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  CpuModel *obj = *((CpuModel **)&objarg);
  (void)jcls;
  SwigDirector_CpuModel *director = dynamic_cast<SwigDirector_CpuModel *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_CpuModel_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  CpuModel *obj = *((CpuModel **)&objarg);
  SwigDirector_CpuModel *director = dynamic_cast<SwigDirector_CpuModel *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jstring JNICALL Java_org_simgrid_surf_SurfJNI_Resource_1getName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  Resource *arg1 = (Resource *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Resource **)&jarg1; 
  result = (char *)(arg1)->getName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_simgrid_surf_SurfJNI_Resource_1isUsed(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Resource *arg1 = (Resource *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Resource **)&jarg1; 
  result = (bool)(arg1)->isUsed();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_simgrid_surf_SurfJNI_Resource_1getModel(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Resource *arg1 = (Resource *) 0 ;
  Model *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Resource **)&jarg1; 
  result = (Model *)(arg1)->getModel();
  *(Model **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_simgrid_surf_SurfJNI_Resource_1getState(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Resource *arg1 = (Resource *) 0 ;
  e_surf_resource_state_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Resource **)&jarg1; 
  result = (e_surf_resource_state_t)(arg1)->getState();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_simgrid_surf_SurfJNI_Resource_1getConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Resource *arg1 = (Resource *) 0 ;
  lmm_constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Resource **)&jarg1; 
  result = (lmm_constraint *)(arg1)->getConstraint();
  *(lmm_constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_simgrid_surf_SurfJNI_Resource_1getProperties(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Resource *arg1 = (Resource *) 0 ;
  s_xbt_dict *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Resource **)&jarg1; 
  result = (s_xbt_dict *)(arg1)->getProperties();
  *(s_xbt_dict **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Resource_1updateState(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jlong jarg2, jobject jarg2_, jdouble jarg3, jdouble jarg4) {
  Resource *arg1 = (Resource *) 0 ;
  tmgr_trace_event *arg2 = (tmgr_trace_event *) 0 ;
  double arg3 ;
  double arg4 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg2_;
  arg1 = *(Resource **)&jarg1; 
  arg2 = *(tmgr_trace_event **)&jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  (arg1)->updateState(arg2,arg3,arg4);
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_delete_1Resource(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Resource *arg1 = (Resource *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Resource **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_simgrid_surf_SurfJNI_new_1Cpu_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_, jlong jarg4, jobject jarg4_, jint jarg5, jdouble jarg6, jdouble jarg7) {
  jlong jresult = 0 ;
  Model *arg1 = (Model *) 0 ;
  char *arg2 = (char *) 0 ;
  s_xbt_dict *arg3 = (s_xbt_dict *) 0 ;
  lmm_constraint *arg4 = (lmm_constraint *) 0 ;
  int arg5 ;
  double arg6 ;
  double arg7 ;
  Cpu *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  (void)jarg4_;
  arg1 = *(Model **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(s_xbt_dict **)&jarg3; 
  arg4 = *(lmm_constraint **)&jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (double)jarg6; 
  arg7 = (double)jarg7; 
  result = (Cpu *)new SwigDirector_Cpu(jenv,arg1,(char const *)arg2,arg3,arg4,arg5,arg6,arg7);
  *(Cpu **)&jresult = result; 
  {
    
  }
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_simgrid_surf_SurfJNI_new_1Cpu_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2, jlong jarg3, jobject jarg3_, jint jarg4, jdouble jarg5, jdouble jarg6) {
  jlong jresult = 0 ;
  Model *arg1 = (Model *) 0 ;
  char *arg2 = (char *) 0 ;
  s_xbt_dict *arg3 = (s_xbt_dict *) 0 ;
  int arg4 ;
  double arg5 ;
  double arg6 ;
  Cpu *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  (void)jarg3_;
  arg1 = *(Model **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  arg3 = *(s_xbt_dict **)&jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (double)jarg5; 
  arg6 = (double)jarg6; 
  result = (Cpu *)new SwigDirector_Cpu(jenv,arg1,(char const *)arg2,arg3,arg4,arg5,arg6);
  *(Cpu **)&jresult = result; 
  {
    
  }
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_delete_1Cpu(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Cpu *arg1 = (Cpu *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Cpu **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jdouble JNICALL Java_org_simgrid_surf_SurfJNI_Cpu_1getCurrentPowerPeak(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Cpu *arg1 = (Cpu *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Cpu **)&jarg1; 
  result = (double)(arg1)->getCurrentPowerPeak();
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_simgrid_surf_SurfJNI_Cpu_1getCurrentPowerPeakSwigExplicitCpu(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Cpu *arg1 = (Cpu *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Cpu **)&jarg1; 
  result = (double)(arg1)->Cpu::getCurrentPowerPeak();
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_simgrid_surf_SurfJNI_Cpu_1execute(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jlong jresult = 0 ;
  Cpu *arg1 = (Cpu *) 0 ;
  double arg2 ;
  CpuAction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Cpu **)&jarg1; 
  arg2 = (double)jarg2; 
  result = (CpuAction *)(arg1)->execute(arg2);
  *(CpuAction **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_simgrid_surf_SurfJNI_Cpu_1sleep(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jlong jresult = 0 ;
  Cpu *arg1 = (Cpu *) 0 ;
  double arg2 ;
  CpuAction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Cpu **)&jarg1; 
  arg2 = (double)jarg2; 
  result = (CpuAction *)(arg1)->sleep(arg2);
  *(CpuAction **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_simgrid_surf_SurfJNI_Cpu_1getCore(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Cpu *arg1 = (Cpu *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Cpu **)&jarg1; 
  result = (int)(arg1)->getCore();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_simgrid_surf_SurfJNI_Cpu_1getCoreSwigExplicitCpu(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Cpu *arg1 = (Cpu *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Cpu **)&jarg1; 
  result = (int)(arg1)->Cpu::getCore();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_simgrid_surf_SurfJNI_Cpu_1getSpeed(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  Cpu *arg1 = (Cpu *) 0 ;
  double arg2 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Cpu **)&jarg1; 
  arg2 = (double)jarg2; 
  result = (double)(arg1)->getSpeed(arg2);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_simgrid_surf_SurfJNI_Cpu_1getSpeedSwigExplicitCpu(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  jdouble jresult = 0 ;
  Cpu *arg1 = (Cpu *) 0 ;
  double arg2 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Cpu **)&jarg1; 
  arg2 = (double)jarg2; 
  result = (double)(arg1)->Cpu::getSpeed(arg2);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_simgrid_surf_SurfJNI_Cpu_1getAvailableSpeed(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Cpu *arg1 = (Cpu *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Cpu **)&jarg1; 
  result = (double)(arg1)->getAvailableSpeed();
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_simgrid_surf_SurfJNI_Cpu_1getAvailableSpeedSwigExplicitCpu(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Cpu *arg1 = (Cpu *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Cpu **)&jarg1; 
  result = (double)(arg1)->Cpu::getAvailableSpeed();
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_simgrid_surf_SurfJNI_Cpu_1getPowerPeakAt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  jdouble jresult = 0 ;
  Cpu *arg1 = (Cpu *) 0 ;
  int arg2 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Cpu **)&jarg1; 
  arg2 = (int)jarg2; 
  result = (double)(arg1)->getPowerPeakAt(arg2);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_simgrid_surf_SurfJNI_Cpu_1getNbPstates(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Cpu *arg1 = (Cpu *) 0 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Cpu **)&jarg1; 
  result = (int)(arg1)->getNbPstates();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Cpu_1setPowerPeakAt(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Cpu *arg1 = (Cpu *) 0 ;
  int arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Cpu **)&jarg1; 
  arg2 = (int)jarg2; 
  (arg1)->setPowerPeakAt(arg2);
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Cpu_1setState(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Cpu *arg1 = (Cpu *) 0 ;
  e_surf_resource_state_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Cpu **)&jarg1; 
  arg2 = (e_surf_resource_state_t)jarg2; 
  (arg1)->setState(arg2);
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Cpu_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  Cpu *obj = *((Cpu **)&objarg);
  (void)jcls;
  SwigDirector_Cpu *director = dynamic_cast<SwigDirector_Cpu *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Cpu_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  Cpu *obj = *((Cpu **)&objarg);
  SwigDirector_Cpu *director = dynamic_cast<SwigDirector_Cpu *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_delete_1NetworkLink(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  NetworkLink *arg1 = (NetworkLink *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(NetworkLink **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jdouble JNICALL Java_org_simgrid_surf_SurfJNI_NetworkLink_1getBandwidth(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  NetworkLink *arg1 = (NetworkLink *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(NetworkLink **)&jarg1; 
  result = (double)(arg1)->getBandwidth();
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_NetworkLink_1updateBandwidth_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3) {
  NetworkLink *arg1 = (NetworkLink *) 0 ;
  double arg2 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(NetworkLink **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  (arg1)->updateBandwidth(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_NetworkLink_1updateBandwidth_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  NetworkLink *arg1 = (NetworkLink *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(NetworkLink **)&jarg1; 
  arg2 = (double)jarg2; 
  (arg1)->updateBandwidth(arg2);
}


SWIGEXPORT jdouble JNICALL Java_org_simgrid_surf_SurfJNI_NetworkLink_1getLatency(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  NetworkLink *arg1 = (NetworkLink *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(NetworkLink **)&jarg1; 
  result = (double)(arg1)->getLatency();
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_NetworkLink_1updateLatency_1_1SWIG_10(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jdouble jarg3) {
  NetworkLink *arg1 = (NetworkLink *) 0 ;
  double arg2 ;
  double arg3 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(NetworkLink **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  (arg1)->updateLatency(arg2,arg3);
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_NetworkLink_1updateLatency_1_1SWIG_11(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  NetworkLink *arg1 = (NetworkLink *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(NetworkLink **)&jarg1; 
  arg2 = (double)jarg2; 
  (arg1)->updateLatency(arg2);
}


SWIGEXPORT jlong JNICALL Java_org_simgrid_surf_SurfJNI_new_1Action(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jboolean jarg3) {
  jlong jresult = 0 ;
  Model *arg1 = (Model *) 0 ;
  double arg2 ;
  bool arg3 ;
  Action *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Model **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (Action *)new Action(arg1,arg2,arg3);
  *(Action **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_delete_1Action(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  Action *arg1 = (Action *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(Action **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jlong JNICALL Java_org_simgrid_surf_SurfJNI_Action_1getModel(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Action *arg1 = (Action *) 0 ;
  Model *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Action **)&jarg1; 
  result = (Model *)(arg1)->getModel();
  *(Model **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_simgrid_surf_SurfJNI_Action_1getVariable(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  Action *arg1 = (Action *) 0 ;
  lmm_variable *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Action **)&jarg1; 
  result = (lmm_variable *)(arg1)->getVariable();
  *(lmm_variable **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_simgrid_surf_SurfJNI_Action_1getState(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jint jresult = 0 ;
  Action *arg1 = (Action *) 0 ;
  e_surf_action_state_t result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Action **)&jarg1; 
  result = (e_surf_action_state_t)(arg1)->getState();
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jboolean JNICALL Java_org_simgrid_surf_SurfJNI_Action_1isSuspended(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jboolean jresult = 0 ;
  Action *arg1 = (Action *) 0 ;
  bool result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Action **)&jarg1; 
  result = (bool)(arg1)->isSuspended();
  jresult = (jboolean)result; 
  return jresult;
}


SWIGEXPORT jdouble JNICALL Java_org_simgrid_surf_SurfJNI_Action_1getBound(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Action *arg1 = (Action *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Action **)&jarg1; 
  result = (double)(arg1)->getBound();
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Action_1setBound(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  Action *arg1 = (Action *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Action **)&jarg1; 
  arg2 = (double)jarg2; 
  (arg1)->setBound(arg2);
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Action_1updateRemains(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  Action *arg1 = (Action *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Action **)&jarg1; 
  arg2 = (double)jarg2; 
  (arg1)->updateRemains(arg2);
}


SWIGEXPORT jdouble JNICALL Java_org_simgrid_surf_SurfJNI_Action_1getRemains(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  Action *arg1 = (Action *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Action **)&jarg1; 
  result = (double)(arg1)->getRemains();
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Action_1setPriority(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2) {
  Action *arg1 = (Action *) 0 ;
  double arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Action **)&jarg1; 
  arg2 = (double)jarg2; 
  (arg1)->setPriority(arg2);
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_Action_1setState(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jint jarg2) {
  Action *arg1 = (Action *) 0 ;
  e_surf_action_state_t arg2 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Action **)&jarg1; 
  arg2 = (e_surf_action_state_t)jarg2; 
  (arg1)->setState(arg2);
}


SWIGEXPORT jlong JNICALL Java_org_simgrid_surf_SurfJNI_new_1CpuAction(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jdouble jarg2, jboolean jarg3) {
  jlong jresult = 0 ;
  Model *arg1 = (Model *) 0 ;
  double arg2 ;
  bool arg3 ;
  CpuAction *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(Model **)&jarg1; 
  arg2 = (double)jarg2; 
  arg3 = jarg3 ? true : false; 
  result = (CpuAction *)new SwigDirector_CpuAction(jenv,arg1,arg2,arg3);
  *(CpuAction **)&jresult = result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_simgrid_surf_SurfJNI_CpuAction_1getCpu(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jlong jresult = 0 ;
  CpuAction *arg1 = (CpuAction *) 0 ;
  Cpu *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(CpuAction **)&jarg1; 
  result = (Cpu *)CpuAction_getCpu(arg1);
  *(Cpu **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_delete_1CpuAction(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  CpuAction *arg1 = (CpuAction *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(CpuAction **)&jarg1; 
  delete arg1;
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_CpuAction_1director_1connect(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jswig_mem_own, jboolean jweak_global) {
  CpuAction *obj = *((CpuAction **)&objarg);
  (void)jcls;
  SwigDirector_CpuAction *director = dynamic_cast<SwigDirector_CpuAction *>(obj);
  if (director) {
    director->swig_connect_director(jenv, jself, jenv->GetObjectClass(jself), (jswig_mem_own == JNI_TRUE), (jweak_global == JNI_TRUE));
  }
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_CpuAction_1change_1ownership(JNIEnv *jenv, jclass jcls, jobject jself, jlong objarg, jboolean jtake_or_release) {
  CpuAction *obj = *((CpuAction **)&objarg);
  SwigDirector_CpuAction *director = dynamic_cast<SwigDirector_CpuAction *>(obj);
  (void)jcls;
  if (director) {
    director->swig_java_change_ownership(jenv, jself, jtake_or_release ? true : false);
  }
}


SWIGEXPORT jdouble JNICALL Java_org_simgrid_surf_SurfJNI_NetworkAction_1getLatency(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  NetworkAction *arg1 = (NetworkAction *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(NetworkAction **)&jarg1; 
  result = (double)NetworkAction_getLatency(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_delete_1NetworkAction(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  NetworkAction *arg1 = (NetworkAction *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(NetworkAction **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jstring JNICALL Java_org_simgrid_surf_SurfJNI_RoutingEdge_1getName(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jstring jresult = 0 ;
  RoutingEdge *arg1 = (RoutingEdge *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(RoutingEdge **)&jarg1; 
  result = (char *)(arg1)->getName();
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_delete_1RoutingEdge(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  RoutingEdge *arg1 = (RoutingEdge *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(RoutingEdge **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jdouble JNICALL Java_org_simgrid_surf_SurfJNI_LmmConstraint_1getUsage(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  lmm_constraint *arg1 = (lmm_constraint *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lmm_constraint **)&jarg1; 
  result = (double)lmm_constraint_getUsage(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_simgrid_surf_SurfJNI_new_1LmmConstraint(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lmm_constraint *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lmm_constraint *)new lmm_constraint();
  *(lmm_constraint **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_delete_1LmmConstraint(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lmm_constraint *arg1 = (lmm_constraint *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lmm_constraint **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jdouble JNICALL Java_org_simgrid_surf_SurfJNI_LmmVariable_1getValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_) {
  jdouble jresult = 0 ;
  lmm_variable *arg1 = (lmm_variable *) 0 ;
  double result;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(lmm_variable **)&jarg1; 
  result = (double)lmm_variable_getValue(arg1);
  jresult = (jdouble)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_simgrid_surf_SurfJNI_new_1LmmVariable(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  lmm_variable *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (lmm_variable *)new lmm_variable();
  *(lmm_variable **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_delete_1LmmVariable(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  lmm_variable *arg1 = (lmm_variable *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(lmm_variable **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jstring JNICALL Java_org_simgrid_surf_SurfJNI_XbtDict_1getValue(JNIEnv *jenv, jclass jcls, jlong jarg1, jobject jarg1_, jstring jarg2) {
  jstring jresult = 0 ;
  s_xbt_dict *arg1 = (s_xbt_dict *) 0 ;
  char *arg2 = (char *) 0 ;
  char *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  (void)jarg1_;
  arg1 = *(s_xbt_dict **)&jarg1; 
  arg2 = 0;
  if (jarg2) {
    arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
    if (!arg2) return 0;
  }
  result = (char *)s_xbt_dict_getValue(arg1,arg2);
  if (result) jresult = jenv->NewStringUTF((const char *)result);
  if (arg2) jenv->ReleaseStringUTFChars(jarg2, (const char *)arg2);
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_simgrid_surf_SurfJNI_new_1XbtDict(JNIEnv *jenv, jclass jcls) {
  jlong jresult = 0 ;
  s_xbt_dict *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  result = (s_xbt_dict *)new s_xbt_dict();
  *(s_xbt_dict **)&jresult = result; 
  return jresult;
}


SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_delete_1XbtDict(JNIEnv *jenv, jclass jcls, jlong jarg1) {
  s_xbt_dict *arg1 = (s_xbt_dict *) 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = *(s_xbt_dict **)&jarg1; 
  delete arg1;
}


SWIGEXPORT jint JNICALL Java_org_simgrid_surf_SurfJNI_SURF_1ACTION_1READY_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  e_surf_action_state_t result;
  
  (void)jenv;
  (void)jcls;
  result = (e_surf_action_state_t)SURF_ACTION_READY;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_simgrid_surf_SurfJNI_SURF_1RESOURCE_1ON_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  e_surf_resource_state_t result;
  
  (void)jenv;
  (void)jcls;
  result = (e_surf_resource_state_t)SURF_RESOURCE_ON;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_simgrid_surf_SurfJNI_SURF_1RESOURCE_1OFF_1get(JNIEnv *jenv, jclass jcls) {
  jint jresult = 0 ;
  e_surf_resource_state_t result;
  
  (void)jenv;
  (void)jcls;
  result = (e_surf_resource_state_t)SURF_RESOURCE_OFF;
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jlong JNICALL Java_org_simgrid_surf_SurfJNI_CpuModel_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Model **)&baseptr = *(CpuModel **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_simgrid_surf_SurfJNI_Cpu_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Resource **)&baseptr = *(Cpu **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_simgrid_surf_SurfJNI_NetworkLink_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Resource **)&baseptr = *(NetworkLink **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_simgrid_surf_SurfJNI_CpuAction_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Action **)&baseptr = *(CpuAction **)&jarg1;
    return baseptr;
}

SWIGEXPORT jlong JNICALL Java_org_simgrid_surf_SurfJNI_NetworkAction_1SWIGUpcast(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong baseptr = 0;
    (void)jenv;
    (void)jcls;
    *(Action **)&baseptr = *(NetworkAction **)&jarg1;
    return baseptr;
}

SWIGEXPORT void JNICALL Java_org_simgrid_surf_SurfJNI_swig_1module_1init(JNIEnv *jenv, jclass jcls) {
  int i;
  
  static struct {
    const char *method;
    const char *signature;
  } methods[33] = {
    {
      "SwigDirector_Plugin_cpuCreatedCallback", "(Lorg/simgrid/surf/Plugin;J)V" 
    },
    {
      "SwigDirector_Plugin_cpuDestructedCallback", "(Lorg/simgrid/surf/Plugin;J)V" 
    },
    {
      "SwigDirector_Plugin_cpuStateChangedCallback", "(Lorg/simgrid/surf/Plugin;JII)V" 
    },
    {
      "SwigDirector_Plugin_cpuActionStateChangedCallback", "(Lorg/simgrid/surf/Plugin;JII)V" 
    },
    {
      "SwigDirector_Plugin_networkLinkCreatedCallback", "(Lorg/simgrid/surf/Plugin;J)V" 
    },
    {
      "SwigDirector_Plugin_networkLinkDestructedCallback", "(Lorg/simgrid/surf/Plugin;J)V" 
    },
    {
      "SwigDirector_Plugin_networkLinkStateChangedCallback", "(Lorg/simgrid/surf/Plugin;JII)V" 
    },
    {
      "SwigDirector_Plugin_networkActionStateChangedCallback", "(Lorg/simgrid/surf/Plugin;JII)V" 
    },
    {
      "SwigDirector_Plugin_networkCommunicateCallback", "(Lorg/simgrid/surf/Plugin;JJJDD)V" 
    },
    {
      "SwigDirector_CpuModel_shareResources", "(Lorg/simgrid/surf/CpuModel;D)D" 
    },
    {
      "SwigDirector_CpuModel_shareResourcesLazy", "(Lorg/simgrid/surf/CpuModel;D)D" 
    },
    {
      "SwigDirector_CpuModel_shareResourcesFull", "(Lorg/simgrid/surf/CpuModel;D)D" 
    },
    {
      "SwigDirector_CpuModel_updateActionsState", "(Lorg/simgrid/surf/CpuModel;DD)V" 
    },
    {
      "SwigDirector_CpuModel_updateActionsStateLazy", "(Lorg/simgrid/surf/CpuModel;DD)V" 
    },
    {
      "SwigDirector_CpuModel_updateActionsStateFull", "(Lorg/simgrid/surf/CpuModel;DD)V" 
    },
    {
      "SwigDirector_CpuModel_getRunningActionSet", "(Lorg/simgrid/surf/CpuModel;)J" 
    },
    {
      "SwigDirector_CpuModel_addTraces", "(Lorg/simgrid/surf/CpuModel;)V" 
    },
    {
      "SwigDirector_CpuModel_createCpu", "(Lorg/simgrid/surf/CpuModel;Ljava/lang/String;[DIDJIIJJ)J" 
    },
    {
      "SwigDirector_Cpu_isUsed", "(Lorg/simgrid/surf/Cpu;)Z" 
    },
    {
      "SwigDirector_Cpu_getState", "(Lorg/simgrid/surf/Cpu;)I" 
    },
    {
      "SwigDirector_Cpu_updateState", "(Lorg/simgrid/surf/Cpu;JDD)V" 
    },
    {
      "SwigDirector_Cpu_getCurrentPowerPeak", "(Lorg/simgrid/surf/Cpu;)D" 
    },
    {
      "SwigDirector_Cpu_execute", "(Lorg/simgrid/surf/Cpu;D)J" 
    },
    {
      "SwigDirector_Cpu_sleep", "(Lorg/simgrid/surf/Cpu;D)J" 
    },
    {
      "SwigDirector_Cpu_getCore", "(Lorg/simgrid/surf/Cpu;)I" 
    },
    {
      "SwigDirector_Cpu_getSpeed", "(Lorg/simgrid/surf/Cpu;D)D" 
    },
    {
      "SwigDirector_Cpu_getAvailableSpeed", "(Lorg/simgrid/surf/Cpu;)D" 
    },
    {
      "SwigDirector_Cpu_getPowerPeakAt", "(Lorg/simgrid/surf/Cpu;I)D" 
    },
    {
      "SwigDirector_Cpu_getNbPstates", "(Lorg/simgrid/surf/Cpu;)I" 
    },
    {
      "SwigDirector_Cpu_setPowerPeakAt", "(Lorg/simgrid/surf/Cpu;I)V" 
    },
    {
      "SwigDirector_CpuAction_getRemains", "(Lorg/simgrid/surf/CpuAction;)D" 
    },
    {
      "SwigDirector_CpuAction_setPriority", "(Lorg/simgrid/surf/CpuAction;D)V" 
    },
    {
      "SwigDirector_CpuAction_setState", "(Lorg/simgrid/surf/CpuAction;I)V" 
    }
  };
  Swig::jclass_SurfJNI = (jclass) jenv->NewGlobalRef(jcls);
  if (!Swig::jclass_SurfJNI) return;
  for (i = 0; i < (int) (sizeof(methods)/sizeof(methods[0])); ++i) {
    Swig::director_methids[i] = jenv->GetStaticMethodID(jcls, methods[i].method, methods[i].signature);
    if (!Swig::director_methids[i]) return;
  }
}


#ifdef __cplusplus
}
#endif

