/* SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Copyright:
 *   2020      Evan Nemerson <evan@nemerson.com>
 *   2020      Himanshi Mathur <himanshi18037@iiitd.ac.in>
 */

#define SIMDE_TEST_X86_AVX512_INSN cmp

#include <test/x86/avx512/test-avx512.h>
#include <simde/x86/avx512/set.h>
#include <simde/x86/avx512/cmp.h>

#if !defined(SIMDE_NATIVE_ALIASES_TESTING)
static int
test_simde_mm512_cmp_ps_mask (SIMDE_MUNIT_TEST_ARGS) {
  static const struct {
    const simde_float32 a[16];
    const simde_float32 b[16];
    const int imm8;
    const simde__mmask16 r;
  } test_vec[] = {
    { { SIMDE_FLOAT32_C(   662.74), SIMDE_FLOAT32_C(  -296.50), SIMDE_FLOAT32_C(    51.89), SIMDE_FLOAT32_C(  -877.47),
        SIMDE_FLOAT32_C(   872.85), SIMDE_FLOAT32_C(  -965.85), SIMDE_FLOAT32_C(  -688.43), SIMDE_FLOAT32_C(   580.42),
        SIMDE_FLOAT32_C(   433.23), SIMDE_FLOAT32_C(   579.01), SIMDE_FLOAT32_C(   251.51), SIMDE_FLOAT32_C(  -341.82),
        SIMDE_FLOAT32_C(  -712.66), SIMDE_FLOAT32_C(  -533.80), SIMDE_FLOAT32_C(   415.61), SIMDE_FLOAT32_C(   350.44) },
      { SIMDE_FLOAT32_C(  -243.73), SIMDE_FLOAT32_C(  -899.82), SIMDE_FLOAT32_C(  -876.74), SIMDE_FLOAT32_C(   548.84),
        SIMDE_FLOAT32_C(   112.62), SIMDE_FLOAT32_C(   228.46), SIMDE_FLOAT32_C(   592.01), SIMDE_FLOAT32_C(  -633.78),
        SIMDE_FLOAT32_C(   405.27), SIMDE_FLOAT32_C(   447.83), SIMDE_FLOAT32_C(  -706.03), SIMDE_FLOAT32_C(   628.46),
        SIMDE_FLOAT32_C(  -379.69), SIMDE_FLOAT32_C(   592.13), SIMDE_FLOAT32_C(   228.45), SIMDE_FLOAT32_C(  -716.95) },
       INT32_C(           0),
      UINT16_C(    0) },
    { { SIMDE_FLOAT32_C(  -704.37), SIMDE_FLOAT32_C(  -719.66), SIMDE_FLOAT32_C(  -594.42), SIMDE_FLOAT32_C(  -831.52),
        SIMDE_FLOAT32_C(  -685.51), SIMDE_FLOAT32_C(  -282.86), SIMDE_FLOAT32_C(   748.90), SIMDE_FLOAT32_C(   747.73),
        SIMDE_FLOAT32_C(  -703.85), SIMDE_FLOAT32_C(     0.41), SIMDE_FLOAT32_C(  -594.10), SIMDE_FLOAT32_C(  -416.51),
        SIMDE_FLOAT32_C(   466.61), SIMDE_FLOAT32_C(   821.52), SIMDE_FLOAT32_C(   933.94), SIMDE_FLOAT32_C(  -777.12) },
      { SIMDE_FLOAT32_C(   921.70), SIMDE_FLOAT32_C(  -942.80), SIMDE_FLOAT32_C(   771.72), SIMDE_FLOAT32_C(    34.32),
        SIMDE_FLOAT32_C(   285.66), SIMDE_FLOAT32_C(   363.73), SIMDE_FLOAT32_C(   400.54), SIMDE_FLOAT32_C(  -309.07),
        SIMDE_FLOAT32_C(  -188.44), SIMDE_FLOAT32_C(   694.50), SIMDE_FLOAT32_C(  -680.61), SIMDE_FLOAT32_C(   431.87),
        SIMDE_FLOAT32_C(   286.63), SIMDE_FLOAT32_C(   547.84), SIMDE_FLOAT32_C(   714.92), SIMDE_FLOAT32_C(   582.26) },
       INT32_C(           1),
      UINT16_C(35645) },
    { { SIMDE_FLOAT32_C(   828.18), SIMDE_FLOAT32_C(  -879.50), SIMDE_FLOAT32_C(   750.74), SIMDE_FLOAT32_C(  -857.33),
        SIMDE_FLOAT32_C(  -162.36), SIMDE_FLOAT32_C(   499.63), SIMDE_FLOAT32_C(   890.40), SIMDE_FLOAT32_C(   133.79),
        SIMDE_FLOAT32_C(  -499.96), SIMDE_FLOAT32_C(  -703.70), SIMDE_FLOAT32_C(   717.28), SIMDE_FLOAT32_C(   966.65),
        SIMDE_FLOAT32_C(  -882.18), SIMDE_FLOAT32_C(   651.22), SIMDE_FLOAT32_C(  -810.47), SIMDE_FLOAT32_C(  -960.48) },
      { SIMDE_FLOAT32_C(   708.42), SIMDE_FLOAT32_C(   961.25), SIMDE_FLOAT32_C(    73.84), SIMDE_FLOAT32_C(    -5.91),
        SIMDE_FLOAT32_C(   324.99), SIMDE_FLOAT32_C(  -525.63), SIMDE_FLOAT32_C(   685.02), SIMDE_FLOAT32_C(  -863.45),
        SIMDE_FLOAT32_C(  -831.12), SIMDE_FLOAT32_C(  -995.59), SIMDE_FLOAT32_C(   568.42), SIMDE_FLOAT32_C(   455.51),
        SIMDE_FLOAT32_C(   552.25), SIMDE_FLOAT32_C(   283.34), SIMDE_FLOAT32_C(    37.76), SIMDE_FLOAT32_C(   380.43) },
       INT32_C(           2),
      UINT16_C(53274) },
    { { SIMDE_FLOAT32_C(   403.83), SIMDE_FLOAT32_C(  -211.50), SIMDE_FLOAT32_C(   523.10), SIMDE_FLOAT32_C(  -758.53),
        SIMDE_FLOAT32_C(  -711.87), SIMDE_FLOAT32_C(   413.50), SIMDE_FLOAT32_C(   375.26), SIMDE_FLOAT32_C(  -211.83),
        SIMDE_FLOAT32_C(   709.80), SIMDE_FLOAT32_C(    92.55), SIMDE_FLOAT32_C(  -245.18), SIMDE_FLOAT32_C(   827.62),
        SIMDE_FLOAT32_C(  -256.23), SIMDE_FLOAT32_C(   -55.64), SIMDE_FLOAT32_C(   867.14), SIMDE_FLOAT32_C(  -547.81) },
      { SIMDE_FLOAT32_C(   -94.39), SIMDE_FLOAT32_C(   -59.02), SIMDE_FLOAT32_C(   446.28), SIMDE_FLOAT32_C(  -769.41),
        SIMDE_FLOAT32_C(   415.35), SIMDE_FLOAT32_C(   131.30), SIMDE_FLOAT32_C(  -632.86), SIMDE_FLOAT32_C(   584.23),
        SIMDE_FLOAT32_C(   135.71), SIMDE_FLOAT32_C(   935.56), SIMDE_FLOAT32_C(    39.74), SIMDE_FLOAT32_C(  -312.04),
        SIMDE_FLOAT32_C(   218.89), SIMDE_FLOAT32_C(  -922.50), SIMDE_FLOAT32_C(  -931.62), SIMDE_FLOAT32_C(  -377.28) },
       INT32_C(           3),
      UINT16_C(    0) },
    { { SIMDE_FLOAT32_C(  -134.00), SIMDE_FLOAT32_C(   591.48), SIMDE_FLOAT32_C(  -135.81), SIMDE_FLOAT32_C(   154.13),
        SIMDE_FLOAT32_C(     4.98), SIMDE_FLOAT32_C(  -760.55), SIMDE_FLOAT32_C(   942.30), SIMDE_FLOAT32_C(  -285.22),
        SIMDE_FLOAT32_C(   332.00), SIMDE_FLOAT32_C(  -302.88), SIMDE_FLOAT32_C(  -457.60), SIMDE_FLOAT32_C(  -924.23),
        SIMDE_FLOAT32_C(   641.48), SIMDE_FLOAT32_C(  -590.45), SIMDE_FLOAT32_C(  -472.04), SIMDE_FLOAT32_C(  -452.91) },
      { SIMDE_FLOAT32_C(   350.53), SIMDE_FLOAT32_C(   974.23), SIMDE_FLOAT32_C(  -222.32), SIMDE_FLOAT32_C(  -234.12),
        SIMDE_FLOAT32_C(   105.53), SIMDE_FLOAT32_C(   144.82), SIMDE_FLOAT32_C(  -649.88), SIMDE_FLOAT32_C(  -758.76),
        SIMDE_FLOAT32_C(    80.38), SIMDE_FLOAT32_C(   389.85), SIMDE_FLOAT32_C(   -70.81), SIMDE_FLOAT32_C(  -700.73),
        SIMDE_FLOAT32_C(   467.35), SIMDE_FLOAT32_C(    -2.42), SIMDE_FLOAT32_C(   -78.01), SIMDE_FLOAT32_C(  -666.65) },
       INT32_C(           4),
           UINT16_MAX },
    { { SIMDE_FLOAT32_C(  -410.94), SIMDE_FLOAT32_C(   786.18), SIMDE_FLOAT32_C(   487.47), SIMDE_FLOAT32_C(   594.03),
        SIMDE_FLOAT32_C(  -974.37), SIMDE_FLOAT32_C(   429.77), SIMDE_FLOAT32_C(  -691.18), SIMDE_FLOAT32_C(   357.63),
        SIMDE_FLOAT32_C(  -873.11), SIMDE_FLOAT32_C(  -148.78), SIMDE_FLOAT32_C(   433.40), SIMDE_FLOAT32_C(   768.37),
        SIMDE_FLOAT32_C(   260.77), SIMDE_FLOAT32_C(   961.36), SIMDE_FLOAT32_C(  -684.54), SIMDE_FLOAT32_C(  -388.70) },
      { SIMDE_FLOAT32_C(   935.59), SIMDE_FLOAT32_C(    93.14), SIMDE_FLOAT32_C(   377.18), SIMDE_FLOAT32_C(    41.12),
        SIMDE_FLOAT32_C(  -762.04), SIMDE_FLOAT32_C(   727.30), SIMDE_FLOAT32_C(   282.36), SIMDE_FLOAT32_C(   318.33),
        SIMDE_FLOAT32_C(   117.15), SIMDE_FLOAT32_C(  -788.45), SIMDE_FLOAT32_C(   617.60), SIMDE_FLOAT32_C(  -415.50),
        SIMDE_FLOAT32_C(   209.13), SIMDE_FLOAT32_C(  -460.41), SIMDE_FLOAT32_C(   -82.16), SIMDE_FLOAT32_C(   798.18) },
       INT32_C(           5),
      UINT16_C(14990) },
    { { SIMDE_FLOAT32_C(  -674.23), SIMDE_FLOAT32_C(  -594.68), SIMDE_FLOAT32_C(   392.22), SIMDE_FLOAT32_C(  -648.60),
        SIMDE_FLOAT32_C(   835.09), SIMDE_FLOAT32_C(   701.04), SIMDE_FLOAT32_C(   709.03), SIMDE_FLOAT32_C(   961.98),
        SIMDE_FLOAT32_C(  -447.74), SIMDE_FLOAT32_C(   142.43), SIMDE_FLOAT32_C(   730.35), SIMDE_FLOAT32_C(   813.03),
        SIMDE_FLOAT32_C(   103.79), SIMDE_FLOAT32_C(  -954.19), SIMDE_FLOAT32_C(  -575.67), SIMDE_FLOAT32_C(    39.38) },
      { SIMDE_FLOAT32_C(   138.95), SIMDE_FLOAT32_C(   801.51), SIMDE_FLOAT32_C(  -919.50), SIMDE_FLOAT32_C(   376.91),
        SIMDE_FLOAT32_C(   528.81), SIMDE_FLOAT32_C(   362.86), SIMDE_FLOAT32_C(  -304.76), SIMDE_FLOAT32_C(  -354.04),
        SIMDE_FLOAT32_C(   574.42), SIMDE_FLOAT32_C(  -687.16), SIMDE_FLOAT32_C(   230.46), SIMDE_FLOAT32_C(  -216.45),
        SIMDE_FLOAT32_C(  -147.57), SIMDE_FLOAT32_C(  -851.70), SIMDE_FLOAT32_C(  -418.27), SIMDE_FLOAT32_C(   178.19) },
       INT32_C(           6),
      UINT16_C( 7924) },
    { { SIMDE_FLOAT32_C(  -446.38), SIMDE_FLOAT32_C(   973.95), SIMDE_FLOAT32_C(   529.59), SIMDE_FLOAT32_C(  -611.29),
        SIMDE_FLOAT32_C(   674.99), SIMDE_FLOAT32_C(   238.63), SIMDE_FLOAT32_C(  -649.31), SIMDE_FLOAT32_C(  -772.76),
        SIMDE_FLOAT32_C(  -618.94), SIMDE_FLOAT32_C(  -918.96), SIMDE_FLOAT32_C(  -959.73), SIMDE_FLOAT32_C(   484.85),
        SIMDE_FLOAT32_C(  -873.15), SIMDE_FLOAT32_C(  -535.40), SIMDE_FLOAT32_C(  -475.77), SIMDE_FLOAT32_C(   265.80) },
      { SIMDE_FLOAT32_C(  -733.89), SIMDE_FLOAT32_C(  -395.27), SIMDE_FLOAT32_C(  -357.30), SIMDE_FLOAT32_C(   794.92),
        SIMDE_FLOAT32_C(   967.60), SIMDE_FLOAT32_C(   337.94), SIMDE_FLOAT32_C(  -559.13), SIMDE_FLOAT32_C(   542.02),
        SIMDE_FLOAT32_C(   650.78), SIMDE_FLOAT32_C(   671.33), SIMDE_FLOAT32_C(  -674.44), SIMDE_FLOAT32_C(  -496.79),
        SIMDE_FLOAT32_C(   819.63), SIMDE_FLOAT32_C(   -92.71), SIMDE_FLOAT32_C(   681.40), SIMDE_FLOAT32_C(  -626.75) },
       INT32_C(           7),
           UINT16_MAX },
    { { SIMDE_FLOAT32_C(  -118.76), SIMDE_FLOAT32_C(   210.99), SIMDE_FLOAT32_C(  -238.04), SIMDE_FLOAT32_C(  -443.77),
        SIMDE_FLOAT32_C(  -550.38), SIMDE_FLOAT32_C(   112.65), SIMDE_FLOAT32_C(  -216.52), SIMDE_FLOAT32_C(  -169.32),
        SIMDE_FLOAT32_C(   193.68), SIMDE_FLOAT32_C(  -176.25), SIMDE_FLOAT32_C(  -684.48), SIMDE_FLOAT32_C(   320.53),
        SIMDE_FLOAT32_C(   288.35), SIMDE_FLOAT32_C(  -160.25), SIMDE_FLOAT32_C(  -413.67), SIMDE_FLOAT32_C(   554.45) },
      { SIMDE_FLOAT32_C(   444.49), SIMDE_FLOAT32_C(   229.03), SIMDE_FLOAT32_C(   349.37), SIMDE_FLOAT32_C(   412.09),
        SIMDE_FLOAT32_C(  -433.02), SIMDE_FLOAT32_C(   790.25), SIMDE_FLOAT32_C(   -45.90), SIMDE_FLOAT32_C(  -782.24),
        SIMDE_FLOAT32_C(   461.58), SIMDE_FLOAT32_C(   279.66), SIMDE_FLOAT32_C(  -279.03), SIMDE_FLOAT32_C(   281.21),
        SIMDE_FLOAT32_C(  -813.04), SIMDE_FLOAT32_C(  -597.63), SIMDE_FLOAT32_C(   654.46), SIMDE_FLOAT32_C(    68.20) },
       INT32_C(           8),
      UINT16_C(    0) },
    { { SIMDE_FLOAT32_C(   613.36), SIMDE_FLOAT32_C(  -583.58), SIMDE_FLOAT32_C(   624.43), SIMDE_FLOAT32_C(  -937.02),
        SIMDE_FLOAT32_C(   529.07), SIMDE_FLOAT32_C(  -592.09), SIMDE_FLOAT32_C(  -106.35), SIMDE_FLOAT32_C(  -277.25),
        SIMDE_FLOAT32_C(   231.66), SIMDE_FLOAT32_C(   209.18), SIMDE_FLOAT32_C(  -956.71), SIMDE_FLOAT32_C(  -480.00),
        SIMDE_FLOAT32_C(  -951.07), SIMDE_FLOAT32_C(  -370.38), SIMDE_FLOAT32_C(  -925.54), SIMDE_FLOAT32_C(   493.42) },
      { SIMDE_FLOAT32_C(   858.65), SIMDE_FLOAT32_C(   423.83), SIMDE_FLOAT32_C(   -94.50), SIMDE_FLOAT32_C(  -574.37),
        SIMDE_FLOAT32_C(   214.07), SIMDE_FLOAT32_C(   859.61), SIMDE_FLOAT32_C(  -356.61), SIMDE_FLOAT32_C(  -324.35),
        SIMDE_FLOAT32_C(   139.27), SIMDE_FLOAT32_C(   364.36), SIMDE_FLOAT32_C(   956.86), SIMDE_FLOAT32_C(   326.23),
        SIMDE_FLOAT32_C(   766.72), SIMDE_FLOAT32_C(   611.33), SIMDE_FLOAT32_C(  -605.57), SIMDE_FLOAT32_C(   380.08) },
       INT32_C(           9),
      UINT16_C(32299) },
    { { SIMDE_FLOAT32_C(  -972.25), SIMDE_FLOAT32_C(  -981.14), SIMDE_FLOAT32_C(   443.06), SIMDE_FLOAT32_C(   556.82),
        SIMDE_FLOAT32_C(  -573.23), SIMDE_FLOAT32_C(  -663.28), SIMDE_FLOAT32_C(  -720.43), SIMDE_FLOAT32_C(   658.42),
        SIMDE_FLOAT32_C(   545.89), SIMDE_FLOAT32_C(  -677.14), SIMDE_FLOAT32_C(  -821.57), SIMDE_FLOAT32_C(   594.83),
        SIMDE_FLOAT32_C(   -47.52), SIMDE_FLOAT32_C(  -747.12), SIMDE_FLOAT32_C(    88.25), SIMDE_FLOAT32_C(  -188.87) },
      { SIMDE_FLOAT32_C(   676.71), SIMDE_FLOAT32_C(   993.75), SIMDE_FLOAT32_C(   236.76), SIMDE_FLOAT32_C(  -109.21),
        SIMDE_FLOAT32_C(   853.36), SIMDE_FLOAT32_C(   880.15), SIMDE_FLOAT32_C(   566.44), SIMDE_FLOAT32_C(    -7.37),
        SIMDE_FLOAT32_C(   244.51), SIMDE_FLOAT32_C(   523.30), SIMDE_FLOAT32_C(  -681.15), SIMDE_FLOAT32_C(    11.24),
        SIMDE_FLOAT32_C(   134.63), SIMDE_FLOAT32_C(  -286.72), SIMDE_FLOAT32_C(  -608.68), SIMDE_FLOAT32_C(   162.38) },
       INT32_C(          10),
      UINT16_C(46707) },
    { { SIMDE_FLOAT32_C(  -267.86), SIMDE_FLOAT32_C(   834.38), SIMDE_FLOAT32_C(  -280.80), SIMDE_FLOAT32_C(   158.91),
        SIMDE_FLOAT32_C(  -828.90), SIMDE_FLOAT32_C(    -1.23), SIMDE_FLOAT32_C(  -182.67), SIMDE_FLOAT32_C(   716.99),
        SIMDE_FLOAT32_C(   321.63), SIMDE_FLOAT32_C(    -4.24), SIMDE_FLOAT32_C(   311.82), SIMDE_FLOAT32_C(  -725.89),
        SIMDE_FLOAT32_C(   248.64), SIMDE_FLOAT32_C(  -599.93), SIMDE_FLOAT32_C(    85.24), SIMDE_FLOAT32_C(   -74.64) },
      { SIMDE_FLOAT32_C(  -606.18), SIMDE_FLOAT32_C(  -677.99), SIMDE_FLOAT32_C(   816.14), SIMDE_FLOAT32_C(  -752.82),
        SIMDE_FLOAT32_C(  -797.84), SIMDE_FLOAT32_C(   382.58), SIMDE_FLOAT32_C(   239.80), SIMDE_FLOAT32_C(   446.68),
        SIMDE_FLOAT32_C(   -94.12), SIMDE_FLOAT32_C(   558.66), SIMDE_FLOAT32_C(  -542.09), SIMDE_FLOAT32_C(  -959.49),
        SIMDE_FLOAT32_C(  -728.06), SIMDE_FLOAT32_C(  -150.77), SIMDE_FLOAT32_C(   202.89), SIMDE_FLOAT32_C(     4.08) },
       INT32_C(          11),
      UINT16_C(    0) },
    { { SIMDE_FLOAT32_C(  -316.38), SIMDE_FLOAT32_C(   922.09), SIMDE_FLOAT32_C(  -837.02), SIMDE_FLOAT32_C(  -145.29),
        SIMDE_FLOAT32_C(   -79.14), SIMDE_FLOAT32_C(   -19.68), SIMDE_FLOAT32_C(  -428.29), SIMDE_FLOAT32_C(  -757.51),
        SIMDE_FLOAT32_C(   976.07), SIMDE_FLOAT32_C(   883.53), SIMDE_FLOAT32_C(  -483.40), SIMDE_FLOAT32_C(   224.72),
        SIMDE_FLOAT32_C(  -716.41), SIMDE_FLOAT32_C(   601.84), SIMDE_FLOAT32_C(  -849.93), SIMDE_FLOAT32_C(  -322.59) },
      { SIMDE_FLOAT32_C(   923.85), SIMDE_FLOAT32_C(   966.22), SIMDE_FLOAT32_C(   -75.41), SIMDE_FLOAT32_C(  -873.98),
        SIMDE_FLOAT32_C(   348.80), SIMDE_FLOAT32_C(  -835.61), SIMDE_FLOAT32_C(   572.69), SIMDE_FLOAT32_C(  -745.32),
        SIMDE_FLOAT32_C(   723.05), SIMDE_FLOAT32_C(  -969.40), SIMDE_FLOAT32_C(  -704.81), SIMDE_FLOAT32_C(   994.98),
        SIMDE_FLOAT32_C(  -120.16), SIMDE_FLOAT32_C(   498.08), SIMDE_FLOAT32_C(    -0.94), SIMDE_FLOAT32_C(   563.45) },
       INT32_C(          12),
           UINT16_MAX },
    { { SIMDE_FLOAT32_C(   420.16), SIMDE_FLOAT32_C(   162.04), SIMDE_FLOAT32_C(  -581.83), SIMDE_FLOAT32_C(  -658.98),
        SIMDE_FLOAT32_C(  -857.64), SIMDE_FLOAT32_C(   -10.13), SIMDE_FLOAT32_C(  -416.49), SIMDE_FLOAT32_C(  -881.56),
        SIMDE_FLOAT32_C(  -126.60), SIMDE_FLOAT32_C(   100.10), SIMDE_FLOAT32_C(   343.15), SIMDE_FLOAT32_C(   156.99),
        SIMDE_FLOAT32_C(  -298.05), SIMDE_FLOAT32_C(   493.23), SIMDE_FLOAT32_C(   834.41), SIMDE_FLOAT32_C(  -374.20) },
      { SIMDE_FLOAT32_C(   459.44), SIMDE_FLOAT32_C(  -241.01), SIMDE_FLOAT32_C(  -248.18), SIMDE_FLOAT32_C(  -191.76),
        SIMDE_FLOAT32_C(   -76.61), SIMDE_FLOAT32_C(  -675.49), SIMDE_FLOAT32_C(    62.92), SIMDE_FLOAT32_C(  -353.57),
        SIMDE_FLOAT32_C(  -644.89), SIMDE_FLOAT32_C(   358.11), SIMDE_FLOAT32_C(  -358.58), SIMDE_FLOAT32_C(   234.95),
        SIMDE_FLOAT32_C(  -143.82), SIMDE_FLOAT32_C(   640.48), SIMDE_FLOAT32_C(  -201.60), SIMDE_FLOAT32_C(  -723.66) },
       INT32_C(          13),
      UINT16_C(50466) },
    { { SIMDE_FLOAT32_C(  -197.48), SIMDE_FLOAT32_C(   216.57), SIMDE_FLOAT32_C(  -382.64), SIMDE_FLOAT32_C(   -55.12),
        SIMDE_FLOAT32_C(  -793.56), SIMDE_FLOAT32_C(   200.87), SIMDE_FLOAT32_C(    63.32), SIMDE_FLOAT32_C(    79.84),
        SIMDE_FLOAT32_C(  -699.03), SIMDE_FLOAT32_C(  -593.53), SIMDE_FLOAT32_C(  -763.16), SIMDE_FLOAT32_C(     2.92),
        SIMDE_FLOAT32_C(   899.70), SIMDE_FLOAT32_C(  -928.76), SIMDE_FLOAT32_C(   628.72), SIMDE_FLOAT32_C(   359.14) },
      { SIMDE_FLOAT32_C(  -169.76), SIMDE_FLOAT32_C(  -619.46), SIMDE_FLOAT32_C(  -832.62), SIMDE_FLOAT32_C(   753.63),
        SIMDE_FLOAT32_C(  -294.96), SIMDE_FLOAT32_C(   230.30), SIMDE_FLOAT32_C(  -599.94), SIMDE_FLOAT32_C(    60.15),
        SIMDE_FLOAT32_C(  -411.60), SIMDE_FLOAT32_C(    41.48), SIMDE_FLOAT32_C(  -704.90), SIMDE_FLOAT32_C(   444.59),
        SIMDE_FLOAT32_C(  -318.04), SIMDE_FLOAT32_C(    93.51), SIMDE_FLOAT32_C(   720.93), SIMDE_FLOAT32_C(   484.48) },
       INT32_C(          14),
      UINT16_C( 4294) },
    { { SIMDE_FLOAT32_C(  -689.92), SIMDE_FLOAT32_C(  -661.71), SIMDE_FLOAT32_C(  -570.64), SIMDE_FLOAT32_C(  -483.48),
        SIMDE_FLOAT32_C(   539.16), SIMDE_FLOAT32_C(   492.68), SIMDE_FLOAT32_C(   596.36), SIMDE_FLOAT32_C(   840.13),
        SIMDE_FLOAT32_C(   899.15), SIMDE_FLOAT32_C(   833.20), SIMDE_FLOAT32_C(  -156.95), SIMDE_FLOAT32_C(   798.85),
        SIMDE_FLOAT32_C(   904.44), SIMDE_FLOAT32_C(  -528.23), SIMDE_FLOAT32_C(   157.99), SIMDE_FLOAT32_C(  -265.32) },
      { SIMDE_FLOAT32_C(  -147.69), SIMDE_FLOAT32_C(   325.37), SIMDE_FLOAT32_C(  -511.69), SIMDE_FLOAT32_C(   557.35),
        SIMDE_FLOAT32_C(  -444.33), SIMDE_FLOAT32_C(  -111.63), SIMDE_FLOAT32_C(  -382.50), SIMDE_FLOAT32_C(   144.07),
        SIMDE_FLOAT32_C(   929.85), SIMDE_FLOAT32_C(   -87.39), SIMDE_FLOAT32_C(  -411.34), SIMDE_FLOAT32_C(  -388.19),
        SIMDE_FLOAT32_C(  -993.88), SIMDE_FLOAT32_C(  -690.41), SIMDE_FLOAT32_C(  -903.71), SIMDE_FLOAT32_C(  -683.81) },
       INT32_C(          15),
           UINT16_MAX },
    { { SIMDE_FLOAT32_C(  -352.12), SIMDE_FLOAT32_C(  -474.35), SIMDE_FLOAT32_C(  -167.29), SIMDE_FLOAT32_C(  -812.96),
        SIMDE_FLOAT32_C(  -981.67), SIMDE_FLOAT32_C(  -570.92), SIMDE_FLOAT32_C(  -972.83), SIMDE_FLOAT32_C(   917.49),
        SIMDE_FLOAT32_C(  -737.72), SIMDE_FLOAT32_C(  -129.78), SIMDE_FLOAT32_C(   716.34), SIMDE_FLOAT32_C(  -833.28),
        SIMDE_FLOAT32_C(   341.99), SIMDE_FLOAT32_C(  -125.67), SIMDE_FLOAT32_C(   -98.59), SIMDE_FLOAT32_C(  -805.70) },
      { SIMDE_FLOAT32_C(  -800.30), SIMDE_FLOAT32_C(   389.72), SIMDE_FLOAT32_C(   751.65), SIMDE_FLOAT32_C(  -244.63),
        SIMDE_FLOAT32_C(  -721.91), SIMDE_FLOAT32_C(  -630.84), SIMDE_FLOAT32_C(   899.44), SIMDE_FLOAT32_C(  -792.06),
        SIMDE_FLOAT32_C(   281.76), SIMDE_FLOAT32_C(  -511.90), SIMDE_FLOAT32_C(  -180.26), SIMDE_FLOAT32_C(   287.88),
        SIMDE_FLOAT32_C(  -202.31), SIMDE_FLOAT32_C(   -83.97), SIMDE_FLOAT32_C(   604.08), SIMDE_FLOAT32_C(   445.56) },
       INT32_C(          16),
      UINT16_C(    0) },
    { { SIMDE_FLOAT32_C(   441.68), SIMDE_FLOAT32_C(  -563.21), SIMDE_FLOAT32_C(   632.60), SIMDE_FLOAT32_C(   460.01),
        SIMDE_FLOAT32_C(  -134.13), SIMDE_FLOAT32_C(   659.78), SIMDE_FLOAT32_C(   377.50), SIMDE_FLOAT32_C(   128.15),
        SIMDE_FLOAT32_C(  -470.00), SIMDE_FLOAT32_C(    93.84), SIMDE_FLOAT32_C(   294.87), SIMDE_FLOAT32_C(   871.99),
        SIMDE_FLOAT32_C(   968.16), SIMDE_FLOAT32_C(  -803.72), SIMDE_FLOAT32_C(  -933.71), SIMDE_FLOAT32_C(  -832.14) },
      { SIMDE_FLOAT32_C(   586.00), SIMDE_FLOAT32_C(   817.94), SIMDE_FLOAT32_C(   -76.77), SIMDE_FLOAT32_C(   864.08),
        SIMDE_FLOAT32_C(  -812.90), SIMDE_FLOAT32_C(  -177.33), SIMDE_FLOAT32_C(  -927.98), SIMDE_FLOAT32_C(   468.86),
        SIMDE_FLOAT32_C(   310.77), SIMDE_FLOAT32_C(  -108.24), SIMDE_FLOAT32_C(  -243.26), SIMDE_FLOAT32_C(  -891.55),
        SIMDE_FLOAT32_C(   807.79), SIMDE_FLOAT32_C(  -639.18), SIMDE_FLOAT32_C(   554.02), SIMDE_FLOAT32_C(   249.47) },
       INT32_C(          17),
      UINT16_C(57739) },
    { { SIMDE_FLOAT32_C(  -202.39), SIMDE_FLOAT32_C(   186.62), SIMDE_FLOAT32_C(  -290.52), SIMDE_FLOAT32_C(   663.47),
        SIMDE_FLOAT32_C(  -153.60), SIMDE_FLOAT32_C(  -913.02), SIMDE_FLOAT32_C(  -208.38), SIMDE_FLOAT32_C(   376.40),
        SIMDE_FLOAT32_C(   180.82), SIMDE_FLOAT32_C(  -913.51), SIMDE_FLOAT32_C(   248.39), SIMDE_FLOAT32_C(   148.98),
        SIMDE_FLOAT32_C(  -717.23), SIMDE_FLOAT32_C(   314.68), SIMDE_FLOAT32_C(   316.85), SIMDE_FLOAT32_C(   868.77) },
      { SIMDE_FLOAT32_C(   132.62), SIMDE_FLOAT32_C(  -759.92), SIMDE_FLOAT32_C(   732.85), SIMDE_FLOAT32_C(   319.72),
        SIMDE_FLOAT32_C(    62.75), SIMDE_FLOAT32_C(   804.87), SIMDE_FLOAT32_C(  -211.42), SIMDE_FLOAT32_C(  -626.48),
        SIMDE_FLOAT32_C(  -303.37), SIMDE_FLOAT32_C(   545.32), SIMDE_FLOAT32_C(  -518.02), SIMDE_FLOAT32_C(  -495.58),
        SIMDE_FLOAT32_C(   906.14), SIMDE_FLOAT32_C(  -964.00), SIMDE_FLOAT32_C(   753.90), SIMDE_FLOAT32_C(  -296.25) },
       INT32_C(          18),
      UINT16_C(21045) },
    { { SIMDE_FLOAT32_C(   222.62), SIMDE_FLOAT32_C(  -536.62), SIMDE_FLOAT32_C(  -632.78), SIMDE_FLOAT32_C(  -930.98),
        SIMDE_FLOAT32_C(  -449.64), SIMDE_FLOAT32_C(   158.84), SIMDE_FLOAT32_C(   445.42), SIMDE_FLOAT32_C(   731.18),
        SIMDE_FLOAT32_C(   245.34), SIMDE_FLOAT32_C(  -306.20), SIMDE_FLOAT32_C(  -119.84), SIMDE_FLOAT32_C(   528.11),
        SIMDE_FLOAT32_C(  -991.52), SIMDE_FLOAT32_C(  -802.99), SIMDE_FLOAT32_C(   396.88), SIMDE_FLOAT32_C(   141.10) },
      { SIMDE_FLOAT32_C(  -562.91), SIMDE_FLOAT32_C(   129.73), SIMDE_FLOAT32_C(  -539.18), SIMDE_FLOAT32_C(   499.84),
        SIMDE_FLOAT32_C(   -65.40), SIMDE_FLOAT32_C(   249.40), SIMDE_FLOAT32_C(   873.36), SIMDE_FLOAT32_C(   631.23),
        SIMDE_FLOAT32_C(  -205.28), SIMDE_FLOAT32_C(  -644.66), SIMDE_FLOAT32_C(  -864.35), SIMDE_FLOAT32_C(  -299.14),
        SIMDE_FLOAT32_C(  -608.67), SIMDE_FLOAT32_C(   889.55), SIMDE_FLOAT32_C(   404.61), SIMDE_FLOAT32_C(   613.95) },
       INT32_C(          19),
      UINT16_C(    0) },
    { { SIMDE_FLOAT32_C(  -647.07), SIMDE_FLOAT32_C(   771.83), SIMDE_FLOAT32_C(   682.97), SIMDE_FLOAT32_C(   -96.71),
        SIMDE_FLOAT32_C(   -69.32), SIMDE_FLOAT32_C(   128.39), SIMDE_FLOAT32_C(  -365.53), SIMDE_FLOAT32_C(  -823.99),
        SIMDE_FLOAT32_C(   822.19), SIMDE_FLOAT32_C(   514.63), SIMDE_FLOAT32_C(   704.12), SIMDE_FLOAT32_C(   830.67),
        SIMDE_FLOAT32_C(   711.64), SIMDE_FLOAT32_C(   101.00), SIMDE_FLOAT32_C(   -28.22), SIMDE_FLOAT32_C(  -851.27) },
      { SIMDE_FLOAT32_C(  -769.27), SIMDE_FLOAT32_C(   432.60), SIMDE_FLOAT32_C(   648.57), SIMDE_FLOAT32_C(   165.32),
        SIMDE_FLOAT32_C(  -318.00), SIMDE_FLOAT32_C(   521.93), SIMDE_FLOAT32_C(  -203.45), SIMDE_FLOAT32_C(   476.73),
        SIMDE_FLOAT32_C(   877.27), SIMDE_FLOAT32_C(   -67.79), SIMDE_FLOAT32_C(  -822.41), SIMDE_FLOAT32_C(  -731.40),
        SIMDE_FLOAT32_C(  -178.24), SIMDE_FLOAT32_C(   582.20), SIMDE_FLOAT32_C(   882.55), SIMDE_FLOAT32_C(   174.68) },
       INT32_C(          20),
           UINT16_MAX },
    { { SIMDE_FLOAT32_C(   354.04), SIMDE_FLOAT32_C(   565.52), SIMDE_FLOAT32_C(  -922.02), SIMDE_FLOAT32_C(  -715.29),
        SIMDE_FLOAT32_C(  -306.09), SIMDE_FLOAT32_C(  -287.55), SIMDE_FLOAT32_C(  -539.27), SIMDE_FLOAT32_C(  -483.90),
        SIMDE_FLOAT32_C(  -772.92), SIMDE_FLOAT32_C(  -835.15), SIMDE_FLOAT32_C(  -653.23), SIMDE_FLOAT32_C(   938.73),
        SIMDE_FLOAT32_C(   265.85), SIMDE_FLOAT32_C(   318.55), SIMDE_FLOAT32_C(  -912.54), SIMDE_FLOAT32_C(   496.58) },
      { SIMDE_FLOAT32_C(  -248.85), SIMDE_FLOAT32_C(   736.03), SIMDE_FLOAT32_C(  -338.10), SIMDE_FLOAT32_C(   433.16),
        SIMDE_FLOAT32_C(   257.97), SIMDE_FLOAT32_C(   458.45), SIMDE_FLOAT32_C(   -90.12), SIMDE_FLOAT32_C(   135.24),
        SIMDE_FLOAT32_C(  -609.34), SIMDE_FLOAT32_C(    87.47), SIMDE_FLOAT32_C(   403.84), SIMDE_FLOAT32_C(   212.42),
        SIMDE_FLOAT32_C(  -330.33), SIMDE_FLOAT32_C(   286.39), SIMDE_FLOAT32_C(  -612.90), SIMDE_FLOAT32_C(  -976.29) },
       INT32_C(          21),
      UINT16_C(47105) },
    { { SIMDE_FLOAT32_C(  -148.09), SIMDE_FLOAT32_C(  -534.92), SIMDE_FLOAT32_C(  -691.57), SIMDE_FLOAT32_C(   545.82),
        SIMDE_FLOAT32_C(   177.53), SIMDE_FLOAT32_C(  -230.85), SIMDE_FLOAT32_C(  -938.08), SIMDE_FLOAT32_C(   404.61),
        SIMDE_FLOAT32_C(   -65.99), SIMDE_FLOAT32_C(  -591.31), SIMDE_FLOAT32_C(   343.34), SIMDE_FLOAT32_C(  -800.14),
        SIMDE_FLOAT32_C(   727.24), SIMDE_FLOAT32_C(   430.80), SIMDE_FLOAT32_C(   696.43), SIMDE_FLOAT32_C(  -521.61) },
      { SIMDE_FLOAT32_C(   166.83), SIMDE_FLOAT32_C(  -641.66), SIMDE_FLOAT32_C(   911.55), SIMDE_FLOAT32_C(  -575.20),
        SIMDE_FLOAT32_C(   816.79), SIMDE_FLOAT32_C(  -178.57), SIMDE_FLOAT32_C(   560.03), SIMDE_FLOAT32_C(  -792.55),
        SIMDE_FLOAT32_C(   908.90), SIMDE_FLOAT32_C(   -36.13), SIMDE_FLOAT32_C(   419.87), SIMDE_FLOAT32_C(  -421.42),
        SIMDE_FLOAT32_C(  -749.74), SIMDE_FLOAT32_C(   806.97), SIMDE_FLOAT32_C(  -397.71), SIMDE_FLOAT32_C(   102.17) },
       INT32_C(          22),
      UINT16_C(20618) },
    { { SIMDE_FLOAT32_C(  -727.95), SIMDE_FLOAT32_C(   -89.29), SIMDE_FLOAT32_C(  -352.01), SIMDE_FLOAT32_C(   449.58),
        SIMDE_FLOAT32_C(   679.87), SIMDE_FLOAT32_C(  -290.09), SIMDE_FLOAT32_C(  -145.82), SIMDE_FLOAT32_C(  -386.13),
        SIMDE_FLOAT32_C(   118.59), SIMDE_FLOAT32_C(  -802.48), SIMDE_FLOAT32_C(  -186.27), SIMDE_FLOAT32_C(  -154.16),
        SIMDE_FLOAT32_C(   628.32), SIMDE_FLOAT32_C(  -489.83), SIMDE_FLOAT32_C(   324.23), SIMDE_FLOAT32_C(  -204.85) },
      { SIMDE_FLOAT32_C(  -131.50), SIMDE_FLOAT32_C(   235.78), SIMDE_FLOAT32_C(   219.94), SIMDE_FLOAT32_C(  -314.71),
        SIMDE_FLOAT32_C(  -942.79), SIMDE_FLOAT32_C(  -220.02), SIMDE_FLOAT32_C(  -107.26), SIMDE_FLOAT32_C(   966.11),
        SIMDE_FLOAT32_C(   743.85), SIMDE_FLOAT32_C(  -687.39), SIMDE_FLOAT32_C(  -455.31), SIMDE_FLOAT32_C(   994.11),
        SIMDE_FLOAT32_C(  -880.42), SIMDE_FLOAT32_C(   146.98), SIMDE_FLOAT32_C(    96.28), SIMDE_FLOAT32_C(  -608.37) },
       INT32_C(          23),
           UINT16_MAX },
    { { SIMDE_FLOAT32_C(  -942.31), SIMDE_FLOAT32_C(   744.27), SIMDE_FLOAT32_C(   841.21), SIMDE_FLOAT32_C(   737.56),
        SIMDE_FLOAT32_C(  -545.82), SIMDE_FLOAT32_C(  -304.61), SIMDE_FLOAT32_C(  -648.57), SIMDE_FLOAT32_C(   572.77),
        SIMDE_FLOAT32_C(  -107.09), SIMDE_FLOAT32_C(   165.16), SIMDE_FLOAT32_C(  -581.39), SIMDE_FLOAT32_C(  -478.77),
        SIMDE_FLOAT32_C(   675.33), SIMDE_FLOAT32_C(   742.84), SIMDE_FLOAT32_C(   316.38), SIMDE_FLOAT32_C(  -456.17) },
      { SIMDE_FLOAT32_C(   -21.39), SIMDE_FLOAT32_C(  -463.68), SIMDE_FLOAT32_C(   229.13), SIMDE_FLOAT32_C(    35.82),
        SIMDE_FLOAT32_C(   316.30), SIMDE_FLOAT32_C(  -878.13), SIMDE_FLOAT32_C(     1.93), SIMDE_FLOAT32_C(    60.15),
        SIMDE_FLOAT32_C(  -565.52), SIMDE_FLOAT32_C(   546.62), SIMDE_FLOAT32_C(    54.26), SIMDE_FLOAT32_C(  -445.94),
        SIMDE_FLOAT32_C(  -306.41), SIMDE_FLOAT32_C(  -849.45), SIMDE_FLOAT32_C(   -54.31), SIMDE_FLOAT32_C(  -248.72) },
       INT32_C(          24),
      UINT16_C(    0) },
    { { SIMDE_FLOAT32_C(   894.82), SIMDE_FLOAT32_C(  -213.10), SIMDE_FLOAT32_C(  -511.16), SIMDE_FLOAT32_C(  -651.01),
        SIMDE_FLOAT32_C(   482.29), SIMDE_FLOAT32_C(  -159.73), SIMDE_FLOAT32_C(   921.76), SIMDE_FLOAT32_C(  -624.79),
        SIMDE_FLOAT32_C(  -994.57), SIMDE_FLOAT32_C(  -659.63), SIMDE_FLOAT32_C(  -103.56), SIMDE_FLOAT32_C(   680.76),
        SIMDE_FLOAT32_C(  -916.80), SIMDE_FLOAT32_C(  -787.19), SIMDE_FLOAT32_C(  -775.40), SIMDE_FLOAT32_C(    61.82) },
      { SIMDE_FLOAT32_C(  -250.87), SIMDE_FLOAT32_C(   453.72), SIMDE_FLOAT32_C(  -902.36), SIMDE_FLOAT32_C(  -934.56),
        SIMDE_FLOAT32_C(   575.59), SIMDE_FLOAT32_C(    99.57), SIMDE_FLOAT32_C(   125.59), SIMDE_FLOAT32_C(  -989.93),
        SIMDE_FLOAT32_C(  -353.81), SIMDE_FLOAT32_C(  -820.15), SIMDE_FLOAT32_C(  -435.87), SIMDE_FLOAT32_C(   339.78),
        SIMDE_FLOAT32_C(  -669.60), SIMDE_FLOAT32_C(   509.82), SIMDE_FLOAT32_C(  -908.94), SIMDE_FLOAT32_C(  -774.79) },
       INT32_C(          25),
      UINT16_C(12594) },
    { { SIMDE_FLOAT32_C(  -703.28), SIMDE_FLOAT32_C(  -420.10), SIMDE_FLOAT32_C(  -425.79), SIMDE_FLOAT32_C(   779.02),
        SIMDE_FLOAT32_C(   420.16), SIMDE_FLOAT32_C(  -504.03), SIMDE_FLOAT32_C(  -845.78), SIMDE_FLOAT32_C(   425.59),
        SIMDE_FLOAT32_C(  -163.66), SIMDE_FLOAT32_C(    50.66), SIMDE_FLOAT32_C(   106.36), SIMDE_FLOAT32_C(   -80.46),
        SIMDE_FLOAT32_C(   263.47), SIMDE_FLOAT32_C(   330.95), SIMDE_FLOAT32_C(   981.36), SIMDE_FLOAT32_C(  -987.39) },
      { SIMDE_FLOAT32_C(  -215.33), SIMDE_FLOAT32_C(  -921.00), SIMDE_FLOAT32_C(  -921.96), SIMDE_FLOAT32_C(  -639.74),
        SIMDE_FLOAT32_C(   178.56), SIMDE_FLOAT32_C(   203.63), SIMDE_FLOAT32_C(  -629.67), SIMDE_FLOAT32_C(   824.75),
        SIMDE_FLOAT32_C(   383.48), SIMDE_FLOAT32_C(   -65.54), SIMDE_FLOAT32_C(   164.53), SIMDE_FLOAT32_C(   713.88),
        SIMDE_FLOAT32_C(  -555.72), SIMDE_FLOAT32_C(   255.59), SIMDE_FLOAT32_C(   939.10), SIMDE_FLOAT32_C(  -258.99) },
       INT32_C(          26),
      UINT16_C(36321) },
    { { SIMDE_FLOAT32_C(   835.48), SIMDE_FLOAT32_C(  -486.70), SIMDE_FLOAT32_C(  -479.98), SIMDE_FLOAT32_C(   255.65),
        SIMDE_FLOAT32_C(     9.27), SIMDE_FLOAT32_C(  -325.76), SIMDE_FLOAT32_C(  -318.76), SIMDE_FLOAT32_C(   845.61),
        SIMDE_FLOAT32_C(   724.90), SIMDE_FLOAT32_C(   787.60), SIMDE_FLOAT32_C(  -234.85), SIMDE_FLOAT32_C(   -11.62),
        SIMDE_FLOAT32_C(   118.55), SIMDE_FLOAT32_C(  -253.49), SIMDE_FLOAT32_C(     0.98), SIMDE_FLOAT32_C(   903.23) },
      { SIMDE_FLOAT32_C(  -174.49), SIMDE_FLOAT32_C(    79.03), SIMDE_FLOAT32_C(  -736.51), SIMDE_FLOAT32_C(  -995.93),
        SIMDE_FLOAT32_C(  -717.34), SIMDE_FLOAT32_C(  -366.18), SIMDE_FLOAT32_C(   828.82), SIMDE_FLOAT32_C(   666.15),
        SIMDE_FLOAT32_C(   568.29), SIMDE_FLOAT32_C(    -6.65), SIMDE_FLOAT32_C(   380.03), SIMDE_FLOAT32_C(  -987.43),
        SIMDE_FLOAT32_C(  -751.06), SIMDE_FLOAT32_C(   319.13), SIMDE_FLOAT32_C(  -246.43), SIMDE_FLOAT32_C(  -915.58) },
       INT32_C(          27),
      UINT16_C(    0) },
    { { SIMDE_FLOAT32_C(   832.43), SIMDE_FLOAT32_C(   273.60), SIMDE_FLOAT32_C(   340.07), SIMDE_FLOAT32_C(  -158.30),
        SIMDE_FLOAT32_C(   947.84), SIMDE_FLOAT32_C(  -978.69), SIMDE_FLOAT32_C(  -312.69), SIMDE_FLOAT32_C(   672.74),
        SIMDE_FLOAT32_C(   808.91), SIMDE_FLOAT32_C(   452.46), SIMDE_FLOAT32_C(  -338.88), SIMDE_FLOAT32_C(   -72.53),
        SIMDE_FLOAT32_C(  -801.03), SIMDE_FLOAT32_C(   662.10), SIMDE_FLOAT32_C(  -169.31), SIMDE_FLOAT32_C(    24.48) },
      { SIMDE_FLOAT32_C(  -258.87), SIMDE_FLOAT32_C(    94.18), SIMDE_FLOAT32_C(    28.55), SIMDE_FLOAT32_C(    23.79),
        SIMDE_FLOAT32_C(   728.01), SIMDE_FLOAT32_C(  -142.63), SIMDE_FLOAT32_C(  -310.06), SIMDE_FLOAT32_C(   296.29),
        SIMDE_FLOAT32_C(   850.72), SIMDE_FLOAT32_C(  -930.03), SIMDE_FLOAT32_C(   308.86), SIMDE_FLOAT32_C(  -900.34),
        SIMDE_FLOAT32_C(   389.10), SIMDE_FLOAT32_C(  -937.56), SIMDE_FLOAT32_C(  -815.92), SIMDE_FLOAT32_C(   221.53) },
       INT32_C(          28),
           UINT16_MAX },
    { { SIMDE_FLOAT32_C(   336.03), SIMDE_FLOAT32_C(   524.16), SIMDE_FLOAT32_C(  -936.77), SIMDE_FLOAT32_C(   283.87),
        SIMDE_FLOAT32_C(   545.47), SIMDE_FLOAT32_C(  -249.46), SIMDE_FLOAT32_C(   -43.38), SIMDE_FLOAT32_C(   354.38),
        SIMDE_FLOAT32_C(  -797.00), SIMDE_FLOAT32_C(   617.74), SIMDE_FLOAT32_C(  -718.15), SIMDE_FLOAT32_C(  -598.03),
        SIMDE_FLOAT32_C(   279.84), SIMDE_FLOAT32_C(   112.54), SIMDE_FLOAT32_C(   426.45), SIMDE_FLOAT32_C(  -979.03) },
      { SIMDE_FLOAT32_C(  -793.27), SIMDE_FLOAT32_C(  -545.00), SIMDE_FLOAT32_C(    44.77), SIMDE_FLOAT32_C(   934.73),
        SIMDE_FLOAT32_C(   312.37), SIMDE_FLOAT32_C(   734.71), SIMDE_FLOAT32_C(   231.03), SIMDE_FLOAT32_C(   163.09),
        SIMDE_FLOAT32_C(   804.68), SIMDE_FLOAT32_C(  -460.11), SIMDE_FLOAT32_C(   262.76), SIMDE_FLOAT32_C(   193.77),
        SIMDE_FLOAT32_C(  -397.67), SIMDE_FLOAT32_C(   446.84), SIMDE_FLOAT32_C(  -584.70), SIMDE_FLOAT32_C(   938.36) },
       INT32_C(          29),
      UINT16_C(21139) },
    { { SIMDE_FLOAT32_C(   -29.00), SIMDE_FLOAT32_C(  -521.48), SIMDE_FLOAT32_C(   222.23), SIMDE_FLOAT32_C(  -483.53),
        SIMDE_FLOAT32_C(   229.06), SIMDE_FLOAT32_C(  -821.16), SIMDE_FLOAT32_C(   870.85), SIMDE_FLOAT32_C(   432.06),
        SIMDE_FLOAT32_C(   796.58), SIMDE_FLOAT32_C(  -847.30), SIMDE_FLOAT32_C(   834.03), SIMDE_FLOAT32_C(    76.42),
        SIMDE_FLOAT32_C(   265.24), SIMDE_FLOAT32_C(   260.47), SIMDE_FLOAT32_C(    97.39), SIMDE_FLOAT32_C(   471.97) },
      { SIMDE_FLOAT32_C(   715.47), SIMDE_FLOAT32_C(  -857.84), SIMDE_FLOAT32_C(   406.70), SIMDE_FLOAT32_C(    27.84),
        SIMDE_FLOAT32_C(   876.87), SIMDE_FLOAT32_C(  -362.27), SIMDE_FLOAT32_C(  -809.06), SIMDE_FLOAT32_C(   681.54),
        SIMDE_FLOAT32_C(   177.62), SIMDE_FLOAT32_C(   453.69), SIMDE_FLOAT32_C(  -124.69), SIMDE_FLOAT32_C(   779.94),
        SIMDE_FLOAT32_C(   -99.47), SIMDE_FLOAT32_C(   290.61), SIMDE_FLOAT32_C(   718.30), SIMDE_FLOAT32_C(   871.53) },
       INT32_C(          30),
      UINT16_C( 5442) },
    { { SIMDE_FLOAT32_C(   769.14), SIMDE_FLOAT32_C(   -59.47), SIMDE_FLOAT32_C(  -612.01), SIMDE_FLOAT32_C(    -1.80),
        SIMDE_FLOAT32_C(   119.37), SIMDE_FLOAT32_C(  -741.16), SIMDE_FLOAT32_C(  -569.75), SIMDE_FLOAT32_C(   -84.05),
        SIMDE_FLOAT32_C(  -588.46), SIMDE_FLOAT32_C(  -735.72), SIMDE_FLOAT32_C(   992.37), SIMDE_FLOAT32_C(   676.78),
        SIMDE_FLOAT32_C(   524.75), SIMDE_FLOAT32_C(    89.76), SIMDE_FLOAT32_C(   148.75), SIMDE_FLOAT32_C(   240.22) },
      { SIMDE_FLOAT32_C(   231.92), SIMDE_FLOAT32_C(  -444.55), SIMDE_FLOAT32_C(  -731.94), SIMDE_FLOAT32_C(   108.79),
        SIMDE_FLOAT32_C(   193.18), SIMDE_FLOAT32_C(  -541.00), SIMDE_FLOAT32_C(  -209.67), SIMDE_FLOAT32_C(  -629.20),
        SIMDE_FLOAT32_C(   912.69), SIMDE_FLOAT32_C(   665.64), SIMDE_FLOAT32_C(  -849.26), SIMDE_FLOAT32_C(  -186.78),
        SIMDE_FLOAT32_C(   -43.74), SIMDE_FLOAT32_C(   869.04), SIMDE_FLOAT32_C(  -315.25), SIMDE_FLOAT32_C(  -274.61) },
       INT32_C(          31),
           UINT16_MAX }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])) ; i++) {
    simde__m512 a = simde_mm512_loadu_ps(test_vec[i].a);
    simde__m512 b = simde_mm512_loadu_ps(test_vec[i].b);
    simde__mmask16 r = simde_mm512_cmp_ps_mask(a, b, test_vec[i].imm8);
    simde_assert_equal_mmask16(r, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_cmp_pd_mask (SIMDE_MUNIT_TEST_ARGS) {
  static const struct {
    const simde_float64 a[8];
    const simde_float64 b[8];
    const int imm8;
    const simde__mmask8 r;
  } test_vec[] = {
    { { SIMDE_FLOAT64_C(  -889.13), SIMDE_FLOAT64_C(   346.35), SIMDE_FLOAT64_C(  -842.69), SIMDE_FLOAT64_C(   879.16),
        SIMDE_FLOAT64_C(    37.28), SIMDE_FLOAT64_C(   607.79), SIMDE_FLOAT64_C(  -858.34), SIMDE_FLOAT64_C(  -122.77) },
      { SIMDE_FLOAT64_C(   597.22), SIMDE_FLOAT64_C(  -446.39), SIMDE_FLOAT64_C(  -495.07), SIMDE_FLOAT64_C(  -701.44),
        SIMDE_FLOAT64_C(   913.94), SIMDE_FLOAT64_C(   514.01), SIMDE_FLOAT64_C(  -970.90), SIMDE_FLOAT64_C(    91.95) },
       INT32_C(          18),
      UINT8_C(149) },
    { { SIMDE_FLOAT64_C(  -229.78), SIMDE_FLOAT64_C(   109.42), SIMDE_FLOAT64_C(   986.52), SIMDE_FLOAT64_C(   450.97),
        SIMDE_FLOAT64_C(  -621.15), SIMDE_FLOAT64_C(   366.22), SIMDE_FLOAT64_C(  -999.97), SIMDE_FLOAT64_C(  -551.44) },
      { SIMDE_FLOAT64_C(   -43.21), SIMDE_FLOAT64_C(  -236.56), SIMDE_FLOAT64_C(    73.66), SIMDE_FLOAT64_C(    21.45),
        SIMDE_FLOAT64_C(   426.81), SIMDE_FLOAT64_C(  -684.87), SIMDE_FLOAT64_C(  -547.62), SIMDE_FLOAT64_C(   194.20) },
       INT32_C(          30),
      UINT8_C( 46) },
    { { SIMDE_FLOAT64_C(   465.94), SIMDE_FLOAT64_C(  -899.85), SIMDE_FLOAT64_C(   236.88), SIMDE_FLOAT64_C(  -744.20),
        SIMDE_FLOAT64_C(   213.84), SIMDE_FLOAT64_C(    84.61), SIMDE_FLOAT64_C(    -4.00), SIMDE_FLOAT64_C(   791.14) },
      { SIMDE_FLOAT64_C(   691.24), SIMDE_FLOAT64_C(  -392.69), SIMDE_FLOAT64_C(    37.26), SIMDE_FLOAT64_C(   209.16),
        SIMDE_FLOAT64_C(  -604.04), SIMDE_FLOAT64_C(  -124.25), SIMDE_FLOAT64_C(  -288.59), SIMDE_FLOAT64_C(  -412.86) },
       INT32_C(          21),
      UINT8_C(244) },
    { { SIMDE_FLOAT64_C(  -618.86), SIMDE_FLOAT64_C(   797.13), SIMDE_FLOAT64_C(  -583.56), SIMDE_FLOAT64_C(    46.88),
        SIMDE_FLOAT64_C(   -89.41), SIMDE_FLOAT64_C(  -683.29), SIMDE_FLOAT64_C(    20.57), SIMDE_FLOAT64_C(  -213.31) },
      { SIMDE_FLOAT64_C(   887.10), SIMDE_FLOAT64_C(  -441.79), SIMDE_FLOAT64_C(   836.33), SIMDE_FLOAT64_C(   135.59),
        SIMDE_FLOAT64_C(   918.70), SIMDE_FLOAT64_C(   512.23), SIMDE_FLOAT64_C(  -895.63), SIMDE_FLOAT64_C(  -900.96) },
       INT32_C(          31),
         UINT8_MAX },
    { { SIMDE_FLOAT64_C(  -989.35), SIMDE_FLOAT64_C(   -86.98), SIMDE_FLOAT64_C(   193.68), SIMDE_FLOAT64_C(  -742.71),
        SIMDE_FLOAT64_C(  -727.59), SIMDE_FLOAT64_C(  -646.86), SIMDE_FLOAT64_C(   183.87), SIMDE_FLOAT64_C(   287.33) },
      { SIMDE_FLOAT64_C(  -774.81), SIMDE_FLOAT64_C(  -242.40), SIMDE_FLOAT64_C(    53.99), SIMDE_FLOAT64_C(  -593.99),
        SIMDE_FLOAT64_C(   779.72), SIMDE_FLOAT64_C(   806.29), SIMDE_FLOAT64_C(  -734.86), SIMDE_FLOAT64_C(  -839.78) },
       INT32_C(           6),
      UINT8_C(198) },
    { { SIMDE_FLOAT64_C(  -467.13), SIMDE_FLOAT64_C(   942.12), SIMDE_FLOAT64_C(   248.01), SIMDE_FLOAT64_C(   325.07),
        SIMDE_FLOAT64_C(  -486.56), SIMDE_FLOAT64_C(   428.42), SIMDE_FLOAT64_C(   503.39), SIMDE_FLOAT64_C(   520.75) },
      { SIMDE_FLOAT64_C(   191.14), SIMDE_FLOAT64_C(   441.43), SIMDE_FLOAT64_C(  -872.87), SIMDE_FLOAT64_C(  -283.89),
        SIMDE_FLOAT64_C(   651.45), SIMDE_FLOAT64_C(   971.81), SIMDE_FLOAT64_C(  -736.72), SIMDE_FLOAT64_C(   -71.12) },
       INT32_C(          17),
      UINT8_C( 49) },
    { { SIMDE_FLOAT64_C(   768.97), SIMDE_FLOAT64_C(    83.87), SIMDE_FLOAT64_C(  -412.86), SIMDE_FLOAT64_C(   997.28),
        SIMDE_FLOAT64_C(  -659.21), SIMDE_FLOAT64_C(   650.14), SIMDE_FLOAT64_C(   927.00), SIMDE_FLOAT64_C(    40.06) },
      { SIMDE_FLOAT64_C(  -783.94), SIMDE_FLOAT64_C(   289.86), SIMDE_FLOAT64_C(  -325.98), SIMDE_FLOAT64_C(  -693.23),
        SIMDE_FLOAT64_C(   823.83), SIMDE_FLOAT64_C(    81.84), SIMDE_FLOAT64_C(  -557.12), SIMDE_FLOAT64_C(   458.20) },
       INT32_C(          28),
         UINT8_MAX },
    { { SIMDE_FLOAT64_C(   728.01), SIMDE_FLOAT64_C(  -387.72), SIMDE_FLOAT64_C(  -341.65), SIMDE_FLOAT64_C(   -84.21),
        SIMDE_FLOAT64_C(   640.32), SIMDE_FLOAT64_C(  -112.91), SIMDE_FLOAT64_C(   308.09), SIMDE_FLOAT64_C(    20.16) },
      { SIMDE_FLOAT64_C(   745.10), SIMDE_FLOAT64_C(   919.13), SIMDE_FLOAT64_C(  -195.91), SIMDE_FLOAT64_C(  -612.27),
        SIMDE_FLOAT64_C(  -399.85), SIMDE_FLOAT64_C(  -354.18), SIMDE_FLOAT64_C(  -752.13), SIMDE_FLOAT64_C(   868.12) },
       INT32_C(          29),
      UINT8_C(120) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])) ; i++) {
    simde__m512d a = simde_mm512_loadu_pd(test_vec[i].a);
    simde__m512d b = simde_mm512_loadu_pd(test_vec[i].b);
    simde__mmask8 r = simde_mm512_cmp_pd_mask(a, b, test_vec[i].imm8);
    simde_assert_equal_mmask8(r, test_vec[i].r);
  }

  return 0;
}

#else

/* To avoid a warning about expr < 0 always evaluating to false
 * (-Wtype-limits) because there are no functions to test. */

static int
test_simde_dummy (SIMDE_MUNIT_TEST_ARGS) {
  return 0;
}

#endif /* !defined(SIMDE_NATIVE_ALIASES_TESTING */

SIMDE_TEST_FUNC_LIST_BEGIN
  #if !defined(SIMDE_NATIVE_ALIASES_TESTING)
    SIMDE_TEST_FUNC_LIST_ENTRY(mm512_cmp_ps_mask)
    SIMDE_TEST_FUNC_LIST_ENTRY(mm512_cmp_pd_mask)
  #else
    SIMDE_TEST_FUNC_LIST_ENTRY(dummy)
  #endif
SIMDE_TEST_FUNC_LIST_END

#include <test/x86/avx512/test-avx512-footer.h>
