/* SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Copyright:
 *   2020      Evan Nemerson <evan@nemerson.com>
 */

#if !defined(SIMDE_ARM_NEON_H)
#define SIMDE_ARM_NEON_H

#include "neon/types.h"

#include "neon/add.h"
#include "neon/addw.h"
#include "neon/and.h"
#include "neon/bsl.h"
#include "neon/cagt.h"
#include "neon/dup_n.h"
#include "neon/eor.h"
#include "neon/get_high.h"
#include "neon/get_lane.h"
#include "neon/get_low.h"
#include "neon/ld1.h"
#include "neon/min.h"
#include "neon/mla.h"
#include "neon/mul.h"
#include "neon/mull.h"
#include "neon/orr.h"
#include "neon/padd.h"
#include "neon/pmin.h"
#include "neon/reinterpret.h"
#include "neon/shl.h"
#include "neon/shl_n.h"
#include "neon/shr_n.h"
#include "neon/st1.h"
#include "neon/sub.h"
#include "neon/uzp1.h"
#include "neon/uzp2.h"

#endif /* SIMDE_ARM_NEON_H */
