/* Copyright (c) 2018, 2019, 2020 Evan Nemerson <evan@nemerson.com>
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#define SIMDE_TESTS_CURRENT_ISAX avx512bw
#include <simde/x86/avx512bw.h>
#include <test/x86/test-avx512.h>

static MunitResult
test_simde_mm512_mask_set1_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i src;
    simde__mmask64 k;
    int8_t a;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C(  80), INT8_C(  13), INT8_C( -86), INT8_C( 103),
                           INT8_C(  30), INT8_C(  88), INT8_C( -63), INT8_C( -16),
                           INT8_C( -68), INT8_C( -20), INT8_C(  48), INT8_C( -36),
                           INT8_C( -97), INT8_C(-103), INT8_C(-104), INT8_C( -61),
                           INT8_C(-122), INT8_C( -83), INT8_C(  -3), INT8_C(-115),
                           INT8_C(  29), INT8_C(-112), INT8_C( 118), INT8_C(  53),
                           INT8_C(-107), INT8_C(-126), INT8_C(  41), INT8_C(-117),
                           INT8_C(  -4), INT8_C( -72), INT8_C(  -9), INT8_C(   2),
                           INT8_C(  10), INT8_C( -61), INT8_C( 116), INT8_C(   1),
                           INT8_C(  35), INT8_C( -78), INT8_C(  17), INT8_C( -82),
                           INT8_C( -14), INT8_C( 120), INT8_C( 120), INT8_C(  33),
                           INT8_C(  97), INT8_C(   4), INT8_C(-104), INT8_C(  67),
                           INT8_C( -86), INT8_C( -90), INT8_C( -95), INT8_C(  51),
                           INT8_C( -83), INT8_C(-120), INT8_C( 123), INT8_C(  -4),
                           INT8_C(  51), INT8_C( -66), INT8_C( -91), INT8_C(  51),
                           INT8_C(  -1), INT8_C(  32), INT8_C(  30), INT8_C(  92)),
      UINT64_C(12701675613368776088),
      INT8_C( -94),
      simde_mm512_set_epi8(INT8_C( -94), INT8_C(  13), INT8_C( -94), INT8_C( -94),
                           INT8_C(  30), INT8_C(  88), INT8_C( -63), INT8_C( -16),
                           INT8_C( -68), INT8_C( -94), INT8_C(  48), INT8_C( -36),
                           INT8_C( -97), INT8_C( -94), INT8_C(-104), INT8_C( -94),
                           INT8_C(-122), INT8_C( -94), INT8_C( -94), INT8_C(-115),
                           INT8_C( -94), INT8_C(-112), INT8_C( -94), INT8_C(  53),
                           INT8_C( -94), INT8_C(-126), INT8_C( -94), INT8_C(-117),
                           INT8_C( -94), INT8_C( -94), INT8_C(  -9), INT8_C(   2),
                           INT8_C( -94), INT8_C( -61), INT8_C( 116), INT8_C(   1),
                           INT8_C( -94), INT8_C( -78), INT8_C( -94), INT8_C( -94),
                           INT8_C( -14), INT8_C( 120), INT8_C( 120), INT8_C( -94),
                           INT8_C(  97), INT8_C( -94), INT8_C( -94), INT8_C(  67),
                           INT8_C( -86), INT8_C( -94), INT8_C( -94), INT8_C( -94),
                           INT8_C( -83), INT8_C( -94), INT8_C( 123), INT8_C( -94),
                           INT8_C( -94), INT8_C( -66), INT8_C( -91), INT8_C( -94),
                           INT8_C( -94), INT8_C(  32), INT8_C(  30), INT8_C(  92)) },
    { simde_mm512_set_epi8(INT8_C( -64), INT8_C( -80), INT8_C(  33), INT8_C(  -9),
                           INT8_C(   3), INT8_C(  93), INT8_C(  13), INT8_C( -28),
                           INT8_C(  79), INT8_C(  10), INT8_C( -42), INT8_C(-127),
                           INT8_C( 114), INT8_C(  78), INT8_C(  61), INT8_C(  67),
                           INT8_C(  95), INT8_C(  14), INT8_C(  28), INT8_C(  56),
                           INT8_C(  43), INT8_C( -20), INT8_C( -77), INT8_C(  83),
                           INT8_C( -68), INT8_C(  87), INT8_C( -96), INT8_C(  13),
                           INT8_C(  40), INT8_C( 107), INT8_C( -63), INT8_C(  -1),
                           INT8_C(  77), INT8_C(  21), INT8_C( -46), INT8_C( -12),
                           INT8_C(  42), INT8_C(  69), INT8_C(  51), INT8_C(  11),
                           INT8_C(-120), INT8_C(  65), INT8_C( -70), INT8_C( -19),
                           INT8_C( -95), INT8_C(  43), INT8_C(  -2), INT8_C( -62),
                           INT8_C( -16), INT8_C(  28), INT8_C(  29), INT8_C( -11),
                           INT8_C(  17), INT8_C( -18), INT8_C( 105), INT8_C(-119),
                           INT8_C(  60), INT8_C( 120), INT8_C(  38), INT8_C( -41),
                           INT8_C(  20), INT8_C( -30), INT8_C(  15), INT8_C( 112)),
      UINT64_C(15052494645983188959),
      INT8_C( -73),
      simde_mm512_set_epi8(INT8_C( -73), INT8_C( -73), INT8_C(  33), INT8_C( -73),
                           INT8_C(   3), INT8_C(  93), INT8_C(  13), INT8_C( -28),
                           INT8_C( -73), INT8_C( -73), INT8_C( -73), INT8_C(-127),
                           INT8_C( 114), INT8_C( -73), INT8_C(  61), INT8_C( -73),
                           INT8_C(  95), INT8_C(  14), INT8_C( -73), INT8_C( -73),
                           INT8_C(  43), INT8_C( -73), INT8_C( -77), INT8_C(  83),
                           INT8_C( -68), INT8_C(  87), INT8_C( -73), INT8_C(  13),
                           INT8_C(  40), INT8_C( 107), INT8_C( -63), INT8_C( -73),
                           INT8_C(  77), INT8_C(  21), INT8_C( -46), INT8_C( -12),
                           INT8_C(  42), INT8_C( -73), INT8_C(  51), INT8_C( -73),
                           INT8_C(-120), INT8_C( -73), INT8_C( -70), INT8_C( -19),
                           INT8_C( -73), INT8_C( -73), INT8_C(  -2), INT8_C( -62),
                           INT8_C( -16), INT8_C(  28), INT8_C(  29), INT8_C( -73),
                           INT8_C(  17), INT8_C( -73), INT8_C( -73), INT8_C( -73),
                           INT8_C( -73), INT8_C( -73), INT8_C(  38), INT8_C( -73),
                           INT8_C( -73), INT8_C( -73), INT8_C( -73), INT8_C( -73)) },
    { simde_mm512_set_epi8(INT8_C( 107), INT8_C( 126), INT8_C( -33), INT8_C(  83),
                           INT8_C(  46), INT8_C(  62), INT8_C( -81), INT8_C(  33),
                           INT8_C( -68), INT8_C(-126), INT8_C( -41), INT8_C( 125),
                           INT8_C( -96), INT8_C( -20), INT8_C(  62), INT8_C( -19),
                           INT8_C(  29), INT8_C( -96), INT8_C(  68), INT8_C( 119),
                           INT8_C( -36), INT8_C( -62), INT8_C( -27), INT8_C(-112),
                           INT8_C(-123), INT8_C(  55), INT8_C(-119), INT8_C(  -4),
                           INT8_C(  58), INT8_C(  28), INT8_C( -84), INT8_C( -38),
                           INT8_C(   1), INT8_C( -25), INT8_C( 107), INT8_C( -63),
                           INT8_C( -86), INT8_C(  88), INT8_C(  36), INT8_C(  53),
                           INT8_C( 109), INT8_C( -36), INT8_C( -70), INT8_C(-125),
                           INT8_C(  -3), INT8_C(-109), INT8_C( 121), INT8_C( -63),
                           INT8_C( 113), INT8_C( -92), INT8_C(  -4), INT8_C(-105),
                           INT8_C( -65), INT8_C(  26), INT8_C( -36), INT8_C(  87),
                           INT8_C(-101), INT8_C( -70), INT8_C(  -3), INT8_C(  26),
                           INT8_C( -88), INT8_C( -51), INT8_C(-123), INT8_C(  93)),
      UINT64_C( 2985661334514035835),
      INT8_C( 111),
      simde_mm512_set_epi8(INT8_C( 107), INT8_C( 126), INT8_C( 111), INT8_C(  83),
                           INT8_C( 111), INT8_C(  62), INT8_C( -81), INT8_C( 111),
                           INT8_C( -68), INT8_C( 111), INT8_C( 111), INT8_C( 125),
                           INT8_C( 111), INT8_C( 111), INT8_C( 111), INT8_C( 111),
                           INT8_C(  29), INT8_C( -96), INT8_C( 111), INT8_C( 111),
                           INT8_C( -36), INT8_C( -62), INT8_C( 111), INT8_C( 111),
                           INT8_C(-123), INT8_C(  55), INT8_C( 111), INT8_C(  -4),
                           INT8_C( 111), INT8_C(  28), INT8_C( 111), INT8_C( -38),
                           INT8_C(   1), INT8_C( -25), INT8_C( 111), INT8_C( 111),
                           INT8_C( 111), INT8_C( 111), INT8_C( 111), INT8_C( 111),
                           INT8_C( 109), INT8_C( 111), INT8_C( -70), INT8_C( 111),
                           INT8_C(  -3), INT8_C(-109), INT8_C( 111), INT8_C( 111),
                           INT8_C( 111), INT8_C( 111), INT8_C( 111), INT8_C(-105),
                           INT8_C( 111), INT8_C( 111), INT8_C( -36), INT8_C(  87),
                           INT8_C(-101), INT8_C( 111), INT8_C( 111), INT8_C( 111),
                           INT8_C( 111), INT8_C( -51), INT8_C( 111), INT8_C( 111)) },
    { simde_mm512_set_epi8(INT8_C( -63), INT8_C(  92), INT8_C( -41), INT8_C( -80),
                           INT8_C(-101), INT8_C(  86), INT8_C(  45), INT8_C(  45),
                           INT8_C( -41), INT8_C(-113), INT8_C( -17), INT8_C(-101),
                           INT8_C(-113), INT8_C( -69), INT8_C(  73), INT8_C(-124),
                           INT8_C(  90), INT8_C(-118), INT8_C(  31), INT8_C(-124),
                           INT8_C( -88), INT8_C(-116), INT8_C(   8), INT8_C( -37),
                           INT8_C( -41), INT8_C(  93), INT8_C( -86), INT8_C(  61),
                           INT8_C( -70), INT8_C( -88), INT8_C(  44), INT8_C( -34),
                           INT8_C( -21), INT8_C(-121), INT8_C(-124), INT8_C(-114),
                           INT8_C(  73), INT8_C(  92), INT8_C( -92), INT8_C(-115),
                           INT8_C(   6), INT8_C(-120), INT8_C(  89), INT8_C(-102),
                           INT8_C( -43), INT8_C(  33), INT8_C(  15), INT8_C(  -6),
                           INT8_C(-105), INT8_C(  66), INT8_C( -60), INT8_C(  54),
                           INT8_C( -95), INT8_C(  49), INT8_C(   1), INT8_C( 118),
                           INT8_C( -33), INT8_C( -35), INT8_C( -34), INT8_C( -10),
                           INT8_C( -70), INT8_C(  74), INT8_C( -10), INT8_C(  97)),
      UINT64_C(12556192675989742329),
      INT8_C(-120),
      simde_mm512_set_epi8(INT8_C(-120), INT8_C(  92), INT8_C(-120), INT8_C( -80),
                           INT8_C(-120), INT8_C(-120), INT8_C(-120), INT8_C(  45),
                           INT8_C( -41), INT8_C(-120), INT8_C( -17), INT8_C(-101),
                           INT8_C(-113), INT8_C( -69), INT8_C(  73), INT8_C(-124),
                           INT8_C(-120), INT8_C(-118), INT8_C(  31), INT8_C(-124),
                           INT8_C(-120), INT8_C(-120), INT8_C(-120), INT8_C( -37),
                           INT8_C(-120), INT8_C(  93), INT8_C(-120), INT8_C(-120),
                           INT8_C( -70), INT8_C(-120), INT8_C(-120), INT8_C( -34),
                           INT8_C(-120), INT8_C(-121), INT8_C(-124), INT8_C(-120),
                           INT8_C(  73), INT8_C(-120), INT8_C(-120), INT8_C(-120),
                           INT8_C(-120), INT8_C(-120), INT8_C(-120), INT8_C(-120),
                           INT8_C(-120), INT8_C(  33), INT8_C(-120), INT8_C(  -6),
                           INT8_C(-120), INT8_C(-120), INT8_C(-120), INT8_C(  54),
                           INT8_C( -95), INT8_C(  49), INT8_C(-120), INT8_C( 118),
                           INT8_C(-120), INT8_C(-120), INT8_C(-120), INT8_C(-120),
                           INT8_C(-120), INT8_C(  74), INT8_C( -10), INT8_C(-120)) },
    { simde_mm512_set_epi8(INT8_C(  21), INT8_C(  17), INT8_C(  22), INT8_C(-115),
                           INT8_C( 101), INT8_C(  -2), INT8_C( -32), INT8_C( -27),
                           INT8_C( -14), INT8_C(  47), INT8_C( 110), INT8_C( -88),
                           INT8_C(  23), INT8_C( -87), INT8_C( -20), INT8_C( 115),
                           INT8_C( 108), INT8_C( -54), INT8_C(-105), INT8_C( -94),
                           INT8_C(  96), INT8_C(-110), INT8_C( -87), INT8_C( 119),
                           INT8_C( 110), INT8_C( -13), INT8_C(  53), INT8_C( -27),
                           INT8_C( -59), INT8_C(  57), INT8_C( -46), INT8_C( -24),
                           INT8_C(  35), INT8_C(  26), INT8_C( 124), INT8_C( -28),
                           INT8_C( -68), INT8_C( -57), INT8_C(  75), INT8_C( -25),
                           INT8_C(-112), INT8_C( 112), INT8_C( 123), INT8_C(-108),
                           INT8_C( 115), INT8_C(  -6), INT8_C(  43), INT8_C(  52),
                           INT8_C( -91), INT8_C( -17), INT8_C(  93), INT8_C(  -2),
                           INT8_C( 116), INT8_C( -51), INT8_C(  70), INT8_C(  98),
                           INT8_C( 104), INT8_C( -69), INT8_C(-102), INT8_C(  77),
                           INT8_C(  82), INT8_C( 125), INT8_C(  42), INT8_C(  83)),
      UINT64_C(12090133344763257330),
      INT8_C(  55),
      simde_mm512_set_epi8(INT8_C(  55), INT8_C(  17), INT8_C(  55), INT8_C(-115),
                           INT8_C( 101), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C( 110), INT8_C( -88),
                           INT8_C(  55), INT8_C( -87), INT8_C( -20), INT8_C( 115),
                           INT8_C(  55), INT8_C(  55), INT8_C(-105), INT8_C( -94),
                           INT8_C(  55), INT8_C(-110), INT8_C( -87), INT8_C( 119),
                           INT8_C( 110), INT8_C( -13), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  57), INT8_C( -46), INT8_C( -24),
                           INT8_C(  55), INT8_C(  26), INT8_C( 124), INT8_C( -28),
                           INT8_C( -68), INT8_C(  55), INT8_C(  75), INT8_C(  55),
                           INT8_C(  55), INT8_C( 112), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  -6), INT8_C(  43), INT8_C(  52),
                           INT8_C( -91), INT8_C( -17), INT8_C(  55), INT8_C(  -2),
                           INT8_C( 116), INT8_C( -51), INT8_C(  70), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  82), INT8_C( 125), INT8_C(  55), INT8_C(  83)) },
    { simde_mm512_set_epi8(INT8_C(-124), INT8_C( -37), INT8_C( -61), INT8_C( -35),
                           INT8_C( -22), INT8_C( -85), INT8_C(-117), INT8_C(-105),
                           INT8_C(  99), INT8_C( -62), INT8_C( 102), INT8_C( -31),
                           INT8_C(  82), INT8_C(  39), INT8_C(  49), INT8_C(  43),
                           INT8_C(  21), INT8_C(  16), INT8_C(  12), INT8_C(-125),
                           INT8_C(   2), INT8_C(-106), INT8_C(  -4), INT8_C( 100),
                           INT8_C( -12), INT8_C(  30), INT8_C( -39), INT8_C( -37),
                           INT8_C(  92), INT8_C( -43), INT8_C(  33), INT8_C(-124),
                           INT8_C(  48), INT8_C(   4), INT8_C(  31), INT8_C(  78),
                           INT8_C(-113), INT8_C( 115), INT8_C( 116), INT8_C( -62),
                           INT8_C(-109), INT8_C( -66), INT8_C(  43), INT8_C(-118),
                           INT8_C(-105), INT8_C( -11), INT8_C( 100), INT8_C(  41),
                           INT8_C(-104), INT8_C(-114), INT8_C(-105), INT8_C(  88),
                           INT8_C( -33), INT8_C(  -8), INT8_C(  41), INT8_C(  16),
                           INT8_C(   4), INT8_C(  89), INT8_C(  66), INT8_C(  27),
                           INT8_C( -63), INT8_C(  30), INT8_C( -95), INT8_C(  33)),
      UINT64_C(13436704833767296949),
      INT8_C(  18),
      simde_mm512_set_epi8(INT8_C(  18), INT8_C( -37), INT8_C(  18), INT8_C(  18),
                           INT8_C(  18), INT8_C( -85), INT8_C(  18), INT8_C(-105),
                           INT8_C(  99), INT8_C(  18), INT8_C(  18), INT8_C(  18),
                           INT8_C(  18), INT8_C(  39), INT8_C(  49), INT8_C(  43),
                           INT8_C(  18), INT8_C(  18), INT8_C(  12), INT8_C(-125),
                           INT8_C(   2), INT8_C(-106), INT8_C(  18), INT8_C(  18),
                           INT8_C(  18), INT8_C(  18), INT8_C( -39), INT8_C(  18),
                           INT8_C(  18), INT8_C( -43), INT8_C(  18), INT8_C(  18),
                           INT8_C(  48), INT8_C(   4), INT8_C(  31), INT8_C(  78),
                           INT8_C(  18), INT8_C( 115), INT8_C( 116), INT8_C( -62),
                           INT8_C(-109), INT8_C(  18), INT8_C(  18), INT8_C(  18),
                           INT8_C(  18), INT8_C( -11), INT8_C( 100), INT8_C(  18),
                           INT8_C(-104), INT8_C(  18), INT8_C(-105), INT8_C(  88),
                           INT8_C(  18), INT8_C(  18), INT8_C(  18), INT8_C(  18),
                           INT8_C(  18), INT8_C(  89), INT8_C(  18), INT8_C(  18),
                           INT8_C( -63), INT8_C(  18), INT8_C( -95), INT8_C(  18)) },
    { simde_mm512_set_epi8(INT8_C( -30), INT8_C( 101), INT8_C(  64), INT8_C( 107),
                           INT8_C( -34), INT8_C( -67), INT8_C( -96), INT8_C(  35),
                           INT8_C( 117), INT8_C(  76), INT8_C( 106), INT8_C( -82),
                           INT8_C( -48), INT8_C(  63), INT8_C(  11), INT8_C(  22),
                           INT8_C(  41), INT8_C(  95), INT8_C(-123), INT8_C( -90),
                           INT8_C(  67), INT8_C( -76), INT8_C(-105), INT8_C(  -7),
                           INT8_C( 115), INT8_C( 121), INT8_C( -52), INT8_C( -95),
                           INT8_C(-101), INT8_C(  64), INT8_C( -67), INT8_C( 107),
                           INT8_C(-104), INT8_C(  56), INT8_C(  89), INT8_C( -95),
                           INT8_C(  21), INT8_C( -42), INT8_C( -75), INT8_C(  45),
                           INT8_C( -86), INT8_C(  32), INT8_C(  27), INT8_C(-119),
                           INT8_C( -68), INT8_C(   5), INT8_C( -78), INT8_C( -36),
                           INT8_C( 125), INT8_C( 117), INT8_C( -63), INT8_C( -68),
                           INT8_C( -45), INT8_C( -77), INT8_C(   6), INT8_C(  68),
                           INT8_C(  79), INT8_C( -92), INT8_C(  67), INT8_C(  61),
                           INT8_C(  42), INT8_C(  26), INT8_C(-117), INT8_C( -55)),
      UINT64_C(14020412538477965079),
      INT8_C( -46),
      simde_mm512_set_epi8(INT8_C( -46), INT8_C( -46), INT8_C(  64), INT8_C( 107),
                           INT8_C( -34), INT8_C( -67), INT8_C( -46), INT8_C(  35),
                           INT8_C( -46), INT8_C(  76), INT8_C( 106), INT8_C( -46),
                           INT8_C( -48), INT8_C(  63), INT8_C( -46), INT8_C(  22),
                           INT8_C( -46), INT8_C(  95), INT8_C(-123), INT8_C( -90),
                           INT8_C(  67), INT8_C( -76), INT8_C( -46), INT8_C(  -7),
                           INT8_C( -46), INT8_C( -46), INT8_C( -46), INT8_C( -95),
                           INT8_C( -46), INT8_C(  64), INT8_C( -46), INT8_C( -46),
                           INT8_C( -46), INT8_C(  56), INT8_C( -46), INT8_C( -95),
                           INT8_C(  21), INT8_C( -42), INT8_C( -75), INT8_C(  45),
                           INT8_C( -86), INT8_C( -46), INT8_C( -46), INT8_C(-119),
                           INT8_C( -46), INT8_C(   5), INT8_C( -78), INT8_C( -46),
                           INT8_C( 125), INT8_C( -46), INT8_C( -46), INT8_C( -68),
                           INT8_C( -46), INT8_C( -46), INT8_C( -46), INT8_C( -46),
                           INT8_C(  79), INT8_C( -92), INT8_C(  67), INT8_C( -46),
                           INT8_C(  42), INT8_C( -46), INT8_C( -46), INT8_C( -46)) },
    { simde_mm512_set_epi8(INT8_C( -83), INT8_C( -73), INT8_C( -22), INT8_C(  98),
                           INT8_C( 126), INT8_C(  41), INT8_C( -28), INT8_C( 126),
                           INT8_C( -75), INT8_C(  91), INT8_C( -33), INT8_C( 103),
                           INT8_C( -63), INT8_C(  62), INT8_C(  83), INT8_C(   4),
                           INT8_C(  65), INT8_C( -22), INT8_C( 107), INT8_C(   8),
                           INT8_C(  31), INT8_C(-111), INT8_C(-114), INT8_C(-118),
                           INT8_C(   2), INT8_C(  76), INT8_C(  19), INT8_C( 127),
                           INT8_C( -37), INT8_C( -41), INT8_C(  91), INT8_C( -64),
                           INT8_C(-105), INT8_C( 127), INT8_C(-121), INT8_C(  84),
                           INT8_C( 124), INT8_C(  50), INT8_C( -86), INT8_C(-101),
                           INT8_C( -82), INT8_C( 121), INT8_C(  18), INT8_C( -17),
                           INT8_C( -55), INT8_C(-102), INT8_C( -81), INT8_C( -54),
                           INT8_C( -56), INT8_C(  -2), INT8_C( -68), INT8_C( 105),
                           INT8_C( -48), INT8_C( -90), INT8_C( -46), INT8_C(  63),
                           INT8_C( 126), INT8_C( -93), INT8_C(  46), INT8_C(-114),
                           INT8_C(  58), INT8_C( 110), INT8_C( 102), INT8_C( -93)),
      UINT64_C(14839809536761107867),
      INT8_C( 106),
      simde_mm512_set_epi8(INT8_C( 106), INT8_C( 106), INT8_C( -22), INT8_C(  98),
                           INT8_C( 106), INT8_C( 106), INT8_C( -28), INT8_C( 106),
                           INT8_C( 106), INT8_C( 106), INT8_C( 106), INT8_C( 106),
                           INT8_C( -63), INT8_C(  62), INT8_C(  83), INT8_C( 106),
                           INT8_C( 106), INT8_C( -22), INT8_C( 107), INT8_C( 106),
                           INT8_C( 106), INT8_C(-111), INT8_C(-114), INT8_C(-118),
                           INT8_C(   2), INT8_C(  76), INT8_C( 106), INT8_C( 127),
                           INT8_C( -37), INT8_C( 106), INT8_C( 106), INT8_C( -64),
                           INT8_C(-105), INT8_C( 127), INT8_C( 106), INT8_C(  84),
                           INT8_C( 124), INT8_C( 106), INT8_C( -86), INT8_C( 106),
                           INT8_C( -82), INT8_C( 121), INT8_C(  18), INT8_C( 106),
                           INT8_C( 106), INT8_C(-102), INT8_C( -81), INT8_C( 106),
                           INT8_C( 106), INT8_C(  -2), INT8_C( -68), INT8_C( 106),
                           INT8_C( -48), INT8_C( 106), INT8_C( -46), INT8_C( 106),
                           INT8_C( 106), INT8_C( -93), INT8_C(  46), INT8_C( 106),
                           INT8_C( 106), INT8_C( 110), INT8_C( 106), INT8_C( 106)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_mask_set1_epi8(test_vec[i].src, test_vec[i].k, test_vec[i].a);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_maskz_set1_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__mmask64 k;
    int8_t a;
    simde__m512i r;
  } test_vec[8] = {
   { UINT64_C( 2901368310709582274),
      INT8_C( -37),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C( -37), INT8_C(   0),
                           INT8_C( -37), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -37), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -37), INT8_C( -37),
                           INT8_C( -37), INT8_C(   0), INT8_C( -37), INT8_C( -37),
                           INT8_C( -37), INT8_C(   0), INT8_C( -37), INT8_C( -37),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -37),
                           INT8_C( -37), INT8_C(   0), INT8_C( -37), INT8_C( -37),
                           INT8_C(   0), INT8_C( -37), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -37), INT8_C(   0),
                           INT8_C(   0), INT8_C( -37), INT8_C( -37), INT8_C(   0),
                           INT8_C( -37), INT8_C(   0), INT8_C( -37), INT8_C( -37),
                           INT8_C(   0), INT8_C( -37), INT8_C( -37), INT8_C( -37),
                           INT8_C( -37), INT8_C(   0), INT8_C(   0), INT8_C( -37),
                           INT8_C( -37), INT8_C( -37), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -37), INT8_C(   0)) },
    { UINT64_C(15800639674747260058),
      INT8_C(  63),
      simde_mm512_set_epi8(INT8_C(  63), INT8_C(  63), INT8_C(   0), INT8_C(  63),
                           INT8_C(  63), INT8_C(   0), INT8_C(  63), INT8_C(  63),
                           INT8_C(   0), INT8_C(  63), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  63), INT8_C(  63), INT8_C(  63),
                           INT8_C(   0), INT8_C(   0), INT8_C(  63), INT8_C(   0),
                           INT8_C(   0), INT8_C(  63), INT8_C(  63), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  63),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  63),
                           INT8_C(  63), INT8_C(   0), INT8_C(   0), INT8_C(  63),
                           INT8_C(  63), INT8_C(  63), INT8_C(   0), INT8_C(  63),
                           INT8_C(   0), INT8_C(  63), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  63),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  63), INT8_C(  63), INT8_C(   0), INT8_C(   0),
                           INT8_C(  63), INT8_C(   0), INT8_C(   0), INT8_C(  63),
                           INT8_C(  63), INT8_C(   0), INT8_C(  63), INT8_C(   0)) },
    { UINT64_C(12860739080443979541),
      INT8_C(  53),
      simde_mm512_set_epi8(INT8_C(  53), INT8_C(   0), INT8_C(  53), INT8_C(  53),
                           INT8_C(   0), INT8_C(   0), INT8_C(  53), INT8_C(   0),
                           INT8_C(   0), INT8_C(  53), INT8_C(  53), INT8_C(  53),
                           INT8_C(  53), INT8_C(   0), INT8_C(  53), INT8_C(   0),
                           INT8_C(  53), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  53), INT8_C(  53), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  53), INT8_C(  53), INT8_C(   0), INT8_C(  53),
                           INT8_C(  53), INT8_C(  53), INT8_C(  53), INT8_C(  53),
                           INT8_C(   0), INT8_C(  53), INT8_C(  53), INT8_C(   0),
                           INT8_C(  53), INT8_C(  53), INT8_C(   0), INT8_C(  53),
                           INT8_C(  53), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  53), INT8_C(  53), INT8_C(  53), INT8_C(   0),
                           INT8_C(   0), INT8_C(  53), INT8_C(  53), INT8_C(  53),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  53),
                           INT8_C(   0), INT8_C(  53), INT8_C(   0), INT8_C(  53)) },
    { UINT64_C( 2595884503750725802),
      INT8_C(  78),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(  78), INT8_C(   0),
                           INT8_C(   0), INT8_C(  78), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  78), INT8_C(  78), INT8_C(   0),
                           INT8_C(   0), INT8_C(  78), INT8_C(  78), INT8_C(   0),
                           INT8_C(  78), INT8_C(  78), INT8_C(  78), INT8_C(  78),
                           INT8_C(   0), INT8_C(   0), INT8_C(  78), INT8_C(  78),
                           INT8_C(   0), INT8_C(   0), INT8_C(  78), INT8_C(  78),
                           INT8_C(  78), INT8_C(  78), INT8_C(   0), INT8_C(  78),
                           INT8_C(  78), INT8_C(  78), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  78), INT8_C(  78), INT8_C(   0), INT8_C(  78),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  78), INT8_C(   0), INT8_C(  78), INT8_C(   0),
                           INT8_C(  78), INT8_C(   0), INT8_C(  78), INT8_C(   0)) },
    { UINT64_C(13286373173549182748),
      INT8_C( -67),
      simde_mm512_set_epi8(INT8_C( -67), INT8_C(   0), INT8_C( -67), INT8_C( -67),
                           INT8_C( -67), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -67), INT8_C( -67), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -67), INT8_C(   0),
                           INT8_C( -67), INT8_C(   0), INT8_C( -67), INT8_C(   0),
                           INT8_C( -67), INT8_C( -67), INT8_C( -67), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -67),
                           INT8_C( -67), INT8_C( -67), INT8_C(   0), INT8_C( -67),
                           INT8_C(   0), INT8_C(   0), INT8_C( -67), INT8_C(   0),
                           INT8_C( -67), INT8_C(   0), INT8_C( -67), INT8_C(   0),
                           INT8_C( -67), INT8_C( -67), INT8_C(   0), INT8_C( -67),
                           INT8_C( -67), INT8_C(   0), INT8_C( -67), INT8_C(   0),
                           INT8_C( -67), INT8_C( -67), INT8_C( -67), INT8_C( -67),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -67),
                           INT8_C( -67), INT8_C( -67), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C(16804997844821669286),
      INT8_C( -98),
      simde_mm512_set_epi8(INT8_C( -98), INT8_C( -98), INT8_C( -98), INT8_C(   0),
                           INT8_C( -98), INT8_C(   0), INT8_C(   0), INT8_C( -98),
                           INT8_C(   0), INT8_C(   0), INT8_C( -98), INT8_C( -98),
                           INT8_C(   0), INT8_C( -98), INT8_C( -98), INT8_C( -98),
                           INT8_C(   0), INT8_C( -98), INT8_C(   0), INT8_C( -98),
                           INT8_C( -98), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -98), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -98), INT8_C( -98), INT8_C(   0), INT8_C(   0),
                           INT8_C( -98), INT8_C( -98), INT8_C( -98), INT8_C( -98),
                           INT8_C( -98), INT8_C( -98), INT8_C(   0), INT8_C(   0),
                           INT8_C( -98), INT8_C( -98), INT8_C(   0), INT8_C(   0),
                           INT8_C( -98), INT8_C( -98), INT8_C( -98), INT8_C( -98),
                           INT8_C(   0), INT8_C( -98), INT8_C(   0), INT8_C( -98),
                           INT8_C( -98), INT8_C(   0), INT8_C( -98), INT8_C(   0),
                           INT8_C(   0), INT8_C( -98), INT8_C( -98), INT8_C(   0)) },
    { UINT64_C(14388383136321922859),
      INT8_C( -31),
      simde_mm512_set_epi8(INT8_C( -31), INT8_C( -31), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -31), INT8_C( -31), INT8_C( -31),
                           INT8_C( -31), INT8_C(   0), INT8_C( -31), INT8_C(   0),
                           INT8_C( -31), INT8_C( -31), INT8_C(   0), INT8_C( -31),
                           INT8_C( -31), INT8_C( -31), INT8_C(   0), INT8_C(   0),
                           INT8_C( -31), INT8_C( -31), INT8_C( -31), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -31), INT8_C( -31),
                           INT8_C( -31), INT8_C(   0), INT8_C( -31), INT8_C(   0),
                           INT8_C( -31), INT8_C( -31), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -31), INT8_C(   0), INT8_C(   0),
                           INT8_C( -31), INT8_C(   0), INT8_C( -31), INT8_C( -31),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -31), INT8_C( -31), INT8_C(   0),
                           INT8_C(   0), INT8_C( -31), INT8_C( -31), INT8_C( -31),
                           INT8_C(   0), INT8_C(   0), INT8_C( -31), INT8_C(   0),
                           INT8_C( -31), INT8_C(   0), INT8_C( -31), INT8_C( -31)) },
    { UINT64_C( 9693935732927043828),
      INT8_C(  57),
      simde_mm512_set_epi8(INT8_C(  57), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  57), INT8_C(  57), INT8_C(   0),
                           INT8_C(  57), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  57), INT8_C(  57), INT8_C(  57),
                           INT8_C(  57), INT8_C(  57), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  57), INT8_C(  57), INT8_C(  57),
                           INT8_C(   0), INT8_C(   0), INT8_C(  57), INT8_C(  57),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  57), INT8_C(  57),
                           INT8_C(  57), INT8_C(  57), INT8_C(   0), INT8_C(   0),
                           INT8_C(  57), INT8_C(   0), INT8_C(   0), INT8_C(  57),
                           INT8_C(   0), INT8_C(  57), INT8_C(   0), INT8_C(  57),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  57),
                           INT8_C(  57), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  57), INT8_C(  57), INT8_C(  57), INT8_C(  57),
                           INT8_C(   0), INT8_C(  57), INT8_C(   0), INT8_C(   0)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_maskz_set1_epi8(test_vec[i].k, test_vec[i].a);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_mask_set1_epi16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i src;
    simde__mmask32 k;
    int16_t a;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi16(INT16_C(   874), INT16_C( 15357), INT16_C(  3602), INT16_C( 11090),
                            INT16_C( 31475), INT16_C( 20808), INT16_C(-26328), INT16_C(-21794),
                            INT16_C(-24829), INT16_C(-15530), INT16_C( -9785), INT16_C( 22806),
                            INT16_C( -6385), INT16_C(-26604), INT16_C(-15351), INT16_C(-18936),
                            INT16_C( 28985), INT16_C( 24045), INT16_C(-25535), INT16_C(-25436),
                            INT16_C(   749), INT16_C( 15517), INT16_C(-24369), INT16_C(-27864),
                            INT16_C(  6864), INT16_C( 16553), INT16_C(  -407), INT16_C(-28514),
                            INT16_C( -9423), INT16_C(-29018), INT16_C(-11420), INT16_C(-22112)),
      UINT32_C(1121120418),
      INT16_C(-24380),
      simde_mm512_set_epi16(INT16_C(   874), INT16_C(-24380), INT16_C(  3602), INT16_C( 11090),
                            INT16_C( 31475), INT16_C( 20808), INT16_C(-24380), INT16_C(-21794),
                            INT16_C(-24380), INT16_C(-24380), INT16_C( -9785), INT16_C(-24380),
                            INT16_C( -6385), INT16_C(-26604), INT16_C(-24380), INT16_C(-18936),
                            INT16_C(-24380), INT16_C(-24380), INT16_C(-24380), INT16_C(-24380),
                            INT16_C(   749), INT16_C( 15517), INT16_C(-24369), INT16_C(-27864),
                            INT16_C(-24380), INT16_C( 16553), INT16_C(-24380), INT16_C(-28514),
                            INT16_C( -9423), INT16_C(-29018), INT16_C(-24380), INT16_C(-22112)) },
    { simde_mm512_set_epi16(INT16_C( 21630), INT16_C(    53), INT16_C(-30787), INT16_C( 11298),
                            INT16_C( 13120), INT16_C(-15891), INT16_C( 20834), INT16_C(  5170),
                            INT16_C( 11237), INT16_C(-32025), INT16_C(  2036), INT16_C(-32146),
                            INT16_C(  6820), INT16_C( 29964), INT16_C(-20673), INT16_C( -6255),
                            INT16_C( 12677), INT16_C(  5934), INT16_C( 18392), INT16_C(-16008),
                            INT16_C( -6967), INT16_C(-23263), INT16_C( 28759), INT16_C(  4932),
                            INT16_C(-20928), INT16_C(-12287), INT16_C(-21100), INT16_C(-15604),
                            INT16_C(-25734), INT16_C(-27889), INT16_C( 22154), INT16_C( 16749)),
      UINT32_C( 442706120),
      INT16_C(-18045),
      simde_mm512_set_epi16(INT16_C( 21630), INT16_C(    53), INT16_C(-30787), INT16_C(-18045),
                            INT16_C(-18045), INT16_C(-15891), INT16_C(-18045), INT16_C(  5170),
                            INT16_C( 11237), INT16_C(-18045), INT16_C(-18045), INT16_C(-32146),
                            INT16_C(  6820), INT16_C( 29964), INT16_C(-18045), INT16_C(-18045),
                            INT16_C( 12677), INT16_C(  5934), INT16_C(-18045), INT16_C(-16008),
                            INT16_C(-18045), INT16_C(-23263), INT16_C( 28759), INT16_C(  4932),
                            INT16_C(-18045), INT16_C(-18045), INT16_C(-21100), INT16_C(-15604),
                            INT16_C(-18045), INT16_C(-27889), INT16_C( 22154), INT16_C( 16749)) },
    { simde_mm512_set_epi16(INT16_C(-12675), INT16_C(-13885), INT16_C( -4000), INT16_C( 31908),
                            INT16_C( 16178), INT16_C( -8662), INT16_C(-27877), INT16_C(-11427),
                            INT16_C(-10847), INT16_C(  7965), INT16_C(-13767), INT16_C( 14192),
                            INT16_C( -3024), INT16_C(-20651), INT16_C(  1677), INT16_C(-14378),
                            INT16_C( 13823), INT16_C(-21716), INT16_C(-14569), INT16_C( 19205),
                            INT16_C(-19335), INT16_C( 31769), INT16_C(-13133), INT16_C(-12032),
                            INT16_C(-27851), INT16_C(-12954), INT16_C(-30941), INT16_C( 26210),
                            INT16_C( 10250), INT16_C(-12883), INT16_C(-31618), INT16_C(  -328)),
      UINT32_C(3083705480),
      INT16_C(  4440),
      simde_mm512_set_epi16(INT16_C(  4440), INT16_C(-13885), INT16_C(  4440), INT16_C(  4440),
                            INT16_C( 16178), INT16_C(  4440), INT16_C(  4440), INT16_C(  4440),
                            INT16_C(  4440), INT16_C(  4440), INT16_C(-13767), INT16_C( 14192),
                            INT16_C(  4440), INT16_C(  4440), INT16_C(  1677), INT16_C(  4440),
                            INT16_C(  4440), INT16_C(-21716), INT16_C(-14569), INT16_C(  4440),
                            INT16_C(  4440), INT16_C(  4440), INT16_C(-13133), INT16_C(-12032),
                            INT16_C(  4440), INT16_C(-12954), INT16_C(-30941), INT16_C( 26210),
                            INT16_C(  4440), INT16_C(-12883), INT16_C(-31618), INT16_C(  -328)) },
    { simde_mm512_set_epi16(INT16_C(-23201), INT16_C(  4909), INT16_C(-10596), INT16_C( 25003),
                            INT16_C( 25193), INT16_C(-28193), INT16_C(  7484), INT16_C( 22842),
                            INT16_C( 12827), INT16_C(-21490), INT16_C(-19021), INT16_C( 17939),
                            INT16_C( 14187), INT16_C( 31294), INT16_C(-22999), INT16_C( 25206),
                            INT16_C(-22002), INT16_C( 23505), INT16_C(-20713), INT16_C( 22238),
                            INT16_C( 29284), INT16_C( 28054), INT16_C(-21727), INT16_C( 30369),
                            INT16_C( 19358), INT16_C(  -623), INT16_C(  2386), INT16_C(  9395),
                            INT16_C(-11819), INT16_C( 28599), INT16_C(-11863), INT16_C( -4500)),
      UINT32_C(1729799485),
      INT16_C(   -51),
      simde_mm512_set_epi16(INT16_C(-23201), INT16_C(   -51), INT16_C(   -51), INT16_C( 25003),
                            INT16_C( 25193), INT16_C(   -51), INT16_C(   -51), INT16_C(   -51),
                            INT16_C( 12827), INT16_C(-21490), INT16_C(-19021), INT16_C(   -51),
                            INT16_C(   -51), INT16_C( 31294), INT16_C(   -51), INT16_C( 25206),
                            INT16_C(   -51), INT16_C( 23505), INT16_C(   -51), INT16_C( 22238),
                            INT16_C( 29284), INT16_C(   -51), INT16_C(-21727), INT16_C(   -51),
                            INT16_C( 19358), INT16_C(  -623), INT16_C(   -51), INT16_C(   -51),
                            INT16_C(   -51), INT16_C(   -51), INT16_C(-11863), INT16_C(   -51)) },
    { simde_mm512_set_epi16(INT16_C(-12929), INT16_C( -9559), INT16_C( -1255), INT16_C(-25300),
                            INT16_C( 24130), INT16_C( 22555), INT16_C(-26496), INT16_C(  4179),
                            INT16_C( 25227), INT16_C( 31028), INT16_C( 12492), INT16_C(-27096),
                            INT16_C( 22382), INT16_C( -5113), INT16_C(-30455), INT16_C( 15691),
                            INT16_C(-18605), INT16_C( -4278), INT16_C( 11441), INT16_C(-26478),
                            INT16_C( 11388), INT16_C(-27754), INT16_C(   607), INT16_C( -1601),
                            INT16_C(-14454), INT16_C(  1251), INT16_C( 27178), INT16_C( 11399),
                            INT16_C(  -184), INT16_C( 17990), INT16_C(-12132), INT16_C(-20400)),
      UINT32_C(3701546889),
      INT16_C( 26765),
      simde_mm512_set_epi16(INT16_C( 26765), INT16_C( 26765), INT16_C( -1255), INT16_C( 26765),
                            INT16_C( 26765), INT16_C( 26765), INT16_C(-26496), INT16_C(  4179),
                            INT16_C( 26765), INT16_C( 31028), INT16_C( 26765), INT16_C(-27096),
                            INT16_C( 22382), INT16_C( -5113), INT16_C(-30455), INT16_C( 26765),
                            INT16_C(-18605), INT16_C( -4278), INT16_C( 11441), INT16_C( 26765),
                            INT16_C( 26765), INT16_C( 26765), INT16_C( 26765), INT16_C( 26765),
                            INT16_C( 26765), INT16_C(  1251), INT16_C( 27178), INT16_C( 11399),
                            INT16_C( 26765), INT16_C( 17990), INT16_C(-12132), INT16_C( 26765)) },
    { simde_mm512_set_epi16(INT16_C( 23556), INT16_C( 11192), INT16_C(-13439), INT16_C( -2357),
                            INT16_C(   858), INT16_C( 27575), INT16_C( 20368), INT16_C(-20256),
                            INT16_C(-11019), INT16_C( -7073), INT16_C(-32385), INT16_C( 27749),
                            INT16_C( 17332), INT16_C(-28131), INT16_C( 22510), INT16_C(  -872),
                            INT16_C( 20986), INT16_C(-25896), INT16_C(  7561), INT16_C(-22951),
                            INT16_C( -9997), INT16_C( 18542), INT16_C( -1921), INT16_C(-16319),
                            INT16_C(-24759), INT16_C( 10467), INT16_C(  8453), INT16_C(  5278),
                            INT16_C(-22217), INT16_C( 17080), INT16_C( 16797), INT16_C( -9777)),
      UINT32_C(3298748633),
      INT16_C( -5240),
      simde_mm512_set_epi16(INT16_C( -5240), INT16_C( -5240), INT16_C(-13439), INT16_C( -2357),
                            INT16_C(   858), INT16_C( -5240), INT16_C( 20368), INT16_C(-20256),
                            INT16_C( -5240), INT16_C( -7073), INT16_C(-32385), INT16_C( -5240),
                            INT16_C( -5240), INT16_C( -5240), INT16_C( -5240), INT16_C(  -872),
                            INT16_C( -5240), INT16_C( -5240), INT16_C( -5240), INT16_C(-22951),
                            INT16_C( -5240), INT16_C( 18542), INT16_C( -1921), INT16_C(-16319),
                            INT16_C( -5240), INT16_C( -5240), INT16_C(  8453), INT16_C( -5240),
                            INT16_C( -5240), INT16_C( 17080), INT16_C( 16797), INT16_C( -5240)) },
    { simde_mm512_set_epi16(INT16_C(  -894), INT16_C( 15324), INT16_C(-23364), INT16_C( 25648),
                            INT16_C(  -512), INT16_C( 12172), INT16_C(-27706), INT16_C(-10514),
                            INT16_C(  1026), INT16_C( 20384), INT16_C(-25471), INT16_C( -3464),
                            INT16_C( 14827), INT16_C( 18045), INT16_C(-25826), INT16_C( 12664),
                            INT16_C(-16682), INT16_C( 16498), INT16_C( 29333), INT16_C(  -511),
                            INT16_C( 15382), INT16_C(-19710), INT16_C(-14139), INT16_C( 14459),
                            INT16_C( 16092), INT16_C(-12889), INT16_C(  -337), INT16_C( 29893),
                            INT16_C(-29467), INT16_C( -8274), INT16_C( 30322), INT16_C(-19138)),
      UINT32_C(3605268017),
      INT16_C(-14523),
      simde_mm512_set_epi16(INT16_C(-14523), INT16_C(-14523), INT16_C(-23364), INT16_C(-14523),
                            INT16_C(  -512), INT16_C(-14523), INT16_C(-14523), INT16_C(-10514),
                            INT16_C(-14523), INT16_C(-14523), INT16_C(-14523), INT16_C( -3464),
                            INT16_C( 14827), INT16_C(-14523), INT16_C(-25826), INT16_C( 12664),
                            INT16_C(-16682), INT16_C( 16498), INT16_C( 29333), INT16_C(  -511),
                            INT16_C( 15382), INT16_C(-14523), INT16_C(-14523), INT16_C( 14459),
                            INT16_C( 16092), INT16_C(-12889), INT16_C(-14523), INT16_C(-14523),
                            INT16_C(-29467), INT16_C( -8274), INT16_C( 30322), INT16_C(-14523)) },
    { simde_mm512_set_epi16(INT16_C( -6967), INT16_C(-20070), INT16_C( -8289), INT16_C(  -479),
                            INT16_C(-18969), INT16_C( -6012), INT16_C( 11721), INT16_C( 13564),
                            INT16_C( 19765), INT16_C( 23581), INT16_C(-21527), INT16_C( -2847),
                            INT16_C( 23178), INT16_C(-14967), INT16_C( 17682), INT16_C( 28255),
                            INT16_C(  8882), INT16_C( 14691), INT16_C(-27903), INT16_C( 28973),
                            INT16_C(   619), INT16_C(-10329), INT16_C( 25572), INT16_C(-13439),
                            INT16_C( -3930), INT16_C(  5659), INT16_C(  -675), INT16_C(-18004),
                            INT16_C(-26191), INT16_C(  5303), INT16_C(-13369), INT16_C( 21695)),
      UINT32_C( 349570055),
      INT16_C( 24210),
      simde_mm512_set_epi16(INT16_C( -6967), INT16_C(-20070), INT16_C( -8289), INT16_C( 24210),
                            INT16_C(-18969), INT16_C( 24210), INT16_C( 11721), INT16_C( 13564),
                            INT16_C( 24210), INT16_C( 24210), INT16_C(-21527), INT16_C( 24210),
                            INT16_C( 23178), INT16_C( 24210), INT16_C( 24210), INT16_C( 28255),
                            INT16_C(  8882), INT16_C( 14691), INT16_C(-27903), INT16_C( 28973),
                            INT16_C(   619), INT16_C( 24210), INT16_C( 25572), INT16_C(-13439),
                            INT16_C( -3930), INT16_C(  5659), INT16_C(  -675), INT16_C(-18004),
                            INT16_C(-26191), INT16_C( 24210), INT16_C( 24210), INT16_C( 24210)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_mask_set1_epi16(test_vec[i].src, test_vec[i].k, test_vec[i].a);
    simde_assert_m512i_i16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_maskz_set1_epi16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__mmask32 k;
    int16_t a;
    simde__m512i r;
  } test_vec[8] = {
   {  UINT32_C( 693683203),
      INT16_C(-16188),
      simde_mm512_set_epi16(INT16_C(     0), INT16_C(     0), INT16_C(-16188), INT16_C(     0),
                            INT16_C(-16188), INT16_C(     0), INT16_C(     0), INT16_C(-16188),
                            INT16_C(     0), INT16_C(-16188), INT16_C(     0), INT16_C(-16188),
                            INT16_C(-16188), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(-16188), INT16_C(-16188), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(-16188), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(-16188), INT16_C(-16188)) },
   {  UINT32_C(2322862674),
      INT16_C(-31832),
      simde_mm512_set_epi16(INT16_C(-31832), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(-31832), INT16_C(     0), INT16_C(-31832), INT16_C(     0),
                            INT16_C(     0), INT16_C(-31832), INT16_C(-31832), INT16_C(-31832),
                            INT16_C(     0), INT16_C(-31832), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(-31832),
                            INT16_C(     0), INT16_C(     0), INT16_C(-31832), INT16_C(     0),
                            INT16_C(     0), INT16_C(-31832), INT16_C(     0), INT16_C(-31832),
                            INT16_C(     0), INT16_C(     0), INT16_C(-31832), INT16_C(     0)) },
   {  UINT32_C(3196780114),
      INT16_C(  8083),
      simde_mm512_set_epi16(INT16_C(  8083), INT16_C(     0), INT16_C(  8083), INT16_C(  8083),
                            INT16_C(  8083), INT16_C(  8083), INT16_C(  8083), INT16_C(     0),
                            INT16_C(  8083), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(  8083), INT16_C(     0), INT16_C(  8083), INT16_C(     0),
                            INT16_C(  8083), INT16_C(  8083), INT16_C(  8083), INT16_C(  8083),
                            INT16_C(  8083), INT16_C(  8083), INT16_C(  8083), INT16_C(     0),
                            INT16_C(     0), INT16_C(  8083), INT16_C(     0), INT16_C(  8083),
                            INT16_C(     0), INT16_C(     0), INT16_C(  8083), INT16_C(     0)) },
   {  UINT32_C( 962615778),
      INT16_C( 10134),
      simde_mm512_set_epi16(INT16_C(     0), INT16_C(     0), INT16_C( 10134), INT16_C( 10134),
                            INT16_C( 10134), INT16_C(     0), INT16_C(     0), INT16_C( 10134),
                            INT16_C(     0), INT16_C( 10134), INT16_C( 10134), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C( 10134), INT16_C(     0), INT16_C( 10134),
                            INT16_C( 10134), INT16_C(     0), INT16_C(     0), INT16_C( 10134),
                            INT16_C( 10134), INT16_C( 10134), INT16_C( 10134), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C( 10134), INT16_C(     0)) },
   {  UINT32_C(3651012064),
      INT16_C(-28841),
      simde_mm512_set_epi16(INT16_C(-28841), INT16_C(-28841), INT16_C(     0), INT16_C(-28841),
                            INT16_C(-28841), INT16_C(     0), INT16_C(     0), INT16_C(-28841),
                            INT16_C(-28841), INT16_C(     0), INT16_C(     0), INT16_C(-28841),
                            INT16_C(-28841), INT16_C(-28841), INT16_C(-28841), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(-28841), INT16_C(     0), INT16_C(-28841),
                            INT16_C(-28841), INT16_C(-28841), INT16_C(-28841), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0)) },
   {  UINT32_C(1153035128),
      INT16_C(  9546),
      simde_mm512_set_epi16(INT16_C(     0), INT16_C(  9546), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(  9546), INT16_C(     0), INT16_C(     0),
                            INT16_C(  9546), INT16_C(     0), INT16_C(  9546), INT16_C(  9546),
                            INT16_C(  9546), INT16_C(     0), INT16_C(     0), INT16_C(  9546),
                            INT16_C(  9546), INT16_C(  9546), INT16_C(  9546), INT16_C(     0),
                            INT16_C(  9546), INT16_C(     0), INT16_C(  9546), INT16_C(  9546),
                            INT16_C(     0), INT16_C(  9546), INT16_C(  9546), INT16_C(  9546),
                            INT16_C(  9546), INT16_C(     0), INT16_C(     0), INT16_C(     0)) },
   {  UINT32_C(2648275992),
      INT16_C(-29002),
      simde_mm512_set_epi16(INT16_C(-29002), INT16_C(     0), INT16_C(     0), INT16_C(-29002),
                            INT16_C(-29002), INT16_C(-29002), INT16_C(     0), INT16_C(-29002),
                            INT16_C(-29002), INT16_C(-29002), INT16_C(     0), INT16_C(-29002),
                            INT16_C(-29002), INT16_C(     0), INT16_C(     0), INT16_C(-29002),
                            INT16_C(     0), INT16_C(-29002), INT16_C(-29002), INT16_C(-29002),
                            INT16_C(-29002), INT16_C(-29002), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(-29002),
                            INT16_C(-29002), INT16_C(     0), INT16_C(     0), INT16_C(     0)) },
   {  UINT32_C(1548742660),
      INT16_C( 11362),
      simde_mm512_set_epi16(INT16_C(     0), INT16_C( 11362), INT16_C(     0), INT16_C( 11362),
                            INT16_C( 11362), INT16_C( 11362), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C( 11362), INT16_C(     0), INT16_C(     0),
                            INT16_C( 11362), INT16_C( 11362), INT16_C( 11362), INT16_C( 11362),
                            INT16_C( 11362), INT16_C( 11362), INT16_C( 11362), INT16_C( 11362),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C( 11362), INT16_C(     0), INT16_C(     0)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_maskz_set1_epi16(test_vec[i].k, test_vec[i].a);
    simde_assert_m512i_i16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_abs_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i a;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C( -97), INT8_C(  22), INT8_C(  -8), INT8_C(-101),
                           INT8_C( -18), INT8_C( 124), INT8_C( -73), INT8_C( -35),
                           INT8_C(-107), INT8_C( 125), INT8_C( -49), INT8_C( -14),
                           INT8_C( -55), INT8_C(  -2), INT8_C(   3), INT8_C( -86),
                           INT8_C( -70), INT8_C( -16), INT8_C(  -3), INT8_C( -98),
                           INT8_C( -20), INT8_C( -18), INT8_C( -58), INT8_C( -57),
                           INT8_C( 119), INT8_C(  17), INT8_C( -79), INT8_C(  80),
                           INT8_C(  82), INT8_C(   3), INT8_C( -18), INT8_C( -99),
                           INT8_C(  25), INT8_C(  25), INT8_C(  83), INT8_C(  88),
                           INT8_C( 117), INT8_C(-128), INT8_C(  16), INT8_C( -42),
                           INT8_C( 114), INT8_C(  -1), INT8_C(-110), INT8_C(  53),
                           INT8_C( 127), INT8_C( -61), INT8_C( -68), INT8_C(  74),
                           INT8_C( 103), INT8_C(  92), INT8_C(-115), INT8_C( -60),
                           INT8_C( -23), INT8_C(  82), INT8_C(-123), INT8_C(  21),
                           INT8_C( -37), INT8_C( 119), INT8_C( -39), INT8_C( -31),
                           INT8_C(  25), INT8_C( -69), INT8_C( -57), INT8_C(  30)),
      simde_mm512_set_epi8(INT8_C(  97), INT8_C(  22), INT8_C(   8), INT8_C( 101),
                           INT8_C(  18), INT8_C( 124), INT8_C(  73), INT8_C(  35),
                           INT8_C( 107), INT8_C( 125), INT8_C(  49), INT8_C(  14),
                           INT8_C(  55), INT8_C(   2), INT8_C(   3), INT8_C(  86),
                           INT8_C(  70), INT8_C(  16), INT8_C(   3), INT8_C(  98),
                           INT8_C(  20), INT8_C(  18), INT8_C(  58), INT8_C(  57),
                           INT8_C( 119), INT8_C(  17), INT8_C(  79), INT8_C(  80),
                           INT8_C(  82), INT8_C(   3), INT8_C(  18), INT8_C(  99),
                           INT8_C(  25), INT8_C(  25), INT8_C(  83), INT8_C(  88),
                           INT8_C( 117), INT8_C(-128), INT8_C(  16), INT8_C(  42),
                           INT8_C( 114), INT8_C(   1), INT8_C( 110), INT8_C(  53),
                           INT8_C( 127), INT8_C(  61), INT8_C(  68), INT8_C(  74),
                           INT8_C( 103), INT8_C(  92), INT8_C( 115), INT8_C(  60),
                           INT8_C(  23), INT8_C(  82), INT8_C( 123), INT8_C(  21),
                           INT8_C(  37), INT8_C( 119), INT8_C(  39), INT8_C(  31),
                           INT8_C(  25), INT8_C(  69), INT8_C(  57), INT8_C(  30)) },
    { simde_mm512_set_epi8(INT8_C( 122), INT8_C(  62), INT8_C( -43), INT8_C( -88),
                           INT8_C(  92), INT8_C(-116), INT8_C(  -6), INT8_C(  36),
                           INT8_C(  10), INT8_C(   2), INT8_C( -66), INT8_C( 108),
                           INT8_C( -38), INT8_C( 112), INT8_C( 123), INT8_C(  87),
                           INT8_C(  99), INT8_C( -46), INT8_C( -53), INT8_C(  41),
                           INT8_C(-105), INT8_C( -98), INT8_C(  18), INT8_C( -12),
                           INT8_C( -82), INT8_C( 126), INT8_C( -77), INT8_C( -19),
                           INT8_C(  18), INT8_C(  16), INT8_C(  35), INT8_C( -10),
                           INT8_C( -58), INT8_C(  48), INT8_C(-120), INT8_C(  38),
                           INT8_C(  62), INT8_C(  17), INT8_C(  33), INT8_C(-120),
                           INT8_C( 106), INT8_C(  25), INT8_C( -91), INT8_C(  15),
                           INT8_C( 101), INT8_C( 114), INT8_C( -46), INT8_C( -58),
                           INT8_C( 113), INT8_C(   4), INT8_C(  50), INT8_C(  42),
                           INT8_C(  -1), INT8_C( -29), INT8_C( -27), INT8_C( -23),
                           INT8_C( -69), INT8_C(  92), INT8_C( -67), INT8_C(  89),
                           INT8_C( -10), INT8_C( -42), INT8_C(  79), INT8_C( 112)),
      simde_mm512_set_epi8(INT8_C( 122), INT8_C(  62), INT8_C(  43), INT8_C(  88),
                           INT8_C(  92), INT8_C( 116), INT8_C(   6), INT8_C(  36),
                           INT8_C(  10), INT8_C(   2), INT8_C(  66), INT8_C( 108),
                           INT8_C(  38), INT8_C( 112), INT8_C( 123), INT8_C(  87),
                           INT8_C(  99), INT8_C(  46), INT8_C(  53), INT8_C(  41),
                           INT8_C( 105), INT8_C(  98), INT8_C(  18), INT8_C(  12),
                           INT8_C(  82), INT8_C( 126), INT8_C(  77), INT8_C(  19),
                           INT8_C(  18), INT8_C(  16), INT8_C(  35), INT8_C(  10),
                           INT8_C(  58), INT8_C(  48), INT8_C( 120), INT8_C(  38),
                           INT8_C(  62), INT8_C(  17), INT8_C(  33), INT8_C( 120),
                           INT8_C( 106), INT8_C(  25), INT8_C(  91), INT8_C(  15),
                           INT8_C( 101), INT8_C( 114), INT8_C(  46), INT8_C(  58),
                           INT8_C( 113), INT8_C(   4), INT8_C(  50), INT8_C(  42),
                           INT8_C(   1), INT8_C(  29), INT8_C(  27), INT8_C(  23),
                           INT8_C(  69), INT8_C(  92), INT8_C(  67), INT8_C(  89),
                           INT8_C(  10), INT8_C(  42), INT8_C(  79), INT8_C( 112)) },
    { simde_mm512_set_epi8(INT8_C(-115), INT8_C( 121), INT8_C( -28), INT8_C( -32),
                           INT8_C(  39), INT8_C(  97), INT8_C( 104), INT8_C( -44),
                           INT8_C( 120), INT8_C( -11), INT8_C( -74), INT8_C( -63),
                           INT8_C( -24), INT8_C( -35), INT8_C(-108), INT8_C(  -9),
                           INT8_C(  30), INT8_C( -94), INT8_C(  96), INT8_C(-119),
                           INT8_C( -14), INT8_C( -94), INT8_C(  34), INT8_C(-111),
                           INT8_C(  86), INT8_C(  -6), INT8_C(-116), INT8_C(  56),
                           INT8_C(  -2), INT8_C(  -8), INT8_C( -66), INT8_C(  73),
                           INT8_C(-111), INT8_C(  20), INT8_C( 114), INT8_C(  16),
                           INT8_C(  71), INT8_C(  17), INT8_C( -13), INT8_C(-101),
                           INT8_C(  32), INT8_C(  52), INT8_C(  -6), INT8_C( -16),
                           INT8_C(  78), INT8_C(  58), INT8_C(  14), INT8_C( -85),
                           INT8_C( -58), INT8_C( 120), INT8_C( 102), INT8_C(-125),
                           INT8_C(  73), INT8_C(-121), INT8_C(-118), INT8_C( -77),
                           INT8_C(  84), INT8_C(  62), INT8_C( 100), INT8_C(-122),
                           INT8_C( -17), INT8_C(  81), INT8_C( 105), INT8_C( -71)),
      simde_mm512_set_epi8(INT8_C( 115), INT8_C( 121), INT8_C(  28), INT8_C(  32),
                           INT8_C(  39), INT8_C(  97), INT8_C( 104), INT8_C(  44),
                           INT8_C( 120), INT8_C(  11), INT8_C(  74), INT8_C(  63),
                           INT8_C(  24), INT8_C(  35), INT8_C( 108), INT8_C(   9),
                           INT8_C(  30), INT8_C(  94), INT8_C(  96), INT8_C( 119),
                           INT8_C(  14), INT8_C(  94), INT8_C(  34), INT8_C( 111),
                           INT8_C(  86), INT8_C(   6), INT8_C( 116), INT8_C(  56),
                           INT8_C(   2), INT8_C(   8), INT8_C(  66), INT8_C(  73),
                           INT8_C( 111), INT8_C(  20), INT8_C( 114), INT8_C(  16),
                           INT8_C(  71), INT8_C(  17), INT8_C(  13), INT8_C( 101),
                           INT8_C(  32), INT8_C(  52), INT8_C(   6), INT8_C(  16),
                           INT8_C(  78), INT8_C(  58), INT8_C(  14), INT8_C(  85),
                           INT8_C(  58), INT8_C( 120), INT8_C( 102), INT8_C( 125),
                           INT8_C(  73), INT8_C( 121), INT8_C( 118), INT8_C(  77),
                           INT8_C(  84), INT8_C(  62), INT8_C( 100), INT8_C( 122),
                           INT8_C(  17), INT8_C(  81), INT8_C( 105), INT8_C(  71)) },
    { simde_mm512_set_epi8(INT8_C( 104), INT8_C(  89), INT8_C(  23), INT8_C( -69),
                           INT8_C( -81), INT8_C( -18), INT8_C(-115), INT8_C(  45),
                           INT8_C( 111), INT8_C(  97), INT8_C( -96), INT8_C( -52),
                           INT8_C( 117), INT8_C( -89), INT8_C(  83), INT8_C(  55),
                           INT8_C( -79), INT8_C( -41), INT8_C(  65), INT8_C( -18),
                           INT8_C( -14), INT8_C( -36), INT8_C(  -5), INT8_C(-118),
                           INT8_C( 102), INT8_C(  66), INT8_C(   6), INT8_C(  63),
                           INT8_C(   2), INT8_C(  71), INT8_C( -79), INT8_C( 103),
                           INT8_C(  99), INT8_C(  75), INT8_C(  18), INT8_C(-125),
                           INT8_C(  89), INT8_C(  97), INT8_C( -12), INT8_C( -68),
                           INT8_C( -29), INT8_C(  64), INT8_C(  90), INT8_C( 106),
                           INT8_C( -66), INT8_C(  46), INT8_C( -67), INT8_C(-122),
                           INT8_C(  35), INT8_C(  89), INT8_C(-123), INT8_C(  49),
                           INT8_C(  79), INT8_C(-111), INT8_C( 102), INT8_C(  13),
                           INT8_C(  18), INT8_C(   7), INT8_C(  11), INT8_C( -54),
                           INT8_C(  79), INT8_C( -18), INT8_C(  80), INT8_C(  58)),
      simde_mm512_set_epi8(INT8_C( 104), INT8_C(  89), INT8_C(  23), INT8_C(  69),
                           INT8_C(  81), INT8_C(  18), INT8_C( 115), INT8_C(  45),
                           INT8_C( 111), INT8_C(  97), INT8_C(  96), INT8_C(  52),
                           INT8_C( 117), INT8_C(  89), INT8_C(  83), INT8_C(  55),
                           INT8_C(  79), INT8_C(  41), INT8_C(  65), INT8_C(  18),
                           INT8_C(  14), INT8_C(  36), INT8_C(   5), INT8_C( 118),
                           INT8_C( 102), INT8_C(  66), INT8_C(   6), INT8_C(  63),
                           INT8_C(   2), INT8_C(  71), INT8_C(  79), INT8_C( 103),
                           INT8_C(  99), INT8_C(  75), INT8_C(  18), INT8_C( 125),
                           INT8_C(  89), INT8_C(  97), INT8_C(  12), INT8_C(  68),
                           INT8_C(  29), INT8_C(  64), INT8_C(  90), INT8_C( 106),
                           INT8_C(  66), INT8_C(  46), INT8_C(  67), INT8_C( 122),
                           INT8_C(  35), INT8_C(  89), INT8_C( 123), INT8_C(  49),
                           INT8_C(  79), INT8_C( 111), INT8_C( 102), INT8_C(  13),
                           INT8_C(  18), INT8_C(   7), INT8_C(  11), INT8_C(  54),
                           INT8_C(  79), INT8_C(  18), INT8_C(  80), INT8_C(  58)) },
    { simde_mm512_set_epi8(INT8_C( -69), INT8_C( -18), INT8_C( -24), INT8_C(  31),
                           INT8_C(-118), INT8_C(  28), INT8_C( 111), INT8_C(   9),
                           INT8_C( -62), INT8_C(   2), INT8_C(  24), INT8_C(  57),
                           INT8_C(  60), INT8_C(  85), INT8_C(-124), INT8_C(   4),
                           INT8_C( -47), INT8_C(  -2), INT8_C( -42), INT8_C(   4),
                           INT8_C(-111), INT8_C(   1), INT8_C(  -7), INT8_C(  49),
                           INT8_C(  87), INT8_C(-117), INT8_C(  70), INT8_C( -68),
                           INT8_C(  92), INT8_C(  73), INT8_C( 108), INT8_C(   6),
                           INT8_C( 108), INT8_C( -36), INT8_C(  61), INT8_C(  29),
                           INT8_C(  87), INT8_C(  64), INT8_C(-117), INT8_C(  17),
                           INT8_C( -12), INT8_C(  46), INT8_C( -75), INT8_C(  42),
                           INT8_C(  80), INT8_C( -38), INT8_C(  85), INT8_C(-124),
                           INT8_C(-126), INT8_C( -12), INT8_C(  41), INT8_C(  12),
                           INT8_C( -57), INT8_C( -47), INT8_C(  80), INT8_C( -60),
                           INT8_C(  24), INT8_C(  89), INT8_C( -45), INT8_C(-122),
                           INT8_C( -52), INT8_C(  21), INT8_C(  54), INT8_C( 124)),
      simde_mm512_set_epi8(INT8_C(  69), INT8_C(  18), INT8_C(  24), INT8_C(  31),
                           INT8_C( 118), INT8_C(  28), INT8_C( 111), INT8_C(   9),
                           INT8_C(  62), INT8_C(   2), INT8_C(  24), INT8_C(  57),
                           INT8_C(  60), INT8_C(  85), INT8_C( 124), INT8_C(   4),
                           INT8_C(  47), INT8_C(   2), INT8_C(  42), INT8_C(   4),
                           INT8_C( 111), INT8_C(   1), INT8_C(   7), INT8_C(  49),
                           INT8_C(  87), INT8_C( 117), INT8_C(  70), INT8_C(  68),
                           INT8_C(  92), INT8_C(  73), INT8_C( 108), INT8_C(   6),
                           INT8_C( 108), INT8_C(  36), INT8_C(  61), INT8_C(  29),
                           INT8_C(  87), INT8_C(  64), INT8_C( 117), INT8_C(  17),
                           INT8_C(  12), INT8_C(  46), INT8_C(  75), INT8_C(  42),
                           INT8_C(  80), INT8_C(  38), INT8_C(  85), INT8_C( 124),
                           INT8_C( 126), INT8_C(  12), INT8_C(  41), INT8_C(  12),
                           INT8_C(  57), INT8_C(  47), INT8_C(  80), INT8_C(  60),
                           INT8_C(  24), INT8_C(  89), INT8_C(  45), INT8_C( 122),
                           INT8_C(  52), INT8_C(  21), INT8_C(  54), INT8_C( 124)) },
    { simde_mm512_set_epi8(INT8_C(  23), INT8_C( -45), INT8_C( -87), INT8_C(-128),
                           INT8_C(  79), INT8_C(  64), INT8_C( -72), INT8_C( 109),
                           INT8_C(  -1), INT8_C( 120), INT8_C( -18), INT8_C(-122),
                           INT8_C( -56), INT8_C(   0), INT8_C( 100), INT8_C(  60),
                           INT8_C( -78), INT8_C( -63), INT8_C(  26), INT8_C(  35),
                           INT8_C( -65), INT8_C(  72), INT8_C(  38), INT8_C( -77),
                           INT8_C(-123), INT8_C( 106), INT8_C(   7), INT8_C(  83),
                           INT8_C(  87), INT8_C( 105), INT8_C( -86), INT8_C(  65),
                           INT8_C( -41), INT8_C( 111), INT8_C( -74), INT8_C( -72),
                           INT8_C(  30), INT8_C( -92), INT8_C(  62), INT8_C( -69),
                           INT8_C( -56), INT8_C( 120), INT8_C(  86), INT8_C(  20),
                           INT8_C( -82), INT8_C(  72), INT8_C(  45), INT8_C(  66),
                           INT8_C( -71), INT8_C(-128), INT8_C( -35), INT8_C(  10),
                           INT8_C( -92), INT8_C( -41), INT8_C( 102), INT8_C( -89),
                           INT8_C(  47), INT8_C(  44), INT8_C(  12), INT8_C(  18),
                           INT8_C( -29), INT8_C( 113), INT8_C( -21), INT8_C( 122)),
      simde_mm512_set_epi8(INT8_C(  23), INT8_C(  45), INT8_C(  87), INT8_C(-128),
                           INT8_C(  79), INT8_C(  64), INT8_C(  72), INT8_C( 109),
                           INT8_C(   1), INT8_C( 120), INT8_C(  18), INT8_C( 122),
                           INT8_C(  56), INT8_C(   0), INT8_C( 100), INT8_C(  60),
                           INT8_C(  78), INT8_C(  63), INT8_C(  26), INT8_C(  35),
                           INT8_C(  65), INT8_C(  72), INT8_C(  38), INT8_C(  77),
                           INT8_C( 123), INT8_C( 106), INT8_C(   7), INT8_C(  83),
                           INT8_C(  87), INT8_C( 105), INT8_C(  86), INT8_C(  65),
                           INT8_C(  41), INT8_C( 111), INT8_C(  74), INT8_C(  72),
                           INT8_C(  30), INT8_C(  92), INT8_C(  62), INT8_C(  69),
                           INT8_C(  56), INT8_C( 120), INT8_C(  86), INT8_C(  20),
                           INT8_C(  82), INT8_C(  72), INT8_C(  45), INT8_C(  66),
                           INT8_C(  71), INT8_C(-128), INT8_C(  35), INT8_C(  10),
                           INT8_C(  92), INT8_C(  41), INT8_C( 102), INT8_C(  89),
                           INT8_C(  47), INT8_C(  44), INT8_C(  12), INT8_C(  18),
                           INT8_C(  29), INT8_C( 113), INT8_C(  21), INT8_C( 122)) },
    { simde_mm512_set_epi8(INT8_C(   6), INT8_C( -58), INT8_C( -97), INT8_C(  99),
                           INT8_C(  24), INT8_C( 108), INT8_C( -42), INT8_C( 116),
                           INT8_C( -51), INT8_C(  37), INT8_C(  17), INT8_C(  87),
                           INT8_C( 119), INT8_C(  22), INT8_C(  38), INT8_C( -86),
                           INT8_C(  70), INT8_C( -19), INT8_C( 116), INT8_C(   4),
                           INT8_C( -77), INT8_C( -68), INT8_C(  19), INT8_C( -39),
                           INT8_C(  -4), INT8_C(-120), INT8_C(  84), INT8_C( -27),
                           INT8_C( -68), INT8_C( 120), INT8_C(-117), INT8_C( -33),
                           INT8_C(   3), INT8_C( 109), INT8_C(  85), INT8_C( -14),
                           INT8_C( 121), INT8_C(  30), INT8_C( 108), INT8_C(  -1),
                           INT8_C( 114), INT8_C( -61), INT8_C(  46), INT8_C(  93),
                           INT8_C(  48), INT8_C( -57), INT8_C( -97), INT8_C(-100),
                           INT8_C(  84), INT8_C(   0), INT8_C( -87), INT8_C( -47),
                           INT8_C(  85), INT8_C(   2), INT8_C( 125), INT8_C(  35),
                           INT8_C( -12), INT8_C(  -7), INT8_C(   3), INT8_C(   4),
                           INT8_C(  86), INT8_C( 111), INT8_C( -66), INT8_C(  29)),
      simde_mm512_set_epi8(INT8_C(   6), INT8_C(  58), INT8_C(  97), INT8_C(  99),
                           INT8_C(  24), INT8_C( 108), INT8_C(  42), INT8_C( 116),
                           INT8_C(  51), INT8_C(  37), INT8_C(  17), INT8_C(  87),
                           INT8_C( 119), INT8_C(  22), INT8_C(  38), INT8_C(  86),
                           INT8_C(  70), INT8_C(  19), INT8_C( 116), INT8_C(   4),
                           INT8_C(  77), INT8_C(  68), INT8_C(  19), INT8_C(  39),
                           INT8_C(   4), INT8_C( 120), INT8_C(  84), INT8_C(  27),
                           INT8_C(  68), INT8_C( 120), INT8_C( 117), INT8_C(  33),
                           INT8_C(   3), INT8_C( 109), INT8_C(  85), INT8_C(  14),
                           INT8_C( 121), INT8_C(  30), INT8_C( 108), INT8_C(   1),
                           INT8_C( 114), INT8_C(  61), INT8_C(  46), INT8_C(  93),
                           INT8_C(  48), INT8_C(  57), INT8_C(  97), INT8_C( 100),
                           INT8_C(  84), INT8_C(   0), INT8_C(  87), INT8_C(  47),
                           INT8_C(  85), INT8_C(   2), INT8_C( 125), INT8_C(  35),
                           INT8_C(  12), INT8_C(   7), INT8_C(   3), INT8_C(   4),
                           INT8_C(  86), INT8_C( 111), INT8_C(  66), INT8_C(  29)) },
    { simde_mm512_set_epi8(INT8_C(  48), INT8_C(  61), INT8_C( 127), INT8_C(  76),
                           INT8_C( -86), INT8_C( 122), INT8_C( -96), INT8_C(-118),
                           INT8_C( -38), INT8_C(  -8), INT8_C(  56), INT8_C(-108),
                           INT8_C(   1), INT8_C(   8), INT8_C(  22), INT8_C(-116),
                           INT8_C( -52), INT8_C(  92), INT8_C(  68), INT8_C( 112),
                           INT8_C( -94), INT8_C( -84), INT8_C(  98), INT8_C( -49),
                           INT8_C( -43), INT8_C( 105), INT8_C(  71), INT8_C(  34),
                           INT8_C(-126), INT8_C(  -5), INT8_C(   5), INT8_C( -61),
                           INT8_C(-125), INT8_C( -31), INT8_C(-128), INT8_C( -41),
                           INT8_C(  82), INT8_C(  17), INT8_C( -47), INT8_C(-121),
                           INT8_C(   0), INT8_C( 118), INT8_C( -18), INT8_C( -96),
                           INT8_C(  45), INT8_C(  28), INT8_C( 105), INT8_C(-104),
                           INT8_C( -15), INT8_C(  24), INT8_C(  94), INT8_C( 103),
                           INT8_C( -54), INT8_C(-112), INT8_C(  15), INT8_C( 123),
                           INT8_C( -27), INT8_C( 121), INT8_C(-118), INT8_C(-112),
                           INT8_C( -70), INT8_C(  97), INT8_C(  58), INT8_C( -42)),
      simde_mm512_set_epi8(INT8_C(  48), INT8_C(  61), INT8_C( 127), INT8_C(  76),
                           INT8_C(  86), INT8_C( 122), INT8_C(  96), INT8_C( 118),
                           INT8_C(  38), INT8_C(   8), INT8_C(  56), INT8_C( 108),
                           INT8_C(   1), INT8_C(   8), INT8_C(  22), INT8_C( 116),
                           INT8_C(  52), INT8_C(  92), INT8_C(  68), INT8_C( 112),
                           INT8_C(  94), INT8_C(  84), INT8_C(  98), INT8_C(  49),
                           INT8_C(  43), INT8_C( 105), INT8_C(  71), INT8_C(  34),
                           INT8_C( 126), INT8_C(   5), INT8_C(   5), INT8_C(  61),
                           INT8_C( 125), INT8_C(  31), INT8_C(-128), INT8_C(  41),
                           INT8_C(  82), INT8_C(  17), INT8_C(  47), INT8_C( 121),
                           INT8_C(   0), INT8_C( 118), INT8_C(  18), INT8_C(  96),
                           INT8_C(  45), INT8_C(  28), INT8_C( 105), INT8_C( 104),
                           INT8_C(  15), INT8_C(  24), INT8_C(  94), INT8_C( 103),
                           INT8_C(  54), INT8_C( 112), INT8_C(  15), INT8_C( 123),
                           INT8_C(  27), INT8_C( 121), INT8_C( 118), INT8_C( 112),
                           INT8_C(  70), INT8_C(  97), INT8_C(  58), INT8_C(  42)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_abs_epi8(test_vec[i].a);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_mask_abs_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i src;
    simde__mmask64 k;
    simde__m512i a;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C( 117), INT8_C(-104), INT8_C( -35), INT8_C( -40),
                           INT8_C(  -1), INT8_C(  43), INT8_C(  10), INT8_C( -45),
                           INT8_C( -42), INT8_C(  80), INT8_C( -69), INT8_C( -15),
                           INT8_C( -14), INT8_C(-122), INT8_C(  60), INT8_C(  93),
                           INT8_C(  23), INT8_C( 122), INT8_C(  10), INT8_C( 108),
                           INT8_C( -24), INT8_C( -65), INT8_C( -39), INT8_C( -98),
                           INT8_C( -57), INT8_C(  -6), INT8_C(  81), INT8_C( -45),
                           INT8_C( -27), INT8_C(  28), INT8_C( -85), INT8_C(  15),
                           INT8_C(-118), INT8_C(  52), INT8_C(  10), INT8_C(-116),
                           INT8_C(  26), INT8_C( -43), INT8_C( -38), INT8_C( -27),
                           INT8_C(  66), INT8_C( -52), INT8_C(   5), INT8_C(  -1),
                           INT8_C( -28), INT8_C(   3), INT8_C( 123), INT8_C(-116),
                           INT8_C( -34), INT8_C( -32), INT8_C(  98), INT8_C( 103),
                           INT8_C( -19), INT8_C(-118), INT8_C( -77), INT8_C( -32),
                           INT8_C(  60), INT8_C( -80), INT8_C(  22), INT8_C( -26),
                           INT8_C(  60), INT8_C( -12), INT8_C( -65), INT8_C(  88)),
      UINT64_C(          2117573942),
      simde_mm512_set_epi8(INT8_C(  32), INT8_C(  22), INT8_C(  88), INT8_C( -34),
                           INT8_C(  12), INT8_C(  90), INT8_C(-101), INT8_C(  -4),
                           INT8_C( -14), INT8_C(  42), INT8_C( -87), INT8_C( 105),
                           INT8_C(  22), INT8_C(  34), INT8_C( 113), INT8_C( -72),
                           INT8_C( -40), INT8_C( -70), INT8_C( -24), INT8_C( -97),
                           INT8_C( -68), INT8_C(  -6), INT8_C(  98), INT8_C(-124),
                           INT8_C( -35), INT8_C(  11), INT8_C(-118), INT8_C( -49),
                           INT8_C( -42), INT8_C(  24), INT8_C( -34), INT8_C(  73),
                           INT8_C(  -3), INT8_C( -72), INT8_C(-103), INT8_C(  26),
                           INT8_C( -36), INT8_C(-109), INT8_C(  37), INT8_C(  50),
                           INT8_C(  26), INT8_C(  78), INT8_C(  33), INT8_C(  67),
                           INT8_C(  -8), INT8_C( -66), INT8_C(  29), INT8_C(  31),
                           INT8_C(  34), INT8_C(  40), INT8_C( -67), INT8_C(  86),
                           INT8_C(  38), INT8_C(-128), INT8_C(-106), INT8_C( -15),
                           INT8_C( 100), INT8_C(  53), INT8_C(  42), INT8_C(  55),
                           INT8_C(  87), INT8_C( -15), INT8_C(  -5), INT8_C( -85)),
      simde_mm512_set_epi8(INT8_C( 117), INT8_C(-104), INT8_C( -35), INT8_C( -40),
                           INT8_C(  -1), INT8_C(  43), INT8_C(  10), INT8_C( -45),
                           INT8_C( -42), INT8_C(  80), INT8_C( -69), INT8_C( -15),
                           INT8_C( -14), INT8_C(-122), INT8_C(  60), INT8_C(  93),
                           INT8_C(  23), INT8_C( 122), INT8_C(  10), INT8_C( 108),
                           INT8_C( -24), INT8_C( -65), INT8_C( -39), INT8_C( -98),
                           INT8_C( -57), INT8_C(  -6), INT8_C(  81), INT8_C( -45),
                           INT8_C( -27), INT8_C(  28), INT8_C( -85), INT8_C(  15),
                           INT8_C(-118), INT8_C(  72), INT8_C( 103), INT8_C(  26),
                           INT8_C(  36), INT8_C( 109), INT8_C(  37), INT8_C( -27),
                           INT8_C(  66), INT8_C( -52), INT8_C(  33), INT8_C(  67),
                           INT8_C( -28), INT8_C(  66), INT8_C(  29), INT8_C(  31),
                           INT8_C(  34), INT8_C( -32), INT8_C(  98), INT8_C(  86),
                           INT8_C(  38), INT8_C(-128), INT8_C( -77), INT8_C(  15),
                           INT8_C(  60), INT8_C( -80), INT8_C(  42), INT8_C(  55),
                           INT8_C(  60), INT8_C(  15), INT8_C(   5), INT8_C(  88)) },
    { simde_mm512_set_epi8(INT8_C( -27), INT8_C(-108), INT8_C(-117), INT8_C( -88),
                           INT8_C(-107), INT8_C(  53), INT8_C( -16), INT8_C(  -1),
                           INT8_C( -92), INT8_C(-119), INT8_C(  17), INT8_C(-122),
                           INT8_C(  22), INT8_C( -13), INT8_C(   7), INT8_C(-126),
                           INT8_C( -24), INT8_C( -51), INT8_C( -29), INT8_C(-114),
                           INT8_C( 100), INT8_C( -53), INT8_C(   0), INT8_C(-112),
                           INT8_C( -80), INT8_C(  89), INT8_C(  91), INT8_C(   1),
                           INT8_C( 102), INT8_C(  -2), INT8_C( -67), INT8_C( -88),
                           INT8_C(  -5), INT8_C( -85), INT8_C(  24), INT8_C(  13),
                           INT8_C(  67), INT8_C(  49), INT8_C(  20), INT8_C( -71),
                           INT8_C( -24), INT8_C(  19), INT8_C( -18), INT8_C(  58),
                           INT8_C( 109), INT8_C(-116), INT8_C(  95), INT8_C(  71),
                           INT8_C(  47), INT8_C( 118), INT8_C( -15), INT8_C( -31),
                           INT8_C( -70), INT8_C( -81), INT8_C(  45), INT8_C(  88),
                           INT8_C( -92), INT8_C(  95), INT8_C(  -3), INT8_C( -29),
                           INT8_C(  20), INT8_C( -86), INT8_C(  -5), INT8_C(  57)),
      UINT64_C(          3796566764),
      simde_mm512_set_epi8(INT8_C( -74), INT8_C(   1), INT8_C( -40), INT8_C(  93),
                           INT8_C(  28), INT8_C(  66), INT8_C(  14), INT8_C( 119),
                           INT8_C(  -8), INT8_C(-103), INT8_C( 124), INT8_C( -64),
                           INT8_C(  -5), INT8_C(  73), INT8_C(  83), INT8_C(-107),
                           INT8_C( -64), INT8_C( -31), INT8_C(  11), INT8_C(  45),
                           INT8_C( -14), INT8_C(-110), INT8_C( 100), INT8_C(  -6),
                           INT8_C( -50), INT8_C(-123), INT8_C( -94), INT8_C(  12),
                           INT8_C( -29), INT8_C(-100), INT8_C(  97), INT8_C(-115),
                           INT8_C( 103), INT8_C( -79), INT8_C( 102), INT8_C(  -6),
                           INT8_C( -20), INT8_C(-105), INT8_C(  -6), INT8_C(  69),
                           INT8_C(  19), INT8_C( 102), INT8_C(-126), INT8_C( -17),
                           INT8_C(  26), INT8_C(-105), INT8_C(  91), INT8_C( -38),
                           INT8_C( 106), INT8_C(   8), INT8_C(  85), INT8_C( -66),
                           INT8_C(  40), INT8_C( -49), INT8_C(  10), INT8_C(  15),
                           INT8_C(  30), INT8_C(  97), INT8_C( -48), INT8_C(  26),
                           INT8_C(  77), INT8_C( 104), INT8_C(-118), INT8_C(  49)),
      simde_mm512_set_epi8(INT8_C( -27), INT8_C(-108), INT8_C(-117), INT8_C( -88),
                           INT8_C(-107), INT8_C(  53), INT8_C( -16), INT8_C(  -1),
                           INT8_C( -92), INT8_C(-119), INT8_C(  17), INT8_C(-122),
                           INT8_C(  22), INT8_C( -13), INT8_C(   7), INT8_C(-126),
                           INT8_C( -24), INT8_C( -51), INT8_C( -29), INT8_C(-114),
                           INT8_C( 100), INT8_C( -53), INT8_C(   0), INT8_C(-112),
                           INT8_C( -80), INT8_C(  89), INT8_C(  91), INT8_C(   1),
                           INT8_C( 102), INT8_C(  -2), INT8_C( -67), INT8_C( -88),
                           INT8_C( 103), INT8_C(  79), INT8_C( 102), INT8_C(  13),
                           INT8_C(  67), INT8_C(  49), INT8_C(   6), INT8_C( -71),
                           INT8_C( -24), INT8_C( 102), INT8_C( -18), INT8_C(  58),
                           INT8_C(  26), INT8_C(-116), INT8_C(  91), INT8_C(  38),
                           INT8_C(  47), INT8_C( 118), INT8_C( -15), INT8_C( -31),
                           INT8_C( -70), INT8_C( -81), INT8_C(  10), INT8_C(  88),
                           INT8_C(  30), INT8_C(  97), INT8_C(  48), INT8_C( -29),
                           INT8_C(  77), INT8_C( 104), INT8_C(  -5), INT8_C(  57)) },
    { simde_mm512_set_epi8(INT8_C(  64), INT8_C(  45), INT8_C( -70), INT8_C(  94),
                           INT8_C( 127), INT8_C( -70), INT8_C( 127), INT8_C( -78),
                           INT8_C( -58), INT8_C(  92), INT8_C( -25), INT8_C(  -8),
                           INT8_C(  21), INT8_C(  89), INT8_C(   8), INT8_C(   1),
                           INT8_C(  85), INT8_C(   5), INT8_C( 111), INT8_C( 109),
                           INT8_C(   6), INT8_C( -27), INT8_C(  18), INT8_C(  62),
                           INT8_C(  -7), INT8_C( 126), INT8_C( -22), INT8_C( -36),
                           INT8_C( -10), INT8_C(  -1), INT8_C(   1), INT8_C( 115),
                           INT8_C(  87), INT8_C(  93), INT8_C( -71), INT8_C(-100),
                           INT8_C( -92), INT8_C( 103), INT8_C( -19), INT8_C(  -4),
                           INT8_C( 126), INT8_C( 112), INT8_C( -72), INT8_C(  45),
                           INT8_C(  61), INT8_C( -10), INT8_C(  68), INT8_C( -93),
                           INT8_C(   5), INT8_C( 127), INT8_C( 109), INT8_C( -62),
                           INT8_C( -89), INT8_C(-117), INT8_C(-126), INT8_C(  52),
                           INT8_C(  -8), INT8_C( -92), INT8_C( -23), INT8_C( -48),
                           INT8_C( 104), INT8_C(-120), INT8_C(  -2), INT8_C(-108)),
      UINT64_C(          2131497860),
      simde_mm512_set_epi8(INT8_C(  85), INT8_C( 118), INT8_C( 120), INT8_C( -48),
                           INT8_C( 112), INT8_C(  80), INT8_C( -83), INT8_C(  55),
                           INT8_C(  10), INT8_C(-104), INT8_C(  -7), INT8_C(-106),
                           INT8_C(  -6), INT8_C(   9), INT8_C( -88), INT8_C(  52),
                           INT8_C(  69), INT8_C(  91), INT8_C(-122), INT8_C(  83),
                           INT8_C(  54), INT8_C( -42), INT8_C(   9), INT8_C( 100),
                           INT8_C(  84), INT8_C(  66), INT8_C(  99), INT8_C( -57),
                           INT8_C(  20), INT8_C( -56), INT8_C( -41), INT8_C(  34),
                           INT8_C(  96), INT8_C( 125), INT8_C(  40), INT8_C( -10),
                           INT8_C(  37), INT8_C( -54), INT8_C( -41), INT8_C( 111),
                           INT8_C( -17), INT8_C(  73), INT8_C(  10), INT8_C(  78),
                           INT8_C( -64), INT8_C(  57), INT8_C(  95), INT8_C(  52),
                           INT8_C(-123), INT8_C( 102), INT8_C( -91), INT8_C( -25),
                           INT8_C( -74), INT8_C(  23), INT8_C(-127), INT8_C( -43),
                           INT8_C( 123), INT8_C( -21), INT8_C( -69), INT8_C(  72),
                           INT8_C( -86), INT8_C(  39), INT8_C( -52), INT8_C(  88)),
      simde_mm512_set_epi8(INT8_C(  64), INT8_C(  45), INT8_C( -70), INT8_C(  94),
                           INT8_C( 127), INT8_C( -70), INT8_C( 127), INT8_C( -78),
                           INT8_C( -58), INT8_C(  92), INT8_C( -25), INT8_C(  -8),
                           INT8_C(  21), INT8_C(  89), INT8_C(   8), INT8_C(   1),
                           INT8_C(  85), INT8_C(   5), INT8_C( 111), INT8_C( 109),
                           INT8_C(   6), INT8_C( -27), INT8_C(  18), INT8_C(  62),
                           INT8_C(  -7), INT8_C( 126), INT8_C( -22), INT8_C( -36),
                           INT8_C( -10), INT8_C(  -1), INT8_C(   1), INT8_C( 115),
                           INT8_C(  87), INT8_C( 125), INT8_C(  40), INT8_C(  10),
                           INT8_C(  37), INT8_C(  54), INT8_C(  41), INT8_C( 111),
                           INT8_C( 126), INT8_C( 112), INT8_C( -72), INT8_C(  45),
                           INT8_C(  64), INT8_C(  57), INT8_C(  68), INT8_C( -93),
                           INT8_C(   5), INT8_C( 127), INT8_C( 109), INT8_C(  25),
                           INT8_C( -89), INT8_C(-117), INT8_C( 127), INT8_C(  43),
                           INT8_C( 123), INT8_C( -92), INT8_C( -23), INT8_C( -48),
                           INT8_C( 104), INT8_C(  39), INT8_C(  -2), INT8_C(-108)) },
    { simde_mm512_set_epi8(INT8_C( -39), INT8_C(-117), INT8_C( -99), INT8_C( -55),
                           INT8_C(   3), INT8_C( -15), INT8_C( 113), INT8_C(  -3),
                           INT8_C( -35), INT8_C( 100), INT8_C( -74), INT8_C(-107),
                           INT8_C(  44), INT8_C( -58), INT8_C(  20), INT8_C(  23),
                           INT8_C( 105), INT8_C( -68), INT8_C( 118), INT8_C( -13),
                           INT8_C( -81), INT8_C(  41), INT8_C( -73), INT8_C(-115),
                           INT8_C(-111), INT8_C(  21), INT8_C(  99), INT8_C( 117),
                           INT8_C( -14), INT8_C(-112), INT8_C(  71), INT8_C(  21),
                           INT8_C(-114), INT8_C( -75), INT8_C(  66), INT8_C(-119),
                           INT8_C( -62), INT8_C( -30), INT8_C(  86), INT8_C(-128),
                           INT8_C( 109), INT8_C(  15), INT8_C( -69), INT8_C(  22),
                           INT8_C( -13), INT8_C(  38), INT8_C( -93), INT8_C( -41),
                           INT8_C(  96), INT8_C(  79), INT8_C( -24), INT8_C( -40),
                           INT8_C(  90), INT8_C(  31), INT8_C( -35), INT8_C(  22),
                           INT8_C(-112), INT8_C( -37), INT8_C(  29), INT8_C(  29),
                           INT8_C(   7), INT8_C(   8), INT8_C( 106), INT8_C( -46)),
      UINT64_C(           127712386),
      simde_mm512_set_epi8(INT8_C(  68), INT8_C( 120), INT8_C( -69), INT8_C( -50),
                           INT8_C( 102), INT8_C(-123), INT8_C(  95), INT8_C( 110),
                           INT8_C(  90), INT8_C( -66), INT8_C( -52), INT8_C(  44),
                           INT8_C(-111), INT8_C(  10), INT8_C(-111), INT8_C(  20),
                           INT8_C( -11), INT8_C(-128), INT8_C( -17), INT8_C( -40),
                           INT8_C( -41), INT8_C(   0), INT8_C( -15), INT8_C( 105),
                           INT8_C(  81), INT8_C(   3), INT8_C(  23), INT8_C( 107),
                           INT8_C( -18), INT8_C(  80), INT8_C(-106), INT8_C(  52),
                           INT8_C(  80), INT8_C( 120), INT8_C(  83), INT8_C(-117),
                           INT8_C(  84), INT8_C( -78), INT8_C(  47), INT8_C( -33),
                           INT8_C( 103), INT8_C(  66), INT8_C(  79), INT8_C(  53),
                           INT8_C( -45), INT8_C(  20), INT8_C( 111), INT8_C( -59),
                           INT8_C( -18), INT8_C(  30), INT8_C(  70), INT8_C( -25),
                           INT8_C( -57), INT8_C(  18), INT8_C(  -4), INT8_C( 101),
                           INT8_C(  75), INT8_C(  12), INT8_C(  85), INT8_C(  93),
                           INT8_C( -79), INT8_C( -13), INT8_C(  43), INT8_C(  45)),
      simde_mm512_set_epi8(INT8_C( -39), INT8_C(-117), INT8_C( -99), INT8_C( -55),
                           INT8_C(   3), INT8_C( -15), INT8_C( 113), INT8_C(  -3),
                           INT8_C( -35), INT8_C( 100), INT8_C( -74), INT8_C(-107),
                           INT8_C(  44), INT8_C( -58), INT8_C(  20), INT8_C(  23),
                           INT8_C( 105), INT8_C( -68), INT8_C( 118), INT8_C( -13),
                           INT8_C( -81), INT8_C(  41), INT8_C( -73), INT8_C(-115),
                           INT8_C(-111), INT8_C(  21), INT8_C(  99), INT8_C( 117),
                           INT8_C( -14), INT8_C(-112), INT8_C(  71), INT8_C(  21),
                           INT8_C(-114), INT8_C( -75), INT8_C(  66), INT8_C(-119),
                           INT8_C( -62), INT8_C(  78), INT8_C(  47), INT8_C(  33),
                           INT8_C( 103), INT8_C(  15), INT8_C( -69), INT8_C(  53),
                           INT8_C(  45), INT8_C(  20), INT8_C( -93), INT8_C( -41),
                           INT8_C(  18), INT8_C(  79), INT8_C(  70), INT8_C(  25),
                           INT8_C(  57), INT8_C(  18), INT8_C( -35), INT8_C(  22),
                           INT8_C(  75), INT8_C( -37), INT8_C(  29), INT8_C(  29),
                           INT8_C(   7), INT8_C(   8), INT8_C(  43), INT8_C( -46)) },
    { simde_mm512_set_epi8(INT8_C( -81), INT8_C(  98), INT8_C(  23), INT8_C(-108),
                           INT8_C(-126), INT8_C(  95), INT8_C( -44), INT8_C( -56),
                           INT8_C(  42), INT8_C(  32), INT8_C( -91), INT8_C(-126),
                           INT8_C( 119), INT8_C(  88), INT8_C( 110), INT8_C(  93),
                           INT8_C(  75), INT8_C( -49), INT8_C( -63), INT8_C( -42),
                           INT8_C(  54), INT8_C( -71), INT8_C(  87), INT8_C(  -1),
                           INT8_C( -25), INT8_C( -60), INT8_C( 102), INT8_C( -98),
                           INT8_C( -95), INT8_C( -34), INT8_C( -46), INT8_C(  94),
                           INT8_C( 118), INT8_C( 127), INT8_C( -62), INT8_C( -70),
                           INT8_C(  80), INT8_C( 125), INT8_C( -12), INT8_C(  33),
                           INT8_C( 110), INT8_C(  -9), INT8_C( -29), INT8_C(-115),
                           INT8_C(-117), INT8_C(  52), INT8_C(-126), INT8_C( -15),
                           INT8_C(-118), INT8_C(-123), INT8_C( -16), INT8_C(  72),
                           INT8_C(  84), INT8_C(  54), INT8_C(  76), INT8_C( -48),
                           INT8_C( -79), INT8_C( 100), INT8_C( -58), INT8_C(  30),
                           INT8_C(  35), INT8_C(  68), INT8_C( -40), INT8_C(   8)),
      UINT64_C(           522030218),
      simde_mm512_set_epi8(INT8_C(  -1), INT8_C( -56), INT8_C( -80), INT8_C(  17),
                           INT8_C( 127), INT8_C(  83), INT8_C(  -9), INT8_C(   0),
                           INT8_C(  -1), INT8_C( 117), INT8_C( -15), INT8_C(  26),
                           INT8_C(  30), INT8_C( -32), INT8_C(  47), INT8_C(  99),
                           INT8_C( -59), INT8_C( -81), INT8_C( -58), INT8_C(  71),
                           INT8_C(-119), INT8_C( -65), INT8_C( -78), INT8_C(-101),
                           INT8_C( -14), INT8_C(   4), INT8_C( -24), INT8_C( -95),
                           INT8_C( 106), INT8_C(  31), INT8_C( 104), INT8_C(  20),
                           INT8_C(  65), INT8_C(  -8), INT8_C( -75), INT8_C(-128),
                           INT8_C( -81), INT8_C(  68), INT8_C( -86), INT8_C(  98),
                           INT8_C( -55), INT8_C(  10), INT8_C(  75), INT8_C(  51),
                           INT8_C( -57), INT8_C(-111), INT8_C(  87), INT8_C(  47),
                           INT8_C( -21), INT8_C( 105), INT8_C(  17), INT8_C( 107),
                           INT8_C(-119), INT8_C( -18), INT8_C(-123), INT8_C(  81),
                           INT8_C(  54), INT8_C(-122), INT8_C( -83), INT8_C(  81),
                           INT8_C(  21), INT8_C(  13), INT8_C(   6), INT8_C( -56)),
      simde_mm512_set_epi8(INT8_C( -81), INT8_C(  98), INT8_C(  23), INT8_C(-108),
                           INT8_C(-126), INT8_C(  95), INT8_C( -44), INT8_C( -56),
                           INT8_C(  42), INT8_C(  32), INT8_C( -91), INT8_C(-126),
                           INT8_C( 119), INT8_C(  88), INT8_C( 110), INT8_C(  93),
                           INT8_C(  75), INT8_C( -49), INT8_C( -63), INT8_C( -42),
                           INT8_C(  54), INT8_C( -71), INT8_C(  87), INT8_C(  -1),
                           INT8_C( -25), INT8_C( -60), INT8_C( 102), INT8_C( -98),
                           INT8_C( -95), INT8_C( -34), INT8_C( -46), INT8_C(  94),
                           INT8_C( 118), INT8_C( 127), INT8_C( -62), INT8_C(-128),
                           INT8_C(  81), INT8_C(  68), INT8_C(  86), INT8_C(  98),
                           INT8_C( 110), INT8_C(  -9), INT8_C( -29), INT8_C(  51),
                           INT8_C(  57), INT8_C( 111), INT8_C(-126), INT8_C(  47),
                           INT8_C(  21), INT8_C(-123), INT8_C( -16), INT8_C(  72),
                           INT8_C( 119), INT8_C(  18), INT8_C(  76), INT8_C( -48),
                           INT8_C(  54), INT8_C( 100), INT8_C( -58), INT8_C(  30),
                           INT8_C(  21), INT8_C(  68), INT8_C(   6), INT8_C(   8)) },
    { simde_mm512_set_epi8(INT8_C(-112), INT8_C( -53), INT8_C(-107), INT8_C(  41),
                           INT8_C( -50), INT8_C( -58), INT8_C(  56), INT8_C(  54),
                           INT8_C(-101), INT8_C(-123), INT8_C(  64), INT8_C( -70),
                           INT8_C( -46), INT8_C(  -1), INT8_C(  70), INT8_C( -46),
                           INT8_C(  96), INT8_C(  45), INT8_C(  57), INT8_C(  -8),
                           INT8_C(  23), INT8_C(  34), INT8_C( -16), INT8_C( -48),
                           INT8_C(  74), INT8_C(  85), INT8_C(-106), INT8_C(  98),
                           INT8_C(  81), INT8_C(-107), INT8_C( -43), INT8_C(  64),
                           INT8_C(-110), INT8_C( 124), INT8_C(-122), INT8_C(-123),
                           INT8_C(  20), INT8_C( 122), INT8_C(  57), INT8_C( -15),
                           INT8_C(  58), INT8_C(  90), INT8_C(-103), INT8_C(  57),
                           INT8_C(  51), INT8_C(-118), INT8_C(  37), INT8_C( -79),
                           INT8_C(  13), INT8_C( 116), INT8_C( -79), INT8_C( -18),
                           INT8_C( -87), INT8_C( -79), INT8_C( -83), INT8_C( -25),
                           INT8_C( -30), INT8_C( -40), INT8_C( 126), INT8_C(  80),
                           INT8_C( -74), INT8_C(  71), INT8_C( -68), INT8_C(  53)),
      UINT64_C(          2821348422),
      simde_mm512_set_epi8(INT8_C(-126), INT8_C(  -8), INT8_C(  35), INT8_C( 112),
                           INT8_C( -78), INT8_C(  75), INT8_C( -25), INT8_C(   1),
                           INT8_C( -27), INT8_C( -67), INT8_C(  49), INT8_C(  75),
                           INT8_C( -39), INT8_C( -68), INT8_C( -51), INT8_C(  42),
                           INT8_C( -30), INT8_C(   1), INT8_C( -18), INT8_C(  -4),
                           INT8_C(  39), INT8_C(  85), INT8_C(  69), INT8_C(  68),
                           INT8_C(-113), INT8_C( -38), INT8_C(  28), INT8_C(  83),
                           INT8_C( -31), INT8_C(  61), INT8_C(  37), INT8_C(  67),
                           INT8_C(  46), INT8_C( -43), INT8_C(  32), INT8_C( -73),
                           INT8_C( -26), INT8_C(   2), INT8_C(  -6), INT8_C( 122),
                           INT8_C( -51), INT8_C( 118), INT8_C(   3), INT8_C(  17),
                           INT8_C(  32), INT8_C(  82), INT8_C(  40), INT8_C(   0),
                           INT8_C(  28), INT8_C(  37), INT8_C(  -3), INT8_C( -85),
                           INT8_C( -92), INT8_C(  45), INT8_C( -23), INT8_C( -58),
                           INT8_C(-108), INT8_C(  44), INT8_C(  28), INT8_C(  77),
                           INT8_C(  12), INT8_C(  81), INT8_C(-103), INT8_C(   7)),
      simde_mm512_set_epi8(INT8_C(-112), INT8_C( -53), INT8_C(-107), INT8_C(  41),
                           INT8_C( -50), INT8_C( -58), INT8_C(  56), INT8_C(  54),
                           INT8_C(-101), INT8_C(-123), INT8_C(  64), INT8_C( -70),
                           INT8_C( -46), INT8_C(  -1), INT8_C(  70), INT8_C( -46),
                           INT8_C(  96), INT8_C(  45), INT8_C(  57), INT8_C(  -8),
                           INT8_C(  23), INT8_C(  34), INT8_C( -16), INT8_C( -48),
                           INT8_C(  74), INT8_C(  85), INT8_C(-106), INT8_C(  98),
                           INT8_C(  81), INT8_C(-107), INT8_C( -43), INT8_C(  64),
                           INT8_C(  46), INT8_C( 124), INT8_C(  32), INT8_C(-123),
                           INT8_C(  26), INT8_C( 122), INT8_C(  57), INT8_C( -15),
                           INT8_C(  58), INT8_C(  90), INT8_C(   3), INT8_C(  57),
                           INT8_C(  32), INT8_C(-118), INT8_C(  40), INT8_C( -79),
                           INT8_C(  13), INT8_C(  37), INT8_C( -79), INT8_C(  85),
                           INT8_C(  92), INT8_C(  45), INT8_C( -83), INT8_C( -25),
                           INT8_C( -30), INT8_C(  44), INT8_C( 126), INT8_C(  80),
                           INT8_C( -74), INT8_C(  81), INT8_C( 103), INT8_C(  53)) },
    { simde_mm512_set_epi8(INT8_C( 115), INT8_C( -13), INT8_C( 104), INT8_C(  83),
                           INT8_C(  80), INT8_C(-118), INT8_C(  34), INT8_C(  48),
                           INT8_C(  50), INT8_C( -65), INT8_C(  88), INT8_C(  76),
                           INT8_C( -17), INT8_C( -86), INT8_C( -68), INT8_C(  75),
                           INT8_C( 121), INT8_C(   9), INT8_C( -63), INT8_C( 106),
                           INT8_C(  93), INT8_C(  44), INT8_C(   0), INT8_C( -33),
                           INT8_C( -53), INT8_C( 101), INT8_C(  76), INT8_C(  37),
                           INT8_C(  94), INT8_C( -32), INT8_C(-104), INT8_C( -20),
                           INT8_C( -48), INT8_C(  45), INT8_C(  88), INT8_C( -93),
                           INT8_C( 104), INT8_C(  42), INT8_C( -99), INT8_C(  59),
                           INT8_C(  90), INT8_C( -69), INT8_C( 107), INT8_C(  16),
                           INT8_C(-118), INT8_C(-119), INT8_C( -60), INT8_C(  51),
                           INT8_C( 126), INT8_C( -78), INT8_C( 114), INT8_C( -75),
                           INT8_C( -75), INT8_C(  19), INT8_C( 113), INT8_C(  84),
                           INT8_C(  47), INT8_C( -83), INT8_C( -26), INT8_C( -38),
                           INT8_C(  64), INT8_C(-106), INT8_C( 107), INT8_C(  56)),
      UINT64_C(          1977462364),
      simde_mm512_set_epi8(INT8_C(-106), INT8_C( -34), INT8_C( 105), INT8_C( -49),
                           INT8_C( -33), INT8_C( 121), INT8_C(   0), INT8_C( 127),
                           INT8_C( -65), INT8_C( -90), INT8_C(-123), INT8_C( 112),
                           INT8_C( -57), INT8_C(  77), INT8_C(  42), INT8_C(  34),
                           INT8_C( -12), INT8_C( -47), INT8_C( 117), INT8_C(  40),
                           INT8_C(  42), INT8_C(  16), INT8_C( -26), INT8_C( 122),
                           INT8_C( 122), INT8_C( -37), INT8_C( -98), INT8_C( -20),
                           INT8_C(  86), INT8_C( -87), INT8_C( -90), INT8_C(-112),
                           INT8_C(-115), INT8_C(  79), INT8_C( 123), INT8_C(  33),
                           INT8_C( -55), INT8_C(-125), INT8_C( 102), INT8_C(  59),
                           INT8_C( -57), INT8_C(  19), INT8_C(  -4), INT8_C( -55),
                           INT8_C( -86), INT8_C(  88), INT8_C( -47), INT8_C(  29),
                           INT8_C(-116), INT8_C( -58), INT8_C( 115), INT8_C( -63),
                           INT8_C( -15), INT8_C( -54), INT8_C(  84), INT8_C(  -1),
                           INT8_C(   5), INT8_C( -33), INT8_C( -96), INT8_C(  93),
                           INT8_C(  97), INT8_C( 124), INT8_C(  26), INT8_C( -34)),
      simde_mm512_set_epi8(INT8_C( 115), INT8_C( -13), INT8_C( 104), INT8_C(  83),
                           INT8_C(  80), INT8_C(-118), INT8_C(  34), INT8_C(  48),
                           INT8_C(  50), INT8_C( -65), INT8_C(  88), INT8_C(  76),
                           INT8_C( -17), INT8_C( -86), INT8_C( -68), INT8_C(  75),
                           INT8_C( 121), INT8_C(   9), INT8_C( -63), INT8_C( 106),
                           INT8_C(  93), INT8_C(  44), INT8_C(   0), INT8_C( -33),
                           INT8_C( -53), INT8_C( 101), INT8_C(  76), INT8_C(  37),
                           INT8_C(  94), INT8_C( -32), INT8_C(-104), INT8_C( -20),
                           INT8_C( -48), INT8_C(  79), INT8_C( 123), INT8_C(  33),
                           INT8_C( 104), INT8_C( 125), INT8_C( -99), INT8_C(  59),
                           INT8_C(  57), INT8_C(  19), INT8_C( 107), INT8_C(  55),
                           INT8_C(  86), INT8_C(  88), INT8_C( -60), INT8_C(  29),
                           INT8_C( 116), INT8_C( -78), INT8_C( 115), INT8_C( -75),
                           INT8_C(  15), INT8_C(  54), INT8_C(  84), INT8_C(  84),
                           INT8_C(  47), INT8_C(  33), INT8_C( -26), INT8_C(  93),
                           INT8_C(  97), INT8_C( 124), INT8_C( 107), INT8_C(  56)) },
    { simde_mm512_set_epi8(INT8_C(   2), INT8_C(  -4), INT8_C( 108), INT8_C(  27),
                           INT8_C( -49), INT8_C(  69), INT8_C( -84), INT8_C(  82),
                           INT8_C(   9), INT8_C(   0), INT8_C(  42), INT8_C( 118),
                           INT8_C(  -3), INT8_C( -67), INT8_C(   6), INT8_C(  30),
                           INT8_C( -88), INT8_C( -69), INT8_C( 118), INT8_C(  36),
                           INT8_C( 110), INT8_C(  81), INT8_C( -37), INT8_C(  36),
                           INT8_C( -74), INT8_C(-109), INT8_C(  47), INT8_C(  12),
                           INT8_C( -29), INT8_C( -81), INT8_C(  76), INT8_C( -22),
                           INT8_C(  91), INT8_C( 125), INT8_C(  98), INT8_C(  17),
                           INT8_C( 115), INT8_C(  58), INT8_C(-107), INT8_C(  90),
                           INT8_C( 115), INT8_C( -24), INT8_C(  83), INT8_C(  17),
                           INT8_C( -11), INT8_C(  20), INT8_C(  81), INT8_C(  54),
                           INT8_C( -59), INT8_C( 112), INT8_C(-102), INT8_C(  13),
                           INT8_C(   8), INT8_C(-105), INT8_C( -27), INT8_C(-127),
                           INT8_C(-112), INT8_C( 125), INT8_C(  21), INT8_C(  55),
                           INT8_C(  24), INT8_C(  58), INT8_C(   7), INT8_C( 127)),
      UINT64_C(           751965274),
      simde_mm512_set_epi8(INT8_C(  90), INT8_C(  75), INT8_C( -70), INT8_C(  89),
                           INT8_C(  25), INT8_C( -86), INT8_C( -40), INT8_C(  -9),
                           INT8_C(-119), INT8_C( -19), INT8_C( 110), INT8_C( -26),
                           INT8_C(-126), INT8_C( 124), INT8_C(   6), INT8_C( -11),
                           INT8_C( -92), INT8_C(  66), INT8_C( -68), INT8_C(  20),
                           INT8_C(  35), INT8_C(  35), INT8_C(  58), INT8_C(  98),
                           INT8_C(  84), INT8_C( -34), INT8_C(  36), INT8_C(-124),
                           INT8_C(  32), INT8_C( -74), INT8_C(  73), INT8_C( -74),
                           INT8_C(  77), INT8_C( 116), INT8_C(  50), INT8_C(  82),
                           INT8_C(  68), INT8_C(  72), INT8_C(  23), INT8_C(  32),
                           INT8_C( -54), INT8_C(  82), INT8_C(  53), INT8_C(  71),
                           INT8_C(  22), INT8_C(  92), INT8_C(  42), INT8_C(-123),
                           INT8_C( -41), INT8_C(  34), INT8_C(  75), INT8_C(  63),
                           INT8_C(-117), INT8_C(  23), INT8_C(-115), INT8_C(  66),
                           INT8_C( -90), INT8_C(  99), INT8_C( -73), INT8_C( -19),
                           INT8_C( -43), INT8_C( -64), INT8_C( -21), INT8_C(  20)),
      simde_mm512_set_epi8(INT8_C(   2), INT8_C(  -4), INT8_C( 108), INT8_C(  27),
                           INT8_C( -49), INT8_C(  69), INT8_C( -84), INT8_C(  82),
                           INT8_C(   9), INT8_C(   0), INT8_C(  42), INT8_C( 118),
                           INT8_C(  -3), INT8_C( -67), INT8_C(   6), INT8_C(  30),
                           INT8_C( -88), INT8_C( -69), INT8_C( 118), INT8_C(  36),
                           INT8_C( 110), INT8_C(  81), INT8_C( -37), INT8_C(  36),
                           INT8_C( -74), INT8_C(-109), INT8_C(  47), INT8_C(  12),
                           INT8_C( -29), INT8_C( -81), INT8_C(  76), INT8_C( -22),
                           INT8_C(  91), INT8_C( 125), INT8_C(  50), INT8_C(  17),
                           INT8_C(  68), INT8_C(  72), INT8_C(-107), INT8_C(  90),
                           INT8_C(  54), INT8_C(  82), INT8_C(  83), INT8_C(  71),
                           INT8_C( -11), INT8_C(  20), INT8_C(  42), INT8_C(  54),
                           INT8_C( -59), INT8_C( 112), INT8_C(-102), INT8_C(  63),
                           INT8_C(   8), INT8_C(  23), INT8_C( -27), INT8_C(-127),
                           INT8_C(-112), INT8_C(  99), INT8_C(  21), INT8_C(  19),
                           INT8_C(  43), INT8_C(  58), INT8_C(  21), INT8_C( 127)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_mask_abs_epi8(test_vec[i].src, test_vec[i].k, test_vec[i].a);
    simde_assert_m512i_i32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_maskz_abs_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__mmask64 k;
    simde__m512i a;
    simde__m512i r;
  } test_vec[8] = {
    { UINT64_C(          1713497089),
      simde_mm512_set_epi8(INT8_C(-105), INT8_C(  80), INT8_C( -16), INT8_C(-124),
                           INT8_C( -48), INT8_C(  76), INT8_C( -91), INT8_C(-128),
                           INT8_C(  54), INT8_C(  63), INT8_C( 114), INT8_C( -73),
                           INT8_C( -26), INT8_C( -48), INT8_C( -24), INT8_C( -13),
                           INT8_C(   5), INT8_C( 123), INT8_C( -45), INT8_C( -57),
                           INT8_C(-107), INT8_C(  47), INT8_C(  90), INT8_C( -54),
                           INT8_C(   1), INT8_C( 118), INT8_C(  37), INT8_C(  -7),
                           INT8_C(  83), INT8_C(  31), INT8_C( -23), INT8_C( -20),
                           INT8_C(-104), INT8_C( 114), INT8_C(  63), INT8_C(  25),
                           INT8_C( -80), INT8_C(  17), INT8_C(  37), INT8_C( -44),
                           INT8_C(-112), INT8_C(  41), INT8_C( -18), INT8_C(  86),
                           INT8_C( 114), INT8_C( -23), INT8_C( -86), INT8_C( -99),
                           INT8_C( 114), INT8_C(  25), INT8_C(  94), INT8_C(  34),
                           INT8_C( -48), INT8_C(  -4), INT8_C(-123), INT8_C( -44),
                           INT8_C( -68), INT8_C(  19), INT8_C(  47), INT8_C(-122),
                           INT8_C( 117), INT8_C(  69), INT8_C(-121), INT8_C(  66)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( 114), INT8_C(  63), INT8_C(   0),
                           INT8_C(   0), INT8_C(  17), INT8_C(  37), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  18), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  99),
                           INT8_C( 114), INT8_C(  25), INT8_C(  94), INT8_C(   0),
                           INT8_C(   0), INT8_C(   4), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  66)) },
    { UINT64_C(           549841533),
      simde_mm512_set_epi8(INT8_C( -84), INT8_C(  24), INT8_C(  17), INT8_C( -28),
                           INT8_C(  -3), INT8_C(  88), INT8_C(  98), INT8_C( -52),
                           INT8_C( -76), INT8_C( -19), INT8_C( 100), INT8_C(  59),
                           INT8_C( -64), INT8_C( -60), INT8_C( -53), INT8_C(  16),
                           INT8_C(   0), INT8_C( -89), INT8_C(  13), INT8_C(  17),
                           INT8_C( 116), INT8_C(  41), INT8_C(  54), INT8_C(  -8),
                           INT8_C(-112), INT8_C( 109), INT8_C(  94), INT8_C(  19),
                           INT8_C(  46), INT8_C( -55), INT8_C( 103), INT8_C(   7),
                           INT8_C( -15), INT8_C( -12), INT8_C( -22), INT8_C( 127),
                           INT8_C( -48), INT8_C( -83), INT8_C(  -9), INT8_C( -85),
                           INT8_C( -79), INT8_C( -12), INT8_C(  76), INT8_C( -65),
                           INT8_C( -90), INT8_C(  19), INT8_C(  33), INT8_C( -50),
                           INT8_C(  89), INT8_C( -40), INT8_C(-117), INT8_C( 111),
                           INT8_C(  48), INT8_C( 119), INT8_C( -55), INT8_C(  66),
                           INT8_C( 113), INT8_C(  -2), INT8_C( -49), INT8_C(-110),
                           INT8_C( -55), INT8_C(  44), INT8_C( 125), INT8_C( -61)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  22), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  79), INT8_C(  12), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  19), INT8_C(   0), INT8_C(  50),
                           INT8_C(  89), INT8_C(  40), INT8_C( 117), INT8_C(   0),
                           INT8_C(  48), INT8_C(   0), INT8_C(  55), INT8_C(   0),
                           INT8_C(   0), INT8_C(   2), INT8_C(  49), INT8_C( 110),
                           INT8_C(  55), INT8_C(  44), INT8_C(   0), INT8_C(  61)) },
    { UINT64_C(          2304862624),
      simde_mm512_set_epi8(INT8_C(  71), INT8_C( -17), INT8_C(   0), INT8_C( -82),
                           INT8_C( -27), INT8_C( 124), INT8_C(  45), INT8_C(  57),
                           INT8_C( 107), INT8_C( -93), INT8_C( -77), INT8_C(  53),
                           INT8_C( 126), INT8_C(  10), INT8_C( 123), INT8_C(-113),
                           INT8_C( -41), INT8_C(-108), INT8_C( -59), INT8_C( -36),
                           INT8_C( -24), INT8_C( -51), INT8_C( -68), INT8_C( -38),
                           INT8_C(  19), INT8_C( 120), INT8_C(-118), INT8_C(  63),
                           INT8_C(  24), INT8_C(  72), INT8_C(  39), INT8_C(  31),
                           INT8_C( -92), INT8_C(  52), INT8_C(  81), INT8_C(  39),
                           INT8_C( -70), INT8_C(  73), INT8_C(  76), INT8_C( 114),
                           INT8_C(  -7), INT8_C(   4), INT8_C( -55), INT8_C( -68),
                           INT8_C( 120), INT8_C(  98), INT8_C(-115), INT8_C( -56),
                           INT8_C(  93), INT8_C(  -2), INT8_C(  78), INT8_C(  16),
                           INT8_C(  88), INT8_C(  71), INT8_C(-112), INT8_C(-118),
                           INT8_C(   4), INT8_C( -88), INT8_C(  76), INT8_C(  88),
                           INT8_C( -97), INT8_C( 107), INT8_C( -28), INT8_C( -59)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  92), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  70), INT8_C(   0), INT8_C(   0), INT8_C( 114),
                           INT8_C(   0), INT8_C(   4), INT8_C(  55), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  56),
                           INT8_C(   0), INT8_C(   2), INT8_C(  78), INT8_C(   0),
                           INT8_C(  88), INT8_C(   0), INT8_C(   0), INT8_C( 118),
                           INT8_C(   4), INT8_C(   0), INT8_C(  76), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C(          2156618221),
      simde_mm512_set_epi8(INT8_C( -88), INT8_C( -28), INT8_C( -75), INT8_C(  34),
                           INT8_C( -30), INT8_C(  -1), INT8_C(  52), INT8_C( -92),
                           INT8_C( -85), INT8_C(  43), INT8_C(   9), INT8_C(  24),
                           INT8_C( -64), INT8_C( 107), INT8_C( -57), INT8_C(  38),
                           INT8_C(  95), INT8_C( -18), INT8_C(  11), INT8_C(  96),
                           INT8_C(  -4), INT8_C( -94), INT8_C( 116), INT8_C( -31),
                           INT8_C(  52), INT8_C(  -2), INT8_C(  98), INT8_C(  10),
                           INT8_C(   5), INT8_C(  19), INT8_C( -65), INT8_C(  10),
                           INT8_C(-109), INT8_C(  52), INT8_C( -85), INT8_C( -32),
                           INT8_C(  38), INT8_C(  92), INT8_C(   6), INT8_C( -71),
                           INT8_C( -79), INT8_C(  79), INT8_C( -94), INT8_C( 113),
                           INT8_C(-117), INT8_C(  20), INT8_C( -82), INT8_C(  82),
                           INT8_C(-120), INT8_C( 114), INT8_C( -52), INT8_C( -68),
                           INT8_C( -20), INT8_C( -47), INT8_C( -90), INT8_C( -87),
                           INT8_C(  79), INT8_C( -37), INT8_C(  63), INT8_C( -89),
                           INT8_C( -40), INT8_C( -67), INT8_C( -69), INT8_C(-117)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( 109), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  79), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( 117), INT8_C(   0), INT8_C(  82), INT8_C(  82),
                           INT8_C(   0), INT8_C( 114), INT8_C(  52), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  87),
                           INT8_C(  79), INT8_C(  37), INT8_C(  63), INT8_C(   0),
                           INT8_C(  40), INT8_C(  67), INT8_C(   0), INT8_C( 117)) },
    { UINT64_C(          2985927056),
      simde_mm512_set_epi8(INT8_C(-128), INT8_C(  11), INT8_C( -31), INT8_C( 116),
                           INT8_C( -77), INT8_C(  97), INT8_C(  87), INT8_C(  53),
                           INT8_C( -33), INT8_C(  37), INT8_C(  28), INT8_C(  24),
                           INT8_C(-103), INT8_C(  99), INT8_C( -75), INT8_C(  41),
                           INT8_C(  83), INT8_C(  39), INT8_C( 120), INT8_C( 115),
                           INT8_C( -51), INT8_C( -28), INT8_C( 102), INT8_C( -98),
                           INT8_C( -77), INT8_C( 121), INT8_C(  42), INT8_C( 114),
                           INT8_C(  -1), INT8_C( 112), INT8_C(  17), INT8_C( -31),
                           INT8_C( 108), INT8_C( -27), INT8_C(  66), INT8_C(  23),
                           INT8_C(  69), INT8_C( -90), INT8_C( -46), INT8_C( -91),
                           INT8_C( -81), INT8_C( -87), INT8_C(   1), INT8_C( -11),
                           INT8_C(  84), INT8_C(-117), INT8_C(  79), INT8_C(-110),
                           INT8_C( -44), INT8_C( -30), INT8_C(  33), INT8_C(  53),
                           INT8_C(  64), INT8_C( -16), INT8_C(-111), INT8_C( -41),
                           INT8_C(-102), INT8_C(  13), INT8_C(  97), INT8_C( -55),
                           INT8_C(  19), INT8_C( -16), INT8_C( -68), INT8_C( -83)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( 108), INT8_C(   0), INT8_C(  66), INT8_C(  23),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  91),
                           INT8_C(  81), INT8_C(  87), INT8_C(   1), INT8_C(  11),
                           INT8_C(  84), INT8_C(   0), INT8_C(   0), INT8_C( 110),
                           INT8_C(  44), INT8_C(   0), INT8_C(  33), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  41),
                           INT8_C( 102), INT8_C(   0), INT8_C(   0), INT8_C(  55),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C(           390836854),
      simde_mm512_set_epi8(INT8_C(  -6), INT8_C( 127), INT8_C(-110), INT8_C(  -8),
                           INT8_C( 106), INT8_C(  95), INT8_C(-126), INT8_C(-127),
                           INT8_C(-103), INT8_C( -21), INT8_C( -20), INT8_C( -71),
                           INT8_C( 106), INT8_C(  23), INT8_C( -51), INT8_C( -47),
                           INT8_C(-107), INT8_C(  61), INT8_C( -93), INT8_C(  10),
                           INT8_C(   4), INT8_C( 110), INT8_C( -43), INT8_C(  40),
                           INT8_C(  60), INT8_C( -40), INT8_C(  36), INT8_C( -39),
                           INT8_C( -80), INT8_C(-110), INT8_C(  14), INT8_C( -61),
                           INT8_C( -39), INT8_C( -70), INT8_C(-116), INT8_C( -99),
                           INT8_C( -82), INT8_C(-113), INT8_C(-120), INT8_C(-116),
                           INT8_C( -58), INT8_C(  18), INT8_C(  72), INT8_C(  23),
                           INT8_C(-117), INT8_C(-105), INT8_C(  83), INT8_C(   3),
                           INT8_C(-104), INT8_C(  34), INT8_C(  72), INT8_C( -33),
                           INT8_C(  84), INT8_C( -90), INT8_C(-116), INT8_C( -46),
                           INT8_C( -18), INT8_C(  96), INT8_C( -46), INT8_C(-109),
                           INT8_C(-103), INT8_C( -18), INT8_C( -39), INT8_C(  67)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  99),
                           INT8_C(   0), INT8_C( 113), INT8_C( 120), INT8_C( 116),
                           INT8_C(   0), INT8_C(  18), INT8_C(   0), INT8_C(   0),
                           INT8_C( 117), INT8_C(   0), INT8_C(  83), INT8_C(   3),
                           INT8_C( 104), INT8_C(   0), INT8_C(  72), INT8_C(  33),
                           INT8_C(   0), INT8_C(   0), INT8_C( 116), INT8_C(   0),
                           INT8_C(   0), INT8_C(  96), INT8_C(  46), INT8_C( 109),
                           INT8_C(   0), INT8_C(  18), INT8_C(  39), INT8_C(   0)) },
    { UINT64_C(           189869641),
      simde_mm512_set_epi8(INT8_C(  28), INT8_C(-101), INT8_C(-104), INT8_C(-117),
                           INT8_C(  24), INT8_C( -55), INT8_C(  82), INT8_C(-100),
                           INT8_C( -42), INT8_C(  62), INT8_C(-113), INT8_C( 110),
                           INT8_C( -92), INT8_C( 127), INT8_C( -92), INT8_C(  20),
                           INT8_C( -35), INT8_C(  35), INT8_C(  30), INT8_C( -86),
                           INT8_C( 120), INT8_C(  91), INT8_C( -69), INT8_C( -49),
                           INT8_C(  19), INT8_C( -87), INT8_C(  42), INT8_C(-110),
                           INT8_C(  68), INT8_C(  97), INT8_C(-125), INT8_C(  75),
                           INT8_C(  30), INT8_C( -54), INT8_C( -38), INT8_C( -20),
                           INT8_C( -96), INT8_C(  84), INT8_C( 108), INT8_C(  24),
                           INT8_C( -54), INT8_C( -26), INT8_C(-125), INT8_C( -53),
                           INT8_C(  48), INT8_C( -78), INT8_C( -96), INT8_C(  82),
                           INT8_C( -16), INT8_C( -68), INT8_C( -65), INT8_C(  28),
                           INT8_C( -82), INT8_C(-116), INT8_C( 119), INT8_C(-113),
                           INT8_C( 102), INT8_C(  90), INT8_C(  86), INT8_C( -14),
                           INT8_C( -49), INT8_C(  71), INT8_C(   2), INT8_C(  28)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  96), INT8_C(   0), INT8_C( 108), INT8_C(  24),
                           INT8_C(   0), INT8_C(  26), INT8_C(   0), INT8_C(  53),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  82),
                           INT8_C(   0), INT8_C(   0), INT8_C(  65), INT8_C(   0),
                           INT8_C(  82), INT8_C( 116), INT8_C( 119), INT8_C(   0),
                           INT8_C(   0), INT8_C(  90), INT8_C(   0), INT8_C(   0),
                           INT8_C(  49), INT8_C(   0), INT8_C(   0), INT8_C(  28)) },
    { UINT64_C(          2755545546),
      simde_mm512_set_epi8(INT8_C( -71), INT8_C(  48), INT8_C(  -1), INT8_C( -17),
                           INT8_C( -90), INT8_C(   3), INT8_C( -34), INT8_C(  36),
                           INT8_C( -17), INT8_C( -38), INT8_C( 100), INT8_C( -30),
                           INT8_C( 118), INT8_C(  42), INT8_C( -25), INT8_C( -45),
                           INT8_C(   4), INT8_C(   8), INT8_C(  53), INT8_C(  84),
                           INT8_C(-120), INT8_C(  61), INT8_C(  90), INT8_C( -19),
                           INT8_C(  31), INT8_C(-108), INT8_C( -76), INT8_C(  95),
                           INT8_C( 101), INT8_C( -99), INT8_C( -14), INT8_C(  26),
                           INT8_C( -35), INT8_C( -61), INT8_C(  15), INT8_C(  71),
                           INT8_C( 113), INT8_C( 109), INT8_C(  91), INT8_C(-117),
                           INT8_C(   0), INT8_C( 121), INT8_C(  48), INT8_C( 109),
                           INT8_C(  55), INT8_C( 125), INT8_C(-112), INT8_C(  80),
                           INT8_C(  48), INT8_C(  40), INT8_C(  32), INT8_C( -98),
                           INT8_C(  64), INT8_C( -31), INT8_C( -10), INT8_C(  -6),
                           INT8_C( -40), INT8_C(  37), INT8_C(  76), INT8_C( -51),
                           INT8_C(  27), INT8_C(  -2), INT8_C(-101), INT8_C( -10)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  35), INT8_C(   0), INT8_C(  15), INT8_C(   0),
                           INT8_C(   0), INT8_C( 109), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  48), INT8_C( 109),
                           INT8_C(  55), INT8_C( 125), INT8_C( 112), INT8_C(   0),
                           INT8_C(   0), INT8_C(  40), INT8_C(   0), INT8_C(   0),
                           INT8_C(  64), INT8_C(   0), INT8_C(   0), INT8_C(   6),
                           INT8_C(  40), INT8_C(  37), INT8_C(   0), INT8_C(   0),
                           INT8_C(  27), INT8_C(   0), INT8_C( 101), INT8_C(   0)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_maskz_abs_epi8(test_vec[i].k, test_vec[i].a);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_abs_epi16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i a;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi16(INT16_C(-24810), INT16_C( -1893), INT16_C( -4484), INT16_C(-18467),
                            INT16_C(-27267), INT16_C(-12302), INT16_C(-13826), INT16_C(   938),
                            INT16_C(-17680), INT16_C(  -610), INT16_C( -4882), INT16_C(-14649),
                            INT16_C( 30481), INT16_C(-20144), INT16_C( 20995), INT16_C( -4451),
                            INT16_C(  6425), INT16_C( 21336), INT16_C( 30080), INT16_C(  4310),
                            INT16_C( 29439), INT16_C(-28107), INT16_C( 32707), INT16_C(-17334),
                            INT16_C( 26460), INT16_C(-29244), INT16_C( -5806), INT16_C(-31467),
                            INT16_C( -9353), INT16_C( -9759), INT16_C(  6587), INT16_C(-14562)),
      simde_mm512_set_epi16(INT16_C( 24810), INT16_C(  1893), INT16_C(  4484), INT16_C( 18467),
                            INT16_C( 27267), INT16_C( 12302), INT16_C( 13826), INT16_C(   938),
                            INT16_C( 17680), INT16_C(   610), INT16_C(  4882), INT16_C( 14649),
                            INT16_C( 30481), INT16_C( 20144), INT16_C( 20995), INT16_C(  4451),
                            INT16_C(  6425), INT16_C( 21336), INT16_C( 30080), INT16_C(  4310),
                            INT16_C( 29439), INT16_C( 28107), INT16_C( 32707), INT16_C( 17334),
                            INT16_C( 26460), INT16_C( 29244), INT16_C(  5806), INT16_C( 31467),
                            INT16_C(  9353), INT16_C(  9759), INT16_C(  6587), INT16_C( 14562)) },
    { simde_mm512_set_epi16(INT16_C( 31294), INT16_C(-10840), INT16_C( 23692), INT16_C( -1500),
                            INT16_C(  2562), INT16_C(-16788), INT16_C( -9616), INT16_C( 31575),
                            INT16_C( 25554), INT16_C(-13527), INT16_C(-26722), INT16_C(  4852),
                            INT16_C(-20866), INT16_C(-19475), INT16_C(  4624), INT16_C(  9206),
                            INT16_C(-14800), INT16_C(-30682), INT16_C( 15889), INT16_C(  8584),
                            INT16_C( 27161), INT16_C(-23281), INT16_C( 25970), INT16_C(-11578),
                            INT16_C( 28932), INT16_C( 12842), INT16_C(   -29), INT16_C( -6679),
                            INT16_C(-17572), INT16_C(-17063), INT16_C( -2346), INT16_C( 20336)),
      simde_mm512_set_epi16(INT16_C( 31294), INT16_C( 10840), INT16_C( 23692), INT16_C(  1500),
                            INT16_C(  2562), INT16_C( 16788), INT16_C(  9616), INT16_C( 31575),
                            INT16_C( 25554), INT16_C( 13527), INT16_C( 26722), INT16_C(  4852),
                            INT16_C( 20866), INT16_C( 19475), INT16_C(  4624), INT16_C(  9206),
                            INT16_C( 14800), INT16_C( 30682), INT16_C( 15889), INT16_C(  8584),
                            INT16_C( 27161), INT16_C( 23281), INT16_C( 25970), INT16_C( 11578),
                            INT16_C( 28932), INT16_C( 12842), INT16_C(    29), INT16_C(  6679),
                            INT16_C( 17572), INT16_C( 17063), INT16_C(  2346), INT16_C( 20336)) },
    { simde_mm512_set_epi16(INT16_C(-29319), INT16_C( -6944), INT16_C( 10081), INT16_C( 26836),
                            INT16_C( 30965), INT16_C(-18751), INT16_C( -5923), INT16_C(-27401),
                            INT16_C(  7842), INT16_C( 24713), INT16_C( -3422), INT16_C(  8849),
                            INT16_C( 22266), INT16_C(-29640), INT16_C(  -264), INT16_C(-16823),
                            INT16_C(-28396), INT16_C( 29200), INT16_C( 18193), INT16_C( -3173),
                            INT16_C(  8244), INT16_C( -1296), INT16_C( 20026), INT16_C(  3755),
                            INT16_C(-14728), INT16_C( 26243), INT16_C( 18823), INT16_C(-30029),
                            INT16_C( 21566), INT16_C( 25734), INT16_C( -4271), INT16_C( 27065)),
      simde_mm512_set_epi16(INT16_C( 29319), INT16_C(  6944), INT16_C( 10081), INT16_C( 26836),
                            INT16_C( 30965), INT16_C( 18751), INT16_C(  5923), INT16_C( 27401),
                            INT16_C(  7842), INT16_C( 24713), INT16_C(  3422), INT16_C(  8849),
                            INT16_C( 22266), INT16_C( 29640), INT16_C(   264), INT16_C( 16823),
                            INT16_C( 28396), INT16_C( 29200), INT16_C( 18193), INT16_C(  3173),
                            INT16_C(  8244), INT16_C(  1296), INT16_C( 20026), INT16_C(  3755),
                            INT16_C( 14728), INT16_C( 26243), INT16_C( 18823), INT16_C( 30029),
                            INT16_C( 21566), INT16_C( 25734), INT16_C(  4271), INT16_C( 27065)) },
    { simde_mm512_set_epi16(INT16_C( 26713), INT16_C(  6075), INT16_C(-20498), INT16_C(-29395),
                            INT16_C( 28513), INT16_C(-24372), INT16_C( 30119), INT16_C( 21303),
                            INT16_C(-20009), INT16_C( 16878), INT16_C( -3364), INT16_C( -1142),
                            INT16_C( 26178), INT16_C(  1599), INT16_C(   583), INT16_C(-20121),
                            INT16_C( 25419), INT16_C(  4739), INT16_C( 22881), INT16_C( -2884),
                            INT16_C( -7360), INT16_C( 23146), INT16_C(-16850), INT16_C(-17018),
                            INT16_C(  9049), INT16_C(-31439), INT16_C( 20369), INT16_C( 26125),
                            INT16_C(  4615), INT16_C(  3018), INT16_C( 20462), INT16_C( 20538)),
      simde_mm512_set_epi16(INT16_C( 26713), INT16_C(  6075), INT16_C( 20498), INT16_C( 29395),
                            INT16_C( 28513), INT16_C( 24372), INT16_C( 30119), INT16_C( 21303),
                            INT16_C( 20009), INT16_C( 16878), INT16_C(  3364), INT16_C(  1142),
                            INT16_C( 26178), INT16_C(  1599), INT16_C(   583), INT16_C( 20121),
                            INT16_C( 25419), INT16_C(  4739), INT16_C( 22881), INT16_C(  2884),
                            INT16_C(  7360), INT16_C( 23146), INT16_C( 16850), INT16_C( 17018),
                            INT16_C(  9049), INT16_C( 31439), INT16_C( 20369), INT16_C( 26125),
                            INT16_C(  4615), INT16_C(  3018), INT16_C( 20462), INT16_C( 20538)) },
    { simde_mm512_set_epi16(INT16_C(-17426), INT16_C( -6113), INT16_C(-30180), INT16_C( 28425),
                            INT16_C(-15870), INT16_C(  6201), INT16_C( 15445), INT16_C(-31740),
                            INT16_C(-11778), INT16_C(-10748), INT16_C(-28415), INT16_C( -1743),
                            INT16_C( 22411), INT16_C( 18108), INT16_C( 23625), INT16_C( 27654),
                            INT16_C( 27868), INT16_C( 15645), INT16_C( 22336), INT16_C(-29935),
                            INT16_C( -3026), INT16_C(-19158), INT16_C( 20698), INT16_C( 21892),
                            INT16_C(-32012), INT16_C( 10508), INT16_C(-14383), INT16_C( 20676),
                            INT16_C(  6233), INT16_C(-11386), INT16_C(-13291), INT16_C( 13948)),
      simde_mm512_set_epi16(INT16_C( 17426), INT16_C(  6113), INT16_C( 30180), INT16_C( 28425),
                            INT16_C( 15870), INT16_C(  6201), INT16_C( 15445), INT16_C( 31740),
                            INT16_C( 11778), INT16_C( 10748), INT16_C( 28415), INT16_C(  1743),
                            INT16_C( 22411), INT16_C( 18108), INT16_C( 23625), INT16_C( 27654),
                            INT16_C( 27868), INT16_C( 15645), INT16_C( 22336), INT16_C( 29935),
                            INT16_C(  3026), INT16_C( 19158), INT16_C( 20698), INT16_C( 21892),
                            INT16_C( 32012), INT16_C( 10508), INT16_C( 14383), INT16_C( 20676),
                            INT16_C(  6233), INT16_C( 11386), INT16_C( 13291), INT16_C( 13948)) },
    { simde_mm512_set_epi16(INT16_C(  6099), INT16_C(-22144), INT16_C( 20288), INT16_C(-18323),
                            INT16_C(  -136), INT16_C( -4474), INT16_C(-14336), INT16_C( 25660),
                            INT16_C(-19775), INT16_C(  6691), INT16_C(-16568), INT16_C(  9907),
                            INT16_C(-31382), INT16_C(  1875), INT16_C( 22377), INT16_C(-21951),
                            INT16_C(-10385), INT16_C(-18760), INT16_C(  7844), INT16_C( 16059),
                            INT16_C(-14216), INT16_C( 22036), INT16_C(-20920), INT16_C( 11586),
                            INT16_C(-18048), INT16_C( -8950), INT16_C(-23337), INT16_C( 26279),
                            INT16_C( 12076), INT16_C(  3090), INT16_C( -7311), INT16_C( -5254)),
      simde_mm512_set_epi16(INT16_C(  6099), INT16_C( 22144), INT16_C( 20288), INT16_C( 18323),
                            INT16_C(   136), INT16_C(  4474), INT16_C( 14336), INT16_C( 25660),
                            INT16_C( 19775), INT16_C(  6691), INT16_C( 16568), INT16_C(  9907),
                            INT16_C( 31382), INT16_C(  1875), INT16_C( 22377), INT16_C( 21951),
                            INT16_C( 10385), INT16_C( 18760), INT16_C(  7844), INT16_C( 16059),
                            INT16_C( 14216), INT16_C( 22036), INT16_C( 20920), INT16_C( 11586),
                            INT16_C( 18048), INT16_C(  8950), INT16_C( 23337), INT16_C( 26279),
                            INT16_C( 12076), INT16_C(  3090), INT16_C(  7311), INT16_C(  5254)) },
    { simde_mm512_set_epi16(INT16_C(  1734), INT16_C(-24733), INT16_C(  6252), INT16_C(-10636),
                            INT16_C(-13019), INT16_C(  4439), INT16_C( 30486), INT16_C(  9898),
                            INT16_C( 18157), INT16_C( 29700), INT16_C(-19524), INT16_C(  5081),
                            INT16_C(  -888), INT16_C( 21733), INT16_C(-17288), INT16_C(-29729),
                            INT16_C(   877), INT16_C( 22002), INT16_C( 31006), INT16_C( 27903),
                            INT16_C( 29379), INT16_C( 11869), INT16_C( 12487), INT16_C(-24676),
                            INT16_C( 21504), INT16_C(-22063), INT16_C( 21762), INT16_C( 32035),
                            INT16_C( -2823), INT16_C(   772), INT16_C( 22127), INT16_C(-16867)),
      simde_mm512_set_epi16(INT16_C(  1734), INT16_C( 24733), INT16_C(  6252), INT16_C( 10636),
                            INT16_C( 13019), INT16_C(  4439), INT16_C( 30486), INT16_C(  9898),
                            INT16_C( 18157), INT16_C( 29700), INT16_C( 19524), INT16_C(  5081),
                            INT16_C(   888), INT16_C( 21733), INT16_C( 17288), INT16_C( 29729),
                            INT16_C(   877), INT16_C( 22002), INT16_C( 31006), INT16_C( 27903),
                            INT16_C( 29379), INT16_C( 11869), INT16_C( 12487), INT16_C( 24676),
                            INT16_C( 21504), INT16_C( 22063), INT16_C( 21762), INT16_C( 32035),
                            INT16_C(  2823), INT16_C(   772), INT16_C( 22127), INT16_C( 16867)) },
    { simde_mm512_set_epi16(INT16_C( 12349), INT16_C( 32588), INT16_C(-21894), INT16_C(-24438),
                            INT16_C( -9480), INT16_C( 14484), INT16_C(   264), INT16_C(  5772),
                            INT16_C(-13220), INT16_C( 17520), INT16_C(-23892), INT16_C( 25295),
                            INT16_C(-10903), INT16_C( 18210), INT16_C(-32005), INT16_C(  1475),
                            INT16_C(-31775), INT16_C(-32553), INT16_C( 21009), INT16_C(-11897),
                            INT16_C(   118), INT16_C( -4448), INT16_C( 11548), INT16_C( 27032),
                            INT16_C( -3816), INT16_C( 24167), INT16_C(-13680), INT16_C(  3963),
                            INT16_C( -6791), INT16_C(-30064), INT16_C(-17823), INT16_C( 15062)),
      simde_mm512_set_epi16(INT16_C( 12349), INT16_C( 32588), INT16_C( 21894), INT16_C( 24438),
                            INT16_C(  9480), INT16_C( 14484), INT16_C(   264), INT16_C(  5772),
                            INT16_C( 13220), INT16_C( 17520), INT16_C( 23892), INT16_C( 25295),
                            INT16_C( 10903), INT16_C( 18210), INT16_C( 32005), INT16_C(  1475),
                            INT16_C( 31775), INT16_C( 32553), INT16_C( 21009), INT16_C( 11897),
                            INT16_C(   118), INT16_C(  4448), INT16_C( 11548), INT16_C( 27032),
                            INT16_C(  3816), INT16_C( 24167), INT16_C( 13680), INT16_C(  3963),
                            INT16_C(  6791), INT16_C( 30064), INT16_C( 17823), INT16_C( 15062)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_abs_epi16(test_vec[i].a);
    simde_assert_m512i_i16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_add_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C( 115), INT8_C(  11), INT8_C(  17), INT8_C( -82),
                           INT8_C(-116), INT8_C( 112), INT8_C(  86), INT8_C(  99),
                           INT8_C(   1), INT8_C( -38), INT8_C( -55), INT8_C( -58),
                           INT8_C(  -6), INT8_C(-111), INT8_C(  46), INT8_C( -68),
                           INT8_C(  37), INT8_C(  -1), INT8_C( -43), INT8_C( -56),
                           INT8_C( -63), INT8_C(-106), INT8_C(  -2), INT8_C(  -9),
                           INT8_C( -26), INT8_C(  -5), INT8_C(-118), INT8_C(  21),
                           INT8_C( -80), INT8_C(  35), INT8_C(-114), INT8_C( -85),
                           INT8_C(  27), INT8_C( -99), INT8_C(  99), INT8_C(-104),
                           INT8_C(-109), INT8_C( -19), INT8_C( 106), INT8_C( -51),
                           INT8_C( 120), INT8_C(  -1), INT8_C(  -1), INT8_C( 103),
                           INT8_C( 113), INT8_C(   3), INT8_C( -59), INT8_C(  26),
                           INT8_C( -39), INT8_C(  27), INT8_C(  22), INT8_C(  15),
                           INT8_C( -88), INT8_C(  68), INT8_C( -57), INT8_C(  96),
                           INT8_C( -60), INT8_C(-103), INT8_C( -37), INT8_C(   9),
                           INT8_C(-102), INT8_C( -46), INT8_C( 105), INT8_C(  91)),
      simde_mm512_set_epi8(INT8_C(  -4), INT8_C(  88), INT8_C( -59), INT8_C(  79),
                           INT8_C( -16), INT8_C( -37), INT8_C(  72), INT8_C( -42),
                           INT8_C( -74), INT8_C(  65), INT8_C(  24), INT8_C(  53),
                           INT8_C( -92), INT8_C(  20), INT8_C(  52), INT8_C(  13),
                           INT8_C(  -8), INT8_C(  41), INT8_C(  39), INT8_C(  95),
                           INT8_C( -72), INT8_C(  80), INT8_C(-125), INT8_C( -55),
                           INT8_C( -63), INT8_C(-100), INT8_C( -35), INT8_C(  63),
                           INT8_C( -96), INT8_C(-124), INT8_C(  33), INT8_C( -43),
                           INT8_C(  87), INT8_C( -16), INT8_C( -39), INT8_C(  26),
                           INT8_C(  73), INT8_C(  13), INT8_C( -30), INT8_C(  81),
                           INT8_C(-115), INT8_C(  94), INT8_C(-110), INT8_C(-100),
                           INT8_C(  75), INT8_C(-127), INT8_C( -22), INT8_C(  36),
                           INT8_C(-104), INT8_C( -42), INT8_C(-112), INT8_C( -74),
                           INT8_C( 107), INT8_C(  55), INT8_C(  -9), INT8_C( -65),
                           INT8_C(  11), INT8_C(   2), INT8_C( 119), INT8_C(  92),
                           INT8_C(-124), INT8_C(  36), INT8_C(-125), INT8_C(  15)),
      simde_mm512_set_epi8(INT8_C( 111), INT8_C(  99), INT8_C( -42), INT8_C(  -3),
                           INT8_C( 124), INT8_C(  75), INT8_C( -98), INT8_C(  57),
                           INT8_C( -73), INT8_C(  27), INT8_C( -31), INT8_C(  -5),
                           INT8_C( -98), INT8_C( -91), INT8_C(  98), INT8_C( -55),
                           INT8_C(  29), INT8_C(  40), INT8_C(  -4), INT8_C(  39),
                           INT8_C( 121), INT8_C( -26), INT8_C(-127), INT8_C( -64),
                           INT8_C( -89), INT8_C(-105), INT8_C( 103), INT8_C(  84),
                           INT8_C(  80), INT8_C( -89), INT8_C( -81), INT8_C(-128),
                           INT8_C( 114), INT8_C(-115), INT8_C(  60), INT8_C( -78),
                           INT8_C( -36), INT8_C(  -6), INT8_C(  76), INT8_C(  30),
                           INT8_C(   5), INT8_C(  93), INT8_C(-111), INT8_C(   3),
                           INT8_C( -68), INT8_C(-124), INT8_C( -81), INT8_C(  62),
                           INT8_C( 113), INT8_C( -15), INT8_C( -90), INT8_C( -59),
                           INT8_C(  19), INT8_C( 123), INT8_C( -66), INT8_C(  31),
                           INT8_C( -49), INT8_C(-101), INT8_C(  82), INT8_C( 101),
                           INT8_C(  30), INT8_C( -10), INT8_C( -20), INT8_C( 106)) },
    { simde_mm512_set_epi8(INT8_C(  57), INT8_C(  15), INT8_C( -30), INT8_C(   3),
                           INT8_C(-124), INT8_C( -51), INT8_C(  61), INT8_C(  22),
                           INT8_C( -57), INT8_C(-107), INT8_C( -23), INT8_C( -68),
                           INT8_C( -41), INT8_C( -19), INT8_C(  38), INT8_C( -82),
                           INT8_C(  -1), INT8_C(  55), INT8_C(-122), INT8_C(  64),
                           INT8_C( -69), INT8_C(-127), INT8_C( -66), INT8_C(  72),
                           INT8_C( -14), INT8_C(  65), INT8_C( -69), INT8_C(   5),
                           INT8_C( -26), INT8_C( -84), INT8_C(  12), INT8_C(  35),
                           INT8_C(  53), INT8_C(  32), INT8_C(  97), INT8_C(  55),
                           INT8_C( -94), INT8_C( 111), INT8_C(  41), INT8_C(  80),
                           INT8_C( -29), INT8_C(-121), INT8_C( -73), INT8_C( -86),
                           INT8_C(  52), INT8_C(  51), INT8_C(  26), INT8_C( 100),
                           INT8_C( -64), INT8_C(   5), INT8_C(  57), INT8_C(-108),
                           INT8_C(  52), INT8_C( -65), INT8_C( -47), INT8_C( -64),
                           INT8_C( -55), INT8_C( -68), INT8_C( 112), INT8_C(-108),
                           INT8_C(-116), INT8_C( -90), INT8_C( -20), INT8_C(  47)),
      simde_mm512_set_epi8(INT8_C(  76), INT8_C( 118), INT8_C(-128), INT8_C( -20),
                           INT8_C(-107), INT8_C(  12), INT8_C( 118), INT8_C( 108),
                           INT8_C( -48), INT8_C( -24), INT8_C(  81), INT8_C(-113),
                           INT8_C(  99), INT8_C(  10), INT8_C( -10), INT8_C( -77),
                           INT8_C( -98), INT8_C(  35), INT8_C(  -2), INT8_C( -48),
                           INT8_C(  36), INT8_C( -25), INT8_C(  54), INT8_C(  89),
                           INT8_C( -18), INT8_C( -82), INT8_C( -90), INT8_C(  72),
                           INT8_C( -65), INT8_C(  90), INT8_C( -54), INT8_C( -91),
                           INT8_C(  69), INT8_C(-114), INT8_C(  88), INT8_C(  93),
                           INT8_C(  65), INT8_C(-106), INT8_C( -12), INT8_C(  57),
                           INT8_C( -13), INT8_C(  91), INT8_C(-113), INT8_C( -86),
                           INT8_C(  40), INT8_C(  95), INT8_C(-105), INT8_C(  46),
                           INT8_C(  92), INT8_C( -57), INT8_C(  63), INT8_C(  82),
                           INT8_C(  27), INT8_C(  21), INT8_C( -77), INT8_C( -75),
                           INT8_C(  37), INT8_C(-116), INT8_C(  30), INT8_C( -13),
                           INT8_C( -44), INT8_C(  75), INT8_C( -22), INT8_C(  66)),
      simde_mm512_set_epi8(INT8_C(-123), INT8_C(-123), INT8_C(  98), INT8_C( -17),
                           INT8_C(  25), INT8_C( -39), INT8_C( -77), INT8_C(-126),
                           INT8_C(-105), INT8_C( 125), INT8_C(  58), INT8_C(  75),
                           INT8_C(  58), INT8_C(  -9), INT8_C(  28), INT8_C(  97),
                           INT8_C( -99), INT8_C(  90), INT8_C(-124), INT8_C(  16),
                           INT8_C( -33), INT8_C( 104), INT8_C( -12), INT8_C( -95),
                           INT8_C( -32), INT8_C( -17), INT8_C(  97), INT8_C(  77),
                           INT8_C( -91), INT8_C(   6), INT8_C( -42), INT8_C( -56),
                           INT8_C( 122), INT8_C( -82), INT8_C( -71), INT8_C(-108),
                           INT8_C( -29), INT8_C(   5), INT8_C(  29), INT8_C(-119),
                           INT8_C( -42), INT8_C( -30), INT8_C(  70), INT8_C(  84),
                           INT8_C(  92), INT8_C(-110), INT8_C( -79), INT8_C(-110),
                           INT8_C(  28), INT8_C( -52), INT8_C( 120), INT8_C( -26),
                           INT8_C(  79), INT8_C( -44), INT8_C(-124), INT8_C( 117),
                           INT8_C( -18), INT8_C(  72), INT8_C(-114), INT8_C(-121),
                           INT8_C(  96), INT8_C( -15), INT8_C( -42), INT8_C( 113)) },
    { simde_mm512_set_epi8(INT8_C( -42), INT8_C(  72), INT8_C(  79), INT8_C( -37),
                           INT8_C( -31), INT8_C( 119), INT8_C(-100), INT8_C(  23),
                           INT8_C(-123), INT8_C( 123), INT8_C( -51), INT8_C(   1),
                           INT8_C( -60), INT8_C(-123), INT8_C(  28), INT8_C( 111),
                           INT8_C( 126), INT8_C(  95), INT8_C( 101), INT8_C(  70),
                           INT8_C(  72), INT8_C(  44), INT8_C(  29), INT8_C( -21),
                           INT8_C(  63), INT8_C(  47), INT8_C(-124), INT8_C(-117),
                           INT8_C( -56), INT8_C( -90), INT8_C( -21), INT8_C(-111),
                           INT8_C( -47), INT8_C( -61), INT8_C( -78), INT8_C( 127),
                           INT8_C(  45), INT8_C( -96), INT8_C( -54), INT8_C(  68),
                           INT8_C(  18), INT8_C( -18), INT8_C(-121), INT8_C(  69),
                           INT8_C( -68), INT8_C( 106), INT8_C( -34), INT8_C(  25),
                           INT8_C(  90), INT8_C( -21), INT8_C( -63), INT8_C(  32),
                           INT8_C( -48), INT8_C(  96), INT8_C( 124), INT8_C(  38),
                           INT8_C( 103), INT8_C(  66), INT8_C(  88), INT8_C( 121),
                           INT8_C(  34), INT8_C( -59), INT8_C(  23), INT8_C( -93)),
      simde_mm512_set_epi8(INT8_C(  46), INT8_C(  98), INT8_C( -25), INT8_C(  13),
                           INT8_C(   8), INT8_C(-127), INT8_C( -39), INT8_C( -31),
                           INT8_C(  60), INT8_C(  14), INT8_C( 113), INT8_C( -32),
                           INT8_C(-122), INT8_C( 104), INT8_C(  35), INT8_C(  44),
                           INT8_C(  27), INT8_C(  81), INT8_C(-121), INT8_C( -61),
                           INT8_C( -44), INT8_C( 106), INT8_C( 114), INT8_C( -89),
                           INT8_C(-115), INT8_C( -25), INT8_C(  47), INT8_C(-101),
                           INT8_C( -49), INT8_C(  29), INT8_C(  44), INT8_C( -34),
                           INT8_C( -90), INT8_C(  -8), INT8_C(  69), INT8_C(  81),
                           INT8_C(  85), INT8_C(-109), INT8_C(  12), INT8_C(  47),
                           INT8_C(  61), INT8_C(  61), INT8_C( -51), INT8_C( -70),
                           INT8_C( 105), INT8_C( -31), INT8_C(  75), INT8_C(-104),
                           INT8_C( -80), INT8_C( 113), INT8_C( -30), INT8_C(   9),
                           INT8_C(-104), INT8_C( -44), INT8_C( -88), INT8_C(-109),
                           INT8_C(-105), INT8_C(  71), INT8_C(-105), INT8_C( -42),
                           INT8_C(  66), INT8_C( -56), INT8_C(  28), INT8_C( 118)),
      simde_mm512_set_epi8(INT8_C(   4), INT8_C( -86), INT8_C(  54), INT8_C( -24),
                           INT8_C( -23), INT8_C(  -8), INT8_C( 117), INT8_C(  -8),
                           INT8_C( -63), INT8_C(-119), INT8_C(  62), INT8_C( -31),
                           INT8_C(  74), INT8_C( -19), INT8_C(  63), INT8_C(-101),
                           INT8_C(-103), INT8_C( -80), INT8_C( -20), INT8_C(   9),
                           INT8_C(  28), INT8_C(-106), INT8_C(-113), INT8_C(-110),
                           INT8_C( -52), INT8_C(  22), INT8_C( -77), INT8_C(  38),
                           INT8_C(-105), INT8_C( -61), INT8_C(  23), INT8_C( 111),
                           INT8_C( 119), INT8_C( -69), INT8_C(  -9), INT8_C( -48),
                           INT8_C(-126), INT8_C(  51), INT8_C( -42), INT8_C( 115),
                           INT8_C(  79), INT8_C(  43), INT8_C(  84), INT8_C(  -1),
                           INT8_C(  37), INT8_C(  75), INT8_C(  41), INT8_C( -79),
                           INT8_C(  10), INT8_C(  92), INT8_C( -93), INT8_C(  41),
                           INT8_C( 104), INT8_C(  52), INT8_C(  36), INT8_C( -71),
                           INT8_C(  -2), INT8_C(-119), INT8_C( -17), INT8_C(  79),
                           INT8_C( 100), INT8_C(-115), INT8_C(  51), INT8_C(  25)) },
    { simde_mm512_set_epi8(INT8_C(  -3), INT8_C(  29), INT8_C( -28), INT8_C(  86),
                           INT8_C( -94), INT8_C(  70), INT8_C(-109), INT8_C( 103),
                           INT8_C(  -8), INT8_C(  53), INT8_C(  38), INT8_C(  18),
                           INT8_C( -99), INT8_C(  98), INT8_C(  27), INT8_C(-117),
                           INT8_C(  14), INT8_C(-108), INT8_C(-106), INT8_C(  -7),
                           INT8_C(  88), INT8_C( -91), INT8_C(-111), INT8_C(-100),
                           INT8_C(  53), INT8_C( 120), INT8_C( -34), INT8_C( -61),
                           INT8_C( -73), INT8_C( -41), INT8_C(-113), INT8_C( -16),
                           INT8_C(  45), INT8_C( -42), INT8_C( -14), INT8_C( -59),
                           INT8_C( -36), INT8_C(  37), INT8_C(  57), INT8_C(  75),
                           INT8_C( -73), INT8_C( -74), INT8_C( -13), INT8_C(  15),
                           INT8_C(  41), INT8_C( -73), INT8_C( -50), INT8_C(  94),
                           INT8_C( 103), INT8_C(  70), INT8_C(-120), INT8_C( 118),
                           INT8_C(   7), INT8_C( 100), INT8_C(   8), INT8_C( -86),
                           INT8_C(-120), INT8_C(  59), INT8_C(  -6), INT8_C(  65),
                           INT8_C(  -9), INT8_C(  -8), INT8_C( -33), INT8_C(-122)),
      simde_mm512_set_epi8(INT8_C( -26), INT8_C( 109), INT8_C(  62), INT8_C(  86),
                           INT8_C( 117), INT8_C(  66), INT8_C(  89), INT8_C( 118),
                           INT8_C(-108), INT8_C( 120), INT8_C( -88), INT8_C(  18),
                           INT8_C(-107), INT8_C( -13), INT8_C(  17), INT8_C( -85),
                           INT8_C(  88), INT8_C( -43), INT8_C( 121), INT8_C( -99),
                           INT8_C(  28), INT8_C( 101), INT8_C(  72), INT8_C(-109),
                           INT8_C(  43), INT8_C( -84), INT8_C(-128), INT8_C( 110),
                           INT8_C(-126), INT8_C(-109), INT8_C(  59), INT8_C(  69),
                           INT8_C(   3), INT8_C( -65), INT8_C( -31), INT8_C(  96),
                           INT8_C( 127), INT8_C(  42), INT8_C(-111), INT8_C( -59),
                           INT8_C( 125), INT8_C( 114), INT8_C( -80), INT8_C( -97),
                           INT8_C(   8), INT8_C(   1), INT8_C( -79), INT8_C(-116),
                           INT8_C(  -6), INT8_C( -44), INT8_C( -40), INT8_C(  10),
                           INT8_C(   8), INT8_C( 105), INT8_C( -27), INT8_C(  13),
                           INT8_C(  63), INT8_C(-122), INT8_C( 115), INT8_C( 100),
                           INT8_C(  83), INT8_C(  44), INT8_C( 112), INT8_C(  95)),
      simde_mm512_set_epi8(INT8_C( -29), INT8_C(-118), INT8_C(  34), INT8_C( -84),
                           INT8_C(  23), INT8_C(-120), INT8_C( -20), INT8_C( -35),
                           INT8_C(-116), INT8_C( -83), INT8_C( -50), INT8_C(  36),
                           INT8_C(  50), INT8_C(  85), INT8_C(  44), INT8_C(  54),
                           INT8_C( 102), INT8_C( 105), INT8_C(  15), INT8_C(-106),
                           INT8_C( 116), INT8_C(  10), INT8_C( -39), INT8_C(  47),
                           INT8_C(  96), INT8_C(  36), INT8_C(  94), INT8_C(  49),
                           INT8_C(  57), INT8_C( 106), INT8_C( -54), INT8_C(  53),
                           INT8_C(  48), INT8_C(-107), INT8_C( -45), INT8_C(  37),
                           INT8_C(  91), INT8_C(  79), INT8_C( -54), INT8_C(  16),
                           INT8_C(  52), INT8_C(  40), INT8_C( -93), INT8_C( -82),
                           INT8_C(  49), INT8_C( -72), INT8_C( 127), INT8_C( -22),
                           INT8_C(  97), INT8_C(  26), INT8_C(  96), INT8_C(-128),
                           INT8_C(  15), INT8_C( -51), INT8_C( -19), INT8_C( -73),
                           INT8_C( -57), INT8_C( -63), INT8_C( 109), INT8_C( -91),
                           INT8_C(  74), INT8_C(  36), INT8_C(  79), INT8_C( -27)) },
    { simde_mm512_set_epi8(INT8_C(  24), INT8_C(   9), INT8_C(-116), INT8_C( -64),
                           INT8_C( -42), INT8_C( 109), INT8_C(  95), INT8_C( -20),
                           INT8_C(  89), INT8_C( -99), INT8_C(  77), INT8_C( 112),
                           INT8_C( -13), INT8_C(  79), INT8_C( -16), INT8_C(  12),
                           INT8_C( -85), INT8_C( 106), INT8_C(  16), INT8_C( -61),
                           INT8_C(   5), INT8_C(-112), INT8_C(  54), INT8_C( -11),
                           INT8_C(  71), INT8_C( -59), INT8_C(  67), INT8_C( -11),
                           INT8_C( -11), INT8_C( -46), INT8_C( 107), INT8_C( -99),
                           INT8_C(-113), INT8_C(  82), INT8_C( -72), INT8_C( -21),
                           INT8_C(  95), INT8_C( -24), INT8_C( -42), INT8_C( -99),
                           INT8_C(  85), INT8_C( -52), INT8_C(  -3), INT8_C( 109),
                           INT8_C(  79), INT8_C( 113), INT8_C(  -3), INT8_C(-117),
                           INT8_C(   6), INT8_C( -32), INT8_C(-122), INT8_C(  96),
                           INT8_C(  62), INT8_C(-100), INT8_C( 110), INT8_C( -49),
                           INT8_C(  45), INT8_C( 122), INT8_C(  74), INT8_C(  32),
                           INT8_C( 109), INT8_C( -21), INT8_C(  81), INT8_C(  80)),
      simde_mm512_set_epi8(INT8_C(-106), INT8_C(  31), INT8_C(-121), INT8_C(  -3),
                           INT8_C(  94), INT8_C(  59), INT8_C( 118), INT8_C( -15),
                           INT8_C( -60), INT8_C( -99), INT8_C( -41), INT8_C( -73),
                           INT8_C( -92), INT8_C(  67), INT8_C(  70), INT8_C(  66),
                           INT8_C(  68), INT8_C(  57), INT8_C( -63), INT8_C( -62),
                           INT8_C(  37), INT8_C( -38), INT8_C( -53), INT8_C(-110),
                           INT8_C(  30), INT8_C(  59), INT8_C( -55), INT8_C(  83),
                           INT8_C(  74), INT8_C( -18), INT8_C( -82), INT8_C(  94),
                           INT8_C( -40), INT8_C(  48), INT8_C( -29), INT8_C( -51),
                           INT8_C( -13), INT8_C( 112), INT8_C( 121), INT8_C(  99),
                           INT8_C(  70), INT8_C(  43), INT8_C( -63), INT8_C(  72),
                           INT8_C(   7), INT8_C( -56), INT8_C( 127), INT8_C( -86),
                           INT8_C(  95), INT8_C(  59), INT8_C(  16), INT8_C(  91),
                           INT8_C(  36), INT8_C(  41), INT8_C(  40), INT8_C(  36),
                           INT8_C(  96), INT8_C(  97), INT8_C( -31), INT8_C( -50),
                           INT8_C( -15), INT8_C(-117), INT8_C(-100), INT8_C(  36)),
      simde_mm512_set_epi8(INT8_C( -82), INT8_C(  40), INT8_C(  19), INT8_C( -67),
                           INT8_C(  52), INT8_C( -88), INT8_C( -43), INT8_C( -35),
                           INT8_C(  29), INT8_C(  58), INT8_C(  36), INT8_C(  39),
                           INT8_C(-105), INT8_C(-110), INT8_C(  54), INT8_C(  78),
                           INT8_C( -17), INT8_C( -93), INT8_C( -47), INT8_C(-123),
                           INT8_C(  42), INT8_C( 106), INT8_C(   1), INT8_C(-121),
                           INT8_C( 101), INT8_C(   0), INT8_C(  12), INT8_C(  72),
                           INT8_C(  63), INT8_C( -64), INT8_C(  25), INT8_C(  -5),
                           INT8_C( 103), INT8_C(-126), INT8_C(-101), INT8_C( -72),
                           INT8_C(  82), INT8_C(  88), INT8_C(  79), INT8_C(   0),
                           INT8_C(-101), INT8_C(  -9), INT8_C( -66), INT8_C( -75),
                           INT8_C(  86), INT8_C(  57), INT8_C( 124), INT8_C(  53),
                           INT8_C( 101), INT8_C(  27), INT8_C(-106), INT8_C( -69),
                           INT8_C(  98), INT8_C( -59), INT8_C(-106), INT8_C( -13),
                           INT8_C(-115), INT8_C( -37), INT8_C(  43), INT8_C( -18),
                           INT8_C(  94), INT8_C( 118), INT8_C( -19), INT8_C( 116)) },
    { simde_mm512_set_epi8(INT8_C(  80), INT8_C(  85), INT8_C( -77), INT8_C(-120),
                           INT8_C(  93), INT8_C( 119), INT8_C(  95), INT8_C(  48),
                           INT8_C( -54), INT8_C( -59), INT8_C(  44), INT8_C( -62),
                           INT8_C( -27), INT8_C(  -3), INT8_C(-114), INT8_C(  91),
                           INT8_C(  48), INT8_C(-100), INT8_C( -13), INT8_C( -26),
                           INT8_C( -23), INT8_C(  24), INT8_C( -41), INT8_C(-127),
                           INT8_C( 116), INT8_C(  67), INT8_C(  28), INT8_C( -88),
                           INT8_C( 124), INT8_C( 110), INT8_C( 101), INT8_C( -80),
                           INT8_C(  83), INT8_C(  88), INT8_C(  12), INT8_C(  67),
                           INT8_C(-114), INT8_C( 104), INT8_C(  22), INT8_C(  33),
                           INT8_C(  17), INT8_C(  85), INT8_C(-116), INT8_C( -42),
                           INT8_C(-114), INT8_C(-115), INT8_C( -45), INT8_C(  18),
                           INT8_C( 100), INT8_C( -40), INT8_C( -20), INT8_C( -18),
                           INT8_C(  50), INT8_C(-118), INT8_C(-126), INT8_C(  30),
                           INT8_C( -11), INT8_C(-123), INT8_C( -50), INT8_C( -43),
                           INT8_C(  -8), INT8_C(  59), INT8_C( -29), INT8_C( 113)),
      simde_mm512_set_epi8(INT8_C(  28), INT8_C(-126), INT8_C(  70), INT8_C( 101),
                           INT8_C( -70), INT8_C( -45), INT8_C(  72), INT8_C(-104),
                           INT8_C(  -2), INT8_C( 127), INT8_C(  19), INT8_C(  17),
                           INT8_C(  90), INT8_C(  92), INT8_C(  57), INT8_C( -92),
                           INT8_C(   4), INT8_C(-125), INT8_C(-100), INT8_C( -61),
                           INT8_C(  20), INT8_C(  82), INT8_C( -88), INT8_C( -42),
                           INT8_C(  71), INT8_C(  54), INT8_C(-128), INT8_C(  30),
                           INT8_C( 117), INT8_C(-111), INT8_C(  67), INT8_C( -75),
                           INT8_C( 119), INT8_C(  86), INT8_C( 121), INT8_C(  38),
                           INT8_C(   2), INT8_C(  76), INT8_C( 126), INT8_C( -13),
                           INT8_C( 110), INT8_C(-128), INT8_C(   0), INT8_C(  57),
                           INT8_C( -22), INT8_C(  31), INT8_C(  89), INT8_C( -92),
                           INT8_C(   1), INT8_C(   2), INT8_C(-122), INT8_C(  89),
                           INT8_C(  27), INT8_C(-110), INT8_C(-100), INT8_C( -82),
                           INT8_C(  99), INT8_C(  88), INT8_C(  22), INT8_C(-115),
                           INT8_C( -82), INT8_C(  80), INT8_C(  99), INT8_C(  -2)),
      simde_mm512_set_epi8(INT8_C( 108), INT8_C( -41), INT8_C(  -7), INT8_C( -19),
                           INT8_C(  23), INT8_C(  74), INT8_C( -89), INT8_C( -56),
                           INT8_C( -56), INT8_C(  68), INT8_C(  63), INT8_C( -45),
                           INT8_C(  63), INT8_C(  89), INT8_C( -57), INT8_C(  -1),
                           INT8_C(  52), INT8_C(  31), INT8_C(-113), INT8_C( -87),
                           INT8_C(  -3), INT8_C( 106), INT8_C( 127), INT8_C(  87),
                           INT8_C( -69), INT8_C( 121), INT8_C(-100), INT8_C( -58),
                           INT8_C( -15), INT8_C(  -1), INT8_C( -88), INT8_C( 101),
                           INT8_C( -54), INT8_C( -82), INT8_C(-123), INT8_C( 105),
                           INT8_C(-112), INT8_C( -76), INT8_C(-108), INT8_C(  20),
                           INT8_C( 127), INT8_C( -43), INT8_C(-116), INT8_C(  15),
                           INT8_C( 120), INT8_C( -84), INT8_C(  44), INT8_C( -74),
                           INT8_C( 101), INT8_C( -38), INT8_C( 114), INT8_C(  71),
                           INT8_C(  77), INT8_C(  28), INT8_C(  30), INT8_C( -52),
                           INT8_C(  88), INT8_C( -35), INT8_C( -28), INT8_C(  98),
                           INT8_C( -90), INT8_C(-117), INT8_C(  70), INT8_C( 111)) },
    { simde_mm512_set_epi8(INT8_C( -43), INT8_C( -96), INT8_C(-113), INT8_C(  75),
                           INT8_C( -67), INT8_C( 113), INT8_C(  41), INT8_C( -67),
                           INT8_C(  94), INT8_C(  93), INT8_C(  35), INT8_C( -32),
                           INT8_C(  30), INT8_C(-121), INT8_C( -92), INT8_C(-118),
                           INT8_C( 105), INT8_C(-107), INT8_C(  48), INT8_C( 107),
                           INT8_C( -33), INT8_C(-100), INT8_C( -43), INT8_C(  97),
                           INT8_C(-123), INT8_C( -97), INT8_C(  96), INT8_C(  10),
                           INT8_C(  30), INT8_C( 102), INT8_C( 119), INT8_C( -55),
                           INT8_C(-113), INT8_C(  -3), INT8_C(-122), INT8_C( -21),
                           INT8_C(  70), INT8_C(  74), INT8_C(  98), INT8_C( -49),
                           INT8_C( 101), INT8_C(  90), INT8_C(  68), INT8_C( -17),
                           INT8_C(  49), INT8_C( 116), INT8_C(-111), INT8_C( -95),
                           INT8_C(-128), INT8_C(  93), INT8_C(  98), INT8_C( -79),
                           INT8_C( 121), INT8_C( -52), INT8_C(-115), INT8_C(  39),
                           INT8_C(  91), INT8_C(  46), INT8_C( -75), INT8_C(  63),
                           INT8_C( -31), INT8_C( 120), INT8_C(-108), INT8_C(  86)),
      simde_mm512_set_epi8(INT8_C(  75), INT8_C( -43), INT8_C( -90), INT8_C(  15),
                           INT8_C( 100), INT8_C( 121), INT8_C( -17), INT8_C(  16),
                           INT8_C( -90), INT8_C(  59), INT8_C( -72), INT8_C( -76),
                           INT8_C(  60), INT8_C( 113), INT8_C( -66), INT8_C( 105),
                           INT8_C(   8), INT8_C(  77), INT8_C(  56), INT8_C(  -8),
                           INT8_C(  53), INT8_C(  44), INT8_C(  37), INT8_C( -80),
                           INT8_C( -40), INT8_C( -78), INT8_C(   0), INT8_C( -90),
                           INT8_C( -51), INT8_C( -88), INT8_C( -69), INT8_C(-127),
                           INT8_C(  54), INT8_C(  76), INT8_C( -69), INT8_C( -97),
                           INT8_C( -54), INT8_C(  83), INT8_C(  74), INT8_C(  94),
                           INT8_C(  53), INT8_C( -44), INT8_C( -80), INT8_C(   9),
                           INT8_C( -83), INT8_C( -78), INT8_C(  43), INT8_C(  30),
                           INT8_C( -30), INT8_C(  10), INT8_C(  23), INT8_C(  -6),
                           INT8_C( -27), INT8_C(  74), INT8_C(  46), INT8_C( -50),
                           INT8_C(  61), INT8_C( 109), INT8_C(  91), INT8_C( -60),
                           INT8_C(  79), INT8_C( 126), INT8_C(  87), INT8_C( -94)),
      simde_mm512_set_epi8(INT8_C(  32), INT8_C( 117), INT8_C(  53), INT8_C(  90),
                           INT8_C(  33), INT8_C( -22), INT8_C(  24), INT8_C( -51),
                           INT8_C(   4), INT8_C(-104), INT8_C( -37), INT8_C(-108),
                           INT8_C(  90), INT8_C(  -8), INT8_C(  98), INT8_C( -13),
                           INT8_C( 113), INT8_C( -30), INT8_C( 104), INT8_C(  99),
                           INT8_C(  20), INT8_C( -56), INT8_C(  -6), INT8_C(  17),
                           INT8_C(  93), INT8_C(  81), INT8_C(  96), INT8_C( -80),
                           INT8_C( -21), INT8_C(  14), INT8_C(  50), INT8_C(  74),
                           INT8_C( -59), INT8_C(  73), INT8_C(  65), INT8_C(-118),
                           INT8_C(  16), INT8_C( -99), INT8_C( -84), INT8_C(  45),
                           INT8_C(-102), INT8_C(  46), INT8_C( -12), INT8_C(  -8),
                           INT8_C( -34), INT8_C(  38), INT8_C( -68), INT8_C( -65),
                           INT8_C(  98), INT8_C( 103), INT8_C( 121), INT8_C( -85),
                           INT8_C(  94), INT8_C(  22), INT8_C( -69), INT8_C( -11),
                           INT8_C(-104), INT8_C(-101), INT8_C(  16), INT8_C(   3),
                           INT8_C(  48), INT8_C( -10), INT8_C( -21), INT8_C(  -8)) },
    { simde_mm512_set_epi8(INT8_C(-100), INT8_C( -80), INT8_C(  14), INT8_C(  -9),
                           INT8_C( -67), INT8_C(   5), INT8_C( -95), INT8_C(  68),
                           INT8_C( -16), INT8_C(  20), INT8_C(  22), INT8_C(  -3),
                           INT8_C(-127), INT8_C( -17), INT8_C( -13), INT8_C(  40),
                           INT8_C(  91), INT8_C( -39), INT8_C( -79), INT8_C(  85),
                           INT8_C(  76), INT8_C(  75), INT8_C( -81), INT8_C( -23),
                           INT8_C(  13), INT8_C( -90), INT8_C(   0), INT8_C( -49),
                           INT8_C(  13), INT8_C( -15), INT8_C(  80), INT8_C(  84),
                           INT8_C( -31), INT8_C(  42), INT8_C(-117), INT8_C( -41),
                           INT8_C(  40), INT8_C(  34), INT8_C(  52), INT8_C(  57),
                           INT8_C( -36), INT8_C(  54), INT8_C( -88), INT8_C( -37),
                           INT8_C(  42), INT8_C( -25), INT8_C( -28), INT8_C(  97),
                           INT8_C(  76), INT8_C(  49), INT8_C(  39), INT8_C( -10),
                           INT8_C(-105), INT8_C(-112), INT8_C(  83), INT8_C(   4),
                           INT8_C(-119), INT8_C(  19), INT8_C(  94), INT8_C( -63),
                           INT8_C(-125), INT8_C( -14), INT8_C( -99), INT8_C(-109)),
      simde_mm512_set_epi8(INT8_C(-125), INT8_C(  58), INT8_C(  21), INT8_C( -49),
                           INT8_C(  57), INT8_C( 100), INT8_C( -53), INT8_C( -95),
                           INT8_C(  11), INT8_C(  86), INT8_C(-107), INT8_C( -97),
                           INT8_C( -44), INT8_C(  32), INT8_C( -88), INT8_C(-124),
                           INT8_C(  62), INT8_C( -59), INT8_C( -30), INT8_C( -67),
                           INT8_C(  31), INT8_C( -63), INT8_C(  67), INT8_C(-105),
                           INT8_C( -12), INT8_C(  36), INT8_C(  20), INT8_C(-120),
                           INT8_C( -47), INT8_C( -93), INT8_C( -39), INT8_C(  11),
                           INT8_C(   4), INT8_C(-127), INT8_C( -25), INT8_C( -13),
                           INT8_C(  26), INT8_C(  36), INT8_C(  -4), INT8_C(  60),
                           INT8_C( -65), INT8_C(  57), INT8_C( -62), INT8_C( 117),
                           INT8_C(-120), INT8_C(  29), INT8_C(-126), INT8_C(  63),
                           INT8_C(  51), INT8_C(  25), INT8_C(  21), INT8_C( -38),
                           INT8_C( -46), INT8_C(  17), INT8_C(  -4), INT8_C(  47),
                           INT8_C( -58), INT8_C( -51), INT8_C( -29), INT8_C(   0),
                           INT8_C( -47), INT8_C(-118), INT8_C( -65), INT8_C(-111)),
      simde_mm512_set_epi8(INT8_C(  31), INT8_C( -22), INT8_C(  35), INT8_C( -58),
                           INT8_C( -10), INT8_C( 105), INT8_C( 108), INT8_C( -27),
                           INT8_C(  -5), INT8_C( 106), INT8_C( -85), INT8_C(-100),
                           INT8_C(  85), INT8_C(  15), INT8_C(-101), INT8_C( -84),
                           INT8_C(-103), INT8_C( -98), INT8_C(-109), INT8_C(  18),
                           INT8_C( 107), INT8_C(  12), INT8_C( -14), INT8_C(-128),
                           INT8_C(   1), INT8_C( -54), INT8_C(  20), INT8_C(  87),
                           INT8_C( -34), INT8_C(-108), INT8_C(  41), INT8_C(  95),
                           INT8_C( -27), INT8_C( -85), INT8_C( 114), INT8_C( -54),
                           INT8_C(  66), INT8_C(  70), INT8_C(  48), INT8_C( 117),
                           INT8_C(-101), INT8_C( 111), INT8_C( 106), INT8_C(  80),
                           INT8_C( -78), INT8_C(   4), INT8_C( 102), INT8_C( -96),
                           INT8_C( 127), INT8_C(  74), INT8_C(  60), INT8_C( -48),
                           INT8_C( 105), INT8_C( -95), INT8_C(  79), INT8_C(  51),
                           INT8_C(  79), INT8_C( -32), INT8_C(  65), INT8_C( -63),
                           INT8_C(  84), INT8_C( 124), INT8_C(  92), INT8_C(  36)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_add_epi8(test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_mask_add_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i src;
    simde__mmask64 k;
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C(  92), INT8_C( 116), INT8_C( -78), INT8_C( -19),
                           INT8_C( -73), INT8_C(  22), INT8_C( -66), INT8_C( -29),
                           INT8_C(  55), INT8_C(  78), INT8_C( -45), INT8_C(-119),
                           INT8_C(  30), INT8_C( -29), INT8_C( -23), INT8_C(  89),
                           INT8_C(  15), INT8_C( 119), INT8_C( -88), INT8_C( 109),
                           INT8_C( -16), INT8_C( -10), INT8_C(   0), INT8_C( -18),
                           INT8_C(   1), INT8_C( 116), INT8_C(  62), INT8_C( -73),
                           INT8_C(-122), INT8_C(   0), INT8_C( 111), INT8_C(  95),
                           INT8_C( -20), INT8_C(   3), INT8_C( 122), INT8_C(-121),
                           INT8_C(  13), INT8_C(  25), INT8_C( -35), INT8_C(-127),
                           INT8_C(  82), INT8_C(  90), INT8_C(  53), INT8_C( 123),
                           INT8_C(  73), INT8_C( 108), INT8_C( -18), INT8_C(  15),
                           INT8_C(  81), INT8_C( -27), INT8_C( 102), INT8_C( 118),
                           INT8_C(  39), INT8_C( -77), INT8_C(  45), INT8_C(  81),
                           INT8_C( -17), INT8_C( -28), INT8_C(  67), INT8_C(-118),
                           INT8_C(  79), INT8_C(-113), INT8_C(-122), INT8_C( 124)),
      UINT64_C(10224647434006242820),
      simde_mm512_set_epi8(INT8_C(  68), INT8_C(-108), INT8_C(-121), INT8_C(-115),
                           INT8_C( -59), INT8_C( -78), INT8_C(-111), INT8_C(  56),
                           INT8_C(   9), INT8_C(-121), INT8_C( 120), INT8_C( -36),
                           INT8_C(  36), INT8_C(-103), INT8_C(-104), INT8_C(  25),
                           INT8_C(-111), INT8_C( -63), INT8_C( -35), INT8_C(-120),
                           INT8_C(  28), INT8_C( -44), INT8_C( -26), INT8_C( -86),
                           INT8_C( -13), INT8_C(  53), INT8_C( -88), INT8_C(-107),
                           INT8_C(  68), INT8_C(  42), INT8_C(-118), INT8_C( 111),
                           INT8_C(  54), INT8_C( -58), INT8_C( -13), INT8_C(  27),
                           INT8_C(  23), INT8_C(  41), INT8_C(-119), INT8_C(  44),
                           INT8_C(   7), INT8_C(-120), INT8_C(  32), INT8_C( -43),
                           INT8_C( 114), INT8_C( -72), INT8_C(  73), INT8_C( -96),
                           INT8_C(  96), INT8_C( 110), INT8_C( -81), INT8_C( -76),
                           INT8_C( 103), INT8_C(-100), INT8_C( -22), INT8_C(  18),
                           INT8_C( 115), INT8_C(  54), INT8_C( -40), INT8_C( 125),
                           INT8_C( 110), INT8_C(  31), INT8_C(  51), INT8_C(-104)),
      simde_mm512_set_epi8(INT8_C( -14), INT8_C(  85), INT8_C( -80), INT8_C(  80),
                           INT8_C(  48), INT8_C(  93), INT8_C(  79), INT8_C( 127),
                           INT8_C(  16), INT8_C(  41), INT8_C(  54), INT8_C(-116),
                           INT8_C(  17), INT8_C(  42), INT8_C( -86), INT8_C(  38),
                           INT8_C(-118), INT8_C( -56), INT8_C(  60), INT8_C(  19),
                           INT8_C(-100), INT8_C(-107), INT8_C( 105), INT8_C( -76),
                           INT8_C(  10), INT8_C(  -9), INT8_C( -12), INT8_C( -56),
                           INT8_C( -71), INT8_C(  96), INT8_C(   6), INT8_C(  24),
                           INT8_C(  69), INT8_C(  73), INT8_C( -27), INT8_C(   3),
                           INT8_C( -95), INT8_C(  50), INT8_C( -67), INT8_C( -39),
                           INT8_C(  97), INT8_C(  62), INT8_C( 101), INT8_C(  56),
                           INT8_C( -79), INT8_C(  83), INT8_C( -99), INT8_C( -56),
                           INT8_C( -17), INT8_C( -56), INT8_C(  -8), INT8_C( -16),
                           INT8_C(  84), INT8_C( -95), INT8_C( -73), INT8_C(  54),
                           INT8_C( 125), INT8_C(  85), INT8_C(  78), INT8_C( -65),
                           INT8_C(   4), INT8_C( 113), INT8_C( -16), INT8_C( -53)),
      simde_mm512_set_epi8(INT8_C(  54), INT8_C( 116), INT8_C( -78), INT8_C( -19),
                           INT8_C( -11), INT8_C(  15), INT8_C( -66), INT8_C( -73),
                           INT8_C(  25), INT8_C( -80), INT8_C( -82), INT8_C(-119),
                           INT8_C(  30), INT8_C( -61), INT8_C( -23), INT8_C(  63),
                           INT8_C(  15), INT8_C( 119), INT8_C(  25), INT8_C(-101),
                           INT8_C( -72), INT8_C( 105), INT8_C(  79), INT8_C( -18),
                           INT8_C(  -3), INT8_C( 116), INT8_C(-100), INT8_C( -73),
                           INT8_C(  -3), INT8_C(   0), INT8_C(-112), INT8_C(-121),
                           INT8_C( -20), INT8_C(   3), INT8_C( -40), INT8_C(  30),
                           INT8_C(  13), INT8_C(  25), INT8_C( -35), INT8_C(   5),
                           INT8_C( 104), INT8_C(  90), INT8_C(  53), INT8_C( 123),
                           INT8_C(  35), INT8_C(  11), INT8_C( -18), INT8_C( 104),
                           INT8_C(  81), INT8_C( -27), INT8_C( -89), INT8_C( 118),
                           INT8_C(  39), INT8_C(  61), INT8_C( -95), INT8_C(  81),
                           INT8_C( -17), INT8_C( -28), INT8_C(  67), INT8_C(-118),
                           INT8_C(  79), INT8_C(-112), INT8_C(-122), INT8_C( 124)) },
    { simde_mm512_set_epi8(INT8_C(-123), INT8_C(-100), INT8_C( -39), INT8_C( -44),
                           INT8_C(  22), INT8_C( 112), INT8_C(  16), INT8_C(  15),
                           INT8_C(-104), INT8_C(-102), INT8_C( 102), INT8_C( -95),
                           INT8_C(  69), INT8_C(  13), INT8_C( -21), INT8_C(  45),
                           INT8_C(  62), INT8_C(-120), INT8_C(-111), INT8_C(  32),
                           INT8_C(-107), INT8_C( -30), INT8_C(  99), INT8_C( -64),
                           INT8_C(   8), INT8_C( -42), INT8_C(  81), INT8_C( -34),
                           INT8_C( -46), INT8_C(  26), INT8_C(  31), INT8_C(  -2),
                           INT8_C(  68), INT8_C(  -7), INT8_C( -71), INT8_C(  46),
                           INT8_C( -21), INT8_C( -73), INT8_C(  21), INT8_C(  83),
                           INT8_C(-108), INT8_C( -97), INT8_C( -69), INT8_C(  73),
                           INT8_C(  57), INT8_C( -37), INT8_C(  21), INT8_C(  82),
                           INT8_C(-119), INT8_C(-126), INT8_C( 126), INT8_C(  91),
                           INT8_C( 115), INT8_C(  31), INT8_C( -79), INT8_C(  28),
                           INT8_C(-106), INT8_C( -18), INT8_C(  65), INT8_C(-104),
                           INT8_C(  81), INT8_C(  38), INT8_C( -84), INT8_C(  -2)),
      UINT64_C( 4597426592773770833),
      simde_mm512_set_epi8(INT8_C(  74), INT8_C(  72), INT8_C(  -4), INT8_C(  28),
                           INT8_C(-115), INT8_C(  93), INT8_C( 102), INT8_C(  44),
                           INT8_C(-103), INT8_C( -29), INT8_C( -50), INT8_C(  48),
                           INT8_C( -96), INT8_C( -50), INT8_C(  46), INT8_C( -65),
                           INT8_C(   4), INT8_C(  43), INT8_C( -75), INT8_C(  97),
                           INT8_C( -26), INT8_C(-103), INT8_C(  71), INT8_C(-107),
                           INT8_C(  91), INT8_C(  45), INT8_C( -11), INT8_C(  47),
                           INT8_C(  29), INT8_C(  25), INT8_C(  26), INT8_C(  -9),
                           INT8_C(  10), INT8_C(  36), INT8_C( -79), INT8_C( -53),
                           INT8_C(  41), INT8_C(   1), INT8_C( -23), INT8_C( -63),
                           INT8_C(-127), INT8_C(  68), INT8_C(  48), INT8_C(  36),
                           INT8_C(  89), INT8_C(-112), INT8_C( -31), INT8_C( 120),
                           INT8_C(  35), INT8_C(  62), INT8_C( -21), INT8_C(-114),
                           INT8_C(-104), INT8_C(  57), INT8_C(  42), INT8_C(-111),
                           INT8_C(  94), INT8_C( -63), INT8_C(  -9), INT8_C(  64),
                           INT8_C( -65), INT8_C(  -2), INT8_C( 110), INT8_C(  -8)),
      simde_mm512_set_epi8(INT8_C(  44), INT8_C( -92), INT8_C( -31), INT8_C(  26),
                           INT8_C( -99), INT8_C( -53), INT8_C( 117), INT8_C(  18),
                           INT8_C( -63), INT8_C(  45), INT8_C(  12), INT8_C(  24),
                           INT8_C(-108), INT8_C(  18), INT8_C( -60), INT8_C(  28),
                           INT8_C(  50), INT8_C( -11), INT8_C( -68), INT8_C( -31),
                           INT8_C( 105), INT8_C(-106), INT8_C(  98), INT8_C(  51),
                           INT8_C(  58), INT8_C( 103), INT8_C( 111), INT8_C(-127),
                           INT8_C(  68), INT8_C( -56), INT8_C( 124), INT8_C(-119),
                           INT8_C(  74), INT8_C( -62), INT8_C(-116), INT8_C(  37),
                           INT8_C( -12), INT8_C( 114), INT8_C(   0), INT8_C(  61),
                           INT8_C( 103), INT8_C(  -4), INT8_C(-105), INT8_C( -68),
                           INT8_C(  39), INT8_C(-100), INT8_C( -93), INT8_C(  11),
                           INT8_C( -80), INT8_C( -19), INT8_C( -22), INT8_C( -39),
                           INT8_C( 127), INT8_C( -38), INT8_C(-125), INT8_C(-111),
                           INT8_C(  84), INT8_C( -96), INT8_C(  87), INT8_C( -22),
                           INT8_C(  -5), INT8_C(  -3), INT8_C(-127), INT8_C(  41)),
      simde_mm512_set_epi8(INT8_C(-123), INT8_C(-100), INT8_C( -35), INT8_C(  54),
                           INT8_C(  42), INT8_C(  40), INT8_C( -37), INT8_C(  62),
                           INT8_C(  90), INT8_C(  16), INT8_C( 102), INT8_C( -95),
                           INT8_C(  52), INT8_C( -32), INT8_C( -21), INT8_C( -37),
                           INT8_C(  62), INT8_C(  32), INT8_C(-111), INT8_C(  66),
                           INT8_C(-107), INT8_C(  47), INT8_C( -87), INT8_C( -56),
                           INT8_C(   8), INT8_C( -42), INT8_C( 100), INT8_C( -34),
                           INT8_C( -46), INT8_C(  26), INT8_C(  31), INT8_C(  -2),
                           INT8_C(  84), INT8_C(  -7), INT8_C(  61), INT8_C( -16),
                           INT8_C(  29), INT8_C( 115), INT8_C( -23), INT8_C(  -2),
                           INT8_C(-108), INT8_C( -97), INT8_C( -57), INT8_C( -32),
                           INT8_C(  57), INT8_C(  44), INT8_C(-124), INT8_C(-125),
                           INT8_C(-119), INT8_C(-126), INT8_C( 126), INT8_C(  91),
                           INT8_C(  23), INT8_C(  19), INT8_C( -83), INT8_C(  28),
                           INT8_C(-106), INT8_C(  97), INT8_C(  65), INT8_C(  42),
                           INT8_C(  81), INT8_C(  38), INT8_C( -84), INT8_C(  33)) },
    { simde_mm512_set_epi8(INT8_C( -30), INT8_C( -37), INT8_C(  51), INT8_C( -36),
                           INT8_C(   8), INT8_C(  52), INT8_C(  97), INT8_C( 123),
                           INT8_C( -49), INT8_C(-124), INT8_C(  95), INT8_C( -83),
                           INT8_C(  70), INT8_C( -50), INT8_C( -61), INT8_C(  25),
                           INT8_C( -97), INT8_C(  28), INT8_C( -58), INT8_C(  11),
                           INT8_C( -14), INT8_C( 126), INT8_C(  81), INT8_C(  45),
                           INT8_C( -23), INT8_C( 120), INT8_C( -83), INT8_C( -16),
                           INT8_C(   7), INT8_C(  51), INT8_C( -57), INT8_C( -50),
                           INT8_C( -21), INT8_C(  98), INT8_C(  88), INT8_C(   0),
                           INT8_C( -66), INT8_C(   3), INT8_C( 124), INT8_C(-113),
                           INT8_C(  50), INT8_C(  88), INT8_C( -85), INT8_C( -93),
                           INT8_C( -44), INT8_C( -13), INT8_C( -94), INT8_C(  17),
                           INT8_C(  -2), INT8_C(  79), INT8_C(-116), INT8_C(  43),
                           INT8_C( -77), INT8_C(-125), INT8_C( -23), INT8_C(-120),
                           INT8_C(  96), INT8_C( -64), INT8_C( -23), INT8_C( -46),
                           INT8_C( -29), INT8_C( -71), INT8_C(  71), INT8_C(  90)),
      UINT64_C(12627002542648829104),
      simde_mm512_set_epi8(INT8_C(  56), INT8_C( -45), INT8_C(-108), INT8_C( -19),
                           INT8_C(-124), INT8_C( -27), INT8_C(  22), INT8_C( 126),
                           INT8_C(-106), INT8_C( -68), INT8_C( -60), INT8_C(   8),
                           INT8_C(  60), INT8_C(  93), INT8_C( -33), INT8_C( -27),
                           INT8_C(  -7), INT8_C(  27), INT8_C(-122), INT8_C( -38),
                           INT8_C(  23), INT8_C(   6), INT8_C(  45), INT8_C( -21),
                           INT8_C( -23), INT8_C(-101), INT8_C( 116), INT8_C( 127),
                           INT8_C(  96), INT8_C(  40), INT8_C( -97), INT8_C(  40),
                           INT8_C(  86), INT8_C( -44), INT8_C(  70), INT8_C( -71),
                           INT8_C(  62), INT8_C( -21), INT8_C(  66), INT8_C(  68),
                           INT8_C( -87), INT8_C( -61), INT8_C(  48), INT8_C( -70),
                           INT8_C(  18), INT8_C( -78), INT8_C( -98), INT8_C( 117),
                           INT8_C(  74), INT8_C(  32), INT8_C(  93), INT8_C( 125),
                           INT8_C( -47), INT8_C( -60), INT8_C( -86), INT8_C( 117),
                           INT8_C( 122), INT8_C( -54), INT8_C(  50), INT8_C( 123),
                           INT8_C( -31), INT8_C( -74), INT8_C( -64), INT8_C(  54)),
      simde_mm512_set_epi8(INT8_C( 115), INT8_C(  51), INT8_C( -91), INT8_C(  56),
                           INT8_C(  64), INT8_C( -39), INT8_C(-119), INT8_C( -28),
                           INT8_C( -54), INT8_C(  28), INT8_C(  54), INT8_C(  -8),
                           INT8_C( -54), INT8_C(-128), INT8_C( -28), INT8_C( -71),
                           INT8_C( 107), INT8_C( -66), INT8_C(-114), INT8_C( -88),
                           INT8_C(  34), INT8_C( -83), INT8_C( -21), INT8_C( -64),
                           INT8_C( 121), INT8_C( -20), INT8_C( -89), INT8_C( -94),
                           INT8_C( 112), INT8_C( -27), INT8_C(  81), INT8_C( -54),
                           INT8_C( -64), INT8_C(-114), INT8_C(  48), INT8_C( -89),
                           INT8_C( -61), INT8_C(  26), INT8_C(  43), INT8_C(  29),
                           INT8_C(   0), INT8_C(  64), INT8_C( 123), INT8_C( -67),
                           INT8_C(  15), INT8_C( 120), INT8_C(  36), INT8_C(  40),
                           INT8_C( 106), INT8_C(-118), INT8_C(-108), INT8_C( -58),
                           INT8_C(  26), INT8_C(-111), INT8_C(  63), INT8_C( -98),
                           INT8_C( -13), INT8_C( -12), INT8_C(-124), INT8_C(  96),
                           INT8_C( -13), INT8_C( -98), INT8_C(  99), INT8_C( -13)),
      simde_mm512_set_epi8(INT8_C( -85), INT8_C( -37), INT8_C(  57), INT8_C( -36),
                           INT8_C( -60), INT8_C( -66), INT8_C( -97), INT8_C(  98),
                           INT8_C( -49), INT8_C(-124), INT8_C(  -6), INT8_C(   0),
                           INT8_C(   6), INT8_C( -35), INT8_C( -61), INT8_C(  25),
                           INT8_C( -97), INT8_C(  28), INT8_C( -58), INT8_C(-126),
                           INT8_C(  57), INT8_C( -77), INT8_C(  24), INT8_C( -85),
                           INT8_C(  98), INT8_C(-121), INT8_C(  27), INT8_C( -16),
                           INT8_C( -48), INT8_C(  51), INT8_C( -57), INT8_C( -14),
                           INT8_C( -21), INT8_C(  98), INT8_C( 118), INT8_C(   0),
                           INT8_C(   1), INT8_C(   5), INT8_C( 124), INT8_C(-113),
                           INT8_C( -87), INT8_C(  88), INT8_C( -85), INT8_C( -93),
                           INT8_C(  33), INT8_C( -13), INT8_C( -94), INT8_C( -99),
                           INT8_C( -76), INT8_C(  79), INT8_C( -15), INT8_C(  43),
                           INT8_C( -77), INT8_C(  85), INT8_C( -23), INT8_C(-120),
                           INT8_C( 109), INT8_C( -64), INT8_C( -74), INT8_C( -37),
                           INT8_C( -29), INT8_C( -71), INT8_C(  71), INT8_C(  90)) },
    { simde_mm512_set_epi8(INT8_C(  72), INT8_C(  45), INT8_C( 120), INT8_C(  -5),
                           INT8_C(-109), INT8_C(  62), INT8_C(  17), INT8_C(  31),
                           INT8_C( -30), INT8_C( -58), INT8_C(  56), INT8_C(  21),
                           INT8_C(  72), INT8_C( -74), INT8_C( -40), INT8_C( 120),
                           INT8_C(  95), INT8_C( 108), INT8_C(  32), INT8_C(  64),
                           INT8_C(-128), INT8_C( 102), INT8_C( -21), INT8_C(  28),
                           INT8_C( 105), INT8_C(  52), INT8_C(  85), INT8_C(-104),
                           INT8_C(  57), INT8_C( -31), INT8_C( -38), INT8_C(-124),
                           INT8_C(-107), INT8_C(  -2), INT8_C(  55), INT8_C(  46),
                           INT8_C( -71), INT8_C(  77), INT8_C(  18), INT8_C(  70),
                           INT8_C(  89), INT8_C( 125), INT8_C( -42), INT8_C(-125),
                           INT8_C( 121), INT8_C( -11), INT8_C( -69), INT8_C( -59),
                           INT8_C( -53), INT8_C(  34), INT8_C(   9), INT8_C(  64),
                           INT8_C( -61), INT8_C( -25), INT8_C(-115), INT8_C( 100),
                           INT8_C(  65), INT8_C(   8), INT8_C(  69), INT8_C(  -8),
                           INT8_C( -15), INT8_C( -51), INT8_C(   1), INT8_C(  90)),
      UINT64_C(14515151237088493607),
      simde_mm512_set_epi8(INT8_C( -26), INT8_C(  -9), INT8_C(  66), INT8_C(   1),
                           INT8_C( -13), INT8_C(  60), INT8_C(-119), INT8_C( -83),
                           INT8_C(-122), INT8_C( -64), INT8_C( -83), INT8_C( -74),
                           INT8_C( 119), INT8_C(  -8), INT8_C(  12), INT8_C( 113),
                           INT8_C( -12), INT8_C( -84), INT8_C(   6), INT8_C(  69),
                           INT8_C(   2), INT8_C( -75), INT8_C( -34), INT8_C(-126),
                           INT8_C(   3), INT8_C(-128), INT8_C(  -9), INT8_C(  24),
                           INT8_C(  11), INT8_C( -94), INT8_C( -32), INT8_C( 110),
                           INT8_C(  33), INT8_C( -24), INT8_C( 125), INT8_C(  35),
                           INT8_C(-103), INT8_C( -48), INT8_C( -22), INT8_C(  38),
                           INT8_C( -81), INT8_C(   9), INT8_C( -11), INT8_C(-124),
                           INT8_C(  71), INT8_C(  31), INT8_C( -42), INT8_C(  93),
                           INT8_C(  67), INT8_C(  45), INT8_C(  51), INT8_C( -92),
                           INT8_C( 126), INT8_C( 108), INT8_C(-123), INT8_C( -71),
                           INT8_C( 113), INT8_C(  32), INT8_C(  71), INT8_C(  55),
                           INT8_C( -26), INT8_C(  82), INT8_C( -81), INT8_C( -20)),
      simde_mm512_set_epi8(INT8_C(-125), INT8_C( 121), INT8_C(-128), INT8_C( 103),
                           INT8_C(   0), INT8_C( 101), INT8_C( -41), INT8_C(  89),
                           INT8_C( -83), INT8_C( -65), INT8_C(   9), INT8_C(  -7),
                           INT8_C( -63), INT8_C(  13), INT8_C( 105), INT8_C(  92),
                           INT8_C( -18), INT8_C( -21), INT8_C(-102), INT8_C(-114),
                           INT8_C(  74), INT8_C( 121), INT8_C( -45), INT8_C(  52),
                           INT8_C( -63), INT8_C( -93), INT8_C(  98), INT8_C( 106),
                           INT8_C(-109), INT8_C( -47), INT8_C(  37), INT8_C(  70),
                           INT8_C( 100), INT8_C( 121), INT8_C(  18), INT8_C(  28),
                           INT8_C(-117), INT8_C( 107), INT8_C(   3), INT8_C( -62),
                           INT8_C(  42), INT8_C(  72), INT8_C(  91), INT8_C(  86),
                           INT8_C( -72), INT8_C(   9), INT8_C( -80), INT8_C( 118),
                           INT8_C( 122), INT8_C(-108), INT8_C( -70), INT8_C( -63),
                           INT8_C(  56), INT8_C(  71), INT8_C( -14), INT8_C(  49),
                           INT8_C( -73), INT8_C(  53), INT8_C( -29), INT8_C(   3),
                           INT8_C( -73), INT8_C(  43), INT8_C( -22), INT8_C(  85)),
      simde_mm512_set_epi8(INT8_C( 105), INT8_C( 112), INT8_C( 120), INT8_C(  -5),
                           INT8_C( -13), INT8_C(  62), INT8_C(  17), INT8_C(   6),
                           INT8_C( -30), INT8_C( 127), INT8_C( -74), INT8_C( -81),
                           INT8_C(  72), INT8_C( -74), INT8_C( -40), INT8_C( 120),
                           INT8_C(  95), INT8_C( 108), INT8_C( -96), INT8_C(  64),
                           INT8_C(  76), INT8_C(  46), INT8_C( -21), INT8_C( -74),
                           INT8_C( 105), INT8_C(  52), INT8_C(  89), INT8_C(-104),
                           INT8_C(  57), INT8_C( 115), INT8_C( -38), INT8_C( -76),
                           INT8_C(-107), INT8_C(  97), INT8_C(  55), INT8_C(  46),
                           INT8_C( -71), INT8_C(  77), INT8_C( -19), INT8_C( -24),
                           INT8_C( -39), INT8_C( 125), INT8_C(  80), INT8_C( -38),
                           INT8_C(  -1), INT8_C( -11), INT8_C(-122), INT8_C( -45),
                           INT8_C( -53), INT8_C( -63), INT8_C(   9), INT8_C(  64),
                           INT8_C( -61), INT8_C( -25), INT8_C(-115), INT8_C( 100),
                           INT8_C(  65), INT8_C(   8), INT8_C(  42), INT8_C(  -8),
                           INT8_C( -15), INT8_C( 125), INT8_C(-103), INT8_C(  65)) },
    { simde_mm512_set_epi8(INT8_C( -47), INT8_C(  84), INT8_C(-126), INT8_C( -64),
                           INT8_C(  14), INT8_C(  11), INT8_C(  37), INT8_C( -23),
                           INT8_C(  67), INT8_C( 124), INT8_C(  58), INT8_C( -94),
                           INT8_C(  30), INT8_C( -33), INT8_C(  70), INT8_C( -24),
                           INT8_C(  38), INT8_C( -97), INT8_C( -56), INT8_C( -60),
                           INT8_C( -59), INT8_C(  65), INT8_C( -74), INT8_C(  45),
                           INT8_C( -11), INT8_C(  55), INT8_C( -82), INT8_C(  12),
                           INT8_C( 106), INT8_C(  22), INT8_C(-124), INT8_C(  -4),
                           INT8_C(   2), INT8_C( -81), INT8_C(  14), INT8_C(  90),
                           INT8_C(-100), INT8_C(-122), INT8_C( -35), INT8_C(  81),
                           INT8_C( -14), INT8_C( -42), INT8_C( 125), INT8_C(-125),
                           INT8_C( -57), INT8_C(  90), INT8_C(  -9), INT8_C(  63),
                           INT8_C(  53), INT8_C(  77), INT8_C(  63), INT8_C( -84),
                           INT8_C(  27), INT8_C(  22), INT8_C(   3), INT8_C( -37),
                           INT8_C(  65), INT8_C( 118), INT8_C(-126), INT8_C(  97),
                           INT8_C( 109), INT8_C(   7), INT8_C(-114), INT8_C( -75)),
      UINT64_C( 8707623543556880126),
      simde_mm512_set_epi8(INT8_C(  84), INT8_C( -71), INT8_C(   8), INT8_C(  12),
                           INT8_C( -11), INT8_C( -76), INT8_C(  62), INT8_C(  93),
                           INT8_C( -75), INT8_C( -77), INT8_C( -84), INT8_C(-108),
                           INT8_C( -35), INT8_C(  14), INT8_C( -60), INT8_C(  18),
                           INT8_C(  23), INT8_C( -60), INT8_C( -63), INT8_C(-114),
                           INT8_C( -55), INT8_C(  75), INT8_C( -99), INT8_C( -55),
                           INT8_C(  58), INT8_C(  76), INT8_C(-102), INT8_C(-118),
                           INT8_C( -30), INT8_C(  39), INT8_C( 119), INT8_C(  85),
                           INT8_C(  -8), INT8_C( -72), INT8_C( -60), INT8_C( -94),
                           INT8_C(-112), INT8_C( 119), INT8_C( 124), INT8_C(  76),
                           INT8_C( -42), INT8_C(-124), INT8_C(  54), INT8_C(  74),
                           INT8_C( -92), INT8_C(  99), INT8_C(  79), INT8_C(  -3),
                           INT8_C(  61), INT8_C( -89), INT8_C(  84), INT8_C( -94),
                           INT8_C(  31), INT8_C(-116), INT8_C( -67), INT8_C(-102),
                           INT8_C( -72), INT8_C( -91), INT8_C(-105), INT8_C(-108),
                           INT8_C( -44), INT8_C(  74), INT8_C( -28), INT8_C( 124)),
      simde_mm512_set_epi8(INT8_C(   1), INT8_C(  75), INT8_C(  21), INT8_C( -36),
                           INT8_C(-126), INT8_C( 122), INT8_C(  71), INT8_C(  76),
                           INT8_C(  28), INT8_C( -56), INT8_C(  32), INT8_C( 101),
                           INT8_C(-107), INT8_C(-111), INT8_C( -88), INT8_C( -19),
                           INT8_C( -77), INT8_C(  19), INT8_C( -21), INT8_C(-111),
                           INT8_C( -68), INT8_C(  82), INT8_C(-118), INT8_C( -76),
                           INT8_C(  47), INT8_C( 127), INT8_C(  62), INT8_C( -16),
                           INT8_C(  10), INT8_C( -14), INT8_C(-100), INT8_C(  86),
                           INT8_C(  29), INT8_C( 107), INT8_C(  56), INT8_C(  21),
                           INT8_C(  24), INT8_C(  68), INT8_C( -96), INT8_C(  64),
                           INT8_C(  48), INT8_C(  13), INT8_C( -83), INT8_C(   4),
                           INT8_C(  -3), INT8_C( -64), INT8_C(  17), INT8_C(-115),
                           INT8_C(  21), INT8_C( 108), INT8_C( 125), INT8_C( -60),
                           INT8_C( -72), INT8_C(  74), INT8_C(  -5), INT8_C( -58),
                           INT8_C( -41), INT8_C(  22), INT8_C(-115), INT8_C( 102),
                           INT8_C(  59), INT8_C( -80), INT8_C( -15), INT8_C( -63)),
      simde_mm512_set_epi8(INT8_C( -47), INT8_C(   4), INT8_C(  29), INT8_C( -24),
                           INT8_C( 119), INT8_C(  11), INT8_C(  37), INT8_C( -23),
                           INT8_C( -47), INT8_C( 123), INT8_C(  58), INT8_C(  -7),
                           INT8_C(  30), INT8_C( -97), INT8_C( 108), INT8_C(  -1),
                           INT8_C( -54), INT8_C( -97), INT8_C( -84), INT8_C(  31),
                           INT8_C( -59), INT8_C(  65), INT8_C( -74), INT8_C( 125),
                           INT8_C( -11), INT8_C( -53), INT8_C( -40), INT8_C( 122),
                           INT8_C( -20), INT8_C(  22), INT8_C(  19), INT8_C(  -4),
                           INT8_C(   2), INT8_C(  35), INT8_C(  14), INT8_C( -73),
                           INT8_C(-100), INT8_C( -69), INT8_C(  28), INT8_C(-116),
                           INT8_C(   6), INT8_C( -42), INT8_C( 125), INT8_C(-125),
                           INT8_C( -95), INT8_C(  90), INT8_C(  -9), INT8_C(-118),
                           INT8_C(  53), INT8_C(  77), INT8_C( -47), INT8_C( 102),
                           INT8_C(  27), INT8_C( -42), INT8_C( -72), INT8_C( -37),
                           INT8_C(-113), INT8_C( -69), INT8_C(  36), INT8_C(  -6),
                           INT8_C(  15), INT8_C(  -6), INT8_C( -43), INT8_C( -75)) },
    { simde_mm512_set_epi8(INT8_C( -64), INT8_C( -53), INT8_C( -42), INT8_C( 126),
                           INT8_C(  67), INT8_C(  50), INT8_C( -18), INT8_C(  76),
                           INT8_C( -19), INT8_C( 123), INT8_C( -87), INT8_C( 106),
                           INT8_C( -74), INT8_C(  44), INT8_C( 117), INT8_C( 103),
                           INT8_C(  81), INT8_C( 122), INT8_C(  56), INT8_C( -10),
                           INT8_C(  67), INT8_C(  79), INT8_C(  83), INT8_C( -38),
                           INT8_C( -13), INT8_C(  43), INT8_C(  27), INT8_C( -97),
                           INT8_C( 102), INT8_C( 126), INT8_C(  38), INT8_C( -62),
                           INT8_C( -24), INT8_C( 117), INT8_C( -38), INT8_C( -93),
                           INT8_C( -58), INT8_C(-124), INT8_C( -75), INT8_C(  10),
                           INT8_C(  18), INT8_C( -74), INT8_C(  14), INT8_C(  36),
                           INT8_C(  -7), INT8_C( 113), INT8_C(  40), INT8_C(  48),
                           INT8_C(-107), INT8_C( -34), INT8_C( -75), INT8_C(  85),
                           INT8_C( -35), INT8_C(-116), INT8_C(  65), INT8_C( -21),
                           INT8_C(  15), INT8_C(   3), INT8_C(  45), INT8_C(  21),
                           INT8_C(  72), INT8_C(  93), INT8_C( 108), INT8_C( 125)),
      UINT64_C(12576710173448868104),
      simde_mm512_set_epi8(INT8_C(  90), INT8_C( -38), INT8_C( -98), INT8_C( -70),
                           INT8_C(-108), INT8_C(  20), INT8_C(  43), INT8_C(-128),
                           INT8_C(  77), INT8_C( 108), INT8_C(  53), INT8_C(  82),
                           INT8_C( -50), INT8_C(  52), INT8_C(  56), INT8_C(  58),
                           INT8_C(-120), INT8_C( -43), INT8_C( 114), INT8_C(  93),
                           INT8_C( -44), INT8_C( -15), INT8_C(  38), INT8_C( -17),
                           INT8_C(-110), INT8_C(-123), INT8_C( -39), INT8_C( 114),
                           INT8_C(  51), INT8_C(-115), INT8_C( -74), INT8_C(  43),
                           INT8_C(  41), INT8_C( -36), INT8_C(  19), INT8_C(  69),
                           INT8_C(  60), INT8_C( -53), INT8_C( 112), INT8_C( 108),
                           INT8_C(   8), INT8_C(  46), INT8_C( -35), INT8_C(  26),
                           INT8_C(  11), INT8_C(  42), INT8_C(  47), INT8_C(  59),
                           INT8_C( -57), INT8_C(  94), INT8_C(-125), INT8_C(-124),
                           INT8_C(  36), INT8_C(  57), INT8_C(  68), INT8_C( -52),
                           INT8_C(  39), INT8_C(  50), INT8_C( -48), INT8_C(  94),
                           INT8_C(  53), INT8_C(  11), INT8_C(  29), INT8_C(  65)),
      simde_mm512_set_epi8(INT8_C(-107), INT8_C( 120), INT8_C( -58), INT8_C( 107),
                           INT8_C( -32), INT8_C( -32), INT8_C(  88), INT8_C( -43),
                           INT8_C(  31), INT8_C( -32), INT8_C( -64), INT8_C(  27),
                           INT8_C(  82), INT8_C( -90), INT8_C( -54), INT8_C( -84),
                           INT8_C( -30), INT8_C(  63), INT8_C(  24), INT8_C(  81),
                           INT8_C(  -8), INT8_C(   9), INT8_C( -35), INT8_C(-101),
                           INT8_C(  83), INT8_C( 107), INT8_C( -47), INT8_C( -56),
                           INT8_C(  57), INT8_C( -88), INT8_C(-115), INT8_C( -20),
                           INT8_C(  58), INT8_C(  75), INT8_C(  56), INT8_C(  93),
                           INT8_C(  49), INT8_C(  43), INT8_C( 108), INT8_C( 118),
                           INT8_C( -79), INT8_C( 112), INT8_C(  44), INT8_C(-112),
                           INT8_C( -52), INT8_C(  10), INT8_C(  28), INT8_C( -86),
                           INT8_C(  65), INT8_C(  62), INT8_C(  86), INT8_C(-107),
                           INT8_C(  24), INT8_C( -55), INT8_C(  54), INT8_C(-110),
                           INT8_C( -33), INT8_C( 110), INT8_C(-116), INT8_C( -39),
                           INT8_C(  39), INT8_C(-112), INT8_C(  64), INT8_C(  43)),
      simde_mm512_set_epi8(INT8_C( -17), INT8_C( -53), INT8_C( 100), INT8_C( 126),
                           INT8_C( 116), INT8_C( -12), INT8_C(-125), INT8_C(  76),
                           INT8_C( 108), INT8_C( 123), INT8_C( -87), INT8_C( 106),
                           INT8_C(  32), INT8_C(  44), INT8_C( 117), INT8_C( -26),
                           INT8_C(  81), INT8_C(  20), INT8_C(-118), INT8_C( -82),
                           INT8_C(  67), INT8_C(  79), INT8_C(   3), INT8_C(-118),
                           INT8_C( -13), INT8_C( -16), INT8_C(  27), INT8_C( -97),
                           INT8_C( 102), INT8_C(  53), INT8_C(  38), INT8_C( -62),
                           INT8_C(  99), INT8_C( 117), INT8_C(  75), INT8_C( -94),
                           INT8_C( 109), INT8_C(-124), INT8_C( -36), INT8_C( -30),
                           INT8_C(  18), INT8_C( -98), INT8_C(   9), INT8_C( -86),
                           INT8_C(  -7), INT8_C(  52), INT8_C(  75), INT8_C(  48),
                           INT8_C(-107), INT8_C( -34), INT8_C( -75), INT8_C(  25),
                           INT8_C( -35), INT8_C(-116), INT8_C(  65), INT8_C(  94),
                           INT8_C(  15), INT8_C(   3), INT8_C(  45), INT8_C(  21),
                           INT8_C(  92), INT8_C(  93), INT8_C( 108), INT8_C( 125)) },
    { simde_mm512_set_epi8(INT8_C(-103), INT8_C(-124), INT8_C(  13), INT8_C( -80),
                           INT8_C( -32), INT8_C( 123), INT8_C( 115), INT8_C( -49),
                           INT8_C( 113), INT8_C( -51), INT8_C( 119), INT8_C( -67),
                           INT8_C( -21), INT8_C(  19), INT8_C( -12), INT8_C(  29),
                           INT8_C(  91), INT8_C( -64), INT8_C(  88), INT8_C(-105),
                           INT8_C(  24), INT8_C(  31), INT8_C(  77), INT8_C(  92),
                           INT8_C( -85), INT8_C(  48), INT8_C(-113), INT8_C(-114),
                           INT8_C(  16), INT8_C(  18), INT8_C( -44), INT8_C( -66),
                           INT8_C(  25), INT8_C(-105), INT8_C(-100), INT8_C( -91),
                           INT8_C(  26), INT8_C(-123), INT8_C( -33), INT8_C( -37),
                           INT8_C(  63), INT8_C(  13), INT8_C(-124), INT8_C(  41),
                           INT8_C(-104), INT8_C( -59), INT8_C(  -2), INT8_C( -54),
                           INT8_C(  73), INT8_C(   3), INT8_C( -18), INT8_C(  10),
                           INT8_C(  19), INT8_C(  58), INT8_C( -12), INT8_C( -75),
                           INT8_C( -88), INT8_C(  59), INT8_C( 104), INT8_C( -40),
                           INT8_C( -82), INT8_C(  42), INT8_C( -73), INT8_C( -94)),
      UINT64_C( 2633789449456316803),
      simde_mm512_set_epi8(INT8_C( 118), INT8_C(  44), INT8_C( -14), INT8_C(  84),
                           INT8_C( -69), INT8_C( -48), INT8_C(  40), INT8_C(  86),
                           INT8_C(  -1), INT8_C( 121), INT8_C( -40), INT8_C(  44),
                           INT8_C(  -1), INT8_C(  38), INT8_C( -44), INT8_C(  38),
                           INT8_C(  93), INT8_C(-107), INT8_C(  -4), INT8_C( -61),
                           INT8_C( -52), INT8_C(  22), INT8_C( -54), INT8_C(-125),
                           INT8_C( -29), INT8_C(  25), INT8_C( -77), INT8_C( -68),
                           INT8_C(   9), INT8_C( -35), INT8_C( -11), INT8_C(  53),
                           INT8_C(  28), INT8_C(  61), INT8_C( -35), INT8_C(-106),
                           INT8_C( -46), INT8_C( 121), INT8_C(-102), INT8_C( 121),
                           INT8_C( -54), INT8_C( -60), INT8_C(   7), INT8_C(   2),
                           INT8_C(-119), INT8_C( 111), INT8_C( -20), INT8_C( -58),
                           INT8_C( -98), INT8_C(  83), INT8_C(  32), INT8_C( -49),
                           INT8_C( -11), INT8_C(  48), INT8_C(  92), INT8_C(  47),
                           INT8_C( -38), INT8_C(  11), INT8_C(  26), INT8_C(  90),
                           INT8_C(  -5), INT8_C(  73), INT8_C(  45), INT8_C(  -2)),
      simde_mm512_set_epi8(INT8_C( -31), INT8_C( 126), INT8_C(-118), INT8_C( -57),
                           INT8_C(-126), INT8_C(  29), INT8_C( 101), INT8_C( -15),
                           INT8_C( -61), INT8_C( 118), INT8_C( 102), INT8_C(  12),
                           INT8_C( -59), INT8_C( -41), INT8_C( -60), INT8_C(  46),
                           INT8_C(  63), INT8_C(  78), INT8_C(  87), INT8_C(  18),
                           INT8_C(  18), INT8_C(  32), INT8_C( -26), INT8_C(  -6),
                           INT8_C( -20), INT8_C(-123), INT8_C(  99), INT8_C(  65),
                           INT8_C(  13), INT8_C(  25), INT8_C( 108), INT8_C(-121),
                           INT8_C(  42), INT8_C(   0), INT8_C( 104), INT8_C( -17),
                           INT8_C( 111), INT8_C(-110), INT8_C( -39), INT8_C( 125),
                           INT8_C( -50), INT8_C( -47), INT8_C(  30), INT8_C(  92),
                           INT8_C(  19), INT8_C(  -8), INT8_C(-120), INT8_C( 127),
                           INT8_C( -49), INT8_C(  23), INT8_C(  16), INT8_C( -64),
                           INT8_C( -79), INT8_C( 116), INT8_C(  -5), INT8_C( -50),
                           INT8_C(  32), INT8_C(  22), INT8_C( -42), INT8_C(  -3),
                           INT8_C(  30), INT8_C(  64), INT8_C(  96), INT8_C( -66)),
      simde_mm512_set_epi8(INT8_C(-103), INT8_C(-124), INT8_C( 124), INT8_C( -80),
                           INT8_C( -32), INT8_C( -19), INT8_C( 115), INT8_C( -49),
                           INT8_C( -62), INT8_C( -51), INT8_C( 119), INT8_C( -67),
                           INT8_C( -60), INT8_C(  -3), INT8_C( -12), INT8_C(  84),
                           INT8_C(  91), INT8_C( -64), INT8_C(  88), INT8_C( -43),
                           INT8_C( -34), INT8_C(  31), INT8_C(  77), INT8_C( 125),
                           INT8_C( -49), INT8_C(  48), INT8_C(-113), INT8_C(-114),
                           INT8_C(  22), INT8_C( -10), INT8_C( -44), INT8_C( -66),
                           INT8_C(  70), INT8_C(  61), INT8_C(-100), INT8_C( -91),
                           INT8_C(  26), INT8_C(  11), INT8_C( -33), INT8_C( -37),
                           INT8_C(  63), INT8_C(  13), INT8_C(-124), INT8_C(  41),
                           INT8_C(-104), INT8_C( -59), INT8_C( 116), INT8_C(  69),
                           INT8_C( 109), INT8_C( 106), INT8_C(  48), INT8_C(-113),
                           INT8_C(  19), INT8_C(  58), INT8_C( -12), INT8_C(  -3),
                           INT8_C(  -6), INT8_C(  59), INT8_C( 104), INT8_C( -40),
                           INT8_C( -82), INT8_C(  42), INT8_C(-115), INT8_C( -68)) },
    { simde_mm512_set_epi8(INT8_C( 117), INT8_C(  69), INT8_C( 121), INT8_C( -45),
                           INT8_C(  30), INT8_C( -73), INT8_C(   2), INT8_C( -40),
                           INT8_C(  95), INT8_C(  -3), INT8_C(  16), INT8_C( -78),
                           INT8_C(-128), INT8_C( -41), INT8_C( -66), INT8_C(  66),
                           INT8_C(  93), INT8_C( -32), INT8_C( -50), INT8_C(  -2),
                           INT8_C( -61), INT8_C(  29), INT8_C( -88), INT8_C(-118),
                           INT8_C( -27), INT8_C(  42), INT8_C(  78), INT8_C( -46),
                           INT8_C( -79), INT8_C(  38), INT8_C( -75), INT8_C(  14),
                           INT8_C(-118), INT8_C(-114), INT8_C(-120), INT8_C(  42),
                           INT8_C(   4), INT8_C(  79), INT8_C( -84), INT8_C(-110),
                           INT8_C(   0), INT8_C(  85), INT8_C( -20), INT8_C(  61),
                           INT8_C(  40), INT8_C( -75), INT8_C(  69), INT8_C( -99),
                           INT8_C(  73), INT8_C( -34), INT8_C( -14), INT8_C(  72),
                           INT8_C( 101), INT8_C(  96), INT8_C(-114), INT8_C(-124),
                           INT8_C( -87), INT8_C(  43), INT8_C(-118), INT8_C( 114),
                           INT8_C( -88), INT8_C(   8), INT8_C( -52), INT8_C(  75)),
      UINT64_C(14890918166471265655),
      simde_mm512_set_epi8(INT8_C( -56), INT8_C( -70), INT8_C(  66), INT8_C(-111),
                           INT8_C( -69), INT8_C(  15), INT8_C( -82), INT8_C( -12),
                           INT8_C( -89), INT8_C(  37), INT8_C(  80), INT8_C( 120),
                           INT8_C( -83), INT8_C(-120), INT8_C(  95), INT8_C(  21),
                           INT8_C(  91), INT8_C( -97), INT8_C( -72), INT8_C(  42),
                           INT8_C(  22), INT8_C( -70), INT8_C(  71), INT8_C( -78),
                           INT8_C(  -5), INT8_C(  52), INT8_C( -22), INT8_C( -34),
                           INT8_C(  16), INT8_C(  92), INT8_C(  91), INT8_C( -72),
                           INT8_C(   3), INT8_C( -31), INT8_C( -95), INT8_C( -56),
                           INT8_C( -50), INT8_C(  68), INT8_C( -24), INT8_C( -50),
                           INT8_C(  94), INT8_C(  67), INT8_C( 108), INT8_C(-118),
                           INT8_C( -65), INT8_C(  31), INT8_C(  70), INT8_C( 108),
                           INT8_C( -66), INT8_C( 107), INT8_C( -85), INT8_C(  38),
                           INT8_C(   2), INT8_C(  32), INT8_C(  56), INT8_C(  66),
                           INT8_C(  -2), INT8_C( -74), INT8_C( 112), INT8_C(  10),
                           INT8_C(  64), INT8_C( 100), INT8_C( -55), INT8_C(  83)),
      simde_mm512_set_epi8(INT8_C( -69), INT8_C( -45), INT8_C(  23), INT8_C(  70),
                           INT8_C(  22), INT8_C( 113), INT8_C(  75), INT8_C(-117),
                           INT8_C(  69), INT8_C( -74), INT8_C(  40), INT8_C( -39),
                           INT8_C( -51), INT8_C( -91), INT8_C(  25), INT8_C(  -4),
                           INT8_C( -12), INT8_C( -13), INT8_C( -77), INT8_C(  75),
                           INT8_C(-116), INT8_C( -36), INT8_C(  38), INT8_C( -52),
                           INT8_C(  13), INT8_C( -52), INT8_C(-100), INT8_C( -46),
                           INT8_C(  13), INT8_C(  83), INT8_C( -94), INT8_C( 102),
                           INT8_C( 116), INT8_C( -60), INT8_C(  44), INT8_C(  -7),
                           INT8_C( 104), INT8_C( -50), INT8_C( -30), INT8_C(  17),
                           INT8_C(  13), INT8_C(-107), INT8_C( 111), INT8_C( -13),
                           INT8_C(  17), INT8_C( -45), INT8_C( -31), INT8_C(  76),
                           INT8_C(-102), INT8_C( -71), INT8_C( 116), INT8_C(  72),
                           INT8_C( -11), INT8_C( -97), INT8_C(  93), INT8_C(  48),
                           INT8_C( -75), INT8_C( -90), INT8_C( -10), INT8_C( -78),
                           INT8_C(  -8), INT8_C( -10), INT8_C(  48), INT8_C( -11)),
      simde_mm512_set_epi8(INT8_C(-125), INT8_C(-115), INT8_C( 121), INT8_C( -45),
                           INT8_C( -47), INT8_C(-128), INT8_C(  -7), INT8_C( -40),
                           INT8_C( -20), INT8_C(  -3), INT8_C( 120), INT8_C( -78),
                           INT8_C(-128), INT8_C(  45), INT8_C( 120), INT8_C(  17),
                           INT8_C(  93), INT8_C( -32), INT8_C( 107), INT8_C(  -2),
                           INT8_C( -94), INT8_C(  29), INT8_C( 109), INT8_C( 126),
                           INT8_C( -27), INT8_C(  42), INT8_C(-122), INT8_C( -46),
                           INT8_C(  29), INT8_C( -81), INT8_C( -75), INT8_C(  30),
                           INT8_C(-118), INT8_C( -91), INT8_C(-120), INT8_C(  42),
                           INT8_C(  54), INT8_C(  79), INT8_C( -54), INT8_C( -33),
                           INT8_C( 107), INT8_C( -40), INT8_C( -37), INT8_C(  61),
                           INT8_C( -48), INT8_C( -14), INT8_C(  39), INT8_C( -99),
                           INT8_C(  73), INT8_C(  36), INT8_C( -14), INT8_C(  72),
                           INT8_C(  -9), INT8_C( -65), INT8_C(-114), INT8_C( 114),
                           INT8_C( -87), INT8_C(  92), INT8_C( 102), INT8_C( -68),
                           INT8_C( -88), INT8_C(  90), INT8_C(  -7), INT8_C(  72)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_mask_add_epi8(test_vec[i].src, test_vec[i].k, test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_maskz_add_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__mmask64 k;
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { UINT64_C(17286015531074160252),
      simde_mm512_set_epi8(INT8_C(-115), INT8_C( -27), INT8_C(  62), INT8_C( -85),
                           INT8_C(  49), INT8_C(-115), INT8_C(  38), INT8_C(   4),
                           INT8_C(  92), INT8_C( 116), INT8_C( -78), INT8_C( -19),
                           INT8_C( -73), INT8_C(  22), INT8_C( -66), INT8_C( -29),
                           INT8_C(  55), INT8_C(  78), INT8_C( -45), INT8_C(-119),
                           INT8_C(  30), INT8_C( -29), INT8_C( -23), INT8_C(  89),
                           INT8_C(  15), INT8_C( 119), INT8_C( -88), INT8_C( 109),
                           INT8_C( -16), INT8_C( -10), INT8_C(   0), INT8_C( -18),
                           INT8_C(   1), INT8_C( 116), INT8_C(  62), INT8_C( -73),
                           INT8_C(-122), INT8_C(   0), INT8_C( 111), INT8_C(  95),
                           INT8_C( -20), INT8_C(   3), INT8_C( 122), INT8_C(-121),
                           INT8_C(  13), INT8_C(  25), INT8_C( -35), INT8_C(-127),
                           INT8_C(  82), INT8_C(  90), INT8_C(  53), INT8_C( 123),
                           INT8_C(  73), INT8_C( 108), INT8_C( -18), INT8_C(  15),
                           INT8_C(  81), INT8_C( -27), INT8_C( 102), INT8_C( 118),
                           INT8_C(  39), INT8_C( -77), INT8_C(  45), INT8_C(  81)),
      simde_mm512_set_epi8(INT8_C(  68), INT8_C(-108), INT8_C(-121), INT8_C(-115),
                           INT8_C( -59), INT8_C( -78), INT8_C(-111), INT8_C(  56),
                           INT8_C(   9), INT8_C(-121), INT8_C( 120), INT8_C( -36),
                           INT8_C(  36), INT8_C(-103), INT8_C(-104), INT8_C(  25),
                           INT8_C(-111), INT8_C( -63), INT8_C( -35), INT8_C(-120),
                           INT8_C(  28), INT8_C( -44), INT8_C( -26), INT8_C( -86),
                           INT8_C( -13), INT8_C(  53), INT8_C( -88), INT8_C(-107),
                           INT8_C(  68), INT8_C(  42), INT8_C(-118), INT8_C( 111),
                           INT8_C(  54), INT8_C( -58), INT8_C( -13), INT8_C(  27),
                           INT8_C(  23), INT8_C(  41), INT8_C(-119), INT8_C(  44),
                           INT8_C(   7), INT8_C(-120), INT8_C(  32), INT8_C( -43),
                           INT8_C( 114), INT8_C( -72), INT8_C(  73), INT8_C( -96),
                           INT8_C(  96), INT8_C( 110), INT8_C( -81), INT8_C( -76),
                           INT8_C( 103), INT8_C(-100), INT8_C( -22), INT8_C(  18),
                           INT8_C( 115), INT8_C(  54), INT8_C( -40), INT8_C( 125),
                           INT8_C( 110), INT8_C(  31), INT8_C(  51), INT8_C(-104)),
      simde_mm512_set_epi8(INT8_C( -47), INT8_C( 121), INT8_C( -59), INT8_C(   0),
                           INT8_C( -10), INT8_C(  63), INT8_C( -73), INT8_C(  60),
                           INT8_C( 101), INT8_C(  -5), INT8_C(  42), INT8_C(   0),
                           INT8_C(   0), INT8_C( -81), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  15), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -49), INT8_C(   3),
                           INT8_C(   2), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  52), INT8_C(   0), INT8_C(-118), INT8_C(   0),
                           INT8_C(   0), INT8_C(  58), INT8_C(   0), INT8_C(   0),
                           INT8_C( -99), INT8_C(  41), INT8_C(  -8), INT8_C(-117),
                           INT8_C( -13), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( 127), INT8_C( -47), INT8_C(  38), INT8_C(  33),
                           INT8_C( -78), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   8), INT8_C( -40), INT8_C(   0),
                           INT8_C(   0), INT8_C(  27), INT8_C(  62), INT8_C( -13),
                           INT8_C(-107), INT8_C( -46), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C( 9031211210081693899),
      simde_mm512_set_epi8(INT8_C(-106), INT8_C( -18), INT8_C(  65), INT8_C(-104),
                           INT8_C(  81), INT8_C(  38), INT8_C( -84), INT8_C(  -2),
                           INT8_C( -14), INT8_C(  85), INT8_C( -80), INT8_C(  80),
                           INT8_C(  48), INT8_C(  93), INT8_C(  79), INT8_C( 127),
                           INT8_C(  16), INT8_C(  41), INT8_C(  54), INT8_C(-116),
                           INT8_C(  17), INT8_C(  42), INT8_C( -86), INT8_C(  38),
                           INT8_C(-118), INT8_C( -56), INT8_C(  60), INT8_C(  19),
                           INT8_C(-100), INT8_C(-107), INT8_C( 105), INT8_C( -76),
                           INT8_C(  10), INT8_C(  -9), INT8_C( -12), INT8_C( -56),
                           INT8_C( -71), INT8_C(  96), INT8_C(   6), INT8_C(  24),
                           INT8_C(  69), INT8_C(  73), INT8_C( -27), INT8_C(   3),
                           INT8_C( -95), INT8_C(  50), INT8_C( -67), INT8_C( -39),
                           INT8_C(  97), INT8_C(  62), INT8_C( 101), INT8_C(  56),
                           INT8_C( -79), INT8_C(  83), INT8_C( -99), INT8_C( -56),
                           INT8_C( -17), INT8_C( -56), INT8_C(  -8), INT8_C( -16),
                           INT8_C(  84), INT8_C( -95), INT8_C( -73), INT8_C(  54)),
      simde_mm512_set_epi8(INT8_C(  63), INT8_C( -51), INT8_C(  87), INT8_C(  32),
                           INT8_C( -65), INT8_C(  55), INT8_C(  14), INT8_C(  81),
                           INT8_C(-123), INT8_C(-100), INT8_C( -39), INT8_C( -44),
                           INT8_C(  22), INT8_C( 112), INT8_C(  16), INT8_C(  15),
                           INT8_C(-104), INT8_C(-102), INT8_C( 102), INT8_C( -95),
                           INT8_C(  69), INT8_C(  13), INT8_C( -21), INT8_C(  45),
                           INT8_C(  62), INT8_C(-120), INT8_C(-111), INT8_C(  32),
                           INT8_C(-107), INT8_C( -30), INT8_C(  99), INT8_C( -64),
                           INT8_C(   8), INT8_C( -42), INT8_C(  81), INT8_C( -34),
                           INT8_C( -46), INT8_C(  26), INT8_C(  31), INT8_C(  -2),
                           INT8_C(  68), INT8_C(  -7), INT8_C( -71), INT8_C(  46),
                           INT8_C( -21), INT8_C( -73), INT8_C(  21), INT8_C(  83),
                           INT8_C(-108), INT8_C( -97), INT8_C( -69), INT8_C(  73),
                           INT8_C(  57), INT8_C( -37), INT8_C(  21), INT8_C(  82),
                           INT8_C(-119), INT8_C(-126), INT8_C( 126), INT8_C(  91),
                           INT8_C( 115), INT8_C(  31), INT8_C( -79), INT8_C(  28)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C( -69), INT8_C(-104), INT8_C( -72),
                           INT8_C(  16), INT8_C(  93), INT8_C(   0), INT8_C(  79),
                           INT8_C(   0), INT8_C( -15), INT8_C(   0), INT8_C(  36),
                           INT8_C(   0), INT8_C( -51), INT8_C(   0), INT8_C(-114),
                           INT8_C(   0), INT8_C( -61), INT8_C(   0), INT8_C(   0),
                           INT8_C(  86), INT8_C(  55), INT8_C(-107), INT8_C(   0),
                           INT8_C( -56), INT8_C(   0), INT8_C( -51), INT8_C(  51),
                           INT8_C(  49), INT8_C( 119), INT8_C( -52), INT8_C( 116),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( 122), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  66), INT8_C( -98), INT8_C(  49),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  44),
                           INT8_C( -11), INT8_C( -35), INT8_C(  32), INT8_C(-127),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( 120), INT8_C(  74), INT8_C(   0), INT8_C(   0),
                           INT8_C( -57), INT8_C(   0), INT8_C( 104), INT8_C(  82)) },
    { UINT64_C( 6828010367541473016),
      simde_mm512_set_epi8(INT8_C(  84), INT8_C( -96), INT8_C(  87), INT8_C( -22),
                           INT8_C(  -5), INT8_C(  -3), INT8_C(-127), INT8_C(  41),
                           INT8_C(  74), INT8_C(  72), INT8_C(  -4), INT8_C(  28),
                           INT8_C(-115), INT8_C(  93), INT8_C( 102), INT8_C(  44),
                           INT8_C(-103), INT8_C( -29), INT8_C( -50), INT8_C(  48),
                           INT8_C( -96), INT8_C( -50), INT8_C(  46), INT8_C( -65),
                           INT8_C(   4), INT8_C(  43), INT8_C( -75), INT8_C(  97),
                           INT8_C( -26), INT8_C(-103), INT8_C(  71), INT8_C(-107),
                           INT8_C(  91), INT8_C(  45), INT8_C( -11), INT8_C(  47),
                           INT8_C(  29), INT8_C(  25), INT8_C(  26), INT8_C(  -9),
                           INT8_C(  10), INT8_C(  36), INT8_C( -79), INT8_C( -53),
                           INT8_C(  41), INT8_C(   1), INT8_C( -23), INT8_C( -63),
                           INT8_C(-127), INT8_C(  68), INT8_C(  48), INT8_C(  36),
                           INT8_C(  89), INT8_C(-112), INT8_C( -31), INT8_C( 120),
                           INT8_C(  35), INT8_C(  62), INT8_C( -21), INT8_C(-114),
                           INT8_C(-104), INT8_C(  57), INT8_C(  42), INT8_C(-111)),
      simde_mm512_set_epi8(INT8_C(  96), INT8_C( -64), INT8_C( -23), INT8_C( -46),
                           INT8_C( -29), INT8_C( -71), INT8_C(  71), INT8_C(  90),
                           INT8_C(  44), INT8_C( -92), INT8_C( -31), INT8_C(  26),
                           INT8_C( -99), INT8_C( -53), INT8_C( 117), INT8_C(  18),
                           INT8_C( -63), INT8_C(  45), INT8_C(  12), INT8_C(  24),
                           INT8_C(-108), INT8_C(  18), INT8_C( -60), INT8_C(  28),
                           INT8_C(  50), INT8_C( -11), INT8_C( -68), INT8_C( -31),
                           INT8_C( 105), INT8_C(-106), INT8_C(  98), INT8_C(  51),
                           INT8_C(  58), INT8_C( 103), INT8_C( 111), INT8_C(-127),
                           INT8_C(  68), INT8_C( -56), INT8_C( 124), INT8_C(-119),
                           INT8_C(  74), INT8_C( -62), INT8_C(-116), INT8_C(  37),
                           INT8_C( -12), INT8_C( 114), INT8_C(   0), INT8_C(  61),
                           INT8_C( 103), INT8_C(  -4), INT8_C(-105), INT8_C( -68),
                           INT8_C(  39), INT8_C(-100), INT8_C( -93), INT8_C(  11),
                           INT8_C( -80), INT8_C( -19), INT8_C( -22), INT8_C( -39),
                           INT8_C( 127), INT8_C( -38), INT8_C(-125), INT8_C(-111)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(  96), INT8_C(   0), INT8_C( -68),
                           INT8_C( -34), INT8_C( -74), INT8_C( -56), INT8_C(   0),
                           INT8_C( 118), INT8_C( -20), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  62),
                           INT8_C(  90), INT8_C(  16), INT8_C( -38), INT8_C(  72),
                           INT8_C(   0), INT8_C( -32), INT8_C( -14), INT8_C( -37),
                           INT8_C(   0), INT8_C(  32), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(-107), INT8_C(   0), INT8_C( 100), INT8_C( -80),
                           INT8_C(  97), INT8_C( -31), INT8_C(-106), INT8_C(-128),
                           INT8_C(  84), INT8_C( -26), INT8_C(  61), INT8_C( -16),
                           INT8_C(  29), INT8_C( 115), INT8_C( -23), INT8_C(   0),
                           INT8_C(   0), INT8_C(  64), INT8_C( -57), INT8_C(   0),
                           INT8_C(-128), INT8_C(  44), INT8_C(-124), INT8_C(   0),
                           INT8_C( -45), INT8_C(  43), INT8_C( -43), INT8_C( 103),
                           INT8_C(  23), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C(18325019528117086600),
      simde_mm512_set_epi8(INT8_C( 122), INT8_C( -54), INT8_C(  50), INT8_C( 123),
                           INT8_C( -31), INT8_C( -74), INT8_C( -64), INT8_C(  54),
                           INT8_C( -81), INT8_C(  60), INT8_C(  31), INT8_C( -23),
                           INT8_C( 108), INT8_C(-119), INT8_C( -92), INT8_C( -80),
                           INT8_C( -30), INT8_C( -37), INT8_C(  51), INT8_C( -36),
                           INT8_C(   8), INT8_C(  52), INT8_C(  97), INT8_C( 123),
                           INT8_C( -49), INT8_C(-124), INT8_C(  95), INT8_C( -83),
                           INT8_C(  70), INT8_C( -50), INT8_C( -61), INT8_C(  25),
                           INT8_C( -97), INT8_C(  28), INT8_C( -58), INT8_C(  11),
                           INT8_C( -14), INT8_C( 126), INT8_C(  81), INT8_C(  45),
                           INT8_C( -23), INT8_C( 120), INT8_C( -83), INT8_C( -16),
                           INT8_C(   7), INT8_C(  51), INT8_C( -57), INT8_C( -50),
                           INT8_C( -21), INT8_C(  98), INT8_C(  88), INT8_C(   0),
                           INT8_C( -66), INT8_C(   3), INT8_C( 124), INT8_C(-113),
                           INT8_C(  50), INT8_C(  88), INT8_C( -85), INT8_C( -93),
                           INT8_C( -44), INT8_C( -13), INT8_C( -94), INT8_C(  17)),
      simde_mm512_set_epi8(INT8_C( -13), INT8_C( -12), INT8_C(-124), INT8_C(  96),
                           INT8_C( -13), INT8_C( -98), INT8_C(  99), INT8_C( -13),
                           INT8_C(  56), INT8_C( -45), INT8_C(-108), INT8_C( -19),
                           INT8_C(-124), INT8_C( -27), INT8_C(  22), INT8_C( 126),
                           INT8_C(-106), INT8_C( -68), INT8_C( -60), INT8_C(   8),
                           INT8_C(  60), INT8_C(  93), INT8_C( -33), INT8_C( -27),
                           INT8_C(  -7), INT8_C(  27), INT8_C(-122), INT8_C( -38),
                           INT8_C(  23), INT8_C(   6), INT8_C(  45), INT8_C( -21),
                           INT8_C( -23), INT8_C(-101), INT8_C( 116), INT8_C( 127),
                           INT8_C(  96), INT8_C(  40), INT8_C( -97), INT8_C(  40),
                           INT8_C(  86), INT8_C( -44), INT8_C(  70), INT8_C( -71),
                           INT8_C(  62), INT8_C( -21), INT8_C(  66), INT8_C(  68),
                           INT8_C( -87), INT8_C( -61), INT8_C(  48), INT8_C( -70),
                           INT8_C(  18), INT8_C( -78), INT8_C( -98), INT8_C( 117),
                           INT8_C(  74), INT8_C(  32), INT8_C(  93), INT8_C( 125),
                           INT8_C( -47), INT8_C( -60), INT8_C( -86), INT8_C( 117)),
      simde_mm512_set_epi8(INT8_C( 109), INT8_C( -66), INT8_C( -74), INT8_C( -37),
                           INT8_C( -44), INT8_C(  84), INT8_C(  35), INT8_C(   0),
                           INT8_C(   0), INT8_C(  15), INT8_C(   0), INT8_C(   0),
                           INT8_C( -16), INT8_C( 110), INT8_C( -70), INT8_C(  46),
                           INT8_C( 120), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  68), INT8_C(-111), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -27), INT8_C(   0),
                           INT8_C(  93), INT8_C(   0), INT8_C( -16), INT8_C(   4),
                           INT8_C(-120), INT8_C(   0), INT8_C(  58), INT8_C(-118),
                           INT8_C(   0), INT8_C(   0), INT8_C( -16), INT8_C(  85),
                           INT8_C(  63), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   9), INT8_C(  18),
                           INT8_C(-108), INT8_C(  37), INT8_C(-120), INT8_C(   0),
                           INT8_C( -48), INT8_C(   0), INT8_C(   0), INT8_C(   4),
                           INT8_C( 124), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -91), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C( 7677112093376593822),
      simde_mm512_set_epi8(INT8_C( -53), INT8_C(  34), INT8_C(   9), INT8_C(  64),
                           INT8_C( -61), INT8_C( -25), INT8_C(-115), INT8_C( 100),
                           INT8_C(  65), INT8_C(   8), INT8_C(  69), INT8_C(  -8),
                           INT8_C( -15), INT8_C( -51), INT8_C(   1), INT8_C(  90),
                           INT8_C( 115), INT8_C(  51), INT8_C( -91), INT8_C(  56),
                           INT8_C(  64), INT8_C( -39), INT8_C(-119), INT8_C( -28),
                           INT8_C( -54), INT8_C(  28), INT8_C(  54), INT8_C(  -8),
                           INT8_C( -54), INT8_C(-128), INT8_C( -28), INT8_C( -71),
                           INT8_C( 107), INT8_C( -66), INT8_C(-114), INT8_C( -88),
                           INT8_C(  34), INT8_C( -83), INT8_C( -21), INT8_C( -64),
                           INT8_C( 121), INT8_C( -20), INT8_C( -89), INT8_C( -94),
                           INT8_C( 112), INT8_C( -27), INT8_C(  81), INT8_C( -54),
                           INT8_C( -64), INT8_C(-114), INT8_C(  48), INT8_C( -89),
                           INT8_C( -61), INT8_C(  26), INT8_C(  43), INT8_C(  29),
                           INT8_C(   0), INT8_C(  64), INT8_C( 123), INT8_C( -67),
                           INT8_C(  15), INT8_C( 120), INT8_C(  36), INT8_C(  40)),
      simde_mm512_set_epi8(INT8_C( 113), INT8_C(  32), INT8_C(  71), INT8_C(  55),
                           INT8_C( -26), INT8_C(  82), INT8_C( -81), INT8_C( -20),
                           INT8_C( -55), INT8_C( 112), INT8_C(  45), INT8_C(  37),
                           INT8_C(  67), INT8_C( -69), INT8_C(  64), INT8_C(  39),
                           INT8_C(  72), INT8_C(  45), INT8_C( 120), INT8_C(  -5),
                           INT8_C(-109), INT8_C(  62), INT8_C(  17), INT8_C(  31),
                           INT8_C( -30), INT8_C( -58), INT8_C(  56), INT8_C(  21),
                           INT8_C(  72), INT8_C( -74), INT8_C( -40), INT8_C( 120),
                           INT8_C(  95), INT8_C( 108), INT8_C(  32), INT8_C(  64),
                           INT8_C(-128), INT8_C( 102), INT8_C( -21), INT8_C(  28),
                           INT8_C( 105), INT8_C(  52), INT8_C(  85), INT8_C(-104),
                           INT8_C(  57), INT8_C( -31), INT8_C( -38), INT8_C(-124),
                           INT8_C(-107), INT8_C(  -2), INT8_C(  55), INT8_C(  46),
                           INT8_C( -71), INT8_C(  77), INT8_C(  18), INT8_C(  70),
                           INT8_C(  89), INT8_C( 125), INT8_C( -42), INT8_C(-125),
                           INT8_C( 121), INT8_C( -11), INT8_C( -69), INT8_C( -59)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(  66), INT8_C(  80), INT8_C(   0),
                           INT8_C( -87), INT8_C(   0), INT8_C(  60), INT8_C(   0),
                           INT8_C(  10), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  52), INT8_C(   0), INT8_C(  65), INT8_C(   0),
                           INT8_C( -69), INT8_C(   0), INT8_C(   0), INT8_C(  51),
                           INT8_C(   0), INT8_C(  23), INT8_C(   0), INT8_C(   0),
                           INT8_C( -84), INT8_C( -30), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  54), INT8_C( -68), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -24),
                           INT8_C( -94), INT8_C(   0), INT8_C( -42), INT8_C(   0),
                           INT8_C( -30), INT8_C(   0), INT8_C(   0), INT8_C(  58),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  78),
                           INT8_C(   0), INT8_C(   0), INT8_C( 103), INT8_C( -43),
                           INT8_C( 124), INT8_C( 103), INT8_C(  61), INT8_C(  99),
                           INT8_C(  89), INT8_C(   0), INT8_C(   0), INT8_C(  64),
                           INT8_C(-120), INT8_C( 109), INT8_C( -33), INT8_C(   0)) },
    { UINT64_C( 4840581956081845689),
      simde_mm512_set_epi8(INT8_C( 122), INT8_C(-108), INT8_C( -70), INT8_C( -63),
                           INT8_C(  56), INT8_C(  71), INT8_C( -14), INT8_C(  49),
                           INT8_C( -73), INT8_C(  53), INT8_C( -29), INT8_C(   3),
                           INT8_C( -73), INT8_C(  43), INT8_C( -22), INT8_C(  85),
                           INT8_C( -26), INT8_C(  -9), INT8_C(  66), INT8_C(   1),
                           INT8_C( -13), INT8_C(  60), INT8_C(-119), INT8_C( -83),
                           INT8_C(-122), INT8_C( -64), INT8_C( -83), INT8_C( -74),
                           INT8_C( 119), INT8_C(  -8), INT8_C(  12), INT8_C( 113),
                           INT8_C( -12), INT8_C( -84), INT8_C(   6), INT8_C(  69),
                           INT8_C(   2), INT8_C( -75), INT8_C( -34), INT8_C(-126),
                           INT8_C(   3), INT8_C(-128), INT8_C(  -9), INT8_C(  24),
                           INT8_C(  11), INT8_C( -94), INT8_C( -32), INT8_C( 110),
                           INT8_C(  33), INT8_C( -24), INT8_C( 125), INT8_C(  35),
                           INT8_C(-103), INT8_C( -48), INT8_C( -22), INT8_C(  38),
                           INT8_C( -81), INT8_C(   9), INT8_C( -11), INT8_C(-124),
                           INT8_C(  71), INT8_C(  31), INT8_C( -42), INT8_C(  93)),
      simde_mm512_set_epi8(INT8_C(  53), INT8_C(  77), INT8_C(  63), INT8_C( -84),
                           INT8_C(  27), INT8_C(  22), INT8_C(   3), INT8_C( -37),
                           INT8_C(  65), INT8_C( 118), INT8_C(-126), INT8_C(  97),
                           INT8_C( 109), INT8_C(   7), INT8_C(-114), INT8_C( -75),
                           INT8_C(-125), INT8_C( 121), INT8_C(-128), INT8_C( 103),
                           INT8_C(   0), INT8_C( 101), INT8_C( -41), INT8_C(  89),
                           INT8_C( -83), INT8_C( -65), INT8_C(   9), INT8_C(  -7),
                           INT8_C( -63), INT8_C(  13), INT8_C( 105), INT8_C(  92),
                           INT8_C( -18), INT8_C( -21), INT8_C(-102), INT8_C(-114),
                           INT8_C(  74), INT8_C( 121), INT8_C( -45), INT8_C(  52),
                           INT8_C( -63), INT8_C( -93), INT8_C(  98), INT8_C( 106),
                           INT8_C(-109), INT8_C( -47), INT8_C(  37), INT8_C(  70),
                           INT8_C( 100), INT8_C( 121), INT8_C(  18), INT8_C(  28),
                           INT8_C(-117), INT8_C( 107), INT8_C(   3), INT8_C( -62),
                           INT8_C(  42), INT8_C(  72), INT8_C(  91), INT8_C(  86),
                           INT8_C( -72), INT8_C(   9), INT8_C( -80), INT8_C( 118)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C( -31), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -11), INT8_C(  12),
                           INT8_C(   0), INT8_C(   0), INT8_C( 101), INT8_C(   0),
                           INT8_C(  36), INT8_C(  50), INT8_C(   0), INT8_C(  10),
                           INT8_C(   0), INT8_C(   0), INT8_C( -62), INT8_C( 104),
                           INT8_C(   0), INT8_C(   0), INT8_C(  96), INT8_C(   6),
                           INT8_C(  51), INT8_C(   0), INT8_C( -74), INT8_C(   0),
                           INT8_C(   0), INT8_C(   5), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-105), INT8_C( -96), INT8_C( -45),
                           INT8_C(  76), INT8_C(  46), INT8_C( -79), INT8_C(   0),
                           INT8_C(   0), INT8_C(  35), INT8_C(  89), INT8_C(   0),
                           INT8_C( -98), INT8_C( 115), INT8_C(   0), INT8_C(   0),
                           INT8_C(-123), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  59), INT8_C(   0), INT8_C( -24),
                           INT8_C( -39), INT8_C(   0), INT8_C(  80), INT8_C( -38),
                           INT8_C(  -1), INT8_C(   0), INT8_C(   0), INT8_C( -45)) },
    { UINT64_C(17498311407133456191),
      simde_mm512_set_epi8(INT8_C(  61), INT8_C( -89), INT8_C(  84), INT8_C( -94),
                           INT8_C(  31), INT8_C(-116), INT8_C( -67), INT8_C(-102),
                           INT8_C( -72), INT8_C( -91), INT8_C(-105), INT8_C(-108),
                           INT8_C( -44), INT8_C(  74), INT8_C( -28), INT8_C( 124),
                           INT8_C( 120), INT8_C( -41), INT8_C( -79), INT8_C( 122),
                           INT8_C(  87), INT8_C(-119), INT8_C(  54), INT8_C(  -2),
                           INT8_C( -47), INT8_C(  84), INT8_C(-126), INT8_C( -64),
                           INT8_C(  14), INT8_C(  11), INT8_C(  37), INT8_C( -23),
                           INT8_C(  67), INT8_C( 124), INT8_C(  58), INT8_C( -94),
                           INT8_C(  30), INT8_C( -33), INT8_C(  70), INT8_C( -24),
                           INT8_C(  38), INT8_C( -97), INT8_C( -56), INT8_C( -60),
                           INT8_C( -59), INT8_C(  65), INT8_C( -74), INT8_C(  45),
                           INT8_C( -11), INT8_C(  55), INT8_C( -82), INT8_C(  12),
                           INT8_C( 106), INT8_C(  22), INT8_C(-124), INT8_C(  -4),
                           INT8_C(   2), INT8_C( -81), INT8_C(  14), INT8_C(  90),
                           INT8_C(-100), INT8_C(-122), INT8_C( -35), INT8_C(  81)),
      simde_mm512_set_epi8(INT8_C(  21), INT8_C( 108), INT8_C( 125), INT8_C( -60),
                           INT8_C( -72), INT8_C(  74), INT8_C(  -5), INT8_C( -58),
                           INT8_C( -41), INT8_C(  22), INT8_C(-115), INT8_C( 102),
                           INT8_C(  59), INT8_C( -80), INT8_C( -15), INT8_C( -63),
                           INT8_C(  84), INT8_C( -71), INT8_C(   8), INT8_C(  12),
                           INT8_C( -11), INT8_C( -76), INT8_C(  62), INT8_C(  93),
                           INT8_C( -75), INT8_C( -77), INT8_C( -84), INT8_C(-108),
                           INT8_C( -35), INT8_C(  14), INT8_C( -60), INT8_C(  18),
                           INT8_C(  23), INT8_C( -60), INT8_C( -63), INT8_C(-114),
                           INT8_C( -55), INT8_C(  75), INT8_C( -99), INT8_C( -55),
                           INT8_C(  58), INT8_C(  76), INT8_C(-102), INT8_C(-118),
                           INT8_C( -30), INT8_C(  39), INT8_C( 119), INT8_C(  85),
                           INT8_C(  -8), INT8_C( -72), INT8_C( -60), INT8_C( -94),
                           INT8_C(-112), INT8_C( 119), INT8_C( 124), INT8_C(  76),
                           INT8_C( -42), INT8_C(-124), INT8_C(  54), INT8_C(  74),
                           INT8_C( -92), INT8_C(  99), INT8_C(  79), INT8_C(  -3)),
      simde_mm512_set_epi8(INT8_C(  82), INT8_C(  19), INT8_C( -47), INT8_C( 102),
                           INT8_C(   0), INT8_C(   0), INT8_C( -72), INT8_C(   0),
                           INT8_C(-113), INT8_C( -69), INT8_C(   0), INT8_C(  -6),
                           INT8_C(   0), INT8_C(  -6), INT8_C( -43), INT8_C(   0),
                           INT8_C(   0), INT8_C(-112), INT8_C( -71), INT8_C(-122),
                           INT8_C(  76), INT8_C(  61), INT8_C(   0), INT8_C(  91),
                           INT8_C(-122), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -23), INT8_C(  -5),
                           INT8_C(  90), INT8_C(  64), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  42), INT8_C( -29), INT8_C( -79),
                           INT8_C(   0), INT8_C( -21), INT8_C(   0), INT8_C(  78),
                           INT8_C( -89), INT8_C(   0), INT8_C(  45), INT8_C(   0),
                           INT8_C( -19), INT8_C( -17), INT8_C( 114), INT8_C( -82),
                           INT8_C(   0), INT8_C(-115), INT8_C(   0), INT8_C(  72),
                           INT8_C(   0), INT8_C(   0), INT8_C(  68), INT8_C( -92),
                           INT8_C(  64), INT8_C( -23), INT8_C(  44), INT8_C(  78)) },
    { UINT64_C( 3462613925466476941),
      simde_mm512_set_epi8(INT8_C(  18), INT8_C( -74), INT8_C(  14), INT8_C(  36),
                           INT8_C(  -7), INT8_C( 113), INT8_C(  40), INT8_C(  48),
                           INT8_C(-107), INT8_C( -34), INT8_C( -75), INT8_C(  85),
                           INT8_C( -35), INT8_C(-116), INT8_C(  65), INT8_C( -21),
                           INT8_C(  15), INT8_C(   3), INT8_C(  45), INT8_C(  21),
                           INT8_C(  72), INT8_C(  93), INT8_C( 108), INT8_C( 125),
                           INT8_C(   1), INT8_C(  75), INT8_C(  21), INT8_C( -36),
                           INT8_C(-126), INT8_C( 122), INT8_C(  71), INT8_C(  76),
                           INT8_C(  28), INT8_C( -56), INT8_C(  32), INT8_C( 101),
                           INT8_C(-107), INT8_C(-111), INT8_C( -88), INT8_C( -19),
                           INT8_C( -77), INT8_C(  19), INT8_C( -21), INT8_C(-111),
                           INT8_C( -68), INT8_C(  82), INT8_C(-118), INT8_C( -76),
                           INT8_C(  47), INT8_C( 127), INT8_C(  62), INT8_C( -16),
                           INT8_C(  10), INT8_C( -14), INT8_C(-100), INT8_C(  86),
                           INT8_C(  29), INT8_C( 107), INT8_C(  56), INT8_C(  21),
                           INT8_C(  24), INT8_C(  68), INT8_C( -96), INT8_C(  64)),
      simde_mm512_set_epi8(INT8_C( -57), INT8_C(  94), INT8_C(-125), INT8_C(-124),
                           INT8_C(  36), INT8_C(  57), INT8_C(  68), INT8_C( -52),
                           INT8_C(  39), INT8_C(  50), INT8_C( -48), INT8_C(  94),
                           INT8_C(  53), INT8_C(  11), INT8_C(  29), INT8_C(  65),
                           INT8_C( -82), INT8_C(-119), INT8_C( 115), INT8_C(  68),
                           INT8_C( -69), INT8_C( 118), INT8_C(  17), INT8_C(   8),
                           INT8_C( -64), INT8_C( -53), INT8_C( -42), INT8_C( 126),
                           INT8_C(  67), INT8_C(  50), INT8_C( -18), INT8_C(  76),
                           INT8_C( -19), INT8_C( 123), INT8_C( -87), INT8_C( 106),
                           INT8_C( -74), INT8_C(  44), INT8_C( 117), INT8_C( 103),
                           INT8_C(  81), INT8_C( 122), INT8_C(  56), INT8_C( -10),
                           INT8_C(  67), INT8_C(  79), INT8_C(  83), INT8_C( -38),
                           INT8_C( -13), INT8_C(  43), INT8_C(  27), INT8_C( -97),
                           INT8_C( 102), INT8_C( 126), INT8_C(  38), INT8_C( -62),
                           INT8_C( -24), INT8_C( 117), INT8_C( -38), INT8_C( -93),
                           INT8_C( -58), INT8_C(-124), INT8_C( -75), INT8_C(  10)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(-111), INT8_C( -88),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  18), INT8_C(-105), INT8_C(   0), INT8_C(  44),
                           INT8_C( -67), INT8_C(   0), INT8_C( -96), INT8_C(   0),
                           INT8_C(   3), INT8_C( -45), INT8_C(   0), INT8_C(-123),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -84), INT8_C(   0), INT8_C(   0),
                           INT8_C(   9), INT8_C(  67), INT8_C( -55), INT8_C( -49),
                           INT8_C(  75), INT8_C( -67), INT8_C(   0), INT8_C(  84),
                           INT8_C(   4), INT8_C(-115), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(-113),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  24),
                           INT8_C(   5), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -34), INT8_C( -56), INT8_C(   0), INT8_C(  74)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_maskz_add_epi8(test_vec[i].k, test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_add_epi16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi16(INT16_C(   349), INT16_C(-29396), INT16_C( -1715), INT16_C( 16589),
                            INT16_C( 13172), INT16_C( 26047), INT16_C(  5883), INT16_C( -4935),
                            INT16_C( 15316), INT16_C(-29937), INT16_C( 30482), INT16_C( -8125),
                            INT16_C( 11096), INT16_C( -7671), INT16_C(-25200), INT16_C(  5750),
                            INT16_C( 31993), INT16_C( -7121), INT16_C( 11998), INT16_C( 13883),
                            INT16_C(-28089), INT16_C(-32338), INT16_C(  -208), INT16_C(-28436),
                            INT16_C(-10610), INT16_C(-10313), INT16_C(-29339), INT16_C( 15099),
                            INT16_C(-23126), INT16_C( -2120), INT16_C( -5377), INT16_C(-19429)),
      simde_mm512_set_epi16(INT16_C(-26025), INT16_C(  6931), INT16_C(-28404), INT16_C( -6915),
                            INT16_C( 32464), INT16_C( 14709), INT16_C(  9265), INT16_C( 28903),
                            INT16_C( 12959), INT16_C(  1528), INT16_C( -1171), INT16_C(-18467),
                            INT16_C(-24910), INT16_C( 20383), INT16_C(-32413), INT16_C( 30063),
                            INT16_C(-18797), INT16_C(  -176), INT16_C( 31069), INT16_C(  -859),
                            INT16_C(-22884), INT16_C( 24996), INT16_C(-21811), INT16_C(  3435),
                            INT16_C(-21086), INT16_C( 16303), INT16_C( -9634), INT16_C( 24020),
                            INT16_C(-17856), INT16_C( 12199), INT16_C(-22749), INT16_C( 18054)),
      simde_mm512_set_epi16(INT16_C(-25676), INT16_C(-22465), INT16_C(-30119), INT16_C(  9674),
                            INT16_C(-19900), INT16_C(-24780), INT16_C( 15148), INT16_C( 23968),
                            INT16_C( 28275), INT16_C(-28409), INT16_C( 29311), INT16_C(-26592),
                            INT16_C(-13814), INT16_C( 12712), INT16_C(  7923), INT16_C(-29723),
                            INT16_C( 13196), INT16_C( -7297), INT16_C(-22469), INT16_C( 13024),
                            INT16_C( 14563), INT16_C( -7342), INT16_C(-22019), INT16_C(-25001),
                            INT16_C(-31696), INT16_C(  5990), INT16_C( 26563), INT16_C(-26417),
                            INT16_C( 24554), INT16_C( 10079), INT16_C(-28126), INT16_C( -1375)) },
    { simde_mm512_set_epi16(INT16_C( -3989), INT16_C(-30175), INT16_C( 25534), INT16_C( 21236),
                            INT16_C(-28751), INT16_C(-15682), INT16_C(-17811), INT16_C(  5466),
                            INT16_C( 14761), INT16_C( -6341), INT16_C( 13005), INT16_C(  6626),
                            INT16_C(-22437), INT16_C( 32157), INT16_C( 16196), INT16_C( 12254),
                            INT16_C( -5188), INT16_C(-27110), INT16_C(-10937), INT16_C( 18876),
                            INT16_C(-22516), INT16_C( -9380), INT16_C( 24491), INT16_C( 32448),
                            INT16_C( 30603), INT16_C( 17755), INT16_C( 15525), INT16_C(-18646),
                            INT16_C( -5336), INT16_C( 12723), INT16_C( 21354), INT16_C( 17662)),
      simde_mm512_set_epi16(INT16_C(-30641), INT16_C(-13527), INT16_C(-31180), INT16_C( -2256),
                            INT16_C( 14465), INT16_C( -5487), INT16_C(-29622), INT16_C(  3444),
                            INT16_C( 10403), INT16_C( 10707), INT16_C( 14250), INT16_C( -9458),
                            INT16_C(-15890), INT16_C(-11581), INT16_C( 31741), INT16_C( -3971),
                            INT16_C(-13172), INT16_C( 26028), INT16_C(-27938), INT16_C( 12765),
                            INT16_C( 12701), INT16_C( 22446), INT16_C( 10601), INT16_C( 23537),
                            INT16_C(-12070), INT16_C(  4052), INT16_C(-27601), INT16_C(  6442),
                            INT16_C( 15457), INT16_C( 16368), INT16_C(-10089), INT16_C(-27950)),
      simde_mm512_set_epi16(INT16_C( 30906), INT16_C( 21834), INT16_C( -5646), INT16_C( 18980),
                            INT16_C(-14286), INT16_C(-21169), INT16_C( 18103), INT16_C(  8910),
                            INT16_C( 25164), INT16_C(  4366), INT16_C( 27255), INT16_C( -2832),
                            INT16_C( 27209), INT16_C( 20576), INT16_C(-17599), INT16_C(  8283),
                            INT16_C(-18360), INT16_C( -1082), INT16_C( 26661), INT16_C( 31641),
                            INT16_C( -9815), INT16_C( 13066), INT16_C(-30444), INT16_C( -9551),
                            INT16_C( 18533), INT16_C( 21807), INT16_C(-12076), INT16_C(-12204),
                            INT16_C( 10121), INT16_C( 29091), INT16_C( 11265), INT16_C(-10288)) },
    { simde_mm512_set_epi16(INT16_C( 11406), INT16_C( 15860), INT16_C( 32408), INT16_C( 20296),
                            INT16_C(-23209), INT16_C( -4355), INT16_C( 20626), INT16_C(  1722),
                            INT16_C(  4406), INT16_C( 21740), INT16_C( 29841), INT16_C(-12318),
                            INT16_C(  5010), INT16_C( 25583), INT16_C(-28636), INT16_C(-19823),
                            INT16_C( 19609), INT16_C(  -482), INT16_C(-26960), INT16_C( 12932),
                            INT16_C( 25675), INT16_C( 27916), INT16_C(  -103), INT16_C( -9711),
                            INT16_C( -8676), INT16_C( 23694), INT16_C( 21251), INT16_C( 19026),
                            INT16_C(-11702), INT16_C(-26830), INT16_C( 26192), INT16_C( 16714)),
      simde_mm512_set_epi16(INT16_C(-20697), INT16_C(  8385), INT16_C(-25016), INT16_C(-29476),
                            INT16_C(  1197), INT16_C(  1598), INT16_C(-18495), INT16_C(  -604),
                            INT16_C( 32461), INT16_C( 15914), INT16_C(-12095), INT16_C( 31489),
                            INT16_C(-29973), INT16_C(  5197), INT16_C(-19884), INT16_C( -9093),
                            INT16_C( 24365), INT16_C(  5199), INT16_C(  1438), INT16_C(-24403),
                            INT16_C( 13393), INT16_C( -9470), INT16_C(-24987), INT16_C( 14167),
                            INT16_C(-21760), INT16_C(-27466), INT16_C(  1802), INT16_C(-10339),
                            INT16_C(-16668), INT16_C( -6467), INT16_C(-22758), INT16_C( 26203)),
      simde_mm512_set_epi16(INT16_C( -9291), INT16_C( 24245), INT16_C(  7392), INT16_C( -9180),
                            INT16_C(-22012), INT16_C( -2757), INT16_C(  2131), INT16_C(  1118),
                            INT16_C(-28669), INT16_C(-27882), INT16_C( 17746), INT16_C( 19171),
                            INT16_C(-24963), INT16_C( 30780), INT16_C( 17016), INT16_C(-28916),
                            INT16_C(-21562), INT16_C(  4717), INT16_C(-25522), INT16_C(-11471),
                            INT16_C(-26468), INT16_C( 18446), INT16_C(-25090), INT16_C(  4456),
                            INT16_C(-30436), INT16_C( -3772), INT16_C( 23053), INT16_C(  8687),
                            INT16_C(-28370), INT16_C( 32239), INT16_C(  3434), INT16_C(-22619)) },
    { simde_mm512_set_epi16(INT16_C(-30508), INT16_C( -8435), INT16_C(-23521), INT16_C(-31231),
                            INT16_C( -6697), INT16_C( 32640), INT16_C( 24568), INT16_C( 14464),
                            INT16_C( -5238), INT16_C( 13133), INT16_C( 23851), INT16_C( 13957),
                            INT16_C( 11395), INT16_C(-27094), INT16_C(  8506), INT16_C(-24029),
                            INT16_C( 10430), INT16_C( -8874), INT16_C( 12704), INT16_C( -5845),
                            INT16_C(-24165), INT16_C( 31525), INT16_C(-23241), INT16_C( 12770),
                            INT16_C( 11983), INT16_C( 24752), INT16_C( 26827), INT16_C(  7419),
                            INT16_C( 18999), INT16_C(-29755), INT16_C( -7348), INT16_C( 17011)),
      simde_mm512_set_epi16(INT16_C( -9556), INT16_C( 20376), INT16_C(  -504), INT16_C(-15467),
                            INT16_C(-27353), INT16_C( 22049), INT16_C(  2480), INT16_C( -1262),
                            INT16_C(-12063), INT16_C(-15465), INT16_C(  9332), INT16_C(  5510),
                            INT16_C( 16986), INT16_C( 10260), INT16_C(-14757), INT16_C( -4174),
                            INT16_C( 13005), INT16_C(  3852), INT16_C(-21347), INT16_C( -1968),
                            INT16_C( -9697), INT16_C( -3705), INT16_C( 32693), INT16_C( 25464),
                            INT16_C(-10937), INT16_C( -1347), INT16_C(-26033), INT16_C( 29916),
                            INT16_C( 26028), INT16_C( 32589), INT16_C(-13806), INT16_C(-11649)),
      simde_mm512_set_epi16(INT16_C( 25472), INT16_C( 11941), INT16_C(-24025), INT16_C( 18838),
                            INT16_C( 31486), INT16_C(-10847), INT16_C( 27048), INT16_C( 13202),
                            INT16_C(-17301), INT16_C( -2332), INT16_C(-32353), INT16_C( 19467),
                            INT16_C( 28381), INT16_C(-16834), INT16_C( -6251), INT16_C(-28203),
                            INT16_C( 23435), INT16_C( -5022), INT16_C( -8643), INT16_C( -7813),
                            INT16_C( 31674), INT16_C( 27820), INT16_C(  9452), INT16_C(-27302),
                            INT16_C(  1046), INT16_C( 23405), INT16_C(   794), INT16_C(-28201),
                            INT16_C(-20509), INT16_C(  2834), INT16_C(-21154), INT16_C(  5362)) },
    { simde_mm512_set_epi16(INT16_C( 17007), INT16_C( 26388), INT16_C( 16587), INT16_C(  2658),
                            INT16_C( 16016), INT16_C( -6098), INT16_C( 17295), INT16_C( 19188),
                            INT16_C( -3860), INT16_C( -2846), INT16_C( -1608), INT16_C(-24739),
                            INT16_C(-11858), INT16_C( -6467), INT16_C(-10889), INT16_C( 20717),
                            INT16_C( 27962), INT16_C( 27514), INT16_C(  3713), INT16_C(-16450),
                            INT16_C(-12904), INT16_C( -9001), INT16_C( -3432), INT16_C( 25105),
                            INT16_C(-29163), INT16_C( 12095), INT16_C( 29208), INT16_C(-23316),
                            INT16_C( -5617), INT16_C( -2025), INT16_C(-15980), INT16_C(-14354)),
      simde_mm512_set_epi16(INT16_C( 18668), INT16_C(-10822), INT16_C( -7319), INT16_C(  2207),
                            INT16_C(-28795), INT16_C( -7604), INT16_C(-16872), INT16_C( 10570),
                            INT16_C( 11704), INT16_C( 17371), INT16_C( -7205), INT16_C(-13111),
                            INT16_C( 29629), INT16_C(-19936), INT16_C(-18746), INT16_C( -3226),
                            INT16_C(-30358), INT16_C( 14777), INT16_C(  5470), INT16_C(  -418),
                            INT16_C( 13272), INT16_C(-20634), INT16_C( 18371), INT16_C( 26212),
                            INT16_C( 15436), INT16_C( 16910), INT16_C( 12497), INT16_C( 26209),
                            INT16_C(-27094), INT16_C( -2417), INT16_C(  7853), INT16_C(  2231)),
      simde_mm512_set_epi16(INT16_C(-29861), INT16_C( 15566), INT16_C(  9268), INT16_C(  4865),
                            INT16_C(-12779), INT16_C(-13702), INT16_C(   423), INT16_C( 29758),
                            INT16_C(  7844), INT16_C( 14525), INT16_C( -8813), INT16_C( 27686),
                            INT16_C( 17771), INT16_C(-26403), INT16_C(-29635), INT16_C( 17491),
                            INT16_C( -2396), INT16_C(-23245), INT16_C(  9183), INT16_C(-16868),
                            INT16_C(   368), INT16_C(-29635), INT16_C( 14939), INT16_C(-14219),
                            INT16_C(-13727), INT16_C( 29005), INT16_C(-23831), INT16_C(  2893),
                            INT16_C(-32711), INT16_C( -4442), INT16_C( -8127), INT16_C(-12123)) },
    { simde_mm512_set_epi16(INT16_C( 19568), INT16_C(  7483), INT16_C( 22665), INT16_C(  4990),
                            INT16_C(-14862), INT16_C(  9090), INT16_C(  3815), INT16_C( 16087),
                            INT16_C(-26135), INT16_C( 16974), INT16_C(-15777), INT16_C( 12750),
                            INT16_C(  9476), INT16_C(-12123), INT16_C(-10116), INT16_C(  6925),
                            INT16_C(-18973), INT16_C( 14619), INT16_C(-17228), INT16_C( 27498),
                            INT16_C( 31940), INT16_C(-14723), INT16_C(-15865), INT16_C(  6456),
                            INT16_C( 15978), INT16_C(-27380), INT16_C( -5397), INT16_C( 25141),
                            INT16_C( 30635), INT16_C( 29554), INT16_C( 31406), INT16_C( 15531)),
      simde_mm512_set_epi16(INT16_C( -9857), INT16_C( 27698), INT16_C(  3653), INT16_C(  6143),
                            INT16_C( 28881), INT16_C(-13964), INT16_C( -9726), INT16_C( 17841),
                            INT16_C(-29232), INT16_C( 23212), INT16_C( 22943), INT16_C( 26376),
                            INT16_C( -7021), INT16_C(-26880), INT16_C(-12162), INT16_C(-24537),
                            INT16_C(-12800), INT16_C(-32034), INT16_C(  5847), INT16_C( -8914),
                            INT16_C(-26726), INT16_C( -2268), INT16_C( -3781), INT16_C(-22106),
                            INT16_C( -9952), INT16_C( 18372), INT16_C(-24517), INT16_C( 24102),
                            INT16_C( 30326), INT16_C(-15689), INT16_C( -8622), INT16_C(-11252)),
      simde_mm512_set_epi16(INT16_C(  9711), INT16_C(-30355), INT16_C( 26318), INT16_C( 11133),
                            INT16_C( 14019), INT16_C( -4874), INT16_C( -5911), INT16_C(-31608),
                            INT16_C( 10169), INT16_C(-25350), INT16_C(  7166), INT16_C(-26410),
                            INT16_C(  2455), INT16_C( 26533), INT16_C(-22278), INT16_C(-17612),
                            INT16_C(-31773), INT16_C(-17415), INT16_C(-11381), INT16_C( 18584),
                            INT16_C(  5214), INT16_C(-16991), INT16_C(-19646), INT16_C(-15650),
                            INT16_C(  6026), INT16_C( -9008), INT16_C(-29914), INT16_C(-16293),
                            INT16_C( -4575), INT16_C( 13865), INT16_C( 22784), INT16_C(  4279)) },
    { simde_mm512_set_epi16(INT16_C( -1121), INT16_C(-12579), INT16_C( 25193), INT16_C( 31374),
                            INT16_C( 24249), INT16_C( 31914), INT16_C(-22493), INT16_C( 26416),
                            INT16_C(-11519), INT16_C( -3516), INT16_C( 22878), INT16_C(-25026),
                            INT16_C(-29925), INT16_C(-17794), INT16_C( 12304), INT16_C(-29767),
                            INT16_C(  -946), INT16_C( 13585), INT16_C( -6006), INT16_C( 10696),
                            INT16_C( 11015), INT16_C(  7464), INT16_C(-24738), INT16_C(-14055),
                            INT16_C(-24830), INT16_C(-22403), INT16_C( 23605), INT16_C( 19959),
                            INT16_C( 30126), INT16_C(  6668), INT16_C( 28139), INT16_C(   733)),
      simde_mm512_set_epi16(INT16_C(-31722), INT16_C(-18221), INT16_C( 22162), INT16_C( 21694),
                            INT16_C( 16362), INT16_C(-13721), INT16_C( 15130), INT16_C( -1388),
                            INT16_C( 17819), INT16_C(-30469), INT16_C(  7229), INT16_C(  2509),
                            INT16_C(-23416), INT16_C( 15526), INT16_C(-10029), INT16_C( 28592),
                            INT16_C( -2245), INT16_C( -5080), INT16_C(-28491), INT16_C( 15185),
                            INT16_C(  8659), INT16_C(  2335), INT16_C( -9271), INT16_C(  4388),
                            INT16_C(-28238), INT16_C(  5718), INT16_C( 15189), INT16_C(-21879),
                            INT16_C(-31587), INT16_C(  7168), INT16_C( 18003), INT16_C(-14578)),
      simde_mm512_set_epi16(INT16_C( 32693), INT16_C(-30800), INT16_C(-18181), INT16_C(-12468),
                            INT16_C(-24925), INT16_C( 18193), INT16_C( -7363), INT16_C( 25028),
                            INT16_C(  6300), INT16_C( 31551), INT16_C( 30107), INT16_C(-22517),
                            INT16_C( 12195), INT16_C( -2268), INT16_C(  2275), INT16_C( -1175),
                            INT16_C( -3191), INT16_C(  8505), INT16_C( 31039), INT16_C( 25881),
                            INT16_C( 19674), INT16_C(  9799), INT16_C( 31527), INT16_C( -9667),
                            INT16_C( 12468), INT16_C(-16685), INT16_C(-26742), INT16_C( -1920),
                            INT16_C( -1461), INT16_C( 13836), INT16_C(-19394), INT16_C(-13845)) },
    { simde_mm512_set_epi16(INT16_C( 18722), INT16_C(  -631), INT16_C( 32064), INT16_C( 21877),
                            INT16_C( 28194), INT16_C(-13573), INT16_C( 32191), INT16_C(  6287),
                            INT16_C(-25755), INT16_C( 16399), INT16_C(-13811), INT16_C(  2883),
                            INT16_C( 16656), INT16_C(  9438), INT16_C(-25775), INT16_C( -7861),
                            INT16_C( -5440), INT16_C(-21346), INT16_C( -9636), INT16_C(  6052),
                            INT16_C(-16353), INT16_C(-24896), INT16_C( -3751), INT16_C( 28448),
                            INT16_C( 16173), INT16_C( 13758), INT16_C( 10762), INT16_C( -8847),
                            INT16_C( 30946), INT16_C( 24629), INT16_C( 27507), INT16_C(-29730)),
      simde_mm512_set_epi16(INT16_C(  8494), INT16_C(  1480), INT16_C(-14309), INT16_C( 10589),
                            INT16_C( 25606), INT16_C( 11689), INT16_C(  -248), INT16_C(-26265),
                            INT16_C(-21392), INT16_C(  5638), INT16_C( 12469), INT16_C( 14554),
                            INT16_C( 17419), INT16_C(-17055), INT16_C( -4627), INT16_C( -2872),
                            INT16_C( 21080), INT16_C(  5517), INT16_C(-18047), INT16_C( 23220),
                            INT16_C( 16689), INT16_C( 19312), INT16_C(-31347), INT16_C( 31388),
                            INT16_C( 31430), INT16_C( 16056), INT16_C(  9633), INT16_C(-17492),
                            INT16_C(-28330), INT16_C(-32115), INT16_C( 14219), INT16_C(  9672)),
      simde_mm512_set_epi16(INT16_C( 27216), INT16_C(   849), INT16_C( 17755), INT16_C( 32466),
                            INT16_C(-11736), INT16_C( -1884), INT16_C( 31943), INT16_C(-19978),
                            INT16_C( 18389), INT16_C( 22037), INT16_C( -1342), INT16_C( 17437),
                            INT16_C(-31461), INT16_C( -7617), INT16_C(-30402), INT16_C(-10733),
                            INT16_C( 15640), INT16_C(-15829), INT16_C(-27683), INT16_C( 29272),
                            INT16_C(   336), INT16_C( -5584), INT16_C( 30438), INT16_C( -5700),
                            INT16_C(-17933), INT16_C( 29814), INT16_C( 20395), INT16_C(-26339),
                            INT16_C(  2616), INT16_C( -7486), INT16_C(-23810), INT16_C(-20058)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_add_epi16(test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_i16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_adds_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C( -30), INT8_C( -16), INT8_C( -64), INT8_C( 113),
                           INT8_C(  51), INT8_C(-115), INT8_C(  19), INT8_C( -80),
                           INT8_C(-110), INT8_C( -62), INT8_C( -91), INT8_C(   8),
                           INT8_C(  11), INT8_C( -49), INT8_C( -43), INT8_C(-101),
                           INT8_C(  16), INT8_C(  61), INT8_C(  -2), INT8_C(-100),
                           INT8_C(   1), INT8_C( -80), INT8_C( 127), INT8_C(-105),
                           INT8_C( -74), INT8_C(-126), INT8_C( 122), INT8_C(  30),
                           INT8_C( -73), INT8_C(  48), INT8_C( -33), INT8_C(   2),
                           INT8_C( -82), INT8_C( -10), INT8_C(  33), INT8_C(  20),
                           INT8_C(-120), INT8_C(-120), INT8_C( -46), INT8_C( -54),
                           INT8_C( -43), INT8_C(  63), INT8_C(  81), INT8_C( 103),
                           INT8_C( 118), INT8_C( -84), INT8_C(  76), INT8_C(  47),
                           INT8_C( 101), INT8_C( -83), INT8_C(  15), INT8_C(  23),
                           INT8_C(  36), INT8_C(-116), INT8_C( -88), INT8_C( -45),
                           INT8_C(  -6), INT8_C(  86), INT8_C(  20), INT8_C(  39),
                           INT8_C( 117), INT8_C(  80), INT8_C(  97), INT8_C(  41)),
      simde_mm512_set_epi8(INT8_C( 122), INT8_C(  43), INT8_C(  38), INT8_C(  97),
                           INT8_C(  38), INT8_C(  68), INT8_C(  88), INT8_C(  56),
                           INT8_C( -39), INT8_C(  61), INT8_C( -57), INT8_C( -66),
                           INT8_C(-121), INT8_C(  29), INT8_C( 110), INT8_C( 127),
                           INT8_C(-115), INT8_C(  16), INT8_C( -46), INT8_C(  65),
                           INT8_C( -36), INT8_C(  26), INT8_C(  12), INT8_C( -79),
                           INT8_C( -66), INT8_C( -28), INT8_C( -67), INT8_C( -79),
                           INT8_C( -60), INT8_C( -13), INT8_C(  74), INT8_C(  25),
                           INT8_C(  46), INT8_C(   8), INT8_C(  70), INT8_C( 106),
                           INT8_C(-119), INT8_C(   0), INT8_C( -96), INT8_C( -51),
                           INT8_C( -50), INT8_C(  93), INT8_C(  92), INT8_C(  65),
                           INT8_C( -96), INT8_C(-126), INT8_C(   4), INT8_C(   9),
                           INT8_C(  26), INT8_C(-119), INT8_C(  93), INT8_C(  15),
                           INT8_C(-115), INT8_C(  77), INT8_C( 125), INT8_C( -62),
                           INT8_C(  77), INT8_C( -22), INT8_C( 101), INT8_C(  83),
                           INT8_C(  45), INT8_C( -68), INT8_C(  97), INT8_C( -19)),
      simde_mm512_set_epi8(INT8_C(  92), INT8_C(  27), INT8_C( -26), INT8_C( 127),
                           INT8_C(  89), INT8_C( -47), INT8_C( 107), INT8_C( -24),
                           INT8_C(-128), INT8_C(  -1), INT8_C(-128), INT8_C( -58),
                           INT8_C(-110), INT8_C( -20), INT8_C(  67), INT8_C(  26),
                           INT8_C( -99), INT8_C(  77), INT8_C( -48), INT8_C( -35),
                           INT8_C( -35), INT8_C( -54), INT8_C( 127), INT8_C(-128),
                           INT8_C(-128), INT8_C(-128), INT8_C(  55), INT8_C( -49),
                           INT8_C(-128), INT8_C(  35), INT8_C(  41), INT8_C(  27),
                           INT8_C( -36), INT8_C(  -2), INT8_C( 103), INT8_C( 126),
                           INT8_C(-128), INT8_C(-120), INT8_C(-128), INT8_C(-105),
                           INT8_C( -93), INT8_C( 127), INT8_C( 127), INT8_C( 127),
                           INT8_C(  22), INT8_C(-128), INT8_C(  80), INT8_C(  56),
                           INT8_C( 127), INT8_C(-128), INT8_C( 108), INT8_C(  38),
                           INT8_C( -79), INT8_C( -39), INT8_C(  37), INT8_C(-107),
                           INT8_C(  71), INT8_C(  64), INT8_C( 121), INT8_C( 122),
                           INT8_C( 127), INT8_C(  12), INT8_C( 127), INT8_C(  22)) },
    { simde_mm512_set_epi8(INT8_C(  60), INT8_C(  96), INT8_C(-106), INT8_C(-115),
                           INT8_C(  31), INT8_C(-108), INT8_C(  15), INT8_C(  63),
                           INT8_C( -77), INT8_C( 125), INT8_C(  41), INT8_C( -80),
                           INT8_C(  36), INT8_C(-118), INT8_C(-116), INT8_C( -63),
                           INT8_C( -44), INT8_C(  70), INT8_C(  99), INT8_C(  48),
                           INT8_C(  67), INT8_C(  43), INT8_C(  83), INT8_C(  53),
                           INT8_C(  60), INT8_C(  57), INT8_C(-118), INT8_C(  55),
                           INT8_C( -62), INT8_C( -42), INT8_C(  19), INT8_C(  52),
                           INT8_C( -37), INT8_C( -32), INT8_C(  33), INT8_C(-114),
                           INT8_C( -96), INT8_C(  53), INT8_C(  18), INT8_C( -37),
                           INT8_C(   6), INT8_C( -87), INT8_C( -11), INT8_C( -10),
                           INT8_C(  -4), INT8_C(  84), INT8_C( 104), INT8_C(  55),
                           INT8_C(  92), INT8_C( 117), INT8_C(  16), INT8_C( 115),
                           INT8_C(  83), INT8_C(  80), INT8_C(-125), INT8_C(  64),
                           INT8_C(  74), INT8_C(  -9), INT8_C( -62), INT8_C(  67),
                           INT8_C( 102), INT8_C(  66), INT8_C( -86), INT8_C(-112)),
      simde_mm512_set_epi8(INT8_C( -97), INT8_C(  52), INT8_C( -91), INT8_C(   7),
                           INT8_C(  -1), INT8_C( -19), INT8_C(  38), INT8_C(  15),
                           INT8_C(  76), INT8_C(  63), INT8_C(  10), INT8_C(  18),
                           INT8_C(  54), INT8_C(  73), INT8_C(  15), INT8_C( -54),
                           INT8_C(-114), INT8_C(  63), INT8_C(  44), INT8_C(   4),
                           INT8_C(  41), INT8_C(  90), INT8_C( -78), INT8_C( -67),
                           INT8_C(  95), INT8_C( -14), INT8_C( -10), INT8_C( -44),
                           INT8_C(  53), INT8_C( 102), INT8_C( 127), INT8_C( 120),
                           INT8_C( -89), INT8_C(  10), INT8_C( -36), INT8_C( -50),
                           INT8_C( 118), INT8_C(-106), INT8_C( -52), INT8_C(  76),
                           INT8_C(  66), INT8_C( -36), INT8_C( -79), INT8_C(  91),
                           INT8_C(  14), INT8_C( 103), INT8_C( -73), INT8_C(-123),
                           INT8_C(  68), INT8_C( -54), INT8_C(-103), INT8_C(  38),
                           INT8_C(  58), INT8_C(   0), INT8_C( -62), INT8_C( -76),
                           INT8_C(  93), INT8_C( 119), INT8_C(  14), INT8_C(  84),
                           INT8_C( -83), INT8_C(  76), INT8_C( -47), INT8_C( -53)),
      simde_mm512_set_epi8(INT8_C( -37), INT8_C( 127), INT8_C(-128), INT8_C(-108),
                           INT8_C(  30), INT8_C(-127), INT8_C(  53), INT8_C(  78),
                           INT8_C(  -1), INT8_C( 127), INT8_C(  51), INT8_C( -62),
                           INT8_C(  90), INT8_C( -45), INT8_C(-101), INT8_C(-117),
                           INT8_C(-128), INT8_C( 127), INT8_C( 127), INT8_C(  52),
                           INT8_C( 108), INT8_C( 127), INT8_C(   5), INT8_C( -14),
                           INT8_C( 127), INT8_C(  43), INT8_C(-128), INT8_C(  11),
                           INT8_C(  -9), INT8_C(  60), INT8_C( 127), INT8_C( 127),
                           INT8_C(-126), INT8_C( -22), INT8_C(  -3), INT8_C(-128),
                           INT8_C(  22), INT8_C( -53), INT8_C( -34), INT8_C(  39),
                           INT8_C(  72), INT8_C(-123), INT8_C( -90), INT8_C(  81),
                           INT8_C(  10), INT8_C( 127), INT8_C(  31), INT8_C( -68),
                           INT8_C( 127), INT8_C(  63), INT8_C( -87), INT8_C( 127),
                           INT8_C( 127), INT8_C(  80), INT8_C(-128), INT8_C( -12),
                           INT8_C( 127), INT8_C( 110), INT8_C( -48), INT8_C( 127),
                           INT8_C(  19), INT8_C( 127), INT8_C(-128), INT8_C(-128)) },
    { simde_mm512_set_epi8(INT8_C( -80), INT8_C( 122), INT8_C(-100), INT8_C( 123),
                           INT8_C(  82), INT8_C(-107), INT8_C(  95), INT8_C( -80),
                           INT8_C(-115), INT8_C(-109), INT8_C(  60), INT8_C(  72),
                           INT8_C(  57), INT8_C(  99), INT8_C( -30), INT8_C(-115),
                           INT8_C(  69), INT8_C(  18), INT8_C(  -5), INT8_C(  -6),
                           INT8_C( -90), INT8_C( -20), INT8_C(  17), INT8_C( 121),
                           INT8_C(-100), INT8_C( -55), INT8_C(  90), INT8_C( -42),
                           INT8_C(-113), INT8_C( 119), INT8_C(  44), INT8_C(-123),
                           INT8_C( -39), INT8_C( 114), INT8_C(  37), INT8_C( -84),
                           INT8_C( -88), INT8_C(  15), INT8_C(  23), INT8_C( 114),
                           INT8_C(  63), INT8_C( -61), INT8_C(  22), INT8_C(   8),
                           INT8_C(  54), INT8_C(  19), INT8_C( -34), INT8_C(  18),
                           INT8_C( -36), INT8_C( 104), INT8_C(   1), INT8_C(   5),
                           INT8_C(-116), INT8_C(  79), INT8_C( -20), INT8_C(  -4),
                           INT8_C(  95), INT8_C( 103), INT8_C(   3), INT8_C(  64),
                           INT8_C(  34), INT8_C( -49), INT8_C( -27), INT8_C(  41)),
      simde_mm512_set_epi8(INT8_C(  97), INT8_C(-116), INT8_C( -44), INT8_C( -44),
                           INT8_C(  67), INT8_C( -66), INT8_C(  77), INT8_C(  60),
                           INT8_C(  74), INT8_C( -19), INT8_C(-123), INT8_C( -81),
                           INT8_C( -74), INT8_C( -21), INT8_C( -32), INT8_C(-122),
                           INT8_C(-110), INT8_C( 116), INT8_C( 115), INT8_C(  99),
                           INT8_C(  29), INT8_C(  50), INT8_C(-119), INT8_C(-126),
                           INT8_C( -53), INT8_C(  68), INT8_C( -37), INT8_C(  84),
                           INT8_C(  23), INT8_C( -10), INT8_C(  15), INT8_C(  37),
                           INT8_C( -93), INT8_C(  57), INT8_C(  28), INT8_C(-116),
                           INT8_C(  56), INT8_C(-124), INT8_C( -93), INT8_C( -67),
                           INT8_C(  27), INT8_C(  -1), INT8_C( -70), INT8_C( -30),
                           INT8_C( -39), INT8_C(  59), INT8_C(  76), INT8_C( 108),
                           INT8_C(  13), INT8_C( -29), INT8_C(  60), INT8_C( 106),
                           INT8_C( 106), INT8_C( -77), INT8_C(-102), INT8_C(   3),
                           INT8_C( -18), INT8_C(  23), INT8_C( 113), INT8_C( -97),
                           INT8_C( 109), INT8_C(  81), INT8_C(  42), INT8_C(  93)),
      simde_mm512_set_epi8(INT8_C(  17), INT8_C(   6), INT8_C(-128), INT8_C(  79),
                           INT8_C( 127), INT8_C(-128), INT8_C( 127), INT8_C( -20),
                           INT8_C( -41), INT8_C(-128), INT8_C( -63), INT8_C(  -9),
                           INT8_C( -17), INT8_C(  78), INT8_C( -62), INT8_C(-128),
                           INT8_C( -41), INT8_C( 127), INT8_C( 110), INT8_C(  93),
                           INT8_C( -61), INT8_C(  30), INT8_C(-102), INT8_C(  -5),
                           INT8_C(-128), INT8_C(  13), INT8_C(  53), INT8_C(  42),
                           INT8_C( -90), INT8_C( 109), INT8_C(  59), INT8_C( -86),
                           INT8_C(-128), INT8_C( 127), INT8_C(  65), INT8_C(-128),
                           INT8_C( -32), INT8_C(-109), INT8_C( -70), INT8_C(  47),
                           INT8_C(  90), INT8_C( -62), INT8_C( -48), INT8_C( -22),
                           INT8_C(  15), INT8_C(  78), INT8_C(  42), INT8_C( 126),
                           INT8_C( -23), INT8_C(  75), INT8_C(  61), INT8_C( 111),
                           INT8_C( -10), INT8_C(   2), INT8_C(-122), INT8_C(  -1),
                           INT8_C(  77), INT8_C( 126), INT8_C( 116), INT8_C( -33),
                           INT8_C( 127), INT8_C(  32), INT8_C(  15), INT8_C( 127)) },
    { simde_mm512_set_epi8(INT8_C( -94), INT8_C(  96), INT8_C( -77), INT8_C( -55),
                           INT8_C(  18), INT8_C(  12), INT8_C(  78), INT8_C( -17),
                           INT8_C( -94), INT8_C(  83), INT8_C( -20), INT8_C(-101),
                           INT8_C( -62), INT8_C( -62), INT8_C( -77), INT8_C(  21),
                           INT8_C(  21), INT8_C( -49), INT8_C(-127), INT8_C( -47),
                           INT8_C( -26), INT8_C(  62), INT8_C( -51), INT8_C( -34),
                           INT8_C(   9), INT8_C( -56), INT8_C(  63), INT8_C(   4),
                           INT8_C(  64), INT8_C(  46), INT8_C(  68), INT8_C( -18),
                           INT8_C(-110), INT8_C( 103), INT8_C(-101), INT8_C(  45),
                           INT8_C( -81), INT8_C( 125), INT8_C(   8), INT8_C(  72),
                           INT8_C( -48), INT8_C( -28), INT8_C( 102), INT8_C( -90),
                           INT8_C(-101), INT8_C( -40), INT8_C( -94), INT8_C(-127),
                           INT8_C( -36), INT8_C( -32), INT8_C(  34), INT8_C( -39),
                           INT8_C( -64), INT8_C( 111), INT8_C(  36), INT8_C(  91),
                           INT8_C(  90), INT8_C( -10), INT8_C(  88), INT8_C(-117),
                           INT8_C( 117), INT8_C(-111), INT8_C(-128), INT8_C( -35)),
      simde_mm512_set_epi8(INT8_C(  65), INT8_C(  -2), INT8_C(   4), INT8_C( -77),
                           INT8_C(  33), INT8_C(-119), INT8_C( -36), INT8_C(  95),
                           INT8_C( -54), INT8_C(  57), INT8_C( -15), INT8_C(  20),
                           INT8_C( 119), INT8_C( -56), INT8_C( -57), INT8_C(  22),
                           INT8_C( -23), INT8_C( -56), INT8_C( -77), INT8_C( 114),
                           INT8_C( -25), INT8_C(  85), INT8_C(  65), INT8_C( 124),
                           INT8_C(  80), INT8_C(  94), INT8_C(  -6), INT8_C(-128),
                           INT8_C(  25), INT8_C( -80), INT8_C(  31), INT8_C( -23),
                           INT8_C( 123), INT8_C(-123), INT8_C( -56), INT8_C(  34),
                           INT8_C(  72), INT8_C( -39), INT8_C( -17), INT8_C(  39),
                           INT8_C(  29), INT8_C( -88), INT8_C(  65), INT8_C(  81),
                           INT8_C(-120), INT8_C(  80), INT8_C( -76), INT8_C( -59),
                           INT8_C(  48), INT8_C( -90), INT8_C( -85), INT8_C(  82),
                           INT8_C( 115), INT8_C(-114), INT8_C(  84), INT8_C( -40),
                           INT8_C( -69), INT8_C( -11), INT8_C(-118), INT8_C(  39),
                           INT8_C( -17), INT8_C( -23), INT8_C(   4), INT8_C( -37)),
      simde_mm512_set_epi8(INT8_C( -29), INT8_C(  94), INT8_C( -73), INT8_C(-128),
                           INT8_C(  51), INT8_C(-107), INT8_C(  42), INT8_C(  78),
                           INT8_C(-128), INT8_C( 127), INT8_C( -35), INT8_C( -81),
                           INT8_C(  57), INT8_C(-118), INT8_C(-128), INT8_C(  43),
                           INT8_C(  -2), INT8_C(-105), INT8_C(-128), INT8_C(  67),
                           INT8_C( -51), INT8_C( 127), INT8_C(  14), INT8_C(  90),
                           INT8_C(  89), INT8_C(  38), INT8_C(  57), INT8_C(-124),
                           INT8_C(  89), INT8_C( -34), INT8_C(  99), INT8_C( -41),
                           INT8_C(  13), INT8_C( -20), INT8_C(-128), INT8_C(  79),
                           INT8_C(  -9), INT8_C(  86), INT8_C(  -9), INT8_C( 111),
                           INT8_C( -19), INT8_C(-116), INT8_C( 127), INT8_C(  -9),
                           INT8_C(-128), INT8_C(  40), INT8_C(-128), INT8_C(-128),
                           INT8_C(  12), INT8_C(-122), INT8_C( -51), INT8_C(  43),
                           INT8_C(  51), INT8_C(  -3), INT8_C( 120), INT8_C(  51),
                           INT8_C(  21), INT8_C( -21), INT8_C( -30), INT8_C( -78),
                           INT8_C( 100), INT8_C(-128), INT8_C(-124), INT8_C( -72)) },
    { simde_mm512_set_epi8(INT8_C(  31), INT8_C( -81), INT8_C( 115), INT8_C(  18),
                           INT8_C(  20), INT8_C( -33), INT8_C(-125), INT8_C( -45),
                           INT8_C(  54), INT8_C(  82), INT8_C(  61), INT8_C(  81),
                           INT8_C( 123), INT8_C(  18), INT8_C(  89), INT8_C(  34),
                           INT8_C(  10), INT8_C( -54), INT8_C( -24), INT8_C(  54),
                           INT8_C(  49), INT8_C( -70), INT8_C(   7), INT8_C( -12),
                           INT8_C( 110), INT8_C( -16), INT8_C( -10), INT8_C(   4),
                           INT8_C(   3), INT8_C( -17), INT8_C( -46), INT8_C( -29),
                           INT8_C(  26), INT8_C( -38), INT8_C(-107), INT8_C( -25),
                           INT8_C(  61), INT8_C(  -4), INT8_C( -21), INT8_C( -11),
                           INT8_C( -29), INT8_C(  62), INT8_C( 120), INT8_C(  84),
                           INT8_C( -48), INT8_C( -42), INT8_C( -15), INT8_C( -64),
                           INT8_C( -90), INT8_C( 111), INT8_C(-123), INT8_C(  61),
                           INT8_C(  22), INT8_C( -48), INT8_C(-107), INT8_C( 122),
                           INT8_C(  27), INT8_C( 119), INT8_C( -63), INT8_C( -61),
                           INT8_C( -69), INT8_C(  46), INT8_C(  34), INT8_C(-101)),
      simde_mm512_set_epi8(INT8_C(  44), INT8_C( 101), INT8_C( -48), INT8_C( -49),
                           INT8_C(  63), INT8_C(  93), INT8_C( -48), INT8_C(-122),
                           INT8_C( -67), INT8_C(  27), INT8_C(   1), INT8_C( -55),
                           INT8_C( -79), INT8_C( -44), INT8_C(-115), INT8_C(-126),
                           INT8_C( -42), INT8_C(  29), INT8_C(  66), INT8_C( -83),
                           INT8_C( 108), INT8_C(  -1), INT8_C( -47), INT8_C(-104),
                           INT8_C(  62), INT8_C(  29), INT8_C(   4), INT8_C( -47),
                           INT8_C(  98), INT8_C(-109), INT8_C( -23), INT8_C(  69),
                           INT8_C(-110), INT8_C( -47), INT8_C(  48), INT8_C(-101),
                           INT8_C( -80), INT8_C(-110), INT8_C( -55), INT8_C(  25),
                           INT8_C(  39), INT8_C(  58), INT8_C(   4), INT8_C(-108),
                           INT8_C( -23), INT8_C( -79), INT8_C( 124), INT8_C(  36),
                           INT8_C( 113), INT8_C( 110), INT8_C( 105), INT8_C( 113),
                           INT8_C( -54), INT8_C( -63), INT8_C(  50), INT8_C( -99),
                           INT8_C(  -8), INT8_C( -76), INT8_C( 102), INT8_C(  51),
                           INT8_C(  58), INT8_C(  16), INT8_C( -94), INT8_C( -93)),
      simde_mm512_set_epi8(INT8_C(  75), INT8_C(  20), INT8_C(  67), INT8_C( -31),
                           INT8_C(  83), INT8_C(  60), INT8_C(-128), INT8_C(-128),
                           INT8_C( -13), INT8_C( 109), INT8_C(  62), INT8_C(  26),
                           INT8_C(  44), INT8_C( -26), INT8_C( -26), INT8_C( -92),
                           INT8_C( -32), INT8_C( -25), INT8_C(  42), INT8_C( -29),
                           INT8_C( 127), INT8_C( -71), INT8_C( -40), INT8_C(-116),
                           INT8_C( 127), INT8_C(  13), INT8_C(  -6), INT8_C( -43),
                           INT8_C( 101), INT8_C(-126), INT8_C( -69), INT8_C(  40),
                           INT8_C( -84), INT8_C( -85), INT8_C( -59), INT8_C(-126),
                           INT8_C( -19), INT8_C(-114), INT8_C( -76), INT8_C(  14),
                           INT8_C(  10), INT8_C( 120), INT8_C( 124), INT8_C( -24),
                           INT8_C( -71), INT8_C(-121), INT8_C( 109), INT8_C( -28),
                           INT8_C(  23), INT8_C( 127), INT8_C( -18), INT8_C( 127),
                           INT8_C( -32), INT8_C(-111), INT8_C( -57), INT8_C(  23),
                           INT8_C(  19), INT8_C(  43), INT8_C(  39), INT8_C( -10),
                           INT8_C( -11), INT8_C(  62), INT8_C( -60), INT8_C(-128)) },
    { simde_mm512_set_epi8(INT8_C(  64), INT8_C(  55), INT8_C(  97), INT8_C( -61),
                           INT8_C(  89), INT8_C( 120), INT8_C(  49), INT8_C( 124),
                           INT8_C(  16), INT8_C( 113), INT8_C(  48), INT8_C(  70),
                           INT8_C(  60), INT8_C( -11), INT8_C(  98), INT8_C(  70),
                           INT8_C( 111), INT8_C(  55), INT8_C( -50), INT8_C( -21),
                           INT8_C(-102), INT8_C(   3), INT8_C(  75), INT8_C(  -9),
                           INT8_C(  34), INT8_C(  96), INT8_C(-104), INT8_C(  37),
                           INT8_C(  74), INT8_C(  22), INT8_C(  13), INT8_C(  82),
                           INT8_C(-108), INT8_C(-112), INT8_C(  49), INT8_C( -58),
                           INT8_C( 116), INT8_C(  58), INT8_C( -29), INT8_C(  60),
                           INT8_C( 125), INT8_C( 105), INT8_C( -20), INT8_C(  -4),
                           INT8_C(-106), INT8_C(-111), INT8_C( -29), INT8_C( -32),
                           INT8_C( -43), INT8_C(-103), INT8_C(  84), INT8_C(  40),
                           INT8_C(  63), INT8_C(  88), INT8_C( -74), INT8_C( -49),
                           INT8_C(  10), INT8_C(  50), INT8_C(  38), INT8_C( 108),
                           INT8_C(  42), INT8_C( -40), INT8_C( -81), INT8_C(  31)),
      simde_mm512_set_epi8(INT8_C(-107), INT8_C( 105), INT8_C( -15), INT8_C( -49),
                           INT8_C(  74), INT8_C( -31), INT8_C( -49), INT8_C( 112),
                           INT8_C(-103), INT8_C(  69), INT8_C( -55), INT8_C(-115),
                           INT8_C( -48), INT8_C(  96), INT8_C(  -8), INT8_C( -35),
                           INT8_C( -24), INT8_C( 101), INT8_C(  70), INT8_C( -69),
                           INT8_C(-105), INT8_C( -28), INT8_C( -38), INT8_C( -85),
                           INT8_C( -94), INT8_C(-122), INT8_C( -80), INT8_C(  95),
                           INT8_C(  -1), INT8_C(  87), INT8_C(  21), INT8_C(   6),
                           INT8_C(-103), INT8_C(  38), INT8_C(  15), INT8_C( -98),
                           INT8_C( -27), INT8_C(  57), INT8_C( -76), INT8_C(-112),
                           INT8_C(  77), INT8_C(  -3), INT8_C(  57), INT8_C(   3),
                           INT8_C( 123), INT8_C( -18), INT8_C( -90), INT8_C(-119),
                           INT8_C( 112), INT8_C(  61), INT8_C( -48), INT8_C( -16),
                           INT8_C( -36), INT8_C(-125), INT8_C( -10), INT8_C(  77),
                           INT8_C( 106), INT8_C(  72), INT8_C(  62), INT8_C( -24),
                           INT8_C( -65), INT8_C( 102), INT8_C(-122), INT8_C(  19)),
      simde_mm512_set_epi8(INT8_C( -43), INT8_C( 127), INT8_C(  82), INT8_C(-110),
                           INT8_C( 127), INT8_C(  89), INT8_C(   0), INT8_C( 127),
                           INT8_C( -87), INT8_C( 127), INT8_C(  -7), INT8_C( -45),
                           INT8_C(  12), INT8_C(  85), INT8_C(  90), INT8_C(  35),
                           INT8_C(  87), INT8_C( 127), INT8_C(  20), INT8_C( -90),
                           INT8_C(-128), INT8_C( -25), INT8_C(  37), INT8_C( -94),
                           INT8_C( -60), INT8_C( -26), INT8_C(-128), INT8_C( 127),
                           INT8_C(  73), INT8_C( 109), INT8_C(  34), INT8_C(  88),
                           INT8_C(-128), INT8_C( -74), INT8_C(  64), INT8_C(-128),
                           INT8_C(  89), INT8_C( 115), INT8_C(-105), INT8_C( -52),
                           INT8_C( 127), INT8_C( 102), INT8_C(  37), INT8_C(  -1),
                           INT8_C(  17), INT8_C(-128), INT8_C(-119), INT8_C(-128),
                           INT8_C(  69), INT8_C( -42), INT8_C(  36), INT8_C(  24),
                           INT8_C(  27), INT8_C( -37), INT8_C( -84), INT8_C(  28),
                           INT8_C( 116), INT8_C( 122), INT8_C( 100), INT8_C(  84),
                           INT8_C( -23), INT8_C(  62), INT8_C(-128), INT8_C(  50)) },
    { simde_mm512_set_epi8(INT8_C(  90), INT8_C(-125), INT8_C(  -5), INT8_C( -69),
                           INT8_C( 103), INT8_C( -40), INT8_C(  35), INT8_C( -38),
                           INT8_C( 107), INT8_C(-117), INT8_C( -80), INT8_C( 123),
                           INT8_C(  57), INT8_C( -70), INT8_C( -34), INT8_C(  38),
                           INT8_C( 114), INT8_C(-126), INT8_C(  20), INT8_C( -93),
                           INT8_C(  17), INT8_C(-128), INT8_C(   2), INT8_C(  15),
                           INT8_C(-122), INT8_C( -10), INT8_C(  -2), INT8_C(  84),
                           INT8_C(  93), INT8_C(  89), INT8_C(  57), INT8_C( -50),
                           INT8_C(   4), INT8_C( -63), INT8_C( 118), INT8_C(  19),
                           INT8_C( -68), INT8_C( -29), INT8_C( -16), INT8_C( -30),
                           INT8_C( -76), INT8_C(-110), INT8_C( 121), INT8_C(  87),
                           INT8_C(-117), INT8_C(-113), INT8_C( -94), INT8_C(  61),
                           INT8_C( -29), INT8_C(  43), INT8_C( -69), INT8_C( 123),
                           INT8_C(  79), INT8_C(-101), INT8_C(  40), INT8_C(  64),
                           INT8_C(  34), INT8_C(-102), INT8_C(  77), INT8_C( 114),
                           INT8_C( -49), INT8_C( -31), INT8_C( 103), INT8_C(  81)),
      simde_mm512_set_epi8(INT8_C(  34), INT8_C(-125), INT8_C( -96), INT8_C(-111),
                           INT8_C(  23), INT8_C(  58), INT8_C(  -5), INT8_C( -22),
                           INT8_C( -80), INT8_C( -90), INT8_C( -33), INT8_C( -65),
                           INT8_C( -34), INT8_C( 100), INT8_C( -10), INT8_C( -57),
                           INT8_C(  37), INT8_C(  -9), INT8_C( -29), INT8_C(-114),
                           INT8_C(-102), INT8_C(  53), INT8_C( 107), INT8_C( 124),
                           INT8_C( -12), INT8_C( -57), INT8_C( -57), INT8_C( -37),
                           INT8_C(  50), INT8_C(  22), INT8_C( -71), INT8_C(  -2),
                           INT8_C( -31), INT8_C(  60), INT8_C(  62), INT8_C(  19),
                           INT8_C( 117), INT8_C(   1), INT8_C( -26), INT8_C(-100),
                           INT8_C(  29), INT8_C(  -6), INT8_C(   7), INT8_C(-100),
                           INT8_C(-120), INT8_C( -33), INT8_C(  17), INT8_C(-103),
                           INT8_C(  10), INT8_C( -45), INT8_C( -76), INT8_C(  10),
                           INT8_C( -10), INT8_C(  15), INT8_C(  36), INT8_C(   2),
                           INT8_C(  74), INT8_C(  44), INT8_C( -16), INT8_C( 122),
                           INT8_C(  -4), INT8_C(  15), INT8_C( -27), INT8_C( -15)),
      simde_mm512_set_epi8(INT8_C( 124), INT8_C(-128), INT8_C(-101), INT8_C(-128),
                           INT8_C( 126), INT8_C(  18), INT8_C(  30), INT8_C( -60),
                           INT8_C(  27), INT8_C(-128), INT8_C(-113), INT8_C(  58),
                           INT8_C(  23), INT8_C(  30), INT8_C( -44), INT8_C( -19),
                           INT8_C( 127), INT8_C(-128), INT8_C(  -9), INT8_C(-128),
                           INT8_C( -85), INT8_C( -75), INT8_C( 109), INT8_C( 127),
                           INT8_C(-128), INT8_C( -67), INT8_C( -59), INT8_C(  47),
                           INT8_C( 127), INT8_C( 111), INT8_C( -14), INT8_C( -52),
                           INT8_C( -27), INT8_C(  -3), INT8_C( 127), INT8_C(  38),
                           INT8_C(  49), INT8_C( -28), INT8_C( -42), INT8_C(-128),
                           INT8_C( -47), INT8_C(-116), INT8_C( 127), INT8_C( -13),
                           INT8_C(-128), INT8_C(-128), INT8_C( -77), INT8_C( -42),
                           INT8_C( -19), INT8_C(  -2), INT8_C(-128), INT8_C( 127),
                           INT8_C(  69), INT8_C( -86), INT8_C(  76), INT8_C(  66),
                           INT8_C( 108), INT8_C( -58), INT8_C(  61), INT8_C( 127),
                           INT8_C( -53), INT8_C( -16), INT8_C(  76), INT8_C(  66)) },
    { simde_mm512_set_epi8(INT8_C( -52), INT8_C(-111), INT8_C(  67), INT8_C( -14),
                           INT8_C(  11), INT8_C( -63), INT8_C( -35), INT8_C( -86),
                           INT8_C(-114), INT8_C( -97), INT8_C( 124), INT8_C( -30),
                           INT8_C(  -1), INT8_C(  55), INT8_C(  84), INT8_C(  12),
                           INT8_C(  86), INT8_C( -43), INT8_C(  81), INT8_C( -30),
                           INT8_C( -25), INT8_C(  74), INT8_C(-105), INT8_C(  11),
                           INT8_C( -97), INT8_C(   0), INT8_C(  98), INT8_C( 106),
                           INT8_C( -83), INT8_C( -89), INT8_C(  16), INT8_C( -42),
                           INT8_C(  81), INT8_C(  35), INT8_C(-127), INT8_C(-127),
                           INT8_C( -38), INT8_C(  51), INT8_C( -75), INT8_C(  24),
                           INT8_C(  86), INT8_C( -37), INT8_C(  97), INT8_C( -82),
                           INT8_C( 109), INT8_C(  21), INT8_C( 127), INT8_C(  16),
                           INT8_C( 101), INT8_C( -69), INT8_C(  95), INT8_C(-121),
                           INT8_C( -66), INT8_C(  39), INT8_C( 104), INT8_C(-109),
                           INT8_C(  -1), INT8_C(  35), INT8_C(  68), INT8_C(  93),
                           INT8_C( -25), INT8_C( 120), INT8_C( -19), INT8_C(  84)),
      simde_mm512_set_epi8(INT8_C(-111), INT8_C(-108), INT8_C( 102), INT8_C( -40),
                           INT8_C(-124), INT8_C( -61), INT8_C(  80), INT8_C( 102),
                           INT8_C( -35), INT8_C(   3), INT8_C( -76), INT8_C(  98),
                           INT8_C(   9), INT8_C( -39), INT8_C( -24), INT8_C( -92),
                           INT8_C( -73), INT8_C( -19), INT8_C(-103), INT8_C( -41),
                           INT8_C( -32), INT8_C(  -8), INT8_C( 126), INT8_C(  75),
                           INT8_C( -64), INT8_C( -26), INT8_C( -15), INT8_C( -35),
                           INT8_C( -20), INT8_C(  -6), INT8_C(  86), INT8_C( -56),
                           INT8_C( -56), INT8_C(  67), INT8_C(  59), INT8_C( -73),
                           INT8_C(  35), INT8_C( -67), INT8_C(  92), INT8_C(  34),
                           INT8_C(  16), INT8_C( -12), INT8_C(  44), INT8_C( -59),
                           INT8_C( -82), INT8_C(-102), INT8_C(  93), INT8_C( -43),
                           INT8_C(  79), INT8_C( -19), INT8_C( -45), INT8_C( -87),
                           INT8_C( -50), INT8_C( -23), INT8_C( -17), INT8_C( 110),
                           INT8_C( 102), INT8_C( -59), INT8_C(-117), INT8_C(  84),
                           INT8_C( -75), INT8_C(  87), INT8_C(  69), INT8_C(  -6)),
      simde_mm512_set_epi8(INT8_C(-128), INT8_C(-128), INT8_C( 127), INT8_C( -54),
                           INT8_C(-113), INT8_C(-124), INT8_C(  45), INT8_C(  16),
                           INT8_C(-128), INT8_C( -94), INT8_C(  48), INT8_C(  68),
                           INT8_C(   8), INT8_C(  16), INT8_C(  60), INT8_C( -80),
                           INT8_C(  13), INT8_C( -62), INT8_C( -22), INT8_C( -71),
                           INT8_C( -57), INT8_C(  66), INT8_C(  21), INT8_C(  86),
                           INT8_C(-128), INT8_C( -26), INT8_C(  83), INT8_C(  71),
                           INT8_C(-103), INT8_C( -95), INT8_C( 102), INT8_C( -98),
                           INT8_C(  25), INT8_C( 102), INT8_C( -68), INT8_C(-128),
                           INT8_C(  -3), INT8_C( -16), INT8_C(  17), INT8_C(  58),
                           INT8_C( 102), INT8_C( -49), INT8_C( 127), INT8_C(-128),
                           INT8_C(  27), INT8_C( -81), INT8_C( 127), INT8_C( -27),
                           INT8_C( 127), INT8_C( -88), INT8_C(  50), INT8_C(-128),
                           INT8_C(-116), INT8_C(  16), INT8_C(  87), INT8_C(   1),
                           INT8_C( 101), INT8_C( -24), INT8_C( -49), INT8_C( 127),
                           INT8_C(-100), INT8_C( 127), INT8_C(  50), INT8_C(  78)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_adds_epi8(test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_mask_adds_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i src;
    simde__mmask64 k;
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C(  92), INT8_C( 116), INT8_C( -78), INT8_C( -19),
                           INT8_C( -73), INT8_C(  22), INT8_C( -66), INT8_C( -29),
                           INT8_C(  55), INT8_C(  78), INT8_C( -45), INT8_C(-119),
                           INT8_C(  30), INT8_C( -29), INT8_C( -23), INT8_C(  89),
                           INT8_C(  15), INT8_C( 119), INT8_C( -88), INT8_C( 109),
                           INT8_C( -16), INT8_C( -10), INT8_C(   0), INT8_C( -18),
                           INT8_C(   1), INT8_C( 116), INT8_C(  62), INT8_C( -73),
                           INT8_C(-122), INT8_C(   0), INT8_C( 111), INT8_C(  95),
                           INT8_C( -20), INT8_C(   3), INT8_C( 122), INT8_C(-121),
                           INT8_C(  13), INT8_C(  25), INT8_C( -35), INT8_C(-127),
                           INT8_C(  82), INT8_C(  90), INT8_C(  53), INT8_C( 123),
                           INT8_C(  73), INT8_C( 108), INT8_C( -18), INT8_C(  15),
                           INT8_C(  81), INT8_C( -27), INT8_C( 102), INT8_C( 118),
                           INT8_C(  39), INT8_C( -77), INT8_C(  45), INT8_C(  81),
                           INT8_C( -17), INT8_C( -28), INT8_C(  67), INT8_C(-118),
                           INT8_C(  79), INT8_C(-113), INT8_C(-122), INT8_C( 124)),
      UINT64_C(10224647434006242820),
      simde_mm512_set_epi8(INT8_C(  68), INT8_C(-108), INT8_C(-121), INT8_C(-115),
                           INT8_C( -59), INT8_C( -78), INT8_C(-111), INT8_C(  56),
                           INT8_C(   9), INT8_C(-121), INT8_C( 120), INT8_C( -36),
                           INT8_C(  36), INT8_C(-103), INT8_C(-104), INT8_C(  25),
                           INT8_C(-111), INT8_C( -63), INT8_C( -35), INT8_C(-120),
                           INT8_C(  28), INT8_C( -44), INT8_C( -26), INT8_C( -86),
                           INT8_C( -13), INT8_C(  53), INT8_C( -88), INT8_C(-107),
                           INT8_C(  68), INT8_C(  42), INT8_C(-118), INT8_C( 111),
                           INT8_C(  54), INT8_C( -58), INT8_C( -13), INT8_C(  27),
                           INT8_C(  23), INT8_C(  41), INT8_C(-119), INT8_C(  44),
                           INT8_C(   7), INT8_C(-120), INT8_C(  32), INT8_C( -43),
                           INT8_C( 114), INT8_C( -72), INT8_C(  73), INT8_C( -96),
                           INT8_C(  96), INT8_C( 110), INT8_C( -81), INT8_C( -76),
                           INT8_C( 103), INT8_C(-100), INT8_C( -22), INT8_C(  18),
                           INT8_C( 115), INT8_C(  54), INT8_C( -40), INT8_C( 125),
                           INT8_C( 110), INT8_C(  31), INT8_C(  51), INT8_C(-104)),
      simde_mm512_set_epi8(INT8_C( -14), INT8_C(  85), INT8_C( -80), INT8_C(  80),
                           INT8_C(  48), INT8_C(  93), INT8_C(  79), INT8_C( 127),
                           INT8_C(  16), INT8_C(  41), INT8_C(  54), INT8_C(-116),
                           INT8_C(  17), INT8_C(  42), INT8_C( -86), INT8_C(  38),
                           INT8_C(-118), INT8_C( -56), INT8_C(  60), INT8_C(  19),
                           INT8_C(-100), INT8_C(-107), INT8_C( 105), INT8_C( -76),
                           INT8_C(  10), INT8_C(  -9), INT8_C( -12), INT8_C( -56),
                           INT8_C( -71), INT8_C(  96), INT8_C(   6), INT8_C(  24),
                           INT8_C(  69), INT8_C(  73), INT8_C( -27), INT8_C(   3),
                           INT8_C( -95), INT8_C(  50), INT8_C( -67), INT8_C( -39),
                           INT8_C(  97), INT8_C(  62), INT8_C( 101), INT8_C(  56),
                           INT8_C( -79), INT8_C(  83), INT8_C( -99), INT8_C( -56),
                           INT8_C( -17), INT8_C( -56), INT8_C(  -8), INT8_C( -16),
                           INT8_C(  84), INT8_C( -95), INT8_C( -73), INT8_C(  54),
                           INT8_C( 125), INT8_C(  85), INT8_C(  78), INT8_C( -65),
                           INT8_C(   4), INT8_C( 113), INT8_C( -16), INT8_C( -53)),
      simde_mm512_set_epi8(INT8_C(  54), INT8_C( 116), INT8_C( -78), INT8_C( -19),
                           INT8_C( -11), INT8_C(  15), INT8_C( -66), INT8_C( 127),
                           INT8_C(  25), INT8_C( -80), INT8_C( 127), INT8_C(-119),
                           INT8_C(  30), INT8_C( -61), INT8_C( -23), INT8_C(  63),
                           INT8_C(  15), INT8_C( 119), INT8_C(  25), INT8_C(-101),
                           INT8_C( -72), INT8_C(-128), INT8_C(  79), INT8_C( -18),
                           INT8_C(  -3), INT8_C( 116), INT8_C(-100), INT8_C( -73),
                           INT8_C(  -3), INT8_C(   0), INT8_C(-112), INT8_C( 127),
                           INT8_C( -20), INT8_C(   3), INT8_C( -40), INT8_C(  30),
                           INT8_C(  13), INT8_C(  25), INT8_C( -35), INT8_C(   5),
                           INT8_C( 104), INT8_C(  90), INT8_C(  53), INT8_C( 123),
                           INT8_C(  35), INT8_C(  11), INT8_C( -18), INT8_C(-128),
                           INT8_C(  81), INT8_C( -27), INT8_C( -89), INT8_C( 118),
                           INT8_C(  39), INT8_C(-128), INT8_C( -95), INT8_C(  81),
                           INT8_C( -17), INT8_C( -28), INT8_C(  67), INT8_C(-118),
                           INT8_C(  79), INT8_C( 127), INT8_C(-122), INT8_C( 124)) },
    { simde_mm512_set_epi8(INT8_C(-123), INT8_C(-100), INT8_C( -39), INT8_C( -44),
                           INT8_C(  22), INT8_C( 112), INT8_C(  16), INT8_C(  15),
                           INT8_C(-104), INT8_C(-102), INT8_C( 102), INT8_C( -95),
                           INT8_C(  69), INT8_C(  13), INT8_C( -21), INT8_C(  45),
                           INT8_C(  62), INT8_C(-120), INT8_C(-111), INT8_C(  32),
                           INT8_C(-107), INT8_C( -30), INT8_C(  99), INT8_C( -64),
                           INT8_C(   8), INT8_C( -42), INT8_C(  81), INT8_C( -34),
                           INT8_C( -46), INT8_C(  26), INT8_C(  31), INT8_C(  -2),
                           INT8_C(  68), INT8_C(  -7), INT8_C( -71), INT8_C(  46),
                           INT8_C( -21), INT8_C( -73), INT8_C(  21), INT8_C(  83),
                           INT8_C(-108), INT8_C( -97), INT8_C( -69), INT8_C(  73),
                           INT8_C(  57), INT8_C( -37), INT8_C(  21), INT8_C(  82),
                           INT8_C(-119), INT8_C(-126), INT8_C( 126), INT8_C(  91),
                           INT8_C( 115), INT8_C(  31), INT8_C( -79), INT8_C(  28),
                           INT8_C(-106), INT8_C( -18), INT8_C(  65), INT8_C(-104),
                           INT8_C(  81), INT8_C(  38), INT8_C( -84), INT8_C(  -2)),
      UINT64_C( 4597426592773770833),
      simde_mm512_set_epi8(INT8_C(  74), INT8_C(  72), INT8_C(  -4), INT8_C(  28),
                           INT8_C(-115), INT8_C(  93), INT8_C( 102), INT8_C(  44),
                           INT8_C(-103), INT8_C( -29), INT8_C( -50), INT8_C(  48),
                           INT8_C( -96), INT8_C( -50), INT8_C(  46), INT8_C( -65),
                           INT8_C(   4), INT8_C(  43), INT8_C( -75), INT8_C(  97),
                           INT8_C( -26), INT8_C(-103), INT8_C(  71), INT8_C(-107),
                           INT8_C(  91), INT8_C(  45), INT8_C( -11), INT8_C(  47),
                           INT8_C(  29), INT8_C(  25), INT8_C(  26), INT8_C(  -9),
                           INT8_C(  10), INT8_C(  36), INT8_C( -79), INT8_C( -53),
                           INT8_C(  41), INT8_C(   1), INT8_C( -23), INT8_C( -63),
                           INT8_C(-127), INT8_C(  68), INT8_C(  48), INT8_C(  36),
                           INT8_C(  89), INT8_C(-112), INT8_C( -31), INT8_C( 120),
                           INT8_C(  35), INT8_C(  62), INT8_C( -21), INT8_C(-114),
                           INT8_C(-104), INT8_C(  57), INT8_C(  42), INT8_C(-111),
                           INT8_C(  94), INT8_C( -63), INT8_C(  -9), INT8_C(  64),
                           INT8_C( -65), INT8_C(  -2), INT8_C( 110), INT8_C(  -8)),
      simde_mm512_set_epi8(INT8_C(  44), INT8_C( -92), INT8_C( -31), INT8_C(  26),
                           INT8_C( -99), INT8_C( -53), INT8_C( 117), INT8_C(  18),
                           INT8_C( -63), INT8_C(  45), INT8_C(  12), INT8_C(  24),
                           INT8_C(-108), INT8_C(  18), INT8_C( -60), INT8_C(  28),
                           INT8_C(  50), INT8_C( -11), INT8_C( -68), INT8_C( -31),
                           INT8_C( 105), INT8_C(-106), INT8_C(  98), INT8_C(  51),
                           INT8_C(  58), INT8_C( 103), INT8_C( 111), INT8_C(-127),
                           INT8_C(  68), INT8_C( -56), INT8_C( 124), INT8_C(-119),
                           INT8_C(  74), INT8_C( -62), INT8_C(-116), INT8_C(  37),
                           INT8_C( -12), INT8_C( 114), INT8_C(   0), INT8_C(  61),
                           INT8_C( 103), INT8_C(  -4), INT8_C(-105), INT8_C( -68),
                           INT8_C(  39), INT8_C(-100), INT8_C( -93), INT8_C(  11),
                           INT8_C( -80), INT8_C( -19), INT8_C( -22), INT8_C( -39),
                           INT8_C( 127), INT8_C( -38), INT8_C(-125), INT8_C(-111),
                           INT8_C(  84), INT8_C( -96), INT8_C(  87), INT8_C( -22),
                           INT8_C(  -5), INT8_C(  -3), INT8_C(-127), INT8_C(  41)),
      simde_mm512_set_epi8(INT8_C(-123), INT8_C(-100), INT8_C( -35), INT8_C(  54),
                           INT8_C(-128), INT8_C(  40), INT8_C( 127), INT8_C(  62),
                           INT8_C(-128), INT8_C(  16), INT8_C( 102), INT8_C( -95),
                           INT8_C(-128), INT8_C( -32), INT8_C( -21), INT8_C( -37),
                           INT8_C(  62), INT8_C(  32), INT8_C(-111), INT8_C(  66),
                           INT8_C(-107), INT8_C(-128), INT8_C( 127), INT8_C( -56),
                           INT8_C(   8), INT8_C( -42), INT8_C( 100), INT8_C( -34),
                           INT8_C( -46), INT8_C(  26), INT8_C(  31), INT8_C(  -2),
                           INT8_C(  84), INT8_C(  -7), INT8_C(-128), INT8_C( -16),
                           INT8_C(  29), INT8_C( 115), INT8_C( -23), INT8_C(  -2),
                           INT8_C(-108), INT8_C( -97), INT8_C( -57), INT8_C( -32),
                           INT8_C(  57), INT8_C(-128), INT8_C(-124), INT8_C( 127),
                           INT8_C(-119), INT8_C(-126), INT8_C( 126), INT8_C(  91),
                           INT8_C(  23), INT8_C(  19), INT8_C( -83), INT8_C(  28),
                           INT8_C(-106), INT8_C(-128), INT8_C(  65), INT8_C(  42),
                           INT8_C(  81), INT8_C(  38), INT8_C( -84), INT8_C(  33)) },
    { simde_mm512_set_epi8(INT8_C( -30), INT8_C( -37), INT8_C(  51), INT8_C( -36),
                           INT8_C(   8), INT8_C(  52), INT8_C(  97), INT8_C( 123),
                           INT8_C( -49), INT8_C(-124), INT8_C(  95), INT8_C( -83),
                           INT8_C(  70), INT8_C( -50), INT8_C( -61), INT8_C(  25),
                           INT8_C( -97), INT8_C(  28), INT8_C( -58), INT8_C(  11),
                           INT8_C( -14), INT8_C( 126), INT8_C(  81), INT8_C(  45),
                           INT8_C( -23), INT8_C( 120), INT8_C( -83), INT8_C( -16),
                           INT8_C(   7), INT8_C(  51), INT8_C( -57), INT8_C( -50),
                           INT8_C( -21), INT8_C(  98), INT8_C(  88), INT8_C(   0),
                           INT8_C( -66), INT8_C(   3), INT8_C( 124), INT8_C(-113),
                           INT8_C(  50), INT8_C(  88), INT8_C( -85), INT8_C( -93),
                           INT8_C( -44), INT8_C( -13), INT8_C( -94), INT8_C(  17),
                           INT8_C(  -2), INT8_C(  79), INT8_C(-116), INT8_C(  43),
                           INT8_C( -77), INT8_C(-125), INT8_C( -23), INT8_C(-120),
                           INT8_C(  96), INT8_C( -64), INT8_C( -23), INT8_C( -46),
                           INT8_C( -29), INT8_C( -71), INT8_C(  71), INT8_C(  90)),
      UINT64_C(12627002542648829104),
      simde_mm512_set_epi8(INT8_C(  56), INT8_C( -45), INT8_C(-108), INT8_C( -19),
                           INT8_C(-124), INT8_C( -27), INT8_C(  22), INT8_C( 126),
                           INT8_C(-106), INT8_C( -68), INT8_C( -60), INT8_C(   8),
                           INT8_C(  60), INT8_C(  93), INT8_C( -33), INT8_C( -27),
                           INT8_C(  -7), INT8_C(  27), INT8_C(-122), INT8_C( -38),
                           INT8_C(  23), INT8_C(   6), INT8_C(  45), INT8_C( -21),
                           INT8_C( -23), INT8_C(-101), INT8_C( 116), INT8_C( 127),
                           INT8_C(  96), INT8_C(  40), INT8_C( -97), INT8_C(  40),
                           INT8_C(  86), INT8_C( -44), INT8_C(  70), INT8_C( -71),
                           INT8_C(  62), INT8_C( -21), INT8_C(  66), INT8_C(  68),
                           INT8_C( -87), INT8_C( -61), INT8_C(  48), INT8_C( -70),
                           INT8_C(  18), INT8_C( -78), INT8_C( -98), INT8_C( 117),
                           INT8_C(  74), INT8_C(  32), INT8_C(  93), INT8_C( 125),
                           INT8_C( -47), INT8_C( -60), INT8_C( -86), INT8_C( 117),
                           INT8_C( 122), INT8_C( -54), INT8_C(  50), INT8_C( 123),
                           INT8_C( -31), INT8_C( -74), INT8_C( -64), INT8_C(  54)),
      simde_mm512_set_epi8(INT8_C( 115), INT8_C(  51), INT8_C( -91), INT8_C(  56),
                           INT8_C(  64), INT8_C( -39), INT8_C(-119), INT8_C( -28),
                           INT8_C( -54), INT8_C(  28), INT8_C(  54), INT8_C(  -8),
                           INT8_C( -54), INT8_C(-128), INT8_C( -28), INT8_C( -71),
                           INT8_C( 107), INT8_C( -66), INT8_C(-114), INT8_C( -88),
                           INT8_C(  34), INT8_C( -83), INT8_C( -21), INT8_C( -64),
                           INT8_C( 121), INT8_C( -20), INT8_C( -89), INT8_C( -94),
                           INT8_C( 112), INT8_C( -27), INT8_C(  81), INT8_C( -54),
                           INT8_C( -64), INT8_C(-114), INT8_C(  48), INT8_C( -89),
                           INT8_C( -61), INT8_C(  26), INT8_C(  43), INT8_C(  29),
                           INT8_C(   0), INT8_C(  64), INT8_C( 123), INT8_C( -67),
                           INT8_C(  15), INT8_C( 120), INT8_C(  36), INT8_C(  40),
                           INT8_C( 106), INT8_C(-118), INT8_C(-108), INT8_C( -58),
                           INT8_C(  26), INT8_C(-111), INT8_C(  63), INT8_C( -98),
                           INT8_C( -13), INT8_C( -12), INT8_C(-124), INT8_C(  96),
                           INT8_C( -13), INT8_C( -98), INT8_C(  99), INT8_C( -13)),
      simde_mm512_set_epi8(INT8_C( 127), INT8_C( -37), INT8_C(-128), INT8_C( -36),
                           INT8_C( -60), INT8_C( -66), INT8_C( -97), INT8_C(  98),
                           INT8_C( -49), INT8_C(-124), INT8_C(  -6), INT8_C(   0),
                           INT8_C(   6), INT8_C( -35), INT8_C( -61), INT8_C(  25),
                           INT8_C( -97), INT8_C(  28), INT8_C( -58), INT8_C(-126),
                           INT8_C(  57), INT8_C( -77), INT8_C(  24), INT8_C( -85),
                           INT8_C(  98), INT8_C(-121), INT8_C(  27), INT8_C( -16),
                           INT8_C( 127), INT8_C(  51), INT8_C( -57), INT8_C( -14),
                           INT8_C( -21), INT8_C(-128), INT8_C( 118), INT8_C(   0),
                           INT8_C(   1), INT8_C(   5), INT8_C( 124), INT8_C(-113),
                           INT8_C( -87), INT8_C(  88), INT8_C( -85), INT8_C( -93),
                           INT8_C(  33), INT8_C( -13), INT8_C( -94), INT8_C( 127),
                           INT8_C( 127), INT8_C(  79), INT8_C( -15), INT8_C(  43),
                           INT8_C( -77), INT8_C(-128), INT8_C( -23), INT8_C(-120),
                           INT8_C( 109), INT8_C( -64), INT8_C( -74), INT8_C( 127),
                           INT8_C( -29), INT8_C( -71), INT8_C(  71), INT8_C(  90)) },
    { simde_mm512_set_epi8(INT8_C(  72), INT8_C(  45), INT8_C( 120), INT8_C(  -5),
                           INT8_C(-109), INT8_C(  62), INT8_C(  17), INT8_C(  31),
                           INT8_C( -30), INT8_C( -58), INT8_C(  56), INT8_C(  21),
                           INT8_C(  72), INT8_C( -74), INT8_C( -40), INT8_C( 120),
                           INT8_C(  95), INT8_C( 108), INT8_C(  32), INT8_C(  64),
                           INT8_C(-128), INT8_C( 102), INT8_C( -21), INT8_C(  28),
                           INT8_C( 105), INT8_C(  52), INT8_C(  85), INT8_C(-104),
                           INT8_C(  57), INT8_C( -31), INT8_C( -38), INT8_C(-124),
                           INT8_C(-107), INT8_C(  -2), INT8_C(  55), INT8_C(  46),
                           INT8_C( -71), INT8_C(  77), INT8_C(  18), INT8_C(  70),
                           INT8_C(  89), INT8_C( 125), INT8_C( -42), INT8_C(-125),
                           INT8_C( 121), INT8_C( -11), INT8_C( -69), INT8_C( -59),
                           INT8_C( -53), INT8_C(  34), INT8_C(   9), INT8_C(  64),
                           INT8_C( -61), INT8_C( -25), INT8_C(-115), INT8_C( 100),
                           INT8_C(  65), INT8_C(   8), INT8_C(  69), INT8_C(  -8),
                           INT8_C( -15), INT8_C( -51), INT8_C(   1), INT8_C(  90)),
      UINT64_C(14515151237088493607),
      simde_mm512_set_epi8(INT8_C( -26), INT8_C(  -9), INT8_C(  66), INT8_C(   1),
                           INT8_C( -13), INT8_C(  60), INT8_C(-119), INT8_C( -83),
                           INT8_C(-122), INT8_C( -64), INT8_C( -83), INT8_C( -74),
                           INT8_C( 119), INT8_C(  -8), INT8_C(  12), INT8_C( 113),
                           INT8_C( -12), INT8_C( -84), INT8_C(   6), INT8_C(  69),
                           INT8_C(   2), INT8_C( -75), INT8_C( -34), INT8_C(-126),
                           INT8_C(   3), INT8_C(-128), INT8_C(  -9), INT8_C(  24),
                           INT8_C(  11), INT8_C( -94), INT8_C( -32), INT8_C( 110),
                           INT8_C(  33), INT8_C( -24), INT8_C( 125), INT8_C(  35),
                           INT8_C(-103), INT8_C( -48), INT8_C( -22), INT8_C(  38),
                           INT8_C( -81), INT8_C(   9), INT8_C( -11), INT8_C(-124),
                           INT8_C(  71), INT8_C(  31), INT8_C( -42), INT8_C(  93),
                           INT8_C(  67), INT8_C(  45), INT8_C(  51), INT8_C( -92),
                           INT8_C( 126), INT8_C( 108), INT8_C(-123), INT8_C( -71),
                           INT8_C( 113), INT8_C(  32), INT8_C(  71), INT8_C(  55),
                           INT8_C( -26), INT8_C(  82), INT8_C( -81), INT8_C( -20)),
      simde_mm512_set_epi8(INT8_C(-125), INT8_C( 121), INT8_C(-128), INT8_C( 103),
                           INT8_C(   0), INT8_C( 101), INT8_C( -41), INT8_C(  89),
                           INT8_C( -83), INT8_C( -65), INT8_C(   9), INT8_C(  -7),
                           INT8_C( -63), INT8_C(  13), INT8_C( 105), INT8_C(  92),
                           INT8_C( -18), INT8_C( -21), INT8_C(-102), INT8_C(-114),
                           INT8_C(  74), INT8_C( 121), INT8_C( -45), INT8_C(  52),
                           INT8_C( -63), INT8_C( -93), INT8_C(  98), INT8_C( 106),
                           INT8_C(-109), INT8_C( -47), INT8_C(  37), INT8_C(  70),
                           INT8_C( 100), INT8_C( 121), INT8_C(  18), INT8_C(  28),
                           INT8_C(-117), INT8_C( 107), INT8_C(   3), INT8_C( -62),
                           INT8_C(  42), INT8_C(  72), INT8_C(  91), INT8_C(  86),
                           INT8_C( -72), INT8_C(   9), INT8_C( -80), INT8_C( 118),
                           INT8_C( 122), INT8_C(-108), INT8_C( -70), INT8_C( -63),
                           INT8_C(  56), INT8_C(  71), INT8_C( -14), INT8_C(  49),
                           INT8_C( -73), INT8_C(  53), INT8_C( -29), INT8_C(   3),
                           INT8_C( -73), INT8_C(  43), INT8_C( -22), INT8_C(  85)),
      simde_mm512_set_epi8(INT8_C(-128), INT8_C( 112), INT8_C( 120), INT8_C(  -5),
                           INT8_C( -13), INT8_C(  62), INT8_C(  17), INT8_C(   6),
                           INT8_C( -30), INT8_C(-128), INT8_C( -74), INT8_C( -81),
                           INT8_C(  72), INT8_C( -74), INT8_C( -40), INT8_C( 120),
                           INT8_C(  95), INT8_C( 108), INT8_C( -96), INT8_C(  64),
                           INT8_C(  76), INT8_C(  46), INT8_C( -21), INT8_C( -74),
                           INT8_C( 105), INT8_C(  52), INT8_C(  89), INT8_C(-104),
                           INT8_C(  57), INT8_C(-128), INT8_C( -38), INT8_C( 127),
                           INT8_C(-107), INT8_C(  97), INT8_C(  55), INT8_C(  46),
                           INT8_C( -71), INT8_C(  77), INT8_C( -19), INT8_C( -24),
                           INT8_C( -39), INT8_C( 125), INT8_C(  80), INT8_C( -38),
                           INT8_C(  -1), INT8_C( -11), INT8_C(-122), INT8_C( 127),
                           INT8_C( -53), INT8_C( -63), INT8_C(   9), INT8_C(  64),
                           INT8_C( -61), INT8_C( -25), INT8_C(-115), INT8_C( 100),
                           INT8_C(  65), INT8_C(   8), INT8_C(  42), INT8_C(  -8),
                           INT8_C( -15), INT8_C( 125), INT8_C(-103), INT8_C(  65)) },
    { simde_mm512_set_epi8(INT8_C( -47), INT8_C(  84), INT8_C(-126), INT8_C( -64),
                           INT8_C(  14), INT8_C(  11), INT8_C(  37), INT8_C( -23),
                           INT8_C(  67), INT8_C( 124), INT8_C(  58), INT8_C( -94),
                           INT8_C(  30), INT8_C( -33), INT8_C(  70), INT8_C( -24),
                           INT8_C(  38), INT8_C( -97), INT8_C( -56), INT8_C( -60),
                           INT8_C( -59), INT8_C(  65), INT8_C( -74), INT8_C(  45),
                           INT8_C( -11), INT8_C(  55), INT8_C( -82), INT8_C(  12),
                           INT8_C( 106), INT8_C(  22), INT8_C(-124), INT8_C(  -4),
                           INT8_C(   2), INT8_C( -81), INT8_C(  14), INT8_C(  90),
                           INT8_C(-100), INT8_C(-122), INT8_C( -35), INT8_C(  81),
                           INT8_C( -14), INT8_C( -42), INT8_C( 125), INT8_C(-125),
                           INT8_C( -57), INT8_C(  90), INT8_C(  -9), INT8_C(  63),
                           INT8_C(  53), INT8_C(  77), INT8_C(  63), INT8_C( -84),
                           INT8_C(  27), INT8_C(  22), INT8_C(   3), INT8_C( -37),
                           INT8_C(  65), INT8_C( 118), INT8_C(-126), INT8_C(  97),
                           INT8_C( 109), INT8_C(   7), INT8_C(-114), INT8_C( -75)),
      UINT64_C( 8707623543556880126),
      simde_mm512_set_epi8(INT8_C(  84), INT8_C( -71), INT8_C(   8), INT8_C(  12),
                           INT8_C( -11), INT8_C( -76), INT8_C(  62), INT8_C(  93),
                           INT8_C( -75), INT8_C( -77), INT8_C( -84), INT8_C(-108),
                           INT8_C( -35), INT8_C(  14), INT8_C( -60), INT8_C(  18),
                           INT8_C(  23), INT8_C( -60), INT8_C( -63), INT8_C(-114),
                           INT8_C( -55), INT8_C(  75), INT8_C( -99), INT8_C( -55),
                           INT8_C(  58), INT8_C(  76), INT8_C(-102), INT8_C(-118),
                           INT8_C( -30), INT8_C(  39), INT8_C( 119), INT8_C(  85),
                           INT8_C(  -8), INT8_C( -72), INT8_C( -60), INT8_C( -94),
                           INT8_C(-112), INT8_C( 119), INT8_C( 124), INT8_C(  76),
                           INT8_C( -42), INT8_C(-124), INT8_C(  54), INT8_C(  74),
                           INT8_C( -92), INT8_C(  99), INT8_C(  79), INT8_C(  -3),
                           INT8_C(  61), INT8_C( -89), INT8_C(  84), INT8_C( -94),
                           INT8_C(  31), INT8_C(-116), INT8_C( -67), INT8_C(-102),
                           INT8_C( -72), INT8_C( -91), INT8_C(-105), INT8_C(-108),
                           INT8_C( -44), INT8_C(  74), INT8_C( -28), INT8_C( 124)),
      simde_mm512_set_epi8(INT8_C(   1), INT8_C(  75), INT8_C(  21), INT8_C( -36),
                           INT8_C(-126), INT8_C( 122), INT8_C(  71), INT8_C(  76),
                           INT8_C(  28), INT8_C( -56), INT8_C(  32), INT8_C( 101),
                           INT8_C(-107), INT8_C(-111), INT8_C( -88), INT8_C( -19),
                           INT8_C( -77), INT8_C(  19), INT8_C( -21), INT8_C(-111),
                           INT8_C( -68), INT8_C(  82), INT8_C(-118), INT8_C( -76),
                           INT8_C(  47), INT8_C( 127), INT8_C(  62), INT8_C( -16),
                           INT8_C(  10), INT8_C( -14), INT8_C(-100), INT8_C(  86),
                           INT8_C(  29), INT8_C( 107), INT8_C(  56), INT8_C(  21),
                           INT8_C(  24), INT8_C(  68), INT8_C( -96), INT8_C(  64),
                           INT8_C(  48), INT8_C(  13), INT8_C( -83), INT8_C(   4),
                           INT8_C(  -3), INT8_C( -64), INT8_C(  17), INT8_C(-115),
                           INT8_C(  21), INT8_C( 108), INT8_C( 125), INT8_C( -60),
                           INT8_C( -72), INT8_C(  74), INT8_C(  -5), INT8_C( -58),
                           INT8_C( -41), INT8_C(  22), INT8_C(-115), INT8_C( 102),
                           INT8_C(  59), INT8_C( -80), INT8_C( -15), INT8_C( -63)),
      simde_mm512_set_epi8(INT8_C( -47), INT8_C(   4), INT8_C(  29), INT8_C( -24),
                           INT8_C(-128), INT8_C(  11), INT8_C(  37), INT8_C( -23),
                           INT8_C( -47), INT8_C(-128), INT8_C(  58), INT8_C(  -7),
                           INT8_C(  30), INT8_C( -97), INT8_C(-128), INT8_C(  -1),
                           INT8_C( -54), INT8_C( -97), INT8_C( -84), INT8_C(-128),
                           INT8_C( -59), INT8_C(  65), INT8_C( -74), INT8_C(-128),
                           INT8_C( -11), INT8_C( 127), INT8_C( -40), INT8_C(-128),
                           INT8_C( -20), INT8_C(  22), INT8_C(  19), INT8_C(  -4),
                           INT8_C(   2), INT8_C(  35), INT8_C(  14), INT8_C( -73),
                           INT8_C(-100), INT8_C( 127), INT8_C(  28), INT8_C( 127),
                           INT8_C(   6), INT8_C( -42), INT8_C( 125), INT8_C(-125),
                           INT8_C( -95), INT8_C(  90), INT8_C(  -9), INT8_C(-118),
                           INT8_C(  53), INT8_C(  77), INT8_C( 127), INT8_C(-128),
                           INT8_C(  27), INT8_C( -42), INT8_C( -72), INT8_C( -37),
                           INT8_C(-113), INT8_C( -69), INT8_C(-128), INT8_C(  -6),
                           INT8_C(  15), INT8_C(  -6), INT8_C( -43), INT8_C( -75)) },
    { simde_mm512_set_epi8(INT8_C( -64), INT8_C( -53), INT8_C( -42), INT8_C( 126),
                           INT8_C(  67), INT8_C(  50), INT8_C( -18), INT8_C(  76),
                           INT8_C( -19), INT8_C( 123), INT8_C( -87), INT8_C( 106),
                           INT8_C( -74), INT8_C(  44), INT8_C( 117), INT8_C( 103),
                           INT8_C(  81), INT8_C( 122), INT8_C(  56), INT8_C( -10),
                           INT8_C(  67), INT8_C(  79), INT8_C(  83), INT8_C( -38),
                           INT8_C( -13), INT8_C(  43), INT8_C(  27), INT8_C( -97),
                           INT8_C( 102), INT8_C( 126), INT8_C(  38), INT8_C( -62),
                           INT8_C( -24), INT8_C( 117), INT8_C( -38), INT8_C( -93),
                           INT8_C( -58), INT8_C(-124), INT8_C( -75), INT8_C(  10),
                           INT8_C(  18), INT8_C( -74), INT8_C(  14), INT8_C(  36),
                           INT8_C(  -7), INT8_C( 113), INT8_C(  40), INT8_C(  48),
                           INT8_C(-107), INT8_C( -34), INT8_C( -75), INT8_C(  85),
                           INT8_C( -35), INT8_C(-116), INT8_C(  65), INT8_C( -21),
                           INT8_C(  15), INT8_C(   3), INT8_C(  45), INT8_C(  21),
                           INT8_C(  72), INT8_C(  93), INT8_C( 108), INT8_C( 125)),
      UINT64_C(12576710173448868104),
      simde_mm512_set_epi8(INT8_C(  90), INT8_C( -38), INT8_C( -98), INT8_C( -70),
                           INT8_C(-108), INT8_C(  20), INT8_C(  43), INT8_C(-128),
                           INT8_C(  77), INT8_C( 108), INT8_C(  53), INT8_C(  82),
                           INT8_C( -50), INT8_C(  52), INT8_C(  56), INT8_C(  58),
                           INT8_C(-120), INT8_C( -43), INT8_C( 114), INT8_C(  93),
                           INT8_C( -44), INT8_C( -15), INT8_C(  38), INT8_C( -17),
                           INT8_C(-110), INT8_C(-123), INT8_C( -39), INT8_C( 114),
                           INT8_C(  51), INT8_C(-115), INT8_C( -74), INT8_C(  43),
                           INT8_C(  41), INT8_C( -36), INT8_C(  19), INT8_C(  69),
                           INT8_C(  60), INT8_C( -53), INT8_C( 112), INT8_C( 108),
                           INT8_C(   8), INT8_C(  46), INT8_C( -35), INT8_C(  26),
                           INT8_C(  11), INT8_C(  42), INT8_C(  47), INT8_C(  59),
                           INT8_C( -57), INT8_C(  94), INT8_C(-125), INT8_C(-124),
                           INT8_C(  36), INT8_C(  57), INT8_C(  68), INT8_C( -52),
                           INT8_C(  39), INT8_C(  50), INT8_C( -48), INT8_C(  94),
                           INT8_C(  53), INT8_C(  11), INT8_C(  29), INT8_C(  65)),
      simde_mm512_set_epi8(INT8_C(-107), INT8_C( 120), INT8_C( -58), INT8_C( 107),
                           INT8_C( -32), INT8_C( -32), INT8_C(  88), INT8_C( -43),
                           INT8_C(  31), INT8_C( -32), INT8_C( -64), INT8_C(  27),
                           INT8_C(  82), INT8_C( -90), INT8_C( -54), INT8_C( -84),
                           INT8_C( -30), INT8_C(  63), INT8_C(  24), INT8_C(  81),
                           INT8_C(  -8), INT8_C(   9), INT8_C( -35), INT8_C(-101),
                           INT8_C(  83), INT8_C( 107), INT8_C( -47), INT8_C( -56),
                           INT8_C(  57), INT8_C( -88), INT8_C(-115), INT8_C( -20),
                           INT8_C(  58), INT8_C(  75), INT8_C(  56), INT8_C(  93),
                           INT8_C(  49), INT8_C(  43), INT8_C( 108), INT8_C( 118),
                           INT8_C( -79), INT8_C( 112), INT8_C(  44), INT8_C(-112),
                           INT8_C( -52), INT8_C(  10), INT8_C(  28), INT8_C( -86),
                           INT8_C(  65), INT8_C(  62), INT8_C(  86), INT8_C(-107),
                           INT8_C(  24), INT8_C( -55), INT8_C(  54), INT8_C(-110),
                           INT8_C( -33), INT8_C( 110), INT8_C(-116), INT8_C( -39),
                           INT8_C(  39), INT8_C(-112), INT8_C(  64), INT8_C(  43)),
      simde_mm512_set_epi8(INT8_C( -17), INT8_C( -53), INT8_C(-128), INT8_C( 126),
                           INT8_C(-128), INT8_C( -12), INT8_C( 127), INT8_C(  76),
                           INT8_C( 108), INT8_C( 123), INT8_C( -87), INT8_C( 106),
                           INT8_C(  32), INT8_C(  44), INT8_C( 117), INT8_C( -26),
                           INT8_C(  81), INT8_C(  20), INT8_C( 127), INT8_C( 127),
                           INT8_C(  67), INT8_C(  79), INT8_C(   3), INT8_C(-118),
                           INT8_C( -13), INT8_C( -16), INT8_C(  27), INT8_C( -97),
                           INT8_C( 102), INT8_C(-128), INT8_C(  38), INT8_C( -62),
                           INT8_C(  99), INT8_C( 117), INT8_C(  75), INT8_C( 127),
                           INT8_C( 109), INT8_C(-124), INT8_C( 127), INT8_C( 127),
                           INT8_C(  18), INT8_C( 127), INT8_C(   9), INT8_C( -86),
                           INT8_C(  -7), INT8_C(  52), INT8_C(  75), INT8_C(  48),
                           INT8_C(-107), INT8_C( -34), INT8_C( -75), INT8_C(-128),
                           INT8_C( -35), INT8_C(-116), INT8_C(  65), INT8_C(-128),
                           INT8_C(  15), INT8_C(   3), INT8_C(  45), INT8_C(  21),
                           INT8_C(  92), INT8_C(  93), INT8_C( 108), INT8_C( 125)) },
    { simde_mm512_set_epi8(INT8_C(-103), INT8_C(-124), INT8_C(  13), INT8_C( -80),
                           INT8_C( -32), INT8_C( 123), INT8_C( 115), INT8_C( -49),
                           INT8_C( 113), INT8_C( -51), INT8_C( 119), INT8_C( -67),
                           INT8_C( -21), INT8_C(  19), INT8_C( -12), INT8_C(  29),
                           INT8_C(  91), INT8_C( -64), INT8_C(  88), INT8_C(-105),
                           INT8_C(  24), INT8_C(  31), INT8_C(  77), INT8_C(  92),
                           INT8_C( -85), INT8_C(  48), INT8_C(-113), INT8_C(-114),
                           INT8_C(  16), INT8_C(  18), INT8_C( -44), INT8_C( -66),
                           INT8_C(  25), INT8_C(-105), INT8_C(-100), INT8_C( -91),
                           INT8_C(  26), INT8_C(-123), INT8_C( -33), INT8_C( -37),
                           INT8_C(  63), INT8_C(  13), INT8_C(-124), INT8_C(  41),
                           INT8_C(-104), INT8_C( -59), INT8_C(  -2), INT8_C( -54),
                           INT8_C(  73), INT8_C(   3), INT8_C( -18), INT8_C(  10),
                           INT8_C(  19), INT8_C(  58), INT8_C( -12), INT8_C( -75),
                           INT8_C( -88), INT8_C(  59), INT8_C( 104), INT8_C( -40),
                           INT8_C( -82), INT8_C(  42), INT8_C( -73), INT8_C( -94)),
      UINT64_C( 2633789449456316803),
      simde_mm512_set_epi8(INT8_C( 118), INT8_C(  44), INT8_C( -14), INT8_C(  84),
                           INT8_C( -69), INT8_C( -48), INT8_C(  40), INT8_C(  86),
                           INT8_C(  -1), INT8_C( 121), INT8_C( -40), INT8_C(  44),
                           INT8_C(  -1), INT8_C(  38), INT8_C( -44), INT8_C(  38),
                           INT8_C(  93), INT8_C(-107), INT8_C(  -4), INT8_C( -61),
                           INT8_C( -52), INT8_C(  22), INT8_C( -54), INT8_C(-125),
                           INT8_C( -29), INT8_C(  25), INT8_C( -77), INT8_C( -68),
                           INT8_C(   9), INT8_C( -35), INT8_C( -11), INT8_C(  53),
                           INT8_C(  28), INT8_C(  61), INT8_C( -35), INT8_C(-106),
                           INT8_C( -46), INT8_C( 121), INT8_C(-102), INT8_C( 121),
                           INT8_C( -54), INT8_C( -60), INT8_C(   7), INT8_C(   2),
                           INT8_C(-119), INT8_C( 111), INT8_C( -20), INT8_C( -58),
                           INT8_C( -98), INT8_C(  83), INT8_C(  32), INT8_C( -49),
                           INT8_C( -11), INT8_C(  48), INT8_C(  92), INT8_C(  47),
                           INT8_C( -38), INT8_C(  11), INT8_C(  26), INT8_C(  90),
                           INT8_C(  -5), INT8_C(  73), INT8_C(  45), INT8_C(  -2)),
      simde_mm512_set_epi8(INT8_C( -31), INT8_C( 126), INT8_C(-118), INT8_C( -57),
                           INT8_C(-126), INT8_C(  29), INT8_C( 101), INT8_C( -15),
                           INT8_C( -61), INT8_C( 118), INT8_C( 102), INT8_C(  12),
                           INT8_C( -59), INT8_C( -41), INT8_C( -60), INT8_C(  46),
                           INT8_C(  63), INT8_C(  78), INT8_C(  87), INT8_C(  18),
                           INT8_C(  18), INT8_C(  32), INT8_C( -26), INT8_C(  -6),
                           INT8_C( -20), INT8_C(-123), INT8_C(  99), INT8_C(  65),
                           INT8_C(  13), INT8_C(  25), INT8_C( 108), INT8_C(-121),
                           INT8_C(  42), INT8_C(   0), INT8_C( 104), INT8_C( -17),
                           INT8_C( 111), INT8_C(-110), INT8_C( -39), INT8_C( 125),
                           INT8_C( -50), INT8_C( -47), INT8_C(  30), INT8_C(  92),
                           INT8_C(  19), INT8_C(  -8), INT8_C(-120), INT8_C( 127),
                           INT8_C( -49), INT8_C(  23), INT8_C(  16), INT8_C( -64),
                           INT8_C( -79), INT8_C( 116), INT8_C(  -5), INT8_C( -50),
                           INT8_C(  32), INT8_C(  22), INT8_C( -42), INT8_C(  -3),
                           INT8_C(  30), INT8_C(  64), INT8_C(  96), INT8_C( -66)),
      simde_mm512_set_epi8(INT8_C(-103), INT8_C(-124), INT8_C(-128), INT8_C( -80),
                           INT8_C( -32), INT8_C( -19), INT8_C( 115), INT8_C( -49),
                           INT8_C( -62), INT8_C( -51), INT8_C( 119), INT8_C( -67),
                           INT8_C( -60), INT8_C(  -3), INT8_C( -12), INT8_C(  84),
                           INT8_C(  91), INT8_C( -64), INT8_C(  88), INT8_C( -43),
                           INT8_C( -34), INT8_C(  31), INT8_C(  77), INT8_C(-128),
                           INT8_C( -49), INT8_C(  48), INT8_C(-113), INT8_C(-114),
                           INT8_C(  22), INT8_C( -10), INT8_C( -44), INT8_C( -66),
                           INT8_C(  70), INT8_C(  61), INT8_C(-100), INT8_C( -91),
                           INT8_C(  26), INT8_C(  11), INT8_C( -33), INT8_C( -37),
                           INT8_C(  63), INT8_C(  13), INT8_C(-124), INT8_C(  41),
                           INT8_C(-104), INT8_C( -59), INT8_C(-128), INT8_C(  69),
                           INT8_C(-128), INT8_C( 106), INT8_C(  48), INT8_C(-113),
                           INT8_C(  19), INT8_C(  58), INT8_C( -12), INT8_C(  -3),
                           INT8_C(  -6), INT8_C(  59), INT8_C( 104), INT8_C( -40),
                           INT8_C( -82), INT8_C(  42), INT8_C( 127), INT8_C( -68)) },
    { simde_mm512_set_epi8(INT8_C( 117), INT8_C(  69), INT8_C( 121), INT8_C( -45),
                           INT8_C(  30), INT8_C( -73), INT8_C(   2), INT8_C( -40),
                           INT8_C(  95), INT8_C(  -3), INT8_C(  16), INT8_C( -78),
                           INT8_C(-128), INT8_C( -41), INT8_C( -66), INT8_C(  66),
                           INT8_C(  93), INT8_C( -32), INT8_C( -50), INT8_C(  -2),
                           INT8_C( -61), INT8_C(  29), INT8_C( -88), INT8_C(-118),
                           INT8_C( -27), INT8_C(  42), INT8_C(  78), INT8_C( -46),
                           INT8_C( -79), INT8_C(  38), INT8_C( -75), INT8_C(  14),
                           INT8_C(-118), INT8_C(-114), INT8_C(-120), INT8_C(  42),
                           INT8_C(   4), INT8_C(  79), INT8_C( -84), INT8_C(-110),
                           INT8_C(   0), INT8_C(  85), INT8_C( -20), INT8_C(  61),
                           INT8_C(  40), INT8_C( -75), INT8_C(  69), INT8_C( -99),
                           INT8_C(  73), INT8_C( -34), INT8_C( -14), INT8_C(  72),
                           INT8_C( 101), INT8_C(  96), INT8_C(-114), INT8_C(-124),
                           INT8_C( -87), INT8_C(  43), INT8_C(-118), INT8_C( 114),
                           INT8_C( -88), INT8_C(   8), INT8_C( -52), INT8_C(  75)),
      UINT64_C(14890918166471265655),
      simde_mm512_set_epi8(INT8_C( -56), INT8_C( -70), INT8_C(  66), INT8_C(-111),
                           INT8_C( -69), INT8_C(  15), INT8_C( -82), INT8_C( -12),
                           INT8_C( -89), INT8_C(  37), INT8_C(  80), INT8_C( 120),
                           INT8_C( -83), INT8_C(-120), INT8_C(  95), INT8_C(  21),
                           INT8_C(  91), INT8_C( -97), INT8_C( -72), INT8_C(  42),
                           INT8_C(  22), INT8_C( -70), INT8_C(  71), INT8_C( -78),
                           INT8_C(  -5), INT8_C(  52), INT8_C( -22), INT8_C( -34),
                           INT8_C(  16), INT8_C(  92), INT8_C(  91), INT8_C( -72),
                           INT8_C(   3), INT8_C( -31), INT8_C( -95), INT8_C( -56),
                           INT8_C( -50), INT8_C(  68), INT8_C( -24), INT8_C( -50),
                           INT8_C(  94), INT8_C(  67), INT8_C( 108), INT8_C(-118),
                           INT8_C( -65), INT8_C(  31), INT8_C(  70), INT8_C( 108),
                           INT8_C( -66), INT8_C( 107), INT8_C( -85), INT8_C(  38),
                           INT8_C(   2), INT8_C(  32), INT8_C(  56), INT8_C(  66),
                           INT8_C(  -2), INT8_C( -74), INT8_C( 112), INT8_C(  10),
                           INT8_C(  64), INT8_C( 100), INT8_C( -55), INT8_C(  83)),
      simde_mm512_set_epi8(INT8_C( -69), INT8_C( -45), INT8_C(  23), INT8_C(  70),
                           INT8_C(  22), INT8_C( 113), INT8_C(  75), INT8_C(-117),
                           INT8_C(  69), INT8_C( -74), INT8_C(  40), INT8_C( -39),
                           INT8_C( -51), INT8_C( -91), INT8_C(  25), INT8_C(  -4),
                           INT8_C( -12), INT8_C( -13), INT8_C( -77), INT8_C(  75),
                           INT8_C(-116), INT8_C( -36), INT8_C(  38), INT8_C( -52),
                           INT8_C(  13), INT8_C( -52), INT8_C(-100), INT8_C( -46),
                           INT8_C(  13), INT8_C(  83), INT8_C( -94), INT8_C( 102),
                           INT8_C( 116), INT8_C( -60), INT8_C(  44), INT8_C(  -7),
                           INT8_C( 104), INT8_C( -50), INT8_C( -30), INT8_C(  17),
                           INT8_C(  13), INT8_C(-107), INT8_C( 111), INT8_C( -13),
                           INT8_C(  17), INT8_C( -45), INT8_C( -31), INT8_C(  76),
                           INT8_C(-102), INT8_C( -71), INT8_C( 116), INT8_C(  72),
                           INT8_C( -11), INT8_C( -97), INT8_C(  93), INT8_C(  48),
                           INT8_C( -75), INT8_C( -90), INT8_C( -10), INT8_C( -78),
                           INT8_C(  -8), INT8_C( -10), INT8_C(  48), INT8_C( -11)),
      simde_mm512_set_epi8(INT8_C(-125), INT8_C(-115), INT8_C( 121), INT8_C( -45),
                           INT8_C( -47), INT8_C( 127), INT8_C(  -7), INT8_C( -40),
                           INT8_C( -20), INT8_C(  -3), INT8_C( 120), INT8_C( -78),
                           INT8_C(-128), INT8_C(-128), INT8_C( 120), INT8_C(  17),
                           INT8_C(  93), INT8_C( -32), INT8_C(-128), INT8_C(  -2),
                           INT8_C( -94), INT8_C(  29), INT8_C( 109), INT8_C(-128),
                           INT8_C( -27), INT8_C(  42), INT8_C(-122), INT8_C( -46),
                           INT8_C(  29), INT8_C( 127), INT8_C( -75), INT8_C(  30),
                           INT8_C(-118), INT8_C( -91), INT8_C(-120), INT8_C(  42),
                           INT8_C(  54), INT8_C(  79), INT8_C( -54), INT8_C( -33),
                           INT8_C( 107), INT8_C( -40), INT8_C( 127), INT8_C(  61),
                           INT8_C( -48), INT8_C( -14), INT8_C(  39), INT8_C( -99),
                           INT8_C(  73), INT8_C(  36), INT8_C( -14), INT8_C(  72),
                           INT8_C(  -9), INT8_C( -65), INT8_C(-114), INT8_C( 114),
                           INT8_C( -87), INT8_C(-128), INT8_C( 102), INT8_C( -68),
                           INT8_C( -88), INT8_C(  90), INT8_C(  -7), INT8_C(  72)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_mask_adds_epi8(test_vec[i].src, test_vec[i].k, test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_maskz_adds_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__mmask64 k;
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { UINT64_C(17286015531074160252),
      simde_mm512_set_epi8(INT8_C(-115), INT8_C( -27), INT8_C(  62), INT8_C( -85),
                           INT8_C(  49), INT8_C(-115), INT8_C(  38), INT8_C(   4),
                           INT8_C(  92), INT8_C( 116), INT8_C( -78), INT8_C( -19),
                           INT8_C( -73), INT8_C(  22), INT8_C( -66), INT8_C( -29),
                           INT8_C(  55), INT8_C(  78), INT8_C( -45), INT8_C(-119),
                           INT8_C(  30), INT8_C( -29), INT8_C( -23), INT8_C(  89),
                           INT8_C(  15), INT8_C( 119), INT8_C( -88), INT8_C( 109),
                           INT8_C( -16), INT8_C( -10), INT8_C(   0), INT8_C( -18),
                           INT8_C(   1), INT8_C( 116), INT8_C(  62), INT8_C( -73),
                           INT8_C(-122), INT8_C(   0), INT8_C( 111), INT8_C(  95),
                           INT8_C( -20), INT8_C(   3), INT8_C( 122), INT8_C(-121),
                           INT8_C(  13), INT8_C(  25), INT8_C( -35), INT8_C(-127),
                           INT8_C(  82), INT8_C(  90), INT8_C(  53), INT8_C( 123),
                           INT8_C(  73), INT8_C( 108), INT8_C( -18), INT8_C(  15),
                           INT8_C(  81), INT8_C( -27), INT8_C( 102), INT8_C( 118),
                           INT8_C(  39), INT8_C( -77), INT8_C(  45), INT8_C(  81)),
      simde_mm512_set_epi8(INT8_C(  68), INT8_C(-108), INT8_C(-121), INT8_C(-115),
                           INT8_C( -59), INT8_C( -78), INT8_C(-111), INT8_C(  56),
                           INT8_C(   9), INT8_C(-121), INT8_C( 120), INT8_C( -36),
                           INT8_C(  36), INT8_C(-103), INT8_C(-104), INT8_C(  25),
                           INT8_C(-111), INT8_C( -63), INT8_C( -35), INT8_C(-120),
                           INT8_C(  28), INT8_C( -44), INT8_C( -26), INT8_C( -86),
                           INT8_C( -13), INT8_C(  53), INT8_C( -88), INT8_C(-107),
                           INT8_C(  68), INT8_C(  42), INT8_C(-118), INT8_C( 111),
                           INT8_C(  54), INT8_C( -58), INT8_C( -13), INT8_C(  27),
                           INT8_C(  23), INT8_C(  41), INT8_C(-119), INT8_C(  44),
                           INT8_C(   7), INT8_C(-120), INT8_C(  32), INT8_C( -43),
                           INT8_C( 114), INT8_C( -72), INT8_C(  73), INT8_C( -96),
                           INT8_C(  96), INT8_C( 110), INT8_C( -81), INT8_C( -76),
                           INT8_C( 103), INT8_C(-100), INT8_C( -22), INT8_C(  18),
                           INT8_C( 115), INT8_C(  54), INT8_C( -40), INT8_C( 125),
                           INT8_C( 110), INT8_C(  31), INT8_C(  51), INT8_C(-104)),
      simde_mm512_set_epi8(INT8_C( -47), INT8_C(-128), INT8_C( -59), INT8_C(   0),
                           INT8_C( -10), INT8_C(-128), INT8_C( -73), INT8_C(  60),
                           INT8_C( 101), INT8_C(  -5), INT8_C(  42), INT8_C(   0),
                           INT8_C(   0), INT8_C( -81), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  15), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -49), INT8_C(   3),
                           INT8_C(   2), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  52), INT8_C(   0), INT8_C(-118), INT8_C(   0),
                           INT8_C(   0), INT8_C(  58), INT8_C(   0), INT8_C(   0),
                           INT8_C( -99), INT8_C(  41), INT8_C(  -8), INT8_C( 127),
                           INT8_C( -13), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( 127), INT8_C( -47), INT8_C(  38), INT8_C(-128),
                           INT8_C( 127), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   8), INT8_C( -40), INT8_C(   0),
                           INT8_C(   0), INT8_C(  27), INT8_C(  62), INT8_C( 127),
                           INT8_C( 127), INT8_C( -46), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C( 9031211210081693899),
      simde_mm512_set_epi8(INT8_C(-106), INT8_C( -18), INT8_C(  65), INT8_C(-104),
                           INT8_C(  81), INT8_C(  38), INT8_C( -84), INT8_C(  -2),
                           INT8_C( -14), INT8_C(  85), INT8_C( -80), INT8_C(  80),
                           INT8_C(  48), INT8_C(  93), INT8_C(  79), INT8_C( 127),
                           INT8_C(  16), INT8_C(  41), INT8_C(  54), INT8_C(-116),
                           INT8_C(  17), INT8_C(  42), INT8_C( -86), INT8_C(  38),
                           INT8_C(-118), INT8_C( -56), INT8_C(  60), INT8_C(  19),
                           INT8_C(-100), INT8_C(-107), INT8_C( 105), INT8_C( -76),
                           INT8_C(  10), INT8_C(  -9), INT8_C( -12), INT8_C( -56),
                           INT8_C( -71), INT8_C(  96), INT8_C(   6), INT8_C(  24),
                           INT8_C(  69), INT8_C(  73), INT8_C( -27), INT8_C(   3),
                           INT8_C( -95), INT8_C(  50), INT8_C( -67), INT8_C( -39),
                           INT8_C(  97), INT8_C(  62), INT8_C( 101), INT8_C(  56),
                           INT8_C( -79), INT8_C(  83), INT8_C( -99), INT8_C( -56),
                           INT8_C( -17), INT8_C( -56), INT8_C(  -8), INT8_C( -16),
                           INT8_C(  84), INT8_C( -95), INT8_C( -73), INT8_C(  54)),
      simde_mm512_set_epi8(INT8_C(  63), INT8_C( -51), INT8_C(  87), INT8_C(  32),
                           INT8_C( -65), INT8_C(  55), INT8_C(  14), INT8_C(  81),
                           INT8_C(-123), INT8_C(-100), INT8_C( -39), INT8_C( -44),
                           INT8_C(  22), INT8_C( 112), INT8_C(  16), INT8_C(  15),
                           INT8_C(-104), INT8_C(-102), INT8_C( 102), INT8_C( -95),
                           INT8_C(  69), INT8_C(  13), INT8_C( -21), INT8_C(  45),
                           INT8_C(  62), INT8_C(-120), INT8_C(-111), INT8_C(  32),
                           INT8_C(-107), INT8_C( -30), INT8_C(  99), INT8_C( -64),
                           INT8_C(   8), INT8_C( -42), INT8_C(  81), INT8_C( -34),
                           INT8_C( -46), INT8_C(  26), INT8_C(  31), INT8_C(  -2),
                           INT8_C(  68), INT8_C(  -7), INT8_C( -71), INT8_C(  46),
                           INT8_C( -21), INT8_C( -73), INT8_C(  21), INT8_C(  83),
                           INT8_C(-108), INT8_C( -97), INT8_C( -69), INT8_C(  73),
                           INT8_C(  57), INT8_C( -37), INT8_C(  21), INT8_C(  82),
                           INT8_C(-119), INT8_C(-126), INT8_C( 126), INT8_C(  91),
                           INT8_C( 115), INT8_C(  31), INT8_C( -79), INT8_C(  28)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C( -69), INT8_C( 127), INT8_C( -72),
                           INT8_C(  16), INT8_C(  93), INT8_C(   0), INT8_C(  79),
                           INT8_C(   0), INT8_C( -15), INT8_C(   0), INT8_C(  36),
                           INT8_C(   0), INT8_C( 127), INT8_C(   0), INT8_C( 127),
                           INT8_C(   0), INT8_C( -61), INT8_C(   0), INT8_C(   0),
                           INT8_C(  86), INT8_C(  55), INT8_C(-107), INT8_C(   0),
                           INT8_C( -56), INT8_C(   0), INT8_C( -51), INT8_C(  51),
                           INT8_C(-128), INT8_C(-128), INT8_C( 127), INT8_C(-128),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( 122), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  66), INT8_C( -98), INT8_C(  49),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  44),
                           INT8_C( -11), INT8_C( -35), INT8_C(  32), INT8_C( 127),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(-128), INT8_C(-128), INT8_C(   0), INT8_C(   0),
                           INT8_C( 127), INT8_C(   0), INT8_C(-128), INT8_C(  82)) },
    { UINT64_C( 6828010367541473016),
      simde_mm512_set_epi8(INT8_C(  84), INT8_C( -96), INT8_C(  87), INT8_C( -22),
                           INT8_C(  -5), INT8_C(  -3), INT8_C(-127), INT8_C(  41),
                           INT8_C(  74), INT8_C(  72), INT8_C(  -4), INT8_C(  28),
                           INT8_C(-115), INT8_C(  93), INT8_C( 102), INT8_C(  44),
                           INT8_C(-103), INT8_C( -29), INT8_C( -50), INT8_C(  48),
                           INT8_C( -96), INT8_C( -50), INT8_C(  46), INT8_C( -65),
                           INT8_C(   4), INT8_C(  43), INT8_C( -75), INT8_C(  97),
                           INT8_C( -26), INT8_C(-103), INT8_C(  71), INT8_C(-107),
                           INT8_C(  91), INT8_C(  45), INT8_C( -11), INT8_C(  47),
                           INT8_C(  29), INT8_C(  25), INT8_C(  26), INT8_C(  -9),
                           INT8_C(  10), INT8_C(  36), INT8_C( -79), INT8_C( -53),
                           INT8_C(  41), INT8_C(   1), INT8_C( -23), INT8_C( -63),
                           INT8_C(-127), INT8_C(  68), INT8_C(  48), INT8_C(  36),
                           INT8_C(  89), INT8_C(-112), INT8_C( -31), INT8_C( 120),
                           INT8_C(  35), INT8_C(  62), INT8_C( -21), INT8_C(-114),
                           INT8_C(-104), INT8_C(  57), INT8_C(  42), INT8_C(-111)),
      simde_mm512_set_epi8(INT8_C(  96), INT8_C( -64), INT8_C( -23), INT8_C( -46),
                           INT8_C( -29), INT8_C( -71), INT8_C(  71), INT8_C(  90),
                           INT8_C(  44), INT8_C( -92), INT8_C( -31), INT8_C(  26),
                           INT8_C( -99), INT8_C( -53), INT8_C( 117), INT8_C(  18),
                           INT8_C( -63), INT8_C(  45), INT8_C(  12), INT8_C(  24),
                           INT8_C(-108), INT8_C(  18), INT8_C( -60), INT8_C(  28),
                           INT8_C(  50), INT8_C( -11), INT8_C( -68), INT8_C( -31),
                           INT8_C( 105), INT8_C(-106), INT8_C(  98), INT8_C(  51),
                           INT8_C(  58), INT8_C( 103), INT8_C( 111), INT8_C(-127),
                           INT8_C(  68), INT8_C( -56), INT8_C( 124), INT8_C(-119),
                           INT8_C(  74), INT8_C( -62), INT8_C(-116), INT8_C(  37),
                           INT8_C( -12), INT8_C( 114), INT8_C(   0), INT8_C(  61),
                           INT8_C( 103), INT8_C(  -4), INT8_C(-105), INT8_C( -68),
                           INT8_C(  39), INT8_C(-100), INT8_C( -93), INT8_C(  11),
                           INT8_C( -80), INT8_C( -19), INT8_C( -22), INT8_C( -39),
                           INT8_C( 127), INT8_C( -38), INT8_C(-125), INT8_C(-111)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(-128), INT8_C(   0), INT8_C( -68),
                           INT8_C( -34), INT8_C( -74), INT8_C( -56), INT8_C(   0),
                           INT8_C( 118), INT8_C( -20), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  62),
                           INT8_C(-128), INT8_C(  16), INT8_C( -38), INT8_C(  72),
                           INT8_C(   0), INT8_C( -32), INT8_C( -14), INT8_C( -37),
                           INT8_C(   0), INT8_C(  32), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( 127), INT8_C(   0), INT8_C( 100), INT8_C( -80),
                           INT8_C(  97), INT8_C( -31), INT8_C( 127), INT8_C(-128),
                           INT8_C(  84), INT8_C( -26), INT8_C(-128), INT8_C( -16),
                           INT8_C(  29), INT8_C( 115), INT8_C( -23), INT8_C(   0),
                           INT8_C(   0), INT8_C(  64), INT8_C( -57), INT8_C(   0),
                           INT8_C( 127), INT8_C(-128), INT8_C(-124), INT8_C(   0),
                           INT8_C( -45), INT8_C(  43), INT8_C( -43), INT8_C(-128),
                           INT8_C(  23), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C(18325019528117086600),
      simde_mm512_set_epi8(INT8_C( 122), INT8_C( -54), INT8_C(  50), INT8_C( 123),
                           INT8_C( -31), INT8_C( -74), INT8_C( -64), INT8_C(  54),
                           INT8_C( -81), INT8_C(  60), INT8_C(  31), INT8_C( -23),
                           INT8_C( 108), INT8_C(-119), INT8_C( -92), INT8_C( -80),
                           INT8_C( -30), INT8_C( -37), INT8_C(  51), INT8_C( -36),
                           INT8_C(   8), INT8_C(  52), INT8_C(  97), INT8_C( 123),
                           INT8_C( -49), INT8_C(-124), INT8_C(  95), INT8_C( -83),
                           INT8_C(  70), INT8_C( -50), INT8_C( -61), INT8_C(  25),
                           INT8_C( -97), INT8_C(  28), INT8_C( -58), INT8_C(  11),
                           INT8_C( -14), INT8_C( 126), INT8_C(  81), INT8_C(  45),
                           INT8_C( -23), INT8_C( 120), INT8_C( -83), INT8_C( -16),
                           INT8_C(   7), INT8_C(  51), INT8_C( -57), INT8_C( -50),
                           INT8_C( -21), INT8_C(  98), INT8_C(  88), INT8_C(   0),
                           INT8_C( -66), INT8_C(   3), INT8_C( 124), INT8_C(-113),
                           INT8_C(  50), INT8_C(  88), INT8_C( -85), INT8_C( -93),
                           INT8_C( -44), INT8_C( -13), INT8_C( -94), INT8_C(  17)),
      simde_mm512_set_epi8(INT8_C( -13), INT8_C( -12), INT8_C(-124), INT8_C(  96),
                           INT8_C( -13), INT8_C( -98), INT8_C(  99), INT8_C( -13),
                           INT8_C(  56), INT8_C( -45), INT8_C(-108), INT8_C( -19),
                           INT8_C(-124), INT8_C( -27), INT8_C(  22), INT8_C( 126),
                           INT8_C(-106), INT8_C( -68), INT8_C( -60), INT8_C(   8),
                           INT8_C(  60), INT8_C(  93), INT8_C( -33), INT8_C( -27),
                           INT8_C(  -7), INT8_C(  27), INT8_C(-122), INT8_C( -38),
                           INT8_C(  23), INT8_C(   6), INT8_C(  45), INT8_C( -21),
                           INT8_C( -23), INT8_C(-101), INT8_C( 116), INT8_C( 127),
                           INT8_C(  96), INT8_C(  40), INT8_C( -97), INT8_C(  40),
                           INT8_C(  86), INT8_C( -44), INT8_C(  70), INT8_C( -71),
                           INT8_C(  62), INT8_C( -21), INT8_C(  66), INT8_C(  68),
                           INT8_C( -87), INT8_C( -61), INT8_C(  48), INT8_C( -70),
                           INT8_C(  18), INT8_C( -78), INT8_C( -98), INT8_C( 117),
                           INT8_C(  74), INT8_C(  32), INT8_C(  93), INT8_C( 125),
                           INT8_C( -47), INT8_C( -60), INT8_C( -86), INT8_C( 117)),
      simde_mm512_set_epi8(INT8_C( 109), INT8_C( -66), INT8_C( -74), INT8_C( 127),
                           INT8_C( -44), INT8_C(-128), INT8_C(  35), INT8_C(   0),
                           INT8_C(   0), INT8_C(  15), INT8_C(   0), INT8_C(   0),
                           INT8_C( -16), INT8_C(-128), INT8_C( -70), INT8_C(  46),
                           INT8_C(-128), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  68), INT8_C( 127), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -27), INT8_C(   0),
                           INT8_C(  93), INT8_C(   0), INT8_C( -16), INT8_C(   4),
                           INT8_C(-120), INT8_C(   0), INT8_C(  58), INT8_C( 127),
                           INT8_C(   0), INT8_C(   0), INT8_C( -16), INT8_C(  85),
                           INT8_C(  63), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   9), INT8_C(  18),
                           INT8_C(-108), INT8_C(  37), INT8_C( 127), INT8_C(   0),
                           INT8_C( -48), INT8_C(   0), INT8_C(   0), INT8_C(   4),
                           INT8_C( 124), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -91), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C( 7677112093376593822),
      simde_mm512_set_epi8(INT8_C( -53), INT8_C(  34), INT8_C(   9), INT8_C(  64),
                           INT8_C( -61), INT8_C( -25), INT8_C(-115), INT8_C( 100),
                           INT8_C(  65), INT8_C(   8), INT8_C(  69), INT8_C(  -8),
                           INT8_C( -15), INT8_C( -51), INT8_C(   1), INT8_C(  90),
                           INT8_C( 115), INT8_C(  51), INT8_C( -91), INT8_C(  56),
                           INT8_C(  64), INT8_C( -39), INT8_C(-119), INT8_C( -28),
                           INT8_C( -54), INT8_C(  28), INT8_C(  54), INT8_C(  -8),
                           INT8_C( -54), INT8_C(-128), INT8_C( -28), INT8_C( -71),
                           INT8_C( 107), INT8_C( -66), INT8_C(-114), INT8_C( -88),
                           INT8_C(  34), INT8_C( -83), INT8_C( -21), INT8_C( -64),
                           INT8_C( 121), INT8_C( -20), INT8_C( -89), INT8_C( -94),
                           INT8_C( 112), INT8_C( -27), INT8_C(  81), INT8_C( -54),
                           INT8_C( -64), INT8_C(-114), INT8_C(  48), INT8_C( -89),
                           INT8_C( -61), INT8_C(  26), INT8_C(  43), INT8_C(  29),
                           INT8_C(   0), INT8_C(  64), INT8_C( 123), INT8_C( -67),
                           INT8_C(  15), INT8_C( 120), INT8_C(  36), INT8_C(  40)),
      simde_mm512_set_epi8(INT8_C( 113), INT8_C(  32), INT8_C(  71), INT8_C(  55),
                           INT8_C( -26), INT8_C(  82), INT8_C( -81), INT8_C( -20),
                           INT8_C( -55), INT8_C( 112), INT8_C(  45), INT8_C(  37),
                           INT8_C(  67), INT8_C( -69), INT8_C(  64), INT8_C(  39),
                           INT8_C(  72), INT8_C(  45), INT8_C( 120), INT8_C(  -5),
                           INT8_C(-109), INT8_C(  62), INT8_C(  17), INT8_C(  31),
                           INT8_C( -30), INT8_C( -58), INT8_C(  56), INT8_C(  21),
                           INT8_C(  72), INT8_C( -74), INT8_C( -40), INT8_C( 120),
                           INT8_C(  95), INT8_C( 108), INT8_C(  32), INT8_C(  64),
                           INT8_C(-128), INT8_C( 102), INT8_C( -21), INT8_C(  28),
                           INT8_C( 105), INT8_C(  52), INT8_C(  85), INT8_C(-104),
                           INT8_C(  57), INT8_C( -31), INT8_C( -38), INT8_C(-124),
                           INT8_C(-107), INT8_C(  -2), INT8_C(  55), INT8_C(  46),
                           INT8_C( -71), INT8_C(  77), INT8_C(  18), INT8_C(  70),
                           INT8_C(  89), INT8_C( 125), INT8_C( -42), INT8_C(-125),
                           INT8_C( 121), INT8_C( -11), INT8_C( -69), INT8_C( -59)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(  66), INT8_C(  80), INT8_C(   0),
                           INT8_C( -87), INT8_C(   0), INT8_C(-128), INT8_C(   0),
                           INT8_C(  10), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  52), INT8_C(   0), INT8_C(  65), INT8_C(   0),
                           INT8_C( 127), INT8_C(   0), INT8_C(   0), INT8_C(  51),
                           INT8_C(   0), INT8_C(  23), INT8_C(   0), INT8_C(   0),
                           INT8_C( -84), INT8_C( -30), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-128), INT8_C( -68), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -24),
                           INT8_C( -94), INT8_C(   0), INT8_C( -42), INT8_C(   0),
                           INT8_C( 127), INT8_C(   0), INT8_C(   0), INT8_C(-128),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(-128),
                           INT8_C(   0), INT8_C(   0), INT8_C( 103), INT8_C( -43),
                           INT8_C(-128), INT8_C( 103), INT8_C(  61), INT8_C(  99),
                           INT8_C(  89), INT8_C(   0), INT8_C(   0), INT8_C(-128),
                           INT8_C( 127), INT8_C( 109), INT8_C( -33), INT8_C(   0)) },
    { UINT64_C( 4840581956081845689),
      simde_mm512_set_epi8(INT8_C( 122), INT8_C(-108), INT8_C( -70), INT8_C( -63),
                           INT8_C(  56), INT8_C(  71), INT8_C( -14), INT8_C(  49),
                           INT8_C( -73), INT8_C(  53), INT8_C( -29), INT8_C(   3),
                           INT8_C( -73), INT8_C(  43), INT8_C( -22), INT8_C(  85),
                           INT8_C( -26), INT8_C(  -9), INT8_C(  66), INT8_C(   1),
                           INT8_C( -13), INT8_C(  60), INT8_C(-119), INT8_C( -83),
                           INT8_C(-122), INT8_C( -64), INT8_C( -83), INT8_C( -74),
                           INT8_C( 119), INT8_C(  -8), INT8_C(  12), INT8_C( 113),
                           INT8_C( -12), INT8_C( -84), INT8_C(   6), INT8_C(  69),
                           INT8_C(   2), INT8_C( -75), INT8_C( -34), INT8_C(-126),
                           INT8_C(   3), INT8_C(-128), INT8_C(  -9), INT8_C(  24),
                           INT8_C(  11), INT8_C( -94), INT8_C( -32), INT8_C( 110),
                           INT8_C(  33), INT8_C( -24), INT8_C( 125), INT8_C(  35),
                           INT8_C(-103), INT8_C( -48), INT8_C( -22), INT8_C(  38),
                           INT8_C( -81), INT8_C(   9), INT8_C( -11), INT8_C(-124),
                           INT8_C(  71), INT8_C(  31), INT8_C( -42), INT8_C(  93)),
      simde_mm512_set_epi8(INT8_C(  53), INT8_C(  77), INT8_C(  63), INT8_C( -84),
                           INT8_C(  27), INT8_C(  22), INT8_C(   3), INT8_C( -37),
                           INT8_C(  65), INT8_C( 118), INT8_C(-126), INT8_C(  97),
                           INT8_C( 109), INT8_C(   7), INT8_C(-114), INT8_C( -75),
                           INT8_C(-125), INT8_C( 121), INT8_C(-128), INT8_C( 103),
                           INT8_C(   0), INT8_C( 101), INT8_C( -41), INT8_C(  89),
                           INT8_C( -83), INT8_C( -65), INT8_C(   9), INT8_C(  -7),
                           INT8_C( -63), INT8_C(  13), INT8_C( 105), INT8_C(  92),
                           INT8_C( -18), INT8_C( -21), INT8_C(-102), INT8_C(-114),
                           INT8_C(  74), INT8_C( 121), INT8_C( -45), INT8_C(  52),
                           INT8_C( -63), INT8_C( -93), INT8_C(  98), INT8_C( 106),
                           INT8_C(-109), INT8_C( -47), INT8_C(  37), INT8_C(  70),
                           INT8_C( 100), INT8_C( 121), INT8_C(  18), INT8_C(  28),
                           INT8_C(-117), INT8_C( 107), INT8_C(   3), INT8_C( -62),
                           INT8_C(  42), INT8_C(  72), INT8_C(  91), INT8_C(  86),
                           INT8_C( -72), INT8_C(   9), INT8_C( -80), INT8_C( 118)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C( -31), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -11), INT8_C(  12),
                           INT8_C(   0), INT8_C(   0), INT8_C(-128), INT8_C(   0),
                           INT8_C(  36), INT8_C(  50), INT8_C(   0), INT8_C(  10),
                           INT8_C(   0), INT8_C(   0), INT8_C( -62), INT8_C( 104),
                           INT8_C(   0), INT8_C(   0), INT8_C(-128), INT8_C(   6),
                           INT8_C(-128), INT8_C(   0), INT8_C( -74), INT8_C(   0),
                           INT8_C(   0), INT8_C(   5), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-105), INT8_C( -96), INT8_C( -45),
                           INT8_C(  76), INT8_C(  46), INT8_C( -79), INT8_C(   0),
                           INT8_C(   0), INT8_C(-128), INT8_C(  89), INT8_C(   0),
                           INT8_C( -98), INT8_C(-128), INT8_C(   0), INT8_C(   0),
                           INT8_C( 127), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  59), INT8_C(   0), INT8_C( -24),
                           INT8_C( -39), INT8_C(   0), INT8_C(  80), INT8_C( -38),
                           INT8_C(  -1), INT8_C(   0), INT8_C(   0), INT8_C( 127)) },
    { UINT64_C(17498311407133456191),
      simde_mm512_set_epi8(INT8_C(  61), INT8_C( -89), INT8_C(  84), INT8_C( -94),
                           INT8_C(  31), INT8_C(-116), INT8_C( -67), INT8_C(-102),
                           INT8_C( -72), INT8_C( -91), INT8_C(-105), INT8_C(-108),
                           INT8_C( -44), INT8_C(  74), INT8_C( -28), INT8_C( 124),
                           INT8_C( 120), INT8_C( -41), INT8_C( -79), INT8_C( 122),
                           INT8_C(  87), INT8_C(-119), INT8_C(  54), INT8_C(  -2),
                           INT8_C( -47), INT8_C(  84), INT8_C(-126), INT8_C( -64),
                           INT8_C(  14), INT8_C(  11), INT8_C(  37), INT8_C( -23),
                           INT8_C(  67), INT8_C( 124), INT8_C(  58), INT8_C( -94),
                           INT8_C(  30), INT8_C( -33), INT8_C(  70), INT8_C( -24),
                           INT8_C(  38), INT8_C( -97), INT8_C( -56), INT8_C( -60),
                           INT8_C( -59), INT8_C(  65), INT8_C( -74), INT8_C(  45),
                           INT8_C( -11), INT8_C(  55), INT8_C( -82), INT8_C(  12),
                           INT8_C( 106), INT8_C(  22), INT8_C(-124), INT8_C(  -4),
                           INT8_C(   2), INT8_C( -81), INT8_C(  14), INT8_C(  90),
                           INT8_C(-100), INT8_C(-122), INT8_C( -35), INT8_C(  81)),
      simde_mm512_set_epi8(INT8_C(  21), INT8_C( 108), INT8_C( 125), INT8_C( -60),
                           INT8_C( -72), INT8_C(  74), INT8_C(  -5), INT8_C( -58),
                           INT8_C( -41), INT8_C(  22), INT8_C(-115), INT8_C( 102),
                           INT8_C(  59), INT8_C( -80), INT8_C( -15), INT8_C( -63),
                           INT8_C(  84), INT8_C( -71), INT8_C(   8), INT8_C(  12),
                           INT8_C( -11), INT8_C( -76), INT8_C(  62), INT8_C(  93),
                           INT8_C( -75), INT8_C( -77), INT8_C( -84), INT8_C(-108),
                           INT8_C( -35), INT8_C(  14), INT8_C( -60), INT8_C(  18),
                           INT8_C(  23), INT8_C( -60), INT8_C( -63), INT8_C(-114),
                           INT8_C( -55), INT8_C(  75), INT8_C( -99), INT8_C( -55),
                           INT8_C(  58), INT8_C(  76), INT8_C(-102), INT8_C(-118),
                           INT8_C( -30), INT8_C(  39), INT8_C( 119), INT8_C(  85),
                           INT8_C(  -8), INT8_C( -72), INT8_C( -60), INT8_C( -94),
                           INT8_C(-112), INT8_C( 119), INT8_C( 124), INT8_C(  76),
                           INT8_C( -42), INT8_C(-124), INT8_C(  54), INT8_C(  74),
                           INT8_C( -92), INT8_C(  99), INT8_C(  79), INT8_C(  -3)),
      simde_mm512_set_epi8(INT8_C(  82), INT8_C(  19), INT8_C( 127), INT8_C(-128),
                           INT8_C(   0), INT8_C(   0), INT8_C( -72), INT8_C(   0),
                           INT8_C(-113), INT8_C( -69), INT8_C(   0), INT8_C(  -6),
                           INT8_C(   0), INT8_C(  -6), INT8_C( -43), INT8_C(   0),
                           INT8_C(   0), INT8_C(-112), INT8_C( -71), INT8_C( 127),
                           INT8_C(  76), INT8_C(-128), INT8_C(   0), INT8_C(  91),
                           INT8_C(-122), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -23), INT8_C(  -5),
                           INT8_C(  90), INT8_C(  64), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  42), INT8_C( -29), INT8_C( -79),
                           INT8_C(   0), INT8_C( -21), INT8_C(   0), INT8_C(-128),
                           INT8_C( -89), INT8_C(   0), INT8_C(  45), INT8_C(   0),
                           INT8_C( -19), INT8_C( -17), INT8_C(-128), INT8_C( -82),
                           INT8_C(   0), INT8_C( 127), INT8_C(   0), INT8_C(  72),
                           INT8_C(   0), INT8_C(   0), INT8_C(  68), INT8_C( 127),
                           INT8_C(-128), INT8_C( -23), INT8_C(  44), INT8_C(  78)) },
    { UINT64_C( 3462613925466476941),
      simde_mm512_set_epi8(INT8_C(  18), INT8_C( -74), INT8_C(  14), INT8_C(  36),
                           INT8_C(  -7), INT8_C( 113), INT8_C(  40), INT8_C(  48),
                           INT8_C(-107), INT8_C( -34), INT8_C( -75), INT8_C(  85),
                           INT8_C( -35), INT8_C(-116), INT8_C(  65), INT8_C( -21),
                           INT8_C(  15), INT8_C(   3), INT8_C(  45), INT8_C(  21),
                           INT8_C(  72), INT8_C(  93), INT8_C( 108), INT8_C( 125),
                           INT8_C(   1), INT8_C(  75), INT8_C(  21), INT8_C( -36),
                           INT8_C(-126), INT8_C( 122), INT8_C(  71), INT8_C(  76),
                           INT8_C(  28), INT8_C( -56), INT8_C(  32), INT8_C( 101),
                           INT8_C(-107), INT8_C(-111), INT8_C( -88), INT8_C( -19),
                           INT8_C( -77), INT8_C(  19), INT8_C( -21), INT8_C(-111),
                           INT8_C( -68), INT8_C(  82), INT8_C(-118), INT8_C( -76),
                           INT8_C(  47), INT8_C( 127), INT8_C(  62), INT8_C( -16),
                           INT8_C(  10), INT8_C( -14), INT8_C(-100), INT8_C(  86),
                           INT8_C(  29), INT8_C( 107), INT8_C(  56), INT8_C(  21),
                           INT8_C(  24), INT8_C(  68), INT8_C( -96), INT8_C(  64)),
      simde_mm512_set_epi8(INT8_C( -57), INT8_C(  94), INT8_C(-125), INT8_C(-124),
                           INT8_C(  36), INT8_C(  57), INT8_C(  68), INT8_C( -52),
                           INT8_C(  39), INT8_C(  50), INT8_C( -48), INT8_C(  94),
                           INT8_C(  53), INT8_C(  11), INT8_C(  29), INT8_C(  65),
                           INT8_C( -82), INT8_C(-119), INT8_C( 115), INT8_C(  68),
                           INT8_C( -69), INT8_C( 118), INT8_C(  17), INT8_C(   8),
                           INT8_C( -64), INT8_C( -53), INT8_C( -42), INT8_C( 126),
                           INT8_C(  67), INT8_C(  50), INT8_C( -18), INT8_C(  76),
                           INT8_C( -19), INT8_C( 123), INT8_C( -87), INT8_C( 106),
                           INT8_C( -74), INT8_C(  44), INT8_C( 117), INT8_C( 103),
                           INT8_C(  81), INT8_C( 122), INT8_C(  56), INT8_C( -10),
                           INT8_C(  67), INT8_C(  79), INT8_C(  83), INT8_C( -38),
                           INT8_C( -13), INT8_C(  43), INT8_C(  27), INT8_C( -97),
                           INT8_C( 102), INT8_C( 126), INT8_C(  38), INT8_C( -62),
                           INT8_C( -24), INT8_C( 117), INT8_C( -38), INT8_C( -93),
                           INT8_C( -58), INT8_C(-124), INT8_C( -75), INT8_C(  10)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(-111), INT8_C( -88),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  18), INT8_C(-105), INT8_C(   0), INT8_C(  44),
                           INT8_C( -67), INT8_C(   0), INT8_C( 127), INT8_C(   0),
                           INT8_C(   3), INT8_C( 127), INT8_C(   0), INT8_C( 127),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( 127), INT8_C(   0), INT8_C(   0),
                           INT8_C(   9), INT8_C(  67), INT8_C( -55), INT8_C( 127),
                           INT8_C(-128), INT8_C( -67), INT8_C(   0), INT8_C(  84),
                           INT8_C(   4), INT8_C( 127), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(-113),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  24),
                           INT8_C(   5), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -34), INT8_C( -56), INT8_C(   0), INT8_C(  74)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_maskz_adds_epi8(test_vec[i].k, test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_adds_epi16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi16(INT16_C(  5952), INT16_C(-21138), INT16_C( 23605), INT16_C( -3799),
                            INT16_C(  1987), INT16_C( 29254), INT16_C( -4184), INT16_C( 13346),
                            INT16_C( 26203), INT16_C(-24373), INT16_C( 15487), INT16_C( 15569),
                            INT16_C( 13821), INT16_C( -3315), INT16_C( 30667), INT16_C(  9811),
                            INT16_C( 22769), INT16_C( 21964), INT16_C(  -315), INT16_C(-15723),
                            INT16_C( -9658), INT16_C(-27088), INT16_C( 18289), INT16_C( 13213),
                            INT16_C(-12712), INT16_C( 23293), INT16_C( 12497), INT16_C( 16576),
                            INT16_C(-19358), INT16_C(-11263), INT16_C( -3745), INT16_C(  7925)),
      simde_mm512_set_epi16(INT16_C(-22600), INT16_C(  9825), INT16_C( 27347), INT16_C( -4649),
                            INT16_C(  4812), INT16_C( 27489), INT16_C( 14729), INT16_C(-20872),
                            INT16_C(-24487), INT16_C( 23053), INT16_C( 28966), INT16_C(-23890),
                            INT16_C( -9737), INT16_C(-24021), INT16_C( 12009), INT16_C(-16892),
                            INT16_C(-11018), INT16_C( -7664), INT16_C( 22598), INT16_C(  9112),
                            INT16_C(  -468), INT16_C(-16246), INT16_C( 11633), INT16_C(  3402),
                            INT16_C( 12940), INT16_C(-18453), INT16_C(-10463), INT16_C(-24372),
                            INT16_C(  9722), INT16_C(  4912), INT16_C( 14086), INT16_C( -2976)),
      simde_mm512_set_epi16(INT16_C(-16648), INT16_C(-11313), INT16_C( 32767), INT16_C( -8448),
                            INT16_C(  6799), INT16_C( 32767), INT16_C( 10545), INT16_C( -7526),
                            INT16_C(  1716), INT16_C( -1320), INT16_C( 32767), INT16_C( -8321),
                            INT16_C(  4084), INT16_C(-27336), INT16_C( 32767), INT16_C( -7081),
                            INT16_C( 11751), INT16_C( 14300), INT16_C( 22283), INT16_C( -6611),
                            INT16_C(-10126), INT16_C(-32768), INT16_C( 29922), INT16_C( 16615),
                            INT16_C(   228), INT16_C(  4840), INT16_C(  2034), INT16_C( -7796),
                            INT16_C( -9636), INT16_C( -6351), INT16_C( 10341), INT16_C(  4949)) },
    { simde_mm512_set_epi16(INT16_C(-21870), INT16_C( -1966), INT16_C(-26101), INT16_C(  8905),
                            INT16_C(-13069), INT16_C( 13555), INT16_C(-23554), INT16_C(-12947),
                            INT16_C( 31779), INT16_C( 21013), INT16_C( 32688), INT16_C( 12512),
                            INT16_C(-26721), INT16_C(  7598), INT16_C( 21566), INT16_C(-11203),
                            INT16_C( 27021), INT16_C( -8539), INT16_C(  -532), INT16_C(-17200),
                            INT16_C(-18609), INT16_C(-30604), INT16_C(  6829), INT16_C(-13538),
                            INT16_C( 21529), INT16_C( 29340), INT16_C( 23176), INT16_C( 10860),
                            INT16_C( 31408), INT16_C(  3656), INT16_C(-30572), INT16_C( -4393)),
      simde_mm512_set_epi16(INT16_C( 29137), INT16_C( 29112), INT16_C(-21893), INT16_C( 14830),
                            INT16_C( 28350), INT16_C( 21222), INT16_C( 26922), INT16_C( 26197),
                            INT16_C(-25881), INT16_C( 28163), INT16_C(-19268), INT16_C( 10158),
                            INT16_C(-29245), INT16_C( 16103), INT16_C(-23323), INT16_C( 12478),
                            INT16_C( -6515), INT16_C( 24007), INT16_C(-28366), INT16_C(-32677),
                            INT16_C(-27350), INT16_C(-26916), INT16_C(-11979), INT16_C( 13820),
                            INT16_C(-22393), INT16_C(-20903), INT16_C( -9892), INT16_C(-22447),
                            INT16_C(-14286), INT16_C(  3532), INT16_C( 19664), INT16_C(-26842)),
      simde_mm512_set_epi16(INT16_C(  7267), INT16_C( 27146), INT16_C(-32768), INT16_C( 23735),
                            INT16_C( 15281), INT16_C( 32767), INT16_C(  3368), INT16_C( 13250),
                            INT16_C(  5898), INT16_C( 32767), INT16_C( 13420), INT16_C( 22670),
                            INT16_C(-32768), INT16_C( 23701), INT16_C( -1757), INT16_C(  1275),
                            INT16_C( 20506), INT16_C( 15468), INT16_C(-28898), INT16_C(-32768),
                            INT16_C(-32768), INT16_C(-32768), INT16_C( -5150), INT16_C(   282),
                            INT16_C(  -864), INT16_C(  8437), INT16_C( 13284), INT16_C(-11587),
                            INT16_C( 17122), INT16_C(  7188), INT16_C(-10908), INT16_C(-31235)) },
    { simde_mm512_set_epi16(INT16_C(-22689), INT16_C( 25207), INT16_C( -9300), INT16_C( 28977),
                            INT16_C(  2270), INT16_C(-32394), INT16_C( 26182), INT16_C( 23367),
                            INT16_C( 31661), INT16_C(  9636), INT16_C(-18580), INT16_C(-28875),
                            INT16_C(-25943), INT16_C( 14067), INT16_C( 10599), INT16_C( 30831),
                            INT16_C(-23557), INT16_C( 11377), INT16_C( -4608), INT16_C( 14955),
                            INT16_C( 11781), INT16_C(-12602), INT16_C( -3223), INT16_C( 11440),
                            INT16_C( -2896), INT16_C(-24304), INT16_C( 29156), INT16_C( -4347),
                            INT16_C( -2421), INT16_C( 31033), INT16_C( -3132), INT16_C(-19324)),
      simde_mm512_set_epi16(INT16_C( -2724), INT16_C(  4704), INT16_C( 23772), INT16_C(-20368),
                            INT16_C(-30374), INT16_C( 15838), INT16_C( 19402), INT16_C( 16976),
                            INT16_C(-28476), INT16_C( -2715), INT16_C(-27679), INT16_C( -8608),
                            INT16_C(-20120), INT16_C( 29206), INT16_C( -1643), INT16_C(-29856),
                            INT16_C( 18656), INT16_C( -9660), INT16_C( -4660), INT16_C(-30272),
                            INT16_C(   610), INT16_C( -3787), INT16_C( 22038), INT16_C(-29446),
                            INT16_C(-26504), INT16_C(-28984), INT16_C(-21830), INT16_C(-27507),
                            INT16_C( 24148), INT16_C(-12945), INT16_C( 24529), INT16_C(  7913)),
      simde_mm512_set_epi16(INT16_C(-25413), INT16_C( 29911), INT16_C( 14472), INT16_C(  8609),
                            INT16_C(-28104), INT16_C(-16556), INT16_C( 32767), INT16_C( 32767),
                            INT16_C(  3185), INT16_C(  6921), INT16_C(-32768), INT16_C(-32768),
                            INT16_C(-32768), INT16_C( 32767), INT16_C(  8956), INT16_C(   975),
                            INT16_C( -4901), INT16_C(  1717), INT16_C( -9268), INT16_C(-15317),
                            INT16_C( 12391), INT16_C(-16389), INT16_C( 18815), INT16_C(-18006),
                            INT16_C(-29400), INT16_C(-32768), INT16_C(  7326), INT16_C(-31854),
                            INT16_C( 21727), INT16_C( 18088), INT16_C( 21397), INT16_C(-11411)) },
    { simde_mm512_set_epi16(INT16_C(-18069), INT16_C( 21685), INT16_C( -5808), INT16_C( 24672),
                            INT16_C( -8190), INT16_C( -2830), INT16_C(-23214), INT16_C(  1083),
                            INT16_C(  6699), INT16_C(   871), INT16_C(-14072), INT16_C( -2337),
                            INT16_C( 13356), INT16_C(  7260), INT16_C(-23788), INT16_C(-19723),
                            INT16_C( 13480), INT16_C(-15429), INT16_C(-20153), INT16_C( 18680),
                            INT16_C(-26180), INT16_C( 27923), INT16_C(-14099), INT16_C( 25829),
                            INT16_C(-27481), INT16_C( 21639), INT16_C( 16654), INT16_C( 19972),
                            INT16_C( 15776), INT16_C( 23126), INT16_C( 30799), INT16_C(-14043)),
      simde_mm512_set_epi16(INT16_C( 16111), INT16_C(-26103), INT16_C( -8800), INT16_C(-24747),
                            INT16_C( 27941), INT16_C(   603), INT16_C( -8112), INT16_C(-28325),
                            INT16_C( -6110), INT16_C(-15530), INT16_C(  -938), INT16_C(-26515),
                            INT16_C( -2492), INT16_C( 16124), INT16_C(-27181), INT16_C( -3573),
                            INT16_C( 11652), INT16_C( 11646), INT16_C(  6964), INT16_C( 27675),
                            INT16_C( 13103), INT16_C( -2742), INT16_C( 27906), INT16_C( -1077),
                            INT16_C(-30636), INT16_C(-23050), INT16_C(  8363), INT16_C( 31350),
                            INT16_C( -4750), INT16_C(  -220), INT16_C( -8954), INT16_C( 15617)),
      simde_mm512_set_epi16(INT16_C( -1958), INT16_C( -4418), INT16_C(-14608), INT16_C(   -75),
                            INT16_C( 19751), INT16_C( -2227), INT16_C(-31326), INT16_C(-27242),
                            INT16_C(   589), INT16_C(-14659), INT16_C(-15010), INT16_C(-28852),
                            INT16_C( 10864), INT16_C( 23384), INT16_C(-32768), INT16_C(-23296),
                            INT16_C( 25132), INT16_C( -3783), INT16_C(-13189), INT16_C( 32767),
                            INT16_C(-13077), INT16_C( 25181), INT16_C( 13807), INT16_C( 24752),
                            INT16_C(-32768), INT16_C( -1411), INT16_C( 25017), INT16_C( 32767),
                            INT16_C( 11026), INT16_C( 22906), INT16_C( 21845), INT16_C(  1574)) },
    { simde_mm512_set_epi16(INT16_C( 25180), INT16_C(-32332), INT16_C(-18604), INT16_C(-25763),
                            INT16_C( 28237), INT16_C(-22027), INT16_C( 18301), INT16_C( 27599),
                            INT16_C( 11815), INT16_C(-14839), INT16_C(-13552), INT16_C( -6300),
                            INT16_C(-30211), INT16_C(-25552), INT16_C(  7375), INT16_C(  5267),
                            INT16_C(-14761), INT16_C(-28375), INT16_C(-32756), INT16_C( 13128),
                            INT16_C( 17683), INT16_C( -4430), INT16_C( -1805), INT16_C(-17763),
                            INT16_C(   206), INT16_C( 15851), INT16_C(  1078), INT16_C( 27402),
                            INT16_C(-15177), INT16_C(  5068), INT16_C(-15079), INT16_C(-13584)),
      simde_mm512_set_epi16(INT16_C( -3533), INT16_C( -3885), INT16_C(   789), INT16_C( -3755),
                            INT16_C(  3668), INT16_C( 19955), INT16_C(-22356), INT16_C(  8403),
                            INT16_C(-16920), INT16_C( 15195), INT16_C( -1853), INT16_C(-12121),
                            INT16_C(  5095), INT16_C( -9909), INT16_C(   574), INT16_C( 31911),
                            INT16_C( -1319), INT16_C( -2880), INT16_C(-31000), INT16_C(-30829),
                            INT16_C(-12917), INT16_C( 21541), INT16_C( 27413), INT16_C(-28040),
                            INT16_C(-19236), INT16_C(-24178), INT16_C(-29369), INT16_C( -3607),
                            INT16_C( -2666), INT16_C(-13470), INT16_C(  4416), INT16_C( 23850)),
      simde_mm512_set_epi16(INT16_C( 21647), INT16_C(-32768), INT16_C(-17815), INT16_C(-29518),
                            INT16_C( 31905), INT16_C( -2072), INT16_C( -4055), INT16_C( 32767),
                            INT16_C( -5105), INT16_C(   356), INT16_C(-15405), INT16_C(-18421),
                            INT16_C(-25116), INT16_C(-32768), INT16_C(  7949), INT16_C( 32767),
                            INT16_C(-16080), INT16_C(-31255), INT16_C(-32768), INT16_C(-17701),
                            INT16_C(  4766), INT16_C( 17111), INT16_C( 25608), INT16_C(-32768),
                            INT16_C(-19030), INT16_C( -8327), INT16_C(-28291), INT16_C( 23795),
                            INT16_C(-17843), INT16_C( -8402), INT16_C(-10663), INT16_C( 10266)) },
    { simde_mm512_set_epi16(INT16_C( 11424), INT16_C( 29699), INT16_C( 29618), INT16_C(-29898),
                            INT16_C(-23079), INT16_C( -6822), INT16_C( -7340), INT16_C(-12296),
                            INT16_C( 17833), INT16_C( -2043), INT16_C(-29766), INT16_C( 30776),
                            INT16_C(-18161), INT16_C(-32768), INT16_C(-31882), INT16_C(  3163),
                            INT16_C( 20808), INT16_C(-24577), INT16_C(  7685), INT16_C(  6279),
                            INT16_C(-27880), INT16_C( 27718), INT16_C(-18275), INT16_C( 24470),
                            INT16_C(  8834), INT16_C( 20594), INT16_C( 23052), INT16_C(-18860),
                            INT16_C(  7784), INT16_C(-16668), INT16_C(-30440), INT16_C(  6387)),
      simde_mm512_set_epi16(INT16_C( 15054), INT16_C(-23448), INT16_C(   866), INT16_C(-23509),
                            INT16_C(    -2), INT16_C(  6267), INT16_C(-15891), INT16_C(-24685),
                            INT16_C( 17511), INT16_C(  7218), INT16_C(-13659), INT16_C(-27162),
                            INT16_C( 10378), INT16_C(-16488), INT16_C(-11578), INT16_C(-27832),
                            INT16_C(-17566), INT16_C(-29377), INT16_C( -2221), INT16_C( 18656),
                            INT16_C(  7516), INT16_C(-30776), INT16_C(-19010), INT16_C( 26269),
                            INT16_C(-18451), INT16_C( 31467), INT16_C(-22066), INT16_C( 30155),
                            INT16_C( -3394), INT16_C( -6131), INT16_C( 13533), INT16_C( 21770)),
      simde_mm512_set_epi16(INT16_C( 26478), INT16_C(  6251), INT16_C( 30484), INT16_C(-32768),
                            INT16_C(-23081), INT16_C(  -555), INT16_C(-23231), INT16_C(-32768),
                            INT16_C( 32767), INT16_C(  5175), INT16_C(-32768), INT16_C(  3614),
                            INT16_C( -7783), INT16_C(-32768), INT16_C(-32768), INT16_C(-24669),
                            INT16_C(  3242), INT16_C(-32768), INT16_C(  5464), INT16_C( 24935),
                            INT16_C(-20364), INT16_C( -3058), INT16_C(-32768), INT16_C( 32767),
                            INT16_C( -9617), INT16_C( 32767), INT16_C(   986), INT16_C( 11295),
                            INT16_C(  4390), INT16_C(-22799), INT16_C(-16907), INT16_C( 28157)) },
    { simde_mm512_set_epi16(INT16_C( 11108), INT16_C(  5360), INT16_C(  8246), INT16_C(  2034),
                            INT16_C(  1485), INT16_C( 28421), INT16_C( 17428), INT16_C(-13900),
                            INT16_C(  4889), INT16_C( 17148), INT16_C( 13806), INT16_C(-26968),
                            INT16_C( -7783), INT16_C( 11345), INT16_C( 17472), INT16_C( 26483),
                            INT16_C(-10340), INT16_C( -7816), INT16_C( 22407), INT16_C( 32028),
                            INT16_C( 18301), INT16_C(-30148), INT16_C( -4736), INT16_C(-10574),
                            INT16_C( 10686), INT16_C( -5463), INT16_C( 19858), INT16_C( -4320),
                            INT16_C(-28154), INT16_C(  8984), INT16_C( 32741), INT16_C( 29052)),
      simde_mm512_set_epi16(INT16_C(-22772), INT16_C(-14596), INT16_C( -9458), INT16_C(  2054),
                            INT16_C(-24090), INT16_C(  1808), INT16_C(  9897), INT16_C( 20003),
                            INT16_C( 21444), INT16_C(  8548), INT16_C( -1773), INT16_C(  8905),
                            INT16_C( 14811), INT16_C(  5752), INT16_C(-17876), INT16_C( -7032),
                            INT16_C(-19669), INT16_C(-30631), INT16_C(-19220), INT16_C( 18906),
                            INT16_C( 15935), INT16_C(  2767), INT16_C(-30937), INT16_C( 13780),
                            INT16_C( 28270), INT16_C( 29263), INT16_C( 11106), INT16_C( 19546),
                            INT16_C( 16947), INT16_C(-29470), INT16_C( -1882), INT16_C(-19990)),
      simde_mm512_set_epi16(INT16_C(-11664), INT16_C( -9236), INT16_C( -1212), INT16_C(  4088),
                            INT16_C(-22605), INT16_C( 30229), INT16_C( 27325), INT16_C(  6103),
                            INT16_C( 26333), INT16_C( 25696), INT16_C( 12033), INT16_C(-18063),
                            INT16_C(  7028), INT16_C( 17097), INT16_C(  -404), INT16_C( 19451),
                            INT16_C(-30009), INT16_C(-32768), INT16_C(  3187), INT16_C( 32767),
                            INT16_C( 32767), INT16_C(-27381), INT16_C(-32768), INT16_C(  3206),
                            INT16_C( 32767), INT16_C( 23800), INT16_C( 30964), INT16_C( 15226),
                            INT16_C(-11207), INT16_C(-20486), INT16_C( 30859), INT16_C(  9062)) },
    { simde_mm512_set_epi16(INT16_C(-30561), INT16_C( -5745), INT16_C( 32288), INT16_C( 11324),
                            INT16_C(-18220), INT16_C(-24874), INT16_C(-10154), INT16_C( 15837),
                            INT16_C( 22748), INT16_C(  6197), INT16_C( 23429), INT16_C(-23495),
                            INT16_C( -9809), INT16_C(-19367), INT16_C(-10631), INT16_C( -3845),
                            INT16_C( -5637), INT16_C(-22436), INT16_C(  6126), INT16_C( 16975),
                            INT16_C(  5830), INT16_C( 26963), INT16_C(-12238), INT16_C( 18631),
                            INT16_C(-23641), INT16_C(-17151), INT16_C(-13103), INT16_C(  5981),
                            INT16_C( 25710), INT16_C( 32081), INT16_C(-26911), INT16_C(-20494)),
      simde_mm512_set_epi16(INT16_C( 30869), INT16_C(-18069), INT16_C(  6380), INT16_C(-23760),
                            INT16_C( -6614), INT16_C( 32014), INT16_C( -2152), INT16_C( 25253),
                            INT16_C( -8172), INT16_C(-22416), INT16_C(  2949), INT16_C(  5712),
                            INT16_C( 30074), INT16_C( 20521), INT16_C( 28471), INT16_C( -3867),
                            INT16_C( -3892), INT16_C( 21304), INT16_C(  2611), INT16_C(  5827),
                            INT16_C(-30009), INT16_C( 31479), INT16_C(-19390), INT16_C(  1047),
                            INT16_C(-19967), INT16_C( 11404), INT16_C( 25909), INT16_C(  6741),
                            INT16_C(  1933), INT16_C(-26599), INT16_C(-25469), INT16_C(-30351)),
      simde_mm512_set_epi16(INT16_C(   308), INT16_C(-23814), INT16_C( 32767), INT16_C(-12436),
                            INT16_C(-24834), INT16_C(  7140), INT16_C(-12306), INT16_C( 32767),
                            INT16_C( 14576), INT16_C(-16219), INT16_C( 26378), INT16_C(-17783),
                            INT16_C( 20265), INT16_C(  1154), INT16_C( 17840), INT16_C( -7712),
                            INT16_C( -9529), INT16_C( -1132), INT16_C(  8737), INT16_C( 22802),
                            INT16_C(-24179), INT16_C( 32767), INT16_C(-31628), INT16_C( 19678),
                            INT16_C(-32768), INT16_C( -5747), INT16_C( 12806), INT16_C( 12722),
                            INT16_C( 27643), INT16_C(  5482), INT16_C(-32768), INT16_C(-32768)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_adds_epi16(test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_i16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_adds_epu8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_x_mm512_set_epu8(UINT8_C( 52), UINT8_C( 29), UINT8_C( 31), UINT8_C(206),
                             UINT8_C( 40), UINT8_C(160), UINT8_C(244), UINT8_C( 85),
                             UINT8_C( 47), UINT8_C(153), UINT8_C(218), UINT8_C(226),
                             UINT8_C( 99), UINT8_C(129), UINT8_C( 68), UINT8_C(218),
                             UINT8_C(122), UINT8_C( 56), UINT8_C(240), UINT8_C( 10),
                             UINT8_C(228), UINT8_C( 40), UINT8_C( 70), UINT8_C( 14),
                             UINT8_C( 67), UINT8_C( 37), UINT8_C( 87), UINT8_C(131),
                             UINT8_C( 29), UINT8_C(175), UINT8_C(167), UINT8_C(223),
                             UINT8_C(170), UINT8_C( 76), UINT8_C( 39), UINT8_C(254),
                             UINT8_C(222), UINT8_C(105), UINT8_C(193), UINT8_C(144),
                             UINT8_C(182), UINT8_C(106), UINT8_C(199), UINT8_C(161),
                             UINT8_C(173), UINT8_C( 65), UINT8_C( 54), UINT8_C(148),
                             UINT8_C(222), UINT8_C(  9), UINT8_C(237), UINT8_C( 76),
                             UINT8_C(149), UINT8_C(196), UINT8_C(194), UINT8_C(114),
                             UINT8_C(167), UINT8_C( 47), UINT8_C(174), UINT8_C(135),
                             UINT8_C(170), UINT8_C(  1), UINT8_C( 40), UINT8_C( 68)),
      simde_x_mm512_set_epu8(UINT8_C(183), UINT8_C(129), UINT8_C(214), UINT8_C( 34),
                             UINT8_C(187), UINT8_C(142), UINT8_C(238), UINT8_C(248),
                             UINT8_C(175), UINT8_C(127), UINT8_C(231), UINT8_C(164),
                             UINT8_C( 16), UINT8_C(128), UINT8_C( 32), UINT8_C( 28),
                             UINT8_C(111), UINT8_C( 40), UINT8_C(  8), UINT8_C(160),
                             UINT8_C( 37), UINT8_C(193), UINT8_C(195), UINT8_C(135),
                             UINT8_C(102), UINT8_C( 87), UINT8_C(146), UINT8_C(206),
                             UINT8_C( 94), UINT8_C(109), UINT8_C(112), UINT8_C( 83),
                             UINT8_C( 63), UINT8_C(215), UINT8_C( 46), UINT8_C( 55),
                             UINT8_C( 78), UINT8_C(211), UINT8_C(175), UINT8_C(210),
                             UINT8_C( 60), UINT8_C(205), UINT8_C(118), UINT8_C(142),
                             UINT8_C(109), UINT8_C( 48), UINT8_C( 54), UINT8_C( 54),
                             UINT8_C( 99), UINT8_C(248), UINT8_C(120), UINT8_C(165),
                             UINT8_C(189), UINT8_C(132), UINT8_C(130), UINT8_C( 16),
                             UINT8_C(  6), UINT8_C(104), UINT8_C(176), UINT8_C(111),
                             UINT8_C(254), UINT8_C(193), UINT8_C(106), UINT8_C(  5)),
      simde_x_mm512_set_epu8(UINT8_C(235), UINT8_C(158), UINT8_C(245), UINT8_C(240),
                             UINT8_C(227), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(222), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(115), UINT8_C(255), UINT8_C(100), UINT8_C(246),
                             UINT8_C(233), UINT8_C( 96), UINT8_C(248), UINT8_C(170),
                             UINT8_C(255), UINT8_C(233), UINT8_C(255), UINT8_C(149),
                             UINT8_C(169), UINT8_C(124), UINT8_C(233), UINT8_C(255),
                             UINT8_C(123), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(233), UINT8_C(255), UINT8_C( 85), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(242), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(113), UINT8_C(108), UINT8_C(202),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(241),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(130),
                             UINT8_C(173), UINT8_C(151), UINT8_C(255), UINT8_C(246),
                             UINT8_C(255), UINT8_C(194), UINT8_C(146), UINT8_C( 73)) },
    { simde_x_mm512_set_epu8(UINT8_C( 38), UINT8_C(254), UINT8_C(204), UINT8_C( 72),
                             UINT8_C(177), UINT8_C( 63), UINT8_C( 67), UINT8_C( 50),
                             UINT8_C( 71), UINT8_C(226), UINT8_C(146), UINT8_C(  4),
                             UINT8_C(134), UINT8_C( 91), UINT8_C(195), UINT8_C(148),
                             UINT8_C( 28), UINT8_C(158), UINT8_C(223), UINT8_C(181),
                             UINT8_C(218), UINT8_C(114), UINT8_C(200), UINT8_C(243),
                             UINT8_C(255), UINT8_C( 48), UINT8_C(233), UINT8_C( 82),
                             UINT8_C( 22), UINT8_C( 26), UINT8_C(128), UINT8_C(166),
                             UINT8_C( 79), UINT8_C(206), UINT8_C(109), UINT8_C(113),
                             UINT8_C( 86), UINT8_C(112), UINT8_C(215), UINT8_C(187),
                             UINT8_C(174), UINT8_C(250), UINT8_C(225), UINT8_C(206),
                             UINT8_C(242), UINT8_C(141), UINT8_C(197), UINT8_C(179),
                             UINT8_C( 88), UINT8_C(237), UINT8_C(191), UINT8_C(149),
                             UINT8_C(130), UINT8_C( 63), UINT8_C( 54), UINT8_C(129),
                             UINT8_C(126), UINT8_C( 18), UINT8_C( 43), UINT8_C(251),
                             UINT8_C(214), UINT8_C(155), UINT8_C( 61), UINT8_C(138)),
      simde_x_mm512_set_epu8(UINT8_C(142), UINT8_C( 33), UINT8_C( 51), UINT8_C(244),
                             UINT8_C( 33), UINT8_C(106), UINT8_C( 75), UINT8_C(210),
                             UINT8_C(121), UINT8_C( 52), UINT8_C(233), UINT8_C(109),
                             UINT8_C(205), UINT8_C(175), UINT8_C(230), UINT8_C( 70),
                             UINT8_C( 28), UINT8_C(216), UINT8_C( 76), UINT8_C(137),
                             UINT8_C(129), UINT8_C(  5), UINT8_C(149), UINT8_C(132),
                             UINT8_C(159), UINT8_C( 55), UINT8_C( 47), UINT8_C(212),
                             UINT8_C(202), UINT8_C( 26), UINT8_C(247), UINT8_C( 19),
                             UINT8_C(109), UINT8_C( 59), UINT8_C( 49), UINT8_C(175),
                             UINT8_C( 15), UINT8_C(240), UINT8_C(155), UINT8_C( 20),
                             UINT8_C( 85), UINT8_C( 57), UINT8_C( 91), UINT8_C(177),
                             UINT8_C(179), UINT8_C(200), UINT8_C( 26), UINT8_C( 99),
                             UINT8_C(  9), UINT8_C(177), UINT8_C(151), UINT8_C(246),
                             UINT8_C(116), UINT8_C(162), UINT8_C(144), UINT8_C( 44),
                             UINT8_C(240), UINT8_C(226), UINT8_C(215), UINT8_C(206),
                             UINT8_C(114), UINT8_C(250), UINT8_C(170), UINT8_C(220)),
      simde_x_mm512_set_epu8(UINT8_C(180), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(210), UINT8_C(169), UINT8_C(142), UINT8_C(255),
                             UINT8_C(192), UINT8_C(255), UINT8_C(255), UINT8_C(113),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(218),
                             UINT8_C( 56), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(119), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(103), UINT8_C(255), UINT8_C(255),
                             UINT8_C(224), UINT8_C( 52), UINT8_C(255), UINT8_C(185),
                             UINT8_C(188), UINT8_C(255), UINT8_C(158), UINT8_C(255),
                             UINT8_C(101), UINT8_C(255), UINT8_C(255), UINT8_C(207),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(223), UINT8_C(255),
                             UINT8_C( 97), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(246), UINT8_C(225), UINT8_C(198), UINT8_C(173),
                             UINT8_C(255), UINT8_C(244), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(231), UINT8_C(255)) },
    { simde_x_mm512_set_epu8(UINT8_C(103), UINT8_C(253), UINT8_C( 31), UINT8_C(185),
                             UINT8_C(101), UINT8_C(201), UINT8_C( 20), UINT8_C( 77),
                             UINT8_C(110), UINT8_C(116), UINT8_C(226), UINT8_C( 37),
                             UINT8_C(155), UINT8_C( 44), UINT8_C(198), UINT8_C(182),
                             UINT8_C(132), UINT8_C( 61), UINT8_C(104), UINT8_C(181),
                             UINT8_C( 77), UINT8_C(161), UINT8_C(154), UINT8_C(195),
                             UINT8_C(148), UINT8_C(239), UINT8_C(178), UINT8_C(165),
                             UINT8_C(  6), UINT8_C(251), UINT8_C( 97), UINT8_C(247),
                             UINT8_C(  8), UINT8_C( 52), UINT8_C( 96), UINT8_C( 34),
                             UINT8_C(233), UINT8_C(  1), UINT8_C(  7), UINT8_C(254),
                             UINT8_C(  3), UINT8_C(  8), UINT8_C(168), UINT8_C(221),
                             UINT8_C(238), UINT8_C(144), UINT8_C( 18), UINT8_C(245),
                             UINT8_C(216), UINT8_C(239), UINT8_C(128), UINT8_C(174),
                             UINT8_C(108), UINT8_C(236), UINT8_C(204), UINT8_C(151),
                             UINT8_C( 83), UINT8_C(224), UINT8_C(253), UINT8_C( 94),
                             UINT8_C( 40), UINT8_C( 10), UINT8_C(195), UINT8_C( 72)),
      simde_x_mm512_set_epu8(UINT8_C(196), UINT8_C(220), UINT8_C(209), UINT8_C(146),
                             UINT8_C( 66), UINT8_C(240), UINT8_C(160), UINT8_C( 58),
                             UINT8_C(206), UINT8_C(157), UINT8_C(225), UINT8_C(238),
                             UINT8_C(235), UINT8_C( 53), UINT8_C( 91), UINT8_C( 97),
                             UINT8_C(175), UINT8_C( 22), UINT8_C( 33), UINT8_C(101),
                             UINT8_C(189), UINT8_C(131), UINT8_C(219), UINT8_C( 30),
                             UINT8_C( 36), UINT8_C( 11), UINT8_C(180), UINT8_C( 46),
                             UINT8_C(126), UINT8_C(239), UINT8_C(135), UINT8_C( 44),
                             UINT8_C(198), UINT8_C(149), UINT8_C(235), UINT8_C( 72),
                             UINT8_C( 18), UINT8_C(214), UINT8_C( 92), UINT8_C(199),
                             UINT8_C( 79), UINT8_C( 28), UINT8_C(156), UINT8_C( 37),
                             UINT8_C(212), UINT8_C(167), UINT8_C( 62), UINT8_C(201),
                             UINT8_C(139), UINT8_C(215), UINT8_C( 68), UINT8_C(117),
                             UINT8_C( 83), UINT8_C(105), UINT8_C(232), UINT8_C(251),
                             UINT8_C(  6), UINT8_C(165), UINT8_C(199), UINT8_C(183),
                             UINT8_C(254), UINT8_C( 55), UINT8_C(167), UINT8_C(238)),
      simde_x_mm512_set_epu8(UINT8_C(255), UINT8_C(255), UINT8_C(240), UINT8_C(255),
                             UINT8_C(167), UINT8_C(255), UINT8_C(180), UINT8_C(135),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C( 97), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C( 83), UINT8_C(137), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(225),
                             UINT8_C(184), UINT8_C(250), UINT8_C(255), UINT8_C(211),
                             UINT8_C(132), UINT8_C(255), UINT8_C(232), UINT8_C(255),
                             UINT8_C(206), UINT8_C(201), UINT8_C(255), UINT8_C(106),
                             UINT8_C(251), UINT8_C(215), UINT8_C( 99), UINT8_C(255),
                             UINT8_C( 82), UINT8_C( 36), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C( 80), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(196), UINT8_C(255),
                             UINT8_C(191), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C( 89), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C( 65), UINT8_C(255), UINT8_C(255)) },
    { simde_x_mm512_set_epu8(UINT8_C(  7), UINT8_C( 99), UINT8_C(210), UINT8_C(110),
                             UINT8_C(202), UINT8_C( 10), UINT8_C(247), UINT8_C( 68),
                             UINT8_C(177), UINT8_C(186), UINT8_C(247), UINT8_C( 36),
                             UINT8_C(212), UINT8_C(146), UINT8_C(251), UINT8_C( 66),
                             UINT8_C(  0), UINT8_C(  8), UINT8_C(116), UINT8_C(102),
                             UINT8_C(175), UINT8_C(223), UINT8_C( 15), UINT8_C(232),
                             UINT8_C(127), UINT8_C( 63), UINT8_C( 84), UINT8_C(165),
                             UINT8_C( 18), UINT8_C(250), UINT8_C( 71), UINT8_C( 18),
                             UINT8_C(132), UINT8_C(155), UINT8_C(102), UINT8_C( 18),
                             UINT8_C(177), UINT8_C(146), UINT8_C(169), UINT8_C(139),
                             UINT8_C( 21), UINT8_C( 79), UINT8_C(  4), UINT8_C(129),
                             UINT8_C(168), UINT8_C( 42), UINT8_C(  9), UINT8_C(184),
                             UINT8_C( 46), UINT8_C( 53), UINT8_C(243), UINT8_C(140),
                             UINT8_C(158), UINT8_C(112), UINT8_C( 35), UINT8_C( 49),
                             UINT8_C(253), UINT8_C(233), UINT8_C( 33), UINT8_C(178),
                             UINT8_C(117), UINT8_C(161), UINT8_C(168), UINT8_C( 39)),
      simde_x_mm512_set_epu8(UINT8_C( 75), UINT8_C(218), UINT8_C(162), UINT8_C( 30),
                             UINT8_C(119), UINT8_C(231), UINT8_C(193), UINT8_C(230),
                             UINT8_C(151), UINT8_C( 49), UINT8_C(234), UINT8_C( 78),
                             UINT8_C( 76), UINT8_C( 37), UINT8_C(174), UINT8_C(105),
                             UINT8_C(224), UINT8_C(210), UINT8_C(188), UINT8_C(142),
                             UINT8_C(116), UINT8_C(129), UINT8_C( 93), UINT8_C(124),
                             UINT8_C(248), UINT8_C(145), UINT8_C(230), UINT8_C( 41),
                             UINT8_C( 66), UINT8_C(115), UINT8_C(180), UINT8_C( 47),
                             UINT8_C( 55), UINT8_C(104), UINT8_C(123), UINT8_C(150),
                             UINT8_C(165), UINT8_C( 22), UINT8_C(  0), UINT8_C(101),
                             UINT8_C( 55), UINT8_C( 23), UINT8_C( 90), UINT8_C( 64),
                             UINT8_C( 52), UINT8_C(254), UINT8_C(116), UINT8_C(243),
                             UINT8_C(  4), UINT8_C( 84), UINT8_C( 82), UINT8_C(103),
                             UINT8_C( 43), UINT8_C(237), UINT8_C(  7), UINT8_C( 76),
                             UINT8_C( 88), UINT8_C(212), UINT8_C( 63), UINT8_C(146),
                             UINT8_C(224), UINT8_C(223), UINT8_C(207), UINT8_C(220)),
      simde_x_mm512_set_epu8(UINT8_C( 82), UINT8_C(255), UINT8_C(255), UINT8_C(140),
                             UINT8_C(255), UINT8_C(241), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(235), UINT8_C(255), UINT8_C(114),
                             UINT8_C(255), UINT8_C(183), UINT8_C(255), UINT8_C(171),
                             UINT8_C(224), UINT8_C(218), UINT8_C(255), UINT8_C(244),
                             UINT8_C(255), UINT8_C(255), UINT8_C(108), UINT8_C(255),
                             UINT8_C(255), UINT8_C(208), UINT8_C(255), UINT8_C(206),
                             UINT8_C( 84), UINT8_C(255), UINT8_C(251), UINT8_C( 65),
                             UINT8_C(187), UINT8_C(255), UINT8_C(225), UINT8_C(168),
                             UINT8_C(255), UINT8_C(168), UINT8_C(169), UINT8_C(240),
                             UINT8_C( 76), UINT8_C(102), UINT8_C( 94), UINT8_C(193),
                             UINT8_C(220), UINT8_C(255), UINT8_C(125), UINT8_C(255),
                             UINT8_C( 50), UINT8_C(137), UINT8_C(255), UINT8_C(243),
                             UINT8_C(201), UINT8_C(255), UINT8_C( 42), UINT8_C(125),
                             UINT8_C(255), UINT8_C(255), UINT8_C( 96), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(255)) },
    { simde_x_mm512_set_epu8(UINT8_C(233), UINT8_C(112), UINT8_C( 62), UINT8_C( 65),
                             UINT8_C( 37), UINT8_C(247), UINT8_C(105), UINT8_C( 54),
                             UINT8_C(214), UINT8_C(255), UINT8_C(145), UINT8_C( 18),
                             UINT8_C(160), UINT8_C( 92), UINT8_C( 29), UINT8_C(253),
                             UINT8_C(230), UINT8_C( 83), UINT8_C(176), UINT8_C( 43),
                             UINT8_C( 78), UINT8_C( 31), UINT8_C(113), UINT8_C(239),
                             UINT8_C( 38), UINT8_C(192), UINT8_C(127), UINT8_C( 44),
                             UINT8_C(218), UINT8_C(134), UINT8_C(224), UINT8_C( 35),
                             UINT8_C(155), UINT8_C(171), UINT8_C( 44), UINT8_C( 53),
                             UINT8_C(101), UINT8_C(234), UINT8_C(121), UINT8_C( 95),
                             UINT8_C(232), UINT8_C(104), UINT8_C( 20), UINT8_C( 52),
                             UINT8_C( 59), UINT8_C( 62), UINT8_C( 55), UINT8_C( 43),
                             UINT8_C(246), UINT8_C( 36), UINT8_C( 25), UINT8_C( 98),
                             UINT8_C(155), UINT8_C(231), UINT8_C( 43), UINT8_C(203),
                             UINT8_C( 77), UINT8_C( 43), UINT8_C( 80), UINT8_C( 85),
                             UINT8_C(227), UINT8_C( 34), UINT8_C( 77), UINT8_C(179)),
      simde_x_mm512_set_epu8(UINT8_C( 68), UINT8_C(183), UINT8_C(190), UINT8_C(248),
                             UINT8_C( 54), UINT8_C(194), UINT8_C(  0), UINT8_C(190),
                             UINT8_C(102), UINT8_C(185), UINT8_C(  5), UINT8_C(238),
                             UINT8_C(188), UINT8_C(104), UINT8_C(139), UINT8_C(163),
                             UINT8_C(242), UINT8_C( 94), UINT8_C(181), UINT8_C(214),
                             UINT8_C(170), UINT8_C(182), UINT8_C(139), UINT8_C( 96),
                             UINT8_C( 80), UINT8_C( 38), UINT8_C(151), UINT8_C(132),
                             UINT8_C(243), UINT8_C( 37), UINT8_C(120), UINT8_C( 30),
                             UINT8_C(115), UINT8_C( 34), UINT8_C(222), UINT8_C(121),
                             UINT8_C(112), UINT8_C(205), UINT8_C(161), UINT8_C( 52),
                             UINT8_C(142), UINT8_C(118), UINT8_C(195), UINT8_C(200),
                             UINT8_C( 59), UINT8_C(  6), UINT8_C(115), UINT8_C(109),
                             UINT8_C( 93), UINT8_C(174), UINT8_C(200), UINT8_C(190),
                             UINT8_C(151), UINT8_C(126), UINT8_C(210), UINT8_C(200),
                             UINT8_C( 79), UINT8_C( 43), UINT8_C( 20), UINT8_C(239),
                             UINT8_C(149), UINT8_C(119), UINT8_C( 96), UINT8_C(120)),
      simde_x_mm512_set_epu8(UINT8_C(255), UINT8_C(255), UINT8_C(252), UINT8_C(255),
                             UINT8_C( 91), UINT8_C(255), UINT8_C(105), UINT8_C(244),
                             UINT8_C(255), UINT8_C(255), UINT8_C(150), UINT8_C(255),
                             UINT8_C(255), UINT8_C(196), UINT8_C(168), UINT8_C(255),
                             UINT8_C(255), UINT8_C(177), UINT8_C(255), UINT8_C(255),
                             UINT8_C(248), UINT8_C(213), UINT8_C(252), UINT8_C(255),
                             UINT8_C(118), UINT8_C(230), UINT8_C(255), UINT8_C(176),
                             UINT8_C(255), UINT8_C(171), UINT8_C(255), UINT8_C( 65),
                             UINT8_C(255), UINT8_C(205), UINT8_C(255), UINT8_C(174),
                             UINT8_C(213), UINT8_C(255), UINT8_C(255), UINT8_C(147),
                             UINT8_C(255), UINT8_C(222), UINT8_C(215), UINT8_C(252),
                             UINT8_C(118), UINT8_C( 68), UINT8_C(170), UINT8_C(152),
                             UINT8_C(255), UINT8_C(210), UINT8_C(225), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(253), UINT8_C(255),
                             UINT8_C(156), UINT8_C( 86), UINT8_C(100), UINT8_C(255),
                             UINT8_C(255), UINT8_C(153), UINT8_C(173), UINT8_C(255)) },
    { simde_x_mm512_set_epu8(UINT8_C(150), UINT8_C(150), UINT8_C(146), UINT8_C(157),
                             UINT8_C(103), UINT8_C( 31), UINT8_C(236), UINT8_C(192),
                             UINT8_C(155), UINT8_C( 46), UINT8_C(170), UINT8_C(176),
                             UINT8_C(189), UINT8_C( 74), UINT8_C(246), UINT8_C(  0),
                             UINT8_C( 85), UINT8_C( 30), UINT8_C(190), UINT8_C( 12),
                             UINT8_C(117), UINT8_C( 74), UINT8_C(194), UINT8_C( 97),
                             UINT8_C(132), UINT8_C( 63), UINT8_C(227), UINT8_C( 21),
                             UINT8_C(244), UINT8_C(229), UINT8_C(176), UINT8_C(122),
                             UINT8_C(159), UINT8_C( 35), UINT8_C(115), UINT8_C(240),
                             UINT8_C( 88), UINT8_C(151), UINT8_C(101), UINT8_C(194),
                             UINT8_C( 49), UINT8_C(128), UINT8_C( 87), UINT8_C(152),
                             UINT8_C(173), UINT8_C(242), UINT8_C(150), UINT8_C( 26),
                             UINT8_C(183), UINT8_C( 56), UINT8_C(181), UINT8_C(193),
                             UINT8_C(231), UINT8_C(135), UINT8_C(190), UINT8_C( 42),
                             UINT8_C( 33), UINT8_C(174), UINT8_C( 57), UINT8_C(232),
                             UINT8_C(176), UINT8_C(125), UINT8_C( 87), UINT8_C( 79)),
      simde_x_mm512_set_epu8(UINT8_C( 68), UINT8_C(  1), UINT8_C(208), UINT8_C( 74),
                             UINT8_C(102), UINT8_C(168), UINT8_C( 41), UINT8_C( 41),
                             UINT8_C( 83), UINT8_C( 95), UINT8_C(152), UINT8_C(131),
                             UINT8_C(230), UINT8_C( 27), UINT8_C(126), UINT8_C(230),
                             UINT8_C(128), UINT8_C(133), UINT8_C(107), UINT8_C(197),
                             UINT8_C( 23), UINT8_C(  2), UINT8_C(108), UINT8_C(207),
                             UINT8_C( 82), UINT8_C(175), UINT8_C(247), UINT8_C(180),
                             UINT8_C( 57), UINT8_C( 31), UINT8_C(124), UINT8_C(203),
                             UINT8_C(246), UINT8_C(195), UINT8_C(173), UINT8_C(161),
                             UINT8_C(132), UINT8_C(162), UINT8_C( 13), UINT8_C(205),
                             UINT8_C(225), UINT8_C( 25), UINT8_C( 39), UINT8_C(181),
                             UINT8_C(149), UINT8_C(149), UINT8_C(138), UINT8_C(158),
                             UINT8_C(215), UINT8_C(147), UINT8_C(  0), UINT8_C( 87),
                             UINT8_C(244), UINT8_C( 10), UINT8_C(  1), UINT8_C( 19),
                             UINT8_C(173), UINT8_C(221), UINT8_C(118), UINT8_C( 51),
                             UINT8_C( 98), UINT8_C(183), UINT8_C(125), UINT8_C( 92)),
      simde_x_mm512_set_epu8(UINT8_C(218), UINT8_C(151), UINT8_C(255), UINT8_C(231),
                             UINT8_C(205), UINT8_C(199), UINT8_C(255), UINT8_C(233),
                             UINT8_C(238), UINT8_C(141), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(101), UINT8_C(255), UINT8_C(230),
                             UINT8_C(213), UINT8_C(163), UINT8_C(255), UINT8_C(209),
                             UINT8_C(140), UINT8_C( 76), UINT8_C(255), UINT8_C(255),
                             UINT8_C(214), UINT8_C(238), UINT8_C(255), UINT8_C(201),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(230), UINT8_C(255), UINT8_C(255),
                             UINT8_C(220), UINT8_C(255), UINT8_C(114), UINT8_C(255),
                             UINT8_C(255), UINT8_C(153), UINT8_C(126), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(184),
                             UINT8_C(255), UINT8_C(203), UINT8_C(181), UINT8_C(255),
                             UINT8_C(255), UINT8_C(145), UINT8_C(191), UINT8_C( 61),
                             UINT8_C(206), UINT8_C(255), UINT8_C(175), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(212), UINT8_C(171)) },
    { simde_x_mm512_set_epu8(UINT8_C(166), UINT8_C(112), UINT8_C( 16), UINT8_C( 20),
                             UINT8_C(189), UINT8_C( 23), UINT8_C( 28), UINT8_C(226),
                             UINT8_C( 92), UINT8_C(105), UINT8_C(249), UINT8_C( 71),
                             UINT8_C( 22), UINT8_C(153), UINT8_C( 38), UINT8_C( 58),
                             UINT8_C( 86), UINT8_C(191), UINT8_C( 97), UINT8_C(186),
                             UINT8_C(117), UINT8_C( 93), UINT8_C( 63), UINT8_C(142),
                             UINT8_C( 82), UINT8_C(123), UINT8_C(210), UINT8_C(159),
                             UINT8_C(175), UINT8_C(187), UINT8_C( 33), UINT8_C(134),
                             UINT8_C(156), UINT8_C(243), UINT8_C(191), UINT8_C(139),
                             UINT8_C(173), UINT8_C( 70), UINT8_C(113), UINT8_C( 30),
                             UINT8_C(184), UINT8_C( 82), UINT8_C(234), UINT8_C(177),
                             UINT8_C(234), UINT8_C(131), UINT8_C(180), UINT8_C( 12),
                             UINT8_C( 47), UINT8_C(213), UINT8_C( 54), UINT8_C(222),
                             UINT8_C(114), UINT8_C(251), UINT8_C(236), UINT8_C( 57),
                             UINT8_C(205), UINT8_C(187), UINT8_C( 48), UINT8_C(112),
                             UINT8_C( 34), UINT8_C( 49), UINT8_C( 95), UINT8_C(198)),
      simde_x_mm512_set_epu8(UINT8_C(116), UINT8_C(101), UINT8_C(212), UINT8_C(199),
                             UINT8_C( 88), UINT8_C(165), UINT8_C(253), UINT8_C( 88),
                             UINT8_C(138), UINT8_C( 27), UINT8_C(153), UINT8_C(155),
                             UINT8_C(248), UINT8_C(175), UINT8_C(152), UINT8_C(246),
                             UINT8_C( 17), UINT8_C(224), UINT8_C( 49), UINT8_C(127),
                             UINT8_C(200), UINT8_C( 46), UINT8_C( 58), UINT8_C(159),
                             UINT8_C(177), UINT8_C( 24), UINT8_C(139), UINT8_C(240),
                             UINT8_C( 45), UINT8_C(115), UINT8_C(179), UINT8_C(230),
                             UINT8_C(249), UINT8_C(217), UINT8_C(202), UINT8_C( 21),
                             UINT8_C(134), UINT8_C(111), UINT8_C( 79), UINT8_C(153),
                             UINT8_C(130), UINT8_C( 83), UINT8_C(196), UINT8_C(101),
                             UINT8_C(151), UINT8_C(117), UINT8_C(152), UINT8_C(155),
                             UINT8_C(116), UINT8_C(201), UINT8_C(241), UINT8_C( 71),
                             UINT8_C( 24), UINT8_C(105), UINT8_C(212), UINT8_C(191),
                             UINT8_C(  1), UINT8_C(252), UINT8_C( 15), UINT8_C( 49),
                             UINT8_C(105), UINT8_C(159), UINT8_C(109), UINT8_C( 31)),
      simde_x_mm512_set_epu8(UINT8_C(255), UINT8_C(213), UINT8_C(228), UINT8_C(219),
                             UINT8_C(255), UINT8_C(188), UINT8_C(255), UINT8_C(255),
                             UINT8_C(230), UINT8_C(132), UINT8_C(255), UINT8_C(226),
                             UINT8_C(255), UINT8_C(255), UINT8_C(190), UINT8_C(255),
                             UINT8_C(103), UINT8_C(255), UINT8_C(146), UINT8_C(255),
                             UINT8_C(255), UINT8_C(139), UINT8_C(121), UINT8_C(255),
                             UINT8_C(255), UINT8_C(147), UINT8_C(255), UINT8_C(255),
                             UINT8_C(220), UINT8_C(255), UINT8_C(212), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(160),
                             UINT8_C(255), UINT8_C(181), UINT8_C(192), UINT8_C(183),
                             UINT8_C(255), UINT8_C(165), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(248), UINT8_C(255), UINT8_C(167),
                             UINT8_C(163), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(138), UINT8_C(255), UINT8_C(255), UINT8_C(248),
                             UINT8_C(206), UINT8_C(255), UINT8_C( 63), UINT8_C(161),
                             UINT8_C(139), UINT8_C(208), UINT8_C(204), UINT8_C(229)) },
    { simde_x_mm512_set_epu8(UINT8_C(239), UINT8_C(174), UINT8_C( 81), UINT8_C( 89),
                             UINT8_C( 63), UINT8_C(160), UINT8_C(219), UINT8_C(204),
                             UINT8_C(161), UINT8_C(  4), UINT8_C(134), UINT8_C(137),
                             UINT8_C( 48), UINT8_C( 33), UINT8_C(178), UINT8_C(122),
                             UINT8_C( 99), UINT8_C(167), UINT8_C( 95), UINT8_C(109),
                             UINT8_C( 38), UINT8_C(191), UINT8_C(  3), UINT8_C( 48),
                             UINT8_C(143), UINT8_C( 51), UINT8_C( 81), UINT8_C( 76),
                             UINT8_C(251), UINT8_C(204), UINT8_C(198), UINT8_C(  1),
                             UINT8_C(175), UINT8_C(123), UINT8_C( 24), UINT8_C(237),
                             UINT8_C(190), UINT8_C( 62), UINT8_C( 87), UINT8_C(255),
                             UINT8_C(119), UINT8_C(202), UINT8_C(  4), UINT8_C( 40),
                             UINT8_C(152), UINT8_C(128), UINT8_C(116), UINT8_C( 72),
                             UINT8_C(245), UINT8_C(148), UINT8_C( 39), UINT8_C(106),
                             UINT8_C(195), UINT8_C(186), UINT8_C(241), UINT8_C(178),
                             UINT8_C( 68), UINT8_C(210), UINT8_C( 61), UINT8_C(218),
                             UINT8_C(116), UINT8_C( 98), UINT8_C( 41), UINT8_C( 22)),
      simde_x_mm512_set_epu8(UINT8_C(  3), UINT8_C(245), UINT8_C(  8), UINT8_C(179),
                             UINT8_C(242), UINT8_C( 19), UINT8_C(107), UINT8_C(170),
                             UINT8_C(178), UINT8_C(175), UINT8_C(174), UINT8_C(170),
                             UINT8_C( 72), UINT8_C(195), UINT8_C(199), UINT8_C( 66),
                             UINT8_C(182), UINT8_C(183), UINT8_C( 58), UINT8_C(245),
                             UINT8_C( 62), UINT8_C( 31), UINT8_C( 93), UINT8_C( 74),
                             UINT8_C(114), UINT8_C( 92), UINT8_C(199), UINT8_C( 53),
                             UINT8_C( 94), UINT8_C(185), UINT8_C(107), UINT8_C(124),
                             UINT8_C(160), UINT8_C(193), UINT8_C( 17), UINT8_C( 65),
                             UINT8_C(242), UINT8_C( 55), UINT8_C(163), UINT8_C(102),
                             UINT8_C( 59), UINT8_C(173), UINT8_C(244), UINT8_C(232),
                             UINT8_C(182), UINT8_C(139), UINT8_C(254), UINT8_C( 81),
                             UINT8_C(228), UINT8_C(175), UINT8_C(104), UINT8_C(167),
                             UINT8_C( 38), UINT8_C(114), UINT8_C(184), UINT8_C(118),
                             UINT8_C(167), UINT8_C( 58), UINT8_C(153), UINT8_C(103),
                             UINT8_C(204), UINT8_C(126), UINT8_C(111), UINT8_C( 63)),
      simde_x_mm512_set_epu8(UINT8_C(242), UINT8_C(255), UINT8_C( 89), UINT8_C(255),
                             UINT8_C(255), UINT8_C(179), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(179), UINT8_C(255), UINT8_C(255),
                             UINT8_C(120), UINT8_C(228), UINT8_C(255), UINT8_C(188),
                             UINT8_C(255), UINT8_C(255), UINT8_C(153), UINT8_C(255),
                             UINT8_C(100), UINT8_C(222), UINT8_C( 96), UINT8_C(122),
                             UINT8_C(255), UINT8_C(143), UINT8_C(255), UINT8_C(129),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(125),
                             UINT8_C(255), UINT8_C(255), UINT8_C( 41), UINT8_C(255),
                             UINT8_C(255), UINT8_C(117), UINT8_C(250), UINT8_C(255),
                             UINT8_C(178), UINT8_C(255), UINT8_C(248), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(153),
                             UINT8_C(255), UINT8_C(255), UINT8_C(143), UINT8_C(255),
                             UINT8_C(233), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(235), UINT8_C(255), UINT8_C(214), UINT8_C(255),
                             UINT8_C(255), UINT8_C(224), UINT8_C(152), UINT8_C( 85)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_adds_epu8(test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_u8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_mask_adds_epu8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i src;
    simde__mmask64 k;
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_x_mm512_set_epu8(UINT8_C(  92), UINT8_C( 116), UINT8_C( 178), UINT8_C( 237),
                             UINT8_C( 183), UINT8_C(  22), UINT8_C( 190), UINT8_C( 227),
                             UINT8_C(  55), UINT8_C(  78), UINT8_C( 211), UINT8_C( 137),
                             UINT8_C(  30), UINT8_C( 227), UINT8_C( 233), UINT8_C(  89),
                             UINT8_C(  15), UINT8_C( 119), UINT8_C( 168), UINT8_C( 109),
                             UINT8_C( 240), UINT8_C( 246), UINT8_C(   0), UINT8_C( 238),
                             UINT8_C(   1), UINT8_C( 116), UINT8_C(  62), UINT8_C( 183),
                             UINT8_C( 134), UINT8_C(   0), UINT8_C( 111), UINT8_C(  95),
                             UINT8_C( 236), UINT8_C(   3), UINT8_C( 122), UINT8_C( 135),
                             UINT8_C(  13), UINT8_C(  25), UINT8_C( 221), UINT8_C( 129),
                             UINT8_C(  82), UINT8_C(  90), UINT8_C(  53), UINT8_C( 123),
                             UINT8_C(  73), UINT8_C( 108), UINT8_C( 238), UINT8_C(  15),
                             UINT8_C(  81), UINT8_C( 229), UINT8_C( 102), UINT8_C( 118),
                             UINT8_C(  39), UINT8_C( 179), UINT8_C(  45), UINT8_C(  81),
                             UINT8_C( 239), UINT8_C( 228), UINT8_C(  67), UINT8_C( 138),
                             UINT8_C(  79), UINT8_C( 143), UINT8_C( 134), UINT8_C( 124)),
      UINT64_C(10224647434006242820),
      simde_x_mm512_set_epu8(UINT8_C(  68), UINT8_C( 148), UINT8_C( 135), UINT8_C( 141),
                             UINT8_C( 197), UINT8_C( 178), UINT8_C( 145), UINT8_C(  56),
                             UINT8_C(   9), UINT8_C( 135), UINT8_C( 120), UINT8_C( 220),
                             UINT8_C(  36), UINT8_C( 153), UINT8_C( 152), UINT8_C(  25),
                             UINT8_C( 145), UINT8_C( 193), UINT8_C( 221), UINT8_C( 136),
                             UINT8_C(  28), UINT8_C( 212), UINT8_C( 230), UINT8_C( 170),
                             UINT8_C( 243), UINT8_C(  53), UINT8_C( 168), UINT8_C( 149),
                             UINT8_C(  68), UINT8_C(  42), UINT8_C( 138), UINT8_C( 111),
                             UINT8_C(  54), UINT8_C( 198), UINT8_C( 243), UINT8_C(  27),
                             UINT8_C(  23), UINT8_C(  41), UINT8_C( 137), UINT8_C(  44),
                             UINT8_C(   7), UINT8_C( 136), UINT8_C(  32), UINT8_C( 213),
                             UINT8_C( 114), UINT8_C( 184), UINT8_C(  73), UINT8_C( 160),
                             UINT8_C(  96), UINT8_C( 110), UINT8_C( 175), UINT8_C( 180),
                             UINT8_C( 103), UINT8_C( 156), UINT8_C( 234), UINT8_C(  18),
                             UINT8_C( 115), UINT8_C(  54), UINT8_C( 216), UINT8_C( 125),
                             UINT8_C( 110), UINT8_C(  31), UINT8_C(  51), UINT8_C( 152)),
      simde_x_mm512_set_epu8(UINT8_C( 242), UINT8_C(  85), UINT8_C( 176), UINT8_C(  80),
                             UINT8_C(  48), UINT8_C(  93), UINT8_C(  79), UINT8_C( 127),
                             UINT8_C(  16), UINT8_C(  41), UINT8_C(  54), UINT8_C( 140),
                             UINT8_C(  17), UINT8_C(  42), UINT8_C( 170), UINT8_C(  38),
                             UINT8_C( 138), UINT8_C( 200), UINT8_C(  60), UINT8_C(  19),
                             UINT8_C( 156), UINT8_C( 149), UINT8_C( 105), UINT8_C( 180),
                             UINT8_C(  10), UINT8_C( 247), UINT8_C( 244), UINT8_C( 200),
                             UINT8_C( 185), UINT8_C(  96), UINT8_C(   6), UINT8_C(  24),
                             UINT8_C(  69), UINT8_C(  73), UINT8_C( 229), UINT8_C(   3),
                             UINT8_C( 161), UINT8_C(  50), UINT8_C( 189), UINT8_C( 217),
                             UINT8_C(  97), UINT8_C(  62), UINT8_C( 101), UINT8_C(  56),
                             UINT8_C( 177), UINT8_C(  83), UINT8_C( 157), UINT8_C( 200),
                             UINT8_C( 239), UINT8_C( 200), UINT8_C( 248), UINT8_C( 240),
                             UINT8_C(  84), UINT8_C( 161), UINT8_C( 183), UINT8_C(  54),
                             UINT8_C( 125), UINT8_C(  85), UINT8_C(  78), UINT8_C( 191),
                             UINT8_C(   4), UINT8_C( 113), UINT8_C( 240), UINT8_C( 203)),
      simde_x_mm512_set_epu8(UINT8_C( 255), UINT8_C( 116), UINT8_C( 178), UINT8_C( 237),
                             UINT8_C( 245), UINT8_C( 255), UINT8_C( 190), UINT8_C( 183),
                             UINT8_C(  25), UINT8_C( 176), UINT8_C( 174), UINT8_C( 137),
                             UINT8_C(  30), UINT8_C( 195), UINT8_C( 233), UINT8_C(  63),
                             UINT8_C(  15), UINT8_C( 119), UINT8_C( 255), UINT8_C( 155),
                             UINT8_C( 184), UINT8_C( 255), UINT8_C( 255), UINT8_C( 238),
                             UINT8_C( 253), UINT8_C( 116), UINT8_C( 255), UINT8_C( 183),
                             UINT8_C( 253), UINT8_C(   0), UINT8_C( 144), UINT8_C( 135),
                             UINT8_C( 236), UINT8_C(   3), UINT8_C( 255), UINT8_C(  30),
                             UINT8_C(  13), UINT8_C(  25), UINT8_C( 221), UINT8_C( 255),
                             UINT8_C( 104), UINT8_C(  90), UINT8_C(  53), UINT8_C( 123),
                             UINT8_C( 255), UINT8_C( 255), UINT8_C( 238), UINT8_C( 255),
                             UINT8_C(  81), UINT8_C( 229), UINT8_C( 255), UINT8_C( 118),
                             UINT8_C(  39), UINT8_C( 255), UINT8_C( 255), UINT8_C(  81),
                             UINT8_C( 239), UINT8_C( 228), UINT8_C(  67), UINT8_C( 138),
                             UINT8_C(  79), UINT8_C( 144), UINT8_C( 134), UINT8_C( 124)) },
    { simde_x_mm512_set_epu8(UINT8_C( 133), UINT8_C( 156), UINT8_C( 217), UINT8_C( 212),
                             UINT8_C(  22), UINT8_C( 112), UINT8_C(  16), UINT8_C(  15),
                             UINT8_C( 152), UINT8_C( 154), UINT8_C( 102), UINT8_C( 161),
                             UINT8_C(  69), UINT8_C(  13), UINT8_C( 235), UINT8_C(  45),
                             UINT8_C(  62), UINT8_C( 136), UINT8_C( 145), UINT8_C(  32),
                             UINT8_C( 149), UINT8_C( 226), UINT8_C(  99), UINT8_C( 192),
                             UINT8_C(   8), UINT8_C( 214), UINT8_C(  81), UINT8_C( 222),
                             UINT8_C( 210), UINT8_C(  26), UINT8_C(  31), UINT8_C( 254),
                             UINT8_C(  68), UINT8_C( 249), UINT8_C( 185), UINT8_C(  46),
                             UINT8_C( 235), UINT8_C( 183), UINT8_C(  21), UINT8_C(  83),
                             UINT8_C( 148), UINT8_C( 159), UINT8_C( 187), UINT8_C(  73),
                             UINT8_C(  57), UINT8_C( 219), UINT8_C(  21), UINT8_C(  82),
                             UINT8_C( 137), UINT8_C( 130), UINT8_C( 126), UINT8_C(  91),
                             UINT8_C( 115), UINT8_C(  31), UINT8_C( 177), UINT8_C(  28),
                             UINT8_C( 150), UINT8_C( 238), UINT8_C(  65), UINT8_C( 152),
                             UINT8_C(  81), UINT8_C(  38), UINT8_C( 172), UINT8_C( 254)),
      UINT64_C( 4597426592773770833),
      simde_x_mm512_set_epu8(UINT8_C(  74), UINT8_C(  72), UINT8_C( 252), UINT8_C(  28),
                             UINT8_C( 141), UINT8_C(  93), UINT8_C( 102), UINT8_C(  44),
                             UINT8_C( 153), UINT8_C( 227), UINT8_C( 206), UINT8_C(  48),
                             UINT8_C( 160), UINT8_C( 206), UINT8_C(  46), UINT8_C( 191),
                             UINT8_C(   4), UINT8_C(  43), UINT8_C( 181), UINT8_C(  97),
                             UINT8_C( 230), UINT8_C( 153), UINT8_C(  71), UINT8_C( 149),
                             UINT8_C(  91), UINT8_C(  45), UINT8_C( 245), UINT8_C(  47),
                             UINT8_C(  29), UINT8_C(  25), UINT8_C(  26), UINT8_C( 247),
                             UINT8_C(  10), UINT8_C(  36), UINT8_C( 177), UINT8_C( 203),
                             UINT8_C(  41), UINT8_C(   1), UINT8_C( 233), UINT8_C( 193),
                             UINT8_C( 129), UINT8_C(  68), UINT8_C(  48), UINT8_C(  36),
                             UINT8_C(  89), UINT8_C( 144), UINT8_C( 225), UINT8_C( 120),
                             UINT8_C(  35), UINT8_C(  62), UINT8_C( 235), UINT8_C( 142),
                             UINT8_C( 152), UINT8_C(  57), UINT8_C(  42), UINT8_C( 145),
                             UINT8_C(  94), UINT8_C( 193), UINT8_C( 247), UINT8_C(  64),
                             UINT8_C( 191), UINT8_C( 254), UINT8_C( 110), UINT8_C( 248)),
      simde_x_mm512_set_epu8(UINT8_C(  44), UINT8_C( 164), UINT8_C( 225), UINT8_C(  26),
                             UINT8_C( 157), UINT8_C( 203), UINT8_C( 117), UINT8_C(  18),
                             UINT8_C( 193), UINT8_C(  45), UINT8_C(  12), UINT8_C(  24),
                             UINT8_C( 148), UINT8_C(  18), UINT8_C( 196), UINT8_C(  28),
                             UINT8_C(  50), UINT8_C( 245), UINT8_C( 188), UINT8_C( 225),
                             UINT8_C( 105), UINT8_C( 150), UINT8_C(  98), UINT8_C(  51),
                             UINT8_C(  58), UINT8_C( 103), UINT8_C( 111), UINT8_C( 129),
                             UINT8_C(  68), UINT8_C( 200), UINT8_C( 124), UINT8_C( 137),
                             UINT8_C(  74), UINT8_C( 194), UINT8_C( 140), UINT8_C(  37),
                             UINT8_C( 244), UINT8_C( 114), UINT8_C(   0), UINT8_C(  61),
                             UINT8_C( 103), UINT8_C( 252), UINT8_C( 151), UINT8_C( 188),
                             UINT8_C(  39), UINT8_C( 156), UINT8_C( 163), UINT8_C(  11),
                             UINT8_C( 176), UINT8_C( 237), UINT8_C( 234), UINT8_C( 217),
                             UINT8_C( 127), UINT8_C( 218), UINT8_C( 131), UINT8_C( 145),
                             UINT8_C(  84), UINT8_C( 160), UINT8_C(  87), UINT8_C( 234),
                             UINT8_C( 251), UINT8_C( 253), UINT8_C( 129), UINT8_C(  41)),
      simde_x_mm512_set_epu8(UINT8_C( 133), UINT8_C( 156), UINT8_C( 255), UINT8_C(  54),
                             UINT8_C( 255), UINT8_C( 255), UINT8_C( 219), UINT8_C(  62),
                             UINT8_C( 255), UINT8_C( 255), UINT8_C( 102), UINT8_C( 161),
                             UINT8_C( 255), UINT8_C( 224), UINT8_C( 235), UINT8_C( 219),
                             UINT8_C(  62), UINT8_C( 255), UINT8_C( 145), UINT8_C( 255),
                             UINT8_C( 149), UINT8_C( 255), UINT8_C( 169), UINT8_C( 200),
                             UINT8_C(   8), UINT8_C( 214), UINT8_C( 255), UINT8_C( 222),
                             UINT8_C( 210), UINT8_C(  26), UINT8_C(  31), UINT8_C( 254),
                             UINT8_C(  84), UINT8_C( 249), UINT8_C( 255), UINT8_C( 240),
                             UINT8_C( 255), UINT8_C( 115), UINT8_C( 233), UINT8_C( 254),
                             UINT8_C( 148), UINT8_C( 159), UINT8_C( 199), UINT8_C( 224),
                             UINT8_C(  57), UINT8_C( 255), UINT8_C( 255), UINT8_C( 131),
                             UINT8_C( 137), UINT8_C( 130), UINT8_C( 126), UINT8_C(  91),
                             UINT8_C( 255), UINT8_C( 255), UINT8_C( 173), UINT8_C(  28),
                             UINT8_C( 150), UINT8_C( 255), UINT8_C(  65), UINT8_C( 255),
                             UINT8_C(  81), UINT8_C(  38), UINT8_C( 172), UINT8_C( 255)) },
    { simde_x_mm512_set_epu8(UINT8_C( 226), UINT8_C( 219), UINT8_C(  51), UINT8_C( 220),
                             UINT8_C(   8), UINT8_C(  52), UINT8_C(  97), UINT8_C( 123),
                             UINT8_C( 207), UINT8_C( 132), UINT8_C(  95), UINT8_C( 173),
                             UINT8_C(  70), UINT8_C( 206), UINT8_C( 195), UINT8_C(  25),
                             UINT8_C( 159), UINT8_C(  28), UINT8_C( 198), UINT8_C(  11),
                             UINT8_C( 242), UINT8_C( 126), UINT8_C(  81), UINT8_C(  45),
                             UINT8_C( 233), UINT8_C( 120), UINT8_C( 173), UINT8_C( 240),
                             UINT8_C(   7), UINT8_C(  51), UINT8_C( 199), UINT8_C( 206),
                             UINT8_C( 235), UINT8_C(  98), UINT8_C(  88), UINT8_C(   0),
                             UINT8_C( 190), UINT8_C(   3), UINT8_C( 124), UINT8_C( 143),
                             UINT8_C(  50), UINT8_C(  88), UINT8_C( 171), UINT8_C( 163),
                             UINT8_C( 212), UINT8_C( 243), UINT8_C( 162), UINT8_C(  17),
                             UINT8_C( 254), UINT8_C(  79), UINT8_C( 140), UINT8_C(  43),
                             UINT8_C( 179), UINT8_C( 131), UINT8_C( 233), UINT8_C( 136),
                             UINT8_C(  96), UINT8_C( 192), UINT8_C( 233), UINT8_C( 210),
                             UINT8_C( 227), UINT8_C( 185), UINT8_C(  71), UINT8_C(  90)),
      UINT64_C(12627002542648829104),
      simde_x_mm512_set_epu8(UINT8_C(  56), UINT8_C( 211), UINT8_C( 148), UINT8_C( 237),
                             UINT8_C( 132), UINT8_C( 229), UINT8_C(  22), UINT8_C( 126),
                             UINT8_C( 150), UINT8_C( 188), UINT8_C( 196), UINT8_C(   8),
                             UINT8_C(  60), UINT8_C(  93), UINT8_C( 223), UINT8_C( 229),
                             UINT8_C( 249), UINT8_C(  27), UINT8_C( 134), UINT8_C( 218),
                             UINT8_C(  23), UINT8_C(   6), UINT8_C(  45), UINT8_C( 235),
                             UINT8_C( 233), UINT8_C( 155), UINT8_C( 116), UINT8_C( 127),
                             UINT8_C(  96), UINT8_C(  40), UINT8_C( 159), UINT8_C(  40),
                             UINT8_C(  86), UINT8_C( 212), UINT8_C(  70), UINT8_C( 185),
                             UINT8_C(  62), UINT8_C( 235), UINT8_C(  66), UINT8_C(  68),
                             UINT8_C( 169), UINT8_C( 195), UINT8_C(  48), UINT8_C( 186),
                             UINT8_C(  18), UINT8_C( 178), UINT8_C( 158), UINT8_C( 117),
                             UINT8_C(  74), UINT8_C(  32), UINT8_C(  93), UINT8_C( 125),
                             UINT8_C( 209), UINT8_C( 196), UINT8_C( 170), UINT8_C( 117),
                             UINT8_C( 122), UINT8_C( 202), UINT8_C(  50), UINT8_C( 123),
                             UINT8_C( 225), UINT8_C( 182), UINT8_C( 192), UINT8_C(  54)),
      simde_x_mm512_set_epu8(UINT8_C( 115), UINT8_C(  51), UINT8_C( 165), UINT8_C(  56),
                             UINT8_C(  64), UINT8_C( 217), UINT8_C( 137), UINT8_C( 228),
                             UINT8_C( 202), UINT8_C(  28), UINT8_C(  54), UINT8_C( 248),
                             UINT8_C( 202), UINT8_C( 128), UINT8_C( 228), UINT8_C( 185),
                             UINT8_C( 107), UINT8_C( 190), UINT8_C( 142), UINT8_C( 168),
                             UINT8_C(  34), UINT8_C( 173), UINT8_C( 235), UINT8_C( 192),
                             UINT8_C( 121), UINT8_C( 236), UINT8_C( 167), UINT8_C( 162),
                             UINT8_C( 112), UINT8_C( 229), UINT8_C(  81), UINT8_C( 202),
                             UINT8_C( 192), UINT8_C( 142), UINT8_C(  48), UINT8_C( 167),
                             UINT8_C( 195), UINT8_C(  26), UINT8_C(  43), UINT8_C(  29),
                             UINT8_C(   0), UINT8_C(  64), UINT8_C( 123), UINT8_C( 189),
                             UINT8_C(  15), UINT8_C( 120), UINT8_C(  36), UINT8_C(  40),
                             UINT8_C( 106), UINT8_C( 138), UINT8_C( 148), UINT8_C( 198),
                             UINT8_C(  26), UINT8_C( 145), UINT8_C(  63), UINT8_C( 158),
                             UINT8_C( 243), UINT8_C( 244), UINT8_C( 132), UINT8_C(  96),
                             UINT8_C( 243), UINT8_C( 158), UINT8_C(  99), UINT8_C( 243)),
      simde_x_mm512_set_epu8(UINT8_C( 171), UINT8_C( 219), UINT8_C( 255), UINT8_C( 220),
                             UINT8_C( 196), UINT8_C( 255), UINT8_C( 159), UINT8_C( 255),
                             UINT8_C( 207), UINT8_C( 132), UINT8_C( 250), UINT8_C( 255),
                             UINT8_C( 255), UINT8_C( 221), UINT8_C( 195), UINT8_C(  25),
                             UINT8_C( 159), UINT8_C(  28), UINT8_C( 198), UINT8_C( 255),
                             UINT8_C(  57), UINT8_C( 179), UINT8_C( 255), UINT8_C( 255),
                             UINT8_C( 255), UINT8_C( 255), UINT8_C( 255), UINT8_C( 240),
                             UINT8_C( 208), UINT8_C(  51), UINT8_C( 199), UINT8_C( 242),
                             UINT8_C( 235), UINT8_C( 255), UINT8_C( 118), UINT8_C(   0),
                             UINT8_C( 255), UINT8_C( 255), UINT8_C( 124), UINT8_C( 143),
                             UINT8_C( 169), UINT8_C(  88), UINT8_C( 171), UINT8_C( 163),
                             UINT8_C(  33), UINT8_C( 243), UINT8_C( 162), UINT8_C( 157),
                             UINT8_C( 180), UINT8_C(  79), UINT8_C( 241), UINT8_C(  43),
                             UINT8_C( 179), UINT8_C( 255), UINT8_C( 233), UINT8_C( 136),
                             UINT8_C( 255), UINT8_C( 192), UINT8_C( 182), UINT8_C( 219),
                             UINT8_C( 227), UINT8_C( 185), UINT8_C(  71), UINT8_C(  90)) },
    { simde_x_mm512_set_epu8(UINT8_C(  72), UINT8_C(  45), UINT8_C( 120), UINT8_C( 251),
                             UINT8_C( 147), UINT8_C(  62), UINT8_C(  17), UINT8_C(  31),
                             UINT8_C( 226), UINT8_C( 198), UINT8_C(  56), UINT8_C(  21),
                             UINT8_C(  72), UINT8_C( 182), UINT8_C( 216), UINT8_C( 120),
                             UINT8_C(  95), UINT8_C( 108), UINT8_C(  32), UINT8_C(  64),
                             UINT8_C( 128), UINT8_C( 102), UINT8_C( 235), UINT8_C(  28),
                             UINT8_C( 105), UINT8_C(  52), UINT8_C(  85), UINT8_C( 152),
                             UINT8_C(  57), UINT8_C( 225), UINT8_C( 218), UINT8_C( 132),
                             UINT8_C( 149), UINT8_C( 254), UINT8_C(  55), UINT8_C(  46),
                             UINT8_C( 185), UINT8_C(  77), UINT8_C(  18), UINT8_C(  70),
                             UINT8_C(  89), UINT8_C( 125), UINT8_C( 214), UINT8_C( 131),
                             UINT8_C( 121), UINT8_C( 245), UINT8_C( 187), UINT8_C( 197),
                             UINT8_C( 203), UINT8_C(  34), UINT8_C(   9), UINT8_C(  64),
                             UINT8_C( 195), UINT8_C( 231), UINT8_C( 141), UINT8_C( 100),
                             UINT8_C(  65), UINT8_C(   8), UINT8_C(  69), UINT8_C( 248),
                             UINT8_C( 241), UINT8_C( 205), UINT8_C(   1), UINT8_C(  90)),
      UINT64_C(14515151237088493607),
      simde_x_mm512_set_epu8(UINT8_C( 230), UINT8_C( 247), UINT8_C(  66), UINT8_C(   1),
                             UINT8_C( 243), UINT8_C(  60), UINT8_C( 137), UINT8_C( 173),
                             UINT8_C( 134), UINT8_C( 192), UINT8_C( 173), UINT8_C( 182),
                             UINT8_C( 119), UINT8_C( 248), UINT8_C(  12), UINT8_C( 113),
                             UINT8_C( 244), UINT8_C( 172), UINT8_C(   6), UINT8_C(  69),
                             UINT8_C(   2), UINT8_C( 181), UINT8_C( 222), UINT8_C( 130),
                             UINT8_C(   3), UINT8_C( 128), UINT8_C( 247), UINT8_C(  24),
                             UINT8_C(  11), UINT8_C( 162), UINT8_C( 224), UINT8_C( 110),
                             UINT8_C(  33), UINT8_C( 232), UINT8_C( 125), UINT8_C(  35),
                             UINT8_C( 153), UINT8_C( 208), UINT8_C( 234), UINT8_C(  38),
                             UINT8_C( 175), UINT8_C(   9), UINT8_C( 245), UINT8_C( 132),
                             UINT8_C(  71), UINT8_C(  31), UINT8_C( 214), UINT8_C(  93),
                             UINT8_C(  67), UINT8_C(  45), UINT8_C(  51), UINT8_C( 164),
                             UINT8_C( 126), UINT8_C( 108), UINT8_C( 133), UINT8_C( 185),
                             UINT8_C( 113), UINT8_C(  32), UINT8_C(  71), UINT8_C(  55),
                             UINT8_C( 230), UINT8_C(  82), UINT8_C( 175), UINT8_C( 236)),
      simde_x_mm512_set_epu8(UINT8_C( 131), UINT8_C( 121), UINT8_C( 128), UINT8_C( 103),
                             UINT8_C(   0), UINT8_C( 101), UINT8_C( 215), UINT8_C(  89),
                             UINT8_C( 173), UINT8_C( 191), UINT8_C(   9), UINT8_C( 249),
                             UINT8_C( 193), UINT8_C(  13), UINT8_C( 105), UINT8_C(  92),
                             UINT8_C( 238), UINT8_C( 235), UINT8_C( 154), UINT8_C( 142),
                             UINT8_C(  74), UINT8_C( 121), UINT8_C( 211), UINT8_C(  52),
                             UINT8_C( 193), UINT8_C( 163), UINT8_C(  98), UINT8_C( 106),
                             UINT8_C( 147), UINT8_C( 209), UINT8_C(  37), UINT8_C(  70),
                             UINT8_C( 100), UINT8_C( 121), UINT8_C(  18), UINT8_C(  28),
                             UINT8_C( 139), UINT8_C( 107), UINT8_C(   3), UINT8_C( 194),
                             UINT8_C(  42), UINT8_C(  72), UINT8_C(  91), UINT8_C(  86),
                             UINT8_C( 184), UINT8_C(   9), UINT8_C( 176), UINT8_C( 118),
                             UINT8_C( 122), UINT8_C( 148), UINT8_C( 186), UINT8_C( 193),
                             UINT8_C(  56), UINT8_C(  71), UINT8_C( 242), UINT8_C(  49),
                             UINT8_C( 183), UINT8_C(  53), UINT8_C( 227), UINT8_C(   3),
                             UINT8_C( 183), UINT8_C(  43), UINT8_C( 234), UINT8_C(  85)),
      simde_x_mm512_set_epu8(UINT8_C( 255), UINT8_C( 255), UINT8_C( 120), UINT8_C( 251),
                             UINT8_C( 243), UINT8_C(  62), UINT8_C(  17), UINT8_C( 255),
                             UINT8_C( 226), UINT8_C( 255), UINT8_C( 182), UINT8_C( 255),
                             UINT8_C(  72), UINT8_C( 182), UINT8_C( 216), UINT8_C( 120),
                             UINT8_C(  95), UINT8_C( 108), UINT8_C( 160), UINT8_C(  64),
                             UINT8_C(  76), UINT8_C( 255), UINT8_C( 235), UINT8_C( 182),
                             UINT8_C( 105), UINT8_C(  52), UINT8_C( 255), UINT8_C( 152),
                             UINT8_C(  57), UINT8_C( 255), UINT8_C( 218), UINT8_C( 180),
                             UINT8_C( 149), UINT8_C( 255), UINT8_C(  55), UINT8_C(  46),
                             UINT8_C( 185), UINT8_C(  77), UINT8_C( 237), UINT8_C( 232),
                             UINT8_C( 217), UINT8_C( 125), UINT8_C( 255), UINT8_C( 218),
                             UINT8_C( 255), UINT8_C( 245), UINT8_C( 255), UINT8_C( 211),
                             UINT8_C( 203), UINT8_C( 193), UINT8_C(   9), UINT8_C(  64),
                             UINT8_C( 195), UINT8_C( 231), UINT8_C( 141), UINT8_C( 100),
                             UINT8_C(  65), UINT8_C(   8), UINT8_C( 255), UINT8_C( 248),
                             UINT8_C( 241), UINT8_C( 125), UINT8_C( 255), UINT8_C( 255)) },
    { simde_x_mm512_set_epu8(UINT8_C( 209), UINT8_C(  84), UINT8_C( 130), UINT8_C( 192),
                             UINT8_C(  14), UINT8_C(  11), UINT8_C(  37), UINT8_C( 233),
                             UINT8_C(  67), UINT8_C( 124), UINT8_C(  58), UINT8_C( 162),
                             UINT8_C(  30), UINT8_C( 223), UINT8_C(  70), UINT8_C( 232),
                             UINT8_C(  38), UINT8_C( 159), UINT8_C( 200), UINT8_C( 196),
                             UINT8_C( 197), UINT8_C(  65), UINT8_C( 182), UINT8_C(  45),
                             UINT8_C( 245), UINT8_C(  55), UINT8_C( 174), UINT8_C(  12),
                             UINT8_C( 106), UINT8_C(  22), UINT8_C( 132), UINT8_C( 252),
                             UINT8_C(   2), UINT8_C( 175), UINT8_C(  14), UINT8_C(  90),
                             UINT8_C( 156), UINT8_C( 134), UINT8_C( 221), UINT8_C(  81),
                             UINT8_C( 242), UINT8_C( 214), UINT8_C( 125), UINT8_C( 131),
                             UINT8_C( 199), UINT8_C(  90), UINT8_C( 247), UINT8_C(  63),
                             UINT8_C(  53), UINT8_C(  77), UINT8_C(  63), UINT8_C( 172),
                             UINT8_C(  27), UINT8_C(  22), UINT8_C(   3), UINT8_C( 219),
                             UINT8_C(  65), UINT8_C( 118), UINT8_C( 130), UINT8_C(  97),
                             UINT8_C( 109), UINT8_C(   7), UINT8_C( 142), UINT8_C( 181)),
      UINT64_C( 8707623543556880126),
      simde_x_mm512_set_epu8(UINT8_C(  84), UINT8_C( 185), UINT8_C(   8), UINT8_C(  12),
                             UINT8_C( 245), UINT8_C( 180), UINT8_C(  62), UINT8_C(  93),
                             UINT8_C( 181), UINT8_C( 179), UINT8_C( 172), UINT8_C( 148),
                             UINT8_C( 221), UINT8_C(  14), UINT8_C( 196), UINT8_C(  18),
                             UINT8_C(  23), UINT8_C( 196), UINT8_C( 193), UINT8_C( 142),
                             UINT8_C( 201), UINT8_C(  75), UINT8_C( 157), UINT8_C( 201),
                             UINT8_C(  58), UINT8_C(  76), UINT8_C( 154), UINT8_C( 138),
                             UINT8_C( 226), UINT8_C(  39), UINT8_C( 119), UINT8_C(  85),
                             UINT8_C( 248), UINT8_C( 184), UINT8_C( 196), UINT8_C( 162),
                             UINT8_C( 144), UINT8_C( 119), UINT8_C( 124), UINT8_C(  76),
                             UINT8_C( 214), UINT8_C( 132), UINT8_C(  54), UINT8_C(  74),
                             UINT8_C( 164), UINT8_C(  99), UINT8_C(  79), UINT8_C( 253),
                             UINT8_C(  61), UINT8_C( 167), UINT8_C(  84), UINT8_C( 162),
                             UINT8_C(  31), UINT8_C( 140), UINT8_C( 189), UINT8_C( 154),
                             UINT8_C( 184), UINT8_C( 165), UINT8_C( 151), UINT8_C( 148),
                             UINT8_C( 212), UINT8_C(  74), UINT8_C( 228), UINT8_C( 124)),
      simde_x_mm512_set_epu8(UINT8_C(   1), UINT8_C(  75), UINT8_C(  21), UINT8_C( 220),
                             UINT8_C( 130), UINT8_C( 122), UINT8_C(  71), UINT8_C(  76),
                             UINT8_C(  28), UINT8_C( 200), UINT8_C(  32), UINT8_C( 101),
                             UINT8_C( 149), UINT8_C( 145), UINT8_C( 168), UINT8_C( 237),
                             UINT8_C( 179), UINT8_C(  19), UINT8_C( 235), UINT8_C( 145),
                             UINT8_C( 188), UINT8_C(  82), UINT8_C( 138), UINT8_C( 180),
                             UINT8_C(  47), UINT8_C( 127), UINT8_C(  62), UINT8_C( 240),
                             UINT8_C(  10), UINT8_C( 242), UINT8_C( 156), UINT8_C(  86),
                             UINT8_C(  29), UINT8_C( 107), UINT8_C(  56), UINT8_C(  21),
                             UINT8_C(  24), UINT8_C(  68), UINT8_C( 160), UINT8_C(  64),
                             UINT8_C(  48), UINT8_C(  13), UINT8_C( 173), UINT8_C(   4),
                             UINT8_C( 253), UINT8_C( 192), UINT8_C(  17), UINT8_C( 141),
                             UINT8_C(  21), UINT8_C( 108), UINT8_C( 125), UINT8_C( 196),
                             UINT8_C( 184), UINT8_C(  74), UINT8_C( 251), UINT8_C( 198),
                             UINT8_C( 215), UINT8_C(  22), UINT8_C( 141), UINT8_C( 102),
                             UINT8_C(  59), UINT8_C( 176), UINT8_C( 241), UINT8_C( 193)),
      simde_x_mm512_set_epu8(UINT8_C( 209), UINT8_C( 255), UINT8_C(  29), UINT8_C( 232),
                             UINT8_C( 255), UINT8_C(  11), UINT8_C(  37), UINT8_C( 233),
                             UINT8_C( 209), UINT8_C( 255), UINT8_C(  58), UINT8_C( 249),
                             UINT8_C(  30), UINT8_C( 159), UINT8_C( 255), UINT8_C( 255),
                             UINT8_C( 202), UINT8_C( 159), UINT8_C( 255), UINT8_C( 255),
                             UINT8_C( 197), UINT8_C(  65), UINT8_C( 182), UINT8_C( 255),
                             UINT8_C( 245), UINT8_C( 203), UINT8_C( 216), UINT8_C( 255),
                             UINT8_C( 236), UINT8_C(  22), UINT8_C( 255), UINT8_C( 252),
                             UINT8_C(   2), UINT8_C( 255), UINT8_C(  14), UINT8_C( 183),
                             UINT8_C( 156), UINT8_C( 187), UINT8_C( 255), UINT8_C( 140),
                             UINT8_C( 255), UINT8_C( 214), UINT8_C( 125), UINT8_C( 131),
                             UINT8_C( 255), UINT8_C(  90), UINT8_C( 247), UINT8_C( 255),
                             UINT8_C(  53), UINT8_C(  77), UINT8_C( 209), UINT8_C( 255),
                             UINT8_C(  27), UINT8_C( 214), UINT8_C( 255), UINT8_C( 219),
                             UINT8_C( 255), UINT8_C( 187), UINT8_C( 255), UINT8_C( 250),
                             UINT8_C( 255), UINT8_C( 250), UINT8_C( 255), UINT8_C( 181)) },
    { simde_x_mm512_set_epu8(UINT8_C( 192), UINT8_C( 203), UINT8_C( 214), UINT8_C( 126),
                             UINT8_C(  67), UINT8_C(  50), UINT8_C( 238), UINT8_C(  76),
                             UINT8_C( 237), UINT8_C( 123), UINT8_C( 169), UINT8_C( 106),
                             UINT8_C( 182), UINT8_C(  44), UINT8_C( 117), UINT8_C( 103),
                             UINT8_C(  81), UINT8_C( 122), UINT8_C(  56), UINT8_C( 246),
                             UINT8_C(  67), UINT8_C(  79), UINT8_C(  83), UINT8_C( 218),
                             UINT8_C( 243), UINT8_C(  43), UINT8_C(  27), UINT8_C( 159),
                             UINT8_C( 102), UINT8_C( 126), UINT8_C(  38), UINT8_C( 194),
                             UINT8_C( 232), UINT8_C( 117), UINT8_C( 218), UINT8_C( 163),
                             UINT8_C( 198), UINT8_C( 132), UINT8_C( 181), UINT8_C(  10),
                             UINT8_C(  18), UINT8_C( 182), UINT8_C(  14), UINT8_C(  36),
                             UINT8_C( 249), UINT8_C( 113), UINT8_C(  40), UINT8_C(  48),
                             UINT8_C( 149), UINT8_C( 222), UINT8_C( 181), UINT8_C(  85),
                             UINT8_C( 221), UINT8_C( 140), UINT8_C(  65), UINT8_C( 235),
                             UINT8_C(  15), UINT8_C(   3), UINT8_C(  45), UINT8_C(  21),
                             UINT8_C(  72), UINT8_C(  93), UINT8_C( 108), UINT8_C( 125)),
      UINT64_C(12576710173448868104),
      simde_x_mm512_set_epu8(UINT8_C(  90), UINT8_C( 218), UINT8_C( 158), UINT8_C( 186),
                             UINT8_C( 148), UINT8_C(  20), UINT8_C(  43), UINT8_C( 128),
                             UINT8_C(  77), UINT8_C( 108), UINT8_C(  53), UINT8_C(  82),
                             UINT8_C( 206), UINT8_C(  52), UINT8_C(  56), UINT8_C(  58),
                             UINT8_C( 136), UINT8_C( 213), UINT8_C( 114), UINT8_C(  93),
                             UINT8_C( 212), UINT8_C( 241), UINT8_C(  38), UINT8_C( 239),
                             UINT8_C( 146), UINT8_C( 133), UINT8_C( 217), UINT8_C( 114),
                             UINT8_C(  51), UINT8_C( 141), UINT8_C( 182), UINT8_C(  43),
                             UINT8_C(  41), UINT8_C( 220), UINT8_C(  19), UINT8_C(  69),
                             UINT8_C(  60), UINT8_C( 203), UINT8_C( 112), UINT8_C( 108),
                             UINT8_C(   8), UINT8_C(  46), UINT8_C( 221), UINT8_C(  26),
                             UINT8_C(  11), UINT8_C(  42), UINT8_C(  47), UINT8_C(  59),
                             UINT8_C( 199), UINT8_C(  94), UINT8_C( 131), UINT8_C( 132),
                             UINT8_C(  36), UINT8_C(  57), UINT8_C(  68), UINT8_C( 204),
                             UINT8_C(  39), UINT8_C(  50), UINT8_C( 208), UINT8_C(  94),
                             UINT8_C(  53), UINT8_C(  11), UINT8_C(  29), UINT8_C(  65)),
      simde_x_mm512_set_epu8(UINT8_C( 149), UINT8_C( 120), UINT8_C( 198), UINT8_C( 107),
                             UINT8_C( 224), UINT8_C( 224), UINT8_C(  88), UINT8_C( 213),
                             UINT8_C(  31), UINT8_C( 224), UINT8_C( 192), UINT8_C(  27),
                             UINT8_C(  82), UINT8_C( 166), UINT8_C( 202), UINT8_C( 172),
                             UINT8_C( 226), UINT8_C(  63), UINT8_C(  24), UINT8_C(  81),
                             UINT8_C( 248), UINT8_C(   9), UINT8_C( 221), UINT8_C( 155),
                             UINT8_C(  83), UINT8_C( 107), UINT8_C( 209), UINT8_C( 200),
                             UINT8_C(  57), UINT8_C( 168), UINT8_C( 141), UINT8_C( 236),
                             UINT8_C(  58), UINT8_C(  75), UINT8_C(  56), UINT8_C(  93),
                             UINT8_C(  49), UINT8_C(  43), UINT8_C( 108), UINT8_C( 118),
                             UINT8_C( 177), UINT8_C( 112), UINT8_C(  44), UINT8_C( 144),
                             UINT8_C( 204), UINT8_C(  10), UINT8_C(  28), UINT8_C( 170),
                             UINT8_C(  65), UINT8_C(  62), UINT8_C(  86), UINT8_C( 149),
                             UINT8_C(  24), UINT8_C( 201), UINT8_C(  54), UINT8_C( 146),
                             UINT8_C( 223), UINT8_C( 110), UINT8_C( 140), UINT8_C( 217),
                             UINT8_C(  39), UINT8_C( 144), UINT8_C(  64), UINT8_C(  43)),
      simde_x_mm512_set_epu8(UINT8_C( 239), UINT8_C( 203), UINT8_C( 255), UINT8_C( 126),
                             UINT8_C( 255), UINT8_C( 244), UINT8_C( 131), UINT8_C(  76),
                             UINT8_C( 108), UINT8_C( 123), UINT8_C( 169), UINT8_C( 106),
                             UINT8_C( 255), UINT8_C(  44), UINT8_C( 117), UINT8_C( 230),
                             UINT8_C(  81), UINT8_C( 255), UINT8_C( 138), UINT8_C( 174),
                             UINT8_C(  67), UINT8_C(  79), UINT8_C( 255), UINT8_C( 255),
                             UINT8_C( 243), UINT8_C( 240), UINT8_C(  27), UINT8_C( 159),
                             UINT8_C( 102), UINT8_C( 255), UINT8_C(  38), UINT8_C( 194),
                             UINT8_C(  99), UINT8_C( 117), UINT8_C(  75), UINT8_C( 162),
                             UINT8_C( 109), UINT8_C( 132), UINT8_C( 220), UINT8_C( 226),
                             UINT8_C(  18), UINT8_C( 158), UINT8_C( 255), UINT8_C( 170),
                             UINT8_C( 249), UINT8_C(  52), UINT8_C(  75), UINT8_C(  48),
                             UINT8_C( 149), UINT8_C( 222), UINT8_C( 181), UINT8_C( 255),
                             UINT8_C( 221), UINT8_C( 140), UINT8_C(  65), UINT8_C( 255),
                             UINT8_C(  15), UINT8_C(   3), UINT8_C(  45), UINT8_C(  21),
                             UINT8_C(  92), UINT8_C(  93), UINT8_C( 108), UINT8_C( 125)) },
    { simde_x_mm512_set_epu8(UINT8_C( 153), UINT8_C( 132), UINT8_C(  13), UINT8_C( 176),
                             UINT8_C( 224), UINT8_C( 123), UINT8_C( 115), UINT8_C( 207),
                             UINT8_C( 113), UINT8_C( 205), UINT8_C( 119), UINT8_C( 189),
                             UINT8_C( 235), UINT8_C(  19), UINT8_C( 244), UINT8_C(  29),
                             UINT8_C(  91), UINT8_C( 192), UINT8_C(  88), UINT8_C( 151),
                             UINT8_C(  24), UINT8_C(  31), UINT8_C(  77), UINT8_C(  92),
                             UINT8_C( 171), UINT8_C(  48), UINT8_C( 143), UINT8_C( 142),
                             UINT8_C(  16), UINT8_C(  18), UINT8_C( 212), UINT8_C( 190),
                             UINT8_C(  25), UINT8_C( 151), UINT8_C( 156), UINT8_C( 165),
                             UINT8_C(  26), UINT8_C( 133), UINT8_C( 223), UINT8_C( 219),
                             UINT8_C(  63), UINT8_C(  13), UINT8_C( 132), UINT8_C(  41),
                             UINT8_C( 152), UINT8_C( 197), UINT8_C( 254), UINT8_C( 202),
                             UINT8_C(  73), UINT8_C(   3), UINT8_C( 238), UINT8_C(  10),
                             UINT8_C(  19), UINT8_C(  58), UINT8_C( 244), UINT8_C( 181),
                             UINT8_C( 168), UINT8_C(  59), UINT8_C( 104), UINT8_C( 216),
                             UINT8_C( 174), UINT8_C(  42), UINT8_C( 183), UINT8_C( 162)),
      UINT64_C( 2633789449456316803),
      simde_x_mm512_set_epu8(UINT8_C( 118), UINT8_C(  44), UINT8_C( 242), UINT8_C(  84),
                             UINT8_C( 187), UINT8_C( 208), UINT8_C(  40), UINT8_C(  86),
                             UINT8_C( 255), UINT8_C( 121), UINT8_C( 216), UINT8_C(  44),
                             UINT8_C( 255), UINT8_C(  38), UINT8_C( 212), UINT8_C(  38),
                             UINT8_C(  93), UINT8_C( 149), UINT8_C( 252), UINT8_C( 195),
                             UINT8_C( 204), UINT8_C(  22), UINT8_C( 202), UINT8_C( 131),
                             UINT8_C( 227), UINT8_C(  25), UINT8_C( 179), UINT8_C( 188),
                             UINT8_C(   9), UINT8_C( 221), UINT8_C( 245), UINT8_C(  53),
                             UINT8_C(  28), UINT8_C(  61), UINT8_C( 221), UINT8_C( 150),
                             UINT8_C( 210), UINT8_C( 121), UINT8_C( 154), UINT8_C( 121),
                             UINT8_C( 202), UINT8_C( 196), UINT8_C(   7), UINT8_C(   2),
                             UINT8_C( 137), UINT8_C( 111), UINT8_C( 236), UINT8_C( 198),
                             UINT8_C( 158), UINT8_C(  83), UINT8_C(  32), UINT8_C( 207),
                             UINT8_C( 245), UINT8_C(  48), UINT8_C(  92), UINT8_C(  47),
                             UINT8_C( 218), UINT8_C(  11), UINT8_C(  26), UINT8_C(  90),
                             UINT8_C( 251), UINT8_C(  73), UINT8_C(  45), UINT8_C( 254)),
      simde_x_mm512_set_epu8(UINT8_C( 225), UINT8_C( 126), UINT8_C( 138), UINT8_C( 199),
                             UINT8_C( 130), UINT8_C(  29), UINT8_C( 101), UINT8_C( 241),
                             UINT8_C( 195), UINT8_C( 118), UINT8_C( 102), UINT8_C(  12),
                             UINT8_C( 197), UINT8_C( 215), UINT8_C( 196), UINT8_C(  46),
                             UINT8_C(  63), UINT8_C(  78), UINT8_C(  87), UINT8_C(  18),
                             UINT8_C(  18), UINT8_C(  32), UINT8_C( 230), UINT8_C( 250),
                             UINT8_C( 236), UINT8_C( 133), UINT8_C(  99), UINT8_C(  65),
                             UINT8_C(  13), UINT8_C(  25), UINT8_C( 108), UINT8_C( 135),
                             UINT8_C(  42), UINT8_C(   0), UINT8_C( 104), UINT8_C( 239),
                             UINT8_C( 111), UINT8_C( 146), UINT8_C( 217), UINT8_C( 125),
                             UINT8_C( 206), UINT8_C( 209), UINT8_C(  30), UINT8_C(  92),
                             UINT8_C(  19), UINT8_C( 248), UINT8_C( 136), UINT8_C( 127),
                             UINT8_C( 207), UINT8_C(  23), UINT8_C(  16), UINT8_C( 192),
                             UINT8_C( 177), UINT8_C( 116), UINT8_C( 251), UINT8_C( 206),
                             UINT8_C(  32), UINT8_C(  22), UINT8_C( 214), UINT8_C( 253),
                             UINT8_C(  30), UINT8_C(  64), UINT8_C(  96), UINT8_C( 190)),
      simde_x_mm512_set_epu8(UINT8_C( 153), UINT8_C( 132), UINT8_C( 255), UINT8_C( 176),
                             UINT8_C( 224), UINT8_C( 237), UINT8_C( 115), UINT8_C( 207),
                             UINT8_C( 255), UINT8_C( 205), UINT8_C( 119), UINT8_C( 189),
                             UINT8_C( 255), UINT8_C( 253), UINT8_C( 244), UINT8_C(  84),
                             UINT8_C(  91), UINT8_C( 192), UINT8_C(  88), UINT8_C( 213),
                             UINT8_C( 222), UINT8_C(  31), UINT8_C(  77), UINT8_C( 255),
                             UINT8_C( 255), UINT8_C(  48), UINT8_C( 143), UINT8_C( 142),
                             UINT8_C(  22), UINT8_C( 246), UINT8_C( 212), UINT8_C( 190),
                             UINT8_C(  70), UINT8_C(  61), UINT8_C( 156), UINT8_C( 165),
                             UINT8_C(  26), UINT8_C( 255), UINT8_C( 223), UINT8_C( 219),
                             UINT8_C(  63), UINT8_C(  13), UINT8_C( 132), UINT8_C(  41),
                             UINT8_C( 152), UINT8_C( 197), UINT8_C( 255), UINT8_C( 255),
                             UINT8_C( 255), UINT8_C( 106), UINT8_C(  48), UINT8_C( 255),
                             UINT8_C(  19), UINT8_C(  58), UINT8_C( 244), UINT8_C( 253),
                             UINT8_C( 250), UINT8_C(  59), UINT8_C( 104), UINT8_C( 216),
                             UINT8_C( 174), UINT8_C(  42), UINT8_C( 141), UINT8_C( 255)) },
    { simde_x_mm512_set_epu8(UINT8_C( 117), UINT8_C(  69), UINT8_C( 121), UINT8_C( 211),
                             UINT8_C(  30), UINT8_C( 183), UINT8_C(   2), UINT8_C( 216),
                             UINT8_C(  95), UINT8_C( 253), UINT8_C(  16), UINT8_C( 178),
                             UINT8_C( 128), UINT8_C( 215), UINT8_C( 190), UINT8_C(  66),
                             UINT8_C(  93), UINT8_C( 224), UINT8_C( 206), UINT8_C( 254),
                             UINT8_C( 195), UINT8_C(  29), UINT8_C( 168), UINT8_C( 138),
                             UINT8_C( 229), UINT8_C(  42), UINT8_C(  78), UINT8_C( 210),
                             UINT8_C( 177), UINT8_C(  38), UINT8_C( 181), UINT8_C(  14),
                             UINT8_C( 138), UINT8_C( 142), UINT8_C( 136), UINT8_C(  42),
                             UINT8_C(   4), UINT8_C(  79), UINT8_C( 172), UINT8_C( 146),
                             UINT8_C(   0), UINT8_C(  85), UINT8_C( 236), UINT8_C(  61),
                             UINT8_C(  40), UINT8_C( 181), UINT8_C(  69), UINT8_C( 157),
                             UINT8_C(  73), UINT8_C( 222), UINT8_C( 242), UINT8_C(  72),
                             UINT8_C( 101), UINT8_C(  96), UINT8_C( 142), UINT8_C( 132),
                             UINT8_C( 169), UINT8_C(  43), UINT8_C( 138), UINT8_C( 114),
                             UINT8_C( 168), UINT8_C(   8), UINT8_C( 204), UINT8_C(  75)),
      UINT64_C(14890918166471265655),
      simde_x_mm512_set_epu8(UINT8_C( 200), UINT8_C( 186), UINT8_C(  66), UINT8_C( 145),
                             UINT8_C( 187), UINT8_C(  15), UINT8_C( 174), UINT8_C( 244),
                             UINT8_C( 167), UINT8_C(  37), UINT8_C(  80), UINT8_C( 120),
                             UINT8_C( 173), UINT8_C( 136), UINT8_C(  95), UINT8_C(  21),
                             UINT8_C(  91), UINT8_C( 159), UINT8_C( 184), UINT8_C(  42),
                             UINT8_C(  22), UINT8_C( 186), UINT8_C(  71), UINT8_C( 178),
                             UINT8_C( 251), UINT8_C(  52), UINT8_C( 234), UINT8_C( 222),
                             UINT8_C(  16), UINT8_C(  92), UINT8_C(  91), UINT8_C( 184),
                             UINT8_C(   3), UINT8_C( 225), UINT8_C( 161), UINT8_C( 200),
                             UINT8_C( 206), UINT8_C(  68), UINT8_C( 232), UINT8_C( 206),
                             UINT8_C(  94), UINT8_C(  67), UINT8_C( 108), UINT8_C( 138),
                             UINT8_C( 191), UINT8_C(  31), UINT8_C(  70), UINT8_C( 108),
                             UINT8_C( 190), UINT8_C( 107), UINT8_C( 171), UINT8_C(  38),
                             UINT8_C(   2), UINT8_C(  32), UINT8_C(  56), UINT8_C(  66),
                             UINT8_C( 254), UINT8_C( 182), UINT8_C( 112), UINT8_C(  10),
                             UINT8_C(  64), UINT8_C( 100), UINT8_C( 201), UINT8_C(  83)),
      simde_x_mm512_set_epu8(UINT8_C( 187), UINT8_C( 211), UINT8_C(  23), UINT8_C(  70),
                             UINT8_C(  22), UINT8_C( 113), UINT8_C(  75), UINT8_C( 139),
                             UINT8_C(  69), UINT8_C( 182), UINT8_C(  40), UINT8_C( 217),
                             UINT8_C( 205), UINT8_C( 165), UINT8_C(  25), UINT8_C( 252),
                             UINT8_C( 244), UINT8_C( 243), UINT8_C( 179), UINT8_C(  75),
                             UINT8_C( 140), UINT8_C( 220), UINT8_C(  38), UINT8_C( 204),
                             UINT8_C(  13), UINT8_C( 204), UINT8_C( 156), UINT8_C( 210),
                             UINT8_C(  13), UINT8_C(  83), UINT8_C( 162), UINT8_C( 102),
                             UINT8_C( 116), UINT8_C( 196), UINT8_C(  44), UINT8_C( 249),
                             UINT8_C( 104), UINT8_C( 206), UINT8_C( 226), UINT8_C(  17),
                             UINT8_C(  13), UINT8_C( 149), UINT8_C( 111), UINT8_C( 243),
                             UINT8_C(  17), UINT8_C( 211), UINT8_C( 225), UINT8_C(  76),
                             UINT8_C( 154), UINT8_C( 185), UINT8_C( 116), UINT8_C(  72),
                             UINT8_C( 245), UINT8_C( 159), UINT8_C(  93), UINT8_C(  48),
                             UINT8_C( 181), UINT8_C( 166), UINT8_C( 246), UINT8_C( 178),
                             UINT8_C( 248), UINT8_C( 246), UINT8_C(  48), UINT8_C( 245)),
      simde_x_mm512_set_epu8(UINT8_C( 255), UINT8_C( 255), UINT8_C( 121), UINT8_C( 211),
                             UINT8_C( 209), UINT8_C( 128), UINT8_C( 249), UINT8_C( 216),
                             UINT8_C( 236), UINT8_C( 253), UINT8_C( 120), UINT8_C( 178),
                             UINT8_C( 128), UINT8_C( 255), UINT8_C( 120), UINT8_C( 255),
                             UINT8_C(  93), UINT8_C( 224), UINT8_C( 255), UINT8_C( 254),
                             UINT8_C( 162), UINT8_C(  29), UINT8_C( 109), UINT8_C( 255),
                             UINT8_C( 229), UINT8_C(  42), UINT8_C( 255), UINT8_C( 210),
                             UINT8_C(  29), UINT8_C( 175), UINT8_C( 181), UINT8_C( 255),
                             UINT8_C( 138), UINT8_C( 255), UINT8_C( 136), UINT8_C(  42),
                             UINT8_C( 255), UINT8_C(  79), UINT8_C( 255), UINT8_C( 223),
                             UINT8_C( 107), UINT8_C( 216), UINT8_C( 219), UINT8_C(  61),
                             UINT8_C( 208), UINT8_C( 242), UINT8_C( 255), UINT8_C( 157),
                             UINT8_C(  73), UINT8_C( 255), UINT8_C( 242), UINT8_C(  72),
                             UINT8_C( 247), UINT8_C( 191), UINT8_C( 142), UINT8_C( 114),
                             UINT8_C( 169), UINT8_C( 255), UINT8_C( 255), UINT8_C( 188),
                             UINT8_C( 168), UINT8_C( 255), UINT8_C( 249), UINT8_C( 255)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_mask_adds_epu8(test_vec[i].src, test_vec[i].k, test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_u8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_maskz_adds_epu8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__mmask64 k;
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { UINT64_C(17286015531074160252),
      simde_x_mm512_set_epu8(UINT8_C( 141), UINT8_C( 229), UINT8_C(  62), UINT8_C( 171),
                             UINT8_C(  49), UINT8_C( 141), UINT8_C(  38), UINT8_C(   4),
                             UINT8_C(  92), UINT8_C( 116), UINT8_C( 178), UINT8_C( 237),
                             UINT8_C( 183), UINT8_C(  22), UINT8_C( 190), UINT8_C( 227),
                             UINT8_C(  55), UINT8_C(  78), UINT8_C( 211), UINT8_C( 137),
                             UINT8_C(  30), UINT8_C( 227), UINT8_C( 233), UINT8_C(  89),
                             UINT8_C(  15), UINT8_C( 119), UINT8_C( 168), UINT8_C( 109),
                             UINT8_C( 240), UINT8_C( 246), UINT8_C(   0), UINT8_C( 238),
                             UINT8_C(   1), UINT8_C( 116), UINT8_C(  62), UINT8_C( 183),
                             UINT8_C( 134), UINT8_C(   0), UINT8_C( 111), UINT8_C(  95),
                             UINT8_C( 236), UINT8_C(   3), UINT8_C( 122), UINT8_C( 135),
                             UINT8_C(  13), UINT8_C(  25), UINT8_C( 221), UINT8_C( 129),
                             UINT8_C(  82), UINT8_C(  90), UINT8_C(  53), UINT8_C( 123),
                             UINT8_C(  73), UINT8_C( 108), UINT8_C( 238), UINT8_C(  15),
                             UINT8_C(  81), UINT8_C( 229), UINT8_C( 102), UINT8_C( 118),
                             UINT8_C(  39), UINT8_C( 179), UINT8_C(  45), UINT8_C(  81)),
      simde_x_mm512_set_epu8(UINT8_C(  68), UINT8_C( 148), UINT8_C( 135), UINT8_C( 141),
                             UINT8_C( 197), UINT8_C( 178), UINT8_C( 145), UINT8_C(  56),
                             UINT8_C(   9), UINT8_C( 135), UINT8_C( 120), UINT8_C( 220),
                             UINT8_C(  36), UINT8_C( 153), UINT8_C( 152), UINT8_C(  25),
                             UINT8_C( 145), UINT8_C( 193), UINT8_C( 221), UINT8_C( 136),
                             UINT8_C(  28), UINT8_C( 212), UINT8_C( 230), UINT8_C( 170),
                             UINT8_C( 243), UINT8_C(  53), UINT8_C( 168), UINT8_C( 149),
                             UINT8_C(  68), UINT8_C(  42), UINT8_C( 138), UINT8_C( 111),
                             UINT8_C(  54), UINT8_C( 198), UINT8_C( 243), UINT8_C(  27),
                             UINT8_C(  23), UINT8_C(  41), UINT8_C( 137), UINT8_C(  44),
                             UINT8_C(   7), UINT8_C( 136), UINT8_C(  32), UINT8_C( 213),
                             UINT8_C( 114), UINT8_C( 184), UINT8_C(  73), UINT8_C( 160),
                             UINT8_C(  96), UINT8_C( 110), UINT8_C( 175), UINT8_C( 180),
                             UINT8_C( 103), UINT8_C( 156), UINT8_C( 234), UINT8_C(  18),
                             UINT8_C( 115), UINT8_C(  54), UINT8_C( 216), UINT8_C( 125),
                             UINT8_C( 110), UINT8_C(  31), UINT8_C(  51), UINT8_C( 152)),
      simde_x_mm512_set_epu8(UINT8_C( 209), UINT8_C( 255), UINT8_C( 197), UINT8_C(   0),
                             UINT8_C( 246), UINT8_C( 255), UINT8_C( 183), UINT8_C(  60),
                             UINT8_C( 101), UINT8_C( 251), UINT8_C( 255), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 175), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C( 255), UINT8_C( 255),
                             UINT8_C( 255), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C( 255), UINT8_C(   0), UINT8_C( 138), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C( 157), UINT8_C(  41), UINT8_C( 248), UINT8_C( 139),
                             UINT8_C( 243), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C( 127), UINT8_C( 209), UINT8_C( 255), UINT8_C( 255),
                             UINT8_C( 178), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C( 255), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C( 255), UINT8_C( 243),
                             UINT8_C( 149), UINT8_C( 210), UINT8_C(   0), UINT8_C(   0)) },
    { UINT64_C( 9031211210081693899),
      simde_x_mm512_set_epu8(UINT8_C( 150), UINT8_C( 238), UINT8_C(  65), UINT8_C( 152),
                             UINT8_C(  81), UINT8_C(  38), UINT8_C( 172), UINT8_C( 254),
                             UINT8_C( 242), UINT8_C(  85), UINT8_C( 176), UINT8_C(  80),
                             UINT8_C(  48), UINT8_C(  93), UINT8_C(  79), UINT8_C( 127),
                             UINT8_C(  16), UINT8_C(  41), UINT8_C(  54), UINT8_C( 140),
                             UINT8_C(  17), UINT8_C(  42), UINT8_C( 170), UINT8_C(  38),
                             UINT8_C( 138), UINT8_C( 200), UINT8_C(  60), UINT8_C(  19),
                             UINT8_C( 156), UINT8_C( 149), UINT8_C( 105), UINT8_C( 180),
                             UINT8_C(  10), UINT8_C( 247), UINT8_C( 244), UINT8_C( 200),
                             UINT8_C( 185), UINT8_C(  96), UINT8_C(   6), UINT8_C(  24),
                             UINT8_C(  69), UINT8_C(  73), UINT8_C( 229), UINT8_C(   3),
                             UINT8_C( 161), UINT8_C(  50), UINT8_C( 189), UINT8_C( 217),
                             UINT8_C(  97), UINT8_C(  62), UINT8_C( 101), UINT8_C(  56),
                             UINT8_C( 177), UINT8_C(  83), UINT8_C( 157), UINT8_C( 200),
                             UINT8_C( 239), UINT8_C( 200), UINT8_C( 248), UINT8_C( 240),
                             UINT8_C(  84), UINT8_C( 161), UINT8_C( 183), UINT8_C(  54)),
      simde_x_mm512_set_epu8(UINT8_C(  63), UINT8_C( 205), UINT8_C(  87), UINT8_C(  32),
                             UINT8_C( 191), UINT8_C(  55), UINT8_C(  14), UINT8_C(  81),
                             UINT8_C( 133), UINT8_C( 156), UINT8_C( 217), UINT8_C( 212),
                             UINT8_C(  22), UINT8_C( 112), UINT8_C(  16), UINT8_C(  15),
                             UINT8_C( 152), UINT8_C( 154), UINT8_C( 102), UINT8_C( 161),
                             UINT8_C(  69), UINT8_C(  13), UINT8_C( 235), UINT8_C(  45),
                             UINT8_C(  62), UINT8_C( 136), UINT8_C( 145), UINT8_C(  32),
                             UINT8_C( 149), UINT8_C( 226), UINT8_C(  99), UINT8_C( 192),
                             UINT8_C(   8), UINT8_C( 214), UINT8_C(  81), UINT8_C( 222),
                             UINT8_C( 210), UINT8_C(  26), UINT8_C(  31), UINT8_C( 254),
                             UINT8_C(  68), UINT8_C( 249), UINT8_C( 185), UINT8_C(  46),
                             UINT8_C( 235), UINT8_C( 183), UINT8_C(  21), UINT8_C(  83),
                             UINT8_C( 148), UINT8_C( 159), UINT8_C( 187), UINT8_C(  73),
                             UINT8_C(  57), UINT8_C( 219), UINT8_C(  21), UINT8_C(  82),
                             UINT8_C( 137), UINT8_C( 130), UINT8_C( 126), UINT8_C(  91),
                             UINT8_C( 115), UINT8_C(  31), UINT8_C( 177), UINT8_C(  28)),
      simde_x_mm512_set_epu8(UINT8_C(   0), UINT8_C( 255), UINT8_C( 152), UINT8_C( 184),
                             UINT8_C( 255), UINT8_C(  93), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C(   0), UINT8_C( 241), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C(   0), UINT8_C( 205), UINT8_C(   0), UINT8_C( 142),
                             UINT8_C(   0), UINT8_C( 195), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(  86), UINT8_C(  55), UINT8_C( 255), UINT8_C(   0),
                             UINT8_C( 200), UINT8_C(   0), UINT8_C( 205), UINT8_C(  51),
                             UINT8_C( 255), UINT8_C( 255), UINT8_C( 204), UINT8_C( 255),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 122), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C( 255), UINT8_C(  49),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C( 245), UINT8_C( 221), UINT8_C( 255), UINT8_C( 129),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C( 255), UINT8_C( 255), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C( 199), UINT8_C(   0), UINT8_C( 255), UINT8_C(  82)) },
    { UINT64_C( 6828010367541473016),
      simde_x_mm512_set_epu8(UINT8_C(  84), UINT8_C( 160), UINT8_C(  87), UINT8_C( 234),
                             UINT8_C( 251), UINT8_C( 253), UINT8_C( 129), UINT8_C(  41),
                             UINT8_C(  74), UINT8_C(  72), UINT8_C( 252), UINT8_C(  28),
                             UINT8_C( 141), UINT8_C(  93), UINT8_C( 102), UINT8_C(  44),
                             UINT8_C( 153), UINT8_C( 227), UINT8_C( 206), UINT8_C(  48),
                             UINT8_C( 160), UINT8_C( 206), UINT8_C(  46), UINT8_C( 191),
                             UINT8_C(   4), UINT8_C(  43), UINT8_C( 181), UINT8_C(  97),
                             UINT8_C( 230), UINT8_C( 153), UINT8_C(  71), UINT8_C( 149),
                             UINT8_C(  91), UINT8_C(  45), UINT8_C( 245), UINT8_C(  47),
                             UINT8_C(  29), UINT8_C(  25), UINT8_C(  26), UINT8_C( 247),
                             UINT8_C(  10), UINT8_C(  36), UINT8_C( 177), UINT8_C( 203),
                             UINT8_C(  41), UINT8_C(   1), UINT8_C( 233), UINT8_C( 193),
                             UINT8_C( 129), UINT8_C(  68), UINT8_C(  48), UINT8_C(  36),
                             UINT8_C(  89), UINT8_C( 144), UINT8_C( 225), UINT8_C( 120),
                             UINT8_C(  35), UINT8_C(  62), UINT8_C( 235), UINT8_C( 142),
                             UINT8_C( 152), UINT8_C(  57), UINT8_C(  42), UINT8_C( 145)),
      simde_x_mm512_set_epu8(UINT8_C(  96), UINT8_C( 192), UINT8_C( 233), UINT8_C( 210),
                             UINT8_C( 227), UINT8_C( 185), UINT8_C(  71), UINT8_C(  90),
                             UINT8_C(  44), UINT8_C( 164), UINT8_C( 225), UINT8_C(  26),
                             UINT8_C( 157), UINT8_C( 203), UINT8_C( 117), UINT8_C(  18),
                             UINT8_C( 193), UINT8_C(  45), UINT8_C(  12), UINT8_C(  24),
                             UINT8_C( 148), UINT8_C(  18), UINT8_C( 196), UINT8_C(  28),
                             UINT8_C(  50), UINT8_C( 245), UINT8_C( 188), UINT8_C( 225),
                             UINT8_C( 105), UINT8_C( 150), UINT8_C(  98), UINT8_C(  51),
                             UINT8_C(  58), UINT8_C( 103), UINT8_C( 111), UINT8_C( 129),
                             UINT8_C(  68), UINT8_C( 200), UINT8_C( 124), UINT8_C( 137),
                             UINT8_C(  74), UINT8_C( 194), UINT8_C( 140), UINT8_C(  37),
                             UINT8_C( 244), UINT8_C( 114), UINT8_C(   0), UINT8_C(  61),
                             UINT8_C( 103), UINT8_C( 252), UINT8_C( 151), UINT8_C( 188),
                             UINT8_C(  39), UINT8_C( 156), UINT8_C( 163), UINT8_C(  11),
                             UINT8_C( 176), UINT8_C( 237), UINT8_C( 234), UINT8_C( 217),
                             UINT8_C( 127), UINT8_C( 218), UINT8_C( 131), UINT8_C( 145)),
      simde_x_mm512_set_epu8(UINT8_C(   0), UINT8_C( 255), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C( 255), UINT8_C( 255), UINT8_C( 200), UINT8_C(   0),
                             UINT8_C( 118), UINT8_C( 236), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C(   0), UINT8_C(  62),
                             UINT8_C( 255), UINT8_C( 255), UINT8_C( 218), UINT8_C(  72),
                             UINT8_C(   0), UINT8_C( 224), UINT8_C( 242), UINT8_C( 219),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C( 149), UINT8_C(   0), UINT8_C( 255), UINT8_C( 176),
                             UINT8_C(  97), UINT8_C( 225), UINT8_C( 150), UINT8_C( 255),
                             UINT8_C(  84), UINT8_C( 230), UINT8_C( 255), UINT8_C( 240),
                             UINT8_C( 255), UINT8_C( 115), UINT8_C( 233), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C( 199), UINT8_C(   0),
                             UINT8_C( 128), UINT8_C( 255), UINT8_C( 255), UINT8_C(   0),
                             UINT8_C( 211), UINT8_C( 255), UINT8_C( 255), UINT8_C( 255),
                             UINT8_C( 255), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0)) },
    { UINT64_C(18325019528117086600),
      simde_x_mm512_set_epu8(UINT8_C( 122), UINT8_C( 202), UINT8_C(  50), UINT8_C( 123),
                             UINT8_C( 225), UINT8_C( 182), UINT8_C( 192), UINT8_C(  54),
                             UINT8_C( 175), UINT8_C(  60), UINT8_C(  31), UINT8_C( 233),
                             UINT8_C( 108), UINT8_C( 137), UINT8_C( 164), UINT8_C( 176),
                             UINT8_C( 226), UINT8_C( 219), UINT8_C(  51), UINT8_C( 220),
                             UINT8_C(   8), UINT8_C(  52), UINT8_C(  97), UINT8_C( 123),
                             UINT8_C( 207), UINT8_C( 132), UINT8_C(  95), UINT8_C( 173),
                             UINT8_C(  70), UINT8_C( 206), UINT8_C( 195), UINT8_C(  25),
                             UINT8_C( 159), UINT8_C(  28), UINT8_C( 198), UINT8_C(  11),
                             UINT8_C( 242), UINT8_C( 126), UINT8_C(  81), UINT8_C(  45),
                             UINT8_C( 233), UINT8_C( 120), UINT8_C( 173), UINT8_C( 240),
                             UINT8_C(   7), UINT8_C(  51), UINT8_C( 199), UINT8_C( 206),
                             UINT8_C( 235), UINT8_C(  98), UINT8_C(  88), UINT8_C(   0),
                             UINT8_C( 190), UINT8_C(   3), UINT8_C( 124), UINT8_C( 143),
                             UINT8_C(  50), UINT8_C(  88), UINT8_C( 171), UINT8_C( 163),
                             UINT8_C( 212), UINT8_C( 243), UINT8_C( 162), UINT8_C(  17)),
      simde_x_mm512_set_epu8(UINT8_C( 243), UINT8_C( 244), UINT8_C( 132), UINT8_C(  96),
                             UINT8_C( 243), UINT8_C( 158), UINT8_C(  99), UINT8_C( 243),
                             UINT8_C(  56), UINT8_C( 211), UINT8_C( 148), UINT8_C( 237),
                             UINT8_C( 132), UINT8_C( 229), UINT8_C(  22), UINT8_C( 126),
                             UINT8_C( 150), UINT8_C( 188), UINT8_C( 196), UINT8_C(   8),
                             UINT8_C(  60), UINT8_C(  93), UINT8_C( 223), UINT8_C( 229),
                             UINT8_C( 249), UINT8_C(  27), UINT8_C( 134), UINT8_C( 218),
                             UINT8_C(  23), UINT8_C(   6), UINT8_C(  45), UINT8_C( 235),
                             UINT8_C( 233), UINT8_C( 155), UINT8_C( 116), UINT8_C( 127),
                             UINT8_C(  96), UINT8_C(  40), UINT8_C( 159), UINT8_C(  40),
                             UINT8_C(  86), UINT8_C( 212), UINT8_C(  70), UINT8_C( 185),
                             UINT8_C(  62), UINT8_C( 235), UINT8_C(  66), UINT8_C(  68),
                             UINT8_C( 169), UINT8_C( 195), UINT8_C(  48), UINT8_C( 186),
                             UINT8_C(  18), UINT8_C( 178), UINT8_C( 158), UINT8_C( 117),
                             UINT8_C(  74), UINT8_C(  32), UINT8_C(  93), UINT8_C( 125),
                             UINT8_C( 209), UINT8_C( 196), UINT8_C( 170), UINT8_C( 117)),
      simde_x_mm512_set_epu8(UINT8_C( 255), UINT8_C( 255), UINT8_C( 182), UINT8_C( 219),
                             UINT8_C( 255), UINT8_C( 255), UINT8_C( 255), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C( 240), UINT8_C( 255), UINT8_C( 186), UINT8_C( 255),
                             UINT8_C( 255), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(  68), UINT8_C( 145), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C( 229), UINT8_C(   0),
                             UINT8_C(  93), UINT8_C(   0), UINT8_C( 240), UINT8_C( 255),
                             UINT8_C( 255), UINT8_C(   0), UINT8_C( 255), UINT8_C( 138),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C( 240), UINT8_C(  85),
                             UINT8_C( 255), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C( 255), UINT8_C( 255),
                             UINT8_C( 255), UINT8_C( 255), UINT8_C( 136), UINT8_C(   0),
                             UINT8_C( 208), UINT8_C(   0), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C( 124), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C( 255), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0)) },
    { UINT64_C( 7677112093376593822),
      simde_x_mm512_set_epu8(UINT8_C( 203), UINT8_C(  34), UINT8_C(   9), UINT8_C(  64),
                             UINT8_C( 195), UINT8_C( 231), UINT8_C( 141), UINT8_C( 100),
                             UINT8_C(  65), UINT8_C(   8), UINT8_C(  69), UINT8_C( 248),
                             UINT8_C( 241), UINT8_C( 205), UINT8_C(   1), UINT8_C(  90),
                             UINT8_C( 115), UINT8_C(  51), UINT8_C( 165), UINT8_C(  56),
                             UINT8_C(  64), UINT8_C( 217), UINT8_C( 137), UINT8_C( 228),
                             UINT8_C( 202), UINT8_C(  28), UINT8_C(  54), UINT8_C( 248),
                             UINT8_C( 202), UINT8_C( 128), UINT8_C( 228), UINT8_C( 185),
                             UINT8_C( 107), UINT8_C( 190), UINT8_C( 142), UINT8_C( 168),
                             UINT8_C(  34), UINT8_C( 173), UINT8_C( 235), UINT8_C( 192),
                             UINT8_C( 121), UINT8_C( 236), UINT8_C( 167), UINT8_C( 162),
                             UINT8_C( 112), UINT8_C( 229), UINT8_C(  81), UINT8_C( 202),
                             UINT8_C( 192), UINT8_C( 142), UINT8_C(  48), UINT8_C( 167),
                             UINT8_C( 195), UINT8_C(  26), UINT8_C(  43), UINT8_C(  29),
                             UINT8_C(   0), UINT8_C(  64), UINT8_C( 123), UINT8_C( 189),
                             UINT8_C(  15), UINT8_C( 120), UINT8_C(  36), UINT8_C(  40)),
      simde_x_mm512_set_epu8(UINT8_C( 113), UINT8_C(  32), UINT8_C(  71), UINT8_C(  55),
                             UINT8_C( 230), UINT8_C(  82), UINT8_C( 175), UINT8_C( 236),
                             UINT8_C( 201), UINT8_C( 112), UINT8_C(  45), UINT8_C(  37),
                             UINT8_C(  67), UINT8_C( 187), UINT8_C(  64), UINT8_C(  39),
                             UINT8_C(  72), UINT8_C(  45), UINT8_C( 120), UINT8_C( 251),
                             UINT8_C( 147), UINT8_C(  62), UINT8_C(  17), UINT8_C(  31),
                             UINT8_C( 226), UINT8_C( 198), UINT8_C(  56), UINT8_C(  21),
                             UINT8_C(  72), UINT8_C( 182), UINT8_C( 216), UINT8_C( 120),
                             UINT8_C(  95), UINT8_C( 108), UINT8_C(  32), UINT8_C(  64),
                             UINT8_C( 128), UINT8_C( 102), UINT8_C( 235), UINT8_C(  28),
                             UINT8_C( 105), UINT8_C(  52), UINT8_C(  85), UINT8_C( 152),
                             UINT8_C(  57), UINT8_C( 225), UINT8_C( 218), UINT8_C( 132),
                             UINT8_C( 149), UINT8_C( 254), UINT8_C(  55), UINT8_C(  46),
                             UINT8_C( 185), UINT8_C(  77), UINT8_C(  18), UINT8_C(  70),
                             UINT8_C(  89), UINT8_C( 125), UINT8_C( 214), UINT8_C( 131),
                             UINT8_C( 121), UINT8_C( 245), UINT8_C( 187), UINT8_C( 197)),
      simde_x_mm512_set_epu8(UINT8_C(   0), UINT8_C(  66), UINT8_C(  80), UINT8_C(   0),
                             UINT8_C( 255), UINT8_C(   0), UINT8_C( 255), UINT8_C(   0),
                             UINT8_C( 255), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C( 255), UINT8_C(   0), UINT8_C(  65), UINT8_C(   0),
                             UINT8_C( 187), UINT8_C(   0), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C( 255), UINT8_C( 226), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C( 255), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C(   0), UINT8_C( 232),
                             UINT8_C( 162), UINT8_C(   0), UINT8_C( 255), UINT8_C(   0),
                             UINT8_C( 226), UINT8_C(   0), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C( 103), UINT8_C( 213),
                             UINT8_C( 255), UINT8_C( 103), UINT8_C(  61), UINT8_C(  99),
                             UINT8_C(  89), UINT8_C(   0), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C( 136), UINT8_C( 255), UINT8_C( 223), UINT8_C(   0)) },
    { UINT64_C( 4840581956081845689),
      simde_x_mm512_set_epu8(UINT8_C( 122), UINT8_C( 148), UINT8_C( 186), UINT8_C( 193),
                             UINT8_C(  56), UINT8_C(  71), UINT8_C( 242), UINT8_C(  49),
                             UINT8_C( 183), UINT8_C(  53), UINT8_C( 227), UINT8_C(   3),
                             UINT8_C( 183), UINT8_C(  43), UINT8_C( 234), UINT8_C(  85),
                             UINT8_C( 230), UINT8_C( 247), UINT8_C(  66), UINT8_C(   1),
                             UINT8_C( 243), UINT8_C(  60), UINT8_C( 137), UINT8_C( 173),
                             UINT8_C( 134), UINT8_C( 192), UINT8_C( 173), UINT8_C( 182),
                             UINT8_C( 119), UINT8_C( 248), UINT8_C(  12), UINT8_C( 113),
                             UINT8_C( 244), UINT8_C( 172), UINT8_C(   6), UINT8_C(  69),
                             UINT8_C(   2), UINT8_C( 181), UINT8_C( 222), UINT8_C( 130),
                             UINT8_C(   3), UINT8_C( 128), UINT8_C( 247), UINT8_C(  24),
                             UINT8_C(  11), UINT8_C( 162), UINT8_C( 224), UINT8_C( 110),
                             UINT8_C(  33), UINT8_C( 232), UINT8_C( 125), UINT8_C(  35),
                             UINT8_C( 153), UINT8_C( 208), UINT8_C( 234), UINT8_C(  38),
                             UINT8_C( 175), UINT8_C(   9), UINT8_C( 245), UINT8_C( 132),
                             UINT8_C(  71), UINT8_C(  31), UINT8_C( 214), UINT8_C(  93)),
      simde_x_mm512_set_epu8(UINT8_C(  53), UINT8_C(  77), UINT8_C(  63), UINT8_C( 172),
                             UINT8_C(  27), UINT8_C(  22), UINT8_C(   3), UINT8_C( 219),
                             UINT8_C(  65), UINT8_C( 118), UINT8_C( 130), UINT8_C(  97),
                             UINT8_C( 109), UINT8_C(   7), UINT8_C( 142), UINT8_C( 181),
                             UINT8_C( 131), UINT8_C( 121), UINT8_C( 128), UINT8_C( 103),
                             UINT8_C(   0), UINT8_C( 101), UINT8_C( 215), UINT8_C(  89),
                             UINT8_C( 173), UINT8_C( 191), UINT8_C(   9), UINT8_C( 249),
                             UINT8_C( 193), UINT8_C(  13), UINT8_C( 105), UINT8_C(  92),
                             UINT8_C( 238), UINT8_C( 235), UINT8_C( 154), UINT8_C( 142),
                             UINT8_C(  74), UINT8_C( 121), UINT8_C( 211), UINT8_C(  52),
                             UINT8_C( 193), UINT8_C( 163), UINT8_C(  98), UINT8_C( 106),
                             UINT8_C( 147), UINT8_C( 209), UINT8_C(  37), UINT8_C(  70),
                             UINT8_C( 100), UINT8_C( 121), UINT8_C(  18), UINT8_C(  28),
                             UINT8_C( 139), UINT8_C( 107), UINT8_C(   3), UINT8_C( 194),
                             UINT8_C(  42), UINT8_C(  72), UINT8_C(  91), UINT8_C(  86),
                             UINT8_C( 184), UINT8_C(   9), UINT8_C( 176), UINT8_C( 118)),
      simde_x_mm512_set_epu8(UINT8_C(   0), UINT8_C( 225), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C( 245), UINT8_C( 255),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C( 255), UINT8_C(   0),
                             UINT8_C( 255), UINT8_C(  50), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C( 194), UINT8_C( 104),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C( 255), UINT8_C( 255),
                             UINT8_C( 255), UINT8_C(   0), UINT8_C( 182), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C( 160), UINT8_C( 211),
                             UINT8_C(  76), UINT8_C( 255), UINT8_C( 255), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C( 255), UINT8_C(   0),
                             UINT8_C( 158), UINT8_C( 255), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C( 133), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C(   0), UINT8_C( 232),
                             UINT8_C( 217), UINT8_C(   0), UINT8_C( 255), UINT8_C( 218),
                             UINT8_C( 255), UINT8_C(   0), UINT8_C(   0), UINT8_C( 211)) },
    { UINT64_C(17498311407133456191),
      simde_x_mm512_set_epu8(UINT8_C(  61), UINT8_C( 167), UINT8_C(  84), UINT8_C( 162),
                             UINT8_C(  31), UINT8_C( 140), UINT8_C( 189), UINT8_C( 154),
                             UINT8_C( 184), UINT8_C( 165), UINT8_C( 151), UINT8_C( 148),
                             UINT8_C( 212), UINT8_C(  74), UINT8_C( 228), UINT8_C( 124),
                             UINT8_C( 120), UINT8_C( 215), UINT8_C( 177), UINT8_C( 122),
                             UINT8_C(  87), UINT8_C( 137), UINT8_C(  54), UINT8_C( 254),
                             UINT8_C( 209), UINT8_C(  84), UINT8_C( 130), UINT8_C( 192),
                             UINT8_C(  14), UINT8_C(  11), UINT8_C(  37), UINT8_C( 233),
                             UINT8_C(  67), UINT8_C( 124), UINT8_C(  58), UINT8_C( 162),
                             UINT8_C(  30), UINT8_C( 223), UINT8_C(  70), UINT8_C( 232),
                             UINT8_C(  38), UINT8_C( 159), UINT8_C( 200), UINT8_C( 196),
                             UINT8_C( 197), UINT8_C(  65), UINT8_C( 182), UINT8_C(  45),
                             UINT8_C( 245), UINT8_C(  55), UINT8_C( 174), UINT8_C(  12),
                             UINT8_C( 106), UINT8_C(  22), UINT8_C( 132), UINT8_C( 252),
                             UINT8_C(   2), UINT8_C( 175), UINT8_C(  14), UINT8_C(  90),
                             UINT8_C( 156), UINT8_C( 134), UINT8_C( 221), UINT8_C(  81)),
      simde_x_mm512_set_epu8(UINT8_C(  21), UINT8_C( 108), UINT8_C( 125), UINT8_C( 196),
                             UINT8_C( 184), UINT8_C(  74), UINT8_C( 251), UINT8_C( 198),
                             UINT8_C( 215), UINT8_C(  22), UINT8_C( 141), UINT8_C( 102),
                             UINT8_C(  59), UINT8_C( 176), UINT8_C( 241), UINT8_C( 193),
                             UINT8_C(  84), UINT8_C( 185), UINT8_C(   8), UINT8_C(  12),
                             UINT8_C( 245), UINT8_C( 180), UINT8_C(  62), UINT8_C(  93),
                             UINT8_C( 181), UINT8_C( 179), UINT8_C( 172), UINT8_C( 148),
                             UINT8_C( 221), UINT8_C(  14), UINT8_C( 196), UINT8_C(  18),
                             UINT8_C(  23), UINT8_C( 196), UINT8_C( 193), UINT8_C( 142),
                             UINT8_C( 201), UINT8_C(  75), UINT8_C( 157), UINT8_C( 201),
                             UINT8_C(  58), UINT8_C(  76), UINT8_C( 154), UINT8_C( 138),
                             UINT8_C( 226), UINT8_C(  39), UINT8_C( 119), UINT8_C(  85),
                             UINT8_C( 248), UINT8_C( 184), UINT8_C( 196), UINT8_C( 162),
                             UINT8_C( 144), UINT8_C( 119), UINT8_C( 124), UINT8_C(  76),
                             UINT8_C( 214), UINT8_C( 132), UINT8_C(  54), UINT8_C(  74),
                             UINT8_C( 164), UINT8_C(  99), UINT8_C(  79), UINT8_C( 253)),
      simde_x_mm512_set_epu8(UINT8_C(  82), UINT8_C( 255), UINT8_C( 209), UINT8_C( 255),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C( 255), UINT8_C(   0),
                             UINT8_C( 255), UINT8_C( 187), UINT8_C(   0), UINT8_C( 250),
                             UINT8_C(   0), UINT8_C( 250), UINT8_C( 255), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C( 185), UINT8_C( 134),
                             UINT8_C( 255), UINT8_C( 255), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C( 255), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C( 233), UINT8_C( 251),
                             UINT8_C(  90), UINT8_C( 255), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 255), UINT8_C( 227), UINT8_C( 255),
                             UINT8_C(   0), UINT8_C( 235), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C( 255), UINT8_C(   0), UINT8_C( 255), UINT8_C(   0),
                             UINT8_C( 255), UINT8_C( 239), UINT8_C( 255), UINT8_C( 174),
                             UINT8_C(   0), UINT8_C( 141), UINT8_C( 255), UINT8_C( 255),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C(  68), UINT8_C( 164),
                             UINT8_C( 255), UINT8_C( 233), UINT8_C( 255), UINT8_C( 255)) },
    { UINT64_C( 3462613925466476941),
      simde_x_mm512_set_epu8(UINT8_C(  18), UINT8_C( 182), UINT8_C(  14), UINT8_C(  36),
                             UINT8_C( 249), UINT8_C( 113), UINT8_C(  40), UINT8_C(  48),
                             UINT8_C( 149), UINT8_C( 222), UINT8_C( 181), UINT8_C(  85),
                             UINT8_C( 221), UINT8_C( 140), UINT8_C(  65), UINT8_C( 235),
                             UINT8_C(  15), UINT8_C(   3), UINT8_C(  45), UINT8_C(  21),
                             UINT8_C(  72), UINT8_C(  93), UINT8_C( 108), UINT8_C( 125),
                             UINT8_C(   1), UINT8_C(  75), UINT8_C(  21), UINT8_C( 220),
                             UINT8_C( 130), UINT8_C( 122), UINT8_C(  71), UINT8_C(  76),
                             UINT8_C(  28), UINT8_C( 200), UINT8_C(  32), UINT8_C( 101),
                             UINT8_C( 149), UINT8_C( 145), UINT8_C( 168), UINT8_C( 237),
                             UINT8_C( 179), UINT8_C(  19), UINT8_C( 235), UINT8_C( 145),
                             UINT8_C( 188), UINT8_C(  82), UINT8_C( 138), UINT8_C( 180),
                             UINT8_C(  47), UINT8_C( 127), UINT8_C(  62), UINT8_C( 240),
                             UINT8_C(  10), UINT8_C( 242), UINT8_C( 156), UINT8_C(  86),
                             UINT8_C(  29), UINT8_C( 107), UINT8_C(  56), UINT8_C(  21),
                             UINT8_C(  24), UINT8_C(  68), UINT8_C( 160), UINT8_C(  64)),
      simde_x_mm512_set_epu8(UINT8_C( 199), UINT8_C(  94), UINT8_C( 131), UINT8_C( 132),
                             UINT8_C(  36), UINT8_C(  57), UINT8_C(  68), UINT8_C( 204),
                             UINT8_C(  39), UINT8_C(  50), UINT8_C( 208), UINT8_C(  94),
                             UINT8_C(  53), UINT8_C(  11), UINT8_C(  29), UINT8_C(  65),
                             UINT8_C( 174), UINT8_C( 137), UINT8_C( 115), UINT8_C(  68),
                             UINT8_C( 187), UINT8_C( 118), UINT8_C(  17), UINT8_C(   8),
                             UINT8_C( 192), UINT8_C( 203), UINT8_C( 214), UINT8_C( 126),
                             UINT8_C(  67), UINT8_C(  50), UINT8_C( 238), UINT8_C(  76),
                             UINT8_C( 237), UINT8_C( 123), UINT8_C( 169), UINT8_C( 106),
                             UINT8_C( 182), UINT8_C(  44), UINT8_C( 117), UINT8_C( 103),
                             UINT8_C(  81), UINT8_C( 122), UINT8_C(  56), UINT8_C( 246),
                             UINT8_C(  67), UINT8_C(  79), UINT8_C(  83), UINT8_C( 218),
                             UINT8_C( 243), UINT8_C(  43), UINT8_C(  27), UINT8_C( 159),
                             UINT8_C( 102), UINT8_C( 126), UINT8_C(  38), UINT8_C( 194),
                             UINT8_C( 232), UINT8_C( 117), UINT8_C( 218), UINT8_C( 163),
                             UINT8_C( 198), UINT8_C( 132), UINT8_C( 181), UINT8_C(  10)),
      simde_x_mm512_set_epu8(UINT8_C(   0), UINT8_C(   0), UINT8_C( 145), UINT8_C( 168),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C( 255), UINT8_C( 151), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C( 189), UINT8_C(   0), UINT8_C( 160), UINT8_C(   0),
                             UINT8_C( 255), UINT8_C( 211), UINT8_C(   0), UINT8_C( 133),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C( 172), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C( 255), UINT8_C( 255), UINT8_C( 201), UINT8_C( 207),
                             UINT8_C( 255), UINT8_C( 189), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C( 255), UINT8_C( 141), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C(   0), UINT8_C(   0), UINT8_C(   0), UINT8_C( 255),
                             UINT8_C( 255), UINT8_C(   0), UINT8_C(   0), UINT8_C(   0),
                             UINT8_C( 222), UINT8_C( 200), UINT8_C(   0), UINT8_C(  74)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_maskz_adds_epu8(test_vec[i].k, test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_u8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_adds_epu16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_x_mm512_set_epu16(UINT16_C( 57245), UINT16_C( 31803), UINT16_C(  9053), UINT16_C( 21282),
                              UINT16_C( 45515), UINT16_C( 57894), UINT16_C( 50445), UINT16_C( 50583),
                              UINT16_C( 54723), UINT16_C( 52144), UINT16_C( 13347), UINT16_C( 57624),
                              UINT16_C( 20975), UINT16_C( 65317), UINT16_C( 16493), UINT16_C( 47193),
                              UINT16_C(  8805), UINT16_C( 17012), UINT16_C( 15383), UINT16_C(  5484),
                              UINT16_C( 64480), UINT16_C( 10898), UINT16_C( 37488), UINT16_C(  8763),
                              UINT16_C( 45480), UINT16_C(  3307), UINT16_C(  9193), UINT16_C( 26229),
                              UINT16_C( 20008), UINT16_C( 59713), UINT16_C( 53564), UINT16_C( 62675)),
      simde_x_mm512_set_epu16(UINT16_C( 56619), UINT16_C( 61703), UINT16_C(  3086), UINT16_C( 41224),
                              UINT16_C(  8421), UINT16_C( 52766), UINT16_C(  7424), UINT16_C( 48822),
                              UINT16_C( 41975), UINT16_C( 22918), UINT16_C( 59915), UINT16_C( 26727),
                              UINT16_C( 53323), UINT16_C( 34707), UINT16_C( 14572), UINT16_C(   716),
                              UINT16_C( 56087), UINT16_C(  9094), UINT16_C( 20814), UINT16_C( 56962),
                              UINT16_C( 14110), UINT16_C( 52082), UINT16_C(  8468), UINT16_C( 11854),
                              UINT16_C(  1576), UINT16_C( 12690), UINT16_C( 32737), UINT16_C( 51663),
                              UINT16_C( 37115), UINT16_C( 18115), UINT16_C( 50682), UINT16_C(  1653)),
      simde_x_mm512_set_epu16(UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 12139), UINT16_C( 62506),
                              UINT16_C( 53936), UINT16_C( 65535), UINT16_C( 57869), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 31065), UINT16_C( 47909),
                              UINT16_C( 64892), UINT16_C( 26106), UINT16_C( 36197), UINT16_C( 62446),
                              UINT16_C( 65535), UINT16_C( 62980), UINT16_C( 45956), UINT16_C( 20617),
                              UINT16_C( 47056), UINT16_C( 15997), UINT16_C( 41930), UINT16_C( 65535),
                              UINT16_C( 57123), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 64328)) },
    { simde_x_mm512_set_epu16(UINT16_C(  1128), UINT16_C( 14143), UINT16_C( 19763), UINT16_C( 47819),
                              UINT16_C( 62972), UINT16_C( 13428), UINT16_C( 18537), UINT16_C( 38297),
                              UINT16_C( 21721), UINT16_C( 58861), UINT16_C( 42577), UINT16_C( 39379),
                              UINT16_C( 55643), UINT16_C( 20439), UINT16_C( 34514), UINT16_C( 49721),
                              UINT16_C( 18526), UINT16_C( 46886), UINT16_C( 20377), UINT16_C( 31658),
                              UINT16_C( 32537), UINT16_C( 50044), UINT16_C( 28503), UINT16_C(  5895),
                              UINT16_C(  1666), UINT16_C( 50137), UINT16_C( 30976), UINT16_C(  4047),
                              UINT16_C( 24589), UINT16_C( 29183), UINT16_C( 13128), UINT16_C(  3541)),
      simde_x_mm512_set_epu16(UINT16_C( 38521), UINT16_C( 64382), UINT16_C( 35873), UINT16_C( 42497),
                              UINT16_C( 46178), UINT16_C( 38904), UINT16_C( 15657), UINT16_C(  6453),
                              UINT16_C( 15377), UINT16_C( 45418), UINT16_C( 38208), UINT16_C( 44948),
                              UINT16_C( 17985), UINT16_C( 28923), UINT16_C( 11094), UINT16_C( 61254),
                              UINT16_C( 41028), UINT16_C(  4939), UINT16_C( 61438), UINT16_C( 34821),
                              UINT16_C(  9578), UINT16_C( 46329), UINT16_C( 53213), UINT16_C( 42297),
                              UINT16_C( 42846), UINT16_C( 12973), UINT16_C( 32628), UINT16_C( 10992),
                              UINT16_C( 56871), UINT16_C( 37695), UINT16_C( 16317), UINT16_C(  4356)),
      simde_x_mm512_set_epu16(UINT16_C( 39649), UINT16_C( 65535), UINT16_C( 55636), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 52332), UINT16_C( 34194), UINT16_C( 44750),
                              UINT16_C( 37098), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 49362), UINT16_C( 45608), UINT16_C( 65535),
                              UINT16_C( 59554), UINT16_C( 51825), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 42115), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 48192),
                              UINT16_C( 44512), UINT16_C( 63110), UINT16_C( 63604), UINT16_C( 15039),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 29445), UINT16_C(  7897)) },
    { simde_x_mm512_set_epu16(UINT16_C( 14747), UINT16_C( 30570), UINT16_C( 56275), UINT16_C( 58793),
                              UINT16_C( 48636), UINT16_C( 11396), UINT16_C( 12142), UINT16_C( 25883),
                              UINT16_C( 48137), UINT16_C( 31445), UINT16_C( 15524), UINT16_C( 49322),
                              UINT16_C(  6761), UINT16_C( 42681), UINT16_C(  8586), UINT16_C( 53309),
                              UINT16_C( 48898), UINT16_C( 23142), UINT16_C( 17912), UINT16_C( 20578),
                              UINT16_C( 42157), UINT16_C( 25705), UINT16_C( 39154), UINT16_C( 32521),
                              UINT16_C(  7302), UINT16_C( 65263), UINT16_C(  7623), UINT16_C( 47267),
                              UINT16_C( 41612), UINT16_C(  7723), UINT16_C( 51815), UINT16_C( 23273)),
      simde_x_mm512_set_epu16(UINT16_C( 29783), UINT16_C( 35133), UINT16_C( 18722), UINT16_C( 24788),
                              UINT16_C(  4507), UINT16_C( 64908), UINT16_C( 18120), UINT16_C( 53792),
                              UINT16_C( 40447), UINT16_C(  2013), UINT16_C( 19329), UINT16_C( 18474),
                              UINT16_C( 45067), UINT16_C( 37105), UINT16_C( 40003), UINT16_C( 11523),
                              UINT16_C( 28865), UINT16_C(  9988), UINT16_C( 16394), UINT16_C( 60605),
                              UINT16_C( 29530), UINT16_C(   612), UINT16_C( 21547), UINT16_C( 12463),
                              UINT16_C( 46586), UINT16_C(  6619), UINT16_C( 39845), UINT16_C(  4328),
                              UINT16_C( 31818), UINT16_C( 16334), UINT16_C( 57400), UINT16_C( 58095)),
      simde_x_mm512_set_epu16(UINT16_C( 44530), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 53143), UINT16_C( 65535), UINT16_C( 30262), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 33458), UINT16_C( 34853), UINT16_C( 65535),
                              UINT16_C( 51828), UINT16_C( 65535), UINT16_C( 48589), UINT16_C( 64832),
                              UINT16_C( 65535), UINT16_C( 33130), UINT16_C( 34306), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 26317), UINT16_C( 60701), UINT16_C( 44984),
                              UINT16_C( 53888), UINT16_C( 65535), UINT16_C( 47468), UINT16_C( 51595),
                              UINT16_C( 65535), UINT16_C( 24057), UINT16_C( 65535), UINT16_C( 65535)) },
    { simde_x_mm512_set_epu16(UINT16_C( 30682), UINT16_C( 30851), UINT16_C(  8660), UINT16_C( 19219),
                              UINT16_C( 10963), UINT16_C(   474), UINT16_C( 23728), UINT16_C( 46528),
                              UINT16_C( 63120), UINT16_C( 45881), UINT16_C( 63086), UINT16_C( 25197),
                              UINT16_C(  2704), UINT16_C(  4513), UINT16_C( 59294), UINT16_C( 60752),
                              UINT16_C( 50954), UINT16_C( 23266), UINT16_C( 27902), UINT16_C(  8814),
                              UINT16_C(  4863), UINT16_C(  1260), UINT16_C( 11681), UINT16_C( 46962),
                              UINT16_C( 62057), UINT16_C(  1167), UINT16_C( 44133), UINT16_C( 29723),
                              UINT16_C( 20503), UINT16_C( 47951), UINT16_C(  6645), UINT16_C( 27511)),
      simde_x_mm512_set_epu16(UINT16_C( 15286), UINT16_C(  5686), UINT16_C( 62529), UINT16_C( 52414),
                              UINT16_C( 64942), UINT16_C( 55157), UINT16_C(  1921), UINT16_C(   414),
                              UINT16_C( 57075), UINT16_C( 38949), UINT16_C( 49837), UINT16_C( 16574),
                              UINT16_C( 63519), UINT16_C( 21815), UINT16_C( 16534), UINT16_C(  5264),
                              UINT16_C( 40611), UINT16_C(  7582), UINT16_C( 27508), UINT16_C( 40060),
                              UINT16_C( 17332), UINT16_C( 48486), UINT16_C( 46457), UINT16_C(  3074),
                              UINT16_C( 49520), UINT16_C( 35694), UINT16_C( 14820), UINT16_C( 26739),
                              UINT16_C( 52931), UINT16_C( 30426), UINT16_C( 34639), UINT16_C( 60126)),
      simde_x_mm512_set_epu16(UINT16_C( 45968), UINT16_C( 36537), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 55631), UINT16_C( 25649), UINT16_C( 46942),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 41771),
                              UINT16_C( 65535), UINT16_C( 26328), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 30848), UINT16_C( 55410), UINT16_C( 48874),
                              UINT16_C( 22195), UINT16_C( 49746), UINT16_C( 58138), UINT16_C( 50036),
                              UINT16_C( 65535), UINT16_C( 36861), UINT16_C( 58953), UINT16_C( 56462),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 41284), UINT16_C( 65535)) },
    { simde_x_mm512_set_epu16(UINT16_C( 20277), UINT16_C(  2901), UINT16_C(  9119), UINT16_C( 39166),
                              UINT16_C( 42714), UINT16_C( 26596), UINT16_C( 65466), UINT16_C( 41724),
                              UINT16_C( 43509), UINT16_C( 36161), UINT16_C( 14559), UINT16_C( 39814),
                              UINT16_C( 39598), UINT16_C( 35810), UINT16_C( 32670), UINT16_C(  2206),
                              UINT16_C( 28889), UINT16_C( 41636), UINT16_C( 48990), UINT16_C( 37294),
                              UINT16_C( 39242), UINT16_C( 39778), UINT16_C(  6979), UINT16_C( 54232),
                              UINT16_C( 47738), UINT16_C( 57923), UINT16_C( 37900), UINT16_C( 45798),
                              UINT16_C( 44781), UINT16_C( 27960), UINT16_C(  1998), UINT16_C( 61149)),
      simde_x_mm512_set_epu16(UINT16_C( 20730), UINT16_C( 18080), UINT16_C( 51364), UINT16_C( 27968),
                              UINT16_C( 47873), UINT16_C( 51993), UINT16_C( 18829), UINT16_C( 15054),
                              UINT16_C( 50771), UINT16_C( 37023), UINT16_C( 39205), UINT16_C( 18252),
                              UINT16_C( 53613), UINT16_C( 36736), UINT16_C( 53958), UINT16_C( 13137),
                              UINT16_C( 43763), UINT16_C( 19789), UINT16_C(  2934), UINT16_C( 22986),
                              UINT16_C( 46964), UINT16_C( 64986), UINT16_C( 13395), UINT16_C( 61287),
                              UINT16_C( 61677), UINT16_C( 22301), UINT16_C( 41322), UINT16_C( 35063),
                              UINT16_C( 22663), UINT16_C( 28062), UINT16_C( 45351), UINT16_C( 21097)),
      simde_x_mm512_set_epu16(UINT16_C( 41007), UINT16_C( 20981), UINT16_C( 60483), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 56778),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 53764), UINT16_C( 58066),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 15343),
                              UINT16_C( 65535), UINT16_C( 61425), UINT16_C( 51924), UINT16_C( 60280),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 20374), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 56022), UINT16_C( 47349), UINT16_C( 65535)) },
    { simde_x_mm512_set_epu16(UINT16_C( 29192), UINT16_C(  8654), UINT16_C( 22850), UINT16_C( 62764),
                              UINT16_C( 24193), UINT16_C( 41054), UINT16_C( 47201), UINT16_C( 29473),
                              UINT16_C(  7514), UINT16_C( 21604), UINT16_C( 55170), UINT16_C( 17089),
                              UINT16_C( 58910), UINT16_C( 18576), UINT16_C( 50942), UINT16_C( 19375),
                              UINT16_C( 32394), UINT16_C(  6670), UINT16_C( 34291), UINT16_C( 10597),
                              UINT16_C( 63848), UINT16_C( 24622), UINT16_C( 55141), UINT16_C( 33399),
                              UINT16_C( 17676), UINT16_C( 53111), UINT16_C( 57678), UINT16_C( 53869),
                              UINT16_C(  1069), UINT16_C( 35377), UINT16_C( 20392), UINT16_C(  6033)),
      simde_x_mm512_set_epu16(UINT16_C( 30110), UINT16_C(  5765), UINT16_C( 21533), UINT16_C( 32154),
                              UINT16_C( 47788), UINT16_C(  4708), UINT16_C( 49450), UINT16_C( 15569),
                              UINT16_C( 11433), UINT16_C( 48528), UINT16_C( 18868), UINT16_C( 49914),
                              UINT16_C( 29591), UINT16_C( 10234), UINT16_C( 18676), UINT16_C( 18833),
                              UINT16_C( 53298), UINT16_C( 44056), UINT16_C(   163), UINT16_C( 14043),
                              UINT16_C( 52308), UINT16_C( 55462), UINT16_C(  1379), UINT16_C( 56593),
                              UINT16_C( 40649), UINT16_C( 10209), UINT16_C( 62181), UINT16_C(  6865),
                              UINT16_C( 33659), UINT16_C( 12643), UINT16_C( 58853), UINT16_C( 27590)),
      simde_x_mm512_set_epu16(UINT16_C( 59302), UINT16_C( 14419), UINT16_C( 44383), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 45762), UINT16_C( 65535), UINT16_C( 45042),
                              UINT16_C( 18947), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 28810), UINT16_C( 65535), UINT16_C( 38208),
                              UINT16_C( 65535), UINT16_C( 50726), UINT16_C( 34454), UINT16_C( 24640),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 56520), UINT16_C( 65535),
                              UINT16_C( 58325), UINT16_C( 63320), UINT16_C( 65535), UINT16_C( 60734),
                              UINT16_C( 34728), UINT16_C( 48020), UINT16_C( 65535), UINT16_C( 33623)) },
    { simde_x_mm512_set_epu16(UINT16_C( 54408), UINT16_C( 44486), UINT16_C( 24517), UINT16_C( 51207),
                              UINT16_C(  2791), UINT16_C( 45592), UINT16_C( 48586), UINT16_C( 36784),
                              UINT16_C( 53369), UINT16_C( 43811), UINT16_C( 65046), UINT16_C( 44235),
                              UINT16_C( 48681), UINT16_C( 21401), UINT16_C( 55417), UINT16_C(  5581),
                              UINT16_C( 56410), UINT16_C( 42092), UINT16_C( 49678), UINT16_C( 22777),
                              UINT16_C( 15839), UINT16_C( 59069), UINT16_C(  3836), UINT16_C( 55877),
                              UINT16_C( 35316), UINT16_C( 40611), UINT16_C( 30925), UINT16_C( 38925),
                              UINT16_C( 44290), UINT16_C( 48844), UINT16_C( 41388), UINT16_C( 24135)),
      simde_x_mm512_set_epu16(UINT16_C(  7663), UINT16_C(  4305), UINT16_C( 48670), UINT16_C( 39779),
                              UINT16_C(  2052), UINT16_C( 40026), UINT16_C( 47264), UINT16_C(  7297),
                              UINT16_C( 11022), UINT16_C( 64822), UINT16_C( 63292), UINT16_C( 56921),
                              UINT16_C(  8160), UINT16_C( 61766), UINT16_C( 22014), UINT16_C( 41597),
                              UINT16_C( 60919), UINT16_C( 45399), UINT16_C( 45462), UINT16_C( 35135),
                              UINT16_C( 13486), UINT16_C( 42127), UINT16_C(  6466), UINT16_C(  5931),
                              UINT16_C( 30448), UINT16_C( 27493), UINT16_C( 24921), UINT16_C( 23842),
                              UINT16_C( 21170), UINT16_C( 62954), UINT16_C(  7914), UINT16_C( 35527)),
      simde_x_mm512_set_epu16(UINT16_C( 62071), UINT16_C( 48791), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C(  4843), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 44081),
                              UINT16_C( 64391), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 56841), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 47178),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 57912),
                              UINT16_C( 29325), UINT16_C( 65535), UINT16_C( 10302), UINT16_C( 61808),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 55846), UINT16_C( 62767),
                              UINT16_C( 65460), UINT16_C( 65535), UINT16_C( 49302), UINT16_C( 59662)) },
    { simde_x_mm512_set_epu16(UINT16_C( 61865), UINT16_C( 23426), UINT16_C(  1768), UINT16_C( 58636),
                              UINT16_C( 57533), UINT16_C( 19108), UINT16_C( 59802), UINT16_C( 30792),
                              UINT16_C( 61240), UINT16_C(  6209), UINT16_C( 32476), UINT16_C( 14300),
                              UINT16_C(  7420), UINT16_C(  1985), UINT16_C( 25770), UINT16_C( 58800),
                              UINT16_C( 51482), UINT16_C( 20894), UINT16_C(   680), UINT16_C( 29487),
                              UINT16_C( 45202), UINT16_C( 20181), UINT16_C( 14712), UINT16_C( 17612),
                              UINT16_C( 16683), UINT16_C(  1453), UINT16_C( 15990), UINT16_C( 36509),
                              UINT16_C( 51737), UINT16_C( 56324), UINT16_C( 34493), UINT16_C( 17761)),
      simde_x_mm512_set_epu16(UINT16_C( 37550), UINT16_C( 51250), UINT16_C( 42874), UINT16_C(  8384),
                              UINT16_C( 13698), UINT16_C( 33689), UINT16_C( 64372), UINT16_C( 20393),
                              UINT16_C( 17692), UINT16_C( 65383), UINT16_C(   545), UINT16_C( 27220),
                              UINT16_C( 18321), UINT16_C( 26532), UINT16_C( 40835), UINT16_C( 14036),
                              UINT16_C(  3666), UINT16_C(  2040), UINT16_C( 61839), UINT16_C( 38748),
                              UINT16_C( 62699), UINT16_C( 55831), UINT16_C( 23293), UINT16_C( 13208),
                              UINT16_C( 60975), UINT16_C( 12632), UINT16_C( 13392), UINT16_C( 63703),
                              UINT16_C( 41286), UINT16_C(  6117), UINT16_C( 32645), UINT16_C( 56152)),
      simde_x_mm512_set_epu16(UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 44642), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 52797), UINT16_C( 65535), UINT16_C( 51185),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 33021), UINT16_C( 41520),
                              UINT16_C( 25741), UINT16_C( 28517), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 55148), UINT16_C( 22934), UINT16_C( 62519), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 38005), UINT16_C( 30820),
                              UINT16_C( 65535), UINT16_C( 14085), UINT16_C( 29382), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 62441), UINT16_C( 65535), UINT16_C( 65535)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_adds_epu16(test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_u16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_avg_epu8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_x_mm512_set_epu8(UINT8_C( 54), UINT8_C( 98), UINT8_C(144), UINT8_C( 33),
                             UINT8_C(227), UINT8_C( 68), UINT8_C( 44), UINT8_C(252),
                             UINT8_C(188), UINT8_C(131), UINT8_C( 22), UINT8_C(137),
                             UINT8_C(110), UINT8_C(230), UINT8_C(116), UINT8_C( 30),
                             UINT8_C(237), UINT8_C(136), UINT8_C(151), UINT8_C(122),
                             UINT8_C( 83), UINT8_C(138), UINT8_C(146), UINT8_C(187),
                             UINT8_C( 83), UINT8_C(179), UINT8_C(167), UINT8_C( 88),
                             UINT8_C(248), UINT8_C( 88), UINT8_C(101), UINT8_C(132),
                             UINT8_C(203), UINT8_C( 36), UINT8_C( 53), UINT8_C(174),
                             UINT8_C( 78), UINT8_C( 97), UINT8_C(124), UINT8_C(201),
                             UINT8_C( 12), UINT8_C(233), UINT8_C(196), UINT8_C(121),
                             UINT8_C( 77), UINT8_C(  2), UINT8_C(189), UINT8_C(251),
                             UINT8_C(252), UINT8_C(129), UINT8_C( 38), UINT8_C(107),
                             UINT8_C(130), UINT8_C(227), UINT8_C(158), UINT8_C(158),
                             UINT8_C(195), UINT8_C( 10), UINT8_C(101), UINT8_C( 55),
                             UINT8_C( 64), UINT8_C(106), UINT8_C(118), UINT8_C( 58)),
      simde_x_mm512_set_epu8(UINT8_C(139), UINT8_C( 91), UINT8_C( 12), UINT8_C(185),
                             UINT8_C( 48), UINT8_C(130), UINT8_C(230), UINT8_C(176),
                             UINT8_C(212), UINT8_C( 20), UINT8_C(110), UINT8_C(217),
                             UINT8_C(186), UINT8_C(186), UINT8_C(132), UINT8_C(114),
                             UINT8_C(188), UINT8_C(251), UINT8_C(225), UINT8_C(230),
                             UINT8_C(165), UINT8_C(108), UINT8_C( 17), UINT8_C(  9),
                             UINT8_C(245), UINT8_C(227), UINT8_C(125), UINT8_C(240),
                             UINT8_C( 47), UINT8_C( 91), UINT8_C(  3), UINT8_C(135),
                             UINT8_C(243), UINT8_C(103), UINT8_C(152), UINT8_C(185),
                             UINT8_C( 49), UINT8_C(  8), UINT8_C( 66), UINT8_C(147),
                             UINT8_C( 50), UINT8_C(167), UINT8_C( 57), UINT8_C(102),
                             UINT8_C(142), UINT8_C( 47), UINT8_C(173), UINT8_C( 47),
                             UINT8_C(172), UINT8_C(237), UINT8_C( 57), UINT8_C(255),
                             UINT8_C(101), UINT8_C(227), UINT8_C(198), UINT8_C(199),
                             UINT8_C( 25), UINT8_C(175), UINT8_C(229), UINT8_C(172),
                             UINT8_C(210), UINT8_C(198), UINT8_C(215), UINT8_C(150)),
      simde_x_mm512_set_epu8(UINT8_C( 97), UINT8_C( 95), UINT8_C( 78), UINT8_C(109),
                             UINT8_C(138), UINT8_C( 99), UINT8_C(137), UINT8_C(214),
                             UINT8_C(200), UINT8_C( 76), UINT8_C( 66), UINT8_C(177),
                             UINT8_C(148), UINT8_C(208), UINT8_C(124), UINT8_C( 72),
                             UINT8_C(213), UINT8_C(194), UINT8_C(188), UINT8_C(176),
                             UINT8_C(124), UINT8_C(123), UINT8_C( 82), UINT8_C( 98),
                             UINT8_C(164), UINT8_C(203), UINT8_C(146), UINT8_C(164),
                             UINT8_C(148), UINT8_C( 90), UINT8_C( 52), UINT8_C(134),
                             UINT8_C(223), UINT8_C( 70), UINT8_C(103), UINT8_C(180),
                             UINT8_C( 64), UINT8_C( 53), UINT8_C( 95), UINT8_C(174),
                             UINT8_C( 31), UINT8_C(200), UINT8_C(127), UINT8_C(112),
                             UINT8_C(110), UINT8_C( 25), UINT8_C(181), UINT8_C(149),
                             UINT8_C(212), UINT8_C(183), UINT8_C( 48), UINT8_C(181),
                             UINT8_C(116), UINT8_C(227), UINT8_C(178), UINT8_C(179),
                             UINT8_C(110), UINT8_C( 93), UINT8_C(165), UINT8_C(114),
                             UINT8_C(137), UINT8_C(152), UINT8_C(167), UINT8_C(104)) },
    { simde_x_mm512_set_epu8(UINT8_C(208), UINT8_C(219), UINT8_C( 57), UINT8_C(220),
                             UINT8_C(  6), UINT8_C( 65), UINT8_C( 21), UINT8_C( 70),
                             UINT8_C( 42), UINT8_C( 69), UINT8_C(205), UINT8_C( 75),
                             UINT8_C( 45), UINT8_C( 93), UINT8_C(126), UINT8_C(  6),
                             UINT8_C(174), UINT8_C( 50), UINT8_C( 17), UINT8_C(221),
                             UINT8_C(217), UINT8_C(127), UINT8_C(111), UINT8_C(120),
                             UINT8_C(131), UINT8_C(148), UINT8_C(141), UINT8_C(152),
                             UINT8_C(144), UINT8_C(136), UINT8_C( 66), UINT8_C( 61),
                             UINT8_C(132), UINT8_C(112), UINT8_C( 28), UINT8_C(152),
                             UINT8_C(127), UINT8_C(231), UINT8_C(109), UINT8_C(161),
                             UINT8_C(158), UINT8_C(  6), UINT8_C(213), UINT8_C(173),
                             UINT8_C(118), UINT8_C(179), UINT8_C( 79), UINT8_C(178),
                             UINT8_C( 46), UINT8_C(236), UINT8_C( 49), UINT8_C( 56),
                             UINT8_C(157), UINT8_C(129), UINT8_C( 46), UINT8_C(200),
                             UINT8_C( 89), UINT8_C(130), UINT8_C(187), UINT8_C(247),
                             UINT8_C(213), UINT8_C( 39), UINT8_C(146), UINT8_C(142)),
      simde_x_mm512_set_epu8(UINT8_C( 76), UINT8_C(227), UINT8_C(192), UINT8_C(129),
                             UINT8_C(228), UINT8_C( 26), UINT8_C(165), UINT8_C(150),
                             UINT8_C(111), UINT8_C( 32), UINT8_C( 11), UINT8_C( 66),
                             UINT8_C( 65), UINT8_C(106), UINT8_C(209), UINT8_C(140),
                             UINT8_C( 66), UINT8_C(  2), UINT8_C(157), UINT8_C(126),
                             UINT8_C( 65), UINT8_C(  8), UINT8_C( 57), UINT8_C( 55),
                             UINT8_C(150), UINT8_C( 40), UINT8_C(164), UINT8_C( 54),
                             UINT8_C( 94), UINT8_C(153), UINT8_C(234), UINT8_C(140),
                             UINT8_C( 45), UINT8_C( 64), UINT8_C(136), UINT8_C(209),
                             UINT8_C(101), UINT8_C(213), UINT8_C(147), UINT8_C(253),
                             UINT8_C( 57), UINT8_C(116), UINT8_C( 96), UINT8_C( 87),
                             UINT8_C(172), UINT8_C( 78), UINT8_C(156), UINT8_C(126),
                             UINT8_C(  3), UINT8_C(150), UINT8_C(133), UINT8_C( 13),
                             UINT8_C(226), UINT8_C( 18), UINT8_C(106), UINT8_C(202),
                             UINT8_C( 95), UINT8_C( 92), UINT8_C( 59), UINT8_C(210),
                             UINT8_C(140), UINT8_C( 87), UINT8_C(213), UINT8_C( 52)),
      simde_x_mm512_set_epu8(UINT8_C(142), UINT8_C(223), UINT8_C(125), UINT8_C(175),
                             UINT8_C(117), UINT8_C( 46), UINT8_C( 93), UINT8_C(110),
                             UINT8_C( 77), UINT8_C( 51), UINT8_C(108), UINT8_C( 71),
                             UINT8_C( 55), UINT8_C(100), UINT8_C(168), UINT8_C( 73),
                             UINT8_C(120), UINT8_C( 26), UINT8_C( 87), UINT8_C(174),
                             UINT8_C(141), UINT8_C( 68), UINT8_C( 84), UINT8_C( 88),
                             UINT8_C(141), UINT8_C( 94), UINT8_C(153), UINT8_C(103),
                             UINT8_C(119), UINT8_C(145), UINT8_C(150), UINT8_C(101),
                             UINT8_C( 89), UINT8_C( 88), UINT8_C( 82), UINT8_C(181),
                             UINT8_C(114), UINT8_C(222), UINT8_C(128), UINT8_C(207),
                             UINT8_C(108), UINT8_C( 61), UINT8_C(155), UINT8_C(130),
                             UINT8_C(145), UINT8_C(129), UINT8_C(118), UINT8_C(152),
                             UINT8_C( 25), UINT8_C(193), UINT8_C( 91), UINT8_C( 35),
                             UINT8_C(192), UINT8_C( 74), UINT8_C( 76), UINT8_C(201),
                             UINT8_C( 92), UINT8_C(111), UINT8_C(123), UINT8_C(229),
                             UINT8_C(177), UINT8_C( 63), UINT8_C(180), UINT8_C( 97)) },
    { simde_x_mm512_set_epu8(UINT8_C( 11), UINT8_C(110), UINT8_C(145), UINT8_C( 98),
                             UINT8_C(192), UINT8_C(110), UINT8_C(161), UINT8_C( 50),
                             UINT8_C(252), UINT8_C(104), UINT8_C(187), UINT8_C( 15),
                             UINT8_C(183), UINT8_C(198), UINT8_C( 79), UINT8_C(  9),
                             UINT8_C( 68), UINT8_C(123), UINT8_C(137), UINT8_C(144),
                             UINT8_C(105), UINT8_C( 90), UINT8_C( 86), UINT8_C( 94),
                             UINT8_C( 93), UINT8_C( 77), UINT8_C(192), UINT8_C(  8),
                             UINT8_C( 44), UINT8_C( 25), UINT8_C( 87), UINT8_C(143),
                             UINT8_C(226), UINT8_C( 88), UINT8_C(154), UINT8_C(252),
                             UINT8_C( 55), UINT8_C(166), UINT8_C(142), UINT8_C(195),
                             UINT8_C(169), UINT8_C(178), UINT8_C(205), UINT8_C( 91),
                             UINT8_C( 65), UINT8_C(198), UINT8_C(127), UINT8_C( 53),
                             UINT8_C(245), UINT8_C( 24), UINT8_C(177), UINT8_C(240),
                             UINT8_C(199), UINT8_C( 24), UINT8_C(143), UINT8_C(108),
                             UINT8_C( 39), UINT8_C(170), UINT8_C(163), UINT8_C(222),
                             UINT8_C( 56), UINT8_C(160), UINT8_C(200), UINT8_C(122)),
      simde_x_mm512_set_epu8(UINT8_C( 57), UINT8_C( 48), UINT8_C(248), UINT8_C( 92),
                             UINT8_C( 57), UINT8_C(154), UINT8_C( 83), UINT8_C(125),
                             UINT8_C( 10), UINT8_C(154), UINT8_C( 72), UINT8_C(111),
                             UINT8_C( 67), UINT8_C( 46), UINT8_C(125), UINT8_C(202),
                             UINT8_C( 45), UINT8_C( 61), UINT8_C( 52), UINT8_C(168),
                             UINT8_C(212), UINT8_C( 16), UINT8_C( 37), UINT8_C(131),
                             UINT8_C( 48), UINT8_C( 90), UINT8_C(210), UINT8_C(233),
                             UINT8_C(148), UINT8_C(  2), UINT8_C( 10), UINT8_C( 62),
                             UINT8_C( 89), UINT8_C(180), UINT8_C( 94), UINT8_C( 22),
                             UINT8_C(254), UINT8_C( 77), UINT8_C(  0), UINT8_C(151),
                             UINT8_C(212), UINT8_C( 38), UINT8_C(106), UINT8_C(205),
                             UINT8_C( 72), UINT8_C(159), UINT8_C(226), UINT8_C( 51),
                             UINT8_C( 53), UINT8_C(162), UINT8_C(189), UINT8_C( 88),
                             UINT8_C( 42), UINT8_C(136), UINT8_C(104), UINT8_C(208),
                             UINT8_C(154), UINT8_C(241), UINT8_C(187), UINT8_C(143),
                             UINT8_C(157), UINT8_C( 95), UINT8_C( 29), UINT8_C( 97)),
      simde_x_mm512_set_epu8(UINT8_C( 34), UINT8_C( 79), UINT8_C(197), UINT8_C( 95),
                             UINT8_C(125), UINT8_C(132), UINT8_C(122), UINT8_C( 88),
                             UINT8_C(131), UINT8_C(129), UINT8_C(130), UINT8_C( 63),
                             UINT8_C(125), UINT8_C(122), UINT8_C(102), UINT8_C(106),
                             UINT8_C( 57), UINT8_C( 92), UINT8_C( 95), UINT8_C(156),
                             UINT8_C(159), UINT8_C( 53), UINT8_C( 62), UINT8_C(113),
                             UINT8_C( 71), UINT8_C( 84), UINT8_C(201), UINT8_C(121),
                             UINT8_C( 96), UINT8_C( 14), UINT8_C( 49), UINT8_C(103),
                             UINT8_C(158), UINT8_C(134), UINT8_C(124), UINT8_C(137),
                             UINT8_C(155), UINT8_C(122), UINT8_C( 71), UINT8_C(173),
                             UINT8_C(191), UINT8_C(108), UINT8_C(156), UINT8_C(148),
                             UINT8_C( 69), UINT8_C(179), UINT8_C(177), UINT8_C( 52),
                             UINT8_C(149), UINT8_C( 93), UINT8_C(183), UINT8_C(164),
                             UINT8_C(121), UINT8_C( 80), UINT8_C(124), UINT8_C(158),
                             UINT8_C( 97), UINT8_C(206), UINT8_C(175), UINT8_C(183),
                             UINT8_C(107), UINT8_C(128), UINT8_C(115), UINT8_C(110)) },
    { simde_x_mm512_set_epu8(UINT8_C(130), UINT8_C( 79), UINT8_C( 82), UINT8_C(  5),
                             UINT8_C(236), UINT8_C(119), UINT8_C( 25), UINT8_C( 77),
                             UINT8_C(139), UINT8_C(103), UINT8_C(204), UINT8_C( 53),
                             UINT8_C( 70), UINT8_C( 81), UINT8_C( 35), UINT8_C(154),
                             UINT8_C(229), UINT8_C( 64), UINT8_C( 94), UINT8_C(131),
                             UINT8_C(217), UINT8_C(  4), UINT8_C(103), UINT8_C(204),
                             UINT8_C( 53), UINT8_C( 46), UINT8_C(123), UINT8_C(123),
                             UINT8_C(251), UINT8_C(227), UINT8_C(153), UINT8_C( 16),
                             UINT8_C( 79), UINT8_C(199), UINT8_C( 15), UINT8_C(177),
                             UINT8_C( 83), UINT8_C( 15), UINT8_C( 37), UINT8_C(215),
                             UINT8_C(178), UINT8_C(145), UINT8_C(240), UINT8_C( 53),
                             UINT8_C(116), UINT8_C(195), UINT8_C(101), UINT8_C(243),
                             UINT8_C(134), UINT8_C( 93), UINT8_C( 64), UINT8_C(103),
                             UINT8_C( 73), UINT8_C( 82), UINT8_C(189), UINT8_C( 37),
                             UINT8_C(202), UINT8_C( 62), UINT8_C(157), UINT8_C( 97),
                             UINT8_C(142), UINT8_C(  6), UINT8_C( 38), UINT8_C( 24)),
      simde_x_mm512_set_epu8(UINT8_C( 57), UINT8_C( 93), UINT8_C(144), UINT8_C( 30),
                             UINT8_C( 11), UINT8_C(223), UINT8_C( 55), UINT8_C(131),
                             UINT8_C( 29), UINT8_C(176), UINT8_C( 52), UINT8_C( 84),
                             UINT8_C( 79), UINT8_C( 47), UINT8_C(128), UINT8_C( 28),
                             UINT8_C( 73), UINT8_C(131), UINT8_C(138), UINT8_C(  1),
                             UINT8_C( 98), UINT8_C(110), UINT8_C(210), UINT8_C(168),
                             UINT8_C(208), UINT8_C(103), UINT8_C(151), UINT8_C( 58),
                             UINT8_C(149), UINT8_C( 16), UINT8_C(113), UINT8_C( 41),
                             UINT8_C(201), UINT8_C( 13), UINT8_C(211), UINT8_C(230),
                             UINT8_C(208), UINT8_C(154), UINT8_C( 49), UINT8_C(127),
                             UINT8_C( 93), UINT8_C(  7), UINT8_C(136), UINT8_C( 53),
                             UINT8_C( 19), UINT8_C( 95), UINT8_C(187), UINT8_C(149),
                             UINT8_C(  0), UINT8_C(161), UINT8_C(228), UINT8_C( 84),
                             UINT8_C( 84), UINT8_C(105), UINT8_C( 90), UINT8_C( 17),
                             UINT8_C(  3), UINT8_C(183), UINT8_C(131), UINT8_C( 24),
                             UINT8_C(201), UINT8_C(  5), UINT8_C(128), UINT8_C( 80)),
      simde_x_mm512_set_epu8(UINT8_C( 94), UINT8_C( 86), UINT8_C(113), UINT8_C( 18),
                             UINT8_C(124), UINT8_C(171), UINT8_C( 40), UINT8_C(104),
                             UINT8_C( 84), UINT8_C(140), UINT8_C(128), UINT8_C( 69),
                             UINT8_C( 75), UINT8_C( 64), UINT8_C( 82), UINT8_C( 91),
                             UINT8_C(151), UINT8_C( 98), UINT8_C(116), UINT8_C( 66),
                             UINT8_C(158), UINT8_C( 57), UINT8_C(157), UINT8_C(186),
                             UINT8_C(131), UINT8_C( 75), UINT8_C(137), UINT8_C( 91),
                             UINT8_C(200), UINT8_C(122), UINT8_C(133), UINT8_C( 29),
                             UINT8_C(140), UINT8_C(106), UINT8_C(113), UINT8_C(204),
                             UINT8_C(146), UINT8_C( 85), UINT8_C( 43), UINT8_C(171),
                             UINT8_C(136), UINT8_C( 76), UINT8_C(188), UINT8_C( 53),
                             UINT8_C( 68), UINT8_C(145), UINT8_C(144), UINT8_C(196),
                             UINT8_C( 67), UINT8_C(127), UINT8_C(146), UINT8_C( 94),
                             UINT8_C( 79), UINT8_C( 94), UINT8_C(140), UINT8_C( 27),
                             UINT8_C(103), UINT8_C(123), UINT8_C(144), UINT8_C( 61),
                             UINT8_C(172), UINT8_C(  6), UINT8_C( 83), UINT8_C( 52)) },
    { simde_x_mm512_set_epu8(UINT8_C( 64), UINT8_C( 98), UINT8_C(116), UINT8_C(169),
                             UINT8_C(168), UINT8_C(153), UINT8_C(192), UINT8_C(140),
                             UINT8_C( 79), UINT8_C( 29), UINT8_C(180), UINT8_C(232),
                             UINT8_C( 89), UINT8_C( 84), UINT8_C(140), UINT8_C(130),
                             UINT8_C(108), UINT8_C(184), UINT8_C(116), UINT8_C( 83),
                             UINT8_C(161), UINT8_C(105), UINT8_C( 17), UINT8_C(119),
                             UINT8_C(  0), UINT8_C(101), UINT8_C(104), UINT8_C(103),
                             UINT8_C(226), UINT8_C( 60), UINT8_C( 23), UINT8_C(129),
                             UINT8_C(141), UINT8_C(179), UINT8_C( 87), UINT8_C(113),
                             UINT8_C(251), UINT8_C(219), UINT8_C(107), UINT8_C(119),
                             UINT8_C( 70), UINT8_C(169), UINT8_C( 11), UINT8_C( 91),
                             UINT8_C( 23), UINT8_C(156), UINT8_C( 99), UINT8_C( 36),
                             UINT8_C(154), UINT8_C( 26), UINT8_C( 23), UINT8_C(168),
                             UINT8_C( 12), UINT8_C(101), UINT8_C(189), UINT8_C(124),
                             UINT8_C(154), UINT8_C( 52), UINT8_C(134), UINT8_C(128),
                             UINT8_C(213), UINT8_C( 85), UINT8_C(189), UINT8_C(209)),
      simde_x_mm512_set_epu8(UINT8_C( 21), UINT8_C( 27), UINT8_C( 57), UINT8_C(175),
                             UINT8_C(191), UINT8_C( 35), UINT8_C( 75), UINT8_C(  5),
                             UINT8_C(168), UINT8_C( 42), UINT8_C(198), UINT8_C(223),
                             UINT8_C(239), UINT8_C(225), UINT8_C(227), UINT8_C(  5),
                             UINT8_C( 85), UINT8_C(196), UINT8_C(184), UINT8_C(155),
                             UINT8_C( 73), UINT8_C(109), UINT8_C(131), UINT8_C(103),
                             UINT8_C(131), UINT8_C(155), UINT8_C(105), UINT8_C( 70),
                             UINT8_C(164), UINT8_C(114), UINT8_C(114), UINT8_C(212),
                             UINT8_C(157), UINT8_C( 34), UINT8_C(220), UINT8_C(250),
                             UINT8_C(254), UINT8_C(227), UINT8_C(240), UINT8_C( 41),
                             UINT8_C(208), UINT8_C( 26), UINT8_C(221), UINT8_C(132),
                             UINT8_C(121), UINT8_C(178), UINT8_C(219), UINT8_C( 55),
                             UINT8_C( 45), UINT8_C( 78), UINT8_C(233), UINT8_C( 53),
                             UINT8_C( 87), UINT8_C(172), UINT8_C(122), UINT8_C(147),
                             UINT8_C(187), UINT8_C(115), UINT8_C( 22), UINT8_C(254),
                             UINT8_C(  9), UINT8_C(218), UINT8_C(224), UINT8_C(214)),
      simde_x_mm512_set_epu8(UINT8_C( 43), UINT8_C( 63), UINT8_C( 87), UINT8_C(172),
                             UINT8_C(180), UINT8_C( 94), UINT8_C(134), UINT8_C( 73),
                             UINT8_C(124), UINT8_C( 36), UINT8_C(189), UINT8_C(228),
                             UINT8_C(164), UINT8_C(155), UINT8_C(184), UINT8_C( 68),
                             UINT8_C( 97), UINT8_C(190), UINT8_C(150), UINT8_C(119),
                             UINT8_C(117), UINT8_C(107), UINT8_C( 74), UINT8_C(111),
                             UINT8_C( 66), UINT8_C(128), UINT8_C(105), UINT8_C( 87),
                             UINT8_C(195), UINT8_C( 87), UINT8_C( 69), UINT8_C(171),
                             UINT8_C(149), UINT8_C(107), UINT8_C(154), UINT8_C(182),
                             UINT8_C(253), UINT8_C(223), UINT8_C(174), UINT8_C( 80),
                             UINT8_C(139), UINT8_C( 98), UINT8_C(116), UINT8_C(112),
                             UINT8_C( 72), UINT8_C(167), UINT8_C(159), UINT8_C( 46),
                             UINT8_C(100), UINT8_C( 52), UINT8_C(128), UINT8_C(111),
                             UINT8_C( 50), UINT8_C(137), UINT8_C(156), UINT8_C(136),
                             UINT8_C(171), UINT8_C( 84), UINT8_C( 78), UINT8_C(191),
                             UINT8_C(111), UINT8_C(152), UINT8_C(207), UINT8_C(212)) },
    { simde_x_mm512_set_epu8(UINT8_C(136), UINT8_C( 77), UINT8_C( 92), UINT8_C(127),
                             UINT8_C(250), UINT8_C( 34), UINT8_C(180), UINT8_C(171),
                             UINT8_C( 31), UINT8_C(112), UINT8_C(162), UINT8_C(182),
                             UINT8_C(240), UINT8_C(136), UINT8_C( 96), UINT8_C( 85),
                             UINT8_C( 41), UINT8_C( 52), UINT8_C( 59), UINT8_C(203),
                             UINT8_C(213), UINT8_C(103), UINT8_C(221), UINT8_C(176),
                             UINT8_C( 99), UINT8_C(  2), UINT8_C( 21), UINT8_C(182),
                             UINT8_C(  7), UINT8_C(176), UINT8_C(125), UINT8_C(109),
                             UINT8_C(233), UINT8_C(242), UINT8_C(  5), UINT8_C(109),
                             UINT8_C( 73), UINT8_C(240), UINT8_C(175), UINT8_C( 24),
                             UINT8_C( 44), UINT8_C(103), UINT8_C(204), UINT8_C( 40),
                             UINT8_C( 78), UINT8_C(117), UINT8_C(221), UINT8_C(168),
                             UINT8_C(194), UINT8_C( 10), UINT8_C( 15), UINT8_C(227),
                             UINT8_C( 13), UINT8_C(241), UINT8_C( 93), UINT8_C( 23),
                             UINT8_C( 31), UINT8_C( 84), UINT8_C(219), UINT8_C( 76),
                             UINT8_C( 52), UINT8_C( 31), UINT8_C( 22), UINT8_C(183)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C( 70), UINT8_C(193), UINT8_C(116),
                             UINT8_C(  9), UINT8_C( 85), UINT8_C(190), UINT8_C(154),
                             UINT8_C( 37), UINT8_C(184), UINT8_C(193), UINT8_C(107),
                             UINT8_C( 79), UINT8_C(235), UINT8_C( 33), UINT8_C(125),
                             UINT8_C(111), UINT8_C(108), UINT8_C( 99), UINT8_C(162),
                             UINT8_C(175), UINT8_C(211), UINT8_C( 79), UINT8_C(167),
                             UINT8_C(166), UINT8_C( 89), UINT8_C( 21), UINT8_C(138),
                             UINT8_C( 15), UINT8_C(105), UINT8_C(191), UINT8_C(205),
                             UINT8_C( 34), UINT8_C(122), UINT8_C(209), UINT8_C(143),
                             UINT8_C(216), UINT8_C(162), UINT8_C(239), UINT8_C(190),
                             UINT8_C(212), UINT8_C(246), UINT8_C(251), UINT8_C(206),
                             UINT8_C( 61), UINT8_C( 80), UINT8_C(151), UINT8_C( 93),
                             UINT8_C( 56), UINT8_C(135), UINT8_C(169), UINT8_C(  8),
                             UINT8_C(191), UINT8_C( 66), UINT8_C( 60), UINT8_C( 24),
                             UINT8_C( 93), UINT8_C(156), UINT8_C( 32), UINT8_C( 27),
                             UINT8_C( 48), UINT8_C(210), UINT8_C(231), UINT8_C( 10)),
      simde_x_mm512_set_epu8(UINT8_C( 68), UINT8_C( 74), UINT8_C(143), UINT8_C(122),
                             UINT8_C(130), UINT8_C( 60), UINT8_C(185), UINT8_C(163),
                             UINT8_C( 34), UINT8_C(148), UINT8_C(178), UINT8_C(145),
                             UINT8_C(160), UINT8_C(186), UINT8_C( 65), UINT8_C(105),
                             UINT8_C( 76), UINT8_C( 80), UINT8_C( 79), UINT8_C(183),
                             UINT8_C(194), UINT8_C(157), UINT8_C(150), UINT8_C(172),
                             UINT8_C(133), UINT8_C( 46), UINT8_C( 21), UINT8_C(160),
                             UINT8_C( 11), UINT8_C(141), UINT8_C(158), UINT8_C(157),
                             UINT8_C(134), UINT8_C(182), UINT8_C(107), UINT8_C(126),
                             UINT8_C(145), UINT8_C(201), UINT8_C(207), UINT8_C(107),
                             UINT8_C(128), UINT8_C(175), UINT8_C(228), UINT8_C(123),
                             UINT8_C( 70), UINT8_C( 99), UINT8_C(186), UINT8_C(131),
                             UINT8_C(125), UINT8_C( 73), UINT8_C( 92), UINT8_C(118),
                             UINT8_C(102), UINT8_C(154), UINT8_C( 77), UINT8_C( 24),
                             UINT8_C( 62), UINT8_C(120), UINT8_C(126), UINT8_C( 52),
                             UINT8_C( 50), UINT8_C(121), UINT8_C(127), UINT8_C( 97)) },
    { simde_x_mm512_set_epu8(UINT8_C(234), UINT8_C(192), UINT8_C(234), UINT8_C(237),
                             UINT8_C(  5), UINT8_C(121), UINT8_C(180), UINT8_C( 23),
                             UINT8_C( 48), UINT8_C(184), UINT8_C(208), UINT8_C(106),
                             UINT8_C( 94), UINT8_C(238), UINT8_C(124), UINT8_C( 15),
                             UINT8_C(123), UINT8_C(203), UINT8_C( 16), UINT8_C( 14),
                             UINT8_C(131), UINT8_C(218), UINT8_C( 99), UINT8_C(178),
                             UINT8_C(217), UINT8_C(189), UINT8_C(211), UINT8_C(222),
                             UINT8_C( 27), UINT8_C( 25), UINT8_C( 55), UINT8_C(187),
                             UINT8_C( 24), UINT8_C(250), UINT8_C( 44), UINT8_C(207),
                             UINT8_C(143), UINT8_C(198), UINT8_C(115), UINT8_C(  4),
                             UINT8_C( 18), UINT8_C( 78), UINT8_C( 97), UINT8_C( 62),
                             UINT8_C( 38), UINT8_C(184), UINT8_C(216), UINT8_C(124),
                             UINT8_C(155), UINT8_C( 45), UINT8_C( 66), UINT8_C( 36),
                             UINT8_C(  7), UINT8_C( 22), UINT8_C(106), UINT8_C( 14),
                             UINT8_C( 55), UINT8_C(  9), UINT8_C(104), UINT8_C(136),
                             UINT8_C(167), UINT8_C(129), UINT8_C(  7), UINT8_C( 98)),
      simde_x_mm512_set_epu8(UINT8_C(  4), UINT8_C( 28), UINT8_C(178), UINT8_C(230),
                             UINT8_C(  8), UINT8_C( 80), UINT8_C(138), UINT8_C(121),
                             UINT8_C(141), UINT8_C(178), UINT8_C(150), UINT8_C( 72),
                             UINT8_C(121), UINT8_C( 20), UINT8_C( 28), UINT8_C(243),
                             UINT8_C(255), UINT8_C(153), UINT8_C( 78), UINT8_C(119),
                             UINT8_C( 23), UINT8_C(182), UINT8_C(133), UINT8_C(168),
                             UINT8_C(148), UINT8_C(129), UINT8_C(203), UINT8_C(206),
                             UINT8_C( 25), UINT8_C(232), UINT8_C( 71), UINT8_C( 92),
                             UINT8_C( 90), UINT8_C(159), UINT8_C(196), UINT8_C( 86),
                             UINT8_C(163), UINT8_C(105), UINT8_C(169), UINT8_C(248),
                             UINT8_C(169), UINT8_C( 85), UINT8_C(177), UINT8_C(146),
                             UINT8_C( 77), UINT8_C( 44), UINT8_C(150), UINT8_C( 64),
                             UINT8_C(145), UINT8_C( 33), UINT8_C(163), UINT8_C(255),
                             UINT8_C( 33), UINT8_C( 86), UINT8_C(  3), UINT8_C(162),
                             UINT8_C(241), UINT8_C(203), UINT8_C( 13), UINT8_C( 95),
                             UINT8_C(247), UINT8_C( 54), UINT8_C( 73), UINT8_C(154)),
      simde_x_mm512_set_epu8(UINT8_C(119), UINT8_C(110), UINT8_C(206), UINT8_C(234),
                             UINT8_C(  7), UINT8_C(101), UINT8_C(159), UINT8_C( 72),
                             UINT8_C( 95), UINT8_C(181), UINT8_C(179), UINT8_C( 89),
                             UINT8_C(108), UINT8_C(129), UINT8_C( 76), UINT8_C(129),
                             UINT8_C(189), UINT8_C(178), UINT8_C( 47), UINT8_C( 67),
                             UINT8_C( 77), UINT8_C(200), UINT8_C(116), UINT8_C(173),
                             UINT8_C(183), UINT8_C(159), UINT8_C(207), UINT8_C(214),
                             UINT8_C( 26), UINT8_C(129), UINT8_C( 63), UINT8_C(140),
                             UINT8_C( 57), UINT8_C(205), UINT8_C(120), UINT8_C(147),
                             UINT8_C(153), UINT8_C(152), UINT8_C(142), UINT8_C(126),
                             UINT8_C( 94), UINT8_C( 82), UINT8_C(137), UINT8_C(104),
                             UINT8_C( 58), UINT8_C(114), UINT8_C(183), UINT8_C( 94),
                             UINT8_C(150), UINT8_C( 39), UINT8_C(115), UINT8_C(146),
                             UINT8_C( 20), UINT8_C( 54), UINT8_C( 55), UINT8_C( 88),
                             UINT8_C(148), UINT8_C(106), UINT8_C( 59), UINT8_C(116),
                             UINT8_C(207), UINT8_C( 92), UINT8_C( 40), UINT8_C(126)) },
    { simde_x_mm512_set_epu8(UINT8_C( 83), UINT8_C(142), UINT8_C( 42), UINT8_C(220),
                             UINT8_C( 37), UINT8_C( 62), UINT8_C( 98), UINT8_C(238),
                             UINT8_C(153), UINT8_C( 28), UINT8_C(206), UINT8_C(122),
                             UINT8_C( 85), UINT8_C(118), UINT8_C(175), UINT8_C(149),
                             UINT8_C(220), UINT8_C( 77), UINT8_C( 29), UINT8_C( 65),
                             UINT8_C(199), UINT8_C(150), UINT8_C( 85), UINT8_C(205),
                             UINT8_C(179), UINT8_C(171), UINT8_C( 47), UINT8_C( 79),
                             UINT8_C(186), UINT8_C(189), UINT8_C(  5), UINT8_C( 88),
                             UINT8_C(186), UINT8_C(241), UINT8_C(203), UINT8_C(126),
                             UINT8_C(116), UINT8_C( 53), UINT8_C( 43), UINT8_C(208),
                             UINT8_C(141), UINT8_C(174), UINT8_C(168), UINT8_C( 33),
                             UINT8_C(144), UINT8_C(236), UINT8_C( 92), UINT8_C(185),
                             UINT8_C(194), UINT8_C( 20), UINT8_C(  6), UINT8_C( 82),
                             UINT8_C( 17), UINT8_C(156), UINT8_C(193), UINT8_C(  6),
                             UINT8_C( 65), UINT8_C( 12), UINT8_C( 82), UINT8_C(186),
                             UINT8_C(  9), UINT8_C( 38), UINT8_C(161), UINT8_C(250)),
      simde_x_mm512_set_epu8(UINT8_C(  7), UINT8_C(237), UINT8_C(219), UINT8_C(171),
                             UINT8_C(236), UINT8_C(104), UINT8_C( 84), UINT8_C(  1),
                             UINT8_C(226), UINT8_C( 80), UINT8_C( 28), UINT8_C(225),
                             UINT8_C(190), UINT8_C(201), UINT8_C(130), UINT8_C(143),
                             UINT8_C( 85), UINT8_C(214), UINT8_C(162), UINT8_C(248),
                             UINT8_C(236), UINT8_C(124), UINT8_C(162), UINT8_C(253),
                             UINT8_C(116), UINT8_C(105), UINT8_C(252), UINT8_C(254),
                             UINT8_C( 40), UINT8_C( 36), UINT8_C( 40), UINT8_C(179),
                             UINT8_C(113), UINT8_C(185), UINT8_C( 37), UINT8_C(245),
                             UINT8_C( 41), UINT8_C(  6), UINT8_C(210), UINT8_C( 50),
                             UINT8_C( 82), UINT8_C(223), UINT8_C(202), UINT8_C( 34),
                             UINT8_C(124), UINT8_C( 12), UINT8_C(156), UINT8_C(107),
                             UINT8_C( 75), UINT8_C(221), UINT8_C(108), UINT8_C(193),
                             UINT8_C(  4), UINT8_C(112), UINT8_C(113), UINT8_C(115),
                             UINT8_C(250), UINT8_C( 35), UINT8_C(161), UINT8_C( 10),
                             UINT8_C(151), UINT8_C(213), UINT8_C(128), UINT8_C(  1)),
      simde_x_mm512_set_epu8(UINT8_C( 45), UINT8_C(190), UINT8_C(131), UINT8_C(196),
                             UINT8_C(137), UINT8_C( 83), UINT8_C( 91), UINT8_C(120),
                             UINT8_C(190), UINT8_C( 54), UINT8_C(117), UINT8_C(174),
                             UINT8_C(138), UINT8_C(160), UINT8_C(153), UINT8_C(146),
                             UINT8_C(153), UINT8_C(146), UINT8_C( 96), UINT8_C(157),
                             UINT8_C(218), UINT8_C(137), UINT8_C(124), UINT8_C(229),
                             UINT8_C(148), UINT8_C(138), UINT8_C(150), UINT8_C(167),
                             UINT8_C(113), UINT8_C(113), UINT8_C( 23), UINT8_C(134),
                             UINT8_C(150), UINT8_C(213), UINT8_C(120), UINT8_C(186),
                             UINT8_C( 79), UINT8_C( 30), UINT8_C(127), UINT8_C(129),
                             UINT8_C(112), UINT8_C(199), UINT8_C(185), UINT8_C( 34),
                             UINT8_C(134), UINT8_C(124), UINT8_C(124), UINT8_C(146),
                             UINT8_C(135), UINT8_C(121), UINT8_C( 57), UINT8_C(138),
                             UINT8_C( 11), UINT8_C(134), UINT8_C(153), UINT8_C( 61),
                             UINT8_C(158), UINT8_C( 24), UINT8_C(122), UINT8_C( 98),
                             UINT8_C( 80), UINT8_C(126), UINT8_C(145), UINT8_C(126)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_avg_epu8(test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_u8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_mask_avg_epu8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i src;
    simde__mmask64 k;
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_x_mm512_set_epu8(UINT8_C(117), UINT8_C(152), UINT8_C(221), UINT8_C(216),
                             UINT8_C(255), UINT8_C( 43), UINT8_C( 10), UINT8_C(211),
                             UINT8_C(214), UINT8_C( 80), UINT8_C(187), UINT8_C(241),
                             UINT8_C(242), UINT8_C(134), UINT8_C( 60), UINT8_C( 93),
                             UINT8_C( 23), UINT8_C(122), UINT8_C( 10), UINT8_C(108),
                             UINT8_C(232), UINT8_C(191), UINT8_C(217), UINT8_C(158),
                             UINT8_C(199), UINT8_C(250), UINT8_C( 81), UINT8_C(211),
                             UINT8_C(229), UINT8_C( 28), UINT8_C(171), UINT8_C( 15),
                             UINT8_C(138), UINT8_C( 52), UINT8_C( 10), UINT8_C(140),
                             UINT8_C( 26), UINT8_C(213), UINT8_C(218), UINT8_C(229),
                             UINT8_C( 66), UINT8_C(204), UINT8_C(  5), UINT8_C(255),
                             UINT8_C(228), UINT8_C(  3), UINT8_C(123), UINT8_C(140),
                             UINT8_C(222), UINT8_C(224), UINT8_C( 98), UINT8_C(103),
                             UINT8_C(237), UINT8_C(138), UINT8_C(179), UINT8_C(224),
                             UINT8_C( 60), UINT8_C(176), UINT8_C( 22), UINT8_C(230),
                             UINT8_C( 60), UINT8_C(244), UINT8_C(191), UINT8_C( 88)),
      UINT64_C(          2117573942),
      simde_x_mm512_set_epu8(UINT8_C( 32), UINT8_C( 22), UINT8_C( 88), UINT8_C(222),
                             UINT8_C( 12), UINT8_C( 90), UINT8_C(155), UINT8_C(252),
                             UINT8_C(242), UINT8_C( 42), UINT8_C(169), UINT8_C(105),
                             UINT8_C( 22), UINT8_C( 34), UINT8_C(113), UINT8_C(184),
                             UINT8_C(216), UINT8_C(186), UINT8_C(232), UINT8_C(159),
                             UINT8_C(188), UINT8_C(250), UINT8_C( 98), UINT8_C(132),
                             UINT8_C(221), UINT8_C( 11), UINT8_C(138), UINT8_C(207),
                             UINT8_C(214), UINT8_C( 24), UINT8_C(222), UINT8_C( 73),
                             UINT8_C(253), UINT8_C(184), UINT8_C(153), UINT8_C( 26),
                             UINT8_C(220), UINT8_C(147), UINT8_C( 37), UINT8_C( 50),
                             UINT8_C( 26), UINT8_C( 78), UINT8_C( 33), UINT8_C( 67),
                             UINT8_C(248), UINT8_C(190), UINT8_C( 29), UINT8_C( 31),
                             UINT8_C( 34), UINT8_C( 40), UINT8_C(189), UINT8_C( 86),
                             UINT8_C( 38), UINT8_C(128), UINT8_C(150), UINT8_C(241),
                             UINT8_C(100), UINT8_C( 53), UINT8_C( 42), UINT8_C( 55),
                             UINT8_C( 87), UINT8_C(241), UINT8_C(251), UINT8_C(171)),
      simde_x_mm512_set_epu8(UINT8_C(229), UINT8_C(148), UINT8_C(139), UINT8_C(168),
                             UINT8_C(149), UINT8_C( 53), UINT8_C(240), UINT8_C(255),
                             UINT8_C(164), UINT8_C(137), UINT8_C( 17), UINT8_C(134),
                             UINT8_C( 22), UINT8_C(243), UINT8_C(  7), UINT8_C(130),
                             UINT8_C(232), UINT8_C(205), UINT8_C(227), UINT8_C(142),
                             UINT8_C(100), UINT8_C(203), UINT8_C(  0), UINT8_C(144),
                             UINT8_C(176), UINT8_C( 89), UINT8_C( 91), UINT8_C(  1),
                             UINT8_C(102), UINT8_C(254), UINT8_C(189), UINT8_C(168),
                             UINT8_C(251), UINT8_C(171), UINT8_C( 24), UINT8_C( 13),
                             UINT8_C( 67), UINT8_C( 49), UINT8_C( 20), UINT8_C(185),
                             UINT8_C(232), UINT8_C( 19), UINT8_C(238), UINT8_C( 58),
                             UINT8_C(109), UINT8_C(140), UINT8_C( 95), UINT8_C( 71),
                             UINT8_C( 47), UINT8_C(118), UINT8_C(241), UINT8_C(225),
                             UINT8_C(186), UINT8_C(175), UINT8_C( 45), UINT8_C( 88),
                             UINT8_C(164), UINT8_C( 95), UINT8_C(253), UINT8_C(227),
                             UINT8_C( 20), UINT8_C(170), UINT8_C(251), UINT8_C( 57)),
      simde_x_mm512_set_epu8(UINT8_C(117), UINT8_C(152), UINT8_C(221), UINT8_C(216),
                             UINT8_C(255), UINT8_C( 43), UINT8_C( 10), UINT8_C(211),
                             UINT8_C(214), UINT8_C( 80), UINT8_C(187), UINT8_C(241),
                             UINT8_C(242), UINT8_C(134), UINT8_C( 60), UINT8_C( 93),
                             UINT8_C( 23), UINT8_C(122), UINT8_C( 10), UINT8_C(108),
                             UINT8_C(232), UINT8_C(191), UINT8_C(217), UINT8_C(158),
                             UINT8_C(199), UINT8_C(250), UINT8_C( 81), UINT8_C(211),
                             UINT8_C(229), UINT8_C( 28), UINT8_C(171), UINT8_C( 15),
                             UINT8_C(138), UINT8_C(178), UINT8_C( 89), UINT8_C( 20),
                             UINT8_C(144), UINT8_C( 98), UINT8_C( 29), UINT8_C(229),
                             UINT8_C( 66), UINT8_C(204), UINT8_C(136), UINT8_C( 63),
                             UINT8_C(228), UINT8_C(165), UINT8_C( 62), UINT8_C( 51),
                             UINT8_C( 41), UINT8_C(224), UINT8_C( 98), UINT8_C(156),
                             UINT8_C(112), UINT8_C(152), UINT8_C(179), UINT8_C(165),
                             UINT8_C( 60), UINT8_C(176), UINT8_C(148), UINT8_C(141),
                             UINT8_C( 60), UINT8_C(206), UINT8_C(251), UINT8_C( 88)) },
    { simde_x_mm512_set_epu8(UINT8_C(248), UINT8_C(153), UINT8_C(124), UINT8_C(192),
                             UINT8_C(251), UINT8_C( 73), UINT8_C( 83), UINT8_C(149),
                             UINT8_C(192), UINT8_C(225), UINT8_C( 11), UINT8_C( 45),
                             UINT8_C(242), UINT8_C(146), UINT8_C(100), UINT8_C(250),
                             UINT8_C(206), UINT8_C(133), UINT8_C(162), UINT8_C( 12),
                             UINT8_C(227), UINT8_C(156), UINT8_C( 97), UINT8_C(141),
                             UINT8_C(103), UINT8_C(177), UINT8_C(102), UINT8_C(250),
                             UINT8_C(236), UINT8_C(151), UINT8_C(250), UINT8_C( 69),
                             UINT8_C( 19), UINT8_C(102), UINT8_C(130), UINT8_C(239),
                             UINT8_C( 26), UINT8_C(151), UINT8_C( 91), UINT8_C(218),
                             UINT8_C(106), UINT8_C(  8), UINT8_C( 85), UINT8_C(190),
                             UINT8_C( 40), UINT8_C(207), UINT8_C( 10), UINT8_C( 15),
                             UINT8_C( 30), UINT8_C( 97), UINT8_C(208), UINT8_C( 26),
                             UINT8_C( 77), UINT8_C(104), UINT8_C(138), UINT8_C( 49),
                             UINT8_C(222), UINT8_C(133), UINT8_C( 22), UINT8_C(114),
                             UINT8_C(226), UINT8_C( 75), UINT8_C(  2), UINT8_C(236)),
      UINT64_C(           474091127),
      simde_x_mm512_set_epu8(UINT8_C( 64), UINT8_C( 45), UINT8_C(186), UINT8_C( 94),
                             UINT8_C(127), UINT8_C(186), UINT8_C(127), UINT8_C(178),
                             UINT8_C(198), UINT8_C( 92), UINT8_C(231), UINT8_C(248),
                             UINT8_C( 21), UINT8_C( 89), UINT8_C(  8), UINT8_C(  1),
                             UINT8_C( 85), UINT8_C(  5), UINT8_C(111), UINT8_C(109),
                             UINT8_C(  6), UINT8_C(229), UINT8_C( 18), UINT8_C( 62),
                             UINT8_C(249), UINT8_C(126), UINT8_C(234), UINT8_C(220),
                             UINT8_C(246), UINT8_C(255), UINT8_C(  1), UINT8_C(115),
                             UINT8_C( 87), UINT8_C( 93), UINT8_C(185), UINT8_C(156),
                             UINT8_C(164), UINT8_C(103), UINT8_C(237), UINT8_C(252),
                             UINT8_C(126), UINT8_C(112), UINT8_C(184), UINT8_C( 45),
                             UINT8_C( 61), UINT8_C(246), UINT8_C( 68), UINT8_C(163),
                             UINT8_C(  5), UINT8_C(127), UINT8_C(109), UINT8_C(194),
                             UINT8_C(167), UINT8_C(139), UINT8_C(130), UINT8_C( 52),
                             UINT8_C(248), UINT8_C(164), UINT8_C(233), UINT8_C(208),
                             UINT8_C(104), UINT8_C(136), UINT8_C(254), UINT8_C(148)),
      simde_x_mm512_set_epu8(UINT8_C( 10), UINT8_C(152), UINT8_C(249), UINT8_C(150),
                             UINT8_C(250), UINT8_C(  9), UINT8_C(168), UINT8_C( 52),
                             UINT8_C( 69), UINT8_C( 91), UINT8_C(134), UINT8_C( 83),
                             UINT8_C( 54), UINT8_C(214), UINT8_C(  9), UINT8_C(100),
                             UINT8_C( 84), UINT8_C( 66), UINT8_C( 99), UINT8_C(199),
                             UINT8_C( 20), UINT8_C(200), UINT8_C(215), UINT8_C( 34),
                             UINT8_C( 96), UINT8_C(125), UINT8_C( 40), UINT8_C(246),
                             UINT8_C( 37), UINT8_C(202), UINT8_C(215), UINT8_C(111),
                             UINT8_C(239), UINT8_C( 73), UINT8_C( 10), UINT8_C( 78),
                             UINT8_C(192), UINT8_C( 57), UINT8_C( 95), UINT8_C( 52),
                             UINT8_C(133), UINT8_C(102), UINT8_C(165), UINT8_C(231),
                             UINT8_C(182), UINT8_C( 23), UINT8_C(129), UINT8_C(213),
                             UINT8_C(123), UINT8_C(235), UINT8_C(187), UINT8_C( 72),
                             UINT8_C(170), UINT8_C( 39), UINT8_C(204), UINT8_C( 88),
                             UINT8_C( 48), UINT8_C( 73), UINT8_C(134), UINT8_C( 45),
                             UINT8_C(127), UINT8_C( 12), UINT8_C( 19), UINT8_C(132)),
      simde_x_mm512_set_epu8(UINT8_C(248), UINT8_C(153), UINT8_C(124), UINT8_C(192),
                             UINT8_C(251), UINT8_C( 73), UINT8_C( 83), UINT8_C(149),
                             UINT8_C(192), UINT8_C(225), UINT8_C( 11), UINT8_C( 45),
                             UINT8_C(242), UINT8_C(146), UINT8_C(100), UINT8_C(250),
                             UINT8_C(206), UINT8_C(133), UINT8_C(162), UINT8_C( 12),
                             UINT8_C(227), UINT8_C(156), UINT8_C( 97), UINT8_C(141),
                             UINT8_C(103), UINT8_C(177), UINT8_C(102), UINT8_C(250),
                             UINT8_C(236), UINT8_C(151), UINT8_C(250), UINT8_C( 69),
                             UINT8_C( 19), UINT8_C(102), UINT8_C(130), UINT8_C(117),
                             UINT8_C(178), UINT8_C( 80), UINT8_C( 91), UINT8_C(218),
                             UINT8_C(106), UINT8_C(107), UINT8_C( 85), UINT8_C(190),
                             UINT8_C( 40), UINT8_C(207), UINT8_C( 99), UINT8_C( 15),
                             UINT8_C( 30), UINT8_C( 97), UINT8_C(208), UINT8_C( 26),
                             UINT8_C(169), UINT8_C( 89), UINT8_C(167), UINT8_C( 49),
                             UINT8_C(222), UINT8_C(119), UINT8_C(184), UINT8_C(127),
                             UINT8_C(226), UINT8_C( 74), UINT8_C(137), UINT8_C(140)) },
    { simde_x_mm512_set_epu8(UINT8_C(221), UINT8_C(100), UINT8_C(182), UINT8_C(149),
                             UINT8_C( 44), UINT8_C(198), UINT8_C( 20), UINT8_C( 23),
                             UINT8_C(105), UINT8_C(188), UINT8_C(118), UINT8_C(243),
                             UINT8_C(175), UINT8_C( 41), UINT8_C(183), UINT8_C(141),
                             UINT8_C(145), UINT8_C( 21), UINT8_C( 99), UINT8_C(117),
                             UINT8_C(242), UINT8_C(144), UINT8_C( 71), UINT8_C( 21),
                             UINT8_C(142), UINT8_C(181), UINT8_C( 66), UINT8_C(137),
                             UINT8_C(194), UINT8_C(226), UINT8_C( 86), UINT8_C(128),
                             UINT8_C(109), UINT8_C( 15), UINT8_C(187), UINT8_C( 22),
                             UINT8_C(243), UINT8_C( 38), UINT8_C(163), UINT8_C(215),
                             UINT8_C( 96), UINT8_C( 79), UINT8_C(232), UINT8_C(216),
                             UINT8_C( 90), UINT8_C( 31), UINT8_C(221), UINT8_C( 22),
                             UINT8_C(144), UINT8_C(219), UINT8_C( 29), UINT8_C( 29),
                             UINT8_C(  7), UINT8_C(  8), UINT8_C(106), UINT8_C(210),
                             UINT8_C( 85), UINT8_C(118), UINT8_C(120), UINT8_C(208),
                             UINT8_C(112), UINT8_C( 80), UINT8_C(173), UINT8_C( 55)),
      UINT64_C(            66155005),
      simde_x_mm512_set_epu8(UINT8_C( 90), UINT8_C(190), UINT8_C(204), UINT8_C( 44),
                             UINT8_C(145), UINT8_C( 10), UINT8_C(145), UINT8_C( 20),
                             UINT8_C(245), UINT8_C(128), UINT8_C(239), UINT8_C(216),
                             UINT8_C(215), UINT8_C(  0), UINT8_C(241), UINT8_C(105),
                             UINT8_C( 81), UINT8_C(  3), UINT8_C( 23), UINT8_C(107),
                             UINT8_C(238), UINT8_C( 80), UINT8_C(150), UINT8_C( 52),
                             UINT8_C( 80), UINT8_C(120), UINT8_C( 83), UINT8_C(139),
                             UINT8_C( 84), UINT8_C(178), UINT8_C( 47), UINT8_C(223),
                             UINT8_C(103), UINT8_C( 66), UINT8_C( 79), UINT8_C( 53),
                             UINT8_C(211), UINT8_C( 20), UINT8_C(111), UINT8_C(197),
                             UINT8_C(238), UINT8_C( 30), UINT8_C( 70), UINT8_C(231),
                             UINT8_C(199), UINT8_C( 18), UINT8_C(252), UINT8_C(101),
                             UINT8_C( 75), UINT8_C( 12), UINT8_C( 85), UINT8_C( 93),
                             UINT8_C(177), UINT8_C(243), UINT8_C( 43), UINT8_C( 45),
                             UINT8_C( 40), UINT8_C(175), UINT8_C( 99), UINT8_C(172),
                             UINT8_C(  7), UINT8_C(156), UINT8_C(188), UINT8_C(130)),
      simde_x_mm512_set_epu8(UINT8_C( 42), UINT8_C( 32), UINT8_C(165), UINT8_C(130),
                             UINT8_C(119), UINT8_C( 88), UINT8_C(110), UINT8_C( 93),
                             UINT8_C( 75), UINT8_C(207), UINT8_C(193), UINT8_C(214),
                             UINT8_C( 54), UINT8_C(185), UINT8_C( 87), UINT8_C(255),
                             UINT8_C(231), UINT8_C(196), UINT8_C(102), UINT8_C(158),
                             UINT8_C(161), UINT8_C(222), UINT8_C(210), UINT8_C( 94),
                             UINT8_C(118), UINT8_C(127), UINT8_C(194), UINT8_C(186),
                             UINT8_C( 80), UINT8_C(125), UINT8_C(244), UINT8_C( 33),
                             UINT8_C(110), UINT8_C(247), UINT8_C(227), UINT8_C(141),
                             UINT8_C(139), UINT8_C( 52), UINT8_C(130), UINT8_C(241),
                             UINT8_C(138), UINT8_C(133), UINT8_C(240), UINT8_C( 72),
                             UINT8_C( 84), UINT8_C( 54), UINT8_C( 76), UINT8_C(208),
                             UINT8_C(177), UINT8_C(100), UINT8_C(198), UINT8_C( 30),
                             UINT8_C( 35), UINT8_C( 68), UINT8_C(216), UINT8_C(  8),
                             UINT8_C( 68), UINT8_C(120), UINT8_C(187), UINT8_C(206),
                             UINT8_C(102), UINT8_C(133), UINT8_C( 95), UINT8_C(110)),
      simde_x_mm512_set_epu8(UINT8_C(221), UINT8_C(100), UINT8_C(182), UINT8_C(149),
                             UINT8_C( 44), UINT8_C(198), UINT8_C( 20), UINT8_C( 23),
                             UINT8_C(105), UINT8_C(188), UINT8_C(118), UINT8_C(243),
                             UINT8_C(175), UINT8_C( 41), UINT8_C(183), UINT8_C(141),
                             UINT8_C(145), UINT8_C( 21), UINT8_C( 99), UINT8_C(117),
                             UINT8_C(242), UINT8_C(144), UINT8_C( 71), UINT8_C( 21),
                             UINT8_C(142), UINT8_C(181), UINT8_C( 66), UINT8_C(137),
                             UINT8_C(194), UINT8_C(226), UINT8_C( 86), UINT8_C(128),
                             UINT8_C(109), UINT8_C( 15), UINT8_C(187), UINT8_C( 22),
                             UINT8_C(243), UINT8_C( 38), UINT8_C(121), UINT8_C(219),
                             UINT8_C(188), UINT8_C( 82), UINT8_C(155), UINT8_C(152),
                             UINT8_C( 90), UINT8_C( 31), UINT8_C(221), UINT8_C(155),
                             UINT8_C(144), UINT8_C( 56), UINT8_C(142), UINT8_C( 62),
                             UINT8_C(  7), UINT8_C(  8), UINT8_C(106), UINT8_C( 27),
                             UINT8_C( 54), UINT8_C(148), UINT8_C(143), UINT8_C(189),
                             UINT8_C( 55), UINT8_C(145), UINT8_C(173), UINT8_C(120)) },
    { simde_x_mm512_set_epu8(UINT8_C(197), UINT8_C(175), UINT8_C(198), UINT8_C( 71),
                             UINT8_C(137), UINT8_C(191), UINT8_C(178), UINT8_C(155),
                             UINT8_C(242), UINT8_C(  4), UINT8_C(232), UINT8_C(161),
                             UINT8_C(106), UINT8_C( 31), UINT8_C(104), UINT8_C( 20),
                             UINT8_C( 65), UINT8_C(248), UINT8_C(181), UINT8_C(128),
                             UINT8_C(175), UINT8_C( 68), UINT8_C(170), UINT8_C( 98),
                             UINT8_C(201), UINT8_C( 10), UINT8_C( 75), UINT8_C( 51),
                             UINT8_C(199), UINT8_C(145), UINT8_C( 87), UINT8_C( 47),
                             UINT8_C(235), UINT8_C(105), UINT8_C( 17), UINT8_C(107),
                             UINT8_C(137), UINT8_C(238), UINT8_C(133), UINT8_C( 81),
                             UINT8_C( 54), UINT8_C(134), UINT8_C(173), UINT8_C( 81),
                             UINT8_C( 21), UINT8_C( 13), UINT8_C(  6), UINT8_C(200),
                             UINT8_C(140), UINT8_C(177), UINT8_C(141), UINT8_C( 81),
                             UINT8_C( 31), UINT8_C( 29), UINT8_C(140), UINT8_C(138),
                             UINT8_C(175), UINT8_C( 98), UINT8_C( 23), UINT8_C(148),
                             UINT8_C(130), UINT8_C( 95), UINT8_C(212), UINT8_C(200)),
      UINT64_C(           518008675),
      simde_x_mm512_set_epu8(UINT8_C(155), UINT8_C(133), UINT8_C( 64), UINT8_C(186),
                             UINT8_C(210), UINT8_C(255), UINT8_C( 70), UINT8_C(210),
                             UINT8_C( 96), UINT8_C( 45), UINT8_C( 57), UINT8_C(248),
                             UINT8_C( 23), UINT8_C( 34), UINT8_C(240), UINT8_C(208),
                             UINT8_C( 74), UINT8_C( 85), UINT8_C(150), UINT8_C( 98),
                             UINT8_C( 81), UINT8_C(149), UINT8_C(213), UINT8_C( 64),
                             UINT8_C(146), UINT8_C(124), UINT8_C(134), UINT8_C(133),
                             UINT8_C( 20), UINT8_C(122), UINT8_C( 57), UINT8_C(241),
                             UINT8_C( 58), UINT8_C( 90), UINT8_C(153), UINT8_C( 57),
                             UINT8_C( 51), UINT8_C(138), UINT8_C( 37), UINT8_C(177),
                             UINT8_C( 13), UINT8_C(116), UINT8_C(177), UINT8_C(238),
                             UINT8_C(169), UINT8_C(177), UINT8_C(173), UINT8_C(231),
                             UINT8_C(226), UINT8_C(216), UINT8_C(126), UINT8_C( 80),
                             UINT8_C(182), UINT8_C( 71), UINT8_C(188), UINT8_C( 53),
                             UINT8_C(255), UINT8_C(200), UINT8_C(176), UINT8_C( 17),
                             UINT8_C(127), UINT8_C( 83), UINT8_C(247), UINT8_C(  0)),
      simde_x_mm512_set_epu8(UINT8_C(226), UINT8_C(  1), UINT8_C(238), UINT8_C(252),
                             UINT8_C( 39), UINT8_C( 85), UINT8_C( 69), UINT8_C( 68),
                             UINT8_C(143), UINT8_C(218), UINT8_C( 28), UINT8_C( 83),
                             UINT8_C(225), UINT8_C( 61), UINT8_C( 37), UINT8_C( 67),
                             UINT8_C( 46), UINT8_C(213), UINT8_C( 32), UINT8_C(183),
                             UINT8_C(230), UINT8_C(  2), UINT8_C(250), UINT8_C(122),
                             UINT8_C(205), UINT8_C(118), UINT8_C(  3), UINT8_C( 17),
                             UINT8_C( 32), UINT8_C( 82), UINT8_C( 40), UINT8_C(  0),
                             UINT8_C( 28), UINT8_C( 37), UINT8_C(253), UINT8_C(171),
                             UINT8_C(164), UINT8_C( 45), UINT8_C(233), UINT8_C(198),
                             UINT8_C(148), UINT8_C( 44), UINT8_C( 28), UINT8_C( 77),
                             UINT8_C( 12), UINT8_C( 81), UINT8_C(153), UINT8_C(  7),
                             UINT8_C(234), UINT8_C( 32), UINT8_C(228), UINT8_C(142),
                             UINT8_C(168), UINT8_C( 42), UINT8_C( 92), UINT8_C( 70),
                             UINT8_C(144), UINT8_C(203), UINT8_C(149), UINT8_C( 41),
                             UINT8_C(206), UINT8_C(198), UINT8_C( 56), UINT8_C( 54)),
      simde_x_mm512_set_epu8(UINT8_C(197), UINT8_C(175), UINT8_C(198), UINT8_C( 71),
                             UINT8_C(137), UINT8_C(191), UINT8_C(178), UINT8_C(155),
                             UINT8_C(242), UINT8_C(  4), UINT8_C(232), UINT8_C(161),
                             UINT8_C(106), UINT8_C( 31), UINT8_C(104), UINT8_C( 20),
                             UINT8_C( 65), UINT8_C(248), UINT8_C(181), UINT8_C(128),
                             UINT8_C(175), UINT8_C( 68), UINT8_C(170), UINT8_C( 98),
                             UINT8_C(201), UINT8_C( 10), UINT8_C( 75), UINT8_C( 51),
                             UINT8_C(199), UINT8_C(145), UINT8_C( 87), UINT8_C( 47),
                             UINT8_C(235), UINT8_C(105), UINT8_C( 17), UINT8_C(114),
                             UINT8_C(108), UINT8_C( 92), UINT8_C(135), UINT8_C( 81),
                             UINT8_C( 81), UINT8_C( 80), UINT8_C(103), UINT8_C( 81),
                             UINT8_C( 21), UINT8_C( 13), UINT8_C(  6), UINT8_C(200),
                             UINT8_C(140), UINT8_C(177), UINT8_C(177), UINT8_C( 81),
                             UINT8_C(175), UINT8_C( 57), UINT8_C(140), UINT8_C( 62),
                             UINT8_C(175), UINT8_C(202), UINT8_C(163), UINT8_C(148),
                             UINT8_C(130), UINT8_C( 95), UINT8_C(152), UINT8_C( 27)) },
    { simde_x_mm512_set_epu8(UINT8_C(121), UINT8_C(  9), UINT8_C(193), UINT8_C(106),
                             UINT8_C( 93), UINT8_C( 44), UINT8_C(  0), UINT8_C(223),
                             UINT8_C(203), UINT8_C(101), UINT8_C( 76), UINT8_C( 37),
                             UINT8_C( 94), UINT8_C(224), UINT8_C(152), UINT8_C(236),
                             UINT8_C(208), UINT8_C( 45), UINT8_C( 88), UINT8_C(163),
                             UINT8_C(104), UINT8_C( 42), UINT8_C(157), UINT8_C( 59),
                             UINT8_C( 90), UINT8_C(187), UINT8_C(107), UINT8_C( 16),
                             UINT8_C(138), UINT8_C(137), UINT8_C(196), UINT8_C( 51),
                             UINT8_C(126), UINT8_C(178), UINT8_C(114), UINT8_C(181),
                             UINT8_C(181), UINT8_C( 19), UINT8_C(113), UINT8_C( 84),
                             UINT8_C( 47), UINT8_C(173), UINT8_C(230), UINT8_C(218),
                             UINT8_C( 64), UINT8_C(150), UINT8_C(107), UINT8_C( 56),
                             UINT8_C(130), UINT8_C(248), UINT8_C( 35), UINT8_C(112),
                             UINT8_C(178), UINT8_C( 75), UINT8_C(231), UINT8_C(  1),
                             UINT8_C(229), UINT8_C(189), UINT8_C( 49), UINT8_C( 75),
                             UINT8_C(217), UINT8_C(188), UINT8_C(205), UINT8_C( 42)),
      UINT64_C(          4020943947),
      simde_x_mm512_set_epu8(UINT8_C(244), UINT8_C(209), UINT8_C(117), UINT8_C( 40),
                             UINT8_C( 42), UINT8_C( 16), UINT8_C(230), UINT8_C(122),
                             UINT8_C(122), UINT8_C(219), UINT8_C(158), UINT8_C(236),
                             UINT8_C( 86), UINT8_C(169), UINT8_C(166), UINT8_C(144),
                             UINT8_C(141), UINT8_C( 79), UINT8_C(123), UINT8_C( 33),
                             UINT8_C(201), UINT8_C(131), UINT8_C(102), UINT8_C( 59),
                             UINT8_C(199), UINT8_C( 19), UINT8_C(252), UINT8_C(201),
                             UINT8_C(170), UINT8_C( 88), UINT8_C(209), UINT8_C( 29),
                             UINT8_C(140), UINT8_C(198), UINT8_C(115), UINT8_C(193),
                             UINT8_C(241), UINT8_C(202), UINT8_C( 84), UINT8_C(255),
                             UINT8_C(  5), UINT8_C(223), UINT8_C(160), UINT8_C( 93),
                             UINT8_C( 97), UINT8_C(124), UINT8_C( 26), UINT8_C(222),
                             UINT8_C(175), UINT8_C(168), UINT8_C( 26), UINT8_C(155),
                             UINT8_C(117), UINT8_C(221), UINT8_C(174), UINT8_C( 92),
                             UINT8_C(115), UINT8_C(243), UINT8_C(104), UINT8_C( 83),
                             UINT8_C( 80), UINT8_C(138), UINT8_C( 34), UINT8_C( 48)),
      simde_x_mm512_set_epu8(UINT8_C(168), UINT8_C(187), UINT8_C(118), UINT8_C( 36),
                             UINT8_C(110), UINT8_C( 81), UINT8_C(219), UINT8_C( 36),
                             UINT8_C(182), UINT8_C(147), UINT8_C( 47), UINT8_C( 12),
                             UINT8_C(227), UINT8_C(175), UINT8_C( 76), UINT8_C(234),
                             UINT8_C( 91), UINT8_C(125), UINT8_C( 98), UINT8_C( 17),
                             UINT8_C(115), UINT8_C( 58), UINT8_C(149), UINT8_C( 90),
                             UINT8_C(115), UINT8_C(232), UINT8_C( 83), UINT8_C( 17),
                             UINT8_C(245), UINT8_C( 20), UINT8_C( 81), UINT8_C( 54),
                             UINT8_C(197), UINT8_C(112), UINT8_C(154), UINT8_C( 13),
                             UINT8_C(  8), UINT8_C(151), UINT8_C(229), UINT8_C(129),
                             UINT8_C(144), UINT8_C(125), UINT8_C( 21), UINT8_C( 55),
                             UINT8_C( 24), UINT8_C( 58), UINT8_C(  7), UINT8_C(127),
                             UINT8_C(150), UINT8_C(222), UINT8_C(105), UINT8_C(207),
                             UINT8_C(223), UINT8_C(121), UINT8_C(  0), UINT8_C(127),
                             UINT8_C(191), UINT8_C(166), UINT8_C(133), UINT8_C(112),
                             UINT8_C(199), UINT8_C( 77), UINT8_C( 42), UINT8_C( 34)),
      simde_x_mm512_set_epu8(UINT8_C(121), UINT8_C(  9), UINT8_C(193), UINT8_C(106),
                             UINT8_C( 93), UINT8_C( 44), UINT8_C(  0), UINT8_C(223),
                             UINT8_C(203), UINT8_C(101), UINT8_C( 76), UINT8_C( 37),
                             UINT8_C( 94), UINT8_C(224), UINT8_C(152), UINT8_C(236),
                             UINT8_C(208), UINT8_C( 45), UINT8_C( 88), UINT8_C(163),
                             UINT8_C(104), UINT8_C( 42), UINT8_C(157), UINT8_C( 59),
                             UINT8_C( 90), UINT8_C(187), UINT8_C(107), UINT8_C( 16),
                             UINT8_C(138), UINT8_C(137), UINT8_C(196), UINT8_C( 51),
                             UINT8_C(169), UINT8_C(155), UINT8_C(135), UINT8_C(181),
                             UINT8_C(125), UINT8_C(177), UINT8_C(157), UINT8_C(192),
                             UINT8_C( 75), UINT8_C(173), UINT8_C( 91), UINT8_C(218),
                             UINT8_C( 61), UINT8_C(150), UINT8_C( 17), UINT8_C( 56),
                             UINT8_C(163), UINT8_C(248), UINT8_C( 66), UINT8_C(181),
                             UINT8_C(170), UINT8_C(171), UINT8_C(231), UINT8_C(  1),
                             UINT8_C(229), UINT8_C(205), UINT8_C( 49), UINT8_C( 75),
                             UINT8_C(140), UINT8_C(188), UINT8_C( 38), UINT8_C( 41)) },
    { simde_x_mm512_set_epu8(UINT8_C( 84), UINT8_C(222), UINT8_C( 36), UINT8_C(132),
                             UINT8_C( 32), UINT8_C(182), UINT8_C( 73), UINT8_C(182),
                             UINT8_C( 77), UINT8_C(116), UINT8_C( 50), UINT8_C( 82),
                             UINT8_C( 68), UINT8_C( 72), UINT8_C( 23), UINT8_C( 32),
                             UINT8_C(202), UINT8_C( 82), UINT8_C( 53), UINT8_C( 71),
                             UINT8_C( 22), UINT8_C( 92), UINT8_C( 42), UINT8_C(133),
                             UINT8_C(215), UINT8_C( 34), UINT8_C( 75), UINT8_C( 63),
                             UINT8_C(139), UINT8_C( 23), UINT8_C(141), UINT8_C( 66),
                             UINT8_C(166), UINT8_C( 99), UINT8_C(183), UINT8_C(237),
                             UINT8_C(213), UINT8_C(192), UINT8_C(235), UINT8_C( 20),
                             UINT8_C(108), UINT8_C(253), UINT8_C(147), UINT8_C(214),
                             UINT8_C( 44), UINT8_C(210), UINT8_C( 20), UINT8_C( 90),
                             UINT8_C(  2), UINT8_C(252), UINT8_C(108), UINT8_C( 27),
                             UINT8_C(207), UINT8_C( 69), UINT8_C(172), UINT8_C( 82),
                             UINT8_C(  9), UINT8_C(  0), UINT8_C( 42), UINT8_C(118),
                             UINT8_C(253), UINT8_C(189), UINT8_C(  6), UINT8_C( 30)),
      UINT64_C(           589511266),
      simde_x_mm512_set_epu8(UINT8_C(159), UINT8_C(199), UINT8_C( 92), UINT8_C(122),
                             UINT8_C( 12), UINT8_C(  6), UINT8_C( 73), UINT8_C(222),
                             UINT8_C( 93), UINT8_C(236), UINT8_C(196), UINT8_C(151),
                             UINT8_C( 37), UINT8_C(206), UINT8_C(135), UINT8_C(234),
                             UINT8_C(134), UINT8_C( 99), UINT8_C(198), UINT8_C( 81),
                             UINT8_C( 12), UINT8_C(102), UINT8_C(195), UINT8_C(222),
                             UINT8_C( 31), UINT8_C( 64), UINT8_C( 80), UINT8_C( 65),
                             UINT8_C(110), UINT8_C(185), UINT8_C(  8), UINT8_C( 98),
                             UINT8_C(113), UINT8_C( 81), UINT8_C(193), UINT8_C(220),
                             UINT8_C(195), UINT8_C(204), UINT8_C(  7), UINT8_C(184),
                             UINT8_C(203), UINT8_C(  3), UINT8_C(246), UINT8_C(115),
                             UINT8_C(106), UINT8_C(122), UINT8_C( 85), UINT8_C(105),
                             UINT8_C( 90), UINT8_C( 75), UINT8_C(186), UINT8_C( 89),
                             UINT8_C( 25), UINT8_C(170), UINT8_C(216), UINT8_C(247),
                             UINT8_C(137), UINT8_C(237), UINT8_C(110), UINT8_C(230),
                             UINT8_C(130), UINT8_C(124), UINT8_C(  6), UINT8_C(245)),
      simde_x_mm512_set_epu8(UINT8_C( 79), UINT8_C( 23), UINT8_C(207), UINT8_C( 80),
                             UINT8_C(207), UINT8_C( 81), UINT8_C(  7), UINT8_C(130),
                             UINT8_C(181), UINT8_C(246), UINT8_C(189), UINT8_C(163),
                             UINT8_C(120), UINT8_C( 35), UINT8_C(200), UINT8_C(  3),
                             UINT8_C( 24), UINT8_C(158), UINT8_C(243), UINT8_C(  3),
                             UINT8_C(150), UINT8_C(228), UINT8_C(184), UINT8_C(101),
                             UINT8_C(219), UINT8_C(121), UINT8_C( 65), UINT8_C( 30),
                             UINT8_C(249), UINT8_C( 33), UINT8_C(115), UINT8_C(122),
                             UINT8_C(244), UINT8_C(143), UINT8_C(149), UINT8_C( 29),
                             UINT8_C(178), UINT8_C(131), UINT8_C(101), UINT8_C(120),
                             UINT8_C( 82), UINT8_C(219), UINT8_C(186), UINT8_C(193),
                             UINT8_C(234), UINT8_C(139), UINT8_C( 28), UINT8_C( 91),
                             UINT8_C(105), UINT8_C(250), UINT8_C(223), UINT8_C(189),
                             UINT8_C(224), UINT8_C(245), UINT8_C(188), UINT8_C( 51),
                             UINT8_C( 24), UINT8_C( 89), UINT8_C( 22), UINT8_C( 52),
                             UINT8_C(174), UINT8_C(224), UINT8_C( 67), UINT8_C(156)),
      simde_x_mm512_set_epu8(UINT8_C( 84), UINT8_C(222), UINT8_C( 36), UINT8_C(132),
                             UINT8_C( 32), UINT8_C(182), UINT8_C( 73), UINT8_C(182),
                             UINT8_C( 77), UINT8_C(116), UINT8_C( 50), UINT8_C( 82),
                             UINT8_C( 68), UINT8_C( 72), UINT8_C( 23), UINT8_C( 32),
                             UINT8_C(202), UINT8_C( 82), UINT8_C( 53), UINT8_C( 71),
                             UINT8_C( 22), UINT8_C( 92), UINT8_C( 42), UINT8_C(133),
                             UINT8_C(215), UINT8_C( 34), UINT8_C( 75), UINT8_C( 63),
                             UINT8_C(139), UINT8_C( 23), UINT8_C(141), UINT8_C( 66),
                             UINT8_C(166), UINT8_C( 99), UINT8_C(171), UINT8_C(237),
                             UINT8_C(213), UINT8_C(192), UINT8_C( 54), UINT8_C(152),
                             UINT8_C(108), UINT8_C(253), UINT8_C(216), UINT8_C(214),
                             UINT8_C( 44), UINT8_C(210), UINT8_C( 57), UINT8_C( 98),
                             UINT8_C(  2), UINT8_C(252), UINT8_C(205), UINT8_C(139),
                             UINT8_C(125), UINT8_C( 69), UINT8_C(202), UINT8_C( 82),
                             UINT8_C(  9), UINT8_C(163), UINT8_C( 66), UINT8_C(118),
                             UINT8_C(253), UINT8_C(189), UINT8_C( 37), UINT8_C( 30)) },
    { simde_x_mm512_set_epu8(UINT8_C(122), UINT8_C( 31), UINT8_C(165), UINT8_C(180),
                             UINT8_C(160), UINT8_C(238), UINT8_C( 21), UINT8_C( 93),
                             UINT8_C(118), UINT8_C( 87), UINT8_C(251), UINT8_C( 43),
                             UINT8_C(165), UINT8_C(232), UINT8_C(151), UINT8_C(210),
                             UINT8_C(191), UINT8_C( 60), UINT8_C(141), UINT8_C(172),
                             UINT8_C(143), UINT8_C(152), UINT8_C( 64), UINT8_C(105),
                             UINT8_C( 15), UINT8_C(129), UINT8_C(227), UINT8_C( 58),
                             UINT8_C( 92), UINT8_C(145), UINT8_C( 98), UINT8_C(228),
                             UINT8_C(166), UINT8_C( 72), UINT8_C(150), UINT8_C( 59),
                             UINT8_C( 16), UINT8_C(  1), UINT8_C(194), UINT8_C( 73),
                             UINT8_C(230), UINT8_C(150), UINT8_C(242), UINT8_C( 38),
                             UINT8_C(140), UINT8_C(234), UINT8_C( 77), UINT8_C( 54),
                             UINT8_C(  3), UINT8_C(126), UINT8_C(200), UINT8_C(132),
                             UINT8_C(171), UINT8_C(245), UINT8_C(169), UINT8_C(148),
                             UINT8_C(166), UINT8_C(  7), UINT8_C(  6), UINT8_C(227),
                             UINT8_C( 91), UINT8_C(103), UINT8_C( 93), UINT8_C(244)),
      UINT64_C(          1742408254),
      simde_x_mm512_set_epu8(UINT8_C(195), UINT8_C(222), UINT8_C( 29), UINT8_C(255),
                             UINT8_C(195), UINT8_C(117), UINT8_C(247), UINT8_C(187),
                             UINT8_C( 69), UINT8_C(188), UINT8_C(174), UINT8_C(241),
                             UINT8_C(175), UINT8_C(167), UINT8_C(226), UINT8_C( 66),
                             UINT8_C(177), UINT8_C(104), UINT8_C(172), UINT8_C(245),
                             UINT8_C( 53), UINT8_C( 17), UINT8_C( 64), UINT8_C( 70),
                             UINT8_C(209), UINT8_C(113), UINT8_C( 86), UINT8_C(118),
                             UINT8_C( 56), UINT8_C( 92), UINT8_C(177), UINT8_C(185),
                             UINT8_C(205), UINT8_C(241), UINT8_C(149), UINT8_C(204),
                             UINT8_C(155), UINT8_C( 35), UINT8_C(114), UINT8_C( 12),
                             UINT8_C(212), UINT8_C( 63), UINT8_C( 66), UINT8_C( 74),
                             UINT8_C( 97), UINT8_C(253), UINT8_C(218), UINT8_C( 22),
                             UINT8_C( 38), UINT8_C( 68), UINT8_C(247), UINT8_C(250),
                             UINT8_C(215), UINT8_C( 66), UINT8_C( 67), UINT8_C( 91),
                             UINT8_C(177), UINT8_C(159), UINT8_C(198), UINT8_C(145),
                             UINT8_C(183), UINT8_C( 26), UINT8_C( 66), UINT8_C(165)),
      simde_x_mm512_set_epu8(UINT8_C(104), UINT8_C(148), UINT8_C(187), UINT8_C(240),
                             UINT8_C(224), UINT8_C(131), UINT8_C(  1), UINT8_C(106),
                             UINT8_C( 77), UINT8_C(151), UINT8_C(127), UINT8_C(197),
                             UINT8_C(118), UINT8_C( 35), UINT8_C( 55), UINT8_C(144),
                             UINT8_C( 54), UINT8_C(201), UINT8_C( 41), UINT8_C(221),
                             UINT8_C(189), UINT8_C( 99), UINT8_C(112), UINT8_C(181),
                             UINT8_C( 52), UINT8_C(200), UINT8_C(153), UINT8_C(231),
                             UINT8_C(146), UINT8_C(105), UINT8_C(102), UINT8_C(227),
                             UINT8_C(214), UINT8_C(182), UINT8_C( 31), UINT8_C( 41),
                             UINT8_C( 93), UINT8_C(234), UINT8_C( 82), UINT8_C( 71),
                             UINT8_C( 52), UINT8_C(241), UINT8_C(224), UINT8_C( 69),
                             UINT8_C( 73), UINT8_C( 93), UINT8_C(195), UINT8_C( 84),
                             UINT8_C(170), UINT8_C(173), UINT8_C(170), UINT8_C( 88),
                             UINT8_C( 60), UINT8_C(109), UINT8_C( 86), UINT8_C(119),
                             UINT8_C(141), UINT8_C(206), UINT8_C( 51), UINT8_C(  6),
                             UINT8_C( 71), UINT8_C(253), UINT8_C( 22), UINT8_C( 92)),
      simde_x_mm512_set_epu8(UINT8_C(122), UINT8_C( 31), UINT8_C(165), UINT8_C(180),
                             UINT8_C(160), UINT8_C(238), UINT8_C( 21), UINT8_C( 93),
                             UINT8_C(118), UINT8_C( 87), UINT8_C(251), UINT8_C( 43),
                             UINT8_C(165), UINT8_C(232), UINT8_C(151), UINT8_C(210),
                             UINT8_C(191), UINT8_C( 60), UINT8_C(141), UINT8_C(172),
                             UINT8_C(143), UINT8_C(152), UINT8_C( 64), UINT8_C(105),
                             UINT8_C( 15), UINT8_C(129), UINT8_C(227), UINT8_C( 58),
                             UINT8_C( 92), UINT8_C(145), UINT8_C( 98), UINT8_C(228),
                             UINT8_C(166), UINT8_C(212), UINT8_C( 90), UINT8_C( 59),
                             UINT8_C( 16), UINT8_C(135), UINT8_C( 98), UINT8_C( 42),
                             UINT8_C(132), UINT8_C(152), UINT8_C(242), UINT8_C( 72),
                             UINT8_C( 85), UINT8_C(234), UINT8_C(207), UINT8_C( 53),
                             UINT8_C(  3), UINT8_C(126), UINT8_C(200), UINT8_C(132),
                             UINT8_C(138), UINT8_C(245), UINT8_C( 77), UINT8_C(148),
                             UINT8_C(166), UINT8_C(  7), UINT8_C(125), UINT8_C( 76),
                             UINT8_C(127), UINT8_C(140), UINT8_C( 44), UINT8_C(244)) },
    { simde_x_mm512_set_epu8(UINT8_C(204), UINT8_C( 72), UINT8_C(160), UINT8_C( 51),
                             UINT8_C( 17), UINT8_C( 91), UINT8_C( 99), UINT8_C(232),
                             UINT8_C(230), UINT8_C( 75), UINT8_C( 98), UINT8_C(249),
                             UINT8_C(240), UINT8_C(193), UINT8_C( 40), UINT8_C(144),
                             UINT8_C( 13), UINT8_C(232), UINT8_C(120), UINT8_C( 62),
                             UINT8_C(136), UINT8_C(  7), UINT8_C(252), UINT8_C(  3),
                             UINT8_C(225), UINT8_C( 43), UINT8_C(176), UINT8_C(138),
                             UINT8_C(205), UINT8_C( 22), UINT8_C(172), UINT8_C( 52),
                             UINT8_C(224), UINT8_C(163), UINT8_C( 92), UINT8_C(198),
                             UINT8_C(193), UINT8_C( 77), UINT8_C(  2), UINT8_C( 58),
                             UINT8_C(117), UINT8_C(166), UINT8_C( 25), UINT8_C( 65),
                             UINT8_C( 70), UINT8_C( 62), UINT8_C(155), UINT8_C(179),
                             UINT8_C(194), UINT8_C(252), UINT8_C(155), UINT8_C(113),
                             UINT8_C( 69), UINT8_C( 48), UINT8_C( 10), UINT8_C( 99),
                             UINT8_C( 95), UINT8_C(207), UINT8_C( 28), UINT8_C(202),
                             UINT8_C(125), UINT8_C(229), UINT8_C(112), UINT8_C( 77)),
      UINT64_C(          3364149510),
      simde_x_mm512_set_epu8(UINT8_C( 11), UINT8_C( 82), UINT8_C( 84), UINT8_C(224),
                             UINT8_C(162), UINT8_C(242), UINT8_C(204), UINT8_C( 68),
                             UINT8_C(182), UINT8_C( 59), UINT8_C( 47), UINT8_C(221),
                             UINT8_C( 34), UINT8_C(151), UINT8_C(204), UINT8_C( 95),
                             UINT8_C(116), UINT8_C( 40), UINT8_C(133), UINT8_C(233),
                             UINT8_C(222), UINT8_C( 50), UINT8_C( 44), UINT8_C( 33),
                             UINT8_C( 29), UINT8_C(204), UINT8_C(121), UINT8_C( 27),
                             UINT8_C(138), UINT8_C(185), UINT8_C(  5), UINT8_C(107),
                             UINT8_C(  3), UINT8_C( 36), UINT8_C( 56), UINT8_C(124),
                             UINT8_C(129), UINT8_C( 58), UINT8_C( 37), UINT8_C(111),
                             UINT8_C(254), UINT8_C(180), UINT8_C( 54), UINT8_C(250),
                             UINT8_C( 42), UINT8_C( 75), UINT8_C(154), UINT8_C(231),
                             UINT8_C(115), UINT8_C(171), UINT8_C(247), UINT8_C(142),
                             UINT8_C(  9), UINT8_C(239), UINT8_C(101), UINT8_C( 47),
                             UINT8_C( 79), UINT8_C(209), UINT8_C(133), UINT8_C(218),
                             UINT8_C(253), UINT8_C( 22), UINT8_C( 28), UINT8_C(216)),
      simde_x_mm512_set_epu8(UINT8_C( 60), UINT8_C( 92), UINT8_C(115), UINT8_C(  5),
                             UINT8_C(100), UINT8_C( 27), UINT8_C(227), UINT8_C(100),
                             UINT8_C( 89), UINT8_C(205), UINT8_C( 67), UINT8_C( 82),
                             UINT8_C(155), UINT8_C(204), UINT8_C(152), UINT8_C(151),
                             UINT8_C(209), UINT8_C(229), UINT8_C(210), UINT8_C( 14),
                             UINT8_C(231), UINT8_C( 89), UINT8_C(236), UINT8_C(229),
                             UINT8_C(214), UINT8_C( 93), UINT8_C( 51), UINT8_C(119),
                             UINT8_C( 13), UINT8_C( 60), UINT8_C(212), UINT8_C(222),
                             UINT8_C( 67), UINT8_C( 38), UINT8_C( 63), UINT8_C(141),
                             UINT8_C( 12), UINT8_C(159), UINT8_C( 36), UINT8_C(134),
                             UINT8_C(  6), UINT8_C(139), UINT8_C( 90), UINT8_C(132),
                             UINT8_C(140), UINT8_C(228), UINT8_C(152), UINT8_C(216),
                             UINT8_C(137), UINT8_C(105), UINT8_C(237), UINT8_C(202),
                             UINT8_C( 29), UINT8_C(230), UINT8_C( 44), UINT8_C(  5),
                             UINT8_C( 39), UINT8_C( 73), UINT8_C(177), UINT8_C(242),
                             UINT8_C(209), UINT8_C( 96), UINT8_C( 58), UINT8_C(209)),
      simde_x_mm512_set_epu8(UINT8_C(204), UINT8_C( 72), UINT8_C(160), UINT8_C( 51),
                             UINT8_C( 17), UINT8_C( 91), UINT8_C( 99), UINT8_C(232),
                             UINT8_C(230), UINT8_C( 75), UINT8_C( 98), UINT8_C(249),
                             UINT8_C(240), UINT8_C(193), UINT8_C( 40), UINT8_C(144),
                             UINT8_C( 13), UINT8_C(232), UINT8_C(120), UINT8_C( 62),
                             UINT8_C(136), UINT8_C(  7), UINT8_C(252), UINT8_C(  3),
                             UINT8_C(225), UINT8_C( 43), UINT8_C(176), UINT8_C(138),
                             UINT8_C(205), UINT8_C( 22), UINT8_C(172), UINT8_C( 52),
                             UINT8_C( 35), UINT8_C( 37), UINT8_C( 92), UINT8_C(198),
                             UINT8_C( 71), UINT8_C( 77), UINT8_C(  2), UINT8_C( 58),
                             UINT8_C(130), UINT8_C(166), UINT8_C( 25), UINT8_C( 65),
                             UINT8_C( 70), UINT8_C(152), UINT8_C(155), UINT8_C(179),
                             UINT8_C(126), UINT8_C(138), UINT8_C(155), UINT8_C(172),
                             UINT8_C( 19), UINT8_C( 48), UINT8_C( 10), UINT8_C( 26),
                             UINT8_C( 95), UINT8_C(207), UINT8_C( 28), UINT8_C(202),
                             UINT8_C(125), UINT8_C( 59), UINT8_C( 43), UINT8_C( 77)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_mask_avg_epu8(test_vec[i].src, test_vec[i].k, test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_u32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_maskz_avg_epu8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__mmask64 k;
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
{ UINT64_C(          1713497089),
      simde_x_mm512_set_epu8(UINT8_C(151), UINT8_C( 80), UINT8_C(240), UINT8_C(132),
                             UINT8_C(208), UINT8_C( 76), UINT8_C(165), UINT8_C(128),
                             UINT8_C( 54), UINT8_C( 63), UINT8_C(114), UINT8_C(183),
                             UINT8_C(230), UINT8_C(208), UINT8_C(232), UINT8_C(243),
                             UINT8_C(  5), UINT8_C(123), UINT8_C(211), UINT8_C(199),
                             UINT8_C(149), UINT8_C( 47), UINT8_C( 90), UINT8_C(202),
                             UINT8_C(  1), UINT8_C(118), UINT8_C( 37), UINT8_C(249),
                             UINT8_C( 83), UINT8_C( 31), UINT8_C(233), UINT8_C(236),
                             UINT8_C(152), UINT8_C(114), UINT8_C( 63), UINT8_C( 25),
                             UINT8_C(176), UINT8_C( 17), UINT8_C( 37), UINT8_C(212),
                             UINT8_C(144), UINT8_C( 41), UINT8_C(238), UINT8_C( 86),
                             UINT8_C(114), UINT8_C(233), UINT8_C(170), UINT8_C(157),
                             UINT8_C(114), UINT8_C( 25), UINT8_C( 94), UINT8_C( 34),
                             UINT8_C(208), UINT8_C(252), UINT8_C(133), UINT8_C(212),
                             UINT8_C(188), UINT8_C( 19), UINT8_C( 47), UINT8_C(134),
                             UINT8_C(117), UINT8_C( 69), UINT8_C(135), UINT8_C( 66)),
      simde_x_mm512_set_epu8(UINT8_C(180), UINT8_C(237), UINT8_C(100), UINT8_C( 59),
                             UINT8_C(192), UINT8_C(196), UINT8_C(203), UINT8_C( 16),
                             UINT8_C(  0), UINT8_C(167), UINT8_C( 13), UINT8_C( 17),
                             UINT8_C(116), UINT8_C( 41), UINT8_C( 54), UINT8_C(248),
                             UINT8_C(144), UINT8_C(109), UINT8_C( 94), UINT8_C( 19),
                             UINT8_C( 46), UINT8_C(201), UINT8_C(103), UINT8_C(  7),
                             UINT8_C(241), UINT8_C(244), UINT8_C(234), UINT8_C(127),
                             UINT8_C(208), UINT8_C(173), UINT8_C(247), UINT8_C(171),
                             UINT8_C(177), UINT8_C(244), UINT8_C( 76), UINT8_C(191),
                             UINT8_C(166), UINT8_C( 19), UINT8_C( 33), UINT8_C(206),
                             UINT8_C( 89), UINT8_C(216), UINT8_C(139), UINT8_C(111),
                             UINT8_C( 48), UINT8_C(119), UINT8_C(201), UINT8_C( 66),
                             UINT8_C(113), UINT8_C(254), UINT8_C(207), UINT8_C(146),
                             UINT8_C(201), UINT8_C( 44), UINT8_C(125), UINT8_C(195),
                             UINT8_C(221), UINT8_C(218), UINT8_C(229), UINT8_C(236),
                             UINT8_C( 32), UINT8_C(197), UINT8_C(234), UINT8_C(125)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(179), UINT8_C( 70), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 18), UINT8_C( 35), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(189), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(112),
                             UINT8_C(114), UINT8_C(140), UINT8_C(151), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(148), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C( 96)) },
    { UINT64_C(          4250428108),
      simde_x_mm512_set_epu8(UINT8_C(107), UINT8_C(163), UINT8_C(179), UINT8_C( 53),
                             UINT8_C(126), UINT8_C( 10), UINT8_C(123), UINT8_C(143),
                             UINT8_C(215), UINT8_C(148), UINT8_C(197), UINT8_C(220),
                             UINT8_C(232), UINT8_C(205), UINT8_C(188), UINT8_C(218),
                             UINT8_C( 19), UINT8_C(120), UINT8_C(138), UINT8_C( 63),
                             UINT8_C( 24), UINT8_C( 72), UINT8_C( 39), UINT8_C( 31),
                             UINT8_C(164), UINT8_C( 52), UINT8_C( 81), UINT8_C( 39),
                             UINT8_C(186), UINT8_C( 73), UINT8_C( 76), UINT8_C(114),
                             UINT8_C(249), UINT8_C(  4), UINT8_C(201), UINT8_C(188),
                             UINT8_C(120), UINT8_C( 98), UINT8_C(141), UINT8_C(200),
                             UINT8_C( 93), UINT8_C(254), UINT8_C( 78), UINT8_C( 16),
                             UINT8_C( 88), UINT8_C( 71), UINT8_C(144), UINT8_C(138),
                             UINT8_C(  4), UINT8_C(168), UINT8_C( 76), UINT8_C( 88),
                             UINT8_C(159), UINT8_C(107), UINT8_C(228), UINT8_C(197),
                             UINT8_C(209), UINT8_C(111), UINT8_C( 61), UINT8_C(147),
                             UINT8_C(137), UINT8_C( 97), UINT8_C(105), UINT8_C(160)),
      simde_x_mm512_set_epu8(UINT8_C( 95), UINT8_C(238), UINT8_C( 11), UINT8_C( 96),
                             UINT8_C(252), UINT8_C(162), UINT8_C(116), UINT8_C(225),
                             UINT8_C( 52), UINT8_C(254), UINT8_C( 98), UINT8_C( 10),
                             UINT8_C(  5), UINT8_C( 19), UINT8_C(191), UINT8_C( 10),
                             UINT8_C(147), UINT8_C( 52), UINT8_C(171), UINT8_C(224),
                             UINT8_C( 38), UINT8_C( 92), UINT8_C(  6), UINT8_C(185),
                             UINT8_C(177), UINT8_C( 79), UINT8_C(162), UINT8_C(113),
                             UINT8_C(139), UINT8_C( 20), UINT8_C(174), UINT8_C( 82),
                             UINT8_C(136), UINT8_C(114), UINT8_C(204), UINT8_C(188),
                             UINT8_C(236), UINT8_C(209), UINT8_C(166), UINT8_C(169),
                             UINT8_C( 79), UINT8_C(219), UINT8_C( 63), UINT8_C(167),
                             UINT8_C(216), UINT8_C(189), UINT8_C(187), UINT8_C(139),
                             UINT8_C(254), UINT8_C(206), UINT8_C(156), UINT8_C(171),
                             UINT8_C(128), UINT8_C(139), UINT8_C( 97), UINT8_C(237),
                             UINT8_C( 71), UINT8_C(239), UINT8_C(  0), UINT8_C(174),
                             UINT8_C(229), UINT8_C(124), UINT8_C( 45), UINT8_C( 57)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(193), UINT8_C( 59), UINT8_C(203), UINT8_C(188),
                             UINT8_C(178), UINT8_C(154), UINT8_C(  0), UINT8_C(185),
                             UINT8_C(  0), UINT8_C(237), UINT8_C(  0), UINT8_C( 92),
                             UINT8_C(152), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(187), UINT8_C(116), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(163), UINT8_C(  0),
                             UINT8_C(140), UINT8_C(175), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(183), UINT8_C(111), UINT8_C(  0), UINT8_C(  0)) },
    { UINT64_C(          3228288806),
      simde_x_mm512_set_epu8(UINT8_C( 83), UINT8_C( 39), UINT8_C(120), UINT8_C(115),
                             UINT8_C(205), UINT8_C(228), UINT8_C(102), UINT8_C(158),
                             UINT8_C(179), UINT8_C(121), UINT8_C( 42), UINT8_C(114),
                             UINT8_C(255), UINT8_C(112), UINT8_C( 17), UINT8_C(225),
                             UINT8_C(108), UINT8_C(229), UINT8_C( 66), UINT8_C( 23),
                             UINT8_C( 69), UINT8_C(166), UINT8_C(210), UINT8_C(165),
                             UINT8_C(175), UINT8_C(169), UINT8_C(  1), UINT8_C(245),
                             UINT8_C( 84), UINT8_C(139), UINT8_C( 79), UINT8_C(146),
                             UINT8_C(212), UINT8_C(226), UINT8_C( 33), UINT8_C( 53),
                             UINT8_C( 64), UINT8_C(240), UINT8_C(145), UINT8_C(215),
                             UINT8_C(154), UINT8_C( 13), UINT8_C( 97), UINT8_C(201),
                             UINT8_C( 19), UINT8_C(240), UINT8_C(188), UINT8_C(173),
                             UINT8_C(228), UINT8_C( 88), UINT8_C( 41), UINT8_C( 18),
                             UINT8_C(177), UINT8_C(249), UINT8_C(161), UINT8_C(144),
                             UINT8_C(168), UINT8_C(228), UINT8_C(181), UINT8_C( 34),
                             UINT8_C(226), UINT8_C(255), UINT8_C( 52), UINT8_C(164)),
      simde_x_mm512_set_epu8(UINT8_C( 60), UINT8_C(216), UINT8_C( 36), UINT8_C(217),
                             UINT8_C(176), UINT8_C(146), UINT8_C( 14), UINT8_C(195),
                             UINT8_C(217), UINT8_C(186), UINT8_C(140), UINT8_C(157),
                             UINT8_C(174), UINT8_C(143), UINT8_C(136), UINT8_C(140),
                             UINT8_C(198), UINT8_C( 18), UINT8_C( 72), UINT8_C( 23),
                             UINT8_C(139), UINT8_C(151), UINT8_C( 83), UINT8_C(  3),
                             UINT8_C(152), UINT8_C( 34), UINT8_C( 72), UINT8_C(223),
                             UINT8_C( 84), UINT8_C(166), UINT8_C(140), UINT8_C(210),
                             UINT8_C(238), UINT8_C( 96), UINT8_C(210), UINT8_C(147),
                             UINT8_C(153), UINT8_C(238), UINT8_C(217), UINT8_C( 67),
                             UINT8_C(118), UINT8_C( 12), UINT8_C(237), UINT8_C(171),
                             UINT8_C( 23), UINT8_C( 75), UINT8_C(178), UINT8_C(118),
                             UINT8_C(128), UINT8_C( 11), UINT8_C(225), UINT8_C(116),
                             UINT8_C(179), UINT8_C( 97), UINT8_C( 87), UINT8_C( 53),
                             UINT8_C(223), UINT8_C( 37), UINT8_C( 28), UINT8_C( 24),
                             UINT8_C(153), UINT8_C( 99), UINT8_C(181), UINT8_C( 41)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(225), UINT8_C(161), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 13), UINT8_C(167), UINT8_C(  0),
                             UINT8_C( 21), UINT8_C(  0), UINT8_C(183), UINT8_C(146),
                             UINT8_C(178), UINT8_C( 50), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(173), UINT8_C(124), UINT8_C( 99),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(105), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(177), UINT8_C(117), UINT8_C(  0)) },
    { UINT64_C(            74372392),
      simde_x_mm512_set_epu8(UINT8_C( 19), UINT8_C(169), UINT8_C( 42), UINT8_C(146),
                             UINT8_C( 68), UINT8_C( 97), UINT8_C(131), UINT8_C( 75),
                             UINT8_C( 30), UINT8_C(202), UINT8_C(218), UINT8_C(236),
                             UINT8_C(160), UINT8_C( 84), UINT8_C(108), UINT8_C( 24),
                             UINT8_C(202), UINT8_C(230), UINT8_C(131), UINT8_C(203),
                             UINT8_C( 48), UINT8_C(178), UINT8_C(160), UINT8_C( 82),
                             UINT8_C(240), UINT8_C(188), UINT8_C(191), UINT8_C( 28),
                             UINT8_C(174), UINT8_C(140), UINT8_C(119), UINT8_C(143),
                             UINT8_C(102), UINT8_C( 90), UINT8_C( 86), UINT8_C(242),
                             UINT8_C(207), UINT8_C( 71), UINT8_C(  2), UINT8_C( 28),
                             UINT8_C(194), UINT8_C( 53), UINT8_C(214), UINT8_C(158),
                             UINT8_C( 11), UINT8_C( 81), UINT8_C( 46), UINT8_C( 73),
                             UINT8_C(250), UINT8_C(127), UINT8_C(146), UINT8_C(248),
                             UINT8_C(106), UINT8_C( 95), UINT8_C(130), UINT8_C(129),
                             UINT8_C(153), UINT8_C(235), UINT8_C(236), UINT8_C(185),
                             UINT8_C(106), UINT8_C( 23), UINT8_C(205), UINT8_C(209)),
      simde_x_mm512_set_epu8(UINT8_C(221), UINT8_C(195), UINT8_C( 15), UINT8_C( 71),
                             UINT8_C(113), UINT8_C(109), UINT8_C( 91), UINT8_C(139),
                             UINT8_C(  0), UINT8_C(121), UINT8_C( 48), UINT8_C(109),
                             UINT8_C( 55), UINT8_C(125), UINT8_C(144), UINT8_C( 80),
                             UINT8_C( 48), UINT8_C( 40), UINT8_C( 32), UINT8_C(158),
                             UINT8_C( 64), UINT8_C(225), UINT8_C(246), UINT8_C(250),
                             UINT8_C(216), UINT8_C( 37), UINT8_C( 76), UINT8_C(205),
                             UINT8_C( 27), UINT8_C(254), UINT8_C(155), UINT8_C(246),
                             UINT8_C(218), UINT8_C( 69), UINT8_C(  1), UINT8_C(216),
                             UINT8_C(164), UINT8_C( 62), UINT8_C( 73), UINT8_C(202),
                             UINT8_C( 28), UINT8_C(155), UINT8_C(152), UINT8_C(139),
                             UINT8_C( 24), UINT8_C(201), UINT8_C( 82), UINT8_C(156),
                             UINT8_C(214), UINT8_C( 62), UINT8_C(143), UINT8_C(110),
                             UINT8_C(164), UINT8_C(127), UINT8_C(164), UINT8_C( 20),
                             UINT8_C(221), UINT8_C( 35), UINT8_C( 30), UINT8_C(170),
                             UINT8_C(120), UINT8_C( 91), UINT8_C(187), UINT8_C(207)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 67), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(104), UINT8_C(183), UINT8_C(  0),
                             UINT8_C( 18), UINT8_C(141), UINT8_C( 64), UINT8_C(  0),
                             UINT8_C(232), UINT8_C( 95), UINT8_C(  0), UINT8_C(179),
                             UINT8_C(  0), UINT8_C(111), UINT8_C(  0), UINT8_C( 75),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(133), UINT8_C(  0),
                             UINT8_C(113), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0)) },
    { UINT64_C(          1704849946),
      simde_x_mm512_set_epu8(UINT8_C( 75), UINT8_C(130), UINT8_C(174), UINT8_C(185),
                             UINT8_C(240), UINT8_C(251), UINT8_C(233), UINT8_C(143),
                             UINT8_C(196), UINT8_C( 48), UINT8_C(196), UINT8_C( 72),
                             UINT8_C(201), UINT8_C(123), UINT8_C( 70), UINT8_C(237),
                             UINT8_C( 30), UINT8_C(225), UINT8_C(201), UINT8_C(186),
                             UINT8_C(  9), UINT8_C(202), UINT8_C( 73), UINT8_C(192),
                             UINT8_C( 82), UINT8_C(124), UINT8_C( 29), UINT8_C(  8),
                             UINT8_C( 64), UINT8_C( 66), UINT8_C(254), UINT8_C(144),
                             UINT8_C(122), UINT8_C(124), UINT8_C( 90), UINT8_C( 22),
                             UINT8_C(107), UINT8_C(236), UINT8_C( 37), UINT8_C(140),
                             UINT8_C(185), UINT8_C( 48), UINT8_C(255), UINT8_C(239),
                             UINT8_C(166), UINT8_C(  3), UINT8_C(222), UINT8_C( 36),
                             UINT8_C(239), UINT8_C(218), UINT8_C(100), UINT8_C(226),
                             UINT8_C(118), UINT8_C( 42), UINT8_C(231), UINT8_C(211),
                             UINT8_C(  4), UINT8_C(  8), UINT8_C( 53), UINT8_C( 84),
                             UINT8_C(136), UINT8_C( 61), UINT8_C( 90), UINT8_C(237)),
      simde_x_mm512_set_epu8(UINT8_C( 81), UINT8_C( 81), UINT8_C( 43), UINT8_C( 91),
                             UINT8_C(149), UINT8_C(240), UINT8_C( 71), UINT8_C(161),
                             UINT8_C(204), UINT8_C( 80), UINT8_C( 62), UINT8_C(128),
                             UINT8_C(178), UINT8_C( 60), UINT8_C( 92), UINT8_C( 64),
                             UINT8_C( 44), UINT8_C(188), UINT8_C(121), UINT8_C(108),
                             UINT8_C( 90), UINT8_C( 48), UINT8_C(  8), UINT8_C(192),
                             UINT8_C(189), UINT8_C(101), UINT8_C( 72), UINT8_C(114),
                             UINT8_C(232), UINT8_C(233), UINT8_C(205), UINT8_C(  5),
                             UINT8_C(117), UINT8_C( 79), UINT8_C( 29), UINT8_C(232),
                             UINT8_C( 51), UINT8_C(176), UINT8_C(226), UINT8_C(160),
                             UINT8_C(230), UINT8_C(138), UINT8_C( 64), UINT8_C(111),
                             UINT8_C(190), UINT8_C(200), UINT8_C(126), UINT8_C(168),
                             UINT8_C(222), UINT8_C(  5), UINT8_C(142), UINT8_C(  0),
                             UINT8_C( 60), UINT8_C( 23), UINT8_C(145), UINT8_C(197),
                             UINT8_C( 92), UINT8_C( 21), UINT8_C(182), UINT8_C( 99),
                             UINT8_C(234), UINT8_C(209), UINT8_C(134), UINT8_C( 50)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(102), UINT8_C( 60), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(206), UINT8_C(  0), UINT8_C(150),
                             UINT8_C(208), UINT8_C(  0), UINT8_C(  0), UINT8_C(175),
                             UINT8_C(178), UINT8_C(102), UINT8_C(  0), UINT8_C(102),
                             UINT8_C(231), UINT8_C(112), UINT8_C(121), UINT8_C(113),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(188), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C( 92),
                             UINT8_C(185), UINT8_C(  0), UINT8_C(112), UINT8_C(  0)) },
    { UINT64_C(           616766838),
      simde_x_mm512_set_epu8(UINT8_C(180), UINT8_C(137), UINT8_C( 51), UINT8_C( 92),
                             UINT8_C(187), UINT8_C( 82), UINT8_C( 53), UINT8_C( 28),
                             UINT8_C(223), UINT8_C(152), UINT8_C(200), UINT8_C(193),
                             UINT8_C(225), UINT8_C(154), UINT8_C(231), UINT8_C( 61),
                             UINT8_C(162), UINT8_C( 56), UINT8_C(127), UINT8_C(187),
                             UINT8_C(196), UINT8_C(180), UINT8_C(126), UINT8_C( 42),
                             UINT8_C(219), UINT8_C(  5), UINT8_C(113), UINT8_C(138),
                             UINT8_C(204), UINT8_C(253), UINT8_C(215), UINT8_C(247),
                             UINT8_C(235), UINT8_C( 43), UINT8_C(234), UINT8_C( 33),
                             UINT8_C(112), UINT8_C(108), UINT8_C(220), UINT8_C( 90),
                             UINT8_C(144), UINT8_C(181), UINT8_C( 55), UINT8_C( 53),
                             UINT8_C( 64), UINT8_C(203), UINT8_C(190), UINT8_C(189),
                             UINT8_C(102), UINT8_C(244), UINT8_C( 66), UINT8_C(205),
                             UINT8_C( 39), UINT8_C(196), UINT8_C(165), UINT8_C(215),
                             UINT8_C(172), UINT8_C( 65), UINT8_C( 68), UINT8_C(204),
                             UINT8_C( 53), UINT8_C( 34), UINT8_C( 78), UINT8_C(127)),
      simde_x_mm512_set_epu8(UINT8_C(141), UINT8_C(142), UINT8_C(201), UINT8_C(183),
                             UINT8_C( 28), UINT8_C(210), UINT8_C( 48), UINT8_C(119),
                             UINT8_C(143), UINT8_C( 53), UINT8_C(224), UINT8_C( 96),
                             UINT8_C(218), UINT8_C(201), UINT8_C(253), UINT8_C(241),
                             UINT8_C( 77), UINT8_C(249), UINT8_C( 74), UINT8_C( 43),
                             UINT8_C(181), UINT8_C(113), UINT8_C(189), UINT8_C(106),
                             UINT8_C( 54), UINT8_C( 32), UINT8_C(202), UINT8_C( 67),
                             UINT8_C(214), UINT8_C( 23), UINT8_C(167), UINT8_C( 40),
                             UINT8_C(139), UINT8_C( 52), UINT8_C( 60), UINT8_C( 38),
                             UINT8_C( 95), UINT8_C( 19), UINT8_C(138), UINT8_C(217),
                             UINT8_C(209), UINT8_C( 61), UINT8_C( 63), UINT8_C(128),
                             UINT8_C(163), UINT8_C( 56), UINT8_C(251), UINT8_C(135),
                             UINT8_C( 69), UINT8_C(144), UINT8_C(129), UINT8_C(103),
                             UINT8_C(244), UINT8_C( 97), UINT8_C(191), UINT8_C( 58),
                             UINT8_C(119), UINT8_C( 19), UINT8_C(105), UINT8_C(174),
                             UINT8_C(180), UINT8_C( 41), UINT8_C(251), UINT8_C(155)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(147), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 64), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(177), UINT8_C(121), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(221), UINT8_C(162),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(154),
                             UINT8_C(142), UINT8_C(147), UINT8_C(  0), UINT8_C(137),
                             UINT8_C(  0), UINT8_C( 42), UINT8_C( 87), UINT8_C(189),
                             UINT8_C(  0), UINT8_C( 38), UINT8_C(165), UINT8_C(  0)) },
    { UINT64_C(           771922964),
      simde_x_mm512_set_epu8(UINT8_C( 84), UINT8_C(193), UINT8_C(196), UINT8_C(188),
                             UINT8_C( 28), UINT8_C( 14), UINT8_C(183), UINT8_C( 63),
                             UINT8_C(195), UINT8_C( 17), UINT8_C( 60), UINT8_C(196),
                             UINT8_C(140), UINT8_C(189), UINT8_C(109), UINT8_C( 63),
                             UINT8_C( 42), UINT8_C(192), UINT8_C(240), UINT8_C(166),
                             UINT8_C( 14), UINT8_C(224), UINT8_C(252), UINT8_C( 17),
                             UINT8_C( 46), UINT8_C(184), UINT8_C(253), UINT8_C( 54),
                             UINT8_C( 94), UINT8_C( 75), UINT8_C(123), UINT8_C(145),
                             UINT8_C(160), UINT8_C(164), UINT8_C(123), UINT8_C(216),
                             UINT8_C(170), UINT8_C(112), UINT8_C(140), UINT8_C( 56),
                             UINT8_C( 30), UINT8_C(182), UINT8_C(108), UINT8_C( 63),
                             UINT8_C( 54), UINT8_C( 68), UINT8_C( 21), UINT8_C( 50),
                             UINT8_C( 82), UINT8_C( 10), UINT8_C(167), UINT8_C(177),
                             UINT8_C(210), UINT8_C(  2), UINT8_C( 48), UINT8_C( 73),
                             UINT8_C(153), UINT8_C( 42), UINT8_C( 43), UINT8_C( 19),
                             UINT8_C( 82), UINT8_C(112), UINT8_C(146), UINT8_C( 77)),
      simde_x_mm512_set_epu8(UINT8_C(117), UINT8_C( 61), UINT8_C(219), UINT8_C(166),
                             UINT8_C(101), UINT8_C(146), UINT8_C(252), UINT8_C(220),
                             UINT8_C(111), UINT8_C(  7), UINT8_C(233), UINT8_C( 32),
                             UINT8_C(239), UINT8_C(243), UINT8_C(204), UINT8_C(249),
                             UINT8_C(179), UINT8_C(241), UINT8_C(226), UINT8_C(120),
                             UINT8_C(244), UINT8_C(118), UINT8_C(248), UINT8_C(141),
                             UINT8_C(179), UINT8_C(252), UINT8_C(219), UINT8_C( 58),
                             UINT8_C( 62), UINT8_C(244), UINT8_C(181), UINT8_C( 77),
                             UINT8_C( 48), UINT8_C(136), UINT8_C(150), UINT8_C( 74),
                             UINT8_C( 87), UINT8_C(176), UINT8_C(194), UINT8_C( 45),
                             UINT8_C(190), UINT8_C(213), UINT8_C( 70), UINT8_C( 70),
                             UINT8_C(177), UINT8_C(254), UINT8_C(160), UINT8_C( 78),
                             UINT8_C(253), UINT8_C(131), UINT8_C(202), UINT8_C(108),
                             UINT8_C(174), UINT8_C(186), UINT8_C(172), UINT8_C(193),
                             UINT8_C(162), UINT8_C(235), UINT8_C(165), UINT8_C(158),
                             UINT8_C(140), UINT8_C(172), UINT8_C(251), UINT8_C(116)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(137), UINT8_C(  0),
                             UINT8_C(129), UINT8_C(144), UINT8_C(167), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C( 91), UINT8_C(  0),
                             UINT8_C(168), UINT8_C(  0), UINT8_C(  0), UINT8_C(143),
                             UINT8_C(192), UINT8_C( 94), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C( 89),
                             UINT8_C(  0), UINT8_C(142), UINT8_C(  0), UINT8_C(  0)) },
    { UINT64_C(            97696573),
      simde_x_mm512_set_epu8(UINT8_C( 56), UINT8_C(233), UINT8_C(161), UINT8_C( 70),
                             UINT8_C( 29), UINT8_C(119), UINT8_C(231), UINT8_C(252),
                             UINT8_C(132), UINT8_C(198), UINT8_C( 18), UINT8_C(195),
                             UINT8_C( 88), UINT8_C(114), UINT8_C(173), UINT8_C( 54),
                             UINT8_C( 75), UINT8_C(  3), UINT8_C(214), UINT8_C(  2),
                             UINT8_C(139), UINT8_C(186), UINT8_C( 99), UINT8_C(154),
                             UINT8_C(177), UINT8_C(145), UINT8_C(140), UINT8_C(170),
                             UINT8_C(124), UINT8_C( 32), UINT8_C(208), UINT8_C(227),
                             UINT8_C( 14), UINT8_C( 57), UINT8_C( 96), UINT8_C(190),
                             UINT8_C(123), UINT8_C(184), UINT8_C( 51), UINT8_C( 34),
                             UINT8_C(239), UINT8_C( 21), UINT8_C(170), UINT8_C(146),
                             UINT8_C(232), UINT8_C(  0), UINT8_C(180), UINT8_C( 80),
                             UINT8_C( 72), UINT8_C(231), UINT8_C(149), UINT8_C(142),
                             UINT8_C(142), UINT8_C( 86), UINT8_C( 39), UINT8_C(243),
                             UINT8_C( 33), UINT8_C(235), UINT8_C( 93), UINT8_C(129),
                             UINT8_C( 46), UINT8_C(131), UINT8_C(184), UINT8_C(105)),
      simde_x_mm512_set_epu8(UINT8_C(188), UINT8_C(104), UINT8_C(150), UINT8_C( 91),
                             UINT8_C(223), UINT8_C( 10), UINT8_C(154), UINT8_C(110),
                             UINT8_C(234), UINT8_C(193), UINT8_C( 58), UINT8_C(132),
                             UINT8_C( 18), UINT8_C(225), UINT8_C( 95), UINT8_C(  7),
                             UINT8_C(253), UINT8_C( 41), UINT8_C(230), UINT8_C(186),
                             UINT8_C(  9), UINT8_C( 18), UINT8_C(163), UINT8_C( 56),
                             UINT8_C( 96), UINT8_C(249), UINT8_C( 80), UINT8_C( 62),
                             UINT8_C(194), UINT8_C( 89), UINT8_C(163), UINT8_C(133),
                             UINT8_C( 35), UINT8_C(148), UINT8_C(177), UINT8_C( 29),
                             UINT8_C(195), UINT8_C(169), UINT8_C( 29), UINT8_C( 99),
                             UINT8_C(232), UINT8_C( 69), UINT8_C( 58), UINT8_C(168),
                             UINT8_C(144), UINT8_C(242), UINT8_C(220), UINT8_C(  1),
                             UINT8_C( 48), UINT8_C(123), UINT8_C( 36), UINT8_C(240),
                             UINT8_C( 56), UINT8_C(103), UINT8_C(183), UINT8_C(  7),
                             UINT8_C(134), UINT8_C(138), UINT8_C(158), UINT8_C(199),
                             UINT8_C( 65), UINT8_C( 92), UINT8_C(182), UINT8_C(118)),
      simde_x_mm512_set_epu8(UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(177), UINT8_C(  0), UINT8_C( 67),
                             UINT8_C(236), UINT8_C( 45), UINT8_C(  0), UINT8_C(157),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(200), UINT8_C(  0),
                             UINT8_C( 60), UINT8_C(  0), UINT8_C( 93), UINT8_C(191),
                             UINT8_C( 99), UINT8_C(  0), UINT8_C(111), UINT8_C(125),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(126), UINT8_C(164),
                             UINT8_C( 56), UINT8_C(112), UINT8_C(  0), UINT8_C(112)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_maskz_avg_epu8(test_vec[i].k, test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_u8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_avg_epu16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_x_mm512_set_epu16(UINT16_C( 13922), UINT16_C( 36897), UINT16_C( 58180), UINT16_C( 11516),
                              UINT16_C( 48259), UINT16_C(  5769), UINT16_C( 28390), UINT16_C( 29726),
                              UINT16_C( 60808), UINT16_C( 38778), UINT16_C( 21386), UINT16_C( 37563),
                              UINT16_C( 21427), UINT16_C( 42840), UINT16_C( 63576), UINT16_C( 25988),
                              UINT16_C( 52004), UINT16_C( 13742), UINT16_C( 20065), UINT16_C( 31945),
                              UINT16_C(  3305), UINT16_C( 50297), UINT16_C( 19714), UINT16_C( 48635),
                              UINT16_C( 64641), UINT16_C(  9835), UINT16_C( 33507), UINT16_C( 40606),
                              UINT16_C( 49930), UINT16_C( 25911), UINT16_C( 16490), UINT16_C( 30266)),
      simde_x_mm512_set_epu16(UINT16_C( 35675), UINT16_C(  3257), UINT16_C( 12418), UINT16_C( 59056),
                              UINT16_C( 54292), UINT16_C( 28377), UINT16_C( 47802), UINT16_C( 33906),
                              UINT16_C( 48379), UINT16_C( 57830), UINT16_C( 42348), UINT16_C(  4361),
                              UINT16_C( 62947), UINT16_C( 32240), UINT16_C( 12123), UINT16_C(   903),
                              UINT16_C( 62311), UINT16_C( 39097), UINT16_C( 12552), UINT16_C( 17043),
                              UINT16_C( 12967), UINT16_C( 14694), UINT16_C( 36399), UINT16_C( 44335),
                              UINT16_C( 44269), UINT16_C( 14847), UINT16_C( 26083), UINT16_C( 50887),
                              UINT16_C(  6575), UINT16_C( 58796), UINT16_C( 53958), UINT16_C( 55190)),
      simde_x_mm512_set_epu16(UINT16_C( 24799), UINT16_C( 20077), UINT16_C( 35299), UINT16_C( 35286),
                              UINT16_C( 51276), UINT16_C( 17073), UINT16_C( 38096), UINT16_C( 31816),
                              UINT16_C( 54594), UINT16_C( 48304), UINT16_C( 31867), UINT16_C( 20962),
                              UINT16_C( 42187), UINT16_C( 37540), UINT16_C( 37850), UINT16_C( 13446),
                              UINT16_C( 57158), UINT16_C( 26420), UINT16_C( 16309), UINT16_C( 24494),
                              UINT16_C(  8136), UINT16_C( 32496), UINT16_C( 28057), UINT16_C( 46485),
                              UINT16_C( 54455), UINT16_C( 12341), UINT16_C( 29795), UINT16_C( 45747),
                              UINT16_C( 28253), UINT16_C( 42354), UINT16_C( 35224), UINT16_C( 42728)) },
    { simde_x_mm512_set_epu16(UINT16_C( 53467), UINT16_C( 14812), UINT16_C(  1601), UINT16_C(  5446),
                              UINT16_C( 10821), UINT16_C( 52555), UINT16_C( 11613), UINT16_C( 32262),
                              UINT16_C( 44594), UINT16_C(  4573), UINT16_C( 55679), UINT16_C( 28536),
                              UINT16_C( 33684), UINT16_C( 36248), UINT16_C( 37000), UINT16_C( 16957),
                              UINT16_C( 33904), UINT16_C(  7320), UINT16_C( 32743), UINT16_C( 28065),
                              UINT16_C( 40454), UINT16_C( 54701), UINT16_C( 30387), UINT16_C( 20402),
                              UINT16_C( 12012), UINT16_C( 12600), UINT16_C( 40321), UINT16_C( 11976),
                              UINT16_C( 22914), UINT16_C( 48119), UINT16_C( 54567), UINT16_C( 37518)),
      simde_x_mm512_set_epu16(UINT16_C( 19683), UINT16_C( 49281), UINT16_C( 58394), UINT16_C( 42390),
                              UINT16_C( 28448), UINT16_C(  2882), UINT16_C( 16746), UINT16_C( 53644),
                              UINT16_C( 16898), UINT16_C( 40318), UINT16_C( 16648), UINT16_C( 14647),
                              UINT16_C( 38440), UINT16_C( 42038), UINT16_C( 24217), UINT16_C( 60044),
                              UINT16_C( 11584), UINT16_C( 35025), UINT16_C( 26069), UINT16_C( 37885),
                              UINT16_C( 14708), UINT16_C( 24663), UINT16_C( 44110), UINT16_C( 40062),
                              UINT16_C(   918), UINT16_C( 34061), UINT16_C( 57874), UINT16_C( 27338),
                              UINT16_C( 24412), UINT16_C( 15314), UINT16_C( 35927), UINT16_C( 54580)),
      simde_x_mm512_set_epu16(UINT16_C( 36575), UINT16_C( 32047), UINT16_C( 29998), UINT16_C( 23918),
                              UINT16_C( 19635), UINT16_C( 27719), UINT16_C( 14180), UINT16_C( 42953),
                              UINT16_C( 30746), UINT16_C( 22446), UINT16_C( 36164), UINT16_C( 21592),
                              UINT16_C( 36062), UINT16_C( 39143), UINT16_C( 30609), UINT16_C( 38501),
                              UINT16_C( 22744), UINT16_C( 21173), UINT16_C( 29406), UINT16_C( 32975),
                              UINT16_C( 27581), UINT16_C( 39682), UINT16_C( 37249), UINT16_C( 30232),
                              UINT16_C(  6465), UINT16_C( 23331), UINT16_C( 49098), UINT16_C( 19657),
                              UINT16_C( 23663), UINT16_C( 31717), UINT16_C( 45247), UINT16_C( 46049)) },
    { simde_x_mm512_set_epu16(UINT16_C(  2926), UINT16_C( 37218), UINT16_C( 49262), UINT16_C( 41266),
                              UINT16_C( 64616), UINT16_C( 47887), UINT16_C( 47046), UINT16_C( 20233),
                              UINT16_C( 17531), UINT16_C( 35216), UINT16_C( 26970), UINT16_C( 22110),
                              UINT16_C( 23885), UINT16_C( 49160), UINT16_C( 11289), UINT16_C( 22415),
                              UINT16_C( 57944), UINT16_C( 39676), UINT16_C( 14246), UINT16_C( 36547),
                              UINT16_C( 43442), UINT16_C( 52571), UINT16_C( 16838), UINT16_C( 32565),
                              UINT16_C( 62744), UINT16_C( 45552), UINT16_C( 50968), UINT16_C( 36716),
                              UINT16_C( 10154), UINT16_C( 41950), UINT16_C( 14496), UINT16_C( 51322)),
      simde_x_mm512_set_epu16(UINT16_C( 14640), UINT16_C( 63580), UINT16_C( 14746), UINT16_C( 21373),
                              UINT16_C(  2714), UINT16_C( 18543), UINT16_C( 17198), UINT16_C( 32202),
                              UINT16_C( 11581), UINT16_C( 13480), UINT16_C( 54288), UINT16_C(  9603),
                              UINT16_C( 12378), UINT16_C( 53993), UINT16_C( 37890), UINT16_C(  2622),
                              UINT16_C( 22964), UINT16_C( 24086), UINT16_C( 65101), UINT16_C(   151),
                              UINT16_C( 54310), UINT16_C( 27341), UINT16_C( 18591), UINT16_C( 57907),
                              UINT16_C( 13730), UINT16_C( 48472), UINT16_C( 10888), UINT16_C( 26832),
                              UINT16_C( 39665), UINT16_C( 48015), UINT16_C( 40287), UINT16_C(  7521)),
      simde_x_mm512_set_epu16(UINT16_C(  8783), UINT16_C( 50399), UINT16_C( 32004), UINT16_C( 31320),
                              UINT16_C( 33665), UINT16_C( 33215), UINT16_C( 32122), UINT16_C( 26218),
                              UINT16_C( 14556), UINT16_C( 24348), UINT16_C( 40629), UINT16_C( 15857),
                              UINT16_C( 18132), UINT16_C( 51577), UINT16_C( 24590), UINT16_C( 12519),
                              UINT16_C( 40454), UINT16_C( 31881), UINT16_C( 39674), UINT16_C( 18349),
                              UINT16_C( 48876), UINT16_C( 39956), UINT16_C( 17715), UINT16_C( 45236),
                              UINT16_C( 38237), UINT16_C( 47012), UINT16_C( 30928), UINT16_C( 31774),
                              UINT16_C( 24910), UINT16_C( 44983), UINT16_C( 27392), UINT16_C( 29422)) },
    { simde_x_mm512_set_epu16(UINT16_C( 33359), UINT16_C( 20997), UINT16_C( 60535), UINT16_C(  6477),
                              UINT16_C( 35687), UINT16_C( 52277), UINT16_C( 18001), UINT16_C(  9114),
                              UINT16_C( 58688), UINT16_C( 24195), UINT16_C( 55556), UINT16_C( 26572),
                              UINT16_C( 13614), UINT16_C( 31611), UINT16_C( 64483), UINT16_C( 39184),
                              UINT16_C( 20423), UINT16_C(  4017), UINT16_C( 21263), UINT16_C(  9687),
                              UINT16_C( 45713), UINT16_C( 61493), UINT16_C( 29891), UINT16_C( 26099),
                              UINT16_C( 34397), UINT16_C( 16487), UINT16_C( 18770), UINT16_C( 48421),
                              UINT16_C( 51774), UINT16_C( 40289), UINT16_C( 36358), UINT16_C(  9752)),
      simde_x_mm512_set_epu16(UINT16_C( 14685), UINT16_C( 36894), UINT16_C(  3039), UINT16_C( 14211),
                              UINT16_C(  7600), UINT16_C( 13396), UINT16_C( 20271), UINT16_C( 32796),
                              UINT16_C( 18819), UINT16_C( 35329), UINT16_C( 25198), UINT16_C( 53928),
                              UINT16_C( 53351), UINT16_C( 38714), UINT16_C( 38160), UINT16_C( 28969),
                              UINT16_C( 51469), UINT16_C( 54246), UINT16_C( 53402), UINT16_C( 12671),
                              UINT16_C( 23815), UINT16_C( 34869), UINT16_C(  4959), UINT16_C( 48021),
                              UINT16_C(   161), UINT16_C( 58452), UINT16_C( 21609), UINT16_C( 23057),
                              UINT16_C(   951), UINT16_C( 33560), UINT16_C( 51461), UINT16_C( 32848)),
      simde_x_mm512_set_epu16(UINT16_C( 24022), UINT16_C( 28946), UINT16_C( 31787), UINT16_C( 10344),
                              UINT16_C( 21644), UINT16_C( 32837), UINT16_C( 19136), UINT16_C( 20955),
                              UINT16_C( 38754), UINT16_C( 29762), UINT16_C( 40377), UINT16_C( 40250),
                              UINT16_C( 33483), UINT16_C( 35163), UINT16_C( 51322), UINT16_C( 34077),
                              UINT16_C( 35946), UINT16_C( 29132), UINT16_C( 37333), UINT16_C( 11179),
                              UINT16_C( 34764), UINT16_C( 48181), UINT16_C( 17425), UINT16_C( 37060),
                              UINT16_C( 17279), UINT16_C( 37470), UINT16_C( 20190), UINT16_C( 35739),
                              UINT16_C( 26363), UINT16_C( 36925), UINT16_C( 43910), UINT16_C( 21300)) },
    { simde_x_mm512_set_epu16(UINT16_C( 16482), UINT16_C( 29865), UINT16_C( 43161), UINT16_C( 49292),
                              UINT16_C( 20253), UINT16_C( 46312), UINT16_C( 22868), UINT16_C( 35970),
                              UINT16_C( 27832), UINT16_C( 29779), UINT16_C( 41321), UINT16_C(  4471),
                              UINT16_C(   101), UINT16_C( 26727), UINT16_C( 57916), UINT16_C(  6017),
                              UINT16_C( 36275), UINT16_C( 22385), UINT16_C( 64475), UINT16_C( 27511),
                              UINT16_C( 18089), UINT16_C(  2907), UINT16_C(  6044), UINT16_C( 25380),
                              UINT16_C( 39450), UINT16_C(  6056), UINT16_C(  3173), UINT16_C( 48508),
                              UINT16_C( 39476), UINT16_C( 34432), UINT16_C( 54613), UINT16_C( 48593)),
      simde_x_mm512_set_epu16(UINT16_C(  5403), UINT16_C( 14767), UINT16_C( 48931), UINT16_C( 19205),
                              UINT16_C( 43050), UINT16_C( 50911), UINT16_C( 61409), UINT16_C( 58117),
                              UINT16_C( 21956), UINT16_C( 47259), UINT16_C( 18797), UINT16_C( 33639),
                              UINT16_C( 33691), UINT16_C( 26950), UINT16_C( 42098), UINT16_C( 29396),
                              UINT16_C( 40226), UINT16_C( 56570), UINT16_C( 65251), UINT16_C( 61481),
                              UINT16_C( 53274), UINT16_C( 56708), UINT16_C( 31154), UINT16_C( 56119),
                              UINT16_C( 11598), UINT16_C( 59701), UINT16_C( 22444), UINT16_C( 31379),
                              UINT16_C( 47987), UINT16_C(  5886), UINT16_C(  2522), UINT16_C( 57558)),
      simde_x_mm512_set_epu16(UINT16_C( 10943), UINT16_C( 22316), UINT16_C( 46046), UINT16_C( 34249),
                              UINT16_C( 31652), UINT16_C( 48612), UINT16_C( 42139), UINT16_C( 47044),
                              UINT16_C( 24894), UINT16_C( 38519), UINT16_C( 30059), UINT16_C( 19055),
                              UINT16_C( 16896), UINT16_C( 26839), UINT16_C( 50007), UINT16_C( 17707),
                              UINT16_C( 38251), UINT16_C( 39478), UINT16_C( 64863), UINT16_C( 44496),
                              UINT16_C( 35682), UINT16_C( 29808), UINT16_C( 18599), UINT16_C( 40750),
                              UINT16_C( 25524), UINT16_C( 32879), UINT16_C( 12809), UINT16_C( 39944),
                              UINT16_C( 43732), UINT16_C( 20159), UINT16_C( 28568), UINT16_C( 53076)) },
    { simde_x_mm512_set_epu16(UINT16_C( 34893), UINT16_C( 23679), UINT16_C( 64034), UINT16_C( 46251),
                              UINT16_C(  8048), UINT16_C( 41654), UINT16_C( 61576), UINT16_C( 24661),
                              UINT16_C( 10548), UINT16_C( 15307), UINT16_C( 54631), UINT16_C( 56752),
                              UINT16_C( 25346), UINT16_C(  5558), UINT16_C(  1968), UINT16_C( 32109),
                              UINT16_C( 59890), UINT16_C(  1389), UINT16_C( 18928), UINT16_C( 44824),
                              UINT16_C( 11367), UINT16_C( 52264), UINT16_C( 20085), UINT16_C( 56744),
                              UINT16_C( 49674), UINT16_C(  4067), UINT16_C(  3569), UINT16_C( 23831),
                              UINT16_C(  8020), UINT16_C( 56140), UINT16_C( 13343), UINT16_C(  5815)),
      simde_x_mm512_set_epu16(UINT16_C(    70), UINT16_C( 49524), UINT16_C(  2389), UINT16_C( 48794),
                              UINT16_C(  9656), UINT16_C( 49515), UINT16_C( 20459), UINT16_C(  8573),
                              UINT16_C( 28524), UINT16_C( 25506), UINT16_C( 45011), UINT16_C( 20391),
                              UINT16_C( 42585), UINT16_C(  5514), UINT16_C(  3945), UINT16_C( 49101),
                              UINT16_C(  8826), UINT16_C( 53647), UINT16_C( 55458), UINT16_C( 61374),
                              UINT16_C( 54518), UINT16_C( 64462), UINT16_C( 15696), UINT16_C( 38749),
                              UINT16_C( 14471), UINT16_C( 43272), UINT16_C( 48962), UINT16_C( 15384),
                              UINT16_C( 23964), UINT16_C(  8219), UINT16_C( 12498), UINT16_C( 59146)),
      simde_x_mm512_set_epu16(UINT16_C( 17482), UINT16_C( 36602), UINT16_C( 33212), UINT16_C( 47523),
                              UINT16_C(  8852), UINT16_C( 45585), UINT16_C( 41018), UINT16_C( 16617),
                              UINT16_C( 19536), UINT16_C( 20407), UINT16_C( 49821), UINT16_C( 38572),
                              UINT16_C( 33966), UINT16_C(  5536), UINT16_C(  2957), UINT16_C( 40605),
                              UINT16_C( 34358), UINT16_C( 27518), UINT16_C( 37193), UINT16_C( 53099),
                              UINT16_C( 32943), UINT16_C( 58363), UINT16_C( 17891), UINT16_C( 47747),
                              UINT16_C( 32073), UINT16_C( 23670), UINT16_C( 26266), UINT16_C( 19608),
                              UINT16_C( 15992), UINT16_C( 32180), UINT16_C( 12921), UINT16_C( 32481)) },
    { simde_x_mm512_set_epu16(UINT16_C( 60096), UINT16_C( 60141), UINT16_C(  1401), UINT16_C( 46103),
                              UINT16_C( 12472), UINT16_C( 53354), UINT16_C( 24302), UINT16_C( 31759),
                              UINT16_C( 31691), UINT16_C(  4110), UINT16_C( 33754), UINT16_C( 25522),
                              UINT16_C( 55741), UINT16_C( 54238), UINT16_C(  6937), UINT16_C( 14267),
                              UINT16_C(  6394), UINT16_C( 11471), UINT16_C( 36806), UINT16_C( 29444),
                              UINT16_C(  4686), UINT16_C( 24894), UINT16_C(  9912), UINT16_C( 55420),
                              UINT16_C( 39725), UINT16_C( 16932), UINT16_C(  1814), UINT16_C( 27150),
                              UINT16_C( 14089), UINT16_C( 26760), UINT16_C( 42881), UINT16_C(  1890)),
      simde_x_mm512_set_epu16(UINT16_C(  1052), UINT16_C( 45798), UINT16_C(  2128), UINT16_C( 35449),
                              UINT16_C( 36274), UINT16_C( 38472), UINT16_C( 30996), UINT16_C(  7411),
                              UINT16_C( 65433), UINT16_C( 20087), UINT16_C(  6070), UINT16_C( 34216),
                              UINT16_C( 38017), UINT16_C( 52174), UINT16_C(  6632), UINT16_C( 18268),
                              UINT16_C( 23199), UINT16_C( 50262), UINT16_C( 41833), UINT16_C( 43512),
                              UINT16_C( 43349), UINT16_C( 45458), UINT16_C( 19756), UINT16_C( 38464),
                              UINT16_C( 37153), UINT16_C( 41983), UINT16_C(  8534), UINT16_C(   930),
                              UINT16_C( 61899), UINT16_C(  3423), UINT16_C( 63286), UINT16_C( 18842)),
      simde_x_mm512_set_epu16(UINT16_C( 30574), UINT16_C( 52970), UINT16_C(  1765), UINT16_C( 40776),
                              UINT16_C( 24373), UINT16_C( 45913), UINT16_C( 27649), UINT16_C( 19585),
                              UINT16_C( 48562), UINT16_C( 12099), UINT16_C( 19912), UINT16_C( 29869),
                              UINT16_C( 46879), UINT16_C( 53206), UINT16_C(  6785), UINT16_C( 16268),
                              UINT16_C( 14797), UINT16_C( 30867), UINT16_C( 39320), UINT16_C( 36478),
                              UINT16_C( 24018), UINT16_C( 35176), UINT16_C( 14834), UINT16_C( 46942),
                              UINT16_C( 38439), UINT16_C( 29458), UINT16_C(  5174), UINT16_C( 14040),
                              UINT16_C( 37994), UINT16_C( 15092), UINT16_C( 53084), UINT16_C( 10366)) },
    { simde_x_mm512_set_epu16(UINT16_C( 21390), UINT16_C( 10972), UINT16_C(  9534), UINT16_C( 25326),
                              UINT16_C( 39196), UINT16_C( 52858), UINT16_C( 21878), UINT16_C( 44949),
                              UINT16_C( 56397), UINT16_C(  7489), UINT16_C( 51094), UINT16_C( 21965),
                              UINT16_C( 45995), UINT16_C( 12111), UINT16_C( 47805), UINT16_C(  1368),
                              UINT16_C( 47857), UINT16_C( 52094), UINT16_C( 29749), UINT16_C( 11216),
                              UINT16_C( 36270), UINT16_C( 43041), UINT16_C( 37100), UINT16_C( 23737),
                              UINT16_C( 49684), UINT16_C(  1618), UINT16_C(  4508), UINT16_C( 49414),
                              UINT16_C( 16652), UINT16_C( 21178), UINT16_C(  2342), UINT16_C( 41466)),
      simde_x_mm512_set_epu16(UINT16_C(  2029), UINT16_C( 56235), UINT16_C( 60520), UINT16_C( 21505),
                              UINT16_C( 57936), UINT16_C(  7393), UINT16_C( 48841), UINT16_C( 33423),
                              UINT16_C( 21974), UINT16_C( 41720), UINT16_C( 60540), UINT16_C( 41725),
                              UINT16_C( 29801), UINT16_C( 64766), UINT16_C( 10276), UINT16_C( 10419),
                              UINT16_C( 29113), UINT16_C(  9717), UINT16_C( 10502), UINT16_C( 53810),
                              UINT16_C( 21215), UINT16_C( 51746), UINT16_C( 31756), UINT16_C( 40043),
                              UINT16_C( 19421), UINT16_C( 27841), UINT16_C(  1136), UINT16_C( 29043),
                              UINT16_C( 64035), UINT16_C( 41226), UINT16_C( 38869), UINT16_C( 32769)),
      simde_x_mm512_set_epu16(UINT16_C( 11710), UINT16_C( 33604), UINT16_C( 35027), UINT16_C( 23416),
                              UINT16_C( 48566), UINT16_C( 30126), UINT16_C( 35360), UINT16_C( 39186),
                              UINT16_C( 39186), UINT16_C( 24605), UINT16_C( 55817), UINT16_C( 31845),
                              UINT16_C( 37898), UINT16_C( 38439), UINT16_C( 29041), UINT16_C(  5894),
                              UINT16_C( 38485), UINT16_C( 30906), UINT16_C( 20126), UINT16_C( 32513),
                              UINT16_C( 28743), UINT16_C( 47394), UINT16_C( 34428), UINT16_C( 31890),
                              UINT16_C( 34553), UINT16_C( 14730), UINT16_C(  2822), UINT16_C( 39229),
                              UINT16_C( 40344), UINT16_C( 31202), UINT16_C( 20606), UINT16_C( 37118)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_avg_epu16(test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_u16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_broadcastb_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m128i a;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm_set_epi8(INT8_C( -17), INT8_C(  88), INT8_C(-122), INT8_C(-119),
                        INT8_C( 111), INT8_C(  87), INT8_C( -76), INT8_C(  27),
                        INT8_C( -93), INT8_C(  -8), INT8_C( -17), INT8_C(  24),
                        INT8_C(  69), INT8_C( 116), INT8_C( -78), INT8_C(-124)),
      simde_mm512_set_epi8(INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124),
                           INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124),
                           INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124),
                           INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124),
                           INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124),
                           INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124),
                           INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124),
                           INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124),
                           INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124),
                           INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124),
                           INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124),
                           INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124),
                           INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124),
                           INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124),
                           INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124),
                           INT8_C(-124), INT8_C(-124), INT8_C(-124), INT8_C(-124)) },
    { simde_mm_set_epi8(INT8_C(  -5), INT8_C(-114), INT8_C( -86), INT8_C(  -2),
                        INT8_C(  33), INT8_C(  90), INT8_C( -50), INT8_C(  28),
                        INT8_C(  15), INT8_C(  12), INT8_C(  32), INT8_C(  54),
                        INT8_C( -15), INT8_C( -57), INT8_C(  36), INT8_C( -50)),
      simde_mm512_set_epi8(INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50)) },
    { simde_mm_set_epi8(INT8_C( -49), INT8_C( -76), INT8_C( -62), INT8_C( 118),
                        INT8_C(  -4), INT8_C( -25), INT8_C( -58), INT8_C( 126),
                        INT8_C(-115), INT8_C( 126), INT8_C(-104), INT8_C( 127),
                        INT8_C(  15), INT8_C(  41), INT8_C(  68), INT8_C(  31)),
      simde_mm512_set_epi8(INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31),
                           INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31),
                           INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31),
                           INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31),
                           INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31),
                           INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31),
                           INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31),
                           INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31),
                           INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31),
                           INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31),
                           INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31),
                           INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31),
                           INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31),
                           INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31),
                           INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31),
                           INT8_C(  31), INT8_C(  31), INT8_C(  31), INT8_C(  31)) },
    { simde_mm_set_epi8(INT8_C( -30), INT8_C( -23), INT8_C( -42), INT8_C( -27),
                        INT8_C(-102), INT8_C(  -5), INT8_C( -87), INT8_C(  98),
                        INT8_C(  33), INT8_C(  73), INT8_C( 125), INT8_C( 120),
                        INT8_C( -70), INT8_C(  59), INT8_C( 124), INT8_C(  46)),
      simde_mm512_set_epi8(INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46),
                           INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46),
                           INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46),
                           INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46),
                           INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46),
                           INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46),
                           INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46),
                           INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46),
                           INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46),
                           INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46),
                           INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46),
                           INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46),
                           INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46),
                           INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46),
                           INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46),
                           INT8_C(  46), INT8_C(  46), INT8_C(  46), INT8_C(  46)) },
    { simde_mm_set_epi8(INT8_C( -18), INT8_C(  28), INT8_C( -19), INT8_C( -73),
                        INT8_C( -19), INT8_C(  67), INT8_C(  79), INT8_C( -45),
                        INT8_C(-124), INT8_C(  80), INT8_C(-101), INT8_C(-122),
                        INT8_C( -54), INT8_C(  30), INT8_C( -16), INT8_C(  55)),
      simde_mm512_set_epi8(INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55)) },
    { simde_mm_set_epi8(INT8_C(   6), INT8_C(  -5), INT8_C(  37), INT8_C( -97),
                        INT8_C(  16), INT8_C(  -5), INT8_C( -18), INT8_C(  14),
                        INT8_C(-120), INT8_C( -59), INT8_C( -43), INT8_C( -97),
                        INT8_C( -71), INT8_C( -73), INT8_C( -73), INT8_C( -50)),
      simde_mm512_set_epi8(INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C( -50), INT8_C( -50), INT8_C( -50)) },
    { simde_mm_set_epi8(INT8_C( 119), INT8_C(  60), INT8_C(  63), INT8_C( -26),
                        INT8_C(  50), INT8_C(  56), INT8_C(  40), INT8_C(  -7),
                        INT8_C(  68), INT8_C( -11), INT8_C( -21), INT8_C( -77),
                        INT8_C(  56), INT8_C(-109), INT8_C(-118), INT8_C(-108)),
      simde_mm512_set_epi8(INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108),
                           INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108),
                           INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108),
                           INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108),
                           INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108),
                           INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108),
                           INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108),
                           INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108),
                           INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108),
                           INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108),
                           INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108),
                           INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108),
                           INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108),
                           INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108),
                           INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108),
                           INT8_C(-108), INT8_C(-108), INT8_C(-108), INT8_C(-108)) },
    { simde_mm_set_epi8(INT8_C(-112), INT8_C(  65), INT8_C(  26), INT8_C( -90),
                        INT8_C( -77), INT8_C(  72), INT8_C(   2), INT8_C(   4),
                        INT8_C( -52), INT8_C( -82), INT8_C( -18), INT8_C( -66),
                        INT8_C(-118), INT8_C( -10), INT8_C(  52), INT8_C( -40)),
      simde_mm512_set_epi8(INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40),
                           INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40),
                           INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40),
                           INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40),
                           INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40),
                           INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40),
                           INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40),
                           INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40),
                           INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40),
                           INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40),
                           INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40),
                           INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40),
                           INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40),
                           INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40),
                           INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40),
                           INT8_C( -40), INT8_C( -40), INT8_C( -40), INT8_C( -40)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_broadcastb_epi8(test_vec[i].a);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_mask_broadcastb_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i src;
    simde__mmask64 k;
    simde__m128i a;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C(  65), INT8_C( -68), INT8_C( 102), INT8_C(-122),
                           INT8_C(  40), INT8_C(  19), INT8_C(-111), INT8_C(   8),
                           INT8_C( -58), INT8_C(-120), INT8_C( 111), INT8_C(  10),
                           INT8_C( -54), INT8_C(-100), INT8_C(  36), INT8_C(  27),
                           INT8_C(-106), INT8_C(-123), INT8_C( 120), INT8_C(  43),
                           INT8_C( -31), INT8_C(   4), INT8_C(  10), INT8_C(  96),
                           INT8_C( -40), INT8_C(  23), INT8_C(  31), INT8_C(  73),
                           INT8_C( -51), INT8_C(  91), INT8_C(  68), INT8_C( -23),
                           INT8_C(-108), INT8_C(  52), INT8_C(  23), INT8_C( 115),
                           INT8_C(  -4), INT8_C(  24), INT8_C( 106), INT8_C( -92),
                           INT8_C( 126), INT8_C(  -6), INT8_C(  16), INT8_C( 102),
                           INT8_C( -47), INT8_C(-116), INT8_C(  -4), INT8_C(  33),
                           INT8_C( -25), INT8_C(-108), INT8_C(-115), INT8_C(-104),
                           INT8_C( -39), INT8_C(  49), INT8_C(  72), INT8_C(  44),
                           INT8_C( -17), INT8_C( -66), INT8_C( -61), INT8_C( -68),
                           INT8_C( 124), INT8_C(  20), INT8_C(  64), INT8_C( -49)),
      UINT64_C(          2970261907),
      simde_mm_set_epi8(INT8_C( -78), INT8_C( -60), INT8_C(-122), INT8_C( -66),
                        INT8_C(   8), INT8_C( -42), INT8_C(  44), INT8_C(  45),
                        INT8_C(  37), INT8_C(  -9), INT8_C( -14), INT8_C(  38),
                        INT8_C( -85), INT8_C(  35), INT8_C(   8), INT8_C(-127)),
      simde_mm512_set_epi8(INT8_C(  65), INT8_C( -68), INT8_C( 102), INT8_C(-122),
                           INT8_C(  40), INT8_C(  19), INT8_C(-111), INT8_C(   8),
                           INT8_C( -58), INT8_C(-120), INT8_C( 111), INT8_C(  10),
                           INT8_C( -54), INT8_C(-100), INT8_C(  36), INT8_C(  27),
                           INT8_C(-106), INT8_C(-123), INT8_C( 120), INT8_C(  43),
                           INT8_C( -31), INT8_C(   4), INT8_C(  10), INT8_C(  96),
                           INT8_C( -40), INT8_C(  23), INT8_C(  31), INT8_C(  73),
                           INT8_C( -51), INT8_C(  91), INT8_C(  68), INT8_C( -23),
                           INT8_C(-127), INT8_C(  52), INT8_C(-127), INT8_C(-127),
                           INT8_C(  -4), INT8_C(  24), INT8_C( 106), INT8_C(-127),
                           INT8_C( 126), INT8_C(  -6), INT8_C(  16), INT8_C( 102),
                           INT8_C(-127), INT8_C(-116), INT8_C(-127), INT8_C(  33),
                           INT8_C(-127), INT8_C(-108), INT8_C(-115), INT8_C(-127),
                           INT8_C(-127), INT8_C(  49), INT8_C(  72), INT8_C(-127),
                           INT8_C(-127), INT8_C( -66), INT8_C( -61), INT8_C(-127),
                           INT8_C( 124), INT8_C(  20), INT8_C(-127), INT8_C(-127)) },
    { simde_mm512_set_epi8(INT8_C( -76), INT8_C(  58), INT8_C(  70), INT8_C(-106),
                           INT8_C( 120), INT8_C(  72), INT8_C(  -4), INT8_C( -60),
                           INT8_C( 104), INT8_C( 101), INT8_C(  53), INT8_C(-121),
                           INT8_C( 102), INT8_C(-115), INT8_C(  90), INT8_C(  31),
                           INT8_C(  11), INT8_C(  68), INT8_C(  48), INT8_C(   4),
                           INT8_C(  55), INT8_C( -83), INT8_C(  75), INT8_C( -60),
                           INT8_C( -54), INT8_C(  57), INT8_C(  70), INT8_C(-114),
                           INT8_C(  51), INT8_C( -72), INT8_C( -71), INT8_C(  17),
                           INT8_C(  48), INT8_C(  40), INT8_C(-108), INT8_C( -12),
                           INT8_C( -11), INT8_C( -71), INT8_C(-114), INT8_C( -36),
                           INT8_C( -92), INT8_C( 101), INT8_C(  30), INT8_C(  10),
                           INT8_C(  43), INT8_C(-116), INT8_C( -45), INT8_C(-104),
                           INT8_C(  99), INT8_C( 108), INT8_C(  90), INT8_C(   7),
                           INT8_C( 112), INT8_C(  86), INT8_C(-125), INT8_C(  88),
                           INT8_C(  27), INT8_C(  40), INT8_C(  10), INT8_C(-105),
                           INT8_C(  76), INT8_C(-101), INT8_C(  87), INT8_C( 112)),
      UINT64_C(           458960523),
      simde_mm_set_epi8(INT8_C(  70), INT8_C( -73), INT8_C( -42), INT8_C( -19),
                        INT8_C( 110), INT8_C( -58), INT8_C(-117), INT8_C(-100),
                        INT8_C(  52), INT8_C( -63), INT8_C( -88), INT8_C( -55),
                        INT8_C(  90), INT8_C( -15), INT8_C( -11), INT8_C( -21)),
      simde_mm512_set_epi8(INT8_C( -76), INT8_C(  58), INT8_C(  70), INT8_C(-106),
                           INT8_C( 120), INT8_C(  72), INT8_C(  -4), INT8_C( -60),
                           INT8_C( 104), INT8_C( 101), INT8_C(  53), INT8_C(-121),
                           INT8_C( 102), INT8_C(-115), INT8_C(  90), INT8_C(  31),
                           INT8_C(  11), INT8_C(  68), INT8_C(  48), INT8_C(   4),
                           INT8_C(  55), INT8_C( -83), INT8_C(  75), INT8_C( -60),
                           INT8_C( -54), INT8_C(  57), INT8_C(  70), INT8_C(-114),
                           INT8_C(  51), INT8_C( -72), INT8_C( -71), INT8_C(  17),
                           INT8_C(  48), INT8_C(  40), INT8_C(-108), INT8_C( -21),
                           INT8_C( -21), INT8_C( -71), INT8_C( -21), INT8_C( -21),
                           INT8_C( -92), INT8_C( -21), INT8_C(  30), INT8_C( -21),
                           INT8_C( -21), INT8_C(-116), INT8_C( -21), INT8_C( -21),
                           INT8_C(  99), INT8_C( 108), INT8_C( -21), INT8_C(   7),
                           INT8_C( -21), INT8_C( -21), INT8_C( -21), INT8_C(  88),
                           INT8_C( -21), INT8_C(  40), INT8_C(  10), INT8_C(-105),
                           INT8_C( -21), INT8_C(-101), INT8_C( -21), INT8_C( -21)) },
    { simde_mm512_set_epi8(INT8_C( -65), INT8_C(  -9), INT8_C( -93), INT8_C(-113),
                           INT8_C( -10), INT8_C(  74), INT8_C(  39), INT8_C(  57),
                           INT8_C(  91), INT8_C( -48), INT8_C(  11), INT8_C( -15),
                           INT8_C(  21), INT8_C( -88), INT8_C(  91), INT8_C(  87),
                           INT8_C(-120), INT8_C(-105), INT8_C( -47), INT8_C(  85),
                           INT8_C( -98), INT8_C(  22), INT8_C(-124), INT8_C(-124),
                           INT8_C(   2), INT8_C(-104), INT8_C(  27), INT8_C(  96),
                           INT8_C( -89), INT8_C(  31), INT8_C(  20), INT8_C(  31),
                           INT8_C( -95), INT8_C(  13), INT8_C(  37), INT8_C(  31),
                           INT8_C( -72), INT8_C(  83), INT8_C(  94), INT8_C(  52),
                           INT8_C(  41), INT8_C(  25), INT8_C( -42), INT8_C(-109),
                           INT8_C(  31), INT8_C(  88), INT8_C( -71), INT8_C( -89),
                           INT8_C( 103), INT8_C( -85), INT8_C( -29), INT8_C(  86),
                           INT8_C(  71), INT8_C(  28), INT8_C( -23), INT8_C(  28),
                           INT8_C( -53), INT8_C( -82), INT8_C(  58), INT8_C( -12),
                           INT8_C(  63), INT8_C(  39), INT8_C( -32), INT8_C( -94)),
      UINT64_C(          1058428392),
      simde_mm_set_epi8(INT8_C(  85), INT8_C( -11), INT8_C( -21), INT8_C(  66),
                        INT8_C(  72), INT8_C(  -7), INT8_C( -18), INT8_C(-121),
                        INT8_C(  56), INT8_C(  51), INT8_C( 101), INT8_C(  91),
                        INT8_C( -85), INT8_C( -32), INT8_C( -40), INT8_C( -81)),
      simde_mm512_set_epi8(INT8_C( -65), INT8_C(  -9), INT8_C( -93), INT8_C(-113),
                           INT8_C( -10), INT8_C(  74), INT8_C(  39), INT8_C(  57),
                           INT8_C(  91), INT8_C( -48), INT8_C(  11), INT8_C( -15),
                           INT8_C(  21), INT8_C( -88), INT8_C(  91), INT8_C(  87),
                           INT8_C(-120), INT8_C(-105), INT8_C( -47), INT8_C(  85),
                           INT8_C( -98), INT8_C(  22), INT8_C(-124), INT8_C(-124),
                           INT8_C(   2), INT8_C(-104), INT8_C(  27), INT8_C(  96),
                           INT8_C( -89), INT8_C(  31), INT8_C(  20), INT8_C(  31),
                           INT8_C( -95), INT8_C(  13), INT8_C( -81), INT8_C( -81),
                           INT8_C( -81), INT8_C( -81), INT8_C( -81), INT8_C( -81),
                           INT8_C(  41), INT8_C(  25), INT8_C( -42), INT8_C( -81),
                           INT8_C(  31), INT8_C( -81), INT8_C( -81), INT8_C( -89),
                           INT8_C( 103), INT8_C( -81), INT8_C( -29), INT8_C( -81),
                           INT8_C(  71), INT8_C( -81), INT8_C( -23), INT8_C( -81),
                           INT8_C( -81), INT8_C( -81), INT8_C( -81), INT8_C( -12),
                           INT8_C( -81), INT8_C(  39), INT8_C( -32), INT8_C( -94)) },
    { simde_mm512_set_epi8(INT8_C(  85), INT8_C(  18), INT8_C(-117), INT8_C( -50),
                           INT8_C(  -8), INT8_C( 126), INT8_C( 103), INT8_C( -42),
                           INT8_C( 107), INT8_C( -60), INT8_C( -85), INT8_C( 123),
                           INT8_C( -11), INT8_C(  41), INT8_C(  98), INT8_C( 115),
                           INT8_C(  14), INT8_C(  34), INT8_C(  89), INT8_C( 101),
                           INT8_C(  39), INT8_C(  26), INT8_C( 121), INT8_C(  70),
                           INT8_C( -20), INT8_C( -34), INT8_C( -11), INT8_C(  72),
                           INT8_C(   8), INT8_C( -24), INT8_C(-104), INT8_C(  61),
                           INT8_C(-108), INT8_C( -43), INT8_C( 102), INT8_C( 100),
                           INT8_C( -29), INT8_C( -21), INT8_C(  70), INT8_C( -28),
                           INT8_C( -21), INT8_C( -82), INT8_C( -18), INT8_C(   9),
                           INT8_C(  94), INT8_C( -32), INT8_C(  97), INT8_C( -86),
                           INT8_C(  87), INT8_C(  62), INT8_C(-118), INT8_C(  17),
                           INT8_C(  18), INT8_C(-126), INT8_C(  74), INT8_C( -83),
                           INT8_C( -46), INT8_C(-103), INT8_C( -21), INT8_C( 108),
                           INT8_C( -58), INT8_C(-126), INT8_C( -28), INT8_C(-112)),
      UINT64_C(           923153287),
      simde_mm_set_epi8(INT8_C(  73), INT8_C( -73), INT8_C( -11), INT8_C(  36),
                        INT8_C( -17), INT8_C(  70), INT8_C(-102), INT8_C(-111),
                        INT8_C(  27), INT8_C( -97), INT8_C(  -6), INT8_C(  -7),
                        INT8_C(  28), INT8_C( -52), INT8_C( -54), INT8_C( -50)),
      simde_mm512_set_epi8(INT8_C(  85), INT8_C(  18), INT8_C(-117), INT8_C( -50),
                           INT8_C(  -8), INT8_C( 126), INT8_C( 103), INT8_C( -42),
                           INT8_C( 107), INT8_C( -60), INT8_C( -85), INT8_C( 123),
                           INT8_C( -11), INT8_C(  41), INT8_C(  98), INT8_C( 115),
                           INT8_C(  14), INT8_C(  34), INT8_C(  89), INT8_C( 101),
                           INT8_C(  39), INT8_C(  26), INT8_C( 121), INT8_C(  70),
                           INT8_C( -20), INT8_C( -34), INT8_C( -11), INT8_C(  72),
                           INT8_C(   8), INT8_C( -24), INT8_C(-104), INT8_C(  61),
                           INT8_C(-108), INT8_C( -43), INT8_C( -50), INT8_C( -50),
                           INT8_C( -29), INT8_C( -50), INT8_C( -50), INT8_C( -50),
                           INT8_C( -21), INT8_C( -82), INT8_C( -18), INT8_C(   9),
                           INT8_C(  94), INT8_C( -50), INT8_C( -50), INT8_C( -86),
                           INT8_C(  87), INT8_C(  62), INT8_C( -50), INT8_C( -50),
                           INT8_C(  18), INT8_C(-126), INT8_C( -50), INT8_C( -50),
                           INT8_C( -50), INT8_C(-103), INT8_C( -21), INT8_C( 108),
                           INT8_C( -58), INT8_C( -50), INT8_C( -50), INT8_C( -50)) },
    { simde_mm512_set_epi8(INT8_C(  67), INT8_C(-107), INT8_C(  82), INT8_C(  55),
                           INT8_C(  64), INT8_C(  72), INT8_C( -53), INT8_C(  66),
                           INT8_C( -50), INT8_C( 103), INT8_C( -13), INT8_C(  78),
                           INT8_C(  15), INT8_C(  32), INT8_C(  76), INT8_C(  78),
                           INT8_C(  28), INT8_C( -98), INT8_C(-128), INT8_C(  80),
                           INT8_C( 106), INT8_C( -45), INT8_C(  79), INT8_C( 116),
                           INT8_C(  23), INT8_C(  31), INT8_C( 117), INT8_C( -12),
                           INT8_C( -59), INT8_C( -16), INT8_C(  98), INT8_C( -49),
                           INT8_C( 116), INT8_C( -82), INT8_C(  92), INT8_C(   1),
                           INT8_C(  30), INT8_C(-100), INT8_C(  61), INT8_C( -14),
                           INT8_C(  26), INT8_C( -40), INT8_C( -78), INT8_C( -85),
                           INT8_C( -24), INT8_C( -47), INT8_C( -93), INT8_C(  -1),
                           INT8_C(  21), INT8_C(  82), INT8_C( 119), INT8_C(  64),
                           INT8_C(  74), INT8_C( -53), INT8_C(  58), INT8_C(  33),
                           INT8_C(  14), INT8_C( 114), INT8_C(  35), INT8_C( 109),
                           INT8_C( -74), INT8_C( -59), INT8_C( -81), INT8_C(  16)),
      UINT64_C(           594368556),
      simde_mm_set_epi8(INT8_C(  26), INT8_C( -78), INT8_C(  32), INT8_C(  10),
                        INT8_C(-126), INT8_C(  64), INT8_C(  35), INT8_C( -54),
                        INT8_C( -42), INT8_C( -70), INT8_C( 114), INT8_C( 111),
                        INT8_C( 111), INT8_C(  11), INT8_C( 104), INT8_C(  39)),
      simde_mm512_set_epi8(INT8_C(  67), INT8_C(-107), INT8_C(  82), INT8_C(  55),
                           INT8_C(  64), INT8_C(  72), INT8_C( -53), INT8_C(  66),
                           INT8_C( -50), INT8_C( 103), INT8_C( -13), INT8_C(  78),
                           INT8_C(  15), INT8_C(  32), INT8_C(  76), INT8_C(  78),
                           INT8_C(  28), INT8_C( -98), INT8_C(-128), INT8_C(  80),
                           INT8_C( 106), INT8_C( -45), INT8_C(  79), INT8_C( 116),
                           INT8_C(  23), INT8_C(  31), INT8_C( 117), INT8_C( -12),
                           INT8_C( -59), INT8_C( -16), INT8_C(  98), INT8_C( -49),
                           INT8_C( 116), INT8_C( -82), INT8_C(  39), INT8_C(   1),
                           INT8_C(  30), INT8_C(-100), INT8_C(  39), INT8_C(  39),
                           INT8_C(  26), INT8_C(  39), INT8_C(  39), INT8_C( -85),
                           INT8_C(  39), INT8_C(  39), INT8_C( -93), INT8_C(  39),
                           INT8_C(  21), INT8_C(  39), INT8_C( 119), INT8_C(  39),
                           INT8_C(  39), INT8_C( -53), INT8_C(  58), INT8_C(  33),
                           INT8_C(  14), INT8_C( 114), INT8_C(  39), INT8_C( 109),
                           INT8_C(  39), INT8_C(  39), INT8_C( -81), INT8_C(  16)) },
    { simde_mm512_set_epi8(INT8_C( 124), INT8_C(  71), INT8_C(-128), INT8_C( 110),
                           INT8_C(-123), INT8_C( -14), INT8_C( 123), INT8_C( -42),
                           INT8_C(  94), INT8_C(  60), INT8_C( 116), INT8_C( -89),
                           INT8_C(  73), INT8_C( -61), INT8_C(  -3), INT8_C(-114),
                           INT8_C( -92), INT8_C( -78), INT8_C(  90), INT8_C(  44),
                           INT8_C( -84), INT8_C( -33), INT8_C( 116), INT8_C(  -6),
                           INT8_C( -44), INT8_C( 126), INT8_C( -26), INT8_C(  80),
                           INT8_C( -91), INT8_C(-125), INT8_C(  72), INT8_C(  -8),
                           INT8_C( -16), INT8_C(  95), INT8_C( -25), INT8_C( -16),
                           INT8_C( -52), INT8_C( 116), INT8_C( -23), INT8_C(-102),
                           INT8_C( 119), INT8_C( -76), INT8_C(  48), INT8_C(  26),
                           INT8_C(-128), INT8_C(  43), INT8_C(  99), INT8_C( -34),
                           INT8_C(-103), INT8_C( -40), INT8_C(  47), INT8_C(-112),
                           INT8_C(-117), INT8_C( 111), INT8_C(-126), INT8_C(-115),
                           INT8_C(  65), INT8_C( -55), INT8_C(  49), INT8_C(  37),
                           INT8_C(-110), INT8_C(-124), INT8_C( 126), INT8_C(  -2)),
      UINT64_C(          1610616610),
      simde_mm_set_epi8(INT8_C( -95), INT8_C(  29), INT8_C( -58), INT8_C( -87),
                        INT8_C(  73), INT8_C(  12), INT8_C( -29), INT8_C(  41),
                        INT8_C( -96), INT8_C( 122), INT8_C( -95), INT8_C( -33),
                        INT8_C(-128), INT8_C(   2), INT8_C( 115), INT8_C( 108)),
      simde_mm512_set_epi8(INT8_C( 124), INT8_C(  71), INT8_C(-128), INT8_C( 110),
                           INT8_C(-123), INT8_C( -14), INT8_C( 123), INT8_C( -42),
                           INT8_C(  94), INT8_C(  60), INT8_C( 116), INT8_C( -89),
                           INT8_C(  73), INT8_C( -61), INT8_C(  -3), INT8_C(-114),
                           INT8_C( -92), INT8_C( -78), INT8_C(  90), INT8_C(  44),
                           INT8_C( -84), INT8_C( -33), INT8_C( 116), INT8_C(  -6),
                           INT8_C( -44), INT8_C( 126), INT8_C( -26), INT8_C(  80),
                           INT8_C( -91), INT8_C(-125), INT8_C(  72), INT8_C(  -8),
                           INT8_C( -16), INT8_C( 108), INT8_C( 108), INT8_C( -16),
                           INT8_C( -52), INT8_C( 116), INT8_C( -23), INT8_C(-102),
                           INT8_C( 119), INT8_C( -76), INT8_C(  48), INT8_C(  26),
                           INT8_C(-128), INT8_C(  43), INT8_C(  99), INT8_C( -34),
                           INT8_C(-103), INT8_C( -40), INT8_C(  47), INT8_C(-112),
                           INT8_C( 108), INT8_C( 108), INT8_C( 108), INT8_C( 108),
                           INT8_C(  65), INT8_C( -55), INT8_C( 108), INT8_C(  37),
                           INT8_C(-110), INT8_C(-124), INT8_C( 108), INT8_C(  -2)) },
    { simde_mm512_set_epi8(INT8_C(  73), INT8_C( -95), INT8_C( -44), INT8_C( 123),
                           INT8_C( -34), INT8_C(-122), INT8_C( 105), INT8_C( -63),
                           INT8_C( -13), INT8_C( -78), INT8_C(  -7), INT8_C(  88),
                           INT8_C(-101), INT8_C(  60), INT8_C(  29), INT8_C( -15),
                           INT8_C(  87), INT8_C( -77), INT8_C(  65), INT8_C(  71),
                           INT8_C( 113), INT8_C(-124), INT8_C( -41), INT8_C( -18),
                           INT8_C(  37), INT8_C( -20), INT8_C( 112), INT8_C(  70),
                           INT8_C(  36), INT8_C( -80), INT8_C( 122), INT8_C( -28),
                           INT8_C( -45), INT8_C(-113), INT8_C(  68), INT8_C(  23),
                           INT8_C(  84), INT8_C(  56), INT8_C( -44), INT8_C( -61),
                           INT8_C( -78), INT8_C(   6), INT8_C(-108), INT8_C(  73),
                           INT8_C( -22), INT8_C( -71), INT8_C(   1), INT8_C(   7),
                           INT8_C(  47), INT8_C(  18), INT8_C(-127), INT8_C( 127),
                           INT8_C( -16), INT8_C( -48), INT8_C( -39), INT8_C( 106),
                           INT8_C(  27), INT8_C(  40), INT8_C( -58), INT8_C( -56),
                           INT8_C( -27), INT8_C(  17), INT8_C(  29), INT8_C( -46)),
      UINT64_C(          2168160586),
      simde_mm_set_epi8(INT8_C(  45), INT8_C(  89), INT8_C( -40), INT8_C(  94),
                        INT8_C( -55), INT8_C( -34), INT8_C(-119), INT8_C(-109),
                        INT8_C(   3), INT8_C(-117), INT8_C(-101), INT8_C(  63),
                        INT8_C( 122), INT8_C(  -4), INT8_C(-100), INT8_C( -84)),
      simde_mm512_set_epi8(INT8_C(  73), INT8_C( -95), INT8_C( -44), INT8_C( 123),
                           INT8_C( -34), INT8_C(-122), INT8_C( 105), INT8_C( -63),
                           INT8_C( -13), INT8_C( -78), INT8_C(  -7), INT8_C(  88),
                           INT8_C(-101), INT8_C(  60), INT8_C(  29), INT8_C( -15),
                           INT8_C(  87), INT8_C( -77), INT8_C(  65), INT8_C(  71),
                           INT8_C( 113), INT8_C(-124), INT8_C( -41), INT8_C( -18),
                           INT8_C(  37), INT8_C( -20), INT8_C( 112), INT8_C(  70),
                           INT8_C(  36), INT8_C( -80), INT8_C( 122), INT8_C( -28),
                           INT8_C( -84), INT8_C(-113), INT8_C(  68), INT8_C(  23),
                           INT8_C(  84), INT8_C(  56), INT8_C( -44), INT8_C( -84),
                           INT8_C( -78), INT8_C(   6), INT8_C( -84), INT8_C( -84),
                           INT8_C( -84), INT8_C( -71), INT8_C( -84), INT8_C( -84),
                           INT8_C( -84), INT8_C(  18), INT8_C(-127), INT8_C( 127),
                           INT8_C( -16), INT8_C( -48), INT8_C( -39), INT8_C( -84),
                           INT8_C(  27), INT8_C( -84), INT8_C( -58), INT8_C( -56),
                           INT8_C( -84), INT8_C(  17), INT8_C( -84), INT8_C( -46)) },
    { simde_mm512_set_epi8(INT8_C(  38), INT8_C( -12), INT8_C( -37), INT8_C(  58),
                           INT8_C(  89), INT8_C(-127), INT8_C( -11), INT8_C(  26),
                           INT8_C( -29), INT8_C(-122), INT8_C(  86), INT8_C(  69),
                           INT8_C(  63), INT8_C(  74), INT8_C(  90), INT8_C(  88),
                           INT8_C( -75), INT8_C( -43), INT8_C(  36), INT8_C(  61),
                           INT8_C( -19), INT8_C(  27), INT8_C(-123), INT8_C(  78),
                           INT8_C(  67), INT8_C(  58), INT8_C( -32), INT8_C(  42),
                           INT8_C(  25), INT8_C( -26), INT8_C( 122), INT8_C(-100),
                           INT8_C(-107), INT8_C( -53), INT8_C(-114), INT8_C(  63),
                           INT8_C(-100), INT8_C(  53), INT8_C( -32), INT8_C( -39),
                           INT8_C( -75), INT8_C(-119), INT8_C( -67), INT8_C(  96),
                           INT8_C(  -6), INT8_C( -22), INT8_C( -12), INT8_C(  19),
                           INT8_C( -51), INT8_C(  42), INT8_C(  39), INT8_C(-124),
                           INT8_C(  38), INT8_C( -95), INT8_C(-119), INT8_C(  -9),
                           INT8_C(  94), INT8_C( -51), INT8_C(   1), INT8_C( -64),
                           INT8_C( -67), INT8_C(-127), INT8_C( -33), INT8_C(  75)),
      UINT64_C(          3579095368),
      simde_mm_set_epi8(INT8_C( -71), INT8_C(-112), INT8_C(-122), INT8_C( -13),
                        INT8_C(-109), INT8_C(  21), INT8_C(  27), INT8_C(-109),
                        INT8_C(  55), INT8_C(   9), INT8_C( 117), INT8_C( -28),
                        INT8_C( -58), INT8_C(  -1), INT8_C(   3), INT8_C( -34)),
      simde_mm512_set_epi8(INT8_C(  38), INT8_C( -12), INT8_C( -37), INT8_C(  58),
                           INT8_C(  89), INT8_C(-127), INT8_C( -11), INT8_C(  26),
                           INT8_C( -29), INT8_C(-122), INT8_C(  86), INT8_C(  69),
                           INT8_C(  63), INT8_C(  74), INT8_C(  90), INT8_C(  88),
                           INT8_C( -75), INT8_C( -43), INT8_C(  36), INT8_C(  61),
                           INT8_C( -19), INT8_C(  27), INT8_C(-123), INT8_C(  78),
                           INT8_C(  67), INT8_C(  58), INT8_C( -32), INT8_C(  42),
                           INT8_C(  25), INT8_C( -26), INT8_C( 122), INT8_C(-100),
                           INT8_C( -34), INT8_C( -34), INT8_C(-114), INT8_C( -34),
                           INT8_C(-100), INT8_C( -34), INT8_C( -32), INT8_C( -34),
                           INT8_C( -75), INT8_C( -34), INT8_C( -67), INT8_C( -34),
                           INT8_C(  -6), INT8_C( -34), INT8_C( -12), INT8_C(  19),
                           INT8_C( -34), INT8_C(  42), INT8_C( -34), INT8_C(-124),
                           INT8_C( -34), INT8_C( -95), INT8_C(-119), INT8_C( -34),
                           INT8_C(  94), INT8_C( -34), INT8_C(   1), INT8_C( -64),
                           INT8_C( -34), INT8_C(-127), INT8_C( -33), INT8_C(  75)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_mask_broadcastb_epi8(test_vec[i].src, test_vec[i].k, test_vec[i].a);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_maskz_broadcastb_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__mmask64 k;
    simde__m128i a;
    simde__m512i r;
  } test_vec[8] = {
    { UINT64_C(          2081702095),
      simde_mm_set_epi8(INT8_C( 126), INT8_C(  -6), INT8_C(  16), INT8_C( 102),
                        INT8_C( -47), INT8_C(-116), INT8_C(  -4), INT8_C(  33),
                        INT8_C( -25), INT8_C(-108), INT8_C(-115), INT8_C(-104),
                        INT8_C( -39), INT8_C(  49), INT8_C(  72), INT8_C(  44)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  44), INT8_C(  44), INT8_C(  44),
                           INT8_C(  44), INT8_C(  44), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  44),
                           INT8_C(   0), INT8_C(  44), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  44), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  44), INT8_C(  44), INT8_C(   0), INT8_C(   0),
                           INT8_C(  44), INT8_C(  44), INT8_C(  44), INT8_C(  44)) },
    { UINT64_C(          4229458596),
      simde_mm_set_epi8(INT8_C(-106), INT8_C(-123), INT8_C( 120), INT8_C(  43),
                        INT8_C( -31), INT8_C(   4), INT8_C(  10), INT8_C(  96),
                        INT8_C( -40), INT8_C(  23), INT8_C(  31), INT8_C(  73),
                        INT8_C( -51), INT8_C(  91), INT8_C(  68), INT8_C( -23)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -23), INT8_C( -23), INT8_C( -23), INT8_C( -23),
                           INT8_C( -23), INT8_C( -23), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -23),
                           INT8_C( -23), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -23), INT8_C( -23), INT8_C(   0),
                           INT8_C( -23), INT8_C(   0), INT8_C( -23), INT8_C(   0),
                           INT8_C( -23), INT8_C(   0), INT8_C( -23), INT8_C(   0),
                           INT8_C(   0), INT8_C( -23), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C(          3399230491),
      simde_mm_set_epi8(INT8_C( -40), INT8_C( -29), INT8_C(  78), INT8_C(  94),
                        INT8_C( -79), INT8_C(  10), INT8_C(-103), INT8_C(-109),
                        INT8_C(  65), INT8_C( -68), INT8_C( 102), INT8_C(-122),
                        INT8_C(  40), INT8_C(  19), INT8_C(-111), INT8_C(   8)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   8), INT8_C(   8), INT8_C(   0), INT8_C(   0),
                           INT8_C(   8), INT8_C(   0), INT8_C(   8), INT8_C(   0),
                           INT8_C(   8), INT8_C(   0), INT8_C(   0), INT8_C(   8),
                           INT8_C(   8), INT8_C(   8), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   8), INT8_C(   0),
                           INT8_C(   0), INT8_C(   8), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   8),
                           INT8_C(   8), INT8_C(   0), INT8_C(   8), INT8_C(   8)) },
    { UINT64_C(          2871199873),
      simde_mm_set_epi8(INT8_C(  27), INT8_C(  40), INT8_C(  10), INT8_C(-105),
                        INT8_C(  76), INT8_C(-101), INT8_C(  87), INT8_C( 112),
                        INT8_C( -78), INT8_C( -60), INT8_C(-122), INT8_C( -66),
                        INT8_C(   8), INT8_C( -42), INT8_C(  44), INT8_C(  45)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  45), INT8_C(   0), INT8_C(  45), INT8_C(   0),
                           INT8_C(  45), INT8_C(   0), INT8_C(  45), INT8_C(  45),
                           INT8_C(   0), INT8_C(   0), INT8_C(  45), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  45), INT8_C(  45),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  45), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  45), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  45)) },
    { UINT64_C(          1884717912),
      simde_mm_set_epi8(INT8_C(  48), INT8_C(  40), INT8_C(-108), INT8_C( -12),
                        INT8_C( -11), INT8_C( -71), INT8_C(-114), INT8_C( -36),
                        INT8_C( -92), INT8_C( 101), INT8_C(  30), INT8_C(  10),
                        INT8_C(  43), INT8_C(-116), INT8_C( -45), INT8_C(-104)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-104), INT8_C(-104), INT8_C(-104),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-104), INT8_C(   0), INT8_C(-104),
                           INT8_C(   0), INT8_C(-104), INT8_C(-104), INT8_C(   0),
                           INT8_C(-104), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(-104), INT8_C(-104),
                           INT8_C(   0), INT8_C(-104), INT8_C(   0), INT8_C(-104),
                           INT8_C(-104), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C(           867744017),
      simde_mm_set_epi8(INT8_C( 104), INT8_C( 101), INT8_C(  53), INT8_C(-121),
                        INT8_C( 102), INT8_C(-115), INT8_C(  90), INT8_C(  31),
                        INT8_C(  11), INT8_C(  68), INT8_C(  48), INT8_C(   4),
                        INT8_C(  55), INT8_C( -83), INT8_C(  75), INT8_C( -60)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -60), INT8_C( -60),
                           INT8_C(   0), INT8_C(   0), INT8_C( -60), INT8_C( -60),
                           INT8_C( -60), INT8_C(   0), INT8_C( -60), INT8_C( -60),
                           INT8_C( -60), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -60), INT8_C(   0), INT8_C( -60), INT8_C( -60),
                           INT8_C( -60), INT8_C(   0), INT8_C(   0), INT8_C( -60),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -60),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -60)) },
    { UINT64_C(          2018049220),
      simde_mm_set_epi8(INT8_C(  52), INT8_C( -63), INT8_C( -88), INT8_C( -55),
                        INT8_C(  90), INT8_C( -15), INT8_C( -11), INT8_C( -21),
                        INT8_C( 100), INT8_C( -84), INT8_C( -92), INT8_C( -78),
                        INT8_C(  27), INT8_C(  91), INT8_C(  46), INT8_C(-117)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-117), INT8_C(-117), INT8_C(-117),
                           INT8_C(-117), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-117), INT8_C(   0), INT8_C(   0),
                           INT8_C(-117), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(-117), INT8_C(-117), INT8_C(-117), INT8_C(-117),
                           INT8_C(-117), INT8_C(-117), INT8_C(   0), INT8_C(   0),
                           INT8_C(-117), INT8_C(-117), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-117), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C(          1858505628),
      simde_mm_set_epi8(INT8_C( 103), INT8_C( -85), INT8_C( -29), INT8_C(  86),
                        INT8_C(  71), INT8_C(  28), INT8_C( -23), INT8_C(  28),
                        INT8_C( -53), INT8_C( -82), INT8_C(  58), INT8_C( -12),
                        INT8_C(  63), INT8_C(  39), INT8_C( -32), INT8_C( -94)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -94), INT8_C( -94), INT8_C(   0),
                           INT8_C( -94), INT8_C( -94), INT8_C( -94), INT8_C(   0),
                           INT8_C( -94), INT8_C( -94), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -94), INT8_C( -94), INT8_C(   0),
                           INT8_C( -94), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -94), INT8_C(   0), INT8_C( -94), INT8_C( -94),
                           INT8_C( -94), INT8_C(   0), INT8_C(   0), INT8_C( -94),
                           INT8_C( -94), INT8_C( -94), INT8_C(   0), INT8_C(   0)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_maskz_broadcastb_epi8(test_vec[i].k, test_vec[i].a);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_broadcastw_epi16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m128i a;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm_set_epi16(INT16_C( -4264), INT16_C(-31095), INT16_C( 28503), INT16_C(-19429),
                         INT16_C(-23560), INT16_C( -4328), INT16_C( 17780), INT16_C(-19836)),
      simde_mm512_set_epi16(INT16_C(-19836), INT16_C(-19836), INT16_C(-19836), INT16_C(-19836),
                            INT16_C(-19836), INT16_C(-19836), INT16_C(-19836), INT16_C(-19836),
                            INT16_C(-19836), INT16_C(-19836), INT16_C(-19836), INT16_C(-19836),
                            INT16_C(-19836), INT16_C(-19836), INT16_C(-19836), INT16_C(-19836),
                            INT16_C(-19836), INT16_C(-19836), INT16_C(-19836), INT16_C(-19836),
                            INT16_C(-19836), INT16_C(-19836), INT16_C(-19836), INT16_C(-19836),
                            INT16_C(-19836), INT16_C(-19836), INT16_C(-19836), INT16_C(-19836),
                            INT16_C(-19836), INT16_C(-19836), INT16_C(-19836), INT16_C(-19836)) },
    { simde_mm_set_epi16(INT16_C( -1138), INT16_C(-21762), INT16_C(  8538), INT16_C(-12772),
                         INT16_C(  3852), INT16_C(  8246), INT16_C( -3641), INT16_C(  9422)),
      simde_mm512_set_epi16(INT16_C(  9422), INT16_C(  9422), INT16_C(  9422), INT16_C(  9422),
                            INT16_C(  9422), INT16_C(  9422), INT16_C(  9422), INT16_C(  9422),
                            INT16_C(  9422), INT16_C(  9422), INT16_C(  9422), INT16_C(  9422),
                            INT16_C(  9422), INT16_C(  9422), INT16_C(  9422), INT16_C(  9422),
                            INT16_C(  9422), INT16_C(  9422), INT16_C(  9422), INT16_C(  9422),
                            INT16_C(  9422), INT16_C(  9422), INT16_C(  9422), INT16_C(  9422),
                            INT16_C(  9422), INT16_C(  9422), INT16_C(  9422), INT16_C(  9422),
                            INT16_C(  9422), INT16_C(  9422), INT16_C(  9422), INT16_C(  9422)) },
    { simde_mm_set_epi16(INT16_C(-12364), INT16_C(-15754), INT16_C(  -793), INT16_C(-14722),
                         INT16_C(-29314), INT16_C(-26497), INT16_C(  3881), INT16_C( 17439)),
      simde_mm512_set_epi16(INT16_C( 17439), INT16_C( 17439), INT16_C( 17439), INT16_C( 17439),
                            INT16_C( 17439), INT16_C( 17439), INT16_C( 17439), INT16_C( 17439),
                            INT16_C( 17439), INT16_C( 17439), INT16_C( 17439), INT16_C( 17439),
                            INT16_C( 17439), INT16_C( 17439), INT16_C( 17439), INT16_C( 17439),
                            INT16_C( 17439), INT16_C( 17439), INT16_C( 17439), INT16_C( 17439),
                            INT16_C( 17439), INT16_C( 17439), INT16_C( 17439), INT16_C( 17439),
                            INT16_C( 17439), INT16_C( 17439), INT16_C( 17439), INT16_C( 17439),
                            INT16_C( 17439), INT16_C( 17439), INT16_C( 17439), INT16_C( 17439)) },
    { simde_mm_set_epi16(INT16_C( -7447), INT16_C(-10523), INT16_C(-25861), INT16_C(-22174),
                         INT16_C(  8521), INT16_C( 32120), INT16_C(-17861), INT16_C( 31790)),
      simde_mm512_set_epi16(INT16_C( 31790), INT16_C( 31790), INT16_C( 31790), INT16_C( 31790),
                            INT16_C( 31790), INT16_C( 31790), INT16_C( 31790), INT16_C( 31790),
                            INT16_C( 31790), INT16_C( 31790), INT16_C( 31790), INT16_C( 31790),
                            INT16_C( 31790), INT16_C( 31790), INT16_C( 31790), INT16_C( 31790),
                            INT16_C( 31790), INT16_C( 31790), INT16_C( 31790), INT16_C( 31790),
                            INT16_C( 31790), INT16_C( 31790), INT16_C( 31790), INT16_C( 31790),
                            INT16_C( 31790), INT16_C( 31790), INT16_C( 31790), INT16_C( 31790),
                            INT16_C( 31790), INT16_C( 31790), INT16_C( 31790), INT16_C( 31790)) },
    { simde_mm_set_epi16(INT16_C( -4580), INT16_C( -4681), INT16_C( -4797), INT16_C( 20435),
                         INT16_C(-31664), INT16_C(-25722), INT16_C(-13794), INT16_C( -4041)),
      simde_mm512_set_epi16(INT16_C( -4041), INT16_C( -4041), INT16_C( -4041), INT16_C( -4041),
                            INT16_C( -4041), INT16_C( -4041), INT16_C( -4041), INT16_C( -4041),
                            INT16_C( -4041), INT16_C( -4041), INT16_C( -4041), INT16_C( -4041),
                            INT16_C( -4041), INT16_C( -4041), INT16_C( -4041), INT16_C( -4041),
                            INT16_C( -4041), INT16_C( -4041), INT16_C( -4041), INT16_C( -4041),
                            INT16_C( -4041), INT16_C( -4041), INT16_C( -4041), INT16_C( -4041),
                            INT16_C( -4041), INT16_C( -4041), INT16_C( -4041), INT16_C( -4041),
                            INT16_C( -4041), INT16_C( -4041), INT16_C( -4041), INT16_C( -4041)) },
    { simde_mm_set_epi16(INT16_C(  1787), INT16_C(  9631), INT16_C(  4347), INT16_C( -4594),
                         INT16_C(-30523), INT16_C(-10849), INT16_C(-17993), INT16_C(-18482)),
      simde_mm512_set_epi16(INT16_C(-18482), INT16_C(-18482), INT16_C(-18482), INT16_C(-18482),
                            INT16_C(-18482), INT16_C(-18482), INT16_C(-18482), INT16_C(-18482),
                            INT16_C(-18482), INT16_C(-18482), INT16_C(-18482), INT16_C(-18482),
                            INT16_C(-18482), INT16_C(-18482), INT16_C(-18482), INT16_C(-18482),
                            INT16_C(-18482), INT16_C(-18482), INT16_C(-18482), INT16_C(-18482),
                            INT16_C(-18482), INT16_C(-18482), INT16_C(-18482), INT16_C(-18482),
                            INT16_C(-18482), INT16_C(-18482), INT16_C(-18482), INT16_C(-18482),
                            INT16_C(-18482), INT16_C(-18482), INT16_C(-18482), INT16_C(-18482)) },
    { simde_mm_set_epi16(INT16_C( 30524), INT16_C( 16358), INT16_C( 12856), INT16_C( 10489),
                         INT16_C( 17653), INT16_C( -5197), INT16_C( 14483), INT16_C(-30060)),
      simde_mm512_set_epi16(INT16_C(-30060), INT16_C(-30060), INT16_C(-30060), INT16_C(-30060),
                            INT16_C(-30060), INT16_C(-30060), INT16_C(-30060), INT16_C(-30060),
                            INT16_C(-30060), INT16_C(-30060), INT16_C(-30060), INT16_C(-30060),
                            INT16_C(-30060), INT16_C(-30060), INT16_C(-30060), INT16_C(-30060),
                            INT16_C(-30060), INT16_C(-30060), INT16_C(-30060), INT16_C(-30060),
                            INT16_C(-30060), INT16_C(-30060), INT16_C(-30060), INT16_C(-30060),
                            INT16_C(-30060), INT16_C(-30060), INT16_C(-30060), INT16_C(-30060),
                            INT16_C(-30060), INT16_C(-30060), INT16_C(-30060), INT16_C(-30060)) },
    { simde_mm_set_epi16(INT16_C(-28607), INT16_C(  6822), INT16_C(-19640), INT16_C(   516),
                         INT16_C(-13138), INT16_C( -4418), INT16_C(-29962), INT16_C( 13528)),
      simde_mm512_set_epi16(INT16_C( 13528), INT16_C( 13528), INT16_C( 13528), INT16_C( 13528),
                            INT16_C( 13528), INT16_C( 13528), INT16_C( 13528), INT16_C( 13528),
                            INT16_C( 13528), INT16_C( 13528), INT16_C( 13528), INT16_C( 13528),
                            INT16_C( 13528), INT16_C( 13528), INT16_C( 13528), INT16_C( 13528),
                            INT16_C( 13528), INT16_C( 13528), INT16_C( 13528), INT16_C( 13528),
                            INT16_C( 13528), INT16_C( 13528), INT16_C( 13528), INT16_C( 13528),
                            INT16_C( 13528), INT16_C( 13528), INT16_C( 13528), INT16_C( 13528),
                            INT16_C( 13528), INT16_C( 13528), INT16_C( 13528), INT16_C( 13528)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_broadcastw_epi16(test_vec[i].a);
    simde_assert_m512i_i16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_shuffle_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C(  56), INT8_C( -94), INT8_C( -41), INT8_C( -59),
                           INT8_C(  40), INT8_C(  78), INT8_C(  93), INT8_C( 107),
                           INT8_C( -47), INT8_C(  66), INT8_C(  -8), INT8_C( -52),
                           INT8_C(  50), INT8_C(  78), INT8_C(  13), INT8_C(  26),
                           INT8_C( -33), INT8_C( 120), INT8_C(  67), INT8_C( -12),
                           INT8_C(  80), INT8_C(  88), INT8_C( -65), INT8_C(  49),
                           INT8_C(  28), INT8_C(  96), INT8_C( -99), INT8_C(-119),
                           INT8_C( 126), INT8_C(  24), INT8_C(  35), INT8_C(  11),
                           INT8_C( -43), INT8_C( -24), INT8_C(   1), INT8_C( -61),
                           INT8_C( 101), INT8_C(   5), INT8_C(  67), INT8_C( -42),
                           INT8_C( -46), INT8_C(-115), INT8_C(-105), INT8_C( -92),
                           INT8_C(  -3), INT8_C( -44), INT8_C(  13), INT8_C( -36),
                           INT8_C( 110), INT8_C( -38), INT8_C( -48), INT8_C(  36),
                           INT8_C( 117), INT8_C( -59), INT8_C( 109), INT8_C( -27),
                           INT8_C( -62), INT8_C(  98), INT8_C(-121), INT8_C(-108),
                           INT8_C(  -7), INT8_C(-112), INT8_C( -52), INT8_C( -84)),
      simde_mm512_set_epi8(INT8_C(  34), INT8_C(  34), INT8_C( -71), INT8_C( -63),
                           INT8_C( -34), INT8_C(-128), INT8_C( 113), INT8_C( -72),
                           INT8_C(  86), INT8_C( -73), INT8_C( -43), INT8_C(  95),
                           INT8_C(   3), INT8_C(  13), INT8_C(  19), INT8_C(  -1),
                           INT8_C( -54), INT8_C( 114), INT8_C(  27), INT8_C( -30),
                           INT8_C(  52), INT8_C( -54), INT8_C(  78), INT8_C(  23),
                           INT8_C(  71), INT8_C(  87), INT8_C( 107), INT8_C( -27),
                           INT8_C( -35), INT8_C(-122), INT8_C(  40), INT8_C(  55),
                           INT8_C(  -2), INT8_C(  40), INT8_C( -63), INT8_C(  85),
                           INT8_C( -25), INT8_C( -93), INT8_C(  25), INT8_C(  70),
                           INT8_C( 117), INT8_C(  66), INT8_C( -79), INT8_C(  57),
                           INT8_C(-115), INT8_C( -27), INT8_C(  59), INT8_C(  25),
                           INT8_C(  -6), INT8_C(  42), INT8_C( -27), INT8_C( -34),
                           INT8_C( -16), INT8_C(   5), INT8_C( -55), INT8_C(  74),
                           INT8_C( -29), INT8_C(  77), INT8_C( -17), INT8_C(  16),
                           INT8_C( -98), INT8_C( -38), INT8_C( 116), INT8_C( -56)),
      simde_mm512_set_epi8(INT8_C(  78), INT8_C(  78), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  13), INT8_C(   0),
                           INT8_C(  66), INT8_C(   0), INT8_C(   0), INT8_C(  56),
                           INT8_C(  50), INT8_C( -41), INT8_C(  50), INT8_C(   0),
                           INT8_C(   0), INT8_C(  24), INT8_C(  80), INT8_C(   0),
                           INT8_C(-119), INT8_C(   0), INT8_C( 120), INT8_C(  28),
                           INT8_C(  28), INT8_C(  28), INT8_C(  80), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  49), INT8_C(  28),
                           INT8_C(   0), INT8_C( -42), INT8_C(   0), INT8_C(-105),
                           INT8_C(   0), INT8_C(   0), INT8_C(  67), INT8_C(-115),
                           INT8_C(-105), INT8_C( -44), INT8_C(   0), INT8_C(  67),
                           INT8_C(   0), INT8_C(   0), INT8_C( 101), INT8_C(  67),
                           INT8_C(   0), INT8_C( -59), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-121), INT8_C(   0), INT8_C( -59),
                           INT8_C(   0), INT8_C( -48), INT8_C(   0), INT8_C( -84),
                           INT8_C(   0), INT8_C(   0), INT8_C(-108), INT8_C(   0)) },
    { simde_mm512_set_epi8(INT8_C( -75), INT8_C(-123), INT8_C( -44), INT8_C( -97),
                           INT8_C(  61), INT8_C(-112), INT8_C( 109), INT8_C(  27),
                           INT8_C(  -9), INT8_C( -31), INT8_C(-111), INT8_C( -59),
                           INT8_C(  94), INT8_C( 110), INT8_C(  31), INT8_C(  50),
                           INT8_C( -86), INT8_C(  24), INT8_C(  91), INT8_C(-105),
                           INT8_C(  39), INT8_C(  25), INT8_C( -65), INT8_C(  69),
                           INT8_C( -59), INT8_C( -57), INT8_C( -98), INT8_C(  26),
                           INT8_C( -35), INT8_C(  -2), INT8_C( 114), INT8_C( -51),
                           INT8_C( -16), INT8_C( 101), INT8_C( -92), INT8_C(  65),
                           INT8_C( -88), INT8_C(  19), INT8_C(-102), INT8_C( -51),
                           INT8_C( -94), INT8_C( -30), INT8_C(  60), INT8_C(  -9),
                           INT8_C(   4), INT8_C( -93), INT8_C( 110), INT8_C(-102),
                           INT8_C( 109), INT8_C(   1), INT8_C( 113), INT8_C( 114),
                           INT8_C( 100), INT8_C(  80), INT8_C(  18), INT8_C(  -7),
                           INT8_C( -87), INT8_C(   0), INT8_C( -55), INT8_C(  37),
                           INT8_C(  13), INT8_C(  86), INT8_C(-114), INT8_C(-125)),
      simde_mm512_set_epi8(INT8_C(  18), INT8_C(  11), INT8_C(  73), INT8_C(  57),
                           INT8_C( -54), INT8_C(   9), INT8_C(  69), INT8_C( -45),
                           INT8_C(  71), INT8_C(  -6), INT8_C( -68), INT8_C(  -8),
                           INT8_C(  14), INT8_C( -27), INT8_C(  84), INT8_C( -90),
                           INT8_C( -10), INT8_C( -81), INT8_C(  77), INT8_C(-113),
                           INT8_C(  32), INT8_C(  17), INT8_C(  62), INT8_C( -18),
                           INT8_C( 124), INT8_C( -42), INT8_C( -52), INT8_C(-109),
                           INT8_C( -19), INT8_C(  30), INT8_C( -51), INT8_C(-111),
                           INT8_C( 100), INT8_C(  63), INT8_C( -80), INT8_C(-126),
                           INT8_C(   3), INT8_C( 119), INT8_C(  38), INT8_C( -44),
                           INT8_C( -48), INT8_C( -43), INT8_C(   6), INT8_C(-113),
                           INT8_C(  -5), INT8_C( -18), INT8_C(  58), INT8_C(  77),
                           INT8_C( -49), INT8_C(-107), INT8_C( -77), INT8_C( 119),
                           INT8_C(  -6), INT8_C(  92), INT8_C(-122), INT8_C(  43),
                           INT8_C(  85), INT8_C(-111), INT8_C( -15), INT8_C(  90),
                           INT8_C(-104), INT8_C(  31), INT8_C(  -4), INT8_C(  57)),
      simde_mm512_set_epi8(INT8_C( 110), INT8_C(  61), INT8_C( 109), INT8_C( 109),
                           INT8_C(   0), INT8_C( 109), INT8_C(-111), INT8_C(   0),
                           INT8_C(  -9), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(-123), INT8_C(   0), INT8_C( -59), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  91), INT8_C(   0),
                           INT8_C( -51), INT8_C( 114), INT8_C(  24), INT8_C(   0),
                           INT8_C(-105), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  24), INT8_C(   0), INT8_C(   0),
                           INT8_C(  -9), INT8_C( -16), INT8_C(   0), INT8_C(   0),
                           INT8_C(   4), INT8_C( -94), INT8_C( -30), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -30), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  19), INT8_C( -92),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -87),
                           INT8_C(   0), INT8_C( 114), INT8_C(   0), INT8_C( 100),
                           INT8_C( -55), INT8_C(   0), INT8_C(   0), INT8_C(  80),
                           INT8_C(   0), INT8_C( 109), INT8_C(   0), INT8_C(  18)) },
    { simde_mm512_set_epi8(INT8_C( -54), INT8_C(  53), INT8_C(  35), INT8_C(  51),
                           INT8_C(  24), INT8_C( 100), INT8_C(  80), INT8_C(   7),
                           INT8_C(  54), INT8_C( 114), INT8_C( -42), INT8_C(  -2),
                           INT8_C(  18), INT8_C( 100), INT8_C(  26), INT8_C( -68),
                           INT8_C(  82), INT8_C( -30), INT8_C(  -4), INT8_C( 110),
                           INT8_C(  24), INT8_C(  88), INT8_C(-100), INT8_C(-120),
                           INT8_C( -17), INT8_C(-109), INT8_C(  92), INT8_C(-105),
                           INT8_C( -20), INT8_C(  34), INT8_C(  98), INT8_C( -17),
                           INT8_C(   2), INT8_C(   6), INT8_C(  37), INT8_C( -85),
                           INT8_C( 118), INT8_C(  28), INT8_C(  34), INT8_C( 117),
                           INT8_C(  77), INT8_C( -32), INT8_C(  25), INT8_C( -74),
                           INT8_C(  93), INT8_C(-108), INT8_C(   3), INT8_C( -90),
                           INT8_C(  13), INT8_C( -29), INT8_C( -88), INT8_C( 116),
                           INT8_C(  14), INT8_C( -29), INT8_C(  30), INT8_C( -26),
                           INT8_C(-115), INT8_C( -36), INT8_C(  94), INT8_C(-125),
                           INT8_C( 118), INT8_C( 125), INT8_C( -91), INT8_C(  31)),
      simde_mm512_set_epi8(INT8_C( -74), INT8_C( -13), INT8_C( -87), INT8_C( -10),
                           INT8_C(  21), INT8_C(  49), INT8_C( -64), INT8_C(  52),
                           INT8_C( -97), INT8_C(-103), INT8_C(-127), INT8_C(  53),
                           INT8_C(  99), INT8_C(  80), INT8_C(  55), INT8_C( 111),
                           INT8_C(  61), INT8_C( -93), INT8_C( -87), INT8_C(  81),
                           INT8_C( 108), INT8_C(  89), INT8_C(  63), INT8_C(-109),
                           INT8_C( -47), INT8_C( -32), INT8_C( 105), INT8_C(  91),
                           INT8_C(  88), INT8_C(  85), INT8_C( -96), INT8_C(  88),
                           INT8_C( -85), INT8_C(   3), INT8_C( 124), INT8_C( -33),
                           INT8_C( -21), INT8_C(  -7), INT8_C( -31), INT8_C(-126),
                           INT8_C(   3), INT8_C( -17), INT8_C(  40), INT8_C(   5),
                           INT8_C( 126), INT8_C( -60), INT8_C( -91), INT8_C(-112),
                           INT8_C(  88), INT8_C(  11), INT8_C( 100), INT8_C( 114),
                           INT8_C( 112), INT8_C( -53), INT8_C(  89), INT8_C(  78),
                           INT8_C( 115), INT8_C( 117), INT8_C( -33), INT8_C(  14),
                           INT8_C( -42), INT8_C( -15), INT8_C(  80), INT8_C( -46)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -42), INT8_C(  26), INT8_C(   0), INT8_C(  -2),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -42),
                           INT8_C(  18), INT8_C( -68), INT8_C(  54), INT8_C( -54),
                           INT8_C(  -4), INT8_C(   0), INT8_C(   0), INT8_C(  98),
                           INT8_C( 110), INT8_C(-100), INT8_C(  82), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(-100), INT8_C(  24),
                           INT8_C(-120), INT8_C(  92), INT8_C(   0), INT8_C(-120),
                           INT8_C(   0), INT8_C(  93), INT8_C( -85), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  93), INT8_C(   0), INT8_C( 117), INT8_C(  25),
                           INT8_C(   6), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -26), INT8_C(  14), INT8_C(-125), INT8_C( 125),
                           INT8_C(  31), INT8_C(   0), INT8_C(  30), INT8_C( -29),
                           INT8_C( 118), INT8_C(  94), INT8_C(   0), INT8_C( -29),
                           INT8_C(   0), INT8_C(   0), INT8_C(  31), INT8_C(   0)) },
    { simde_mm512_set_epi8(INT8_C(-109), INT8_C(  14), INT8_C( -91), INT8_C( -44),
                           INT8_C(  79), INT8_C(  -4), INT8_C(  88), INT8_C(  49),
                           INT8_C( -95), INT8_C( -92), INT8_C(-116), INT8_C(   8),
                           INT8_C(  25), INT8_C(  30), INT8_C( -55), INT8_C(-120),
                           INT8_C( -58), INT8_C( -84), INT8_C(  99), INT8_C( -92),
                           INT8_C( -29), INT8_C( -47), INT8_C(  42), INT8_C( -56),
                           INT8_C( 109), INT8_C( -71), INT8_C( -73), INT8_C( -30),
                           INT8_C( -15), INT8_C(-106), INT8_C( -91), INT8_C( -57),
                           INT8_C(  51), INT8_C(  -8), INT8_C(  55), INT8_C(  36),
                           INT8_C( -55), INT8_C(-103), INT8_C(  51), INT8_C( -28),
                           INT8_C(  70), INT8_C( 114), INT8_C(  -3), INT8_C(  49),
                           INT8_C(  23), INT8_C( -28), INT8_C( -87), INT8_C(  57),
                           INT8_C(  28), INT8_C( -12), INT8_C( -51), INT8_C(  37),
                           INT8_C(  29), INT8_C( -58), INT8_C( -69), INT8_C(  30),
                           INT8_C(  43), INT8_C( -65), INT8_C(  -2), INT8_C( -83),
                           INT8_C( -27), INT8_C(-122), INT8_C(  77), INT8_C(  47)),
      simde_mm512_set_epi8(INT8_C(-116), INT8_C(-127), INT8_C( -95), INT8_C( -97),
                           INT8_C( -78), INT8_C( -53), INT8_C( -36), INT8_C(  62),
                           INT8_C(  63), INT8_C(  28), INT8_C( -37), INT8_C(  40),
                           INT8_C( -14), INT8_C(   2), INT8_C( -65), INT8_C( -67),
                           INT8_C(  79), INT8_C(  51), INT8_C( -51), INT8_C( -64),
                           INT8_C( -40), INT8_C(-102), INT8_C(-107), INT8_C(  82),
                           INT8_C(  20), INT8_C(  54), INT8_C(  66), INT8_C(   7),
                           INT8_C(  33), INT8_C( 108), INT8_C( -88), INT8_C(  69),
                           INT8_C(  98), INT8_C(  43), INT8_C(  25), INT8_C(  58),
                           INT8_C( 117), INT8_C( -34), INT8_C( -70), INT8_C(   3),
                           INT8_C(   1), INT8_C( 100), INT8_C(   3), INT8_C(  14),
                           INT8_C( 117), INT8_C( -91), INT8_C( -89), INT8_C(  66),
                           INT8_C(  32), INT8_C( -35), INT8_C( 104), INT8_C(  65),
                           INT8_C(-100), INT8_C(  27), INT8_C(  42), INT8_C(  91),
                           INT8_C( -47), INT8_C(  39), INT8_C( -65), INT8_C(-124),
                           INT8_C( -84), INT8_C( -95), INT8_C( -46), INT8_C(-113)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  14),
                           INT8_C(-109), INT8_C( -44), INT8_C(   0), INT8_C(  49),
                           INT8_C(   0), INT8_C(  30), INT8_C(   0), INT8_C(   0),
                           INT8_C( -58), INT8_C( -15), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(-106),
                           INT8_C( -30), INT8_C( -71), INT8_C(-106), INT8_C( 109),
                           INT8_C( -91), INT8_C( -92), INT8_C(   0), INT8_C( -73),
                           INT8_C( -28), INT8_C( -55), INT8_C(  51), INT8_C(-103),
                           INT8_C(  -3), INT8_C(   0), INT8_C(   0), INT8_C(  23),
                           INT8_C( -87), INT8_C(  49), INT8_C(  23), INT8_C(  -8),
                           INT8_C(  -3), INT8_C(   0), INT8_C(   0), INT8_C( -28),
                           INT8_C(  47), INT8_C(   0), INT8_C(  30), INT8_C(  77),
                           INT8_C(   0), INT8_C(  29), INT8_C( -58), INT8_C(  29),
                           INT8_C(   0), INT8_C(  43), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
    { simde_mm512_set_epi8(INT8_C(-119), INT8_C(  55), INT8_C( -13), INT8_C(-118),
                           INT8_C(   5), INT8_C(  14), INT8_C(-103), INT8_C(  58),
                           INT8_C( 109), INT8_C(-113), INT8_C( -44), INT8_C( 126),
                           INT8_C(  70), INT8_C(-126), INT8_C(  24), INT8_C(-117),
                           INT8_C(  80), INT8_C(  25), INT8_C(  64), INT8_C( -89),
                           INT8_C(  60), INT8_C(   5), INT8_C(-119), INT8_C( -29),
                           INT8_C( -95), INT8_C( -26), INT8_C(  25), INT8_C( -65),
                           INT8_C( -81), INT8_C( -84), INT8_C(  46), INT8_C(  62),
                           INT8_C( -25), INT8_C(-116), INT8_C(-126), INT8_C(-103),
                           INT8_C( 126), INT8_C( -39), INT8_C( 111), INT8_C( -10),
                           INT8_C( -48), INT8_C( 122), INT8_C( -86), INT8_C( -25),
                           INT8_C(  35), INT8_C(  -4), INT8_C(  -7), INT8_C(  76),
                           INT8_C(-116), INT8_C(   1), INT8_C( 126), INT8_C( -30),
                           INT8_C( -11), INT8_C(  82), INT8_C(  81), INT8_C(  27),
                           INT8_C( -15), INT8_C( -14), INT8_C(  56), INT8_C(  60),
                           INT8_C( -29), INT8_C( -65), INT8_C( -35), INT8_C(  21)),
      simde_mm512_set_epi8(INT8_C( 125), INT8_C( -43), INT8_C( -42), INT8_C( -51),
                           INT8_C( -36), INT8_C(  38), INT8_C(  42), INT8_C(  18),
                           INT8_C(  24), INT8_C( -25), INT8_C(  19), INT8_C(  15),
                           INT8_C(-119), INT8_C(-124), INT8_C( 104), INT8_C( -93),
                           INT8_C(  22), INT8_C( -16), INT8_C(  31), INT8_C( 116),
                           INT8_C( -99), INT8_C(  45), INT8_C( -54), INT8_C(  50),
                           INT8_C( -72), INT8_C(-107), INT8_C(  48), INT8_C( 118),
                           INT8_C( -68), INT8_C( -15), INT8_C(-108), INT8_C( -29),
                           INT8_C( 118), INT8_C(  96), INT8_C( -51), INT8_C( 107),
                           INT8_C( -23), INT8_C( -97), INT8_C(  -6), INT8_C(  91),
                           INT8_C( -57), INT8_C( -67), INT8_C(-105), INT8_C(  68),
                           INT8_C( -50), INT8_C(  16), INT8_C( -86), INT8_C(   6),
                           INT8_C(  55), INT8_C(-118), INT8_C( 112), INT8_C( 125),
                           INT8_C(  92), INT8_C(  91), INT8_C( -27), INT8_C(  53),
                           INT8_C(  28), INT8_C( -66), INT8_C( -69), INT8_C(-117),
                           INT8_C( -30), INT8_C(-106), INT8_C(   1), INT8_C(  95)),
      simde_mm512_set_epi8(INT8_C( -13), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-113), INT8_C(  14), INT8_C(-126),
                           INT8_C(  58), INT8_C(   0), INT8_C(  70), INT8_C(-119),
                           INT8_C(   0), INT8_C(   0), INT8_C(  58), INT8_C(   0),
                           INT8_C( -26), INT8_C(   0), INT8_C(  80), INT8_C( -65),
                           INT8_C(   0), INT8_C(  64), INT8_C(   0), INT8_C( -84),
                           INT8_C(   0), INT8_C(   0), INT8_C(  62), INT8_C( -26),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( 122), INT8_C(  76), INT8_C(   0), INT8_C( 126),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( 126),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -25),
                           INT8_C(   0), INT8_C(  76), INT8_C(   0), INT8_C( 122),
                           INT8_C( -15), INT8_C(   0), INT8_C(  21), INT8_C( 126),
                           INT8_C( -30), INT8_C( -11), INT8_C(   0), INT8_C(  56),
                           INT8_C( -30), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -35), INT8_C(-116)) },
    { simde_mm512_set_epi8(INT8_C(  18), INT8_C(-124), INT8_C(  -6), INT8_C( -41),
                           INT8_C(-109), INT8_C(  19), INT8_C(  47), INT8_C(  73),
                           INT8_C( -58), INT8_C( -50), INT8_C(  73), INT8_C( 110),
                           INT8_C(  56), INT8_C( -30), INT8_C( -79), INT8_C( 123),
                           INT8_C(  77), INT8_C(  62), INT8_C( -28), INT8_C(  45),
                           INT8_C( -95), INT8_C(  12), INT8_C(  53), INT8_C(  75),
                           INT8_C(  66), INT8_C( -89), INT8_C(  46), INT8_C( -47),
                           INT8_C(   6), INT8_C(   4), INT8_C( 112), INT8_C( -34),
                           INT8_C( 121), INT8_C(  -3), INT8_C(-102), INT8_C(-115),
                           INT8_C( -12), INT8_C(  80), INT8_C(   3), INT8_C(  56),
                           INT8_C(  85), INT8_C( -43), INT8_C( -93), INT8_C(  34),
                           INT8_C( -58), INT8_C(-101), INT8_C(  51), INT8_C(   1),
                           INT8_C( -18), INT8_C( -90), INT8_C( -71), INT8_C(  74),
                           INT8_C(  -5), INT8_C(-113), INT8_C(  71), INT8_C(  61),
                           INT8_C(  92), INT8_C(  73), INT8_C( 116), INT8_C( 110),
                           INT8_C(-117), INT8_C(  96), INT8_C( -77), INT8_C(  45)),
      simde_mm512_set_epi8(INT8_C(  52), INT8_C( -84), INT8_C( 103), INT8_C(-105),
                           INT8_C( -57), INT8_C(  17), INT8_C(-110), INT8_C(-113),
                           INT8_C(  56), INT8_C( 125), INT8_C(  56), INT8_C( -88),
                           INT8_C( -31), INT8_C( 119), INT8_C( -86), INT8_C( 114),
                           INT8_C( -85), INT8_C(  14), INT8_C(  60), INT8_C(  84),
                           INT8_C( -61), INT8_C(-111), INT8_C(  74), INT8_C( 113),
                           INT8_C(  13), INT8_C( -89), INT8_C(-114), INT8_C( -79),
                           INT8_C( -34), INT8_C( -73), INT8_C(  -9), INT8_C(-108),
                           INT8_C(  93), INT8_C( -78), INT8_C(  -1), INT8_C(-102),
                           INT8_C(  12), INT8_C( 117), INT8_C(  80), INT8_C(  44),
                           INT8_C(  29), INT8_C(  18), INT8_C(  91), INT8_C( -23),
                           INT8_C( 110), INT8_C(-126), INT8_C( -71), INT8_C(  65),
                           INT8_C( -76), INT8_C(  85), INT8_C(  93), INT8_C( -86),
                           INT8_C(-123), INT8_C(-115), INT8_C(-105), INT8_C(  75),
                           INT8_C(  45), INT8_C(  22), INT8_C(  73), INT8_C(  74),
                           INT8_C( 107), INT8_C( -60), INT8_C( -28), INT8_C( -57)),
      simde_mm512_set_epi8(INT8_C( 110), INT8_C(   0), INT8_C( -58), INT8_C(   0),
                           INT8_C(   0), INT8_C( -79), INT8_C(   0), INT8_C(   0),
                           INT8_C(  73), INT8_C(  -6), INT8_C(  73), INT8_C(   0),
                           INT8_C(   0), INT8_C( -58), INT8_C(   0), INT8_C( -30),
                           INT8_C(   0), INT8_C(  62), INT8_C(  45), INT8_C( -47),
                           INT8_C(   0), INT8_C(   0), INT8_C(  12), INT8_C( 112),
                           INT8_C( -28), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(-102), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(-115), INT8_C( -93), INT8_C(   1), INT8_C(-115),
                           INT8_C(-102), INT8_C(-101), INT8_C( -12), INT8_C(   0),
                           INT8_C(  -3), INT8_C(   0), INT8_C(   0), INT8_C(  51),
                           INT8_C(   0), INT8_C( 116), INT8_C( -71), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  -5),
                           INT8_C( -71), INT8_C(  73), INT8_C(  71), INT8_C(-113),
                           INT8_C(  -5), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
    { simde_mm512_set_epi8(INT8_C(   4), INT8_C( -30), INT8_C( -68), INT8_C(  57),
                           INT8_C(  73), INT8_C(  25), INT8_C( -45), INT8_C( 112),
                           INT8_C(  41), INT8_C(  41), INT8_C( -56), INT8_C( -93),
                           INT8_C(  29), INT8_C(  99), INT8_C(  15), INT8_C( 122),
                           INT8_C(  74), INT8_C(   0), INT8_C(  89), INT8_C(  61),
                           INT8_C( 124), INT8_C(  36), INT8_C( -87), INT8_C( -25),
                           INT8_C(  42), INT8_C(-125), INT8_C( -87), INT8_C(  69),
                           INT8_C(  81), INT8_C(   4), INT8_C(  55), INT8_C( 107),
                           INT8_C(   0), INT8_C(  -7), INT8_C(  37), INT8_C( -15),
                           INT8_C( 117), INT8_C(   9), INT8_C( -27), INT8_C(  11),
                           INT8_C(  16), INT8_C(  87), INT8_C( 119), INT8_C(-107),
                           INT8_C( -22), INT8_C(  27), INT8_C( -86), INT8_C( -63),
                           INT8_C(  90), INT8_C( -44), INT8_C(-113), INT8_C(-126),
                           INT8_C( -75), INT8_C(  67), INT8_C(  88), INT8_C( 105),
                           INT8_C(  80), INT8_C(   7), INT8_C(  66), INT8_C( 126),
                           INT8_C(  17), INT8_C( -20), INT8_C( -91), INT8_C( -99)),
      simde_mm512_set_epi8(INT8_C( 123), INT8_C( 117), INT8_C(  18), INT8_C(   2),
                           INT8_C(-105), INT8_C( -51), INT8_C(  -9), INT8_C(  72),
                           INT8_C(  69), INT8_C(-116), INT8_C(  95), INT8_C(-110),
                           INT8_C( -32), INT8_C( 110), INT8_C(  -8), INT8_C(  85),
                           INT8_C( -41), INT8_C(  80), INT8_C( -44), INT8_C( 110),
                           INT8_C( -28), INT8_C( 116), INT8_C(  41), INT8_C( -31),
                           INT8_C(  12), INT8_C(  40), INT8_C(   5), INT8_C(   1),
                           INT8_C( -14), INT8_C(  66), INT8_C( -95), INT8_C( 106),
                           INT8_C(  66), INT8_C( -91), INT8_C( -20), INT8_C(-109),
                           INT8_C( -46), INT8_C(  41), INT8_C(  82), INT8_C( -61),
                           INT8_C(   2), INT8_C(   3), INT8_C(  62), INT8_C( -90),
                           INT8_C(  99), INT8_C( -54), INT8_C( -28), INT8_C( -21),
                           INT8_C( 126), INT8_C( 115), INT8_C( -46), INT8_C(  76),
                           INT8_C( -43), INT8_C(  46), INT8_C( 107), INT8_C(  75),
                           INT8_C( -93), INT8_C(  67), INT8_C( -37), INT8_C(   4),
                           INT8_C(-127), INT8_C( -50), INT8_C( -26), INT8_C(  99)),
      simde_mm512_set_epi8(INT8_C(  73), INT8_C( -56), INT8_C(  99), INT8_C(  99),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( 112),
                           INT8_C( -56), INT8_C(   0), INT8_C(   4), INT8_C(   0),
                           INT8_C(   0), INT8_C( -30), INT8_C(   0), INT8_C( -56),
                           INT8_C(   0), INT8_C( 107), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  69), INT8_C( -87), INT8_C(   0),
                           INT8_C(  61), INT8_C( -25), INT8_C( -87), INT8_C(  55),
                           INT8_C(   0), INT8_C(   4), INT8_C(   0), INT8_C(  36),
                           INT8_C(  27), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -27), INT8_C(  27), INT8_C(   0),
                           INT8_C(  27), INT8_C( -22), INT8_C(  -7), INT8_C(   0),
                           INT8_C( -22), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -44), INT8_C(  17), INT8_C(   0), INT8_C(-126),
                           INT8_C(   0), INT8_C( -44), INT8_C( -75), INT8_C( -75),
                           INT8_C(   0), INT8_C(  17), INT8_C(   0), INT8_C( 126),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  17)) },
    { simde_mm512_set_epi8(INT8_C(  56), INT8_C(  24), INT8_C( -33), INT8_C(  82),
                           INT8_C(  72), INT8_C(  63), INT8_C(-114), INT8_C(  14),
                           INT8_C(   2), INT8_C(  71), INT8_C( -31), INT8_C( -46),
                           INT8_C(  64), INT8_C( -11), INT8_C(  35), INT8_C(  -7),
                           INT8_C( -78), INT8_C( 125), INT8_C( -28), INT8_C( -59),
                           INT8_C(   6), INT8_C(-127), INT8_C(  34), INT8_C(  64),
                           INT8_C(  88), INT8_C( -88), INT8_C(  70), INT8_C( -90),
                           INT8_C(  47), INT8_C( -21), INT8_C(-104), INT8_C( -27),
                           INT8_C( -16), INT8_C( -29), INT8_C(  51), INT8_C(-116),
                           INT8_C( -87), INT8_C(  91), INT8_C(-106), INT8_C(  -3),
                           INT8_C( -55), INT8_C( -15), INT8_C(-109), INT8_C(-108),
                           INT8_C( -41), INT8_C(  79), INT8_C(  54), INT8_C(  68),
                           INT8_C( -51), INT8_C(-108), INT8_C( -83), INT8_C( 104),
                           INT8_C(  18), INT8_C(-128), INT8_C( -75), INT8_C( -12),
                           INT8_C(  56), INT8_C(-104), INT8_C(  56), INT8_C(  47),
                           INT8_C( -30), INT8_C( -15), INT8_C(-115), INT8_C(  88)),
      simde_mm512_set_epi8(INT8_C( 107), INT8_C( 125), INT8_C(-111), INT8_C( -89),
                           INT8_C(  -9), INT8_C( 122), INT8_C(  -2), INT8_C( -26),
                           INT8_C(-100), INT8_C(  80), INT8_C(  89), INT8_C(  38),
                           INT8_C(  95), INT8_C( -82), INT8_C( -66), INT8_C( 108),
                           INT8_C( 104), INT8_C( -20), INT8_C(  72), INT8_C( -82),
                           INT8_C(  23), INT8_C( -45), INT8_C( -20), INT8_C(   8),
                           INT8_C(  -2), INT8_C( -77), INT8_C(-112), INT8_C( 102),
                           INT8_C(  83), INT8_C(  80), INT8_C(  56), INT8_C( -53),
                           INT8_C( -83), INT8_C( -86), INT8_C(  15), INT8_C(  30),
                           INT8_C( -92), INT8_C(  -2), INT8_C(  42), INT8_C( -79),
                           INT8_C( 108), INT8_C(  44), INT8_C(  17), INT8_C(  83),
                           INT8_C( -49), INT8_C( -44), INT8_C( -42), INT8_C( -54),
                           INT8_C(-127), INT8_C(  12), INT8_C(  88), INT8_C(-118),
                           INT8_C( -23), INT8_C( -69), INT8_C( -23), INT8_C( -36),
                           INT8_C( -23), INT8_C( -80), INT8_C(  33), INT8_C(  82),
                           INT8_C( -43), INT8_C( -91), INT8_C( -36), INT8_C( -56)),
      simde_mm512_set_epi8(INT8_C(  72), INT8_C( -33), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  63), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  -7), INT8_C(-114), INT8_C(  71),
                           INT8_C(  56), INT8_C(   0), INT8_C(   0), INT8_C(  82),
                           INT8_C(  64), INT8_C(   0), INT8_C(  64), INT8_C(   0),
                           INT8_C(  88), INT8_C(   0), INT8_C(   0), INT8_C(  64),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -88),
                           INT8_C(  47), INT8_C( -27), INT8_C(  64), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -16), INT8_C( -29),
                           INT8_C(   0), INT8_C(   0), INT8_C(  91), INT8_C(   0),
                           INT8_C(-116), INT8_C(-116), INT8_C(  54), INT8_C( -41),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( 104), INT8_C( -12), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(-115), INT8_C( -15),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_shuffle_epi8(test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_mask_shuffle_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i src;
    simde__mmask64 k;
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C(  92), INT8_C( 116), INT8_C( -78), INT8_C( -19),
                           INT8_C( -73), INT8_C(  22), INT8_C( -66), INT8_C( -29),
                           INT8_C(  55), INT8_C(  78), INT8_C( -45), INT8_C(-119),
                           INT8_C(  30), INT8_C( -29), INT8_C( -23), INT8_C(  89),
                           INT8_C(  15), INT8_C( 119), INT8_C( -88), INT8_C( 109),
                           INT8_C( -16), INT8_C( -10), INT8_C(   0), INT8_C( -18),
                           INT8_C(   1), INT8_C( 116), INT8_C(  62), INT8_C( -73),
                           INT8_C(-122), INT8_C(   0), INT8_C( 111), INT8_C(  95),
                           INT8_C( -20), INT8_C(   3), INT8_C( 122), INT8_C(-121),
                           INT8_C(  13), INT8_C(  25), INT8_C( -35), INT8_C(-127),
                           INT8_C(  82), INT8_C(  90), INT8_C(  53), INT8_C( 123),
                           INT8_C(  73), INT8_C( 108), INT8_C( -18), INT8_C(  15),
                           INT8_C(  81), INT8_C( -27), INT8_C( 102), INT8_C( 118),
                           INT8_C(  39), INT8_C( -77), INT8_C(  45), INT8_C(  81),
                           INT8_C( -17), INT8_C( -28), INT8_C(  67), INT8_C(-118),
                           INT8_C(  79), INT8_C(-113), INT8_C(-122), INT8_C( 124)),
      UINT64_C(10224647434006242820),
      simde_mm512_set_epi8(INT8_C(  68), INT8_C(-108), INT8_C(-121), INT8_C(-115),
                           INT8_C( -59), INT8_C( -78), INT8_C(-111), INT8_C(  56),
                           INT8_C(   9), INT8_C(-121), INT8_C( 120), INT8_C( -36),
                           INT8_C(  36), INT8_C(-103), INT8_C(-104), INT8_C(  25),
                           INT8_C(-111), INT8_C( -63), INT8_C( -35), INT8_C(-120),
                           INT8_C(  28), INT8_C( -44), INT8_C( -26), INT8_C( -86),
                           INT8_C( -13), INT8_C(  53), INT8_C( -88), INT8_C(-107),
                           INT8_C(  68), INT8_C(  42), INT8_C(-118), INT8_C( 111),
                           INT8_C(  54), INT8_C( -58), INT8_C( -13), INT8_C(  27),
                           INT8_C(  23), INT8_C(  41), INT8_C(-119), INT8_C(  44),
                           INT8_C(   7), INT8_C(-120), INT8_C(  32), INT8_C( -43),
                           INT8_C( 114), INT8_C( -72), INT8_C(  73), INT8_C( -96),
                           INT8_C(  96), INT8_C( 110), INT8_C( -81), INT8_C( -76),
                           INT8_C( 103), INT8_C(-100), INT8_C( -22), INT8_C(  18),
                           INT8_C( 115), INT8_C(  54), INT8_C( -40), INT8_C( 125),
                           INT8_C( 110), INT8_C(  31), INT8_C(  51), INT8_C(-104)),
      simde_mm512_set_epi8(INT8_C( -14), INT8_C(  85), INT8_C( -80), INT8_C(  80),
                           INT8_C(  48), INT8_C(  93), INT8_C(  79), INT8_C( 127),
                           INT8_C(  16), INT8_C(  41), INT8_C(  54), INT8_C(-116),
                           INT8_C(  17), INT8_C(  42), INT8_C( -86), INT8_C(  38),
                           INT8_C(-118), INT8_C( -56), INT8_C(  60), INT8_C(  19),
                           INT8_C(-100), INT8_C(-107), INT8_C( 105), INT8_C( -76),
                           INT8_C(  10), INT8_C(  -9), INT8_C( -12), INT8_C( -56),
                           INT8_C( -71), INT8_C(  96), INT8_C(   6), INT8_C(  24),
                           INT8_C(  69), INT8_C(  73), INT8_C( -27), INT8_C(   3),
                           INT8_C( -95), INT8_C(  50), INT8_C( -67), INT8_C( -39),
                           INT8_C(  97), INT8_C(  62), INT8_C( 101), INT8_C(  56),
                           INT8_C( -79), INT8_C(  83), INT8_C( -99), INT8_C( -56),
                           INT8_C( -17), INT8_C( -56), INT8_C(  -8), INT8_C( -16),
                           INT8_C(  84), INT8_C( -95), INT8_C( -73), INT8_C(  54),
                           INT8_C( 125), INT8_C(  85), INT8_C(  78), INT8_C( -65),
                           INT8_C(   4), INT8_C( 113), INT8_C( -16), INT8_C( -53)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C( 116), INT8_C( -78), INT8_C( -19),
                           INT8_C(  25), INT8_C(-121), INT8_C( -66), INT8_C(  68),
                           INT8_C(  25), INT8_C(-111), INT8_C(-121), INT8_C(-119),
                           INT8_C(  30), INT8_C( -78), INT8_C( -23), INT8_C(-121),
                           INT8_C(  15), INT8_C( 119), INT8_C(-120), INT8_C(  68),
                           INT8_C(   0), INT8_C(   0), INT8_C( -26), INT8_C( -18),
                           INT8_C( -44), INT8_C( 116), INT8_C(   0), INT8_C( -73),
                           INT8_C(   0), INT8_C(   0), INT8_C(  53), INT8_C( -86),
                           INT8_C( -20), INT8_C(   3), INT8_C(   0), INT8_C( 114),
                           INT8_C(  13), INT8_C(  25), INT8_C( -35), INT8_C(   0),
                           INT8_C(  73), INT8_C(  90), INT8_C(  53), INT8_C( 123),
                           INT8_C(   0), INT8_C( 114), INT8_C( -18), INT8_C(   0),
                           INT8_C(  81), INT8_C( -27), INT8_C(   0), INT8_C( 118),
                           INT8_C(  39), INT8_C(   0), INT8_C(   0), INT8_C(  81),
                           INT8_C( -17), INT8_C( -28), INT8_C(  67), INT8_C(-118),
                           INT8_C(  79), INT8_C(  51), INT8_C(-122), INT8_C( 124)) },
    { simde_mm512_set_epi8(INT8_C(-123), INT8_C(-100), INT8_C( -39), INT8_C( -44),
                           INT8_C(  22), INT8_C( 112), INT8_C(  16), INT8_C(  15),
                           INT8_C(-104), INT8_C(-102), INT8_C( 102), INT8_C( -95),
                           INT8_C(  69), INT8_C(  13), INT8_C( -21), INT8_C(  45),
                           INT8_C(  62), INT8_C(-120), INT8_C(-111), INT8_C(  32),
                           INT8_C(-107), INT8_C( -30), INT8_C(  99), INT8_C( -64),
                           INT8_C(   8), INT8_C( -42), INT8_C(  81), INT8_C( -34),
                           INT8_C( -46), INT8_C(  26), INT8_C(  31), INT8_C(  -2),
                           INT8_C(  68), INT8_C(  -7), INT8_C( -71), INT8_C(  46),
                           INT8_C( -21), INT8_C( -73), INT8_C(  21), INT8_C(  83),
                           INT8_C(-108), INT8_C( -97), INT8_C( -69), INT8_C(  73),
                           INT8_C(  57), INT8_C( -37), INT8_C(  21), INT8_C(  82),
                           INT8_C(-119), INT8_C(-126), INT8_C( 126), INT8_C(  91),
                           INT8_C( 115), INT8_C(  31), INT8_C( -79), INT8_C(  28),
                           INT8_C(-106), INT8_C( -18), INT8_C(  65), INT8_C(-104),
                           INT8_C(  81), INT8_C(  38), INT8_C( -84), INT8_C(  -2)),
      UINT64_C( 4597426592773770833),
      simde_mm512_set_epi8(INT8_C(  74), INT8_C(  72), INT8_C(  -4), INT8_C(  28),
                           INT8_C(-115), INT8_C(  93), INT8_C( 102), INT8_C(  44),
                           INT8_C(-103), INT8_C( -29), INT8_C( -50), INT8_C(  48),
                           INT8_C( -96), INT8_C( -50), INT8_C(  46), INT8_C( -65),
                           INT8_C(   4), INT8_C(  43), INT8_C( -75), INT8_C(  97),
                           INT8_C( -26), INT8_C(-103), INT8_C(  71), INT8_C(-107),
                           INT8_C(  91), INT8_C(  45), INT8_C( -11), INT8_C(  47),
                           INT8_C(  29), INT8_C(  25), INT8_C(  26), INT8_C(  -9),
                           INT8_C(  10), INT8_C(  36), INT8_C( -79), INT8_C( -53),
                           INT8_C(  41), INT8_C(   1), INT8_C( -23), INT8_C( -63),
                           INT8_C(-127), INT8_C(  68), INT8_C(  48), INT8_C(  36),
                           INT8_C(  89), INT8_C(-112), INT8_C( -31), INT8_C( 120),
                           INT8_C(  35), INT8_C(  62), INT8_C( -21), INT8_C(-114),
                           INT8_C(-104), INT8_C(  57), INT8_C(  42), INT8_C(-111),
                           INT8_C(  94), INT8_C( -63), INT8_C(  -9), INT8_C(  64),
                           INT8_C( -65), INT8_C(  -2), INT8_C( 110), INT8_C(  -8)),
      simde_mm512_set_epi8(INT8_C(  44), INT8_C( -92), INT8_C( -31), INT8_C(  26),
                           INT8_C( -99), INT8_C( -53), INT8_C( 117), INT8_C(  18),
                           INT8_C( -63), INT8_C(  45), INT8_C(  12), INT8_C(  24),
                           INT8_C(-108), INT8_C(  18), INT8_C( -60), INT8_C(  28),
                           INT8_C(  50), INT8_C( -11), INT8_C( -68), INT8_C( -31),
                           INT8_C( 105), INT8_C(-106), INT8_C(  98), INT8_C(  51),
                           INT8_C(  58), INT8_C( 103), INT8_C( 111), INT8_C(-127),
                           INT8_C(  68), INT8_C( -56), INT8_C( 124), INT8_C(-119),
                           INT8_C(  74), INT8_C( -62), INT8_C(-116), INT8_C(  37),
                           INT8_C( -12), INT8_C( 114), INT8_C(   0), INT8_C(  61),
                           INT8_C( 103), INT8_C(  -4), INT8_C(-105), INT8_C( -68),
                           INT8_C(  39), INT8_C(-100), INT8_C( -93), INT8_C(  11),
                           INT8_C( -80), INT8_C( -19), INT8_C( -22), INT8_C( -39),
                           INT8_C( 127), INT8_C( -38), INT8_C(-125), INT8_C(-111),
                           INT8_C(  84), INT8_C( -96), INT8_C(  87), INT8_C( -22),
                           INT8_C(  -5), INT8_C(  -3), INT8_C(-127), INT8_C(  41)),
      simde_mm512_set_epi8(INT8_C(-123), INT8_C(-100), INT8_C(   0), INT8_C(  93),
                           INT8_C(   0), INT8_C(   0), INT8_C( -50), INT8_C( -50),
                           INT8_C(   0), INT8_C(  -4), INT8_C( 102), INT8_C( -95),
                           INT8_C(   0), INT8_C( -50), INT8_C( -21), INT8_C(  28),
                           INT8_C(  62), INT8_C(   0), INT8_C(-111), INT8_C(   0),
                           INT8_C(-107), INT8_C(   0), INT8_C(  25), INT8_C(  29),
                           INT8_C(   8), INT8_C( -42), INT8_C(   4), INT8_C( -34),
                           INT8_C( -46), INT8_C(  26), INT8_C(  31), INT8_C(  -2),
                           INT8_C(   1), INT8_C(  -7), INT8_C(   0), INT8_C(  48),
                           INT8_C(   0), INT8_C(-112), INT8_C( 120), INT8_C( -79),
                           INT8_C(-108), INT8_C( -97), INT8_C(   0), INT8_C(   0),
                           INT8_C(  57), INT8_C(   0), INT8_C(   0), INT8_C(  41),
                           INT8_C(-119), INT8_C(-126), INT8_C( 126), INT8_C(  91),
                           INT8_C(  35), INT8_C(   0), INT8_C(   0), INT8_C(  28),
                           INT8_C(-106), INT8_C(   0), INT8_C(  65), INT8_C(   0),
                           INT8_C(  81), INT8_C(  38), INT8_C( -84), INT8_C(  42)) },
    { simde_mm512_set_epi8(INT8_C( -30), INT8_C( -37), INT8_C(  51), INT8_C( -36),
                           INT8_C(   8), INT8_C(  52), INT8_C(  97), INT8_C( 123),
                           INT8_C( -49), INT8_C(-124), INT8_C(  95), INT8_C( -83),
                           INT8_C(  70), INT8_C( -50), INT8_C( -61), INT8_C(  25),
                           INT8_C( -97), INT8_C(  28), INT8_C( -58), INT8_C(  11),
                           INT8_C( -14), INT8_C( 126), INT8_C(  81), INT8_C(  45),
                           INT8_C( -23), INT8_C( 120), INT8_C( -83), INT8_C( -16),
                           INT8_C(   7), INT8_C(  51), INT8_C( -57), INT8_C( -50),
                           INT8_C( -21), INT8_C(  98), INT8_C(  88), INT8_C(   0),
                           INT8_C( -66), INT8_C(   3), INT8_C( 124), INT8_C(-113),
                           INT8_C(  50), INT8_C(  88), INT8_C( -85), INT8_C( -93),
                           INT8_C( -44), INT8_C( -13), INT8_C( -94), INT8_C(  17),
                           INT8_C(  -2), INT8_C(  79), INT8_C(-116), INT8_C(  43),
                           INT8_C( -77), INT8_C(-125), INT8_C( -23), INT8_C(-120),
                           INT8_C(  96), INT8_C( -64), INT8_C( -23), INT8_C( -46),
                           INT8_C( -29), INT8_C( -71), INT8_C(  71), INT8_C(  90)),
      UINT64_C(12627002542648829104),
      simde_mm512_set_epi8(INT8_C(  56), INT8_C( -45), INT8_C(-108), INT8_C( -19),
                           INT8_C(-124), INT8_C( -27), INT8_C(  22), INT8_C( 126),
                           INT8_C(-106), INT8_C( -68), INT8_C( -60), INT8_C(   8),
                           INT8_C(  60), INT8_C(  93), INT8_C( -33), INT8_C( -27),
                           INT8_C(  -7), INT8_C(  27), INT8_C(-122), INT8_C( -38),
                           INT8_C(  23), INT8_C(   6), INT8_C(  45), INT8_C( -21),
                           INT8_C( -23), INT8_C(-101), INT8_C( 116), INT8_C( 127),
                           INT8_C(  96), INT8_C(  40), INT8_C( -97), INT8_C(  40),
                           INT8_C(  86), INT8_C( -44), INT8_C(  70), INT8_C( -71),
                           INT8_C(  62), INT8_C( -21), INT8_C(  66), INT8_C(  68),
                           INT8_C( -87), INT8_C( -61), INT8_C(  48), INT8_C( -70),
                           INT8_C(  18), INT8_C( -78), INT8_C( -98), INT8_C( 117),
                           INT8_C(  74), INT8_C(  32), INT8_C(  93), INT8_C( 125),
                           INT8_C( -47), INT8_C( -60), INT8_C( -86), INT8_C( 117),
                           INT8_C( 122), INT8_C( -54), INT8_C(  50), INT8_C( 123),
                           INT8_C( -31), INT8_C( -74), INT8_C( -64), INT8_C(  54)),
      simde_mm512_set_epi8(INT8_C( 115), INT8_C(  51), INT8_C( -91), INT8_C(  56),
                           INT8_C(  64), INT8_C( -39), INT8_C(-119), INT8_C( -28),
                           INT8_C( -54), INT8_C(  28), INT8_C(  54), INT8_C(  -8),
                           INT8_C( -54), INT8_C(-128), INT8_C( -28), INT8_C( -71),
                           INT8_C( 107), INT8_C( -66), INT8_C(-114), INT8_C( -88),
                           INT8_C(  34), INT8_C( -83), INT8_C( -21), INT8_C( -64),
                           INT8_C( 121), INT8_C( -20), INT8_C( -89), INT8_C( -94),
                           INT8_C( 112), INT8_C( -27), INT8_C(  81), INT8_C( -54),
                           INT8_C( -64), INT8_C(-114), INT8_C(  48), INT8_C( -89),
                           INT8_C( -61), INT8_C(  26), INT8_C(  43), INT8_C(  29),
                           INT8_C(   0), INT8_C(  64), INT8_C( 123), INT8_C( -67),
                           INT8_C(  15), INT8_C( 120), INT8_C(  36), INT8_C(  40),
                           INT8_C( 106), INT8_C(-118), INT8_C(-108), INT8_C( -58),
                           INT8_C(  26), INT8_C(-111), INT8_C(  63), INT8_C( -98),
                           INT8_C( -13), INT8_C( -12), INT8_C(-124), INT8_C(  96),
                           INT8_C( -13), INT8_C( -98), INT8_C(  99), INT8_C( -13)),
      simde_mm512_set_epi8(INT8_C(  60), INT8_C( -37), INT8_C(   0), INT8_C( -36),
                           INT8_C( -27), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -49), INT8_C(-124), INT8_C( -68), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -61), INT8_C(  25),
                           INT8_C( -97), INT8_C(  28), INT8_C( -58), INT8_C(   0),
                           INT8_C(  40), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  45), INT8_C(   0), INT8_C(   0), INT8_C( -16),
                           INT8_C(  40), INT8_C(  51), INT8_C( -57), INT8_C(   0),
                           INT8_C( -21), INT8_C(   0), INT8_C( 117), INT8_C(   0),
                           INT8_C(   0), INT8_C( -21), INT8_C( 124), INT8_C(-113),
                           INT8_C( 117), INT8_C(  88), INT8_C( -85), INT8_C( -93),
                           INT8_C(  86), INT8_C( -13), INT8_C( -94), INT8_C(  68),
                           INT8_C( -60), INT8_C(  79), INT8_C(   0), INT8_C(  43),
                           INT8_C( -77), INT8_C(   0), INT8_C( -23), INT8_C(-120),
                           INT8_C(   0), INT8_C( -64), INT8_C(   0), INT8_C(  54),
                           INT8_C( -29), INT8_C( -71), INT8_C(  71), INT8_C(  90)) },
    { simde_mm512_set_epi8(INT8_C(  72), INT8_C(  45), INT8_C( 120), INT8_C(  -5),
                           INT8_C(-109), INT8_C(  62), INT8_C(  17), INT8_C(  31),
                           INT8_C( -30), INT8_C( -58), INT8_C(  56), INT8_C(  21),
                           INT8_C(  72), INT8_C( -74), INT8_C( -40), INT8_C( 120),
                           INT8_C(  95), INT8_C( 108), INT8_C(  32), INT8_C(  64),
                           INT8_C(-128), INT8_C( 102), INT8_C( -21), INT8_C(  28),
                           INT8_C( 105), INT8_C(  52), INT8_C(  85), INT8_C(-104),
                           INT8_C(  57), INT8_C( -31), INT8_C( -38), INT8_C(-124),
                           INT8_C(-107), INT8_C(  -2), INT8_C(  55), INT8_C(  46),
                           INT8_C( -71), INT8_C(  77), INT8_C(  18), INT8_C(  70),
                           INT8_C(  89), INT8_C( 125), INT8_C( -42), INT8_C(-125),
                           INT8_C( 121), INT8_C( -11), INT8_C( -69), INT8_C( -59),
                           INT8_C( -53), INT8_C(  34), INT8_C(   9), INT8_C(  64),
                           INT8_C( -61), INT8_C( -25), INT8_C(-115), INT8_C( 100),
                           INT8_C(  65), INT8_C(   8), INT8_C(  69), INT8_C(  -8),
                           INT8_C( -15), INT8_C( -51), INT8_C(   1), INT8_C(  90)),
      UINT64_C(14515151237088493607),
      simde_mm512_set_epi8(INT8_C( -26), INT8_C(  -9), INT8_C(  66), INT8_C(   1),
                           INT8_C( -13), INT8_C(  60), INT8_C(-119), INT8_C( -83),
                           INT8_C(-122), INT8_C( -64), INT8_C( -83), INT8_C( -74),
                           INT8_C( 119), INT8_C(  -8), INT8_C(  12), INT8_C( 113),
                           INT8_C( -12), INT8_C( -84), INT8_C(   6), INT8_C(  69),
                           INT8_C(   2), INT8_C( -75), INT8_C( -34), INT8_C(-126),
                           INT8_C(   3), INT8_C(-128), INT8_C(  -9), INT8_C(  24),
                           INT8_C(  11), INT8_C( -94), INT8_C( -32), INT8_C( 110),
                           INT8_C(  33), INT8_C( -24), INT8_C( 125), INT8_C(  35),
                           INT8_C(-103), INT8_C( -48), INT8_C( -22), INT8_C(  38),
                           INT8_C( -81), INT8_C(   9), INT8_C( -11), INT8_C(-124),
                           INT8_C(  71), INT8_C(  31), INT8_C( -42), INT8_C(  93),
                           INT8_C(  67), INT8_C(  45), INT8_C(  51), INT8_C( -92),
                           INT8_C( 126), INT8_C( 108), INT8_C(-123), INT8_C( -71),
                           INT8_C( 113), INT8_C(  32), INT8_C(  71), INT8_C(  55),
                           INT8_C( -26), INT8_C(  82), INT8_C( -81), INT8_C( -20)),
      simde_mm512_set_epi8(INT8_C(-125), INT8_C( 121), INT8_C(-128), INT8_C( 103),
                           INT8_C(   0), INT8_C( 101), INT8_C( -41), INT8_C(  89),
                           INT8_C( -83), INT8_C( -65), INT8_C(   9), INT8_C(  -7),
                           INT8_C( -63), INT8_C(  13), INT8_C( 105), INT8_C(  92),
                           INT8_C( -18), INT8_C( -21), INT8_C(-102), INT8_C(-114),
                           INT8_C(  74), INT8_C( 121), INT8_C( -45), INT8_C(  52),
                           INT8_C( -63), INT8_C( -93), INT8_C(  98), INT8_C( 106),
                           INT8_C(-109), INT8_C( -47), INT8_C(  37), INT8_C(  70),
                           INT8_C( 100), INT8_C( 121), INT8_C(  18), INT8_C(  28),
                           INT8_C(-117), INT8_C( 107), INT8_C(   3), INT8_C( -62),
                           INT8_C(  42), INT8_C(  72), INT8_C(  91), INT8_C(  86),
                           INT8_C( -72), INT8_C(   9), INT8_C( -80), INT8_C( 118),
                           INT8_C( 122), INT8_C(-108), INT8_C( -70), INT8_C( -63),
                           INT8_C(  56), INT8_C(  71), INT8_C( -14), INT8_C(  49),
                           INT8_C( -73), INT8_C(  53), INT8_C( -29), INT8_C(   3),
                           INT8_C( -73), INT8_C(  43), INT8_C( -22), INT8_C(  85)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(-119), INT8_C( 120), INT8_C(  -5),
                           INT8_C( 113), INT8_C(  62), INT8_C(  17), INT8_C(-119),
                           INT8_C( -30), INT8_C(   0), INT8_C(-119), INT8_C(   0),
                           INT8_C(  72), INT8_C( -74), INT8_C( -40), INT8_C( 120),
                           INT8_C(  95), INT8_C( 108), INT8_C(   0), INT8_C(  64),
                           INT8_C( -75), INT8_C( -34), INT8_C( -21), INT8_C(  24),
                           INT8_C( 105), INT8_C(  52), INT8_C( -94), INT8_C(-104),
                           INT8_C(  57), INT8_C(   0), INT8_C( -38), INT8_C(-128),
                           INT8_C(-107), INT8_C( -22), INT8_C(  55), INT8_C(  46),
                           INT8_C( -71), INT8_C(  77), INT8_C(  71), INT8_C(   0),
                           INT8_C( -48), INT8_C( 125), INT8_C(-103), INT8_C(   9),
                           INT8_C(   0), INT8_C( -11), INT8_C(   0), INT8_C(   9),
                           INT8_C( -53), INT8_C(   0), INT8_C(   9), INT8_C(  64),
                           INT8_C( -61), INT8_C( -25), INT8_C(-115), INT8_C( 100),
                           INT8_C(  65), INT8_C(   8), INT8_C(   0), INT8_C(  -8),
                           INT8_C( -15), INT8_C( 126), INT8_C(   0), INT8_C(  71)) },
    { simde_mm512_set_epi8(INT8_C( -47), INT8_C(  84), INT8_C(-126), INT8_C( -64),
                           INT8_C(  14), INT8_C(  11), INT8_C(  37), INT8_C( -23),
                           INT8_C(  67), INT8_C( 124), INT8_C(  58), INT8_C( -94),
                           INT8_C(  30), INT8_C( -33), INT8_C(  70), INT8_C( -24),
                           INT8_C(  38), INT8_C( -97), INT8_C( -56), INT8_C( -60),
                           INT8_C( -59), INT8_C(  65), INT8_C( -74), INT8_C(  45),
                           INT8_C( -11), INT8_C(  55), INT8_C( -82), INT8_C(  12),
                           INT8_C( 106), INT8_C(  22), INT8_C(-124), INT8_C(  -4),
                           INT8_C(   2), INT8_C( -81), INT8_C(  14), INT8_C(  90),
                           INT8_C(-100), INT8_C(-122), INT8_C( -35), INT8_C(  81),
                           INT8_C( -14), INT8_C( -42), INT8_C( 125), INT8_C(-125),
                           INT8_C( -57), INT8_C(  90), INT8_C(  -9), INT8_C(  63),
                           INT8_C(  53), INT8_C(  77), INT8_C(  63), INT8_C( -84),
                           INT8_C(  27), INT8_C(  22), INT8_C(   3), INT8_C( -37),
                           INT8_C(  65), INT8_C( 118), INT8_C(-126), INT8_C(  97),
                           INT8_C( 109), INT8_C(   7), INT8_C(-114), INT8_C( -75)),
      UINT64_C( 8707623543556880126),
      simde_mm512_set_epi8(INT8_C(  84), INT8_C( -71), INT8_C(   8), INT8_C(  12),
                           INT8_C( -11), INT8_C( -76), INT8_C(  62), INT8_C(  93),
                           INT8_C( -75), INT8_C( -77), INT8_C( -84), INT8_C(-108),
                           INT8_C( -35), INT8_C(  14), INT8_C( -60), INT8_C(  18),
                           INT8_C(  23), INT8_C( -60), INT8_C( -63), INT8_C(-114),
                           INT8_C( -55), INT8_C(  75), INT8_C( -99), INT8_C( -55),
                           INT8_C(  58), INT8_C(  76), INT8_C(-102), INT8_C(-118),
                           INT8_C( -30), INT8_C(  39), INT8_C( 119), INT8_C(  85),
                           INT8_C(  -8), INT8_C( -72), INT8_C( -60), INT8_C( -94),
                           INT8_C(-112), INT8_C( 119), INT8_C( 124), INT8_C(  76),
                           INT8_C( -42), INT8_C(-124), INT8_C(  54), INT8_C(  74),
                           INT8_C( -92), INT8_C(  99), INT8_C(  79), INT8_C(  -3),
                           INT8_C(  61), INT8_C( -89), INT8_C(  84), INT8_C( -94),
                           INT8_C(  31), INT8_C(-116), INT8_C( -67), INT8_C(-102),
                           INT8_C( -72), INT8_C( -91), INT8_C(-105), INT8_C(-108),
                           INT8_C( -44), INT8_C(  74), INT8_C( -28), INT8_C( 124)),
      simde_mm512_set_epi8(INT8_C(   1), INT8_C(  75), INT8_C(  21), INT8_C( -36),
                           INT8_C(-126), INT8_C( 122), INT8_C(  71), INT8_C(  76),
                           INT8_C(  28), INT8_C( -56), INT8_C(  32), INT8_C( 101),
                           INT8_C(-107), INT8_C(-111), INT8_C( -88), INT8_C( -19),
                           INT8_C( -77), INT8_C(  19), INT8_C( -21), INT8_C(-111),
                           INT8_C( -68), INT8_C(  82), INT8_C(-118), INT8_C( -76),
                           INT8_C(  47), INT8_C( 127), INT8_C(  62), INT8_C( -16),
                           INT8_C(  10), INT8_C( -14), INT8_C(-100), INT8_C(  86),
                           INT8_C(  29), INT8_C( 107), INT8_C(  56), INT8_C(  21),
                           INT8_C(  24), INT8_C(  68), INT8_C( -96), INT8_C(  64),
                           INT8_C(  48), INT8_C(  13), INT8_C( -83), INT8_C(   4),
                           INT8_C(  -3), INT8_C( -64), INT8_C(  17), INT8_C(-115),
                           INT8_C(  21), INT8_C( 108), INT8_C( 125), INT8_C( -60),
                           INT8_C( -72), INT8_C(  74), INT8_C(  -5), INT8_C( -58),
                           INT8_C( -41), INT8_C(  22), INT8_C(-115), INT8_C( 102),
                           INT8_C(  59), INT8_C( -80), INT8_C( -15), INT8_C( -63)),
      simde_mm512_set_epi8(INT8_C( -47), INT8_C( -11), INT8_C( -84), INT8_C(   0),
                           INT8_C(   0), INT8_C(  11), INT8_C(  37), INT8_C( -23),
                           INT8_C(  12), INT8_C(   0), INT8_C(  58), INT8_C( -84),
                           INT8_C(  30), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -97), INT8_C(   0), INT8_C(   0),
                           INT8_C( -59), INT8_C(  65), INT8_C( -74), INT8_C(   0),
                           INT8_C( -11), INT8_C(  23), INT8_C( -60), INT8_C(   0),
                           INT8_C(  75), INT8_C(  22), INT8_C(   0), INT8_C(  -4),
                           INT8_C(   2), INT8_C(-112), INT8_C(  14), INT8_C(  54),
                           INT8_C(-100), INT8_C(  74), INT8_C(   0), INT8_C(  -3),
                           INT8_C(  -3), INT8_C( -42), INT8_C( 125), INT8_C(-125),
                           INT8_C(   0), INT8_C(  90), INT8_C(  -9), INT8_C(   0),
                           INT8_C(  53), INT8_C(  77), INT8_C(  84), INT8_C(   0),
                           INT8_C(  27), INT8_C(-116), INT8_C(   0), INT8_C( -37),
                           INT8_C(   0), INT8_C( -91), INT8_C(   0), INT8_C( -91),
                           INT8_C(  31), INT8_C(   0), INT8_C(   0), INT8_C( -75)) },
    { simde_mm512_set_epi8(INT8_C( -64), INT8_C( -53), INT8_C( -42), INT8_C( 126),
                           INT8_C(  67), INT8_C(  50), INT8_C( -18), INT8_C(  76),
                           INT8_C( -19), INT8_C( 123), INT8_C( -87), INT8_C( 106),
                           INT8_C( -74), INT8_C(  44), INT8_C( 117), INT8_C( 103),
                           INT8_C(  81), INT8_C( 122), INT8_C(  56), INT8_C( -10),
                           INT8_C(  67), INT8_C(  79), INT8_C(  83), INT8_C( -38),
                           INT8_C( -13), INT8_C(  43), INT8_C(  27), INT8_C( -97),
                           INT8_C( 102), INT8_C( 126), INT8_C(  38), INT8_C( -62),
                           INT8_C( -24), INT8_C( 117), INT8_C( -38), INT8_C( -93),
                           INT8_C( -58), INT8_C(-124), INT8_C( -75), INT8_C(  10),
                           INT8_C(  18), INT8_C( -74), INT8_C(  14), INT8_C(  36),
                           INT8_C(  -7), INT8_C( 113), INT8_C(  40), INT8_C(  48),
                           INT8_C(-107), INT8_C( -34), INT8_C( -75), INT8_C(  85),
                           INT8_C( -35), INT8_C(-116), INT8_C(  65), INT8_C( -21),
                           INT8_C(  15), INT8_C(   3), INT8_C(  45), INT8_C(  21),
                           INT8_C(  72), INT8_C(  93), INT8_C( 108), INT8_C( 125)),
      UINT64_C(12576710173448868104),
      simde_mm512_set_epi8(INT8_C(  90), INT8_C( -38), INT8_C( -98), INT8_C( -70),
                           INT8_C(-108), INT8_C(  20), INT8_C(  43), INT8_C(-128),
                           INT8_C(  77), INT8_C( 108), INT8_C(  53), INT8_C(  82),
                           INT8_C( -50), INT8_C(  52), INT8_C(  56), INT8_C(  58),
                           INT8_C(-120), INT8_C( -43), INT8_C( 114), INT8_C(  93),
                           INT8_C( -44), INT8_C( -15), INT8_C(  38), INT8_C( -17),
                           INT8_C(-110), INT8_C(-123), INT8_C( -39), INT8_C( 114),
                           INT8_C(  51), INT8_C(-115), INT8_C( -74), INT8_C(  43),
                           INT8_C(  41), INT8_C( -36), INT8_C(  19), INT8_C(  69),
                           INT8_C(  60), INT8_C( -53), INT8_C( 112), INT8_C( 108),
                           INT8_C(   8), INT8_C(  46), INT8_C( -35), INT8_C(  26),
                           INT8_C(  11), INT8_C(  42), INT8_C(  47), INT8_C(  59),
                           INT8_C( -57), INT8_C(  94), INT8_C(-125), INT8_C(-124),
                           INT8_C(  36), INT8_C(  57), INT8_C(  68), INT8_C( -52),
                           INT8_C(  39), INT8_C(  50), INT8_C( -48), INT8_C(  94),
                           INT8_C(  53), INT8_C(  11), INT8_C(  29), INT8_C(  65)),
      simde_mm512_set_epi8(INT8_C(-107), INT8_C( 120), INT8_C( -58), INT8_C( 107),
                           INT8_C( -32), INT8_C( -32), INT8_C(  88), INT8_C( -43),
                           INT8_C(  31), INT8_C( -32), INT8_C( -64), INT8_C(  27),
                           INT8_C(  82), INT8_C( -90), INT8_C( -54), INT8_C( -84),
                           INT8_C( -30), INT8_C(  63), INT8_C(  24), INT8_C(  81),
                           INT8_C(  -8), INT8_C(   9), INT8_C( -35), INT8_C(-101),
                           INT8_C(  83), INT8_C( 107), INT8_C( -47), INT8_C( -56),
                           INT8_C(  57), INT8_C( -88), INT8_C(-115), INT8_C( -20),
                           INT8_C(  58), INT8_C(  75), INT8_C(  56), INT8_C(  93),
                           INT8_C(  49), INT8_C(  43), INT8_C( 108), INT8_C( 118),
                           INT8_C( -79), INT8_C( 112), INT8_C(  44), INT8_C(-112),
                           INT8_C( -52), INT8_C(  10), INT8_C(  28), INT8_C( -86),
                           INT8_C(  65), INT8_C(  62), INT8_C(  86), INT8_C(-107),
                           INT8_C(  24), INT8_C( -55), INT8_C(  54), INT8_C(-110),
                           INT8_C( -33), INT8_C( 110), INT8_C(-116), INT8_C( -39),
                           INT8_C(  39), INT8_C(-112), INT8_C(  64), INT8_C(  43)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C( -53), INT8_C(   0), INT8_C( 126),
                           INT8_C(   0), INT8_C(   0), INT8_C(-128), INT8_C(  76),
                           INT8_C(  90), INT8_C( 123), INT8_C( -87), INT8_C( 106),
                           INT8_C(  52), INT8_C(  44), INT8_C( 117), INT8_C(   0),
                           INT8_C(  81), INT8_C(-120), INT8_C( -17), INT8_C( -74),
                           INT8_C(  67), INT8_C(  79), INT8_C(   0), INT8_C(   0),
                           INT8_C( -13), INT8_C( -44), INT8_C(  27), INT8_C( -97),
                           INT8_C( 102), INT8_C(   0), INT8_C(  38), INT8_C( -62),
                           INT8_C( -53), INT8_C( 117), INT8_C( 108), INT8_C(  19),
                           INT8_C(  47), INT8_C(-124), INT8_C(  69), INT8_C(  46),
                           INT8_C(  18), INT8_C(  59), INT8_C(  69), INT8_C(   0),
                           INT8_C(  -7), INT8_C( -53), INT8_C(  69), INT8_C(  48),
                           INT8_C(-107), INT8_C( -34), INT8_C( -75), INT8_C(   0),
                           INT8_C( -35), INT8_C(-116), INT8_C(  65), INT8_C(   0),
                           INT8_C(  15), INT8_C(   3), INT8_C(  45), INT8_C(  21),
                           INT8_C(  39), INT8_C(  93), INT8_C( 108), INT8_C( 125)) },
    { simde_mm512_set_epi8(INT8_C(-103), INT8_C(-124), INT8_C(  13), INT8_C( -80),
                           INT8_C( -32), INT8_C( 123), INT8_C( 115), INT8_C( -49),
                           INT8_C( 113), INT8_C( -51), INT8_C( 119), INT8_C( -67),
                           INT8_C( -21), INT8_C(  19), INT8_C( -12), INT8_C(  29),
                           INT8_C(  91), INT8_C( -64), INT8_C(  88), INT8_C(-105),
                           INT8_C(  24), INT8_C(  31), INT8_C(  77), INT8_C(  92),
                           INT8_C( -85), INT8_C(  48), INT8_C(-113), INT8_C(-114),
                           INT8_C(  16), INT8_C(  18), INT8_C( -44), INT8_C( -66),
                           INT8_C(  25), INT8_C(-105), INT8_C(-100), INT8_C( -91),
                           INT8_C(  26), INT8_C(-123), INT8_C( -33), INT8_C( -37),
                           INT8_C(  63), INT8_C(  13), INT8_C(-124), INT8_C(  41),
                           INT8_C(-104), INT8_C( -59), INT8_C(  -2), INT8_C( -54),
                           INT8_C(  73), INT8_C(   3), INT8_C( -18), INT8_C(  10),
                           INT8_C(  19), INT8_C(  58), INT8_C( -12), INT8_C( -75),
                           INT8_C( -88), INT8_C(  59), INT8_C( 104), INT8_C( -40),
                           INT8_C( -82), INT8_C(  42), INT8_C( -73), INT8_C( -94)),
      UINT64_C( 2633789449456316803),
      simde_mm512_set_epi8(INT8_C( 118), INT8_C(  44), INT8_C( -14), INT8_C(  84),
                           INT8_C( -69), INT8_C( -48), INT8_C(  40), INT8_C(  86),
                           INT8_C(  -1), INT8_C( 121), INT8_C( -40), INT8_C(  44),
                           INT8_C(  -1), INT8_C(  38), INT8_C( -44), INT8_C(  38),
                           INT8_C(  93), INT8_C(-107), INT8_C(  -4), INT8_C( -61),
                           INT8_C( -52), INT8_C(  22), INT8_C( -54), INT8_C(-125),
                           INT8_C( -29), INT8_C(  25), INT8_C( -77), INT8_C( -68),
                           INT8_C(   9), INT8_C( -35), INT8_C( -11), INT8_C(  53),
                           INT8_C(  28), INT8_C(  61), INT8_C( -35), INT8_C(-106),
                           INT8_C( -46), INT8_C( 121), INT8_C(-102), INT8_C( 121),
                           INT8_C( -54), INT8_C( -60), INT8_C(   7), INT8_C(   2),
                           INT8_C(-119), INT8_C( 111), INT8_C( -20), INT8_C( -58),
                           INT8_C( -98), INT8_C(  83), INT8_C(  32), INT8_C( -49),
                           INT8_C( -11), INT8_C(  48), INT8_C(  92), INT8_C(  47),
                           INT8_C( -38), INT8_C(  11), INT8_C(  26), INT8_C(  90),
                           INT8_C(  -5), INT8_C(  73), INT8_C(  45), INT8_C(  -2)),
      simde_mm512_set_epi8(INT8_C( -31), INT8_C( 126), INT8_C(-118), INT8_C( -57),
                           INT8_C(-126), INT8_C(  29), INT8_C( 101), INT8_C( -15),
                           INT8_C( -61), INT8_C( 118), INT8_C( 102), INT8_C(  12),
                           INT8_C( -59), INT8_C( -41), INT8_C( -60), INT8_C(  46),
                           INT8_C(  63), INT8_C(  78), INT8_C(  87), INT8_C(  18),
                           INT8_C(  18), INT8_C(  32), INT8_C( -26), INT8_C(  -6),
                           INT8_C( -20), INT8_C(-123), INT8_C(  99), INT8_C(  65),
                           INT8_C(  13), INT8_C(  25), INT8_C( 108), INT8_C(-121),
                           INT8_C(  42), INT8_C(   0), INT8_C( 104), INT8_C( -17),
                           INT8_C( 111), INT8_C(-110), INT8_C( -39), INT8_C( 125),
                           INT8_C( -50), INT8_C( -47), INT8_C(  30), INT8_C(  92),
                           INT8_C(  19), INT8_C(  -8), INT8_C(-120), INT8_C( 127),
                           INT8_C( -49), INT8_C(  23), INT8_C(  16), INT8_C( -64),
                           INT8_C( -79), INT8_C( 116), INT8_C(  -5), INT8_C( -50),
                           INT8_C(  32), INT8_C(  22), INT8_C( -42), INT8_C(  -3),
                           INT8_C(  30), INT8_C(  64), INT8_C(  96), INT8_C( -66)),
      simde_mm512_set_epi8(INT8_C(-103), INT8_C(-124), INT8_C(   0), INT8_C( -80),
                           INT8_C( -32), INT8_C( -14), INT8_C( 115), INT8_C( -49),
                           INT8_C(   0), INT8_C( -51), INT8_C( 119), INT8_C( -67),
                           INT8_C(   0), INT8_C(   0), INT8_C( -12), INT8_C(  44),
                           INT8_C(  91), INT8_C( -64), INT8_C(  88), INT8_C( -35),
                           INT8_C( -35), INT8_C(  31), INT8_C(  77), INT8_C(   0),
                           INT8_C(   0), INT8_C(  48), INT8_C(-113), INT8_C(-114),
                           INT8_C(  -4), INT8_C( -54), INT8_C( -44), INT8_C( -66),
                           INT8_C( 121), INT8_C( -58), INT8_C(-100), INT8_C( -91),
                           INT8_C(  26), INT8_C(   0), INT8_C( -33), INT8_C( -37),
                           INT8_C(  63), INT8_C(  13), INT8_C(-124), INT8_C(  41),
                           INT8_C(-104), INT8_C( -59), INT8_C(   0), INT8_C(  28),
                           INT8_C(   0), INT8_C( -38), INT8_C(  -2), INT8_C(   0),
                           INT8_C(  19), INT8_C(  58), INT8_C( -12), INT8_C(   0),
                           INT8_C(  -2), INT8_C(  59), INT8_C( 104), INT8_C( -40),
                           INT8_C( -82), INT8_C(  42), INT8_C(  -2), INT8_C(   0)) },
    { simde_mm512_set_epi8(INT8_C( 117), INT8_C(  69), INT8_C( 121), INT8_C( -45),
                           INT8_C(  30), INT8_C( -73), INT8_C(   2), INT8_C( -40),
                           INT8_C(  95), INT8_C(  -3), INT8_C(  16), INT8_C( -78),
                           INT8_C(-128), INT8_C( -41), INT8_C( -66), INT8_C(  66),
                           INT8_C(  93), INT8_C( -32), INT8_C( -50), INT8_C(  -2),
                           INT8_C( -61), INT8_C(  29), INT8_C( -88), INT8_C(-118),
                           INT8_C( -27), INT8_C(  42), INT8_C(  78), INT8_C( -46),
                           INT8_C( -79), INT8_C(  38), INT8_C( -75), INT8_C(  14),
                           INT8_C(-118), INT8_C(-114), INT8_C(-120), INT8_C(  42),
                           INT8_C(   4), INT8_C(  79), INT8_C( -84), INT8_C(-110),
                           INT8_C(   0), INT8_C(  85), INT8_C( -20), INT8_C(  61),
                           INT8_C(  40), INT8_C( -75), INT8_C(  69), INT8_C( -99),
                           INT8_C(  73), INT8_C( -34), INT8_C( -14), INT8_C(  72),
                           INT8_C( 101), INT8_C(  96), INT8_C(-114), INT8_C(-124),
                           INT8_C( -87), INT8_C(  43), INT8_C(-118), INT8_C( 114),
                           INT8_C( -88), INT8_C(   8), INT8_C( -52), INT8_C(  75)),
      UINT64_C(14890918166471265655),
      simde_mm512_set_epi8(INT8_C( -56), INT8_C( -70), INT8_C(  66), INT8_C(-111),
                           INT8_C( -69), INT8_C(  15), INT8_C( -82), INT8_C( -12),
                           INT8_C( -89), INT8_C(  37), INT8_C(  80), INT8_C( 120),
                           INT8_C( -83), INT8_C(-120), INT8_C(  95), INT8_C(  21),
                           INT8_C(  91), INT8_C( -97), INT8_C( -72), INT8_C(  42),
                           INT8_C(  22), INT8_C( -70), INT8_C(  71), INT8_C( -78),
                           INT8_C(  -5), INT8_C(  52), INT8_C( -22), INT8_C( -34),
                           INT8_C(  16), INT8_C(  92), INT8_C(  91), INT8_C( -72),
                           INT8_C(   3), INT8_C( -31), INT8_C( -95), INT8_C( -56),
                           INT8_C( -50), INT8_C(  68), INT8_C( -24), INT8_C( -50),
                           INT8_C(  94), INT8_C(  67), INT8_C( 108), INT8_C(-118),
                           INT8_C( -65), INT8_C(  31), INT8_C(  70), INT8_C( 108),
                           INT8_C( -66), INT8_C( 107), INT8_C( -85), INT8_C(  38),
                           INT8_C(   2), INT8_C(  32), INT8_C(  56), INT8_C(  66),
                           INT8_C(  -2), INT8_C( -74), INT8_C( 112), INT8_C(  10),
                           INT8_C(  64), INT8_C( 100), INT8_C( -55), INT8_C(  83)),
      simde_mm512_set_epi8(INT8_C( -69), INT8_C( -45), INT8_C(  23), INT8_C(  70),
                           INT8_C(  22), INT8_C( 113), INT8_C(  75), INT8_C(-117),
                           INT8_C(  69), INT8_C( -74), INT8_C(  40), INT8_C( -39),
                           INT8_C( -51), INT8_C( -91), INT8_C(  25), INT8_C(  -4),
                           INT8_C( -12), INT8_C( -13), INT8_C( -77), INT8_C(  75),
                           INT8_C(-116), INT8_C( -36), INT8_C(  38), INT8_C( -52),
                           INT8_C(  13), INT8_C( -52), INT8_C(-100), INT8_C( -46),
                           INT8_C(  13), INT8_C(  83), INT8_C( -94), INT8_C( 102),
                           INT8_C( 116), INT8_C( -60), INT8_C(  44), INT8_C(  -7),
                           INT8_C( 104), INT8_C( -50), INT8_C( -30), INT8_C(  17),
                           INT8_C(  13), INT8_C(-107), INT8_C( 111), INT8_C( -13),
                           INT8_C(  17), INT8_C( -45), INT8_C( -31), INT8_C(  76),
                           INT8_C(-102), INT8_C( -71), INT8_C( 116), INT8_C(  72),
                           INT8_C( -11), INT8_C( -97), INT8_C(  93), INT8_C(  48),
                           INT8_C( -75), INT8_C( -90), INT8_C( -10), INT8_C( -78),
                           INT8_C(  -8), INT8_C( -10), INT8_C(  48), INT8_C( -11)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C( 121), INT8_C( -45),
                           INT8_C(  37), INT8_C(  95), INT8_C( -69), INT8_C( -40),
                           INT8_C(  80), INT8_C(  -3), INT8_C( -12), INT8_C( -78),
                           INT8_C(-128), INT8_C(   0), INT8_C( -82), INT8_C(   0),
                           INT8_C(  93), INT8_C( -32), INT8_C(   0), INT8_C(  -2),
                           INT8_C(   0), INT8_C(  29), INT8_C(  52), INT8_C(   0),
                           INT8_C( -27), INT8_C(  42), INT8_C(   0), INT8_C( -46),
                           INT8_C( -72), INT8_C(  16), INT8_C( -75), INT8_C(  52),
                           INT8_C(-118), INT8_C(   0), INT8_C(-120), INT8_C(  42),
                           INT8_C( -50), INT8_C(  79), INT8_C(   0), INT8_C(  70),
                           INT8_C( -95), INT8_C(   0), INT8_C(   3), INT8_C(  61),
                           INT8_C(  70), INT8_C(   0), INT8_C(   0), INT8_C( -99),
                           INT8_C(  73), INT8_C(   0), INT8_C( -14), INT8_C(  72),
                           INT8_C(   0), INT8_C(   0), INT8_C(-114), INT8_C(  83),
                           INT8_C( -87), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -88), INT8_C(   0), INT8_C(  83), INT8_C(   0)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_mask_shuffle_epi8(test_vec[i].src, test_vec[i].k, test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_maskz_shuffle_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__mmask64 k;
    simde__m512i a;
    simde__m512i b;
    simde__m512i r;
  } test_vec[8] = {
    { UINT64_C(17286015531074160252),
      simde_mm512_set_epi8(INT8_C(-115), INT8_C( -27), INT8_C(  62), INT8_C( -85),
                           INT8_C(  49), INT8_C(-115), INT8_C(  38), INT8_C(   4),
                           INT8_C(  92), INT8_C( 116), INT8_C( -78), INT8_C( -19),
                           INT8_C( -73), INT8_C(  22), INT8_C( -66), INT8_C( -29),
                           INT8_C(  55), INT8_C(  78), INT8_C( -45), INT8_C(-119),
                           INT8_C(  30), INT8_C( -29), INT8_C( -23), INT8_C(  89),
                           INT8_C(  15), INT8_C( 119), INT8_C( -88), INT8_C( 109),
                           INT8_C( -16), INT8_C( -10), INT8_C(   0), INT8_C( -18),
                           INT8_C(   1), INT8_C( 116), INT8_C(  62), INT8_C( -73),
                           INT8_C(-122), INT8_C(   0), INT8_C( 111), INT8_C(  95),
                           INT8_C( -20), INT8_C(   3), INT8_C( 122), INT8_C(-121),
                           INT8_C(  13), INT8_C(  25), INT8_C( -35), INT8_C(-127),
                           INT8_C(  82), INT8_C(  90), INT8_C(  53), INT8_C( 123),
                           INT8_C(  73), INT8_C( 108), INT8_C( -18), INT8_C(  15),
                           INT8_C(  81), INT8_C( -27), INT8_C( 102), INT8_C( 118),
                           INT8_C(  39), INT8_C( -77), INT8_C(  45), INT8_C(  81)),
      simde_mm512_set_epi8(INT8_C(  68), INT8_C(-108), INT8_C(-121), INT8_C(-115),
                           INT8_C( -59), INT8_C( -78), INT8_C(-111), INT8_C(  56),
                           INT8_C(   9), INT8_C(-121), INT8_C( 120), INT8_C( -36),
                           INT8_C(  36), INT8_C(-103), INT8_C(-104), INT8_C(  25),
                           INT8_C(-111), INT8_C( -63), INT8_C( -35), INT8_C(-120),
                           INT8_C(  28), INT8_C( -44), INT8_C( -26), INT8_C( -86),
                           INT8_C( -13), INT8_C(  53), INT8_C( -88), INT8_C(-107),
                           INT8_C(  68), INT8_C(  42), INT8_C(-118), INT8_C( 111),
                           INT8_C(  54), INT8_C( -58), INT8_C( -13), INT8_C(  27),
                           INT8_C(  23), INT8_C(  41), INT8_C(-119), INT8_C(  44),
                           INT8_C(   7), INT8_C(-120), INT8_C(  32), INT8_C( -43),
                           INT8_C( 114), INT8_C( -72), INT8_C(  73), INT8_C( -96),
                           INT8_C(  96), INT8_C( 110), INT8_C( -81), INT8_C( -76),
                           INT8_C( 103), INT8_C(-100), INT8_C( -22), INT8_C(  18),
                           INT8_C( 115), INT8_C(  54), INT8_C( -40), INT8_C( 125),
                           INT8_C( 110), INT8_C(  31), INT8_C(  51), INT8_C(-104)),
      simde_mm512_set_epi8(INT8_C( -19), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   4),
                           INT8_C(  38), INT8_C(   0), INT8_C(   4), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( 109), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -20), INT8_C( 111), INT8_C(   0), INT8_C( -73),
                           INT8_C( -20), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  25), INT8_C(   0), INT8_C( 111), INT8_C(   0),
                           INT8_C(  81), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -27), INT8_C(   0), INT8_C(  53),
                           INT8_C(  90), INT8_C(  82), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C( 9031211210081693899),
      simde_mm512_set_epi8(INT8_C(-106), INT8_C( -18), INT8_C(  65), INT8_C(-104),
                           INT8_C(  81), INT8_C(  38), INT8_C( -84), INT8_C(  -2),
                           INT8_C( -14), INT8_C(  85), INT8_C( -80), INT8_C(  80),
                           INT8_C(  48), INT8_C(  93), INT8_C(  79), INT8_C( 127),
                           INT8_C(  16), INT8_C(  41), INT8_C(  54), INT8_C(-116),
                           INT8_C(  17), INT8_C(  42), INT8_C( -86), INT8_C(  38),
                           INT8_C(-118), INT8_C( -56), INT8_C(  60), INT8_C(  19),
                           INT8_C(-100), INT8_C(-107), INT8_C( 105), INT8_C( -76),
                           INT8_C(  10), INT8_C(  -9), INT8_C( -12), INT8_C( -56),
                           INT8_C( -71), INT8_C(  96), INT8_C(   6), INT8_C(  24),
                           INT8_C(  69), INT8_C(  73), INT8_C( -27), INT8_C(   3),
                           INT8_C( -95), INT8_C(  50), INT8_C( -67), INT8_C( -39),
                           INT8_C(  97), INT8_C(  62), INT8_C( 101), INT8_C(  56),
                           INT8_C( -79), INT8_C(  83), INT8_C( -99), INT8_C( -56),
                           INT8_C( -17), INT8_C( -56), INT8_C(  -8), INT8_C( -16),
                           INT8_C(  84), INT8_C( -95), INT8_C( -73), INT8_C(  54)),
      simde_mm512_set_epi8(INT8_C(  63), INT8_C( -51), INT8_C(  87), INT8_C(  32),
                           INT8_C( -65), INT8_C(  55), INT8_C(  14), INT8_C(  81),
                           INT8_C(-123), INT8_C(-100), INT8_C( -39), INT8_C( -44),
                           INT8_C(  22), INT8_C( 112), INT8_C(  16), INT8_C(  15),
                           INT8_C(-104), INT8_C(-102), INT8_C( 102), INT8_C( -95),
                           INT8_C(  69), INT8_C(  13), INT8_C( -21), INT8_C(  45),
                           INT8_C(  62), INT8_C(-120), INT8_C(-111), INT8_C(  32),
                           INT8_C(-107), INT8_C( -30), INT8_C(  99), INT8_C( -64),
                           INT8_C(   8), INT8_C( -42), INT8_C(  81), INT8_C( -34),
                           INT8_C( -46), INT8_C(  26), INT8_C(  31), INT8_C(  -2),
                           INT8_C(  68), INT8_C(  -7), INT8_C( -71), INT8_C(  46),
                           INT8_C( -21), INT8_C( -73), INT8_C(  21), INT8_C(  83),
                           INT8_C(-108), INT8_C( -97), INT8_C( -69), INT8_C(  73),
                           INT8_C(  57), INT8_C( -37), INT8_C(  21), INT8_C(  82),
                           INT8_C(-119), INT8_C(-126), INT8_C( 126), INT8_C(  91),
                           INT8_C( 115), INT8_C(  31), INT8_C( -79), INT8_C(  28)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C( -14), INT8_C( 127),
                           INT8_C(   0), INT8_C( -14), INT8_C(   0), INT8_C(  79),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( 127), INT8_C(   0), INT8_C(-106),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  60), INT8_C(  54), INT8_C(   0), INT8_C(   0),
                           INT8_C(  41), INT8_C(   0), INT8_C(   0), INT8_C( -76),
                           INT8_C(   0), INT8_C(   0), INT8_C(-100), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  96), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  -9),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -95),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -99),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  84), INT8_C(   0), INT8_C(   0), INT8_C(  56)) },
    { UINT64_C( 6828010367541473016),
      simde_mm512_set_epi8(INT8_C(  84), INT8_C( -96), INT8_C(  87), INT8_C( -22),
                           INT8_C(  -5), INT8_C(  -3), INT8_C(-127), INT8_C(  41),
                           INT8_C(  74), INT8_C(  72), INT8_C(  -4), INT8_C(  28),
                           INT8_C(-115), INT8_C(  93), INT8_C( 102), INT8_C(  44),
                           INT8_C(-103), INT8_C( -29), INT8_C( -50), INT8_C(  48),
                           INT8_C( -96), INT8_C( -50), INT8_C(  46), INT8_C( -65),
                           INT8_C(   4), INT8_C(  43), INT8_C( -75), INT8_C(  97),
                           INT8_C( -26), INT8_C(-103), INT8_C(  71), INT8_C(-107),
                           INT8_C(  91), INT8_C(  45), INT8_C( -11), INT8_C(  47),
                           INT8_C(  29), INT8_C(  25), INT8_C(  26), INT8_C(  -9),
                           INT8_C(  10), INT8_C(  36), INT8_C( -79), INT8_C( -53),
                           INT8_C(  41), INT8_C(   1), INT8_C( -23), INT8_C( -63),
                           INT8_C(-127), INT8_C(  68), INT8_C(  48), INT8_C(  36),
                           INT8_C(  89), INT8_C(-112), INT8_C( -31), INT8_C( 120),
                           INT8_C(  35), INT8_C(  62), INT8_C( -21), INT8_C(-114),
                           INT8_C(-104), INT8_C(  57), INT8_C(  42), INT8_C(-111)),
      simde_mm512_set_epi8(INT8_C(  96), INT8_C( -64), INT8_C( -23), INT8_C( -46),
                           INT8_C( -29), INT8_C( -71), INT8_C(  71), INT8_C(  90),
                           INT8_C(  44), INT8_C( -92), INT8_C( -31), INT8_C(  26),
                           INT8_C( -99), INT8_C( -53), INT8_C( 117), INT8_C(  18),
                           INT8_C( -63), INT8_C(  45), INT8_C(  12), INT8_C(  24),
                           INT8_C(-108), INT8_C(  18), INT8_C( -60), INT8_C(  28),
                           INT8_C(  50), INT8_C( -11), INT8_C( -68), INT8_C( -31),
                           INT8_C( 105), INT8_C(-106), INT8_C(  98), INT8_C(  51),
                           INT8_C(  58), INT8_C( 103), INT8_C( 111), INT8_C(-127),
                           INT8_C(  68), INT8_C( -56), INT8_C( 124), INT8_C(-119),
                           INT8_C(  74), INT8_C( -62), INT8_C(-116), INT8_C(  37),
                           INT8_C( -12), INT8_C( 114), INT8_C(   0), INT8_C(  61),
                           INT8_C( 103), INT8_C(  -4), INT8_C(-105), INT8_C( -68),
                           INT8_C(  39), INT8_C(-100), INT8_C( -93), INT8_C(  11),
                           INT8_C( -80), INT8_C( -19), INT8_C( -22), INT8_C( -39),
                           INT8_C( 127), INT8_C( -38), INT8_C(-125), INT8_C(-111)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  74), INT8_C(   0),
                           INT8_C( -22), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  93),
                           INT8_C(   0), INT8_C( -50), INT8_C(  48), INT8_C( -65),
                           INT8_C(   0), INT8_C(-103), INT8_C(   0), INT8_C(  48),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  25), INT8_C(   0), INT8_C(  91), INT8_C(   0),
                           INT8_C( -53), INT8_C(   0), INT8_C(  47), INT8_C(   0),
                           INT8_C(  25), INT8_C(   0), INT8_C(   0), INT8_C( -79),
                           INT8_C(   0), INT8_C(   1), INT8_C( -63), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  35), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(-127), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C(18325019528117086600),
      simde_mm512_set_epi8(INT8_C( 122), INT8_C( -54), INT8_C(  50), INT8_C( 123),
                           INT8_C( -31), INT8_C( -74), INT8_C( -64), INT8_C(  54),
                           INT8_C( -81), INT8_C(  60), INT8_C(  31), INT8_C( -23),
                           INT8_C( 108), INT8_C(-119), INT8_C( -92), INT8_C( -80),
                           INT8_C( -30), INT8_C( -37), INT8_C(  51), INT8_C( -36),
                           INT8_C(   8), INT8_C(  52), INT8_C(  97), INT8_C( 123),
                           INT8_C( -49), INT8_C(-124), INT8_C(  95), INT8_C( -83),
                           INT8_C(  70), INT8_C( -50), INT8_C( -61), INT8_C(  25),
                           INT8_C( -97), INT8_C(  28), INT8_C( -58), INT8_C(  11),
                           INT8_C( -14), INT8_C( 126), INT8_C(  81), INT8_C(  45),
                           INT8_C( -23), INT8_C( 120), INT8_C( -83), INT8_C( -16),
                           INT8_C(   7), INT8_C(  51), INT8_C( -57), INT8_C( -50),
                           INT8_C( -21), INT8_C(  98), INT8_C(  88), INT8_C(   0),
                           INT8_C( -66), INT8_C(   3), INT8_C( 124), INT8_C(-113),
                           INT8_C(  50), INT8_C(  88), INT8_C( -85), INT8_C( -93),
                           INT8_C( -44), INT8_C( -13), INT8_C( -94), INT8_C(  17)),
      simde_mm512_set_epi8(INT8_C( -13), INT8_C( -12), INT8_C(-124), INT8_C(  96),
                           INT8_C( -13), INT8_C( -98), INT8_C(  99), INT8_C( -13),
                           INT8_C(  56), INT8_C( -45), INT8_C(-108), INT8_C( -19),
                           INT8_C(-124), INT8_C( -27), INT8_C(  22), INT8_C( 126),
                           INT8_C(-106), INT8_C( -68), INT8_C( -60), INT8_C(   8),
                           INT8_C(  60), INT8_C(  93), INT8_C( -33), INT8_C( -27),
                           INT8_C(  -7), INT8_C(  27), INT8_C(-122), INT8_C( -38),
                           INT8_C(  23), INT8_C(   6), INT8_C(  45), INT8_C( -21),
                           INT8_C( -23), INT8_C(-101), INT8_C( 116), INT8_C( 127),
                           INT8_C(  96), INT8_C(  40), INT8_C( -97), INT8_C(  40),
                           INT8_C(  86), INT8_C( -44), INT8_C(  70), INT8_C( -71),
                           INT8_C(  62), INT8_C( -21), INT8_C(  66), INT8_C(  68),
                           INT8_C( -87), INT8_C( -61), INT8_C(  48), INT8_C( -70),
                           INT8_C(  18), INT8_C( -78), INT8_C( -98), INT8_C( 117),
                           INT8_C(  74), INT8_C(  32), INT8_C(  93), INT8_C( 125),
                           INT8_C( -47), INT8_C( -60), INT8_C( -86), INT8_C( 117)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -80),
                           INT8_C(   0), INT8_C(   0), INT8_C( 108), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  60), INT8_C( -54),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -36), INT8_C(  51), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -49), INT8_C(   0), INT8_C(  51), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -16), INT8_C( -97),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  45),
                           INT8_C( 120), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  51), INT8_C( -16),
                           INT8_C(   0), INT8_C(   0), INT8_C(  17), INT8_C(   0),
                           INT8_C( -13), INT8_C(   0), INT8_C(   0), INT8_C( -85),
                           INT8_C(   3), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C( 7677112093376593822),
      simde_mm512_set_epi8(INT8_C( -53), INT8_C(  34), INT8_C(   9), INT8_C(  64),
                           INT8_C( -61), INT8_C( -25), INT8_C(-115), INT8_C( 100),
                           INT8_C(  65), INT8_C(   8), INT8_C(  69), INT8_C(  -8),
                           INT8_C( -15), INT8_C( -51), INT8_C(   1), INT8_C(  90),
                           INT8_C( 115), INT8_C(  51), INT8_C( -91), INT8_C(  56),
                           INT8_C(  64), INT8_C( -39), INT8_C(-119), INT8_C( -28),
                           INT8_C( -54), INT8_C(  28), INT8_C(  54), INT8_C(  -8),
                           INT8_C( -54), INT8_C(-128), INT8_C( -28), INT8_C( -71),
                           INT8_C( 107), INT8_C( -66), INT8_C(-114), INT8_C( -88),
                           INT8_C(  34), INT8_C( -83), INT8_C( -21), INT8_C( -64),
                           INT8_C( 121), INT8_C( -20), INT8_C( -89), INT8_C( -94),
                           INT8_C( 112), INT8_C( -27), INT8_C(  81), INT8_C( -54),
                           INT8_C( -64), INT8_C(-114), INT8_C(  48), INT8_C( -89),
                           INT8_C( -61), INT8_C(  26), INT8_C(  43), INT8_C(  29),
                           INT8_C(   0), INT8_C(  64), INT8_C( 123), INT8_C( -67),
                           INT8_C(  15), INT8_C( 120), INT8_C(  36), INT8_C(  40)),
      simde_mm512_set_epi8(INT8_C( 113), INT8_C(  32), INT8_C(  71), INT8_C(  55),
                           INT8_C( -26), INT8_C(  82), INT8_C( -81), INT8_C( -20),
                           INT8_C( -55), INT8_C( 112), INT8_C(  45), INT8_C(  37),
                           INT8_C(  67), INT8_C( -69), INT8_C(  64), INT8_C(  39),
                           INT8_C(  72), INT8_C(  45), INT8_C( 120), INT8_C(  -5),
                           INT8_C(-109), INT8_C(  62), INT8_C(  17), INT8_C(  31),
                           INT8_C( -30), INT8_C( -58), INT8_C(  56), INT8_C(  21),
                           INT8_C(  72), INT8_C( -74), INT8_C( -40), INT8_C( 120),
                           INT8_C(  95), INT8_C( 108), INT8_C(  32), INT8_C(  64),
                           INT8_C(-128), INT8_C( 102), INT8_C( -21), INT8_C(  28),
                           INT8_C( 105), INT8_C(  52), INT8_C(  85), INT8_C(-104),
                           INT8_C(  57), INT8_C( -31), INT8_C( -38), INT8_C(-124),
                           INT8_C(-107), INT8_C(  -2), INT8_C(  55), INT8_C(  46),
                           INT8_C( -71), INT8_C(  77), INT8_C(  18), INT8_C(  70),
                           INT8_C(  89), INT8_C( 125), INT8_C( -42), INT8_C(-125),
                           INT8_C( 121), INT8_C( -11), INT8_C( -69), INT8_C( -59)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(  90), INT8_C(  65), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -15), INT8_C(   0), INT8_C(  90), INT8_C(   0),
                           INT8_C( -28), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  51), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -54),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -21), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(-114),
                           INT8_C(   0), INT8_C(  48), INT8_C( 120), INT8_C(  64),
                           INT8_C(  43), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  43), INT8_C(   0), INT8_C(   0), INT8_C(   0)) },
    { UINT64_C( 4840581956081845689),
      simde_mm512_set_epi8(INT8_C( 122), INT8_C(-108), INT8_C( -70), INT8_C( -63),
                           INT8_C(  56), INT8_C(  71), INT8_C( -14), INT8_C(  49),
                           INT8_C( -73), INT8_C(  53), INT8_C( -29), INT8_C(   3),
                           INT8_C( -73), INT8_C(  43), INT8_C( -22), INT8_C(  85),
                           INT8_C( -26), INT8_C(  -9), INT8_C(  66), INT8_C(   1),
                           INT8_C( -13), INT8_C(  60), INT8_C(-119), INT8_C( -83),
                           INT8_C(-122), INT8_C( -64), INT8_C( -83), INT8_C( -74),
                           INT8_C( 119), INT8_C(  -8), INT8_C(  12), INT8_C( 113),
                           INT8_C( -12), INT8_C( -84), INT8_C(   6), INT8_C(  69),
                           INT8_C(   2), INT8_C( -75), INT8_C( -34), INT8_C(-126),
                           INT8_C(   3), INT8_C(-128), INT8_C(  -9), INT8_C(  24),
                           INT8_C(  11), INT8_C( -94), INT8_C( -32), INT8_C( 110),
                           INT8_C(  33), INT8_C( -24), INT8_C( 125), INT8_C(  35),
                           INT8_C(-103), INT8_C( -48), INT8_C( -22), INT8_C(  38),
                           INT8_C( -81), INT8_C(   9), INT8_C( -11), INT8_C(-124),
                           INT8_C(  71), INT8_C(  31), INT8_C( -42), INT8_C(  93)),
      simde_mm512_set_epi8(INT8_C(  53), INT8_C(  77), INT8_C(  63), INT8_C( -84),
                           INT8_C(  27), INT8_C(  22), INT8_C(   3), INT8_C( -37),
                           INT8_C(  65), INT8_C( 118), INT8_C(-126), INT8_C(  97),
                           INT8_C( 109), INT8_C(   7), INT8_C(-114), INT8_C( -75),
                           INT8_C(-125), INT8_C( 121), INT8_C(-128), INT8_C( 103),
                           INT8_C(   0), INT8_C( 101), INT8_C( -41), INT8_C(  89),
                           INT8_C( -83), INT8_C( -65), INT8_C(   9), INT8_C(  -7),
                           INT8_C( -63), INT8_C(  13), INT8_C( 105), INT8_C(  92),
                           INT8_C( -18), INT8_C( -21), INT8_C(-102), INT8_C(-114),
                           INT8_C(  74), INT8_C( 121), INT8_C( -45), INT8_C(  52),
                           INT8_C( -63), INT8_C( -93), INT8_C(  98), INT8_C( 106),
                           INT8_C(-109), INT8_C( -47), INT8_C(  37), INT8_C(  70),
                           INT8_C( 100), INT8_C( 121), INT8_C(  18), INT8_C(  28),
                           INT8_C(-117), INT8_C( 107), INT8_C(   3), INT8_C( -62),
                           INT8_C(  42), INT8_C(  72), INT8_C(  91), INT8_C(  86),
                           INT8_C( -72), INT8_C(   9), INT8_C( -80), INT8_C( 118)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C( -70), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -73), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -70), INT8_C( -73), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(-122),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(-119),
                           INT8_C(   0), INT8_C(   0), INT8_C(-119), INT8_C(   0),
                           INT8_C(   0), INT8_C(  66), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -75), INT8_C( -34), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -94), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(-124), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-103), INT8_C(   0), INT8_C(   0),
                           INT8_C( -48), INT8_C(   0), INT8_C(-103), INT8_C(   9),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   9)) },
    { UINT64_C(17498311407133456191),
      simde_mm512_set_epi8(INT8_C(  61), INT8_C( -89), INT8_C(  84), INT8_C( -94),
                           INT8_C(  31), INT8_C(-116), INT8_C( -67), INT8_C(-102),
                           INT8_C( -72), INT8_C( -91), INT8_C(-105), INT8_C(-108),
                           INT8_C( -44), INT8_C(  74), INT8_C( -28), INT8_C( 124),
                           INT8_C( 120), INT8_C( -41), INT8_C( -79), INT8_C( 122),
                           INT8_C(  87), INT8_C(-119), INT8_C(  54), INT8_C(  -2),
                           INT8_C( -47), INT8_C(  84), INT8_C(-126), INT8_C( -64),
                           INT8_C(  14), INT8_C(  11), INT8_C(  37), INT8_C( -23),
                           INT8_C(  67), INT8_C( 124), INT8_C(  58), INT8_C( -94),
                           INT8_C(  30), INT8_C( -33), INT8_C(  70), INT8_C( -24),
                           INT8_C(  38), INT8_C( -97), INT8_C( -56), INT8_C( -60),
                           INT8_C( -59), INT8_C(  65), INT8_C( -74), INT8_C(  45),
                           INT8_C( -11), INT8_C(  55), INT8_C( -82), INT8_C(  12),
                           INT8_C( 106), INT8_C(  22), INT8_C(-124), INT8_C(  -4),
                           INT8_C(   2), INT8_C( -81), INT8_C(  14), INT8_C(  90),
                           INT8_C(-100), INT8_C(-122), INT8_C( -35), INT8_C(  81)),
      simde_mm512_set_epi8(INT8_C(  21), INT8_C( 108), INT8_C( 125), INT8_C( -60),
                           INT8_C( -72), INT8_C(  74), INT8_C(  -5), INT8_C( -58),
                           INT8_C( -41), INT8_C(  22), INT8_C(-115), INT8_C( 102),
                           INT8_C(  59), INT8_C( -80), INT8_C( -15), INT8_C( -63),
                           INT8_C(  84), INT8_C( -71), INT8_C(   8), INT8_C(  12),
                           INT8_C( -11), INT8_C( -76), INT8_C(  62), INT8_C(  93),
                           INT8_C( -75), INT8_C( -77), INT8_C( -84), INT8_C(-108),
                           INT8_C( -35), INT8_C(  14), INT8_C( -60), INT8_C(  18),
                           INT8_C(  23), INT8_C( -60), INT8_C( -63), INT8_C(-114),
                           INT8_C( -55), INT8_C(  75), INT8_C( -99), INT8_C( -55),
                           INT8_C(  58), INT8_C(  76), INT8_C(-102), INT8_C(-118),
                           INT8_C( -30), INT8_C(  39), INT8_C( 119), INT8_C(  85),
                           INT8_C(  -8), INT8_C( -72), INT8_C( -60), INT8_C( -94),
                           INT8_C(-112), INT8_C( 119), INT8_C( 124), INT8_C(  76),
                           INT8_C( -42), INT8_C(-124), INT8_C(  54), INT8_C(  74),
                           INT8_C( -92), INT8_C(  99), INT8_C(  79), INT8_C(  -3)),
      simde_mm512_set_epi8(INT8_C(-105), INT8_C( -94), INT8_C(  84), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -91), INT8_C(   0), INT8_C( -91),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  -2), INT8_C( 122),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -79),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  11),
                           INT8_C(  38), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  30), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( -94), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  38), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   2), INT8_C(  12), INT8_C(  12),
                           INT8_C(   0), INT8_C(   0), INT8_C( -81), INT8_C(  22),
                           INT8_C(   0), INT8_C(-100), INT8_C( -11), INT8_C(   0)) },
    { UINT64_C( 3462613925466476941),
      simde_mm512_set_epi8(INT8_C(  18), INT8_C( -74), INT8_C(  14), INT8_C(  36),
                           INT8_C(  -7), INT8_C( 113), INT8_C(  40), INT8_C(  48),
                           INT8_C(-107), INT8_C( -34), INT8_C( -75), INT8_C(  85),
                           INT8_C( -35), INT8_C(-116), INT8_C(  65), INT8_C( -21),
                           INT8_C(  15), INT8_C(   3), INT8_C(  45), INT8_C(  21),
                           INT8_C(  72), INT8_C(  93), INT8_C( 108), INT8_C( 125),
                           INT8_C(   1), INT8_C(  75), INT8_C(  21), INT8_C( -36),
                           INT8_C(-126), INT8_C( 122), INT8_C(  71), INT8_C(  76),
                           INT8_C(  28), INT8_C( -56), INT8_C(  32), INT8_C( 101),
                           INT8_C(-107), INT8_C(-111), INT8_C( -88), INT8_C( -19),
                           INT8_C( -77), INT8_C(  19), INT8_C( -21), INT8_C(-111),
                           INT8_C( -68), INT8_C(  82), INT8_C(-118), INT8_C( -76),
                           INT8_C(  47), INT8_C( 127), INT8_C(  62), INT8_C( -16),
                           INT8_C(  10), INT8_C( -14), INT8_C(-100), INT8_C(  86),
                           INT8_C(  29), INT8_C( 107), INT8_C(  56), INT8_C(  21),
                           INT8_C(  24), INT8_C(  68), INT8_C( -96), INT8_C(  64)),
      simde_mm512_set_epi8(INT8_C( -57), INT8_C(  94), INT8_C(-125), INT8_C(-124),
                           INT8_C(  36), INT8_C(  57), INT8_C(  68), INT8_C( -52),
                           INT8_C(  39), INT8_C(  50), INT8_C( -48), INT8_C(  94),
                           INT8_C(  53), INT8_C(  11), INT8_C(  29), INT8_C(  65),
                           INT8_C( -82), INT8_C(-119), INT8_C( 115), INT8_C(  68),
                           INT8_C( -69), INT8_C( 118), INT8_C(  17), INT8_C(   8),
                           INT8_C( -64), INT8_C( -53), INT8_C( -42), INT8_C( 126),
                           INT8_C(  67), INT8_C(  50), INT8_C( -18), INT8_C(  76),
                           INT8_C( -19), INT8_C( 123), INT8_C( -87), INT8_C( 106),
                           INT8_C( -74), INT8_C(  44), INT8_C( 117), INT8_C( 103),
                           INT8_C(  81), INT8_C( 122), INT8_C(  56), INT8_C( -10),
                           INT8_C(  67), INT8_C(  79), INT8_C(  83), INT8_C( -38),
                           INT8_C( -13), INT8_C(  43), INT8_C(  27), INT8_C( -97),
                           INT8_C( 102), INT8_C( 126), INT8_C(  38), INT8_C( -62),
                           INT8_C( -24), INT8_C( 117), INT8_C( -38), INT8_C( -93),
                           INT8_C( -58), INT8_C(-124), INT8_C( -75), INT8_C(  10)),
      simde_mm512_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C( -75), INT8_C(  -7), INT8_C(   0), INT8_C(  65),
                           INT8_C(   0), INT8_C(   0), INT8_C(-126), INT8_C(   0),
                           INT8_C(   0), INT8_C(  75), INT8_C(   0), INT8_C( 125),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C( 122), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(-107), INT8_C(   0), INT8_C(-111),
                           INT8_C(   0), INT8_C( 101), INT8_C(   0), INT8_C( -77),
                           INT8_C(-118), INT8_C(-111), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -14)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m512i r = simde_mm512_maskz_shuffle_epi8(test_vec[i].k, test_vec[i].a, test_vec[i].b);
    simde_assert_m512i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_cmpeq_epi8_mask(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i   a;
    simde__m512i   b;
    simde__mmask64 r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C(  73), INT8_C(  68), INT8_C( -71), INT8_C( -32),
                           INT8_C( 100), INT8_C( 125), INT8_C(  89), INT8_C(  95),
                           INT8_C( -23), INT8_C(  76), INT8_C(  84), INT8_C( -43),
                           INT8_C(  86), INT8_C(  29), INT8_C(  64), INT8_C(  30),
                           INT8_C( -17), INT8_C( -61), INT8_C( 115), INT8_C( -53),
                           INT8_C(-100), INT8_C( 104), INT8_C( 111), INT8_C( -59),
                           INT8_C( -31), INT8_C(  20), INT8_C(  31), INT8_C(-121),
                           INT8_C(  90), INT8_C(  18), INT8_C(   6), INT8_C(  39),
                           INT8_C(  15), INT8_C(  62), INT8_C(  39), INT8_C( -25),
                           INT8_C(  60), INT8_C( 110), INT8_C(  45), INT8_C( 113),
                           INT8_C(  81), INT8_C(  78), INT8_C( -53), INT8_C(  11),
                           INT8_C( -27), INT8_C(-113), INT8_C(  -3), INT8_C(  14),
                           INT8_C( 109), INT8_C(  43), INT8_C( -54), INT8_C( 111),
                           INT8_C( -91), INT8_C( -21), INT8_C( 102), INT8_C(   8),
                           INT8_C( -41), INT8_C( -47), INT8_C( -90), INT8_C(   3),
                           INT8_C(  18), INT8_C(  32), INT8_C(  89), INT8_C( -62)),
      simde_mm512_set_epi8(INT8_C(  73), INT8_C(  68), INT8_C( -71), INT8_C( -46),
                           INT8_C(  72), INT8_C(  42), INT8_C(  65), INT8_C( -27),
                           INT8_C( -37), INT8_C(  76), INT8_C(  84), INT8_C( -95),
                           INT8_C( -29), INT8_C(  29), INT8_C(  64), INT8_C(  75),
                           INT8_C( -17), INT8_C( -61), INT8_C(  76), INT8_C(  88),
                           INT8_C(-100), INT8_C( -91), INT8_C( 111), INT8_C( -59),
                           INT8_C( -31), INT8_C( -17), INT8_C(  31), INT8_C(  68),
                           INT8_C(  90), INT8_C(  18), INT8_C(-110), INT8_C(  39),
                           INT8_C(  15), INT8_C(  62), INT8_C(  24), INT8_C( -25),
                           INT8_C(  80), INT8_C( 122), INT8_C( 103), INT8_C(-115),
                           INT8_C(  81), INT8_C(  24), INT8_C(  32), INT8_C(  82),
                           INT8_C( -27), INT8_C( 105), INT8_C(  -3), INT8_C(  14),
                           INT8_C( 109), INT8_C(  43), INT8_C( -54), INT8_C(-121),
                           INT8_C( -91), INT8_C(-124), INT8_C( 102), INT8_C(  46),
                           INT8_C( -41), INT8_C( 101), INT8_C(  51), INT8_C(   3),
                           INT8_C(  18), INT8_C(  32), INT8_C( -12), INT8_C( -62)),
      UINT64_C(0xe066cbadd08bea9d) },
    { simde_mm512_set_epi8(INT8_C( -84), INT8_C(-108), INT8_C(  13), INT8_C( -97),
                           INT8_C( -34), INT8_C(  27), INT8_C( 124), INT8_C(-120),
                           INT8_C(   3), INT8_C(  26), INT8_C(  43), INT8_C( -96),
                           INT8_C( -63), INT8_C(  49), INT8_C( 127), INT8_C(   0),
                           INT8_C( -20), INT8_C( -31), INT8_C( 125), INT8_C(  14),
                           INT8_C( -53), INT8_C( -87), INT8_C( 115), INT8_C( -20),
                           INT8_C( -93), INT8_C(  70), INT8_C(  29), INT8_C( -90),
                           INT8_C( 105), INT8_C( -54), INT8_C(  96), INT8_C(-106),
                           INT8_C(  94), INT8_C( -52), INT8_C( -50), INT8_C( -79),
                           INT8_C( -54), INT8_C(  78), INT8_C(  17), INT8_C(  81),
                           INT8_C(  35), INT8_C( 120), INT8_C(  47), INT8_C( -25),
                           INT8_C( 110), INT8_C(  55), INT8_C(  40), INT8_C( -31),
                           INT8_C(  93), INT8_C( -23), INT8_C(   4), INT8_C(  45),
                           INT8_C(  59), INT8_C( -33), INT8_C( 124), INT8_C( -52),
                           INT8_C(  42), INT8_C( -14), INT8_C(-119), INT8_C(  88),
                           INT8_C( -38), INT8_C( -31), INT8_C(-113), INT8_C(  33)),
      simde_mm512_set_epi8(INT8_C(  25), INT8_C(-108), INT8_C(  13), INT8_C( -97),
                           INT8_C( -34), INT8_C( 119), INT8_C( 122), INT8_C(  82),
                           INT8_C(   3), INT8_C(-111), INT8_C(  60), INT8_C( -96),
                           INT8_C(  26), INT8_C(   3), INT8_C(  -7), INT8_C(  -8),
                           INT8_C(  94), INT8_C( -31), INT8_C( -71), INT8_C(  14),
                           INT8_C(-105), INT8_C( -87), INT8_C( 115), INT8_C( -68),
                           INT8_C( -93), INT8_C(  70), INT8_C( -47), INT8_C(-106),
                           INT8_C( 105), INT8_C( -54), INT8_C(  96), INT8_C( 105),
                           INT8_C(  94), INT8_C(  84), INT8_C( -50), INT8_C( -79),
                           INT8_C( -54), INT8_C(  78), INT8_C(  17), INT8_C(  39),
                           INT8_C(  35), INT8_C( -87), INT8_C( -83), INT8_C( -25),
                           INT8_C( 110), INT8_C(   2), INT8_C( -90), INT8_C( -31),
                           INT8_C(  19), INT8_C( -23), INT8_C(   4), INT8_C(  16),
                           INT8_C(  59), INT8_C( -33), INT8_C( 124), INT8_C( 127),
                           INT8_C( -60), INT8_C( -14), INT8_C(-119), INT8_C(  88),
                           INT8_C( -38), INT8_C( 109), INT8_C(-113), INT8_C(  25)),
      UINT64_C(0x789056cebe996e7a) },
    { simde_mm512_set_epi8(INT8_C(  93), INT8_C( 110), INT8_C( 120), INT8_C(  25),
                           INT8_C( -37), INT8_C( -25), INT8_C( -34), INT8_C(-108),
                           INT8_C( -77), INT8_C(-114), INT8_C(  79), INT8_C( -50),
                           INT8_C( -94), INT8_C(  22), INT8_C( -28), INT8_C(-105),
                           INT8_C( 110), INT8_C(  29), INT8_C(  -9), INT8_C( -13),
                           INT8_C( -71), INT8_C( 107), INT8_C(-115), INT8_C(  86),
                           INT8_C(-127), INT8_C(-100), INT8_C(   1), INT8_C(  21),
                           INT8_C( -55), INT8_C( -85), INT8_C( -55), INT8_C( -81),
                           INT8_C( -41), INT8_C(  39), INT8_C(  18), INT8_C( -92),
                           INT8_C(  11), INT8_C( -32), INT8_C( -53), INT8_C(  38),
                           INT8_C( -49), INT8_C(-118), INT8_C(  20), INT8_C(  66),
                           INT8_C(-106), INT8_C(-109), INT8_C(  45), INT8_C( -24),
                           INT8_C( -47), INT8_C(  95), INT8_C(  50), INT8_C( 105),
                           INT8_C(  58), INT8_C(  25), INT8_C( -53), INT8_C( -61),
                           INT8_C( -90), INT8_C(  92), INT8_C(  83), INT8_C( 120),
                           INT8_C( 107), INT8_C( -72), INT8_C(   3), INT8_C(  -1)),
      simde_mm512_set_epi8(INT8_C(  93), INT8_C( 110), INT8_C( 120), INT8_C( -75),
                           INT8_C( -37), INT8_C( -25), INT8_C(  14), INT8_C(-108),
                           INT8_C(   5), INT8_C(-114), INT8_C(  79), INT8_C(  57),
                           INT8_C( -94), INT8_C(  22), INT8_C(   4), INT8_C(   3),
                           INT8_C(  66), INT8_C(  29), INT8_C(  -9), INT8_C(  20),
                           INT8_C(  93), INT8_C( 107), INT8_C(   6), INT8_C(  86),
                           INT8_C(  84), INT8_C(-100), INT8_C(  81), INT8_C(  21),
                           INT8_C( 117), INT8_C(  22), INT8_C( -55), INT8_C( -81),
                           INT8_C( -41), INT8_C( -17), INT8_C(  19), INT8_C( 106),
                           INT8_C( 114), INT8_C( -32), INT8_C(  98), INT8_C( -16),
                           INT8_C( -49), INT8_C(-118), INT8_C(  20), INT8_C(  66),
                           INT8_C(-106), INT8_C(-109), INT8_C(  97), INT8_C(  29),
                           INT8_C( -47), INT8_C( -47), INT8_C(  50), INT8_C(-111),
                           INT8_C(  58), INT8_C( 115), INT8_C( -53), INT8_C(  93),
                           INT8_C( -90), INT8_C( -27), INT8_C(  41), INT8_C( 120),
                           INT8_C( 119), INT8_C(  86), INT8_C( -36), INT8_C(  -1)),
      UINT64_C(0xed6c655384fcaa91) },
    { simde_mm512_set_epi8(INT8_C(  10), INT8_C(  75), INT8_C(  91), INT8_C( -99),
                           INT8_C( -88), INT8_C(  99), INT8_C( -86), INT8_C(  96),
                           INT8_C(  14), INT8_C(  -1), INT8_C(  14), INT8_C( 100),
                           INT8_C(-114), INT8_C(  63), INT8_C(  68), INT8_C(-113),
                           INT8_C( -59), INT8_C( -42), INT8_C( -14), INT8_C(-111),
                           INT8_C(   6), INT8_C(  68), INT8_C(  11), INT8_C(-108),
                           INT8_C( -62), INT8_C(  87), INT8_C( -72), INT8_C( -23),
                           INT8_C(  78), INT8_C( -18), INT8_C( -36), INT8_C(  -6),
                           INT8_C( -68), INT8_C(-115), INT8_C( -24), INT8_C( 127),
                           INT8_C( -36), INT8_C(  21), INT8_C(  38), INT8_C(-106),
                           INT8_C(  33), INT8_C( -66), INT8_C(-121), INT8_C(  36),
                           INT8_C(  24), INT8_C(  61), INT8_C(  66), INT8_C(  20),
                           INT8_C(  63), INT8_C( -18), INT8_C(  11), INT8_C(-103),
                           INT8_C( -19), INT8_C( -42), INT8_C( -69), INT8_C(  53),
                           INT8_C( -40), INT8_C( 112), INT8_C(   8), INT8_C( -69),
                           INT8_C(-102), INT8_C(  62), INT8_C(  85), INT8_C(  62)),
      simde_mm512_set_epi8(INT8_C(  10), INT8_C(  75), INT8_C( -74), INT8_C( -47),
                           INT8_C( -88), INT8_C(  99), INT8_C( -86), INT8_C(-128),
                           INT8_C(  94), INT8_C(  -1), INT8_C(  99), INT8_C( 100),
                           INT8_C( -25), INT8_C(   7), INT8_C(  59), INT8_C(-113),
                           INT8_C( 119), INT8_C( -42), INT8_C( -14), INT8_C(  79),
                           INT8_C(   4), INT8_C(-111), INT8_C(  11), INT8_C(  80),
                           INT8_C( -78), INT8_C(  87), INT8_C( -72), INT8_C(-111),
                           INT8_C( -95), INT8_C( -18), INT8_C( -36), INT8_C( -40),
                           INT8_C( -68), INT8_C(-115), INT8_C( -24), INT8_C( -50),
                           INT8_C( -36), INT8_C(  10), INT8_C(  47), INT8_C(  62),
                           INT8_C( -15), INT8_C( -66), INT8_C(-122), INT8_C(  36),
                           INT8_C( -22), INT8_C(  61), INT8_C( -11), INT8_C(  20),
                           INT8_C(  63), INT8_C(  82), INT8_C(-113), INT8_C(-103),
                           INT8_C( -19), INT8_C( -42), INT8_C( -69), INT8_C(  53),
                           INT8_C( -40), INT8_C( 112), INT8_C(   8), INT8_C( -69),
                           INT8_C(-102), INT8_C(  23), INT8_C(  85), INT8_C(  62)),
      UINT64_C(0xce516266e8559ffb) },
    { simde_mm512_set_epi8(INT8_C(  -7), INT8_C(   2), INT8_C(-111), INT8_C(  64),
                           INT8_C(-100), INT8_C(  87), INT8_C( 100), INT8_C( -30),
                           INT8_C( -39), INT8_C( -38), INT8_C( 121), INT8_C(  55),
                           INT8_C( -64), INT8_C(  81), INT8_C(  -3), INT8_C(  79),
                           INT8_C( -41), INT8_C( 118), INT8_C( -37), INT8_C( -34),
                           INT8_C( -13), INT8_C(  63), INT8_C(  26), INT8_C( -81),
                           INT8_C(  90), INT8_C(  43), INT8_C( -31), INT8_C( -17),
                           INT8_C(-100), INT8_C( -71), INT8_C(-104), INT8_C( -66),
                           INT8_C( -94), INT8_C( -89), INT8_C( 100), INT8_C(  36),
                           INT8_C(  17), INT8_C( 116), INT8_C( -30), INT8_C(  16),
                           INT8_C( 110), INT8_C(  98), INT8_C(  11), INT8_C( -42),
                           INT8_C( -78), INT8_C( -68), INT8_C( -26), INT8_C( -35),
                           INT8_C(  12), INT8_C( -40), INT8_C( -27), INT8_C( -40),
                           INT8_C(-102), INT8_C(-109), INT8_C(  39), INT8_C(  29),
                           INT8_C(  21), INT8_C(   9), INT8_C(  49), INT8_C( -13),
                           INT8_C( -49), INT8_C(   7), INT8_C(  91), INT8_C(  15)),
      simde_mm512_set_epi8(INT8_C(  78), INT8_C(   2), INT8_C( -91), INT8_C(  64),
                           INT8_C(-100), INT8_C(  41), INT8_C( -34), INT8_C( -46),
                           INT8_C( -39), INT8_C(  31), INT8_C(  13), INT8_C(  55),
                           INT8_C( -42), INT8_C(  33), INT8_C(  -3), INT8_C(  79),
                           INT8_C( -41), INT8_C( 118), INT8_C( -37), INT8_C(  90),
                           INT8_C( -13), INT8_C(  63), INT8_C(  51), INT8_C( -81),
                           INT8_C(  90), INT8_C(  43), INT8_C( -31), INT8_C(-112),
                           INT8_C(-100), INT8_C(  41), INT8_C(-104), INT8_C( -66),
                           INT8_C( -94), INT8_C( -89), INT8_C( -85), INT8_C(-109),
                           INT8_C( 113), INT8_C( 116), INT8_C( 100), INT8_C(  16),
                           INT8_C(   5), INT8_C( -50), INT8_C( -51), INT8_C( -42),
                           INT8_C( -95), INT8_C( -68), INT8_C( -26), INT8_C( -35),
                           INT8_C( -73), INT8_C(  71), INT8_C(  65), INT8_C( -40),
                           INT8_C(-102), INT8_C(   7), INT8_C(  94), INT8_C(  29),
                           INT8_C(  65), INT8_C(   9), INT8_C(  49), INT8_C( -13),
                           INT8_C( -33), INT8_C(   7), INT8_C(-101), INT8_C(  15)),
      UINT64_C(0x5893edebc5171975) },
    { simde_mm512_set_epi8(INT8_C( -34), INT8_C( -12), INT8_C( 105), INT8_C(-124),
                           INT8_C( -33), INT8_C( -79), INT8_C(  -6), INT8_C(  54),
                           INT8_C(  81), INT8_C( -11), INT8_C(  67), INT8_C(  63),
                           INT8_C( 103), INT8_C( 119), INT8_C( -89), INT8_C(  40),
                           INT8_C(   8), INT8_C( -38), INT8_C(  71), INT8_C(  66),
                           INT8_C(-106), INT8_C( -45), INT8_C(  18), INT8_C( 100),
                           INT8_C( 122), INT8_C(  93), INT8_C( -42), INT8_C(   5),
                           INT8_C( -39), INT8_C(  37), INT8_C( -70), INT8_C(  13),
                           INT8_C(  99), INT8_C( -57), INT8_C( -88), INT8_C( -36),
                           INT8_C(-103), INT8_C(  25), INT8_C(  94), INT8_C(-107),
                           INT8_C( -32), INT8_C( -12), INT8_C( -14), INT8_C(  32),
                           INT8_C( -38), INT8_C(  10), INT8_C(  89), INT8_C( -69),
                           INT8_C(  -8), INT8_C(  69), INT8_C( -20), INT8_C(-122),
                           INT8_C( -75), INT8_C( -71), INT8_C(   3), INT8_C( 102),
                           INT8_C( 119), INT8_C( -58), INT8_C( -49), INT8_C(  80),
                           INT8_C( -15), INT8_C( -97), INT8_C(  45), INT8_C(  96)),
      simde_mm512_set_epi8(INT8_C( -34), INT8_C( -12), INT8_C(  81), INT8_C(-115),
                           INT8_C( -33), INT8_C( -79), INT8_C(-117), INT8_C( -34),
                           INT8_C(  81), INT8_C( -11), INT8_C( -63), INT8_C( -61),
                           INT8_C(  53), INT8_C( 119), INT8_C(  26), INT8_C(  40),
                           INT8_C(   8), INT8_C( -38), INT8_C(  25), INT8_C( -23),
                           INT8_C( -16), INT8_C( -45), INT8_C( -64), INT8_C( 100),
                           INT8_C(  91), INT8_C(  93), INT8_C( -42), INT8_C(   5),
                           INT8_C(  81), INT8_C( -76), INT8_C( -70), INT8_C(  13),
                           INT8_C(  26), INT8_C( -57), INT8_C( -88), INT8_C( -64),
                           INT8_C( -68), INT8_C( -91), INT8_C(-123), INT8_C(  38),
                           INT8_C( -32), INT8_C(  29), INT8_C(  82), INT8_C(  54),
                           INT8_C(-107), INT8_C(  10), INT8_C(  89), INT8_C(  28),
                           INT8_C( -27), INT8_C(  41), INT8_C( -20), INT8_C(-122),
                           INT8_C( -75), INT8_C( -71), INT8_C(   3), INT8_C( -30),
                           INT8_C(  97), INT8_C(  18), INT8_C( -90), INT8_C( 107),
                           INT8_C(  99), INT8_C(  10), INT8_C(  45), INT8_C(  96)),
      UINT64_C(0xccc5c57360863e03) },
    { simde_mm512_set_epi8(INT8_C(  48), INT8_C(  94), INT8_C( 112), INT8_C(-107),
                           INT8_C( -34), INT8_C( -86), INT8_C(  65), INT8_C(  92),
                           INT8_C(  97), INT8_C( -99), INT8_C(  28), INT8_C(  47),
                           INT8_C(-117), INT8_C( -22), INT8_C(-111), INT8_C( -67),
                           INT8_C( 113), INT8_C(-107), INT8_C( -23), INT8_C(  77),
                           INT8_C(  60), INT8_C( 104), INT8_C(-116), INT8_C( -86),
                           INT8_C(-113), INT8_C( -79), INT8_C( -64), INT8_C( -15),
                           INT8_C(-123), INT8_C(  99), INT8_C(  25), INT8_C(  27),
                           INT8_C( -40), INT8_C( 126), INT8_C( -66), INT8_C( -45),
                           INT8_C(  57), INT8_C( -30), INT8_C( -12), INT8_C(  16),
                           INT8_C( 122), INT8_C( 124), INT8_C( -75), INT8_C(  50),
                           INT8_C(  -6), INT8_C(  41), INT8_C( -47), INT8_C(  -3),
                           INT8_C(  29), INT8_C( -20), INT8_C( -45), INT8_C( -46),
                           INT8_C( -45), INT8_C( -14), INT8_C(  99), INT8_C(  84),
                           INT8_C( -62), INT8_C( -99), INT8_C(-104), INT8_C( -78),
                           INT8_C( 106), INT8_C(-117), INT8_C( -94), INT8_C(   3)),
      simde_mm512_set_epi8(INT8_C( -88), INT8_C( -74), INT8_C(   2), INT8_C( -83),
                           INT8_C(-112), INT8_C( -91), INT8_C(  65), INT8_C(  92),
                           INT8_C(  97), INT8_C(  52), INT8_C(  28), INT8_C( -65),
                           INT8_C(-117), INT8_C( -90), INT8_C(-111), INT8_C( -67),
                           INT8_C( 113), INT8_C(  16), INT8_C(-124), INT8_C(  77),
                           INT8_C(  60), INT8_C( -64), INT8_C(-116), INT8_C( -89),
                           INT8_C(  -7), INT8_C( -79), INT8_C(  46), INT8_C( 114),
                           INT8_C(-107), INT8_C(  99), INT8_C( -79), INT8_C(  80),
                           INT8_C( -40), INT8_C( -81), INT8_C( -66), INT8_C( -45),
                           INT8_C(  57), INT8_C( -30), INT8_C(  66), INT8_C(  71),
                           INT8_C( 122), INT8_C(  95), INT8_C( -43), INT8_C(  50),
                           INT8_C(  -6), INT8_C(  41), INT8_C( -47), INT8_C(  95),
                           INT8_C(   5), INT8_C( -20), INT8_C( -45), INT8_C(-118),
                           INT8_C(  70), INT8_C(  81), INT8_C(   0), INT8_C(  84),
                           INT8_C( -62), INT8_C(-101), INT8_C(  13), INT8_C(  33),
                           INT8_C(-104), INT8_C(-117), INT8_C( -11), INT8_C(  20)),
      UINT64_C(0x3ab9a44bc9e6184) },
    { simde_mm512_set_epi8(INT8_C(  67), INT8_C(  34), INT8_C( -33), INT8_C(  31),
                           INT8_C(-128), INT8_C(  55), INT8_C(  93), INT8_C(  58),
                           INT8_C(  57), INT8_C( 104), INT8_C(-110), INT8_C(  59),
                           INT8_C(  55), INT8_C(  33), INT8_C(-122), INT8_C(  69),
                           INT8_C(  57), INT8_C(  30), INT8_C( -13), INT8_C( -65),
                           INT8_C( -22), INT8_C(-100), INT8_C(  18), INT8_C( -65),
                           INT8_C( -60), INT8_C(-105), INT8_C(  27), INT8_C( -71),
                           INT8_C(  52), INT8_C(  12), INT8_C(  -4), INT8_C(  64),
                           INT8_C(  20), INT8_C(  51), INT8_C(  87), INT8_C(  43),
                           INT8_C(  26), INT8_C(   6), INT8_C( -66), INT8_C( -40),
                           INT8_C(  87), INT8_C(   1), INT8_C( -26), INT8_C(  92),
                           INT8_C( -33), INT8_C(   8), INT8_C(  42), INT8_C( -93),
                           INT8_C(  44), INT8_C( -55), INT8_C(-113), INT8_C( -43),
                           INT8_C(  32), INT8_C( 105), INT8_C( -27), INT8_C(  96),
                           INT8_C(  72), INT8_C(  48), INT8_C( -46), INT8_C(  24),
                           INT8_C( -10), INT8_C( -98), INT8_C( -56), INT8_C( -41)),
      simde_mm512_set_epi8(INT8_C(  67), INT8_C( -63), INT8_C( -33), INT8_C(  31),
                           INT8_C(-128), INT8_C(  55), INT8_C(  93), INT8_C(  -8),
                           INT8_C(  82), INT8_C( 104), INT8_C(-110), INT8_C(  59),
                           INT8_C(  55), INT8_C(   0), INT8_C( -25), INT8_C(  69),
                           INT8_C(  27), INT8_C(  30), INT8_C( -13), INT8_C( -65),
                           INT8_C(  -7), INT8_C( -28), INT8_C(  18), INT8_C( -65),
                           INT8_C(  67), INT8_C(  -3), INT8_C(  57), INT8_C( -68),
                           INT8_C(  52), INT8_C(  12), INT8_C(  -4), INT8_C(-128),
                           INT8_C(  20), INT8_C(  37), INT8_C(   9), INT8_C(  80),
                           INT8_C(  26), INT8_C(   6), INT8_C( -66), INT8_C(   9),
                           INT8_C( -98), INT8_C(   1), INT8_C( -26), INT8_C(  92),
                           INT8_C( -33), INT8_C(   8), INT8_C( -81), INT8_C( -93),
                           INT8_C( 116), INT8_C( -55), INT8_C(-113), INT8_C( -43),
                           INT8_C(  32), INT8_C( 105), INT8_C( -27), INT8_C(  37),
                           INT8_C(  72), INT8_C( -73), INT8_C( -19), INT8_C(  96),
                           INT8_C(  52), INT8_C( -98), INT8_C( -45), INT8_C( -41)),
      UINT64_C(0xbe79730e8e7d7e85) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__mmask64 r = simde_mm512_cmpeq_epi8_mask(test_vec[i].a, test_vec[i].b);
    munit_assert_uint64(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_cmpge_epi8_mask(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i   a;
    simde__m512i   b;
    simde__mmask64 r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C(  92), INT8_C(-121), INT8_C( 120), INT8_C( -19),
                           INT8_C( -73), INT8_C(  22), INT8_C( -66), INT8_C( -29),
                           INT8_C(  55), INT8_C( -63), INT8_C( -45), INT8_C(-119),
                           INT8_C(  30), INT8_C( -29), INT8_C( -26), INT8_C(  89),
                           INT8_C( -13), INT8_C( 119), INT8_C( -88), INT8_C( 109),
                           INT8_C(  68), INT8_C( -10), INT8_C(   0), INT8_C( -18),
                           INT8_C(   1), INT8_C( 116), INT8_C( -13), INT8_C( -73),
                           INT8_C(-122), INT8_C(   0), INT8_C( 111), INT8_C(  95),
                           INT8_C( -20), INT8_C(   3), INT8_C( 122), INT8_C( -43),
                           INT8_C(  13), INT8_C(  25), INT8_C( -35), INT8_C(-127),
                           INT8_C(  82), INT8_C(  90), INT8_C(  53), INT8_C( 123),
                           INT8_C(  73), INT8_C( 108), INT8_C( -18), INT8_C(  15),
                           INT8_C( 115), INT8_C(  54), INT8_C( 102), INT8_C( 118),
                           INT8_C(  39), INT8_C( -77), INT8_C(  45), INT8_C(  81),
                           INT8_C( -17), INT8_C( -28), INT8_C(  67), INT8_C( -85),
                           INT8_C(  79), INT8_C(-113), INT8_C(-122), INT8_C( 124)),
      simde_mm512_set_epi8(INT8_C(   9), INT8_C(-121), INT8_C( 120), INT8_C( -36),
                           INT8_C(  36), INT8_C(-103), INT8_C(-104), INT8_C(  25),
                           INT8_C(-111), INT8_C( -63), INT8_C( -35), INT8_C(-120),
                           INT8_C(  28), INT8_C( -44), INT8_C( -26), INT8_C( -86),
                           INT8_C( -13), INT8_C(  53), INT8_C( -88), INT8_C(-107),
                           INT8_C(  68), INT8_C(  42), INT8_C(-118), INT8_C( 111),
                           INT8_C(  54), INT8_C( -58), INT8_C( -13), INT8_C(  27),
                           INT8_C(  23), INT8_C(  41), INT8_C(-119), INT8_C(  44),
                           INT8_C(   7), INT8_C(-120), INT8_C(  32), INT8_C( -43),
                           INT8_C( 114), INT8_C( -72), INT8_C(  73), INT8_C( -96),
                           INT8_C(  96), INT8_C( 110), INT8_C( -81), INT8_C( -76),
                           INT8_C( 103), INT8_C(-100), INT8_C( -22), INT8_C(  18),
                           INT8_C( 115), INT8_C(  54), INT8_C( -40), INT8_C( 125),
                           INT8_C( 110), INT8_C(  31), INT8_C(  51), INT8_C(-104),
                           INT8_C(-115), INT8_C( -27), INT8_C(  62), INT8_C( -85),
                           INT8_C(  49), INT8_C(-115), INT8_C(  38), INT8_C(   4)),
      UINT64_C(0xf6dffa637436e1bd) },
    { simde_mm512_set_epi8(INT8_C(  16), INT8_C(  41), INT8_C( 102), INT8_C( -95),
                           INT8_C(  17), INT8_C(  42), INT8_C( -86), INT8_C(  38),
                           INT8_C(  62), INT8_C( -56), INT8_C(  60), INT8_C(  19),
                           INT8_C(-100), INT8_C(-107), INT8_C( 105), INT8_C( -76),
                           INT8_C(  10), INT8_C(  -9), INT8_C( -12), INT8_C( -56),
                           INT8_C( -71), INT8_C(  96), INT8_C(  31), INT8_C(  24),
                           INT8_C(  68), INT8_C(  -7), INT8_C( -27), INT8_C(   3),
                           INT8_C( -21), INT8_C(  50), INT8_C( -67), INT8_C( -39),
                           INT8_C(-108), INT8_C(  62), INT8_C( 101), INT8_C(  56),
                           INT8_C( -79), INT8_C( -37), INT8_C( -99), INT8_C( -56),
                           INT8_C(-119), INT8_C( -56), INT8_C(  -8), INT8_C( -16),
                           INT8_C( 115), INT8_C( -95), INT8_C( -73), INT8_C(  54),
                           INT8_C( 125), INT8_C(  85), INT8_C(  78), INT8_C( -65),
                           INT8_C(   4), INT8_C(  38), INT8_C( -84), INT8_C( -53),
                           INT8_C(  68), INT8_C(-108), INT8_C(-121), INT8_C(-115),
                           INT8_C( -59), INT8_C( -78), INT8_C(-111), INT8_C(  56)),
      simde_mm512_set_epi8(INT8_C(-104), INT8_C(-102), INT8_C( 102), INT8_C( -95),
                           INT8_C(  69), INT8_C(  13), INT8_C( -21), INT8_C(  45),
                           INT8_C(  62), INT8_C(-120), INT8_C(-111), INT8_C(  32),
                           INT8_C(-107), INT8_C( -30), INT8_C(  99), INT8_C( -64),
                           INT8_C(   8), INT8_C( -42), INT8_C(  81), INT8_C( -34),
                           INT8_C( -46), INT8_C(  26), INT8_C(  31), INT8_C(  -2),
                           INT8_C(  68), INT8_C(  -7), INT8_C( -71), INT8_C(  46),
                           INT8_C( -21), INT8_C( -73), INT8_C(  21), INT8_C(  83),
                           INT8_C(-108), INT8_C( -97), INT8_C( -69), INT8_C(  73),
                           INT8_C(  57), INT8_C( -37), INT8_C(  21), INT8_C(  82),
                           INT8_C(-119), INT8_C(-126), INT8_C( 126), INT8_C(  91),
                           INT8_C( 115), INT8_C(  31), INT8_C( -79), INT8_C(  28),
                           INT8_C(-106), INT8_C( -18), INT8_C(  65), INT8_C(-104),
                           INT8_C(  81), INT8_C(  38), INT8_C( -84), INT8_C(  -2),
                           INT8_C( -14), INT8_C(  85), INT8_C( -80), INT8_C(  80),
                           INT8_C(  48), INT8_C(  93), INT8_C(  79), INT8_C( 127)),
      UINT64_C(0xf4eac7ece4cbf680) },
    { simde_mm512_set_epi8(INT8_C(  50), INT8_C(  43), INT8_C( -68), INT8_C(  97),
                           INT8_C( -26), INT8_C(-103), INT8_C(  71), INT8_C(-107),
                           INT8_C(  91), INT8_C(  45), INT8_C( -11), INT8_C(  47),
                           INT8_C(  29), INT8_C( -56), INT8_C(  26), INT8_C(  -9),
                           INT8_C(  10), INT8_C(  36), INT8_C(-116), INT8_C( -53),
                           INT8_C(  41), INT8_C(   1), INT8_C( -23), INT8_C(  61),
                           INT8_C(-127), INT8_C(  -4), INT8_C(  48), INT8_C( -68),
                           INT8_C(  89), INT8_C(-112), INT8_C( -31), INT8_C( 120),
                           INT8_C(  35), INT8_C(  62), INT8_C( -21), INT8_C(-114),
                           INT8_C(-104), INT8_C(  57), INT8_C(  42), INT8_C(-111),
                           INT8_C(  94), INT8_C( -63), INT8_C(  87), INT8_C(  64),
                           INT8_C( -65), INT8_C(  -2), INT8_C( 110), INT8_C(  -8),
                           INT8_C(  63), INT8_C( -51), INT8_C(  -4), INT8_C(  32),
                           INT8_C( -65), INT8_C(  55), INT8_C(  14), INT8_C(  81),
                           INT8_C(-123), INT8_C(-100), INT8_C( -39), INT8_C( -44),
                           INT8_C(  22), INT8_C( 112), INT8_C(  16), INT8_C(  15)),
      simde_mm512_set_epi8(INT8_C(  50), INT8_C( -11), INT8_C( -68), INT8_C( -31),
                           INT8_C( 105), INT8_C(-106), INT8_C(  98), INT8_C(  51),
                           INT8_C(  58), INT8_C( 103), INT8_C( 111), INT8_C(-127),
                           INT8_C(  68), INT8_C( -56), INT8_C( 124), INT8_C(-119),
                           INT8_C(  74), INT8_C( -62), INT8_C(-116), INT8_C(  37),
                           INT8_C( -12), INT8_C( 114), INT8_C(   0), INT8_C(  61),
                           INT8_C( 103), INT8_C(  -4), INT8_C(-105), INT8_C( -68),
                           INT8_C(  39), INT8_C(-100), INT8_C( -93), INT8_C(  11),
                           INT8_C( -80), INT8_C( -19), INT8_C( -22), INT8_C( -39),
                           INT8_C( 127), INT8_C( -38), INT8_C(-125), INT8_C(-111),
                           INT8_C(  84), INT8_C( -96), INT8_C(  87), INT8_C( -22),
                           INT8_C(  -5), INT8_C(  -3), INT8_C(-127), INT8_C(  41),
                           INT8_C(  74), INT8_C(  72), INT8_C(  -4), INT8_C(  28),
                           INT8_C(-115), INT8_C(  93), INT8_C( 102), INT8_C(  44),
                           INT8_C(-103), INT8_C( -29), INT8_C( -50), INT8_C(  48),
                           INT8_C( -96), INT8_C( -50), INT8_C(  46), INT8_C( -65)),
      UINT64_C(0xf495697be7f6392d) },
    { simde_mm512_set_epi8(INT8_C( -97), INT8_C(  28), INT8_C( -58), INT8_C(  11),
                           INT8_C( -14), INT8_C( 126), INT8_C(  81), INT8_C(  45),
                           INT8_C( -23), INT8_C( 120), INT8_C( -83), INT8_C( -16),
                           INT8_C(   7), INT8_C(  51), INT8_C( -57), INT8_C( -50),
                           INT8_C( -21), INT8_C(  98), INT8_C(  88), INT8_C(   0),
                           INT8_C( -66), INT8_C(   3), INT8_C( 124), INT8_C(-113),
                           INT8_C(  50), INT8_C(  32), INT8_C( -85), INT8_C( -93),
                           INT8_C( -44), INT8_C( -13), INT8_C( -94), INT8_C(  17),
                           INT8_C( 122), INT8_C(  79), INT8_C(-116), INT8_C(  43),
                           INT8_C( -77), INT8_C(-125), INT8_C( -23), INT8_C(-120),
                           INT8_C(  96), INT8_C( -64), INT8_C( -23), INT8_C( -46),
                           INT8_C( -29), INT8_C( -71), INT8_C(  71), INT8_C( -80),
                           INT8_C(  44), INT8_C( -92), INT8_C( -31), INT8_C(  26),
                           INT8_C(   8), INT8_C(  52), INT8_C( 117), INT8_C( 123),
                           INT8_C( -63), INT8_C(  45), INT8_C(  95), INT8_C(  24),
                           INT8_C(-108), INT8_C(  18), INT8_C( -60), INT8_C(  28)),
      simde_mm512_set_epi8(INT8_C( -23), INT8_C(-101), INT8_C( 116), INT8_C( 127),
                           INT8_C(  96), INT8_C(  40), INT8_C( -97), INT8_C(  40),
                           INT8_C(  86), INT8_C( -44), INT8_C(  70), INT8_C( -71),
                           INT8_C(  62), INT8_C( -21), INT8_C(  66), INT8_C(  68),
                           INT8_C( -87), INT8_C( -61), INT8_C(  48), INT8_C( -70),
                           INT8_C(  18), INT8_C( -78), INT8_C( -98), INT8_C( 117),
                           INT8_C(  74), INT8_C(  32), INT8_C(  93), INT8_C( 125),
                           INT8_C( -47), INT8_C( -60), INT8_C( -86), INT8_C( 117),
                           INT8_C( 122), INT8_C( -54), INT8_C(  50), INT8_C( 123),
                           INT8_C( -31), INT8_C( -74), INT8_C( -64), INT8_C(  54),
                           INT8_C( -81), INT8_C(  60), INT8_C(  31), INT8_C( -23),
                           INT8_C( 108), INT8_C(-119), INT8_C( -92), INT8_C( -80),
                           INT8_C( -30), INT8_C( -37), INT8_C(  51), INT8_C( -36),
                           INT8_C(   8), INT8_C(  52), INT8_C(  97), INT8_C( 123),
                           INT8_C( -49), INT8_C(-124), INT8_C(  95), INT8_C( -83),
                           INT8_C(  70), INT8_C( -50), INT8_C( -61), INT8_C(  25)),
      UINT64_C(0x4754f64cc2879f77) },
    { simde_mm512_set_epi8(INT8_C( 121), INT8_C( -20), INT8_C( -89), INT8_C( -94),
                           INT8_C( 112), INT8_C( -27), INT8_C(  81), INT8_C( -54),
                           INT8_C( -64), INT8_C(-114), INT8_C(  48), INT8_C( -89),
                           INT8_C( -61), INT8_C(  26), INT8_C(  43), INT8_C(  29),
                           INT8_C(   0), INT8_C( 125), INT8_C( -42), INT8_C( -67),
                           INT8_C(  15), INT8_C( 120), INT8_C(  36), INT8_C(  40),
                           INT8_C( -53), INT8_C(  34), INT8_C(-108), INT8_C( -58),
                           INT8_C(  26), INT8_C(-111), INT8_C(  63), INT8_C( -98),
                           INT8_C(  65), INT8_C(   8), INT8_C(-124), INT8_C(  96),
                           INT8_C( -13), INT8_C( -98), INT8_C(  99), INT8_C(  90),
                           INT8_C(  56), INT8_C( -45), INT8_C(-108), INT8_C( -19),
                           INT8_C(-124), INT8_C( -27), INT8_C(  22), INT8_C( 126),
                           INT8_C(-106), INT8_C( -68), INT8_C( -60), INT8_C(   8),
                           INT8_C( -54), INT8_C(  93), INT8_C( -33), INT8_C( -27),
                           INT8_C(  -7), INT8_C(  27), INT8_C(-122), INT8_C( -88),
                           INT8_C(  23), INT8_C(   6), INT8_C(  45), INT8_C( -21)),
      simde_mm512_set_epi8(INT8_C( 105), INT8_C(  52), INT8_C(  85), INT8_C(-104),
                           INT8_C(  57), INT8_C( -31), INT8_C( -38), INT8_C(-124),
                           INT8_C(-107), INT8_C(  -2), INT8_C(  55), INT8_C(  46),
                           INT8_C( -71), INT8_C(  77), INT8_C(  18), INT8_C(  70),
                           INT8_C(  89), INT8_C( 125), INT8_C( -42), INT8_C(-125),
                           INT8_C( 121), INT8_C( -11), INT8_C( -69), INT8_C( -59),
                           INT8_C( -53), INT8_C(  34), INT8_C(   9), INT8_C(  64),
                           INT8_C( -61), INT8_C( -25), INT8_C(-115), INT8_C( 100),
                           INT8_C(  65), INT8_C(   8), INT8_C(  69), INT8_C(  -8),
                           INT8_C( -15), INT8_C( -51), INT8_C(   1), INT8_C(  90),
                           INT8_C( 115), INT8_C(  51), INT8_C( -91), INT8_C(  56),
                           INT8_C(  64), INT8_C( -39), INT8_C(-119), INT8_C( -28),
                           INT8_C( -54), INT8_C(  28), INT8_C(  54), INT8_C(  -8),
                           INT8_C( -54), INT8_C(-128), INT8_C( -28), INT8_C( -71),
                           INT8_C( 107), INT8_C( -66), INT8_C(-114), INT8_C( -88),
                           INT8_C(  34), INT8_C( -83), INT8_C( -21), INT8_C( -64)),
      UINT64_C(0x9f8a77cadb071d57) },
    { simde_mm512_set_epi8(INT8_C(  33), INT8_C( 121), INT8_C( 125), INT8_C(  35),
                           INT8_C(-103), INT8_C( -48), INT8_C( -22), INT8_C(  38),
                           INT8_C( -81), INT8_C(   9), INT8_C( -11), INT8_C(-124),
                           INT8_C(  71), INT8_C(   9), INT8_C( -42), INT8_C( 118),
                           INT8_C(  67), INT8_C(  45), INT8_C(  51), INT8_C( -92),
                           INT8_C( 126), INT8_C( 108), INT8_C(-123), INT8_C( -71),
                           INT8_C( 113), INT8_C(  32), INT8_C(  71), INT8_C(   3),
                           INT8_C( -26), INT8_C(  82), INT8_C( -81), INT8_C( -20),
                           INT8_C( -55), INT8_C( 112), INT8_C(  66), INT8_C(  37),
                           INT8_C(  67), INT8_C( -69), INT8_C(  64), INT8_C(  39),
                           INT8_C(  72), INT8_C(  45), INT8_C( 120), INT8_C(  -5),
                           INT8_C(-109), INT8_C(  62), INT8_C(  17), INT8_C(  31),
                           INT8_C( -30), INT8_C( -58), INT8_C(  56), INT8_C(  21),
                           INT8_C(  72), INT8_C( -75), INT8_C( -34), INT8_C( 120),
                           INT8_C(  95), INT8_C( 108), INT8_C(  32), INT8_C(  64),
                           INT8_C(-128), INT8_C( 102), INT8_C( -21), INT8_C(  28)),
      simde_mm512_set_epi8(INT8_C( 100), INT8_C( 121), INT8_C(  18), INT8_C(  28),
                           INT8_C(-117), INT8_C( 107), INT8_C(   3), INT8_C( -62),
                           INT8_C(  42), INT8_C(  72), INT8_C(  91), INT8_C(  86),
                           INT8_C( -72), INT8_C(   9), INT8_C( -80), INT8_C( 118),
                           INT8_C( 122), INT8_C(-108), INT8_C( -70), INT8_C( -63),
                           INT8_C(  56), INT8_C(  71), INT8_C( -14), INT8_C(  49),
                           INT8_C( -73), INT8_C(  53), INT8_C( -29), INT8_C(   3),
                           INT8_C( -73), INT8_C(  43), INT8_C( -22), INT8_C(  85),
                           INT8_C( -26), INT8_C(  -9), INT8_C(  66), INT8_C(   1),
                           INT8_C( -13), INT8_C(  60), INT8_C(-119), INT8_C( -83),
                           INT8_C(-122), INT8_C( -64), INT8_C( -83), INT8_C( -74),
                           INT8_C( 119), INT8_C(  -8), INT8_C(  12), INT8_C( 113),
                           INT8_C( -12), INT8_C( -84), INT8_C(   6), INT8_C(  69),
                           INT8_C(   2), INT8_C( -75), INT8_C( -34), INT8_C(-126),
                           INT8_C(   3), INT8_C(-128), INT8_C(  -9), INT8_C(  24),
                           INT8_C(  11), INT8_C( -94), INT8_C( -32), INT8_C( 110)),
      UINT64_C(0x790f6cbc7bf66ff6) },
    { simde_mm512_set_epi8(INT8_C(   2), INT8_C( -81), INT8_C(  14), INT8_C(  90),
                           INT8_C(-100), INT8_C(-122), INT8_C( -35), INT8_C(  81),
                           INT8_C( -14), INT8_C( -42), INT8_C( 125), INT8_C(-125),
                           INT8_C( -57), INT8_C(  90), INT8_C(  -9), INT8_C(  63),
                           INT8_C(  53), INT8_C(  77), INT8_C(  63), INT8_C( -84),
                           INT8_C(  27), INT8_C(  22), INT8_C( -28), INT8_C( -37),
                           INT8_C(  65), INT8_C( 118), INT8_C(-126), INT8_C(  97),
                           INT8_C( 109), INT8_C(-119), INT8_C(-114), INT8_C( -75),
                           INT8_C(-125), INT8_C( 121), INT8_C(-128), INT8_C( 103),
                           INT8_C(   0), INT8_C( 101), INT8_C( -41), INT8_C(  89),
                           INT8_C(  67), INT8_C( -65), INT8_C(   9), INT8_C(  -7),
                           INT8_C( -63), INT8_C(  13), INT8_C( 105), INT8_C(  92),
                           INT8_C( -18), INT8_C( -21), INT8_C(-102), INT8_C(-114),
                           INT8_C(  74), INT8_C( 121), INT8_C( -45), INT8_C(  52),
                           INT8_C( -63), INT8_C( -93), INT8_C(  98), INT8_C( 106),
                           INT8_C(-109), INT8_C( -47), INT8_C(  37), INT8_C(  70)),
      simde_mm512_set_epi8(INT8_C( -42), INT8_C(-124), INT8_C(  54), INT8_C(  74),
                           INT8_C( -92), INT8_C(  99), INT8_C(  79), INT8_C(  -3),
                           INT8_C(  61), INT8_C( -89), INT8_C(  84), INT8_C( -94),
                           INT8_C(  31), INT8_C(-116), INT8_C( -67), INT8_C(-102),
                           INT8_C( -72), INT8_C( -91), INT8_C(-105), INT8_C(-108),
                           INT8_C( -44), INT8_C(  74), INT8_C( -28), INT8_C( 124),
                           INT8_C( 120), INT8_C( -41), INT8_C( -79), INT8_C( 122),
                           INT8_C(  87), INT8_C(-119), INT8_C(  54), INT8_C(  -2),
                           INT8_C( -47), INT8_C(  84), INT8_C(-126), INT8_C( -64),
                           INT8_C(  14), INT8_C(  11), INT8_C(  37), INT8_C( -23),
                           INT8_C(  67), INT8_C( 124), INT8_C(  58), INT8_C( -94),
                           INT8_C(  30), INT8_C( -33), INT8_C(  70), INT8_C( -24),
                           INT8_C(  38), INT8_C( -97), INT8_C( -56), INT8_C( -60),
                           INT8_C( -59), INT8_C(  65), INT8_C( -74), INT8_C(  45),
                           INT8_C( -11), INT8_C(  55), INT8_C( -82), INT8_C(  12),
                           INT8_C( 106), INT8_C(  22), INT8_C(-124), INT8_C(  -4)),
      UINT64_C(0xd167fa4c55974f33) },
    { simde_mm512_set_epi8(INT8_C(  18), INT8_C(  13), INT8_C(  14), INT8_C(   4),
                           INT8_C(  -3), INT8_C( -64), INT8_C(  17), INT8_C(-115),
                           INT8_C(  21), INT8_C( -34), INT8_C( 125), INT8_C( -60),
                           INT8_C( -72), INT8_C(  74), INT8_C(  -5), INT8_C( -21),
                           INT8_C( -41), INT8_C(  22), INT8_C(  45), INT8_C( 102),
                           INT8_C(  59), INT8_C( -80), INT8_C( -15), INT8_C( -63),
                           INT8_C(  84), INT8_C( -71), INT8_C(   8), INT8_C(  12),
                           INT8_C( -11), INT8_C( -76), INT8_C(  62), INT8_C(  93),
                           INT8_C( -75), INT8_C( -77), INT8_C( -84), INT8_C(-108),
                           INT8_C( -35), INT8_C(  14), INT8_C( -60), INT8_C(  18),
                           INT8_C(  23), INT8_C( -60), INT8_C( -63), INT8_C(-114),
                           INT8_C( -55), INT8_C(  75), INT8_C( -99), INT8_C( -55),
                           INT8_C(  58), INT8_C(  76), INT8_C(-102), INT8_C(-118),
                           INT8_C(  10), INT8_C(  39), INT8_C( 119), INT8_C(  85),
                           INT8_C(  -8), INT8_C( -72), INT8_C( -60), INT8_C( -94),
                           INT8_C(-112), INT8_C( 119), INT8_C( 124), INT8_C(  76)),
      simde_mm512_set_epi8(INT8_C(  18), INT8_C( -74), INT8_C(  14), INT8_C(  36),
                           INT8_C(  -7), INT8_C( 113), INT8_C(  40), INT8_C(  48),
                           INT8_C(-107), INT8_C( -34), INT8_C( -75), INT8_C(  85),
                           INT8_C( -35), INT8_C(-116), INT8_C(  65), INT8_C( -21),
                           INT8_C(  15), INT8_C(   3), INT8_C(  45), INT8_C(  21),
                           INT8_C(  72), INT8_C(  93), INT8_C( 108), INT8_C( 125),
                           INT8_C(   1), INT8_C(  75), INT8_C(  21), INT8_C( -36),
                           INT8_C(-126), INT8_C( 122), INT8_C(  71), INT8_C(  76),
                           INT8_C(  28), INT8_C( -56), INT8_C(  32), INT8_C( 101),
                           INT8_C(-107), INT8_C(-111), INT8_C( -88), INT8_C( -19),
                           INT8_C( -77), INT8_C(  19), INT8_C( -21), INT8_C(-111),
                           INT8_C( -68), INT8_C(  82), INT8_C(-118), INT8_C( -76),
                           INT8_C(  47), INT8_C( 127), INT8_C(  62), INT8_C( -16),
                           INT8_C(  10), INT8_C( -14), INT8_C(-100), INT8_C(  86),
                           INT8_C(  29), INT8_C( 107), INT8_C(  56), INT8_C(  21),
                           INT8_C(  24), INT8_C(  68), INT8_C( -96), INT8_C(  64)),
      UINT64_C(0xe8e570990f8b8e07) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__mmask64 r = simde_mm512_cmpge_epi8_mask(test_vec[i].a, test_vec[i].b);
    munit_assert_uint64(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_cmpge_epu8_mask(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i   a;
    simde__m512i   b;
    simde__mmask64 r;
  } test_vec[8] = {
    { simde_x_mm512_set_epu8(UINT8_C( 92), UINT8_C(135), UINT8_C(120), UINT8_C(237),
                             UINT8_C(183), UINT8_C( 22), UINT8_C(190), UINT8_C(227),
                             UINT8_C( 55), UINT8_C(193), UINT8_C(211), UINT8_C(137),
                             UINT8_C( 30), UINT8_C(227), UINT8_C(230), UINT8_C( 89),
                             UINT8_C(243), UINT8_C(119), UINT8_C(168), UINT8_C(109),
                             UINT8_C( 68), UINT8_C(246), UINT8_C(  0), UINT8_C(238),
                             UINT8_C(  1), UINT8_C(116), UINT8_C(243), UINT8_C(183),
                             UINT8_C(134), UINT8_C(  0), UINT8_C(111), UINT8_C( 95),
                             UINT8_C(236), UINT8_C(  3), UINT8_C(122), UINT8_C(213),
                             UINT8_C( 13), UINT8_C( 25), UINT8_C(221), UINT8_C(129),
                             UINT8_C( 82), UINT8_C( 90), UINT8_C( 53), UINT8_C(123),
                             UINT8_C( 73), UINT8_C(108), UINT8_C(238), UINT8_C( 15),
                             UINT8_C(115), UINT8_C( 54), UINT8_C(102), UINT8_C(118),
                             UINT8_C( 39), UINT8_C(179), UINT8_C( 45), UINT8_C( 81),
                             UINT8_C(239), UINT8_C(228), UINT8_C( 67), UINT8_C(171),
                             UINT8_C( 79), UINT8_C(143), UINT8_C(134), UINT8_C(124)),
      simde_x_mm512_set_epu8(UINT8_C(  9), UINT8_C(135), UINT8_C(120), UINT8_C(220),
                             UINT8_C( 36), UINT8_C(153), UINT8_C(152), UINT8_C( 25),
                             UINT8_C(145), UINT8_C(193), UINT8_C(221), UINT8_C(136),
                             UINT8_C( 28), UINT8_C(212), UINT8_C(230), UINT8_C(170),
                             UINT8_C(243), UINT8_C( 53), UINT8_C(168), UINT8_C(149),
                             UINT8_C( 68), UINT8_C( 42), UINT8_C(138), UINT8_C(111),
                             UINT8_C( 54), UINT8_C(198), UINT8_C(243), UINT8_C( 27),
                             UINT8_C( 23), UINT8_C( 41), UINT8_C(137), UINT8_C( 44),
                             UINT8_C(  7), UINT8_C(136), UINT8_C( 32), UINT8_C(213),
                             UINT8_C(114), UINT8_C(184), UINT8_C( 73), UINT8_C(160),
                             UINT8_C( 96), UINT8_C(110), UINT8_C(175), UINT8_C(180),
                             UINT8_C(103), UINT8_C(156), UINT8_C(234), UINT8_C( 18),
                             UINT8_C(115), UINT8_C( 54), UINT8_C(216), UINT8_C(125),
                             UINT8_C(110), UINT8_C( 31), UINT8_C( 51), UINT8_C(152),
                             UINT8_C(141), UINT8_C(229), UINT8_C( 62), UINT8_C(171),
                             UINT8_C( 49), UINT8_C(141), UINT8_C( 38), UINT8_C(  4)),
      UINT64_C(0xfb5eed39b202c4bf) },
    { simde_x_mm512_set_epu8(UINT8_C( 16), UINT8_C( 41), UINT8_C(102), UINT8_C(161),
                             UINT8_C( 17), UINT8_C( 42), UINT8_C(170), UINT8_C( 38),
                             UINT8_C( 62), UINT8_C(200), UINT8_C( 60), UINT8_C( 19),
                             UINT8_C(156), UINT8_C(149), UINT8_C(105), UINT8_C(180),
                             UINT8_C( 10), UINT8_C(247), UINT8_C(244), UINT8_C(200),
                             UINT8_C(185), UINT8_C( 96), UINT8_C( 31), UINT8_C( 24),
                             UINT8_C( 68), UINT8_C(249), UINT8_C(229), UINT8_C(  3),
                             UINT8_C(235), UINT8_C( 50), UINT8_C(189), UINT8_C(217),
                             UINT8_C(148), UINT8_C( 62), UINT8_C(101), UINT8_C( 56),
                             UINT8_C(177), UINT8_C(219), UINT8_C(157), UINT8_C(200),
                             UINT8_C(137), UINT8_C(200), UINT8_C(248), UINT8_C(240),
                             UINT8_C(115), UINT8_C(161), UINT8_C(183), UINT8_C( 54),
                             UINT8_C(125), UINT8_C( 85), UINT8_C( 78), UINT8_C(191),
                             UINT8_C(  4), UINT8_C( 38), UINT8_C(172), UINT8_C(203),
                             UINT8_C( 68), UINT8_C(148), UINT8_C(135), UINT8_C(141),
                             UINT8_C(197), UINT8_C(178), UINT8_C(145), UINT8_C( 56)),
      simde_x_mm512_set_epu8(UINT8_C(152), UINT8_C(154), UINT8_C(102), UINT8_C(161),
                             UINT8_C( 69), UINT8_C( 13), UINT8_C(235), UINT8_C( 45),
                             UINT8_C( 62), UINT8_C(136), UINT8_C(145), UINT8_C( 32),
                             UINT8_C(149), UINT8_C(226), UINT8_C( 99), UINT8_C(192),
                             UINT8_C(  8), UINT8_C(214), UINT8_C( 81), UINT8_C(222),
                             UINT8_C(210), UINT8_C( 26), UINT8_C( 31), UINT8_C(254),
                             UINT8_C( 68), UINT8_C(249), UINT8_C(185), UINT8_C( 46),
                             UINT8_C(235), UINT8_C(183), UINT8_C( 21), UINT8_C( 83),
                             UINT8_C(148), UINT8_C(159), UINT8_C(187), UINT8_C( 73),
                             UINT8_C( 57), UINT8_C(219), UINT8_C( 21), UINT8_C( 82),
                             UINT8_C(137), UINT8_C(130), UINT8_C(126), UINT8_C( 91),
                             UINT8_C(115), UINT8_C( 31), UINT8_C(177), UINT8_C( 28),
                             UINT8_C(150), UINT8_C(238), UINT8_C( 65), UINT8_C(152),
                             UINT8_C( 81), UINT8_C( 38), UINT8_C(172), UINT8_C(254),
                             UINT8_C(242), UINT8_C( 85), UINT8_C(176), UINT8_C( 80),
                             UINT8_C( 48), UINT8_C( 93), UINT8_C( 79), UINT8_C(127)),
      UINT64_C(0x34cae6eb8fff365e) },
    { simde_x_mm512_set_epu8(UINT8_C( 50), UINT8_C( 43), UINT8_C(188), UINT8_C( 97),
                             UINT8_C(230), UINT8_C(153), UINT8_C( 71), UINT8_C(149),
                             UINT8_C( 91), UINT8_C( 45), UINT8_C(245), UINT8_C( 47),
                             UINT8_C( 29), UINT8_C(200), UINT8_C( 26), UINT8_C(247),
                             UINT8_C( 10), UINT8_C( 36), UINT8_C(140), UINT8_C(203),
                             UINT8_C( 41), UINT8_C(  1), UINT8_C(233), UINT8_C( 61),
                             UINT8_C(129), UINT8_C(252), UINT8_C( 48), UINT8_C(188),
                             UINT8_C( 89), UINT8_C(144), UINT8_C(225), UINT8_C(120),
                             UINT8_C( 35), UINT8_C( 62), UINT8_C(235), UINT8_C(142),
                             UINT8_C(152), UINT8_C( 57), UINT8_C( 42), UINT8_C(145),
                             UINT8_C( 94), UINT8_C(193), UINT8_C( 87), UINT8_C( 64),
                             UINT8_C(191), UINT8_C(254), UINT8_C(110), UINT8_C(248),
                             UINT8_C( 63), UINT8_C(205), UINT8_C(252), UINT8_C( 32),
                             UINT8_C(191), UINT8_C( 55), UINT8_C( 14), UINT8_C( 81),
                             UINT8_C(133), UINT8_C(156), UINT8_C(217), UINT8_C(212),
                             UINT8_C( 22), UINT8_C(112), UINT8_C( 16), UINT8_C( 15)),
      simde_x_mm512_set_epu8(UINT8_C( 50), UINT8_C(245), UINT8_C(188), UINT8_C(225),
                             UINT8_C(105), UINT8_C(150), UINT8_C( 98), UINT8_C( 51),
                             UINT8_C( 58), UINT8_C(103), UINT8_C(111), UINT8_C(129),
                             UINT8_C( 68), UINT8_C(200), UINT8_C(124), UINT8_C(137),
                             UINT8_C( 74), UINT8_C(194), UINT8_C(140), UINT8_C( 37),
                             UINT8_C(244), UINT8_C(114), UINT8_C(  0), UINT8_C( 61),
                             UINT8_C(103), UINT8_C(252), UINT8_C(151), UINT8_C(188),
                             UINT8_C( 39), UINT8_C(156), UINT8_C(163), UINT8_C( 11),
                             UINT8_C(176), UINT8_C(237), UINT8_C(234), UINT8_C(217),
                             UINT8_C(127), UINT8_C(218), UINT8_C(131), UINT8_C(145),
                             UINT8_C( 84), UINT8_C(160), UINT8_C( 87), UINT8_C(234),
                             UINT8_C(251), UINT8_C(253), UINT8_C(129), UINT8_C( 41),
                             UINT8_C( 74), UINT8_C( 72), UINT8_C(252), UINT8_C( 28),
                             UINT8_C(141), UINT8_C( 93), UINT8_C(102), UINT8_C( 44),
                             UINT8_C(153), UINT8_C(227), UINT8_C(206), UINT8_C( 48),
                             UINT8_C(160), UINT8_C(206), UINT8_C( 46), UINT8_C(191)),
      UINT64_C(0xada533db29e57930) },
    { simde_x_mm512_set_epu8(UINT8_C(159), UINT8_C( 28), UINT8_C(198), UINT8_C( 11),
                             UINT8_C(242), UINT8_C(126), UINT8_C( 81), UINT8_C( 45),
                             UINT8_C(233), UINT8_C(120), UINT8_C(173), UINT8_C(240),
                             UINT8_C(  7), UINT8_C( 51), UINT8_C(199), UINT8_C(206),
                             UINT8_C(235), UINT8_C( 98), UINT8_C( 88), UINT8_C(  0),
                             UINT8_C(190), UINT8_C(  3), UINT8_C(124), UINT8_C(143),
                             UINT8_C( 50), UINT8_C( 32), UINT8_C(171), UINT8_C(163),
                             UINT8_C(212), UINT8_C(243), UINT8_C(162), UINT8_C( 17),
                             UINT8_C(122), UINT8_C( 79), UINT8_C(140), UINT8_C( 43),
                             UINT8_C(179), UINT8_C(131), UINT8_C(233), UINT8_C(136),
                             UINT8_C( 96), UINT8_C(192), UINT8_C(233), UINT8_C(210),
                             UINT8_C(227), UINT8_C(185), UINT8_C( 71), UINT8_C(176),
                             UINT8_C( 44), UINT8_C(164), UINT8_C(225), UINT8_C( 26),
                             UINT8_C(  8), UINT8_C( 52), UINT8_C(117), UINT8_C(123),
                             UINT8_C(193), UINT8_C( 45), UINT8_C( 95), UINT8_C( 24),
                             UINT8_C(148), UINT8_C( 18), UINT8_C(196), UINT8_C( 28)),
      simde_x_mm512_set_epu8(UINT8_C(233), UINT8_C(155), UINT8_C(116), UINT8_C(127),
                             UINT8_C( 96), UINT8_C( 40), UINT8_C(159), UINT8_C( 40),
                             UINT8_C( 86), UINT8_C(212), UINT8_C( 70), UINT8_C(185),
                             UINT8_C( 62), UINT8_C(235), UINT8_C( 66), UINT8_C( 68),
                             UINT8_C(169), UINT8_C(195), UINT8_C( 48), UINT8_C(186),
                             UINT8_C( 18), UINT8_C(178), UINT8_C(158), UINT8_C(117),
                             UINT8_C( 74), UINT8_C( 32), UINT8_C( 93), UINT8_C(125),
                             UINT8_C(209), UINT8_C(196), UINT8_C(170), UINT8_C(117),
                             UINT8_C(122), UINT8_C(202), UINT8_C( 50), UINT8_C(123),
                             UINT8_C(225), UINT8_C(182), UINT8_C(192), UINT8_C( 54),
                             UINT8_C(175), UINT8_C( 60), UINT8_C( 31), UINT8_C(233),
                             UINT8_C(108), UINT8_C(137), UINT8_C(164), UINT8_C(176),
                             UINT8_C(226), UINT8_C(219), UINT8_C( 51), UINT8_C(220),
                             UINT8_C(  8), UINT8_C( 52), UINT8_C( 97), UINT8_C(123),
                             UINT8_C(207), UINT8_C(132), UINT8_C( 95), UINT8_C(173),
                             UINT8_C( 70), UINT8_C(206), UINT8_C(195), UINT8_C( 25)),
      UINT64_C(0x2db3a97ca36d2f2b) },
    { simde_x_mm512_set_epu8(UINT8_C(121), UINT8_C(236), UINT8_C(167), UINT8_C(162),
                             UINT8_C(112), UINT8_C(229), UINT8_C( 81), UINT8_C(202),
                             UINT8_C(192), UINT8_C(142), UINT8_C( 48), UINT8_C(167),
                             UINT8_C(195), UINT8_C( 26), UINT8_C( 43), UINT8_C( 29),
                             UINT8_C(  0), UINT8_C(125), UINT8_C(214), UINT8_C(189),
                             UINT8_C( 15), UINT8_C(120), UINT8_C( 36), UINT8_C( 40),
                             UINT8_C(203), UINT8_C( 34), UINT8_C(148), UINT8_C(198),
                             UINT8_C( 26), UINT8_C(145), UINT8_C( 63), UINT8_C(158),
                             UINT8_C( 65), UINT8_C(  8), UINT8_C(132), UINT8_C( 96),
                             UINT8_C(243), UINT8_C(158), UINT8_C( 99), UINT8_C( 90),
                             UINT8_C( 56), UINT8_C(211), UINT8_C(148), UINT8_C(237),
                             UINT8_C(132), UINT8_C(229), UINT8_C( 22), UINT8_C(126),
                             UINT8_C(150), UINT8_C(188), UINT8_C(196), UINT8_C(  8),
                             UINT8_C(202), UINT8_C( 93), UINT8_C(223), UINT8_C(229),
                             UINT8_C(249), UINT8_C( 27), UINT8_C(134), UINT8_C(168),
                             UINT8_C( 23), UINT8_C(  6), UINT8_C( 45), UINT8_C(235)),
      simde_x_mm512_set_epu8(UINT8_C(105), UINT8_C( 52), UINT8_C( 85), UINT8_C(152),
                             UINT8_C( 57), UINT8_C(225), UINT8_C(218), UINT8_C(132),
                             UINT8_C(149), UINT8_C(254), UINT8_C( 55), UINT8_C( 46),
                             UINT8_C(185), UINT8_C( 77), UINT8_C( 18), UINT8_C( 70),
                             UINT8_C( 89), UINT8_C(125), UINT8_C(214), UINT8_C(131),
                             UINT8_C(121), UINT8_C(245), UINT8_C(187), UINT8_C(197),
                             UINT8_C(203), UINT8_C( 34), UINT8_C(  9), UINT8_C( 64),
                             UINT8_C(195), UINT8_C(231), UINT8_C(141), UINT8_C(100),
                             UINT8_C( 65), UINT8_C(  8), UINT8_C( 69), UINT8_C(248),
                             UINT8_C(241), UINT8_C(205), UINT8_C(  1), UINT8_C( 90),
                             UINT8_C(115), UINT8_C( 51), UINT8_C(165), UINT8_C( 56),
                             UINT8_C( 64), UINT8_C(217), UINT8_C(137), UINT8_C(228),
                             UINT8_C(202), UINT8_C( 28), UINT8_C( 54), UINT8_C(248),
                             UINT8_C(202), UINT8_C(128), UINT8_C(228), UINT8_C(185),
                             UINT8_C(107), UINT8_C(190), UINT8_C(142), UINT8_C(168),
                             UINT8_C( 34), UINT8_C(173), UINT8_C(235), UINT8_C(192)),
      UINT64_C(0xfd9a70f1eb5c6991) },
    { simde_x_mm512_set_epu8(UINT8_C( 33), UINT8_C(121), UINT8_C(125), UINT8_C( 35),
                             UINT8_C(153), UINT8_C(208), UINT8_C(234), UINT8_C( 38),
                             UINT8_C(175), UINT8_C(  9), UINT8_C(245), UINT8_C(132),
                             UINT8_C( 71), UINT8_C(  9), UINT8_C(214), UINT8_C(118),
                             UINT8_C( 67), UINT8_C( 45), UINT8_C( 51), UINT8_C(164),
                             UINT8_C(126), UINT8_C(108), UINT8_C(133), UINT8_C(185),
                             UINT8_C(113), UINT8_C( 32), UINT8_C( 71), UINT8_C(  3),
                             UINT8_C(230), UINT8_C( 82), UINT8_C(175), UINT8_C(236),
                             UINT8_C(201), UINT8_C(112), UINT8_C( 66), UINT8_C( 37),
                             UINT8_C( 67), UINT8_C(187), UINT8_C( 64), UINT8_C( 39),
                             UINT8_C( 72), UINT8_C( 45), UINT8_C(120), UINT8_C(251),
                             UINT8_C(147), UINT8_C( 62), UINT8_C( 17), UINT8_C( 31),
                             UINT8_C(226), UINT8_C(198), UINT8_C( 56), UINT8_C( 21),
                             UINT8_C( 72), UINT8_C(181), UINT8_C(222), UINT8_C(120),
                             UINT8_C( 95), UINT8_C(108), UINT8_C( 32), UINT8_C( 64),
                             UINT8_C(128), UINT8_C(102), UINT8_C(235), UINT8_C( 28)),
      simde_x_mm512_set_epu8(UINT8_C(100), UINT8_C(121), UINT8_C( 18), UINT8_C( 28),
                             UINT8_C(139), UINT8_C(107), UINT8_C(  3), UINT8_C(194),
                             UINT8_C( 42), UINT8_C( 72), UINT8_C( 91), UINT8_C( 86),
                             UINT8_C(184), UINT8_C(  9), UINT8_C(176), UINT8_C(118),
                             UINT8_C(122), UINT8_C(148), UINT8_C(186), UINT8_C(193),
                             UINT8_C( 56), UINT8_C( 71), UINT8_C(242), UINT8_C( 49),
                             UINT8_C(183), UINT8_C( 53), UINT8_C(227), UINT8_C(  3),
                             UINT8_C(183), UINT8_C( 43), UINT8_C(234), UINT8_C( 85),
                             UINT8_C(230), UINT8_C(247), UINT8_C( 66), UINT8_C(  1),
                             UINT8_C(243), UINT8_C( 60), UINT8_C(137), UINT8_C(173),
                             UINT8_C(134), UINT8_C(192), UINT8_C(173), UINT8_C(182),
                             UINT8_C(119), UINT8_C(248), UINT8_C( 12), UINT8_C(113),
                             UINT8_C(244), UINT8_C(172), UINT8_C(  6), UINT8_C( 69),
                             UINT8_C(  2), UINT8_C(181), UINT8_C(222), UINT8_C(130),
                             UINT8_C(  3), UINT8_C(128), UINT8_C(247), UINT8_C( 24),
                             UINT8_C( 11), UINT8_C(162), UINT8_C(224), UINT8_C(110)),
      UINT64_C(0x7eb70d1d341a6e9a) },
    { simde_x_mm512_set_epu8(UINT8_C(  2), UINT8_C(175), UINT8_C( 14), UINT8_C( 90),
                             UINT8_C(156), UINT8_C(134), UINT8_C(221), UINT8_C( 81),
                             UINT8_C(242), UINT8_C(214), UINT8_C(125), UINT8_C(131),
                             UINT8_C(199), UINT8_C( 90), UINT8_C(247), UINT8_C( 63),
                             UINT8_C( 53), UINT8_C( 77), UINT8_C( 63), UINT8_C(172),
                             UINT8_C( 27), UINT8_C( 22), UINT8_C(228), UINT8_C(219),
                             UINT8_C( 65), UINT8_C(118), UINT8_C(130), UINT8_C( 97),
                             UINT8_C(109), UINT8_C(137), UINT8_C(142), UINT8_C(181),
                             UINT8_C(131), UINT8_C(121), UINT8_C(128), UINT8_C(103),
                             UINT8_C(  0), UINT8_C(101), UINT8_C(215), UINT8_C( 89),
                             UINT8_C( 67), UINT8_C(191), UINT8_C(  9), UINT8_C(249),
                             UINT8_C(193), UINT8_C( 13), UINT8_C(105), UINT8_C( 92),
                             UINT8_C(238), UINT8_C(235), UINT8_C(154), UINT8_C(142),
                             UINT8_C( 74), UINT8_C(121), UINT8_C(211), UINT8_C( 52),
                             UINT8_C(193), UINT8_C(163), UINT8_C( 98), UINT8_C(106),
                             UINT8_C(147), UINT8_C(209), UINT8_C( 37), UINT8_C( 70)),
      simde_x_mm512_set_epu8(UINT8_C(214), UINT8_C(132), UINT8_C( 54), UINT8_C( 74),
                             UINT8_C(164), UINT8_C( 99), UINT8_C( 79), UINT8_C(253),
                             UINT8_C( 61), UINT8_C(167), UINT8_C( 84), UINT8_C(162),
                             UINT8_C( 31), UINT8_C(140), UINT8_C(189), UINT8_C(154),
                             UINT8_C(184), UINT8_C(165), UINT8_C(151), UINT8_C(148),
                             UINT8_C(212), UINT8_C( 74), UINT8_C(228), UINT8_C(124),
                             UINT8_C(120), UINT8_C(215), UINT8_C(177), UINT8_C(122),
                             UINT8_C( 87), UINT8_C(137), UINT8_C( 54), UINT8_C(254),
                             UINT8_C(209), UINT8_C( 84), UINT8_C(130), UINT8_C(192),
                             UINT8_C( 14), UINT8_C( 11), UINT8_C( 37), UINT8_C(233),
                             UINT8_C( 67), UINT8_C(124), UINT8_C( 58), UINT8_C(162),
                             UINT8_C( 30), UINT8_C(223), UINT8_C( 70), UINT8_C(232),
                             UINT8_C( 38), UINT8_C(159), UINT8_C(200), UINT8_C(196),
                             UINT8_C(197), UINT8_C( 65), UINT8_C(182), UINT8_C( 45),
                             UINT8_C(245), UINT8_C( 55), UINT8_C(174), UINT8_C( 12),
                             UINT8_C(106), UINT8_C( 22), UINT8_C(132), UINT8_C(252)),
      UINT64_C(0x56ea130e46dac75c) },
    { simde_x_mm512_set_epu8(UINT8_C( 18), UINT8_C( 13), UINT8_C( 14), UINT8_C(  4),
                             UINT8_C(253), UINT8_C(192), UINT8_C( 17), UINT8_C(141),
                             UINT8_C( 21), UINT8_C(222), UINT8_C(125), UINT8_C(196),
                             UINT8_C(184), UINT8_C( 74), UINT8_C(251), UINT8_C(235),
                             UINT8_C(215), UINT8_C( 22), UINT8_C( 45), UINT8_C(102),
                             UINT8_C( 59), UINT8_C(176), UINT8_C(241), UINT8_C(193),
                             UINT8_C( 84), UINT8_C(185), UINT8_C(  8), UINT8_C( 12),
                             UINT8_C(245), UINT8_C(180), UINT8_C( 62), UINT8_C( 93),
                             UINT8_C(181), UINT8_C(179), UINT8_C(172), UINT8_C(148),
                             UINT8_C(221), UINT8_C( 14), UINT8_C(196), UINT8_C( 18),
                             UINT8_C( 23), UINT8_C(196), UINT8_C(193), UINT8_C(142),
                             UINT8_C(201), UINT8_C( 75), UINT8_C(157), UINT8_C(201),
                             UINT8_C( 58), UINT8_C( 76), UINT8_C(154), UINT8_C(138),
                             UINT8_C( 10), UINT8_C( 39), UINT8_C(119), UINT8_C( 85),
                             UINT8_C(248), UINT8_C(184), UINT8_C(196), UINT8_C(162),
                             UINT8_C(144), UINT8_C(119), UINT8_C(124), UINT8_C( 76)),
      simde_x_mm512_set_epu8(UINT8_C( 18), UINT8_C(182), UINT8_C( 14), UINT8_C( 36),
                             UINT8_C(249), UINT8_C(113), UINT8_C( 40), UINT8_C( 48),
                             UINT8_C(149), UINT8_C(222), UINT8_C(181), UINT8_C( 85),
                             UINT8_C(221), UINT8_C(140), UINT8_C( 65), UINT8_C(235),
                             UINT8_C( 15), UINT8_C(  3), UINT8_C( 45), UINT8_C( 21),
                             UINT8_C( 72), UINT8_C( 93), UINT8_C(108), UINT8_C(125),
                             UINT8_C(  1), UINT8_C( 75), UINT8_C( 21), UINT8_C(220),
                             UINT8_C(130), UINT8_C(122), UINT8_C( 71), UINT8_C( 76),
                             UINT8_C( 28), UINT8_C(200), UINT8_C( 32), UINT8_C(101),
                             UINT8_C(149), UINT8_C(145), UINT8_C(168), UINT8_C(237),
                             UINT8_C(179), UINT8_C( 19), UINT8_C(235), UINT8_C(145),
                             UINT8_C(188), UINT8_C( 82), UINT8_C(138), UINT8_C(180),
                             UINT8_C( 47), UINT8_C(127), UINT8_C( 62), UINT8_C(240),
                             UINT8_C( 10), UINT8_C(242), UINT8_C(156), UINT8_C( 86),
                             UINT8_C( 29), UINT8_C(107), UINT8_C( 56), UINT8_C( 21),
                             UINT8_C( 24), UINT8_C( 68), UINT8_C(160), UINT8_C( 64)),
      UINT64_C(0xad53f7cdba4ba8fd) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__mmask64 r = simde_mm512_cmpge_epu8_mask(test_vec[i].a, test_vec[i].b);
    munit_assert_uint64(r, ==, test_vec[i].r);
   }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_cmpgt_epi8_mask(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i   a;
    simde__m512i   b;
    simde__mmask64 r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C(  92), INT8_C(-121), INT8_C( 120), INT8_C( -19),
                           INT8_C( -73), INT8_C(  22), INT8_C( -66), INT8_C( -29),
                           INT8_C(  55), INT8_C( -63), INT8_C( -45), INT8_C(-119),
                           INT8_C(  30), INT8_C( -29), INT8_C( -26), INT8_C(  89),
                           INT8_C( -13), INT8_C( 119), INT8_C( -88), INT8_C( 109),
                           INT8_C(  68), INT8_C( -10), INT8_C(   0), INT8_C( -18),
                           INT8_C(   1), INT8_C( 116), INT8_C( -13), INT8_C( -73),
                           INT8_C(-122), INT8_C(   0), INT8_C( 111), INT8_C(  95),
                           INT8_C( -20), INT8_C(   3), INT8_C( 122), INT8_C( -43),
                           INT8_C(  13), INT8_C(  25), INT8_C( -35), INT8_C(-127),
                           INT8_C(  82), INT8_C(  90), INT8_C(  53), INT8_C( 123),
                           INT8_C(  73), INT8_C( 108), INT8_C( -18), INT8_C(  15),
                           INT8_C( 115), INT8_C(  54), INT8_C( 102), INT8_C( 118),
                           INT8_C(  39), INT8_C( -77), INT8_C(  45), INT8_C(  81),
                           INT8_C( -17), INT8_C( -28), INT8_C(  67), INT8_C( -85),
                           INT8_C(  79), INT8_C(-113), INT8_C(-122), INT8_C( 124)),
      simde_mm512_set_epi8(INT8_C(   9), INT8_C(-121), INT8_C( 120), INT8_C( -36),
                           INT8_C(  36), INT8_C(-103), INT8_C(-104), INT8_C(  25),
                           INT8_C(-111), INT8_C( -63), INT8_C( -35), INT8_C(-120),
                           INT8_C(  28), INT8_C( -44), INT8_C( -26), INT8_C( -86),
                           INT8_C( -13), INT8_C(  53), INT8_C( -88), INT8_C(-107),
                           INT8_C(  68), INT8_C(  42), INT8_C(-118), INT8_C( 111),
                           INT8_C(  54), INT8_C( -58), INT8_C( -13), INT8_C(  27),
                           INT8_C(  23), INT8_C(  41), INT8_C(-119), INT8_C(  44),
                           INT8_C(   7), INT8_C(-120), INT8_C(  32), INT8_C( -43),
                           INT8_C( 114), INT8_C( -72), INT8_C(  73), INT8_C( -96),
                           INT8_C(  96), INT8_C( 110), INT8_C( -81), INT8_C( -76),
                           INT8_C( 103), INT8_C(-100), INT8_C( -22), INT8_C(  18),
                           INT8_C( 115), INT8_C(  54), INT8_C( -40), INT8_C( 125),
                           INT8_C( 110), INT8_C(  31), INT8_C(  51), INT8_C(-104),
                           INT8_C(-115), INT8_C( -27), INT8_C(  62), INT8_C( -85),
                           INT8_C(  49), INT8_C(-115), INT8_C(  38), INT8_C(   4)),
      UINT64_C(0x969d5243643621ad) },
    { simde_mm512_set_epi8(INT8_C(  16), INT8_C(  41), INT8_C( 102), INT8_C( -95),
                           INT8_C(  17), INT8_C(  42), INT8_C( -86), INT8_C(  38),
                           INT8_C(  62), INT8_C( -56), INT8_C(  60), INT8_C(  19),
                           INT8_C(-100), INT8_C(-107), INT8_C( 105), INT8_C( -76),
                           INT8_C(  10), INT8_C(  -9), INT8_C( -12), INT8_C( -56),
                           INT8_C( -71), INT8_C(  96), INT8_C(  31), INT8_C(  24),
                           INT8_C(  68), INT8_C(  -7), INT8_C( -27), INT8_C(   3),
                           INT8_C( -21), INT8_C(  50), INT8_C( -67), INT8_C( -39),
                           INT8_C(-108), INT8_C(  62), INT8_C( 101), INT8_C(  56),
                           INT8_C( -79), INT8_C( -37), INT8_C( -99), INT8_C( -56),
                           INT8_C(-119), INT8_C( -56), INT8_C(  -8), INT8_C( -16),
                           INT8_C( 115), INT8_C( -95), INT8_C( -73), INT8_C(  54),
                           INT8_C( 125), INT8_C(  85), INT8_C(  78), INT8_C( -65),
                           INT8_C(   4), INT8_C(  38), INT8_C( -84), INT8_C( -53),
                           INT8_C(  68), INT8_C(-108), INT8_C(-121), INT8_C(-115),
                           INT8_C( -59), INT8_C( -78), INT8_C(-111), INT8_C(  56)),
      simde_mm512_set_epi8(INT8_C(-104), INT8_C(-102), INT8_C( 102), INT8_C( -95),
                           INT8_C(  69), INT8_C(  13), INT8_C( -21), INT8_C(  45),
                           INT8_C(  62), INT8_C(-120), INT8_C(-111), INT8_C(  32),
                           INT8_C(-107), INT8_C( -30), INT8_C(  99), INT8_C( -64),
                           INT8_C(   8), INT8_C( -42), INT8_C(  81), INT8_C( -34),
                           INT8_C( -46), INT8_C(  26), INT8_C(  31), INT8_C(  -2),
                           INT8_C(  68), INT8_C(  -7), INT8_C( -71), INT8_C(  46),
                           INT8_C( -21), INT8_C( -73), INT8_C(  21), INT8_C(  83),
                           INT8_C(-108), INT8_C( -97), INT8_C( -69), INT8_C(  73),
                           INT8_C(  57), INT8_C( -37), INT8_C(  21), INT8_C(  82),
                           INT8_C(-119), INT8_C(-126), INT8_C( 126), INT8_C(  91),
                           INT8_C( 115), INT8_C(  31), INT8_C( -79), INT8_C(  28),
                           INT8_C(-106), INT8_C( -18), INT8_C(  65), INT8_C(-104),
                           INT8_C(  81), INT8_C(  38), INT8_C( -84), INT8_C(  -2),
                           INT8_C( -14), INT8_C(  85), INT8_C( -80), INT8_C(  80),
                           INT8_C(  48), INT8_C(  93), INT8_C(  79), INT8_C( 127)),
      UINT64_C(0xc46ac5246043f080) },
    { simde_mm512_set_epi8(INT8_C(  50), INT8_C(  43), INT8_C( -68), INT8_C(  97),
                           INT8_C( -26), INT8_C(-103), INT8_C(  71), INT8_C(-107),
                           INT8_C(  91), INT8_C(  45), INT8_C( -11), INT8_C(  47),
                           INT8_C(  29), INT8_C( -56), INT8_C(  26), INT8_C(  -9),
                           INT8_C(  10), INT8_C(  36), INT8_C(-116), INT8_C( -53),
                           INT8_C(  41), INT8_C(   1), INT8_C( -23), INT8_C(  61),
                           INT8_C(-127), INT8_C(  -4), INT8_C(  48), INT8_C( -68),
                           INT8_C(  89), INT8_C(-112), INT8_C( -31), INT8_C( 120),
                           INT8_C(  35), INT8_C(  62), INT8_C( -21), INT8_C(-114),
                           INT8_C(-104), INT8_C(  57), INT8_C(  42), INT8_C(-111),
                           INT8_C(  94), INT8_C( -63), INT8_C(  87), INT8_C(  64),
                           INT8_C( -65), INT8_C(  -2), INT8_C( 110), INT8_C(  -8),
                           INT8_C(  63), INT8_C( -51), INT8_C(  -4), INT8_C(  32),
                           INT8_C( -65), INT8_C(  55), INT8_C(  14), INT8_C(  81),
                           INT8_C(-123), INT8_C(-100), INT8_C( -39), INT8_C( -44),
                           INT8_C(  22), INT8_C( 112), INT8_C(  16), INT8_C(  15)),
      simde_mm512_set_epi8(INT8_C(  50), INT8_C( -11), INT8_C( -68), INT8_C( -31),
                           INT8_C( 105), INT8_C(-106), INT8_C(  98), INT8_C(  51),
                           INT8_C(  58), INT8_C( 103), INT8_C( 111), INT8_C(-127),
                           INT8_C(  68), INT8_C( -56), INT8_C( 124), INT8_C(-119),
                           INT8_C(  74), INT8_C( -62), INT8_C(-116), INT8_C(  37),
                           INT8_C( -12), INT8_C( 114), INT8_C(   0), INT8_C(  61),
                           INT8_C( 103), INT8_C(  -4), INT8_C(-105), INT8_C( -68),
                           INT8_C(  39), INT8_C(-100), INT8_C( -93), INT8_C(  11),
                           INT8_C( -80), INT8_C( -19), INT8_C( -22), INT8_C( -39),
                           INT8_C( 127), INT8_C( -38), INT8_C(-125), INT8_C(-111),
                           INT8_C(  84), INT8_C( -96), INT8_C(  87), INT8_C( -22),
                           INT8_C(  -5), INT8_C(  -3), INT8_C(-127), INT8_C(  41),
                           INT8_C(  74), INT8_C(  72), INT8_C(  -4), INT8_C(  28),
                           INT8_C(-115), INT8_C(  93), INT8_C( 102), INT8_C(  44),
                           INT8_C(-103), INT8_C( -29), INT8_C( -50), INT8_C(  48),
                           INT8_C( -96), INT8_C( -50), INT8_C(  46), INT8_C( -65)),
      UINT64_C(0x5491482be6d6192d) },
    { simde_mm512_set_epi8(INT8_C( -97), INT8_C(  28), INT8_C( -58), INT8_C(  11),
                           INT8_C( -14), INT8_C( 126), INT8_C(  81), INT8_C(  45),
                           INT8_C( -23), INT8_C( 120), INT8_C( -83), INT8_C( -16),
                           INT8_C(   7), INT8_C(  51), INT8_C( -57), INT8_C( -50),
                           INT8_C( -21), INT8_C(  98), INT8_C(  88), INT8_C(   0),
                           INT8_C( -66), INT8_C(   3), INT8_C( 124), INT8_C(-113),
                           INT8_C(  50), INT8_C(  32), INT8_C( -85), INT8_C( -93),
                           INT8_C( -44), INT8_C( -13), INT8_C( -94), INT8_C(  17),
                           INT8_C( 122), INT8_C(  79), INT8_C(-116), INT8_C(  43),
                           INT8_C( -77), INT8_C(-125), INT8_C( -23), INT8_C(-120),
                           INT8_C(  96), INT8_C( -64), INT8_C( -23), INT8_C( -46),
                           INT8_C( -29), INT8_C( -71), INT8_C(  71), INT8_C( -80),
                           INT8_C(  44), INT8_C( -92), INT8_C( -31), INT8_C(  26),
                           INT8_C(   8), INT8_C(  52), INT8_C( 117), INT8_C( 123),
                           INT8_C( -63), INT8_C(  45), INT8_C(  95), INT8_C(  24),
                           INT8_C(-108), INT8_C(  18), INT8_C( -60), INT8_C(  28)),
      simde_mm512_set_epi8(INT8_C( -23), INT8_C(-101), INT8_C( 116), INT8_C( 127),
                           INT8_C(  96), INT8_C(  40), INT8_C( -97), INT8_C(  40),
                           INT8_C(  86), INT8_C( -44), INT8_C(  70), INT8_C( -71),
                           INT8_C(  62), INT8_C( -21), INT8_C(  66), INT8_C(  68),
                           INT8_C( -87), INT8_C( -61), INT8_C(  48), INT8_C( -70),
                           INT8_C(  18), INT8_C( -78), INT8_C( -98), INT8_C( 117),
                           INT8_C(  74), INT8_C(  32), INT8_C(  93), INT8_C( 125),
                           INT8_C( -47), INT8_C( -60), INT8_C( -86), INT8_C( 117),
                           INT8_C( 122), INT8_C( -54), INT8_C(  50), INT8_C( 123),
                           INT8_C( -31), INT8_C( -74), INT8_C( -64), INT8_C(  54),
                           INT8_C( -81), INT8_C(  60), INT8_C(  31), INT8_C( -23),
                           INT8_C( 108), INT8_C(-119), INT8_C( -92), INT8_C( -80),
                           INT8_C( -30), INT8_C( -37), INT8_C(  51), INT8_C( -36),
                           INT8_C(   8), INT8_C(  52), INT8_C(  97), INT8_C( 123),
                           INT8_C( -49), INT8_C(-124), INT8_C(  95), INT8_C( -83),
                           INT8_C(  70), INT8_C( -50), INT8_C( -61), INT8_C(  25)),
      UINT64_C(0x4754f60c42869257) },
    { simde_mm512_set_epi8(INT8_C( 121), INT8_C( -20), INT8_C( -89), INT8_C( -94),
                           INT8_C( 112), INT8_C( -27), INT8_C(  81), INT8_C( -54),
                           INT8_C( -64), INT8_C(-114), INT8_C(  48), INT8_C( -89),
                           INT8_C( -61), INT8_C(  26), INT8_C(  43), INT8_C(  29),
                           INT8_C(   0), INT8_C( 125), INT8_C( -42), INT8_C( -67),
                           INT8_C(  15), INT8_C( 120), INT8_C(  36), INT8_C(  40),
                           INT8_C( -53), INT8_C(  34), INT8_C(-108), INT8_C( -58),
                           INT8_C(  26), INT8_C(-111), INT8_C(  63), INT8_C( -98),
                           INT8_C(  65), INT8_C(   8), INT8_C(-124), INT8_C(  96),
                           INT8_C( -13), INT8_C( -98), INT8_C(  99), INT8_C(  90),
                           INT8_C(  56), INT8_C( -45), INT8_C(-108), INT8_C( -19),
                           INT8_C(-124), INT8_C( -27), INT8_C(  22), INT8_C( 126),
                           INT8_C(-106), INT8_C( -68), INT8_C( -60), INT8_C(   8),
                           INT8_C( -54), INT8_C(  93), INT8_C( -33), INT8_C( -27),
                           INT8_C(  -7), INT8_C(  27), INT8_C(-122), INT8_C( -88),
                           INT8_C(  23), INT8_C(   6), INT8_C(  45), INT8_C( -21)),
      simde_mm512_set_epi8(INT8_C( 105), INT8_C(  52), INT8_C(  85), INT8_C(-104),
                           INT8_C(  57), INT8_C( -31), INT8_C( -38), INT8_C(-124),
                           INT8_C(-107), INT8_C(  -2), INT8_C(  55), INT8_C(  46),
                           INT8_C( -71), INT8_C(  77), INT8_C(  18), INT8_C(  70),
                           INT8_C(  89), INT8_C( 125), INT8_C( -42), INT8_C(-125),
                           INT8_C( 121), INT8_C( -11), INT8_C( -69), INT8_C( -59),
                           INT8_C( -53), INT8_C(  34), INT8_C(   9), INT8_C(  64),
                           INT8_C( -61), INT8_C( -25), INT8_C(-115), INT8_C( 100),
                           INT8_C(  65), INT8_C(   8), INT8_C(  69), INT8_C(  -8),
                           INT8_C( -15), INT8_C( -51), INT8_C(   1), INT8_C(  90),
                           INT8_C( 115), INT8_C(  51), INT8_C( -91), INT8_C(  56),
                           INT8_C(  64), INT8_C( -39), INT8_C(-119), INT8_C( -28),
                           INT8_C( -54), INT8_C(  28), INT8_C(  54), INT8_C(  -8),
                           INT8_C( -54), INT8_C(-128), INT8_C( -28), INT8_C( -71),
                           INT8_C( 107), INT8_C( -66), INT8_C(-114), INT8_C( -88),
                           INT8_C(  34), INT8_C( -83), INT8_C( -21), INT8_C( -64)),
      UINT64_C(0x9f8a170a1a071547) },
    { simde_mm512_set_epi8(INT8_C(  33), INT8_C( 121), INT8_C( 125), INT8_C(  35),
                           INT8_C(-103), INT8_C( -48), INT8_C( -22), INT8_C(  38),
                           INT8_C( -81), INT8_C(   9), INT8_C( -11), INT8_C(-124),
                           INT8_C(  71), INT8_C(   9), INT8_C( -42), INT8_C( 118),
                           INT8_C(  67), INT8_C(  45), INT8_C(  51), INT8_C( -92),
                           INT8_C( 126), INT8_C( 108), INT8_C(-123), INT8_C( -71),
                           INT8_C( 113), INT8_C(  32), INT8_C(  71), INT8_C(   3),
                           INT8_C( -26), INT8_C(  82), INT8_C( -81), INT8_C( -20),
                           INT8_C( -55), INT8_C( 112), INT8_C(  66), INT8_C(  37),
                           INT8_C(  67), INT8_C( -69), INT8_C(  64), INT8_C(  39),
                           INT8_C(  72), INT8_C(  45), INT8_C( 120), INT8_C(  -5),
                           INT8_C(-109), INT8_C(  62), INT8_C(  17), INT8_C(  31),
                           INT8_C( -30), INT8_C( -58), INT8_C(  56), INT8_C(  21),
                           INT8_C(  72), INT8_C( -75), INT8_C( -34), INT8_C( 120),
                           INT8_C(  95), INT8_C( 108), INT8_C(  32), INT8_C(  64),
                           INT8_C(-128), INT8_C( 102), INT8_C( -21), INT8_C(  28)),
      simde_mm512_set_epi8(INT8_C( 100), INT8_C( 121), INT8_C(  18), INT8_C(  28),
                           INT8_C(-117), INT8_C( 107), INT8_C(   3), INT8_C( -62),
                           INT8_C(  42), INT8_C(  72), INT8_C(  91), INT8_C(  86),
                           INT8_C( -72), INT8_C(   9), INT8_C( -80), INT8_C( 118),
                           INT8_C( 122), INT8_C(-108), INT8_C( -70), INT8_C( -63),
                           INT8_C(  56), INT8_C(  71), INT8_C( -14), INT8_C(  49),
                           INT8_C( -73), INT8_C(  53), INT8_C( -29), INT8_C(   3),
                           INT8_C( -73), INT8_C(  43), INT8_C( -22), INT8_C(  85),
                           INT8_C( -26), INT8_C(  -9), INT8_C(  66), INT8_C(   1),
                           INT8_C( -13), INT8_C(  60), INT8_C(-119), INT8_C( -83),
                           INT8_C(-122), INT8_C( -64), INT8_C( -83), INT8_C( -74),
                           INT8_C( 119), INT8_C(  -8), INT8_C(  12), INT8_C( 113),
                           INT8_C( -12), INT8_C( -84), INT8_C(   6), INT8_C(  69),
                           INT8_C(   2), INT8_C( -75), INT8_C( -34), INT8_C(-126),
                           INT8_C(   3), INT8_C(-128), INT8_C(  -9), INT8_C(  24),
                           INT8_C(  11), INT8_C( -94), INT8_C( -32), INT8_C( 110)),
      UINT64_C(0x390a6cac5bf669f6) },
    { simde_mm512_set_epi8(INT8_C(   2), INT8_C( -81), INT8_C(  14), INT8_C(  90),
                           INT8_C(-100), INT8_C(-122), INT8_C( -35), INT8_C(  81),
                           INT8_C( -14), INT8_C( -42), INT8_C( 125), INT8_C(-125),
                           INT8_C( -57), INT8_C(  90), INT8_C(  -9), INT8_C(  63),
                           INT8_C(  53), INT8_C(  77), INT8_C(  63), INT8_C( -84),
                           INT8_C(  27), INT8_C(  22), INT8_C( -28), INT8_C( -37),
                           INT8_C(  65), INT8_C( 118), INT8_C(-126), INT8_C(  97),
                           INT8_C( 109), INT8_C(-119), INT8_C(-114), INT8_C( -75),
                           INT8_C(-125), INT8_C( 121), INT8_C(-128), INT8_C( 103),
                           INT8_C(   0), INT8_C( 101), INT8_C( -41), INT8_C(  89),
                           INT8_C(  67), INT8_C( -65), INT8_C(   9), INT8_C(  -7),
                           INT8_C( -63), INT8_C(  13), INT8_C( 105), INT8_C(  92),
                           INT8_C( -18), INT8_C( -21), INT8_C(-102), INT8_C(-114),
                           INT8_C(  74), INT8_C( 121), INT8_C( -45), INT8_C(  52),
                           INT8_C( -63), INT8_C( -93), INT8_C(  98), INT8_C( 106),
                           INT8_C(-109), INT8_C( -47), INT8_C(  37), INT8_C(  70)),
      simde_mm512_set_epi8(INT8_C( -42), INT8_C(-124), INT8_C(  54), INT8_C(  74),
                           INT8_C( -92), INT8_C(  99), INT8_C(  79), INT8_C(  -3),
                           INT8_C(  61), INT8_C( -89), INT8_C(  84), INT8_C( -94),
                           INT8_C(  31), INT8_C(-116), INT8_C( -67), INT8_C(-102),
                           INT8_C( -72), INT8_C( -91), INT8_C(-105), INT8_C(-108),
                           INT8_C( -44), INT8_C(  74), INT8_C( -28), INT8_C( 124),
                           INT8_C( 120), INT8_C( -41), INT8_C( -79), INT8_C( 122),
                           INT8_C(  87), INT8_C(-119), INT8_C(  54), INT8_C(  -2),
                           INT8_C( -47), INT8_C(  84), INT8_C(-126), INT8_C( -64),
                           INT8_C(  14), INT8_C(  11), INT8_C(  37), INT8_C( -23),
                           INT8_C(  67), INT8_C( 124), INT8_C(  58), INT8_C( -94),
                           INT8_C(  30), INT8_C( -33), INT8_C(  70), INT8_C( -24),
                           INT8_C(  38), INT8_C( -97), INT8_C( -56), INT8_C( -60),
                           INT8_C( -59), INT8_C(  65), INT8_C( -74), INT8_C(  45),
                           INT8_C( -11), INT8_C(  55), INT8_C( -82), INT8_C(  12),
                           INT8_C( 106), INT8_C(  22), INT8_C(-124), INT8_C(  -4)),
      UINT64_C(0xd167f84855174f33) },
    { simde_mm512_set_epi8(INT8_C(  18), INT8_C(  13), INT8_C(  14), INT8_C(   4),
                           INT8_C(  -3), INT8_C( -64), INT8_C(  17), INT8_C(-115),
                           INT8_C(  21), INT8_C( -34), INT8_C( 125), INT8_C( -60),
                           INT8_C( -72), INT8_C(  74), INT8_C(  -5), INT8_C( -21),
                           INT8_C( -41), INT8_C(  22), INT8_C(  45), INT8_C( 102),
                           INT8_C(  59), INT8_C( -80), INT8_C( -15), INT8_C( -63),
                           INT8_C(  84), INT8_C( -71), INT8_C(   8), INT8_C(  12),
                           INT8_C( -11), INT8_C( -76), INT8_C(  62), INT8_C(  93),
                           INT8_C( -75), INT8_C( -77), INT8_C( -84), INT8_C(-108),
                           INT8_C( -35), INT8_C(  14), INT8_C( -60), INT8_C(  18),
                           INT8_C(  23), INT8_C( -60), INT8_C( -63), INT8_C(-114),
                           INT8_C( -55), INT8_C(  75), INT8_C( -99), INT8_C( -55),
                           INT8_C(  58), INT8_C(  76), INT8_C(-102), INT8_C(-118),
                           INT8_C(  10), INT8_C(  39), INT8_C( 119), INT8_C(  85),
                           INT8_C(  -8), INT8_C( -72), INT8_C( -60), INT8_C( -94),
                           INT8_C(-112), INT8_C( 119), INT8_C( 124), INT8_C(  76)),
      simde_mm512_set_epi8(INT8_C(  18), INT8_C( -74), INT8_C(  14), INT8_C(  36),
                           INT8_C(  -7), INT8_C( 113), INT8_C(  40), INT8_C(  48),
                           INT8_C(-107), INT8_C( -34), INT8_C( -75), INT8_C(  85),
                           INT8_C( -35), INT8_C(-116), INT8_C(  65), INT8_C( -21),
                           INT8_C(  15), INT8_C(   3), INT8_C(  45), INT8_C(  21),
                           INT8_C(  72), INT8_C(  93), INT8_C( 108), INT8_C( 125),
                           INT8_C(   1), INT8_C(  75), INT8_C(  21), INT8_C( -36),
                           INT8_C(-126), INT8_C( 122), INT8_C(  71), INT8_C(  76),
                           INT8_C(  28), INT8_C( -56), INT8_C(  32), INT8_C( 101),
                           INT8_C(-107), INT8_C(-111), INT8_C( -88), INT8_C( -19),
                           INT8_C( -77), INT8_C(  19), INT8_C( -21), INT8_C(-111),
                           INT8_C( -68), INT8_C(  82), INT8_C(-118), INT8_C( -76),
                           INT8_C(  47), INT8_C( 127), INT8_C(  62), INT8_C( -16),
                           INT8_C(  10), INT8_C( -14), INT8_C(-100), INT8_C(  86),
                           INT8_C(  29), INT8_C( 107), INT8_C(  56), INT8_C(  21),
                           INT8_C(  24), INT8_C(  68), INT8_C( -96), INT8_C(  64)),
      UINT64_C(0x48a450990f8b8607) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__mmask64 r = simde_mm512_cmpgt_epi8_mask(test_vec[i].a, test_vec[i].b);
    munit_assert_uint64(r, ==, test_vec[i].r);
   }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_cmpgt_epu8_mask(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i   a;
    simde__m512i   b;
    simde__mmask64 r;
  } test_vec[8] = {
    { simde_x_mm512_set_epu8(UINT8_C( 92), UINT8_C(135), UINT8_C(120), UINT8_C(237),
                             UINT8_C(183), UINT8_C( 22), UINT8_C(190), UINT8_C(227),
                             UINT8_C( 55), UINT8_C(193), UINT8_C(211), UINT8_C(137),
                             UINT8_C( 30), UINT8_C(227), UINT8_C(230), UINT8_C( 89),
                             UINT8_C(243), UINT8_C(119), UINT8_C(168), UINT8_C(109),
                             UINT8_C( 68), UINT8_C(246), UINT8_C(  0), UINT8_C(238),
                             UINT8_C(  1), UINT8_C(116), UINT8_C(243), UINT8_C(183),
                             UINT8_C(134), UINT8_C(  0), UINT8_C(111), UINT8_C( 95),
                             UINT8_C(236), UINT8_C(  3), UINT8_C(122), UINT8_C(213),
                             UINT8_C( 13), UINT8_C( 25), UINT8_C(221), UINT8_C(129),
                             UINT8_C( 82), UINT8_C( 90), UINT8_C( 53), UINT8_C(123),
                             UINT8_C( 73), UINT8_C(108), UINT8_C(238), UINT8_C( 15),
                             UINT8_C(115), UINT8_C( 54), UINT8_C(102), UINT8_C(118),
                             UINT8_C( 39), UINT8_C(179), UINT8_C( 45), UINT8_C( 81),
                             UINT8_C(239), UINT8_C(228), UINT8_C( 67), UINT8_C(171),
                             UINT8_C( 79), UINT8_C(143), UINT8_C(134), UINT8_C(124)),
      simde_x_mm512_set_epu8(UINT8_C(  9), UINT8_C(135), UINT8_C(120), UINT8_C(220),
                             UINT8_C( 36), UINT8_C(153), UINT8_C(152), UINT8_C( 25),
                             UINT8_C(145), UINT8_C(193), UINT8_C(221), UINT8_C(136),
                             UINT8_C( 28), UINT8_C(212), UINT8_C(230), UINT8_C(170),
                             UINT8_C(243), UINT8_C( 53), UINT8_C(168), UINT8_C(149),
                             UINT8_C( 68), UINT8_C( 42), UINT8_C(138), UINT8_C(111),
                             UINT8_C( 54), UINT8_C(198), UINT8_C(243), UINT8_C( 27),
                             UINT8_C( 23), UINT8_C( 41), UINT8_C(137), UINT8_C( 44),
                             UINT8_C(  7), UINT8_C(136), UINT8_C( 32), UINT8_C(213),
                             UINT8_C(114), UINT8_C(184), UINT8_C( 73), UINT8_C(160),
                             UINT8_C( 96), UINT8_C(110), UINT8_C(175), UINT8_C(180),
                             UINT8_C(103), UINT8_C(156), UINT8_C(234), UINT8_C( 18),
                             UINT8_C(115), UINT8_C( 54), UINT8_C(216), UINT8_C(125),
                             UINT8_C(110), UINT8_C( 31), UINT8_C( 51), UINT8_C(152),
                             UINT8_C(141), UINT8_C(229), UINT8_C( 62), UINT8_C(171),
                             UINT8_C( 49), UINT8_C(141), UINT8_C( 38), UINT8_C(  4)),
      UINT64_C(0x9b1c4519a20204af) },
    { simde_x_mm512_set_epu8(UINT8_C( 16), UINT8_C( 41), UINT8_C(102), UINT8_C(161),
                             UINT8_C( 17), UINT8_C( 42), UINT8_C(170), UINT8_C( 38),
                             UINT8_C( 62), UINT8_C(200), UINT8_C( 60), UINT8_C( 19),
                             UINT8_C(156), UINT8_C(149), UINT8_C(105), UINT8_C(180),
                             UINT8_C( 10), UINT8_C(247), UINT8_C(244), UINT8_C(200),
                             UINT8_C(185), UINT8_C( 96), UINT8_C( 31), UINT8_C( 24),
                             UINT8_C( 68), UINT8_C(249), UINT8_C(229), UINT8_C(  3),
                             UINT8_C(235), UINT8_C( 50), UINT8_C(189), UINT8_C(217),
                             UINT8_C(148), UINT8_C( 62), UINT8_C(101), UINT8_C( 56),
                             UINT8_C(177), UINT8_C(219), UINT8_C(157), UINT8_C(200),
                             UINT8_C(137), UINT8_C(200), UINT8_C(248), UINT8_C(240),
                             UINT8_C(115), UINT8_C(161), UINT8_C(183), UINT8_C( 54),
                             UINT8_C(125), UINT8_C( 85), UINT8_C( 78), UINT8_C(191),
                             UINT8_C(  4), UINT8_C( 38), UINT8_C(172), UINT8_C(203),
                             UINT8_C( 68), UINT8_C(148), UINT8_C(135), UINT8_C(141),
                             UINT8_C(197), UINT8_C(178), UINT8_C(145), UINT8_C( 56)),
      simde_x_mm512_set_epu8(UINT8_C(152), UINT8_C(154), UINT8_C(102), UINT8_C(161),
                             UINT8_C( 69), UINT8_C( 13), UINT8_C(235), UINT8_C( 45),
                             UINT8_C( 62), UINT8_C(136), UINT8_C(145), UINT8_C( 32),
                             UINT8_C(149), UINT8_C(226), UINT8_C( 99), UINT8_C(192),
                             UINT8_C(  8), UINT8_C(214), UINT8_C( 81), UINT8_C(222),
                             UINT8_C(210), UINT8_C( 26), UINT8_C( 31), UINT8_C(254),
                             UINT8_C( 68), UINT8_C(249), UINT8_C(185), UINT8_C( 46),
                             UINT8_C(235), UINT8_C(183), UINT8_C( 21), UINT8_C( 83),
                             UINT8_C(148), UINT8_C(159), UINT8_C(187), UINT8_C( 73),
                             UINT8_C( 57), UINT8_C(219), UINT8_C( 21), UINT8_C( 82),
                             UINT8_C(137), UINT8_C(130), UINT8_C(126), UINT8_C( 91),
                             UINT8_C(115), UINT8_C( 31), UINT8_C(177), UINT8_C( 28),
                             UINT8_C(150), UINT8_C(238), UINT8_C( 65), UINT8_C(152),
                             UINT8_C( 81), UINT8_C( 38), UINT8_C(172), UINT8_C(254),
                             UINT8_C(242), UINT8_C( 85), UINT8_C(176), UINT8_C( 80),
                             UINT8_C( 48), UINT8_C( 93), UINT8_C( 79), UINT8_C(127)),
      UINT64_C(0x44ae4230b77305e) },
    { simde_x_mm512_set_epu8(UINT8_C( 50), UINT8_C( 43), UINT8_C(188), UINT8_C( 97),
                             UINT8_C(230), UINT8_C(153), UINT8_C( 71), UINT8_C(149),
                             UINT8_C( 91), UINT8_C( 45), UINT8_C(245), UINT8_C( 47),
                             UINT8_C( 29), UINT8_C(200), UINT8_C( 26), UINT8_C(247),
                             UINT8_C( 10), UINT8_C( 36), UINT8_C(140), UINT8_C(203),
                             UINT8_C( 41), UINT8_C(  1), UINT8_C(233), UINT8_C( 61),
                             UINT8_C(129), UINT8_C(252), UINT8_C( 48), UINT8_C(188),
                             UINT8_C( 89), UINT8_C(144), UINT8_C(225), UINT8_C(120),
                             UINT8_C( 35), UINT8_C( 62), UINT8_C(235), UINT8_C(142),
                             UINT8_C(152), UINT8_C( 57), UINT8_C( 42), UINT8_C(145),
                             UINT8_C( 94), UINT8_C(193), UINT8_C( 87), UINT8_C( 64),
                             UINT8_C(191), UINT8_C(254), UINT8_C(110), UINT8_C(248),
                             UINT8_C( 63), UINT8_C(205), UINT8_C(252), UINT8_C( 32),
                             UINT8_C(191), UINT8_C( 55), UINT8_C( 14), UINT8_C( 81),
                             UINT8_C(133), UINT8_C(156), UINT8_C(217), UINT8_C(212),
                             UINT8_C( 22), UINT8_C(112), UINT8_C( 16), UINT8_C( 15)),
      simde_x_mm512_set_epu8(UINT8_C( 50), UINT8_C(245), UINT8_C(188), UINT8_C(225),
                             UINT8_C(105), UINT8_C(150), UINT8_C( 98), UINT8_C( 51),
                             UINT8_C( 58), UINT8_C(103), UINT8_C(111), UINT8_C(129),
                             UINT8_C( 68), UINT8_C(200), UINT8_C(124), UINT8_C(137),
                             UINT8_C( 74), UINT8_C(194), UINT8_C(140), UINT8_C( 37),
                             UINT8_C(244), UINT8_C(114), UINT8_C(  0), UINT8_C( 61),
                             UINT8_C(103), UINT8_C(252), UINT8_C(151), UINT8_C(188),
                             UINT8_C( 39), UINT8_C(156), UINT8_C(163), UINT8_C( 11),
                             UINT8_C(176), UINT8_C(237), UINT8_C(234), UINT8_C(217),
                             UINT8_C(127), UINT8_C(218), UINT8_C(131), UINT8_C(145),
                             UINT8_C( 84), UINT8_C(160), UINT8_C( 87), UINT8_C(234),
                             UINT8_C(251), UINT8_C(253), UINT8_C(129), UINT8_C( 41),
                             UINT8_C( 74), UINT8_C( 72), UINT8_C(252), UINT8_C( 28),
                             UINT8_C(141), UINT8_C( 93), UINT8_C(102), UINT8_C( 44),
                             UINT8_C(153), UINT8_C(227), UINT8_C(206), UINT8_C( 48),
                             UINT8_C(160), UINT8_C(206), UINT8_C( 46), UINT8_C(191)),
      UINT64_C(0xda1128b28c55930) },
    { simde_x_mm512_set_epu8(UINT8_C(159), UINT8_C( 28), UINT8_C(198), UINT8_C( 11),
                             UINT8_C(242), UINT8_C(126), UINT8_C( 81), UINT8_C( 45),
                             UINT8_C(233), UINT8_C(120), UINT8_C(173), UINT8_C(240),
                             UINT8_C(  7), UINT8_C( 51), UINT8_C(199), UINT8_C(206),
                             UINT8_C(235), UINT8_C( 98), UINT8_C( 88), UINT8_C(  0),
                             UINT8_C(190), UINT8_C(  3), UINT8_C(124), UINT8_C(143),
                             UINT8_C( 50), UINT8_C( 32), UINT8_C(171), UINT8_C(163),
                             UINT8_C(212), UINT8_C(243), UINT8_C(162), UINT8_C( 17),
                             UINT8_C(122), UINT8_C( 79), UINT8_C(140), UINT8_C( 43),
                             UINT8_C(179), UINT8_C(131), UINT8_C(233), UINT8_C(136),
                             UINT8_C( 96), UINT8_C(192), UINT8_C(233), UINT8_C(210),
                             UINT8_C(227), UINT8_C(185), UINT8_C( 71), UINT8_C(176),
                             UINT8_C( 44), UINT8_C(164), UINT8_C(225), UINT8_C( 26),
                             UINT8_C(  8), UINT8_C( 52), UINT8_C(117), UINT8_C(123),
                             UINT8_C(193), UINT8_C( 45), UINT8_C( 95), UINT8_C( 24),
                             UINT8_C(148), UINT8_C( 18), UINT8_C(196), UINT8_C( 28)),
      simde_x_mm512_set_epu8(UINT8_C(233), UINT8_C(155), UINT8_C(116), UINT8_C(127),
                             UINT8_C( 96), UINT8_C( 40), UINT8_C(159), UINT8_C( 40),
                             UINT8_C( 86), UINT8_C(212), UINT8_C( 70), UINT8_C(185),
                             UINT8_C( 62), UINT8_C(235), UINT8_C( 66), UINT8_C( 68),
                             UINT8_C(169), UINT8_C(195), UINT8_C( 48), UINT8_C(186),
                             UINT8_C( 18), UINT8_C(178), UINT8_C(158), UINT8_C(117),
                             UINT8_C( 74), UINT8_C( 32), UINT8_C( 93), UINT8_C(125),
                             UINT8_C(209), UINT8_C(196), UINT8_C(170), UINT8_C(117),
                             UINT8_C(122), UINT8_C(202), UINT8_C( 50), UINT8_C(123),
                             UINT8_C(225), UINT8_C(182), UINT8_C(192), UINT8_C( 54),
                             UINT8_C(175), UINT8_C( 60), UINT8_C( 31), UINT8_C(233),
                             UINT8_C(108), UINT8_C(137), UINT8_C(164), UINT8_C(176),
                             UINT8_C(226), UINT8_C(219), UINT8_C( 51), UINT8_C(220),
                             UINT8_C(  8), UINT8_C( 52), UINT8_C( 97), UINT8_C(123),
                             UINT8_C(207), UINT8_C(132), UINT8_C( 95), UINT8_C(173),
                             UINT8_C( 70), UINT8_C(206), UINT8_C(195), UINT8_C( 25)),
      UINT64_C(0x2db3a93c236c220b) },
    { simde_x_mm512_set_epu8(UINT8_C(121), UINT8_C(236), UINT8_C(167), UINT8_C(162),
                             UINT8_C(112), UINT8_C(229), UINT8_C( 81), UINT8_C(202),
                             UINT8_C(192), UINT8_C(142), UINT8_C( 48), UINT8_C(167),
                             UINT8_C(195), UINT8_C( 26), UINT8_C( 43), UINT8_C( 29),
                             UINT8_C(  0), UINT8_C(125), UINT8_C(214), UINT8_C(189),
                             UINT8_C( 15), UINT8_C(120), UINT8_C( 36), UINT8_C( 40),
                             UINT8_C(203), UINT8_C( 34), UINT8_C(148), UINT8_C(198),
                             UINT8_C( 26), UINT8_C(145), UINT8_C( 63), UINT8_C(158),
                             UINT8_C( 65), UINT8_C(  8), UINT8_C(132), UINT8_C( 96),
                             UINT8_C(243), UINT8_C(158), UINT8_C( 99), UINT8_C( 90),
                             UINT8_C( 56), UINT8_C(211), UINT8_C(148), UINT8_C(237),
                             UINT8_C(132), UINT8_C(229), UINT8_C( 22), UINT8_C(126),
                             UINT8_C(150), UINT8_C(188), UINT8_C(196), UINT8_C(  8),
                             UINT8_C(202), UINT8_C( 93), UINT8_C(223), UINT8_C(229),
                             UINT8_C(249), UINT8_C( 27), UINT8_C(134), UINT8_C(168),
                             UINT8_C( 23), UINT8_C(  6), UINT8_C( 45), UINT8_C(235)),
      simde_x_mm512_set_epu8(UINT8_C(105), UINT8_C( 52), UINT8_C( 85), UINT8_C(152),
                             UINT8_C( 57), UINT8_C(225), UINT8_C(218), UINT8_C(132),
                             UINT8_C(149), UINT8_C(254), UINT8_C( 55), UINT8_C( 46),
                             UINT8_C(185), UINT8_C( 77), UINT8_C( 18), UINT8_C( 70),
                             UINT8_C( 89), UINT8_C(125), UINT8_C(214), UINT8_C(131),
                             UINT8_C(121), UINT8_C(245), UINT8_C(187), UINT8_C(197),
                             UINT8_C(203), UINT8_C( 34), UINT8_C(  9), UINT8_C( 64),
                             UINT8_C(195), UINT8_C(231), UINT8_C(141), UINT8_C(100),
                             UINT8_C( 65), UINT8_C(  8), UINT8_C( 69), UINT8_C(248),
                             UINT8_C(241), UINT8_C(205), UINT8_C(  1), UINT8_C( 90),
                             UINT8_C(115), UINT8_C( 51), UINT8_C(165), UINT8_C( 56),
                             UINT8_C( 64), UINT8_C(217), UINT8_C(137), UINT8_C(228),
                             UINT8_C(202), UINT8_C( 28), UINT8_C( 54), UINT8_C(248),
                             UINT8_C(202), UINT8_C(128), UINT8_C(228), UINT8_C(185),
                             UINT8_C(107), UINT8_C(190), UINT8_C(142), UINT8_C(168),
                             UINT8_C( 34), UINT8_C(173), UINT8_C(235), UINT8_C(192)),
      UINT64_C(0xfd9a10312a5c6181) },
    { simde_x_mm512_set_epu8(UINT8_C( 33), UINT8_C(121), UINT8_C(125), UINT8_C( 35),
                             UINT8_C(153), UINT8_C(208), UINT8_C(234), UINT8_C( 38),
                             UINT8_C(175), UINT8_C(  9), UINT8_C(245), UINT8_C(132),
                             UINT8_C( 71), UINT8_C(  9), UINT8_C(214), UINT8_C(118),
                             UINT8_C( 67), UINT8_C( 45), UINT8_C( 51), UINT8_C(164),
                             UINT8_C(126), UINT8_C(108), UINT8_C(133), UINT8_C(185),
                             UINT8_C(113), UINT8_C( 32), UINT8_C( 71), UINT8_C(  3),
                             UINT8_C(230), UINT8_C( 82), UINT8_C(175), UINT8_C(236),
                             UINT8_C(201), UINT8_C(112), UINT8_C( 66), UINT8_C( 37),
                             UINT8_C( 67), UINT8_C(187), UINT8_C( 64), UINT8_C( 39),
                             UINT8_C( 72), UINT8_C( 45), UINT8_C(120), UINT8_C(251),
                             UINT8_C(147), UINT8_C( 62), UINT8_C( 17), UINT8_C( 31),
                             UINT8_C(226), UINT8_C(198), UINT8_C( 56), UINT8_C( 21),
                             UINT8_C( 72), UINT8_C(181), UINT8_C(222), UINT8_C(120),
                             UINT8_C( 95), UINT8_C(108), UINT8_C( 32), UINT8_C( 64),
                             UINT8_C(128), UINT8_C(102), UINT8_C(235), UINT8_C( 28)),
      simde_x_mm512_set_epu8(UINT8_C(100), UINT8_C(121), UINT8_C( 18), UINT8_C( 28),
                             UINT8_C(139), UINT8_C(107), UINT8_C(  3), UINT8_C(194),
                             UINT8_C( 42), UINT8_C( 72), UINT8_C( 91), UINT8_C( 86),
                             UINT8_C(184), UINT8_C(  9), UINT8_C(176), UINT8_C(118),
                             UINT8_C(122), UINT8_C(148), UINT8_C(186), UINT8_C(193),
                             UINT8_C( 56), UINT8_C( 71), UINT8_C(242), UINT8_C( 49),
                             UINT8_C(183), UINT8_C( 53), UINT8_C(227), UINT8_C(  3),
                             UINT8_C(183), UINT8_C( 43), UINT8_C(234), UINT8_C( 85),
                             UINT8_C(230), UINT8_C(247), UINT8_C( 66), UINT8_C(  1),
                             UINT8_C(243), UINT8_C( 60), UINT8_C(137), UINT8_C(173),
                             UINT8_C(134), UINT8_C(192), UINT8_C(173), UINT8_C(182),
                             UINT8_C(119), UINT8_C(248), UINT8_C( 12), UINT8_C(113),
                             UINT8_C(244), UINT8_C(172), UINT8_C(  6), UINT8_C( 69),
                             UINT8_C(  2), UINT8_C(181), UINT8_C(222), UINT8_C(130),
                             UINT8_C(  3), UINT8_C(128), UINT8_C(247), UINT8_C( 24),
                             UINT8_C( 11), UINT8_C(162), UINT8_C(224), UINT8_C(110)),
      UINT64_C(0x3eb20d0d141a689a) },
    { simde_x_mm512_set_epu8(UINT8_C(  2), UINT8_C(175), UINT8_C( 14), UINT8_C( 90),
                             UINT8_C(156), UINT8_C(134), UINT8_C(221), UINT8_C( 81),
                             UINT8_C(242), UINT8_C(214), UINT8_C(125), UINT8_C(131),
                             UINT8_C(199), UINT8_C( 90), UINT8_C(247), UINT8_C( 63),
                             UINT8_C( 53), UINT8_C( 77), UINT8_C( 63), UINT8_C(172),
                             UINT8_C( 27), UINT8_C( 22), UINT8_C(228), UINT8_C(219),
                             UINT8_C( 65), UINT8_C(118), UINT8_C(130), UINT8_C( 97),
                             UINT8_C(109), UINT8_C(137), UINT8_C(142), UINT8_C(181),
                             UINT8_C(131), UINT8_C(121), UINT8_C(128), UINT8_C(103),
                             UINT8_C(  0), UINT8_C(101), UINT8_C(215), UINT8_C( 89),
                             UINT8_C( 67), UINT8_C(191), UINT8_C(  9), UINT8_C(249),
                             UINT8_C(193), UINT8_C( 13), UINT8_C(105), UINT8_C( 92),
                             UINT8_C(238), UINT8_C(235), UINT8_C(154), UINT8_C(142),
                             UINT8_C( 74), UINT8_C(121), UINT8_C(211), UINT8_C( 52),
                             UINT8_C(193), UINT8_C(163), UINT8_C( 98), UINT8_C(106),
                             UINT8_C(147), UINT8_C(209), UINT8_C( 37), UINT8_C( 70)),
      simde_x_mm512_set_epu8(UINT8_C(214), UINT8_C(132), UINT8_C( 54), UINT8_C( 74),
                             UINT8_C(164), UINT8_C( 99), UINT8_C( 79), UINT8_C(253),
                             UINT8_C( 61), UINT8_C(167), UINT8_C( 84), UINT8_C(162),
                             UINT8_C( 31), UINT8_C(140), UINT8_C(189), UINT8_C(154),
                             UINT8_C(184), UINT8_C(165), UINT8_C(151), UINT8_C(148),
                             UINT8_C(212), UINT8_C( 74), UINT8_C(228), UINT8_C(124),
                             UINT8_C(120), UINT8_C(215), UINT8_C(177), UINT8_C(122),
                             UINT8_C( 87), UINT8_C(137), UINT8_C( 54), UINT8_C(254),
                             UINT8_C(209), UINT8_C( 84), UINT8_C(130), UINT8_C(192),
                             UINT8_C( 14), UINT8_C( 11), UINT8_C( 37), UINT8_C(233),
                             UINT8_C( 67), UINT8_C(124), UINT8_C( 58), UINT8_C(162),
                             UINT8_C( 30), UINT8_C(223), UINT8_C( 70), UINT8_C(232),
                             UINT8_C( 38), UINT8_C(159), UINT8_C(200), UINT8_C(196),
                             UINT8_C(197), UINT8_C( 65), UINT8_C(182), UINT8_C( 45),
                             UINT8_C(245), UINT8_C( 55), UINT8_C(174), UINT8_C( 12),
                             UINT8_C(106), UINT8_C( 22), UINT8_C(132), UINT8_C(252)),
      UINT64_C(0x56ea110a465ac75c) },
    { simde_x_mm512_set_epu8(UINT8_C( 18), UINT8_C( 13), UINT8_C( 14), UINT8_C(  4),
                             UINT8_C(253), UINT8_C(192), UINT8_C( 17), UINT8_C(141),
                             UINT8_C( 21), UINT8_C(222), UINT8_C(125), UINT8_C(196),
                             UINT8_C(184), UINT8_C( 74), UINT8_C(251), UINT8_C(235),
                             UINT8_C(215), UINT8_C( 22), UINT8_C( 45), UINT8_C(102),
                             UINT8_C( 59), UINT8_C(176), UINT8_C(241), UINT8_C(193),
                             UINT8_C( 84), UINT8_C(185), UINT8_C(  8), UINT8_C( 12),
                             UINT8_C(245), UINT8_C(180), UINT8_C( 62), UINT8_C( 93),
                             UINT8_C(181), UINT8_C(179), UINT8_C(172), UINT8_C(148),
                             UINT8_C(221), UINT8_C( 14), UINT8_C(196), UINT8_C( 18),
                             UINT8_C( 23), UINT8_C(196), UINT8_C(193), UINT8_C(142),
                             UINT8_C(201), UINT8_C( 75), UINT8_C(157), UINT8_C(201),
                             UINT8_C( 58), UINT8_C( 76), UINT8_C(154), UINT8_C(138),
                             UINT8_C( 10), UINT8_C( 39), UINT8_C(119), UINT8_C( 85),
                             UINT8_C(248), UINT8_C(184), UINT8_C(196), UINT8_C(162),
                             UINT8_C(144), UINT8_C(119), UINT8_C(124), UINT8_C( 76)),
      simde_x_mm512_set_epu8(UINT8_C( 18), UINT8_C(182), UINT8_C( 14), UINT8_C( 36),
                             UINT8_C(249), UINT8_C(113), UINT8_C( 40), UINT8_C( 48),
                             UINT8_C(149), UINT8_C(222), UINT8_C(181), UINT8_C( 85),
                             UINT8_C(221), UINT8_C(140), UINT8_C( 65), UINT8_C(235),
                             UINT8_C( 15), UINT8_C(  3), UINT8_C( 45), UINT8_C( 21),
                             UINT8_C( 72), UINT8_C( 93), UINT8_C(108), UINT8_C(125),
                             UINT8_C(  1), UINT8_C( 75), UINT8_C( 21), UINT8_C(220),
                             UINT8_C(130), UINT8_C(122), UINT8_C( 71), UINT8_C( 76),
                             UINT8_C( 28), UINT8_C(200), UINT8_C( 32), UINT8_C(101),
                             UINT8_C(149), UINT8_C(145), UINT8_C(168), UINT8_C(237),
                             UINT8_C(179), UINT8_C( 19), UINT8_C(235), UINT8_C(145),
                             UINT8_C(188), UINT8_C( 82), UINT8_C(138), UINT8_C(180),
                             UINT8_C( 47), UINT8_C(127), UINT8_C( 62), UINT8_C(240),
                             UINT8_C( 10), UINT8_C(242), UINT8_C(156), UINT8_C( 86),
                             UINT8_C( 29), UINT8_C(107), UINT8_C( 56), UINT8_C( 21),
                             UINT8_C( 24), UINT8_C( 68), UINT8_C(160), UINT8_C( 64)),
      UINT64_C(0xd12d7cdba4ba0fd) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__mmask64 r = simde_mm512_cmpgt_epu8_mask(test_vec[i].a, test_vec[i].b);
    munit_assert_uint64(r, ==, test_vec[i].r);
   }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_cmple_epi8_mask(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__mmask64 r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C(  52), INT8_C(   1), INT8_C(  13), INT8_C(  75),
                           INT8_C( -85), INT8_C(  72), INT8_C( -19), INT8_C( -45),
                           INT8_C(  -9), INT8_C(-112), INT8_C( -83), INT8_C( -75),
                           INT8_C( 108), INT8_C( -56), INT8_C(   1), INT8_C(  67),
                           INT8_C(-121), INT8_C( -80), INT8_C( -61), INT8_C( -21),
                           INT8_C(  32), INT8_C(  90), INT8_C(  18), INT8_C( -76),
                           INT8_C( -55), INT8_C(-120), INT8_C(  21), INT8_C(  67),
                           INT8_C( -90), INT8_C(  96), INT8_C(  54), INT8_C( 110),
                           INT8_C(  64), INT8_C(   8), INT8_C( -22), INT8_C(  94),
                           INT8_C(  52), INT8_C( -99), INT8_C(  -4), INT8_C( -84),
                           INT8_C(  -6), INT8_C( 125), INT8_C(  -1), INT8_C( -60),
                           INT8_C(  92), INT8_C(-113), INT8_C( -19), INT8_C(  84),
                           INT8_C( -51), INT8_C(  77), INT8_C(  43), INT8_C( -20),
                           INT8_C( -65), INT8_C( 126), INT8_C(  26), INT8_C( 119),
                           INT8_C( -48), INT8_C( -40), INT8_C(  25), INT8_C(-102),
                           INT8_C( -57), INT8_C( -51), INT8_C(  66), INT8_C(  22)),
      simde_mm512_set_epi8(INT8_C(  86), INT8_C(   9), INT8_C( -71), INT8_C( -90),
                           INT8_C(  18), INT8_C( -62), INT8_C( -33), INT8_C(-112),
                           INT8_C( -98), INT8_C( -84), INT8_C(-115), INT8_C(  15),
                           INT8_C( -33), INT8_C( -76), INT8_C(  61), INT8_C( -95),
                           INT8_C(-105), INT8_C( -60), INT8_C(  -6), INT8_C(-111),
                           INT8_C(  16), INT8_C(-119), INT8_C(  -8), INT8_C( 102),
                           INT8_C(-121), INT8_C(  65), INT8_C(  74), INT8_C( -15),
                           INT8_C( -75), INT8_C( 113), INT8_C(  12), INT8_C(  72),
                           INT8_C(  11), INT8_C( -99), INT8_C(-102), INT8_C(-120),
                           INT8_C(  85), INT8_C( -27), INT8_C(  50), INT8_C(  44),
                           INT8_C(  99), INT8_C(  97), INT8_C( -64), INT8_C(  17),
                           INT8_C( -71), INT8_C( 126), INT8_C( 120), INT8_C(  30),
                           INT8_C(  35), INT8_C( -80), INT8_C( -38), INT8_C( 107),
                           INT8_C(  58), INT8_C(   8), INT8_C( -10), INT8_C(   0),
                           INT8_C(-107), INT8_C( -88), INT8_C(-112), INT8_C(  12),
                           INT8_C(-116), INT8_C( -27), INT8_C( -98), INT8_C(-111)),
      UINT64_C(14434847609910106132) },
    { simde_mm512_set_epi8(INT8_C( 107), INT8_C(-116), INT8_C( 122), INT8_C( 102),
                           INT8_C( -58), INT8_C( 110), INT8_C( -59), INT8_C( -22),
                           INT8_C(  43), INT8_C(  28), INT8_C(  44), INT8_C( -42),
                           INT8_C(-114), INT8_C( -45), INT8_C( -97), INT8_C(  37),
                           INT8_C(-125), INT8_C(  89), INT8_C(-120), INT8_C( -47),
                           INT8_C( -37), INT8_C( -38), INT8_C( 100), INT8_C(  17),
                           INT8_C(  50), INT8_C( -37), INT8_C( -47), INT8_C(  89),
                           INT8_C(  20), INT8_C( -20), INT8_C( -62), INT8_C(-101),
                           INT8_C(  62), INT8_C( 121), INT8_C(-111), INT8_C(  -6),
                           INT8_C(   1), INT8_C(  18), INT8_C(  98), INT8_C(  82),
                           INT8_C( -13), INT8_C(  78), INT8_C(  -4), INT8_C(  14),
                           INT8_C( -66), INT8_C(  64), INT8_C( -67), INT8_C( 109),
                           INT8_C(  39), INT8_C(  91), INT8_C( -87), INT8_C(   9),
                           INT8_C( -93), INT8_C(-109), INT8_C(   6), INT8_C(  98),
                           INT8_C( 120), INT8_C( 124), INT8_C( 122), INT8_C( -19),
                           INT8_C( -77), INT8_C(  57), INT8_C( -96), INT8_C( 126)),
      simde_mm512_set_epi8(INT8_C( -21), INT8_C(-123), INT8_C( -78), INT8_C( -79),
                           INT8_C( -86), INT8_C(  25), INT8_C(-109), INT8_C(  -7),
                           INT8_C(  99), INT8_C( -40), INT8_C(  26), INT8_C(  97),
                           INT8_C(-125), INT8_C( 116), INT8_C( -95), INT8_C(  35),
                           INT8_C(   2), INT8_C(-112), INT8_C(  36), INT8_C( -92),
                           INT8_C(   3), INT8_C(-116), INT8_C( 114), INT8_C(-106),
                           INT8_C(  44), INT8_C(  56), INT8_C(  61), INT8_C( -40),
                           INT8_C(   0), INT8_C( 125), INT8_C(  -9), INT8_C(-122),
                           INT8_C( -60), INT8_C(  40), INT8_C( -45), INT8_C( -33),
                           INT8_C( -44), INT8_C( -46), INT8_C( -92), INT8_C( -73),
                           INT8_C( -80), INT8_C( 116), INT8_C( -97), INT8_C( -44),
                           INT8_C(-128), INT8_C(  96), INT8_C(  31), INT8_C(  65),
                           INT8_C(  78), INT8_C(-127), INT8_C(-104), INT8_C( -24),
                           INT8_C(  50), INT8_C(-106), INT8_C(  74), INT8_C( -36),
                           INT8_C( -78), INT8_C( -25), INT8_C(  74), INT8_C(  73),
                           INT8_C(-109), INT8_C(  66), INT8_C(  65), INT8_C( 122)),
      UINT64_C(114466196149407254) },
    { simde_mm512_set_epi8(INT8_C(-114), INT8_C( -20), INT8_C(  33), INT8_C(  85),
                           INT8_C( 122), INT8_C( -58), INT8_C(-110), INT8_C(  73),
                           INT8_C( -51), INT8_C(  77), INT8_C(  19), INT8_C(  55),
                           INT8_C(  58), INT8_C(-110), INT8_C(  71), INT8_C(-103),
                           INT8_C(   4), INT8_C(-105), INT8_C(  17), INT8_C( -19),
                           INT8_C( -69), INT8_C(  -9), INT8_C(  20), INT8_C( -70),
                           INT8_C( -64), INT8_C(  10), INT8_C(  85), INT8_C( 102),
                           INT8_C( -33), INT8_C(-106), INT8_C(-128), INT8_C(  35),
                           INT8_C( -69), INT8_C( -59), INT8_C( 120), INT8_C(-107),
                           INT8_C( 106), INT8_C( -82), INT8_C( -54), INT8_C(-116),
                           INT8_C(  23), INT8_C(   8), INT8_C(  -4), INT8_C( -91),
                           INT8_C( -73), INT8_C( -40), INT8_C( 102), INT8_C( -54),
                           INT8_C( -23), INT8_C( -80), INT8_C(-110), INT8_C( -39),
                           INT8_C(  63), INT8_C( 120), INT8_C(  11), INT8_C(  -6),
                           INT8_C( 120), INT8_C( -34), INT8_C( -31), INT8_C(-107),
                           INT8_C(  78), INT8_C( 119), INT8_C( -83), INT8_C(  34)),
      simde_mm512_set_epi8(INT8_C( -52), INT8_C( -70), INT8_C(  68), INT8_C( -91),
                           INT8_C(-105), INT8_C(-106), INT8_C( -66), INT8_C( -74),
                           INT8_C(  10), INT8_C(-101), INT8_C( -82), INT8_C(  74),
                           INT8_C(  61), INT8_C(-127), INT8_C(  33), INT8_C( -25),
                           INT8_C( -39), INT8_C(  43), INT8_C(  29), INT8_C(  72),
                           INT8_C( -22), INT8_C(  98), INT8_C( -15), INT8_C(  51),
                           INT8_C(-120), INT8_C( -23), INT8_C(   8), INT8_C(  42),
                           INT8_C(-125), INT8_C(  -3), INT8_C(  56), INT8_C( 103),
                           INT8_C(-111), INT8_C(  -5), INT8_C(  92), INT8_C( -35),
                           INT8_C( 109), INT8_C( -50), INT8_C( -47), INT8_C(-123),
                           INT8_C( 113), INT8_C( -13), INT8_C(  46), INT8_C(  -7),
                           INT8_C(  18), INT8_C(  70), INT8_C(  27), INT8_C( -34),
                           INT8_C( -89), INT8_C(  80), INT8_C(-101), INT8_C( -36),
                           INT8_C(  41), INT8_C( -84), INT8_C( -38), INT8_C( -38),
                           INT8_C(  67), INT8_C( -35), INT8_C(-125), INT8_C( -16),
                           INT8_C( -10), INT8_C(-121), INT8_C( -73), INT8_C(  -7)),
      UINT64_C(11716533376188772370) },
    { simde_mm512_set_epi8(INT8_C( -44), INT8_C(  33), INT8_C(-126), INT8_C( -76),
                           INT8_C(  95), INT8_C(  42), INT8_C( 112), INT8_C(-100),
                           INT8_C(-103), INT8_C( 126), INT8_C(-112), INT8_C( -76),
                           INT8_C(-105), INT8_C( -79), INT8_C( -40), INT8_C( -27),
                           INT8_C( -60), INT8_C( -42), INT8_C(-109), INT8_C( -31),
                           INT8_C( -68), INT8_C( -24), INT8_C( -70), INT8_C(  67),
                           INT8_C( -80), INT8_C(  19), INT8_C( -96), INT8_C(   2),
                           INT8_C( -54), INT8_C(  80), INT8_C(  72), INT8_C( -38),
                           INT8_C(  64), INT8_C( -70), INT8_C( -47), INT8_C( -13),
                           INT8_C(  21), INT8_C(  42), INT8_C(-120), INT8_C( -10),
                           INT8_C(  63), INT8_C( -33), INT8_C( -57), INT8_C( -57),
                           INT8_C( 116), INT8_C(  15), INT8_C( -51), INT8_C(  -6),
                           INT8_C( 122), INT8_C(  99), INT8_C(-128), INT8_C(  -5),
                           INT8_C( -25), INT8_C( 119), INT8_C( -74), INT8_C(  99),
                           INT8_C( -40), INT8_C( -57), INT8_C(  28), INT8_C( -42),
                           INT8_C(-120), INT8_C(  65), INT8_C( -45), INT8_C(-120)),
      simde_mm512_set_epi8(INT8_C(  -9), INT8_C(  84), INT8_C(  59), INT8_C(  71),
                           INT8_C(  13), INT8_C(  39), INT8_C( -79), INT8_C( -26),
                           INT8_C(  82), INT8_C( -47), INT8_C( -45), INT8_C(  29),
                           INT8_C( -91), INT8_C( -34), INT8_C(  79), INT8_C(-114),
                           INT8_C( -91), INT8_C(  13), INT8_C(  12), INT8_C( -60),
                           INT8_C( -44), INT8_C(-121), INT8_C(  70), INT8_C(  85),
                           INT8_C( -49), INT8_C(   2), INT8_C(  65), INT8_C(  20),
                           INT8_C(  84), INT8_C(  52), INT8_C( -41), INT8_C(  31),
                           INT8_C(  85), INT8_C(   5), INT8_C(-119), INT8_C( -80),
                           INT8_C(  55), INT8_C( 106), INT8_C( 104), INT8_C(-127),
                           INT8_C(  66), INT8_C(   9), INT8_C( -87), INT8_C(   1),
                           INT8_C(  62), INT8_C( -13), INT8_C( -95), INT8_C( 107),
                           INT8_C( -18), INT8_C(   9), INT8_C( -38), INT8_C( 114),
                           INT8_C(  -6), INT8_C(  83), INT8_C( -70), INT8_C( -62),
                           INT8_C( -54), INT8_C(  89), INT8_C( -72), INT8_C( -70),
                           INT8_C( -80), INT8_C( -23), INT8_C( -13), INT8_C( 125)),
      UINT64_C(17419478854498597451) },
    { simde_mm512_set_epi8(INT8_C(-122), INT8_C(  98), INT8_C( -61), INT8_C( -27),
                           INT8_C( -69), INT8_C( -73), INT8_C(  19), INT8_C( -42),
                           INT8_C( -94), INT8_C( -91), INT8_C(  70), INT8_C(  49),
                           INT8_C( -51), INT8_C( -48), INT8_C( -34), INT8_C( -19),
                           INT8_C(-122), INT8_C(  35), INT8_C( 100), INT8_C( -94),
                           INT8_C( -69), INT8_C(  64), INT8_C(  56), INT8_C( -16),
                           INT8_C(  95), INT8_C( -67), INT8_C( 120), INT8_C( -89),
                           INT8_C(  79), INT8_C(  34), INT8_C(-114), INT8_C( -60),
                           INT8_C(  60), INT8_C( -94), INT8_C( -73), INT8_C(-127),
                           INT8_C(  53), INT8_C( -21), INT8_C( -21), INT8_C(  93),
                           INT8_C( -84), INT8_C(  -3), INT8_C( -33), INT8_C(-100),
                           INT8_C( -51), INT8_C(  64), INT8_C( 122), INT8_C(  20),
                           INT8_C(  71), INT8_C(  31), INT8_C( 119), INT8_C( -31),
                           INT8_C( -54), INT8_C(-117), INT8_C(  16), INT8_C( -86),
                           INT8_C(  -2), INT8_C( -44), INT8_C(  18), INT8_C(  10),
                           INT8_C(  87), INT8_C( 126), INT8_C( 125), INT8_C(-118)),
      simde_mm512_set_epi8(INT8_C(  73), INT8_C( -43), INT8_C( -22), INT8_C(  17),
                           INT8_C(  58), INT8_C(-109), INT8_C( -46), INT8_C( -57),
                           INT8_C(  64), INT8_C( 101), INT8_C( 126), INT8_C( -55),
                           INT8_C(-126), INT8_C( 125), INT8_C(  63), INT8_C(  11),
                           INT8_C(  35), INT8_C(  47), INT8_C( -77), INT8_C( -22),
                           INT8_C( -98), INT8_C( -82), INT8_C( -84), INT8_C(-104),
                           INT8_C(  55), INT8_C( -26), INT8_C( -90), INT8_C( -11),
                           INT8_C(  51), INT8_C( 115), INT8_C(  98), INT8_C( -34),
                           INT8_C( -10), INT8_C(  39), INT8_C( 107), INT8_C(  53),
                           INT8_C( -20), INT8_C( 127), INT8_C(  -9), INT8_C(   9),
                           INT8_C(-101), INT8_C( -21), INT8_C( -30), INT8_C( -70),
                           INT8_C(-128), INT8_C(-115), INT8_C(-123), INT8_C( -73),
                           INT8_C( -77), INT8_C(  54), INT8_C( 113), INT8_C(  34),
                           INT8_C(  55), INT8_C( -74), INT8_C( -52), INT8_C(  17),
                           INT8_C(   5), INT8_C(-118), INT8_C( -68), INT8_C( 115),
                           INT8_C( 127), INT8_C(  35), INT8_C(  86), INT8_C(  24)),
      UINT64_C(13323847096662515097) },
    { simde_mm512_set_epi8(INT8_C(  37), INT8_C( -12), INT8_C( -32), INT8_C( 126),
                           INT8_C( -35), INT8_C(-101), INT8_C(  64), INT8_C( -71),
                           INT8_C( 102), INT8_C(  71), INT8_C( -15), INT8_C( -36),
                           INT8_C( -31), INT8_C( -15), INT8_C(   2), INT8_C( -32),
                           INT8_C(   7), INT8_C( -43), INT8_C( 119), INT8_C( -54),
                           INT8_C( -96), INT8_C(  -6), INT8_C(  62), INT8_C( 104),
                           INT8_C(  35), INT8_C(  37), INT8_C( 120), INT8_C(  -4),
                           INT8_C(  62), INT8_C(  54), INT8_C( -97), INT8_C(-103),
                           INT8_C(-115), INT8_C( -68), INT8_C( -94), INT8_C( -96),
                           INT8_C( -71), INT8_C( 108), INT8_C( 112), INT8_C(  21),
                           INT8_C( -60), INT8_C(-107), INT8_C(  13), INT8_C(  23),
                           INT8_C(  28), INT8_C(  94), INT8_C(-121), INT8_C(-105),
                           INT8_C( 117), INT8_C(  92), INT8_C(  -5), INT8_C( 102),
                           INT8_C( 113), INT8_C( -68), INT8_C( -73), INT8_C( -98),
                           INT8_C(-116), INT8_C(-108), INT8_C( 104), INT8_C( -94),
                           INT8_C( 123), INT8_C( -15), INT8_C( 105), INT8_C(  49)),
      simde_mm512_set_epi8(INT8_C(   5), INT8_C(  84), INT8_C(  11), INT8_C( -98),
                           INT8_C( -61), INT8_C( -19), INT8_C(  52), INT8_C(  -5),
                           INT8_C( -79), INT8_C(  45), INT8_C( -79), INT8_C( -17),
                           INT8_C( -45), INT8_C(  68), INT8_C(  30), INT8_C( -51),
                           INT8_C(-115), INT8_C(-100), INT8_C( -59), INT8_C( -64),
                           INT8_C(  94), INT8_C( -29), INT8_C( -94), INT8_C(  91),
                           INT8_C(-128), INT8_C( -59), INT8_C( -67), INT8_C( -23),
                           INT8_C(  61), INT8_C(-122), INT8_C(-120), INT8_C(-108),
                           INT8_C( -31), INT8_C( -12), INT8_C( -69), INT8_C(  83),
                           INT8_C( -41), INT8_C(-119), INT8_C(-114), INT8_C(  34),
                           INT8_C(  83), INT8_C( 109), INT8_C(-105), INT8_C( -73),
                           INT8_C(  94), INT8_C( -53), INT8_C(  17), INT8_C( 104),
                           INT8_C( -66), INT8_C(  76), INT8_C(-125), INT8_C( -11),
                           INT8_C(  91), INT8_C( -85), INT8_C( -13), INT8_C( -16),
                           INT8_C( -56), INT8_C(  83), INT8_C(  72), INT8_C(  80),
                           INT8_C(  38), INT8_C( -24), INT8_C(  28), INT8_C( 126)),
      UINT64_C(7284018247602209745) },
    { simde_mm512_set_epi8(INT8_C( -73), INT8_C(-128), INT8_C(  96), INT8_C( -55),
                           INT8_C( -66), INT8_C(  -7), INT8_C( -10), INT8_C(-120),
                           INT8_C( 107), INT8_C( -20), INT8_C( -32), INT8_C(   4),
                           INT8_C(-122), INT8_C(-121), INT8_C(  77), INT8_C(  72),
                           INT8_C(  24), INT8_C( -59), INT8_C(   5), INT8_C( -25),
                           INT8_C( -39), INT8_C( 100), INT8_C( -14), INT8_C(  62),
                           INT8_C( -76), INT8_C( -56), INT8_C( -35), INT8_C(  47),
                           INT8_C(  88), INT8_C(  70), INT8_C(  51), INT8_C(  15),
                           INT8_C(  65), INT8_C(  78), INT8_C( -75), INT8_C(  26),
                           INT8_C( -34), INT8_C( -87), INT8_C( -19), INT8_C( -93),
                           INT8_C(  -9), INT8_C( -97), INT8_C( 126), INT8_C( -61),
                           INT8_C( 126), INT8_C( 124), INT8_C( 103), INT8_C(-124),
                           INT8_C(  74), INT8_C( -95), INT8_C(  17), INT8_C( -78),
                           INT8_C(-110), INT8_C( -79), INT8_C(  39), INT8_C(  55),
                           INT8_C(  21), INT8_C(  70), INT8_C( -36), INT8_C( -25),
                           INT8_C(  -3), INT8_C( -83), INT8_C( -67), INT8_C(  -7)),
      simde_mm512_set_epi8(INT8_C( -94), INT8_C(   1), INT8_C(  32), INT8_C(   2),
                           INT8_C(-119), INT8_C(  91), INT8_C(-121), INT8_C(  50),
                           INT8_C( -99), INT8_C(   3), INT8_C(  73), INT8_C(  40),
                           INT8_C(-124), INT8_C( -23), INT8_C(  95), INT8_C( 102),
                           INT8_C(  41), INT8_C(  56), INT8_C(  70), INT8_C( 126),
                           INT8_C(  48), INT8_C( -42), INT8_C(  60), INT8_C(  88),
                           INT8_C(  38), INT8_C(  76), INT8_C(  -4), INT8_C(-121),
                           INT8_C( -33), INT8_C( 119), INT8_C(-103), INT8_C(   4),
                           INT8_C( 100), INT8_C(  93), INT8_C(  25), INT8_C(-105),
                           INT8_C(-113), INT8_C(  48), INT8_C( 102), INT8_C( -75),
                           INT8_C(  35), INT8_C(  24), INT8_C(  12), INT8_C(  10),
                           INT8_C(  -8), INT8_C(  18), INT8_C( -50), INT8_C(  14),
                           INT8_C( -72), INT8_C(  90), INT8_C( -35), INT8_C( 103),
                           INT8_C( -97), INT8_C( -75), INT8_C(  46), INT8_C( -43),
                           INT8_C( 101), INT8_C( -57), INT8_C(  37), INT8_C(  23),
                           INT8_C(-127), INT8_C(  86), INT8_C( -24), INT8_C( 104)),
      UINT64_C(6158667976012816055) },
    { simde_mm512_set_epi8(INT8_C(-100), INT8_C( -98), INT8_C( -42), INT8_C(  95),
                           INT8_C(  40), INT8_C(   8), INT8_C( 114), INT8_C(  23),
                           INT8_C( -26), INT8_C(-115), INT8_C(  79), INT8_C(  45),
                           INT8_C(  90), INT8_C( 114), INT8_C(   2), INT8_C( 107),
                           INT8_C( -80), INT8_C(  -3), INT8_C( -37), INT8_C( -87),
                           INT8_C( -51), INT8_C( -33), INT8_C( -48), INT8_C( -87),
                           INT8_C( -24), INT8_C( -52), INT8_C( 116), INT8_C( 127),
                           INT8_C(   3), INT8_C( 109), INT8_C(-127), INT8_C( -79),
                           INT8_C( -48), INT8_C(-121), INT8_C(  27), INT8_C(  17),
                           INT8_C(  52), INT8_C(-113), INT8_C( -21), INT8_C(  13),
                           INT8_C(-121), INT8_C( -96), INT8_C(  10), INT8_C(-116),
                           INT8_C(  62), INT8_C(  99), INT8_C(  21), INT8_C(  68),
                           INT8_C( -43), INT8_C( 107), INT8_C(  47), INT8_C( -18),
                           INT8_C( -46), INT8_C(-117), INT8_C(  83), INT8_C( -33),
                           INT8_C(  50), INT8_C(  26), INT8_C(   5), INT8_C(-102),
                           INT8_C( -62), INT8_C(-117), INT8_C(  11), INT8_C( -89)),
      simde_mm512_set_epi8(INT8_C(  -7), INT8_C(-107), INT8_C(-110), INT8_C(   3),
                           INT8_C( 123), INT8_C(  42), INT8_C(  35), INT8_C(-112),
                           INT8_C( -33), INT8_C( -27), INT8_C( -71), INT8_C(  60),
                           INT8_C(  28), INT8_C(-128), INT8_C( -61), INT8_C( -94),
                           INT8_C( -53), INT8_C(-120), INT8_C( -58), INT8_C(  86),
                           INT8_C(  54), INT8_C( -41), INT8_C( -24), INT8_C( -24),
                           INT8_C( -79), INT8_C(  97), INT8_C(  11), INT8_C(-106),
                           INT8_C(  -2), INT8_C( -80), INT8_C(  54), INT8_C(   5),
                           INT8_C(  37), INT8_C(  35), INT8_C( -99), INT8_C(-117),
                           INT8_C( -23), INT8_C(  93), INT8_C(  84), INT8_C(  64),
                           INT8_C(-111), INT8_C( -21), INT8_C( -43), INT8_C(  49),
                           INT8_C(   7), INT8_C( -32), INT8_C(  68), INT8_C( -29),
                           INT8_C( 119), INT8_C(  93), INT8_C( -20), INT8_C( -53),
                           INT8_C(  28), INT8_C( -11), INT8_C(  -1), INT8_C(  93),
                           INT8_C( -68), INT8_C( 100), INT8_C(  31), INT8_C(  98),
                           INT8_C(  78), INT8_C(  52), INT8_C(  -6), INT8_C(  -1)),
      UINT64_C(10110751878864342397) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__mmask64 r = simde_mm512_cmple_epi8_mask(test_vec[i].a, test_vec[i].b);
    munit_assert_uint64(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_cmple_epu8_mask(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__mmask64 r;
  } test_vec[8] = {
    { simde_x_mm512_set_epu8(UINT8_C(212), UINT8_C( 13), UINT8_C( 31), UINT8_C(214),
                             UINT8_C(180), UINT8_C(244), UINT8_C( 71), UINT8_C( 63),
                             UINT8_C(225), UINT8_C(144), UINT8_C( 44), UINT8_C(106),
                             UINT8_C(204), UINT8_C( 63), UINT8_C(146), UINT8_C(179),
                             UINT8_C( 32), UINT8_C(164), UINT8_C(133), UINT8_C( 40),
                             UINT8_C(191), UINT8_C(127), UINT8_C(223), UINT8_C( 71),
                             UINT8_C(188), UINT8_C( 44), UINT8_C(171), UINT8_C( 22),
                             UINT8_C( 89), UINT8_C(241), UINT8_C( 98), UINT8_C(161),
                             UINT8_C(  5), UINT8_C(111), UINT8_C(103), UINT8_C(163),
                             UINT8_C(148), UINT8_C(182), UINT8_C( 53), UINT8_C(167),
                             UINT8_C(123), UINT8_C( 87), UINT8_C(248), UINT8_C( 30),
                             UINT8_C( 59), UINT8_C( 34), UINT8_C(228), UINT8_C(123),
                             UINT8_C( 19), UINT8_C(  1), UINT8_C(177), UINT8_C(191),
                             UINT8_C(228), UINT8_C(252), UINT8_C( 82), UINT8_C( 41),
                             UINT8_C(190), UINT8_C( 81), UINT8_C(126), UINT8_C(186),
                             UINT8_C(232), UINT8_C(220), UINT8_C(248), UINT8_C(  9)),
      simde_x_mm512_set_epu8(UINT8_C(156), UINT8_C(167), UINT8_C(182), UINT8_C(174),
                             UINT8_C( 59), UINT8_C( 33), UINT8_C(108), UINT8_C( 56),
                             UINT8_C(235), UINT8_C(112), UINT8_C( 57), UINT8_C(123),
                             UINT8_C(204), UINT8_C(222), UINT8_C(254), UINT8_C(219),
                             UINT8_C( 79), UINT8_C(226), UINT8_C(235), UINT8_C(225),
                             UINT8_C(225), UINT8_C(214), UINT8_C( 93), UINT8_C(110),
                             UINT8_C(130), UINT8_C(140), UINT8_C(  9), UINT8_C(197),
                             UINT8_C(196), UINT8_C(218), UINT8_C( 26), UINT8_C(172),
                             UINT8_C( 79), UINT8_C(211), UINT8_C(167), UINT8_C(175),
                             UINT8_C(117), UINT8_C(109), UINT8_C(123), UINT8_C( 61),
                             UINT8_C(201), UINT8_C(219), UINT8_C( 65), UINT8_C(225),
                             UINT8_C(169), UINT8_C(245), UINT8_C(163), UINT8_C(246),
                             UINT8_C( 72), UINT8_C(  0), UINT8_C(139), UINT8_C( 27),
                             UINT8_C(202), UINT8_C(250), UINT8_C(  9), UINT8_C( 85),
                             UINT8_C(  2), UINT8_C(226), UINT8_C( 89), UINT8_C( 13),
                             UINT8_C(200), UINT8_C(251), UINT8_C( 41), UINT8_C(231)),
      UINT64_C(7115684499037192517) },
    { simde_x_mm512_set_epu8(UINT8_C( 29), UINT8_C(222), UINT8_C(229), UINT8_C(138),
                             UINT8_C(180), UINT8_C(164), UINT8_C( 76), UINT8_C(245),
                             UINT8_C( 99), UINT8_C(226), UINT8_C(230), UINT8_C( 98),
                             UINT8_C(233), UINT8_C( 51), UINT8_C(144), UINT8_C(148),
                             UINT8_C( 54), UINT8_C( 78), UINT8_C(119), UINT8_C( 10),
                             UINT8_C(178), UINT8_C(149), UINT8_C(114), UINT8_C( 10),
                             UINT8_C(114), UINT8_C(229), UINT8_C(111), UINT8_C(217),
                             UINT8_C(221), UINT8_C(177), UINT8_C(132), UINT8_C(239),
                             UINT8_C( 37), UINT8_C( 97), UINT8_C( 39), UINT8_C(159),
                             UINT8_C(180), UINT8_C(171), UINT8_C(207), UINT8_C( 97),
                             UINT8_C( 34), UINT8_C( 28), UINT8_C(196), UINT8_C( 31),
                             UINT8_C(161), UINT8_C(176), UINT8_C(212), UINT8_C(150),
                             UINT8_C(127), UINT8_C( 96), UINT8_C(  8), UINT8_C(231),
                             UINT8_C(113), UINT8_C(244), UINT8_C(225), UINT8_C( 59),
                             UINT8_C(  8), UINT8_C(189), UINT8_C(180), UINT8_C(181),
                             UINT8_C( 17), UINT8_C(247), UINT8_C(253), UINT8_C(193)),
      simde_x_mm512_set_epu8(UINT8_C(139), UINT8_C(135), UINT8_C(125), UINT8_C(234),
                             UINT8_C(170), UINT8_C(118), UINT8_C(218), UINT8_C(127),
                             UINT8_C(224), UINT8_C( 87), UINT8_C(101), UINT8_C( 79),
                             UINT8_C(160), UINT8_C( 79), UINT8_C(171), UINT8_C(143),
                             UINT8_C(221), UINT8_C( 27), UINT8_C( 16), UINT8_C(105),
                             UINT8_C(233), UINT8_C(128), UINT8_C( 36), UINT8_C( 18),
                             UINT8_C( 43), UINT8_C(252), UINT8_C(123), UINT8_C(101),
                             UINT8_C( 69), UINT8_C( 20), UINT8_C(168), UINT8_C(248),
                             UINT8_C( 42), UINT8_C(112), UINT8_C( 32), UINT8_C(253),
                             UINT8_C( 41), UINT8_C( 94), UINT8_C(127), UINT8_C(246),
                             UINT8_C(224), UINT8_C( 59), UINT8_C(224), UINT8_C(111),
                             UINT8_C(208), UINT8_C( 14), UINT8_C(109), UINT8_C(170),
                             UINT8_C(202), UINT8_C(101), UINT8_C(232), UINT8_C( 20),
                             UINT8_C( 79), UINT8_C( 96), UINT8_C(249), UINT8_C(176),
                             UINT8_C(110), UINT8_C(169), UINT8_C( 85), UINT8_C( 81),
                             UINT8_C( 78), UINT8_C(  8), UINT8_C(191), UINT8_C( 88)),
      UINT64_C(10558295030420333448) },
    { simde_x_mm512_set_epu8(UINT8_C(179), UINT8_C(213), UINT8_C( 48), UINT8_C(187),
                             UINT8_C(164), UINT8_C(  7), UINT8_C( 91), UINT8_C(  4),
                             UINT8_C(102), UINT8_C(109), UINT8_C(177), UINT8_C(255),
                             UINT8_C(192), UINT8_C(222), UINT8_C(234), UINT8_C(134),
                             UINT8_C(145), UINT8_C(124), UINT8_C(251), UINT8_C(236),
                             UINT8_C(216), UINT8_C(105), UINT8_C(153), UINT8_C( 89),
                             UINT8_C( 43), UINT8_C( 64), UINT8_C(112), UINT8_C(212),
                             UINT8_C(140), UINT8_C( 39), UINT8_C( 85), UINT8_C(189),
                             UINT8_C(227), UINT8_C(172), UINT8_C(113), UINT8_C(242),
                             UINT8_C( 62), UINT8_C(140), UINT8_C(107), UINT8_C(240),
                             UINT8_C(230), UINT8_C(141), UINT8_C(154), UINT8_C(244),
                             UINT8_C(228), UINT8_C(222), UINT8_C(241), UINT8_C( 55),
                             UINT8_C( 62), UINT8_C(128), UINT8_C( 59), UINT8_C( 35),
                             UINT8_C(194), UINT8_C(240), UINT8_C(211), UINT8_C(214),
                             UINT8_C( 18), UINT8_C(149), UINT8_C(249), UINT8_C(119),
                             UINT8_C( 83), UINT8_C(223), UINT8_C(207), UINT8_C(164)),
      simde_x_mm512_set_epu8(UINT8_C( 54), UINT8_C(  3), UINT8_C(127), UINT8_C(243),
                             UINT8_C(233), UINT8_C( 35), UINT8_C(224), UINT8_C( 24),
                             UINT8_C(138), UINT8_C(223), UINT8_C(122), UINT8_C(117),
                             UINT8_C(242), UINT8_C(132), UINT8_C(185), UINT8_C( 60),
                             UINT8_C(130), UINT8_C( 34), UINT8_C(198), UINT8_C( 87),
                             UINT8_C(166), UINT8_C( 62), UINT8_C(236), UINT8_C(111),
                             UINT8_C(236), UINT8_C(148), UINT8_C( 23), UINT8_C(102),
                             UINT8_C(203), UINT8_C( 39), UINT8_C( 44), UINT8_C(229),
                             UINT8_C(165), UINT8_C( 64), UINT8_C(247), UINT8_C(232),
                             UINT8_C(252), UINT8_C( 14), UINT8_C(190), UINT8_C(210),
                             UINT8_C(114), UINT8_C( 77), UINT8_C(213), UINT8_C( 48),
                             UINT8_C(150), UINT8_C(192), UINT8_C(  7), UINT8_C( 60),
                             UINT8_C(243), UINT8_C(183), UINT8_C( 19), UINT8_C( 12),
                             UINT8_C( 82), UINT8_C(159), UINT8_C(244), UINT8_C( 58),
                             UINT8_C(100), UINT8_C(194), UINT8_C(140), UINT8_C(234),
                             UINT8_C( 26), UINT8_C( 79), UINT8_C(203), UINT8_C( 24)),
      UINT64_C(4595927599441625808) },
    { simde_x_mm512_set_epu8(UINT8_C( 20), UINT8_C(104), UINT8_C(252), UINT8_C( 18),
                             UINT8_C( 49), UINT8_C(100), UINT8_C(232), UINT8_C(164),
                             UINT8_C(213), UINT8_C(  4), UINT8_C(177), UINT8_C(161),
                             UINT8_C(177), UINT8_C(  3), UINT8_C(134), UINT8_C(175),
                             UINT8_C( 44), UINT8_C(123), UINT8_C(208), UINT8_C( 13),
                             UINT8_C(112), UINT8_C(152), UINT8_C(166), UINT8_C( 36),
                             UINT8_C(194), UINT8_C( 54), UINT8_C(139), UINT8_C(252),
                             UINT8_C(211), UINT8_C( 63), UINT8_C(  1), UINT8_C(193),
                             UINT8_C(192), UINT8_C( 71), UINT8_C( 33), UINT8_C(244),
                             UINT8_C(217), UINT8_C(149), UINT8_C(174), UINT8_C(175),
                             UINT8_C(183), UINT8_C( 89), UINT8_C(  4), UINT8_C(212),
                             UINT8_C(123), UINT8_C( 28), UINT8_C(107), UINT8_C( 62),
                             UINT8_C(181), UINT8_C(  4), UINT8_C(156), UINT8_C( 13),
                             UINT8_C( 99), UINT8_C(210), UINT8_C( 57), UINT8_C( 39),
                             UINT8_C( 59), UINT8_C( 79), UINT8_C( 89), UINT8_C(123),
                             UINT8_C( 82), UINT8_C(235), UINT8_C(217), UINT8_C(152)),
      simde_x_mm512_set_epu8(UINT8_C(150), UINT8_C(194), UINT8_C(117), UINT8_C( 49),
                             UINT8_C(221), UINT8_C(199), UINT8_C(212), UINT8_C(148),
                             UINT8_C( 85), UINT8_C( 59), UINT8_C(185), UINT8_C( 89),
                             UINT8_C(176), UINT8_C(174), UINT8_C(127), UINT8_C(134),
                             UINT8_C(249), UINT8_C(178), UINT8_C(114), UINT8_C(195),
                             UINT8_C(248), UINT8_C(153), UINT8_C( 86), UINT8_C(137),
                             UINT8_C( 78), UINT8_C(198), UINT8_C(186), UINT8_C(113),
                             UINT8_C(114), UINT8_C(213), UINT8_C(233), UINT8_C(100),
                             UINT8_C(115), UINT8_C( 27), UINT8_C(  6), UINT8_C(115),
                             UINT8_C( 71), UINT8_C(139), UINT8_C(249), UINT8_C(103),
                             UINT8_C(106), UINT8_C(242), UINT8_C( 15), UINT8_C(207),
                             UINT8_C( 82), UINT8_C(215), UINT8_C(153), UINT8_C(201),
                             UINT8_C(103), UINT8_C(101), UINT8_C(182), UINT8_C(195),
                             UINT8_C(233), UINT8_C( 35), UINT8_C(201), UINT8_C(188),
                             UINT8_C(248), UINT8_C(236), UINT8_C( 57), UINT8_C(212),
                             UINT8_C( 14), UINT8_C(200), UINT8_C( 28), UINT8_C(223)),
      UINT64_C(15881061616211950545) },
    { simde_x_mm512_set_epu8(UINT8_C( 75), UINT8_C(247), UINT8_C(  8), UINT8_C(191),
                             UINT8_C(201), UINT8_C(123), UINT8_C( 94), UINT8_C(179),
                             UINT8_C(244), UINT8_C(101), UINT8_C( 84), UINT8_C(235),
                             UINT8_C( 73), UINT8_C(217), UINT8_C(236), UINT8_C( 67),
                             UINT8_C(172), UINT8_C(176), UINT8_C( 63), UINT8_C( 10),
                             UINT8_C(  5), UINT8_C(236), UINT8_C(174), UINT8_C(220),
                             UINT8_C(206), UINT8_C(250), UINT8_C(153), UINT8_C(199),
                             UINT8_C(238), UINT8_C(212), UINT8_C(149), UINT8_C(133),
                             UINT8_C( 38), UINT8_C( 78), UINT8_C(150), UINT8_C(121),
                             UINT8_C(152), UINT8_C(118), UINT8_C(104), UINT8_C(114),
                             UINT8_C( 96), UINT8_C(108), UINT8_C( 94), UINT8_C(164),
                             UINT8_C(231), UINT8_C( 95), UINT8_C( 67), UINT8_C(157),
                             UINT8_C(160), UINT8_C( 73), UINT8_C(157), UINT8_C(140),
                             UINT8_C(130), UINT8_C(247), UINT8_C(150), UINT8_C(152),
                             UINT8_C(157), UINT8_C(232), UINT8_C( 29), UINT8_C(121),
                             UINT8_C(206), UINT8_C(156), UINT8_C(126), UINT8_C( 23)),
      simde_x_mm512_set_epu8(UINT8_C(100), UINT8_C( 83), UINT8_C( 54), UINT8_C( 71),
                             UINT8_C( 37), UINT8_C(  5), UINT8_C(116), UINT8_C( 23),
                             UINT8_C(202), UINT8_C( 63), UINT8_C( 69), UINT8_C(165),
                             UINT8_C( 74), UINT8_C(243), UINT8_C(197), UINT8_C(135),
                             UINT8_C( 54), UINT8_C(163), UINT8_C(231), UINT8_C(198),
                             UINT8_C(236), UINT8_C( 28), UINT8_C(182), UINT8_C(250),
                             UINT8_C(142), UINT8_C(142), UINT8_C(129), UINT8_C(112),
                             UINT8_C( 35), UINT8_C(210), UINT8_C(144), UINT8_C(254),
                             UINT8_C(152), UINT8_C(159), UINT8_C( 93), UINT8_C( 83),
                             UINT8_C(237), UINT8_C(179), UINT8_C(152), UINT8_C( 79),
                             UINT8_C(232), UINT8_C(160), UINT8_C(116), UINT8_C(255),
                             UINT8_C(123), UINT8_C(122), UINT8_C(140), UINT8_C(155),
                             UINT8_C(208), UINT8_C(117), UINT8_C(159), UINT8_C(124),
                             UINT8_C( 66), UINT8_C(106), UINT8_C( 14), UINT8_C(238),
                             UINT8_C( 20), UINT8_C(155), UINT8_C(176), UINT8_C( 29),
                             UINT8_C(190), UINT8_C(210), UINT8_C(118), UINT8_C(126)),
      UINT64_C(11677054287794856229) },
    { simde_x_mm512_set_epu8(UINT8_C(207), UINT8_C( 64), UINT8_C(105), UINT8_C(187),
                             UINT8_C(171), UINT8_C( 70), UINT8_C(149), UINT8_C(106),
                             UINT8_C(166), UINT8_C(121), UINT8_C(188), UINT8_C(223),
                             UINT8_C(179), UINT8_C(107), UINT8_C(221), UINT8_C(150),
                             UINT8_C(139), UINT8_C( 19), UINT8_C(235), UINT8_C( 53),
                             UINT8_C(220), UINT8_C( 58), UINT8_C(119), UINT8_C(117),
                             UINT8_C(168), UINT8_C( 70), UINT8_C(147), UINT8_C(215),
                             UINT8_C(204), UINT8_C(240), UINT8_C( 35), UINT8_C(179),
                             UINT8_C(220), UINT8_C(143), UINT8_C(187), UINT8_C( 63),
                             UINT8_C(203), UINT8_C(224), UINT8_C(132), UINT8_C( 76),
                             UINT8_C( 40), UINT8_C( 69), UINT8_C(  2), UINT8_C( 69),
                             UINT8_C( 77), UINT8_C( 42), UINT8_C( 24), UINT8_C(201),
                             UINT8_C( 19), UINT8_C(253), UINT8_C(249), UINT8_C(203),
                             UINT8_C( 23), UINT8_C(169), UINT8_C(207), UINT8_C(  8),
                             UINT8_C(208), UINT8_C(154), UINT8_C( 75), UINT8_C(165),
                             UINT8_C(  0), UINT8_C(121), UINT8_C( 35), UINT8_C( 83)),
      simde_x_mm512_set_epu8(UINT8_C(148), UINT8_C( 45), UINT8_C( 60), UINT8_C(121),
                             UINT8_C(136), UINT8_C(104), UINT8_C( 13), UINT8_C(217),
                             UINT8_C( 88), UINT8_C(183), UINT8_C(187), UINT8_C(143),
                             UINT8_C(198), UINT8_C(210), UINT8_C(145), UINT8_C(248),
                             UINT8_C( 52), UINT8_C( 10), UINT8_C(182), UINT8_C( 49),
                             UINT8_C( 78), UINT8_C( 50), UINT8_C( 27), UINT8_C( 82),
                             UINT8_C( 46), UINT8_C(154), UINT8_C( 72), UINT8_C(  7),
                             UINT8_C( 99), UINT8_C( 90), UINT8_C(196), UINT8_C(238),
                             UINT8_C(215), UINT8_C(157), UINT8_C(102), UINT8_C( 95),
                             UINT8_C(144), UINT8_C( 12), UINT8_C( 52), UINT8_C( 36),
                             UINT8_C( 87), UINT8_C( 93), UINT8_C( 55), UINT8_C( 68),
                             UINT8_C(113), UINT8_C( 27), UINT8_C(111), UINT8_C(201),
                             UINT8_C(130), UINT8_C( 33), UINT8_C(210), UINT8_C( 36),
                             UINT8_C( 59), UINT8_C(255), UINT8_C( 46), UINT8_C( 49),
                             UINT8_C( 22), UINT8_C(148), UINT8_C(144), UINT8_C(146),
                             UINT8_C(245), UINT8_C( 41), UINT8_C(198), UINT8_C(231)),
      UINT64_C(381961832516783403) },
    { simde_x_mm512_set_epu8(UINT8_C(235), UINT8_C( 63), UINT8_C(229), UINT8_C(216),
                             UINT8_C( 37), UINT8_C(222), UINT8_C( 30), UINT8_C( 44),
                             UINT8_C(158), UINT8_C(214), UINT8_C(245), UINT8_C( 16),
                             UINT8_C( 13), UINT8_C( 12), UINT8_C(141), UINT8_C(114),
                             UINT8_C(211), UINT8_C( 56), UINT8_C(106), UINT8_C( 90),
                             UINT8_C( 25), UINT8_C( 48), UINT8_C(151), UINT8_C(  2),
                             UINT8_C(239), UINT8_C(116), UINT8_C( 99), UINT8_C( 74),
                             UINT8_C(147), UINT8_C( 81), UINT8_C(180), UINT8_C(169),
                             UINT8_C(183), UINT8_C(247), UINT8_C(193), UINT8_C( 12),
                             UINT8_C(147), UINT8_C(164), UINT8_C(194), UINT8_C(196),
                             UINT8_C( 62), UINT8_C(138), UINT8_C(220), UINT8_C(182),
                             UINT8_C(122), UINT8_C(  2), UINT8_C(203), UINT8_C( 14),
                             UINT8_C( 82), UINT8_C(208), UINT8_C(210), UINT8_C( 59),
                             UINT8_C( 36), UINT8_C(151), UINT8_C( 18), UINT8_C( 92),
                             UINT8_C(134), UINT8_C(208), UINT8_C( 95), UINT8_C( 59),
                             UINT8_C(250), UINT8_C(  9), UINT8_C(199), UINT8_C(157)),
      simde_x_mm512_set_epu8(UINT8_C(138), UINT8_C(192), UINT8_C( 19), UINT8_C( 45),
                             UINT8_C(  2), UINT8_C( 30), UINT8_C(159), UINT8_C(195),
                             UINT8_C( 92), UINT8_C(244), UINT8_C(218), UINT8_C(152),
                             UINT8_C(238), UINT8_C(209), UINT8_C( 95), UINT8_C( 38),
                             UINT8_C( 76), UINT8_C( 25), UINT8_C(198), UINT8_C( 22),
                             UINT8_C(237), UINT8_C( 18), UINT8_C(148), UINT8_C(223),
                             UINT8_C( 99), UINT8_C(223), UINT8_C(112), UINT8_C(190),
                             UINT8_C( 45), UINT8_C( 13), UINT8_C( 32), UINT8_C(140),
                             UINT8_C(249), UINT8_C(183), UINT8_C(177), UINT8_C( 27),
                             UINT8_C( 27), UINT8_C(174), UINT8_C(110), UINT8_C( 62),
                             UINT8_C(140), UINT8_C(195), UINT8_C(157), UINT8_C(183),
                             UINT8_C( 81), UINT8_C( 92), UINT8_C( 28), UINT8_C( 99),
                             UINT8_C(115), UINT8_C( 41), UINT8_C(207), UINT8_C(220),
                             UINT8_C(170), UINT8_C( 70), UINT8_C(196), UINT8_C( 53),
                             UINT8_C( 45), UINT8_C(254), UINT8_C(177), UINT8_C(198),
                             UINT8_C( 26), UINT8_C(251), UINT8_C(201), UINT8_C(125)),
      UINT64_C(4853800061908654710) },
    { simde_x_mm512_set_epu8(UINT8_C( 39), UINT8_C(111), UINT8_C( 79), UINT8_C( 64),
                             UINT8_C(165), UINT8_C( 55), UINT8_C( 15), UINT8_C(251),
                             UINT8_C(155), UINT8_C(226), UINT8_C(102), UINT8_C( 27),
                             UINT8_C(173), UINT8_C(169), UINT8_C(205), UINT8_C( 72),
                             UINT8_C(187), UINT8_C(157), UINT8_C(143), UINT8_C( 48),
                             UINT8_C(145), UINT8_C(133), UINT8_C(221), UINT8_C(157),
                             UINT8_C(112), UINT8_C(228), UINT8_C(192), UINT8_C(246),
                             UINT8_C( 19), UINT8_C(154), UINT8_C(151), UINT8_C( 43),
                             UINT8_C( 18), UINT8_C( 33), UINT8_C(196), UINT8_C( 32),
                             UINT8_C(143), UINT8_C(197), UINT8_C( 77), UINT8_C( 35),
                             UINT8_C(108), UINT8_C( 21), UINT8_C(240), UINT8_C( 47),
                             UINT8_C( 44), UINT8_C(206), UINT8_C(103), UINT8_C(244),
                             UINT8_C(131), UINT8_C(178), UINT8_C(145), UINT8_C(  4),
                             UINT8_C(241), UINT8_C( 13), UINT8_C(185), UINT8_C( 72),
                             UINT8_C(226), UINT8_C( 93), UINT8_C(116), UINT8_C( 66),
                             UINT8_C(223), UINT8_C(186), UINT8_C(235), UINT8_C( 57)),
      simde_x_mm512_set_epu8(UINT8_C(137), UINT8_C(  6), UINT8_C( 38), UINT8_C(185),
                             UINT8_C(182), UINT8_C(134), UINT8_C( 54), UINT8_C( 21),
                             UINT8_C(101), UINT8_C( 51), UINT8_C(169), UINT8_C(214),
                             UINT8_C(204), UINT8_C( 43), UINT8_C( 15), UINT8_C(161),
                             UINT8_C(123), UINT8_C(201), UINT8_C(126), UINT8_C( 21),
                             UINT8_C(181), UINT8_C(113), UINT8_C(224), UINT8_C(235),
                             UINT8_C(112), UINT8_C( 81), UINT8_C( 97), UINT8_C(103),
                             UINT8_C( 63), UINT8_C( 88), UINT8_C(251), UINT8_C( 83),
                             UINT8_C( 37), UINT8_C( 52), UINT8_C(172), UINT8_C( 10),
                             UINT8_C(101), UINT8_C(146), UINT8_C(200), UINT8_C(167),
                             UINT8_C( 91), UINT8_C(136), UINT8_C(165), UINT8_C( 10),
                             UINT8_C( 46), UINT8_C(208), UINT8_C(176), UINT8_C(155),
                             UINT8_C(102), UINT8_C(231), UINT8_C( 88), UINT8_C(169),
                             UINT8_C( 36), UINT8_C(196), UINT8_C(172), UINT8_C(187),
                             UINT8_C(198), UINT8_C(153), UINT8_C(113), UINT8_C( 47),
                             UINT8_C(217), UINT8_C(143), UINT8_C(254), UINT8_C( 59)),
      UINT64_C(11401226995314349379) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__mmask64 r = simde_mm512_cmple_epu8_mask(test_vec[i].a, test_vec[i].b);
    munit_assert_uint64(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm512_cmplt_epi8_mask(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__mmask64 r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C( -77), INT8_C( -25), INT8_C( -46), INT8_C(  46),
                           INT8_C(  13), INT8_C(   4), INT8_C( -85), INT8_C( -85),
                           INT8_C( -84), INT8_C( -54), INT8_C(  24), INT8_C(  27),
                           INT8_C(-115), INT8_C(  32), INT8_C( -88), INT8_C( -66),
                           INT8_C( 113), INT8_C( -86), INT8_C(  24), INT8_C(  39),
                           INT8_C( -74), INT8_C(  61), INT8_C( 110), INT8_C(  70),
                           INT8_C(  64), INT8_C(  85), INT8_C(-108), INT8_C(  -7),
                           INT8_C(-115), INT8_C( -79), INT8_C( -97), INT8_C( -25),
                           INT8_C( 108), INT8_C( -91), INT8_C(  98), INT8_C(  90),
                           INT8_C( -86), INT8_C(-115), INT8_C(  85), INT8_C( -77),
                           INT8_C( -94), INT8_C( -97), INT8_C( 118), INT8_C( -72),
                           INT8_C( -59), INT8_C(   1), INT8_C(   5), INT8_C(  40),
                           INT8_C( -51), INT8_C(-106), INT8_C( -27), INT8_C(-101),
                           INT8_C(  27), INT8_C( -43), INT8_C( -67), INT8_C(-118),
                           INT8_C(   9), INT8_C( -56), INT8_C(-102), INT8_C( -49),
                           INT8_C( -36), INT8_C(  56), INT8_C(  85), INT8_C(  82)),
      simde_mm512_set_epi8(INT8_C(  15), INT8_C( -44), INT8_C(  -4), INT8_C(  65),
                           INT8_C( 115), INT8_C(  75), INT8_C(-128), INT8_C( -29),
                           INT8_C( -41), INT8_C( -89), INT8_C( -75), INT8_C( -12),
                           INT8_C(   8), INT8_C( -18), INT8_C(   0), INT8_C(  50),
                           INT8_C( -20), INT8_C(  66), INT8_C(  59), INT8_C(  42),
                           INT8_C( 112), INT8_C(-128), INT8_C(  83), INT8_C(   7),
                           INT8_C(  66), INT8_C( -29), INT8_C( -70), INT8_C(  42),
                           INT8_C(-100), INT8_C(  85), INT8_C( -81), INT8_C( -93),
                           INT8_C(   9), INT8_C( -66), INT8_C( -12), INT8_C(  91),
                           INT8_C(  12), INT8_C(  45), INT8_C( 127), INT8_C(-123),
                           INT8_C( -53), INT8_C(  78), INT8_C(  39), INT8_C(-107),
                           INT8_C(   4), INT8_C( -32), INT8_C( -36), INT8_C(  -2),
                           INT8_C( -88), INT8_C(  39), INT8_C( -66), INT8_C( -14),
                           INT8_C( -93), INT8_C( -77), INT8_C( -69), INT8_C(   8),
                           INT8_C(-103), INT8_C( 105), INT8_C(  72), INT8_C(  -8),
                           INT8_C(  49), INT8_C(-104), INT8_C(  40), INT8_C(  17)),
      UINT64_C(13658143053960466808) },
    { simde_mm512_set_epi8(INT8_C(-103), INT8_C(  71), INT8_C(  97), INT8_C(  13),
                           INT8_C( -23), INT8_C(-103), INT8_C(-115), INT8_C(  49),
                           INT8_C(  20), INT8_C(  -2), INT8_C(  49), INT8_C(  20),
                           INT8_C( -48), INT8_C(  19), INT8_C(  36), INT8_C(   5),
                           INT8_C( 110), INT8_C( -17), INT8_C( -78), INT8_C( -81),
                           INT8_C( -87), INT8_C( -42), INT8_C( -90), INT8_C( -74),
                           INT8_C( -81), INT8_C( -59), INT8_C( -73), INT8_C( 101),
                           INT8_C( -93), INT8_C(  16), INT8_C(  54), INT8_C(-126),
                           INT8_C(  73), INT8_C(-113), INT8_C( -63), INT8_C(   0),
                           INT8_C(  -4), INT8_C( -98), INT8_C(  69), INT8_C( -82),
                           INT8_C(-103), INT8_C(-100), INT8_C( -26), INT8_C(   6),
                           INT8_C( -99), INT8_C(  22), INT8_C(   1), INT8_C(-119),
                           INT8_C(  62), INT8_C( -91), INT8_C( 126), INT8_C( -42),
                           INT8_C( -88), INT8_C( -10), INT8_C(  66), INT8_C(-108),
                           INT8_C(   4), INT8_C( -81), INT8_C(-101), INT8_C( -87),
                           INT8_C( -36), INT8_C( 114), INT8_C( 105), INT8_C(  70)),
      simde_mm512_set_epi8(INT8_C(-106), INT8_C( 118), INT8_C(-104), INT8_C(  91),
                           INT8_C(  22), INT8_C( -65), INT8_C(  99), INT8_C(  90),
                           INT8_C( -59), INT8_C( 121), INT8_C(  74), INT8_C(  82),
                           INT8_C(  17), INT8_C( -59), INT8_C(  19), INT8_C(-103),
                           INT8_C(  84), INT8_C(  62), INT8_C( 105), INT8_C( -37),
                           INT8_C( -29), INT8_C(-118), INT8_C(  43), INT8_C(  43),
                           INT8_C(  33), INT8_C(-102), INT8_C(  -5), INT8_C( -51),
                           INT8_C( -22), INT8_C(   3), INT8_C(  47), INT8_C( -50),
                           INT8_C( -25), INT8_C(  25), INT8_C( -33), INT8_C( -68),
                           INT8_C(  52), INT8_C( -60), INT8_C(  19), INT8_C(-103),
                           INT8_C(  71), INT8_C(  88), INT8_C(  82), INT8_C( -50),
                           INT8_C( -90), INT8_C(  -3), INT8_C( -25), INT8_C(  35),
                           INT8_C(-100), INT8_C( -67), INT8_C(  46), INT8_C(  77),
                           INT8_C( -70), INT8_C(   1), INT8_C(  82), INT8_C( 114),
                           INT8_C( -55), INT8_C(  11), INT8_C( -95), INT8_C( 111),
                           INT8_C(  48), INT8_C(  71), INT8_C(  90), INT8_C( -66)),
      UINT64_C(6879384398415355768) },
    { simde_mm512_set_epi8(INT8_C( -71), INT8_C( 111), INT8_C( -21), INT8_C(  61),
                           INT8_C(   5), INT8_C(  96), INT8_C(  81), INT8_C(   9),
                           INT8_C(-121), INT8_C(  39), INT8_C( -77), INT8_C( 111),
                           INT8_C( -66), INT8_C(  56), INT8_C( -30), INT8_C( -47),
                           INT8_C(  60), INT8_C( -59), INT8_C(  45), INT8_C(  86),
                           INT8_C( -57), INT8_C( -53), INT8_C( 106), INT8_C(  23),
                           INT8_C( -11), INT8_C(  82), INT8_C(  92), INT8_C( -19),
                           INT8_C(  64), INT8_C( 103), INT8_C( -89), INT8_C( -98),
                           INT8_C( -33), INT8_C(  99), INT8_C(  24), INT8_C(  46),
                           INT8_C(  12), INT8_C(  -4), INT8_C( -89), INT8_C( 107),
                           INT8_C( -35), INT8_C(  71), INT8_C(  43), INT8_C( 111),
                           INT8_C( -31), INT8_C( -90), INT8_C(  -5), INT8_C(  22),
                           INT8_C(  27), INT8_C( -27), INT8_C( -44), INT8_C( 119),
                           INT8_C( -73), INT8_C(  55), INT8_C(-108), INT8_C( -98),
                           INT8_C( 121), INT8_C(-114), INT8_C(  51), INT8_C(  28),
                           INT8_C(  69), INT8_C(  37), INT8_C(  17), INT8_C( -56)),
      simde_mm512_set_epi8(INT8_C( -65), INT8_C(  52), INT8_C(  -9), INT8_C(  14),
                           INT8_C(  23), INT8_C(-117), INT8_C( 110), INT8_C(  60),
                           INT8_C(  81), INT8_C(-125), INT8_C( 120), INT8_C(  71),
                           INT8_C( 100), INT8_C( -41), INT8_C( 116), INT8_C(-126),
                           INT8_C(-101), INT8_C(  34), INT8_C( -39), INT8_C(  84),
                           INT8_C( -70), INT8_C(-112), INT8_C(  -6), INT8_C( -59),
                           INT8_C(  82), INT8_C(  94), INT8_C(  76), INT8_C( 114),
                           INT8_C( 127), INT8_C( -86), INT8_C( -89), INT8_C(  93),
                           INT8_C(   1), INT8_C( 119), INT8_C( -87), INT8_C( -11),
                           INT8_C( -62), INT8_C( -56), INT8_C( -72), INT8_C( -84),
                           INT8_C(  46), INT8_C(  34), INT8_C( -72), INT8_C(-127),
                           INT8_C(  99), INT8_C( 102), INT8_C(  60), INT8_C(  57),
                           INT8_C( -62), INT8_C( -50), INT8_C( -30), INT8_C(  99),
                           INT8_C( -14), INT8_C(  93), INT8_C( -12), INT8_C(-120),
                           INT8_C( 126), INT8_C(   7), INT8_C(  84), INT8_C(  10),
                           INT8_C( -53), INT8_C( 100), INT8_C( 113), INT8_C( -25)),
      UINT64_C(12369770630542733031) },
    { simde_mm512_set_epi8(INT8_C(  56), INT8_C(  -4), INT8_C(  -4), INT8_C( -38),
                           INT8_C(  25), INT8_C( 103), INT8_C( -62), INT8_C(  92),
                           INT8_C(  31), INT8_C( -43), INT8_C( -18), INT8_C(  90),
                           INT8_C( -11), INT8_C(  80), INT8_C(-102), INT8_C( -32),
                           INT8_C( -48), INT8_C(  -4), INT8_C(-124), INT8_C(-111),
                           INT8_C( 122), INT8_C(  50), INT8_C(  20), INT8_C(  73),
                           INT8_C(  10), INT8_C( -61), INT8_C(  30), INT8_C(  39),
                           INT8_C(  47), INT8_C(  -1), INT8_C( -24), INT8_C(-123),
                           INT8_C(  91), INT8_C(   9), INT8_C( -27), INT8_C(  35),
                           INT8_C(   0), INT8_C( -62), INT8_C( -75), INT8_C( 104),
                           INT8_C(  44), INT8_C(  16), INT8_C(-126), INT8_C(  97),
                           INT8_C( -20), INT8_C( -56), INT8_C( -70), INT8_C( -25),
                           INT8_C(  96), INT8_C( 112), INT8_C( 102), INT8_C(   2),
                           INT8_C( -70), INT8_C( -47), INT8_C(  77), INT8_C( -51),
                           INT8_C( -63), INT8_C(  15), INT8_C( -89), INT8_C( -32),
                           INT8_C(  72), INT8_C( 102), INT8_C( -45), INT8_C(  80)),
      simde_mm512_set_epi8(INT8_C(  46), INT8_C( -69), INT8_C(  -3), INT8_C(   7),
                           INT8_C( -53), INT8_C( -75), INT8_C(-113), INT8_C(  66),
                           INT8_C(-117), INT8_C(  -4), INT8_C( -75), INT8_C(-100),
                           INT8_C( -10), INT8_C(-123), INT8_C( 108), INT8_C(  99),
                           INT8_C(  34), INT8_C(  28), INT8_C(  20), INT8_C(  -3),
                           INT8_C( -41), INT8_C(  37), INT8_C( 126), INT8_C(  37),
                           INT8_C(  86), INT8_C(-126), INT8_