/* Copyright (c) 2018, 2019 Evan Nemerson <evan@nemerson.com>
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#define SIMDE_TESTS_CURRENT_ISAX avx2
#include <simde/x86/avx2.h>
#include <test/x86/test-avx.h>

#if defined(SIMDE_X86_AVX2_NATIVE) || defined(SIMDE_NO_NATIVE) || defined(SIMDE_ALWAYS_BUILD_NATIVE_TESTS)

static MunitResult
test_simde_mm256_abs_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi8(INT8_C( -27), INT8_C(  88), INT8_C(-122), INT8_C(  -6),
                           INT8_C( -23), INT8_C( 108), INT8_C(-103), INT8_C(  32),
                           INT8_C(  43), INT8_C( 116), INT8_C(  -6), INT8_C( -98),
                           INT8_C( -62), INT8_C( -87), INT8_C(  90), INT8_C(  82),
                           INT8_C(  86), INT8_C(   8), INT8_C(-126), INT8_C( -22),
                           INT8_C( -80), INT8_C(-125), INT8_C(  -5), INT8_C(-101),
                           INT8_C(  36), INT8_C( 114), INT8_C( -51), INT8_C(  59),
                           INT8_C( -97), INT8_C( 124), INT8_C(  25), INT8_C(  90)),
      simde_mm256_set_epi8(INT8_C(  27), INT8_C(  88), INT8_C( 122), INT8_C(   6),
                           INT8_C(  23), INT8_C( 108), INT8_C( 103), INT8_C(  32),
                           INT8_C(  43), INT8_C( 116), INT8_C(   6), INT8_C(  98),
                           INT8_C(  62), INT8_C(  87), INT8_C(  90), INT8_C(  82),
                           INT8_C(  86), INT8_C(   8), INT8_C( 126), INT8_C(  22),
                           INT8_C(  80), INT8_C( 125), INT8_C(   5), INT8_C( 101),
                           INT8_C(  36), INT8_C( 114), INT8_C(  51), INT8_C(  59),
                           INT8_C(  97), INT8_C( 124), INT8_C(  25), INT8_C(  90)) },
    { simde_mm256_set_epi8(INT8_C( 111), INT8_C(  46), INT8_C( -44), INT8_C(  36),
                           INT8_C( -79), INT8_C( 101), INT8_C(   0), INT8_C(   2),
                           INT8_C( -69), INT8_C(  31), INT8_C( -68), INT8_C( -82),
                           INT8_C( -45), INT8_C( 120), INT8_C(  39), INT8_C(  46),
                           INT8_C(  66), INT8_C(  30), INT8_C(-106), INT8_C( 118),
                           INT8_C(  61), INT8_C(  98), INT8_C( -61), INT8_C(  98),
                           INT8_C(  49), INT8_C( -12), INT8_C(-117), INT8_C(-115),
                           INT8_C(  63), INT8_C( -92), INT8_C(-102), INT8_C(-110)),
      simde_mm256_set_epi8(INT8_C( 111), INT8_C(  46), INT8_C(  44), INT8_C(  36),
                           INT8_C(  79), INT8_C( 101), INT8_C(   0), INT8_C(   2),
                           INT8_C(  69), INT8_C(  31), INT8_C(  68), INT8_C(  82),
                           INT8_C(  45), INT8_C( 120), INT8_C(  39), INT8_C(  46),
                           INT8_C(  66), INT8_C(  30), INT8_C( 106), INT8_C( 118),
                           INT8_C(  61), INT8_C(  98), INT8_C(  61), INT8_C(  98),
                           INT8_C(  49), INT8_C(  12), INT8_C( 117), INT8_C( 115),
                           INT8_C(  63), INT8_C(  92), INT8_C( 102), INT8_C( 110)) },
    { simde_mm256_set_epi8(INT8_C(  64), INT8_C( -84), INT8_C(  54), INT8_C(-102),
                           INT8_C( -69), INT8_C(  12), INT8_C(-119), INT8_C( -19),
                           INT8_C(  19), INT8_C( -55), INT8_C( -11), INT8_C(-117),
                           INT8_C( -68), INT8_C( -51), INT8_C(  26), INT8_C(  72),
                           INT8_C( -15), INT8_C( 108), INT8_C( -66), INT8_C( -24),
                           INT8_C( -97), INT8_C( -48), INT8_C(  75), INT8_C(  35),
                           INT8_C(  48), INT8_C( -25), INT8_C( -43), INT8_C(   2),
                           INT8_C( -75), INT8_C(  28), INT8_C(-108), INT8_C( -43)),
      simde_mm256_set_epi8(INT8_C(  64), INT8_C(  84), INT8_C(  54), INT8_C( 102),
                           INT8_C(  69), INT8_C(  12), INT8_C( 119), INT8_C(  19),
                           INT8_C(  19), INT8_C(  55), INT8_C(  11), INT8_C( 117),
                           INT8_C(  68), INT8_C(  51), INT8_C(  26), INT8_C(  72),
                           INT8_C(  15), INT8_C( 108), INT8_C(  66), INT8_C(  24),
                           INT8_C(  97), INT8_C(  48), INT8_C(  75), INT8_C(  35),
                           INT8_C(  48), INT8_C(  25), INT8_C(  43), INT8_C(   2),
                           INT8_C(  75), INT8_C(  28), INT8_C( 108), INT8_C(  43)) },
    { simde_mm256_set_epi8(INT8_C(   8), INT8_C( -54), INT8_C(  -1), INT8_C(-128),
                           INT8_C( 118), INT8_C( -15), INT8_C( 125), INT8_C(  76),
                           INT8_C(  47), INT8_C(  33), INT8_C(  69), INT8_C(  21),
                           INT8_C(-116), INT8_C(  34), INT8_C(  36), INT8_C(  31),
                           INT8_C( -32), INT8_C( -84), INT8_C(  23), INT8_C( -76),
                           INT8_C(  82), INT8_C(-115), INT8_C(  74), INT8_C(-110),
                           INT8_C( -46), INT8_C( 125), INT8_C( -52), INT8_C( -99),
                           INT8_C(  30), INT8_C(-106), INT8_C(  66), INT8_C(   5)),
      simde_mm256_set_epi8(INT8_C(   8), INT8_C(  54), INT8_C(   1), INT8_C(-128),
                           INT8_C( 118), INT8_C(  15), INT8_C( 125), INT8_C(  76),
                           INT8_C(  47), INT8_C(  33), INT8_C(  69), INT8_C(  21),
                           INT8_C( 116), INT8_C(  34), INT8_C(  36), INT8_C(  31),
                           INT8_C(  32), INT8_C(  84), INT8_C(  23), INT8_C(  76),
                           INT8_C(  82), INT8_C( 115), INT8_C(  74), INT8_C( 110),
                           INT8_C(  46), INT8_C( 125), INT8_C(  52), INT8_C(  99),
                           INT8_C(  30), INT8_C( 106), INT8_C(  66), INT8_C(   5)) },
    { simde_mm256_set_epi8(INT8_C( 122), INT8_C(  42), INT8_C(-121), INT8_C(-106),
                           INT8_C( 122), INT8_C(  -8), INT8_C(  81), INT8_C(-109),
                           INT8_C( 124), INT8_C(  32), INT8_C(  63), INT8_C( -21),
                           INT8_C( -51), INT8_C( -42), INT8_C(   1), INT8_C( -78),
                           INT8_C(  74), INT8_C(   8), INT8_C(  25), INT8_C(  10),
                           INT8_C( 113), INT8_C( -75), INT8_C( -32), INT8_C( 126),
                           INT8_C( -87), INT8_C(  67), INT8_C(  78), INT8_C( -64),
                           INT8_C(   7), INT8_C( -40), INT8_C( -46), INT8_C( -59)),
      simde_mm256_set_epi8(INT8_C( 122), INT8_C(  42), INT8_C( 121), INT8_C( 106),
                           INT8_C( 122), INT8_C(   8), INT8_C(  81), INT8_C( 109),
                           INT8_C( 124), INT8_C(  32), INT8_C(  63), INT8_C(  21),
                           INT8_C(  51), INT8_C(  42), INT8_C(   1), INT8_C(  78),
                           INT8_C(  74), INT8_C(   8), INT8_C(  25), INT8_C(  10),
                           INT8_C( 113), INT8_C(  75), INT8_C(  32), INT8_C( 126),
                           INT8_C(  87), INT8_C(  67), INT8_C(  78), INT8_C(  64),
                           INT8_C(   7), INT8_C(  40), INT8_C(  46), INT8_C(  59)) },
    { simde_mm256_set_epi8(INT8_C(  10), INT8_C( 120), INT8_C(  81), INT8_C(-105),
                           INT8_C(  73), INT8_C( -95), INT8_C(  79), INT8_C( -86),
                           INT8_C( -93), INT8_C( -54), INT8_C( -43), INT8_C( -88),
                           INT8_C(  59), INT8_C( -27), INT8_C(  12), INT8_C(  10),
                           INT8_C(  73), INT8_C( -48), INT8_C( 112), INT8_C(  27),
                           INT8_C(-113), INT8_C( -31), INT8_C( -56), INT8_C( -96),
                           INT8_C(  48), INT8_C( -94), INT8_C(-111), INT8_C(  60),
                           INT8_C(-116), INT8_C( -77), INT8_C( -70), INT8_C(  17)),
      simde_mm256_set_epi8(INT8_C(  10), INT8_C( 120), INT8_C(  81), INT8_C( 105),
                           INT8_C(  73), INT8_C(  95), INT8_C(  79), INT8_C(  86),
                           INT8_C(  93), INT8_C(  54), INT8_C(  43), INT8_C(  88),
                           INT8_C(  59), INT8_C(  27), INT8_C(  12), INT8_C(  10),
                           INT8_C(  73), INT8_C(  48), INT8_C( 112), INT8_C(  27),
                           INT8_C( 113), INT8_C(  31), INT8_C(  56), INT8_C(  96),
                           INT8_C(  48), INT8_C(  94), INT8_C( 111), INT8_C(  60),
                           INT8_C( 116), INT8_C(  77), INT8_C(  70), INT8_C(  17)) },
    { simde_mm256_set_epi8(INT8_C(  61), INT8_C( -57), INT8_C( -99), INT8_C(   0),
                           INT8_C(  98), INT8_C(-121), INT8_C(  67), INT8_C( -20),
                           INT8_C(  44), INT8_C(  53), INT8_C(-128), INT8_C(  44),
                           INT8_C( 127), INT8_C(  53), INT8_C(-127), INT8_C(  58),
                           INT8_C(  35), INT8_C(  83), INT8_C( -56), INT8_C(  22),
                           INT8_C(  -4), INT8_C(  -6), INT8_C(  -7), INT8_C( 121),
                           INT8_C( -22), INT8_C( -32), INT8_C( -52), INT8_C( 124),
                           INT8_C( -93), INT8_C(  55), INT8_C( -23), INT8_C( -62)),
      simde_mm256_set_epi8(INT8_C(  61), INT8_C(  57), INT8_C(  99), INT8_C(   0),
                           INT8_C(  98), INT8_C( 121), INT8_C(  67), INT8_C(  20),
                           INT8_C(  44), INT8_C(  53), INT8_C(-128), INT8_C(  44),
                           INT8_C( 127), INT8_C(  53), INT8_C( 127), INT8_C(  58),
                           INT8_C(  35), INT8_C(  83), INT8_C(  56), INT8_C(  22),
                           INT8_C(   4), INT8_C(   6), INT8_C(   7), INT8_C( 121),
                           INT8_C(  22), INT8_C(  32), INT8_C(  52), INT8_C( 124),
                           INT8_C(  93), INT8_C(  55), INT8_C(  23), INT8_C(  62)) },
    { simde_mm256_set_epi8(INT8_C(  71), INT8_C( -58), INT8_C(  24), INT8_C( 117),
                           INT8_C(   2), INT8_C( -31), INT8_C( -86), INT8_C( 101),
                           INT8_C(   3), INT8_C(  63), INT8_C(   2), INT8_C( -30),
                           INT8_C( -33), INT8_C(  51), INT8_C(  60), INT8_C(  81),
                           INT8_C( -91), INT8_C( -73), INT8_C(  66), INT8_C(  67),
                           INT8_C(  72), INT8_C(  -7), INT8_C(  44), INT8_C( -32),
                           INT8_C( -80), INT8_C( 101), INT8_C( -98), INT8_C(  89),
                           INT8_C(  89), INT8_C(  94), INT8_C( 109), INT8_C(-109)),
      simde_mm256_set_epi8(INT8_C(  71), INT8_C(  58), INT8_C(  24), INT8_C( 117),
                           INT8_C(   2), INT8_C(  31), INT8_C(  86), INT8_C( 101),
                           INT8_C(   3), INT8_C(  63), INT8_C(   2), INT8_C(  30),
                           INT8_C(  33), INT8_C(  51), INT8_C(  60), INT8_C(  81),
                           INT8_C(  91), INT8_C(  73), INT8_C(  66), INT8_C(  67),
                           INT8_C(  72), INT8_C(   7), INT8_C(  44), INT8_C(  32),
                           INT8_C(  80), INT8_C( 101), INT8_C(  98), INT8_C(  89),
                           INT8_C(  89), INT8_C(  94), INT8_C( 109), INT8_C( 109)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_abs_epi8(test_vec[i].a);
    simde_assert_m256i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_abs_epi16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi16(INT16_C(  9101), INT16_C( 13664), INT16_C( 14007), INT16_C( 17440),
                            INT16_C( 21201), INT16_C(-16892), INT16_C(-22702), INT16_C(-11875),
                            INT16_C(  9352), INT16_C( 21001), INT16_C( 15464), INT16_C( 27994),
                            INT16_C( 12104), INT16_C(-22404), INT16_C(-21433), INT16_C( -4031)),
      simde_mm256_set_epi16(INT16_C(  9101), INT16_C( 13664), INT16_C( 14007), INT16_C( 17440),
                            INT16_C( 21201), INT16_C( 16892), INT16_C( 22702), INT16_C( 11875),
                            INT16_C(  9352), INT16_C( 21001), INT16_C( 15464), INT16_C( 27994),
                            INT16_C( 12104), INT16_C( 22404), INT16_C( 21433), INT16_C(  4031)) },
    { simde_mm256_set_epi16(INT16_C( 20289), INT16_C( -8788), INT16_C(  5917), INT16_C(-28916),
                            INT16_C(-21540), INT16_C( -8179), INT16_C(-25392), INT16_C(  2609),
                            INT16_C( 12609), INT16_C(-11367), INT16_C(   -70), INT16_C( 28633),
                            INT16_C(-21576), INT16_C(-23753), INT16_C(-11797), INT16_C(-17346)),
      simde_mm256_set_epi16(INT16_C( 20289), INT16_C(  8788), INT16_C(  5917), INT16_C( 28916),
                            INT16_C( 21540), INT16_C(  8179), INT16_C( 25392), INT16_C(  2609),
                            INT16_C( 12609), INT16_C( 11367), INT16_C(    70), INT16_C( 28633),
                            INT16_C( 21576), INT16_C( 23753), INT16_C( 11797), INT16_C( 17346)) },
    { simde_mm256_set_epi16(INT16_C( 11563), INT16_C(-31585), INT16_C( 24583), INT16_C(  2918),
                            INT16_C(  5705), INT16_C( 31274), INT16_C(-12388), INT16_C( 31454),
                            INT16_C(  5008), INT16_C( 10123), INT16_C( 28874), INT16_C(-27636),
                            INT16_C(  1380), INT16_C(-32687), INT16_C( 24141), INT16_C( 11570)),
      simde_mm256_set_epi16(INT16_C( 11563), INT16_C( 31585), INT16_C( 24583), INT16_C(  2918),
                            INT16_C(  5705), INT16_C( 31274), INT16_C( 12388), INT16_C( 31454),
                            INT16_C(  5008), INT16_C( 10123), INT16_C( 28874), INT16_C( 27636),
                            INT16_C(  1380), INT16_C( 32687), INT16_C( 24141), INT16_C( 11570)) },
    { simde_mm256_set_epi16(INT16_C(-28981), INT16_C(-21254), INT16_C( 12206), INT16_C( 17751),
                            INT16_C(  4887), INT16_C( 27025), INT16_C( 20436), INT16_C( -3143),
                            INT16_C(  5806), INT16_C( 19398), INT16_C( 23890), INT16_C( -1841),
                            INT16_C( -1212), INT16_C(  -418), INT16_C(  2804), INT16_C(-24086)),
      simde_mm256_set_epi16(INT16_C( 28981), INT16_C( 21254), INT16_C( 12206), INT16_C( 17751),
                            INT16_C(  4887), INT16_C( 27025), INT16_C( 20436), INT16_C(  3143),
                            INT16_C(  5806), INT16_C( 19398), INT16_C( 23890), INT16_C(  1841),
                            INT16_C(  1212), INT16_C(   418), INT16_C(  2804), INT16_C( 24086)) },
    { simde_mm256_set_epi16(INT16_C(-32227), INT16_C( 26559), INT16_C( 32468), INT16_C(  9282),
                            INT16_C( 10212), INT16_C(  7157), INT16_C(-18109), INT16_C(-13716),
                            INT16_C(  3356), INT16_C( -6654), INT16_C(  3548), INT16_C(-31612),
                            INT16_C( -3226), INT16_C(-30156), INT16_C(-15323), INT16_C(  8689)),
      simde_mm256_set_epi16(INT16_C( 32227), INT16_C( 26559), INT16_C( 32468), INT16_C(  9282),
                            INT16_C( 10212), INT16_C(  7157), INT16_C( 18109), INT16_C( 13716),
                            INT16_C(  3356), INT16_C(  6654), INT16_C(  3548), INT16_C( 31612),
                            INT16_C(  3226), INT16_C( 30156), INT16_C( 15323), INT16_C(  8689)) },
    { simde_mm256_set_epi16(INT16_C( 14337), INT16_C(-20237), INT16_C(  7001), INT16_C( 29027),
                            INT16_C( -3029), INT16_C( 12894), INT16_C(-24482), INT16_C( -8195),
                            INT16_C( -7637), INT16_C(-26436), INT16_C( 15950), INT16_C(  5319),
                            INT16_C( 22977), INT16_C(  -593), INT16_C(-29639), INT16_C( 23312)),
      simde_mm256_set_epi16(INT16_C( 14337), INT16_C( 20237), INT16_C(  7001), INT16_C( 29027),
                            INT16_C(  3029), INT16_C( 12894), INT16_C( 24482), INT16_C(  8195),
                            INT16_C(  7637), INT16_C( 26436), INT16_C( 15950), INT16_C(  5319),
                            INT16_C( 22977), INT16_C(   593), INT16_C( 29639), INT16_C( 23312)) },
    { simde_mm256_set_epi16(INT16_C(  4249), INT16_C( -3888), INT16_C( 15630), INT16_C(-11095),
                            INT16_C(-21648), INT16_C(-10947), INT16_C( -1651), INT16_C(  5821),
                            INT16_C( 25032), INT16_C( 26383), INT16_C(-18726), INT16_C(-14746),
                            INT16_C(  9694), INT16_C(-29231), INT16_C( 18526), INT16_C(-12816)),
      simde_mm256_set_epi16(INT16_C(  4249), INT16_C(  3888), INT16_C( 15630), INT16_C( 11095),
                            INT16_C( 21648), INT16_C( 10947), INT16_C(  1651), INT16_C(  5821),
                            INT16_C( 25032), INT16_C( 26383), INT16_C( 18726), INT16_C( 14746),
                            INT16_C(  9694), INT16_C( 29231), INT16_C( 18526), INT16_C( 12816)) },
    { simde_mm256_set_epi16(INT16_C(  6410), INT16_C(  4746), INT16_C( 16873), INT16_C(-29607),
                            INT16_C( 21314), INT16_C(-32512), INT16_C(-23052), INT16_C( 20594),
                            INT16_C( -1613), INT16_C( 26993), INT16_C( 28325), INT16_C(   406),
                            INT16_C(-19031), INT16_C(  6060), INT16_C(-29650), INT16_C(  8164)),
      simde_mm256_set_epi16(INT16_C(  6410), INT16_C(  4746), INT16_C( 16873), INT16_C( 29607),
                            INT16_C( 21314), INT16_C( 32512), INT16_C( 23052), INT16_C( 20594),
                            INT16_C(  1613), INT16_C( 26993), INT16_C( 28325), INT16_C(   406),
                            INT16_C( 19031), INT16_C(  6060), INT16_C( 29650), INT16_C(  8164)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_abs_epi16(test_vec[i].a);
    simde_assert_m256i_i16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_abs_epi32(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi32(INT32_C(  596456800), INT32_C(  917980192), INT32_C( 1389477380), INT32_C(-1487744611),
                            INT32_C(  612913673), INT32_C( 1013476698), INT32_C(  793290876), INT32_C(-1404571583)),
      simde_mm256_set_epi32(INT32_C(  596456800), INT32_C(  917980192), INT32_C( 1389477380), INT32_C( 1487744611),
                            INT32_C(  612913673), INT32_C( 1013476698), INT32_C(  793290876), INT32_C( 1404571583)) },
    { simde_mm256_set_epi32(INT32_C( 1329716652), INT32_C(  387813132), INT32_C(-1411588083), INT32_C(-1664087503),
                            INT32_C(  826397593), INT32_C(   -4558887), INT32_C(-1413962953), INT32_C( -773080002)),
      simde_mm256_set_epi32(INT32_C( 1329716652), INT32_C(  387813132), INT32_C( 1411588083), INT32_C( 1664087503),
                            INT32_C(  826397593), INT32_C(    4558887), INT32_C( 1413962953), INT32_C(  773080002)) },
    { simde_mm256_set_epi32(INT32_C(  757826719), INT32_C( 1611074406), INT32_C(  373914154), INT32_C( -811828514),
                            INT32_C(  328214411), INT32_C( 1892324364), INT32_C(   90472529), INT32_C( 1582116146)),
      simde_mm256_set_epi32(INT32_C(  757826719), INT32_C( 1611074406), INT32_C(  373914154), INT32_C(  811828514),
                            INT32_C(  328214411), INT32_C( 1892324364), INT32_C(   90472529), INT32_C( 1582116146)) },
    { simde_mm256_set_epi32(INT32_C(-1899254534), INT32_C(  799950167), INT32_C(  320301457), INT32_C( 1339356089),
                            INT32_C(  380521414), INT32_C( 1565718735), INT32_C(  -79364514), INT32_C(  183804394)),
      simde_mm256_set_epi32(INT32_C( 1899254534), INT32_C(  799950167), INT32_C(  320301457), INT32_C( 1339356089),
                            INT32_C(  380521414), INT32_C( 1565718735), INT32_C(   79364514), INT32_C(  183804394)) },
    { simde_mm256_set_epi32(INT32_C(-2112002113), INT32_C( 2127832130), INT32_C(  669260789), INT32_C(-1186739604),
                            INT32_C(  219997698), INT32_C(  232555652), INT32_C( -211383756), INT32_C(-1004199439)),
      simde_mm256_set_epi32(INT32_C( 2112002113), INT32_C( 2127832130), INT32_C(  669260789), INT32_C( 1186739604),
                            INT32_C(  219997698), INT32_C(  232555652), INT32_C(  211383756), INT32_C( 1004199439)) },
    { simde_mm256_set_epi32(INT32_C(  939634931), INT32_C(  458846563), INT32_C( -198495650), INT32_C(-1604395011),
                            INT32_C( -500459332), INT32_C( 1045304519), INT32_C( 1505885615), INT32_C(-1942398192)),
      simde_mm256_set_epi32(INT32_C(  939634931), INT32_C(  458846563), INT32_C(  198495650), INT32_C( 1604395011),
                            INT32_C(  500459332), INT32_C( 1045304519), INT32_C( 1505885615), INT32_C( 1942398192)) },
    { simde_mm256_set_epi32(INT32_C(  278524112), INT32_C( 1024382121), INT32_C(-1418668739), INT32_C( -108194115),
                            INT32_C( 1640523535), INT32_C(-1227176346), INT32_C(  635342289), INT32_C( 1214172656)),
      simde_mm256_set_epi32(INT32_C(  278524112), INT32_C( 1024382121), INT32_C( 1418668739), INT32_C(  108194115),
                            INT32_C( 1640523535), INT32_C( 1227176346), INT32_C(  635342289), INT32_C( 1214172656)) },
    { simde_mm256_set_epi32(INT32_C(  420090506), INT32_C( 1105824857), INT32_C( 1396867328), INT32_C(-1510715278),
                            INT32_C( -105682575), INT32_C( 1856307606), INT32_C(-1247209556), INT32_C(-1943134236)),
      simde_mm256_set_epi32(INT32_C(  420090506), INT32_C( 1105824857), INT32_C( 1396867328), INT32_C( 1510715278),
                            INT32_C(  105682575), INT32_C( 1856307606), INT32_C( 1247209556), INT32_C( 1943134236)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_abs_epi32(test_vec[i].a);
    simde_assert_m256i_i32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_add_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi8(INT8_C(  38), INT8_C(   7), INT8_C(  -2), INT8_C(  58),
                           INT8_C( 110), INT8_C( -99), INT8_C( -44), INT8_C(  54),
                           INT8_C(  -7), INT8_C(  11), INT8_C(  37), INT8_C(  89),
                           INT8_C(-116), INT8_C( -61), INT8_C( -62), INT8_C(-100),
                           INT8_C(  93), INT8_C(-106), INT8_C( -93), INT8_C( -65),
                           INT8_C(  41), INT8_C(  48), INT8_C( 119), INT8_C( -81),
                           INT8_C( 111), INT8_C(-127), INT8_C( -20), INT8_C(  49),
                           INT8_C( -86), INT8_C(  40), INT8_C(   8), INT8_C( -11)),
      simde_mm256_set_epi8(INT8_C(  39), INT8_C(  75), INT8_C(  21), INT8_C( -79),
                           INT8_C(  76), INT8_C( -46), INT8_C(  91), INT8_C(  40),
                           INT8_C(  97), INT8_C( -98), INT8_C( -82), INT8_C(  44),
                           INT8_C( -73), INT8_C( -89), INT8_C(-127), INT8_C( -32),
                           INT8_C( 120), INT8_C( 113), INT8_C( -53), INT8_C( -49),
                           INT8_C( -63), INT8_C(  81), INT8_C( -64), INT8_C(  90),
                           INT8_C( 100), INT8_C( -73), INT8_C( -51), INT8_C(-117),
                           INT8_C( -40), INT8_C(  69), INT8_C(-110), INT8_C( -48)),
      simde_mm256_set_epi8(INT8_C(  77), INT8_C(  82), INT8_C(  19), INT8_C( -21),
                           INT8_C( -70), INT8_C( 111), INT8_C(  47), INT8_C(  94),
                           INT8_C(  90), INT8_C( -87), INT8_C( -45), INT8_C(-123),
                           INT8_C(  67), INT8_C( 106), INT8_C(  67), INT8_C( 124),
                           INT8_C( -43), INT8_C(   7), INT8_C( 110), INT8_C(-114),
                           INT8_C( -22), INT8_C(-127), INT8_C(  55), INT8_C(   9),
                           INT8_C( -45), INT8_C(  56), INT8_C( -71), INT8_C( -68),
                           INT8_C(-126), INT8_C( 109), INT8_C(-102), INT8_C( -59)) },
    { simde_mm256_set_epi8(INT8_C(  71), INT8_C(   4), INT8_C(  70), INT8_C( -16),
                           INT8_C( -60), INT8_C( -69), INT8_C( -49), INT8_C( 108),
                           INT8_C( 108), INT8_C(  12), INT8_C(  69), INT8_C( -44),
                           INT8_C( 104), INT8_C(-122), INT8_C(  94), INT8_C( -44),
                           INT8_C(  20), INT8_C( -27), INT8_C(  55), INT8_C( 116),
                           INT8_C( 117), INT8_C(-108), INT8_C(  62), INT8_C(-118),
                           INT8_C(  86), INT8_C( -59), INT8_C(   3), INT8_C(  -3),
                           INT8_C( -82), INT8_C( 110), INT8_C(  88), INT8_C(  57)),
      simde_mm256_set_epi8(INT8_C( -80), INT8_C( 112), INT8_C(  78), INT8_C( -63),
                           INT8_C( 105), INT8_C(  59), INT8_C(  13), INT8_C( -94),
                           INT8_C( 116), INT8_C( -39), INT8_C(  42), INT8_C(  69),
                           INT8_C( 119), INT8_C(  -2), INT8_C( -96), INT8_C( -26),
                           INT8_C(  78), INT8_C(  -3), INT8_C( 125), INT8_C(  93),
                           INT8_C( -99), INT8_C( -92), INT8_C(  87), INT8_C( 115),
                           INT8_C( -58), INT8_C( 102), INT8_C(  77), INT8_C(  14),
                           INT8_C(-124), INT8_C(  69), INT8_C( 123), INT8_C(  22)),
      simde_mm256_set_epi8(INT8_C(  -9), INT8_C( 116), INT8_C(-108), INT8_C( -79),
                           INT8_C(  45), INT8_C( -10), INT8_C( -36), INT8_C(  14),
                           INT8_C( -32), INT8_C( -27), INT8_C( 111), INT8_C(  25),
                           INT8_C( -33), INT8_C(-124), INT8_C(  -2), INT8_C( -70),
                           INT8_C(  98), INT8_C( -30), INT8_C( -76), INT8_C( -47),
                           INT8_C(  18), INT8_C(  56), INT8_C(-107), INT8_C(  -3),
                           INT8_C(  28), INT8_C(  43), INT8_C(  80), INT8_C(  11),
                           INT8_C(  50), INT8_C( -77), INT8_C( -45), INT8_C(  79)) },
    { simde_mm256_set_epi8(INT8_C(  35), INT8_C(  50), INT8_C(-118), INT8_C( -51),
                           INT8_C( 104), INT8_C(  20), INT8_C( -38), INT8_C(-105),
                           INT8_C(  57), INT8_C(  19), INT8_C( -89), INT8_C( -46),
                           INT8_C(  27), INT8_C( -40), INT8_C(  -8), INT8_C( -54),
                           INT8_C(  74), INT8_C(-108), INT8_C( -11), INT8_C(  36),
                           INT8_C(  14), INT8_C(  26), INT8_C( -19), INT8_C( -47),
                           INT8_C(  70), INT8_C( -22), INT8_C(   1), INT8_C(  48),
                           INT8_C(-104), INT8_C(  96), INT8_C(  54), INT8_C( -65)),
      simde_mm256_set_epi8(INT8_C(  28), INT8_C( -52), INT8_C( 107), INT8_C(-103),
                           INT8_C( 110), INT8_C(  86), INT8_C(  60), INT8_C(   2),
                           INT8_C( -17), INT8_C(  30), INT8_C( -28), INT8_C( -92),
                           INT8_C(  93), INT8_C( 112), INT8_C( -31), INT8_C(  -9),
                           INT8_C(   8), INT8_C( -36), INT8_C( -58), INT8_C(-120),
                           INT8_C( -53), INT8_C(  26), INT8_C( -55), INT8_C( -73),
                           INT8_C(  20), INT8_C(  83), INT8_C( 124), INT8_C(  54),
                           INT8_C(  30), INT8_C( -54), INT8_C( -43), INT8_C(-123)),
      simde_mm256_set_epi8(INT8_C(  63), INT8_C(  -2), INT8_C( -11), INT8_C( 102),
                           INT8_C( -42), INT8_C( 106), INT8_C(  22), INT8_C(-103),
                           INT8_C(  40), INT8_C(  49), INT8_C(-117), INT8_C( 118),
                           INT8_C( 120), INT8_C(  72), INT8_C( -39), INT8_C( -63),
                           INT8_C(  82), INT8_C( 112), INT8_C( -69), INT8_C( -84),
                           INT8_C( -39), INT8_C(  52), INT8_C( -74), INT8_C(-120),
                           INT8_C(  90), INT8_C(  61), INT8_C( 125), INT8_C( 102),
                           INT8_C( -74), INT8_C(  42), INT8_C(  11), INT8_C(  68)) },
    { simde_mm256_set_epi8(INT8_C( -39), INT8_C( 114), INT8_C(  -7), INT8_C( 121),
                           INT8_C(  92), INT8_C(  79), INT8_C( 102), INT8_C(  76),
                           INT8_C( 109), INT8_C( -19), INT8_C(  70), INT8_C( -60),
                           INT8_C(  69), INT8_C( -31), INT8_C(  37), INT8_C(  40),
                           INT8_C( -46), INT8_C(  88), INT8_C( -21), INT8_C( -43),
                           INT8_C(  83), INT8_C(  14), INT8_C( -23), INT8_C( -33),
                           INT8_C(  86), INT8_C( -85), INT8_C(   8), INT8_C(  59),
                           INT8_C( 123), INT8_C(  93), INT8_C( -22), INT8_C(  26)),
      simde_mm256_set_epi8(INT8_C( 116), INT8_C( -91), INT8_C(  32), INT8_C( -33),
                           INT8_C(-123), INT8_C(-113), INT8_C(  98), INT8_C( -60),
                           INT8_C(-116), INT8_C( -75), INT8_C(  96), INT8_C(  10),
                           INT8_C( -53), INT8_C( -10), INT8_C( -80), INT8_C(-128),
                           INT8_C(  59), INT8_C( -73), INT8_C( -11), INT8_C(   8),
                           INT8_C(-127), INT8_C(-108), INT8_C(-124), INT8_C( 111),
                           INT8_C( -79), INT8_C(  28), INT8_C(  24), INT8_C(  40),
                           INT8_C(  40), INT8_C(  29), INT8_C( 119), INT8_C( 100)),
      simde_mm256_set_epi8(INT8_C(  77), INT8_C(  23), INT8_C(  25), INT8_C(  88),
                           INT8_C( -31), INT8_C( -34), INT8_C( -56), INT8_C(  16),
                           INT8_C(  -7), INT8_C( -94), INT8_C( -90), INT8_C( -50),
                           INT8_C(  16), INT8_C( -41), INT8_C( -43), INT8_C( -88),
                           INT8_C(  13), INT8_C(  15), INT8_C( -32), INT8_C( -35),
                           INT8_C( -44), INT8_C( -94), INT8_C( 109), INT8_C(  78),
                           INT8_C(   7), INT8_C( -57), INT8_C(  32), INT8_C(  99),
                           INT8_C( -93), INT8_C( 122), INT8_C(  97), INT8_C( 126)) },
    { simde_mm256_set_epi8(INT8_C(-108), INT8_C( -39), INT8_C( -41), INT8_C( 120),
                           INT8_C(-106), INT8_C( -66), INT8_C( -98), INT8_C( -12),
                           INT8_C(-106), INT8_C( -94), INT8_C( -31), INT8_C( -14),
                           INT8_C(  -2), INT8_C( -34), INT8_C( -30), INT8_C( -64),
                           INT8_C(  65), INT8_C(  50), INT8_C(  73), INT8_C( -32),
                           INT8_C( 106), INT8_C(-126), INT8_C(  67), INT8_C(  53),
                           INT8_C( 104), INT8_C(  17), INT8_C( -36), INT8_C(  95),
                           INT8_C(  57), INT8_C(  32), INT8_C( -59), INT8_C( -12)),
      simde_mm256_set_epi8(INT8_C(  29), INT8_C(  61), INT8_C( -31), INT8_C( 122),
                           INT8_C(   8), INT8_C( -70), INT8_C(  11), INT8_C(  62),
                           INT8_C( -73), INT8_C( -96), INT8_C( -10), INT8_C( -40),
                           INT8_C( -52), INT8_C( -38), INT8_C(  92), INT8_C(  51),
                           INT8_C(  35), INT8_C(  53), INT8_C(  88), INT8_C( -11),
                           INT8_C(  57), INT8_C(-113), INT8_C(-123), INT8_C( 106),
                           INT8_C(-110), INT8_C(-110), INT8_C(   2), INT8_C(  67),
                           INT8_C( -30), INT8_C( -96), INT8_C( -97), INT8_C( -86)),
      simde_mm256_set_epi8(INT8_C( -79), INT8_C(  22), INT8_C( -72), INT8_C( -14),
                           INT8_C( -98), INT8_C( 120), INT8_C( -87), INT8_C(  50),
                           INT8_C(  77), INT8_C(  66), INT8_C( -41), INT8_C( -54),
                           INT8_C( -54), INT8_C( -72), INT8_C(  62), INT8_C( -13),
                           INT8_C( 100), INT8_C( 103), INT8_C( -95), INT8_C( -43),
                           INT8_C( -93), INT8_C(  17), INT8_C( -56), INT8_C( -97),
                           INT8_C(  -6), INT8_C( -93), INT8_C( -34), INT8_C( -94),
                           INT8_C(  27), INT8_C( -64), INT8_C( 100), INT8_C( -98)) },
    { simde_mm256_set_epi8(INT8_C( -25), INT8_C( -91), INT8_C(  57), INT8_C( -61),
                           INT8_C(  27), INT8_C( -92), INT8_C(-114), INT8_C(-104),
                           INT8_C( 125), INT8_C( 120), INT8_C( -30), INT8_C(   8),
                           INT8_C(  88), INT8_C( -75), INT8_C( 100), INT8_C(  97),
                           INT8_C( -61), INT8_C( 122), INT8_C(  27), INT8_C( -70),
                           INT8_C( -30), INT8_C( -60), INT8_C( -90), INT8_C( -43),
                           INT8_C( -10), INT8_C( -38), INT8_C(  12), INT8_C(  90),
                           INT8_C(   1), INT8_C(  39), INT8_C( -80), INT8_C(  53)),
      simde_mm256_set_epi8(INT8_C( 121), INT8_C(  85), INT8_C(-111), INT8_C(-111),
                           INT8_C(  84), INT8_C(  54), INT8_C( -52), INT8_C( -62),
                           INT8_C( -55), INT8_C(  17), INT8_C(  68), INT8_C(  63),
                           INT8_C( 113), INT8_C( -67), INT8_C( -38), INT8_C(-118),
                           INT8_C(-104), INT8_C( -71), INT8_C(  55), INT8_C(  21),
                           INT8_C( -66), INT8_C(  19), INT8_C(-123), INT8_C(  95),
                           INT8_C( 118), INT8_C(  65), INT8_C( -70), INT8_C( -13),
                           INT8_C( 120), INT8_C( -27), INT8_C( -66), INT8_C( 122)),
      simde_mm256_set_epi8(INT8_C(  96), INT8_C(  -6), INT8_C( -54), INT8_C(  84),
                           INT8_C( 111), INT8_C( -38), INT8_C(  90), INT8_C(  90),
                           INT8_C(  70), INT8_C(-119), INT8_C(  38), INT8_C(  71),
                           INT8_C( -55), INT8_C( 114), INT8_C(  62), INT8_C( -21),
                           INT8_C(  91), INT8_C(  51), INT8_C(  82), INT8_C( -49),
                           INT8_C( -96), INT8_C( -41), INT8_C(  43), INT8_C(  52),
                           INT8_C( 108), INT8_C(  27), INT8_C( -58), INT8_C(  77),
                           INT8_C( 121), INT8_C(  12), INT8_C( 110), INT8_C( -81)) },
    { simde_mm256_set_epi8(INT8_C( 117), INT8_C( -64), INT8_C(  32), INT8_C( -52),
                           INT8_C(  16), INT8_C( -33), INT8_C(  14), INT8_C( -85),
                           INT8_C(   3), INT8_C( -57), INT8_C( -94), INT8_C( -41),
                           INT8_C( -98), INT8_C( 127), INT8_C(  42), INT8_C(  48),
                           INT8_C(  17), INT8_C( 106), INT8_C( -29), INT8_C( -56),
                           INT8_C(  75), INT8_C(-117), INT8_C( 106), INT8_C(  46),
                           INT8_C(-110), INT8_C( 123), INT8_C(  46), INT8_C(   8),
                           INT8_C(-118), INT8_C( 103), INT8_C(  19), INT8_C(  26)),
      simde_mm256_set_epi8(INT8_C(-123), INT8_C(  76), INT8_C( 117), INT8_C(  39),
                           INT8_C( 120), INT8_C( -11), INT8_C(  12), INT8_C( -12),
                           INT8_C( -32), INT8_C(   7), INT8_C(  13), INT8_C(  45),
                           INT8_C(  60), INT8_C( -83), INT8_C( -84), INT8_C( -17),
                           INT8_C( -88), INT8_C( -57), INT8_C( 102), INT8_C( -44),
                           INT8_C( 119), INT8_C(  16), INT8_C( 101), INT8_C( -86),
                           INT8_C(-106), INT8_C(-124), INT8_C(  83), INT8_C(-127),
                           INT8_C(  55), INT8_C( -92), INT8_C(  15), INT8_C(-114)),
      simde_mm256_set_epi8(INT8_C(  -6), INT8_C(  12), INT8_C(-107), INT8_C( -13),
                           INT8_C(-120), INT8_C( -44), INT8_C(  26), INT8_C( -97),
                           INT8_C( -29), INT8_C( -50), INT8_C( -81), INT8_C(   4),
                           INT8_C( -38), INT8_C(  44), INT8_C( -42), INT8_C(  31),
                           INT8_C( -71), INT8_C(  49), INT8_C(  73), INT8_C(-100),
                           INT8_C( -62), INT8_C(-101), INT8_C( -49), INT8_C( -40),
                           INT8_C(  40), INT8_C(  -1), INT8_C(-127), INT8_C(-119),
                           INT8_C( -63), INT8_C(  11), INT8_C(  34), INT8_C( -88)) },
    { simde_mm256_set_epi8(INT8_C(-111), INT8_C( -68), INT8_C( -72), INT8_C(-123),
                           INT8_C(  60), INT8_C(  19), INT8_C( -56), INT8_C( -34),
                           INT8_C(  75), INT8_C(-101), INT8_C(  82), INT8_C(  25),
                           INT8_C( 119), INT8_C(  87), INT8_C(  12), INT8_C( -81),
                           INT8_C( 120), INT8_C(  58), INT8_C(  77), INT8_C(-102),
                           INT8_C( -65), INT8_C(  14), INT8_C(  32), INT8_C(-111),
                           INT8_C(  72), INT8_C(  -1), INT8_C( 117), INT8_C(-104),
                           INT8_C(  81), INT8_C( -80), INT8_C( -43), INT8_C( -80)),
      simde_mm256_set_epi8(INT8_C( 114), INT8_C( -63), INT8_C(  59), INT8_C( -32),
                           INT8_C( 113), INT8_C(-103), INT8_C( -89), INT8_C( -53),
                           INT8_C( -11), INT8_C(  31), INT8_C(  71), INT8_C( -59),
                           INT8_C(  89), INT8_C(  28), INT8_C(  76), INT8_C(  62),
                           INT8_C(  13), INT8_C( 105), INT8_C( -93), INT8_C(  64),
                           INT8_C( -40), INT8_C(  38), INT8_C( -73), INT8_C(-114),
                           INT8_C(-121), INT8_C( -54), INT8_C(-113), INT8_C(   1),
                           INT8_C( -77), INT8_C( -55), INT8_C(  24), INT8_C( -16)),
      simde_mm256_set_epi8(INT8_C(   3), INT8_C( 125), INT8_C( -13), INT8_C( 101),
                           INT8_C( -83), INT8_C( -84), INT8_C( 111), INT8_C( -87),
                           INT8_C(  64), INT8_C( -70), INT8_C(-103), INT8_C( -34),
                           INT8_C( -48), INT8_C( 115), INT8_C(  88), INT8_C( -19),
                           INT8_C(-123), INT8_C( -93), INT8_C( -16), INT8_C( -38),
                           INT8_C(-105), INT8_C(  52), INT8_C( -41), INT8_C(  31),
                           INT8_C( -49), INT8_C( -55), INT8_C(   4), INT8_C(-103),
                           INT8_C(   4), INT8_C( 121), INT8_C( -19), INT8_C( -96)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_add_epi8(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_add_epi16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi16(INT16_C(-12908), INT16_C(-15352), INT16_C( -9871), INT16_C( 11131),
                            INT16_C(-13055), INT16_C( 26967), INT16_C(-23057), INT16_C( 20309),
                            INT16_C(-12549), INT16_C(-20367), INT16_C(  6732), INT16_C( -7853),
                            INT16_C(-23923), INT16_C( -3719), INT16_C(-28976), INT16_C( 10001)),
      simde_mm256_set_epi16(INT16_C( 13883), INT16_C( 24989), INT16_C(-27634), INT16_C( 20264),
                            INT16_C( 15739), INT16_C(-13782), INT16_C( -2125), INT16_C(-14153),
                            INT16_C( -5381), INT16_C(-18938), INT16_C(-15901), INT16_C( -7111),
                            INT16_C(-11138), INT16_C( 23506), INT16_C( -6177), INT16_C(-29557)),
      simde_mm256_set_epi16(INT16_C(   975), INT16_C(  9637), INT16_C( 28031), INT16_C( 31395),
                            INT16_C(  2684), INT16_C( 13185), INT16_C(-25182), INT16_C(  6156),
                            INT16_C(-17930), INT16_C( 26231), INT16_C( -9169), INT16_C(-14964),
                            INT16_C( 30475), INT16_C( 19787), INT16_C( 30383), INT16_C(-19556)) },
    { simde_mm256_set_epi16(INT16_C(-20529), INT16_C(-26039), INT16_C( 27693), INT16_C(-13325),
                            INT16_C(-24443), INT16_C(-32106), INT16_C(-21283), INT16_C( -3709),
                            INT16_C(   747), INT16_C( 18820), INT16_C(-26624), INT16_C( 10967),
                            INT16_C( 25066), INT16_C( 19698), INT16_C(-32202), INT16_C(-11757)),
      simde_mm256_set_epi16(INT16_C( 10244), INT16_C(-18450), INT16_C(  5048), INT16_C( -3511),
                            INT16_C(-16723), INT16_C(-30842), INT16_C( 22572), INT16_C( -8065),
                            INT16_C( 30703), INT16_C(-26965), INT16_C( 23628), INT16_C(-27177),
                            INT16_C(-17808), INT16_C(-15958), INT16_C( 15529), INT16_C( 11766)),
      simde_mm256_set_epi16(INT16_C(-10285), INT16_C( 21047), INT16_C( 32741), INT16_C(-16836),
                            INT16_C( 24370), INT16_C(  2588), INT16_C(  1289), INT16_C(-11774),
                            INT16_C( 31450), INT16_C( -8145), INT16_C( -2996), INT16_C(-16210),
                            INT16_C(  7258), INT16_C(  3740), INT16_C(-16673), INT16_C(     9)) },
    { simde_mm256_set_epi16(INT16_C( 20347), INT16_C( 23946), INT16_C( 24055), INT16_C(  9643),
                            INT16_C( -2110), INT16_C(-31092), INT16_C(-13787), INT16_C( -6302),
                            INT16_C(  1396), INT16_C(  8481), INT16_C(-32148), INT16_C( 29268),
                            INT16_C( -9419), INT16_C( -3935), INT16_C( -1720), INT16_C(-10026)),
      simde_mm256_set_epi16(INT16_C( 15679), INT16_C( -2155), INT16_C( 32033), INT16_C( -2216),
                            INT16_C(-11561), INT16_C( 32737), INT16_C(-28164), INT16_C(  9867),
                            INT16_C( 17610), INT16_C(-22692), INT16_C(-28058), INT16_C(  7040),
                            INT16_C( 26754), INT16_C( -3306), INT16_C( -7351), INT16_C( 27370)),
      simde_mm256_set_epi16(INT16_C(-29510), INT16_C( 21791), INT16_C( -9448), INT16_C(  7427),
                            INT16_C(-13671), INT16_C(  1645), INT16_C( 23585), INT16_C(  3565),
                            INT16_C( 19006), INT16_C(-14211), INT16_C(  5330), INT16_C(-29228),
                            INT16_C( 17335), INT16_C( -7241), INT16_C( -9071), INT16_C( 17344)) },
    { simde_mm256_set_epi16(INT16_C(-27154), INT16_C(-23947), INT16_C(  1952), INT16_C(  7823),
                            INT16_C( 29492), INT16_C( -6766), INT16_C( 11046), INT16_C( 22007),
                            INT16_C( 15625), INT16_C( -6212), INT16_C( 31802), INT16_C( 17826),
                            INT16_C( 14647), INT16_C( 24188), INT16_C(-26765), INT16_C( 18766)),
      simde_mm256_set_epi16(INT16_C(-26373), INT16_C( 11481), INT16_C(-29646), INT16_C(-31758),
                            INT16_C(-13826), INT16_C( 16818), INT16_C( -2585), INT16_C(  3549),
                            INT16_C(   930), INT16_C(-29705), INT16_C(-19505), INT16_C(-18939),
                            INT16_C(-22195), INT16_C(  6794), INT16_C(  4204), INT16_C( 28707)),
      simde_mm256_set_epi16(INT16_C( 12009), INT16_C(-12466), INT16_C(-27694), INT16_C(-23935),
                            INT16_C( 15666), INT16_C( 10052), INT16_C(  8461), INT16_C( 25556),
                            INT16_C( 16555), INT16_C( 29619), INT16_C( 12297), INT16_C( -1113),
                            INT16_C( -7548), INT16_C( 30982), INT16_C(-22561), INT16_C(-18063)) },
    { simde_mm256_set_epi16(INT16_C( 30710), INT16_C( 24751), INT16_C( -4369), INT16_C( 18532),
                            INT16_C( 22682), INT16_C( 30280), INT16_C( 11292), INT16_C( 11710),
                            INT16_C(-17556), INT16_C( 10009), INT16_C(-27333), INT16_C( 22196),
                            INT16_C(-19056), INT16_C( -7837), INT16_C( 29666), INT16_C(  6547)),
      simde_mm256_set_epi16(INT16_C( -2566), INT16_C(  5814), INT16_C( 26818), INT16_C( 27091),
                            INT16_C(-10234), INT16_C( 23509), INT16_C( 13267), INT16_C( -7338),
                            INT16_C( 13949), INT16_C(  1472), INT16_C( 11063), INT16_C( -7215),
                            INT16_C( -8090), INT16_C(-23785), INT16_C(-15335), INT16_C(  4848)),
      simde_mm256_set_epi16(INT16_C( 28144), INT16_C( 30565), INT16_C( 22449), INT16_C(-19913),
                            INT16_C( 12448), INT16_C(-11747), INT16_C( 24559), INT16_C(  4372),
                            INT16_C( -3607), INT16_C( 11481), INT16_C(-16270), INT16_C( 14981),
                            INT16_C(-27146), INT16_C(-31622), INT16_C( 14331), INT16_C( 11395)) },
    { simde_mm256_set_epi16(INT16_C( 30207), INT16_C(-18325), INT16_C(  1180), INT16_C(-26389),
                            INT16_C( 14745), INT16_C(  7441), INT16_C(-23138), INT16_C(-20960),
                            INT16_C( 16686), INT16_C(-12834), INT16_C( -5724), INT16_C(  1237),
                            INT16_C( 12783), INT16_C( -1549), INT16_C(  7604), INT16_C(-25399)),
      simde_mm256_set_epi16(INT16_C( -5331), INT16_C(-23526), INT16_C( 14670), INT16_C(-15592),
                            INT16_C( 18159), INT16_C(  4760), INT16_C( 10369), INT16_C(-25724),
                            INT16_C(-28583), INT16_C( -6941), INT16_C(-17844), INT16_C(-14094),
                            INT16_C( 16769), INT16_C( 12540), INT16_C(-26071), INT16_C(  8463)),
      simde_mm256_set_epi16(INT16_C( 24876), INT16_C( 23685), INT16_C( 15850), INT16_C( 23555),
                            INT16_C(-32632), INT16_C( 12201), INT16_C(-12769), INT16_C( 18852),
                            INT16_C(-11897), INT16_C(-19775), INT16_C(-23568), INT16_C(-12857),
                            INT16_C( 29552), INT16_C( 10991), INT16_C(-18467), INT16_C(-16936)) },
    { simde_mm256_set_epi16(INT16_C( 28357), INT16_C( 20172), INT16_C( 17421), INT16_C(-11866),
                            INT16_C(-11434), INT16_C( 24363), INT16_C( 30807), INT16_C( -1507),
                            INT16_C(-31442), INT16_C( 25409), INT16_C( 25186), INT16_C( 22807),
                            INT16_C(-13333), INT16_C(-32257), INT16_C(-15570), INT16_C(  2752)),
      simde_mm256_set_epi16(INT16_C(-19799), INT16_C(-19809), INT16_C(-16948), INT16_C( -1715),
                            INT16_C( 29345), INT16_C(-32027), INT16_C(  5007), INT16_C(  4903),
                            INT16_C( -2392), INT16_C(-30038), INT16_C( 23207), INT16_C(-24060),
                            INT16_C( 29275), INT16_C( 13317), INT16_C( 26431), INT16_C( 23940)),
      simde_mm256_set_epi16(INT16_C(  8558), INT16_C(   363), INT16_C(   473), INT16_C(-13581),
                            INT16_C( 17911), INT16_C( -7664), INT16_C(-29722), INT16_C(  3396),
                            INT16_C( 31702), INT16_C( -4629), INT16_C(-17143), INT16_C( -1253),
                            INT16_C( 15942), INT16_C(-18940), INT16_C( 10861), INT16_C( 26692)) },
    { simde_mm256_set_epi16(INT16_C(  6003), INT16_C( 21193), INT16_C( 27446), INT16_C( 12164),
                            INT16_C(-15839), INT16_C(-27621), INT16_C( 27366), INT16_C(  3166),
                            INT16_C(-14586), INT16_C( 16192), INT16_C( 17380), INT16_C(  2397),
                            INT16_C( 17243), INT16_C(  7969), INT16_C(-18393), INT16_C(-28306)),
      simde_mm256_set_epi16(INT16_C( -9798), INT16_C(  1801), INT16_C(-11340), INT16_C(-25270),
                            INT16_C( -7120), INT16_C( -2660), INT16_C( 23941), INT16_C( 18110),
                            INT16_C( -3348), INT16_C( -5762), INT16_C( 30271), INT16_C(  3473),
                            INT16_C( -7979), INT16_C( -3070), INT16_C( 12208), INT16_C( 30362)),
      simde_mm256_set_epi16(INT16_C( -3795), INT16_C( 22994), INT16_C( 16106), INT16_C(-13106),
                            INT16_C(-22959), INT16_C(-30281), INT16_C(-14229), INT16_C( 21276),
                            INT16_C(-17934), INT16_C( 10430), INT16_C(-17885), INT16_C(  5870),
                            INT16_C(  9264), INT16_C(  4899), INT16_C( -6185), INT16_C(  2056)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_add_epi16(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_add_epi32(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi32(INT32_C( 1102687755), INT32_C( 1275949869), INT32_C( -388043296), INT32_C( 1616523445),
                            INT32_C( -312991452), INT32_C(-1980926618), INT32_C( 1274012126), INT32_C(  -45808693)),
      simde_mm256_set_epi32(INT32_C(-1821401638), INT32_C( 1143218625), INT32_C(-1072188421), INT32_C( -228883992),
                            INT32_C( 1453787917), INT32_C(-1686415046), INT32_C(-1856178723), INT32_C(-1344248495)),
      simde_mm256_set_epi32(INT32_C( -718713883), INT32_C(-1875798802), INT32_C(-1460231717), INT32_C( 1387639453),
                            INT32_C( 1140796465), INT32_C(  627625632), INT32_C( -582166597), INT32_C(-1390057188)) },
    { simde_mm256_set_epi32(INT32_C( -511556352), INT32_C(  512138684), INT32_C( 2115720361), INT32_C( -345092241),
                            INT32_C( -115713034), INT32_C( 1435785542), INT32_C( -578341737), INT32_C(  626663856)),
      simde_mm256_set_epi32(INT32_C( 1905028737), INT32_C(  164639990), INT32_C(-1952346601), INT32_C( 1853095591),
                            INT32_C(-1825217200), INT32_C(-1102744367), INT32_C(-1105586227), INT32_C(-1908622941)),
      simde_mm256_set_epi32(INT32_C( 1393472385), INT32_C(  676778674), INT32_C(  163373760), INT32_C( 1508003350),
                            INT32_C(-1940930234), INT32_C(  333041175), INT32_C(-1683927964), INT32_C(-1281959085)) },
    { simde_mm256_set_epi32(INT32_C(  841608097), INT32_C(-2001797484), INT32_C(-1658305288), INT32_C(  966942303),
                            INT32_C(  842108123), INT32_C(  697774066), INT32_C(-1273233002), INT32_C( -331057125)),
      simde_mm256_set_epi32(INT32_C(  824745259), INT32_C( 1162513122), INT32_C( 1536105364), INT32_C( 1572988069),
                            INT32_C( 1601630355), INT32_C(  105174023), INT32_C( -548723565), INT32_C(  342919548)),
      simde_mm256_set_epi32(INT32_C( 1666353356), INT32_C( -839284362), INT32_C( -122199924), INT32_C(-1755036924),
                            INT32_C(-1851228818), INT32_C(  802948089), INT32_C(-1821956567), INT32_C(   11862423)) },
    { simde_mm256_set_epi32(INT32_C(-1982661498), INT32_C( -454967885), INT32_C( 1606399367), INT32_C( 1911771725),
                            INT32_C( -320200723), INT32_C( 2055189331), INT32_C( 1782567162), INT32_C(  617047003)),
      simde_mm256_set_epi32(INT32_C(-1988185598), INT32_C( 1350171177), INT32_C( -741176174), INT32_C( 1024642864),
                            INT32_C( 1174775607), INT32_C(-1489493977), INT32_C( 2114610376), INT32_C(-1150946108)),
      simde_mm256_set_epi32(INT32_C(  324120200), INT32_C(  895203292), INT32_C(  865223193), INT32_C(-1358552707),
                            INT32_C(  854574884), INT32_C(  565695354), INT32_C( -397789758), INT32_C( -533899105)) },
    { simde_mm256_set_epi32(INT32_C(-1636237507), INT32_C(-2022044523), INT32_C( 1298417038), INT32_C( -498789244),
                            INT32_C(-1120565370), INT32_C(  -10552717), INT32_C( 1267811859), INT32_C( 1736112342)),
      simde_mm256_set_epi32(INT32_C(   30746202), INT32_C( 1464439343), INT32_C( 1694184093), INT32_C(-1066802952),
                            INT32_C( -664495133), INT32_C(-2016253412), INT32_C(-1975304715), INT32_C(  -70672826)),
      simde_mm256_set_epi32(INT32_C(-1605491305), INT32_C( -557605180), INT32_C(-1302366165), INT32_C(-1565592196),
                            INT32_C(-1785060503), INT32_C(-2026806129), INT32_C( -707492856), INT32_C( 1665439516)) },
    { simde_mm256_set_epi32(INT32_C(  289000373), INT32_C( 1573632519), INT32_C(  -39248751), INT32_C( -989305129),
                            INT32_C( -946333511), INT32_C( -275686449), INT32_C(  -98660627), INT32_C(-1519479102)),
      simde_mm256_set_epi32(INT32_C(  297476793), INT32_C(  436731799), INT32_C(  124294563), INT32_C(-1635813332),
                            INT32_C(  263383074), INT32_C( -533172755), INT32_C( 1125990821), INT32_C( -786980387)),
      simde_mm256_set_epi32(INT32_C(  586477166), INT32_C( 2010364318), INT32_C(   85045812), INT32_C( 1669848835),
                            INT32_C( -682950437), INT32_C( -808859204), INT32_C( 1027330194), INT32_C( 1988507807)) },
    { simde_mm256_set_epi32(INT32_C(  518182194), INT32_C(-1204047142), INT32_C(  -66070725), INT32_C(  499109808),
                            INT32_C(-2041576579), INT32_C( -621515360), INT32_C(  566201077), INT32_C(  301667364)),
      simde_mm256_set_epi32(INT32_C(-1846226401), INT32_C(-1479610627), INT32_C( -205605694), INT32_C( 2074175879),
                            INT32_C(  797873427), INT32_C(  232260429), INT32_C( 2122451120), INT32_C(-1502060759)),
      simde_mm256_set_epi32(INT32_C(-1328044207), INT32_C( 1611309527), INT32_C( -271676419), INT32_C(-1721681609),
                            INT32_C(-1243703152), INT32_C( -389254931), INT32_C(-1606315099), INT32_C(-1200393395)) },
    { simde_mm256_set_epi32(INT32_C(  405834501), INT32_C(-1910761465), INT32_C(  957239954), INT32_C( -786856288),
                            INT32_C(  843920617), INT32_C(  327146567), INT32_C( -333483012), INT32_C(-1269489720)),
      simde_mm256_set_epi32(INT32_C( -343554450), INT32_C( -768698719), INT32_C(-1629325598), INT32_C(  -86112156),
                            INT32_C(-1762054840), INT32_C(-1230219631), INT32_C(-1955142376), INT32_C(  681367456)),
      simde_mm256_set_epi32(INT32_C(   62280051), INT32_C( 1615507112), INT32_C( -672085644), INT32_C( -872968444),
                            INT32_C( -918134223), INT32_C( -903073064), INT32_C( 2006341908), INT32_C( -588122264)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_add_epi32(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_add_epi64(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi64x(INT64_C( -919395005897301486), INT64_C( -150854599157471417),
                             INT64_C( 8808382520295569970), INT64_C(-2573562509116397532)),
      simde_mm256_set_epi64x(INT64_C( 3276842246935198107), INT64_C(  509596195322373870),
                             INT64_C( 5497236691336464382), INT64_C( 7792219835689675301)),
      simde_mm256_set_epi64x(INT64_C( 2357447241037896621), INT64_C(  358741596164902453),
                             INT64_C(-4141124862077517264), INT64_C( 5218657326573277769)) },
    { simde_mm256_set_epi64x(INT64_C(-8319032728400165160), INT64_C( 5761166475766138642),
                             INT64_C( 1889840457419449714), INT64_C(-7866468136110945528)),
      simde_mm256_set_epi64x(INT64_C(-7943707797090752726), INT64_C(-3031420544278169311),
                             INT64_C( -274806827926037798), INT64_C(-6305854756278616306)),
      simde_mm256_set_epi64x(INT64_C( 2184003548218633730), INT64_C( 2729745931487969331),
                             INT64_C( 1615033629493411916), INT64_C( 4274421181319989782)) },
    { simde_mm256_set_epi64x(INT64_C( 5895960517559859999), INT64_C( 6208968053276251170),
                             INT64_C( 7761614749466428803), INT64_C(-6998556565488043930)),
      simde_mm256_set_epi64x(INT64_C(-7645095141522766353), INT64_C( 7326575676453958933),
                             INT64_C( 1354311398343021783), INT64_C( 5074528974494991107)),
      simde_mm256_set_epi64x(INT64_C(-1749134623962906354), INT64_C(-4911200343979341513),
                             INT64_C( 9115926147809450586), INT64_C(-1924027590993052823)) },
    { simde_mm256_set_epi64x(INT64_C( 7265152682832433510), INT64_C(-3085894531646767861),
                             INT64_C(-9131129251692740054), INT64_C(  -13949299420174832)),
      simde_mm256_set_epi64x(INT64_C(-8945299951793325147), INT64_C( 1105999600596947619),
                             INT64_C( 1005965954309535795), INT64_C( 6577596548744990052)),
      simde_mm256_set_epi64x(INT64_C(-1680147268960891637), INT64_C(-1979894931049820242),
                             INT64_C(-8125163297383204259), INT64_C( 6563647249324815220)) },
    { simde_mm256_set_epi64x(INT64_C(-1757821625677084255), INT64_C(-2404608367637526264),
                             INT64_C(  707296317246937957), INT64_C(-8620111396460581683)),
      simde_mm256_set_epi64x(INT64_C(-3596883371125205809), INT64_C( 2676371285603083419),
                             INT64_C( 6821095199901887872), INT64_C(-7512247745220049837)),
      simde_mm256_set_epi64x(INT64_C(-5354704996802290064), INT64_C(  271762917965557155),
                             INT64_C( 7528391517148825829), INT64_C( 2314384932028920096)) },
    { simde_mm256_set_epi64x(INT64_C( 6839811261830973327), INT64_C( 5631394124827236824),
                             INT64_C(-5955019407573777834), INT64_C(-3458836099791348328)),
      simde_mm256_set_epi64x(INT64_C( 7744082525445212477), INT64_C(-8800502010596219205),
                             INT64_C(  384951712332227405), INT64_C(  430518285591300198)),
      simde_mm256_set_epi64x(INT64_C(-3862850286433365812), INT64_C(-3169107885768982381),
                             INT64_C(-5570067695241550429), INT64_C(-3028317814200048130)) },
    { simde_mm256_set_epi64x(INT64_C(-3472881623031498101), INT64_C(-1430648476837955016),
                             INT64_C(-3715397159055217239), INT64_C( 5273106926976979674)),
      simde_mm256_set_epi64x(INT64_C(-4550310691059172162), INT64_C( 3088580064706171589),
                             INT64_C( 5815698628016314327), INT64_C(-8735000016575196569)),
      simde_mm256_set_epi64x(INT64_C(-8023192314090670263), INT64_C( 1657931587868216573),
                             INT64_C( 2100301468961097088), INT64_C(-3461893089598216895)) },
    { simde_mm256_set_epi64x(INT64_C(-8609934348254886079), INT64_C( 4626495260054383935),
                             INT64_C(-1742895605763712389), INT64_C( 8190624861564512538)),
      simde_mm256_set_epi64x(INT64_C(-1653872282243675761), INT64_C(-8277823144431279152),
                             INT64_C( 5269960775097450688), INT64_C( 3526432474948394359)),
      simde_mm256_set_epi64x(INT64_C( 8182937443210989776), INT64_C(-3651327884376895217),
                             INT64_C( 3527065169333738299), INT64_C(-6729686737196644719)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_add_epi64(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i64(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_alignr_epi8_case0(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi8(INT8_C(  57), INT8_C( -47), INT8_C( -81), INT8_C( -95),
                           INT8_C(-100), INT8_C( -69), INT8_C( -75), INT8_C(-127),
                           INT8_C(  -8), INT8_C( -83), INT8_C( -94), INT8_C(-113),
                           INT8_C( 107), INT8_C( -39), INT8_C( -99), INT8_C(  46),
                           INT8_C( -61), INT8_C( -72), INT8_C(  -5), INT8_C(-126),
                           INT8_C( 113), INT8_C(-120), INT8_C(  -9), INT8_C( 117),
                           INT8_C( 121), INT8_C( -14), INT8_C( -58), INT8_C(-118),
                           INT8_C( -70), INT8_C( -35), INT8_C(-100), INT8_C(  48)),
      simde_mm256_set_epi8(INT8_C( -98), INT8_C(  80), INT8_C( -16), INT8_C(  73),
                           INT8_C( 126), INT8_C(-115), INT8_C(  31), INT8_C(  80),
                           INT8_C( -75), INT8_C( 117), INT8_C( -13), INT8_C( -70),
                           INT8_C(-101), INT8_C( -10), INT8_C(-111), INT8_C(  96),
                           INT8_C( -77), INT8_C(   0), INT8_C(  70), INT8_C(-121),
                           INT8_C(  78), INT8_C(  54), INT8_C(  38), INT8_C(  18),
                           INT8_C( -12), INT8_C(  68), INT8_C(  53), INT8_C(  45),
                           INT8_C(  77), INT8_C( 103), INT8_C( 118), INT8_C( 116)),
      simde_mm256_set_epi8(INT8_C( -39), INT8_C( -99), INT8_C(  46), INT8_C( -98),
                           INT8_C(  80), INT8_C( -16), INT8_C(  73), INT8_C( 126),
                           INT8_C(-115), INT8_C(  31), INT8_C(  80), INT8_C( -75),
                           INT8_C( 117), INT8_C( -13), INT8_C( -70), INT8_C(-101),
                           INT8_C( -35), INT8_C(-100), INT8_C(  48), INT8_C( -77),
                           INT8_C(   0), INT8_C(  70), INT8_C(-121), INT8_C(  78),
                           INT8_C(  54), INT8_C(  38), INT8_C(  18), INT8_C( -12),
                           INT8_C(  68), INT8_C(  53), INT8_C(  45), INT8_C(  77)) },
    { simde_mm256_set_epi8(INT8_C(   8), INT8_C(  70), INT8_C(  96), INT8_C(  42),
                           INT8_C(  73), INT8_C( -91), INT8_C( -93), INT8_C( -58),
                           INT8_C( -35), INT8_C( -14), INT8_C( 118), INT8_C(-128),
                           INT8_C( -97), INT8_C(  97), INT8_C(  22), INT8_C(   4),
                           INT8_C(  24), INT8_C( 124), INT8_C( -32), INT8_C( -48),
                           INT8_C( -74), INT8_C(  95), INT8_C(  95), INT8_C( -38),
                           INT8_C(  54), INT8_C( 120), INT8_C( -65), INT8_C( -96),
                           INT8_C( -44), INT8_C( -78), INT8_C( -95), INT8_C(-111)),
      simde_mm256_set_epi8(INT8_C(  66), INT8_C(  48), INT8_C(  60), INT8_C(  -4),
                           INT8_C(  33), INT8_C(  67), INT8_C(  97), INT8_C(  65),
                           INT8_C(  80), INT8_C(-109), INT8_C(  88), INT8_C( -23),
                           INT8_C( 107), INT8_C( -65), INT8_C( -65), INT8_C(  62),
                           INT8_C(  90), INT8_C( 118), INT8_C(  25), INT8_C( 105),
                           INT8_C( 109), INT8_C( -45), INT8_C(   4), INT8_C(-107),
                           INT8_C(  55), INT8_C(-101), INT8_C( -65), INT8_C( 121),
                           INT8_C( -76), INT8_C(  55), INT8_C(   6), INT8_C(  86)),
      simde_mm256_set_epi8(INT8_C(  97), INT8_C(  22), INT8_C(   4), INT8_C(  66),
                           INT8_C(  48), INT8_C(  60), INT8_C(  -4), INT8_C(  33),
                           INT8_C(  67), INT8_C(  97), INT8_C(  65), INT8_C(  80),
                           INT8_C(-109), INT8_C(  88), INT8_C( -23), INT8_C( 107),
                           INT8_C( -78), INT8_C( -95), INT8_C(-111), INT8_C(  90),
                           INT8_C( 118), INT8_C(  25), INT8_C( 105), INT8_C( 109),
                           INT8_C( -45), INT8_C(   4), INT8_C(-107), INT8_C(  55),
                           INT8_C(-101), INT8_C( -65), INT8_C( 121), INT8_C( -76)) },
    { simde_mm256_set_epi8(INT8_C(  -1), INT8_C(  93), INT8_C( 114), INT8_C(  49),
                           INT8_C( 120), INT8_C( -70), INT8_C(-112), INT8_C(  19),
                           INT8_C(  56), INT8_C( -12), INT8_C( -77), INT8_C( -85),
                           INT8_C( -59), INT8_C(  80), INT8_C( -47), INT8_C( -28),
                           INT8_C( -33), INT8_C(  73), INT8_C( -24), INT8_C(-106),
                           INT8_C(-122), INT8_C(-111), INT8_C(  -3), INT8_C(  57),
                           INT8_C(  67), INT8_C( 107), INT8_C( -68), INT8_C(-101),
                           INT8_C(  -9), INT8_C(   5), INT8_C(-124), INT8_C( -69)),
      simde_mm256_set_epi8(INT8_C( -67), INT8_C(  65), INT8_C( -72), INT8_C( -90),
                           INT8_C( -44), INT8_C(   2), INT8_C(  39), INT8_C( -45),
                           INT8_C(  51), INT8_C( -30), INT8_C( -47), INT8_C(   1),
                           INT8_C( -91), INT8_C( -40), INT8_C( -73), INT8_C(  33),
                           INT8_C(-117), INT8_C( -31), INT8_C(-117), INT8_C(  60),
                           INT8_C( -36), INT8_C(-120), INT8_C( -10), INT8_C( -12),
                           INT8_C( -25), INT8_C(-103), INT8_C(  48), INT8_C( -50),
                           INT8_C( 101), INT8_C(  93), INT8_C( -31), INT8_C( -33)),
      simde_mm256_set_epi8(INT8_C(  80), INT8_C( -47), INT8_C( -28), INT8_C( -67),
                           INT8_C(  65), INT8_C( -72), INT8_C( -90), INT8_C( -44),
                           INT8_C(   2), INT8_C(  39), INT8_C( -45), INT8_C(  51),
                           INT8_C( -30), INT8_C( -47), INT8_C(   1), INT8_C( -91),
                           INT8_C(   5), INT8_C(-124), INT8_C( -69), INT8_C(-117),
                           INT8_C( -31), INT8_C(-117), INT8_C(  60), INT8_C( -36),
                           INT8_C(-120), INT8_C( -10), INT8_C( -12), INT8_C( -25),
                           INT8_C(-103), INT8_C(  48), INT8_C( -50), INT8_C( 101)) },
    { simde_mm256_set_epi8(INT8_C( 114), INT8_C( -28), INT8_C( -81), INT8_C(-126),
                           INT8_C(-114), INT8_C( -94), INT8_C(-101), INT8_C(  52),
                           INT8_C(  30), INT8_C(  66), INT8_C(-105), INT8_C(  50),
                           INT8_C(  48), INT8_C(  15), INT8_C(   1), INT8_C(-106),
                           INT8_C( -36), INT8_C(  61), INT8_C( -18), INT8_C(   8),
                           INT8_C(  89), INT8_C( -23), INT8_C(  58), INT8_C( -29),
                           INT8_C( 110), INT8_C(  57), INT8_C( -39), INT8_C(   1),
                           INT8_C( -60), INT8_C(  60), INT8_C( -80), INT8_C( -20)),
      simde_mm256_set_epi8(INT8_C( -60), INT8_C(  69), INT8_C( -69), INT8_C( 107),
                           INT8_C(   2), INT8_C( -33), INT8_C(  14), INT8_C(  77),
                           INT8_C(  15), INT8_C(  63), INT8_C(  63), INT8_C( -53),
                           INT8_C(  -9), INT8_C(  76), INT8_C(   7), INT8_C( -76),
                           INT8_C( -23), INT8_C(-107), INT8_C(  84), INT8_C(  37),
                           INT8_C( -18), INT8_C(  47), INT8_C(  58), INT8_C(  31),
                           INT8_C(  69), INT8_C(  12), INT8_C(  46), INT8_C( 101),
                           INT8_C( -38), INT8_C( 117), INT8_C(-113), INT8_C( -36)),
      simde_mm256_set_epi8(INT8_C(  15), INT8_C(   1), INT8_C(-106), INT8_C( -60),
                           INT8_C(  69), INT8_C( -69), INT8_C( 107), INT8_C(   2),
                           INT8_C( -33), INT8_C(  14), INT8_C(  77), INT8_C(  15),
                           INT8_C(  63), INT8_C(  63), INT8_C( -53), INT8_C(  -9),
                           INT8_C(  60), INT8_C( -80), INT8_C( -20), INT8_C( -23),
                           INT8_C(-107), INT8_C(  84), INT8_C(  37), INT8_C( -18),
                           INT8_C(  47), INT8_C(  58), INT8_C(  31), INT8_C(  69),
                           INT8_C(  12), INT8_C(  46), INT8_C( 101), INT8_C( -38)) },
    { simde_mm256_set_epi8(INT8_C(  13), INT8_C( -32), INT8_C( -51), INT8_C(  49),
                           INT8_C(  15), INT8_C(  15), INT8_C( -66), INT8_C( -38),
                           INT8_C(  69), INT8_C(   1), INT8_C( -50), INT8_C(-103),
                           INT8_C(  72), INT8_C( -87), INT8_C(-104), INT8_C( -58),
                           INT8_C(  63), INT8_C(-120), INT8_C(  36), INT8_C( -61),
                           INT8_C( 106), INT8_C(  97), INT8_C(-128), INT8_C(  26),
                           INT8_C(-121), INT8_C( -27), INT8_C( 107), INT8_C(-112),
                           INT8_C(  57), INT8_C(  39), INT8_C(  98), INT8_C( 126)),
      simde_mm256_set_epi8(INT8_C(-110), INT8_C(  50), INT8_C( 102), INT8_C( -85),
                           INT8_C( -62), INT8_C(  74), INT8_C( 102), INT8_C(  36),
                           INT8_C( -55), INT8_C(-104), INT8_C(  11), INT8_C( -70),
                           INT8_C( -20), INT8_C(-104), INT8_C( -37), INT8_C( 122),
                           INT8_C( -88), INT8_C(  70), INT8_C(  43), INT8_C( -34),
                           INT8_C(  14), INT8_C(  55), INT8_C( -41), INT8_C(  33),
                           INT8_C(  53), INT8_C(-102), INT8_C(  56), INT8_C(  26),
                           INT8_C( -79), INT8_C( -30), INT8_C(  73), INT8_C( -53)),
      simde_mm256_set_epi8(INT8_C( -87), INT8_C(-104), INT8_C( -58), INT8_C(-110),
                           INT8_C(  50), INT8_C( 102), INT8_C( -85), INT8_C( -62),
                           INT8_C(  74), INT8_C( 102), INT8_C(  36), INT8_C( -55),
                           INT8_C(-104), INT8_C(  11), INT8_C( -70), INT8_C( -20),
                           INT8_C(  39), INT8_C(  98), INT8_C( 126), INT8_C( -88),
                           INT8_C(  70), INT8_C(  43), INT8_C( -34), INT8_C(  14),
                           INT8_C(  55), INT8_C( -41), INT8_C(  33), INT8_C(  53),
                           INT8_C(-102), INT8_C(  56), INT8_C(  26), INT8_C( -79)) },
    { simde_mm256_set_epi8(INT8_C(-103), INT8_C(  23), INT8_C( -90), INT8_C(  43),
                           INT8_C(  -8), INT8_C(  54), INT8_C( -93), INT8_C(  64),
                           INT8_C(-116), INT8_C( -76), INT8_C( -53), INT8_C(  35),
                           INT8_C(  51), INT8_C( -86), INT8_C(   8), INT8_C(  43),
                           INT8_C( -60), INT8_C(-113), INT8_C(  44), INT8_C(-102),
                           INT8_C(  77), INT8_C(  95), INT8_C(  57), INT8_C( 124),
                           INT8_C( -91), INT8_C( -87), INT8_C( -54), INT8_C( -83),
                           INT8_C( 108), INT8_C(  76), INT8_C(  90), INT8_C( -49)),
      simde_mm256_set_epi8(INT8_C( -43), INT8_C(  -5), INT8_C(  94), INT8_C(  76),
                           INT8_C(  -9), INT8_C( 110), INT8_C( -82), INT8_C( 112),
                           INT8_C( -25), INT8_C(  11), INT8_C( -46), INT8_C( -57),
                           INT8_C( -13), INT8_C(-127), INT8_C(  10), INT8_C(-113),
                           INT8_C(  55), INT8_C(  85), INT8_C(  75), INT8_C(  61),
                           INT8_C(  49), INT8_C( -14), INT8_C(  44), INT8_C(-128),
                           INT8_C(-102), INT8_C( -17), INT8_C(  64), INT8_C( -73),
                           INT8_C(  14), INT8_C(  19), INT8_C(  -2), INT8_C(   7)),
      simde_mm256_set_epi8(INT8_C( -86), INT8_C(   8), INT8_C(  43), INT8_C( -43),
                           INT8_C(  -5), INT8_C(  94), INT8_C(  76), INT8_C(  -9),
                           INT8_C( 110), INT8_C( -82), INT8_C( 112), INT8_C( -25),
                           INT8_C(  11), INT8_C( -46), INT8_C( -57), INT8_C( -13),
                           INT8_C(  76), INT8_C(  90), INT8_C( -49), INT8_C(  55),
                           INT8_C(  85), INT8_C(  75), INT8_C(  61), INT8_C(  49),
                           INT8_C( -14), INT8_C(  44), INT8_C(-128), INT8_C(-102),
                           INT8_C( -17), INT8_C(  64), INT8_C( -73), INT8_C(  14)) },
    { simde_mm256_set_epi8(INT8_C( -32), INT8_C( -82), INT8_C(  79), INT8_C(  79),
                           INT8_C( 127), INT8_C(  16), INT8_C(-118), INT8_C( 113),
                           INT8_C( -52), INT8_C( -25), INT8_C(-124), INT8_C( -77),
                           INT8_C( 114), INT8_C(-118), INT8_C( -84), INT8_C(  73),
                           INT8_C( -12), INT8_C( -67), INT8_C(-127), INT8_C( -69),
                           INT8_C(  30), INT8_C(  14), INT8_C( -47), INT8_C(-119),
                           INT8_C( -36), INT8_C( -97), INT8_C( -89), INT8_C(  24),
                           INT8_C( -41), INT8_C( 117), INT8_C(-102), INT8_C(  54)),
      simde_mm256_set_epi8(INT8_C( -66), INT8_C( -50), INT8_C(  39), INT8_C(  30),
                           INT8_C(  53), INT8_C( 108), INT8_C( -71), INT8_C( -62),
                           INT8_C(  58), INT8_C( -69), INT8_C( -39), INT8_C( -28),
                           INT8_C(  58), INT8_C(  54), INT8_C(-117), INT8_C( -49),
                           INT8_C( 126), INT8_C( -71), INT8_C( -39), INT8_C(-120),
                           INT8_C(  88), INT8_C(  41), INT8_C( 127), INT8_C( 111),
                           INT8_C( -32), INT8_C( -18), INT8_C(  12), INT8_C(  97),
                           INT8_C(  83), INT8_C( -96), INT8_C(  13), INT8_C(-101)),
      simde_mm256_set_epi8(INT8_C(-118), INT8_C( -84), INT8_C(  73), INT8_C( -66),
                           INT8_C( -50), INT8_C(  39), INT8_C(  30), INT8_C(  53),
                           INT8_C( 108), INT8_C( -71), INT8_C( -62), INT8_C(  58),
                           INT8_C( -69), INT8_C( -39), INT8_C( -28), INT8_C(  58),
                           INT8_C( 117), INT8_C(-102), INT8_C(  54), INT8_C( 126),
                           INT8_C( -71), INT8_C( -39), INT8_C(-120), INT8_C(  88),
                           INT8_C(  41), INT8_C( 127), INT8_C( 111), INT8_C( -32),
                           INT8_C( -18), INT8_C(  12), INT8_C(  97), INT8_C(  83)) },
    { simde_mm256_set_epi8(INT8_C(-105), INT8_C(   9), INT8_C( -52), INT8_C(  54),
                           INT8_C( -11), INT8_C( -39), INT8_C( -64), INT8_C( -79),
                           INT8_C(  88), INT8_C(  52), INT8_C( -95), INT8_C( -70),
                           INT8_C(  46), INT8_C( 121), INT8_C( -22), INT8_C( 113),
                           INT8_C(  26), INT8_C( 104), INT8_C( -52), INT8_C( 109),
                           INT8_C(   5), INT8_C(  87), INT8_C(  90), INT8_C(  -7),
                           INT8_C( -35), INT8_C(-112), INT8_C(  20), INT8_C(-128),
                           INT8_C( -21), INT8_C( -67), INT8_C(  37), INT8_C( -35)),
      simde_mm256_set_epi8(INT8_C(  66), INT8_C( -23), INT8_C(  45), INT8_C( -38),
                           INT8_C( -94), INT8_C( 119), INT8_C( -23), INT8_C(  70),
                           INT8_C( -75), INT8_C(  25), INT8_C(  79), INT8_C(-101),
                           INT8_C(-122), INT8_C(-107), INT8_C( -10), INT8_C(-109),
                           INT8_C( -96), INT8_C(  45), INT8_C(  31), INT8_C( -60),
                           INT8_C( 100), INT8_C( 115), INT8_C(  79), INT8_C(  38),
                           INT8_C( -35), INT8_C(  57), INT8_C(  13), INT8_C(  93),
                           INT8_C(  54), INT8_C( -61), INT8_C( 101), INT8_C(-113)),
      simde_mm256_set_epi8(INT8_C( 121), INT8_C( -22), INT8_C( 113), INT8_C(  66),
                           INT8_C( -23), INT8_C(  45), INT8_C( -38), INT8_C( -94),
                           INT8_C( 119), INT8_C( -23), INT8_C(  70), INT8_C( -75),
                           INT8_C(  25), INT8_C(  79), INT8_C(-101), INT8_C(-122),
                           INT8_C( -67), INT8_C(  37), INT8_C( -35), INT8_C( -96),
                           INT8_C(  45), INT8_C(  31), INT8_C( -60), INT8_C( 100),
                           INT8_C( 115), INT8_C(  79), INT8_C(  38), INT8_C( -35),
                           INT8_C(  57), INT8_C(  13), INT8_C(  93), INT8_C(  54)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_alignr_epi8(test_vec[i].a, test_vec[i].b, 3);
    simde_assert_m256i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_alignr_epi8_case1(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi8(INT8_C(  57), INT8_C( -47), INT8_C( -81), INT8_C( -95),
                           INT8_C(-100), INT8_C( -69), INT8_C( -75), INT8_C(-127),
                           INT8_C(  -8), INT8_C( -83), INT8_C( -94), INT8_C(-113),
                           INT8_C( 107), INT8_C( -39), INT8_C( -99), INT8_C(  46),
                           INT8_C( -61), INT8_C( -72), INT8_C(  -5), INT8_C(-126),
                           INT8_C( 113), INT8_C(-120), INT8_C(  -9), INT8_C( 117),
                           INT8_C( 121), INT8_C( -14), INT8_C( -58), INT8_C(-118),
                           INT8_C( -70), INT8_C( -35), INT8_C(-100), INT8_C(  48)),
      simde_mm256_set_epi8(INT8_C( -98), INT8_C(  80), INT8_C( -16), INT8_C(  73),
                           INT8_C( 126), INT8_C(-115), INT8_C(  31), INT8_C(  80),
                           INT8_C( -75), INT8_C( 117), INT8_C( -13), INT8_C( -70),
                           INT8_C(-101), INT8_C( -10), INT8_C(-111), INT8_C(  96),
                           INT8_C( -77), INT8_C(   0), INT8_C(  70), INT8_C(-121),
                           INT8_C(  78), INT8_C(  54), INT8_C(  38), INT8_C(  18),
                           INT8_C( -12), INT8_C(  68), INT8_C(  53), INT8_C(  45),
                           INT8_C(  77), INT8_C( 103), INT8_C( 118), INT8_C( 116)),
      simde_mm256_set_epi8(INT8_C( -75), INT8_C(-127), INT8_C(  -8), INT8_C( -83),
                           INT8_C( -94), INT8_C(-113), INT8_C( 107), INT8_C( -39),
                           INT8_C( -99), INT8_C(  46), INT8_C( -98), INT8_C(  80),
                           INT8_C( -16), INT8_C(  73), INT8_C( 126), INT8_C(-115),
                           INT8_C(  -9), INT8_C( 117), INT8_C( 121), INT8_C( -14),
                           INT8_C( -58), INT8_C(-118), INT8_C( -70), INT8_C( -35),
                           INT8_C(-100), INT8_C(  48), INT8_C( -77), INT8_C(   0),
                           INT8_C(  70), INT8_C(-121), INT8_C(  78), INT8_C(  54)) },
    { simde_mm256_set_epi8(INT8_C(   8), INT8_C(  70), INT8_C(  96), INT8_C(  42),
                           INT8_C(  73), INT8_C( -91), INT8_C( -93), INT8_C( -58),
                           INT8_C( -35), INT8_C( -14), INT8_C( 118), INT8_C(-128),
                           INT8_C( -97), INT8_C(  97), INT8_C(  22), INT8_C(   4),
                           INT8_C(  24), INT8_C( 124), INT8_C( -32), INT8_C( -48),
                           INT8_C( -74), INT8_C(  95), INT8_C(  95), INT8_C( -38),
                           INT8_C(  54), INT8_C( 120), INT8_C( -65), INT8_C( -96),
                           INT8_C( -44), INT8_C( -78), INT8_C( -95), INT8_C(-111)),
      simde_mm256_set_epi8(INT8_C(  66), INT8_C(  48), INT8_C(  60), INT8_C(  -4),
                           INT8_C(  33), INT8_C(  67), INT8_C(  97), INT8_C(  65),
                           INT8_C(  80), INT8_C(-109), INT8_C(  88), INT8_C( -23),
                           INT8_C( 107), INT8_C( -65), INT8_C( -65), INT8_C(  62),
                           INT8_C(  90), INT8_C( 118), INT8_C(  25), INT8_C( 105),
                           INT8_C( 109), INT8_C( -45), INT8_C(   4), INT8_C(-107),
                           INT8_C(  55), INT8_C(-101), INT8_C( -65), INT8_C( 121),
                           INT8_C( -76), INT8_C(  55), INT8_C(   6), INT8_C(  86)),
      simde_mm256_set_epi8(INT8_C( -93), INT8_C( -58), INT8_C( -35), INT8_C( -14),
                           INT8_C( 118), INT8_C(-128), INT8_C( -97), INT8_C(  97),
                           INT8_C(  22), INT8_C(   4), INT8_C(  66), INT8_C(  48),
                           INT8_C(  60), INT8_C(  -4), INT8_C(  33), INT8_C(  67),
                           INT8_C(  95), INT8_C( -38), INT8_C(  54), INT8_C( 120),
                           INT8_C( -65), INT8_C( -96), INT8_C( -44), INT8_C( -78),
                           INT8_C( -95), INT8_C(-111), INT8_C(  90), INT8_C( 118),
                           INT8_C(  25), INT8_C( 105), INT8_C( 109), INT8_C( -45)) },
    { simde_mm256_set_epi8(INT8_C(  -1), INT8_C(  93), INT8_C( 114), INT8_C(  49),
                           INT8_C( 120), INT8_C( -70), INT8_C(-112), INT8_C(  19),
                           INT8_C(  56), INT8_C( -12), INT8_C( -77), INT8_C( -85),
                           INT8_C( -59), INT8_C(  80), INT8_C( -47), INT8_C( -28),
                           INT8_C( -33), INT8_C(  73), INT8_C( -24), INT8_C(-106),
                           INT8_C(-122), INT8_C(-111), INT8_C(  -3), INT8_C(  57),
                           INT8_C(  67), INT8_C( 107), INT8_C( -68), INT8_C(-101),
                           INT8_C(  -9), INT8_C(   5), INT8_C(-124), INT8_C( -69)),
      simde_mm256_set_epi8(INT8_C( -67), INT8_C(  65), INT8_C( -72), INT8_C( -90),
                           INT8_C( -44), INT8_C(   2), INT8_C(  39), INT8_C( -45),
                           INT8_C(  51), INT8_C( -30), INT8_C( -47), INT8_C(   1),
                           INT8_C( -91), INT8_C( -40), INT8_C( -73), INT8_C(  33),
                           INT8_C(-117), INT8_C( -31), INT8_C(-117), INT8_C(  60),
                           INT8_C( -36), INT8_C(-120), INT8_C( -10), INT8_C( -12),
                           INT8_C( -25), INT8_C(-103), INT8_C(  48), INT8_C( -50),
                           INT8_C( 101), INT8_C(  93), INT8_C( -31), INT8_C( -33)),
      simde_mm256_set_epi8(INT8_C(-112), INT8_C(  19), INT8_C(  56), INT8_C( -12),
                           INT8_C( -77), INT8_C( -85), INT8_C( -59), INT8_C(  80),
                           INT8_C( -47), INT8_C( -28), INT8_C( -67), INT8_C(  65),
                           INT8_C( -72), INT8_C( -90), INT8_C( -44), INT8_C(   2),
                           INT8_C(  -3), INT8_C(  57), INT8_C(  67), INT8_C( 107),
                           INT8_C( -68), INT8_C(-101), INT8_C(  -9), INT8_C(   5),
                           INT8_C(-124), INT8_C( -69), INT8_C(-117), INT8_C( -31),
                           INT8_C(-117), INT8_C(  60), INT8_C( -36), INT8_C(-120)) },
    { simde_mm256_set_epi8(INT8_C( 114), INT8_C( -28), INT8_C( -81), INT8_C(-126),
                           INT8_C(-114), INT8_C( -94), INT8_C(-101), INT8_C(  52),
                           INT8_C(  30), INT8_C(  66), INT8_C(-105), INT8_C(  50),
                           INT8_C(  48), INT8_C(  15), INT8_C(   1), INT8_C(-106),
                           INT8_C( -36), INT8_C(  61), INT8_C( -18), INT8_C(   8),
                           INT8_C(  89), INT8_C( -23), INT8_C(  58), INT8_C( -29),
                           INT8_C( 110), INT8_C(  57), INT8_C( -39), INT8_C(   1),
                           INT8_C( -60), INT8_C(  60), INT8_C( -80), INT8_C( -20)),
      simde_mm256_set_epi8(INT8_C( -60), INT8_C(  69), INT8_C( -69), INT8_C( 107),
                           INT8_C(   2), INT8_C( -33), INT8_C(  14), INT8_C(  77),
                           INT8_C(  15), INT8_C(  63), INT8_C(  63), INT8_C( -53),
                           INT8_C(  -9), INT8_C(  76), INT8_C(   7), INT8_C( -76),
                           INT8_C( -23), INT8_C(-107), INT8_C(  84), INT8_C(  37),
                           INT8_C( -18), INT8_C(  47), INT8_C(  58), INT8_C(  31),
                           INT8_C(  69), INT8_C(  12), INT8_C(  46), INT8_C( 101),
                           INT8_C( -38), INT8_C( 117), INT8_C(-113), INT8_C( -36)),
      simde_mm256_set_epi8(INT8_C(-101), INT8_C(  52), INT8_C(  30), INT8_C(  66),
                           INT8_C(-105), INT8_C(  50), INT8_C(  48), INT8_C(  15),
                           INT8_C(   1), INT8_C(-106), INT8_C( -60), INT8_C(  69),
                           INT8_C( -69), INT8_C( 107), INT8_C(   2), INT8_C( -33),
                           INT8_C(  58), INT8_C( -29), INT8_C( 110), INT8_C(  57),
                           INT8_C( -39), INT8_C(   1), INT8_C( -60), INT8_C(  60),
                           INT8_C( -80), INT8_C( -20), INT8_C( -23), INT8_C(-107),
                           INT8_C(  84), INT8_C(  37), INT8_C( -18), INT8_C(  47)) },
    { simde_mm256_set_epi8(INT8_C(  13), INT8_C( -32), INT8_C( -51), INT8_C(  49),
                           INT8_C(  15), INT8_C(  15), INT8_C( -66), INT8_C( -38),
                           INT8_C(  69), INT8_C(   1), INT8_C( -50), INT8_C(-103),
                           INT8_C(  72), INT8_C( -87), INT8_C(-104), INT8_C( -58),
                           INT8_C(  63), INT8_C(-120), INT8_C(  36), INT8_C( -61),
                           INT8_C( 106), INT8_C(  97), INT8_C(-128), INT8_C(  26),
                           INT8_C(-121), INT8_C( -27), INT8_C( 107), INT8_C(-112),
                           INT8_C(  57), INT8_C(  39), INT8_C(  98), INT8_C( 126)),
      simde_mm256_set_epi8(INT8_C(-110), INT8_C(  50), INT8_C( 102), INT8_C( -85),
                           INT8_C( -62), INT8_C(  74), INT8_C( 102), INT8_C(  36),
                           INT8_C( -55), INT8_C(-104), INT8_C(  11), INT8_C( -70),
                           INT8_C( -20), INT8_C(-104), INT8_C( -37), INT8_C( 122),
                           INT8_C( -88), INT8_C(  70), INT8_C(  43), INT8_C( -34),
                           INT8_C(  14), INT8_C(  55), INT8_C( -41), INT8_C(  33),
                           INT8_C(  53), INT8_C(-102), INT8_C(  56), INT8_C(  26),
                           INT8_C( -79), INT8_C( -30), INT8_C(  73), INT8_C( -53)),
      simde_mm256_set_epi8(INT8_C( -66), INT8_C( -38), INT8_C(  69), INT8_C(   1),
                           INT8_C( -50), INT8_C(-103), INT8_C(  72), INT8_C( -87),
                           INT8_C(-104), INT8_C( -58), INT8_C(-110), INT8_C(  50),
                           INT8_C( 102), INT8_C( -85), INT8_C( -62), INT8_C(  74),
                           INT8_C(-128), INT8_C(  26), INT8_C(-121), INT8_C( -27),
                           INT8_C( 107), INT8_C(-112), INT8_C(  57), INT8_C(  39),
                           INT8_C(  98), INT8_C( 126), INT8_C( -88), INT8_C(  70),
                           INT8_C(  43), INT8_C( -34), INT8_C(  14), INT8_C(  55)) },
    { simde_mm256_set_epi8(INT8_C(-103), INT8_C(  23), INT8_C( -90), INT8_C(  43),
                           INT8_C(  -8), INT8_C(  54), INT8_C( -93), INT8_C(  64),
                           INT8_C(-116), INT8_C( -76), INT8_C( -53), INT8_C(  35),
                           INT8_C(  51), INT8_C( -86), INT8_C(   8), INT8_C(  43),
                           INT8_C( -60), INT8_C(-113), INT8_C(  44), INT8_C(-102),
                           INT8_C(  77), INT8_C(  95), INT8_C(  57), INT8_C( 124),
                           INT8_C( -91), INT8_C( -87), INT8_C( -54), INT8_C( -83),
                           INT8_C( 108), INT8_C(  76), INT8_C(  90), INT8_C( -49)),
      simde_mm256_set_epi8(INT8_C( -43), INT8_C(  -5), INT8_C(  94), INT8_C(  76),
                           INT8_C(  -9), INT8_C( 110), INT8_C( -82), INT8_C( 112),
                           INT8_C( -25), INT8_C(  11), INT8_C( -46), INT8_C( -57),
                           INT8_C( -13), INT8_C(-127), INT8_C(  10), INT8_C(-113),
                           INT8_C(  55), INT8_C(  85), INT8_C(  75), INT8_C(  61),
                           INT8_C(  49), INT8_C( -14), INT8_C(  44), INT8_C(-128),
                           INT8_C(-102), INT8_C( -17), INT8_C(  64), INT8_C( -73),
                           INT8_C(  14), INT8_C(  19), INT8_C(  -2), INT8_C(   7)),
      simde_mm256_set_epi8(INT8_C( -93), INT8_C(  64), INT8_C(-116), INT8_C( -76),
                           INT8_C( -53), INT8_C(  35), INT8_C(  51), INT8_C( -86),
                           INT8_C(   8), INT8_C(  43), INT8_C( -43), INT8_C(  -5),
                           INT8_C(  94), INT8_C(  76), INT8_C(  -9), INT8_C( 110),
                           INT8_C(  57), INT8_C( 124), INT8_C( -91), INT8_C( -87),
                           INT8_C( -54), INT8_C( -83), INT8_C( 108), INT8_C(  76),
                           INT8_C(  90), INT8_C( -49), INT8_C(  55), INT8_C(  85),
                           INT8_C(  75), INT8_C(  61), INT8_C(  49), INT8_C( -14)) },
    { simde_mm256_set_epi8(INT8_C( -32), INT8_C( -82), INT8_C(  79), INT8_C(  79),
                           INT8_C( 127), INT8_C(  16), INT8_C(-118), INT8_C( 113),
                           INT8_C( -52), INT8_C( -25), INT8_C(-124), INT8_C( -77),
                           INT8_C( 114), INT8_C(-118), INT8_C( -84), INT8_C(  73),
                           INT8_C( -12), INT8_C( -67), INT8_C(-127), INT8_C( -69),
                           INT8_C(  30), INT8_C(  14), INT8_C( -47), INT8_C(-119),
                           INT8_C( -36), INT8_C( -97), INT8_C( -89), INT8_C(  24),
                           INT8_C( -41), INT8_C( 117), INT8_C(-102), INT8_C(  54)),
      simde_mm256_set_epi8(INT8_C( -66), INT8_C( -50), INT8_C(  39), INT8_C(  30),
                           INT8_C(  53), INT8_C( 108), INT8_C( -71), INT8_C( -62),
                           INT8_C(  58), INT8_C( -69), INT8_C( -39), INT8_C( -28),
                           INT8_C(  58), INT8_C(  54), INT8_C(-117), INT8_C( -49),
                           INT8_C( 126), INT8_C( -71), INT8_C( -39), INT8_C(-120),
                           INT8_C(  88), INT8_C(  41), INT8_C( 127), INT8_C( 111),
                           INT8_C( -32), INT8_C( -18), INT8_C(  12), INT8_C(  97),
                           INT8_C(  83), INT8_C( -96), INT8_C(  13), INT8_C(-101)),
      simde_mm256_set_epi8(INT8_C(-118), INT8_C( 113), INT8_C( -52), INT8_C( -25),
                           INT8_C(-124), INT8_C( -77), INT8_C( 114), INT8_C(-118),
                           INT8_C( -84), INT8_C(  73), INT8_C( -66), INT8_C( -50),
                           INT8_C(  39), INT8_C(  30), INT8_C(  53), INT8_C( 108),
                           INT8_C( -47), INT8_C(-119), INT8_C( -36), INT8_C( -97),
                           INT8_C( -89), INT8_C(  24), INT8_C( -41), INT8_C( 117),
                           INT8_C(-102), INT8_C(  54), INT8_C( 126), INT8_C( -71),
                           INT8_C( -39), INT8_C(-120), INT8_C(  88), INT8_C(  41)) },
    { simde_mm256_set_epi8(INT8_C(-105), INT8_C(   9), INT8_C( -52), INT8_C(  54),
                           INT8_C( -11), INT8_C( -39), INT8_C( -64), INT8_C( -79),
                           INT8_C(  88), INT8_C(  52), INT8_C( -95), INT8_C( -70),
                           INT8_C(  46), INT8_C( 121), INT8_C( -22), INT8_C( 113),
                           INT8_C(  26), INT8_C( 104), INT8_C( -52), INT8_C( 109),
                           INT8_C(   5), INT8_C(  87), INT8_C(  90), INT8_C(  -7),
                           INT8_C( -35), INT8_C(-112), INT8_C(  20), INT8_C(-128),
                           INT8_C( -21), INT8_C( -67), INT8_C(  37), INT8_C( -35)),
      simde_mm256_set_epi8(INT8_C(  66), INT8_C( -23), INT8_C(  45), INT8_C( -38),
                           INT8_C( -94), INT8_C( 119), INT8_C( -23), INT8_C(  70),
                           INT8_C( -75), INT8_C(  25), INT8_C(  79), INT8_C(-101),
                           INT8_C(-122), INT8_C(-107), INT8_C( -10), INT8_C(-109),
                           INT8_C( -96), INT8_C(  45), INT8_C(  31), INT8_C( -60),
                           INT8_C( 100), INT8_C( 115), INT8_C(  79), INT8_C(  38),
                           INT8_C( -35), INT8_C(  57), INT8_C(  13), INT8_C(  93),
                           INT8_C(  54), INT8_C( -61), INT8_C( 101), INT8_C(-113)),
      simde_mm256_set_epi8(INT8_C( -64), INT8_C( -79), INT8_C(  88), INT8_C(  52),
                           INT8_C( -95), INT8_C( -70), INT8_C(  46), INT8_C( 121),
                           INT8_C( -22), INT8_C( 113), INT8_C(  66), INT8_C( -23),
                           INT8_C(  45), INT8_C( -38), INT8_C( -94), INT8_C( 119),
                           INT8_C(  90), INT8_C(  -7), INT8_C( -35), INT8_C(-112),
                           INT8_C(  20), INT8_C(-128), INT8_C( -21), INT8_C( -67),
                           INT8_C(  37), INT8_C( -35), INT8_C( -96), INT8_C(  45),
                           INT8_C(  31), INT8_C( -60), INT8_C( 100), INT8_C( 115)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_alignr_epi8(test_vec[i].a, test_vec[i].b, 10);
    simde_assert_m256i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_alignr_epi8_case2(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi8(INT8_C( 113), INT8_C( -69), INT8_C(  23), INT8_C( -66),
                           INT8_C( 115), INT8_C( -83), INT8_C( -66), INT8_C( -71),
                           INT8_C(  28), INT8_C(  74), INT8_C(  -4), INT8_C(  16),
                           INT8_C(  16), INT8_C( -20), INT8_C(  79), INT8_C( -49),
                           INT8_C(  13), INT8_C(  59), INT8_C( -99), INT8_C(  73),
                           INT8_C(  19), INT8_C(  31), INT8_C( -64), INT8_C( -94),
                           INT8_C( 111), INT8_C( 121), INT8_C( -91), INT8_C( -99),
                           INT8_C(-120), INT8_C(  24), INT8_C(-116), INT8_C( -29)),
      simde_mm256_set_epi8(INT8_C(  19), INT8_C( 117), INT8_C(  83), INT8_C(  54),
                           INT8_C( -84), INT8_C(-110), INT8_C( 115), INT8_C(  25),
                           INT8_C( 122), INT8_C( -20), INT8_C(  49), INT8_C( -87),
                           INT8_C(   9), INT8_C( -79), INT8_C(  28), INT8_C( -93),
                           INT8_C( -97), INT8_C(  38), INT8_C(  85), INT8_C( -70),
                           INT8_C(  96), INT8_C(   7), INT8_C( -55), INT8_C(  -8),
                           INT8_C(  94), INT8_C(  69), INT8_C(  20), INT8_C(  64),
                           INT8_C(  54), INT8_C(  88), INT8_C( -92), INT8_C( -89)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C( 113), INT8_C( -69), INT8_C(  23),
                           INT8_C( -66), INT8_C( 115), INT8_C( -83), INT8_C( -66),
                           INT8_C( -71), INT8_C(  28), INT8_C(  74), INT8_C(  -4),
                           INT8_C(  16), INT8_C(  16), INT8_C( -20), INT8_C(  79),
                           INT8_C(   0), INT8_C(  13), INT8_C(  59), INT8_C( -99),
                           INT8_C(  73), INT8_C(  19), INT8_C(  31), INT8_C( -64),
                           INT8_C( -94), INT8_C( 111), INT8_C( 121), INT8_C( -91),
                           INT8_C( -99), INT8_C(-120), INT8_C(  24), INT8_C(-116)) },
    { simde_mm256_set_epi8(INT8_C(  -7), INT8_C( -66), INT8_C(-120), INT8_C( 103),
                           INT8_C( -48), INT8_C( -55), INT8_C(-109), INT8_C(  52),
                           INT8_C( 103), INT8_C(  30), INT8_C( -21), INT8_C(-107),
                           INT8_C(  14), INT8_C(  -9), INT8_C(  61), INT8_C(-114),
                           INT8_C(-120), INT8_C(-116), INT8_C( -34), INT8_C( -96),
                           INT8_C( 124), INT8_C(  29), INT8_C( -49), INT8_C(  74),
                           INT8_C( -82), INT8_C(  66), INT8_C(  24), INT8_C(  47),
                           INT8_C(  -7), INT8_C( -96), INT8_C(  99), INT8_C( -53)),
      simde_mm256_set_epi8(INT8_C(  77), INT8_C(  25), INT8_C(  25), INT8_C(  69),
                           INT8_C( -34), INT8_C(   2), INT8_C(  12), INT8_C(  -5),
                           INT8_C( -49), INT8_C( -58), INT8_C( -38), INT8_C( -80),
                           INT8_C(  88), INT8_C(  48), INT8_C(  49), INT8_C(  73),
                           INT8_C( 121), INT8_C(  39), INT8_C( -20), INT8_C(  28),
                           INT8_C( 121), INT8_C(   0), INT8_C( -34), INT8_C(  24),
                           INT8_C( -45), INT8_C(-121), INT8_C( -12), INT8_C(  37),
                           INT8_C(  64), INT8_C(  31), INT8_C(  31), INT8_C(  41)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(  -7), INT8_C( -66), INT8_C(-120),
                           INT8_C( 103), INT8_C( -48), INT8_C( -55), INT8_C(-109),
                           INT8_C(  52), INT8_C( 103), INT8_C(  30), INT8_C( -21),
                           INT8_C(-107), INT8_C(  14), INT8_C(  -9), INT8_C(  61),
                           INT8_C(   0), INT8_C(-120), INT8_C(-116), INT8_C( -34),
                           INT8_C( -96), INT8_C( 124), INT8_C(  29), INT8_C( -49),
                           INT8_C(  74), INT8_C( -82), INT8_C(  66), INT8_C(  24),
                           INT8_C(  47), INT8_C(  -7), INT8_C( -96), INT8_C(  99)) },
    { simde_mm256_set_epi8(INT8_C(  -1), INT8_C(  20), INT8_C( -95), INT8_C( 112),
                           INT8_C(  49), INT8_C(-103), INT8_C( 108), INT8_C( -46),
                           INT8_C( -85), INT8_C( -99), INT8_C(  78), INT8_C( 125),
                           INT8_C( -66), INT8_C( -37), INT8_C(  94), INT8_C( 112),
                           INT8_C(-126), INT8_C( -37), INT8_C(-124), INT8_C( -71),
                           INT8_C( -21), INT8_C( -79), INT8_C(  -2), INT8_C(  34),
                           INT8_C( -56), INT8_C(  22), INT8_C(-102), INT8_C(  53),
                           INT8_C( -24), INT8_C( -87), INT8_C(  16), INT8_C( -85)),
      simde_mm256_set_epi8(INT8_C(  66), INT8_C( -80), INT8_C(  10), INT8_C( -95),
                           INT8_C( -33), INT8_C(  65), INT8_C(-115), INT8_C( -97),
                           INT8_C( -96), INT8_C(  17), INT8_C( 123), INT8_C( -81),
                           INT8_C( -25), INT8_C( -92), INT8_C( 110), INT8_C(  74),
                           INT8_C(  58), INT8_C( 126), INT8_C(  24), INT8_C( -87),
                           INT8_C(-124), INT8_C(  -7), INT8_C( -55), INT8_C( 112),
                           INT8_C(  10), INT8_C(-117), INT8_C( -16), INT8_C(  34),
                           INT8_C( -23), INT8_C( 105), INT8_C(  32), INT8_C(-122)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(  -1), INT8_C(  20), INT8_C( -95),
                           INT8_C( 112), INT8_C(  49), INT8_C(-103), INT8_C( 108),
                           INT8_C( -46), INT8_C( -85), INT8_C( -99), INT8_C(  78),
                           INT8_C( 125), INT8_C( -66), INT8_C( -37), INT8_C(  94),
                           INT8_C(   0), INT8_C(-126), INT8_C( -37), INT8_C(-124),
                           INT8_C( -71), INT8_C( -21), INT8_C( -79), INT8_C(  -2),
                           INT8_C(  34), INT8_C( -56), INT8_C(  22), INT8_C(-102),
                           INT8_C(  53), INT8_C( -24), INT8_C( -87), INT8_C(  16)) },
    { simde_mm256_set_epi8(INT8_C(  25), INT8_C( -64), INT8_C( 105), INT8_C( -19),
                           INT8_C(-100), INT8_C( 119), INT8_C(  53), INT8_C(-128),
                           INT8_C(  50), INT8_C(-115), INT8_C(  36), INT8_C( 126),
                           INT8_C(   7), INT8_C( -21), INT8_C(-106), INT8_C(-120),
                           INT8_C( 127), INT8_C( -66), INT8_C(  -1), INT8_C( -93),
                           INT8_C(  -5), INT8_C(  40), INT8_C(  78), INT8_C(-119),
                           INT8_C(  82), INT8_C( -17), INT8_C(  18), INT8_C(  47),
                           INT8_C(   8), INT8_C(-108), INT8_C(-114), INT8_C(  65)),
      simde_mm256_set_epi8(INT8_C(-113), INT8_C( 113), INT8_C(-118), INT8_C( -40),
                           INT8_C(-102), INT8_C( -62), INT8_C(  64), INT8_C( -33),
                           INT8_C(  77), INT8_C( -83), INT8_C( -74), INT8_C(  19),
                           INT8_C(  71), INT8_C(  17), INT8_C( -17), INT8_C( -35),
                           INT8_C(  93), INT8_C( -41), INT8_C(  11), INT8_C(   0),
                           INT8_C( -41), INT8_C( -66), INT8_C( -72), INT8_C( 117),
                           INT8_C( 100), INT8_C(-122), INT8_C(  24), INT8_C(-112),
                           INT8_C(  87), INT8_C(  37), INT8_C( -17), INT8_C( -51)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(  25), INT8_C( -64), INT8_C( 105),
                           INT8_C( -19), INT8_C(-100), INT8_C( 119), INT8_C(  53),
                           INT8_C(-128), INT8_C(  50), INT8_C(-115), INT8_C(  36),
                           INT8_C( 126), INT8_C(   7), INT8_C( -21), INT8_C(-106),
                           INT8_C(   0), INT8_C( 127), INT8_C( -66), INT8_C(  -1),
                           INT8_C( -93), INT8_C(  -5), INT8_C(  40), INT8_C(  78),
                           INT8_C(-119), INT8_C(  82), INT8_C( -17), INT8_C(  18),
                           INT8_C(  47), INT8_C(   8), INT8_C(-108), INT8_C(-114)) },
    { simde_mm256_set_epi8(INT8_C( -71), INT8_C(  29), INT8_C( -63), INT8_C( -99),
                           INT8_C(  16), INT8_C(  67), INT8_C(-118), INT8_C(  12),
                           INT8_C( -46), INT8_C( 113), INT8_C(-128), INT8_C(-114),
                           INT8_C( -51), INT8_C( -75), INT8_C(  97), INT8_C( -73),
                           INT8_C(  24), INT8_C( -63), INT8_C(  20), INT8_C( -26),
                           INT8_C( -44), INT8_C(  71), INT8_C( 109), INT8_C( 113),
                           INT8_C(  36), INT8_C( 100), INT8_C(  42), INT8_C( -55),
                           INT8_C(  12), INT8_C( -66), INT8_C( -91), INT8_C(  82)),
      simde_mm256_set_epi8(INT8_C(  81), INT8_C(  93), INT8_C(  76), INT8_C(  23),
                           INT8_C( -32), INT8_C(  31), INT8_C(  25), INT8_C( -76),
                           INT8_C(  38), INT8_C( 114), INT8_C(  74), INT8_C( -11),
                           INT8_C(  55), INT8_C( -33), INT8_C( -78), INT8_C( -96),
                           INT8_C( 106), INT8_C(   1), INT8_C(  32), INT8_C( -46),
                           INT8_C( 124), INT8_C(  89), INT8_C( -80), INT8_C( -22),
                           INT8_C(-117), INT8_C( -99), INT8_C( -39), INT8_C( -63),
                           INT8_C(  12), INT8_C( 106), INT8_C( 120), INT8_C(  64)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C( -71), INT8_C(  29), INT8_C( -63),
                           INT8_C( -99), INT8_C(  16), INT8_C(  67), INT8_C(-118),
                           INT8_C(  12), INT8_C( -46), INT8_C( 113), INT8_C(-128),
                           INT8_C(-114), INT8_C( -51), INT8_C( -75), INT8_C(  97),
                           INT8_C(   0), INT8_C(  24), INT8_C( -63), INT8_C(  20),
                           INT8_C( -26), INT8_C( -44), INT8_C(  71), INT8_C( 109),
                           INT8_C( 113), INT8_C(  36), INT8_C( 100), INT8_C(  42),
                           INT8_C( -55), INT8_C(  12), INT8_C( -66), INT8_C( -91)) },
    { simde_mm256_set_epi8(INT8_C(  91), INT8_C( -47), INT8_C( -11), INT8_C(  95),
                           INT8_C(-101), INT8_C(  71), INT8_C( -99), INT8_C( 119),
                           INT8_C(  53), INT8_C( -40), INT8_C(  93), INT8_C( -71),
                           INT8_C(  53), INT8_C( 101), INT8_C(  91), INT8_C(  38),
                           INT8_C( 101), INT8_C(  10), INT8_C(   7), INT8_C(  37),
                           INT8_C( -66), INT8_C(   4), INT8_C( -96), INT8_C( -47),
                           INT8_C( -72), INT8_C(-123), INT8_C( -18), INT8_C( -16),
                           INT8_C(  57), INT8_C(  -1), INT8_C(-122), INT8_C(  93)),
      simde_mm256_set_epi8(INT8_C( 125), INT8_C( -97), INT8_C( -63), INT8_C(  47),
                           INT8_C(  76), INT8_C( -11), INT8_C(  32), INT8_C(  96),
                           INT8_C( 121), INT8_C( -93), INT8_C(  72), INT8_C( -40),
                           INT8_C( -11), INT8_C( -76), INT8_C(  51), INT8_C(-122),
                           INT8_C( 108), INT8_C( -61), INT8_C(  -9), INT8_C( -38),
                           INT8_C( -65), INT8_C( -53), INT8_C( -36), INT8_C(  43),
                           INT8_C( -52), INT8_C( -14), INT8_C( -72), INT8_C(  79),
                           INT8_C(   4), INT8_C(  96), INT8_C( -88), INT8_C(  40)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(  91), INT8_C( -47), INT8_C( -11),
                           INT8_C(  95), INT8_C(-101), INT8_C(  71), INT8_C( -99),
                           INT8_C( 119), INT8_C(  53), INT8_C( -40), INT8_C(  93),
                           INT8_C( -71), INT8_C(  53), INT8_C( 101), INT8_C(  91),
                           INT8_C(   0), INT8_C( 101), INT8_C(  10), INT8_C(   7),
                           INT8_C(  37), INT8_C( -66), INT8_C(   4), INT8_C( -96),
                           INT8_C( -47), INT8_C( -72), INT8_C(-123), INT8_C( -18),
                           INT8_C( -16), INT8_C(  57), INT8_C(  -1), INT8_C(-122)) },
    { simde_mm256_set_epi8(INT8_C(-125), INT8_C(  50), INT8_C(   9), INT8_C(-114),
                           INT8_C(  12), INT8_C(-115), INT8_C(  20), INT8_C( -81),
                           INT8_C(  65), INT8_C(  -9), INT8_C(   1), INT8_C(  -7),
                           INT8_C(  48), INT8_C(  81), INT8_C( -58), INT8_C( -29),
                           INT8_C(-102), INT8_C(  98), INT8_C( 126), INT8_C(  49),
                           INT8_C(  95), INT8_C(  45), INT8_C( -60), INT8_C( -92),
                           INT8_C(  -7), INT8_C( -56), INT8_C( -47), INT8_C( -85),
                           INT8_C( -93), INT8_C(  33), INT8_C( -91), INT8_C( -34)),
      simde_mm256_set_epi8(INT8_C(  88), INT8_C( -22), INT8_C( -14), INT8_C(  72),
                           INT8_C(-106), INT8_C( -75), INT8_C( -40), INT8_C( -29),
                           INT8_C(  71), INT8_C(  52), INT8_C( -19), INT8_C( -85),
                           INT8_C(  47), INT8_C( -19), INT8_C( -33), INT8_C( -99),
                           INT8_C( -95), INT8_C(-103), INT8_C( 113), INT8_C(  75),
                           INT8_C(  16), INT8_C(-125), INT8_C(  51), INT8_C( -20),
                           INT8_C( -87), INT8_C(  79), INT8_C(  50), INT8_C( -45),
                           INT8_C( -77), INT8_C( -89), INT8_C(  25), INT8_C( -53)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(-125), INT8_C(  50), INT8_C(   9),
                           INT8_C(-114), INT8_C(  12), INT8_C(-115), INT8_C(  20),
                           INT8_C( -81), INT8_C(  65), INT8_C(  -9), INT8_C(   1),
                           INT8_C(  -7), INT8_C(  48), INT8_C(  81), INT8_C( -58),
                           INT8_C(   0), INT8_C(-102), INT8_C(  98), INT8_C( 126),
                           INT8_C(  49), INT8_C(  95), INT8_C(  45), INT8_C( -60),
                           INT8_C( -92), INT8_C(  -7), INT8_C( -56), INT8_C( -47),
                           INT8_C( -85), INT8_C( -93), INT8_C(  33), INT8_C( -91)) },
    { simde_mm256_set_epi8(INT8_C( 108), INT8_C( -54), INT8_C(  79), INT8_C( -34),
                           INT8_C(  79), INT8_C( 114), INT8_C(  95), INT8_C( -13),
                           INT8_C( -32), INT8_C( 106), INT8_C(   6), INT8_C(-103),
                           INT8_C( -17), INT8_C( 126), INT8_C( -76), INT8_C( 100),
                           INT8_C( 103), INT8_C( -73), INT8_C(-120), INT8_C(  89),
                           INT8_C(  92), INT8_C(   1), INT8_C(  24), INT8_C( -42),
                           INT8_C( -87), INT8_C(-120), INT8_C( -69), INT8_C( 118),
                           INT8_C( -71), INT8_C(  35), INT8_C(  31), INT8_C( -27)),
      simde_mm256_set_epi8(INT8_C( 106), INT8_C(  34), INT8_C( -93), INT8_C( -41),
                           INT8_C(  92), INT8_C(  50), INT8_C(-109), INT8_C(  24),
                           INT8_C(  49), INT8_C( -59), INT8_C( -13), INT8_C(  39),
                           INT8_C( 111), INT8_C( -38), INT8_C(  26), INT8_C(  -9),
                           INT8_C(-106), INT8_C(-118), INT8_C( 104), INT8_C( -38),
                           INT8_C( 127), INT8_C( -21), INT8_C(  72), INT8_C(-105),
                           INT8_C( 100), INT8_C(  65), INT8_C(  70), INT8_C(-111),
                           INT8_C(  93), INT8_C(-113), INT8_C( -69), INT8_C( -81)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C( 108), INT8_C( -54), INT8_C(  79),
                           INT8_C( -34), INT8_C(  79), INT8_C( 114), INT8_C(  95),
                           INT8_C( -13), INT8_C( -32), INT8_C( 106), INT8_C(   6),
                           INT8_C(-103), INT8_C( -17), INT8_C( 126), INT8_C( -76),
                           INT8_C(   0), INT8_C( 103), INT8_C( -73), INT8_C(-120),
                           INT8_C(  89), INT8_C(  92), INT8_C(   1), INT8_C(  24),
                           INT8_C( -42), INT8_C( -87), INT8_C(-120), INT8_C( -69),
                           INT8_C( 118), INT8_C( -71), INT8_C(  35), INT8_C(  31)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_alignr_epi8(test_vec[i].a, test_vec[i].b, 17);
    simde_assert_m256i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_alignr_epi8_case3(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi8(INT8_C(  57), INT8_C( -47), INT8_C( -81), INT8_C( -95),
                           INT8_C(-100), INT8_C( -69), INT8_C( -75), INT8_C(-127),
                           INT8_C(  -8), INT8_C( -83), INT8_C( -94), INT8_C(-113),
                           INT8_C( 107), INT8_C( -39), INT8_C( -99), INT8_C(  46),
                           INT8_C( -61), INT8_C( -72), INT8_C(  -5), INT8_C(-126),
                           INT8_C( 113), INT8_C(-120), INT8_C(  -9), INT8_C( 117),
                           INT8_C( 121), INT8_C( -14), INT8_C( -58), INT8_C(-118),
                           INT8_C( -70), INT8_C( -35), INT8_C(-100), INT8_C(  48)),
      simde_mm256_set_epi8(INT8_C( -98), INT8_C(  80), INT8_C( -16), INT8_C(  73),
                           INT8_C( 126), INT8_C(-115), INT8_C(  31), INT8_C(  80),
                           INT8_C( -75), INT8_C( 117), INT8_C( -13), INT8_C( -70),
                           INT8_C(-101), INT8_C( -10), INT8_C(-111), INT8_C(  96),
                           INT8_C( -77), INT8_C(   0), INT8_C(  70), INT8_C(-121),
                           INT8_C(  78), INT8_C(  54), INT8_C(  38), INT8_C(  18),
                           INT8_C( -12), INT8_C(  68), INT8_C(  53), INT8_C(  45),
                           INT8_C(  77), INT8_C( 103), INT8_C( 118), INT8_C( 116)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  57), INT8_C( -47),
                           INT8_C( -81), INT8_C( -95), INT8_C(-100), INT8_C( -69),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -61), INT8_C( -72),
                           INT8_C(  -5), INT8_C(-126), INT8_C( 113), INT8_C(-120)) },
    { simde_mm256_set_epi8(INT8_C(   8), INT8_C(  70), INT8_C(  96), INT8_C(  42),
                           INT8_C(  73), INT8_C( -91), INT8_C( -93), INT8_C( -58),
                           INT8_C( -35), INT8_C( -14), INT8_C( 118), INT8_C(-128),
                           INT8_C( -97), INT8_C(  97), INT8_C(  22), INT8_C(   4),
                           INT8_C(  24), INT8_C( 124), INT8_C( -32), INT8_C( -48),
                           INT8_C( -74), INT8_C(  95), INT8_C(  95), INT8_C( -38),
                           INT8_C(  54), INT8_C( 120), INT8_C( -65), INT8_C( -96),
                           INT8_C( -44), INT8_C( -78), INT8_C( -95), INT8_C(-111)),
      simde_mm256_set_epi8(INT8_C(  66), INT8_C(  48), INT8_C(  60), INT8_C(  -4),
                           INT8_C(  33), INT8_C(  67), INT8_C(  97), INT8_C(  65),
                           INT8_C(  80), INT8_C(-109), INT8_C(  88), INT8_C( -23),
                           INT8_C( 107), INT8_C( -65), INT8_C( -65), INT8_C(  62),
                           INT8_C(  90), INT8_C( 118), INT8_C(  25), INT8_C( 105),
                           INT8_C( 109), INT8_C( -45), INT8_C(   4), INT8_C(-107),
                           INT8_C(  55), INT8_C(-101), INT8_C( -65), INT8_C( 121),
                           INT8_C( -76), INT8_C(  55), INT8_C(   6), INT8_C(  86)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   8), INT8_C(  70),
                           INT8_C(  96), INT8_C(  42), INT8_C(  73), INT8_C( -91),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  24), INT8_C( 124),
                           INT8_C( -32), INT8_C( -48), INT8_C( -74), INT8_C(  95)) },
    { simde_mm256_set_epi8(INT8_C(  -1), INT8_C(  93), INT8_C( 114), INT8_C(  49),
                           INT8_C( 120), INT8_C( -70), INT8_C(-112), INT8_C(  19),
                           INT8_C(  56), INT8_C( -12), INT8_C( -77), INT8_C( -85),
                           INT8_C( -59), INT8_C(  80), INT8_C( -47), INT8_C( -28),
                           INT8_C( -33), INT8_C(  73), INT8_C( -24), INT8_C(-106),
                           INT8_C(-122), INT8_C(-111), INT8_C(  -3), INT8_C(  57),
                           INT8_C(  67), INT8_C( 107), INT8_C( -68), INT8_C(-101),
                           INT8_C(  -9), INT8_C(   5), INT8_C(-124), INT8_C( -69)),
      simde_mm256_set_epi8(INT8_C( -67), INT8_C(  65), INT8_C( -72), INT8_C( -90),
                           INT8_C( -44), INT8_C(   2), INT8_C(  39), INT8_C( -45),
                           INT8_C(  51), INT8_C( -30), INT8_C( -47), INT8_C(   1),
                           INT8_C( -91), INT8_C( -40), INT8_C( -73), INT8_C(  33),
                           INT8_C(-117), INT8_C( -31), INT8_C(-117), INT8_C(  60),
                           INT8_C( -36), INT8_C(-120), INT8_C( -10), INT8_C( -12),
                           INT8_C( -25), INT8_C(-103), INT8_C(  48), INT8_C( -50),
                           INT8_C( 101), INT8_C(  93), INT8_C( -31), INT8_C( -33)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  -1), INT8_C(  93),
                           INT8_C( 114), INT8_C(  49), INT8_C( 120), INT8_C( -70),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -33), INT8_C(  73),
                           INT8_C( -24), INT8_C(-106), INT8_C(-122), INT8_C(-111)) },
    { simde_mm256_set_epi8(INT8_C( 114), INT8_C( -28), INT8_C( -81), INT8_C(-126),
                           INT8_C(-114), INT8_C( -94), INT8_C(-101), INT8_C(  52),
                           INT8_C(  30), INT8_C(  66), INT8_C(-105), INT8_C(  50),
                           INT8_C(  48), INT8_C(  15), INT8_C(   1), INT8_C(-106),
                           INT8_C( -36), INT8_C(  61), INT8_C( -18), INT8_C(   8),
                           INT8_C(  89), INT8_C( -23), INT8_C(  58), INT8_C( -29),
                           INT8_C( 110), INT8_C(  57), INT8_C( -39), INT8_C(   1),
                           INT8_C( -60), INT8_C(  60), INT8_C( -80), INT8_C( -20)),
      simde_mm256_set_epi8(INT8_C( -60), INT8_C(  69), INT8_C( -69), INT8_C( 107),
                           INT8_C(   2), INT8_C( -33), INT8_C(  14), INT8_C(  77),
                           INT8_C(  15), INT8_C(  63), INT8_C(  63), INT8_C( -53),
                           INT8_C(  -9), INT8_C(  76), INT8_C(   7), INT8_C( -76),
                           INT8_C( -23), INT8_C(-107), INT8_C(  84), INT8_C(  37),
                           INT8_C( -18), INT8_C(  47), INT8_C(  58), INT8_C(  31),
                           INT8_C(  69), INT8_C(  12), INT8_C(  46), INT8_C( 101),
                           INT8_C( -38), INT8_C( 117), INT8_C(-113), INT8_C( -36)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( 114), INT8_C( -28),
                           INT8_C( -81), INT8_C(-126), INT8_C(-114), INT8_C( -94),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -36), INT8_C(  61),
                           INT8_C( -18), INT8_C(   8), INT8_C(  89), INT8_C( -23)) },
    { simde_mm256_set_epi8(INT8_C(  13), INT8_C( -32), INT8_C( -51), INT8_C(  49),
                           INT8_C(  15), INT8_C(  15), INT8_C( -66), INT8_C( -38),
                           INT8_C(  69), INT8_C(   1), INT8_C( -50), INT8_C(-103),
                           INT8_C(  72), INT8_C( -87), INT8_C(-104), INT8_C( -58),
                           INT8_C(  63), INT8_C(-120), INT8_C(  36), INT8_C( -61),
                           INT8_C( 106), INT8_C(  97), INT8_C(-128), INT8_C(  26),
                           INT8_C(-121), INT8_C( -27), INT8_C( 107), INT8_C(-112),
                           INT8_C(  57), INT8_C(  39), INT8_C(  98), INT8_C( 126)),
      simde_mm256_set_epi8(INT8_C(-110), INT8_C(  50), INT8_C( 102), INT8_C( -85),
                           INT8_C( -62), INT8_C(  74), INT8_C( 102), INT8_C(  36),
                           INT8_C( -55), INT8_C(-104), INT8_C(  11), INT8_C( -70),
                           INT8_C( -20), INT8_C(-104), INT8_C( -37), INT8_C( 122),
                           INT8_C( -88), INT8_C(  70), INT8_C(  43), INT8_C( -34),
                           INT8_C(  14), INT8_C(  55), INT8_C( -41), INT8_C(  33),
                           INT8_C(  53), INT8_C(-102), INT8_C(  56), INT8_C(  26),
                           INT8_C( -79), INT8_C( -30), INT8_C(  73), INT8_C( -53)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  13), INT8_C( -32),
                           INT8_C( -51), INT8_C(  49), INT8_C(  15), INT8_C(  15),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  63), INT8_C(-120),
                           INT8_C(  36), INT8_C( -61), INT8_C( 106), INT8_C(  97)) },
    { simde_mm256_set_epi8(INT8_C(-103), INT8_C(  23), INT8_C( -90), INT8_C(  43),
                           INT8_C(  -8), INT8_C(  54), INT8_C( -93), INT8_C(  64),
                           INT8_C(-116), INT8_C( -76), INT8_C( -53), INT8_C(  35),
                           INT8_C(  51), INT8_C( -86), INT8_C(   8), INT8_C(  43),
                           INT8_C( -60), INT8_C(-113), INT8_C(  44), INT8_C(-102),
                           INT8_C(  77), INT8_C(  95), INT8_C(  57), INT8_C( 124),
                           INT8_C( -91), INT8_C( -87), INT8_C( -54), INT8_C( -83),
                           INT8_C( 108), INT8_C(  76), INT8_C(  90), INT8_C( -49)),
      simde_mm256_set_epi8(INT8_C( -43), INT8_C(  -5), INT8_C(  94), INT8_C(  76),
                           INT8_C(  -9), INT8_C( 110), INT8_C( -82), INT8_C( 112),
                           INT8_C( -25), INT8_C(  11), INT8_C( -46), INT8_C( -57),
                           INT8_C( -13), INT8_C(-127), INT8_C(  10), INT8_C(-113),
                           INT8_C(  55), INT8_C(  85), INT8_C(  75), INT8_C(  61),
                           INT8_C(  49), INT8_C( -14), INT8_C(  44), INT8_C(-128),
                           INT8_C(-102), INT8_C( -17), INT8_C(  64), INT8_C( -73),
                           INT8_C(  14), INT8_C(  19), INT8_C(  -2), INT8_C(   7)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(-103), INT8_C(  23),
                           INT8_C( -90), INT8_C(  43), INT8_C(  -8), INT8_C(  54),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -60), INT8_C(-113),
                           INT8_C(  44), INT8_C(-102), INT8_C(  77), INT8_C(  95)) },
    { simde_mm256_set_epi8(INT8_C( -32), INT8_C( -82), INT8_C(  79), INT8_C(  79),
                           INT8_C( 127), INT8_C(  16), INT8_C(-118), INT8_C( 113),
                           INT8_C( -52), INT8_C( -25), INT8_C(-124), INT8_C( -77),
                           INT8_C( 114), INT8_C(-118), INT8_C( -84), INT8_C(  73),
                           INT8_C( -12), INT8_C( -67), INT8_C(-127), INT8_C( -69),
                           INT8_C(  30), INT8_C(  14), INT8_C( -47), INT8_C(-119),
                           INT8_C( -36), INT8_C( -97), INT8_C( -89), INT8_C(  24),
                           INT8_C( -41), INT8_C( 117), INT8_C(-102), INT8_C(  54)),
      simde_mm256_set_epi8(INT8_C( -66), INT8_C( -50), INT8_C(  39), INT8_C(  30),
                           INT8_C(  53), INT8_C( 108), INT8_C( -71), INT8_C( -62),
                           INT8_C(  58), INT8_C( -69), INT8_C( -39), INT8_C( -28),
                           INT8_C(  58), INT8_C(  54), INT8_C(-117), INT8_C( -49),
                           INT8_C( 126), INT8_C( -71), INT8_C( -39), INT8_C(-120),
                           INT8_C(  88), INT8_C(  41), INT8_C( 127), INT8_C( 111),
                           INT8_C( -32), INT8_C( -18), INT8_C(  12), INT8_C(  97),
                           INT8_C(  83), INT8_C( -96), INT8_C(  13), INT8_C(-101)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -32), INT8_C( -82),
                           INT8_C(  79), INT8_C(  79), INT8_C( 127), INT8_C(  16),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C( -12), INT8_C( -67),
                           INT8_C(-127), INT8_C( -69), INT8_C(  30), INT8_C(  14)) },
    { simde_mm256_set_epi8(INT8_C(-105), INT8_C(   9), INT8_C( -52), INT8_C(  54),
                           INT8_C( -11), INT8_C( -39), INT8_C( -64), INT8_C( -79),
                           INT8_C(  88), INT8_C(  52), INT8_C( -95), INT8_C( -70),
                           INT8_C(  46), INT8_C( 121), INT8_C( -22), INT8_C( 113),
                           INT8_C(  26), INT8_C( 104), INT8_C( -52), INT8_C( 109),
                           INT8_C(   5), INT8_C(  87), INT8_C(  90), INT8_C(  -7),
                           INT8_C( -35), INT8_C(-112), INT8_C(  20), INT8_C(-128),
                           INT8_C( -21), INT8_C( -67), INT8_C(  37), INT8_C( -35)),
      simde_mm256_set_epi8(INT8_C(  66), INT8_C( -23), INT8_C(  45), INT8_C( -38),
                           INT8_C( -94), INT8_C( 119), INT8_C( -23), INT8_C(  70),
                           INT8_C( -75), INT8_C(  25), INT8_C(  79), INT8_C(-101),
                           INT8_C(-122), INT8_C(-107), INT8_C( -10), INT8_C(-109),
                           INT8_C( -96), INT8_C(  45), INT8_C(  31), INT8_C( -60),
                           INT8_C( 100), INT8_C( 115), INT8_C(  79), INT8_C(  38),
                           INT8_C( -35), INT8_C(  57), INT8_C(  13), INT8_C(  93),
                           INT8_C(  54), INT8_C( -61), INT8_C( 101), INT8_C(-113)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(-105), INT8_C(   9),
                           INT8_C( -52), INT8_C(  54), INT8_C( -11), INT8_C( -39),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  26), INT8_C( 104),
                           INT8_C( -52), INT8_C( 109), INT8_C(   5), INT8_C(  87)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_alignr_epi8(test_vec[i].a, test_vec[i].b, 26);
    simde_assert_m256i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_and_si256(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi64x(INT64_C( 8722470578646828517), INT64_C(  891261850847437783),
                             INT64_C( 8698554819020653857), INT64_C(-7282900013878242954)),
      simde_mm256_set_epi64x(INT64_C(-8128142018056442141), INT64_C( 5559182722028422309),
                             INT64_C( 2093267872519066825), INT64_C(-7117023562774970023)),
      simde_mm256_set_epi64x(INT64_C(  648519197013312737), INT64_C(  866420841735143557),
                             INT64_C( 1730587322060899329), INT64_C(-7482378910948097712)) },
    { simde_mm256_set_epi64x(INT64_C(-2297219683620407228), INT64_C(-2314825045857877411),
                             INT64_C(-2223407797787304327), INT64_C( 5408595704702705619)),
      simde_mm256_set_epi64x(INT64_C( 1902387556947256757), INT64_C(-4636290958455233996),
                             INT64_C( -193279292138890017), INT64_C( 2387678637527501964)),
      simde_mm256_set_epi64x(INT64_C(    1867272746704900), INT64_C(-6944527661819330028),
                             INT64_C(-2233693047608222631), INT64_C(   72674428659436672)) },
    { simde_mm256_set_epi64x(INT64_C(-8083909718117301567), INT64_C(   11995607010100125),
                             INT64_C(-6068617776224060223), INT64_C(-6387203967446836987)),
      simde_mm256_set_epi64x(INT64_C(-8320376883848651160), INT64_C(-4950145821323384534),
                             INT64_C(-7969688999974624617), INT64_C(  659904372446782737)),
      simde_mm256_set_epi64x(INT64_C(-8322647438183611840), INT64_C(    2406350531494152),
                             INT64_C(-9131628786599059327), INT64_C(   74330855942160641)) },
    { simde_mm256_set_epi64x(INT64_C(-7862557356832127783), INT64_C(-5197238245936512816),
                             INT64_C(-1440736387308233171), INT64_C( -422437923560182700)),
      simde_mm256_set_epi64x(INT64_C( 4501573497311276896), INT64_C( 1568099047173454230),
                             INT64_C( 6784671475384752865), INT64_C(-5901872067663085826)),
      simde_mm256_set_epi64x(INT64_C( 1324204786773460032), INT64_C( 1568098471546732688),
                             INT64_C( 5476791399028365857), INT64_C(-6196932668584612780)) },
    { simde_mm256_set_epi64x(INT64_C(  -83457062575009429), INT64_C(-7222721162513873213),
                             INT64_C( 8275972355230696496), INT64_C( 5685146925209815999)),
      simde_mm256_set_epi64x(INT64_C( 7621095561231011691), INT64_C(-1384347240916299959),
                             INT64_C( 8784701942784527649), INT64_C(-6329984144489188000)),
      simde_mm256_set_epi64x(INT64_C( 7549018173429252459), INT64_C(-8592431562369268159),
                             INT64_C( 8126746635764630560), INT64_C(  586910516468318496)) },
    { simde_mm256_set_epi64x(INT64_C( 5973184558080946927), INT64_C(-1786695518880322601),
                             INT64_C(  564422817571527071), INT64_C( 4038585732338755869)),
      simde_mm256_set_epi64x(INT64_C(-8901168232869945121), INT64_C( 8118630853720063073),
                             INT64_C( -228868271804772649), INT64_C(-6456700929251086932)),
      simde_mm256_set_epi64x(INT64_C(   27024505729917135), INT64_C( 6926573216261613633),
                             INT64_C(  346814025888696471), INT64_C( 2306177340255840524)) },
    { simde_mm256_set_epi64x(INT64_C( 4967668340414178010), INT64_C(-2410168209476403592),
                             INT64_C(-3019436090811439415), INT64_C(-6965119139859890192)),
      simde_mm256_set_epi64x(INT64_C(-5120337331222163918), INT64_C(-1589564432494918546),
                             INT64_C( 5292723257474752308), INT64_C( 2511807878775255697)),
      simde_mm256_set_epi64x(INT64_C(   67729921108361746), INT64_C(-3999169530918599576),
                             INT64_C( 4616337787987166720), INT64_C(  167381957966049936)) },
    { simde_mm256_set_epi64x(INT64_C(-6179811667909625694), INT64_C(-2471055444546593648),
                             INT64_C( 7540412455883833292), INT64_C( 6654843089135720963)),
      simde_mm256_set_epi64x(INT64_C( -939588147635733509), INT64_C(-1340596046637757449),
                             INT64_C(-1662948605324253370), INT64_C(  817158485966988858)),
      simde_mm256_set_epi64x(INT64_C(-6758530821969135454), INT64_C(-3664509346923870064),
                             INT64_C( 7540157231680104260), INT64_C(  599541701488411138)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_and_si256(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i64(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_andnot_si256(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
   { simde_mm256_set_epi32(INT32_C( 1296069903), INT32_C( -401713319), INT32_C( -398512257), INT32_C( 1831595067),
                            INT32_C(  -79935516), INT32_C(-1180021826), INT32_C( 1322035843), INT32_C( 1532358492)),
      simde_mm256_set_epi32(INT32_C( 1994603249), INT32_C(-1155877896), INT32_C( 1480474617), INT32_C( 1055447888),
                            INT32_C( 1247599905), INT32_C( -290225910), INT32_C(  -75325456), INT32_C( 1443351725)),
      simde_mm256_set_epi32(INT32_C(  849545968), INT32_C(  319856800), INT32_C(  268439680), INT32_C(  314577728),
                            INT32_C(    4233217), INT32_C( 1175552000), INT32_C(-1325263504), INT32_C(   67240097)) },
    { simde_mm256_set_epi32(INT32_C(  751085853), INT32_C(  464664830), INT32_C( 1171943738), INT32_C(  238039385),
                            INT32_C(  447621112), INT32_C( -944668210), INT32_C(  -26835475), INT32_C( -497913063)),
      simde_mm256_set_epi32(INT32_C( -346681351), INT32_C( 1057375625), INT32_C(-1640028951), INT32_C( 1365052187),
                            INT32_C( 1146265967), INT32_C( -337636497), INT32_C(-2119055512), INT32_C(-1077772260)),
      simde_mm256_set_epi32(INT32_C(-1022228768), INT32_C(  604259585), INT32_C(-1708849983), INT32_C( 1364003330),
                            INT32_C( 1146126343), INT32_C(  675287585), INT32_C(   26296832), INT32_C(  494960644)) },
    { simde_mm256_set_epi32(INT32_C( 1652916374), INT32_C(  430611066), INT32_C(-1135996673), INT32_C( 1059116837),
                            INT32_C(  642663426), INT32_C(-2076745619), INT32_C(-1526373034), INT32_C(-1938949753)),
      simde_mm256_set_epi32(INT32_C(   21997480), INT32_C( 2006437191), INT32_C(-1106118986), INT32_C( -552923366),
                            INT32_C( 1259738142), INT32_C(-1272739174), INT32_C(  256185924), INT32_C(  828965431)),
      simde_mm256_set_epi32(INT32_C(   21636904), INT32_C( 1712669957), INT32_C(   34727424), INT32_C(-1073018854),
                            INT32_C( 1225789468), INT32_C(  805341842), INT32_C(  171971072), INT32_C(  822084144)) },
    { simde_mm256_set_epi32(INT32_C( 1850172884), INT32_C(  347371552), INT32_C(-2124471172), INT32_C(-1122146912),
                            INT32_C(-2084330368), INT32_C(-1474045155), INT32_C(-1097896595), INT32_C( -157279178)),
      simde_mm256_set_epi32(INT32_C( 1150160686), INT32_C( 1294066543), INT32_C(-1264650397), INT32_C( -958193094),
                            INT32_C( 1906124487), INT32_C(-1106662757), INT32_C(-1281709058), INT32_C(-1981986383)),
      simde_mm256_set_epi32(INT32_C(    8915498), INT32_C( 1224835919), INT32_C(  880857859), INT32_C( 1122107930),
                            INT32_C( 1880883783), INT32_C(  369631362), INT32_C(   17859218), INT32_C(  157106561)) },
    { simde_mm256_set_epi32(INT32_C( 1083224354), INT32_C(-2047292862), INT32_C(-1063111811), INT32_C(  679392193),
                            INT32_C(-1649939198), INT32_C(  165669772), INT32_C(-1686920475), INT32_C( -669365464)),
      simde_mm256_set_epi32(INT32_C(    1910614), INT32_C( 1742547828), INT32_C( 1824050734), INT32_C( 1245292821),
                            INT32_C( 1373149632), INT32_C(-1705573089), INT32_C(-2120011139), INT32_C( 1659478998)),
      simde_mm256_set_epi32(INT32_C(     853588), INT32_C( 1644503348), INT32_C(  739822594), INT32_C( 1107363860),
                            INT32_C( 1079513280), INT32_C(-1845492717), INT32_C(    8392728), INT32_C(  585212118)) },
    { simde_mm256_set_epi32(INT32_C( -215087200), INT32_C(  439485206), INT32_C(   52069439), INT32_C( 1985678052),
                            INT32_C(  236126003), INT32_C( 1543880509), INT32_C(-1076073317), INT32_C(  911942733)),
      simde_mm256_set_epi32(INT32_C(  289944943), INT32_C( 1791469709), INT32_C(-1356404241), INT32_C(-2084942503),
                            INT32_C(-1405988531), INT32_C(   52512230), INT32_C( -191001241), INT32_C(   11336758)),
      simde_mm256_set_epi32(INT32_C(    4206671), INT32_C( 1623566473), INT32_C(-1406899776), INT32_C(-2120202983),
                            INT32_C(-1608515508), INT32_C(   52445378), INT32_C( 1073840484), INT32_C(   10803250)) },
    { simde_mm256_set_epi32(INT32_C( -255265247), INT32_C(  884745637), INT32_C(-1256896434), INT32_C( 1712403469),
                            INT32_C(-1168205511), INT32_C( 1417172277), INT32_C(    6510726), INT32_C( 1896753771)),
      simde_mm256_set_epi32(INT32_C( 1154369104), INT32_C( 1355111439), INT32_C(  107073276), INT32_C( 1081379485),
                            INT32_C( -791672049), INT32_C(-1430371667), INT32_C( 1251404018), INT32_C(  686255615)),
      simde_mm256_set_epi32(INT32_C(   67502160), INT32_C( 1078024202), INT32_C(   39880368), INT32_C(    6589072),
                            INT32_C( 1082130950), INT32_C(-1434058104), INT32_C( 1251254384), INT32_C(  148981140)) },
    { simde_mm256_set_epi32(INT32_C( 1670586553), INT32_C( 1338043318), INT32_C(-2053008274), INT32_C( 1109326069),
                            INT32_C(  858036123), INT32_C(  201080868), INT32_C( -768148447), INT32_C( 1651890892)),
      simde_mm256_set_epi32(INT32_C( 1950737481), INT32_C(-1368157265), INT32_C(  504476696), INT32_C(-1751057511),
                            INT32_C(-1576762410), INT32_C( 1167387907), INT32_C(  398094763), INT32_C( 1151527447)),
      simde_mm256_set_epi32(INT32_C(  340051008), INT32_C(-1607266295), INT32_C(  437264400), INT32_C(-1784675576),
                            INT32_C(-2147483580), INT32_C( 1140894979), INT32_C(   92799370), INT32_C(   75636755)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_andnot_si256(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_adds_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi8(INT8_C(-119), INT8_C( -56), INT8_C(  53), INT8_C(-117),
                           INT8_C(  25), INT8_C(  -8), INT8_C( -23), INT8_C( -22),
                           INT8_C( 105), INT8_C(  21), INT8_C( -22), INT8_C(-123),
                           INT8_C( -78), INT8_C(   1), INT8_C( 124), INT8_C(  72),
                           INT8_C( -56), INT8_C( 100), INT8_C( -58), INT8_C(  52),
                           INT8_C( 106), INT8_C(-112), INT8_C( -69), INT8_C(-107),
                           INT8_C(  71), INT8_C( -50), INT8_C(  48), INT8_C( -51),
                           INT8_C( -22), INT8_C( 119), INT8_C(  38), INT8_C(-116)),
      simde_mm256_set_epi8(INT8_C( -61), INT8_C(  39), INT8_C( 108), INT8_C( 116),
                           INT8_C(   8), INT8_C(  57), INT8_C( -68), INT8_C(-111),
                           INT8_C(  66), INT8_C(-114), INT8_C(  86), INT8_C(  70),
                           INT8_C(  95), INT8_C(  18), INT8_C(  95), INT8_C(  15),
                           INT8_C( -45), INT8_C(  91), INT8_C(  47), INT8_C( 120),
                           INT8_C(-127), INT8_C(  -1), INT8_C(  68), INT8_C(-116),
                           INT8_C(  47), INT8_C(  11), INT8_C( -19), INT8_C( -17),
                           INT8_C(-114), INT8_C(  40), INT8_C( -43), INT8_C( -57)),
      simde_mm256_set_epi8(INT8_C(-128), INT8_C( -17), INT8_C( 127), INT8_C(  -1),
                           INT8_C(  33), INT8_C(  49), INT8_C( -91), INT8_C(-128),
                           INT8_C( 127), INT8_C( -93), INT8_C(  64), INT8_C( -53),
                           INT8_C(  17), INT8_C(  19), INT8_C( 127), INT8_C(  87),
                           INT8_C(-101), INT8_C( 127), INT8_C( -11), INT8_C( 127),
                           INT8_C( -21), INT8_C(-113), INT8_C(  -1), INT8_C(-128),
                           INT8_C( 118), INT8_C( -39), INT8_C(  29), INT8_C( -68),
                           INT8_C(-128), INT8_C( 127), INT8_C(  -5), INT8_C(-128)) },
    { simde_mm256_set_epi8(INT8_C(  39), INT8_C(  31), INT8_C( -61), INT8_C( -35),
                           INT8_C(  33), INT8_C(  40), INT8_C( 126), INT8_C( 109),
                           INT8_C(   9), INT8_C( 100), INT8_C(-107), INT8_C(  27),
                           INT8_C( -15), INT8_C(  43), INT8_C(-116), INT8_C(-111),
                           INT8_C( -44), INT8_C(-120), INT8_C(  17), INT8_C( -18),
                           INT8_C( -10), INT8_C( -86), INT8_C(   7), INT8_C(  61),
                           INT8_C( -46), INT8_C( -53), INT8_C(  -3), INT8_C(  98),
                           INT8_C( -75), INT8_C( -98), INT8_C(  77), INT8_C( 102)),
      simde_mm256_set_epi8(INT8_C(-107), INT8_C(-113), INT8_C(   9), INT8_C(  35),
                           INT8_C(  62), INT8_C( -77), INT8_C(   0), INT8_C(   9),
                           INT8_C(  -7), INT8_C(  23), INT8_C( -88), INT8_C( -35),
                           INT8_C(  78), INT8_C(   7), INT8_C(  79), INT8_C( -98),
                           INT8_C( -54), INT8_C(  87), INT8_C( 123), INT8_C(  91),
                           INT8_C( 116), INT8_C(  67), INT8_C( 110), INT8_C(  43),
                           INT8_C( -68), INT8_C( -85), INT8_C( -23), INT8_C( -82),
                           INT8_C(  66), INT8_C(-119), INT8_C( -51), INT8_C(  79)),
      simde_mm256_set_epi8(INT8_C( -68), INT8_C( -82), INT8_C( -52), INT8_C(   0),
                           INT8_C(  95), INT8_C( -37), INT8_C( 126), INT8_C( 118),
                           INT8_C(   2), INT8_C( 123), INT8_C(-128), INT8_C(  -8),
                           INT8_C(  63), INT8_C(  50), INT8_C( -37), INT8_C(-128),
                           INT8_C( -98), INT8_C( -33), INT8_C( 127), INT8_C(  73),
                           INT8_C( 106), INT8_C( -19), INT8_C( 117), INT8_C( 104),
                           INT8_C(-114), INT8_C(-128), INT8_C( -26), INT8_C(  16),
                           INT8_C(  -9), INT8_C(-128), INT8_C(  26), INT8_C( 127)) },
    { simde_mm256_set_epi8(INT8_C( -96), INT8_C(  -2), INT8_C(-104), INT8_C(  30),
                           INT8_C( -98), INT8_C(-110), INT8_C( -27), INT8_C(   8),
                           INT8_C(  36), INT8_C( -65), INT8_C(  59), INT8_C(  66),
                           INT8_C( -66), INT8_C( -58), INT8_C( 111), INT8_C(  36),
                           INT8_C(  35), INT8_C(  -4), INT8_C( -85), INT8_C(  66),
                           INT8_C( 120), INT8_C(  62), INT8_C(  85), INT8_C(  -9),
                           INT8_C(  -9), INT8_C( -49), INT8_C(  90), INT8_C( -80),
                           INT8_C( -89), INT8_C( -62), INT8_C(-127), INT8_C(-100)),
      simde_mm256_set_epi8(INT8_C( -67), INT8_C(  11), INT8_C( -39), INT8_C(  56),
                           INT8_C( -35), INT8_C( 114), INT8_C(  34), INT8_C( -29),
                           INT8_C(  -3), INT8_C( 101), INT8_C( 115), INT8_C(  44),
                           INT8_C(  36), INT8_C( -77), INT8_C(  98), INT8_C( 105),
                           INT8_C(  91), INT8_C(  26), INT8_C(   9), INT8_C(   8),
                           INT8_C(  79), INT8_C(  -2), INT8_C( -60), INT8_C(  45),
                           INT8_C(-118), INT8_C( -81), INT8_C(  63), INT8_C( -54),
                           INT8_C( -51), INT8_C(  41), INT8_C(  33), INT8_C( -19)),
      simde_mm256_set_epi8(INT8_C(-128), INT8_C(   9), INT8_C(-128), INT8_C(  86),
                           INT8_C(-128), INT8_C(   4), INT8_C(   7), INT8_C( -21),
                           INT8_C(  33), INT8_C(  36), INT8_C( 127), INT8_C( 110),
                           INT8_C( -30), INT8_C(-128), INT8_C( 127), INT8_C( 127),
                           INT8_C( 126), INT8_C(  22), INT8_C( -76), INT8_C(  74),
                           INT8_C( 127), INT8_C(  60), INT8_C(  25), INT8_C(  36),
                           INT8_C(-127), INT8_C(-128), INT8_C( 127), INT8_C(-128),
                           INT8_C(-128), INT8_C( -21), INT8_C( -94), INT8_C(-119)) },
    { simde_mm256_set_epi8(INT8_C( -17), INT8_C( -49), INT8_C(  22), INT8_C( -45),
                           INT8_C(  54), INT8_C(  22), INT8_C( -24), INT8_C( 117),
                           INT8_C( -78), INT8_C( 103), INT8_C(-105), INT8_C(  94),
                           INT8_C(-107), INT8_C(   6), INT8_C(-126), INT8_C(  89),
                           INT8_C(  17), INT8_C(   8), INT8_C(  15), INT8_C( -34),
                           INT8_C(  29), INT8_C(  90), INT8_C(  96), INT8_C( -78),
                           INT8_C( -87), INT8_C( -25), INT8_C(  62), INT8_C(  48),
                           INT8_C(-125), INT8_C( -71), INT8_C( -72), INT8_C(  85)),
      simde_mm256_set_epi8(INT8_C( -54), INT8_C(  53), INT8_C( -73), INT8_C( -38),
                           INT8_C(-124), INT8_C(  23), INT8_C(  96), INT8_C( -55),
                           INT8_C(  34), INT8_C( 108), INT8_C( -62), INT8_C(-104),
                           INT8_C(  81), INT8_C( -26), INT8_C(  -9), INT8_C( -47),
                           INT8_C( -73), INT8_C(  27), INT8_C( -45), INT8_C(-119),
                           INT8_C(-120), INT8_C(-121), INT8_C(  67), INT8_C( -46),
                           INT8_C(  17), INT8_C( 101), INT8_C(  16), INT8_C(-101),
                           INT8_C( -58), INT8_C(  77), INT8_C( -17), INT8_C( -35)),
      simde_mm256_set_epi8(INT8_C( -71), INT8_C(   4), INT8_C( -51), INT8_C( -83),
                           INT8_C( -70), INT8_C(  45), INT8_C(  72), INT8_C(  62),
                           INT8_C( -44), INT8_C( 127), INT8_C(-128), INT8_C( -10),
                           INT8_C( -26), INT8_C( -20), INT8_C(-128), INT8_C(  42),
                           INT8_C( -56), INT8_C(  35), INT8_C( -30), INT8_C(-128),
                           INT8_C( -91), INT8_C( -31), INT8_C( 127), INT8_C(-124),
                           INT8_C( -70), INT8_C(  76), INT8_C(  78), INT8_C( -53),
                           INT8_C(-128), INT8_C(   6), INT8_C( -89), INT8_C(  50)) },
    { simde_mm256_set_epi8(INT8_C(  99), INT8_C(  94), INT8_C( -71), INT8_C(  34),
                           INT8_C(-112), INT8_C(  96), INT8_C( -20), INT8_C( -14),
                           INT8_C(  85), INT8_C( 101), INT8_C(-125), INT8_C( -64),
                           INT8_C(  54), INT8_C( -63), INT8_C( -68), INT8_C( -91),
                           INT8_C(  62), INT8_C( -51), INT8_C(  27), INT8_C(  22),
                           INT8_C( -58), INT8_C(  12), INT8_C(   9), INT8_C( -36),
                           INT8_C(  40), INT8_C( -72), INT8_C( -90), INT8_C(  -3),
                           INT8_C( -94), INT8_C( -54), INT8_C(  87), INT8_C( -43)),
      simde_mm256_set_epi8(INT8_C(  99), INT8_C( -12), INT8_C(  40), INT8_C( -99),
                           INT8_C(  48), INT8_C(-109), INT8_C(  57), INT8_C( 112),
                           INT8_C( -67), INT8_C( -21), INT8_C(  14), INT8_C(  22),
                           INT8_C( -61), INT8_C( -64), INT8_C(  99), INT8_C( -14),
                           INT8_C( 121), INT8_C( 116), INT8_C( 125), INT8_C( -80),
                           INT8_C( -90), INT8_C( -41), INT8_C(  82), INT8_C( 106),
                           INT8_C( -62), INT8_C( -13), INT8_C( -52), INT8_C( -14),
                           INT8_C( -76), INT8_C(-109), INT8_C( 112), INT8_C( -92)),
      simde_mm256_set_epi8(INT8_C( 127), INT8_C(  82), INT8_C( -31), INT8_C( -65),
                           INT8_C( -64), INT8_C( -13), INT8_C(  37), INT8_C(  98),
                           INT8_C(  18), INT8_C(  80), INT8_C(-111), INT8_C( -42),
                           INT8_C(  -7), INT8_C(-127), INT8_C(  31), INT8_C(-105),
                           INT8_C( 127), INT8_C(  65), INT8_C( 127), INT8_C( -58),
                           INT8_C(-128), INT8_C( -29), INT8_C(  91), INT8_C(  70),
                           INT8_C( -22), INT8_C( -85), INT8_C(-128), INT8_C( -17),
                           INT8_C(-128), INT8_C(-128), INT8_C( 127), INT8_C(-128)) },
    { simde_mm256_set_epi8(INT8_C( -49), INT8_C( 105), INT8_C(-105), INT8_C(  27),
                           INT8_C( -85), INT8_C(  38), INT8_C(-122), INT8_C(  31),
                           INT8_C( -23), INT8_C(  94), INT8_C(  33), INT8_C( 112),
                           INT8_C( 117), INT8_C(  95), INT8_C( 107), INT8_C( -60),
                           INT8_C(  41), INT8_C( -75), INT8_C( 112), INT8_C(-110),
                           INT8_C( 101), INT8_C( -13), INT8_C( 127), INT8_C( -84),
                           INT8_C( -84), INT8_C( -70), INT8_C( -49), INT8_C(  84),
                           INT8_C(  -1), INT8_C( -17), INT8_C(  -2), INT8_C(  84)),
      simde_mm256_set_epi8(INT8_C(-108), INT8_C(  63), INT8_C( 104), INT8_C(  -9),
                           INT8_C(  74), INT8_C( 114), INT8_C( -61), INT8_C(  39),
                           INT8_C(  15), INT8_C(   6), INT8_C(  41), INT8_C( 125),
                           INT8_C(  96), INT8_C( -39), INT8_C( -42), INT8_C(  75),
                           INT8_C( -60), INT8_C(  18), INT8_C(-100), INT8_C( -10),
                           INT8_C( -33), INT8_C( -88), INT8_C( -36), INT8_C(  79),
                           INT8_C(  49), INT8_C(  63), INT8_C( -18), INT8_C( -83),
                           INT8_C(  44), INT8_C(  75), INT8_C( -17), INT8_C(  -9)),
      simde_mm256_set_epi8(INT8_C(-128), INT8_C( 127), INT8_C(  -1), INT8_C(  18),
                           INT8_C( -11), INT8_C( 127), INT8_C(-128), INT8_C(  70),
                           INT8_C(  -8), INT8_C( 100), INT8_C(  74), INT8_C( 127),
                           INT8_C( 127), INT8_C(  56), INT8_C(  65), INT8_C(  15),
                           INT8_C( -19), INT8_C( -57), INT8_C(  12), INT8_C(-120),
                           INT8_C(  68), INT8_C(-101), INT8_C(  91), INT8_C(  -5),
                           INT8_C( -35), INT8_C(  -7), INT8_C( -67), INT8_C(   1),
                           INT8_C(  43), INT8_C(  58), INT8_C( -19), INT8_C(  75)) },
    { simde_mm256_set_epi8(INT8_C( -41), INT8_C( -94), INT8_C(  69), INT8_C( 109),
                           INT8_C(-102), INT8_C(  64), INT8_C( 116), INT8_C(  22),
                           INT8_C( -63), INT8_C(  76), INT8_C( -59), INT8_C( -94),
                           INT8_C(  69), INT8_C(   1), INT8_C( -30), INT8_C( 101),
                           INT8_C( 121), INT8_C(  10), INT8_C( -82), INT8_C( -33),
                           INT8_C( -83), INT8_C( -50), INT8_C(-111), INT8_C( -72),
                           INT8_C(  42), INT8_C(-125), INT8_C(-128), INT8_C(  -8),
                           INT8_C(  27), INT8_C( -93), INT8_C(-126), INT8_C( -77)),
      simde_mm256_set_epi8(INT8_C(  -9), INT8_C( -48), INT8_C(  73), INT8_C(  31),
                           INT8_C( 127), INT8_C(  88), INT8_C(  20), INT8_C( -82),
                           INT8_C( -19), INT8_C(   3), INT8_C(  83), INT8_C( 114),
                           INT8_C(   1), INT8_C(  31), INT8_C(  44), INT8_C(   5),
                           INT8_C( -63), INT8_C( -96), INT8_C(   2), INT8_C(-126),
                           INT8_C(  96), INT8_C( -97), INT8_C( -87), INT8_C( -40),
                           INT8_C(-112), INT8_C(  92), INT8_C( -98), INT8_C( -50),
                           INT8_C(  63), INT8_C( -57), INT8_C(  24), INT8_C( -21)),
      simde_mm256_set_epi8(INT8_C( -50), INT8_C(-128), INT8_C( 127), INT8_C( 127),
                           INT8_C(  25), INT8_C( 127), INT8_C( 127), INT8_C( -60),
                           INT8_C( -82), INT8_C(  79), INT8_C(  24), INT8_C(  20),
                           INT8_C(  70), INT8_C(  32), INT8_C(  14), INT8_C( 106),
                           INT8_C(  58), INT8_C( -86), INT8_C( -80), INT8_C(-128),
                           INT8_C(  13), INT8_C(-128), INT8_C(-128), INT8_C(-112),
                           INT8_C( -70), INT8_C( -33), INT8_C(-128), INT8_C( -58),
                           INT8_C(  90), INT8_C(-128), INT8_C(-102), INT8_C( -98)) },
    { simde_mm256_set_epi8(INT8_C(  59), INT8_C( -47), INT8_C(  -6), INT8_C( 114),
                           INT8_C( 104), INT8_C(  53), INT8_C(-112), INT8_C(  19),
                           INT8_C( 115), INT8_C(  22), INT8_C(  66), INT8_C(  27),
                           INT8_C( -25), INT8_C( -41), INT8_C(-111), INT8_C( 115),
                           INT8_C( -21), INT8_C( -32), INT8_C(  -5), INT8_C(  11),
                           INT8_C(  -6), INT8_C( 110), INT8_C( -89), INT8_C( -64),
                           INT8_C(-104), INT8_C(  74), INT8_C( -29), INT8_C(  87),
                           INT8_C(  -8), INT8_C(  96), INT8_C(   5), INT8_C( 122)),
      simde_mm256_set_epi8(INT8_C(  43), INT8_C(  18), INT8_C(  50), INT8_C(-115),
                           INT8_C(  38), INT8_C( -78), INT8_C( -51), INT8_C(  97),
                           INT8_C(  30), INT8_C(   7), INT8_C( -46), INT8_C( -16),
                           INT8_C( 109), INT8_C(-103), INT8_C( -61), INT8_C(  64),
                           INT8_C(  60), INT8_C( -63), INT8_C( -52), INT8_C( -15),
                           INT8_C( 104), INT8_C( 105), INT8_C(  61), INT8_C( 106),
                           INT8_C( -66), INT8_C( 111), INT8_C( -25), INT8_C(  24),
                           INT8_C(  28), INT8_C( 102), INT8_C(   8), INT8_C(  93)),
      simde_mm256_set_epi8(INT8_C( 102), INT8_C( -29), INT8_C(  44), INT8_C(  -1),
                           INT8_C( 127), INT8_C( -25), INT8_C(-128), INT8_C( 116),
                           INT8_C( 127), INT8_C(  29), INT8_C(  20), INT8_C(  11),
                           INT8_C(  84), INT8_C(-128), INT8_C(-128), INT8_C( 127),
                           INT8_C(  39), INT8_C( -95), INT8_C( -57), INT8_C(  -4),
                           INT8_C(  98), INT8_C( 127), INT8_C( -28), INT8_C(  42),
                           INT8_C(-128), INT8_C( 127), INT8_C( -54), INT8_C( 111),
                           INT8_C(  20), INT8_C( 127), INT8_C(  13), INT8_C( 127)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_adds_epi8(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_adds_epi16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi16(INT16_C(  -962), INT16_C( 12004), INT16_C( 15276), INT16_C( 19344),
                            INT16_C(  1682), INT16_C( 24393), INT16_C(-26791), INT16_C( 15115),
                            INT16_C( 26019), INT16_C(-25175), INT16_C(-17857), INT16_C( 29245),
                            INT16_C( -3095), INT16_C( -1043), INT16_C(  8684), INT16_C( -4510)),
      simde_mm256_set_epi16(INT16_C(  1387), INT16_C(  5995), INT16_C( 24092), INT16_C(-22020),
                            INT16_C( 17334), INT16_C(-21406), INT16_C(  5443), INT16_C( -4682),
                            INT16_C( 19873), INT16_C(-31638), INT16_C( 16556), INT16_C(-22745),
                            INT16_C(  6086), INT16_C(-26599), INT16_C(-32635), INT16_C( 18742)),
      simde_mm256_set_epi16(INT16_C(   425), INT16_C( 17999), INT16_C( 32767), INT16_C( -2676),
                            INT16_C( 19016), INT16_C(  2987), INT16_C(-21348), INT16_C( 10433),
                            INT16_C( 32767), INT16_C(-32768), INT16_C( -1301), INT16_C(  6500),
                            INT16_C(  2991), INT16_C(-27642), INT16_C(-23951), INT16_C( 14232)) },
    { simde_mm256_set_epi16(INT16_C(-15667), INT16_C( -4604), INT16_C( -1424), INT16_C( 14196),
                            INT16_C( -3271), INT16_C(-28350), INT16_C( 32228), INT16_C(-15812),
                            INT16_C( -3284), INT16_C(  -332), INT16_C(-21864), INT16_C(-23002),
                            INT16_C( 15429), INT16_C( 22829), INT16_C( -2222), INT16_C( 22367)),
      simde_mm256_set_epi16(INT16_C(  2292), INT16_C( 20266), INT16_C( 19204), INT16_C(-18548),
                            INT16_C(-10545), INT16_C( 20262), INT16_C( 18576), INT16_C( 18942),
                            INT16_C( 30300), INT16_C( -3505), INT16_C( 25496), INT16_C(-21517),
                            INT16_C( 23044), INT16_C( 26958), INT16_C( 16161), INT16_C( -8396)),
      simde_mm256_set_epi16(INT16_C(-13375), INT16_C( 15662), INT16_C( 17780), INT16_C( -4352),
                            INT16_C(-13816), INT16_C( -8088), INT16_C( 32767), INT16_C(  3130),
                            INT16_C( 27016), INT16_C( -3837), INT16_C(  3632), INT16_C(-32768),
                            INT16_C( 32767), INT16_C( 32767), INT16_C( 13939), INT16_C( 13971)) },
    { simde_mm256_set_epi16(INT16_C(-13807), INT16_C(-17934), INT16_C( 30355), INT16_C(  -764),
                            INT16_C( -4690), INT16_C( 11643), INT16_C( 12025), INT16_C( 13748),
                            INT16_C( 20416), INT16_C(-20138), INT16_C( -7279), INT16_C(-10075),
                            INT16_C( 30794), INT16_C( -8219), INT16_C(  7665), INT16_C( 31634)),
      simde_mm256_set_epi16(INT16_C( 19174), INT16_C( 30134), INT16_C(  -229), INT16_C( 19963),
                            INT16_C( -2304), INT16_C( 30679), INT16_C( 27179), INT16_C(-10745),
                            INT16_C(-27839), INT16_C( -4281), INT16_C( 23775), INT16_C( -9849),
                            INT16_C(-26461), INT16_C(-25537), INT16_C( -6859), INT16_C(-14106)),
      simde_mm256_set_epi16(INT16_C(  5367), INT16_C( 12200), INT16_C( 30126), INT16_C( 19199),
                            INT16_C( -6994), INT16_C( 32767), INT16_C( 32767), INT16_C(  3003),
                            INT16_C( -7423), INT16_C(-24419), INT16_C( 16496), INT16_C(-19924),
                            INT16_C(  4333), INT16_C(-32768), INT16_C(   806), INT16_C( 17528)) },
    { simde_mm256_set_epi16(INT16_C( -5643), INT16_C( 16549), INT16_C( 27397), INT16_C(-21486),
                            INT16_C( -4783), INT16_C( -4255), INT16_C( -9777), INT16_C( -2005),
                            INT16_C( -5487), INT16_C(  4410), INT16_C(  9721), INT16_C(-18951),
                            INT16_C( 27380), INT16_C( 27675), INT16_C(-18193), INT16_C( -8216)),
      simde_mm256_set_epi16(INT16_C(  3093), INT16_C(-27399), INT16_C( 25399), INT16_C( 21162),
                            INT16_C(-20342), INT16_C(-26357), INT16_C( 20961), INT16_C(-29046),
                            INT16_C(-12304), INT16_C(-23482), INT16_C( 31742), INT16_C( 26191),
                            INT16_C( 32539), INT16_C( 28035), INT16_C( -8379), INT16_C( 32320)),
      simde_mm256_set_epi16(INT16_C( -2550), INT16_C(-10850), INT16_C( 32767), INT16_C(  -324),
                            INT16_C(-25125), INT16_C(-30612), INT16_C( 11184), INT16_C(-31051),
                            INT16_C(-17791), INT16_C(-19072), INT16_C( 32767), INT16_C(  7240),
                            INT16_C( 32767), INT16_C( 32767), INT16_C(-26572), INT16_C( 24104)) },
    { simde_mm256_set_epi16(INT16_C(  8117), INT16_C(   765), INT16_C( -4891), INT16_C( -1773),
                            INT16_C( 21984), INT16_C( 23512), INT16_C(  8564), INT16_C(   676),
                            INT16_C(-22280), INT16_C(  5831), INT16_C(-15902), INT16_C( 13241),
                            INT16_C(  6903), INT16_C( -2164), INT16_C(-27428), INT16_C(-27012)),
      simde_mm256_set_epi16(INT16_C( 12023), INT16_C(-19040), INT16_C( 31146), INT16_C(-18380),
                            INT16_C(-24072), INT16_C( 14767), INT16_C( 22843), INT16_C( -2924),
                            INT16_C( -5044), INT16_C(-32368), INT16_C( 21585), INT16_C( -7796),
                            INT16_C( 32151), INT16_C(  8315), INT16_C( 19587), INT16_C(-17957)),
      simde_mm256_set_epi16(INT16_C( 20140), INT16_C(-18275), INT16_C( 26255), INT16_C(-20153),
                            INT16_C( -2088), INT16_C( 32767), INT16_C( 31407), INT16_C( -2248),
                            INT16_C(-27324), INT16_C(-26537), INT16_C(  5683), INT16_C(  5445),
                            INT16_C( 32767), INT16_C(  6151), INT16_C( -7841), INT16_C(-32768)) },
    { simde_mm256_set_epi16(INT16_C(-15432), INT16_C(-29555), INT16_C(-22086), INT16_C(-23352),
                            INT16_C(-24272), INT16_C( 28442), INT16_C( -6183), INT16_C( 20311),
                            INT16_C(-15448), INT16_C(-31565), INT16_C(-17613), INT16_C( -1655),
                            INT16_C( -3795), INT16_C( 27576), INT16_C(-23497), INT16_C( -9670)),
      simde_mm256_set_epi16(INT16_C(-16830), INT16_C(  -159), INT16_C(-22301), INT16_C(-32198),
                            INT16_C(  2834), INT16_C(   201), INT16_C(-29264), INT16_C( -1240),
                            INT16_C(  4796), INT16_C(-27180), INT16_C( 31617), INT16_C( -2210),
                            INT16_C( -9712), INT16_C( 10057), INT16_C( -1995), INT16_C( 27783)),
      simde_mm256_set_epi16(INT16_C(-32262), INT16_C(-29714), INT16_C(-32768), INT16_C(-32768),
                            INT16_C(-21438), INT16_C( 28643), INT16_C(-32768), INT16_C( 19071),
                            INT16_C(-10652), INT16_C(-32768), INT16_C( 14004), INT16_C( -3865),
                            INT16_C(-13507), INT16_C( 32767), INT16_C(-25492), INT16_C( 18113)) },
    { simde_mm256_set_epi16(INT16_C(-15154), INT16_C(  9051), INT16_C(  6258), INT16_C( -1499),
                            INT16_C(-27693), INT16_C( -8500), INT16_C(  -882), INT16_C(  9147),
                            INT16_C( 22175), INT16_C( 10790), INT16_C(-10382), INT16_C( 21347),
                            INT16_C( -8836), INT16_C(-17904), INT16_C(-31823), INT16_C(-28959)),
      simde_mm256_set_epi16(INT16_C( 31738), INT16_C( 18200), INT16_C(-12479), INT16_C(   972),
                            INT16_C(-30550), INT16_C(-19770), INT16_C( 32501), INT16_C( -4294),
                            INT16_C(-22747), INT16_C(-27490), INT16_C(-20241), INT16_C(-31535),
                            INT16_C(-31518), INT16_C(-18415), INT16_C( 12039), INT16_C(-31202)),
      simde_mm256_set_epi16(INT16_C( 16584), INT16_C( 27251), INT16_C( -6221), INT16_C(  -527),
                            INT16_C(-32768), INT16_C(-28270), INT16_C( 31619), INT16_C(  4853),
                            INT16_C(  -572), INT16_C(-16700), INT16_C(-30623), INT16_C(-10188),
                            INT16_C(-32768), INT16_C(-32768), INT16_C(-19784), INT16_C(-32768)) },
    { simde_mm256_set_epi16(INT16_C(-23218), INT16_C(-16504), INT16_C(-28974), INT16_C(-20854),
                            INT16_C( 27922), INT16_C(   717), INT16_C(-10156), INT16_C( 13317),
                            INT16_C( 12071), INT16_C(-29036), INT16_C( 16491), INT16_C(  6863),
                            INT16_C(  3054), INT16_C( -8502), INT16_C(-19858), INT16_C(-20664)),
      simde_mm256_set_epi16(INT16_C(-22864), INT16_C(-13701), INT16_C( -9243), INT16_C( -4457),
                            INT16_C( 16105), INT16_C(  3518), INT16_C(-11607), INT16_C(-19946),
                            INT16_C(  5641), INT16_C(  8617), INT16_C(-22446), INT16_C(  2151),
                            INT16_C( 16533), INT16_C(-18326), INT16_C( 16839), INT16_C( 26518)),
      simde_mm256_set_epi16(INT16_C(-32768), INT16_C(-30205), INT16_C(-32768), INT16_C(-25311),
                            INT16_C( 32767), INT16_C(  4235), INT16_C(-21763), INT16_C( -6629),
                            INT16_C( 17712), INT16_C(-20419), INT16_C( -5955), INT16_C(  9014),
                            INT16_C( 19587), INT16_C(-26828), INT16_C( -3019), INT16_C(  5854)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_adds_epi16(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_adds_epu8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_x_mm256_set_epu8(UINT8_C(253), UINT8_C(134), UINT8_C(240), UINT8_C(121),
                             UINT8_C(194), UINT8_C(  6), UINT8_C( 90), UINT8_C(185),
                             UINT8_C( 52), UINT8_C(188), UINT8_C(255), UINT8_C(213),
                             UINT8_C( 70), UINT8_C(140), UINT8_C( 59), UINT8_C(206),
                             UINT8_C( 91), UINT8_C( 56), UINT8_C(139), UINT8_C( 19),
                             UINT8_C( 62), UINT8_C( 91), UINT8_C( 24), UINT8_C( 86),
                             UINT8_C(156), UINT8_C( 89), UINT8_C( 98), UINT8_C(113),
                             UINT8_C(237), UINT8_C(  2), UINT8_C(237), UINT8_C(177)),
      simde_x_mm256_set_epu8(UINT8_C(213), UINT8_C( 63), UINT8_C( 15), UINT8_C(166),
                             UINT8_C( 63), UINT8_C(196), UINT8_C(141), UINT8_C(108),
                             UINT8_C( 47), UINT8_C(216), UINT8_C( 17), UINT8_C(218),
                             UINT8_C(111), UINT8_C(130), UINT8_C(  1), UINT8_C(159),
                             UINT8_C( 50), UINT8_C(145), UINT8_C(171), UINT8_C( 70),
                             UINT8_C( 84), UINT8_C(160), UINT8_C(222), UINT8_C(215),
                             UINT8_C( 44), UINT8_C(139), UINT8_C( 68), UINT8_C( 49),
                             UINT8_C(218), UINT8_C( 62), UINT8_C(151), UINT8_C(225)),
      simde_x_mm256_set_epu8(UINT8_C(255), UINT8_C(197), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(202), UINT8_C(231), UINT8_C(255),
                             UINT8_C( 99), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(181), UINT8_C(255), UINT8_C( 60), UINT8_C(255),
                             UINT8_C(141), UINT8_C(201), UINT8_C(255), UINT8_C( 89),
                             UINT8_C(146), UINT8_C(251), UINT8_C(246), UINT8_C(255),
                             UINT8_C(200), UINT8_C(228), UINT8_C(166), UINT8_C(162),
                             UINT8_C(255), UINT8_C( 64), UINT8_C(255), UINT8_C(255)) },
    { simde_x_mm256_set_epu8(UINT8_C( 46), UINT8_C( 60), UINT8_C( 83), UINT8_C( 69),
                             UINT8_C( 75), UINT8_C( 52), UINT8_C(182), UINT8_C( 56),
                             UINT8_C( 10), UINT8_C(180), UINT8_C(245), UINT8_C(208),
                             UINT8_C(165), UINT8_C( 77), UINT8_C(214), UINT8_C(172),
                             UINT8_C( 90), UINT8_C( 10), UINT8_C(190), UINT8_C(204),
                             UINT8_C(174), UINT8_C(200), UINT8_C( 75), UINT8_C(188),
                             UINT8_C(215), UINT8_C( 51), UINT8_C(188), UINT8_C( 47),
                             UINT8_C( 17), UINT8_C(116), UINT8_C(116), UINT8_C(103)),
      simde_x_mm256_set_epu8(UINT8_C( 76), UINT8_C( 23), UINT8_C( 40), UINT8_C(  7),
                             UINT8_C( 32), UINT8_C(238), UINT8_C(187), UINT8_C( 34),
                             UINT8_C(130), UINT8_C(185), UINT8_C(135), UINT8_C( 64),
                             UINT8_C(167), UINT8_C(215), UINT8_C(226), UINT8_C(221),
                             UINT8_C( 22), UINT8_C( 21), UINT8_C( 86), UINT8_C(166),
                             UINT8_C( 38), UINT8_C( 88), UINT8_C(194), UINT8_C( 97),
                             UINT8_C( 79), UINT8_C(177), UINT8_C(251), UINT8_C(218),
                             UINT8_C( 76), UINT8_C(121), UINT8_C(164), UINT8_C( 80)),
      simde_x_mm256_set_epu8(UINT8_C(122), UINT8_C( 83), UINT8_C(123), UINT8_C( 76),
                             UINT8_C(107), UINT8_C(255), UINT8_C(255), UINT8_C( 90),
                             UINT8_C(140), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(112), UINT8_C( 31), UINT8_C(255), UINT8_C(255),
                             UINT8_C(212), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(228), UINT8_C(255), UINT8_C(255),
                             UINT8_C( 93), UINT8_C(237), UINT8_C(255), UINT8_C(183)) },
    { simde_x_mm256_set_epu8(UINT8_C( 62), UINT8_C(125), UINT8_C(167), UINT8_C( 69),
                             UINT8_C(185), UINT8_C(211), UINT8_C(194), UINT8_C( 87),
                             UINT8_C( 42), UINT8_C( 67), UINT8_C(196), UINT8_C(131),
                             UINT8_C( 56), UINT8_C(103), UINT8_C( 93), UINT8_C(201),
                             UINT8_C(200), UINT8_C( 67), UINT8_C(  5), UINT8_C(251),
                             UINT8_C(171), UINT8_C(  0), UINT8_C(242), UINT8_C(219),
                             UINT8_C( 52), UINT8_C( 56), UINT8_C(153), UINT8_C(193),
                             UINT8_C(206), UINT8_C(184), UINT8_C(179), UINT8_C(112)),
      simde_x_mm256_set_epu8(UINT8_C(  3), UINT8_C( 94), UINT8_C(  2), UINT8_C( 80),
                             UINT8_C( 75), UINT8_C( 54), UINT8_C(116), UINT8_C(175),
                             UINT8_C(133), UINT8_C(183), UINT8_C(131), UINT8_C(  7),
                             UINT8_C( 65), UINT8_C( 80), UINT8_C(192), UINT8_C( 97),
                             UINT8_C(148), UINT8_C(232), UINT8_C(135), UINT8_C(251),
                             UINT8_C(194), UINT8_C( 84), UINT8_C(121), UINT8_C( 35),
                             UINT8_C( 55), UINT8_C(172), UINT8_C( 74), UINT8_C( 18),
                             UINT8_C( 14), UINT8_C( 11), UINT8_C( 86), UINT8_C(161)),
      simde_x_mm256_set_epu8(UINT8_C( 65), UINT8_C(219), UINT8_C(169), UINT8_C(149),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(175), UINT8_C(250), UINT8_C(255), UINT8_C(138),
                             UINT8_C(121), UINT8_C(183), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(140), UINT8_C(255),
                             UINT8_C(255), UINT8_C( 84), UINT8_C(255), UINT8_C(254),
                             UINT8_C(107), UINT8_C(228), UINT8_C(227), UINT8_C(211),
                             UINT8_C(220), UINT8_C(195), UINT8_C(255), UINT8_C(255)) },
    { simde_x_mm256_set_epu8(UINT8_C(180), UINT8_C(149), UINT8_C(241), UINT8_C( 31),
                             UINT8_C( 45), UINT8_C(238), UINT8_C(127), UINT8_C( 41),
                             UINT8_C( 61), UINT8_C( 40), UINT8_C(253), UINT8_C(133),
                             UINT8_C(247), UINT8_C(164), UINT8_C(139), UINT8_C(228),
                             UINT8_C( 62), UINT8_C(209), UINT8_C(132), UINT8_C( 80),
                             UINT8_C(102), UINT8_C(192), UINT8_C(185), UINT8_C(191),
                             UINT8_C(100), UINT8_C(154), UINT8_C( 33), UINT8_C( 61),
                             UINT8_C( 93), UINT8_C(153), UINT8_C(220), UINT8_C(160)),
      simde_x_mm256_set_epu8(UINT8_C(230), UINT8_C( 84), UINT8_C( 78), UINT8_C(157),
                             UINT8_C(192), UINT8_C( 80), UINT8_C(173), UINT8_C(216),
                             UINT8_C( 47), UINT8_C(218), UINT8_C( 93), UINT8_C(143),
                             UINT8_C( 45), UINT8_C( 59), UINT8_C(151), UINT8_C(134),
                             UINT8_C( 70), UINT8_C( 90), UINT8_C( 58), UINT8_C(114),
                             UINT8_C(223), UINT8_C(242), UINT8_C( 15), UINT8_C(131),
                             UINT8_C( 82), UINT8_C(204), UINT8_C(173), UINT8_C(  5),
                             UINT8_C( 58), UINT8_C(182), UINT8_C(252), UINT8_C(237)),
      simde_x_mm256_set_epu8(UINT8_C(255), UINT8_C(233), UINT8_C(255), UINT8_C(188),
                             UINT8_C(237), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(108), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(223), UINT8_C(255), UINT8_C(255),
                             UINT8_C(132), UINT8_C(255), UINT8_C(190), UINT8_C(194),
                             UINT8_C(255), UINT8_C(255), UINT8_C(200), UINT8_C(255),
                             UINT8_C(182), UINT8_C(255), UINT8_C(206), UINT8_C( 66),
                             UINT8_C(151), UINT8_C(255), UINT8_C(255), UINT8_C(255)) },
    { simde_x_mm256_set_epu8(UINT8_C(201), UINT8_C(214), UINT8_C(179), UINT8_C(233),
                             UINT8_C(198), UINT8_C( 81), UINT8_C(243), UINT8_C(119),
                             UINT8_C(160), UINT8_C(147), UINT8_C( 34), UINT8_C(138),
                             UINT8_C(127), UINT8_C( 31), UINT8_C(145), UINT8_C( 40),
                             UINT8_C(228), UINT8_C( 45), UINT8_C(  3), UINT8_C(  4),
                             UINT8_C(249), UINT8_C(180), UINT8_C(210), UINT8_C(  7),
                             UINT8_C(175), UINT8_C( 81), UINT8_C( 15), UINT8_C(137),
                             UINT8_C( 20), UINT8_C( 57), UINT8_C(  3), UINT8_C(157)),
      simde_x_mm256_set_epu8(UINT8_C(209), UINT8_C( 16), UINT8_C(253), UINT8_C(199),
                             UINT8_C(185), UINT8_C(238), UINT8_C( 28), UINT8_C( 87),
                             UINT8_C( 41), UINT8_C(232), UINT8_C( 54), UINT8_C(100),
                             UINT8_C(160), UINT8_C( 87), UINT8_C(101), UINT8_C(193),
                             UINT8_C(173), UINT8_C(242), UINT8_C(182), UINT8_C(  0),
                             UINT8_C(222), UINT8_C(142), UINT8_C(217), UINT8_C(177),
                             UINT8_C(237), UINT8_C(196), UINT8_C(145), UINT8_C(208),
                             UINT8_C( 95), UINT8_C(248), UINT8_C( 86), UINT8_C( 20)),
      simde_x_mm256_set_epu8(UINT8_C(255), UINT8_C(230), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(206),
                             UINT8_C(201), UINT8_C(255), UINT8_C( 88), UINT8_C(238),
                             UINT8_C(255), UINT8_C(118), UINT8_C(246), UINT8_C(233),
                             UINT8_C(255), UINT8_C(255), UINT8_C(185), UINT8_C(  4),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(184),
                             UINT8_C(255), UINT8_C(255), UINT8_C(160), UINT8_C(255),
                             UINT8_C(115), UINT8_C(255), UINT8_C( 89), UINT8_C(177)) },
    { simde_x_mm256_set_epu8(UINT8_C(117), UINT8_C(251), UINT8_C(156), UINT8_C( 72),
                             UINT8_C(241), UINT8_C( 25), UINT8_C( 80), UINT8_C(195),
                             UINT8_C(213), UINT8_C( 26), UINT8_C( 44), UINT8_C(154),
                             UINT8_C( 40), UINT8_C(201), UINT8_C(142), UINT8_C(110),
                             UINT8_C( 17), UINT8_C(100), UINT8_C( 41), UINT8_C(223),
                             UINT8_C(255), UINT8_C(232), UINT8_C(253), UINT8_C(190),
                             UINT8_C(155), UINT8_C(178), UINT8_C(150), UINT8_C(248),
                             UINT8_C(166), UINT8_C(223), UINT8_C( 92), UINT8_C(146)),
      simde_x_mm256_set_epu8(UINT8_C(164), UINT8_C(171), UINT8_C(230), UINT8_C(232),
                             UINT8_C( 86), UINT8_C(220), UINT8_C(153), UINT8_C(194),
                             UINT8_C( 83), UINT8_C( 81), UINT8_C( 80), UINT8_C( 93),
                             UINT8_C( 96), UINT8_C( 68), UINT8_C( 55), UINT8_C(183),
                             UINT8_C(110), UINT8_C(151), UINT8_C( 66), UINT8_C(168),
                             UINT8_C(210), UINT8_C( 58), UINT8_C(169), UINT8_C(189),
                             UINT8_C( 61), UINT8_C( 15), UINT8_C(124), UINT8_C(190),
                             UINT8_C( 93), UINT8_C(242), UINT8_C( 80), UINT8_C(225)),
      simde_x_mm256_set_epu8(UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(245), UINT8_C(233), UINT8_C(255),
                             UINT8_C(255), UINT8_C(107), UINT8_C(124), UINT8_C(247),
                             UINT8_C(136), UINT8_C(255), UINT8_C(197), UINT8_C(255),
                             UINT8_C(127), UINT8_C(251), UINT8_C(107), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(216), UINT8_C(193), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(172), UINT8_C(255)) },
    { simde_x_mm256_set_epu8(UINT8_C(130), UINT8_C( 76), UINT8_C( 98), UINT8_C(  8),
                             UINT8_C(243), UINT8_C(125), UINT8_C(189), UINT8_C(162),
                             UINT8_C(107), UINT8_C( 98), UINT8_C(171), UINT8_C( 80),
                             UINT8_C(243), UINT8_C(225), UINT8_C(  6), UINT8_C( 11),
                             UINT8_C(250), UINT8_C(210), UINT8_C( 60), UINT8_C(230),
                             UINT8_C( 17), UINT8_C(222), UINT8_C( 70), UINT8_C(180),
                             UINT8_C( 28), UINT8_C( 96), UINT8_C(128), UINT8_C(195),
                             UINT8_C(240), UINT8_C(119), UINT8_C(199), UINT8_C( 65)),
      simde_x_mm256_set_epu8(UINT8_C( 47), UINT8_C(225), UINT8_C( 74), UINT8_C(106),
                             UINT8_C(149), UINT8_C(250), UINT8_C(221), UINT8_C( 24),
                             UINT8_C(161), UINT8_C( 69), UINT8_C(209), UINT8_C(120),
                             UINT8_C(116), UINT8_C(235), UINT8_C(  4), UINT8_C(161),
                             UINT8_C(156), UINT8_C(193), UINT8_C(253), UINT8_C(  2),
                             UINT8_C(168), UINT8_C( 52), UINT8_C(231), UINT8_C(201),
                             UINT8_C(115), UINT8_C(  0), UINT8_C(176), UINT8_C(224),
                             UINT8_C(  4), UINT8_C(219), UINT8_C(202), UINT8_C(177)),
      simde_x_mm256_set_epu8(UINT8_C(177), UINT8_C(255), UINT8_C(172), UINT8_C(114),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(186),
                             UINT8_C(255), UINT8_C(167), UINT8_C(255), UINT8_C(200),
                             UINT8_C(255), UINT8_C(255), UINT8_C( 10), UINT8_C(172),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(232),
                             UINT8_C(185), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(143), UINT8_C( 96), UINT8_C(255), UINT8_C(255),
                             UINT8_C(244), UINT8_C(255), UINT8_C(255), UINT8_C(242)) },
    { simde_x_mm256_set_epu8(UINT8_C(144), UINT8_C( 62), UINT8_C(142), UINT8_C(211),
                             UINT8_C( 41), UINT8_C(162), UINT8_C(184), UINT8_C(180),
                             UINT8_C(242), UINT8_C( 80), UINT8_C( 73), UINT8_C( 63),
                             UINT8_C(168), UINT8_C(176), UINT8_C( 12), UINT8_C( 85),
                             UINT8_C( 62), UINT8_C( 83), UINT8_C( 52), UINT8_C( 39),
                             UINT8_C( 56), UINT8_C(245), UINT8_C( 65), UINT8_C(213),
                             UINT8_C( 94), UINT8_C( 88), UINT8_C(157), UINT8_C(124),
                             UINT8_C(123), UINT8_C(196), UINT8_C( 79), UINT8_C( 49)),
      simde_x_mm256_set_epu8(UINT8_C(142), UINT8_C( 71), UINT8_C(103), UINT8_C(139),
                             UINT8_C(236), UINT8_C(100), UINT8_C(139), UINT8_C(154),
                             UINT8_C(203), UINT8_C(125), UINT8_C(237), UINT8_C(236),
                             UINT8_C( 45), UINT8_C(103), UINT8_C( 56), UINT8_C( 68),
                             UINT8_C( 26), UINT8_C( 73), UINT8_C(130), UINT8_C( 19),
                             UINT8_C(222), UINT8_C(206), UINT8_C(129), UINT8_C(101),
                             UINT8_C( 56), UINT8_C(145), UINT8_C(213), UINT8_C(249),
                             UINT8_C(145), UINT8_C( 67), UINT8_C(236), UINT8_C(136)),
      simde_x_mm256_set_epu8(UINT8_C(255), UINT8_C(133), UINT8_C(245), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(205), UINT8_C(255), UINT8_C(255),
                             UINT8_C(213), UINT8_C(255), UINT8_C( 68), UINT8_C(153),
                             UINT8_C( 88), UINT8_C(156), UINT8_C(182), UINT8_C( 58),
                             UINT8_C(255), UINT8_C(255), UINT8_C(194), UINT8_C(255),
                             UINT8_C(150), UINT8_C(233), UINT8_C(255), UINT8_C(255),
                             UINT8_C(255), UINT8_C(255), UINT8_C(255), UINT8_C(185)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_adds_epu8(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_u8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_adds_epu16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_x_mm256_set_epu16(UINT16_C( 46173), UINT16_C( 51502), UINT16_C( 53334), UINT16_C( 43223),
                              UINT16_C( 23928), UINT16_C( 20321), UINT16_C( 51743), UINT16_C( 37618),
                              UINT16_C( 65078), UINT16_C(  7253), UINT16_C( 52827), UINT16_C( 55189),
                              UINT16_C(  4987), UINT16_C( 17665), UINT16_C( 14350), UINT16_C( 38811)),
      simde_x_mm256_set_epu16(UINT16_C( 37136), UINT16_C( 48792), UINT16_C(  4303), UINT16_C(  5479),
                              UINT16_C( 25191), UINT16_C( 58551), UINT16_C( 48285), UINT16_C(  4997),
                              UINT16_C( 11428), UINT16_C( 55078), UINT16_C( 56047), UINT16_C( 52960),
                              UINT16_C( 65202), UINT16_C( 38018), UINT16_C(   624), UINT16_C(  7777)),
      simde_x_mm256_set_epu16(UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 57637), UINT16_C( 48702),
                              UINT16_C( 49119), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 42615),
                              UINT16_C( 65535), UINT16_C( 62331), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 55683), UINT16_C( 14974), UINT16_C( 46588)) },
    { simde_x_mm256_set_epu16(UINT16_C( 32326), UINT16_C( 24612), UINT16_C( 21846), UINT16_C( 55200),
                              UINT16_C( 41586), UINT16_C( 19758), UINT16_C( 51650), UINT16_C( 38909),
                              UINT16_C( 46063), UINT16_C( 28335), UINT16_C(  9134), UINT16_C( 41639),
                              UINT16_C( 55060), UINT16_C( 39890), UINT16_C(  8293), UINT16_C( 53471)),
      simde_x_mm256_set_epu16(UINT16_C( 41234), UINT16_C(  2183), UINT16_C( 63540), UINT16_C(  1722),
                              UINT16_C( 28608), UINT16_C( 25104), UINT16_C( 45712), UINT16_C( 60419),
                              UINT16_C( 19160), UINT16_C(  3341), UINT16_C( 25253), UINT16_C( 20430),
                              UINT16_C( 42207), UINT16_C( 24498), UINT16_C( 15365), UINT16_C( 19541)),
      simde_x_mm256_set_epu16(UINT16_C( 65535), UINT16_C( 26795), UINT16_C( 65535), UINT16_C( 56922),
                              UINT16_C( 65535), UINT16_C( 44862), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 65223), UINT16_C( 31676), UINT16_C( 34387), UINT16_C( 62069),
                              UINT16_C( 65535), UINT16_C( 64388), UINT16_C( 23658), UINT16_C( 65535)) },
    { simde_x_mm256_set_epu16(UINT16_C( 26386), UINT16_C( 63006), UINT16_C( 58203), UINT16_C( 62377),
                              UINT16_C( 47602), UINT16_C( 30067), UINT16_C( 23114), UINT16_C( 33473),
                              UINT16_C( 53575), UINT16_C( 38408), UINT16_C( 17337), UINT16_C( 42126),
                              UINT16_C(  5249), UINT16_C( 35315), UINT16_C( 42156), UINT16_C( 18091)),
      simde_x_mm256_set_epu16(UINT16_C( 52612), UINT16_C( 30768), UINT16_C( 53242), UINT16_C( 17367),
                              UINT16_C( 55155), UINT16_C( 55208), UINT16_C( 40791), UINT16_C( 34106),
                              UINT16_C( 38398), UINT16_C(  3526), UINT16_C( 48471), UINT16_C( 61865),
                              UINT16_C( 26735), UINT16_C( 59797), UINT16_C( 61911), UINT16_C(  9267)),
      simde_x_mm256_set_epu16(UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 63905), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 41934), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 31984), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 27358)) },
    { simde_x_mm256_set_epu16(UINT16_C( 52292), UINT16_C( 60997), UINT16_C( 31428), UINT16_C(  9305),
                              UINT16_C( 57362), UINT16_C( 62823), UINT16_C(  6394), UINT16_C( 15984),
                              UINT16_C( 50964), UINT16_C( 21850), UINT16_C( 44748), UINT16_C( 36872),
                              UINT16_C( 14263), UINT16_C( 48235), UINT16_C(  9404), UINT16_C( 55410)),
      simde_x_mm256_set_epu16(UINT16_C(  5822), UINT16_C( 53891), UINT16_C( 53572), UINT16_C( 35299),
                              UINT16_C( 32303), UINT16_C( 47360), UINT16_C(  2824), UINT16_C( 19749),
                              UINT16_C(  6763), UINT16_C( 47400), UINT16_C( 29201), UINT16_C( 32332),
                              UINT16_C( 24570), UINT16_C( 50755), UINT16_C( 22545), UINT16_C(  9382)),
      simde_x_mm256_set_epu16(UINT16_C( 58114), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 44604),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C(  9218), UINT16_C( 35733),
                              UINT16_C( 57727), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 38833), UINT16_C( 65535), UINT16_C( 31949), UINT16_C( 64792)) },
    { simde_x_mm256_set_epu16(UINT16_C( 50076), UINT16_C(  9743), UINT16_C( 10727), UINT16_C( 51592),
                              UINT16_C( 28130), UINT16_C( 34226), UINT16_C( 44764), UINT16_C( 58424),
                              UINT16_C( 15168), UINT16_C(  4051), UINT16_C( 54044), UINT16_C(  7020),
                              UINT16_C( 31115), UINT16_C( 49299), UINT16_C( 40742), UINT16_C( 48855)),
      simde_x_mm256_set_epu16(UINT16_C( 50898), UINT16_C( 60971), UINT16_C(  2964), UINT16_C( 53140),
                              UINT16_C( 39951), UINT16_C( 57637), UINT16_C( 63735), UINT16_C( 40101),
                              UINT16_C( 37326), UINT16_C( 12531), UINT16_C( 29670), UINT16_C( 49503),
                              UINT16_C( 64935), UINT16_C( 44011), UINT16_C( 59422), UINT16_C( 45053)),
      simde_x_mm256_set_epu16(UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 13691), UINT16_C( 65535),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 52494), UINT16_C( 16582), UINT16_C( 65535), UINT16_C( 56523),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535)) },
    { simde_x_mm256_set_epu16(UINT16_C( 12906), UINT16_C( 34342), UINT16_C( 49900), UINT16_C( 16373),
                              UINT16_C( 41099), UINT16_C( 42680), UINT16_C( 11034), UINT16_C(  4050),
                              UINT16_C( 41370), UINT16_C( 18241), UINT16_C( 60694), UINT16_C( 59842),
                              UINT16_C(  7044), UINT16_C( 38288), UINT16_C( 18779), UINT16_C( 33204)),
      simde_x_mm256_set_epu16(UINT16_C( 39975), UINT16_C( 26379), UINT16_C( 49406), UINT16_C( 11197),
                              UINT16_C( 25665), UINT16_C( 45876), UINT16_C(  8978), UINT16_C( 56112),
                              UINT16_C(  5541), UINT16_C( 41816), UINT16_C(  1773), UINT16_C( 25366),
                              UINT16_C( 51395), UINT16_C( 19553), UINT16_C( 37079), UINT16_C( 32528)),
      simde_x_mm256_set_epu16(UINT16_C( 52881), UINT16_C( 60721), UINT16_C( 65535), UINT16_C( 27570),
                              UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 20012), UINT16_C( 60162),
                              UINT16_C( 46911), UINT16_C( 60057), UINT16_C( 62467), UINT16_C( 65535),
                              UINT16_C( 58439), UINT16_C( 57841), UINT16_C( 55858), UINT16_C( 65535)) },
    { simde_x_mm256_set_epu16(UINT16_C( 54610), UINT16_C( 56071), UINT16_C( 54559), UINT16_C( 11899),
                              UINT16_C( 32307), UINT16_C(  4962), UINT16_C( 27630), UINT16_C( 33600),
                              UINT16_C( 31852), UINT16_C( 56358), UINT16_C( 35796), UINT16_C(  8024),
                              UINT16_C( 46221), UINT16_C(  4529), UINT16_C( 49147), UINT16_C(  8518)),
      simde_x_mm256_set_epu16(UINT16_C( 57675), UINT16_C(  2883), UINT16_C( 55066), UINT16_C( 41648),
                              UINT16_C( 12159), UINT16_C( 20265), UINT16_C( 47525), UINT16_C( 54059),
                              UINT16_C( 12623), UINT16_C( 11063), UINT16_C( 34242), UINT16_C( 57692),
                              UINT16_C(  8071), UINT16_C(  9806), UINT16_C( 30691), UINT16_C( 35776)),
      simde_x_mm256_set_epu16(UINT16_C( 65535), UINT16_C( 58954), UINT16_C( 65535), UINT16_C( 53547),
                              UINT16_C( 44466), UINT16_C( 25227), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 44475), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535),
                              UINT16_C( 54292), UINT16_C( 14335), UINT16_C( 65535), UINT16_C( 44294)) },
    { simde_x_mm256_set_epu16(UINT16_C( 56834), UINT16_C( 64885), UINT16_C(  9140), UINT16_C( 13056),
                              UINT16_C( 40842), UINT16_C( 10347), UINT16_C(  7339), UINT16_C( 17877),
                              UINT16_C( 14924), UINT16_C( 16868), UINT16_C( 50139), UINT16_C( 42854),
                              UINT16_C( 20413), UINT16_C( 64148), UINT16_C( 24871), UINT16_C( 35734)),
      simde_x_mm256_set_epu16(UINT16_C( 20840), UINT16_C( 44144), UINT16_C( 58177), UINT16_C( 28709),
                              UINT16_C( 14233), UINT16_C( 55224), UINT16_C( 50824), UINT16_C( 22009),
                              UINT16_C( 46863), UINT16_C( 40997), UINT16_C( 17728), UINT16_C( 21679),
                              UINT16_C(  9552), UINT16_C( 17236), UINT16_C(  5658), UINT16_C( 51223)),
      simde_x_mm256_set_epu16(UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 65535), UINT16_C( 41765),
                              UINT16_C( 55075), UINT16_C( 65535), UINT16_C( 58163), UINT16_C( 39886),
                              UINT16_C( 61787), UINT16_C( 57865), UINT16_C( 65535), UINT16_C( 64533),
                              UINT16_C( 29965), UINT16_C( 65535), UINT16_C( 30529), UINT16_C( 65535)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_adds_epu16(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_u16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_avg_epu8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_x_mm256_set_epu8(UINT8_C(132), UINT8_C(185), UINT8_C( 15), UINT8_C(235),
                             UINT8_C(102), UINT8_C(  8), UINT8_C(239), UINT8_C(181),
                             UINT8_C( 81), UINT8_C(155), UINT8_C(236), UINT8_C(191),
                             UINT8_C(133), UINT8_C( 65), UINT8_C( 73), UINT8_C( 40),
                             UINT8_C(181), UINT8_C( 86), UINT8_C( 73), UINT8_C(213),
                             UINT8_C( 85), UINT8_C( 28), UINT8_C( 53), UINT8_C(225),
                             UINT8_C(217), UINT8_C(129), UINT8_C( 68), UINT8_C(183),
                             UINT8_C(232), UINT8_C( 91), UINT8_C(  4), UINT8_C(129)),
      simde_x_mm256_set_epu8(UINT8_C(199), UINT8_C(146), UINT8_C( 73), UINT8_C(129),
                             UINT8_C( 53), UINT8_C( 30), UINT8_C(178), UINT8_C(252),
                             UINT8_C(125), UINT8_C( 44), UINT8_C( 67), UINT8_C( 83),
                             UINT8_C( 52), UINT8_C( 79), UINT8_C(239), UINT8_C(118),
                             UINT8_C(100), UINT8_C( 25), UINT8_C( 74), UINT8_C( 78),
                             UINT8_C( 90), UINT8_C(145), UINT8_C(118), UINT8_C(211),
                             UINT8_C( 29), UINT8_C( 31), UINT8_C(128), UINT8_C( 53),
                             UINT8_C( 19), UINT8_C(239), UINT8_C(181), UINT8_C(108)),
      simde_x_mm256_set_epu8(UINT8_C(166), UINT8_C(166), UINT8_C( 44), UINT8_C(182),
                             UINT8_C( 78), UINT8_C( 19), UINT8_C(209), UINT8_C(217),
                             UINT8_C(103), UINT8_C(100), UINT8_C(152), UINT8_C(137),
                             UINT8_C( 93), UINT8_C( 72), UINT8_C(156), UINT8_C( 79),
                             UINT8_C(141), UINT8_C( 56), UINT8_C( 74), UINT8_C(146),
                             UINT8_C( 88), UINT8_C( 87), UINT8_C( 86), UINT8_C(218),
                             UINT8_C(123), UINT8_C( 80), UINT8_C( 98), UINT8_C(118),
                             UINT8_C(126), UINT8_C(165), UINT8_C( 93), UINT8_C(119)) },
    { simde_x_mm256_set_epu8(UINT8_C(209), UINT8_C(137), UINT8_C(159), UINT8_C(201),
                             UINT8_C(142), UINT8_C(123), UINT8_C(233), UINT8_C(210),
                             UINT8_C(180), UINT8_C(  1), UINT8_C( 19), UINT8_C(  5),
                             UINT8_C( 35), UINT8_C(203), UINT8_C(189), UINT8_C( 26),
                             UINT8_C(153), UINT8_C(140), UINT8_C( 62), UINT8_C(144),
                             UINT8_C( 20), UINT8_C(125), UINT8_C(185), UINT8_C(133),
                             UINT8_C( 90), UINT8_C(243), UINT8_C( 18), UINT8_C(117),
                             UINT8_C(102), UINT8_C(222), UINT8_C( 27), UINT8_C( 12)),
      simde_x_mm256_set_epu8(UINT8_C(201), UINT8_C(154), UINT8_C( 75), UINT8_C(146),
                             UINT8_C( 84), UINT8_C(138), UINT8_C(110), UINT8_C( 18),
                             UINT8_C(142), UINT8_C(147), UINT8_C(192), UINT8_C(131),
                             UINT8_C(151), UINT8_C(232), UINT8_C(176), UINT8_C(  8),
                             UINT8_C(133), UINT8_C( 27), UINT8_C( 52), UINT8_C( 35),
                             UINT8_C(114), UINT8_C(148), UINT8_C(237), UINT8_C(121),
                             UINT8_C(209), UINT8_C( 97), UINT8_C(242), UINT8_C( 75),
                             UINT8_C(194), UINT8_C( 62), UINT8_C(242), UINT8_C(214)),
      simde_x_mm256_set_epu8(UINT8_C(205), UINT8_C(146), UINT8_C(117), UINT8_C(174),
                             UINT8_C(113), UINT8_C(131), UINT8_C(172), UINT8_C(114),
                             UINT8_C(161), UINT8_C( 74), UINT8_C(106), UINT8_C( 68),
                             UINT8_C( 93), UINT8_C(218), UINT8_C(183), UINT8_C( 17),
                             UINT8_C(143), UINT8_C( 84), UINT8_C( 57), UINT8_C( 90),
                             UINT8_C( 67), UINT8_C(137), UINT8_C(211), UINT8_C(127),
                             UINT8_C(150), UINT8_C(170), UINT8_C(130), UINT8_C( 96),
                             UINT8_C(148), UINT8_C(142), UINT8_C(135), UINT8_C(113)) },
    { simde_x_mm256_set_epu8(UINT8_C(223), UINT8_C( 80), UINT8_C( 95), UINT8_C( 57),
                             UINT8_C(173), UINT8_C( 14), UINT8_C( 75), UINT8_C( 79),
                             UINT8_C(206), UINT8_C( 37), UINT8_C(125), UINT8_C(225),
                             UINT8_C(172), UINT8_C(121), UINT8_C( 43), UINT8_C(249),
                             UINT8_C(122), UINT8_C(  3), UINT8_C( 25), UINT8_C(204),
                             UINT8_C(153), UINT8_C( 32), UINT8_C(245), UINT8_C( 58),
                             UINT8_C(211), UINT8_C(116), UINT8_C( 87), UINT8_C(228),
                             UINT8_C(139), UINT8_C(203), UINT8_C(106), UINT8_C(216)),
      simde_x_mm256_set_epu8(UINT8_C( 18), UINT8_C(169), UINT8_C( 46), UINT8_C(100),
                             UINT8_C(246), UINT8_C(  6), UINT8_C(208), UINT8_C(224),
                             UINT8_C(134), UINT8_C(248), UINT8_C( 90), UINT8_C(243),
                             UINT8_C( 95), UINT8_C(216), UINT8_C(232), UINT8_C(245),
                             UINT8_C( 35), UINT8_C(118), UINT8_C( 23), UINT8_C(111),
                             UINT8_C(137), UINT8_C(  1), UINT8_C( 43), UINT8_C(212),
                             UINT8_C(143), UINT8_C(143), UINT8_C(106), UINT8_C(242),
                             UINT8_C(188), UINT8_C( 78), UINT8_C( 94), UINT8_C( 49)),
      simde_x_mm256_set_epu8(UINT8_C(121), UINT8_C(125), UINT8_C( 71), UINT8_C( 79),
                             UINT8_C(210), UINT8_C( 10), UINT8_C(142), UINT8_C(152),
                             UINT8_C(170), UINT8_C(143), UINT8_C(108), UINT8_C(234),
                             UINT8_C(134), UINT8_C(169), UINT8_C(138), UINT8_C(247),
                             UINT8_C( 79), UINT8_C( 61), UINT8_C( 24), UINT8_C(158),
                             UINT8_C(145), UINT8_C( 17), UINT8_C(144), UINT8_C(135),
                             UINT8_C(177), UINT8_C(130), UINT8_C( 97), UINT8_C(235),
                             UINT8_C(164), UINT8_C(141), UINT8_C(100), UINT8_C(133)) },
    { simde_x_mm256_set_epu8(UINT8_C(186), UINT8_C( 51), UINT8_C(166), UINT8_C(159),
                             UINT8_C( 61), UINT8_C(189), UINT8_C(148), UINT8_C(156),
                             UINT8_C(199), UINT8_C( 59), UINT8_C(214), UINT8_C( 21),
                             UINT8_C( 92), UINT8_C( 24), UINT8_C( 35), UINT8_C( 33),
                             UINT8_C( 27), UINT8_C(133), UINT8_C(  9), UINT8_C(114),
                             UINT8_C(170), UINT8_C( 78), UINT8_C(149), UINT8_C(203),
                             UINT8_C(212), UINT8_C(108), UINT8_C(116), UINT8_C(217),
                             UINT8_C(102), UINT8_C(192), UINT8_C(223), UINT8_C( 98)),
      simde_x_mm256_set_epu8(UINT8_C( 51), UINT8_C(193), UINT8_C(129), UINT8_C(222),
                             UINT8_C(147), UINT8_C( 49), UINT8_C(210), UINT8_C(198),
                             UINT8_C(192), UINT8_C(158), UINT8_C( 49), UINT8_C(217),
                             UINT8_C( 20), UINT8_C(183), UINT8_C(213), UINT8_C( 71),
                             UINT8_C(164), UINT8_C( 92), UINT8_C(118), UINT8_C( 17),
                             UINT8_C(236), UINT8_C( 27), UINT8_C(162), UINT8_C( 98),
                             UINT8_C(196), UINT8_C(135), UINT8_C(  7), UINT8_C(172),
                             UINT8_C(233), UINT8_C( 47), UINT8_C(151), UINT8_C(128)),
      simde_x_mm256_set_epu8(UINT8_C(119), UINT8_C(122), UINT8_C(148), UINT8_C(191),
                             UINT8_C(104), UINT8_C(119), UINT8_C(179), UINT8_C(177),
                             UINT8_C(196), UINT8_C(109), UINT8_C(132), UINT8_C(119),
                             UINT8_C( 56), UINT8_C(104), UINT8_C(124), UINT8_C( 52),
                             UINT8_C( 96), UINT8_C(113), UINT8_C( 64), UINT8_C( 66),
                             UINT8_C(203), UINT8_C( 53), UINT8_C(156), UINT8_C(151),
                             UINT8_C(204), UINT8_C(122), UINT8_C( 62), UINT8_C(195),
                             UINT8_C(168), UINT8_C(120), UINT8_C(187), UINT8_C(113)) },
    { simde_x_mm256_set_epu8(UINT8_C(182), UINT8_C(141), UINT8_C( 93), UINT8_C( 91),
                             UINT8_C(  0), UINT8_C(189), UINT8_C(215), UINT8_C(221),
                             UINT8_C(105), UINT8_C(231), UINT8_C( 61), UINT8_C(224),
                             UINT8_C( 68), UINT8_C( 84), UINT8_C(247), UINT8_C(215),
                             UINT8_C(125), UINT8_C(197), UINT8_C( 69), UINT8_C(102),
                             UINT8_C(218), UINT8_C(120), UINT8_C(113), UINT8_C(175),
                             UINT8_C(134), UINT8_C( 33), UINT8_C(106), UINT8_C(117),
                             UINT8_C(129), UINT8_C(249), UINT8_C(194), UINT8_C( 70)),
      simde_x_mm256_set_epu8(UINT8_C(137), UINT8_C( 27), UINT8_C( 17), UINT8_C( 94),
                             UINT8_C(244), UINT8_C(142), UINT8_C(142), UINT8_C( 48),
                             UINT8_C( 54), UINT8_C(217), UINT8_C(209), UINT8_C(122),
                             UINT8_C(  1), UINT8_C(190), UINT8_C( 59), UINT8_C(250),
                             UINT8_C(179), UINT8_C(176), UINT8_C(167), UINT8_C( 57),
                             UINT8_C( 90), UINT8_C( 15), UINT8_C( 31), UINT8_C(140),
                             UINT8_C(209), UINT8_C(104), UINT8_C(139), UINT8_C(154),
                             UINT8_C( 57), UINT8_C(248), UINT8_C(225), UINT8_C( 65)),
      simde_x_mm256_set_epu8(UINT8_C(160), UINT8_C( 84), UINT8_C( 55), UINT8_C( 93),
                             UINT8_C(122), UINT8_C(166), UINT8_C(179), UINT8_C(135),
                             UINT8_C( 80), UINT8_C(224), UINT8_C(135), UINT8_C(173),
                             UINT8_C( 35), UINT8_C(137), UINT8_C(153), UINT8_C(233),
                             UINT8_C(152), UINT8_C(187), UINT8_C(118), UINT8_C( 80),
                             UINT8_C(154), UINT8_C( 68), UINT8_C( 72), UINT8_C(158),
                             UINT8_C(172), UINT8_C( 69), UINT8_C(123), UINT8_C(136),
                             UINT8_C( 93), UINT8_C(249), UINT8_C(210), UINT8_C( 68)) },
    { simde_x_mm256_set_epu8(UINT8_C(125), UINT8_C(242), UINT8_C( 34), UINT8_C(120),
                             UINT8_C(106), UINT8_C(202), UINT8_C(100), UINT8_C( 61),
                             UINT8_C(105), UINT8_C(145), UINT8_C( 46), UINT8_C(129),
                             UINT8_C(208), UINT8_C( 57), UINT8_C( 82), UINT8_C( 21),
                             UINT8_C( 59), UINT8_C( 97), UINT8_C(206), UINT8_C(  4),
                             UINT8_C(182), UINT8_C( 81), UINT8_C(203), UINT8_C(252),
                             UINT8_C(111), UINT8_C( 28), UINT8_C(210), UINT8_C( 57),
                             UINT8_C(214), UINT8_C(124), UINT8_C(137), UINT8_C(114)),
      simde_x_mm256_set_epu8(UINT8_C(208), UINT8_C( 60), UINT8_C( 51), UINT8_C( 61),
                             UINT8_C(249), UINT8_C(203), UINT8_C( 69), UINT8_C(195),
                             UINT8_C( 16), UINT8_C( 67), UINT8_C(241), UINT8_C(244),
                             UINT8_C(217), UINT8_C(201), UINT8_C(104), UINT8_C( 80),
                             UINT8_C( 30), UINT8_C( 40), UINT8_C( 69), UINT8_C( 88),
                             UINT8_C( 83), UINT8_C(141), UINT8_C(221), UINT8_C(174),
                             UINT8_C(165), UINT8_C(114), UINT8_C(107), UINT8_C( 42),
                             UINT8_C( 83), UINT8_C(  1), UINT8_C( 95), UINT8_C( 89)),
      simde_x_mm256_set_epu8(UINT8_C(167), UINT8_C(151), UINT8_C( 43), UINT8_C( 91),
                             UINT8_C(178), UINT8_C(203), UINT8_C( 85), UINT8_C(128),
                             UINT8_C( 61), UINT8_C(106), UINT8_C(144), UINT8_C(187),
                             UINT8_C(213), UINT8_C(129), UINT8_C( 93), UINT8_C( 51),
                             UINT8_C( 45), UINT8_C( 69), UINT8_C(138), UINT8_C( 46),
                             UINT8_C(133), UINT8_C(111), UINT8_C(212), UINT8_C(213),
                             UINT8_C(138), UINT8_C( 71), UINT8_C(159), UINT8_C( 50),
                             UINT8_C(149), UINT8_C( 63), UINT8_C(116), UINT8_C(102)) },
    { simde_x_mm256_set_epu8(UINT8_C( 59), UINT8_C(202), UINT8_C( 28), UINT8_C( 65),
                             UINT8_C( 60), UINT8_C( 92), UINT8_C(112), UINT8_C(105),
                             UINT8_C(229), UINT8_C(116), UINT8_C(242), UINT8_C(217),
                             UINT8_C(203), UINT8_C( 71), UINT8_C( 15), UINT8_C(143),
                             UINT8_C( 58), UINT8_C(228), UINT8_C( 36), UINT8_C(154),
                             UINT8_C( 96), UINT8_C(  2), UINT8_C( 86), UINT8_C( 36),
                             UINT8_C( 93), UINT8_C( 29), UINT8_C( 70), UINT8_C( 20),
                             UINT8_C(130), UINT8_C(172), UINT8_C(152), UINT8_C(189)),
      simde_x_mm256_set_epu8(UINT8_C(100), UINT8_C( 42), UINT8_C( 77), UINT8_C( 21),
                             UINT8_C(144), UINT8_C(197), UINT8_C(242), UINT8_C(243),
                             UINT8_C(205), UINT8_C(204), UINT8_C( 75), UINT8_C(102),
                             UINT8_C( 21), UINT8_C(148), UINT8_C( 70), UINT8_C(128),
                             UINT8_C( 95), UINT8_C(147), UINT8_C( 39), UINT8_C(190),
                             UINT8_C( 20), UINT8_C(128), UINT8_C(196), UINT8_C(160),
                             UINT8_C(  8), UINT8_C(206), UINT8_C( 13), UINT8_C(197),
                             UINT8_C( 93), UINT8_C(253), UINT8_C( 16), UINT8_C( 27)),
      simde_x_mm256_set_epu8(UINT8_C( 80), UINT8_C(122), UINT8_C( 53), UINT8_C( 43),
                             UINT8_C(102), UINT8_C(145), UINT8_C(177), UINT8_C(174),
                             UINT8_C(217), UINT8_C(160), UINT8_C(159), UINT8_C(160),
                             UINT8_C(112), UINT8_C(110), UINT8_C( 43), UINT8_C(136),
                             UINT8_C( 77), UINT8_C(188), UINT8_C( 38), UINT8_C(172),
                             UINT8_C( 58), UINT8_C( 65), UINT8_C(141), UINT8_C( 98),
                             UINT8_C( 51), UINT8_C(118), UINT8_C( 42), UINT8_C(109),
                             UINT8_C(112), UINT8_C(213), UINT8_C( 84), UINT8_C(108)) },
    { simde_x_mm256_set_epu8(UINT8_C( 75), UINT8_C( 17), UINT8_C(162), UINT8_C( 64),
                             UINT8_C(129), UINT8_C(250), UINT8_C(112), UINT8_C(166),
                             UINT8_C( 98), UINT8_C(126), UINT8_C(129), UINT8_C(211),
                             UINT8_C( 27), UINT8_C( 12), UINT8_C(183), UINT8_C(140),
                             UINT8_C(106), UINT8_C(255), UINT8_C(252), UINT8_C(224),
                             UINT8_C(116), UINT8_C(208), UINT8_C( 69), UINT8_C(  4),
                             UINT8_C(193), UINT8_C( 46), UINT8_C(111), UINT8_C( 96),
                             UINT8_C(101), UINT8_C(183), UINT8_C( 99), UINT8_C( 60)),
      simde_x_mm256_set_epu8(UINT8_C( 48), UINT8_C( 27), UINT8_C(253), UINT8_C(118),
                             UINT8_C(225), UINT8_C(134), UINT8_C(250), UINT8_C(133),
                             UINT8_C( 52), UINT8_C( 47), UINT8_C( 27), UINT8_C(213),
                             UINT8_C( 28), UINT8_C(208), UINT8_C( 73), UINT8_C( 89),
                             UINT8_C( 76), UINT8_C(160), UINT8_C( 57), UINT8_C(191),
                             UINT8_C( 34), UINT8_C(121), UINT8_C(194), UINT8_C(205),
                             UINT8_C(102), UINT8_C(106), UINT8_C(175), UINT8_C(219),
                             UINT8_C(174), UINT8_C(128), UINT8_C(137), UINT8_C(235)),
      simde_x_mm256_set_epu8(UINT8_C( 62), UINT8_C( 22), UINT8_C(208), UINT8_C( 91),
                             UINT8_C(177), UINT8_C(192), UINT8_C(181), UINT8_C(150),
                             UINT8_C( 75), UINT8_C( 87), UINT8_C( 78), UINT8_C(212),
                             UINT8_C( 28), UINT8_C(110), UINT8_C(128), UINT8_C(115),
                             UINT8_C( 91), UINT8_C(208), UINT8_C(155), UINT8_C(208),
                             UINT8_C( 75), UINT8_C(165), UINT8_C(132), UINT8_C(105),
                             UINT8_C(148), UINT8_C( 76), UINT8_C(143), UINT8_C(158),
                             UINT8_C(138), UINT8_C(156), UINT8_C(118), UINT8_C(148)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_avg_epu8(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_u8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_avg_epu16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_x_mm256_set_epu16(UINT16_C( 33977), UINT16_C(  4075), UINT16_C( 26120), UINT16_C( 61365),
                              UINT16_C( 20891), UINT16_C( 60607), UINT16_C( 34113), UINT16_C( 18728),
                              UINT16_C( 46422), UINT16_C( 18901), UINT16_C( 21788), UINT16_C( 13793),
                              UINT16_C( 55681), UINT16_C( 17591), UINT16_C( 59483), UINT16_C(  1153)),
      simde_x_mm256_set_epu16(UINT16_C( 51090), UINT16_C( 18817), UINT16_C( 13598), UINT16_C( 45820),
                              UINT16_C( 32044), UINT16_C( 17235), UINT16_C( 13391), UINT16_C( 61302),
                              UINT16_C( 25625), UINT16_C( 19022), UINT16_C( 23185), UINT16_C( 30419),
                              UINT16_C(  7455), UINT16_C( 32821), UINT16_C(  5103), UINT16_C( 46444)),
      simde_x_mm256_set_epu16(UINT16_C( 42534), UINT16_C( 11446), UINT16_C( 19859), UINT16_C( 53593),
                              UINT16_C( 26468), UINT16_C( 38921), UINT16_C( 23752), UINT16_C( 40015),
                              UINT16_C( 36024), UINT16_C( 18962), UINT16_C( 22487), UINT16_C( 22106),
                              UINT16_C( 31568), UINT16_C( 25206), UINT16_C( 32293), UINT16_C( 23799)) },
    { simde_x_mm256_set_epu16(UINT16_C( 53641), UINT16_C( 40905), UINT16_C( 36475), UINT16_C( 59858),
                              UINT16_C( 46081), UINT16_C(  4869), UINT16_C(  9163), UINT16_C( 48410),
                              UINT16_C( 39308), UINT16_C( 16016), UINT16_C(  5245), UINT16_C( 47493),
                              UINT16_C( 23283), UINT16_C(  4725), UINT16_C( 26334), UINT16_C(  6924)),
      simde_x_mm256_set_epu16(UINT16_C( 51610), UINT16_C( 19346), UINT16_C( 21642), UINT16_C( 28178),
                              UINT16_C( 36499), UINT16_C( 49283), UINT16_C( 38888), UINT16_C( 45064),
                              UINT16_C( 34075), UINT16_C( 13347), UINT16_C( 29332), UINT16_C( 60793),
                              UINT16_C( 53601), UINT16_C( 62027), UINT16_C( 49726), UINT16_C( 62166)),
      simde_x_mm256_set_epu16(UINT16_C( 52626), UINT16_C( 30126), UINT16_C( 29059), UINT16_C( 44018),
                              UINT16_C( 41290), UINT16_C( 27076), UINT16_C( 24026), UINT16_C( 46737),
                              UINT16_C( 36692), UINT16_C( 14682), UINT16_C( 17289), UINT16_C( 54143),
                              UINT16_C( 38442), UINT16_C( 33376), UINT16_C( 38030), UINT16_C( 34545)) },
    { simde_x_mm256_set_epu16(UINT16_C( 57168), UINT16_C( 24377), UINT16_C( 44302), UINT16_C( 19279),
                              UINT16_C( 52773), UINT16_C( 32225), UINT16_C( 44153), UINT16_C( 11257),
                              UINT16_C( 31235), UINT16_C(  6604), UINT16_C( 39200), UINT16_C( 62778),
                              UINT16_C( 54132), UINT16_C( 22500), UINT16_C( 35787), UINT16_C( 27352)),
      simde_x_mm256_set_epu16(UINT16_C(  4777), UINT16_C( 11876), UINT16_C( 62982), UINT16_C( 53472),
                              UINT16_C( 34552), UINT16_C( 23283), UINT16_C( 24536), UINT16_C( 59637),
                              UINT16_C(  9078), UINT16_C(  5999), UINT16_C( 35073), UINT16_C( 11220),
                              UINT16_C( 36751), UINT16_C( 27378), UINT16_C( 48206), UINT16_C( 24113)),
      simde_x_mm256_set_epu16(UINT16_C( 30973), UINT16_C( 18127), UINT16_C( 53642), UINT16_C( 36376),
                              UINT16_C( 43663), UINT16_C( 27754), UINT16_C( 34345), UINT16_C( 35447),
                              UINT16_C( 20157), UINT16_C(  6302), UINT16_C( 37137), UINT16_C( 36999),
                              UINT16_C( 45442), UINT16_C( 24939), UINT16_C( 41997), UINT16_C( 25733)) },
    { simde_x_mm256_set_epu16(UINT16_C( 47667), UINT16_C( 42655), UINT16_C( 15805), UINT16_C( 38044),
                              UINT16_C( 51003), UINT16_C( 54805), UINT16_C( 23576), UINT16_C(  8993),
                              UINT16_C(  7045), UINT16_C(  2418), UINT16_C( 43598), UINT16_C( 38347),
                              UINT16_C( 54380), UINT16_C( 29913), UINT16_C( 26304), UINT16_C( 57186)),
      simde_x_mm256_set_epu16(UINT16_C( 13249), UINT16_C( 33246), UINT16_C( 37681), UINT16_C( 53958),
                              UINT16_C( 49310), UINT16_C( 12761), UINT16_C(  5303), UINT16_C( 54599),
                              UINT16_C( 42076), UINT16_C( 30225), UINT16_C( 60443), UINT16_C( 41570),
                              UINT16_C( 50311), UINT16_C(  1964), UINT16_C( 59695), UINT16_C( 38784)),
      simde_x_mm256_set_epu16(UINT16_C( 30458), UINT16_C( 37951), UINT16_C( 26743), UINT16_C( 46001),
                              UINT16_C( 50157), UINT16_C( 33783), UINT16_C( 14440), UINT16_C( 31796),
                              UINT16_C( 24561), UINT16_C( 16322), UINT16_C( 52021), UINT16_C( 39959),
                              UINT16_C( 52346), UINT16_C( 15939), UINT16_C( 43000), UINT16_C( 47985)) },
    { simde_x_mm256_set_epu16(UINT16_C( 46733), UINT16_C( 23899), UINT16_C(   189), UINT16_C( 55261),
                              UINT16_C( 27111), UINT16_C( 15840), UINT16_C( 17492), UINT16_C( 63447),
                              UINT16_C( 32197), UINT16_C( 17766), UINT16_C( 55928), UINT16_C( 29103),
                              UINT16_C( 34337), UINT16_C( 27253), UINT16_C( 33273), UINT16_C( 49734)),
      simde_x_mm256_set_epu16(UINT16_C( 35099), UINT16_C(  4446), UINT16_C( 62606), UINT16_C( 36400),
                              UINT16_C( 14041), UINT16_C( 53626), UINT16_C(   446), UINT16_C( 15354),
                              UINT16_C( 46000), UINT16_C( 42809), UINT16_C( 23055), UINT16_C(  8076),
                              UINT16_C( 53608), UINT16_C( 35738), UINT16_C( 14840), UINT16_C( 57665)),
      simde_x_mm256_set_epu16(UINT16_C( 40916), UINT16_C( 14173), UINT16_C( 31398), UINT16_C( 45831),
                              UINT16_C( 20576), UINT16_C( 34733), UINT16_C(  8969), UINT16_C( 39401),
                              UINT16_C( 39099), UINT16_C( 30288), UINT16_C( 39492), UINT16_C( 18590),
                              UINT16_C( 43973), UINT16_C( 31496), UINT16_C( 24057), UINT16_C( 53700)) },
    { simde_x_mm256_set_epu16(UINT16_C( 32242), UINT16_C(  8824), UINT16_C( 27338), UINT16_C( 25661),
                              UINT16_C( 27025), UINT16_C( 11905), UINT16_C( 53305), UINT16_C( 21013),
                              UINT16_C( 15201), UINT16_C( 52740), UINT16_C( 46673), UINT16_C( 52220),
                              UINT16_C( 28444), UINT16_C( 53817), UINT16_C( 54908), UINT16_C( 35186)),
      simde_x_mm256_set_epu16(UINT16_C( 53308), UINT16_C( 13117), UINT16_C( 63947), UINT16_C( 17859),
                              UINT16_C(  4163), UINT16_C( 61940), UINT16_C( 55753), UINT16_C( 26704),
                              UINT16_C(  7720), UINT16_C( 17752), UINT16_C( 21389), UINT16_C( 56750),
                              UINT16_C( 42354), UINT16_C( 27434), UINT16_C( 21249), UINT16_C( 24409)),
      simde_x_mm256_set_epu16(UINT16_C( 42775), UINT16_C( 10971), UINT16_C( 45643), UINT16_C( 21760),
                              UINT16_C( 15594), UINT16_C( 36923), UINT16_C( 54529), UINT16_C( 23859),
                              UINT16_C( 11461), UINT16_C( 35246), UINT16_C( 34031), UINT16_C( 54485),
                              UINT16_C( 35399), UINT16_C( 40626), UINT16_C( 38079), UINT16_C( 29798)) },
    { simde_x_mm256_set_epu16(UINT16_C( 15306), UINT16_C(  7233), UINT16_C( 15452), UINT16_C( 28777),
                              UINT16_C( 58740), UINT16_C( 62169), UINT16_C( 52039), UINT16_C(  3983),
                              UINT16_C( 15076), UINT16_C(  9370), UINT16_C( 24578), UINT16_C( 22052),
                              UINT16_C( 23837), UINT16_C( 17940), UINT16_C( 33452), UINT16_C( 39101)),
      simde_x_mm256_set_epu16(UINT16_C( 25642), UINT16_C( 19733), UINT16_C( 37061), UINT16_C( 62195),
                              UINT16_C( 52684), UINT16_C( 19302), UINT16_C(  5524), UINT16_C( 18048),
                              UINT16_C( 24467), UINT16_C( 10174), UINT16_C(  5248), UINT16_C( 50336),
                              UINT16_C(  2254), UINT16_C(  3525), UINT16_C( 24061), UINT16_C(  4123)),
      simde_x_mm256_set_epu16(UINT16_C( 20474), UINT16_C( 13483), UINT16_C( 26257), UINT16_C( 45486),
                              UINT16_C( 55712), UINT16_C( 40736), UINT16_C( 28782), UINT16_C( 11016),
                              UINT16_C( 19772), UINT16_C(  9772), UINT16_C( 14913), UINT16_C( 36194),
                              UINT16_C( 13046), UINT16_C( 10733), UINT16_C( 28757), UINT16_C( 21612)) },
    { simde_x_mm256_set_epu16(UINT16_C( 19217), UINT16_C( 41536), UINT16_C( 33274), UINT16_C( 28838),
                              UINT16_C( 25214), UINT16_C( 33235), UINT16_C(  6924), UINT16_C( 46988),
                              UINT16_C( 27391), UINT16_C( 64736), UINT16_C( 29904), UINT16_C( 17668),
                              UINT16_C( 49454), UINT16_C( 28512), UINT16_C( 26039), UINT16_C( 25404)),
      simde_x_mm256_set_epu16(UINT16_C( 12315), UINT16_C( 64886), UINT16_C( 57734), UINT16_C( 64133),
                              UINT16_C( 13359), UINT16_C(  7125), UINT16_C(  7376), UINT16_C( 18777),
                              UINT16_C( 19616), UINT16_C( 14783), UINT16_C(  8825), UINT16_C( 49869),
                              UINT16_C( 26218), UINT16_C( 45019), UINT16_C( 44672), UINT16_C( 35307)),
      simde_x_mm256_set_epu16(UINT16_C( 15766), UINT16_C( 53211), UINT16_C( 45504), UINT16_C( 46486),
                              UINT16_C( 19287), UINT16_C( 20180), UINT16_C(  7150), UINT16_C( 32883),
                              UINT16_C( 23504), UINT16_C( 39760), UINT16_C( 19365), UINT16_C( 33769),
                              UINT16_C( 37836), UINT16_C( 36766), UINT16_C( 35356), UINT16_C( 30356)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_avg_epu16(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_u16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_blend_epi16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi16(INT16_C( -9012), INT16_C( 17188), INT16_C( 20170), INT16_C( -6948),
                            INT16_C(  9138), INT16_C( 24690), INT16_C( -6761), INT16_C( -2618),
                            INT16_C( 30583), INT16_C(  3343), INT16_C( -2458), INT16_C( 32235),
                            INT16_C(-14188), INT16_C( 15906), INT16_C(-17823), INT16_C(  7319)),
      simde_mm256_set_epi16(INT16_C( -5752), INT16_C(-23668), INT16_C(-25159), INT16_C(-19782),
                            INT16_C( 28185), INT16_C(-14343), INT16_C(-18599), INT16_C(   827),
                            INT16_C( -4902), INT16_C(  2482), INT16_C( 14836), INT16_C(-27028),
                            INT16_C( 23821), INT16_C( -1365), INT16_C( -4235), INT16_C(  -888)),
      simde_mm256_set_epi16(INT16_C( -9012), INT16_C( 17188), INT16_C( 20170), INT16_C( -6948),
                            INT16_C( 28185), INT16_C(-14343), INT16_C( -6761), INT16_C(   827),
                            INT16_C( 30583), INT16_C(  3343), INT16_C( -2458), INT16_C( 32235),
                            INT16_C( 23821), INT16_C( -1365), INT16_C(-17823), INT16_C(  -888)) },
    { simde_mm256_set_epi16(INT16_C(  2208), INT16_C( 24143), INT16_C( 20623), INT16_C( -5907),
                            INT16_C(  4359), INT16_C(  6016), INT16_C(  2606), INT16_C(-17968),
                            INT16_C( 24878), INT16_C(-20974), INT16_C( 11542), INT16_C( 18923),
                            INT16_C( 32276), INT16_C(-26730), INT16_C( 20467), INT16_C(-30404)),
      simde_mm256_set_epi16(INT16_C( 27588), INT16_C(-23388), INT16_C( 31848), INT16_C( 22463),
                            INT16_C(-31474), INT16_C(-14474), INT16_C(  2006), INT16_C(-32634),
                            INT16_C( 32036), INT16_C(-13145), INT16_C(-30339), INT16_C(-22528),
                            INT16_C( 17597), INT16_C( 17800), INT16_C( 16042), INT16_C( 23637)),
      simde_mm256_set_epi16(INT16_C(  2208), INT16_C( 24143), INT16_C( 20623), INT16_C( -5907),
                            INT16_C(-31474), INT16_C(-14474), INT16_C(  2606), INT16_C(-32634),
                            INT16_C( 24878), INT16_C(-20974), INT16_C( 11542), INT16_C( 18923),
                            INT16_C( 17597), INT16_C( 17800), INT16_C( 20467), INT16_C( 23637)) },
    { simde_mm256_set_epi16(INT16_C(-30302), INT16_C( -3491), INT16_C(-12187), INT16_C( -9390),
                            INT16_C( -5875), INT16_C(  4739), INT16_C( 19577), INT16_C(  7526),
                            INT16_C( 31347), INT16_C( 10086), INT16_C(-16595), INT16_C( 27410),
                            INT16_C(  1134), INT16_C(-11806), INT16_C(-16010), INT16_C(-25451)),
      simde_mm256_set_epi16(INT16_C(-29901), INT16_C( 18434), INT16_C(  -841), INT16_C( 28759),
                            INT16_C( -1918), INT16_C(  2817), INT16_C(-31249), INT16_C(  6853),
                            INT16_C( 24735), INT16_C(-25824), INT16_C( -1496), INT16_C( 12880),
                            INT16_C( 11586), INT16_C( 24977), INT16_C( 22341), INT16_C(-21470)),
      simde_mm256_set_epi16(INT16_C(-30302), INT16_C( -3491), INT16_C(-12187), INT16_C( -9390),
                            INT16_C( -1918), INT16_C(  2817), INT16_C( 19577), INT16_C(  6853),
                            INT16_C( 31347), INT16_C( 10086), INT16_C(-16595), INT16_C( 27410),
                            INT16_C( 11586), INT16_C( 24977), INT16_C(-16010), INT16_C(-21470)) },
    { simde_mm256_set_epi16(INT16_C( 17074), INT16_C(-20924), INT16_C( 13898), INT16_C( 20227),
                            INT16_C( 12334), INT16_C(-15702), INT16_C( 28564), INT16_C(-15082),
                            INT16_C(-19676), INT16_C(   796), INT16_C( 13442), INT16_C( -9023),
                            INT16_C( 10428), INT16_C( 21588), INT16_C(-25545), INT16_C( 22589)),
      simde_mm256_set_epi16(INT16_C( 13365), INT16_C(-16397), INT16_C(-14658), INT16_C(  8081),
                            INT16_C(  4626), INT16_C(-31038), INT16_C(-27498), INT16_C( -1797),
                            INT16_C(-14919), INT16_C( 31584), INT16_C( 32162), INT16_C( 21664),
                            INT16_C( 32327), INT16_C(  9046), INT16_C( 29457), INT16_C( 18165)),
      simde_mm256_set_epi16(INT16_C( 17074), INT16_C(-20924), INT16_C( 13898), INT16_C( 20227),
                            INT16_C(  4626), INT16_C(-31038), INT16_C( 28564), INT16_C( -1797),
                            INT16_C(-19676), INT16_C(   796), INT16_C( 13442), INT16_C( -9023),
                            INT16_C( 32327), INT16_C(  9046), INT16_C(-25545), INT16_C( 18165)) },
    { simde_mm256_set_epi16(INT16_C(-28976), INT16_C(-17452), INT16_C(-30835), INT16_C(-11288),
                            INT16_C( 23746), INT16_C(-12398), INT16_C( -9605), INT16_C(   914),
                            INT16_C( -6067), INT16_C(  4660), INT16_C( 15780), INT16_C( 30375),
                            INT16_C(-32484), INT16_C( 23271), INT16_C(-15980), INT16_C(  3969)),
      simde_mm256_set_epi16(INT16_C(-14502), INT16_C(-26489), INT16_C( -6738), INT16_C( -1193),
                            INT16_C( 15756), INT16_C(-12605), INT16_C(-12710), INT16_C( -8558),
                            INT16_C( 19027), INT16_C(-19772), INT16_C( 23814), INT16_C(-30071),
                            INT16_C(-29678), INT16_C( 31649), INT16_C(  4669), INT16_C( -4491)),
      simde_mm256_set_epi16(INT16_C(-28976), INT16_C(-17452), INT16_C(-30835), INT16_C(-11288),
                            INT16_C( 15756), INT16_C(-12605), INT16_C( -9605), INT16_C( -8558),
                            INT16_C( -6067), INT16_C(  4660), INT16_C( 15780), INT16_C( 30375),
                            INT16_C(-29678), INT16_C( 31649), INT16_C(-15980), INT16_C( -4491)) },
    { simde_mm256_set_epi16(INT16_C( 16416), INT16_C(-25375), INT16_C(-21092), INT16_C(-20302),
                            INT16_C(-10725), INT16_C(-20142), INT16_C( -4818), INT16_C(-14140),
                            INT16_C(-13625), INT16_C(-24584), INT16_C(  6087), INT16_C(-31850),
                            INT16_C(-29507), INT16_C(  7132), INT16_C( -6862), INT16_C( 26102)),
      simde_mm256_set_epi16(INT16_C(  3513), INT16_C(-30455), INT16_C(-14215), INT16_C(-31390),
                            INT16_C( 22371), INT16_C(-30450), INT16_C(-14197), INT16_C( -3991),
                            INT16_C( 25198), INT16_C( -1251), INT16_C( -4992), INT16_C(-16295),
                            INT16_C( 23622), INT16_C( 28506), INT16_C(-16087), INT16_C(-18392)),
      simde_mm256_set_epi16(INT16_C( 16416), INT16_C(-25375), INT16_C(-21092), INT16_C(-20302),
                            INT16_C( 22371), INT16_C(-30450), INT16_C( -4818), INT16_C( -3991),
                            INT16_C(-13625), INT16_C(-24584), INT16_C(  6087), INT16_C(-31850),
                            INT16_C( 23622), INT16_C( 28506), INT16_C( -6862), INT16_C(-18392)) },
    { simde_mm256_set_epi16(INT16_C( -2375), INT16_C(  3031), INT16_C( 26231), INT16_C(  5999),
                            INT16_C(-10519), INT16_C( 21791), INT16_C(  3889), INT16_C( 28062),
                            INT16_C(-23674), INT16_C(-25444), INT16_C( 16907), INT16_C( 20389),
                            INT16_C(-22712), INT16_C(   486), INT16_C( -2776), INT16_C(-21644)),
      simde_mm256_set_epi16(INT16_C(-29652), INT16_C(   489), INT16_C( -7346), INT16_C(-13391),
                            INT16_C( 21827), INT16_C(  9877), INT16_C(  7842), INT16_C(-13219),
                            INT16_C( 12847), INT16_C( 31187), INT16_C( -8174), INT16_C( -7953),
                            INT16_C(  8071), INT16_C(-19051), INT16_C( 30976), INT16_C( 20848)),
      simde_mm256_set_epi16(INT16_C( -2375), INT16_C(  3031), INT16_C( 26231), INT16_C(  5999),
                            INT16_C( 21827), INT16_C(  9877), INT16_C(  3889), INT16_C(-13219),
                            INT16_C(-23674), INT16_C(-25444), INT16_C( 16907), INT16_C( 20389),
                            INT16_C(  8071), INT16_C(-19051), INT16_C( -2776), INT16_C( 20848)) },
    { simde_mm256_set_epi16(INT16_C( 13214), INT16_C(-27703), INT16_C(  6386), INT16_C(  5153),
                            INT16_C( 26096), INT16_C(  8476), INT16_C( 10527), INT16_C(-23224),
                            INT16_C( 23690), INT16_C(  9355), INT16_C(  1283), INT16_C(-29402),
                            INT16_C( 22593), INT16_C(-12032), INT16_C( -8259), INT16_C( 13457)),
      simde_mm256_set_epi16(INT16_C(-25352), INT16_C( 21231), INT16_C(-11795), INT16_C( 17700),
                            INT16_C(-24048), INT16_C(-11558), INT16_C( -1645), INT16_C( 21362),
                            INT16_C( 18474), INT16_C( 30559), INT16_C(  -790), INT16_C( 30067),
                            INT16_C(  3488), INT16_C(  3834), INT16_C(  2645), INT16_C(-14787)),
      simde_mm256_set_epi16(INT16_C( 13214), INT16_C(-27703), INT16_C(  6386), INT16_C(  5153),
                            INT16_C(-24048), INT16_C(-11558), INT16_C( 10527), INT16_C( 21362),
                            INT16_C( 23690), INT16_C(  9355), INT16_C(  1283), INT16_C(-29402),
                            INT16_C(  3488), INT16_C(  3834), INT16_C( -8259), INT16_C(-14787)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_blend_epi16(test_vec[i].a, test_vec[i].b, 13);
    simde_assert_m256i_i16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_blend_epi32(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi32(INT32_C(   67571941), INT32_C(-1405773426), INT32_C( 1540271825), INT32_C( 2065572299),
                            INT32_C( -582398487), INT32_C( 1269568238), INT32_C( -277360429), INT32_C(  355946014)),
      simde_mm256_set_epi32(INT32_C(-1175528322), INT32_C( -128390122), INT32_C( 1870386786), INT32_C( 1369967555),
                            INT32_C(  417868105), INT32_C(  128490599), INT32_C( 1283738263), INT32_C( -937782732)),
      simde_mm256_set_epi32(INT32_C(   67571941), INT32_C(-1405773426), INT32_C( 1540271825), INT32_C( 2065572299),
                            INT32_C(  417868105), INT32_C(  128490599), INT32_C( -277360429), INT32_C( -937782732)) },
    { simde_mm256_set_epi32(INT32_C( 1471616457), INT32_C(  153196965), INT32_C(  177786947), INT32_C(-1953704859),
                            INT32_C(-2052334624), INT32_C(-1985445584), INT32_C(  389650479), INT32_C(-1304302924)),
      simde_mm256_set_epi32(INT32_C( -934897433), INT32_C( 1646862966), INT32_C(-1085276514), INT32_C(  112227015),
                            INT32_C(-1389537102), INT32_C(  687724210), INT32_C( 1265543631), INT32_C(  346850755)),
      simde_mm256_set_epi32(INT32_C( 1471616457), INT32_C(  153196965), INT32_C(  177786947), INT32_C(-1953704859),
                            INT32_C(-1389537102), INT32_C(  687724210), INT32_C(  389650479), INT32_C(  346850755)) },
    { simde_mm256_set_epi32(INT32_C(-1682060225), INT32_C(  867867583), INT32_C(  925546319), INT32_C( 1379938785),
                            INT32_C(  653018322), INT32_C( -687296073), INT32_C( -911101701), INT32_C( 1547072378)),
      simde_mm256_set_epi32(INT32_C( 1176167258), INT32_C( -301183666), INT32_C( -466020487), INT32_C(   52703344),
                            INT32_C( 1233020389), INT32_C( 1117532027), INT32_C( 1899739665), INT32_C(-2043295118)),
      simde_mm256_set_epi32(INT32_C(-1682060225), INT32_C(  867867583), INT32_C(  925546319), INT32_C( 1379938785),
                            INT32_C( 1233020389), INT32_C( 1117532027), INT32_C( -911101701), INT32_C(-2043295118)) },
    { simde_mm256_set_epi32(INT32_C(  359138398), INT32_C( -860526519), INT32_C( 1692947884), INT32_C(  772823662),
                            INT32_C( -270939677), INT32_C( 1412661540), INT32_C( 1070011153), INT32_C(  771375046)),
      simde_mm256_set_epi32(INT32_C( -974034130), INT32_C(   37087187), INT32_C( -871436522), INT32_C(   33095078),
                            INT32_C(  715849450), INT32_C(-1345812415), INT32_C(  -45115049), INT32_C( 1960320081)),
      simde_mm256_set_epi32(INT32_C(  359138398), INT32_C( -860526519), INT32_C( 1692947884), INT32_C(  772823662),
                            INT32_C(  715849450), INT32_C(-1345812415), INT32_C( 1070011153), INT32_C( 1960320081)) },
    { simde_mm256_set_epi32(INT32_C( -426383461), INT32_C( -768942960), INT32_C( -264677869), INT32_C( -822820045),
                            INT32_C( 1890345084), INT32_C(-2046745025), INT32_C( -207573670), INT32_C( 1399666591)),
      simde_mm256_set_epi32(INT32_C(  232105709), INT32_C(-1583898310), INT32_C( 1161298300), INT32_C(  169359829),
                            INT32_C(  621794425), INT32_C(  607256107), INT32_C( 1099667121), INT32_C( -184390486)),
      simde_mm256_set_epi32(INT32_C( -426383461), INT32_C( -768942960), INT32_C( -264677869), INT32_C( -822820045),
                            INT32_C(  621794425), INT32_C(  607256107), INT32_C( -207573670), INT32_C( -184390486)) },
    { simde_mm256_set_epi32(INT32_C(-1564290184), INT32_C( -240378472), INT32_C( 1142270593), INT32_C( 1000191111),
                            INT32_C(   20701140), INT32_C(   37555352), INT32_C( -694404400), INT32_C( 1055280730)),
      simde_mm256_set_epi32(INT32_C( 1835031057), INT32_C( 2079483638), INT32_C( 1962415366), INT32_C( -373228817),
                            INT32_C(  142245442), INT32_C(   51427720), INT32_C( 1717201652), INT32_C( 1177983710)),
      simde_mm256_set_epi32(INT32_C(-1564290184), INT32_C( -240378472), INT32_C( 1142270593), INT32_C( 1000191111),
                            INT32_C(  142245442), INT32_C(   51427720), INT32_C( -694404400), INT32_C( 1177983710)) },
    { simde_mm256_set_epi32(INT32_C(-1384452546), INT32_C( -108099055), INT32_C(   -3256672), INT32_C(-2139665218),
                            INT32_C( -280826539), INT32_C( -885573478), INT32_C( 2104257473), INT32_C( 1279376382)),
      simde_mm256_set_epi32(INT32_C( 1706246197), INT32_C(-1331652281), INT32_C( 1192842905), INT32_C( -885790109),
                            INT32_C(-1010846518), INT32_C( -536721191), INT32_C( 1967911533), INT32_C( 1933417937)),
      simde_mm256_set_epi32(INT32_C(-1384452546), INT32_C( -108099055), INT32_C(   -3256672), INT32_C(-2139665218),
                            INT32_C(-1010846518), INT32_C( -536721191), INT32_C( 2104257473), INT32_C( 1933417937)) },
    { simde_mm256_set_epi32(INT32_C( 1532802072), INT32_C(  125283422), INT32_C(-1578036874), INT32_C(  445027764),
                            INT32_C( -409254011), INT32_C( 1098938926), INT32_C(-1086732528), INT32_C( -812360922)),
      simde_mm256_set_epi32(INT32_C( 1974078859), INT32_C( 2037136311), INT32_C( 1463878416), INT32_C(  122656324),
                            INT32_C(-2126065903), INT32_C(-1726635542), INT32_C(-1755031182), INT32_C( 1725515904)),
      simde_mm256_set_epi32(INT32_C( 1532802072), INT32_C(  125283422), INT32_C(-1578036874), INT32_C(  445027764),
                            INT32_C(-2126065903), INT32_C(-1726635542), INT32_C(-1086732528), INT32_C( 1725515904)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_blend_epi32(test_vec[i].a, test_vec[i].b, 13);
    simde_assert_m256i_i32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_blendv_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i i;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi8(INT8_C( 119), INT8_C(  14), INT8_C( 127), INT8_C(-117),
                           INT8_C( -92), INT8_C(  49), INT8_C( -15), INT8_C( -64),
                           INT8_C(  66), INT8_C(-125), INT8_C(  43), INT8_C(   6),
                           INT8_C(-117), INT8_C(  95), INT8_C(   4), INT8_C( 100),
                           INT8_C(  82), INT8_C( -66), INT8_C(  57), INT8_C( -98),
                           INT8_C( -94), INT8_C(   7), INT8_C(  58), INT8_C(-109),
                           INT8_C( -21), INT8_C( -88), INT8_C(  12), INT8_C(  65),
                           INT8_C(-108), INT8_C( -25), INT8_C( -96), INT8_C(  -4)),
      simde_mm256_set_epi8(INT8_C( -68), INT8_C(  -8), INT8_C(  57), INT8_C( 103),
                           INT8_C(  55), INT8_C( 120), INT8_C(   1), INT8_C(  68),
                           INT8_C(  85), INT8_C(-119), INT8_C(  -3), INT8_C(  60),
                           INT8_C(-115), INT8_C( -64), INT8_C( 126), INT8_C( -67),
                           INT8_C(  11), INT8_C(  73), INT8_C(  97), INT8_C( -47),
                           INT8_C(  73), INT8_C( -17), INT8_C(  -4), INT8_C(  19),
                           INT8_C( -66), INT8_C(  -1), INT8_C(  84), INT8_C( -63),
                           INT8_C(  58), INT8_C( 114), INT8_C( 107), INT8_C( -13)),
      simde_mm256_set_epi8(INT8_C( -94), INT8_C( -13), INT8_C( -63), INT8_C(  48),
                           INT8_C(  72), INT8_C( -33), INT8_C(-118), INT8_C(  86),
                           INT8_C(  17), INT8_C( 112), INT8_C(   9), INT8_C( 106),
                           INT8_C( 115), INT8_C( -15), INT8_C(  74), INT8_C(   5),
                           INT8_C(  17), INT8_C( -31), INT8_C(-120), INT8_C(  18),
                           INT8_C(  82), INT8_C( -67), INT8_C(-101), INT8_C(-109),
                           INT8_C(  81), INT8_C(-126), INT8_C(  -8), INT8_C(   4),
                           INT8_C( 123), INT8_C( 125), INT8_C(  70), INT8_C(  66)),
      simde_mm256_set_epi8(INT8_C( -68), INT8_C(  -8), INT8_C(  57), INT8_C(-117),
                           INT8_C( -92), INT8_C( 120), INT8_C(   1), INT8_C( -64),
                           INT8_C(  66), INT8_C(-125), INT8_C(  43), INT8_C(   6),
                           INT8_C(-117), INT8_C( -64), INT8_C(   4), INT8_C( 100),
                           INT8_C(  82), INT8_C(  73), INT8_C(  97), INT8_C( -98),
                           INT8_C( -94), INT8_C( -17), INT8_C(  -4), INT8_C(  19),
                           INT8_C( -21), INT8_C(  -1), INT8_C(  84), INT8_C(  65),
                           INT8_C(-108), INT8_C( -25), INT8_C( -96), INT8_C(  -4)) },
    { simde_mm256_set_epi8(INT8_C( -95), INT8_C(  48), INT8_C(-106), INT8_C(   2),
                           INT8_C( -98), INT8_C(  42), INT8_C( 111), INT8_C( -63),
                           INT8_C(  63), INT8_C(  60), INT8_C(-104), INT8_C(-108),
                           INT8_C( -18), INT8_C( -88), INT8_C(  55), INT8_C(  21),
                           INT8_C(-103), INT8_C( 114), INT8_C( -80), INT8_C(  89),
                           INT8_C(  60), INT8_C(  45), INT8_C( -20), INT8_C(  79),
                           INT8_C(-112), INT8_C( -14), INT8_C( -11), INT8_C( 117),
                           INT8_C(  14), INT8_C( -21), INT8_C(  11), INT8_C(-119)),
      simde_mm256_set_epi8(INT8_C(   7), INT8_C( -82), INT8_C( -49), INT8_C(   6),
                           INT8_C(-108), INT8_C(-115), INT8_C( -95), INT8_C( -53),
                           INT8_C(   6), INT8_C(  28), INT8_C(  47), INT8_C(  86),
                           INT8_C( -76), INT8_C(-114), INT8_C( 114), INT8_C(  94),
                           INT8_C(  90), INT8_C(  13), INT8_C( 121), INT8_C(-123),
                           INT8_C( -33), INT8_C( -67), INT8_C(  30), INT8_C( -90),
                           INT8_C(  -5), INT8_C(  42), INT8_C( 102), INT8_C(  53),
                           INT8_C(  95), INT8_C(  56), INT8_C(   1), INT8_C( -15)),
      simde_mm256_set_epi8(INT8_C(-117), INT8_C( -35), INT8_C(  72), INT8_C( -41),
                           INT8_C(-118), INT8_C( 110), INT8_C(  61), INT8_C(  45),
                           INT8_C(-112), INT8_C( 112), INT8_C(  46), INT8_C( -75),
                           INT8_C(  71), INT8_C( -85), INT8_C( -58), INT8_C( 104),
                           INT8_C(-126), INT8_C(-109), INT8_C(  86), INT8_C(  70),
                           INT8_C( -85), INT8_C( 113), INT8_C(  90), INT8_C(  35),
                           INT8_C( -48), INT8_C( -83), INT8_C(  16), INT8_C(  55),
                           INT8_C( -13), INT8_C(  42), INT8_C( -55), INT8_C( -15)),
      simde_mm256_set_epi8(INT8_C(   7), INT8_C( -82), INT8_C(-106), INT8_C(   6),
                           INT8_C(-108), INT8_C(  42), INT8_C( 111), INT8_C( -63),
                           INT8_C(   6), INT8_C(  60), INT8_C(-104), INT8_C(  86),
                           INT8_C( -18), INT8_C(-114), INT8_C( 114), INT8_C(  21),
                           INT8_C(  90), INT8_C(  13), INT8_C( -80), INT8_C(  89),
                           INT8_C( -33), INT8_C(  45), INT8_C( -20), INT8_C(  79),
                           INT8_C(  -5), INT8_C(  42), INT8_C( -11), INT8_C( 117),
                           INT8_C(  95), INT8_C( -21), INT8_C(   1), INT8_C( -15)) },
    { simde_mm256_set_epi8(INT8_C(  12), INT8_C( 118), INT8_C(-120), INT8_C(  17),
                           INT8_C(  61), INT8_C(  24), INT8_C(-114), INT8_C(-117),
                           INT8_C( -20), INT8_C(-118), INT8_C(  93), INT8_C( 106),
                           INT8_C( -99), INT8_C(  -8), INT8_C( 114), INT8_C(-115),
                           INT8_C( -65), INT8_C( -34), INT8_C(  66), INT8_C(  62),
                           INT8_C( 113), INT8_C( -44), INT8_C( 109), INT8_C(  20),
                           INT8_C( 122), INT8_C( -58), INT8_C(   7), INT8_C(-123),
                           INT8_C(  18), INT8_C(  89), INT8_C( -84), INT8_C(-114)),
      simde_mm256_set_epi8(INT8_C( -67), INT8_C( -15), INT8_C( -72), INT8_C( -39),
                           INT8_C( -90), INT8_C( 108), INT8_C(  93), INT8_C( -36),
                           INT8_C( -64), INT8_C(  36), INT8_C( -98), INT8_C(  76),
                           INT8_C( 123), INT8_C( -40), INT8_C( -48), INT8_C(-111),
                           INT8_C(-100), INT8_C(  76), INT8_C( 114), INT8_C(  51),
                           INT8_C(  72), INT8_C(  51), INT8_C( 101), INT8_C(-128),
                           INT8_C( -68), INT8_C(  35), INT8_C( -50), INT8_C(-100),
                           INT8_C(  85), INT8_C(-109), INT8_C( -86), INT8_C(  43)),
      simde_mm256_set_epi8(INT8_C(  21), INT8_C(  44), INT8_C(  93), INT8_C( -14),
                           INT8_C(  76), INT8_C(  78), INT8_C( 101), INT8_C(  40),
                           INT8_C( 126), INT8_C( -37), INT8_C( 115), INT8_C(  17),
                           INT8_C(  43), INT8_C( -71), INT8_C(-123), INT8_C( -85),
                           INT8_C( -19), INT8_C(  27), INT8_C(  72), INT8_C(  57),
                           INT8_C( 118), INT8_C( -19), INT8_C( -66), INT8_C( 124),
                           INT8_C( -52), INT8_C( -69), INT8_C(  32), INT8_C(  64),
                           INT8_C( -16), INT8_C(-103), INT8_C( -39), INT8_C( 121)),
      simde_mm256_set_epi8(INT8_C(  12), INT8_C( 118), INT8_C(-120), INT8_C( -39),
                           INT8_C(  61), INT8_C(  24), INT8_C(-114), INT8_C(-117),
                           INT8_C( -20), INT8_C(  36), INT8_C(  93), INT8_C( 106),
                           INT8_C( -99), INT8_C( -40), INT8_C( -48), INT8_C(-111),
                           INT8_C(-100), INT8_C( -34), INT8_C(  66), INT8_C(  62),
                           INT8_C( 113), INT8_C(  51), INT8_C( 101), INT8_C(  20),
                           INT8_C( -68), INT8_C(  35), INT8_C(   7), INT8_C(-123),
                           INT8_C(  85), INT8_C(-109), INT8_C( -86), INT8_C(-114)) },
    { simde_mm256_set_epi8(INT8_C( -23), INT8_C( 109), INT8_C(  45), INT8_C( -63),
                           INT8_C(  54), INT8_C( -58), INT8_C( -11), INT8_C(  18),
                           INT8_C(  27), INT8_C( -68), INT8_C(-102), INT8_C(  76),
                           INT8_C( -97), INT8_C(  26), INT8_C(  10), INT8_C( -41),
                           INT8_C(  50), INT8_C(  54), INT8_C(-128), INT8_C(  77),
                           INT8_C( -33), INT8_C( -46), INT8_C( 118), INT8_C(  76),
                           INT8_C( -72), INT8_C( 106), INT8_C( -54), INT8_C(  28),
                           INT8_C(  86), INT8_C(  37), INT8_C(  -1), INT8_C(  83)),
      simde_mm256_set_epi8(INT8_C( 123), INT8_C(  58), INT8_C(  98), INT8_C( 125),
                           INT8_C( 118), INT8_C(-119), INT8_C( -36), INT8_C(  78),
                           INT8_C(   0), INT8_C(  77), INT8_C(  67), INT8_C( 118),
                           INT8_C(  22), INT8_C( -94), INT8_C( -70), INT8_C(  21),
                           INT8_C(  65), INT8_C(  89), INT8_C(  34), INT8_C(  21),
                           INT8_C(  65), INT8_C( -53), INT8_C( -43), INT8_C( -55),
                           INT8_C( -12), INT8_C( -79), INT8_C(-123), INT8_C(  80),
                           INT8_C( -58), INT8_C( -76), INT8_C( -82), INT8_C(  16)),
      simde_mm256_set_epi8(INT8_C( -15), INT8_C( -31), INT8_C( 124), INT8_C(  18),
                           INT8_C(  63), INT8_C(-119), INT8_C( -84), INT8_C( -47),
                           INT8_C( 110), INT8_C(  99), INT8_C(  -7), INT8_C( -78),
                           INT8_C( 122), INT8_C(   9), INT8_C(  54), INT8_C(-112),
                           INT8_C(-100), INT8_C(  -9), INT8_C(-127), INT8_C(  67),
                           INT8_C( -60), INT8_C( -43), INT8_C(  76), INT8_C(  10),
                           INT8_C(  83), INT8_C( -83), INT8_C( -60), INT8_C( -94),
                           INT8_C( -63), INT8_C( 113), INT8_C(-114), INT8_C( 124)),
      simde_mm256_set_epi8(INT8_C( 123), INT8_C(  58), INT8_C(  45), INT8_C( -63),
                           INT8_C(  54), INT8_C(-119), INT8_C( -36), INT8_C(  78),
                           INT8_C(  27), INT8_C( -68), INT8_C(  67), INT8_C( 118),
                           INT8_C( -97), INT8_C(  26), INT8_C(  10), INT8_C(  21),
                           INT8_C(  65), INT8_C(  89), INT8_C(  34), INT8_C(  77),
                           INT8_C(  65), INT8_C( -53), INT8_C( 118), INT8_C(  76),
                           INT8_C( -72), INT8_C( -79), INT8_C(-123), INT8_C(  80),
                           INT8_C( -58), INT8_C(  37), INT8_C( -82), INT8_C(  83)) },
    { simde_mm256_set_epi8(INT8_C(  71), INT8_C(  12), INT8_C( 123), INT8_C(-112),
                           INT8_C(-126), INT8_C(  60), INT8_C( 108), INT8_C(-103),
                           INT8_C( 103), INT8_C( 120), INT8_C( -99), INT8_C( 114),
                           INT8_C(  34), INT8_C( -37), INT8_C( -98), INT8_C( -39),
                           INT8_C(-107), INT8_C( -14), INT8_C(  -8), INT8_C( -82),
                           INT8_C( 123), INT8_C(  78), INT8_C(  27), INT8_C(   7),
                           INT8_C(  90), INT8_C(-108), INT8_C( -54), INT8_C(  40),
                           INT8_C(  -9), INT8_C( -18), INT8_C(  12), INT8_C(   6)),
      simde_mm256_set_epi8(INT8_C(  20), INT8_C( -98), INT8_C(  96), INT8_C(   3),
                           INT8_C(  27), INT8_C(  45), INT8_C( -97), INT8_C( -19),
                           INT8_C( -40), INT8_C( -84), INT8_C( -70), INT8_C( -38),
                           INT8_C( -57), INT8_C(-122), INT8_C( -18), INT8_C( -59),
                           INT8_C( -66), INT8_C(  38), INT8_C(  28), INT8_C( -72),
                           INT8_C(  41), INT8_C( -85), INT8_C(-107), INT8_C( 124),
                           INT8_C(-120), INT8_C(   0), INT8_C(  52), INT8_C( -73),
                           INT8_C( -94), INT8_C(-103), INT8_C( 104), INT8_C(-108)),
      simde_mm256_set_epi8(INT8_C( 114), INT8_C(  67), INT8_C(  87), INT8_C(  60),
                           INT8_C( -47), INT8_C(-121), INT8_C( -54), INT8_C( 110),
                           INT8_C(-100), INT8_C( 105), INT8_C( -23), INT8_C(  81),
                           INT8_C(-121), INT8_C(  67), INT8_C(  97), INT8_C(-125),
                           INT8_C(  78), INT8_C( 118), INT8_C(  46), INT8_C( -85),
                           INT8_C(  78), INT8_C( -66), INT8_C(  11), INT8_C(  90),
                           INT8_C(  11), INT8_C( 120), INT8_C(  20), INT8_C(  83),
                           INT8_C( 103), INT8_C( -43), INT8_C(  72), INT8_C( -92)),
      simde_mm256_set_epi8(INT8_C(  71), INT8_C(  12), INT8_C( 123), INT8_C(-112),
                           INT8_C(  27), INT8_C(  45), INT8_C( -97), INT8_C(-103),
                           INT8_C( -40), INT8_C( 120), INT8_C( -70), INT8_C( 114),
                           INT8_C( -57), INT8_C( -37), INT8_C( -98), INT8_C( -59),
                           INT8_C(-107), INT8_C( -14), INT8_C(  -8), INT8_C( -72),
                           INT8_C( 123), INT8_C( -85), INT8_C(  27), INT8_C(   7),
                           INT8_C(  90), INT8_C(-108), INT8_C( -54), INT8_C(  40),
                           INT8_C(  -9), INT8_C(-103), INT8_C(  12), INT8_C(-108)) },
    { simde_mm256_set_epi8(INT8_C(-120), INT8_C( -17), INT8_C(  71), INT8_C( 108),
                           INT8_C(-124), INT8_C(   8), INT8_C(  38), INT8_C(-124),
                           INT8_C( -33), INT8_C( -80), INT8_C(  82), INT8_C( -52),
                           INT8_C( -85), INT8_C(  20), INT8_C( -43), INT8_C(  49),
                           INT8_C(-127), INT8_C(  82), INT8_C(-125), INT8_C(-107),
                           INT8_C(  99), INT8_C( -94), INT8_C(  98), INT8_C( 124),
                           INT8_C(  23), INT8_C(  -8), INT8_C( -30), INT8_C( 107),
                           INT8_C( -17), INT8_C( -36), INT8_C(  65), INT8_C(  35)),
      simde_mm256_set_epi8(INT8_C(  50), INT8_C( -42), INT8_C(  70), INT8_C(  74),
                           INT8_C( -25), INT8_C( 118), INT8_C(  53), INT8_C(  91),
                           INT8_C( -24), INT8_C(  44), INT8_C(-107), INT8_C(  38),
                           INT8_C(  62), INT8_C(  93), INT8_C(  84), INT8_C(  86),
                           INT8_C(  25), INT8_C(  25), INT8_C(  -1), INT8_C( -49),
                           INT8_C( -69), INT8_C( -81), INT8_C(  33), INT8_C( -90),
                           INT8_C( 118), INT8_C(  99), INT8_C( -68), INT8_C(  38),
                           INT8_C( -18), INT8_C( -20), INT8_C( -37), INT8_C( -57)),
      simde_mm256_set_epi8(INT8_C(  36), INT8_C(  48), INT8_C(-118), INT8_C( 125),
                           INT8_C(  12), INT8_C( 115), INT8_C( -38), INT8_C(   1),
                           INT8_C( -43), INT8_C(-120), INT8_C( 119), INT8_C(  88),
                           INT8_C(  19), INT8_C(   1), INT8_C(  40), INT8_C( -39),
                           INT8_C( -67), INT8_C(  66), INT8_C( -86), INT8_C(  38),
                           INT8_C(  40), INT8_C( -46), INT8_C( 104), INT8_C( -95),
                           INT8_C( 115), INT8_C( -49), INT8_C(  15), INT8_C(-101),
                           INT8_C( -79), INT8_C(  -5), INT8_C( 112), INT8_C( -45)),
      simde_mm256_set_epi8(INT8_C(-120), INT8_C( -17), INT8_C(  70), INT8_C( 108),
                           INT8_C(-124), INT8_C(   8), INT8_C(  53), INT8_C(-124),
                           INT8_C( -24), INT8_C(  44), INT8_C(  82), INT8_C( -52),
                           INT8_C( -85), INT8_C(  20), INT8_C( -43), INT8_C(  86),
                           INT8_C(  25), INT8_C(  82), INT8_C(  -1), INT8_C(-107),
                           INT8_C(  99), INT8_C( -81), INT8_C(  98), INT8_C( -90),
                           INT8_C(  23), INT8_C(  99), INT8_C( -30), INT8_C(  38),
                           INT8_C( -18), INT8_C( -20), INT8_C(  65), INT8_C( -57)) },
    { simde_mm256_set_epi8(INT8_C(  55), INT8_C(  33), INT8_C(  43), INT8_C(  65),
                           INT8_C( -59), INT8_C( -95), INT8_C(  10), INT8_C(  11),
                           INT8_C( 122), INT8_C(  35), INT8_C(  55), INT8_C( 107),
                           INT8_C( -46), INT8_C(-119), INT8_C(-106), INT8_C(  77),
                           INT8_C( -56), INT8_C( -78), INT8_C( -97), INT8_C(-126),
                           INT8_C( -36), INT8_C(  17), INT8_C(  13), INT8_C(  38),
                           INT8_C(  52), INT8_C( -31), INT8_C(  68), INT8_C(  51),
                           INT8_C( -16), INT8_C(  61), INT8_C( -72), INT8_C( -48)),
      simde_mm256_set_epi8(INT8_C( 123), INT8_C(-111), INT8_C( -83), INT8_C(  -8),
                           INT8_C(  66), INT8_C( -69), INT8_C( -27), INT8_C(-103),
                           INT8_C(-112), INT8_C( -80), INT8_C(  56), INT8_C(  60),
                           INT8_C(-106), INT8_C(  -4), INT8_C(-128), INT8_C(-122),
                           INT8_C(  74), INT8_C( -55), INT8_C( -48), INT8_C(-128),
                           INT8_C(  -2), INT8_C(  63), INT8_C( -37), INT8_C(  18),
                           INT8_C( -89), INT8_C( -76), INT8_C(  42), INT8_C(  62),
                           INT8_C(  74), INT8_C( -87), INT8_C(  30), INT8_C(-103)),
      simde_mm256_set_epi8(INT8_C(   4), INT8_C( -10), INT8_C(  -5), INT8_C(  -1),
                           INT8_C(  -4), INT8_C(  87), INT8_C( -59), INT8_C(  -9),
                           INT8_C( -53), INT8_C(  83), INT8_C( -63), INT8_C(  99),
                           INT8_C(  55), INT8_C( 119), INT8_C(  36), INT8_C( -96),
                           INT8_C( -98), INT8_C(  22), INT8_C(   4), INT8_C(-128),
                           INT8_C(  16), INT8_C( -72), INT8_C( 114), INT8_C(  35),
                           INT8_C( -15), INT8_C( -10), INT8_C(  97), INT8_C(-112),
                           INT8_C(-109), INT8_C( -68), INT8_C(   8), INT8_C( 101)),
      simde_mm256_set_epi8(INT8_C(  55), INT8_C(-111), INT8_C( -83), INT8_C(  -8),
                           INT8_C(  66), INT8_C( -95), INT8_C( -27), INT8_C(-103),
                           INT8_C(-112), INT8_C(  35), INT8_C(  56), INT8_C( 107),
                           INT8_C( -46), INT8_C(-119), INT8_C(-106), INT8_C(-122),
                           INT8_C(  74), INT8_C( -78), INT8_C( -97), INT8_C(-128),
                           INT8_C( -36), INT8_C(  63), INT8_C(  13), INT8_C(  38),
                           INT8_C( -89), INT8_C( -76), INT8_C(  68), INT8_C(  62),
                           INT8_C(  74), INT8_C( -87), INT8_C( -72), INT8_C( -48)) },
    { simde_mm256_set_epi8(INT8_C(  69), INT8_C( -38), INT8_C(-105), INT8_C( -77),
                           INT8_C(   3), INT8_C( -19), INT8_C( -91), INT8_C(  81),
                           INT8_C( -61), INT8_C(  88), INT8_C( -52), INT8_C( -76),
                           INT8_C(-100), INT8_C( -70), INT8_C( -64), INT8_C(  71),
                           INT8_C(  82), INT8_C(-122), INT8_C( -41), INT8_C( -86),
                           INT8_C(   9), INT8_C(  29), INT8_C( -31), INT8_C( -87),
                           INT8_C(-113), INT8_C( 100), INT8_C( 100), INT8_C( -55),
                           INT8_C( -11), INT8_C(  92), INT8_C( -87), INT8_C(  43)),
      simde_mm256_set_epi8(INT8_C(  96), INT8_C(-116), INT8_C(   5), INT8_C(  16),
                           INT8_C( -66), INT8_C(   4), INT8_C(   8), INT8_C(  34),
                           INT8_C(  93), INT8_C(  90), INT8_C( -27), INT8_C(  86),
                           INT8_C( 115), INT8_C(  27), INT8_C( -30), INT8_C(  15),
                           INT8_C(  94), INT8_C( -93), INT8_C( -55), INT8_C( -18),
                           INT8_C(-122), INT8_C(  51), INT8_C( -22), INT8_C( -72),
                           INT8_C( -80), INT8_C(  24), INT8_C(  38), INT8_C(  87),
                           INT8_C( -35), INT8_C( -67), INT8_C(  94), INT8_C( -17)),
      simde_mm256_set_epi8(INT8_C( -19), INT8_C( -11), INT8_C(  77), INT8_C( -75),
                           INT8_C(  98), INT8_C( -18), INT8_C( -28), INT8_C(   5),
                           INT8_C(  86), INT8_C(-117), INT8_C( 114), INT8_C( -52),
                           INT8_C(  63), INT8_C( -51), INT8_C( 110), INT8_C( -22),
                           INT8_C(  54), INT8_C(  36), INT8_C(  44), INT8_C(  72),
                           INT8_C( -14), INT8_C( -61), INT8_C( -76), INT8_C(  51),
                           INT8_C(  40), INT8_C( -28), INT8_C( -97), INT8_C( 114),
                           INT8_C(-128), INT8_C(   9), INT8_C(  94), INT8_C( -35)),
      simde_mm256_set_epi8(INT8_C(  96), INT8_C(-116), INT8_C(-105), INT8_C(  16),
                           INT8_C(   3), INT8_C(   4), INT8_C(   8), INT8_C(  81),
                           INT8_C( -61), INT8_C(  90), INT8_C( -52), INT8_C(  86),
                           INT8_C(-100), INT8_C(  27), INT8_C( -64), INT8_C(  15),
                           INT8_C(  82), INT8_C(-122), INT8_C( -41), INT8_C( -86),
                           INT8_C(-122), INT8_C(  51), INT8_C( -22), INT8_C( -87),
                           INT8_C(-113), INT8_C(  24), INT8_C(  38), INT8_C( -55),
                           INT8_C( -35), INT8_C(  92), INT8_C( -87), INT8_C( -17)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_blendv_epi8(test_vec[i].a, test_vec[i].b, test_vec[i].i);
    simde_assert_m256i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_cmpeq_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi8( INT8_C( -34),  INT8_C(  65),  INT8_C( -18),  INT8_C( -94),
                            INT8_C(  20),  INT8_C(-105),  INT8_C(  79),  INT8_C( -26),
                            INT8_C(   7),  INT8_C( -36),  INT8_C(  33),  INT8_C( 123),
                            INT8_C( 115),  INT8_C( -52),  INT8_C( -98),  INT8_C(  62),
                            INT8_C(  64),  INT8_C( -91),  INT8_C(  45),  INT8_C( 102),
                            INT8_C(  21),  INT8_C(-111),  INT8_C( -41),  INT8_C( -14),
                            INT8_C(  91),  INT8_C(-106),  INT8_C(  23),  INT8_C(  86),
                            INT8_C(-108),  INT8_C(  34),  INT8_C(  -9),  INT8_C(  42)),
      simde_mm256_set_epi8( INT8_C( -34),  INT8_C(  65),  INT8_C(-119),  INT8_C( -94),
                            INT8_C( -15),  INT8_C(  95),  INT8_C(  72),  INT8_C(  66),
                            INT8_C(-113),  INT8_C( -36), ~INT8_C(   0),  INT8_C( 123),
                            INT8_C( -47),  INT8_C( -52),  INT8_C(  -7),  INT8_C(  62),
                            INT8_C(  31),  INT8_C(  79),  INT8_C(  20),  INT8_C( 102),
                            INT8_C(  21),  INT8_C(  17),  INT8_C(-125),  INT8_C( -14),
                            INT8_C(  22),  INT8_C(-111),  INT8_C(  23),  INT8_C( 100),
                            INT8_C(-122),  INT8_C(  34),  INT8_C( -26),  INT8_C(  42)),
      simde_mm256_set_epi8(~INT8_C(   0), ~INT8_C(   0),  INT8_C(   0), ~INT8_C(   0),
                            INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),
                            INT8_C(   0), ~INT8_C(   0),  INT8_C(   0), ~INT8_C(   0),
                            INT8_C(   0), ~INT8_C(   0),  INT8_C(   0), ~INT8_C(   0),
                            INT8_C(   0),  INT8_C(   0),  INT8_C(   0), ~INT8_C(   0),
                           ~INT8_C(   0),  INT8_C(   0),  INT8_C(   0), ~INT8_C(   0),
                            INT8_C(   0),  INT8_C(   0), ~INT8_C(   0),  INT8_C(   0),
                            INT8_C(   0), ~INT8_C(   0),  INT8_C(   0), ~INT8_C(   0)) },
    { simde_mm256_set_epi8( INT8_C(  61),  INT8_C(  96),  INT8_C( -54),  INT8_C(  88),
                            INT8_C(-115),  INT8_C(  14),  INT8_C( 100),  INT8_C( -28),
                            INT8_C(  78),  INT8_C( -79),  INT8_C(  80),  INT8_C( 114),
                            INT8_C(  29),  INT8_C( -69),  INT8_C(   6),  INT8_C(-127),
                            INT8_C( 116),  INT8_C(  35),  INT8_C(  49),  INT8_C( -24),
                            INT8_C(   4),  INT8_C(-123),  INT8_C( -95),  INT8_C( -23),
                            INT8_C(  44),  INT8_C(  68),  INT8_C( -84),  INT8_C(  -9),
                            INT8_C( -86),  INT8_C( 117),  INT8_C(  55),  INT8_C( 121)),
      simde_mm256_set_epi8( INT8_C(  61),  INT8_C(  81),  INT8_C(  33),  INT8_C(  88),
                            INT8_C( -34),  INT8_C(  14),  INT8_C( 111),  INT8_C( -28),
                            INT8_C( -70),  INT8_C(-102),  INT8_C( 116),  INT8_C(-102),
                            INT8_C(  29),  INT8_C( -10),  INT8_C(  13),  INT8_C( 109),
                            INT8_C( 116),  INT8_C( -83),  INT8_C(  49),  INT8_C(   1),
                            INT8_C(   4),  INT8_C(-123),  INT8_C( -18),  INT8_C( -23),
                            INT8_C(  44),  INT8_C(  68),  INT8_C(-109),  INT8_C(  54),
                            INT8_C( 123),  INT8_C(  62),  INT8_C(  71),  INT8_C(   3)),
      simde_mm256_set_epi8(~INT8_C(   0),  INT8_C(   0),  INT8_C(   0), ~INT8_C(   0),
                            INT8_C(   0), ~INT8_C(   0),  INT8_C(   0), ~INT8_C(   0),
                            INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),
                           ~INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),
                           ~INT8_C(   0),  INT8_C(   0), ~INT8_C(   0),  INT8_C(   0),
                           ~INT8_C(   0), ~INT8_C(   0),  INT8_C(   0), ~INT8_C(   0),
                           ~INT8_C(   0), ~INT8_C(   0),  INT8_C(   0),  INT8_C(   0),
                            INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0)) },
    { simde_mm256_set_epi8( INT8_C( -58),  INT8_C( -55),  INT8_C( 126),  INT8_C( -17),
                            INT8_C( -94),  INT8_C( -45),  INT8_C( -42),  INT8_C(  39),
                            INT8_C( -81),  INT8_C( -73),  INT8_C( -20),  INT8_C( -73),
                            INT8_C(  79),  INT8_C(  25),  INT8_C( -86),  INT8_C( -52),
                            INT8_C( 106),  INT8_C(  58),  INT8_C( 113),  INT8_C(  61),
                            INT8_C( -71),  INT8_C(  -3),  INT8_C( 101),  INT8_C(-102),
                            INT8_C( -14),  INT8_C( -40),  INT8_C(  82),  INT8_C( -84),
                            INT8_C(  49),  INT8_C(  46),  INT8_C(  59),  INT8_C( -33)),
      simde_mm256_set_epi8( INT8_C( 110),  INT8_C( -67),  INT8_C( 126),  INT8_C( -17),
                            INT8_C( -94),  INT8_C( -46),  INT8_C( -74),  INT8_C( -37),
                            INT8_C( -81),  INT8_C( -93),  INT8_C(  97),  INT8_C( -73),
                            INT8_C( -66),  INT8_C(  25),  INT8_C(  37),  INT8_C( -52),
                            INT8_C( 106),  INT8_C( -80),  INT8_C( 113),  INT8_C(  61),
                            INT8_C( -50),  INT8_C(  68),  INT8_C( 101),  INT8_C(-102),
                            INT8_C( -14),  INT8_C( -35),  INT8_C(  54),  INT8_C(  -2),
                            INT8_C(  49),  INT8_C(  46),  INT8_C(   6),  INT8_C(   4)),
      simde_mm256_set_epi8( INT8_C(   0),  INT8_C(   0), ~INT8_C(   0), ~INT8_C(   0),
                           ~INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),
                           ~INT8_C(   0),  INT8_C(   0),  INT8_C(   0), ~INT8_C(   0),
                            INT8_C(   0), ~INT8_C(   0),  INT8_C(   0), ~INT8_C(   0),
                           ~INT8_C(   0),  INT8_C(   0), ~INT8_C(   0), ~INT8_C(   0),
                            INT8_C(   0),  INT8_C(   0), ~INT8_C(   0), ~INT8_C(   0),
                           ~INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),
                           ~INT8_C(   0), ~INT8_C(   0),  INT8_C(   0),  INT8_C(   0)) },
    { simde_mm256_set_epi8( INT8_C(  -9),  INT8_C(  28),  INT8_C(   1),  INT8_C(   0),
                            INT8_C(  57),  INT8_C( -72),  INT8_C( -61),  INT8_C(  74),
                            INT8_C(-105),  INT8_C(  58),  INT8_C(  84),  INT8_C(  60),
                            INT8_C(  21),  INT8_C(  38),  INT8_C(  16),  INT8_C(  25),
                            INT8_C(   2),  INT8_C( -63),  INT8_C(  28),  INT8_C(  93),
                            INT8_C( -44),  INT8_C( -78),  INT8_C( -50),  INT8_C( -21),
                            INT8_C(  47),  INT8_C(  30),  INT8_C(  97),  INT8_C(  18),
                            INT8_C( -36),  INT8_C(  72),  INT8_C( -66),  INT8_C( 124)),
      simde_mm256_set_epi8( INT8_C(-127),  INT8_C( -27),  INT8_C(  86),  INT8_C( -50),
                            INT8_C(  57),  INT8_C( -49),  INT8_C( -61),  INT8_C(  74),
                            INT8_C(-105),  INT8_C( -45),  INT8_C( 125),  INT8_C(  18),
                            INT8_C( -47),  INT8_C(  70),  INT8_C(  16),  INT8_C(  90),
                            INT8_C(   2),  INT8_C( -44),  INT8_C( 121),  INT8_C(  48),
                            INT8_C( -78),  INT8_C( 120),  INT8_C( -50),  INT8_C( -21),
                            INT8_C(  47),  INT8_C( -59),  INT8_C(  97),  INT8_C(  21),
                            INT8_C( -36),  INT8_C(  72),  INT8_C( -44),  INT8_C( 124)),
      simde_mm256_set_epi8( INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),
                           ~INT8_C(   0),  INT8_C(   0), ~INT8_C(   0), ~INT8_C(   0),
                           ~INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),
                            INT8_C(   0),  INT8_C(   0), ~INT8_C(   0),  INT8_C(   0),
                           ~INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),
                            INT8_C(   0),  INT8_C(   0), ~INT8_C(   0), ~INT8_C(   0),
                           ~INT8_C(   0),  INT8_C(   0), ~INT8_C(   0),  INT8_C(   0),
                           ~INT8_C(   0), ~INT8_C(   0),  INT8_C(   0), ~INT8_C(   0)) },
    { simde_mm256_set_epi8( INT8_C(  75),  INT8_C(  -6),  INT8_C( -43),  INT8_C( 107),
                            INT8_C(  28),  INT8_C(  81),  INT8_C(  82),  INT8_C(  91),
                            INT8_C(  66),  INT8_C( 107),  INT8_C( -41),  INT8_C( -50),
                            INT8_C(  -5),  INT8_C(  66),  INT8_C(-100),  INT8_C( 112),
                            INT8_C(-109),  INT8_C(  92),  INT8_C( -50),  INT8_C(  68),
                            INT8_C( -54),  INT8_C( 111),  INT8_C(  25),  INT8_C(  36),
                            INT8_C(  30),  INT8_C( -33),  INT8_C(  28),  INT8_C(  68),
                            INT8_C( -69),  INT8_C( 124),  INT8_C(-124),  INT8_C(  48)),
      simde_mm256_set_epi8( INT8_C(  26),  INT8_C( 124),  INT8_C( -85),  INT8_C(  90),
                            INT8_C(  49),  INT8_C( -43),  INT8_C(  82),  INT8_C(-110),
                            INT8_C(  -4),  INT8_C(-103),  INT8_C(-116),  INT8_C( -91),
                            INT8_C( 101),  INT8_C( -60),  INT8_C(  28),  INT8_C( -62),
                            INT8_C(-109),  INT8_C(   2),  INT8_C(  71),  INT8_C(  68),
                            INT8_C(  92),  INT8_C( -96),  INT8_C( -47),  INT8_C(  89),
                            INT8_C(-111),  INT8_C( -89),  INT8_C(  38),  INT8_C( 109),
                            INT8_C( -69),  INT8_C(  57),  INT8_C(  87),  INT8_C(  94)),
      simde_mm256_set_epi8( INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),
                            INT8_C(   0),  INT8_C(   0), ~INT8_C(   0),  INT8_C(   0),
                            INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),
                            INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),
                           ~INT8_C(   0),  INT8_C(   0),  INT8_C(   0), ~INT8_C(   0),
                            INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),
                            INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),
                           ~INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0)) },
    { simde_mm256_set_epi8( INT8_C(  78),  INT8_C(-103),  INT8_C( -83),  INT8_C( -64),
                            INT8_C(  86),  INT8_C(  62),  INT8_C(  40),  INT8_C(-116),
                            INT8_C(  49),  INT8_C(  94),  INT8_C( -31),  INT8_C(  82),
                            INT8_C( -55),  INT8_C(-100),  INT8_C( -61),  INT8_C( -62),
                            INT8_C(-101),  INT8_C( 117),  INT8_C( -20),  INT8_C(  19),
                            INT8_C( -97),  INT8_C( -75),  INT8_C(-101),  INT8_C( -39),
                            INT8_C(  28),  INT8_C(  55),  INT8_C(  85),  INT8_C( 106),
                            INT8_C( -97),  INT8_C( -74),  INT8_C(  51),  INT8_C( -54)),
      simde_mm256_set_epi8( INT8_C(-116),  INT8_C( -91),  INT8_C( 105),  INT8_C( -64),
                            INT8_C(  -6),  INT8_C( -63),  INT8_C(  82),  INT8_C(   4),
                            INT8_C(  -7),  INT8_C( -70),  INT8_C( -31),  INT8_C( -83),
                            INT8_C(  22),  INT8_C(-100),  INT8_C(  96),  INT8_C( -62),
                            INT8_C(-120),  INT8_C( 120),  INT8_C( -20),  INT8_C( -80),
                            INT8_C( -97),  INT8_C( -75),  INT8_C( -29),  INT8_C(   4),
                            INT8_C(  28),  INT8_C(  60),  INT8_C(  79),  INT8_C(  73),
                            INT8_C(  17),  INT8_C(-120),  INT8_C( 110),  INT8_C( 100)),
      simde_mm256_set_epi8( INT8_C(   0),  INT8_C(   0),  INT8_C(   0), ~INT8_C(   0),
                            INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),
                            INT8_C(   0),  INT8_C(   0), ~INT8_C(   0),  INT8_C(   0),
                            INT8_C(   0), ~INT8_C(   0),  INT8_C(   0), ~INT8_C(   0),
                            INT8_C(   0),  INT8_C(   0), ~INT8_C(   0),  INT8_C(   0),
                           ~INT8_C(   0), ~INT8_C(   0),  INT8_C(   0),  INT8_C(   0),
                           ~INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),
                            INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0)) },
    { simde_mm256_set_epi8( INT8_C( 118),  INT8_C(  88),  INT8_C(  13),  INT8_C(  39),
                            INT8_C( -45),  INT8_C(  46),  INT8_C( -85),  INT8_C(  17),
                            INT8_C(  -7),  INT8_C(  75),  INT8_C(  -5),  INT8_C(-120),
                            INT8_C( -77),  INT8_C( -49),  INT8_C(  58),  INT8_C( -50),
                            INT8_C(   0),  INT8_C(  21),  INT8_C( -11),  INT8_C( -48),
                            INT8_C( -85),  INT8_C(  55),  INT8_C( 100), ~INT8_C(   0),
                            INT8_C(   7),  INT8_C(  72),  INT8_C(  25),  INT8_C(-126),
                            INT8_C( -81),  INT8_C( -15),  INT8_C( -25),  INT8_C( -55)),
      simde_mm256_set_epi8( INT8_C( 107),  INT8_C(  67),  INT8_C( -53),  INT8_C(  30),
                            INT8_C(  53),  INT8_C( -25),  INT8_C(  94),  INT8_C(  90),
                            INT8_C( -59),  INT8_C(  75),  INT8_C(  65),  INT8_C(-120),
                            INT8_C(  32),  INT8_C( -11),  INT8_C(  58),  INT8_C(  33),
                            INT8_C(   0),  INT8_C(  44),  INT8_C( -11),  INT8_C(  49),
                            INT8_C( -51),  INT8_C(  55),  INT8_C( 100),  INT8_C( -67),
                            INT8_C( -45),  INT8_C(  89),  INT8_C(  25),  INT8_C( 110),
                            INT8_C(  60),  INT8_C( -42),  INT8_C( -25),  INT8_C(   1)),
      simde_mm256_set_epi8( INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),
                            INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),
                            INT8_C(   0), ~INT8_C(   0),  INT8_C(   0), ~INT8_C(   0),
                            INT8_C(   0),  INT8_C(   0), ~INT8_C(   0),  INT8_C(   0),
                           ~INT8_C(   0),  INT8_C(   0), ~INT8_C(   0),  INT8_C(   0),
                            INT8_C(   0), ~INT8_C(   0), ~INT8_C(   0),  INT8_C(   0),
                            INT8_C(   0),  INT8_C(   0), ~INT8_C(   0),  INT8_C(   0),
                            INT8_C(   0),  INT8_C(   0), ~INT8_C(   0),  INT8_C(   0)) },
    { simde_mm256_set_epi8( INT8_C(  47),  INT8_C( 126),  INT8_C( -95),  INT8_C(-121),
                            INT8_C(  84),  INT8_C(  11),  INT8_C(  -4),  INT8_C( -74),
                            INT8_C(-124),  INT8_C(   4),  INT8_C( -12),  INT8_C(  31),
                            INT8_C(  41),  INT8_C(  31),  INT8_C( -42),  INT8_C(  92),
                            INT8_C( -62),  INT8_C(  -8),  INT8_C( -73),  INT8_C(  14),
                            INT8_C(  22),  INT8_C(-109),  INT8_C( 103),  INT8_C(  90),
                            INT8_C(  98),  INT8_C( -28),  INT8_C( -11),  INT8_C(-120),
                            INT8_C( -81),  INT8_C(   0),  INT8_C(  34),  INT8_C(  36)),
      simde_mm256_set_epi8( INT8_C(  47),  INT8_C(-103),  INT8_C( -95),  INT8_C(-121),
                            INT8_C(  84),  INT8_C(  72),  INT8_C( 125),  INT8_C( -13),
                            INT8_C( -49),  INT8_C(  14),  INT8_C(  44),  INT8_C( 110),
                            INT8_C(  41),  INT8_C(  68),  INT8_C( -42),  INT8_C(  92),
                            INT8_C( 107),  INT8_C(  -8),  INT8_C( 127),  INT8_C(  14),
                            INT8_C(  22),  INT8_C(-109),  INT8_C( -52),  INT8_C(  -3),
                            INT8_C( -78),  INT8_C(  91),  INT8_C(   8),  INT8_C(  23),
                            INT8_C( 110),  INT8_C( -91),  INT8_C(  34),  INT8_C(  17)),
      simde_mm256_set_epi8(~INT8_C(   0),  INT8_C(   0), ~INT8_C(   0), ~INT8_C(   0),
                           ~INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),
                            INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),
                           ~INT8_C(   0),  INT8_C(   0), ~INT8_C(   0), ~INT8_C(   0),
                            INT8_C(   0), ~INT8_C(   0),  INT8_C(   0), ~INT8_C(   0),
                           ~INT8_C(   0), ~INT8_C(   0),  INT8_C(   0),  INT8_C(   0),
                            INT8_C(   0),  INT8_C(   0),  INT8_C(   0),  INT8_C(   0),
                            INT8_C(   0),  INT8_C(   0), ~INT8_C(   0),  INT8_C(   0)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_cmpeq_epi8(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_cmpeq_epi16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi16( INT16_C( -5413),  INT16_C( -8669),  INT16_C(-20019),  INT16_C( 13281),
                             INT16_C( 31513),  INT16_C( 29495),  INT16_C( 24515),  INT16_C( -4843),
                             INT16_C(-25942),  INT16_C(-22058),  INT16_C( 25862),  INT16_C( 17599),
                             INT16_C(  3410),  INT16_C(-25277),  INT16_C( -9899),  INT16_C( -1157)),
      simde_mm256_set_epi16( INT16_C(-24951),  INT16_C( -8669),  INT16_C(-20019),  INT16_C(-25059),
                             INT16_C(-16550),  INT16_C( 29495),  INT16_C( 14158),  INT16_C( 15756),
                             INT16_C(-12717),  INT16_C( 16217),  INT16_C( 23007),  INT16_C(-29661),
                             INT16_C( -4389),  INT16_C( -6794),  INT16_C( 24406),  INT16_C(  3979)),
      simde_mm256_set_epi16( INT16_C(     0),  ~INT16_C(    0),  ~INT16_C(    0),  INT16_C(     0),
                             INT16_C(     0),  ~INT16_C(    0),  INT16_C(     0),  INT16_C(     0),
                             INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),
                             INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0)) },
    { simde_mm256_set_epi16( INT16_C(-24592),  INT16_C(-14625),  INT16_C(-22785),  INT16_C(  -539),
                             INT16_C( 27023),  INT16_C( 22410),  INT16_C( 24512),  INT16_C( 28286),
                             INT16_C(  -371),  INT16_C(-19534),  INT16_C( 20760),  INT16_C( -2933),
                             INT16_C( 19420),  INT16_C( 28265),  INT16_C(  -411),  INT16_C(-25192)),
      simde_mm256_set_epi16( INT16_C(-13031),  INT16_C(-29481),  INT16_C(-21398),  INT16_C(  5762),
                             INT16_C(-11151),  INT16_C( 22410),  INT16_C(-17819),  INT16_C(-18343),
                             INT16_C(  -371),  INT16_C(-18178),  INT16_C( 32217),  INT16_C(-13082),
                             INT16_C( 19420),  INT16_C(-14308),  INT16_C(  -411),  INT16_C(-25192)),
      simde_mm256_set_epi16( INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),
                             INT16_C(     0),  ~INT16_C(    0),  INT16_C(     0),  INT16_C(     0),
                             ~INT16_C(    0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),
                             ~INT16_C(    0),  INT16_C(     0),  ~INT16_C(    0),  ~INT16_C(    0)) },
    { simde_mm256_set_epi16( INT16_C( -1787),  INT16_C( 14472),  INT16_C(  9645),  INT16_C(  6467),
                             INT16_C(-28251),  INT16_C( -4608),  INT16_C(-20138),  INT16_C(-12375),
                             INT16_C( -3139),  INT16_C(-11799),  INT16_C(-25694),  INT16_C( -9505),
                             INT16_C(  2016),  INT16_C(-12994),  INT16_C( 12032),  INT16_C( -1625)),
      simde_mm256_set_epi16( INT16_C( 14082),  INT16_C( 14472),  INT16_C(  9645),  INT16_C(-10341),
                             INT16_C(-21377),  INT16_C(-28844),  INT16_C(-27109),  INT16_C(-21859),
                             INT16_C( -3139),  INT16_C(-20139),  INT16_C(-25694),  INT16_C( 28917),
                             INT16_C(  5339),  INT16_C( 19240),  INT16_C( 12032),  INT16_C(  2212)),
      simde_mm256_set_epi16( INT16_C(     0),  ~INT16_C(    0),  ~INT16_C(    0),  INT16_C(     0),
                             INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),
                             ~INT16_C(    0),  INT16_C(     0),  ~INT16_C(    0),  INT16_C(     0),
                             INT16_C(     0),  INT16_C(     0),  ~INT16_C(    0),  INT16_C(     0)) },
    { simde_mm256_set_epi16( INT16_C( 29890),  INT16_C( 31032),  INT16_C(-29157),  INT16_C(-14947),
                             INT16_C(-10307),  INT16_C(-20105),  INT16_C( -2072),  INT16_C( 29196),
                             INT16_C(  1484),  INT16_C(-11865),  INT16_C(-30233),  INT16_C( 30603),
                             INT16_C( 20632),  INT16_C(-27772),  INT16_C(-32273),  INT16_C(  4867)),
      simde_mm256_set_epi16( INT16_C(-21410),  INT16_C(  9749),  INT16_C(-29157),  INT16_C(-14947),
                             INT16_C( 13547),  INT16_C( 28436),  INT16_C( -2072),  INT16_C( 29196),
                             INT16_C(  1484),  INT16_C(-14930),  INT16_C(  6002),  INT16_C( 30603),
                             INT16_C( 27473),  INT16_C(  2844),  INT16_C(-19044),  INT16_C(  4867)),
      simde_mm256_set_epi16( INT16_C(     0),  INT16_C(     0),  ~INT16_C(    0),  ~INT16_C(    0),
                             INT16_C(     0),  INT16_C(     0),  ~INT16_C(    0),  ~INT16_C(    0),
                             ~INT16_C(    0),  INT16_C(     0),  INT16_C(     0),  ~INT16_C(    0),
                             INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  ~INT16_C(    0)) },
    { simde_mm256_set_epi16( INT16_C( -2810),  INT16_C(-12778),  INT16_C( 16624),  INT16_C(  2706),
                             INT16_C( 14585),  INT16_C( -6866),  INT16_C(  -582),  INT16_C( 29880),
                             INT16_C( 20309),  INT16_C( 25315),  INT16_C( -5634),  INT16_C(-21292),
                             INT16_C( 11215),  INT16_C( 13817),  INT16_C( 26751),  INT16_C( -8288)),
      simde_mm256_set_epi16( INT16_C(-11737),  INT16_C(-19770),  INT16_C(  8400),  INT16_C(  2706),
                             INT16_C( 14599),  INT16_C( -6866),  INT16_C(  -582),  INT16_C( 29880),
                             INT16_C( 20309),  INT16_C( 32436),  INT16_C( -5634),  INT16_C(-21292),
                             INT16_C(-11784),  INT16_C( 13817),  INT16_C( 26751),  INT16_C(-12877)),
      simde_mm256_set_epi16( INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  ~INT16_C(    0),
                             INT16_C(     0),  ~INT16_C(    0),  ~INT16_C(    0),  ~INT16_C(    0),
                             ~INT16_C(    0),  INT16_C(     0),  ~INT16_C(    0),  ~INT16_C(    0),
                             INT16_C(     0),  ~INT16_C(    0),  ~INT16_C(    0),  INT16_C(     0)) },
    { simde_mm256_set_epi16( INT16_C( 11738),  INT16_C(-30358),  INT16_C(-23042),  INT16_C( -2979),
                             INT16_C( 32390),  INT16_C( 22571),  INT16_C( -5410),  INT16_C( 14750),
                             INT16_C(-16092),  INT16_C( 27869),  INT16_C( 28085),  INT16_C( 15025),
                             INT16_C(-11732),  INT16_C( 28458),  INT16_C( -3526),  INT16_C(-21900)),
      simde_mm256_set_epi16( INT16_C( 11738),  INT16_C(-30358),  INT16_C(-12411),  INT16_C( -2979),
                             INT16_C(-27990),  INT16_C( 25385),  INT16_C( -5410),  INT16_C( 13011),
                             INT16_C(-30216),  INT16_C(-15754),  INT16_C( 28085),  INT16_C(   142),
                             INT16_C(-11865),  INT16_C( 28458),  INT16_C(  2605),  INT16_C( 31867)),
      simde_mm256_set_epi16( ~INT16_C(    0),  ~INT16_C(    0),  INT16_C(     0),  ~INT16_C(    0),
                             INT16_C(     0),  INT16_C(     0),  ~INT16_C(    0),  INT16_C(     0),
                             INT16_C(     0),  INT16_C(     0),  ~INT16_C(    0),  INT16_C(     0),
                             INT16_C(     0),  ~INT16_C(    0),  INT16_C(     0),  INT16_C(     0)) },
    { simde_mm256_set_epi16( INT16_C(-15649),  INT16_C( 19434),  INT16_C( 30307),  INT16_C( -2580),
                             INT16_C(-17669),  INT16_C(-12636),  INT16_C(-26128),  INT16_C(  1047),
                             INT16_C( 31189),  INT16_C( -4800),  INT16_C(-21775),  INT16_C(  9584),
                             INT16_C(-10037),  INT16_C(-12969),  INT16_C( -2203),  INT16_C(  7107)),
      simde_mm256_set_epi16( INT16_C(-14042),  INT16_C( 19434),  INT16_C( 12761),  INT16_C( -2580),
                             INT16_C(-14129),  INT16_C(-21327),  INT16_C(  8254),  INT16_C( 17988),
                             INT16_C( 31189),  INT16_C(-12604),  INT16_C(-31847),  INT16_C(  9584),
                             INT16_C(  2606),  INT16_C(-15409),  INT16_C( -2203),  INT16_C(  7107)),
      simde_mm256_set_epi16( INT16_C(     0),  ~INT16_C(    0),  INT16_C(     0),  ~INT16_C(    0),
                             INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),
                             ~INT16_C(    0),  INT16_C(     0),  INT16_C(     0),  ~INT16_C(    0),
                             INT16_C(     0),  INT16_C(     0),  ~INT16_C(    0),  ~INT16_C(    0)) },
    { simde_mm256_set_epi16( INT16_C(  2093),  INT16_C( 26175),  INT16_C(  5850),  INT16_C(-17892),
                             INT16_C(-28618),  INT16_C(-20409),  INT16_C(   201),  INT16_C(-27373),
                             INT16_C(-25181),  INT16_C( -3904),  INT16_C( 26317),  INT16_C( 18884),
                             INT16_C( 15503),  INT16_C( 21511),  INT16_C(-24060),  INT16_C( -1242)),
      simde_mm256_set_epi16( INT16_C(-27449),  INT16_C( 26175),  INT16_C( 26521),  INT16_C(-16887),
                             INT16_C(-13967),  INT16_C(-16902),  INT16_C(-25148),  INT16_C( 11331),
                             INT16_C(-22706),  INT16_C( -3904),  INT16_C( -3346),  INT16_C( 18884),
                             INT16_C(  2207),  INT16_C( 11164),  INT16_C( 22502),  INT16_C(-11226)),
      simde_mm256_set_epi16( INT16_C(     0),  ~INT16_C(    0),  INT16_C(     0),  INT16_C(     0),
                             INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0),
                             INT16_C(     0),  ~INT16_C(    0),  INT16_C(     0),  ~INT16_C(    0),
                             INT16_C(     0),  INT16_C(     0),  INT16_C(     0),  INT16_C(     0)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_cmpeq_epi16(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_cmpeq_epi32(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi32( INT32_C( -566104414),  INT32_C(  345460710),  INT32_C(  131867003),  INT32_C( 1942789694),
                             INT32_C( 1084566886),  INT32_C(  361879538),  INT32_C( 1536563030),  INT32_C(-1809647830)),
      simde_mm256_set_epi32( INT32_C( 1749780765),  INT32_C( -245413822),  INT32_C(  131867003),  INT32_C( -777848334),
                             INT32_C(  525276311),  INT32_C(  361879538),  INT32_C(  378618724),  INT32_C(-1809647830)),
      simde_mm256_set_epi32( INT32_C(          0),  INT32_C(          0),  ~INT32_C(         0),  INT32_C(          0),
                             INT32_C(          0),  ~INT32_C(         0),  INT32_C(          0),  ~INT32_C(         0)) },
    { simde_mm256_set_epi32( INT32_C( 1746696722),  INT32_C(  940817566),  INT32_C( -345075038),  INT32_C( 1008650721),
                             INT32_C( 1982631981),  INT32_C( 1481863730),  INT32_C( 1367059109),  INT32_C( -627319339)),
      simde_mm256_set_epi32( INT32_C( 1746696722),  INT32_C(  940817566),  INT32_C(-2066241582),  INT32_C( 1008650721),
                             INT32_C(  174011254),  INT32_C(-1995628897),  INT32_C( -710324691),  INT32_C( -119123371)),
      simde_mm256_set_epi32( ~INT32_C(         0),  ~INT32_C(         0),  INT32_C(          0),  ~INT32_C(         0),
                             INT32_C(          0),  INT32_C(          0),  INT32_C(          0),  INT32_C(          0)) },
    { simde_mm256_set_epi32( INT32_C( 1029753432),  INT32_C(-1928436508),  INT32_C( 1320243314),  INT32_C(  498796161),
                             INT32_C( 1948463592),  INT32_C(   75866601),  INT32_C(  742698231),  INT32_C(-1435158663)),
      simde_mm256_set_epi32( INT32_C( 1029753432),  INT32_C(-1928436508),  INT32_C(-1164282726),  INT32_C(  267783533),
                             INT32_C( -156415231),  INT32_C(-1409290651),  INT32_C(  -98856138),  INT32_C( 2067678979)),
      simde_mm256_set_epi32( ~INT32_C(         0),  ~INT32_C(         0),  INT32_C(          0),  INT32_C(          0),
                             INT32_C(          0),  INT32_C(          0),  INT32_C(          0),  INT32_C(          0)) },
    { simde_mm256_set_epi32( INT32_C( -346859314),  INT32_C( 1692797387),  INT32_C(   66311928),  INT32_C(  460824773),
                             INT32_C( -548661058),  INT32_C( -254589283),  INT32_C(  833835845),  INT32_C(-1932331579)),
      simde_mm256_set_epi32( INT32_C( -346859314),  INT32_C(   60539810),  INT32_C( 1011930823),  INT32_C(  460824773),
                             INT32_C(  190841895),  INT32_C( -254589283),  INT32_C(  316499678),  INT32_C(-1932331579)),
      simde_mm256_set_epi32( ~INT32_C(         0),  INT32_C(          0),  INT32_C(          0),  ~INT32_C(         0),
                             INT32_C(          0),  ~INT32_C(         0),  INT32_C(          0),  ~INT32_C(         0)) },
    { simde_mm256_set_epi32( INT32_C( -959873297),  INT32_C(-1563175385),  INT32_C(-1346900809),  INT32_C( 1327082188),
                             INT32_C( 1782214973),  INT32_C(-1174575718),  INT32_C( -220704084),  INT32_C(  825113567)),
      simde_mm256_set_epi32( INT32_C( -959873297),  INT32_C(  735229659),  INT32_C( -660381298),  INT32_C(-1091295976),
                             INT32_C( 1782214973),  INT32_C(-1174575718),  INT32_C( 2094872318),  INT32_C( 1028851204)),
      simde_mm256_set_epi32( ~INT32_C(         0),  INT32_C(          0),  INT32_C(          0),  INT32_C(          0),
                             ~INT32_C(         0),  ~INT32_C(         0),  INT32_C(          0),  INT32_C(          0)) },
    { simde_mm256_set_epi32( INT32_C( 1661232006),  INT32_C( 1627888390),  INT32_C(  757018179),  INT32_C( -750573130),
                             INT32_C(-1367421353),  INT32_C(  198410180),  INT32_C(-1240440841),  INT32_C(-1417499113)),
      simde_mm256_set_epi32( INT32_C( -466269763),  INT32_C(   49857616),  INT32_C(  757018179),  INT32_C( -750573130),
                             INT32_C(-1367421353),  INT32_C(-1831110733),  INT32_C(-1233216938),  INT32_C(   84780453)),
      simde_mm256_set_epi32( INT32_C(          0),  INT32_C(          0),  ~INT32_C(         0),  ~INT32_C(         0),
                             ~INT32_C(         0),  INT32_C(          0),  INT32_C(          0),  INT32_C(          0)) },
    { simde_mm256_set_epi32( INT32_C( -149159680),  INT32_C(  968409930),  INT32_C(-1757785028),  INT32_C(  354816025),
                             INT32_C(   46210141),  INT32_C( -726479125),  INT32_C(  790520082),  INT32_C( -599212420)),
      simde_mm256_set_epi32( INT32_C( -149159680),  INT32_C( 1775235902),  INT32_C(-1757785028),  INT32_C( -783938470),
                             INT32_C(   46210141),  INT32_C( -726479125),  INT32_C( -272289003),  INT32_C( -599212420)),
      simde_mm256_set_epi32( ~INT32_C(         0),  INT32_C(          0),  ~INT32_C(         0),  INT32_C(          0),
                             ~INT32_C(         0),  ~INT32_C(         0),  INT32_C(          0),  ~INT32_C(         0)) },
    { simde_mm256_set_epi32( INT32_C(  431380596),  INT32_C( -800905622),  INT32_C(-1090716510),  INT32_C(  598832812),
                             INT32_C(  183783146),  INT32_C( 1473748330),  INT32_C( 1405235121),  INT32_C( 1193787762)),
      simde_mm256_set_epi32( INT32_C( 1093676520),  INT32_C( -410887875),  INT32_C( 1548812312),  INT32_C( -913535121),
                             INT32_C(  183783146),  INT32_C(-1507745238),  INT32_C( 1405235121),  INT32_C( 1193787762)),
      simde_mm256_set_epi32( INT32_C(          0),  INT32_C(          0),  INT32_C(          0),  INT32_C(          0),
                             ~INT32_C(         0),  INT32_C(          0),  ~INT32_C(         0),  ~INT32_C(         0)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_cmpeq_epi32(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_cmpeq_epi64(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi64x( INT64_C( 5666986029204224795),  INT64_C( 4139191150084672711),
                              INT64_C(-2995542033801296871),  INT64_C( 2916699395471658679)),
      simde_mm256_set_epi64x( INT64_C( 5666986029204224795),  INT64_C(-4286656252876457389),
                              INT64_C( 1630571993074201933),  INT64_C(-4091102519963379575)),
      simde_mm256_set_epi64x( INT64_C(                  -1),  INT64_C(                   0),
                              INT64_C(                   0),  INT64_C(                   0)) },
    { simde_mm256_set_epi64x( INT64_C( 3487161978562406497),  INT64_C( 3319820858778075593),
                              INT64_C(-2061262812497087366),  INT64_C( 3422398331177828808)),
      simde_mm256_set_epi64x( INT64_C( 3487161978562406497),  INT64_C( 3319820858778075593),
                              INT64_C( 4615290220825808616),  INT64_C(-1811913409974062507)),
      simde_mm256_set_epi64x( INT64_C(                  -1),  INT64_C(                  -1),
                              INT64_C(                   0),  INT64_C(                   0)) },
    { simde_mm256_set_epi64x( INT64_C( 6876132350949566240),  INT64_C(  286650737897020179),
                              INT64_C( 8647803947797074216),  INT64_C( 8045239586356137615)),
      simde_mm256_set_epi64x( INT64_C(-2007896190058863769),  INT64_C( 1398080065885028992),
                              INT64_C( 8575195519759543000),  INT64_C( 3842062270653749921)),
      simde_mm256_set_epi64x( INT64_C(                   0),  INT64_C(                   0),
                              INT64_C(                   0),  INT64_C(                   0)) },
    { simde_mm256_set_epi64x( INT64_C( -813114899828683326),  INT64_C( 8993356532590363052),
                              INT64_C( 1099980308418045920),  INT64_C( -959713571456510913)),
      simde_mm256_set_epi64x( INT64_C( -813114899828683326),  INT64_C( 8993356532590363052),
                              INT64_C( 2705033811286181232),  INT64_C(-9000650858577263758)),
      simde_mm256_set_epi64x( INT64_C(                  -1),  INT64_C(                  -1),
                              INT64_C(                   0),  INT64_C(                   0)) },
    { simde_mm256_set_epi64x( INT64_C(-2995469803746067901),  INT64_C( 8439110829491825822),
                              INT64_C(  622618816590200788),  INT64_C(-4486881289174213355)),
      simde_mm256_set_epi64x( INT64_C(-2995469803746067901),  INT64_C(-3762957269640528607),
                              INT64_C(  622618816590200788),  INT64_C(-3609138253339109026)),
      simde_mm256_set_epi64x( ~INT64_C(                  0),  INT64_C(                   0),
                              ~INT64_C(                  0),  INT64_C(                   0)) },
    { simde_mm256_set_epi64x( INT64_C(-1016066772373646945),  INT64_C( 3813602464259710788),
                              INT64_C( 7563424360708952600),  INT64_C(-5726115040178877821)),
      simde_mm256_set_epi64x( INT64_C(-1016066772373646945),  INT64_C( 3813602464259710788),
                              INT64_C(-7344230325683392237),  INT64_C(-5726115040178877821)),
      simde_mm256_set_epi64x( ~INT64_C(                  0),  ~INT64_C(                  0),
                              INT64_C(                   0),  ~INT64_C(                  0)) },
    { simde_mm256_set_epi64x( INT64_C(-5638985149235693304),  INT64_C( 3850441284517009347),
                              INT64_C(-7932931861129304736),  INT64_C(-7323455422359325640)),
      simde_mm256_set_epi64x( INT64_C(-6947747787688303029),  INT64_C( 7867789037175719368),
                              INT64_C(-7932931861129304736),  INT64_C(  356641616463870387)),
      simde_mm256_set_epi64x( INT64_C(                   0),  INT64_C(                   0),
                              ~INT64_C(                  0),  INT64_C(                   0)) },
    { simde_mm256_set_epi64x( INT64_C(-3620459218438416224),  INT64_C(-7960741818410807131),
                              INT64_C( 2210317486113607969),  INT64_C( 2056660070405601362)),
      simde_mm256_set_epi64x( INT64_C(  186345282622433582),  INT64_C(-7960741818410807131),
                              INT64_C( 2210317486113607969),  INT64_C( 8434183884659739058)),
      simde_mm256_set_epi64x( INT64_C(                   0),  ~INT64_C(                  0),
                              ~INT64_C(                  0),  INT64_C(                   0)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_cmpeq_epi64(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i64(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_cmpgt_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
   { simde_mm256_set_epi8(INT8_C(  97), INT8_C(  38), INT8_C(  50), INT8_C( -69),
                           INT8_C(-120), INT8_C( 113), INT8_C( -33), INT8_C( -11),
                           INT8_C(  68), INT8_C(  95), INT8_C(  30), INT8_C(  12),
                           INT8_C( -73), INT8_C( -78), INT8_C( -31), INT8_C(  -6),
                           INT8_C( -85), INT8_C(   8), INT8_C( -57), INT8_C(  86),
                           INT8_C(-111), INT8_C(  96), INT8_C(  27), INT8_C( -37),
                           INT8_C(  36), INT8_C(-109), INT8_C( -29), INT8_C(  11),
                           INT8_C( 121), INT8_C(  68), INT8_C(  -8), INT8_C(-117)),
      simde_mm256_set_epi8(INT8_C( -11), INT8_C( -47), INT8_C(  44), INT8_C(  92),
                           INT8_C(-103), INT8_C( 119), INT8_C(  74), INT8_C( -33),
                           INT8_C(  46), INT8_C( -92), INT8_C( -68), INT8_C(  34),
                           INT8_C(  87), INT8_C( -27), INT8_C( -38), INT8_C(   8),
                           INT8_C( -43), INT8_C(  93), INT8_C(   8), INT8_C(-116),
                           INT8_C(-110), INT8_C(  42), INT8_C( -23), INT8_C(  50),
                           INT8_C(  67), INT8_C( -92), INT8_C( -32), INT8_C(  41),
                           INT8_C( -11), INT8_C( 105), INT8_C( -20), INT8_C(  57)),
      simde_mm256_set_epi8(INT8_C(  -1), INT8_C(  -1), INT8_C(  -1), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  -1),
                           INT8_C(  -1), INT8_C(  -1), INT8_C(  -1), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  -1), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  -1),
                           INT8_C(   0), INT8_C(  -1), INT8_C(  -1), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  -1), INT8_C(   0),
                           INT8_C(  -1), INT8_C(   0), INT8_C(  -1), INT8_C(   0)) },
    { simde_mm256_set_epi8(INT8_C( -79), INT8_C( 114), INT8_C(  20), INT8_C(   6),
                           INT8_C( -80), INT8_C(  63), INT8_C( 115), INT8_C( -39),
                           INT8_C( 103), INT8_C(-111), INT8_C(  -9), INT8_C(  41),
                           INT8_C(-111), INT8_C(  96), INT8_C(-117), INT8_C(  -5),
                           INT8_C( -32), INT8_C( 112), INT8_C(  94), INT8_C( -30),
                           INT8_C(   1), INT8_C(  15), INT8_C(  71), INT8_C( 106),
                           INT8_C(  89), INT8_C(  14), INT8_C( -92), INT8_C(  -5),
                           INT8_C(  34), INT8_C(  41), INT8_C(   6), INT8_C(  46)),
      simde_mm256_set_epi8(INT8_C(  69), INT8_C(  68), INT8_C( -50), INT8_C( -53),
                           INT8_C(  53), INT8_C(-115), INT8_C(  -3), INT8_C( -63),
                           INT8_C(  44), INT8_C( -26), INT8_C( -60), INT8_C(  77),
                           INT8_C( -39), INT8_C(  69), INT8_C(  -4), INT8_C(  67),
                           INT8_C(   2), INT8_C( 127), INT8_C(-108), INT8_C( -32),
                           INT8_C( -90), INT8_C( -18), INT8_C(  30), INT8_C( 126),
                           INT8_C(  71), INT8_C(  87), INT8_C(  81), INT8_C(   8),
                           INT8_C(  97), INT8_C(  48), INT8_C( 122), INT8_C(  19)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(  -1), INT8_C(  -1), INT8_C(  -1),
                           INT8_C(   0), INT8_C(  -1), INT8_C(  -1), INT8_C(  -1),
                           INT8_C(  -1), INT8_C(   0), INT8_C(  -1), INT8_C(   0),
                           INT8_C(   0), INT8_C(  -1), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  -1), INT8_C(  -1),
                           INT8_C(  -1), INT8_C(  -1), INT8_C(  -1), INT8_C(   0),
                           INT8_C(  -1), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  -1)) },
    { simde_mm256_set_epi8(INT8_C(   4), INT8_C( -93), INT8_C(  78), INT8_C( -99),
                           INT8_C( -33), INT8_C(  93), INT8_C(-119), INT8_C( -26),
                           INT8_C(-115), INT8_C( -63), INT8_C( -15), INT8_C( -15),
                           INT8_C(  51), INT8_C(  56), INT8_C(-113), INT8_C( -56),
                           INT8_C(  88), INT8_C(  97), INT8_C( 124), INT8_C( 124),
                           INT8_C( -61), INT8_C( 109), INT8_C(  81), INT8_C(  37),
                           INT8_C(  67), INT8_C( -23), INT8_C(  20), INT8_C( 101),
                           INT8_C(-111), INT8_C(  20), INT8_C( -17), INT8_C(  88)),
      simde_mm256_set_epi8(INT8_C( -45), INT8_C( -79), INT8_C(  95), INT8_C(  42),
                           INT8_C(  -8), INT8_C(  12), INT8_C(  84), INT8_C( -28),
                           INT8_C(  -9), INT8_C(  73), INT8_C( 108), INT8_C(  19),
                           INT8_C(  -1), INT8_C( -28), INT8_C(  40), INT8_C( -89),
                           INT8_C(  87), INT8_C(-118), INT8_C(  52), INT8_C( -73),
                           INT8_C(  83), INT8_C( -87), INT8_C( -94), INT8_C( -66),
                           INT8_C(  22), INT8_C( -68), INT8_C(-100), INT8_C( -90),
                           INT8_C(  59), INT8_C(-103), INT8_C( -68), INT8_C(  90)),
      simde_mm256_set_epi8(INT8_C(  -1), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  -1), INT8_C(   0), INT8_C(  -1),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  -1), INT8_C(  -1), INT8_C(   0), INT8_C(  -1),
                           INT8_C(  -1), INT8_C(  -1), INT8_C(  -1), INT8_C(  -1),
                           INT8_C(   0), INT8_C(  -1), INT8_C(  -1), INT8_C(  -1),
                           INT8_C(  -1), INT8_C(  -1), INT8_C(  -1), INT8_C(  -1),
                           INT8_C(   0), INT8_C(  -1), INT8_C(  -1), INT8_C(   0)) },
    { simde_mm256_set_epi8(INT8_C(  78), INT8_C( -98), INT8_C(-121), INT8_C(  92),
                           INT8_C(  -8), INT8_C(  96), INT8_C(-118), INT8_C( -55),
                           INT8_C( -74), INT8_C( 105), INT8_C( -18), INT8_C(  33),
                           INT8_C(  85), INT8_C( -52), INT8_C(  68), INT8_C(   9),
                           INT8_C( -37), INT8_C(  70), INT8_C(  98), INT8_C( -80),
                           INT8_C( -54), INT8_C(-128), INT8_C( -94), INT8_C(-119),
                           INT8_C(-113), INT8_C(-115), INT8_C(  71), INT8_C( -46),
                           INT8_C(  19), INT8_C( 125), INT8_C(  40), INT8_C(   3)),
      simde_mm256_set_epi8(INT8_C( -28), INT8_C(-110), INT8_C(-103), INT8_C(   3),
                           INT8_C(-127), INT8_C(  24), INT8_C( 119), INT8_C(  81),
                           INT8_C(  -7), INT8_C( -15), INT8_C( 106), INT8_C(   4),
                           INT8_C( -43), INT8_C(  98), INT8_C( -93), INT8_C(  36),
                           INT8_C(  -1), INT8_C(  44), INT8_C(  82), INT8_C(  14),
                           INT8_C(   0), INT8_C( 125), INT8_C(  43), INT8_C( -25),
                           INT8_C(  68), INT8_C(  74), INT8_C(   8), INT8_C(  53),
                           INT8_C(  -2), INT8_C(  27), INT8_C( -33), INT8_C(  -9)),
      simde_mm256_set_epi8(INT8_C(  -1), INT8_C(  -1), INT8_C(   0), INT8_C(  -1),
                           INT8_C(  -1), INT8_C(  -1), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  -1), INT8_C(   0), INT8_C(  -1),
                           INT8_C(  -1), INT8_C(   0), INT8_C(  -1), INT8_C(   0),
                           INT8_C(   0), INT8_C(  -1), INT8_C(  -1), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  -1), INT8_C(   0),
                           INT8_C(  -1), INT8_C(  -1), INT8_C(  -1), INT8_C(  -1)) },
    { simde_mm256_set_epi8(INT8_C(  95), INT8_C( -80), INT8_C( -95), INT8_C(  93),
                           INT8_C(   6), INT8_C(-125), INT8_C( -26), INT8_C( 102),
                           INT8_C(  60), INT8_C( -54), INT8_C( 123), INT8_C( -73),
                           INT8_C( -99), INT8_C(  28), INT8_C(  26), INT8_C(-127),
                           INT8_C(  12), INT8_C( -51), INT8_C(  90), INT8_C( -32),
                           INT8_C( -10), INT8_C(  41), INT8_C( -30), INT8_C( 107),
                           INT8_C(  23), INT8_C( 114), INT8_C( 116), INT8_C( -31),
                           INT8_C( -33), INT8_C( -82), INT8_C(  21), INT8_C(  83)),
      simde_mm256_set_epi8(INT8_C(  49), INT8_C( -50), INT8_C( -70), INT8_C( -68),
                           INT8_C(  71), INT8_C( -80), INT8_C( -71), INT8_C(  39),
                           INT8_C(  88), INT8_C(-120), INT8_C(  70), INT8_C(-124),
                           INT8_C(  40), INT8_C(-103), INT8_C(  95), INT8_C(-100),
                           INT8_C(  -5), INT8_C(  64), INT8_C( -11), INT8_C(  -4),
                           INT8_C( -28), INT8_C( -66), INT8_C(  41), INT8_C(  31),
                           INT8_C(  82), INT8_C(  26), INT8_C( -64), INT8_C(  57),
                           INT8_C(  27), INT8_C(  15), INT8_C(  57), INT8_C(-125)),
      simde_mm256_set_epi8(INT8_C(  -1), INT8_C(   0), INT8_C(   0), INT8_C(  -1),
                           INT8_C(   0), INT8_C(   0), INT8_C(  -1), INT8_C(  -1),
                           INT8_C(   0), INT8_C(  -1), INT8_C(  -1), INT8_C(  -1),
                           INT8_C(   0), INT8_C(  -1), INT8_C(   0), INT8_C(   0),
                           INT8_C(  -1), INT8_C(   0), INT8_C(  -1), INT8_C(   0),
                           INT8_C(  -1), INT8_C(  -1), INT8_C(   0), INT8_C(  -1),
                           INT8_C(   0), INT8_C(  -1), INT8_C(  -1), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  -1)) },
    { simde_mm256_set_epi8(INT8_C(  57), INT8_C(-121), INT8_C(  -6), INT8_C( -74),
                           INT8_C(  22), INT8_C( -63), INT8_C(  17), INT8_C( 101),
                           INT8_C(  43), INT8_C( -53), INT8_C(-112), INT8_C( -25),
                           INT8_C(  85), INT8_C(  55), INT8_C(  77), INT8_C( -58),
                           INT8_C(  73), INT8_C(  35), INT8_C( -70), INT8_C(  30),
                           INT8_C( -78), INT8_C(   4), INT8_C( -97), INT8_C(   5),
                           INT8_C( -36), INT8_C(  28), INT8_C(  95), INT8_C(  75),
                           INT8_C( -88), INT8_C(  11), INT8_C(  45), INT8_C( -19)),
      simde_mm256_set_epi8(INT8_C(  85), INT8_C( 121), INT8_C(   8), INT8_C( 127),
                           INT8_C(-122), INT8_C( -88), INT8_C( 107), INT8_C(  76),
                           INT8_C(-128), INT8_C(-125), INT8_C(  90), INT8_C(  68),
                           INT8_C( -36), INT8_C(  75), INT8_C( -58), INT8_C(  50),
                           INT8_C(  69), INT8_C(-119), INT8_C(-102), INT8_C( -69),
                           INT8_C(  16), INT8_C(  98), INT8_C(  34), INT8_C(-127),
                           INT8_C(  10), INT8_C(  69), INT8_C( 121), INT8_C(-126),
                           INT8_C(  88), INT8_C( -14), INT8_C(-110), INT8_C( -45)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  -1), INT8_C(  -1), INT8_C(   0), INT8_C(  -1),
                           INT8_C(  -1), INT8_C(  -1), INT8_C(   0), INT8_C(   0),
                           INT8_C(  -1), INT8_C(   0), INT8_C(  -1), INT8_C(   0),
                           INT8_C(  -1), INT8_C(  -1), INT8_C(  -1), INT8_C(  -1),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  -1),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  -1),
                           INT8_C(   0), INT8_C(  -1), INT8_C(  -1), INT8_C(  -1)) },
    { simde_mm256_set_epi8(INT8_C( -41), INT8_C( -49), INT8_C(  85), INT8_C( 123),
                           INT8_C( -68), INT8_C( -82), INT8_C( -28), INT8_C( -31),
                           INT8_C(  16), INT8_C(  27), INT8_C(   9), INT8_C(-102),
                           INT8_C(  78), INT8_C(  37), INT8_C( -66), INT8_C(  41),
                           INT8_C( -11), INT8_C(-117), INT8_C(  83), INT8_C(  41),
                           INT8_C(-105), INT8_C(  71), INT8_C( -12), INT8_C( 118),
                           INT8_C( -49), INT8_C( -73), INT8_C( -68), INT8_C( -18),
                           INT8_C( 118), INT8_C( 110), INT8_C(  85), INT8_C(  87)),
      simde_mm256_set_epi8(INT8_C( 117), INT8_C( -99), INT8_C( 113), INT8_C(  26),
                           INT8_C( -41), INT8_C(  64), INT8_C(  93), INT8_C(  98),
                           INT8_C( 100), INT8_C(  92), INT8_C( -14), INT8_C(  86),
                           INT8_C(  83), INT8_C(  11), INT8_C( -24), INT8_C(  12),
                           INT8_C(  30), INT8_C(  43), INT8_C( 100), INT8_C(  94),
                           INT8_C(  19), INT8_C(  46), INT8_C( -17), INT8_C(   0),
                           INT8_C(   9), INT8_C( 104), INT8_C(  26), INT8_C(  39),
                           INT8_C( 102), INT8_C( -79), INT8_C( 114), INT8_C(   9)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(  -1), INT8_C(   0), INT8_C(  -1),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(  -1), INT8_C(   0),
                           INT8_C(   0), INT8_C(  -1), INT8_C(   0), INT8_C(  -1),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  -1), INT8_C(  -1), INT8_C(  -1),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(  -1), INT8_C(  -1), INT8_C(   0), INT8_C(  -1)) },
    { simde_mm256_set_epi8(INT8_C( 102), INT8_C(  -3), INT8_C( -18), INT8_C(-123),
                           INT8_C( -72), INT8_C(  10), INT8_C(  86), INT8_C(  30),
                           INT8_C( -77), INT8_C(  95), INT8_C( -77), INT8_C(   0),
                           INT8_C( -69), INT8_C( -21), INT8_C(  52), INT8_C( -84),
                           INT8_C(  45), INT8_C( -12), INT8_C( -37), INT8_C(  90),
                           INT8_C(  28), INT8_C(-104), INT8_C( 106), INT8_C( 118),
                           INT8_C( -89), INT8_C(   3), INT8_C(  10), INT8_C( 107),
                           INT8_C( 119), INT8_C(  18), INT8_C( -95), INT8_C( 109)),
      simde_mm256_set_epi8(INT8_C( -86), INT8_C(  18), INT8_C( -58), INT8_C(   3),
                           INT8_C( -64), INT8_C( -78), INT8_C( -50), INT8_C( 105),
                           INT8_C(  15), INT8_C(-117), INT8_C( -59), INT8_C( 105),
                           INT8_C( -20), INT8_C( -76), INT8_C( -88), INT8_C(-122),
                           INT8_C( -16), INT8_C( -87), INT8_C( 108), INT8_C( -44),
                           INT8_C( -34), INT8_C( -65), INT8_C( 125), INT8_C( -17),
                           INT8_C(-119), INT8_C(  55), INT8_C( -39), INT8_C( -68),
                           INT8_C(-116), INT8_C(  45), INT8_C(-101), INT8_C(  61)),
      simde_mm256_set_epi8(INT8_C(  -1), INT8_C(   0), INT8_C(  -1), INT8_C(   0),
                           INT8_C(   0), INT8_C(  -1), INT8_C(  -1), INT8_C(   0),
                           INT8_C(   0), INT8_C(  -1), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(  -1), INT8_C(  -1), INT8_C(  -1),
                           INT8_C(  -1), INT8_C(  -1), INT8_C(   0), INT8_C(  -1),
                           INT8_C(  -1), INT8_C(   0), INT8_C(   0), INT8_C(  -1),
                           INT8_C(  -1), INT8_C(   0), INT8_C(  -1), INT8_C(  -1),
                           INT8_C(  -1), INT8_C(   0), INT8_C(  -1), INT8_C(  -1)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_cmpgt_epi8(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_cmpgt_epi16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi16(INT16_C( 22495), INT16_C( -4666), INT16_C( 11364), INT16_C(  3408),
                            INT16_C( -7753), INT16_C( 22355), INT16_C( 25225), INT16_C(-16816),
                            INT16_C( 30843), INT16_C( 15445), INT16_C(-14188), INT16_C( 18672),
                            INT16_C(-17933), INT16_C( 19821), INT16_C( -7211), INT16_C( 10864)),
      simde_mm256_set_epi16(INT16_C(  -752), INT16_C(-15840), INT16_C(-30268), INT16_C( 11179),
                            INT16_C( 16785), INT16_C(-16319), INT16_C(  8147), INT16_C(-29538),
                            INT16_C( 19069), INT16_C( 27101), INT16_C( 26817), INT16_C(-21010),
                            INT16_C(-18350), INT16_C(  1385), INT16_C(-28379), INT16_C(-19254)),
      simde_mm256_set_epi16(INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(     0),
                            INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1),
                            INT16_C(    -1), INT16_C(     0), INT16_C(     0), INT16_C(    -1),
                            INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1)) },
    { simde_mm256_set_epi16(INT16_C( 22399), INT16_C(   -10), INT16_C( 26109), INT16_C( 19317),
                            INT16_C( 26547), INT16_C( 21309), INT16_C(-21770), INT16_C(-29851),
                            INT16_C(  8254), INT16_C( -6152), INT16_C( 14575), INT16_C(-26009),
                            INT16_C( -9485), INT16_C(  5665), INT16_C( 19505), INT16_C( -7563)),
      simde_mm256_set_epi16(INT16_C( 14612), INT16_C(-31260), INT16_C(-18743), INT16_C( -4117),
                            INT16_C( 18997), INT16_C(-26816), INT16_C( 13752), INT16_C( 24083),
                            INT16_C(-17683), INT16_C(-12944), INT16_C(-20564), INT16_C( -4251),
                            INT16_C( -8899), INT16_C( -5996), INT16_C( 20472), INT16_C( -9514)),
      simde_mm256_set_epi16(INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1),
                            INT16_C(    -1), INT16_C(    -1), INT16_C(     0), INT16_C(     0),
                            INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(     0),
                            INT16_C(     0), INT16_C(    -1), INT16_C(     0), INT16_C(    -1)) },
    { simde_mm256_set_epi16(INT16_C( -1570), INT16_C(-21545), INT16_C(-26360), INT16_C( -8434),
                            INT16_C( -3275), INT16_C(-16762), INT16_C( -5746), INT16_C( 30695),
                            INT16_C(  2714), INT16_C( 10463), INT16_C(  9000), INT16_C(  9451),
                            INT16_C( 23785), INT16_C( 12389), INT16_C(-26622), INT16_C(-15647)),
      simde_mm256_set_epi16(INT16_C(  1010), INT16_C(-25985), INT16_C( 16762), INT16_C(  1632),
                            INT16_C(-18641), INT16_C( 15349), INT16_C(-16838), INT16_C(-20536),
                            INT16_C(-25875), INT16_C( 26970), INT16_C(-23524), INT16_C( 11391),
                            INT16_C(  3100), INT16_C(-31773), INT16_C( 26059), INT16_C( 11041)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(    -1), INT16_C(     0), INT16_C(     0),
                            INT16_C(    -1), INT16_C(     0), INT16_C(    -1), INT16_C(    -1),
                            INT16_C(    -1), INT16_C(     0), INT16_C(    -1), INT16_C(     0),
                            INT16_C(    -1), INT16_C(    -1), INT16_C(     0), INT16_C(     0)) },
    { simde_mm256_set_epi16(INT16_C( 23915), INT16_C(   959), INT16_C(-22514), INT16_C( 13747),
                            INT16_C(-26649), INT16_C( 22646), INT16_C( 13432), INT16_C( 27482),
                            INT16_C( 19401), INT16_C( 30181), INT16_C( 31161), INT16_C(-17967),
                            INT16_C(-19058), INT16_C( 31935), INT16_C( 11181), INT16_C( 23239)),
      simde_mm256_set_epi16(INT16_C(-28186), INT16_C(  2084), INT16_C( 31597), INT16_C(  7566),
                            INT16_C( 21799), INT16_C(-27106), INT16_C(  4736), INT16_C( 18793),
                            INT16_C(-13965), INT16_C(-17482), INT16_C( 12657), INT16_C(-20379),
                            INT16_C( 24896), INT16_C( 28918), INT16_C( 22577), INT16_C( 29712)),
      simde_mm256_set_epi16(INT16_C(    -1), INT16_C(     0), INT16_C(     0), INT16_C(    -1),
                            INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1),
                            INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1),
                            INT16_C(     0), INT16_C(    -1), INT16_C(     0), INT16_C(     0)) },
    { simde_mm256_set_epi16(INT16_C( 11952), INT16_C( 18081), INT16_C(  7197), INT16_C( -9524),
                            INT16_C( 18521), INT16_C(  8735), INT16_C( 31233), INT16_C(-18919),
                            INT16_C(  8906), INT16_C( 21111), INT16_C( 27720), INT16_C(  5158),
                            INT16_C(  2673), INT16_C( 31824), INT16_C(-18067), INT16_C(  -891)),
      simde_mm256_set_epi16(INT16_C(-18602), INT16_C( 15849), INT16_C(-28095), INT16_C( -3999),
                            INT16_C( 13518), INT16_C(-13535), INT16_C(-30865), INT16_C(   675),
                            INT16_C(-26284), INT16_C( -1429), INT16_C(-19333), INT16_C(-26108),
                            INT16_C( 10384), INT16_C(-21020), INT16_C(-15076), INT16_C( 30415)),
      simde_mm256_set_epi16(INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(     0),
                            INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(     0),
                            INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1),
                            INT16_C(     0), INT16_C(    -1), INT16_C(     0), INT16_C(     0)) },
    { simde_mm256_set_epi16(INT16_C(-31253), INT16_C( -5290), INT16_C(-20180), INT16_C(  8300),
                            INT16_C( 29534), INT16_C( 10169), INT16_C( 27568), INT16_C(-21872),
                            INT16_C( 20546), INT16_C(  3171), INT16_C( -5551), INT16_C( 13838),
                            INT16_C( 10100), INT16_C(-27385), INT16_C( 19172), INT16_C(-26206)),
      simde_mm256_set_epi16(INT16_C(-12916), INT16_C( 16100), INT16_C(-14860), INT16_C(  6730),
                            INT16_C(  2608), INT16_C(-17352), INT16_C( 13860), INT16_C(  6700),
                            INT16_C( -7357), INT16_C( -1733), INT16_C(  7387), INT16_C(  5378),
                            INT16_C(-19225), INT16_C( -5805), INT16_C(   154), INT16_C(-20617)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(    -1),
                            INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(     0),
                            INT16_C(    -1), INT16_C(    -1), INT16_C(     0), INT16_C(    -1),
                            INT16_C(    -1), INT16_C(     0), INT16_C(    -1), INT16_C(     0)) },
    { simde_mm256_set_epi16(INT16_C( 13973), INT16_C( 21863), INT16_C( -4187), INT16_C( 31713),
                            INT16_C( -2161), INT16_C(-12788), INT16_C( 13548), INT16_C( 19072),
                            INT16_C(-23365), INT16_C(  2809), INT16_C( 16101), INT16_C( -9274),
                            INT16_C( 12377), INT16_C( 26381), INT16_C( 29677), INT16_C(  4006)),
      simde_mm256_set_epi16(INT16_C( -9250), INT16_C(-11965), INT16_C(-16314), INT16_C( -8035),
                            INT16_C(-12852), INT16_C( -3996), INT16_C(  8694), INT16_C( -8455),
                            INT16_C( 12571), INT16_C(-15529), INT16_C( -8320), INT16_C( 14428),
                            INT16_C( -5397), INT16_C( 17843), INT16_C(  7761), INT16_C( -1266)),
      simde_mm256_set_epi16(INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1),
                            INT16_C(    -1), INT16_C(     0), INT16_C(    -1), INT16_C(    -1),
                            INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(     0),
                            INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1)) },
    { simde_mm256_set_epi16(INT16_C(  7404), INT16_C( 10935), INT16_C(-26115), INT16_C(  8618),
                            INT16_C(-27599), INT16_C( 31224), INT16_C(  4654), INT16_C(-18707),
                            INT16_C( 12785), INT16_C( 22785), INT16_C( 25148), INT16_C(-31622),
                            INT16_C( 17070), INT16_C(-22617), INT16_C(  6953), INT16_C(-14046)),
      simde_mm256_set_epi16(INT16_C(-11447), INT16_C( 18342), INT16_C(   563), INT16_C(-13432),
                            INT16_C( 21117), INT16_C( 29427), INT16_C( 31704), INT16_C( 14377),
                            INT16_C( 14770), INT16_C( -3712), INT16_C(  7229), INT16_C(-22634),
                            INT16_C( 28493), INT16_C(-28170), INT16_C(  5912), INT16_C(  7039)),
      simde_mm256_set_epi16(INT16_C(    -1), INT16_C(     0), INT16_C(     0), INT16_C(    -1),
                            INT16_C(     0), INT16_C(    -1), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(     0),
                            INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(     0)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_cmpgt_epi16(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_cmpgt_epi32(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi32(INT32_C(-1910963751), INT32_C(-1037527336), INT32_C( -581253082), INT32_C( -805157505),
                            INT32_C( 1446966287), INT32_C(   -8913681), INT32_C( -494526366), INT32_C(-1857474161)),
      simde_mm256_set_epi32(INT32_C(-1143050049), INT32_C(-1545949366), INT32_C( 1503277288), INT32_C(-1357138171),
                            INT32_C( 1058844939), INT32_C(  309480335), INT32_C( 1825640960), INT32_C(-2083253752)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(         -1), INT32_C(          0), INT32_C(         -1),
                            INT32_C(         -1), INT32_C(          0), INT32_C(          0), INT32_C(         -1)) },
    { simde_mm256_set_epi32(INT32_C(-1125895018), INT32_C( -151199733), INT32_C(-1156572232), INT32_C(-1719423594),
                            INT32_C(-1350415044), INT32_C( 1941048360), INT32_C( 1462693644), INT32_C(  157276070)),
      simde_mm256_set_epi32(INT32_C( 1685470989), INT32_C(  -23549807), INT32_C( 2101982138), INT32_C(-1846214249),
                            INT32_C(-1855916776), INT32_C( -540831398), INT32_C(  233301808), INT32_C( 1667068415)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(          0), INT32_C(          0), INT32_C(         -1),
                            INT32_C(         -1), INT32_C(         -1), INT32_C(         -1), INT32_C(          0)) },
    { simde_mm256_set_epi32(INT32_C(-2064202369), INT32_C( -937796718), INT32_C( 1860922821), INT32_C( -943515104),
                            INT32_C( 1932702217), INT32_C(-1909235607), INT32_C( -701927701), INT32_C( 2122537608)),
      simde_mm256_set_epi32(INT32_C( 1359427872), INT32_C(  430067405), INT32_C(-2017266204), INT32_C( -112174075),
                            INT32_C(-2036257158), INT32_C(  794990098), INT32_C( 1595368835), INT32_C(-2025748789)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(          0), INT32_C(         -1), INT32_C(          0),
                            INT32_C(         -1), INT32_C(          0), INT32_C(          0), INT32_C(         -1)) },
    { simde_mm256_set_epi32(INT32_C(  101914014), INT32_C( 1252307439), INT32_C( -251229086), INT32_C( 1747655874),
                            INT32_C( 1975156439), INT32_C(  244588822), INT32_C(-2030488384), INT32_C(  -41784348)),
      simde_mm256_set_epi32(INT32_C(  126704158), INT32_C(-1817043660), INT32_C(   67229317), INT32_C( 1709840887),
                            INT32_C( -401701180), INT32_C(-1816869894), INT32_C( -356935412), INT32_C( 1029497038)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(         -1), INT32_C(          0), INT32_C(         -1),
                            INT32_C(         -1), INT32_C(         -1), INT32_C(          0), INT32_C(          0)) },
    { simde_mm256_set_epi32(INT32_C(-1821031073), INT32_C(-1888821389), INT32_C( 1302274763), INT32_C( -889069785),
                            INT32_C(  849224332), INT32_C( 1448513971), INT32_C(-1444618137), INT32_C( -857531383)),
      simde_mm256_set_epi32(INT32_C( -294182987), INT32_C(-1911426210), INT32_C( 1273887477), INT32_C( -804272895),
                            INT32_C(-1138168885), INT32_C(-1273049807), INT32_C( -920424822), INT32_C(   75748881)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(         -1), INT32_C(         -1), INT32_C(          0),
                            INT32_C(         -1), INT32_C(         -1), INT32_C(          0), INT32_C(          0)) },
    { simde_mm256_set_epi32(INT32_C( -145989095), INT32_C( 1224886052), INT32_C(-1270092347), INT32_C(-2004839127),
                            INT32_C( -805168375), INT32_C(-2053011497), INT32_C(  926069792), INT32_C( -523797780)),
      simde_mm256_set_epi32(INT32_C( 1782736183), INT32_C( 1196895214), INT32_C( 2023829967), INT32_C(  431966763),
                            INT32_C(-1279096565), INT32_C(-1568278654), INT32_C( -225755322), INT32_C(  800135833)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(         -1), INT32_C(          0), INT32_C(          0),
                            INT32_C(         -1), INT32_C(          0), INT32_C(         -1), INT32_C(          0)) },
    { simde_mm256_set_epi32(INT32_C(   45181175), INT32_C( 2067174734), INT32_C(-1046962322), INT32_C( -770870625),
                            INT32_C(  166196701), INT32_C(-1211694319), INT32_C( 1891438592), INT32_C(-1986783509)),
      simde_mm256_set_epi32(INT32_C( 1357811899), INT32_C( -666006860), INT32_C(  -78093915), INT32_C(-1784875915),
                            INT32_C(-1592390514), INT32_C( -295345562), INT32_C(-1194315003), INT32_C( -378378269)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(         -1), INT32_C(          0), INT32_C(         -1),
                            INT32_C(         -1), INT32_C(          0), INT32_C(         -1), INT32_C(          0)) },
    { simde_mm256_set_epi32(INT32_C( 2029570724), INT32_C(  593067919), INT32_C( 1378001411), INT32_C(-1490077172),
                            INT32_C( -985008502), INT32_C( -780769236), INT32_C(  983706005), INT32_C( -145048806)),
      simde_mm256_set_epi32(INT32_C( -371614648), INT32_C(  790968401), INT32_C(  604322541), INT32_C( 1275463353),
                            INT32_C(  507685025), INT32_C(-1785065497), INT32_C( -324987069), INT32_C( 1403024939)),
      simde_mm256_set_epi32(INT32_C(         -1), INT32_C(          0), INT32_C(         -1), INT32_C(          0),
                            INT32_C(          0), INT32_C(         -1), INT32_C(         -1), INT32_C(          0)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_cmpgt_epi32(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_cmpgt_epi64(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
      { simde_mm256_set_epi64x(INT64_C( 2118945800826688975), INT64_C(-2048024407550915063),
                             INT64_C( 5214505670652994271), INT64_C( -257856994503089701)),
      simde_mm256_set_epi64x(INT64_C( 5695011750507465952), INT64_C( -909596801509157384),
                             INT64_C( 8030198869340496548), INT64_C(  154404577117411578)),
      simde_mm256_set_epi64x(INT64_C(                   0), INT64_C(                   0),
                             INT64_C(                   0), INT64_C(                   0)) },
    { simde_mm256_set_epi64x(INT64_C( 5911350820320548021), INT64_C( 1593992970237440641),
                             INT64_C( 1816057404225443518), INT64_C(-5807847363009183486)),
      simde_mm256_set_epi64x(INT64_C( 6716528373762493386), INT64_C(-8043125522610464194),
                             INT64_C( 8780083716644576089), INT64_C( 1141738695323567528)),
      simde_mm256_set_epi64x(INT64_C(                   0), INT64_C(                  -1),
                             INT64_C(                   0), INT64_C(                   0)) },
    { simde_mm256_set_epi64x(INT64_C( 2128200156105206458), INT64_C( 4268557007045133354),
                             INT64_C(  922795411729807384), INT64_C( -370673782849908924)),
      simde_mm256_set_epi64x(INT64_C(-4606711496612992363), INT64_C( 5770563142009272389),
                             INT64_C( 5439573582391425757), INT64_C( 3818549561656095124)),
      simde_mm256_set_epi64x(INT64_C(                  -1), INT64_C(                   0),
                             INT64_C(                   0), INT64_C(                   0)) },
    { simde_mm256_set_epi64x(INT64_C(-7763872078520682010), INT64_C( 8214461135943818795),
                             INT64_C( 6913361685886042209), INT64_C( 4675504907089870645)),
      simde_mm256_set_epi64x(INT64_C( 4559571845325885325), INT64_C(-5258431881764629271),
                             INT64_C( 5559569102824249097), INT64_C( 5799667037503013333)),
      simde_mm256_set_epi64x(INT64_C(                   0), INT64_C(                  -1),
                             INT64_C(                  -1), INT64_C(                   0)) },
    { simde_mm256_set_epi64x(INT64_C( 4800525853411880003), INT64_C( -184846840160593290),
                             INT64_C(-4953203027402144401), INT64_C( 2572609663077992835)),
      simde_mm256_set_epi64x(INT64_C(-5431416973650143300), INT64_C( 5030179310017915920),
                             INT64_C(-6125011459628645754), INT64_C(-8488302794525901027)),
      simde_mm256_set_epi64x(INT64_C(                  -1), INT64_C(                   0),
                             INT64_C(                  -1), INT64_C(                  -1)) },
    { simde_mm256_set_epi64x(INT64_C(-3860235829589315850), INT64_C( 8837948345888719516),
                             INT64_C( 3875197176959192831), INT64_C(-5180468743599698974)),
      simde_mm256_set_epi64x(INT64_C(-1290331525121336992), INT64_C(-2797732422128290053),
                             INT64_C(-1679378228033738615), INT64_C(-7981001780127731934)),
      simde_mm256_set_epi64x(INT64_C(                   0), INT64_C(                  -1),
                             INT64_C(                  -1), INT64_C(                  -1)) },
    { simde_mm256_set_epi64x(INT64_C(-1174099241428997420), INT64_C( -973237140110744253),
                             INT64_C(-2478103055519574033), INT64_C(-4160968278707001293)),
      simde_mm256_set_epi64x(INT64_C(-5836788839917359935), INT64_C( 9029070361682465515),
                             INT64_C( 7441474531728878768), INT64_C(-8910660672377811998)),
      simde_mm256_set_epi64x(INT64_C(                  -1), INT64_C(                   0),
                             INT64_C(                   0), INT64_C(                  -1)) },
    { simde_mm256_set_epi64x(INT64_C(  660412182468938166), INT64_C( 2628509021710534078),
                             INT64_C(-4480617326594733579), INT64_C( 6124790654743076244)),
      simde_mm256_set_epi64x(INT64_C(-2572783283758925366), INT64_C( 8355777023791813662),
                             INT64_C( 7632362282544129149), INT64_C(-5998036421176707691)),
      simde_mm256_set_epi64x(INT64_C(                  -1), INT64_C(                   0),
                             INT64_C(                   0), INT64_C(                  -1)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_cmpgt_epi64(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i64(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm_broadcastb_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m128i a;
    simde__m128i r;
  } test_vec[8] = {
    { simde_mm_set_epi8(INT8_C( -20), INT8_C( 103), INT8_C( -20), INT8_C( 116),
                        INT8_C(  -9), INT8_C(  73), INT8_C(  44), INT8_C(  79),
                        INT8_C( -20), INT8_C( -81), INT8_C(-114), INT8_C( -81),
                        INT8_C(  10), INT8_C(  63), INT8_C( -41), INT8_C(-117)),
      simde_mm_set_epi8(INT8_C(-117), INT8_C(-117), INT8_C(-117), INT8_C(-117),
                        INT8_C(-117), INT8_C(-117), INT8_C(-117), INT8_C(-117),
                        INT8_C(-117), INT8_C(-117), INT8_C(-117), INT8_C(-117),
                        INT8_C(-117), INT8_C(-117), INT8_C(-117), INT8_C(-117)) },
    { simde_mm_set_epi8(INT8_C( -22), INT8_C(-124), INT8_C( -97), INT8_C(  -1),
                        INT8_C(  -4), INT8_C( -87), INT8_C( -49), INT8_C(-124),
                        INT8_C( -37), INT8_C( -17), INT8_C( -57), INT8_C(   0),
                        INT8_C(-121), INT8_C(  57), INT8_C(  49), INT8_C(-112)),
      simde_mm_set_epi8(INT8_C(-112), INT8_C(-112), INT8_C(-112), INT8_C(-112),
                        INT8_C(-112), INT8_C(-112), INT8_C(-112), INT8_C(-112),
                        INT8_C(-112), INT8_C(-112), INT8_C(-112), INT8_C(-112),
                        INT8_C(-112), INT8_C(-112), INT8_C(-112), INT8_C(-112)) },
    { simde_mm_set_epi8(INT8_C( -37), INT8_C( -43), INT8_C( -30), INT8_C(  45),
                        INT8_C(  86), INT8_C(-100), INT8_C( -53), INT8_C(  -4),
                        INT8_C(  54), INT8_C(-107), INT8_C(  40), INT8_C( -68),
                        INT8_C(  49), INT8_C(  59), INT8_C( -37), INT8_C(  60)),
      simde_mm_set_epi8(INT8_C(  60), INT8_C(  60), INT8_C(  60), INT8_C(  60),
                        INT8_C(  60), INT8_C(  60), INT8_C(  60), INT8_C(  60),
                        INT8_C(  60), INT8_C(  60), INT8_C(  60), INT8_C(  60),
                        INT8_C(  60), INT8_C(  60), INT8_C(  60), INT8_C(  60)) },
    { simde_mm_set_epi8(INT8_C(  35), INT8_C( -98), INT8_C( -73), INT8_C(  22),
                        INT8_C(-127), INT8_C(  78), INT8_C( 125), INT8_C(  84),
                        INT8_C(-115), INT8_C(-124), INT8_C(-103), INT8_C(  59),
                        INT8_C(  15), INT8_C( -58), INT8_C(  81), INT8_C(   4)),
      simde_mm_set_epi8(INT8_C(   4), INT8_C(   4), INT8_C(   4), INT8_C(   4),
                        INT8_C(   4), INT8_C(   4), INT8_C(   4), INT8_C(   4),
                        INT8_C(   4), INT8_C(   4), INT8_C(   4), INT8_C(   4),
                        INT8_C(   4), INT8_C(   4), INT8_C(   4), INT8_C(   4)) },
    { simde_mm_set_epi8(INT8_C( -56), INT8_C(  88), INT8_C(   1), INT8_C( -59),
                        INT8_C( -14), INT8_C( -27), INT8_C( -63), INT8_C( -89),
                        INT8_C( -31), INT8_C( -81), INT8_C( -92), INT8_C( 115),
                        INT8_C( 106), INT8_C( -49), INT8_C( -19), INT8_C(  92)),
      simde_mm_set_epi8(INT8_C(  92), INT8_C(  92), INT8_C(  92), INT8_C(  92),
                        INT8_C(  92), INT8_C(  92), INT8_C(  92), INT8_C(  92),
                        INT8_C(  92), INT8_C(  92), INT8_C(  92), INT8_C(  92),
                        INT8_C(  92), INT8_C(  92), INT8_C(  92), INT8_C(  92)) },
    { simde_mm_set_epi8(INT8_C(   7), INT8_C(  47), INT8_C(  55), INT8_C(  77),
                        INT8_C(  16), INT8_C( -71), INT8_C(-122), INT8_C( -81),
                        INT8_C(-120), INT8_C( -64), INT8_C( -77), INT8_C(  13),
                        INT8_C(  80), INT8_C(-114), INT8_C(-121), INT8_C(  92)),
      simde_mm_set_epi8(INT8_C(  92), INT8_C(  92), INT8_C(  92), INT8_C(  92),
                        INT8_C(  92), INT8_C(  92), INT8_C(  92), INT8_C(  92),
                        INT8_C(  92), INT8_C(  92), INT8_C(  92), INT8_C(  92),
                        INT8_C(  92), INT8_C(  92), INT8_C(  92), INT8_C(  92)) },
    { simde_mm_set_epi8(INT8_C(  14), INT8_C( -85), INT8_C(  -8), INT8_C( -80),
                        INT8_C( -58), INT8_C(  84), INT8_C(  52), INT8_C(-106),
                        INT8_C( -46), INT8_C( 118), INT8_C( -96), INT8_C(  88),
                        INT8_C(  35), INT8_C(  50), INT8_C(-112), INT8_C(-112)),
      simde_mm_set_epi8(INT8_C(-112), INT8_C(-112), INT8_C(-112), INT8_C(-112),
                        INT8_C(-112), INT8_C(-112), INT8_C(-112), INT8_C(-112),
                        INT8_C(-112), INT8_C(-112), INT8_C(-112), INT8_C(-112),
                        INT8_C(-112), INT8_C(-112), INT8_C(-112), INT8_C(-112)) },
    { simde_mm_set_epi8(INT8_C(  17), INT8_C(  88), INT8_C( -82), INT8_C(-109),
                        INT8_C(  56), INT8_C(  18), INT8_C(  73), INT8_C( 115),
                        INT8_C( -99), INT8_C( -71), INT8_C( -92), INT8_C( 121),
                        INT8_C(  93), INT8_C(  51), INT8_C( -65), INT8_C(  55)),
      simde_mm_set_epi8(INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                        INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                        INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                        INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m128i r = simde_mm_broadcastb_epi8(test_vec[i].a);
    simde_assert_m128i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_broadcastb_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m128i a;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm_set_epi8(INT8_C( -20), INT8_C( 103), INT8_C( -20), INT8_C( 116),
                        INT8_C(  -9), INT8_C(  73), INT8_C(  44), INT8_C(  79),
                        INT8_C( -20), INT8_C( -81), INT8_C(-114), INT8_C( -81),
                        INT8_C(  10), INT8_C(  63), INT8_C( -41), INT8_C(-117)),
      simde_mm256_set_epi8(INT8_C(-117), INT8_C(-117), INT8_C(-117), INT8_C(-117),
                           INT8_C(-117), INT8_C(-117), INT8_C(-117), INT8_C(-117),
                           INT8_C(-117), INT8_C(-117), INT8_C(-117), INT8_C(-117),
                           INT8_C(-117), INT8_C(-117), INT8_C(-117), INT8_C(-117),
                           INT8_C(-117), INT8_C(-117), INT8_C(-117), INT8_C(-117),
                           INT8_C(-117), INT8_C(-117), INT8_C(-117), INT8_C(-117),
                           INT8_C(-117), INT8_C(-117), INT8_C(-117), INT8_C(-117),
                           INT8_C(-117), INT8_C(-117), INT8_C(-117), INT8_C(-117)) },
    { simde_mm_set_epi8(INT8_C( -22), INT8_C(-124), INT8_C( -97), INT8_C(  -1),
                        INT8_C(  -4), INT8_C( -87), INT8_C( -49), INT8_C(-124),
                        INT8_C( -37), INT8_C( -17), INT8_C( -57), INT8_C(   0),
                        INT8_C(-121), INT8_C(  57), INT8_C(  49), INT8_C(-112)),
      simde_mm256_set_epi8(INT8_C(-112), INT8_C(-112), INT8_C(-112), INT8_C(-112),
                           INT8_C(-112), INT8_C(-112), INT8_C(-112), INT8_C(-112),
                           INT8_C(-112), INT8_C(-112), INT8_C(-112), INT8_C(-112),
                           INT8_C(-112), INT8_C(-112), INT8_C(-112), INT8_C(-112),
                           INT8_C(-112), INT8_C(-112), INT8_C(-112), INT8_C(-112),
                           INT8_C(-112), INT8_C(-112), INT8_C(-112), INT8_C(-112),
                           INT8_C(-112), INT8_C(-112), INT8_C(-112), INT8_C(-112),
                           INT8_C(-112), INT8_C(-112), INT8_C(-112), INT8_C(-112)) },
    { simde_mm_set_epi8(INT8_C( -37), INT8_C( -43), INT8_C( -30), INT8_C(  45),
                        INT8_C(  86), INT8_C(-100), INT8_C( -53), INT8_C(  -4),
                        INT8_C(  54), INT8_C(-107), INT8_C(  40), INT8_C( -68),
                        INT8_C(  49), INT8_C(  59), INT8_C( -37), INT8_C(  60)),
      simde_mm256_set_epi8(INT8_C(  60), INT8_C(  60), INT8_C(  60), INT8_C(  60),
                           INT8_C(  60), INT8_C(  60), INT8_C(  60), INT8_C(  60),
                           INT8_C(  60), INT8_C(  60), INT8_C(  60), INT8_C(  60),
                           INT8_C(  60), INT8_C(  60), INT8_C(  60), INT8_C(  60),
                           INT8_C(  60), INT8_C(  60), INT8_C(  60), INT8_C(  60),
                           INT8_C(  60), INT8_C(  60), INT8_C(  60), INT8_C(  60),
                           INT8_C(  60), INT8_C(  60), INT8_C(  60), INT8_C(  60),
                           INT8_C(  60), INT8_C(  60), INT8_C(  60), INT8_C(  60)) },
    { simde_mm_set_epi8(INT8_C(  35), INT8_C( -98), INT8_C( -73), INT8_C(  22),
                        INT8_C(-127), INT8_C(  78), INT8_C( 125), INT8_C(  84),
                        INT8_C(-115), INT8_C(-124), INT8_C(-103), INT8_C(  59),
                        INT8_C(  15), INT8_C( -58), INT8_C(  81), INT8_C(   4)),
      simde_mm256_set_epi8(INT8_C(   4), INT8_C(   4), INT8_C(   4), INT8_C(   4),
                           INT8_C(   4), INT8_C(   4), INT8_C(   4), INT8_C(   4),
                           INT8_C(   4), INT8_C(   4), INT8_C(   4), INT8_C(   4),
                           INT8_C(   4), INT8_C(   4), INT8_C(   4), INT8_C(   4),
                           INT8_C(   4), INT8_C(   4), INT8_C(   4), INT8_C(   4),
                           INT8_C(   4), INT8_C(   4), INT8_C(   4), INT8_C(   4),
                           INT8_C(   4), INT8_C(   4), INT8_C(   4), INT8_C(   4),
                           INT8_C(   4), INT8_C(   4), INT8_C(   4), INT8_C(   4)) },
    { simde_mm_set_epi8(INT8_C( -56), INT8_C(  88), INT8_C(   1), INT8_C( -59),
                        INT8_C( -14), INT8_C( -27), INT8_C( -63), INT8_C( -89),
                        INT8_C( -31), INT8_C( -81), INT8_C( -92), INT8_C( 115),
                        INT8_C( 106), INT8_C( -49), INT8_C( -19), INT8_C(  92)),
      simde_mm256_set_epi8(INT8_C(  92), INT8_C(  92), INT8_C(  92), INT8_C(  92),
                           INT8_C(  92), INT8_C(  92), INT8_C(  92), INT8_C(  92),
                           INT8_C(  92), INT8_C(  92), INT8_C(  92), INT8_C(  92),
                           INT8_C(  92), INT8_C(  92), INT8_C(  92), INT8_C(  92),
                           INT8_C(  92), INT8_C(  92), INT8_C(  92), INT8_C(  92),
                           INT8_C(  92), INT8_C(  92), INT8_C(  92), INT8_C(  92),
                           INT8_C(  92), INT8_C(  92), INT8_C(  92), INT8_C(  92),
                           INT8_C(  92), INT8_C(  92), INT8_C(  92), INT8_C(  92)) },
    { simde_mm_set_epi8(INT8_C(   7), INT8_C(  47), INT8_C(  55), INT8_C(  77),
                        INT8_C(  16), INT8_C( -71), INT8_C(-122), INT8_C( -81),
                        INT8_C(-120), INT8_C( -64), INT8_C( -77), INT8_C(  13),
                        INT8_C(  80), INT8_C(-114), INT8_C(-121), INT8_C(  92)),
      simde_mm256_set_epi8(INT8_C(  92), INT8_C(  92), INT8_C(  92), INT8_C(  92),
                           INT8_C(  92), INT8_C(  92), INT8_C(  92), INT8_C(  92),
                           INT8_C(  92), INT8_C(  92), INT8_C(  92), INT8_C(  92),
                           INT8_C(  92), INT8_C(  92), INT8_C(  92), INT8_C(  92),
                           INT8_C(  92), INT8_C(  92), INT8_C(  92), INT8_C(  92),
                           INT8_C(  92), INT8_C(  92), INT8_C(  92), INT8_C(  92),
                           INT8_C(  92), INT8_C(  92), INT8_C(  92), INT8_C(  92),
                           INT8_C(  92), INT8_C(  92), INT8_C(  92), INT8_C(  92)) },
    { simde_mm_set_epi8(INT8_C(  14), INT8_C( -85), INT8_C(  -8), INT8_C( -80),
                        INT8_C( -58), INT8_C(  84), INT8_C(  52), INT8_C(-106),
                        INT8_C( -46), INT8_C( 118), INT8_C( -96), INT8_C(  88),
                        INT8_C(  35), INT8_C(  50), INT8_C(-112), INT8_C(-112)),
      simde_mm256_set_epi8(INT8_C(-112), INT8_C(-112), INT8_C(-112), INT8_C(-112),
                           INT8_C(-112), INT8_C(-112), INT8_C(-112), INT8_C(-112),
                           INT8_C(-112), INT8_C(-112), INT8_C(-112), INT8_C(-112),
                           INT8_C(-112), INT8_C(-112), INT8_C(-112), INT8_C(-112),
                           INT8_C(-112), INT8_C(-112), INT8_C(-112), INT8_C(-112),
                           INT8_C(-112), INT8_C(-112), INT8_C(-112), INT8_C(-112),
                           INT8_C(-112), INT8_C(-112), INT8_C(-112), INT8_C(-112),
                           INT8_C(-112), INT8_C(-112), INT8_C(-112), INT8_C(-112)) },
    { simde_mm_set_epi8(INT8_C(  17), INT8_C(  88), INT8_C( -82), INT8_C(-109),
                        INT8_C(  56), INT8_C(  18), INT8_C(  73), INT8_C( 115),
                        INT8_C( -99), INT8_C( -71), INT8_C( -92), INT8_C( 121),
                        INT8_C(  93), INT8_C(  51), INT8_C( -65), INT8_C(  55)),
      simde_mm256_set_epi8(INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55),
                           INT8_C(  55), INT8_C(  55), INT8_C(  55), INT8_C(  55)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_broadcastb_epi8(test_vec[i].a);
    simde_assert_m256i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_broadcastsi128_si256(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m128i a;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm_set_epi64x   (INT64_C( 3783485884510153131), INT64_C( 5322848723863790661)),
      simde_mm256_set_epi64x(INT64_C( 3783485884510153131), INT64_C( 5322848723863790661),
                             INT64_C( 3783485884510153131), INT64_C( 5322848723863790661)) },
    { simde_mm_set_epi64x   (INT64_C( 3709494745882156155), INT64_C(-6688158465955285293)),
      simde_mm256_set_epi64x(INT64_C( 3709494745882156155), INT64_C(-6688158465955285293),
                             INT64_C( 3709494745882156155), INT64_C(-6688158465955285293)) },
    { simde_mm_set_epi64x   (INT64_C(-8419237038829073489), INT64_C(-1707044583358729761)),
      simde_mm256_set_epi64x(INT64_C(-8419237038829073489), INT64_C(-1707044583358729761),
                             INT64_C(-8419237038829073489), INT64_C(-1707044583358729761)) },
    { simde_mm_set_epi64x   (INT64_C( -168447772491176834), INT64_C(-4784151950425519944)),
      simde_mm256_set_epi64x(INT64_C( -168447772491176834), INT64_C(-4784151950425519944),
                             INT64_C( -168447772491176834), INT64_C(-4784151950425519944)) },
    { simde_mm_set_epi64x   (INT64_C(  992172666234330248), INT64_C( 7115358650695109080)),
      simde_mm256_set_epi64x(INT64_C(  992172666234330248), INT64_C( 7115358650695109080),
                             INT64_C(  992172666234330248), INT64_C( 7115358650695109080)) },
    { simde_mm_set_epi64x   (INT64_C( 6019682307676879898), INT64_C( -745177675559433697)),
      simde_mm256_set_epi64x(INT64_C( 6019682307676879898), INT64_C( -745177675559433697),
                             INT64_C( 6019682307676879898), INT64_C( -745177675559433697)) },
    { simde_mm_set_epi64x   (INT64_C(-8364368011425569946), INT64_C( 1685080214233190853)),
      simde_mm256_set_epi64x(INT64_C(-8364368011425569946), INT64_C( 1685080214233190853),
                             INT64_C(-8364368011425569946), INT64_C( 1685080214233190853)) },
    { simde_mm_set_epi64x   (INT64_C( 6712859087758853138), INT64_C( 2170550621944299043)),
      simde_mm256_set_epi64x(INT64_C( 6712859087758853138), INT64_C( 2170550621944299043),
                             INT64_C( 6712859087758853138), INT64_C( 2170550621944299043)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_broadcastsi128_si256(test_vec[i].a);
    simde_assert_m256i_i64(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_cvtepi8_epi16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m128i a;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm_set_epi8(INT8_C( -64), INT8_C( -39), INT8_C(  -1), INT8_C( 123),
                        INT8_C( -41), INT8_C(  42), INT8_C( -42), INT8_C(  48),
                        INT8_C(-101), INT8_C( -11), INT8_C(  78), INT8_C( -33),
                        INT8_C(  -4), INT8_C( -46), INT8_C(-128), INT8_C( 115)),
      simde_mm256_set_epi16(INT16_C(   -64), INT16_C(   -39), INT16_C(    -1), INT16_C(   123),
                            INT16_C(   -41), INT16_C(    42), INT16_C(   -42), INT16_C(    48),
                            INT16_C(  -101), INT16_C(   -11), INT16_C(    78), INT16_C(   -33),
                            INT16_C(    -4), INT16_C(   -46), INT16_C(  -128), INT16_C(   115)) },
    { simde_mm_set_epi8(INT8_C( -82), INT8_C(  92), INT8_C(  55), INT8_C( -41),
                        INT8_C(  61), INT8_C(-113), INT8_C( 108), INT8_C(  36),
                        INT8_C( 115), INT8_C(  53), INT8_C( -46), INT8_C( -96),
                        INT8_C( -71), INT8_C( -38), INT8_C(  25), INT8_C(  61)),
      simde_mm256_set_epi16(INT16_C(   -82), INT16_C(    92), INT16_C(    55), INT16_C(   -41),
                            INT16_C(    61), INT16_C(  -113), INT16_C(   108), INT16_C(    36),
                            INT16_C(   115), INT16_C(    53), INT16_C(   -46), INT16_C(   -96),
                            INT16_C(   -71), INT16_C(   -38), INT16_C(    25), INT16_C(    61)) },
    { simde_mm_set_epi8(INT8_C( -73), INT8_C(   5), INT8_C(  10), INT8_C(-111),
                        INT8_C(-127), INT8_C(  16), INT8_C( -16), INT8_C(-115),
                        INT8_C(  94), INT8_C(  88), INT8_C( -20), INT8_C( -24),
                        INT8_C( -27), INT8_C( -17), INT8_C( -31), INT8_C(  67)),
      simde_mm256_set_epi16(INT16_C(   -73), INT16_C(     5), INT16_C(    10), INT16_C(  -111),
                            INT16_C(  -127), INT16_C(    16), INT16_C(   -16), INT16_C(  -115),
                            INT16_C(    94), INT16_C(    88), INT16_C(   -20), INT16_C(   -24),
                            INT16_C(   -27), INT16_C(   -17), INT16_C(   -31), INT16_C(    67)) },
    { simde_mm_set_epi8(INT8_C( -17), INT8_C(   8), INT8_C(  67), INT8_C( -40),
                        INT8_C(  99), INT8_C(  89), INT8_C( -60), INT8_C( -24),
                        INT8_C( 120), INT8_C( -29), INT8_C(-127), INT8_C(  15),
                        INT8_C( -40), INT8_C(-106), INT8_C(  13), INT8_C( -27)),
      simde_mm256_set_epi16(INT16_C(   -17), INT16_C(     8), INT16_C(    67), INT16_C(   -40),
                            INT16_C(    99), INT16_C(    89), INT16_C(   -60), INT16_C(   -24),
                            INT16_C(   120), INT16_C(   -29), INT16_C(  -127), INT16_C(    15),
                            INT16_C(   -40), INT16_C(  -106), INT16_C(    13), INT16_C(   -27)) },
    { simde_mm_set_epi8(INT8_C(  -5), INT8_C(  52), INT8_C( 112), INT8_C( -86),
                        INT8_C(   7), INT8_C(   2), INT8_C(  89), INT8_C(  40),
                        INT8_C(  34), INT8_C( -14), INT8_C(-119), INT8_C(-115),
                        INT8_C(-103), INT8_C( 103), INT8_C( -15), INT8_C( -68)),
      simde_mm256_set_epi16(INT16_C(    -5), INT16_C(    52), INT16_C(   112), INT16_C(   -86),
                            INT16_C(     7), INT16_C(     2), INT16_C(    89), INT16_C(    40),
                            INT16_C(    34), INT16_C(   -14), INT16_C(  -119), INT16_C(  -115),
                            INT16_C(  -103), INT16_C(   103), INT16_C(   -15), INT16_C(   -68)) },
    { simde_mm_set_epi8(INT8_C(  34), INT8_C( 104), INT8_C(-116), INT8_C(-106),
                        INT8_C(-122), INT8_C(  51), INT8_C( -86), INT8_C(  26),
                        INT8_C(  57), INT8_C(  23), INT8_C( 125), INT8_C(  20),
                        INT8_C(  40), INT8_C( -87), INT8_C( -60), INT8_C( -93)),
      simde_mm256_set_epi16(INT16_C(    34), INT16_C(   104), INT16_C(  -116), INT16_C(  -106),
                            INT16_C(  -122), INT16_C(    51), INT16_C(   -86), INT16_C(    26),
                            INT16_C(    57), INT16_C(    23), INT16_C(   125), INT16_C(    20),
                            INT16_C(    40), INT16_C(   -87), INT16_C(   -60), INT16_C(   -93)) },
    { simde_mm_set_epi8(INT8_C(  35), INT8_C( 103), INT8_C(  83), INT8_C(  11),
                        INT8_C(   5), INT8_C( -26), INT8_C( -34), INT8_C( -28),
                        INT8_C( -15), INT8_C(  -2), INT8_C(  10), INT8_C( -97),
                        INT8_C(  35), INT8_C(-108), INT8_C(  38), INT8_C(-122)),
      simde_mm256_set_epi16(INT16_C(    35), INT16_C(   103), INT16_C(    83), INT16_C(    11),
                            INT16_C(     5), INT16_C(   -26), INT16_C(   -34), INT16_C(   -28),
                            INT16_C(   -15), INT16_C(    -2), INT16_C(    10), INT16_C(   -97),
                            INT16_C(    35), INT16_C(  -108), INT16_C(    38), INT16_C(  -122)) },
    { simde_mm_set_epi8(INT8_C(  44), INT8_C(-101), INT8_C(-122), INT8_C(  91),
                        INT8_C(  60), INT8_C(  60), INT8_C(  22), INT8_C(  81),
                        INT8_C(  13), INT8_C(-111), INT8_C(-125), INT8_C( -40),
                        INT8_C( -72), INT8_C(-102), INT8_C( -87), INT8_C( 108)),
      simde_mm256_set_epi16(INT16_C(    44), INT16_C(  -101), INT16_C(  -122), INT16_C(    91),
                            INT16_C(    60), INT16_C(    60), INT16_C(    22), INT16_C(    81),
                            INT16_C(    13), INT16_C(  -111), INT16_C(  -125), INT16_C(   -40),
                            INT16_C(   -72), INT16_C(  -102), INT16_C(   -87), INT16_C(   108)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_cvtepi8_epi16(test_vec[i].a);
    simde_assert_m256i_i16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_cvtepi8_epi32(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m128i a;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm_set_epi8(INT8_C( 123), INT8_C(  -2), INT8_C( 102), INT8_C( -48),
                        INT8_C(  12), INT8_C(-119), INT8_C( -32), INT8_C(  68),
                        INT8_C( -88), INT8_C(  80), INT8_C(  32), INT8_C(-108),
                        INT8_C( -66), INT8_C(  35), INT8_C( -12), INT8_C(-103)),
      simde_mm256_set_epi32(INT32_C(        -88), INT32_C(         80), INT32_C(         32), INT32_C(       -108),
                            INT32_C(        -66), INT32_C(         35), INT32_C(        -12), INT32_C(       -103)) },
    { simde_mm_set_epi8(INT8_C( -12), INT8_C( -88), INT8_C( -20), INT8_C( -26),
                        INT8_C( -69), INT8_C( -40), INT8_C( 122), INT8_C(-121),
                        INT8_C(  47), INT8_C( 123), INT8_C( -15), INT8_C(-104),
                        INT8_C( -91), INT8_C( -13), INT8_C( -61), INT8_C(-104)),
      simde_mm256_set_epi32(INT32_C(         47), INT32_C(        123), INT32_C(        -15), INT32_C(       -104),
                            INT32_C(        -91), INT32_C(        -13), INT32_C(        -61), INT32_C(       -104)) },
    { simde_mm_set_epi8(INT8_C(-105), INT8_C(  35), INT8_C(-118), INT8_C( -44),
                        INT8_C( -91), INT8_C(  43), INT8_C(  18), INT8_C( -70),
                        INT8_C(  44), INT8_C(  98), INT8_C( -82), INT8_C(-126),
                        INT8_C( -80), INT8_C(-109), INT8_C(  69), INT8_C(-116)),
      simde_mm256_set_epi32(INT32_C(         44), INT32_C(         98), INT32_C(        -82), INT32_C(       -126),
                            INT32_C(        -80), INT32_C(       -109), INT32_C(         69), INT32_C(       -116)) },
    { simde_mm_set_epi8(INT8_C(  43), INT8_C(  92), INT8_C( -66), INT8_C( -32),
                        INT8_C(  71), INT8_C( -63), INT8_C(  51), INT8_C(  89),
                        INT8_C( 102), INT8_C(  -4), INT8_C( -28), INT8_C(  -5),
                        INT8_C(-107), INT8_C( -25), INT8_C(-107), INT8_C( -15)),
      simde_mm256_set_epi32(INT32_C(        102), INT32_C(         -4), INT32_C(        -28), INT32_C(         -5),
                            INT32_C(       -107), INT32_C(        -25), INT32_C(       -107), INT32_C(        -15)) },
    { simde_mm_set_epi8(INT8_C(  -7), INT8_C( -22), INT8_C(  -1), INT8_C(  29),
                        INT8_C(  -3), INT8_C( -97), INT8_C(  61), INT8_C( -36),
                        INT8_C( -81), INT8_C( -83), INT8_C(  54), INT8_C(  37),
                        INT8_C( -70), INT8_C( -70), INT8_C(  12), INT8_C( -61)),
      simde_mm256_set_epi32(INT32_C(        -81), INT32_C(        -83), INT32_C(         54), INT32_C(         37),
                            INT32_C(        -70), INT32_C(        -70), INT32_C(         12), INT32_C(        -61)) },
    { simde_mm_set_epi8(INT8_C(  88), INT8_C( -30), INT8_C( 125), INT8_C( -22),
                        INT8_C( -87), INT8_C(-109), INT8_C( -90), INT8_C( -86),
                        INT8_C(-124), INT8_C( -10), INT8_C(  57), INT8_C( -62),
                        INT8_C( -55), INT8_C(  40), INT8_C( -11), INT8_C(-100)),
      simde_mm256_set_epi32(INT32_C(       -124), INT32_C(        -10), INT32_C(         57), INT32_C(        -62),
                            INT32_C(        -55), INT32_C(         40), INT32_C(        -11), INT32_C(       -100)) },
    { simde_mm_set_epi8(INT8_C(  58), INT8_C(-110), INT8_C(  -6), INT8_C( -58),
                        INT8_C(-110), INT8_C( 125), INT8_C(  39), INT8_C( -82),
                        INT8_C( -88), INT8_C( 107), INT8_C(  76), INT8_C(  58),
                        INT8_C(  -2), INT8_C(-119), INT8_C( -27), INT8_C(  40)),
      simde_mm256_set_epi32(INT32_C(        -88), INT32_C(        107), INT32_C(         76), INT32_C(         58),
                            INT32_C(         -2), INT32_C(       -119), INT32_C(        -27), INT32_C(         40)) },
    { simde_mm_set_epi8(INT8_C(-110), INT8_C( -24), INT8_C( -33), INT8_C(-117),
                        INT8_C(  92), INT8_C( -35), INT8_C( 113), INT8_C(  13),
                        INT8_C(  46), INT8_C(-107), INT8_C(   4), INT8_C(   8),
                        INT8_C(  56), INT8_C(   9), INT8_C( 123), INT8_C(  36)),
      simde_mm256_set_epi32(INT32_C(         46), INT32_C(       -107), INT32_C(          4), INT32_C(          8),
                            INT32_C(         56), INT32_C(          9), INT32_C(        123), INT32_C(         36)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_cvtepi8_epi32(test_vec[i].a);
    simde_assert_m256i_i32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_cvtepi8_epi64(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m128i a;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm_set_epi8(INT8_C(   9), INT8_C( -74), INT8_C( -52), INT8_C( -68),
                        INT8_C(  95), INT8_C( -10), INT8_C( -99), INT8_C( 121),
                        INT8_C(   1), INT8_C(  69), INT8_C( -36), INT8_C(-102),
                        INT8_C(-124), INT8_C( -93), INT8_C(-101), INT8_C(-118)),
      simde_mm256_set_epi64x(INT64_C(                -124), INT64_C(                 -93),
                             INT64_C(                -101), INT64_C(                -118)) },
    { simde_mm_set_epi8(INT8_C(-107), INT8_C( -34), INT8_C( -75), INT8_C( 119),
                        INT8_C( -79), INT8_C(-103), INT8_C(  -9), INT8_C(-121),
                        INT8_C( -51), INT8_C(   4), INT8_C(  89), INT8_C( 110),
                        INT8_C( 112), INT8_C(  67), INT8_C(-101), INT8_C(  87)),
      simde_mm256_set_epi64x(INT64_C(                 112), INT64_C(                  67),
                             INT64_C(                -101), INT64_C(                  87)) },
    { simde_mm_set_epi8(INT8_C( -85), INT8_C( 121), INT8_C(-116), INT8_C( 121),
                        INT8_C( -43), INT8_C( -80), INT8_C(   1), INT8_C(-102),
                        INT8_C(  39), INT8_C(-105), INT8_C( -26), INT8_C(  88),
                        INT8_C( -52), INT8_C(  61), INT8_C(-127), INT8_C(  21)),
      simde_mm256_set_epi64x(INT64_C(                 -52), INT64_C(                  61),
                             INT64_C(                -127), INT64_C(                  21)) },
    { simde_mm_set_epi8(INT8_C(  85), INT8_C(   1), INT8_C(  94), INT8_C(  60),
                        INT8_C( 102), INT8_C(   9), INT8_C( -56), INT8_C(  64),
                        INT8_C(-103), INT8_C( -86), INT8_C(  51), INT8_C(-126),
                        INT8_C(  -9), INT8_C(  88), INT8_C( -52), INT8_C(  13)),
      simde_mm256_set_epi64x(INT64_C(                  -9), INT64_C(                  88),
                             INT64_C(                 -52), INT64_C(                  13)) },
    { simde_mm_set_epi8(INT8_C(   0), INT8_C( -40), INT8_C(  42), INT8_C(  42),
                        INT8_C( 109), INT8_C(  -5), INT8_C( -28), INT8_C( -80),
                        INT8_C(  70), INT8_C(   6), INT8_C( -51), INT8_C(  17),
                        INT8_C(-105), INT8_C(-108), INT8_C(  14), INT8_C( -91)),
      simde_mm256_set_epi64x(INT64_C(                -105), INT64_C(                -108),
                             INT64_C(                  14), INT64_C(                 -91)) },
    { simde_mm_set_epi8(INT8_C( 125), INT8_C(-114), INT8_C( -39), INT8_C(-118),
                        INT8_C(  29), INT8_C( -81), INT8_C(-121), INT8_C( 115),
                        INT8_C(-128), INT8_C(  99), INT8_C(  64), INT8_C(   7),
                        INT8_C( 114), INT8_C(-101), INT8_C(-127), INT8_C(  30)),
      simde_mm256_set_epi64x(INT64_C(                 114), INT64_C(                -101),
                             INT64_C(                -127), INT64_C(                  30)) },
    { simde_mm_set_epi8(INT8_C(-126), INT8_C( 122), INT8_C(  50), INT8_C( 115),
                        INT8_C(  72), INT8_C( -56), INT8_C(  52), INT8_C( 125),
                        INT8_C(-104), INT8_C( -76), INT8_C(  65), INT8_C( 103),
                        INT8_C(-122), INT8_C( -36), INT8_C( -93), INT8_C( 110)),
      simde_mm256_set_epi64x(INT64_C(                -122), INT64_C(                 -36),
                             INT64_C(                 -93), INT64_C(                 110)) },
    { simde_mm_set_epi8(INT8_C( -80), INT8_C(  98), INT8_C(-119), INT8_C(  51),
                        INT8_C( -37), INT8_C( -17), INT8_C( -94), INT8_C(-122),
                        INT8_C(-114), INT8_C(  13), INT8_C( -75), INT8_C( 111),
                        INT8_C( -76), INT8_C( -15), INT8_C(  -1), INT8_C( -12)),
      simde_mm256_set_epi64x(INT64_C(                 -76), INT64_C(                 -15),
                             INT64_C(                  -1), INT64_C(                 -12)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_cvtepi8_epi64(test_vec[i].a);
    simde_assert_m256i_i64(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}


static MunitResult
test_simde_mm256_cvtepi16_epi32(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m128i a;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm_set_epi16(INT16_C( 29201), INT16_C( 17763), INT16_C( 13480), INT16_C( 29487),
                         INT16_C( -6581), INT16_C( 13446), INT16_C( 26538), INT16_C( -3936)),
      simde_mm256_set_epi32(INT32_C(      29201), INT32_C(      17763), INT32_C(      13480), INT32_C(      29487),
                            INT32_C(      -6581), INT32_C(      13446), INT32_C(      26538), INT32_C(      -3936)) },
    { simde_mm_set_epi16(INT16_C( -3829), INT16_C( 12503), INT16_C( 10513), INT16_C( 11407),
                         INT16_C( 28611), INT16_C(  5727), INT16_C( 32199), INT16_C( 11434)),
      simde_mm256_set_epi32(INT32_C(      -3829), INT32_C(      12503), INT32_C(      10513), INT32_C(      11407),
                            INT32_C(      28611), INT32_C(       5727), INT32_C(      32199), INT32_C(      11434)) },
    { simde_mm_set_epi16(INT16_C( -4989), INT16_C(-23450), INT16_C(-15441), INT16_C( 22895),
                         INT16_C(  2927), INT16_C(-20709), INT16_C( -7582), INT16_C(-31347)),
      simde_mm256_set_epi32(INT32_C(      -4989), INT32_C(     -23450), INT32_C(     -15441), INT32_C(      22895),
                            INT32_C(       2927), INT32_C(     -20709), INT32_C(      -7582), INT32_C(     -31347)) },
    { simde_mm_set_epi16(INT16_C( 24635), INT16_C( 21162), INT16_C( 29781), INT16_C(  -488),
                         INT16_C( -6580), INT16_C(-27732), INT16_C(   607), INT16_C(-20782)),
      simde_mm256_set_epi32(INT32_C(      24635), INT32_C(      21162), INT32_C(      29781), INT32_C(       -488),
                            INT32_C(      -6580), INT32_C(     -27732), INT32_C(        607), INT32_C(     -20782)) },
    { simde_mm_set_epi16(INT16_C(  -401), INT16_C( -5605), INT16_C(-28681), INT16_C(  4577),
                         INT16_C( -9094), INT16_C(  6804), INT16_C( -9223), INT16_C( 10661)),
      simde_mm256_set_epi32(INT32_C(       -401), INT32_C(      -5605), INT32_C(     -28681), INT32_C(       4577),
                            INT32_C(      -9094), INT32_C(       6804), INT32_C(      -9223), INT32_C(      10661)) },
    { simde_mm_set_epi16(INT16_C(  2053), INT16_C(-19489), INT16_C(  7360), INT16_C( 16515),
                         INT16_C( 32080), INT16_C(-16555), INT16_C(-32752), INT16_C( 19001)),
      simde_mm256_set_epi32(INT32_C(       2053), INT32_C(     -19489), INT32_C(       7360), INT32_C(      16515),
                            INT32_C(      32080), INT32_C(     -16555), INT32_C(     -32752), INT32_C(      19001)) },
    { simde_mm_set_epi16(INT16_C(-31610), INT16_C(-22910), INT16_C( 22850), INT16_C(-27168),
                         INT16_C( 13092), INT16_C(-21449), INT16_C( 16024), INT16_C(  8597)),
      simde_mm256_set_epi32(INT32_C(     -31610), INT32_C(     -22910), INT32_C(      22850), INT32_C(     -27168),
                            INT32_C(      13092), INT32_C(     -21449), INT32_C(      16024), INT32_C(       8597)) },
    { simde_mm_set_epi16(INT16_C( 28081), INT16_C( -7416), INT16_C( 18632), INT16_C(-28896),
                         INT16_C(-23156), INT16_C(-15424), INT16_C(-13082), INT16_C( 23555)),
      simde_mm256_set_epi32(INT32_C(      28081), INT32_C(      -7416), INT32_C(      18632), INT32_C(     -28896),
                            INT32_C(     -23156), INT32_C(     -15424), INT32_C(     -13082), INT32_C(      23555)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_cvtepi16_epi32(test_vec[i].a);
    simde_assert_m256i_i32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_cvtepi16_epi64(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m128i a;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm_set_epi16(INT16_C(-31485), INT16_C(  6767), INT16_C( -1054), INT16_C(-15390),
                         INT16_C(-10897), INT16_C(-31336), INT16_C( -9551), INT16_C(  8617)),
      simde_mm256_set_epi64x(INT64_C(              -10897), INT64_C(              -31336),
                             INT64_C(               -9551), INT64_C(                8617)) },
    { simde_mm_set_epi16(INT16_C( 30988), INT16_C(  5181), INT16_C( 18938), INT16_C(-32273),
                         INT16_C(  5456), INT16_C( 19282), INT16_C(-21851), INT16_C( 27127)),
      simde_mm256_set_epi64x(INT64_C(                5456), INT64_C(               19282),
                             INT64_C(              -21851), INT64_C(               27127)) },
    { simde_mm_set_epi16(INT16_C( -7527), INT16_C(-20831), INT16_C( 23786), INT16_C(  3131),
                         INT16_C(-19886), INT16_C( -2045), INT16_C(-25062), INT16_C( -5779)),
      simde_mm256_set_epi64x(INT64_C(              -19886), INT64_C(               -2045),
                             INT64_C(              -25062), INT64_C(               -5779)) },
    { simde_mm_set_epi16(INT16_C( 31086), INT16_C( 22946), INT16_C( -1551), INT16_C(  9842),
                         INT16_C(-22586), INT16_C(  5015), INT16_C( 24465), INT16_C(-15199)),
      simde_mm256_set_epi64x(INT64_C(              -22586), INT64_C(                5015),
                             INT64_C(               24465), INT64_C(              -15199)) },
    { simde_mm_set_epi16(INT16_C( 20641), INT16_C(-16277), INT16_C( 32328), INT16_C( 21501),
                         INT16_C( 17537), INT16_C(-11745), INT16_C(-20371), INT16_C( 18200)),
      simde_mm256_set_epi64x(INT64_C(               17537), INT64_C(              -11745),
                             INT64_C(              -20371), INT64_C(               18200)) },
    { simde_mm_set_epi16(INT16_C(-26363), INT16_C(-18240), INT16_C( 21370), INT16_C(-23762),
                         INT16_C(  2610), INT16_C(  7301), INT16_C(-13295), INT16_C( 15532)),
      simde_mm256_set_epi64x(INT64_C(                2610), INT64_C(                7301),
                             INT64_C(              -13295), INT64_C(               15532)) },
    { simde_mm_set_epi16(INT16_C( -6112), INT16_C(-22921), INT16_C( -1544), INT16_C(-16225),
                         INT16_C( 14287), INT16_C(-23793), INT16_C(  5660), INT16_C(-22213)),
      simde_mm256_set_epi64x(INT64_C(               14287), INT64_C(              -23793),
                             INT64_C(                5660), INT64_C(              -22213)) },
    { simde_mm_set_epi16(INT16_C(  -130), INT16_C( -9648), INT16_C(-32446), INT16_C( 22661),
                         INT16_C( 18414), INT16_C(-28168), INT16_C( 10429), INT16_C(  9914)),
      simde_mm256_set_epi64x(INT64_C(               18414), INT64_C(              -28168),
                             INT64_C(               10429), INT64_C(                9914)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_cvtepi16_epi64(test_vec[i].a);
    simde_assert_m256i_i64(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_cvtepi32_epi64(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m128i a;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm_set_epi32(INT32_C( 2035310840), INT32_C(  817509407), INT32_C( 1530478738), INT32_C( 1934275633)),
      simde_mm256_set_epi64x(INT64_C(          2035310840), INT64_C(           817509407),
                             INT64_C(          1530478738), INT64_C(          1934275633)) },
    { simde_mm_set_epi32(INT32_C(-1872979628), INT32_C( 1510684699), INT32_C( -362741060), INT32_C(   56318596)),
      simde_mm256_set_epi64x(INT64_C(         -1872979628), INT64_C(          1510684699),
                             INT64_C(          -362741060), INT64_C(            56318596)) },
    { simde_mm_set_epi32(INT32_C(  -15196779), INT32_C(    3808236), INT32_C( -178294426), INT32_C(-1675394154)),
      simde_mm256_set_epi64x(INT64_C(           -15196779), INT64_C(             3808236),
                             INT64_C(          -178294426), INT64_C(         -1675394154)) },
    { simde_mm_set_epi32(INT32_C( 1742018933), INT32_C( -523666920), INT32_C(-1989565458), INT32_C( -138158906)),
      simde_mm256_set_epi64x(INT64_C(          1742018933), INT64_C(          -523666920),
                             INT64_C(         -1989565458), INT64_C(          -138158906)) },
    { simde_mm_set_epi32(INT32_C( -851329384), INT32_C(-2094859646), INT32_C(-1382699819), INT32_C( 2104722305)),
      simde_mm256_set_epi64x(INT64_C(          -851329384), INT64_C(         -2094859646),
                             INT64_C(         -1382699819), INT64_C(          2104722305)) },
    { simde_mm_set_epi32(INT32_C( 1596198624), INT32_C(-1923442761), INT32_C( 1335983203), INT32_C(-1180029731)),
      simde_mm256_set_epi64x(INT64_C(          1596198624), INT64_C(         -1923442761),
                             INT64_C(          1335983203), INT64_C(         -1180029731)) },
    { simde_mm_set_epi32(INT32_C(  599337487), INT32_C( 1023189876), INT32_C( 1555456525), INT32_C( -191457824)),
      simde_mm256_set_epi64x(INT64_C(           599337487), INT64_C(          1023189876),
                             INT64_C(          1555456525), INT64_C(          -191457824)) },
    { simde_mm_set_epi32(INT32_C( 2100212902), INT32_C( -853030753), INT32_C( -606897046), INT32_C(-1882381199)),
      simde_mm256_set_epi64x(INT64_C(          2100212902), INT64_C(          -853030753),
                             INT64_C(          -606897046), INT64_C(         -1882381199)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_cvtepi32_epi64(test_vec[i].a);
    simde_assert_m256i_i64(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_cvtepu8_epi16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m128i a;
    simde__m256i r;
  } test_vec[8] = {
    { simde_x_mm_set_epu8(UINT8_C(240), UINT8_C( 50), UINT8_C(144), UINT8_C(  4),
                          UINT8_C(  7), UINT8_C(233), UINT8_C(157), UINT8_C( 74),
                          UINT8_C(217), UINT8_C( 90), UINT8_C(141), UINT8_C(254),
                          UINT8_C(115), UINT8_C( 96), UINT8_C(126), UINT8_C( 23)),
      simde_mm256_set_epi16(INT16_C(   240), INT16_C(    50), INT16_C(   144), INT16_C(     4),
                            INT16_C(     7), INT16_C(   233), INT16_C(   157), INT16_C(    74),
                            INT16_C(   217), INT16_C(    90), INT16_C(   141), INT16_C(   254),
                            INT16_C(   115), INT16_C(    96), INT16_C(   126), INT16_C(    23)) },
    { simde_x_mm_set_epu8(UINT8_C( 79), UINT8_C(126), UINT8_C(254), UINT8_C( 77),
                          UINT8_C(225), UINT8_C( 76), UINT8_C( 61), UINT8_C(223),
                          UINT8_C( 95), UINT8_C(244), UINT8_C( 66), UINT8_C(  4),
                          UINT8_C(241), UINT8_C(112), UINT8_C(120), UINT8_C(166)),
      simde_mm256_set_epi16(INT16_C(    79), INT16_C(   126), INT16_C(   254), INT16_C(    77),
                            INT16_C(   225), INT16_C(    76), INT16_C(    61), INT16_C(   223),
                            INT16_C(    95), INT16_C(   244), INT16_C(    66), INT16_C(     4),
                            INT16_C(   241), INT16_C(   112), INT16_C(   120), INT16_C(   166)) },
    { simde_x_mm_set_epu8(UINT8_C( 56), UINT8_C(107), UINT8_C(114), UINT8_C( 86),
                          UINT8_C( 35), UINT8_C( 47), UINT8_C( 25), UINT8_C(187),
                          UINT8_C(176), UINT8_C( 49), UINT8_C(164), UINT8_C(236),
                          UINT8_C(110), UINT8_C( 61), UINT8_C( 64), UINT8_C( 42)),
      simde_mm256_set_epi16(INT16_C(    56), INT16_C(   107), INT16_C(   114), INT16_C(    86),
                            INT16_C(    35), INT16_C(    47), INT16_C(    25), INT16_C(   187),
                            INT16_C(   176), INT16_C(    49), INT16_C(   164), INT16_C(   236),
                            INT16_C(   110), INT16_C(    61), INT16_C(    64), INT16_C(    42)) },
    { simde_x_mm_set_epu8(UINT8_C( 54), UINT8_C(130), UINT8_C(171), UINT8_C( 76),
                          UINT8_C( 75), UINT8_C(192), UINT8_C(152), UINT8_C(247),
                          UINT8_C(165), UINT8_C(252), UINT8_C(115), UINT8_C( 73),
                          UINT8_C( 86), UINT8_C( 52), UINT8_C( 29), UINT8_C(227)),
      simde_mm256_set_epi16(INT16_C(    54), INT16_C(   130), INT16_C(   171), INT16_C(    76),
                            INT16_C(    75), INT16_C(   192), INT16_C(   152), INT16_C(   247),
                            INT16_C(   165), INT16_C(   252), INT16_C(   115), INT16_C(    73),
                            INT16_C(    86), INT16_C(    52), INT16_C(    29), INT16_C(   227)) },
    { simde_x_mm_set_epu8(UINT8_C(175), UINT8_C(214), UINT8_C(138), UINT8_C(132),
                          UINT8_C( 59), UINT8_C( 53), UINT8_C(175), UINT8_C( 98),
                          UINT8_C(195), UINT8_C(230), UINT8_C(207), UINT8_C(189),
                          UINT8_C(100), UINT8_C(255), UINT8_C( 84), UINT8_C(129)),
      simde_mm256_set_epi16(INT16_C(   175), INT16_C(   214), INT16_C(   138), INT16_C(   132),
                            INT16_C(    59), INT16_C(    53), INT16_C(   175), INT16_C(    98),
                            INT16_C(   195), INT16_C(   230), INT16_C(   207), INT16_C(   189),
                            INT16_C(   100), INT16_C(   255), INT16_C(    84), INT16_C(   129)) },
    { simde_x_mm_set_epu8(UINT8_C( 40), UINT8_C( 10), UINT8_C(243), UINT8_C( 28),
                          UINT8_C( 48), UINT8_C(231), UINT8_C(240), UINT8_C(  2),
                          UINT8_C(  1), UINT8_C( 20), UINT8_C(184), UINT8_C(244),
                          UINT8_C(174), UINT8_C(138), UINT8_C( 47), UINT8_C(122)),
      simde_mm256_set_epi16(INT16_C(    40), INT16_C(    10), INT16_C(   243), INT16_C(    28),
                            INT16_C(    48), INT16_C(   231), INT16_C(   240), INT16_C(     2),
                            INT16_C(     1), INT16_C(    20), INT16_C(   184), INT16_C(   244),
                            INT16_C(   174), INT16_C(   138), INT16_C(    47), INT16_C(   122)) },
    { simde_x_mm_set_epu8(UINT8_C( 90), UINT8_C(144), UINT8_C(116), UINT8_C( 64),
                          UINT8_C(250), UINT8_C(233), UINT8_C(185), UINT8_C(193),
                          UINT8_C(172), UINT8_C(128), UINT8_C( 92), UINT8_C(230),
                          UINT8_C(153), UINT8_C( 17), UINT8_C(  8), UINT8_C(121)),
      simde_mm256_set_epi16(INT16_C(    90), INT16_C(   144), INT16_C(   116), INT16_C(    64),
                            INT16_C(   250), INT16_C(   233), INT16_C(   185), INT16_C(   193),
                            INT16_C(   172), INT16_C(   128), INT16_C(    92), INT16_C(   230),
                            INT16_C(   153), INT16_C(    17), INT16_C(     8), INT16_C(   121)) },
    { simde_x_mm_set_epu8(UINT8_C(135), UINT8_C(132), UINT8_C(184), UINT8_C(244),
                          UINT8_C(164), UINT8_C( 94), UINT8_C(216), UINT8_C(238),
                          UINT8_C(112), UINT8_C(252), UINT8_C( 78), UINT8_C(150),
                          UINT8_C( 72), UINT8_C(215), UINT8_C(214), UINT8_C(215)),
      simde_mm256_set_epi16(INT16_C(   135), INT16_C(   132), INT16_C(   184), INT16_C(   244),
                            INT16_C(   164), INT16_C(    94), INT16_C(   216), INT16_C(   238),
                            INT16_C(   112), INT16_C(   252), INT16_C(    78), INT16_C(   150),
                            INT16_C(    72), INT16_C(   215), INT16_C(   214), INT16_C(   215)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_cvtepu8_epi16(test_vec[i].a);
    simde_assert_m256i_i16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_cvtepu8_epi32(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m128i a;
    simde__m256i r;
  } test_vec[8] = {
    { simde_x_mm_set_epu8(UINT8_C(240), UINT8_C( 50), UINT8_C(144), UINT8_C(  4),
                          UINT8_C(  7), UINT8_C(233), UINT8_C(157), UINT8_C( 74),
                          UINT8_C(217), UINT8_C( 90), UINT8_C(141), UINT8_C(254),
                          UINT8_C(115), UINT8_C( 96), UINT8_C(126), UINT8_C( 23)),
      simde_mm256_set_epi32(INT32_C(        217), INT32_C(         90), INT32_C(        141), INT32_C(        254),
                            INT32_C(        115), INT32_C(         96), INT32_C(        126), INT32_C(         23)) },
    { simde_x_mm_set_epu8(UINT8_C( 79), UINT8_C(126), UINT8_C(254), UINT8_C( 77),
                          UINT8_C(225), UINT8_C( 76), UINT8_C( 61), UINT8_C(223),
                          UINT8_C( 95), UINT8_C(244), UINT8_C( 66), UINT8_C(  4),
                          UINT8_C(241), UINT8_C(112), UINT8_C(120), UINT8_C(166)),
      simde_mm256_set_epi32(INT32_C(         95), INT32_C(        244), INT32_C(         66), INT32_C(          4),
                            INT32_C(        241), INT32_C(        112), INT32_C(        120), INT32_C(        166)) },
    { simde_x_mm_set_epu8(UINT8_C( 56), UINT8_C(107), UINT8_C(114), UINT8_C( 86),
                          UINT8_C( 35), UINT8_C( 47), UINT8_C( 25), UINT8_C(187),
                          UINT8_C(176), UINT8_C( 49), UINT8_C(164), UINT8_C(236),
                          UINT8_C(110), UINT8_C( 61), UINT8_C( 64), UINT8_C( 42)),
      simde_mm256_set_epi32(INT32_C(        176), INT32_C(         49), INT32_C(        164), INT32_C(        236),
                            INT32_C(        110), INT32_C(         61), INT32_C(         64), INT32_C(         42)) },
    { simde_x_mm_set_epu8(UINT8_C( 54), UINT8_C(130), UINT8_C(171), UINT8_C( 76),
                          UINT8_C( 75), UINT8_C(192), UINT8_C(152), UINT8_C(247),
                          UINT8_C(165), UINT8_C(252), UINT8_C(115), UINT8_C( 73),
                          UINT8_C( 86), UINT8_C( 52), UINT8_C( 29), UINT8_C(227)),
      simde_mm256_set_epi32(INT32_C(        165), INT32_C(        252), INT32_C(        115), INT32_C(         73),
                            INT32_C(         86), INT32_C(         52), INT32_C(         29), INT32_C(        227)) },
    { simde_x_mm_set_epu8(UINT8_C(175), UINT8_C(214), UINT8_C(138), UINT8_C(132),
                          UINT8_C( 59), UINT8_C( 53), UINT8_C(175), UINT8_C( 98),
                          UINT8_C(195), UINT8_C(230), UINT8_C(207), UINT8_C(189),
                          UINT8_C(100), UINT8_C(255), UINT8_C( 84), UINT8_C(129)),
      simde_mm256_set_epi32(INT32_C(        195), INT32_C(        230), INT32_C(        207), INT32_C(        189),
                            INT32_C(        100), INT32_C(        255), INT32_C(         84), INT32_C(        129)) },
    { simde_x_mm_set_epu8(UINT8_C( 40), UINT8_C( 10), UINT8_C(243), UINT8_C( 28),
                          UINT8_C( 48), UINT8_C(231), UINT8_C(240), UINT8_C(  2),
                          UINT8_C(  1), UINT8_C( 20), UINT8_C(184), UINT8_C(244),
                          UINT8_C(174), UINT8_C(138), UINT8_C( 47), UINT8_C(122)),
      simde_mm256_set_epi32(INT32_C(          1), INT32_C(         20), INT32_C(        184), INT32_C(        244),
                            INT32_C(        174), INT32_C(        138), INT32_C(         47), INT32_C(        122)) },
    { simde_x_mm_set_epu8(UINT8_C( 90), UINT8_C(144), UINT8_C(116), UINT8_C( 64),
                          UINT8_C(250), UINT8_C(233), UINT8_C(185), UINT8_C(193),
                          UINT8_C(172), UINT8_C(128), UINT8_C( 92), UINT8_C(230),
                          UINT8_C(153), UINT8_C( 17), UINT8_C(  8), UINT8_C(121)),
      simde_mm256_set_epi32(INT32_C(        172), INT32_C(        128), INT32_C(         92), INT32_C(        230),
                            INT32_C(        153), INT32_C(         17), INT32_C(          8), INT32_C(        121)) },
    { simde_x_mm_set_epu8(UINT8_C(135), UINT8_C(132), UINT8_C(184), UINT8_C(244),
                          UINT8_C(164), UINT8_C( 94), UINT8_C(216), UINT8_C(238),
                          UINT8_C(112), UINT8_C(252), UINT8_C( 78), UINT8_C(150),
                          UINT8_C( 72), UINT8_C(215), UINT8_C(214), UINT8_C(215)),
      simde_mm256_set_epi32(INT32_C(        112), INT32_C(        252), INT32_C(         78), INT32_C(        150),
                            INT32_C(         72), INT32_C(        215), INT32_C(        214), INT32_C(        215)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_cvtepu8_epi32(test_vec[i].a);
    simde_assert_m256i_i32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_cvtepu8_epi64(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m128i a;
    simde__m256i r;
  } test_vec[8] = {
    { simde_x_mm_set_epu8(UINT8_C(  9), UINT8_C(182), UINT8_C(204), UINT8_C(188),
                          UINT8_C( 95), UINT8_C(246), UINT8_C(157), UINT8_C(121),
                          UINT8_C(  1), UINT8_C( 69), UINT8_C(220), UINT8_C(154),
                          UINT8_C(132), UINT8_C(163), UINT8_C(155), UINT8_C(138)),
      simde_mm256_set_epi64x(INT64_C(                 132), INT64_C(                 163),
                             INT64_C(                 155), INT64_C(                 138)) },
    { simde_x_mm_set_epu8(UINT8_C(149), UINT8_C(222), UINT8_C(181), UINT8_C(119),
                          UINT8_C(177), UINT8_C(153), UINT8_C(247), UINT8_C(135),
                          UINT8_C(205), UINT8_C(  4), UINT8_C( 89), UINT8_C(110),
                          UINT8_C(112), UINT8_C( 67), UINT8_C(155), UINT8_C( 87)),
      simde_mm256_set_epi64x(INT64_C(                 112), INT64_C(                  67),
                             INT64_C(                 155), INT64_C(                  87)) },
    { simde_x_mm_set_epu8(UINT8_C(171), UINT8_C(121), UINT8_C(140), UINT8_C(121),
                          UINT8_C(213), UINT8_C(176), UINT8_C(  1), UINT8_C(154),
                          UINT8_C( 39), UINT8_C(151), UINT8_C(230), UINT8_C( 88),
                          UINT8_C(204), UINT8_C( 61), UINT8_C(129), UINT8_C( 21)),
      simde_mm256_set_epi64x(INT64_C(                 204), INT64_C(                  61),
                             INT64_C(                 129), INT64_C(                  21)) },
    { simde_x_mm_set_epu8(UINT8_C( 85), UINT8_C(  1), UINT8_C( 94), UINT8_C( 60),
                          UINT8_C(102), UINT8_C(  9), UINT8_C(200), UINT8_C( 64),
                          UINT8_C(153), UINT8_C(170), UINT8_C( 51), UINT8_C(130),
                          UINT8_C(247), UINT8_C( 88), UINT8_C(204), UINT8_C( 13)),
      simde_mm256_set_epi64x(INT64_C(                 247), INT64_C(                  88),
                             INT64_C(                 204), INT64_C(                  13)) },
    { simde_x_mm_set_epu8(UINT8_C(  0), UINT8_C(216), UINT8_C( 42), UINT8_C( 42),
                          UINT8_C(109), UINT8_C(251), UINT8_C(228), UINT8_C(176),
                          UINT8_C( 70), UINT8_C(  6), UINT8_C(205), UINT8_C( 17),
                          UINT8_C(151), UINT8_C(148), UINT8_C( 14), UINT8_C(165)),
      simde_mm256_set_epi64x(INT64_C(                 151), INT64_C(                 148),
                             INT64_C(                  14), INT64_C(                 165)) },
    { simde_x_mm_set_epu8(UINT8_C(125), UINT8_C(142), UINT8_C(217), UINT8_C(138),
                          UINT8_C( 29), UINT8_C(175), UINT8_C(135), UINT8_C(115),
                          UINT8_C(128), UINT8_C( 99), UINT8_C( 64), UINT8_C(  7),
                          UINT8_C(114), UINT8_C(155), UINT8_C(129), UINT8_C( 30)),
      simde_mm256_set_epi64x(INT64_C(                 114), INT64_C(                 155),
                             INT64_C(                 129), INT64_C(                  30)) },
    { simde_x_mm_set_epu8(UINT8_C(130), UINT8_C(122), UINT8_C( 50), UINT8_C(115),
                          UINT8_C( 72), UINT8_C(200), UINT8_C( 52), UINT8_C(125),
                          UINT8_C(152), UINT8_C(180), UINT8_C( 65), UINT8_C(103),
                          UINT8_C(134), UINT8_C(220), UINT8_C(163), UINT8_C(110)),
      simde_mm256_set_epi64x(INT64_C(                 134), INT64_C(                 220),
                             INT64_C(                 163), INT64_C(                 110)) },
    { simde_x_mm_set_epu8(UINT8_C(176), UINT8_C( 98), UINT8_C(137), UINT8_C( 51),
                          UINT8_C(219), UINT8_C(239), UINT8_C(162), UINT8_C(134),
                          UINT8_C(142), UINT8_C( 13), UINT8_C(181), UINT8_C(111),
                          UINT8_C(180), UINT8_C(241), UINT8_C(255), UINT8_C(244)),
      simde_mm256_set_epi64x(INT64_C(                 180), INT64_C(                 241),
                             INT64_C(                 255), INT64_C(                 244)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_cvtepu8_epi64(test_vec[i].a);
    simde_assert_m256i_i64(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_cvtepu16_epi32(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m128i a;
    simde__m256i r;
  } test_vec[8] = {
    { simde_x_mm_set_epu16(UINT16_C(61490), UINT16_C(36868), UINT16_C( 2025), UINT16_C(40266),
                           UINT16_C(55642), UINT16_C(36350), UINT16_C(29536), UINT16_C(32279)),
      simde_mm256_set_epi32(INT32_C(      61490), INT32_C(      36868), INT32_C(       2025), INT32_C(      40266),
                            INT32_C(      55642), INT32_C(      36350), INT32_C(      29536), INT32_C(      32279)) },
    { simde_x_mm_set_epu16(UINT16_C(20350), UINT16_C(65101), UINT16_C(57676), UINT16_C(15839),
                           UINT16_C(24564), UINT16_C(16900), UINT16_C(61808), UINT16_C(30886)),
      simde_mm256_set_epi32(INT32_C(      20350), INT32_C(      65101), INT32_C(      57676), INT32_C(      15839),
                            INT32_C(      24564), INT32_C(      16900), INT32_C(      61808), INT32_C(      30886)) },
    { simde_x_mm_set_epu16(UINT16_C(14443), UINT16_C(29270), UINT16_C( 9007), UINT16_C( 6587),
                           UINT16_C(45105), UINT16_C(42220), UINT16_C(28221), UINT16_C(16426)),
      simde_mm256_set_epi32(INT32_C(      14443), INT32_C(      29270), INT32_C(       9007), INT32_C(       6587),
                            INT32_C(      45105), INT32_C(      42220), INT32_C(      28221), INT32_C(      16426)) },
    { simde_x_mm_set_epu16(UINT16_C(13954), UINT16_C(43852), UINT16_C(19392), UINT16_C(39159),
                           UINT16_C(42492), UINT16_C(29513), UINT16_C(22068), UINT16_C( 7651)),
      simde_mm256_set_epi32(INT32_C(      13954), INT32_C(      43852), INT32_C(      19392), INT32_C(      39159),
                            INT32_C(      42492), INT32_C(      29513), INT32_C(      22068), INT32_C(       7651)) },
    { simde_x_mm_set_epu16(UINT16_C(45014), UINT16_C(35460), UINT16_C(15157), UINT16_C(44898),
                           UINT16_C(50150), UINT16_C(53181), UINT16_C(25855), UINT16_C(21633)),
      simde_mm256_set_epi32(INT32_C(      45014), INT32_C(      35460), INT32_C(      15157), INT32_C(      44898),
                            INT32_C(      50150), INT32_C(      53181), INT32_C(      25855), INT32_C(      21633)) },
    { simde_x_mm_set_epu16(UINT16_C(10250), UINT16_C(62236), UINT16_C(12519), UINT16_C(61442),
                           UINT16_C(  276), UINT16_C(47348), UINT16_C(44682), UINT16_C(12154)),
      simde_mm256_set_epi32(INT32_C(      10250), INT32_C(      62236), INT32_C(      12519), INT32_C(      61442),
                            INT32_C(        276), INT32_C(      47348), INT32_C(      44682), INT32_C(      12154)) },
    { simde_x_mm_set_epu16(UINT16_C(23184), UINT16_C(29760), UINT16_C(64233), UINT16_C(47553),
                           UINT16_C(44160), UINT16_C(23782), UINT16_C(39185), UINT16_C( 2169)),
      simde_mm256_set_epi32(INT32_C(      23184), INT32_C(      29760), INT32_C(      64233), INT32_C(      47553),
                            INT32_C(      44160), INT32_C(      23782), INT32_C(      39185), INT32_C(       2169)) },
    { simde_x_mm_set_epu16(UINT16_C(34692), UINT16_C(47348), UINT16_C(42078), UINT16_C(55534),
                           UINT16_C(28924), UINT16_C(20118), UINT16_C(18647), UINT16_C(54999)),
      simde_mm256_set_epi32(INT32_C(      34692), INT32_C(      47348), INT32_C(      42078), INT32_C(      55534),
                            INT32_C(      28924), INT32_C(      20118), INT32_C(      18647), INT32_C(      54999)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_cvtepu16_epi32(test_vec[i].a);
    simde_assert_m256i_i32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_cvtepu16_epi64(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m128i a;
    simde__m256i r;
  } test_vec[8] = {
    { simde_x_mm_set_epu16(UINT16_C(61490), UINT16_C(36868), UINT16_C( 2025), UINT16_C(40266),
                           UINT16_C(55642), UINT16_C(36350), UINT16_C(29536), UINT16_C(32279)),
      simde_mm256_set_epi64x(INT64_C(               55642), INT64_C(               36350),
                             INT64_C(               29536), INT64_C(               32279)) },
    { simde_x_mm_set_epu16(UINT16_C(20350), UINT16_C(65101), UINT16_C(57676), UINT16_C(15839),
                           UINT16_C(24564), UINT16_C(16900), UINT16_C(61808), UINT16_C(30886)),
      simde_mm256_set_epi64x(INT64_C(               24564), INT64_C(               16900),
                             INT64_C(               61808), INT64_C(               30886)) },
    { simde_x_mm_set_epu16(UINT16_C(14443), UINT16_C(29270), UINT16_C( 9007), UINT16_C( 6587),
                           UINT16_C(45105), UINT16_C(42220), UINT16_C(28221), UINT16_C(16426)),
      simde_mm256_set_epi64x(INT64_C(               45105), INT64_C(               42220),
                             INT64_C(               28221), INT64_C(               16426)) },
    { simde_x_mm_set_epu16(UINT16_C(13954), UINT16_C(43852), UINT16_C(19392), UINT16_C(39159),
                           UINT16_C(42492), UINT16_C(29513), UINT16_C(22068), UINT16_C( 7651)),
      simde_mm256_set_epi64x(INT64_C(               42492), INT64_C(               29513),
                             INT64_C(               22068), INT64_C(                7651)) },
    { simde_x_mm_set_epu16(UINT16_C(45014), UINT16_C(35460), UINT16_C(15157), UINT16_C(44898),
                           UINT16_C(50150), UINT16_C(53181), UINT16_C(25855), UINT16_C(21633)),
      simde_mm256_set_epi64x(INT64_C(               50150), INT64_C(               53181),
                             INT64_C(               25855), INT64_C(               21633)) },
    { simde_x_mm_set_epu16(UINT16_C(10250), UINT16_C(62236), UINT16_C(12519), UINT16_C(61442),
                           UINT16_C(  276), UINT16_C(47348), UINT16_C(44682), UINT16_C(12154)),
      simde_mm256_set_epi64x(INT64_C(                 276), INT64_C(               47348),
                             INT64_C(               44682), INT64_C(               12154)) },
    { simde_x_mm_set_epu16(UINT16_C(23184), UINT16_C(29760), UINT16_C(64233), UINT16_C(47553),
                           UINT16_C(44160), UINT16_C(23782), UINT16_C(39185), UINT16_C( 2169)),
      simde_mm256_set_epi64x(INT64_C(               44160), INT64_C(               23782),
                             INT64_C(               39185), INT64_C(                2169)) },
    { simde_x_mm_set_epu16(UINT16_C(34692), UINT16_C(47348), UINT16_C(42078), UINT16_C(55534),
                           UINT16_C(28924), UINT16_C(20118), UINT16_C(18647), UINT16_C(54999)),
      simde_mm256_set_epi64x(INT64_C(               28924), INT64_C(               20118),
                             INT64_C(               18647), INT64_C(               54999)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_cvtepu16_epi64(test_vec[i].a);
    simde_assert_m256i_i64(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_cvtepu32_epi64(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m128i a;
    simde__m256i r;
  } test_vec[8] = {
    { simde_x_mm_set_epu32(UINT32_C(2027668512), UINT32_C(4262540660), UINT32_C(2279720356), UINT32_C( 579063940)),
      simde_mm256_set_epi64x(INT64_C(          2027668512), INT64_C(          4262540660),
                             INT64_C(          2279720356), INT64_C(           579063940)) },
    { simde_x_mm_set_epu32(UINT32_C( 214101781), UINT32_C(2515026933), UINT32_C(  10021235), UINT32_C(4284419101)),
      simde_mm256_set_epi64x(INT64_C(           214101781), INT64_C(          2515026933),
                             INT64_C(            10021235), INT64_C(          4284419101)) },
    { simde_x_mm_set_epu32(UINT32_C(2492492584), UINT32_C(1475674737), UINT32_C( 145233694), UINT32_C(2838555915)),
      simde_mm256_set_epi64x(INT64_C(          2492492584), INT64_C(          1475674737),
                             INT64_C(           145233694), INT64_C(          2838555915)) },
    { simde_x_mm_set_epu32(UINT32_C(3488754722), UINT32_C(2142666247), UINT32_C(4044693026), UINT32_C( 975481583)),
      simde_mm256_set_epi64x(INT64_C(          3488754722), INT64_C(          2142666247),
                             INT64_C(          4044693026), INT64_C(           975481583)) },
    { simde_x_mm_set_epu32(UINT32_C(3942926803), UINT32_C(  10053147), UINT32_C(3324554936), UINT32_C( 275092283)),
      simde_mm256_set_epi64x(INT64_C(          3942926803), INT64_C(            10053147),
                             INT64_C(          3324554936), INT64_C(           275092283)) },
    { simde_x_mm_set_epu32(UINT32_C( 609927901), UINT32_C(4032952140), UINT32_C(2163741382), UINT32_C(1197307836)),
      simde_mm256_set_epi64x(INT64_C(           609927901), INT64_C(          4032952140),
                             INT64_C(          2163741382), INT64_C(          1197307836)) },
    { simde_x_mm_set_epu32(UINT32_C( 667494753), UINT32_C(  25338810), UINT32_C( 229628292), UINT32_C(1413771580)),
      simde_mm256_set_epi64x(INT64_C(           667494753), INT64_C(            25338810),
                             INT64_C(           229628292), INT64_C(          1413771580)) },
    { simde_x_mm_set_epu32(UINT32_C(3461166204), UINT32_C(2882591041), UINT32_C(4038947223), UINT32_C(3672325978)),
      simde_mm256_set_epi64x(INT64_C(          3461166204), INT64_C(          2882591041),
                             INT64_C(          4038947223), INT64_C(          3672325978)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_cvtepu32_epi64(test_vec[i].a);
    simde_assert_m256i_i64(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_extract_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  simde__m256i a;

  a = simde_mm256_set_epi8(INT8_C( 109), INT8_C( -15), INT8_C(  -7), INT8_C(  79),
                           INT8_C(  63), INT8_C(  13), INT8_C(  55), INT8_C(  74),
                           INT8_C( -46), INT8_C( 126), INT8_C(-104), INT8_C(  83),
                           INT8_C( -94), INT8_C(  46), INT8_C( -10), INT8_C( -51),
                           INT8_C( -63), INT8_C(   8), INT8_C(  47), INT8_C( 108),
                           INT8_C(  38), INT8_C( -24), INT8_C( -54), INT8_C(  83),
                           INT8_C(  41), INT8_C(  48), INT8_C(-118), INT8_C(  66),
                           INT8_C( -73), INT8_C( 110), INT8_C(  47), INT8_C(  78));
  munit_assert_int8(HEDLEY_STATIC_CAST(int8_t, simde_mm256_extract_epi8(a,  1)), ==, INT8_C(  47));

  a = simde_mm256_set_epi8(INT8_C(   9), INT8_C(  60), INT8_C( -76), INT8_C(  57),
                           INT8_C( 106), INT8_C( -35), INT8_C( -51), INT8_C(  33),
                           INT8_C(-119), INT8_C(  27), INT8_C(-103), INT8_C( -96),
                           INT8_C( 114), INT8_C(   4), INT8_C( -76), INT8_C( -65),
                           INT8_C( 105), INT8_C( -42), INT8_C(  71), INT8_C(  12),
                           INT8_C(-113), INT8_C(  32), INT8_C(-107), INT8_C( -55),
                           INT8_C(  87), INT8_C(  74), INT8_C(  33), INT8_C(  32),
                           INT8_C( -83), INT8_C( -97), INT8_C(  40), INT8_C(-118));
  munit_assert_int8(HEDLEY_STATIC_CAST(int8_t, simde_mm256_extract_epi8(a, 12)), ==, INT8_C(  12));

  a = simde_mm256_set_epi8(INT8_C(  53), INT8_C( -56), INT8_C( -74), INT8_C(  14),
                           INT8_C(  84), INT8_C(  78), INT8_C(  58), INT8_C(  56),
                           INT8_C(-126), INT8_C(  20), INT8_C(  56), INT8_C(  20),
                           INT8_C(   6), INT8_C( 127), INT8_C( 111), INT8_C(-117),
                           INT8_C( -66), INT8_C(-101), INT8_C(  45), INT8_C(   7),
                           INT8_C(-108), INT8_C( 110), INT8_C( -80), INT8_C( -37),
                           INT8_C( -87), INT8_C( -76), INT8_C( -93), INT8_C( -39),
                           INT8_C(   5), INT8_C(  40), INT8_C( 106), INT8_C( -44));
  munit_assert_int8(HEDLEY_STATIC_CAST(int8_t, simde_mm256_extract_epi8(a,  2)), ==, INT8_C(  40));

  a = simde_mm256_set_epi8(INT8_C( -54), INT8_C( -60), INT8_C(   8), INT8_C(-114),
                           INT8_C( -71), INT8_C(  78), INT8_C( -79), INT8_C(  48),
                           INT8_C( 112), INT8_C( 109), INT8_C(  51), INT8_C( -46),
                           INT8_C( -65), INT8_C( -24), INT8_C(  81), INT8_C(  65),
                           INT8_C(  88), INT8_C(  30), INT8_C( -69), INT8_C( -54),
                           INT8_C(  87), INT8_C( 123), INT8_C( 124), INT8_C( -89),
                           INT8_C(  14), INT8_C( -48), INT8_C(  73), INT8_C(  34),
                           INT8_C( -22), INT8_C( -74), INT8_C(   4), INT8_C( -22));
  munit_assert_int8(HEDLEY_STATIC_CAST(int8_t, simde_mm256_extract_epi8(a,  1)), ==, INT8_C(   4));

  a = simde_mm256_set_epi8(INT8_C( -34), INT8_C(  20), INT8_C(  68), INT8_C( -53),
                           INT8_C(  24), INT8_C( -70), INT8_C( -82), INT8_C(  20),
                           INT8_C(-104), INT8_C( -97), INT8_C( 126), INT8_C(-128),
                           INT8_C( 102), INT8_C( -37), INT8_C( -20), INT8_C(  -7),
                           INT8_C( -78), INT8_C( 110), INT8_C( -59), INT8_C(  89),
                           INT8_C( -18), INT8_C( -26), INT8_C( -89), INT8_C(  39),
                           INT8_C( -79), INT8_C( 100), INT8_C( -39), INT8_C(  76),
                           INT8_C( -51), INT8_C( -31), INT8_C(  26), INT8_C( -70));
  munit_assert_int8(HEDLEY_STATIC_CAST(int8_t, simde_mm256_extract_epi8(a, 27)), ==, INT8_C(  24));

  a = simde_mm256_set_epi8(INT8_C( -85), INT8_C( -44), INT8_C( 101), INT8_C( 109),
                           INT8_C(  58), INT8_C(  71), INT8_C(  75), INT8_C(  93),
                           INT8_C( -37), INT8_C(  91), INT8_C(   6), INT8_C(  95),
                           INT8_C( -47), INT8_C( 107), INT8_C( 114), INT8_C( -12),
                           INT8_C(  86), INT8_C(  23), INT8_C( -82), INT8_C(  84),
                           INT8_C( -80), INT8_C( -54), INT8_C(-107), INT8_C( -58),
                           INT8_C( -42), INT8_C( -79), INT8_C(  59), INT8_C( -50),
                           INT8_C(  63), INT8_C(-125), INT8_C( -96), INT8_C( -58));
  munit_assert_int8(HEDLEY_STATIC_CAST(int8_t, simde_mm256_extract_epi8(a, 11)), ==, INT8_C( -80));

  a = simde_mm256_set_epi8(INT8_C(  71), INT8_C(  18), INT8_C(  82), INT8_C( -74),
                           INT8_C(   9), INT8_C(  -6), INT8_C( -94), INT8_C( -46),
                           INT8_C(  17), INT8_C(  25), INT8_C( -11), INT8_C(-128),
                           INT8_C(-116), INT8_C(  77), INT8_C(  76), INT8_C(   8),
                           INT8_C(  80), INT8_C( -50), INT8_C(  11), INT8_C(  10),
                           INT8_C( 107), INT8_C( -99), INT8_C(  37), INT8_C(   5),
                           INT8_C( 107), INT8_C(-118), INT8_C( 119), INT8_C( -11),
                           INT8_C(  84), INT8_C(   8), INT8_C(  15), INT8_C(-102));
  munit_assert_int8(HEDLEY_STATIC_CAST(int8_t, simde_mm256_extract_epi8(a,  9)), ==, INT8_C(  37));

  a = simde_mm256_set_epi8(INT8_C(  84), INT8_C(-100), INT8_C( 116), INT8_C( -53),
                           INT8_C(-104), INT8_C(  52), INT8_C(  51), INT8_C(  60),
                           INT8_C(  91), INT8_C( 114), INT8_C(-106), INT8_C( -11),
                           INT8_C(  83), INT8_C(  57), INT8_C(   4), INT8_C(-120),
                           INT8_C(  77), INT8_C(  71), INT8_C(   1), INT8_C(  95),
                           INT8_C(  23), INT8_C(  89), INT8_C( 112), INT8_C(  -7),
                           INT8_C( -66), INT8_C(  78), INT8_C(  88), INT8_C(   5),
                           INT8_C(  75), INT8_C(  72), INT8_C( -87), INT8_C(  47));
  munit_assert_int8(HEDLEY_STATIC_CAST(int8_t, simde_mm256_extract_epi8(a, 27)), ==, INT8_C(-104));

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_extract_epi16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  simde__m256i a;

  a = simde_mm256_set_epi16(INT16_C( -9152), INT16_C(-17321), INT16_C( -3541), INT16_C( 31629),
                            INT16_C(  4310), INT16_C(-20495), INT16_C(-28807), INT16_C(-17056),
                            INT16_C(-19221), INT16_C( 32236), INT16_C(-26695), INT16_C( -3004),
                            INT16_C( -4570), INT16_C(-14787), INT16_C(  7635), INT16_C(-23471));
  munit_assert_int16(HEDLEY_STATIC_CAST(int16_t, simde_mm256_extract_epi16(a,  4)), ==, INT16_C( -3004));

  a = simde_mm256_set_epi16(INT16_C( 10010), INT16_C(  6255), INT16_C(-20985), INT16_C( 25937),
                            INT16_C(   187), INT16_C(-14746), INT16_C(  4260), INT16_C( -5314),
                            INT16_C( 21499), INT16_C(-10726), INT16_C(-28550), INT16_C(-26957),
                            INT16_C( 25383), INT16_C(-32368), INT16_C(-28215), INT16_C(-29614));
  munit_assert_int16(HEDLEY_STATIC_CAST(int16_t, simde_mm256_extract_epi16(a,  3)), ==, INT16_C( 25383));

  a = simde_mm256_set_epi16(INT16_C( -9332), INT16_C( -3776), INT16_C(  -659), INT16_C(-11998),
                            INT16_C(-22530), INT16_C( 30025), INT16_C( -7620), INT16_C( -4652),
                            INT16_C( 12144), INT16_C(  2985), INT16_C(-29351), INT16_C(  7652),
                            INT16_C( 29358), INT16_C( -2482), INT16_C(  2031), INT16_C(-18027));
  munit_assert_int16(HEDLEY_STATIC_CAST(int16_t, simde_mm256_extract_epi16(a, 12)), ==, INT16_C(-11998));

  a = simde_mm256_set_epi16(INT16_C(  5566), INT16_C( 26716), INT16_C(-28005), INT16_C(-20328),
                            INT16_C(-22447), INT16_C(-29429), INT16_C( 18844), INT16_C(-28207),
                            INT16_C( 13304), INT16_C( 29506), INT16_C( 26640), INT16_C(-30988),
                            INT16_C(  7094), INT16_C( 15837), INT16_C( 17850), INT16_C( -4007));
  munit_assert_int16(HEDLEY_STATIC_CAST(int16_t, simde_mm256_extract_epi16(a,  8)), ==, INT16_C(-28207));

  a = simde_mm256_set_epi16(INT16_C(-22807), INT16_C( 19457), INT16_C(-27368), INT16_C(-30791),
                            INT16_C( -9280), INT16_C(-12893), INT16_C(-14741), INT16_C( -5696),
                            INT16_C(  4897), INT16_C( 24376), INT16_C(-27876), INT16_C( 29206),
                            INT16_C(-29469), INT16_C(-22113), INT16_C( 23067), INT16_C(  6063));
  munit_assert_int16(HEDLEY_STATIC_CAST(int16_t, simde_mm256_extract_epi16(a,  3)), ==, INT16_C(-29469));

  a = simde_mm256_set_epi16(INT16_C( -6124), INT16_C(  1398), INT16_C(   383), INT16_C(  1785),
                            INT16_C(-30725), INT16_C(-20290), INT16_C( 11961), INT16_C(-25919),
                            INT16_C(-25742), INT16_C(-31321), INT16_C( -6067), INT16_C( 17059),
                            INT16_C( 16943), INT16_C( 31917), INT16_C( 18056), INT16_C(-23274));
  munit_assert_int16(HEDLEY_STATIC_CAST(int16_t, simde_mm256_extract_epi16(a,  7)), ==, INT16_C(-25742));

  a = simde_mm256_set_epi16(INT16_C( 29739), INT16_C(-15442), INT16_C(-18760), INT16_C(  3107),
                            INT16_C(-25745), INT16_C(    -8), INT16_C( -5543), INT16_C(  3310),
                            INT16_C( 13765), INT16_C(-29431), INT16_C( 31912), INT16_C( 20910),
                            INT16_C(-32282), INT16_C(  8881), INT16_C(-19453), INT16_C(-25360));
  munit_assert_int16(HEDLEY_STATIC_CAST(int16_t, simde_mm256_extract_epi16(a,  0)), ==, INT16_C(-25360));

  a = simde_mm256_set_epi16(INT16_C( 19041), INT16_C( 28526), INT16_C(   632), INT16_C( 12890),
                            INT16_C( -9054), INT16_C(  9044), INT16_C(-24624), INT16_C(-18390),
                            INT16_C( -7692), INT16_C( 20879), INT16_C(  2760), INT16_C( 29306),
                            INT16_C(  5480), INT16_C( 22577), INT16_C(-15668), INT16_C(-16497));
  munit_assert_int16(HEDLEY_STATIC_CAST(int16_t, simde_mm256_extract_epi16(a,  0)), ==, INT16_C(-16497));

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_extracti128_si256(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m128i ra;
    simde__m128i rb;
  } test_vec[8] = {
    { simde_mm256_set_epi32(INT32_C( 1229394801), INT32_C(  992221618), INT32_C(-1388107406), INT32_C(  780445625),
                            INT32_C( 1795700153), INT32_C( -297324271), INT32_C( 1549329146), INT32_C( -534963225)),
      simde_mm256_set_epi32(INT32_C( -867719772), INT32_C(-1804212438), INT32_C( 1849818353), INT32_C(  405560893),
                            INT32_C( 1351338386), INT32_C( -886724662), INT32_C( 1197680760), INT32_C( 1003042592)),
      simde_mm_set_epi32(INT32_C( 1795700153), INT32_C( -297324271), INT32_C( 1549329146), INT32_C( -534963225)),
      simde_mm_set_epi32(INT32_C( 1229394801), INT32_C(  992221618), INT32_C(-1388107406), INT32_C(  780445625)) },
    { simde_mm256_set_epi32(INT32_C( 1839397279), INT32_C( -585358334), INT32_C(  779178160), INT32_C( -362976984),
                            INT32_C(-1015866216), INT32_C( -556342867), INT32_C( -766379029), INT32_C( -130781639)),
      simde_mm256_set_epi32(INT32_C( 2021215895), INT32_C( -422044488), INT32_C(-1385706777), INT32_C(   22702781),
                            INT32_C( 1076807274), INT32_C(-1923875401), INT32_C( -554846936), INT32_C(-1008226174)),
      simde_mm_set_epi32(INT32_C(-1015866216), INT32_C( -556342867), INT32_C( -766379029), INT32_C( -130781639)),
      simde_mm_set_epi32(INT32_C( 1839397279), INT32_C( -585358334), INT32_C(  779178160), INT32_C( -362976984)) },
    { simde_mm256_set_epi32(INT32_C(   23865749), INT32_C( -908972624), INT32_C(-1642418179), INT32_C(  111689864),
                            INT32_C( -835154412), INT32_C( -431540196), INT32_C( -161564683), INT32_C(  204589457)),
      simde_mm256_set_epi32(INT32_C( 2088662618), INT32_C(-1671363325), INT32_C( -997695043), INT32_C( -809764814),
                            INT32_C( 2092581708), INT32_C(-1073689737), INT32_C(-1556963227), INT32_C( -641330488)),
      simde_mm_set_epi32(INT32_C( -835154412), INT32_C( -431540196), INT32_C( -161564683), INT32_C(  204589457)),
      simde_mm_set_epi32(INT32_C(   23865749), INT32_C( -908972624), INT32_C(-1642418179), INT32_C(  111689864)) },
    { simde_mm256_set_epi32(INT32_C( 1727711569), INT32_C(-1915329589), INT32_C( -979233658), INT32_C( -409203179),
                            INT32_C( 1343207861), INT32_C(-1541174422), INT32_C(-2097250480), INT32_C(-1382492089)),
      simde_mm256_set_epi32(INT32_C(  -42175512), INT32_C(-2146588690), INT32_C(-1902868938), INT32_C( 1919945739),
                            INT32_C(  410749235), INT32_C(-1828962645), INT32_C(  525862553), INT32_C( -282512400)),
      simde_mm_set_epi32(INT32_C( 1343207861), INT32_C(-1541174422), INT32_C(-2097250480), INT32_C(-1382492089)),
      simde_mm_set_epi32(INT32_C( 1727711569), INT32_C(-1915329589), INT32_C( -979233658), INT32_C( -409203179)) },
    { simde_mm256_set_epi32(INT32_C(  377369527), INT32_C( 1159197718), INT32_C(  288677560), INT32_C(  828517622),
                            INT32_C( 1815109517), INT32_C( 1103735854), INT32_C( 1342116414), INT32_C( 1750949195)),
      simde_mm256_set_epi32(INT32_C( 1481955155), INT32_C( -119794855), INT32_C(-2109995042), INT32_C(  582656481),
                            INT32_C( 1178951500), INT32_C(  762286037), INT32_C(  628377158), INT32_C( -188026020)),
      simde_mm_set_epi32(INT32_C( 1815109517), INT32_C( 1103735854), INT32_C( 1342116414), INT32_C( 1750949195)),
      simde_mm_set_epi32(INT32_C(  377369527), INT32_C( 1159197718), INT32_C(  288677560), INT32_C(  828517622)) },
    { simde_mm256_set_epi32(INT32_C(-1996051424), INT32_C( -314294760), INT32_C( -770521150), INT32_C(  508113145),
                            INT32_C( -677093043), INT32_C( -527636644), INT32_C( 1238565466), INT32_C(-1592387355)),
      simde_mm256_set_epi32(INT32_C(-1510707643), INT32_C( 1988531398), INT32_C(-1182276921), INT32_C(  363503044),
                            INT32_C( 2086268932), INT32_C( -428647595), INT32_C( 1685321543), INT32_C( 1979089365)),
      simde_mm_set_epi32(INT32_C( -677093043), INT32_C( -527636644), INT32_C( 1238565466), INT32_C(-1592387355)),
      simde_mm_set_epi32(INT32_C(-1996051424), INT32_C( -314294760), INT32_C( -770521150), INT32_C(  508113145)) },
    { simde_mm256_set_epi32(INT32_C(    4593159), INT32_C( 1779671737), INT32_C( -569674634), INT32_C( -184254965),
                            INT32_C( -665786654), INT32_C(  663766301), INT32_C(-1237697897), INT32_C( -260948936)),
      simde_mm256_set_epi32(INT32_C( -575114102), INT32_C( -399786699), INT32_C(-1468780124), INT32_C( 2032090700),
                            INT32_C(  723386747), INT32_C(-1766232746), INT32_C(   73837413), INT32_C(  496540408)),
      simde_mm_set_epi32(INT32_C( -665786654), INT32_C(  663766301), INT32_C(-1237697897), INT32_C( -260948936)),
      simde_mm_set_epi32(INT32_C(    4593159), INT32_C( 1779671737), INT32_C( -569674634), INT32_C( -184254965)) },
    { simde_mm256_set_epi32(INT32_C( -328197013), INT32_C( 1036318270), INT32_C(-1930293157), INT32_C( 1948339432),
                            INT32_C( 1903716614), INT32_C(-1951673698), INT32_C(-1858071379), INT32_C( 2070124471)),
      simde_mm256_set_epi32(INT32_C(-1815372819), INT32_C( -102535612), INT32_C(  115383384), INT32_C( 1004544095),
                            INT32_C( 1506420054), INT32_C(-1014523798), INT32_C(-1776388104), INT32_C( 1550371104)),
      simde_mm_set_epi32(INT32_C( 1903716614), INT32_C(-1951673698), INT32_C(-1858071379), INT32_C( 2070124471)),
      simde_mm_set_epi32(INT32_C( -328197013), INT32_C( 1036318270), INT32_C(-1930293157), INT32_C( 1948339432)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m128i ra = simde_mm256_extracti128_si256(test_vec[i].a, 0);
    simde__m128i rb = simde_mm256_extracti128_si256(test_vec[i].a, 1);
    simde_assert_m128i_i32(ra, ==, test_vec[i].ra);
    simde_assert_m128i_i32(rb, ==, test_vec[i].rb);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_madd_epi16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi16(INT16_C(-22074), INT16_C( 27892), INT16_C(-27402), INT16_C( -5185),
                            INT16_C(-13617), INT16_C(  6733), INT16_C( 31914), INT16_C( 16627),
                            INT16_C( 14296), INT16_C(   527), INT16_C(-18797), INT16_C( 25549),
                            INT16_C( 30759), INT16_C(-12360), INT16_C(  6414), INT16_C( 21507)),
      simde_mm256_set_epi16(INT16_C( 13087), INT16_C(   552), INT16_C(-32388), INT16_C( 21398),
                            INT16_C( -2724), INT16_C( 12527), INT16_C(  4881), INT16_C( -1411),
                            INT16_C(  4971), INT16_C(  -716), INT16_C(-15438), INT16_C( 22737),
                            INT16_C( 22649), INT16_C( 14157), INT16_C( 16131), INT16_C( 25742)),
      simde_mm256_set_epi32(INT32_C( -273486054), INT32_C(  776547346), INT32_C(  121436999), INT32_C(  132311537),
                            INT32_C(   70688084), INT32_C(  871095699), INT32_C(  521680071), INT32_C(  657097428)) },
    { simde_mm256_set_epi16(INT16_C( 31591), INT16_C( 27463), INT16_C(-11448), INT16_C( 12754),
                            INT16_C( 23360), INT16_C( 24732), INT16_C( 21501), INT16_C(  9477),
                            INT16_C(-29628), INT16_C( 15818), INT16_C( 22405), INT16_C(-17463),
                            INT16_C( -4252), INT16_C(  1744), INT16_C( 29107), INT16_C(  -236)),
      simde_mm256_set_epi16(INT16_C( 17376), INT16_C(-10713), INT16_C(  2486), INT16_C(  1967),
                            INT16_C(  3397), INT16_C( 25143), INT16_C( 11210), INT16_C( -8470),
                            INT16_C( -7431), INT16_C(-24781), INT16_C( 28646), INT16_C(-15461),
                            INT16_C( -7439), INT16_C(-17272), INT16_C(-12699), INT16_C( 15557)),
      simde_mm256_set_epi32(INT32_C(  254714097), INT32_C(   -3372610), INT32_C(  701190596), INT32_C(  160756020),
                            INT32_C( -171820190), INT32_C(  911809073), INT32_C(    1508260), INT32_C( -373301245)) },
    { simde_mm256_set_epi16(INT16_C(-23018), INT16_C( 27443), INT16_C( -9704), INT16_C(  6815),
                            INT16_C(-10742), INT16_C(-15199), INT16_C(-25926), INT16_C( 11907),
                            INT16_C(-11173), INT16_C( -1296), INT16_C(-31401), INT16_C(-11984),
                            INT16_C( 29153), INT16_C( 26221), INT16_C( 23204), INT16_C( 24693)),
      simde_mm256_set_epi16(INT16_C( 22883), INT16_C( -1430), INT16_C(-22444), INT16_C( -4173),
                            INT16_C( -9271), INT16_C(-22344), INT16_C(-19214), INT16_C(-15237),
                            INT16_C(  8913), INT16_C(-31636), INT16_C(-32308), INT16_C( 15943),
                            INT16_C(  4837), INT16_C( -6600), INT16_C(-14527), INT16_C(-29993)),
      simde_mm256_set_epi32(INT32_C( -565964384), INT32_C(  189357581), INT32_C(  439195538), INT32_C(  316715205),
                            INT32_C(  -58584693), INT32_C(  823442596), INT32_C(  -32045539), INT32_C(-1077701657)) },
    { simde_mm256_set_epi16(INT16_C( -2513), INT16_C( -1446), INT16_C( 20507), INT16_C(-25668),
                            INT16_C( 32595), INT16_C(  1090), INT16_C(  8204), INT16_C(  9120),
                            INT16_C( -8133), INT16_C( 31849), INT16_C(-18457), INT16_C(-12347),
                            INT16_C( 18795), INT16_C( -8246), INT16_C( 23278), INT16_C(-14987)),
      simde_mm256_set_epi16(INT16_C( 12529), INT16_C(-11077), INT16_C(  5410), INT16_C(-23993),
                            INT16_C(-26377), INT16_C( -6112), INT16_C(-21857), INT16_C(  3969),
                            INT16_C( -2477), INT16_C(-13689), INT16_C( 21824), INT16_C(  -644),
                            INT16_C( 10631), INT16_C(-12974), INT16_C(-28564), INT16_C( 32352)),
      simde_mm256_set_epi32(INT32_C(  -15468035), INT32_C(  726795194), INT32_C( -866420395), INT32_C( -143117548),
                            INT32_C( -415835520), INT32_C( -394854100), INT32_C(  306793249), INT32_C(-1149772216)) },
    { simde_mm256_set_epi16(INT16_C(  7571), INT16_C( 21562), INT16_C( 24839), INT16_C( 27056),
                            INT16_C(-18448), INT16_C( 29209), INT16_C(  1880), INT16_C(-21767),
                            INT16_C( 26198), INT16_C(-31641), INT16_C(  3244), INT16_C(-13098),
                            INT16_C( -4443), INT16_C(  -521), INT16_C(-27791), INT16_C(-13063)),
      simde_mm256_set_epi16(INT16_C(-17648), INT16_C(  8337), INT16_C( -3551), INT16_C(-28013),
                            INT16_C(-17930), INT16_C(   577), INT16_C( 32382), INT16_C( 20122),
                            INT16_C(-14435), INT16_C(-21581), INT16_C(-32759), INT16_C(  2792),
                            INT16_C(-24268), INT16_C( 11663), INT16_C( -1946), INT16_C( 19139)),
      simde_mm256_set_epi32(INT32_C(   46149386), INT32_C( -846123017), INT32_C(  347626233), INT32_C( -377117414),
                            INT32_C(  304676291), INT32_C( -142839812), INT32_C(  101746301), INT32_C( -195931471)) },
    { simde_mm256_set_epi16(INT16_C(-11993), INT16_C( -3203), INT16_C( 15681), INT16_C(-18383),
                            INT16_C( 16847), INT16_C(  2437), INT16_C( -8441), INT16_C( 14338),
                            INT16_C(  7300), INT16_C(-21082), INT16_C(-17580), INT16_C(  1429),
                            INT16_C(-32388), INT16_C(-10418), INT16_C(-19218), INT16_C(-31595)),
      simde_mm256_set_epi16(INT16_C(-24077), INT16_C(-32143), INT16_C( 18864), INT16_C( 11719),
                            INT16_C( -5555), INT16_C( -6220), INT16_C(-30370), INT16_C( 23594),
                            INT16_C( 29026), INT16_C( 10950), INT16_C( 31566), INT16_C(-28277),
                            INT16_C( 28777), INT16_C( 17653), INT16_C(-21542), INT16_C(  7263)),
      simde_mm256_set_epi32(INT32_C(  391709490), INT32_C(   80376007), INT32_C( -108743225), INT32_C(  594643942),
                            INT32_C(  -18958100), INT32_C( -595338113), INT32_C(-1115938430), INT32_C(  184519671)) },
    { simde_mm256_set_epi16(INT16_C(-31708), INT16_C( -6736), INT16_C(-12543), INT16_C(-19831),
                            INT16_C( -5660), INT16_C(-20189), INT16_C( 31844), INT16_C( 20882),
                            INT16_C(-22159), INT16_C( -7550), INT16_C(  8622), INT16_C(-20427),
                            INT16_C(-19784), INT16_C(  4739), INT16_C( -9632), INT16_C(  3416)),
      simde_mm256_set_epi16(INT16_C( 18684), INT16_C(  4347), INT16_C( 18074), INT16_C(-24539),
                            INT16_C( 14613), INT16_C(-28009), INT16_C( 18528), INT16_C(-16867),
                            INT16_C(  1794), INT16_C(-22885), INT16_C( 27546), INT16_C( 25964),
                            INT16_C( -3488), INT16_C(-31053), INT16_C(  6969), INT16_C(-12364)),
      simde_mm256_set_epi32(INT32_C( -621713664), INT32_C(  259930727), INT32_C(  482764121), INT32_C(  237788938),
                            INT32_C(  133028504), INT32_C( -292865016), INT32_C(  -78153575), INT32_C( -109360832)) },
    { simde_mm256_set_epi16(INT16_C( 32611), INT16_C(-26810), INT16_C( 32585), INT16_C(  6944),
                            INT16_C( 26033), INT16_C(  2406), INT16_C(-32105), INT16_C(-11091),
                            INT16_C(-32475), INT16_C(-29532), INT16_C( 13591), INT16_C(-15433),
                            INT16_C( 29089), INT16_C(-24035), INT16_C( 15832), INT16_C(-10008)),
      simde_mm256_set_epi16(INT16_C( 16370), INT16_C( -9733), INT16_C( -7456), INT16_C( -2346),
                            INT16_C( -1285), INT16_C( -5955), INT16_C(-24955), INT16_C( -4486),
                            INT16_C(  4170), INT16_C(-17666), INT16_C(  7986), INT16_C( 19848),
                            INT16_C(-13940), INT16_C( 24511), INT16_C( 18142), INT16_C(-26201)),
      simde_mm256_set_epi32(INT32_C(  794783800), INT32_C( -259244384), INT32_C(  -47780135), INT32_C(  850934501),
                            INT32_C(  386291562), INT32_C( -197776458), INT32_C( -994622545), INT32_C(  549443752)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_madd_epi16(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_max_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi8(INT8_C(  82), INT8_C(  80), INT8_C( 100), INT8_C(-114),
                           INT8_C(-121), INT8_C(-115), INT8_C( -33), INT8_C( -36),
                           INT8_C(-105), INT8_C( -52), INT8_C(  94), INT8_C(  97),
                           INT8_C( -84), INT8_C( 116), INT8_C( 107), INT8_C( -76),
                           INT8_C(   5), INT8_C(  53), INT8_C( 122), INT8_C(-101),
                           INT8_C(  32), INT8_C(-122), INT8_C( -66), INT8_C( -61),
                           INT8_C( -25), INT8_C(  -2), INT8_C(  14), INT8_C( -94),
                           INT8_C(  18), INT8_C( -35), INT8_C(-102), INT8_C(  57)),
      simde_mm256_set_epi8(INT8_C(  46), INT8_C( -89), INT8_C(  83), INT8_C( 115),
                           INT8_C( 114), INT8_C(  48), INT8_C(   9), INT8_C(   1),
                           INT8_C(  54), INT8_C( -93), INT8_C( 118), INT8_C( -84),
                           INT8_C(  50), INT8_C( -43), INT8_C(-125), INT8_C( -87),
                           INT8_C(  48), INT8_C(  67), INT8_C(  65), INT8_C( 103),
                           INT8_C( 105), INT8_C( -97), INT8_C( -54), INT8_C(  17),
                           INT8_C( -90), INT8_C( -86), INT8_C( 116), INT8_C( 127),
                           INT8_C(  77), INT8_C(  -5), INT8_C(  31), INT8_C(  24)),
      simde_mm256_set_epi8(INT8_C(  82), INT8_C(  80), INT8_C( 100), INT8_C( 115),
                           INT8_C( 114), INT8_C(  48), INT8_C(   9), INT8_C(   1),
                           INT8_C(  54), INT8_C( -52), INT8_C( 118), INT8_C(  97),
                           INT8_C(  50), INT8_C( 116), INT8_C( 107), INT8_C( -76),
                           INT8_C(  48), INT8_C(  67), INT8_C( 122), INT8_C( 103),
                           INT8_C( 105), INT8_C( -97), INT8_C( -54), INT8_C(  17),
                           INT8_C( -25), INT8_C(  -2), INT8_C( 116), INT8_C( 127),
                           INT8_C(  77), INT8_C(  -5), INT8_C(  31), INT8_C(  57)) },
    { simde_mm256_set_epi8(INT8_C( 104), INT8_C( 106), INT8_C(-125), INT8_C(  -4),
                           INT8_C( -59), INT8_C(  95), INT8_C( -56), INT8_C(  31),
                           INT8_C( 108), INT8_C(   5), INT8_C( 101), INT8_C(  27),
                           INT8_C( -64), INT8_C(  57), INT8_C(-101), INT8_C( -55),
                           INT8_C(  77), INT8_C( 118), INT8_C(  99), INT8_C(  21),
                           INT8_C(  95), INT8_C(  17), INT8_C(  54), INT8_C( -21),
                           INT8_C(  92), INT8_C( -54), INT8_C(  78), INT8_C(  40),
                           INT8_C( 102), INT8_C(-101), INT8_C(   0), INT8_C( 127)),
      simde_mm256_set_epi8(INT8_C( -59), INT8_C( 102), INT8_C(  95), INT8_C( -82),
                           INT8_C( -77), INT8_C( -39), INT8_C( -88), INT8_C( -22),
                           INT8_C(  54), INT8_C(  84), INT8_C( -33), INT8_C(  49),
                           INT8_C(  63), INT8_C(  99), INT8_C(  64), INT8_C(-122),
                           INT8_C( 102), INT8_C(  28), INT8_C(  90), INT8_C(  72),
                           INT8_C(  24), INT8_C(  50), INT8_C(  78), INT8_C( -15),
                           INT8_C( -20), INT8_C( -56), INT8_C(  73), INT8_C(  48),
                           INT8_C( -27), INT8_C(   7), INT8_C( -15), INT8_C(-109)),
      simde_mm256_set_epi8(INT8_C( 104), INT8_C( 106), INT8_C(  95), INT8_C(  -4),
                           INT8_C( -59), INT8_C(  95), INT8_C( -56), INT8_C(  31),
                           INT8_C( 108), INT8_C(  84), INT8_C( 101), INT8_C(  49),
                           INT8_C(  63), INT8_C(  99), INT8_C(  64), INT8_C( -55),
                           INT8_C( 102), INT8_C( 118), INT8_C(  99), INT8_C(  72),
                           INT8_C(  95), INT8_C(  50), INT8_C(  78), INT8_C( -15),
                           INT8_C(  92), INT8_C( -54), INT8_C(  78), INT8_C(  48),
                           INT8_C( 102), INT8_C(   7), INT8_C(   0), INT8_C( 127)) },
    { simde_mm256_set_epi8(INT8_C(  65), INT8_C(  23), INT8_C(  64), INT8_C( -32),
                           INT8_C( -17), INT8_C(  98), INT8_C( -25), INT8_C( 100),
                           INT8_C(-100), INT8_C( -55), INT8_C( -13), INT8_C( 105),
                           INT8_C(   8), INT8_C(  62), INT8_C(-102), INT8_C(  30),
                           INT8_C(  -9), INT8_C(  71), INT8_C( -37), INT8_C( -11),
                           INT8_C( -97), INT8_C(  54), INT8_C( -23), INT8_C( 103),
                           INT8_C(  11), INT8_C( -76), INT8_C(  47), INT8_C(  45),
                           INT8_C( -29), INT8_C( -83), INT8_C( -52), INT8_C(  82)),
      simde_mm256_set_epi8(INT8_C(  -2), INT8_C( -84), INT8_C( -69), INT8_C( -58),
                           INT8_C(-128), INT8_C(  76), INT8_C( 110), INT8_C( -99),
                           INT8_C(  46), INT8_C(   8), INT8_C( -50), INT8_C(  -2),
                           INT8_C( 114), INT8_C(  31), INT8_C( -27), INT8_C( -16),
                           INT8_C(  63), INT8_C( -83), INT8_C(-114), INT8_C( 116),
                           INT8_C(  14), INT8_C( -31), INT8_C(   3), INT8_C(-105),
                           INT8_C( -84), INT8_C( -19), INT8_C(  81), INT8_C(  57),
                           INT8_C( -55), INT8_C( -67), INT8_C( -89), INT8_C(  74)),
      simde_mm256_set_epi8(INT8_C(  65), INT8_C(  23), INT8_C(  64), INT8_C( -32),
                           INT8_C( -17), INT8_C(  98), INT8_C( 110), INT8_C( 100),
                           INT8_C(  46), INT8_C(   8), INT8_C( -13), INT8_C( 105),
                           INT8_C( 114), INT8_C(  62), INT8_C( -27), INT8_C(  30),
                           INT8_C(  63), INT8_C(  71), INT8_C( -37), INT8_C( 116),
                           INT8_C(  14), INT8_C(  54), INT8_C(   3), INT8_C( 103),
                           INT8_C(  11), INT8_C( -19), INT8_C(  81), INT8_C(  57),
                           INT8_C( -29), INT8_C( -67), INT8_C( -52), INT8_C(  82)) },
    { simde_mm256_set_epi8(INT8_C(   3), INT8_C( -48), INT8_C( -19), INT8_C( 101),
                           INT8_C(  -3), INT8_C( -85), INT8_C(-102), INT8_C(  26),
                           INT8_C(  89), INT8_C( -95), INT8_C(  51), INT8_C(  -5),
                           INT8_C(  13), INT8_C(  30), INT8_C( -92), INT8_C( -13),
                           INT8_C(  68), INT8_C(  71), INT8_C(-127), INT8_C( -65),
                           INT8_C(-102), INT8_C(  -1), INT8_C(  48), INT8_C(  30),
                           INT8_C(  43), INT8_C(  71), INT8_C(  53), INT8_C(  78),
                           INT8_C(  81), INT8_C( 119), INT8_C( -32), INT8_C(  18)),
      simde_mm256_set_epi8(INT8_C( -81), INT8_C( -54), INT8_C( -70), INT8_C( 102),
                           INT8_C(  86), INT8_C( 106), INT8_C(  99), INT8_C(  -7),
                           INT8_C( -74), INT8_C( -52), INT8_C(-121), INT8_C(-127),
                           INT8_C(  49), INT8_C(-119), INT8_C(  52), INT8_C( 119),
                           INT8_C( 123), INT8_C(-104), INT8_C(  44), INT8_C( -14),
                           INT8_C(  56), INT8_C( -83), INT8_C(  21), INT8_C( 108),
                           INT8_C( -43), INT8_C(  75), INT8_C(  75), INT8_C(  51),
                           INT8_C(  54), INT8_C( -18), INT8_C( 100), INT8_C(  49)),
      simde_mm256_set_epi8(INT8_C(   3), INT8_C( -48), INT8_C( -19), INT8_C( 102),
                           INT8_C(  86), INT8_C( 106), INT8_C(  99), INT8_C(  26),
                           INT8_C(  89), INT8_C( -52), INT8_C(  51), INT8_C(  -5),
                           INT8_C(  49), INT8_C(  30), INT8_C(  52), INT8_C( 119),
                           INT8_C( 123), INT8_C(  71), INT8_C(  44), INT8_C( -14),
                           INT8_C(  56), INT8_C(  -1), INT8_C(  48), INT8_C( 108),
                           INT8_C(  43), INT8_C(  75), INT8_C(  75), INT8_C(  78),
                           INT8_C(  81), INT8_C( 119), INT8_C( 100), INT8_C(  49)) },
    { simde_mm256_set_epi8(INT8_C( -92), INT8_C(  89), INT8_C(  61), INT8_C( 117),
                           INT8_C( -42), INT8_C(  29), INT8_C( -36), INT8_C(  67),
                           INT8_C(-107), INT8_C(  95), INT8_C(-103), INT8_C( -42),
                           INT8_C( -63), INT8_C(  54), INT8_C(  53), INT8_C( -40),
                           INT8_C( -66), INT8_C( -31), INT8_C( -91), INT8_C(  82),
                           INT8_C( 110), INT8_C( -33), INT8_C(  21), INT8_C(  38),
                           INT8_C( -69), INT8_C(  34), INT8_C( -74), INT8_C(  24),
                           INT8_C( -26), INT8_C(-124), INT8_C( -81), INT8_C(  36)),
      simde_mm256_set_epi8(INT8_C(-105), INT8_C(  55), INT8_C(-117), INT8_C(  72),
                           INT8_C( -82), INT8_C( -42), INT8_C( 100), INT8_C( -21),
                           INT8_C(  19), INT8_C( 104), INT8_C(  11), INT8_C(  52),
                           INT8_C(  30), INT8_C(   8), INT8_C(  70), INT8_C( -51),
                           INT8_C( -61), INT8_C( -91), INT8_C( 126), INT8_C( -28),
                           INT8_C( -34), INT8_C( 102), INT8_C(  69), INT8_C(  99),
                           INT8_C(  81), INT8_C(  11), INT8_C( -51), INT8_C(   2),
                           INT8_C(  60), INT8_C( -70), INT8_C(  92), INT8_C( -37)),
      simde_mm256_set_epi8(INT8_C( -92), INT8_C(  89), INT8_C(  61), INT8_C( 117),
                           INT8_C( -42), INT8_C(  29), INT8_C( 100), INT8_C(  67),
                           INT8_C(  19), INT8_C( 104), INT8_C(  11), INT8_C(  52),
                           INT8_C(  30), INT8_C(  54), INT8_C(  70), INT8_C( -40),
                           INT8_C( -61), INT8_C( -31), INT8_C( 126), INT8_C(  82),
                           INT8_C( 110), INT8_C( 102), INT8_C(  69), INT8_C(  99),
                           INT8_C(  81), INT8_C(  34), INT8_C( -51), INT8_C(  24),
                           INT8_C(  60), INT8_C( -70), INT8_C(  92), INT8_C(  36)) },
    { simde_mm256_set_epi8(INT8_C(-123), INT8_C( 126), INT8_C(  24), INT8_C(  94),
                           INT8_C( -42), INT8_C( 118), INT8_C(   5), INT8_C( -41),
                           INT8_C( -65), INT8_C( -51), INT8_C( -68), INT8_C( 107),
                           INT8_C( -74), INT8_C( 112), INT8_C(  53), INT8_C(  87),
                           INT8_C(  26), INT8_C( -33), INT8_C(  99), INT8_C(-107),
                           INT8_C(   6), INT8_C( 119), INT8_C( -42), INT8_C(  32),
                           INT8_C(  54), INT8_C( -97), INT8_C(-117), INT8_C(  -9),
                           INT8_C(-107), INT8_C(  44), INT8_C( -40), INT8_C(  33)),
      simde_mm256_set_epi8(INT8_C(-115), INT8_C( -12), INT8_C( -81), INT8_C(-120),
                           INT8_C(  82), INT8_C( 114), INT8_C( -55), INT8_C(-106),
                           INT8_C( -54), INT8_C( 126), INT8_C(  70), INT8_C(  83),
                           INT8_C(  64), INT8_C( -11), INT8_C(  10), INT8_C(  72),
                           INT8_C(  19), INT8_C( -35), INT8_C( 123), INT8_C( -50),
                           INT8_C(  95), INT8_C(  -2), INT8_C(  77), INT8_C( -12),
                           INT8_C(-127), INT8_C( -73), INT8_C( 117), INT8_C(  14),
                           INT8_C(  40), INT8_C( -92), INT8_C(  74), INT8_C( 114)),
      simde_mm256_set_epi8(INT8_C(-115), INT8_C( 126), INT8_C(  24), INT8_C(  94),
                           INT8_C(  82), INT8_C( 118), INT8_C(   5), INT8_C( -41),
                           INT8_C( -54), INT8_C( 126), INT8_C(  70), INT8_C( 107),
                           INT8_C(  64), INT8_C( 112), INT8_C(  53), INT8_C(  87),
                           INT8_C(  26), INT8_C( -33), INT8_C( 123), INT8_C( -50),
                           INT8_C(  95), INT8_C( 119), INT8_C(  77), INT8_C(  32),
                           INT8_C(  54), INT8_C( -73), INT8_C( 117), INT8_C(  14),
                           INT8_C(  40), INT8_C(  44), INT8_C(  74), INT8_C( 114)) },
    { simde_mm256_set_epi8(INT8_C(  29), INT8_C(  41), INT8_C( 107), INT8_C(  24),
                           INT8_C(-113), INT8_C( 113), INT8_C( -53), INT8_C(   6),
                           INT8_C( -82), INT8_C(  34), INT8_C(   0), INT8_C(  35),
                           INT8_C( -43), INT8_C(-128), INT8_C( -61), INT8_C( -69),
                           INT8_C(   2), INT8_C(  64), INT8_C(  89), INT8_C( -88),
                           INT8_C( 111), INT8_C( -95), INT8_C(  42), INT8_C( -15),
                           INT8_C(  21), INT8_C(  73), INT8_C(  70), INT8_C( 127),
                           INT8_C(  32), INT8_C( 116), INT8_C(  36), INT8_C( -14)),
      simde_mm256_set_epi8(INT8_C(  52), INT8_C( -53), INT8_C( 101), INT8_C(  79),
                           INT8_C(  -8), INT8_C( -70), INT8_C( -81), INT8_C(-117),
                           INT8_C(  27), INT8_C( -60), INT8_C(  78), INT8_C(   6),
                           INT8_C(  79), INT8_C(  72), INT8_C(   1), INT8_C( -62),
                           INT8_C( -36), INT8_C( -42), INT8_C(   0), INT8_C( -10),
                           INT8_C( -19), INT8_C(  -1), INT8_C(  25), INT8_C( -88),
                           INT8_C(  -5), INT8_C( -10), INT8_C( 127), INT8_C( 114),
                           INT8_C( 110), INT8_C(  -1), INT8_C( -27), INT8_C(  51)),
      simde_mm256_set_epi8(INT8_C(  52), INT8_C(  41), INT8_C( 107), INT8_C(  79),
                           INT8_C(  -8), INT8_C( 113), INT8_C( -53), INT8_C(   6),
                           INT8_C(  27), INT8_C(  34), INT8_C(  78), INT8_C(  35),
                           INT8_C(  79), INT8_C(  72), INT8_C(   1), INT8_C( -62),
                           INT8_C(   2), INT8_C(  64), INT8_C(  89), INT8_C( -10),
                           INT8_C( 111), INT8_C(  -1), INT8_C(  42), INT8_C( -15),
                           INT8_C(  21), INT8_C(  73), INT8_C( 127), INT8_C( 127),
                           INT8_C( 110), INT8_C( 116), INT8_C(  36), INT8_C(  51)) },
    { simde_mm256_set_epi8(INT8_C(  94), INT8_C( -83), INT8_C( -81), INT8_C( 109),
                           INT8_C(  -8), INT8_C( 100), INT8_C(  40), INT8_C(-125),
                           INT8_C( 114), INT8_C( -99), INT8_C(  42), INT8_C(  35),
                           INT8_C(  59), INT8_C(  67), INT8_C(  26), INT8_C( -39),
                           INT8_C(  79), INT8_C( 116), INT8_C(   3), INT8_C( -47),
                           INT8_C(  73), INT8_C(  13), INT8_C( -83), INT8_C( -95),
                           INT8_C(  75), INT8_C( -48), INT8_C( -36), INT8_C( 127),
                           INT8_C( 117), INT8_C(  -9), INT8_C(  94), INT8_C( -87)),
      simde_mm256_set_epi8(INT8_C( -44), INT8_C( -67), INT8_C(-100), INT8_C(  73),
                           INT8_C(  63), INT8_C(  69), INT8_C( -48), INT8_C( -87),
                           INT8_C(  -1), INT8_C( -19), INT8_C(  -9), INT8_C(  66),
                           INT8_C(  27), INT8_C(  17), INT8_C(-109), INT8_C(  22),
                           INT8_C(  98), INT8_C( 106), INT8_C( -50), INT8_C( -90),
                           INT8_C(  92), INT8_C( 106), INT8_C( -59), INT8_C(  31),
                           INT8_C( -18), INT8_C( -17), INT8_C( -80), INT8_C( -46),
                           INT8_C(  67), INT8_C( -29), INT8_C(  44), INT8_C(  76)),
      simde_mm256_set_epi8(INT8_C(  94), INT8_C( -67), INT8_C( -81), INT8_C( 109),
                           INT8_C(  63), INT8_C( 100), INT8_C(  40), INT8_C( -87),
                           INT8_C( 114), INT8_C( -19), INT8_C(  42), INT8_C(  66),
                           INT8_C(  59), INT8_C(  67), INT8_C(  26), INT8_C(  22),
                           INT8_C(  98), INT8_C( 116), INT8_C(   3), INT8_C( -47),
                           INT8_C(  92), INT8_C( 106), INT8_C( -59), INT8_C(  31),
                           INT8_C(  75), INT8_C( -17), INT8_C( -36), INT8_C( 127),
                           INT8_C( 117), INT8_C(  -9), INT8_C(  94), INT8_C(  76)) },
  };


  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_max_epi8(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_max_epu8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
   { simde_x_mm256_set_epu8(UINT8_C(180), UINT8_C(215), UINT8_C( 58), UINT8_C(173),
                             UINT8_C(238), UINT8_C(242), UINT8_C( 74), UINT8_C(116),
                             UINT8_C(237), UINT8_C( 59), UINT8_C(170), UINT8_C(217),
                             UINT8_C(180), UINT8_C(149), UINT8_C(157), UINT8_C(250),
                             UINT8_C(224), UINT8_C(201), UINT8_C(109), UINT8_C(247),
                             UINT8_C( 25), UINT8_C(111), UINT8_C( 62), UINT8_C(129),
                             UINT8_C(115), UINT8_C(244), UINT8_C( 23), UINT8_C(181),
                             UINT8_C(205), UINT8_C(130), UINT8_C( 15), UINT8_C(  6)),
      simde_x_mm256_set_epu8(UINT8_C(129), UINT8_C(102), UINT8_C(249), UINT8_C(232),
                             UINT8_C(171), UINT8_C(250), UINT8_C(155), UINT8_C( 41),
                             UINT8_C(184), UINT8_C(159), UINT8_C(213), UINT8_C( 99),
                             UINT8_C(220), UINT8_C(155), UINT8_C(220), UINT8_C(163),
                             UINT8_C(219), UINT8_C(184), UINT8_C( 97), UINT8_C(230),
                             UINT8_C( 89), UINT8_C( 94), UINT8_C( 73), UINT8_C(152),
                             UINT8_C( 89), UINT8_C( 86), UINT8_C(115), UINT8_C(206),
                             UINT8_C(132), UINT8_C(230), UINT8_C(207), UINT8_C(  0)),
      simde_x_mm256_set_epu8(UINT8_C(180), UINT8_C(215), UINT8_C(249), UINT8_C(232),
                             UINT8_C(238), UINT8_C(250), UINT8_C(155), UINT8_C(116),
                             UINT8_C(237), UINT8_C(159), UINT8_C(213), UINT8_C(217),
                             UINT8_C(220), UINT8_C(155), UINT8_C(220), UINT8_C(250),
                             UINT8_C(224), UINT8_C(201), UINT8_C(109), UINT8_C(247),
                             UINT8_C( 89), UINT8_C(111), UINT8_C( 73), UINT8_C(152),
                             UINT8_C(115), UINT8_C(244), UINT8_C(115), UINT8_C(206),
                             UINT8_C(205), UINT8_C(230), UINT8_C(207), UINT8_C(  6)) },
    { simde_x_mm256_set_epu8(UINT8_C(218), UINT8_C(157), UINT8_C(237), UINT8_C(159),
                             UINT8_C( 73), UINT8_C(122), UINT8_C( 14), UINT8_C(243),
                             UINT8_C(232), UINT8_C(133), UINT8_C( 42), UINT8_C( 15),
                             UINT8_C( 24), UINT8_C(199), UINT8_C(216), UINT8_C( 25),
                             UINT8_C(242), UINT8_C(254), UINT8_C(156), UINT8_C(113),
                             UINT8_C(  5), UINT8_C( 95), UINT8_C( 73), UINT8_C(123),
                             UINT8_C(224), UINT8_C(233), UINT8_C(137), UINT8_C(219),
                             UINT8_C(122), UINT8_C(103), UINT8_C( 32), UINT8_C( 32)),
      simde_x_mm256_set_epu8(UINT8_C(255), UINT8_C(178), UINT8_C( 89), UINT8_C( 15),
                             UINT8_C( 21), UINT8_C(211), UINT8_C(214), UINT8_C(175),
                             UINT8_C( 24), UINT8_C(208), UINT8_C(242), UINT8_C( 16),
                             UINT8_C( 86), UINT8_C(207), UINT8_C(159), UINT8_C( 23),
                             UINT8_C( 74), UINT8_C( 72), UINT8_C(123), UINT8_C( 85),
                             UINT8_C( 99), UINT8_C(  6), UINT8_C( 15), UINT8_C(240),
                             UINT8_C(112), UINT8_C( 36), UINT8_C(217), UINT8_C( 82),
                             UINT8_C(251), UINT8_C( 67), UINT8_C(226), UINT8_C(252)),
      simde_x_mm256_set_epu8(UINT8_C(255), UINT8_C(178), UINT8_C(237), UINT8_C(159),
                             UINT8_C( 73), UINT8_C(211), UINT8_C(214), UINT8_C(243),
                             UINT8_C(232), UINT8_C(208), UINT8_C(242), UINT8_C( 16),
                             UINT8_C( 86), UINT8_C(207), UINT8_C(216), UINT8_C( 25),
                             UINT8_C(242), UINT8_C(254), UINT8_C(156), UINT8_C(113),
                             UINT8_C( 99), UINT8_C( 95), UINT8_C( 73), UINT8_C(240),
                             UINT8_C(224), UINT8_C(233), UINT8_C(217), UINT8_C(219),
                             UINT8_C(251), UINT8_C(103), UINT8_C(226), UINT8_C(252)) },
    { simde_x_mm256_set_epu8(UINT8_C( 99), UINT8_C(186), UINT8_C(163), UINT8_C(  4),
                             UINT8_C( 50), UINT8_C( 29), UINT8_C(  2), UINT8_C( 45),
                             UINT8_C( 57), UINT8_C(  0), UINT8_C(206), UINT8_C( 78),
                             UINT8_C(164), UINT8_C( 87), UINT8_C( 32), UINT8_C(133),
                             UINT8_C(239), UINT8_C(167), UINT8_C( 26), UINT8_C(218),
                             UINT8_C(142), UINT8_C( 23), UINT8_C( 41), UINT8_C( 63),
                             UINT8_C(230), UINT8_C(150), UINT8_C( 27), UINT8_C(237),
                             UINT8_C(105), UINT8_C(166), UINT8_C( 82), UINT8_C( 50)),
      simde_x_mm256_set_epu8(UINT8_C(129), UINT8_C(111), UINT8_C( 84), UINT8_C(213),
                             UINT8_C( 28), UINT8_C( 33), UINT8_C(141), UINT8_C(175),
                             UINT8_C( 38), UINT8_C(248), UINT8_C(  9), UINT8_C(  4),
                             UINT8_C(199), UINT8_C( 40), UINT8_C(185), UINT8_C(144),
                             UINT8_C( 46), UINT8_C( 14), UINT8_C( 90), UINT8_C(214),
                             UINT8_C( 91), UINT8_C( 56), UINT8_C( 35), UINT8_C(120),
                             UINT8_C(228), UINT8_C( 66), UINT8_C( 89), UINT8_C(196),
                             UINT8_C(150), UINT8_C(233), UINT8_C(114), UINT8_C(153)),
      simde_x_mm256_set_epu8(UINT8_C(129), UINT8_C(186), UINT8_C(163), UINT8_C(213),
                             UINT8_C( 50), UINT8_C( 33), UINT8_C(141), UINT8_C(175),
                             UINT8_C( 57), UINT8_C(248), UINT8_C(206), UINT8_C( 78),
                             UINT8_C(199), UINT8_C( 87), UINT8_C(185), UINT8_C(144),
                             UINT8_C(239), UINT8_C(167), UINT8_C( 90), UINT8_C(218),
                             UINT8_C(142), UINT8_C( 56), UINT8_C( 41), UINT8_C(120),
                             UINT8_C(230), UINT8_C(150), UINT8_C( 89), UINT8_C(237),
                             UINT8_C(150), UINT8_C(233), UINT8_C(114), UINT8_C(153)) },
    { simde_x_mm256_set_epu8(UINT8_C( 80), UINT8_C(  4), UINT8_C(125), UINT8_C(  7),
                             UINT8_C( 48), UINT8_C(207), UINT8_C( 44), UINT8_C(221),
                             UINT8_C(215), UINT8_C( 45), UINT8_C(223), UINT8_C(194),
                             UINT8_C(186), UINT8_C( 12), UINT8_C(145), UINT8_C(171),
                             UINT8_C(238), UINT8_C(191), UINT8_C( 72), UINT8_C(118),
                             UINT8_C( 66), UINT8_C(123), UINT8_C(140), UINT8_C(190),
                             UINT8_C(  2), UINT8_C(202), UINT8_C( 43), UINT8_C( 29),
                             UINT8_C( 54), UINT8_C( 64), UINT8_C(115), UINT8_C( 16)),
      simde_x_mm256_set_epu8(UINT8_C( 80), UINT8_C(158), UINT8_C(246), UINT8_C( 30),
                             UINT8_C(178), UINT8_C(129), UINT8_C(199), UINT8_C(213),
                             UINT8_C( 85), UINT8_C(149), UINT8_C(108), UINT8_C( 59),
                             UINT8_C(205), UINT8_C(149), UINT8_C(119), UINT8_C(194),
                             UINT8_C(246), UINT8_C( 94), UINT8_C(221), UINT8_C(162),
                             UINT8_C( 94), UINT8_C(125), UINT8_C(138), UINT8_C(231),
                             UINT8_C(191), UINT8_C( 11), UINT8_C( 15), UINT8_C( 66),
                             UINT8_C(133), UINT8_C(100), UINT8_C( 76), UINT8_C( 29)),
      simde_x_mm256_set_epu8(UINT8_C( 80), UINT8_C(158), UINT8_C(246), UINT8_C( 30),
                             UINT8_C(178), UINT8_C(207), UINT8_C(199), UINT8_C(221),
                             UINT8_C(215), UINT8_C(149), UINT8_C(223), UINT8_C(194),
                             UINT8_C(205), UINT8_C(149), UINT8_C(145), UINT8_C(194),
                             UINT8_C(246), UINT8_C(191), UINT8_C(221), UINT8_C(162),
                             UINT8_C( 94), UINT8_C(125), UINT8_C(140), UINT8_C(231),
                             UINT8_C(191), UINT8_C(202), UINT8_C( 43), UINT8_C( 66),
                             UINT8_C(133), UINT8_C(100), UINT8_C(115), UINT8_C( 29)) },
    { simde_x_mm256_set_epu8(UINT8_C(197), UINT8_C( 85), UINT8_C( 13), UINT8_C(197),
                             UINT8_C( 97), UINT8_C(213), UINT8_C( 19), UINT8_C(106),
                             UINT8_C(135), UINT8_C(  2), UINT8_C(117), UINT8_C(164),
                             UINT8_C(206), UINT8_C(103), UINT8_C( 74), UINT8_C( 88),
                             UINT8_C(183), UINT8_C( 33), UINT8_C(103), UINT8_C(216),
                             UINT8_C(136), UINT8_C(200), UINT8_C( 59), UINT8_C(124),
                             UINT8_C(188), UINT8_C(115), UINT8_C(181), UINT8_C(132),
                             UINT8_C(156), UINT8_C( 81), UINT8_C(255), UINT8_C(214)),
      simde_x_mm256_set_epu8(UINT8_C( 95), UINT8_C( 13), UINT8_C(157), UINT8_C(137),
                             UINT8_C( 41), UINT8_C(108), UINT8_C(  8), UINT8_C( 29),
                             UINT8_C( 52), UINT8_C(238), UINT8_C( 31), UINT8_C( 23),
                             UINT8_C(  9), UINT8_C( 86), UINT8_C(  2), UINT8_C( 88),
                             UINT8_C( 88), UINT8_C(185), UINT8_C(173), UINT8_C(108),
                             UINT8_C(234), UINT8_C(252), UINT8_C(231), UINT8_C( 15),
                             UINT8_C( 68), UINT8_C(138), UINT8_C( 60), UINT8_C(162),
                             UINT8_C(131), UINT8_C(215), UINT8_C( 87), UINT8_C( 44)),
      simde_x_mm256_set_epu8(UINT8_C(197), UINT8_C( 85), UINT8_C(157), UINT8_C(197),
                             UINT8_C( 97), UINT8_C(213), UINT8_C( 19), UINT8_C(106),
                             UINT8_C(135), UINT8_C(238), UINT8_C(117), UINT8_C(164),
                             UINT8_C(206), UINT8_C(103), UINT8_C( 74), UINT8_C( 88),
                             UINT8_C(183), UINT8_C(185), UINT8_C(173), UINT8_C(216),
                             UINT8_C(234), UINT8_C(252), UINT8_C(231), UINT8_C(124),
                             UINT8_C(188), UINT8_C(138), UINT8_C(181), UINT8_C(162),
                             UINT8_C(156), UINT8_C(215), UINT8_C(255), UINT8_C(214)) },
    { simde_x_mm256_set_epu8(UINT8_C(231), UINT8_C(112), UINT8_C(155), UINT8_C( 33),
                             UINT8_C( 64), UINT8_C(148), UINT8_C(180), UINT8_C( 63),
                             UINT8_C( 75), UINT8_C(171), UINT8_C(170), UINT8_C(114),
                             UINT8_C(142), UINT8_C(212), UINT8_C(162), UINT8_C(149),
                             UINT8_C( 47), UINT8_C(201), UINT8_C( 71), UINT8_C( 17),
                             UINT8_C(237), UINT8_C(172), UINT8_C(186), UINT8_C( 26),
                             UINT8_C(227), UINT8_C(106), UINT8_C(215), UINT8_C(216),
                             UINT8_C(247), UINT8_C(225), UINT8_C(  9), UINT8_C( 60)),
      simde_x_mm256_set_epu8(UINT8_C(136), UINT8_C( 20), UINT8_C(248), UINT8_C(149),
                             UINT8_C(  4), UINT8_C(138), UINT8_C(203), UINT8_C( 63),
                             UINT8_C(168), UINT8_C(148), UINT8_C(215), UINT8_C( 68),
                             UINT8_C(209), UINT8_C(109), UINT8_C(191), UINT8_C(165),
                             UINT8_C( 20), UINT8_C( 98), UINT8_C(113), UINT8_C(151),
                             UINT8_C(142), UINT8_C(111), UINT8_C(162), UINT8_C(190),
                             UINT8_C(230), UINT8_C(122), UINT8_C(213), UINT8_C(213),
                             UINT8_C(118), UINT8_C(189), UINT8_C( 22), UINT8_C(229)),
      simde_x_mm256_set_epu8(UINT8_C(231), UINT8_C(112), UINT8_C(248), UINT8_C(149),
                             UINT8_C( 64), UINT8_C(148), UINT8_C(203), UINT8_C( 63),
                             UINT8_C(168), UINT8_C(171), UINT8_C(215), UINT8_C(114),
                             UINT8_C(209), UINT8_C(212), UINT8_C(191), UINT8_C(165),
                             UINT8_C( 47), UINT8_C(201), UINT8_C(113), UINT8_C(151),
                             UINT8_C(237), UINT8_C(172), UINT8_C(186), UINT8_C(190),
                             UINT8_C(230), UINT8_C(122), UINT8_C(215), UINT8_C(216),
                             UINT8_C(247), UINT8_C(225), UINT8_C( 22), UINT8_C(229)) },
    { simde_x_mm256_set_epu8(UINT8_C(183), UINT8_C(  9), UINT8_C( 46), UINT8_C( 70),
                             UINT8_C( 48), UINT8_C(117), UINT8_C(202), UINT8_C(154),
                             UINT8_C(250), UINT8_C(204), UINT8_C(191), UINT8_C( 51),
                             UINT8_C( 37), UINT8_C(  5), UINT8_C(178), UINT8_C( 19),
                             UINT8_C(105), UINT8_C( 57), UINT8_C( 19), UINT8_C( 60),
                             UINT8_C( 26), UINT8_C( 52), UINT8_C(197), UINT8_C( 41),
                             UINT8_C(112), UINT8_C(146), UINT8_C(171), UINT8_C( 51),
                             UINT8_C( 94), UINT8_C(195), UINT8_C(226), UINT8_C(203)),
      simde_x_mm256_set_epu8(UINT8_C( 96), UINT8_C( 68), UINT8_C( 60), UINT8_C( 83),
                             UINT8_C(130), UINT8_C( 56), UINT8_C(227), UINT8_C(106),
                             UINT8_C(254), UINT8_C(175), UINT8_C(176), UINT8_C(122),
                             UINT8_C(126), UINT8_C(122), UINT8_C(171), UINT8_C(205),
                             UINT8_C( 85), UINT8_C(250), UINT8_C( 22), UINT8_C(153),
                             UINT8_C(140), UINT8_C(119), UINT8_C( 56), UINT8_C(225),
                             UINT8_C( 78), UINT8_C(180), UINT8_C(234), UINT8_C(136),
                             UINT8_C( 47), UINT8_C(214), UINT8_C( 40), UINT8_C(206)),
      simde_x_mm256_set_epu8(UINT8_C(183), UINT8_C( 68), UINT8_C( 60), UINT8_C( 83),
                             UINT8_C(130), UINT8_C(117), UINT8_C(227), UINT8_C(154),
                             UINT8_C(254), UINT8_C(204), UINT8_C(191), UINT8_C(122),
                             UINT8_C(126), UINT8_C(122), UINT8_C(178), UINT8_C(205),
                             UINT8_C(105), UINT8_C(250), UINT8_C( 22), UINT8_C(153),
                             UINT8_C(140), UINT8_C(119), UINT8_C(197), UINT8_C(225),
                             UINT8_C(112), UINT8_C(180), UINT8_C(234), UINT8_C(136),
                             UINT8_C( 94), UINT8_C(214), UINT8_C(226), UINT8_C(206)) },
    { simde_x_mm256_set_epu8(UINT8_C( 93), UINT8_C(234), UINT8_C(139), UINT8_C(  2),
                             UINT8_C(  9), UINT8_C(232), UINT8_C( 35), UINT8_C( 78),
                             UINT8_C(197), UINT8_C( 13), UINT8_C(224), UINT8_C( 83),
                             UINT8_C( 37), UINT8_C(182), UINT8_C( 94), UINT8_C( 69),
                             UINT8_C(143), UINT8_C( 54), UINT8_C(219), UINT8_C(171),
                             UINT8_C( 22), UINT8_C(117), UINT8_C( 46), UINT8_C(238),
                             UINT8_C(  4), UINT8_C(125), UINT8_C(  7), UINT8_C(106),
                             UINT8_C(127), UINT8_C( 87), UINT8_C( 56), UINT8_C( 20)),
      simde_x_mm256_set_epu8(UINT8_C( 73), UINT8_C(103), UINT8_C( 49), UINT8_C(198),
                             UINT8_C(212), UINT8_C(255), UINT8_C(227), UINT8_C( 52),
                             UINT8_C(122), UINT8_C( 22), UINT8_C(213), UINT8_C(204),
                             UINT8_C(103), UINT8_C( 93), UINT8_C( 45), UINT8_C( 45),
                             UINT8_C(221), UINT8_C(118), UINT8_C( 73), UINT8_C( 16),
                             UINT8_C(194), UINT8_C( 60), UINT8_C(246), UINT8_C(126),
                             UINT8_C( 84), UINT8_C(155), UINT8_C(128), UINT8_C( 83),
                             UINT8_C(  5), UINT8_C( 37), UINT8_C(157), UINT8_C(132)),
      simde_x_mm256_set_epu8(UINT8_C( 93), UINT8_C(234), UINT8_C(139), UINT8_C(198),
                             UINT8_C(212), UINT8_C(255), UINT8_C(227), UINT8_C( 78),
                             UINT8_C(197), UINT8_C( 22), UINT8_C(224), UINT8_C(204),
                             UINT8_C(103), UINT8_C(182), UINT8_C( 94), UINT8_C( 69),
                             UINT8_C(221), UINT8_C(118), UINT8_C(219), UINT8_C(171),
                             UINT8_C(194), UINT8_C(117), UINT8_C(246), UINT8_C(238),
                             UINT8_C( 84), UINT8_C(155), UINT8_C(128), UINT8_C(106),
                             UINT8_C(127), UINT8_C( 87), UINT8_C(157), UINT8_C(132)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_max_epu8(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_u8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_max_epi16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
   { simde_mm256_set_epi16(INT16_C( 13945), INT16_C(-32397), INT16_C( -8500), INT16_C(-16936),
                            INT16_C(  -615), INT16_C( 28879), INT16_C( 19952), INT16_C(-20844),
                            INT16_C(-18762), INT16_C( 23311), INT16_C(-22090), INT16_C( 16355),
                            INT16_C( 18939), INT16_C( -9393), INT16_C( 19655), INT16_C( 25483)),
      simde_mm256_set_epi16(INT16_C(-30076), INT16_C(-27428), INT16_C(-24061), INT16_C( -9620),
                            INT16_C(-17974), INT16_C(  3150), INT16_C(  6986), INT16_C(-23891),
                            INT16_C( 12942), INT16_C( 12645), INT16_C(-13904), INT16_C(  -868),
                            INT16_C(-14591), INT16_C( 24935), INT16_C(  4654), INT16_C(  4591)),
      simde_mm256_set_epi16(INT16_C( 13945), INT16_C(-27428), INT16_C( -8500), INT16_C( -9620),
                            INT16_C(  -615), INT16_C( 28879), INT16_C( 19952), INT16_C(-20844),
                            INT16_C( 12942), INT16_C( 23311), INT16_C(-13904), INT16_C( 16355),
                            INT16_C( 18939), INT16_C( 24935), INT16_C( 19655), INT16_C( 25483)) },
    { simde_mm256_set_epi16(INT16_C( 15746), INT16_C( 16476), INT16_C(-26892), INT16_C( 15551),
                            INT16_C(  4802), INT16_C( 22020), INT16_C(  7684), INT16_C( 20433),
                            INT16_C(-15213), INT16_C( -9067), INT16_C( 11028), INT16_C(  2768),
                            INT16_C( 19036), INT16_C(-29021), INT16_C( 27796), INT16_C(-20181)),
      simde_mm256_set_epi16(INT16_C(-15017), INT16_C(-10120), INT16_C(-23789), INT16_C(-21730),
                            INT16_C( 16078), INT16_C(  3607), INT16_C(-18668), INT16_C(-12209),
                            INT16_C(  -562), INT16_C( 30247), INT16_C( 20324), INT16_C( -8924),
                            INT16_C( 24524), INT16_C( -5426), INT16_C( 25503), INT16_C(  2215)),
      simde_mm256_set_epi16(INT16_C( 15746), INT16_C( 16476), INT16_C(-23789), INT16_C( 15551),
                            INT16_C( 16078), INT16_C( 22020), INT16_C(  7684), INT16_C( 20433),
                            INT16_C(  -562), INT16_C( 30247), INT16_C( 20324), INT16_C(  2768),
                            INT16_C( 24524), INT16_C( -5426), INT16_C( 27796), INT16_C(  2215)) },
    { simde_mm256_set_epi16(INT16_C(  9558), INT16_C( 24602), INT16_C(-11854), INT16_C( 13316),
                            INT16_C( -7111), INT16_C(  5322), INT16_C( 10474), INT16_C( 14309),
                            INT16_C( 10175), INT16_C(-23285), INT16_C( -7105), INT16_C(-18408),
                            INT16_C( -9456), INT16_C(-31797), INT16_C(  6677), INT16_C( 24246)),
      simde_mm256_set_epi16(INT16_C(  8353), INT16_C(-12225), INT16_C( 10989), INT16_C( 20160),
                            INT16_C(-24928), INT16_C( 11285), INT16_C(-21080), INT16_C(-21637),
                            INT16_C(  -557), INT16_C(-15431), INT16_C(-14247), INT16_C(  1813),
                            INT16_C( -7571), INT16_C( 22502), INT16_C( 12550), INT16_C(  3083)),
      simde_mm256_set_epi16(INT16_C(  9558), INT16_C( 24602), INT16_C( 10989), INT16_C( 20160),
                            INT16_C( -7111), INT16_C( 11285), INT16_C( 10474), INT16_C( 14309),
                            INT16_C( 10175), INT16_C(-15431), INT16_C( -7105), INT16_C(  1813),
                            INT16_C( -7571), INT16_C( 22502), INT16_C( 12550), INT16_C( 24246)) },
    { simde_mm256_set_epi16(INT16_C( 25542), INT16_C(-21715), INT16_C(-12723), INT16_C(  3641),
                            INT16_C( 10626), INT16_C(  1975), INT16_C( 32038), INT16_C( 13257),
                            INT16_C( 26030), INT16_C(-29459), INT16_C( 27784), INT16_C(-29348),
                            INT16_C( 24986), INT16_C( 19201), INT16_C(-21133), INT16_C(  -544)),
      simde_mm256_set_epi16(INT16_C(-15360), INT16_C( -9091), INT16_C(  9964), INT16_C(-26119),
                            INT16_C(-13193), INT16_C( -4473), INT16_C(-16910), INT16_C( -8355),
                            INT16_C( 29088), INT16_C( 26903), INT16_C( 19970), INT16_C( 20929),
                            INT16_C( 21866), INT16_C(  -554), INT16_C(-31252), INT16_C(-27281)),
      simde_mm256_set_epi16(INT16_C( 25542), INT16_C( -9091), INT16_C(  9964), INT16_C(  3641),
                            INT16_C( 10626), INT16_C(  1975), INT16_C( 32038), INT16_C( 13257),
                            INT16_C( 29088), INT16_C( 26903), INT16_C( 27784), INT16_C( 20929),
                            INT16_C( 24986), INT16_C( 19201), INT16_C(-21133), INT16_C(  -544)) },
    { simde_mm256_set_epi16(INT16_C(-28957), INT16_C(  7788), INT16_C(-11350), INT16_C( 29385),
                            INT16_C( -7207), INT16_C(-21363), INT16_C(-10963), INT16_C(-23177),
                            INT16_C( 22883), INT16_C(-14765), INT16_C( 17155), INT16_C(-19202),
                            INT16_C(-32343), INT16_C(  8167), INT16_C( 17107), INT16_C(-17194)),
      simde_mm256_set_epi16(INT16_C(-21587), INT16_C( 21036), INT16_C( 16036), INT16_C(-20844),
                            INT16_C(  2600), INT16_C(-15232), INT16_C(  4125), INT16_C( 22708),
                            INT16_C(-29000), INT16_C(-22285), INT16_C(  8338), INT16_C( 25191),
                            INT16_C(  5401), INT16_C(-28508), INT16_C(-16518), INT16_C(-23781)),
      simde_mm256_set_epi16(INT16_C(-21587), INT16_C( 21036), INT16_C( 16036), INT16_C( 29385),
                            INT16_C(  2600), INT16_C(-15232), INT16_C(  4125), INT16_C( 22708),
                            INT16_C( 22883), INT16_C(-14765), INT16_C( 17155), INT16_C( 25191),
                            INT16_C(  5401), INT16_C(  8167), INT16_C( 17107), INT16_C(-17194)) },
    { simde_mm256_set_epi16(INT16_C( 26823), INT16_C( 30422), INT16_C(-10399), INT16_C(  6469),
                            INT16_C(-22608), INT16_C(  3602), INT16_C( 24356), INT16_C( -5312),
                            INT16_C( 22553), INT16_C(  4057), INT16_C( 16984), INT16_C( 14642),
                            INT16_C( -4725), INT16_C(-13132), INT16_C(-32486), INT16_C( -9795)),
      simde_mm256_set_epi16(INT16_C(-16670), INT16_C( 11037), INT16_C(-12867), INT16_C( -9733),
                            INT16_C(-19057), INT16_C( 28626), INT16_C( 27349), INT16_C( 21991),
                            INT16_C(-17860), INT16_C( -7267), INT16_C( 21708), INT16_C( 27219),
                            INT16_C(  3344), INT16_C(-13000), INT16_C( -5702), INT16_C(  8873)),
      simde_mm256_set_epi16(INT16_C( 26823), INT16_C( 30422), INT16_C(-10399), INT16_C(  6469),
                            INT16_C(-19057), INT16_C( 28626), INT16_C( 27349), INT16_C( 21991),
                            INT16_C( 22553), INT16_C(  4057), INT16_C( 21708), INT16_C( 27219),
                            INT16_C(  3344), INT16_C(-13000), INT16_C( -5702), INT16_C(  8873)) },
    { simde_mm256_set_epi16(INT16_C( 28327), INT16_C( 28059), INT16_C(-12455), INT16_C(-22892),
                            INT16_C(  9516), INT16_C(-23091), INT16_C( 28067), INT16_C( 29028),
                            INT16_C(-24610), INT16_C(-13303), INT16_C( -3871), INT16_C( 25753),
                            INT16_C(-19764), INT16_C(-10115), INT16_C( -9313), INT16_C(-10807)),
      simde_mm256_set_epi16(INT16_C(  1267), INT16_C( -7929), INT16_C( 29505), INT16_C( 22745),
                            INT16_C(  1801), INT16_C(  -829), INT16_C(  2659), INT16_C( 24204),
                            INT16_C( 27266), INT16_C(-10805), INT16_C(  7071), INT16_C( 12404),
                            INT16_C( 27748), INT16_C( 11490), INT16_C(-10130), INT16_C(  7320)),
      simde_mm256_set_epi16(INT16_C( 28327), INT16_C( 28059), INT16_C( 29505), INT16_C( 22745),
                            INT16_C(  9516), INT16_C(  -829), INT16_C( 28067), INT16_C( 29028),
                            INT16_C( 27266), INT16_C(-10805), INT16_C(  7071), INT16_C( 25753),
                            INT16_C( 27748), INT16_C( 11490), INT16_C( -9313), INT16_C(  7320)) },
    { simde_mm256_set_epi16(INT16_C(-28396), INT16_C(  3489), INT16_C( 18687), INT16_C( 31879),
                            INT16_C( 15536), INT16_C(-17843), INT16_C( 25087), INT16_C(-27693),
                            INT16_C(-17170), INT16_C( 22369), INT16_C(-27360), INT16_C( -5829),
                            INT16_C(-28550), INT16_C(   650), INT16_C(-11446), INT16_C(  3172)),
      simde_mm256_set_epi16(INT16_C(-17057), INT16_C(-18950), INT16_C( 15210), INT16_C(-25469),
                            INT16_C(-29475), INT16_C( 24211), INT16_C(-14409), INT16_C( -9847),
                            INT16_C( 14530), INT16_C(-24184), INT16_C(-29404), INT16_C(  9879),
                            INT16_C(  2544), INT16_C(-17943), INT16_C(  7392), INT16_C( 21259)),
      simde_mm256_set_epi16(INT16_C(-17057), INT16_C(  3489), INT16_C( 18687), INT16_C( 31879),
                            INT16_C( 15536), INT16_C( 24211), INT16_C( 25087), INT16_C( -9847),
                            INT16_C( 14530), INT16_C( 22369), INT16_C(-27360), INT16_C(  9879),
                            INT16_C(  2544), INT16_C(   650), INT16_C(  7392), INT16_C( 21259)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_max_epi16(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_max_epi32(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi32(INT32_C(-1578701412), INT32_C(-1861943275), INT32_C( 1717826073), INT32_C( -689858277),
                            INT32_C(-2120069619), INT32_C( -269745295), INT32_C(  993893699), INT32_C( 1747535129)),
      simde_mm256_set_epi32(INT32_C(-1662415513), INT32_C(  528745592), INT32_C( -219858588), INT32_C(  622357704),
                            INT32_C(-2013314779), INT32_C(-1188086430), INT32_C( 1171120200), INT32_C(  259652605)),
      simde_mm256_set_epi32(INT32_C(-1578701412), INT32_C(  528745592), INT32_C( 1717826073), INT32_C(  622357704),
                            INT32_C(-2013314779), INT32_C( -269745295), INT32_C( 1171120200), INT32_C( 1747535129)) },
    { simde_mm256_set_epi32(INT32_C( 1892880717), INT32_C(  489135272), INT32_C( 1334433155), INT32_C(  820950025),
                            INT32_C(  875780372), INT32_C( 1165542940), INT32_C(-1922521413), INT32_C( 1603602866)),
      simde_mm256_set_epi32(INT32_C( 1774078122), INT32_C(  717307143), INT32_C( 1385706638), INT32_C( 1722931608),
                            INT32_C(  722989282), INT32_C(  346685962), INT32_C(  888351034), INT32_C(-1040558861)),
      simde_mm256_set_epi32(INT32_C( 1892880717), INT32_C(  717307143), INT32_C( 1385706638), INT32_C( 1722931608),
                            INT32_C(  875780372), INT32_C( 1165542940), INT32_C(  888351034), INT32_C( 1603602866)) },
    { simde_mm256_set_epi32(INT32_C(  542527818), INT32_C(  704072326), INT32_C(-1102544845), INT32_C( 1444592706),
                            INT32_C(-1925092178), INT32_C( -204731801), INT32_C(  775742710), INT32_C( 1177505754)),
      simde_mm256_set_epi32(INT32_C( -551142491), INT32_C(  444795418), INT32_C( -825745617), INT32_C(-1787304548),
                            INT32_C(-1241777147), INT32_C(  265612525), INT32_C( 2134936507), INT32_C(-1780599144)),
      simde_mm256_set_epi32(INT32_C(  542527818), INT32_C(  704072326), INT32_C( -825745617), INT32_C( 1444592706),
                            INT32_C(-1241777147), INT32_C(  265612525), INT32_C( 2134936507), INT32_C( 1177505754)) },
    { simde_mm256_set_epi32(INT32_C(  788610578), INT32_C( 1831830497), INT32_C( -755374494), INT32_C( 2130364415),
                            INT32_C( -342185910), INT32_C(  854700402), INT32_C( 1343385181), INT32_C(  891289886)),
      simde_mm256_set_epi32(INT32_C( 1917738489), INT32_C(  690751883), INT32_C(-1037858966), INT32_C(-1567909551),
                            INT32_C(  -26783282), INT32_C( -715472333), INT32_C( -713074037), INT32_C(  -17697982)),
      simde_mm256_set_epi32(INT32_C( 1917738489), INT32_C( 1831830497), INT32_C( -755374494), INT32_C( 2130364415),
                            INT32_C(  -26783282), INT32_C(  854700402), INT32_C( 1343385181), INT32_C(  891289886)) },
    { simde_mm256_set_epi32(INT32_C( 1796568981), INT32_C(-1846046069), INT32_C(-1495880353), INT32_C(-1105562137),
                            INT32_C(-2000119429), INT32_C(  450352139), INT32_C( -734796291), INT32_C(-1851159287)),
      simde_mm256_set_epi32(INT32_C( 1076027923), INT32_C( 1999677975), INT32_C( -498539521), INT32_C(-1166856281),
                            INT32_C(-1611419248), INT32_C(-1268341170), INT32_C(-1115547457), INT32_C( 1554907000)),
      simde_mm256_set_epi32(INT32_C( 1796568981), INT32_C( 1999677975), INT32_C( -498539521), INT32_C(-1105562137),
                            INT32_C(-1611419248), INT32_C(  450352139), INT32_C( -734796291), INT32_C( 1554907000)) },
    { simde_mm256_set_epi32(INT32_C( -263364521), INT32_C( 1666932430), INT32_C(  378039954), INT32_C( 1866502452),
                            INT32_C( -756222443), INT32_C( -752660448), INT32_C( 1087715357), INT32_C( 1808069656)),
      simde_mm256_set_epi32(INT32_C(   10375777), INT32_C(  958545984), INT32_C(-1916055393), INT32_C(-1450264731),
                            INT32_C( -550755823), INT32_C( 2131394316), INT32_C(  243861812), INT32_C( 1031114919)),
      simde_mm256_set_epi32(INT32_C(   10375777), INT32_C( 1666932430), INT32_C(  378039954), INT32_C( 1866502452),
                            INT32_C( -550755823), INT32_C( 2131394316), INT32_C( 1087715357), INT32_C( 1808069656)) },
    { simde_mm256_set_epi32(INT32_C(-1075159077), INT32_C( -789508054), INT32_C(-2102436600), INT32_C(  177892995),
                            INT32_C(-1910430929), INT32_C( -135620958), INT32_C( 1899951190), INT32_C(-1286116105)),
      simde_mm256_set_epi32(INT32_C(-1117240644), INT32_C(-1011771686), INT32_C(-1764247251), INT32_C( -953836385),
                            INT32_C(-1633093106), INT32_C( 1815106343), INT32_C( 1418749534), INT32_C( 1718021188)),
      simde_mm256_set_epi32(INT32_C(-1075159077), INT32_C( -789508054), INT32_C(-1764247251), INT32_C(  177892995),
                            INT32_C(-1633093106), INT32_C( 1815106343), INT32_C( 1899951190), INT32_C( 1718021188)) },
    { simde_mm256_set_epi32(INT32_C( -585726505), INT32_C( -735532451), INT32_C( 1572773329), INT32_C(-1610167093),
                            INT32_C(  934479765), INT32_C( 1726304740), INT32_C(-1433078949), INT32_C(-1056217637)),
      simde_mm256_set_epi32(INT32_C(  201330788), INT32_C( 1825214883), INT32_C(  489777084), INT32_C( -824102072),
                            INT32_C(-1255028012), INT32_C(-1300324544), INT32_C(-1269112569), INT32_C( -124131174)),
      simde_mm256_set_epi32(INT32_C(  201330788), INT32_C( 1825214883), INT32_C( 1572773329), INT32_C( -824102072),
                            INT32_C(  934479765), INT32_C( 1726304740), INT32_C(-1269112569), INT32_C( -124131174)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_max_epi32(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_min_epu8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_x_mm256_set_epu8(UINT8_C( 83), UINT8_C( 77), UINT8_C(142), UINT8_C(252),
                             UINT8_C( 19), UINT8_C( 26), UINT8_C(193), UINT8_C( 92),
                             UINT8_C(253), UINT8_C(183), UINT8_C(225), UINT8_C(205),
                             UINT8_C(165), UINT8_C( 19), UINT8_C(154), UINT8_C(158),
                             UINT8_C(126), UINT8_C(221), UINT8_C(206), UINT8_C( 22),
                             UINT8_C(217), UINT8_C(166), UINT8_C(237), UINT8_C(161),
                             UINT8_C(207), UINT8_C( 26), UINT8_C( 36), UINT8_C( 78),
                             UINT8_C( 55), UINT8_C(167), UINT8_C( 36), UINT8_C(198)),
      simde_x_mm256_set_epu8(UINT8_C(203), UINT8_C( 44), UINT8_C( 47), UINT8_C( 51),
                             UINT8_C(185), UINT8_C( 39), UINT8_C(221), UINT8_C( 75),
                             UINT8_C(182), UINT8_C(100), UINT8_C(238), UINT8_C(172),
                             UINT8_C(248), UINT8_C(164), UINT8_C( 91), UINT8_C(138),
                             UINT8_C(128), UINT8_C( 29), UINT8_C(136), UINT8_C(164),
                             UINT8_C( 43), UINT8_C( 85), UINT8_C(168), UINT8_C(105),
                             UINT8_C(240), UINT8_C(205), UINT8_C(221), UINT8_C(217),
                             UINT8_C(244), UINT8_C(220), UINT8_C(102), UINT8_C( 37)),
      simde_x_mm256_set_epu8(UINT8_C( 83), UINT8_C( 44), UINT8_C( 47), UINT8_C( 51),
                             UINT8_C( 19), UINT8_C( 26), UINT8_C(193), UINT8_C( 75),
                             UINT8_C(182), UINT8_C(100), UINT8_C(225), UINT8_C(172),
                             UINT8_C(165), UINT8_C( 19), UINT8_C( 91), UINT8_C(138),
                             UINT8_C(126), UINT8_C( 29), UINT8_C(136), UINT8_C( 22),
                             UINT8_C( 43), UINT8_C( 85), UINT8_C(168), UINT8_C(105),
                             UINT8_C(207), UINT8_C( 26), UINT8_C( 36), UINT8_C( 78),
                             UINT8_C( 55), UINT8_C(167), UINT8_C( 36), UINT8_C( 37)) },
    { simde_x_mm256_set_epu8(UINT8_C(177), UINT8_C(210), UINT8_C( 28), UINT8_C(116),
                             UINT8_C(174), UINT8_C(162), UINT8_C(241), UINT8_C( 21),
                             UINT8_C(126), UINT8_C(202), UINT8_C(250), UINT8_C(169),
                             UINT8_C( 43), UINT8_C(239), UINT8_C(224), UINT8_C(202),
                             UINT8_C(208), UINT8_C( 48), UINT8_C(132), UINT8_C( 78),
                             UINT8_C( 59), UINT8_C(  2), UINT8_C(213), UINT8_C(228),
                             UINT8_C( 42), UINT8_C( 45), UINT8_C(244), UINT8_C( 41),
                             UINT8_C( 49), UINT8_C( 48), UINT8_C(111), UINT8_C(211)),
      simde_x_mm256_set_epu8(UINT8_C(114), UINT8_C( 33), UINT8_C(210), UINT8_C(232),
                             UINT8_C(128), UINT8_C(122), UINT8_C(216), UINT8_C(228),
                             UINT8_C( 91), UINT8_C( 37), UINT8_C(119), UINT8_C(203),
                             UINT8_C(236), UINT8_C( 24), UINT8_C(170), UINT8_C(120),
                             UINT8_C( 95), UINT8_C(231), UINT8_C(152), UINT8_C(143),
                             UINT8_C( 42), UINT8_C( 38), UINT8_C(240), UINT8_C(125),
                             UINT8_C(124), UINT8_C(251), UINT8_C(118), UINT8_C( 44),
                             UINT8_C( 68), UINT8_C( 42), UINT8_C( 54), UINT8_C(185)),
      simde_x_mm256_set_epu8(UINT8_C(114), UINT8_C( 33), UINT8_C( 28), UINT8_C(116),
                             UINT8_C(128), UINT8_C(122), UINT8_C(216), UINT8_C( 21),
                             UINT8_C( 91), UINT8_C( 37), UINT8_C(119), UINT8_C(169),
                             UINT8_C( 43), UINT8_C( 24), UINT8_C(170), UINT8_C(120),
                             UINT8_C( 95), UINT8_C( 48), UINT8_C(132), UINT8_C( 78),
                             UINT8_C( 42), UINT8_C(  2), UINT8_C(213), UINT8_C(125),
                             UINT8_C( 42), UINT8_C( 45), UINT8_C(118), UINT8_C( 41),
                             UINT8_C( 49), UINT8_C( 42), UINT8_C( 54), UINT8_C(185)) },
    { simde_x_mm256_set_epu8(UINT8_C( 78), UINT8_C( 16), UINT8_C( 42), UINT8_C(217),
                             UINT8_C(  5), UINT8_C( 96), UINT8_C(  7), UINT8_C( 83),
                             UINT8_C( 16), UINT8_C(208), UINT8_C(  1), UINT8_C(207),
                             UINT8_C( 75), UINT8_C(207), UINT8_C(252), UINT8_C( 92),
                             UINT8_C(122), UINT8_C( 24), UINT8_C( 32), UINT8_C(104),
                             UINT8_C( 88), UINT8_C( 59), UINT8_C(218), UINT8_C( 28),
                             UINT8_C( 51), UINT8_C( 64), UINT8_C( 65), UINT8_C( 92),
                             UINT8_C( 24), UINT8_C( 83), UINT8_C(248), UINT8_C(243)),
      simde_x_mm256_set_epu8(UINT8_C(167), UINT8_C( 87), UINT8_C( 75), UINT8_C( 10),
                             UINT8_C( 44), UINT8_C(173), UINT8_C(210), UINT8_C(150),
                             UINT8_C(187), UINT8_C(229), UINT8_C(246), UINT8_C( 10),
                             UINT8_C( 80), UINT8_C( 74), UINT8_C(174), UINT8_C(128),
                             UINT8_C( 64), UINT8_C(160), UINT8_C(126), UINT8_C(231),
                             UINT8_C(215), UINT8_C( 80), UINT8_C(115), UINT8_C( 66),
                             UINT8_C(204), UINT8_C( 18), UINT8_C(158), UINT8_C(133),
                             UINT8_C(170), UINT8_C(119), UINT8_C(216), UINT8_C(196)),
      simde_x_mm256_set_epu8(UINT8_C( 78), UINT8_C( 16), UINT8_C( 42), UINT8_C( 10),
                             UINT8_C(  5), UINT8_C( 96), UINT8_C(  7), UINT8_C( 83),
                             UINT8_C( 16), UINT8_C(208), UINT8_C(  1), UINT8_C( 10),
                             UINT8_C( 75), UINT8_C( 74), UINT8_C(174), UINT8_C( 92),
                             UINT8_C( 64), UINT8_C( 24), UINT8_C( 32), UINT8_C(104),
                             UINT8_C( 88), UINT8_C( 59), UINT8_C(115), UINT8_C( 28),
                             UINT8_C( 51), UINT8_C( 18), UINT8_C( 65), UINT8_C( 92),
                             UINT8_C( 24), UINT8_C( 83), UINT8_C(216), UINT8_C(196)) },
    { simde_x_mm256_set_epu8(UINT8_C(  4), UINT8_C(145), UINT8_C( 75), UINT8_C( 42),
                             UINT8_C( 60), UINT8_C(146), UINT8_C(158), UINT8_C(  3),
                             UINT8_C( 57), UINT8_C(210), UINT8_C( 14), UINT8_C(106),
                             UINT8_C( 96), UINT8_C(136), UINT8_C( 82), UINT8_C( 54),
                             UINT8_C(227), UINT8_C(202), UINT8_C( 35), UINT8_C(184),
                             UINT8_C( 41), UINT8_C(205), UINT8_C(162), UINT8_C(206),
                             UINT8_C(247), UINT8_C( 69), UINT8_C(139), UINT8_C(186),
                             UINT8_C( 13), UINT8_C(119), UINT8_C( 79), UINT8_C( 53)),
      simde_x_mm256_set_epu8(UINT8_C(239), UINT8_C(239), UINT8_C( 37), UINT8_C(187),
                             UINT8_C(237), UINT8_C(203), UINT8_C( 68), UINT8_C( 35),
                             UINT8_C(147), UINT8_C(109), UINT8_C(244), UINT8_C(194),
                             UINT8_C(131), UINT8_C(189), UINT8_C( 51), UINT8_C( 84),
                             UINT8_C( 48), UINT8_C( 26), UINT8_C(203), UINT8_C( 35),
                             UINT8_C(128), UINT8_C( 76), UINT8_C( 16), UINT8_C( 52),
                             UINT8_C(103), UINT8_C(192), UINT8_C(105), UINT8_C( 65),
                             UINT8_C(117), UINT8_C(100), UINT8_C( 71), UINT8_C(124)),
      simde_x_mm256_set_epu8(UINT8_C(  4), UINT8_C(145), UINT8_C( 37), UINT8_C( 42),
                             UINT8_C( 60), UINT8_C(146), UINT8_C( 68), UINT8_C(  3),
                             UINT8_C( 57), UINT8_C(109), UINT8_C( 14), UINT8_C(106),
                             UINT8_C( 96), UINT8_C(136), UINT8_C( 51), UINT8_C( 54),
                             UINT8_C( 48), UINT8_C( 26), UINT8_C( 35), UINT8_C( 35),
                             UINT8_C( 41), UINT8_C( 76), UINT8_C( 16), UINT8_C( 52),
                             UINT8_C(103), UINT8_C( 69), UINT8_C(105), UINT8_C( 65),
                             UINT8_C( 13), UINT8_C(100), UINT8_C( 71), UINT8_C( 53)) },
    { simde_x_mm256_set_epu8(UINT8_C(144), UINT8_C(140), UINT8_C(121), UINT8_C(161),
                             UINT8_C(  2), UINT8_C( 56), UINT8_C(102), UINT8_C(220),
                             UINT8_C(246), UINT8_C( 67), UINT8_C( 19), UINT8_C( 67),
                             UINT8_C( 18), UINT8_C(117), UINT8_C(155), UINT8_C( 84),
                             UINT8_C(  3), UINT8_C(204), UINT8_C( 72), UINT8_C( 34),
                             UINT8_C(218), UINT8_C(208), UINT8_C( 99), UINT8_C( 27),
                             UINT8_C(224), UINT8_C( 99), UINT8_C(119), UINT8_C(221),
                             UINT8_C( 98), UINT8_C(202), UINT8_C(146), UINT8_C( 18)),
      simde_x_mm256_set_epu8(UINT8_C(127), UINT8_C(108), UINT8_C( 76), UINT8_C(146),
                             UINT8_C(206), UINT8_C(221), UINT8_C(206), UINT8_C(168),
                             UINT8_C( 11), UINT8_C(166), UINT8_C(228), UINT8_C(131),
                             UINT8_C( 46), UINT8_C( 42), UINT8_C(192), UINT8_C(117),
                             UINT8_C(166), UINT8_C(151), UINT8_C(189), UINT8_C(138),
                             UINT8_C(121), UINT8_C( 19), UINT8_C( 89), UINT8_C(188),
                             UINT8_C(255), UINT8_C(104), UINT8_C(124), UINT8_C(206),
                             UINT8_C( 89), UINT8_C(160), UINT8_C(162), UINT8_C( 10)),
      simde_x_mm256_set_epu8(UINT8_C(127), UINT8_C(108), UINT8_C( 76), UINT8_C(146),
                             UINT8_C(  2), UINT8_C( 56), UINT8_C(102), UINT8_C(168),
                             UINT8_C( 11), UINT8_C( 67), UINT8_C( 19), UINT8_C( 67),
                             UINT8_C( 18), UINT8_C( 42), UINT8_C(155), UINT8_C( 84),
                             UINT8_C(  3), UINT8_C(151), UINT8_C( 72), UINT8_C( 34),
                             UINT8_C(121), UINT8_C( 19), UINT8_C( 89), UINT8_C( 27),
                             UINT8_C(224), UINT8_C( 99), UINT8_C(119), UINT8_C(206),
                             UINT8_C( 89), UINT8_C(160), UINT8_C(146), UINT8_C( 10)) },
    { simde_x_mm256_set_epu8(UINT8_C( 74), UINT8_C(143), UINT8_C( 19), UINT8_C(  8),
                             UINT8_C( 11), UINT8_C(124), UINT8_C( 76), UINT8_C(  6),
                             UINT8_C(148), UINT8_C( 67), UINT8_C(224), UINT8_C(163),
                             UINT8_C(113), UINT8_C(245), UINT8_C( 59), UINT8_C( 27),
                             UINT8_C(131), UINT8_C(161), UINT8_C(251), UINT8_C(125),
                             UINT8_C(201), UINT8_C(252), UINT8_C(140), UINT8_C( 24),
                             UINT8_C(254), UINT8_C(183), UINT8_C(205), UINT8_C(238),
                             UINT8_C(180), UINT8_C( 21), UINT8_C( 59), UINT8_C(174)),
      simde_x_mm256_set_epu8(UINT8_C( 98), UINT8_C(152), UINT8_C(212), UINT8_C(148),
                             UINT8_C(183), UINT8_C( 37), UINT8_C(170), UINT8_C( 93),
                             UINT8_C( 52), UINT8_C(182), UINT8_C(181), UINT8_C(242),
                             UINT8_C(229), UINT8_C(182), UINT8_C(143), UINT8_C( 43),
                             UINT8_C(177), UINT8_C(115), UINT8_C(177), UINT8_C(170),
                             UINT8_C( 71), UINT8_C(222), UINT8_C(162), UINT8_C(198),
                             UINT8_C(195), UINT8_C(222), UINT8_C( 10), UINT8_C( 86),
                             UINT8_C( 48), UINT8_C(215), UINT8_C( 16), UINT8_C( 69)),
      simde_x_mm256_set_epu8(UINT8_C( 74), UINT8_C(143), UINT8_C( 19), UINT8_C(  8),
                             UINT8_C( 11), UINT8_C( 37), UINT8_C( 76), UINT8_C(  6),
                             UINT8_C( 52), UINT8_C( 67), UINT8_C(181), UINT8_C(163),
                             UINT8_C(113), UINT8_C(182), UINT8_C( 59), UINT8_C( 27),
                             UINT8_C(131), UINT8_C(115), UINT8_C(177), UINT8_C(125),
                             UINT8_C( 71), UINT8_C(222), UINT8_C(140), UINT8_C( 24),
                             UINT8_C(195), UINT8_C(183), UINT8_C( 10), UINT8_C( 86),
                             UINT8_C( 48), UINT8_C( 21), UINT8_C( 16), UINT8_C( 69)) },
    { simde_x_mm256_set_epu8(UINT8_C(119), UINT8_C(117), UINT8_C( 13), UINT8_C(207),
                             UINT8_C( 70), UINT8_C(197), UINT8_C(152), UINT8_C( 89),
                             UINT8_C(135), UINT8_C(159), UINT8_C( 50), UINT8_C(184),
                             UINT8_C(155), UINT8_C( 62), UINT8_C(253), UINT8_C(248),
                             UINT8_C(240), UINT8_C(207), UINT8_C( 53), UINT8_C(202),
                             UINT8_C(203), UINT8_C(241), UINT8_C(218), UINT8_C(118),
                             UINT8_C(121), UINT8_C(140), UINT8_C(125), UINT8_C( 65),
                             UINT8_C( 70), UINT8_C(249), UINT8_C(217), UINT8_C(237)),
      simde_x_mm256_set_epu8(UINT8_C(125), UINT8_C( 67), UINT8_C( 52), UINT8_C(  8),
                             UINT8_C(207), UINT8_C(205), UINT8_C( 56), UINT8_C(196),
                             UINT8_C( 42), UINT8_C(240), UINT8_C(116), UINT8_C( 44),
                             UINT8_C(109), UINT8_C(201), UINT8_C(220), UINT8_C(182),
                             UINT8_C(224), UINT8_C( 99), UINT8_C(151), UINT8_C(222),
                             UINT8_C(220), UINT8_C(252), UINT8_C(  6), UINT8_C(245),
                             UINT8_C(215), UINT8_C(221), UINT8_C(177), UINT8_C(240),
                             UINT8_C(118), UINT8_C(155), UINT8_C(143), UINT8_C(240)),
      simde_x_mm256_set_epu8(UINT8_C(119), UINT8_C( 67), UINT8_C( 13), UINT8_C(  8),
                             UINT8_C( 70), UINT8_C(197), UINT8_C( 56), UINT8_C( 89),
                             UINT8_C( 42), UINT8_C(159), UINT8_C( 50), UINT8_C( 44),
                             UINT8_C(109), UINT8_C( 62), UINT8_C(220), UINT8_C(182),
                             UINT8_C(224), UINT8_C( 99), UINT8_C( 53), UINT8_C(202),
                             UINT8_C(203), UINT8_C(241), UINT8_C(  6), UINT8_C(118),
                             UINT8_C(121), UINT8_C(140), UINT8_C(125), UINT8_C( 65),
                             UINT8_C( 70), UINT8_C(155), UINT8_C(143), UINT8_C(237)) },
    { simde_x_mm256_set_epu8(UINT8_C(201), UINT8_C(240), UINT8_C( 36), UINT8_C( 35),
                             UINT8_C(236), UINT8_C( 73), UINT8_C( 29), UINT8_C(244),
                             UINT8_C(140), UINT8_C( 36), UINT8_C(200), UINT8_C(155),
                             UINT8_C(  8), UINT8_C(245), UINT8_C( 10), UINT8_C( 93),
                             UINT8_C(124), UINT8_C(125), UINT8_C( 25), UINT8_C(192),
                             UINT8_C( 32), UINT8_C(119), UINT8_C(142), UINT8_C(147),
                             UINT8_C( 56), UINT8_C( 66), UINT8_C(172), UINT8_C(214),
                             UINT8_C(227), UINT8_C(203), UINT8_C( 62), UINT8_C( 37)),
      simde_x_mm256_set_epu8(UINT8_C(  5), UINT8_C( 64), UINT8_C(205), UINT8_C(118),
                             UINT8_C( 53), UINT8_C(  5), UINT8_C( 28), UINT8_C( 17),
                             UINT8_C( 93), UINT8_C(223), UINT8_C( 18), UINT8_C( 93),
                             UINT8_C(210), UINT8_C(158), UINT8_C( 37), UINT8_C( 66),
                             UINT8_C(184), UINT8_C(142), UINT8_C(246), UINT8_C( 15),
                             UINT8_C(153), UINT8_C(  9), UINT8_C(121), UINT8_C(211),
                             UINT8_C(  7), UINT8_C( 12), UINT8_C( 41), UINT8_C( 14),
                             UINT8_C(127), UINT8_C(208), UINT8_C(  7), UINT8_C( 93)),
      simde_x_mm256_set_epu8(UINT8_C(  5), UINT8_C( 64), UINT8_C( 36), UINT8_C( 35),
                             UINT8_C( 53), UINT8_C(  5), UINT8_C( 28), UINT8_C( 17),
                             UINT8_C( 93), UINT8_C( 36), UINT8_C( 18), UINT8_C( 93),
                             UINT8_C(  8), UINT8_C(158), UINT8_C( 10), UINT8_C( 66),
                             UINT8_C(124), UINT8_C(125), UINT8_C( 25), UINT8_C( 15),
                             UINT8_C( 32), UINT8_C(  9), UINT8_C(121), UINT8_C(147),
                             UINT8_C(  7), UINT8_C( 12), UINT8_C( 41), UINT8_C( 14),
                             UINT8_C(127), UINT8_C(203), UINT8_C(  7), UINT8_C( 37)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_min_epu8(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_u8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_min_epu16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_x_mm256_set_epu16(UINT16_C( 21985), UINT16_C( 37408), UINT16_C( 64559), UINT16_C( 50506),
                              UINT16_C( 21348), UINT16_C( 50917), UINT16_C( 43331), UINT16_C(  4092),
                              UINT16_C( 58372), UINT16_C(  9106), UINT16_C( 30380), UINT16_C( 36427),
                              UINT16_C( 37095), UINT16_C( 38478), UINT16_C( 20272), UINT16_C( 48447)),
      simde_x_mm256_set_epu16(UINT16_C(  1564), UINT16_C( 15505), UINT16_C( 60508), UINT16_C( 59764),
                              UINT16_C(  4697), UINT16_C( 47817), UINT16_C(  4510), UINT16_C( 63199),
                              UINT16_C( 46692), UINT16_C( 14440), UINT16_C( 53716), UINT16_C(  9747),
                              UINT16_C( 59579), UINT16_C( 43113), UINT16_C( 42711), UINT16_C( 11767)),
      simde_x_mm256_set_epu16(UINT16_C(  1564), UINT16_C( 15505), UINT16_C( 60508), UINT16_C( 50506),
                              UINT16_C(  4697), UINT16_C( 47817), UINT16_C(  4510), UINT16_C(  4092),
                              UINT16_C( 46692), UINT16_C(  9106), UINT16_C( 30380), UINT16_C(  9747),
                              UINT16_C( 37095), UINT16_C( 38478), UINT16_C( 20272), UINT16_C( 11767)) },
    { simde_x_mm256_set_epu16(UINT16_C( 19955), UINT16_C(   258), UINT16_C(  7499), UINT16_C( 10868),
                              UINT16_C(  6000), UINT16_C( 24962), UINT16_C( 19695), UINT16_C( 32604),
                              UINT16_C( 25690), UINT16_C(  5375), UINT16_C(  7487), UINT16_C( 63875),
                              UINT16_C( 58580), UINT16_C( 15823), UINT16_C( 50945), UINT16_C( 25251)),
      simde_x_mm256_set_epu16(UINT16_C( 40574), UINT16_C( 18810), UINT16_C( 13888), UINT16_C( 49326),
                              UINT16_C( 64223), UINT16_C( 65297), UINT16_C( 61868), UINT16_C( 28086),
                              UINT16_C( 41020), UINT16_C( 35514), UINT16_C( 58890), UINT16_C(  3107),
                              UINT16_C(  7813), UINT16_C( 34771), UINT16_C( 34306), UINT16_C( 41125)),
      simde_x_mm256_set_epu16(UINT16_C( 19955), UINT16_C(   258), UINT16_C(  7499), UINT16_C( 10868),
                              UINT16_C(  6000), UINT16_C( 24962), UINT16_C( 19695), UINT16_C( 28086),
                              UINT16_C( 25690), UINT16_C(  5375), UINT16_C(  7487), UINT16_C(  3107),
                              UINT16_C(  7813), UINT16_C( 15823), UINT16_C( 34306), UINT16_C( 25251)) },
    { simde_x_mm256_set_epu16(UINT16_C( 54635), UINT16_C( 31649), UINT16_C( 37203), UINT16_C( 44269),
                              UINT16_C( 35808), UINT16_C( 48759), UINT16_C( 30288), UINT16_C( 48436),
                              UINT16_C( 40625), UINT16_C( 61846), UINT16_C( 14756), UINT16_C( 44804),
                              UINT16_C(  3949), UINT16_C( 42131), UINT16_C( 39125), UINT16_C( 37028)),
      simde_x_mm256_set_epu16(UINT16_C( 57949), UINT16_C( 27621), UINT16_C( 31226), UINT16_C( 53362),
                              UINT16_C( 27488), UINT16_C( 47169), UINT16_C( 31030), UINT16_C( 24207),
                              UINT16_C(  4423), UINT16_C( 14910), UINT16_C( 30727), UINT16_C( 21908),
                              UINT16_C( 50230), UINT16_C( 46262), UINT16_C( 25828), UINT16_C( 42233)),
      simde_x_mm256_set_epu16(UINT16_C( 54635), UINT16_C( 27621), UINT16_C( 31226), UINT16_C( 44269),
                              UINT16_C( 27488), UINT16_C( 47169), UINT16_C( 30288), UINT16_C( 24207),
                              UINT16_C(  4423), UINT16_C( 14910), UINT16_C( 14756), UINT16_C( 21908),
                              UINT16_C(  3949), UINT16_C( 42131), UINT16_C( 25828), UINT16_C( 37028)) },
    { simde_x_mm256_set_epu16(UINT16_C( 20152), UINT16_C( 27686), UINT16_C( 12466), UINT16_C( 27372),
                              UINT16_C( 44680), UINT16_C(  5041), UINT16_C( 65098), UINT16_C( 61815),
                              UINT16_C( 46798), UINT16_C( 41939), UINT16_C( 44487), UINT16_C( 43543),
                              UINT16_C( 48144), UINT16_C( 56243), UINT16_C( 61060), UINT16_C( 26152)),
      simde_x_mm256_set_epu16(UINT16_C(  5079), UINT16_C( 44741), UINT16_C( 26080), UINT16_C( 22525),
                              UINT16_C( 28605), UINT16_C(  1946), UINT16_C( 59845), UINT16_C( 20686),
                              UINT16_C( 33395), UINT16_C( 20058), UINT16_C( 31413), UINT16_C( 18280),
                              UINT16_C( 56644), UINT16_C( 26935), UINT16_C( 15289), UINT16_C( 20043)),
      simde_x_mm256_set_epu16(UINT16_C(  5079), UINT16_C( 27686), UINT16_C( 12466), UINT16_C( 22525),
                              UINT16_C( 28605), UINT16_C(  1946), UINT16_C( 59845), UINT16_C( 20686),
                              UINT16_C( 33395), UINT16_C( 20058), UINT16_C( 31413), UINT16_C( 18280),
                              UINT16_C( 48144), UINT16_C( 26935), UINT16_C( 15289), UINT16_C( 20043)) },
    { simde_x_mm256_set_epu16(UINT16_C( 50822), UINT16_C( 22037), UINT16_C( 40380), UINT16_C( 27848),
                              UINT16_C( 22453), UINT16_C( 65299), UINT16_C(   416), UINT16_C( 55389),
                              UINT16_C(  3972), UINT16_C( 20597), UINT16_C(  3476), UINT16_C( 46123),
                              UINT16_C( 29301), UINT16_C( 51108), UINT16_C( 35981), UINT16_C(  8905)),
      simde_x_mm256_set_epu16(UINT16_C( 25885), UINT16_C( 59271), UINT16_C( 16174), UINT16_C( 33039),
                              UINT16_C( 55355), UINT16_C( 49380), UINT16_C( 36750), UINT16_C( 16476),
                              UINT16_C( 22855), UINT16_C( 12806), UINT16_C(  3167), UINT16_C( 41606),
                              UINT16_C( 57407), UINT16_C( 61681), UINT16_C( 28474), UINT16_C( 18472)),
      simde_x_mm256_set_epu16(UINT16_C( 25885), UINT16_C( 22037), UINT16_C( 16174), UINT16_C( 27848),
                              UINT16_C( 22453), UINT16_C( 49380), UINT16_C(   416), UINT16_C( 16476),
                              UINT16_C(  3972), UINT16_C( 12806), UINT16_C(  3167), UINT16_C( 41606),
                              UINT16_C( 29301), UINT16_C( 51108), UINT16_C( 28474), UINT16_C(  8905)) },
    { simde_x_mm256_set_epu16(UINT16_C( 38411), UINT16_C( 38062), UINT16_C( 63184), UINT16_C(  5327),
                              UINT16_C(  2662), UINT16_C( 37879), UINT16_C( 38436), UINT16_C( 35926),
                              UINT16_C( 37505), UINT16_C( 16059), UINT16_C( 30023), UINT16_C( 13435),
                              UINT16_C( 55897), UINT16_C( 41272), UINT16_C( 35066), UINT16_C( 45732)),
      simde_x_mm256_set_epu16(UINT16_C(  4290), UINT16_C(  8244), UINT16_C( 17610), UINT16_C( 27365),
                              UINT16_C( 41082), UINT16_C( 32808), UINT16_C( 11681), UINT16_C( 25455),
                              UINT16_C(  5969), UINT16_C( 52658), UINT16_C( 58404), UINT16_C( 43100),
                              UINT16_C( 23433), UINT16_C( 56801), UINT16_C( 40070), UINT16_C( 43765)),
      simde_x_mm256_set_epu16(UINT16_C(  4290), UINT16_C(  8244), UINT16_C( 17610), UINT16_C(  5327),
                              UINT16_C(  2662), UINT16_C( 32808), UINT16_C( 11681), UINT16_C( 25455),
                              UINT16_C(  5969), UINT16_C( 16059), UINT16_C( 30023), UINT16_C( 13435),
                              UINT16_C( 23433), UINT16_C( 41272), UINT16_C( 35066), UINT16_C( 43765)) },
    { simde_x_mm256_set_epu16(UINT16_C(  3920), UINT16_C(  2672), UINT16_C(   125), UINT16_C( 16695),
                              UINT16_C(  9026), UINT16_C(  9313), UINT16_C( 36585), UINT16_C( 38441),
                              UINT16_C( 50905), UINT16_C( 11221), UINT16_C( 28122), UINT16_C( 18875),
                              UINT16_C( 30095), UINT16_C( 22178), UINT16_C( 51689), UINT16_C( 19916)),
      simde_x_mm256_set_epu16(UINT16_C( 58371), UINT16_C( 46494), UINT16_C( 62748), UINT16_C( 27388),
                              UINT16_C( 64543), UINT16_C( 23688), UINT16_C( 42332), UINT16_C( 43841),
                              UINT16_C( 27632), UINT16_C( 34295), UINT16_C( 21862), UINT16_C( 32789),
                              UINT16_C( 42560), UINT16_C( 49564), UINT16_C( 10833), UINT16_C( 33089)),
      simde_x_mm256_set_epu16(UINT16_C(  3920), UINT16_C(  2672), UINT16_C(   125), UINT16_C( 16695),
                              UINT16_C(  9026), UINT16_C(  9313), UINT16_C( 36585), UINT16_C( 38441),
                              UINT16_C( 27632), UINT16_C( 11221), UINT16_C( 21862), UINT16_C( 18875),
                              UINT16_C( 30095), UINT16_C( 22178), UINT16_C( 10833), UINT16_C( 19916)) },
    { simde_x_mm256_set_epu16(UINT16_C( 32155), UINT16_C( 62138), UINT16_C( 45089), UINT16_C( 64592),
                              UINT16_C( 57638), UINT16_C( 36363), UINT16_C( 16857), UINT16_C( 65526),
                              UINT16_C(  4908), UINT16_C( 33576), UINT16_C( 61433), UINT16_C( 64967),
                              UINT16_C( 30812), UINT16_C( 35007), UINT16_C(  3114), UINT16_C( 45540)),
      simde_x_mm256_set_epu16(UINT16_C( 46521), UINT16_C(  5351), UINT16_C( 22645), UINT16_C( 25668),
                              UINT16_C( 14295), UINT16_C( 52574), UINT16_C(  9596), UINT16_C( 37163),
                              UINT16_C( 27912), UINT16_C( 36566), UINT16_C( 34315), UINT16_C(  2157),
                              UINT16_C( 51210), UINT16_C( 14248), UINT16_C( 30537), UINT16_C( 57705)),
      simde_x_mm256_set_epu16(UINT16_C( 32155), UINT16_C(  5351), UINT16_C( 22645), UINT16_C( 25668),
                              UINT16_C( 14295), UINT16_C( 36363), UINT16_C(  9596), UINT16_C( 37163),
                              UINT16_C(  4908), UINT16_C( 33576), UINT16_C( 34315), UINT16_C(  2157),
                              UINT16_C( 30812), UINT16_C( 14248), UINT16_C(  3114), UINT16_C( 45540)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_min_epu16(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_u16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_min_epu32(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_x_mm256_set_epu32(UINT32_C(1967336836), UINT32_C(4229175532), UINT32_C(3383228965), UINT32_C( 979444700),
                              UINT32_C( 138906106), UINT32_C( 146006389), UINT32_C(2494756173), UINT32_C(2105904126)),
      simde_x_mm256_set_epu32(UINT32_C(2893387611), UINT32_C(2460478173), UINT32_C(3299027518), UINT32_C( 896184310),
                              UINT32_C(1699227452), UINT32_C(1922730015), UINT32_C(1220777705), UINT32_C( 483108197)),
      simde_x_mm256_set_epu32(UINT32_C(1967336836), UINT32_C(2460478173), UINT32_C(3299027518), UINT32_C( 896184310),
                              UINT32_C( 138906106), UINT32_C( 146006389), UINT32_C(1220777705), UINT32_C( 483108197)) },
    { simde_x_mm256_set_epu32(UINT32_C( 596030925), UINT32_C(1623933296), UINT32_C(4116080130), UINT32_C(2140384796),
                              UINT32_C(1701047302), UINT32_C( 386212074), UINT32_C( 328829151), UINT32_C(3670208831)),
      simde_x_mm256_set_epu32(UINT32_C(3740465827), UINT32_C(1627250042), UINT32_C(2355376593), UINT32_C(1538421544),
                              UINT32_C( 533181547), UINT32_C(1474624420), UINT32_C( 464742120), UINT32_C(1469792713)),
      simde_x_mm256_set_epu32(UINT32_C( 596030925), UINT32_C(1623933296), UINT32_C(2355376593), UINT32_C(1538421544),
                              UINT32_C( 533181547), UINT32_C( 386212074), UINT32_C( 328829151), UINT32_C(1469792713)) },
    { simde_x_mm256_set_epu32(UINT32_C(3969449230), UINT32_C(1656808571), UINT32_C(3512723294), UINT32_C(1894827634),
                              UINT32_C( 143242580), UINT32_C(1411474427), UINT32_C(1474375050), UINT32_C(2576321811)),
      simde_x_mm256_set_epu32(UINT32_C(3817774721), UINT32_C(1995677222), UINT32_C(2801037071), UINT32_C(1160265207),
                              UINT32_C( 536799050), UINT32_C(3040213718), UINT32_C(2960203135), UINT32_C( 387289056)),
      simde_x_mm256_set_epu32(UINT32_C(3817774721), UINT32_C(1656808571), UINT32_C(2801037071), UINT32_C(1160265207),
                              UINT32_C( 143242580), UINT32_C(1411474427), UINT32_C(1474375050), UINT32_C( 387289056)) },
    { simde_x_mm256_set_epu32(UINT32_C(4117731720), UINT32_C(2896203570), UINT32_C(2130869721), UINT32_C( 624464130),
                              UINT32_C(3920434556), UINT32_C(3882005287), UINT32_C(2912704980), UINT32_C(3353740323)),
      simde_x_mm256_set_epu32(UINT32_C(1011878374), UINT32_C( 876977997), UINT32_C( 633144937), UINT32_C(2591224872),
                              UINT32_C(1689064732), UINT32_C(1345088039), UINT32_C(3928457299), UINT32_C(1317789172)),
      simde_x_mm256_set_epu32(UINT32_C(1011878374), UINT32_C( 876977997), UINT32_C( 633144937), UINT32_C( 624464130),
                              UINT32_C(1689064732), UINT32_C(1345088039), UINT32_C(2912704980), UINT32_C(1317789172)) },
    { simde_x_mm256_set_epu32(UINT32_C(1278890315), UINT32_C(3068059236), UINT32_C( 937423722), UINT32_C( 545836753),
                              UINT32_C(3944086739), UINT32_C(2155957693), UINT32_C( 750306742), UINT32_C( 995938818)),
      simde_x_mm256_set_epu32(UINT32_C(2300290567), UINT32_C(3884383026), UINT32_C( 682756216), UINT32_C( 434660596),
                              UINT32_C(3895444851), UINT32_C(3229085704), UINT32_C(3028266335), UINT32_C(2490258842)),
      simde_x_mm256_set_epu32(UINT32_C(1278890315), UINT32_C(3068059236), UINT32_C( 682756216), UINT32_C( 434660596),
                              UINT32_C(3895444851), UINT32_C(2155957693), UINT32_C( 750306742), UINT32_C( 995938818)) },
    { simde_x_mm256_set_epu32(UINT32_C( 953347239), UINT32_C(3233201384), UINT32_C( 883460426), UINT32_C( 630153716),
                              UINT32_C(2626834474), UINT32_C(4260188706), UINT32_C(4276291548), UINT32_C(1697478493)),
      simde_x_mm256_set_epu32(UINT32_C(3841797977), UINT32_C( 519016629), UINT32_C(  54139722), UINT32_C(4160085404),
                              UINT32_C(2354740665), UINT32_C( 224670449), UINT32_C(2606748626), UINT32_C(2604287898)),
      simde_x_mm256_set_epu32(UINT32_C( 953347239), UINT32_C( 519016629), UINT32_C(  54139722), UINT32_C( 630153716),
                              UINT32_C(2354740665), UINT32_C( 224670449), UINT32_C(2606748626), UINT32_C(1697478493)) },
    { simde_x_mm256_set_epu32(UINT32_C(4276795094), UINT32_C(3517498069), UINT32_C(3286132221), UINT32_C(1640896057),
                              UINT32_C(1497672480), UINT32_C(  40644986), UINT32_C(1824934232), UINT32_C(1194285849)),
      simde_x_mm256_set_epu32(UINT32_C(1850977199), UINT32_C(1916865152), UINT32_C(2772610612), UINT32_C(2574813520),
                              UINT32_C(1514631464), UINT32_C(2960447777), UINT32_C(2276426609), UINT32_C(1419491712)),
      simde_x_mm256_set_epu32(UINT32_C(1850977199), UINT32_C(1916865152), UINT32_C(2772610612), UINT32_C(1640896057),
                              UINT32_C(1497672480), UINT32_C(  40644986), UINT32_C(1824934232), UINT32_C(1194285849)) },
    { simde_x_mm256_set_epu32(UINT32_C( 990577222), UINT32_C(1025245358), UINT32_C(2406551265), UINT32_C(4071927667),
                              UINT32_C(3189139328), UINT32_C(1739830541), UINT32_C(1739044254), UINT32_C( 584922997)),
      simde_x_mm256_set_epu32(UINT32_C(  72076484), UINT32_C(2950382985), UINT32_C( 915753842), UINT32_C( 355749909),
                              UINT32_C(3000181234), UINT32_C(3918623971), UINT32_C(3711879869), UINT32_C(3103913192)),
      simde_x_mm256_set_epu32(UINT32_C(  72076484), UINT32_C(1025245358), UINT32_C( 915753842), UINT32_C( 355749909),
                              UINT32_C(3000181234), UINT32_C(1739830541), UINT32_C(1739044254), UINT32_C( 584922997)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_min_epu32(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_u32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_movemask_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    int32_t r;
  } test_vec[8] = {
    { simde_mm256_set_epi8(INT8_C( -96), INT8_C(-118), INT8_C(  98), INT8_C(  62),
                           INT8_C( -51), INT8_C(  97), INT8_C( -33), INT8_C( 125),
                           INT8_C(-127), INT8_C( -72), INT8_C(  -2), INT8_C(  75),
                           INT8_C(   7), INT8_C(  73), INT8_C( -28), INT8_C(  60),
                           INT8_C(   8), INT8_C( -37), INT8_C(-119), INT8_C(  83),
                           INT8_C( -63), INT8_C( 105), INT8_C(-120), INT8_C( -81),
                           INT8_C(  66), INT8_C( -93), INT8_C(  75), INT8_C( -69),
                           INT8_C(  47), INT8_C(  11), INT8_C(  51), INT8_C(  35)),
      -891131056 },
    { simde_mm256_set_epi8(INT8_C(  15), INT8_C( 104), INT8_C( -65), INT8_C(-125),
                           INT8_C(  29), INT8_C( 110), INT8_C( -50), INT8_C(  21),
                           INT8_C( -48), INT8_C( 105), INT8_C(  56), INT8_C( 122),
                           INT8_C( -60), INT8_C( 127), INT8_C(  65), INT8_C(-126),
                           INT8_C(  -5), INT8_C( -40), INT8_C( -84), INT8_C( -80),
                           INT8_C(  27), INT8_C(  14), INT8_C(  89), INT8_C(  45),
                           INT8_C(-125), INT8_C( -33), INT8_C( 119), INT8_C(  -9),
                           INT8_C(  20), INT8_C(-117), INT8_C( -34), INT8_C( -66)),
      847900887 },
    { simde_mm256_set_epi8(INT8_C( 106), INT8_C(  46), INT8_C( 114), INT8_C( -45),
                           INT8_C(  75), INT8_C(  29), INT8_C( -66), INT8_C(-117),
                           INT8_C(  47), INT8_C(  53), INT8_C(  50), INT8_C(  31),
                           INT8_C(-111), INT8_C(  36), INT8_C( -73), INT8_C(  38),
                           INT8_C( -23), INT8_C( 112), INT8_C( -88), INT8_C(  42),
                           INT8_C( -89), INT8_C( 120), INT8_C(  50), INT8_C(  27),
                           INT8_C(   6), INT8_C(   1), INT8_C( 127), INT8_C( 127),
                           INT8_C(  38), INT8_C(  57), INT8_C(  13), INT8_C( -14)),
      319465473 },
    { simde_mm256_set_epi8(INT8_C( -21), INT8_C( 113), INT8_C( 127), INT8_C( -53),
                           INT8_C( 111), INT8_C( 121), INT8_C( -27), INT8_C(  17),
                           INT8_C(-104), INT8_C(  11), INT8_C( -41), INT8_C( -39),
                           INT8_C(  51), INT8_C(  41), INT8_C(  91), INT8_C( -62),
                           INT8_C(-116), INT8_C(  34), INT8_C(  15), INT8_C( -55),
                           INT8_C( -90), INT8_C( -31), INT8_C( -66), INT8_C( -64),
                           INT8_C( 115), INT8_C( -38), INT8_C( -54), INT8_C(  24),
                           INT8_C( -59), INT8_C( -48), INT8_C(  15), INT8_C(  60)),
      -1833853076 },
    { simde_mm256_set_epi8(INT8_C( -84), INT8_C(  66), INT8_C( 126), INT8_C( -52),
                           INT8_C(  88), INT8_C(  79), INT8_C(  71), INT8_C( -11),
                           INT8_C( -43), INT8_C( -40), INT8_C(-120), INT8_C(  75),
                           INT8_C(  12), INT8_C( -40), INT8_C(  86), INT8_C( 111),
                           INT8_C( 107), INT8_C( -40), INT8_C( -47), INT8_C(  90),
                           INT8_C(  21), INT8_C( 126), INT8_C( -72), INT8_C( -52),
                           INT8_C( -36), INT8_C( -82), INT8_C( -69), INT8_C(  97),
                           INT8_C(-122), INT8_C( -39), INT8_C(  59), INT8_C(  25)),
      -1847303188 },
    { simde_mm256_set_epi8(INT8_C(  67), INT8_C(  64), INT8_C(  17), INT8_C(  -4),
                           INT8_C( -84), INT8_C(  57), INT8_C(  94), INT8_C(  94),
                           INT8_C(-112), INT8_C(  59), INT8_C( -47), INT8_C( -43),
                           INT8_C( -74), INT8_C(  39), INT8_C(  45), INT8_C( -64),
                           INT8_C( -47), INT8_C( 114), INT8_C( -10), INT8_C(  33),
                           INT8_C(  47), INT8_C( -82), INT8_C( -45), INT8_C(  28),
                           INT8_C(  16), INT8_C(  34), INT8_C(  94), INT8_C(  53),
                           INT8_C(  64), INT8_C(-113), INT8_C( -53), INT8_C(  74)),
      414819846 },
    { simde_mm256_set_epi8(INT8_C(  27), INT8_C(  -3), INT8_C(  33), INT8_C( -42),
                           INT8_C( 113), INT8_C( -79), INT8_C( 119), INT8_C(  38),
                           INT8_C(  96), INT8_C( 109), INT8_C( 125), INT8_C(  82),
                           INT8_C(   8), INT8_C( -29), INT8_C(  10), INT8_C( -22),
                           INT8_C( -49), INT8_C( 123), INT8_C( 109), INT8_C( -49),
                           INT8_C(   6), INT8_C( -16), INT8_C( -14), INT8_C( 102),
                           INT8_C(  -5), INT8_C(  88), INT8_C(  66), INT8_C( -63),
                           INT8_C(  82), INT8_C(  34), INT8_C(  44), INT8_C(  56)),
      1409652368 },
    { simde_mm256_set_epi8(INT8_C( -69), INT8_C( -65), INT8_C(  16), INT8_C( 111),
                           INT8_C( 123), INT8_C(  89), INT8_C(  77), INT8_C(   3),
                           INT8_C(  37), INT8_C( -13), INT8_C(  28), INT8_C(  56),
                           INT8_C( -40), INT8_C( -18), INT8_C( -12), INT8_C(  32),
                           INT8_C( -91), INT8_C( -40), INT8_C( 109), INT8_C(  79),
                           INT8_C(  14), INT8_C(  52), INT8_C(  95), INT8_C(  73),
                           INT8_C(  62), INT8_C( -36), INT8_C( -31), INT8_C(  24),
                           INT8_C(  60), INT8_C( -72), INT8_C(   1), INT8_C( -18)),
      -1068580763 },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    int32_t r = simde_mm256_movemask_epi8(test_vec[i].a);
    munit_assert_int32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_mullo_epi16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi16(INT16_C( 26958), INT16_C(  5839), INT16_C( 10773), INT16_C(-17217),
                            INT16_C( 20782), INT16_C(-24278), INT16_C( 14053), INT16_C(  4872),
                            INT16_C(-31512), INT16_C( -5844), INT16_C(  1857), INT16_C(  9311),
                            INT16_C( 26459), INT16_C( 31943), INT16_C(-26611), INT16_C( 26444)),
      simde_mm256_set_epi16(INT16_C( 25062), INT16_C(-26342), INT16_C(  2282), INT16_C( -1929),
                            INT16_C( -4943), INT16_C(-11597), INT16_C(-15401), INT16_C(-15540),
                            INT16_C( -1566), INT16_C( -8249), INT16_C(  3344), INT16_C(-23800),
                            INT16_C( 15220), INT16_C( -3764), INT16_C( 25181), INT16_C( 11266)),
      simde_mm256_set_epi16(INT16_C( 10772), INT16_C(  2054), INT16_C(  7986), INT16_C(-15159),
                            INT16_C(-30514), INT16_C(  9310), INT16_C(-30381), INT16_C(-16800),
                            INT16_C(  -816), INT16_C(-27340), INT16_C(-16112), INT16_C(-24584),
                            INT16_C(-12740), INT16_C( 25108), INT16_C( 14009), INT16_C( -8552)) },
    { simde_mm256_set_epi16(INT16_C( -5684), INT16_C( 15383), INT16_C(-12220), INT16_C(  1990),
                            INT16_C( -3866), INT16_C(-10346), INT16_C( 21545), INT16_C( 18065),
                            INT16_C(-21267), INT16_C( -3518), INT16_C( 27216), INT16_C( 24702),
                            INT16_C( -8721), INT16_C(-16371), INT16_C( 21885), INT16_C( 22906)),
      simde_mm256_set_epi16(INT16_C( -9241), INT16_C( -3030), INT16_C(-27821), INT16_C( 13222),
                            INT16_C( -7134), INT16_C(  9766), INT16_C(  1304), INT16_C( 21664),
                            INT16_C( 21613), INT16_C( 29626), INT16_C(-23683), INT16_C( 15587),
                            INT16_C( 14936), INT16_C( 31442), INT16_C(  1986), INT16_C(-23873)),
      simde_mm256_set_epi16(INT16_C( 31508), INT16_C(-14394), INT16_C(-28148), INT16_C( 31844),
                            INT16_C(-10612), INT16_C( 17476), INT16_C(-20264), INT16_C(-20832),
                            INT16_C( 25833), INT16_C(-22028), INT16_C( -9968), INT16_C(  6074),
                            INT16_C( 28712), INT16_C(-17238), INT16_C( 13242), INT16_C( -2554)) },
    { simde_mm256_set_epi16(INT16_C(-22642), INT16_C(   406), INT16_C( -2741), INT16_C( 24854),
                            INT16_C(-32159), INT16_C(  5357), INT16_C( 22365), INT16_C(-19783),
                            INT16_C(  6458), INT16_C( -2382), INT16_C( 27277), INT16_C( 20167),
                            INT16_C(   308), INT16_C( 11773), INT16_C(-18240), INT16_C(-22526)),
      simde_mm256_set_epi16(INT16_C(  3067), INT16_C( -5016), INT16_C( 13492), INT16_C(-13562),
                            INT16_C(-32027), INT16_C(-13606), INT16_C(-15731), INT16_C( 23689),
                            INT16_C( -1980), INT16_C(-21001), INT16_C( 20300), INT16_C( -4296),
                            INT16_C(  -123), INT16_C( 14799), INT16_C(-32140), INT16_C( 31677)),
      simde_mm256_set_epi16(INT16_C( 25146), INT16_C( -4880), INT16_C(-19268), INT16_C(-18300),
                            INT16_C( -7483), INT16_C(-11310), INT16_C(-26567), INT16_C(  8449),
                            INT16_C( -7320), INT16_C( 20414), INT16_C(  9436), INT16_C(  1160),
                            INT16_C( 27652), INT16_C(-31597), INT16_C( 14080), INT16_C(  -134)) },
    { simde_mm256_set_epi16(INT16_C(-19186), INT16_C(  1301), INT16_C( 31295), INT16_C(-15933),
                            INT16_C( 15507), INT16_C( -5145), INT16_C( 22638), INT16_C( -9549),
                            INT16_C(  5226), INT16_C( -8321), INT16_C( 11534), INT16_C( -7469),
                            INT16_C( 21265), INT16_C( -8572), INT16_C(  3867), INT16_C( 30789)),
      simde_mm256_set_epi16(INT16_C(-11613), INT16_C( 15229), INT16_C( -2018), INT16_C( 27597),
                            INT16_C(-11741), INT16_C(-30691), INT16_C( 13581), INT16_C(-20193),
                            INT16_C( 19002), INT16_C(-20438), INT16_C( 23792), INT16_C( 10741),
                            INT16_C( 24708), INT16_C(-12234), INT16_C(-16212), INT16_C(-32518)),
      simde_mm256_set_epi16(INT16_C(-15382), INT16_C( 21057), INT16_C( 23394), INT16_C(-21977),
                            INT16_C( -8679), INT16_C( 28971), INT16_C( 17302), INT16_C( 16045),
                            INT16_C( 17412), INT16_C( -1322), INT16_C( 17696), INT16_C( -8465),
                            INT16_C( 13508), INT16_C( 12248), INT16_C( 26148), INT16_C( -3230)) },
    { simde_mm256_set_epi16(INT16_C( 31461), INT16_C( 28893), INT16_C(-27940), INT16_C(-14179),
                            INT16_C( -7147), INT16_C(  8716), INT16_C( -5522), INT16_C( -7988),
                            INT16_C( 11144), INT16_C( 18257), INT16_C(  -233), INT16_C( 22445),
                            INT16_C(-19828), INT16_C( 15498), INT16_C( 17919), INT16_C( -2256)),
      simde_mm256_set_epi16(INT16_C(-10903), INT16_C(  5816), INT16_C( 24259), INT16_C(-27791),
                            INT16_C(-16404), INT16_C(  3280), INT16_C(-17628), INT16_C( -2370),
                            INT16_C( 12909), INT16_C( 25550), INT16_C(  7994), INT16_C(   693),
                            INT16_C(  -412), INT16_C( 18409), INT16_C(-18714), INT16_C(    -7)),
      simde_mm256_set_epi16(INT16_C( -3859), INT16_C(  7384), INT16_C(-23148), INT16_C(-19379),
                            INT16_C( -4516), INT16_C( 14784), INT16_C( 20856), INT16_C( -8344),
                            INT16_C(  6376), INT16_C(-18898), INT16_C(-27594), INT16_C( 22353),
                            INT16_C(-22864), INT16_C( 24474), INT16_C( 11546), INT16_C( 15792)) },
    { simde_mm256_set_epi16(INT16_C(-23599), INT16_C( -6775), INT16_C(-22042), INT16_C( 23599),
                            INT16_C( 29883), INT16_C(-16427), INT16_C( 18767), INT16_C( 13204),
                            INT16_C(-18900), INT16_C(-23120), INT16_C( 17609), INT16_C(-28983),
                            INT16_C( 10186), INT16_C(-12557), INT16_C(  9866), INT16_C( 22138)),
      simde_mm256_set_epi16(INT16_C(-21041), INT16_C(-13045), INT16_C( 15958), INT16_C( 31878),
                            INT16_C( 18632), INT16_C( 10843), INT16_C(-29976), INT16_C(-16463),
                            INT16_C(-15244), INT16_C( -3717), INT16_C( 16396), INT16_C(-24330),
                            INT16_C( -6946), INT16_C( 27306), INT16_C( -9977), INT16_C(-30515)),
      simde_mm256_set_epi16(INT16_C(-19713), INT16_C(-28189), INT16_C(-14524), INT16_C(  1178),
                            INT16_C(-13800), INT16_C(  8887), INT16_C(  1432), INT16_C(  5460),
                            INT16_C( 15344), INT16_C( 19344), INT16_C( 31084), INT16_C(-10970),
                            INT16_C( 26924), INT16_C(  2910), INT16_C(  1990), INT16_C(  4018)) },
    { simde_mm256_set_epi16(INT16_C(  8019), INT16_C(-18318), INT16_C(-27174), INT16_C(-24268),
                            INT16_C(-11542), INT16_C(  3812), INT16_C( 30491), INT16_C(  9957),
                            INT16_C( 24267), INT16_C( 14634), INT16_C(   742), INT16_C(  6819),
                            INT16_C( 18671), INT16_C(-25958), INT16_C( 11320), INT16_C( 22969)),
      simde_mm256_set_epi16(INT16_C(-30081), INT16_C(-15383), INT16_C(-30862), INT16_C( 19583),
                            INT16_C(  4817), INT16_C( 15541), INT16_C( 22774), INT16_C( -2106),
                            INT16_C(-10048), INT16_C(-27305), INT16_C(-18367), INT16_C(-29706),
                            INT16_C(-10409), INT16_C( 15691), INT16_C(  9193), INT16_C( 19182)),
      simde_mm256_set_epi16(INT16_C( 18477), INT16_C(-19006), INT16_C(-20204), INT16_C( 26828),
                            INT16_C(-23286), INT16_C( -2252), INT16_C(-17422), INT16_C(  2078),
                            INT16_C( 24640), INT16_C( -8378), INT16_C(  3174), INT16_C(  6562),
                            INT16_C(-32199), INT16_C(  -738), INT16_C( -6408), INT16_C( -7170)) },
    { simde_mm256_set_epi16(INT16_C(  1498), INT16_C(-31368), INT16_C( -3455), INT16_C(-19849),
                            INT16_C(-16083), INT16_C(-23087), INT16_C( 26835), INT16_C( 10141),
                            INT16_C( 24239), INT16_C(-15471), INT16_C(   117), INT16_C(-26512),
                            INT16_C( -4941), INT16_C( 10703), INT16_C( 12266), INT16_C(-25802)),
      simde_mm256_set_epi16(INT16_C(-20053), INT16_C(-31092), INT16_C( 14330), INT16_C( 14498),
                            INT16_C( 16232), INT16_C(-21016), INT16_C( 26384), INT16_C(-26667),
                            INT16_C( 26626), INT16_C(  -346), INT16_C( 22688), INT16_C(-31544),
                            INT16_C( 24113), INT16_C(  2549), INT16_C( 12831), INT16_C(-19325)),
      simde_mm256_set_epi16(INT16_C(-23906), INT16_C(-12896), INT16_C(-30470), INT16_C( -2226),
                            INT16_C(-29368), INT16_C(-32152), INT16_C( 29232), INT16_C(-28511),
                            INT16_C(-10914), INT16_C(-20986), INT16_C(-32480), INT16_C(-10368),
                            INT16_C(  2115), INT16_C( 18971), INT16_C(-32426), INT16_C( 25762)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_mullo_epi16(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_mullo_epi32(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi32(INT32_C(-1352403780), INT32_C( -343467662), INT32_C(  517643457), INT32_C( -488960691),
                            INT32_C(-1266352672), INT32_C( 1517008609), INT32_C(  990411931), INT32_C(-1870795966)),
      simde_mm256_set_epi32(INT32_C(-1381411484), INT32_C(-1688230631), INT32_C( 2122460393), INT32_C( 1331099088),
                            INT32_C(-1172838687), INT32_C(-1435873650), INT32_C(  806691655), INT32_C( 1528853489)),
      simde_mm256_set_epi32(INT32_C( 1332348272), INT32_C(-1964640734), INT32_C( 1072420777), INT32_C(  814972816),
                            INT32_C(-1273339424), INT32_C(  480378574), INT32_C( -786776067), INT32_C( 1970872098)) },
    { simde_mm256_set_epi32(INT32_C( 1337827173), INT32_C( -259025503), INT32_C( -584925635), INT32_C(  195250370),
                            INT32_C(-1297361156), INT32_C( -136339105), INT32_C(  279578676), INT32_C(-1541670246)),
      simde_mm256_set_epi32(INT32_C(  163529464), INT32_C( 1163098936), INT32_C(-2107715246), INT32_C(  687192711),
                            INT32_C(  869285726), INT32_C(-1567378281), INT32_C(-1698583124), INT32_C( 1922904107)),
      simde_mm256_set_epi32(INT32_C(-1675267112), INT32_C(-2071980488), INT32_C(  114736266), INT32_C(-1214098866),
                            INT32_C( -977210232), INT32_C(  971766537), INT32_C(-1862490384), INT32_C(  337770462)) },
    { simde_mm256_set_epi32(INT32_C(-1141523047), INT32_C(   75738515), INT32_C( 2021274638), INT32_C(-1605111533),
                            INT32_C(  702401071), INT32_C(  991513903), INT32_C( 1097525967), INT32_C(   12869194)),
      simde_mm256_set_epi32(INT32_C( -236040676), INT32_C(-1937249843), INT32_C( -759698458), INT32_C( 1440000042),
                            INT32_C(  500464056), INT32_C( 1039800065), INT32_C( 1696902588), INT32_C( 1988285066)),
      simde_mm256_set_epi32(INT32_C(-1142728004), INT32_C( 1660012983), INT32_C(  496344724), INT32_C( 1454769438),
                            INT32_C(-1377466168), INT32_C(  334399023), INT32_C(  -78753020), INT32_C( 2093451236)) },
    { simde_mm256_set_epi32(INT32_C(  135806382), INT32_C( 1225419686), INT32_C(-1943331695), INT32_C( -184770167),
                            INT32_C( -868496558), INT32_C(-1570632013), INT32_C(-1946534455), INT32_C(  456616503)),
      simde_mm256_set_epi32(INT32_C( 1379577055), INT32_C( -512074604), INT32_C(-1891332670), INT32_C( 1111532874),
                            INT32_C(-1428646370), INT32_C(  907679144), INT32_C(  -10646910), INT32_C( 1881159279)),
      simde_mm256_set_epi32(INT32_C(  200974994), INT32_C(  735175672), INT32_C(-1930722590), INT32_C( 1499725466),
                            INT32_C( -111943780), INT32_C( -608414600), INT32_C(-1553548782), INT32_C( -733042727)) },
    { simde_mm256_set_epi32(INT32_C( 1387302426), INT32_C( -589733281), INT32_C(-1148378464), INT32_C(-1369430370),
                            INT32_C(   64719355), INT32_C( 1048033330), INT32_C( 1019366599), INT32_C(-1908464696)),
      simde_mm256_set_epi32(INT32_C( -277676972), INT32_C( -370073323), INT32_C( -963247981), INT32_C(  258227968),
                            INT32_C( 1397531888), INT32_C(   91286530), INT32_C(  441718636), INT32_C(  180722050)),
      simde_mm256_set_epi32(INT32_C( 2070165640), INT32_C(  905072843), INT32_C(-1144331808), INT32_C(   20505088),
                            INT32_C(-1715853488), INT32_C( 1788708964), INT32_C( 2116699380), INT32_C( 1364898704)) },
    { simde_mm256_set_epi32(INT32_C( 1766434696), INT32_C( -696400655), INT32_C( -511755431), INT32_C(  254323910),
                            INT32_C(-1407716551), INT32_C( -866109177), INT32_C( 1454483112), INT32_C(  830274169)),
      simde_mm256_set_epi32(INT32_C( -369468938), INT32_C(  827481876), INT32_C(  733336376), INT32_C( -709198563),
                            INT32_C(-1510456310), INT32_C( 2091700298), INT32_C(-1848267445), INT32_C( -214051693)),
      simde_mm256_set_epi32(INT32_C(  718619824), INT32_C(-1541746220), INT32_C(  447501944), INT32_C( -640401298),
                            INT32_C( 1908581434), INT32_C( -153474042), INT32_C( 1165187896), INT32_C( 1946486651)) },
    { simde_mm256_set_epi32(INT32_C(  551854829), INT32_C(-1524250015), INT32_C(  248754089), INT32_C( 2058702947),
                            INT32_C(  514801021), INT32_C(-2062150747), INT32_C( 1811376814), INT32_C( 1655721768)),
      simde_mm256_set_epi32(INT32_C(  -68197299), INT32_C( -108251896), INT32_C(  732768373), INT32_C(-1458146720),
                            INT32_C(-1648648199), INT32_C(  765297486), INT32_C( 1888788167), INT32_C( 1580342871)),
      simde_mm256_set_epi32(INT32_C(-1364421303), INT32_C(   35678216), INT32_C( -228151235), INT32_C(   88881952),
                            INT32_C( 1123185045), INT32_C( -436704442), INT32_C( 1841516866), INT32_C( 1493276312)) },
    { simde_mm256_set_epi32(INT32_C(-1004493292), INT32_C(   86312384), INT32_C(-1589794735), INT32_C( 1105371360),
                            INT32_C(  893767357), INT32_C( -562966901), INT32_C(  980757301), INT32_C( 2070176970)),
      simde_mm256_set_epi32(INT32_C( 1498513889), INT32_C( 1078743553), INT32_C(  911009242), INT32_C(  -31879959),
                            INT32_C(  673790886), INT32_C(-1100901508), INT32_C(  837704078), INT32_C( -540129822)),
      simde_mm256_set_epi32(INT32_C( 1421216660), INT32_C(-1778612800), INT32_C(-2078422534), INT32_C( -585176096),
                            INT32_C( 1177460110), INT32_C(-2056987564), INT32_C( 2034852966), INT32_C(  240610388)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_mullo_epi32(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_x_mm256_mullo_epu32(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_x_mm256_set_epu32(UINT32_C(2258322750), UINT32_C(2861166599), UINT32_C(3174424968), UINT32_C(2016553993),
                              UINT32_C(2997181236), UINT32_C( 363976099), UINT32_C(1103728177), UINT32_C(2198010875)),
      simde_x_mm256_set_epu32(UINT32_C(1159500967), UINT32_C(2653222606), UINT32_C(3215542902), UINT32_C(2811870533),
                              UINT32_C(3872912803), UINT32_C(1788506759), UINT32_C(1042504603), UINT32_C(1249290459)),
      simde_x_mm256_set_epu32(UINT32_C(3692692338), UINT32_C(3668041634), UINT32_C( 617563312), UINT32_C(2691269485),
                              UINT32_C(1346229788), UINT32_C(2750955253), UINT32_C(3376906923), UINT32_C(3164358585)) },
    { simde_x_mm256_set_epu32(UINT32_C(2548089923), UINT32_C(1352192202), UINT32_C(3738306426), UINT32_C( 536787617),
                              UINT32_C( 525476003), UINT32_C(3633025093), UINT32_C(1784195446), UINT32_C(1453616288)),
      simde_x_mm256_set_epu32(UINT32_C(1186306915), UINT32_C( 779102467), UINT32_C(1127274760), UINT32_C(2603214034),
                              UINT32_C( 521716141), UINT32_C(3878310832), UINT32_C(2866604767), UINT32_C(3646073150)),
      simde_x_mm256_set_epu32(UINT32_C(3894376169), UINT32_C( 261803102), UINT32_C(1405527504), UINT32_C(2079685650),
                              UINT32_C(3781357863), UINT32_C( 235638384), UINT32_C(2877913546), UINT32_C(4073189056)) },
    { simde_x_mm256_set_epu32(UINT32_C(1846808532), UINT32_C(4103184512), UINT32_C(1968463192), UINT32_C(1782167042),
                              UINT32_C(2474531325), UINT32_C( 998377243), UINT32_C(  44320792), UINT32_C( 386122774)),
      simde_x_mm256_set_epu32(UINT32_C(3246150743), UINT32_C(1171028203), UINT32_C(3269727308), UINT32_C(1281786774),
                              UINT32_C(4190872936), UINT32_C( 118349934), UINT32_C(3463597682), UINT32_C(  47529222)),
      simde_x_mm256_set_epu32(UINT32_C(2092101900), UINT32_C( 720000384), UINT32_C(1052153376), UINT32_C(3804212012),
                              UINT32_C(3421741000), UINT32_C(1903537562), UINT32_C(2781833904), UINT32_C(3256735364)) },
    { simde_x_mm256_set_epu32(UINT32_C(4276815888), UINT32_C(1336815165), UINT32_C( 961795267), UINT32_C( 314541168),
                              UINT32_C(2077700186), UINT32_C(2373614491), UINT32_C(2478361141), UINT32_C(3586675075)),
      simde_x_mm256_set_epu32(UINT32_C(1354372236), UINT32_C(3218632640), UINT32_C(3308884037), UINT32_C( 276466624),
                              UINT32_C(1857596357), UINT32_C(2760506734), UINT32_C( 503740282), UINT32_C(1124719285)),
      simde_x_mm256_set_epu32(UINT32_C(2697570496), UINT32_C(3475448000), UINT32_C( 162597007), UINT32_C( 703341568),
                              UINT32_C(1989432130), UINT32_C(1220299674), UINT32_C(1062010946), UINT32_C(3802541983)) },
    { simde_x_mm256_set_epu32(UINT32_C(1408536206), UINT32_C( 904931218), UINT32_C(3779421746), UINT32_C( 832565776),
                              UINT32_C(  37616047), UINT32_C(1134646772), UINT32_C(3784150216), UINT32_C(1429477789)),
      simde_x_mm256_set_epu32(UINT32_C( 961414585), UINT32_C(1502350843), UINT32_C(3315915686), UINT32_C(2253735990),
                              UINT32_C(2519475515), UINT32_C( 980432319), UINT32_C( 560915899), UINT32_C(2488230114)),
      simde_x_mm256_set_epu32(UINT32_C(2143799966), UINT32_C(2052142630), UINT32_C(1668614764), UINT32_C( 857837408),
                              UINT32_C(3983726165), UINT32_C(3203048716), UINT32_C(2806300184), UINT32_C(1829534874)) },
    { simde_x_mm256_set_epu32(UINT32_C( 574695235), UINT32_C( 304227009), UINT32_C(1668479769), UINT32_C(3452443080),
                              UINT32_C(3762070562), UINT32_C(2046023294), UINT32_C( 475815618), UINT32_C( 179358113)),
      simde_x_mm256_set_epu32(UINT32_C( 260558052), UINT32_C(3663947713), UINT32_C(4165399884), UINT32_C(1745062207),
                              UINT32_C(2120455131), UINT32_C(4011446154), UINT32_C(1023802013), UINT32_C( 827938078)),
      simde_x_mm256_set_epu32(UINT32_C( 245717932), UINT32_C( 844814977), UINT32_C(1900509292), UINT32_C(1197629496),
                              UINT32_C(3678793494), UINT32_C(2083488236), UINT32_C(2902036730), UINT32_C(3718452702)) },
    { simde_x_mm256_set_epu32(UINT32_C(1617715092), UINT32_C(2193069624), UINT32_C( 650454244), UINT32_C(2538964293),
                              UINT32_C(1532176753), UINT32_C(3080365125), UINT32_C(2879482590), UINT32_C(3982850403)),
      simde_x_mm256_set_epu32(UINT32_C(1884881854), UINT32_C(3265025687), UINT32_C(1041888717), UINT32_C(1140822020),
                              UINT32_C(4094158163), UINT32_C( 967388894), UINT32_C(1291557283), UINT32_C(2562715165)),
      simde_x_mm256_set_epu32(UINT32_C(3489770456), UINT32_C(3235932936), UINT32_C(2322644628), UINT32_C(1191699732),
                              UINT32_C(3592389795), UINT32_C(3492534742), UINT32_C(1884272986), UINT32_C(2486553143)) },
    { simde_x_mm256_set_epu32(UINT32_C(3590735797), UINT32_C(1425583171), UINT32_C( 334293210), UINT32_C( 791405491),
                              UINT32_C(1931435573), UINT32_C( 591893589), UINT32_C(1994069612), UINT32_C( 354132544)),
      simde_x_mm256_set_epu32(UINT32_C(2748385695), UINT32_C( 731899882), UINT32_C(1077607699), UINT32_C(1910108083),
                              UINT32_C(1267460605), UINT32_C(2091709757), UINT32_C(2754232525), UINT32_C(2186524445)),
      simde_x_mm256_set_epu32(UINT32_C(4029736555), UINT32_C(1297803838), UINT32_C(3726162478), UINT32_C(4211036969),
                              UINT32_C(   8738657), UINT32_C(3189748033), UINT32_C(3502503036), UINT32_C(1071456576)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_x_mm256_mullo_epu32(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_u32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_or_si256(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi64x(INT64_C( -801044498564576659), INT64_C(-2909946603020252481),
                             INT64_C( 5958340648204315976), INT64_C( 8713768337389103061)),
      simde_mm256_set_epi64x(INT64_C( 9176724763357309327), INT64_C( 4054644920102546891),
                             INT64_C( 4782244109117166481), INT64_C( 3831721763102663031)),
      simde_mm256_set_epi64x(INT64_C(   -1584611843413009), INT64_C(   -9571266241499137),
                             INT64_C( 5980208482798747609), INT64_C( 9074056875634305015)) },
    { simde_mm256_set_epi64x(INT64_C( 1317517346722662736), INT64_C( 8192878697228400830),
                             INT64_C(-3537455209908178968), INT64_C(-2713816682012121382)),
      simde_mm256_set_epi64x(INT64_C( 7957277620212510994), INT64_C( -737217900053345188),
                             INT64_C( 8353910688937076237), INT64_C(  240232259721200655)),
      simde_mm256_set_epi64x(INT64_C( 9110201366055221586), INT64_C( -723122418076615426),
                             INT64_C(   -4662226728259603), INT64_C(-2641361182872049953)) },
    { simde_mm256_set_epi64x(INT64_C(-1030545204507091849), INT64_C(-1542600680052722313),
                             INT64_C(-7648307982573512602), INT64_C( 5973019580240685616)),
      simde_mm256_set_epi64x(INT64_C(-6290470397500953523), INT64_C( 8109710997204180941),
                             INT64_C( 5917924879433877736), INT64_C( 8502004464391034004)),
      simde_mm256_set_epi64x(INT64_C( -453800777020900225), INT64_C( -387309568701530113),
                             INT64_C(-2883445622328010514), INT64_C( 8646205037023002292)) },
    { simde_mm256_set_epi64x(INT64_C(-2990334454120409171), INT64_C(-3220201474370514905),
                             INT64_C( 8548083516217107397), INT64_C( 1251663319653874101)),
      simde_mm256_set_epi64x(INT64_C(-2621282330722334206), INT64_C( 5235652619773460077),
                             INT64_C(-8007055325654862889), INT64_C( 4775726838041815408)),
      simde_mm256_set_epi64x(INT64_C(-2333014432620503121), INT64_C(-2598629952962888081),
                             INT64_C( -656965087403232297), INT64_C( 6007467006593006069)) },
    { simde_mm256_set_epi64x(INT64_C( 1315645066342648861), INT64_C( 3754004658427516786),
                             INT64_C(-7880307939890805097), INT64_C(-5701204371115270443)),
      simde_mm256_set_epi64x(INT64_C( 4172903126396830914), INT64_C( -493154668521044871),
                             INT64_C(-2309759438976524777), INT64_C(-1689539225349388212)),
      simde_mm256_set_epi64x(INT64_C( 4317612287190453471), INT64_C( -198167755223214213),
                             INT64_C(-2309335405310321001), INT64_C( -509524860864094499)) },
    { simde_mm256_set_epi64x(INT64_C(-7748112100043814155), INT64_C( 5814291251258484552),
                             INT64_C( 8569511450246080549), INT64_C(-3900190118960098388)),
      simde_mm256_set_epi64x(INT64_C( 9015646334468450927), INT64_C(  883710405382046595),
                             INT64_C( 2743428167896968049), INT64_C(-6564603084509542605)),
      simde_mm256_set_epi64x(INT64_C( -180373114503566593), INT64_C( 6697859792108349387),
                             INT64_C( 8574745263641455477), INT64_C(-1297039137678485569)) },
    { simde_mm256_set_epi64x(INT64_C( 5980675563351081308), INT64_C( 7108230643859206772),
                             INT64_C(-7185068082285956895), INT64_C(-5748801677096031915)),
      simde_mm256_set_epi64x(INT64_C(-1209090942768865396), INT64_C(-7402713372895048445),
                             INT64_C(  -24471728257632960), INT64_C( 3473093230644658861)),
      simde_mm256_set_epi64x(INT64_C(     -14577395916836), INT64_C( -295610862468677769),
                             INT64_C(   -6315904187370015), INT64_C(-5748026933373309955)) },
    { simde_mm256_set_epi64x(INT64_C( 3669045510431781214), INT64_C(-8656850301840548621),
                             INT64_C(-5639311717074453893), INT64_C(-8609899897096571068)),
      simde_mm256_set_epi64x(INT64_C(-5772405160554679118), INT64_C( 8581290868842963452),
                             INT64_C(-7553387725647900846), INT64_C( 1768046205102779153)),
      simde_mm256_set_epi64x(INT64_C(-4616368323934308866), INT64_C( -585750987759698433),
                             INT64_C(-5206728520596308101), INT64_C(-7454726563416572075)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_or_si256(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i64(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_packs_epi32(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi32(INT32_C(    1118080), INT32_C(         -7), INT32_C(      -7630), INT32_C(         -2),
                            INT32_C(   -3082145), INT32_C(     -11087), INT32_C(    -687386), INT32_C(          1)),
      simde_mm256_set_epi32(INT32_C(  181612761), INT32_C(      21694), INT32_C(        745), INT32_C(     215111),
                            INT32_C(     435492), INT32_C(  -99515557), INT32_C(      -4549), INT32_C(         -1)),
      simde_mm256_set_epi16(INT16_C( 32767), INT16_C( 21694), INT16_C(   745), INT16_C( 32767),
                            INT16_C( 32767), INT16_C(    -7), INT16_C( -7630), INT16_C(    -2),
                            INT16_C( 32767), INT16_C(-32768), INT16_C( -4549), INT16_C(    -1),
                            INT16_C(-32768), INT16_C(-11087), INT16_C(-32768), INT16_C(     1)) },
    { simde_mm256_set_epi32(INT32_C(       2286), INT32_C(       -143), INT32_C(      11092), INT32_C(        113),
                            INT32_C(        161), INT32_C(          3), INT32_C(  -61643846), INT32_C(       -559)),
      simde_mm256_set_epi32(INT32_C(      -1647), INT32_C(    8798268), INT32_C(        -39), INT32_C(       -200),
                            INT32_C(     -16116), INT32_C(        359), INT32_C(          8), INT32_C(          0)),
      simde_mm256_set_epi16(INT16_C( -1647), INT16_C( 32767), INT16_C(   -39), INT16_C(  -200),
                            INT16_C(  2286), INT16_C(  -143), INT16_C( 11092), INT16_C(   113),
                            INT16_C(-16116), INT16_C(   359), INT16_C(     8), INT16_C(     0),
                            INT16_C(   161), INT16_C(     3), INT16_C(-32768), INT16_C(  -559)) },
    { simde_mm256_set_epi32(INT32_C(     -26267), INT32_C(  203715897), INT32_C(  -15056735), INT32_C(        -29),
                            INT32_C(          0), INT32_C(       -102), INT32_C(    8987732), INT32_C(   -1467116)),
      simde_mm256_set_epi32(INT32_C(   59339060), INT32_C(         14), INT32_C(         39), INT32_C(       7846),
                            INT32_C(        -11), INT32_C(         18), INT32_C(         -2), INT32_C(    7851730)),
      simde_mm256_set_epi16(INT16_C( 32767), INT16_C(    14), INT16_C(    39), INT16_C(  7846),
                            INT16_C(-26267), INT16_C( 32767), INT16_C(-32768), INT16_C(   -29),
                            INT16_C(   -11), INT16_C(    18), INT16_C(    -2), INT16_C( 32767),
                            INT16_C(     0), INT16_C(  -102), INT16_C( 32767), INT16_C(-32768)) },
    { simde_mm256_set_epi32(INT32_C(         20), INT32_C(    1729846), INT32_C(      11325), INT32_C(         -6),
                            INT32_C(    1076453), INT32_C(       2695), INT32_C(       2939), INT32_C(       -672)),
      simde_mm256_set_epi32(INT32_C(      14331), INT32_C( -379958894), INT32_C( -369085099), INT32_C(         10),
                            INT32_C(    7318167), INT32_C( -234036594), INT32_C(        159), INT32_C(       -255)),
      simde_mm256_set_epi16(INT16_C( 14331), INT16_C(-32768), INT16_C(-32768), INT16_C(    10),
                            INT16_C(    20), INT16_C( 32767), INT16_C( 11325), INT16_C(    -6),
                            INT16_C( 32767), INT16_C(-32768), INT16_C(   159), INT16_C(  -255),
                            INT16_C( 32767), INT16_C(  2695), INT16_C(  2939), INT16_C(  -672)) },
    { simde_mm256_set_epi32(INT32_C(      -1993), INT32_C(         12), INT32_C(       1544), INT32_C(      -3883),
                            INT32_C(         -1), INT32_C(          5), INT32_C(        -14), INT32_C(          0)),
      simde_mm256_set_epi32(INT32_C(  238433710), INT32_C( 1672160398), INT32_C(          7), INT32_C(    -335748),
                            INT32_C(         -2), INT32_C(        412), INT32_C(        -41), INT32_C(         57)),
      simde_mm256_set_epi16(INT16_C( 32767), INT16_C( 32767), INT16_C(     7), INT16_C(-32768),
                            INT16_C( -1993), INT16_C(    12), INT16_C(  1544), INT16_C( -3883),
                            INT16_C(    -2), INT16_C(   412), INT16_C(   -41), INT16_C(    57),
                            INT16_C(    -1), INT16_C(     5), INT16_C(   -14), INT16_C(     0)) },
    { simde_mm256_set_epi32(INT32_C(        -43), INT32_C(       -722), INT32_C(    3168686), INT32_C(        786),
                            INT32_C(     309716), INT32_C(  -71131617), INT32_C(   -2242932), INT32_C(        -79)),
      simde_mm256_set_epi32(INT32_C( -529814087), INT32_C(   98057466), INT32_C(   84311759), INT32_C(      -1932),
                            INT32_C(     211676), INT32_C(      -2048), INT32_C(   32017519), INT32_C(      38919)),
      simde_mm256_set_epi16(INT16_C(-32768), INT16_C( 32767), INT16_C( 32767), INT16_C( -1932),
                            INT16_C(   -43), INT16_C(  -722), INT16_C( 32767), INT16_C(   786),
                            INT16_C( 32767), INT16_C( -2048), INT16_C( 32767), INT16_C( 32767),
                            INT16_C( 32767), INT16_C(-32768), INT16_C(-32768), INT16_C(   -79)) },
    { simde_mm256_set_epi32(INT32_C(    1100378), INT32_C(   -2351165), INT32_C(         29), INT32_C(    4689904),
                            INT32_C(     103620), INT32_C(    1739844), INT32_C(    -790582), INT32_C(   73163936)),
      simde_mm256_set_epi32(INT32_C(         -4), INT32_C(         24), INT32_C(    1145468), INT32_C(      -3858),
                            INT32_C(         -2), INT32_C(        493), INT32_C(       -552), INT32_C( -294973875)),
      simde_mm256_set_epi16(INT16_C(    -4), INT16_C(    24), INT16_C( 32767), INT16_C( -3858),
                            INT16_C( 32767), INT16_C(-32768), INT16_C(    29), INT16_C( 32767),
                            INT16_C(    -2), INT16_C(   493), INT16_C(  -552), INT16_C(-32768),
                            INT16_C( 32767), INT16_C( 32767), INT16_C(-32768), INT16_C( 32767)) },
    { simde_mm256_set_epi32(INT32_C(   -2758054), INT32_C(  -48014840), INT32_C(      10027), INT32_C(    7146548),
                            INT32_C(     466187), INT32_C(     513667), INT32_C(       -320), INT32_C(        -13)),
      simde_mm256_set_epi32(INT32_C(    1666809), INT32_C(      25654), INT32_C(          1), INT32_C(    1983852),
                            INT32_C(     380233), INT32_C(       -706), INT32_C(-1412412685), INT32_C(     -44675)),
      simde_mm256_set_epi16(INT16_C( 32767), INT16_C( 25654), INT16_C(     1), INT16_C( 32767),
                            INT16_C(-32768), INT16_C(-32768), INT16_C( 10027), INT16_C( 32767),
                            INT16_C( 32767), INT16_C(  -706), INT16_C(-32768), INT16_C(-32768),
                            INT16_C( 32767), INT16_C( 32767), INT16_C(  -320), INT16_C(   -13)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_packs_epi32(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_permute4x64_epi64(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi64x(INT64_C(-4031273950158647677), INT64_C(-7434948453373431243),
                             INT64_C(  966046851086666502), INT64_C(-3558090175042735721)),
      simde_mm256_set_epi64x(INT64_C(-3558090175042735721), INT64_C(-3558090175042735721),
                             INT64_C(-4031273950158647677), INT64_C(  966046851086666502)) },
    { simde_mm256_set_epi64x(INT64_C(-5846597928812893198), INT64_C(-4353963629209663352),
                             INT64_C(-7799994890686903985), INT64_C( 1444957477620918324)),
      simde_mm256_set_epi64x(INT64_C( 1444957477620918324), INT64_C( 1444957477620918324),
                             INT64_C(-5846597928812893198), INT64_C(-7799994890686903985)) },
    { simde_mm256_set_epi64x(INT64_C(-1184806487964558659), INT64_C( 7043949117721512702),
                             INT64_C(  -92438279376413162), INT64_C( 2263934164871463775)),
      simde_mm256_set_epi64x(INT64_C( 2263934164871463775), INT64_C( 2263934164871463775),
                             INT64_C(-1184806487964558659), INT64_C(  -92438279376413162)) },
    { simde_mm256_set_epi64x(INT64_C( 9090919205935740251), INT64_C( 3797255434791406626),
                             INT64_C(-3974983398240952043), INT64_C(-2667637164037811982)),
      simde_mm256_set_epi64x(INT64_C(-2667637164037811982), INT64_C(-2667637164037811982),
                             INT64_C( 9090919205935740251), INT64_C(-3974983398240952043)) },
    { simde_mm256_set_epi64x(INT64_C( 7885365925671452944), INT64_C( 8557735835567037410),
                             INT64_C( 1805700887716213163), INT64_C(-5945530108016559723)),
      simde_mm256_set_epi64x(INT64_C(-5945530108016559723), INT64_C(-5945530108016559723),
                             INT64_C( 7885365925671452944), INT64_C( 1805700887716213163)) },
    { simde_mm256_set_epi64x(INT64_C( -666700084400918528), INT64_C( 2293046882897477780),
                             INT64_C(-4361422993016110212), INT64_C( 5540865589910111090)),
      simde_mm256_set_epi64x(INT64_C( 5540865589910111090), INT64_C( 5540865589910111090),
                             INT64_C( -666700084400918528), INT64_C(-4361422993016110212)) },
    { simde_mm256_set_epi64x(INT64_C(-4089126903474854143), INT64_C(-3405442608942374627),
                             INT64_C(-5965708747641475330), INT64_C( 3779098457061206514)),
      simde_mm256_set_epi64x(INT64_C( 3779098457061206514), INT64_C( 3779098457061206514),
                             INT64_C(-4089126903474854143), INT64_C(-5965708747641475330)) },
    { simde_mm256_set_epi64x(INT64_C(-7195404196599220190), INT64_C( 4846123797420351534),
                             INT64_C( 1973553066803872882), INT64_C(-2603358823346386940)),
      simde_mm256_set_epi64x(INT64_C(-2603358823346386940), INT64_C(-2603358823346386940),
                             INT64_C(-7195404196599220190), INT64_C( 1973553066803872882)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_permute4x64_epi64(test_vec[i].a, 13);
    simde_assert_m256i_i64(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_permute2x128_si256(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi64x(INT64_C( 9096692030846176105), INT64_C(  644260392039444522),
                             INT64_C(-4583540275174352405), INT64_C(-6816753880857675259)),
      simde_mm256_set_epi64x(INT64_C(-7886827988827131690), INT64_C(-2107575233125845054),
                             INT64_C(-8398644678734943287), INT64_C( 7172114359254607016)),
      simde_mm256_set_epi64x(INT64_C( 9096692030846176105), INT64_C(  644260392039444522),
                             INT64_C(-7886827988827131690), INT64_C(-2107575233125845054)) },
    { simde_mm256_set_epi64x(INT64_C(-6314946612387904819), INT64_C(-1883921203594067636),
                             INT64_C(-5030251871897832411), INT64_C( 8348493077761215789)),
      simde_mm256_set_epi64x(INT64_C( 2582913386835954622), INT64_C(  153655168481379701),
                             INT64_C(-1087064137492042031), INT64_C( 1783808851867973139)),
      simde_mm256_set_epi64x(INT64_C(-6314946612387904819), INT64_C(-1883921203594067636),
                             INT64_C( 2582913386835954622), INT64_C(  153655168481379701)) },
    { simde_mm256_set_epi64x(INT64_C(-3208478614025680333), INT64_C(-3409066786741744502),
                             INT64_C(-6957643043766269700), INT64_C( 3219428559958296960)),
      simde_mm256_set_epi64x(INT64_C(-1736924574103250292), INT64_C(-2810347538827243748),
                             INT64_C( -297965813118371045), INT64_C(-7618358042182251122)),
      simde_mm256_set_epi64x(INT64_C(-3208478614025680333), INT64_C(-3409066786741744502),
                             INT64_C(-1736924574103250292), INT64_C(-2810347538827243748)) },
    { simde_mm256_set_epi64x(INT64_C(  796366024780064289), INT64_C(-1489690745108457074),
                             INT64_C(-7990282097237082056), INT64_C(-7545130296515735090)),
      simde_mm256_set_epi64x(INT64_C(  951803776889232332), INT64_C(-6640461449591045668),
                             INT64_C( 5271740244822761531), INT64_C( 3149915688837762175)),
      simde_mm256_set_epi64x(INT64_C(  796366024780064289), INT64_C(-1489690745108457074),
                             INT64_C(  951803776889232332), INT64_C(-6640461449591045668)) },
    { simde_mm256_set_epi64x(INT64_C(  -95120238103258498), INT64_C(-1762353908339260045),
                             INT64_C( 6992845328844002662), INT64_C(-5939283762406250642)),
      simde_mm256_set_epi64x(INT64_C(-5885001620821736092), INT64_C(-6745062192544323367),
                             INT64_C( 7803931770148523943), INT64_C(-8993062880293478576)),
      simde_mm256_set_epi64x(INT64_C(  -95120238103258498), INT64_C(-1762353908339260045),
                             INT64_C(-5885001620821736092), INT64_C(-6745062192544323367)) },
    { simde_mm256_set_epi64x(INT64_C(-3708437875152674849), INT64_C( 8243162546537572005),
                             INT64_C(-1103721052327437925), INT64_C(-2925489198757650175)),
      simde_mm256_set_epi64x(INT64_C( 1440085788748654982), INT64_C( 1725906984156202179),
                             INT64_C( 5845599904819452784), INT64_C( 7162548421658470679)),
      simde_mm256_set_epi64x(INT64_C(-3708437875152674849), INT64_C( 8243162546537572005),
                             INT64_C( 1440085788748654982), INT64_C( 1725906984156202179)) },
    { simde_mm256_set_epi64x(INT64_C( 6834943649491098623), INT64_C( 2759372331225584008),
                             INT64_C(-1659900994892419246), INT64_C(-2119655686628377164)),
      simde_mm256_set_epi64x(INT64_C( 1954610004667753515), INT64_C( 5688482191974230934),
                             INT64_C(-3937849964004809456), INT64_C(-8694088207381845200)),
      simde_mm256_set_epi64x(INT64_C( 6834943649491098623), INT64_C( 2759372331225584008),
                             INT64_C( 1954610004667753515), INT64_C( 5688482191974230934)) },
    { simde_mm256_set_epi64x(INT64_C( 5051547726856501651), INT64_C( 7333908238294102632),
                             INT64_C( 7118133466490521985), INT64_C( 6243950982549416292)),
      simde_mm256_set_epi64x(INT64_C(-6805527145604381785), INT64_C(-1282569833996306134),
                             INT64_C(-1497859500202369050), INT64_C( 1581543684384159070)),
      simde_mm256_set_epi64x(INT64_C( 5051547726856501651), INT64_C( 7333908238294102632),
                             INT64_C(-6805527145604381785), INT64_C(-1282569833996306134)) },
  };

  //printf("\n");
  //for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
  //  simde__m256i_private a, b, r;

  //  munit_rand_memory(sizeof(a), (uint8_t*) &a);
  //  munit_rand_memory(sizeof(b), (uint8_t*) &b);

  //  r = simde__m256i_to_private(simde_mm256_permute2x128_si256(simde__m256i_from_private(a), simde__m256i_from_private(b), 23));

  //  printf("    { simde_mm256_set_epi64x(INT64_C(%20" PRId64 "), INT64_C(%20" PRId64 "),\n"
  //         "                             INT64_C(%20" PRId64 "), INT64_C(%20" PRId64 ")),\n",
  //         a.i64[3], a.i64[2], a.i64[1], a.i64[0]);
  //  printf("      simde_mm256_set_epi64x(INT64_C(%20" PRId64 "), INT64_C(%20" PRId64 "),\n"
  //         "                             INT64_C(%20" PRId64 "), INT64_C(%20" PRId64 ")),\n",
  //         b.i64[3], b.i64[2], b.i64[1], b.i64[0]);
  //  printf("      simde_mm256_set_epi64x(INT64_C(%20" PRId64 "), INT64_C(%20" PRId64 "),\n"
  //         "                             INT64_C(%20" PRId64 "), INT64_C(%20" PRId64 ")) },\n",
  //         r.i64[3], r.i64[2], r.i64[1], r.i64[0]);
  //}
  //return MUNIT_FAIL;

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_permute2x128_si256(test_vec[i].a, test_vec[i].b, 23);
    simde_assert_m256i_i64(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_shuffle_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_x_mm256_set_epu8(UINT8_C(132), UINT8_C(100), UINT8_C(115), UINT8_C( 94),
                             UINT8_C( 73), UINT8_C(247), UINT8_C(104), UINT8_C(220),
                             UINT8_C(117), UINT8_C( 74), UINT8_C( 39), UINT8_C(125),
                             UINT8_C( 51), UINT8_C( 55), UINT8_C(148), UINT8_C(183),
                             UINT8_C(  5), UINT8_C(228), UINT8_C( 33), UINT8_C( 72),
                             UINT8_C( 84), UINT8_C(  4), UINT8_C(172), UINT8_C(134),
                             UINT8_C( 26), UINT8_C(247), UINT8_C(250), UINT8_C(  1),
                             UINT8_C(220), UINT8_C( 43), UINT8_C( 83), UINT8_C(118)),
      simde_x_mm256_set_epu8(UINT8_C( 24), UINT8_C(160), UINT8_C( 38), UINT8_C(201),
                             UINT8_C(108), UINT8_C( 32), UINT8_C( 93), UINT8_C( 16),
                             UINT8_C(104), UINT8_C(146), UINT8_C(128), UINT8_C(127),
                             UINT8_C(240), UINT8_C(187), UINT8_C(163), UINT8_C( 93),
                             UINT8_C(161), UINT8_C(148), UINT8_C(236), UINT8_C(208),
                             UINT8_C(110), UINT8_C( 19), UINT8_C(  3), UINT8_C(142),
                             UINT8_C( 56), UINT8_C( 74), UINT8_C(  2), UINT8_C(168),
                             UINT8_C(100), UINT8_C(209), UINT8_C( 27), UINT8_C( 46)),
      simde_x_mm256_set_epu8(UINT8_C(220), UINT8_C(  0), UINT8_C( 74), UINT8_C(  0),
                             UINT8_C( 94), UINT8_C(183), UINT8_C(115), UINT8_C(183),
                             UINT8_C(220), UINT8_C(  0), UINT8_C(  0), UINT8_C(132),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(115),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(228), UINT8_C(220), UINT8_C(220), UINT8_C(  0),
                             UINT8_C(134), UINT8_C(  4), UINT8_C( 43), UINT8_C(  0),
                             UINT8_C(  1), UINT8_C(  0), UINT8_C( 84), UINT8_C(228)) },
    { simde_x_mm256_set_epu8(UINT8_C( 53), UINT8_C(227), UINT8_C(193), UINT8_C(203),
                             UINT8_C(188), UINT8_C( 31), UINT8_C(134), UINT8_C(151),
                             UINT8_C( 90), UINT8_C(227), UINT8_C(228), UINT8_C( 42),
                             UINT8_C(223), UINT8_C( 71), UINT8_C( 37), UINT8_C(166),
                             UINT8_C(115), UINT8_C( 13), UINT8_C(136), UINT8_C( 67),
                             UINT8_C(142), UINT8_C( 55), UINT8_C(218), UINT8_C(135),
                             UINT8_C(160), UINT8_C(121), UINT8_C(105), UINT8_C(225),
                             UINT8_C( 67), UINT8_C(106), UINT8_C( 80), UINT8_C(187)),
      simde_x_mm256_set_epu8(UINT8_C(139), UINT8_C(207), UINT8_C(188), UINT8_C(170),
                             UINT8_C(232), UINT8_C(172), UINT8_C( 51), UINT8_C( 14),
                             UINT8_C( 50), UINT8_C(186), UINT8_C( 76), UINT8_C(187),
                             UINT8_C( 22), UINT8_C( 90), UINT8_C(150), UINT8_C(148),
                             UINT8_C(123), UINT8_C( 36), UINT8_C(145), UINT8_C( 72),
                             UINT8_C(252), UINT8_C(171), UINT8_C(109), UINT8_C( 77),
                             UINT8_C(145), UINT8_C( 77), UINT8_C(121), UINT8_C(107),
                             UINT8_C(138), UINT8_C(154), UINT8_C(236), UINT8_C( 13)),
      simde_x_mm256_set_epu8(UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(223), UINT8_C(227),
                             UINT8_C( 71), UINT8_C(  0), UINT8_C(203), UINT8_C(  0),
                             UINT8_C(227), UINT8_C( 31), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(142), UINT8_C(225), UINT8_C(  0), UINT8_C(135),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(136), UINT8_C(136),
                             UINT8_C(  0), UINT8_C(136), UINT8_C(218), UINT8_C(142),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(136)) },
    { simde_x_mm256_set_epu8(UINT8_C(147), UINT8_C(175), UINT8_C(103), UINT8_C(105),
                             UINT8_C(115), UINT8_C( 25), UINT8_C( 88), UINT8_C( 95),
                             UINT8_C(108), UINT8_C(195), UINT8_C( 30), UINT8_C( 32),
                             UINT8_C(183), UINT8_C(198), UINT8_C(177), UINT8_C( 61),
                             UINT8_C(213), UINT8_C(  7), UINT8_C(150), UINT8_C(186),
                             UINT8_C( 52), UINT8_C(  9), UINT8_C( 76), UINT8_C(240),
                             UINT8_C(240), UINT8_C(126), UINT8_C(242), UINT8_C(203),
                             UINT8_C(162), UINT8_C( 72), UINT8_C(186), UINT8_C( 35)),
      simde_x_mm256_set_epu8(UINT8_C( 26), UINT8_C(  1), UINT8_C(253), UINT8_C(220),
                             UINT8_C(156), UINT8_C(126), UINT8_C(237), UINT8_C(228),
                             UINT8_C(210), UINT8_C( 82), UINT8_C(  8), UINT8_C(  8),
                             UINT8_C(104), UINT8_C( 35), UINT8_C( 98), UINT8_C( 24),
                             UINT8_C(230), UINT8_C(227), UINT8_C( 73), UINT8_C(233),
                             UINT8_C(132), UINT8_C( 49), UINT8_C( 63), UINT8_C(172),
                             UINT8_C(137), UINT8_C( 87), UINT8_C( 85), UINT8_C(128),
                             UINT8_C(136), UINT8_C(108), UINT8_C( 70), UINT8_C(218)),
      simde_x_mm256_set_epu8(UINT8_C( 25), UINT8_C(177), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(175), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(198), UINT8_C( 95), UINT8_C( 95),
                             UINT8_C( 95), UINT8_C(183), UINT8_C(198), UINT8_C( 95),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C( 76), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(186), UINT8_C(213), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(240), UINT8_C(242), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(186), UINT8_C(126), UINT8_C(  0)) },
    { simde_x_mm256_set_epu8(UINT8_C(132), UINT8_C( 22), UINT8_C(115), UINT8_C(245),
                             UINT8_C(139), UINT8_C(127), UINT8_C( 30), UINT8_C( 96),
                             UINT8_C(123), UINT8_C(228), UINT8_C( 73), UINT8_C(244),
                             UINT8_C( 12), UINT8_C( 46), UINT8_C( 26), UINT8_C( 36),
                             UINT8_C(186), UINT8_C( 18), UINT8_C(169), UINT8_C(233),
                             UINT8_C(  8), UINT8_C(185), UINT8_C(123), UINT8_C( 50),
                             UINT8_C(171), UINT8_C(240), UINT8_C(159), UINT8_C(176),
                             UINT8_C( 29), UINT8_C(146), UINT8_C( 85), UINT8_C( 34)),
      simde_x_mm256_set_epu8(UINT8_C(197), UINT8_C( 93), UINT8_C( 52), UINT8_C(130),
                             UINT8_C(124), UINT8_C( 87), UINT8_C( 88), UINT8_C( 89),
                             UINT8_C( 56), UINT8_C(209), UINT8_C( 85), UINT8_C(235),
                             UINT8_C( 45), UINT8_C(236), UINT8_C(154), UINT8_C( 72),
                             UINT8_C(164), UINT8_C(253), UINT8_C(196), UINT8_C( 41),
                             UINT8_C( 28), UINT8_C(181), UINT8_C(180), UINT8_C(237),
                             UINT8_C( 65), UINT8_C(122), UINT8_C(110), UINT8_C( 94),
                             UINT8_C(125), UINT8_C( 60), UINT8_C( 80), UINT8_C(209)),
      simde_x_mm256_set_epu8(UINT8_C(  0), UINT8_C(115), UINT8_C(244), UINT8_C(  0),
                             UINT8_C(245), UINT8_C(123), UINT8_C( 96), UINT8_C( 30),
                             UINT8_C( 96), UINT8_C(  0), UINT8_C( 73), UINT8_C(  0),
                             UINT8_C(115), UINT8_C(  0), UINT8_C(  0), UINT8_C( 96),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(123),
                             UINT8_C(233), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C( 85), UINT8_C(185), UINT8_C( 18), UINT8_C( 18),
                             UINT8_C(169), UINT8_C(233), UINT8_C( 34), UINT8_C(  0)) },
    { simde_x_mm256_set_epu8(UINT8_C(233), UINT8_C(108), UINT8_C(215), UINT8_C(181),
                             UINT8_C(100), UINT8_C( 72), UINT8_C(220), UINT8_C( 52),
                             UINT8_C( 24), UINT8_C(  0), UINT8_C(242), UINT8_C(125),
                             UINT8_C(116), UINT8_C(102), UINT8_C( 94), UINT8_C( 64),
                             UINT8_C(158), UINT8_C(177), UINT8_C(  3), UINT8_C(246),
                             UINT8_C(164), UINT8_C(171), UINT8_C(138), UINT8_C( 15),
                             UINT8_C( 30), UINT8_C( 68), UINT8_C(246), UINT8_C(147),
                             UINT8_C(162), UINT8_C( 13), UINT8_C( 93), UINT8_C( 58)),
      simde_x_mm256_set_epu8(UINT8_C(159), UINT8_C(224), UINT8_C(140), UINT8_C(117),
                             UINT8_C( 95), UINT8_C( 45), UINT8_C(144), UINT8_C( 69),
                             UINT8_C(174), UINT8_C( 34), UINT8_C(237), UINT8_C( 42),
                             UINT8_C( 78), UINT8_C(  7), UINT8_C(200), UINT8_C(173),
                             UINT8_C(137), UINT8_C( 75), UINT8_C(170), UINT8_C(110),
                             UINT8_C(182), UINT8_C(180), UINT8_C(173), UINT8_C(172),
                             UINT8_C(227), UINT8_C(222), UINT8_C(132), UINT8_C(  4),
                             UINT8_C(190), UINT8_C(  7), UINT8_C( 12), UINT8_C( 21)),
      simde_x_mm256_set_epu8(UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(242),
                             UINT8_C(233), UINT8_C(215), UINT8_C(  0), UINT8_C(242),
                             UINT8_C(  0), UINT8_C(102), UINT8_C(  0), UINT8_C( 72),
                             UINT8_C(108), UINT8_C( 24), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(164), UINT8_C(  0), UINT8_C(177),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(147),
                             UINT8_C(  0), UINT8_C( 30), UINT8_C(246), UINT8_C(246)) },
    { simde_x_mm256_set_epu8(UINT8_C(239), UINT8_C(190), UINT8_C( 67), UINT8_C(183),
                             UINT8_C(162), UINT8_C( 57), UINT8_C(249), UINT8_C(218),
                             UINT8_C(176), UINT8_C(139), UINT8_C(  3), UINT8_C(248),
                             UINT8_C(214), UINT8_C( 36), UINT8_C(105), UINT8_C( 96),
                             UINT8_C( 80), UINT8_C(108), UINT8_C(142), UINT8_C(  2),
                             UINT8_C(196), UINT8_C(162), UINT8_C( 38), UINT8_C(  4),
                             UINT8_C(175), UINT8_C(178), UINT8_C( 88), UINT8_C(165),
                             UINT8_C(168), UINT8_C( 71), UINT8_C( 76), UINT8_C(232)),
      simde_x_mm256_set_epu8(UINT8_C(199), UINT8_C( 95), UINT8_C( 43), UINT8_C(216),
                             UINT8_C(128), UINT8_C(137), UINT8_C(103), UINT8_C( 51),
                             UINT8_C(121), UINT8_C( 84), UINT8_C(196), UINT8_C(101),
                             UINT8_C(251), UINT8_C(  4), UINT8_C( 89), UINT8_C( 54),
                             UINT8_C(216), UINT8_C(149), UINT8_C(145), UINT8_C( 73),
                             UINT8_C(162), UINT8_C( 73), UINT8_C(124), UINT8_C(146),
                             UINT8_C( 70), UINT8_C(151), UINT8_C(137), UINT8_C(218),
                             UINT8_C(230), UINT8_C(112), UINT8_C( 45), UINT8_C(226)),
      simde_x_mm256_set_epu8(UINT8_C(  0), UINT8_C(239), UINT8_C(162), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(176), UINT8_C(214),
                             UINT8_C(249), UINT8_C(248), UINT8_C(  0), UINT8_C(  3),
                             UINT8_C(  0), UINT8_C(248), UINT8_C(249), UINT8_C(139),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C( 38),
                             UINT8_C(  0), UINT8_C( 38), UINT8_C(  2), UINT8_C(  0),
                             UINT8_C(178), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(232), UINT8_C(142), UINT8_C(  0)) },
    { simde_x_mm256_set_epu8(UINT8_C( 81), UINT8_C(102), UINT8_C( 49), UINT8_C(133),
                             UINT8_C(250), UINT8_C( 13), UINT8_C(233), UINT8_C( 67),
                             UINT8_C(205), UINT8_C(254), UINT8_C( 41), UINT8_C(  6),
                             UINT8_C(117), UINT8_C(148), UINT8_C(222), UINT8_C(171),
                             UINT8_C(  8), UINT8_C( 99), UINT8_C( 93), UINT8_C( 39),
                             UINT8_C(103), UINT8_C(215), UINT8_C(216), UINT8_C( 75),
                             UINT8_C( 94), UINT8_C(171), UINT8_C( 41), UINT8_C(173),
                             UINT8_C(217), UINT8_C(138), UINT8_C(180), UINT8_C(160)),
      simde_x_mm256_set_epu8(UINT8_C(200), UINT8_C(107), UINT8_C(119), UINT8_C(216),
                             UINT8_C( 73), UINT8_C(187), UINT8_C(212), UINT8_C( 20),
                             UINT8_C( 22), UINT8_C( 11), UINT8_C(155), UINT8_C(106),
                             UINT8_C( 35), UINT8_C(108), UINT8_C( 43), UINT8_C( 58),
                             UINT8_C(102), UINT8_C(228), UINT8_C(  5), UINT8_C(227),
                             UINT8_C(106), UINT8_C(119), UINT8_C(184), UINT8_C(199),
                             UINT8_C( 57), UINT8_C(120), UINT8_C( 14), UINT8_C( 56),
                             UINT8_C( 82), UINT8_C( 19), UINT8_C( 33), UINT8_C( 82)),
      simde_x_mm256_set_epu8(UINT8_C(  0), UINT8_C(250), UINT8_C(205), UINT8_C(  0),
                             UINT8_C(233), UINT8_C(  0), UINT8_C(  0), UINT8_C(  6),
                             UINT8_C(254), UINT8_C(250), UINT8_C(  0), UINT8_C( 13),
                             UINT8_C(117), UINT8_C(133), UINT8_C(250), UINT8_C( 13),
                             UINT8_C(171), UINT8_C(  0), UINT8_C( 41), UINT8_C(  0),
                             UINT8_C(215), UINT8_C( 94), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(216), UINT8_C( 75), UINT8_C( 99), UINT8_C( 75),
                             UINT8_C(138), UINT8_C(217), UINT8_C(180), UINT8_C(138)) },
    { simde_x_mm256_set_epu8(UINT8_C(173), UINT8_C(218), UINT8_C( 20), UINT8_C( 45),
                             UINT8_C(110), UINT8_C( 90), UINT8_C(183), UINT8_C( 54),
                             UINT8_C(102), UINT8_C(126), UINT8_C(167), UINT8_C(135),
                             UINT8_C( 42), UINT8_C( 74), UINT8_C( 22), UINT8_C(137),
                             UINT8_C( 56), UINT8_C(  5), UINT8_C( 18), UINT8_C(105),
                             UINT8_C( 83), UINT8_C(146), UINT8_C(229), UINT8_C( 54),
                             UINT8_C(169), UINT8_C( 55), UINT8_C(228), UINT8_C(168),
                             UINT8_C(  1), UINT8_C(126), UINT8_C(169), UINT8_C(235)),
      simde_x_mm256_set_epu8(UINT8_C(254), UINT8_C( 56), UINT8_C(  4), UINT8_C(163),
                             UINT8_C( 35), UINT8_C( 52), UINT8_C(182), UINT8_C( 52),
                             UINT8_C(  1), UINT8_C( 45), UINT8_C(119), UINT8_C(169),
                             UINT8_C(175), UINT8_C(254), UINT8_C( 71), UINT8_C( 63),
                             UINT8_C( 24), UINT8_C(116), UINT8_C(194), UINT8_C(184),
                             UINT8_C(150), UINT8_C(167), UINT8_C(101), UINT8_C(133),
                             UINT8_C( 95), UINT8_C( 84), UINT8_C(199), UINT8_C(134),
                             UINT8_C(251), UINT8_C(101), UINT8_C( 38), UINT8_C( 43)),
      simde_x_mm256_set_epu8(UINT8_C(  0), UINT8_C( 54), UINT8_C(135), UINT8_C(  0),
                             UINT8_C( 42), UINT8_C(135), UINT8_C(  0), UINT8_C(135),
                             UINT8_C( 22), UINT8_C( 20), UINT8_C(102), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(102), UINT8_C(173),
                             UINT8_C( 54), UINT8_C(168), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(228), UINT8_C(  0),
                             UINT8_C( 56), UINT8_C(168), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(228), UINT8_C( 55), UINT8_C( 83)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_shuffle_epi8(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_u8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_shuffle_epi32(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi32(INT32_C(    7953530), INT32_C( 1626445648), INT32_C(  338474584), INT32_C( 1314132322),
                            INT32_C( -165526664), INT32_C( 1862544223), INT32_C( 1736492928), INT32_C( -812721862)),
      simde_mm256_set_epi32(INT32_C( 1626445648), INT32_C( 1626445648), INT32_C( 1626445648), INT32_C( 1626445648),
                            INT32_C( 1862544223), INT32_C( 1862544223), INT32_C( 1862544223), INT32_C( 1862544223)) },
    { simde_mm256_set_epi32(INT32_C( 1571455878), INT32_C( 1654912639), INT32_C( 1961566624), INT32_C( 1369731271),
                            INT32_C( -802314883), INT32_C( 1895104772), INT32_C(-1294636783), INT32_C(   -2090880)),
      simde_mm256_set_epi32(INT32_C( 1654912639), INT32_C( 1654912639), INT32_C( 1654912639), INT32_C( 1654912639),
                            INT32_C( 1895104772), INT32_C( 1895104772), INT32_C( 1895104772), INT32_C( 1895104772)) },
    { simde_mm256_set_epi32(INT32_C(  716787034), INT32_C(  279681787), INT32_C(  -21556639), INT32_C(-1981624037),
                            INT32_C(  330738474), INT32_C(-1021797214), INT32_C(  117555788), INT32_C( 1295745410)),
      simde_mm256_set_epi32(INT32_C(  279681787), INT32_C(  279681787), INT32_C(  279681787), INT32_C(  279681787),
                            INT32_C(-1021797214), INT32_C(-1021797214), INT32_C(-1021797214), INT32_C(-1021797214)) },
    { simde_mm256_set_epi32(INT32_C(-1161252350), INT32_C( 1333069761), INT32_C( -746913676), INT32_C(-1297385199),
                            INT32_C( 1762552906), INT32_C( 1819201471), INT32_C(-1000519846), INT32_C( 2096577459)),
      simde_mm256_set_epi32(INT32_C( 1333069761), INT32_C( 1333069761), INT32_C( 1333069761), INT32_C( 1333069761),
                            INT32_C( 1819201471), INT32_C( 1819201471), INT32_C( 1819201471), INT32_C( 1819201471)) },
    { simde_mm256_set_epi32(INT32_C( 1772174643), INT32_C( 2012282759), INT32_C(  407185018), INT32_C(-1907491648),
                            INT32_C(-1950535235), INT32_C(   59473466), INT32_C( -212502371), INT32_C( -171378108)),
      simde_mm256_set_epi32(INT32_C( 2012282759), INT32_C( 2012282759), INT32_C( 2012282759), INT32_C( 2012282759),
                            INT32_C(   59473466), INT32_C(   59473466), INT32_C(   59473466), INT32_C(   59473466)) },
    { simde_mm256_set_epi32(INT32_C(-1786867928), INT32_C(  183968379), INT32_C(-1710767833), INT32_C(  419209661),
                            INT32_C( 1470446764), INT32_C( -838411183), INT32_C( 1711518303), INT32_C(-1929674962)),
      simde_mm256_set_epi32(INT32_C(  183968379), INT32_C(  183968379), INT32_C(  183968379), INT32_C(  183968379),
                            INT32_C( -838411183), INT32_C( -838411183), INT32_C( -838411183), INT32_C( -838411183)) },
    { simde_mm256_set_epi32(INT32_C(-1296827172), INT32_C(-1426782704), INT32_C(  461497475), INT32_C(  857689164),
                            INT32_C( -127267738), INT32_C( -225620875), INT32_C( -476268334), INT32_C(     275470)),
      simde_mm256_set_epi32(INT32_C(-1426782704), INT32_C(-1426782704), INT32_C(-1426782704), INT32_C(-1426782704),
                            INT32_C( -225620875), INT32_C( -225620875), INT32_C( -225620875), INT32_C( -225620875)) },
    { simde_mm256_set_epi32(INT32_C(  492995740), INT32_C(-1095702956), INT32_C( 1746718954), INT32_C( 2048506117),
                            INT32_C(  180431580), INT32_C(-1463759846), INT32_C( 1212242273), INT32_C(-1640731308)),
      simde_mm256_set_epi32(INT32_C(-1095702956), INT32_C(-1095702956), INT32_C(-1095702956), INT32_C(-1095702956),
                            INT32_C(-1463759846), INT32_C(-1463759846), INT32_C(-1463759846), INT32_C(-1463759846)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_shuffle_epi32(test_vec[i].a, 0xaa);
    simde_assert_m256i_i32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_shufflelo_epi16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi16(INT16_C( -2179), INT16_C( 30608), INT16_C( 19808), INT16_C(-28307),
                            INT16_C( 25873), INT16_C( -9642), INT16_C(    56), INT16_C(   338),
                            INT16_C(-29256), INT16_C(  9693), INT16_C( 18909), INT16_C(  3915),
                            INT16_C(  2653), INT16_C( 26676), INT16_C(-23808), INT16_C( 25025)),
      simde_mm256_set_epi16(INT16_C( -2179), INT16_C( 30608), INT16_C( 19808), INT16_C(-28307),
                            INT16_C( -9642), INT16_C(    56), INT16_C(    56), INT16_C(    56),
                            INT16_C(-29256), INT16_C(  9693), INT16_C( 18909), INT16_C(  3915),
                            INT16_C( 26676), INT16_C(-23808), INT16_C(-23808), INT16_C(-23808)) },
    { simde_mm256_set_epi16(INT16_C( 18348), INT16_C(-29440), INT16_C( -6978), INT16_C( 22811),
                            INT16_C(-31995), INT16_C( 32157), INT16_C( -1931), INT16_C( 15650),
                            INT16_C( 25681), INT16_C( 27258), INT16_C( -9033), INT16_C( 28640),
                            INT16_C(-16045), INT16_C(  2509), INT16_C(-23756), INT16_C(  4399)),
      simde_mm256_set_epi16(INT16_C( 18348), INT16_C(-29440), INT16_C( -6978), INT16_C( 22811),
                            INT16_C( 32157), INT16_C( -1931), INT16_C( -1931), INT16_C( -1931),
                            INT16_C( 25681), INT16_C( 27258), INT16_C( -9033), INT16_C( 28640),
                            INT16_C(  2509), INT16_C(-23756), INT16_C(-23756), INT16_C(-23756)) },
    { simde_mm256_set_epi16(INT16_C( 32389), INT16_C(-20100), INT16_C( 26342), INT16_C(-12082),
                            INT16_C( 27809), INT16_C( 10468), INT16_C( 29312), INT16_C( -5875),
                            INT16_C( 10801), INT16_C(-11039), INT16_C(-32348), INT16_C(-19420),
                            INT16_C(-32754), INT16_C(-20940), INT16_C( 17235), INT16_C(-29506)),
      simde_mm256_set_epi16(INT16_C( 32389), INT16_C(-20100), INT16_C( 26342), INT16_C(-12082),
                            INT16_C( 10468), INT16_C( 29312), INT16_C( 29312), INT16_C( 29312),
                            INT16_C( 10801), INT16_C(-11039), INT16_C(-32348), INT16_C(-19420),
                            INT16_C(-20940), INT16_C( 17235), INT16_C( 17235), INT16_C( 17235)) },
    { simde_mm256_set_epi16(INT16_C(-30489), INT16_C( 27619), INT16_C(-16535), INT16_C(-14927),
                            INT16_C( 10253), INT16_C( 31108), INT16_C(    46), INT16_C( 10088),
                            INT16_C(-25344), INT16_C( -5295), INT16_C( 22387), INT16_C( 27540),
                            INT16_C(-30287), INT16_C(  3057), INT16_C( -2994), INT16_C( 31366)),
      simde_mm256_set_epi16(INT16_C(-30489), INT16_C( 27619), INT16_C(-16535), INT16_C(-14927),
                            INT16_C( 31108), INT16_C(    46), INT16_C(    46), INT16_C(    46),
                            INT16_C(-25344), INT16_C( -5295), INT16_C( 22387), INT16_C( 27540),
                            INT16_C(  3057), INT16_C( -2994), INT16_C( -2994), INT16_C( -2994)) },
    { simde_mm256_set_epi16(INT16_C( -7255), INT16_C(-20910), INT16_C( 13809), INT16_C(  9595),
                            INT16_C( -1612), INT16_C( 23053), INT16_C(  7111), INT16_C(-11581),
                            INT16_C(-12829), INT16_C( 20686), INT16_C(-16865), INT16_C(  5649),
                            INT16_C(-25623), INT16_C( -2444), INT16_C( 11296), INT16_C(  7832)),
      simde_mm256_set_epi16(INT16_C( -7255), INT16_C(-20910), INT16_C( 13809), INT16_C(  9595),
                            INT16_C( 23053), INT16_C(  7111), INT16_C(  7111), INT16_C(  7111),
                            INT16_C(-12829), INT16_C( 20686), INT16_C(-16865), INT16_C(  5649),
                            INT16_C( -2444), INT16_C( 11296), INT16_C( 11296), INT16_C( 11296)) },
    { simde_mm256_set_epi16(INT16_C(-26606), INT16_C(  4305), INT16_C( 13601), INT16_C(  6245),
                            INT16_C( -6095), INT16_C(  5518), INT16_C(-13456), INT16_C(-16529),
                            INT16_C(-18890), INT16_C( 32306), INT16_C( 18285), INT16_C(  9413),
                            INT16_C( -4831), INT16_C( 31394), INT16_C(  7403), INT16_C(  8863)),
      simde_mm256_set_epi16(INT16_C(-26606), INT16_C(  4305), INT16_C( 13601), INT16_C(  6245),
                            INT16_C(  5518), INT16_C(-13456), INT16_C(-13456), INT16_C(-13456),
                            INT16_C(-18890), INT16_C( 32306), INT16_C( 18285), INT16_C(  9413),
                            INT16_C( 31394), INT16_C(  7403), INT16_C(  7403), INT16_C(  7403)) },
    { simde_mm256_set_epi16(INT16_C(-22090), INT16_C(  3292), INT16_C(-24353), INT16_C(-13630),
                            INT16_C(  1106), INT16_C( 20149), INT16_C( 12111), INT16_C( -9481),
                            INT16_C(  8059), INT16_C( 23722), INT16_C(-24846), INT16_C(-19082),
                            INT16_C( 18649), INT16_C( 23374), INT16_C(-15098), INT16_C(  5703)),
      simde_mm256_set_epi16(INT16_C(-22090), INT16_C(  3292), INT16_C(-24353), INT16_C(-13630),
                            INT16_C( 20149), INT16_C( 12111), INT16_C( 12111), INT16_C( 12111),
                            INT16_C(  8059), INT16_C( 23722), INT16_C(-24846), INT16_C(-19082),
                            INT16_C( 23374), INT16_C(-15098), INT16_C(-15098), INT16_C(-15098)) },
    { simde_mm256_set_epi16(INT16_C( 31351), INT16_C(-28147), INT16_C(-17219), INT16_C( 13266),
                            INT16_C( 26309), INT16_C(  5438), INT16_C( -9093), INT16_C(  -541),
                            INT16_C( -7590), INT16_C(-28792), INT16_C(  9449), INT16_C(-27866),
                            INT16_C(  7986), INT16_C(-24032), INT16_C( 23568), INT16_C( 18541)),
      simde_mm256_set_epi16(INT16_C( 31351), INT16_C(-28147), INT16_C(-17219), INT16_C( 13266),
                            INT16_C(  5438), INT16_C( -9093), INT16_C( -9093), INT16_C( -9093),
                            INT16_C( -7590), INT16_C(-28792), INT16_C(  9449), INT16_C(-27866),
                            INT16_C(-24032), INT16_C( 23568), INT16_C( 23568), INT16_C( 23568)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_shufflelo_epi16(test_vec[i].a, 149);
    simde_assert_m256i_i16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_sign_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi8(INT8_C(-124), INT8_C( -48), INT8_C(  10), INT8_C(  63),
                           INT8_C( -84), INT8_C( 103), INT8_C( -14), INT8_C(  63),
                           INT8_C(  82), INT8_C( -68), INT8_C( -17), INT8_C( 117),
                           INT8_C( -80), INT8_C(-104), INT8_C(  37), INT8_C(  59),
                           INT8_C( 121), INT8_C(  11), INT8_C( -20), INT8_C( -38),
                           INT8_C(  36), INT8_C( -63), INT8_C( -89), INT8_C( -39),
                           INT8_C( 115), INT8_C(  43), INT8_C(-116), INT8_C(   8),
                           INT8_C( -68), INT8_C( -15), INT8_C(  35), INT8_C( -73)),
      simde_mm256_set_epi8(INT8_C(  64), INT8_C( -46), INT8_C( 104), INT8_C(  85),
                           INT8_C( -66), INT8_C( 103), INT8_C( -19), INT8_C( -91),
                           INT8_C(-116), INT8_C(  86), INT8_C(  54), INT8_C(  90),
                           INT8_C(-128), INT8_C( 120), INT8_C( 127), INT8_C( -41),
                           INT8_C(  56), INT8_C(  45), INT8_C( -60), INT8_C(  14),
                           INT8_C(  -4), INT8_C( -42), INT8_C( -79), INT8_C(  83),
                           INT8_C(  72), INT8_C(  65), INT8_C( -99), INT8_C( 111),
                           INT8_C( -84), INT8_C( 103), INT8_C( -29), INT8_C( -65)),
      simde_mm256_set_epi8(INT8_C(-124), INT8_C(  48), INT8_C(  10), INT8_C(  63),
                           INT8_C(  84), INT8_C( 103), INT8_C(  14), INT8_C( -63),
                           INT8_C( -82), INT8_C( -68), INT8_C( -17), INT8_C( 117),
                           INT8_C(  80), INT8_C(-104), INT8_C(  37), INT8_C( -59),
                           INT8_C( 121), INT8_C(  11), INT8_C(  20), INT8_C( -38),
                           INT8_C( -36), INT8_C(  63), INT8_C(  89), INT8_C( -39),
                           INT8_C( 115), INT8_C(  43), INT8_C( 116), INT8_C(   8),
                           INT8_C(  68), INT8_C( -15), INT8_C( -35), INT8_C(  73)) },
    { simde_mm256_set_epi8(INT8_C( 122), INT8_C( 101), INT8_C(  57), INT8_C(-117),
                           INT8_C( -22), INT8_C( -56), INT8_C(  -5), INT8_C(  60),
                           INT8_C( 110), INT8_C( -69), INT8_C( -30), INT8_C( -83),
                           INT8_C(  50), INT8_C(  67), INT8_C( -85), INT8_C(  24),
                           INT8_C(  64), INT8_C( 117), INT8_C(  23), INT8_C( -97),
                           INT8_C(  88), INT8_C(  95), INT8_C(  73), INT8_C(  84),
                           INT8_C(  44), INT8_C( 108), INT8_C( -73), INT8_C(-105),
                           INT8_C(  58), INT8_C( 125), INT8_C(  21), INT8_C(  -8)),
      simde_mm256_set_epi8(INT8_C( -54), INT8_C( -52), INT8_C( 108), INT8_C(  17),
                           INT8_C( -61), INT8_C(  77), INT8_C( -68), INT8_C(-127),
                           INT8_C(  55), INT8_C( -25), INT8_C( -44), INT8_C(-111),
                           INT8_C(  12), INT8_C( -35), INT8_C( 116), INT8_C(  64),
                           INT8_C( -32), INT8_C( 127), INT8_C( -91), INT8_C( -72),
                           INT8_C( -92), INT8_C(  13), INT8_C(  97), INT8_C( -10),
                           INT8_C(-120), INT8_C( -40), INT8_C( -37), INT8_C( -49),
                           INT8_C( 123), INT8_C( -15), INT8_C( 100), INT8_C( -27)),
      simde_mm256_set_epi8(INT8_C(-122), INT8_C(-101), INT8_C(  57), INT8_C(-117),
                           INT8_C(  22), INT8_C( -56), INT8_C(   5), INT8_C( -60),
                           INT8_C( 110), INT8_C(  69), INT8_C(  30), INT8_C(  83),
                           INT8_C(  50), INT8_C( -67), INT8_C( -85), INT8_C(  24),
                           INT8_C( -64), INT8_C( 117), INT8_C( -23), INT8_C(  97),
                           INT8_C( -88), INT8_C(  95), INT8_C(  73), INT8_C( -84),
                           INT8_C( -44), INT8_C(-108), INT8_C(  73), INT8_C( 105),
                           INT8_C(  58), INT8_C(-125), INT8_C(  21), INT8_C(   8)) },
    { simde_mm256_set_epi8(INT8_C(  80), INT8_C(-104), INT8_C(  33), INT8_C( -96),
                           INT8_C( 105), INT8_C( -57), INT8_C(-123), INT8_C(  89),
                           INT8_C(  62), INT8_C( -47), INT8_C( -92), INT8_C( -33),
                           INT8_C( 113), INT8_C(  44), INT8_C( 125), INT8_C( -43),
                           INT8_C(  28), INT8_C( -43), INT8_C( 122), INT8_C(-115),
                           INT8_C(  45), INT8_C(  72), INT8_C(  66), INT8_C(  86),
                           INT8_C( -11), INT8_C(  17), INT8_C(  64), INT8_C( -36),
                           INT8_C( -86), INT8_C(  -6), INT8_C( -64), INT8_C(  31)),
      simde_mm256_set_epi8(INT8_C(  65), INT8_C( -61), INT8_C(  83), INT8_C( -37),
                           INT8_C(-100), INT8_C(  96), INT8_C(  90), INT8_C( -24),
                           INT8_C(  86), INT8_C( -18), INT8_C( -62), INT8_C(-110),
                           INT8_C(-107), INT8_C(  -6), INT8_C(   9), INT8_C(  -6),
                           INT8_C(  80), INT8_C( -71), INT8_C( -81), INT8_C( 127),
                           INT8_C( -21), INT8_C( -14), INT8_C(  27), INT8_C(  82),
                           INT8_C(-126), INT8_C(  70), INT8_C(  18), INT8_C( -75),
                           INT8_C( 126), INT8_C(-103), INT8_C(-109), INT8_C( 116)),
      simde_mm256_set_epi8(INT8_C(  80), INT8_C( 104), INT8_C(  33), INT8_C(  96),
                           INT8_C(-105), INT8_C( -57), INT8_C(-123), INT8_C( -89),
                           INT8_C(  62), INT8_C(  47), INT8_C(  92), INT8_C(  33),
                           INT8_C(-113), INT8_C( -44), INT8_C( 125), INT8_C(  43),
                           INT8_C(  28), INT8_C(  43), INT8_C(-122), INT8_C(-115),
                           INT8_C( -45), INT8_C( -72), INT8_C(  66), INT8_C(  86),
                           INT8_C(  11), INT8_C(  17), INT8_C(  64), INT8_C(  36),
                           INT8_C( -86), INT8_C(   6), INT8_C(  64), INT8_C(  31)) },
    { simde_mm256_set_epi8(INT8_C(  88), INT8_C(  57), INT8_C( -36), INT8_C(  10),
                           INT8_C(  93), INT8_C( -67), INT8_C(  35), INT8_C(   4),
                           INT8_C(  82), INT8_C( -81), INT8_C(  18), INT8_C(  74),
                           INT8_C(-119), INT8_C( -48), INT8_C(  50), INT8_C( -37),
                           INT8_C(  85), INT8_C(  99), INT8_C( -94), INT8_C(-127),
                           INT8_C( 126), INT8_C(  36), INT8_C(  87), INT8_C( -95),
                           INT8_C( 111), INT8_C(  86), INT8_C( -49), INT8_C(  -3),
                           INT8_C( -39), INT8_C(  19), INT8_C(  -3), INT8_C( -93)),
      simde_mm256_set_epi8(INT8_C( -50), INT8_C(  47), INT8_C( 110), INT8_C(  89),
                           INT8_C( -98), INT8_C( -62), INT8_C( 100), INT8_C( -53),
                           INT8_C( -92), INT8_C(  -2), INT8_C(  91), INT8_C( -12),
                           INT8_C( -28), INT8_C( -91), INT8_C( -27), INT8_C(  32),
                           INT8_C(-110), INT8_C( -42), INT8_C(  73), INT8_C(-102),
                           INT8_C(-122), INT8_C(  48), INT8_C(  -4), INT8_C( -50),
                           INT8_C(   9), INT8_C( -36), INT8_C( 102), INT8_C(-126),
                           INT8_C(  34), INT8_C(  96), INT8_C( -57), INT8_C(   7)),
      simde_mm256_set_epi8(INT8_C( -88), INT8_C(  57), INT8_C( -36), INT8_C(  10),
                           INT8_C( -93), INT8_C(  67), INT8_C(  35), INT8_C(  -4),
                           INT8_C( -82), INT8_C(  81), INT8_C(  18), INT8_C( -74),
                           INT8_C( 119), INT8_C(  48), INT8_C( -50), INT8_C( -37),
                           INT8_C( -85), INT8_C( -99), INT8_C( -94), INT8_C( 127),
                           INT8_C(-126), INT8_C(  36), INT8_C( -87), INT8_C(  95),
                           INT8_C( 111), INT8_C( -86), INT8_C( -49), INT8_C(   3),
                           INT8_C( -39), INT8_C(  19), INT8_C(   3), INT8_C( -93)) },
    { simde_mm256_set_epi8(INT8_C(  77), INT8_C( -76), INT8_C( 117), INT8_C( -63),
                           INT8_C( -98), INT8_C( -23), INT8_C(  99), INT8_C(  28),
                           INT8_C( 114), INT8_C( -99), INT8_C( 117), INT8_C( -16),
                           INT8_C( -35), INT8_C(  79), INT8_C( -35), INT8_C( -40),
                           INT8_C( 116), INT8_C(  97), INT8_C(  16), INT8_C(  32),
                           INT8_C(-122), INT8_C(  -2), INT8_C( 116), INT8_C( -53),
                           INT8_C(-103), INT8_C( -52), INT8_C(  50), INT8_C( -27),
                           INT8_C(-112), INT8_C( 115), INT8_C( -42), INT8_C( -87)),
      simde_mm256_set_epi8(INT8_C(  49), INT8_C( 101), INT8_C( -91), INT8_C( -11),
                           INT8_C(  38), INT8_C( 110), INT8_C(  63), INT8_C( 118),
                           INT8_C(  65), INT8_C( -80), INT8_C( 118), INT8_C( -75),
                           INT8_C( 103), INT8_C( -76), INT8_C(  10), INT8_C( -66),
                           INT8_C( 107), INT8_C(-120), INT8_C(  11), INT8_C( -38),
                           INT8_C( -59), INT8_C( -40), INT8_C(  -9), INT8_C( 123),
                           INT8_C(  -3), INT8_C( -44), INT8_C( -64), INT8_C(  26),
                           INT8_C( -30), INT8_C(  14), INT8_C(-100), INT8_C(  22)),
      simde_mm256_set_epi8(INT8_C(  77), INT8_C( -76), INT8_C(-117), INT8_C(  63),
                           INT8_C( -98), INT8_C( -23), INT8_C(  99), INT8_C(  28),
                           INT8_C( 114), INT8_C(  99), INT8_C( 117), INT8_C(  16),
                           INT8_C( -35), INT8_C( -79), INT8_C( -35), INT8_C(  40),
                           INT8_C( 116), INT8_C( -97), INT8_C(  16), INT8_C( -32),
                           INT8_C( 122), INT8_C(   2), INT8_C(-116), INT8_C( -53),
                           INT8_C( 103), INT8_C(  52), INT8_C( -50), INT8_C( -27),
                           INT8_C( 112), INT8_C( 115), INT8_C(  42), INT8_C( -87)) },
    { simde_mm256_set_epi8(INT8_C( -77), INT8_C(  55), INT8_C(  69), INT8_C(   5),
                           INT8_C( -56), INT8_C(  30), INT8_C( 123), INT8_C(  84),
                           INT8_C(  88), INT8_C(-108), INT8_C(  47), INT8_C( -23),
                           INT8_C( -58), INT8_C( -90), INT8_C(  18), INT8_C(-120),
                           INT8_C( -15), INT8_C(  43), INT8_C( 102), INT8_C(   1),
                           INT8_C( -38), INT8_C(  45), INT8_C( 120), INT8_C( 124),
                           INT8_C(  39), INT8_C(  42), INT8_C(-106), INT8_C(  42),
                           INT8_C(  50), INT8_C( 123), INT8_C(  83), INT8_C( -75)),
      simde_mm256_set_epi8(INT8_C( -99), INT8_C(   1), INT8_C( 103), INT8_C( -24),
                           INT8_C(  77), INT8_C(  77), INT8_C( -55), INT8_C(  64),
                           INT8_C( -51), INT8_C( 124), INT8_C( -74), INT8_C(  85),
                           INT8_C(  26), INT8_C( -10), INT8_C( -19), INT8_C( -23),
                           INT8_C( -11), INT8_C(  18), INT8_C(-116), INT8_C(  62),
                           INT8_C( -42), INT8_C( -20), INT8_C( 104), INT8_C(-123),
                           INT8_C(-113), INT8_C(   1), INT8_C( -68), INT8_C( -90),
                           INT8_C(   1), INT8_C( -32), INT8_C(   1), INT8_C(-108)),
      simde_mm256_set_epi8(INT8_C(  77), INT8_C(  55), INT8_C(  69), INT8_C(  -5),
                           INT8_C( -56), INT8_C(  30), INT8_C(-123), INT8_C(  84),
                           INT8_C( -88), INT8_C(-108), INT8_C( -47), INT8_C( -23),
                           INT8_C( -58), INT8_C(  90), INT8_C( -18), INT8_C( 120),
                           INT8_C(  15), INT8_C(  43), INT8_C(-102), INT8_C(   1),
                           INT8_C(  38), INT8_C( -45), INT8_C( 120), INT8_C(-124),
                           INT8_C( -39), INT8_C(  42), INT8_C( 106), INT8_C( -42),
                           INT8_C(  50), INT8_C(-123), INT8_C(  83), INT8_C(  75)) },
    { simde_mm256_set_epi8(INT8_C( 124), INT8_C(  74), INT8_C( -32), INT8_C(  30),
                           INT8_C(-109), INT8_C(  52), INT8_C(  31), INT8_C(  94),
                           INT8_C( -78), INT8_C( -59), INT8_C(  -8), INT8_C(  92),
                           INT8_C(   9), INT8_C( -91), INT8_C( -63), INT8_C( -72),
                           INT8_C( -85), INT8_C(   1), INT8_C(  60), INT8_C(  84),
                           INT8_C(  43), INT8_C( -36), INT8_C(-112), INT8_C(   6),
                           INT8_C( -19), INT8_C(-123), INT8_C(  80), INT8_C( -53),
                           INT8_C( -54), INT8_C(  94), INT8_C(   3), INT8_C( 112)),
      simde_mm256_set_epi8(INT8_C( -31), INT8_C( -40), INT8_C( -74), INT8_C(  49),
                           INT8_C(-107), INT8_C(-106), INT8_C( 102), INT8_C(   9),
                           INT8_C( 117), INT8_C(  90), INT8_C( 114), INT8_C( -61),
                           INT8_C(  32), INT8_C(  -8), INT8_C(  -4), INT8_C( -57),
                           INT8_C( 123), INT8_C(-125), INT8_C(   9), INT8_C(-128),
                           INT8_C(-101), INT8_C(   1), INT8_C(  32), INT8_C( -63),
                           INT8_C(  99), INT8_C(  41), INT8_C(  38), INT8_C(-106),
                           INT8_C( -65), INT8_C(  58), INT8_C( -23), INT8_C( 120)),
      simde_mm256_set_epi8(INT8_C(-124), INT8_C( -74), INT8_C(  32), INT8_C(  30),
                           INT8_C( 109), INT8_C( -52), INT8_C(  31), INT8_C(  94),
                           INT8_C( -78), INT8_C( -59), INT8_C(  -8), INT8_C( -92),
                           INT8_C(   9), INT8_C(  91), INT8_C(  63), INT8_C(  72),
                           INT8_C( -85), INT8_C(  -1), INT8_C(  60), INT8_C( -84),
                           INT8_C( -43), INT8_C( -36), INT8_C(-112), INT8_C(  -6),
                           INT8_C( -19), INT8_C(-123), INT8_C(  80), INT8_C(  53),
                           INT8_C(  54), INT8_C(  94), INT8_C(  -3), INT8_C( 112)) },
    { simde_mm256_set_epi8(INT8_C( -49), INT8_C(-106), INT8_C(  23), INT8_C(  37),
                           INT8_C( -87), INT8_C( 105), INT8_C(  66), INT8_C( -47),
                           INT8_C(-100), INT8_C( -77), INT8_C(-123), INT8_C( -73),
                           INT8_C(  -4), INT8_C( -48), INT8_C(  97), INT8_C( -78),
                           INT8_C(  21), INT8_C( 125), INT8_C(-128), INT8_C(  30),
                           INT8_C( -87), INT8_C(  46), INT8_C( -21), INT8_C( -69),
                           INT8_C(  -4), INT8_C(  15), INT8_C( -17), INT8_C( -95),
                           INT8_C(   7), INT8_C(  32), INT8_C(  93), INT8_C( -95)),
      simde_mm256_set_epi8(INT8_C(  27), INT8_C(  61), INT8_C(  26), INT8_C(  17),
                           INT8_C( 110), INT8_C(  35), INT8_C(  70), INT8_C( -63),
                           INT8_C(  51), INT8_C( -79), INT8_C( -47), INT8_C(  74),
                           INT8_C(  44), INT8_C(   7), INT8_C( 125), INT8_C( -59),
                           INT8_C( -26), INT8_C( -74), INT8_C( -55), INT8_C( -22),
                           INT8_C(  18), INT8_C( -40), INT8_C(  33), INT8_C( 126),
                           INT8_C(-127), INT8_C(  -2), INT8_C(-125), INT8_C(  79),
                           INT8_C( 113), INT8_C(  14), INT8_C( 113), INT8_C(  21)),
      simde_mm256_set_epi8(INT8_C( -49), INT8_C(-106), INT8_C(  23), INT8_C(  37),
                           INT8_C( -87), INT8_C( 105), INT8_C(  66), INT8_C(  47),
                           INT8_C(-100), INT8_C(  77), INT8_C( 123), INT8_C( -73),
                           INT8_C(  -4), INT8_C( -48), INT8_C(  97), INT8_C(  78),
                           INT8_C( -21), INT8_C(-125), INT8_C(-128), INT8_C( -30),
                           INT8_C( -87), INT8_C( -46), INT8_C( -21), INT8_C( -69),
                           INT8_C(   4), INT8_C( -15), INT8_C(  17), INT8_C( -95),
                           INT8_C(   7), INT8_C(  32), INT8_C(  93), INT8_C( -95)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_sign_epi8(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_sign_epi16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi16(INT16_C(-31536), INT16_C(  2623), INT16_C(-21401), INT16_C( -3521),
                            INT16_C( 21180), INT16_C( -4235), INT16_C(-20328), INT16_C(  9531),
                            INT16_C( 30987), INT16_C( -4902), INT16_C(  9409), INT16_C(-22567),
                            INT16_C( 29483), INT16_C(-29688), INT16_C(-17167), INT16_C(  9143)),
      simde_mm256_set_epi16(INT16_C( 16594), INT16_C( 26709), INT16_C(-16793), INT16_C( -4699),
                            INT16_C(-29610), INT16_C( 13914), INT16_C(-32648), INT16_C( 32727),
                            INT16_C( 14381), INT16_C(-15346), INT16_C(  -810), INT16_C(-20141),
                            INT16_C( 18497), INT16_C(-25233), INT16_C(-21401), INT16_C( -7233)),
      simde_mm256_set_epi16(INT16_C(-31536), INT16_C(  2623), INT16_C( 21401), INT16_C(  3521),
                            INT16_C(-21180), INT16_C( -4235), INT16_C( 20328), INT16_C(  9531),
                            INT16_C( 30987), INT16_C(  4902), INT16_C( -9409), INT16_C( 22567),
                            INT16_C( 29483), INT16_C( 29688), INT16_C( 17167), INT16_C( -9143)) },
    { simde_mm256_set_epi16(INT16_C( 31333), INT16_C( 14731), INT16_C( -5432), INT16_C( -1220),
                            INT16_C( 28347), INT16_C( -7507), INT16_C( 12867), INT16_C(-21736),
                            INT16_C( 16501), INT16_C(  6047), INT16_C( 22623), INT16_C( 18772),
                            INT16_C( 11372), INT16_C(-18537), INT16_C( 14973), INT16_C(  5624)),
      simde_mm256_set_epi16(INT16_C(-13620), INT16_C( 27665), INT16_C(-15539), INT16_C(-17279),
                            INT16_C( 14311), INT16_C(-11119), INT16_C(  3293), INT16_C( 29760),
                            INT16_C( -8065), INT16_C(-23112), INT16_C(-23539), INT16_C( 25078),
                            INT16_C(-30504), INT16_C( -9265), INT16_C( 31729), INT16_C( 25829)),
      simde_mm256_set_epi16(INT16_C(-31333), INT16_C( 14731), INT16_C(  5432), INT16_C(  1220),
                            INT16_C( 28347), INT16_C(  7507), INT16_C( 12867), INT16_C(-21736),
                            INT16_C(-16501), INT16_C( -6047), INT16_C(-22623), INT16_C( 18772),
                            INT16_C(-11372), INT16_C( 18537), INT16_C( 14973), INT16_C(  5624)) },
    { simde_mm256_set_epi16(INT16_C( 20632), INT16_C(  8608), INT16_C( 27079), INT16_C(-31399),
                            INT16_C( 16081), INT16_C(-23329), INT16_C( 28972), INT16_C( 32213),
                            INT16_C(  7381), INT16_C( 31373), INT16_C( 11592), INT16_C( 16982),
                            INT16_C( -2799), INT16_C( 16604), INT16_C(-21766), INT16_C(-16353)),
      simde_mm256_set_epi16(INT16_C( 16835), INT16_C( 21467), INT16_C(-25504), INT16_C( 23272),
                            INT16_C( 22254), INT16_C(-15726), INT16_C(-27142), INT16_C(  2554),
                            INT16_C( 20665), INT16_C(-20609), INT16_C( -5134), INT16_C(  6994),
                            INT16_C(-32186), INT16_C(  4789), INT16_C( 32409), INT16_C(-27788)),
      simde_mm256_set_epi16(INT16_C( 20632), INT16_C(  8608), INT16_C(-27079), INT16_C(-31399),
                            INT16_C( 16081), INT16_C( 23329), INT16_C(-28972), INT16_C( 32213),
                            INT16_C(  7381), INT16_C(-31373), INT16_C(-11592), INT16_C( 16982),
                            INT16_C(  2799), INT16_C( 16604), INT16_C(-21766), INT16_C( 16353)) },
    { simde_mm256_set_epi16(INT16_C( 22585), INT16_C( -9206), INT16_C( 23997), INT16_C(  8964),
                            INT16_C( 21167), INT16_C(  4682), INT16_C(-30256), INT16_C( 13019),
                            INT16_C( 21859), INT16_C(-23935), INT16_C( 32292), INT16_C( 22433),
                            INT16_C( 28502), INT16_C(-12291), INT16_C( -9965), INT16_C(  -605)),
      simde_mm256_set_epi16(INT16_C(-12753), INT16_C( 28249), INT16_C(-24894), INT16_C( 25803),
                            INT16_C(-23298), INT16_C( 23540), INT16_C( -7003), INT16_C( -6880),
                            INT16_C(-27946), INT16_C( 18842), INT16_C(-31184), INT16_C(  -818),
                            INT16_C(  2524), INT16_C( 26242), INT16_C(  8800), INT16_C(-14585)),
      simde_mm256_set_epi16(INT16_C(-22585), INT16_C( -9206), INT16_C(-23997), INT16_C(  8964),
                            INT16_C(-21167), INT16_C(  4682), INT16_C( 30256), INT16_C(-13019),
                            INT16_C(-21859), INT16_C(-23935), INT16_C(-32292), INT16_C(-22433),
                            INT16_C( 28502), INT16_C(-12291), INT16_C( -9965), INT16_C(   605)) },
    { simde_mm256_set_epi16(INT16_C( 19892), INT16_C( 30145), INT16_C(-24855), INT16_C( 25372),
                            INT16_C( 29341), INT16_C( 30192), INT16_C( -8881), INT16_C( -8744),
                            INT16_C( 29793), INT16_C(  4128), INT16_C(-30978), INT16_C( 29899),
                            INT16_C(-26164), INT16_C( 13029), INT16_C(-28557), INT16_C(-10583)),
      simde_mm256_set_epi16(INT16_C( 12645), INT16_C(-23051), INT16_C(  9838), INT16_C( 16246),
                            INT16_C( 16816), INT16_C( 30389), INT16_C( 26548), INT16_C(  2750),
                            INT16_C( 27528), INT16_C(  3034), INT16_C(-14888), INT16_C( -2181),
                            INT16_C(  -556), INT16_C(-16358), INT16_C( -7666), INT16_C(-25578)),
      simde_mm256_set_epi16(INT16_C( 19892), INT16_C(-30145), INT16_C(-24855), INT16_C( 25372),
                            INT16_C( 29341), INT16_C( 30192), INT16_C( -8881), INT16_C( -8744),
                            INT16_C( 29793), INT16_C(  4128), INT16_C( 30978), INT16_C(-29899),
                            INT16_C( 26164), INT16_C(-13029), INT16_C( 28557), INT16_C( 10583)) },
    { simde_mm256_set_epi16(INT16_C(-19657), INT16_C( 17669), INT16_C(-14306), INT16_C( 31572),
                            INT16_C( 22676), INT16_C( 12265), INT16_C(-14682), INT16_C(  4744),
                            INT16_C( -3797), INT16_C( 26113), INT16_C( -9683), INT16_C( 30844),
                            INT16_C( 10026), INT16_C(-27094), INT16_C( 12923), INT16_C( 21429)),
      simde_mm256_set_epi16(INT16_C(-25343), INT16_C( 26600), INT16_C( 19789), INT16_C(-14016),
                            INT16_C(-12932), INT16_C(-18859), INT16_C(  6902), INT16_C( -4631),
                            INT16_C( -2798), INT16_C(-29634), INT16_C(-10516), INT16_C( 26757),
                            INT16_C(-28927), INT16_C(-17242), INT16_C(   480), INT16_C(   404)),
      simde_mm256_set_epi16(INT16_C( 19657), INT16_C( 17669), INT16_C(-14306), INT16_C(-31572),
                            INT16_C(-22676), INT16_C(-12265), INT16_C(-14682), INT16_C( -4744),
                            INT16_C(  3797), INT16_C(-26113), INT16_C(  9683), INT16_C( 30844),
                            INT16_C(-10026), INT16_C( 27094), INT16_C( 12923), INT16_C( 21429)) },
    { simde_mm256_set_epi16(INT16_C( 31818), INT16_C( -8162), INT16_C(-27852), INT16_C(  8030),
                            INT16_C(-19771), INT16_C( -1956), INT16_C(  2469), INT16_C(-15944),
                            INT16_C(-21759), INT16_C( 15444), INT16_C( 11228), INT16_C(-28666),
                            INT16_C( -4731), INT16_C( 20683), INT16_C(-13730), INT16_C(   880)),
      simde_mm256_set_epi16(INT16_C( -7720), INT16_C(-18895), INT16_C(-27242), INT16_C( 26121),
                            INT16_C( 30042), INT16_C( 29379), INT16_C(  8440), INT16_C(  -825),
                            INT16_C( 31619), INT16_C(  2432), INT16_C(-25855), INT16_C(  8385),
                            INT16_C( 25385), INT16_C(  9878), INT16_C(-16582), INT16_C( -5768)),
      simde_mm256_set_epi16(INT16_C(-31818), INT16_C(  8162), INT16_C( 27852), INT16_C(  8030),
                            INT16_C(-19771), INT16_C( -1956), INT16_C(  2469), INT16_C( 15944),
                            INT16_C(-21759), INT16_C( 15444), INT16_C(-11228), INT16_C(-28666),
                            INT16_C( -4731), INT16_C( 20683), INT16_C( 13730), INT16_C(  -880)) },
    { simde_mm256_set_epi16(INT16_C(-12394), INT16_C(  5925), INT16_C(-22167), INT16_C( 17105),
                            INT16_C(-25421), INT16_C(-31305), INT16_C(  -816), INT16_C( 25010),
                            INT16_C(  5501), INT16_C(-32738), INT16_C(-22226), INT16_C( -5189),
                            INT16_C( -1009), INT16_C( -4191), INT16_C(  1824), INT16_C( 23969)),
      simde_mm256_set_epi16(INT16_C(  6973), INT16_C(  6673), INT16_C( 28195), INT16_C( 18113),
                            INT16_C( 13233), INT16_C(-11958), INT16_C( 11271), INT16_C( 32197),
                            INT16_C( -6474), INT16_C(-13846), INT16_C(  4824), INT16_C(  8574),
                            INT16_C(-32258), INT16_C(-31921), INT16_C( 28942), INT16_C( 28949)),
      simde_mm256_set_epi16(INT16_C(-12394), INT16_C(  5925), INT16_C(-22167), INT16_C( 17105),
                            INT16_C(-25421), INT16_C( 31305), INT16_C(  -816), INT16_C( 25010),
                            INT16_C( -5501), INT16_C( 32738), INT16_C(-22226), INT16_C( -5189),
                            INT16_C(  1009), INT16_C(  4191), INT16_C(  1824), INT16_C( 23969)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_sign_epi16(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_sign_epi32(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi32(INT32_C(-2066740673), INT32_C(-1402473921), INT32_C( 1388113781), INT32_C(-1332206277),
                            INT32_C( 2030824666), INT32_C(  616671193), INT32_C( 1932233736), INT32_C(-1125047369)),
      simde_mm256_set_epi32(INT32_C( 1087531093), INT32_C(-1100485211), INT32_C(-1940507046), INT32_C(-2139586601),
                            INT32_C(  942523406), INT32_C(  -53038765), INT32_C( 1212259695), INT32_C(-1402477633)),
      simde_mm256_set_epi32(INT32_C(-2066740673), INT32_C( 1402473921), INT32_C(-1388113781), INT32_C( 1332206277),
                            INT32_C( 2030824666), INT32_C( -616671193), INT32_C( 1932233736), INT32_C( 1125047369)) },
    { simde_mm256_set_epi32(INT32_C( 2053454219), INT32_C( -355927236), INT32_C( 1857807021), INT32_C(  843295512),
                            INT32_C( 1081415583), INT32_C( 1482639700), INT32_C(  745322391), INT32_C(  981276152)),
      simde_mm256_set_epi32(INT32_C( -892572655), INT32_C(-1018315647), INT32_C(  937940113), INT32_C(  215839808),
                            INT32_C( -528505416), INT32_C(-1542626826), INT32_C(-1999053873), INT32_C( 2079417573)),
      simde_mm256_set_epi32(INT32_C(-2053454219), INT32_C(  355927236), INT32_C( 1857807021), INT32_C(  843295512),
                            INT32_C(-1081415583), INT32_C(-1482639700), INT32_C( -745322391), INT32_C(  981276152)) },
    { simde_mm256_set_epi32(INT32_C( 1352147360), INT32_C( 1774683481), INT32_C( 1053926623), INT32_C( 1898741205),
                            INT32_C(  483752589), INT32_C(  759710294), INT32_C( -183418660), INT32_C(-1426407393)),
      simde_mm256_set_epi32(INT32_C( 1103320027), INT32_C(-1671406872), INT32_C( 1458487954), INT32_C(-1778775558),
                            INT32_C( 1354346367), INT32_C( -336454830), INT32_C(-2109336907), INT32_C( 2123993972)),
      simde_mm256_set_epi32(INT32_C( 1352147360), INT32_C(-1774683481), INT32_C( 1053926623), INT32_C(-1898741205),
                            INT32_C(  483752589), INT32_C( -759710294), INT32_C(  183418660), INT32_C(-1426407393)) },
    { simde_mm256_set_epi32(INT32_C( 1480186890), INT32_C( 1572676356), INT32_C( 1387205194), INT32_C(-1982844197),
                            INT32_C( 1432593025), INT32_C( 2116310945), INT32_C( 1867960317), INT32_C( -653001309)),
      simde_mm256_set_epi32(INT32_C( -835752359), INT32_C(-1631427381), INT32_C(-1526834188), INT32_C( -458889952),
                            INT32_C(-1831450214), INT32_C(-2043609906), INT32_C(  165439106), INT32_C(  576767751)),
      simde_mm256_set_epi32(INT32_C(-1480186890), INT32_C(-1572676356), INT32_C(-1387205194), INT32_C( 1982844197),
                            INT32_C(-1432593025), INT32_C(-2116310945), INT32_C( 1867960317), INT32_C( -653001309)) },
    { simde_mm256_set_epi32(INT32_C( 1303672257), INT32_C(-1628871908), INT32_C( 1922921968), INT32_C( -581968424),
                            INT32_C( 1952518176), INT32_C(-2030144309), INT32_C(-1714670875), INT32_C(-1871456599)),
      simde_mm256_set_epi32(INT32_C(  828745205), INT32_C(  644759414), INT32_C( 1102083765), INT32_C( 1739852478),
                            INT32_C( 1804078042), INT32_C( -975636613), INT32_C(  -36388838), INT32_C( -502359018)),
      simde_mm256_set_epi32(INT32_C( 1303672257), INT32_C(-1628871908), INT32_C( 1922921968), INT32_C( -581968424),
                            INT32_C( 1952518176), INT32_C( 2030144309), INT32_C( 1714670875), INT32_C( 1871456599)) },
    { simde_mm256_set_epi32(INT32_C(-1288223483), INT32_C( -937526444), INT32_C( 1486106601), INT32_C( -962194808),
                            INT32_C( -248814079), INT32_C( -634554244), INT32_C(  657102378), INT32_C(  846943157)),
      simde_mm256_set_epi32(INT32_C(-1660852248), INT32_C( 1296943424), INT32_C( -847464875), INT32_C(  452390377),
                            INT32_C( -183333826), INT32_C( -689149819), INT32_C(-1895711578), INT32_C(   31457684)),
      simde_mm256_set_epi32(INT32_C( 1288223483), INT32_C( -937526444), INT32_C(-1486106601), INT32_C( -962194808),
                            INT32_C(  248814079), INT32_C(  634554244), INT32_C( -657102378), INT32_C(  846943157)) },
    { simde_mm256_set_epi32(INT32_C( 2085281822), INT32_C(-1825300642), INT32_C(-1295648676), INT32_C(  161857976),
                            INT32_C(-1425982380), INT32_C(  735875078), INT32_C( -310030133), INT32_C( -899808400)),
      simde_mm256_set_epi32(INT32_C( -505891279), INT32_C(-1785305591), INT32_C( 1968861891), INT32_C(  553188551),
                            INT32_C( 2072185216), INT32_C(-1694424895), INT32_C( 1663641238), INT32_C(-1086658184)),
      simde_mm256_set_epi32(INT32_C(-2085281822), INT32_C( 1825300642), INT32_C(-1295648676), INT32_C(  161857976),
                            INT32_C(-1425982380), INT32_C( -735875078), INT32_C( -310030133), INT32_C(  899808400)) },
    { simde_mm256_set_epi32(INT32_C( -812247259), INT32_C(-1452719407), INT32_C(-1665956425), INT32_C(  -53452366),
                            INT32_C(  360546334), INT32_C(-1456542789), INT32_C(  -66064479), INT32_C(  119561633)),
      simde_mm256_set_epi32(INT32_C(  456989201), INT32_C( 1847805633), INT32_C(  867291466), INT32_C(  738688453),
                            INT32_C( -424228374), INT32_C(  316154238), INT32_C(-2114026673), INT32_C( 1896771861)),
      simde_mm256_set_epi32(INT32_C( -812247259), INT32_C(-1452719407), INT32_C(-1665956425), INT32_C(  -53452366),
                            INT32_C( -360546334), INT32_C(-1456542789), INT32_C(   66064479), INT32_C(  119561633)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_sign_epi32(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_slli_epi16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i r;
  } test_vec[] = {
    { simde_mm256_set_epi16(INT16_C( -7189), INT16_C( -4038), INT16_C(  8832), INT16_C(-31599),
                            INT16_C(  9071), INT16_C(-26166), INT16_C(  4984), INT16_C(-29916),
                            INT16_C( 26692), INT16_C(  7557), INT16_C(-30970), INT16_C(-31903),
                            INT16_C( 32721), INT16_C( 14732), INT16_C( -9072), INT16_C(-28469)),
      simde_mm256_set_epi16(INT16_C( -7189), INT16_C( -4038), INT16_C(  8832), INT16_C(-31599),
                            INT16_C(  9071), INT16_C(-26166), INT16_C(  4984), INT16_C(-29916),
                            INT16_C( 26692), INT16_C(  7557), INT16_C(-30970), INT16_C(-31903),
                            INT16_C( 32721), INT16_C( 14732), INT16_C( -9072), INT16_C(-28469)) },
    { simde_mm256_set_epi16(INT16_C( 27658), INT16_C(-18253), INT16_C( 19135), INT16_C(-22021),
                            INT16_C(-31750), INT16_C( 26403), INT16_C(-14265), INT16_C( -1890),
                            INT16_C( 16323), INT16_C( -5176), INT16_C(-29730), INT16_C( -7646),
                            INT16_C(-24362), INT16_C( 28979), INT16_C( 13248), INT16_C(  6628)),
      simde_mm256_set_epi16(INT16_C(-10220), INT16_C( 29030), INT16_C(-27266), INT16_C( 21494),
                            INT16_C(  2036), INT16_C(-12730), INT16_C(-28530), INT16_C( -3780),
                            INT16_C( 32646), INT16_C(-10352), INT16_C(  6076), INT16_C(-15292),
                            INT16_C( 16812), INT16_C( -7578), INT16_C( 26496), INT16_C( 13256)) },
    { simde_mm256_set_epi16(INT16_C(-18549), INT16_C( -1433), INT16_C( 15072), INT16_C( 28665),
                            INT16_C(-22672), INT16_C( 30426), INT16_C(-11873), INT16_C(-28559),
                            INT16_C( 26366), INT16_C( 20007), INT16_C( 14676), INT16_C( -4391),
                            INT16_C(-13223), INT16_C(-20349), INT16_C(-14071), INT16_C(  6326)),
      simde_mm256_set_epi16(INT16_C( -8660), INT16_C( -5732), INT16_C( -5248), INT16_C(-16412),
                            INT16_C(-25152), INT16_C( -9368), INT16_C( 18044), INT16_C( 16836),
                            INT16_C(-25608), INT16_C( 14492), INT16_C( -6832), INT16_C(-17564),
                            INT16_C( 12644), INT16_C(-15860), INT16_C(  9252), INT16_C( 25304)) },
    { simde_mm256_set_epi16(INT16_C(-15802), INT16_C(  1115), INT16_C(-15134), INT16_C(-24432),
                            INT16_C( 29893), INT16_C( 28473), INT16_C( 18873), INT16_C( 20173),
                            INT16_C(   191), INT16_C( 32281), INT16_C( 13007), INT16_C( 21879),
                            INT16_C( 31137), INT16_C(-25345), INT16_C(  8960), INT16_C(  9998)),
      simde_mm256_set_epi16(INT16_C(  4656), INT16_C(  8920), INT16_C( 10000), INT16_C(  1152),
                            INT16_C(-23000), INT16_C( 31176), INT16_C( 19912), INT16_C( 30312),
                            INT16_C(  1528), INT16_C( -3896), INT16_C(-27016), INT16_C(-21576),
                            INT16_C(-13048), INT16_C( -6152), INT16_C(  6144), INT16_C( 14448)) },
    { simde_mm256_set_epi16(INT16_C(-11235), INT16_C( 12162), INT16_C(-25050), INT16_C(-16691),
                            INT16_C(-21645), INT16_C(-11525), INT16_C( 24581), INT16_C( 20473),
                            INT16_C( 17987), INT16_C( 13992), INT16_C( 21082), INT16_C(  9896),
                            INT16_C( 20946), INT16_C(  -338), INT16_C(  -890), INT16_C(  3047)),
      simde_mm256_set_epi16(INT16_C( 16848), INT16_C( -2016), INT16_C( -7584), INT16_C( -4912),
                            INT16_C(-18640), INT16_C( 12208), INT16_C(    80), INT16_C(  -112),
                            INT16_C( 25648), INT16_C( 27264), INT16_C(  9632), INT16_C( 27264),
                            INT16_C(  7456), INT16_C( -5408), INT16_C(-14240), INT16_C(-16784)) },
    { simde_mm256_set_epi16(INT16_C(  4232), INT16_C(  9528), INT16_C(  5625), INT16_C( -2056),
                            INT16_C( -5147), INT16_C(-18162), INT16_C(-12026), INT16_C(-23947),
                            INT16_C( 19702), INT16_C( 18533), INT16_C( 17268), INT16_C( -7285),
                            INT16_C(-25540), INT16_C( 15541), INT16_C(-16480), INT16_C(-30543)),
      simde_mm256_set_epi16(INT16_C(  4352), INT16_C(-22784), INT16_C(-16608), INT16_C(  -256),
                            INT16_C( 31904), INT16_C(  8640), INT16_C(  8384), INT16_C( 20128),
                            INT16_C(-24896), INT16_C(  3232), INT16_C( 28288), INT16_C( 29024),
                            INT16_C(-30848), INT16_C(-26976), INT16_C( -3072), INT16_C(  5664)) },
    { simde_mm256_set_epi16(INT16_C( 21401), INT16_C(-26197), INT16_C(-15084), INT16_C(  9940),
                            INT16_C(-15195), INT16_C( 26408), INT16_C( 31953), INT16_C(  9654),
                            INT16_C(-16569), INT16_C( 29048), INT16_C(-29616), INT16_C(  6990),
                            INT16_C(  2847), INT16_C(-28587), INT16_C( 20626), INT16_C(  4687)),
      simde_mm256_set_epi16(INT16_C( -6592), INT16_C( 27328), INT16_C( 17664), INT16_C(-19200),
                            INT16_C( 10560), INT16_C(-13824), INT16_C( 13376), INT16_C( 28032),
                            INT16_C(-11840), INT16_C( 24064), INT16_C(  5120), INT16_C(-11392),
                            INT16_C(-14400), INT16_C(  5440), INT16_C(  9344), INT16_C(-27712)) },
    { simde_mm256_set_epi16(INT16_C( -7756), INT16_C( -3283), INT16_C(-22803), INT16_C(-16163),
                            INT16_C(  5629), INT16_C( 29150), INT16_C( -9667), INT16_C( 12335),
                            INT16_C(-18839), INT16_C(-10112), INT16_C(-18195), INT16_C(-15969),
                            INT16_C(-29495), INT16_C( 29894), INT16_C(-13459), INT16_C( 16744)),
      simde_mm256_set_epi16(INT16_C( -9728), INT16_C(-27008), INT16_C( 30336), INT16_C( 28288),
                            INT16_C(  -384), INT16_C( -4352), INT16_C(  7808), INT16_C(  6016),
                            INT16_C( 13440), INT16_C( 16384), INT16_C( 30336), INT16_C(-12416),
                            INT16_C( 25728), INT16_C( 25344), INT16_C(-18816), INT16_C(-19456)) },
    { simde_mm256_set_epi16(INT16_C(-28557), INT16_C(-10724), INT16_C(  2722), INT16_C(-10967),
                            INT16_C(  5210), INT16_C( 29322), INT16_C( 15248), INT16_C( -8080),
                            INT16_C(-19889), INT16_C( 30125), INT16_C( 14116), INT16_C(-29183),
                            INT16_C( 11578), INT16_C(-15372), INT16_C(-24444), INT16_C( 10332)),
      simde_mm256_set_epi16(INT16_C( 29440), INT16_C(  7168), INT16_C(-24064), INT16_C( 10496),
                            INT16_C( 23040), INT16_C(-30208), INT16_C(-28672), INT16_C( 28672),
                            INT16_C( 20224), INT16_C(-21248), INT16_C(  9216), INT16_C(   256),
                            INT16_C( 14848), INT16_C( -3072), INT16_C(-31744), INT16_C( 23552)) },
    { simde_mm256_set_epi16(INT16_C(-21274), INT16_C(-31982), INT16_C(-20961), INT16_C(  5088),
                            INT16_C(-17462), INT16_C( -9409), INT16_C( 15757), INT16_C(  1966),
                            INT16_C(-22236), INT16_C(-28953), INT16_C( -1919), INT16_C(-19201),
                            INT16_C( 20002), INT16_C( 13277), INT16_C(-29203), INT16_C(-31968)),
      simde_mm256_set_epi16(INT16_C(-13312), INT16_C(  9216), INT16_C( 15872), INT16_C(-16384),
                            INT16_C(-27648), INT16_C( 32256), INT16_C(  6656), INT16_C( 23552),
                            INT16_C( 18432), INT16_C(-12800), INT16_C(   512), INT16_C(  -512),
                            INT16_C( 17408), INT16_C(-17920), INT16_C( -9728), INT16_C( 16384)) },
    { simde_mm256_set_epi16(INT16_C( 18957), INT16_C( -9706), INT16_C( -6614), INT16_C( 10095),
                            INT16_C(  5161), INT16_C(  -605), INT16_C( 13764), INT16_C( 27464),
                            INT16_C( -3974), INT16_C( -5977), INT16_C(-10905), INT16_C(   357),
                            INT16_C(-20180), INT16_C(  8910), INT16_C( -3748), INT16_C(  6077)),
      simde_mm256_set_epi16(INT16_C( 13312), INT16_C( 22528), INT16_C(-22528), INT16_C(-17408),
                            INT16_C(-23552), INT16_C(-29696), INT16_C(  4096), INT16_C(  8192),
                            INT16_C( -6144), INT16_C(-25600), INT16_C(-25600), INT16_C(-27648),
                            INT16_C(-20480), INT16_C( 14336), INT16_C( 28672), INT16_C( -3072)) },
    { simde_mm256_set_epi16(INT16_C(-31972), INT16_C( 18963), INT16_C( 30683), INT16_C(-21818),
                            INT16_C(-14936), INT16_C(-28324), INT16_C( -9468), INT16_C(-30588),
                            INT16_C(-23376), INT16_C( 11957), INT16_C(-26836), INT16_C(  1095),
                            INT16_C(  3892), INT16_C( 16953), INT16_C( 18603), INT16_C(-10451)),
      simde_mm256_set_epi16(INT16_C( -8192), INT16_C(-26624), INT16_C(-10240), INT16_C( 12288),
                            INT16_C( 16384), INT16_C( -8192), INT16_C(  8192), INT16_C(  8192),
                            INT16_C(-32768), INT16_C(-22528), INT16_C( 24576), INT16_C( 14336),
                            INT16_C(-24576), INT16_C(-14336), INT16_C( 22528), INT16_C( 26624)) },
    { simde_mm256_set_epi16(INT16_C( -5389), INT16_C(-19407), INT16_C( 25290), INT16_C( -4640),
                            INT16_C( 29672), INT16_C( 23128), INT16_C(-13360), INT16_C(-25779),
                            INT16_C(-15993), INT16_C( -8711), INT16_C(-27319), INT16_C(  5516),
                            INT16_C(-14272), INT16_C( 31123), INT16_C(-10448), INT16_C( 22014)),
      simde_mm256_set_epi16(INT16_C( 12288), INT16_C(  4096), INT16_C(-24576), INT16_C(     0),
                            INT16_C(-32768), INT16_C(-32768), INT16_C(     0), INT16_C(-12288),
                            INT16_C( 28672), INT16_C(-28672), INT16_C(-28672), INT16_C(-16384),
                            INT16_C(     0), INT16_C( 12288), INT16_C(     0), INT16_C( -8192)) },
    { simde_mm256_set_epi16(INT16_C( -8792), INT16_C( -1044), INT16_C(-11356), INT16_C( -9495),
                            INT16_C(  4809), INT16_C(-13629), INT16_C( 15424), INT16_C(-18049),
                            INT16_C(  4498), INT16_C(-15799), INT16_C(-26777), INT16_C(  7570),
                            INT16_C( 20105), INT16_C( -5032), INT16_C( -5734), INT16_C(-24145)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(-32768), INT16_C(-32768), INT16_C(  8192),
                            INT16_C(  8192), INT16_C( 24576), INT16_C(     0), INT16_C( -8192),
                            INT16_C( 16384), INT16_C(  8192), INT16_C( -8192), INT16_C( 16384),
                            INT16_C(  8192), INT16_C(     0), INT16_C( 16384), INT16_C( -8192)) },
    { simde_mm256_set_epi16(INT16_C(-28948), INT16_C(-14792), INT16_C( 23966), INT16_C( 21707),
                            INT16_C(  7390), INT16_C(  8499), INT16_C( 25220), INT16_C( 26210),
                            INT16_C(  3798), INT16_C( 20760), INT16_C(-20165), INT16_C(-15694),
                            INT16_C(   538), INT16_C(    97), INT16_C( -3558), INT16_C(-31643)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(     0), INT16_C(-32768), INT16_C(-16384),
                            INT16_C(-32768), INT16_C(-16384), INT16_C(     0), INT16_C(-32768),
                            INT16_C(-32768), INT16_C(     0), INT16_C(-16384), INT16_C(-32768),
                            INT16_C(-32768), INT16_C( 16384), INT16_C(-32768), INT16_C( 16384)) },
    { simde_mm256_set_epi16(INT16_C(-17181), INT16_C(  9599), INT16_C(-10139), INT16_C(-21574),
                            INT16_C( -1148), INT16_C(-14339), INT16_C( -9621), INT16_C(  4987),
                            INT16_C(-25046), INT16_C( 11688), INT16_C( -9678), INT16_C( -6619),
                            INT16_C( 24962), INT16_C(-11214), INT16_C( 26930), INT16_C(-12095)),
      simde_mm256_set_epi16(INT16_C(-32768), INT16_C(-32768), INT16_C(-32768), INT16_C(     0),
                            INT16_C(     0), INT16_C(-32768), INT16_C(-32768), INT16_C(-32768),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(-32768),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(-32768)) }
  };

  simde__m256i r;

  r = simde_mm256_slli_epi16(test_vec[0].a, 0);
  simde_assert_m256i_i16(r, ==, test_vec[0].r);

  r = simde_mm256_slli_epi16(test_vec[1].a, 1);
  simde_assert_m256i_i16(r, ==, test_vec[1].r);

  r = simde_mm256_slli_epi16(test_vec[2].a, 2);
  simde_assert_m256i_i16(r, ==, test_vec[2].r);

  r = simde_mm256_slli_epi16(test_vec[3].a, 3);
  simde_assert_m256i_i16(r, ==, test_vec[3].r);

  r = simde_mm256_slli_epi16(test_vec[4].a, 4);
  simde_assert_m256i_i16(r, ==, test_vec[4].r);

  r = simde_mm256_slli_epi16(test_vec[5].a, 5);
  simde_assert_m256i_i16(r, ==, test_vec[5].r);

  r = simde_mm256_slli_epi16(test_vec[6].a, 6);
  simde_assert_m256i_i16(r, ==, test_vec[6].r);

  r = simde_mm256_slli_epi16(test_vec[7].a, 7);
  simde_assert_m256i_i16(r, ==, test_vec[7].r);

  r = simde_mm256_slli_epi16(test_vec[8].a, 8);
  simde_assert_m256i_i16(r, ==, test_vec[8].r);

  r = simde_mm256_slli_epi16(test_vec[9].a, 9);
  simde_assert_m256i_i16(r, ==, test_vec[9].r);

  r = simde_mm256_slli_epi16(test_vec[10].a, 10);
  simde_assert_m256i_i16(r, ==, test_vec[10].r);

  r = simde_mm256_slli_epi16(test_vec[11].a, 11);
  simde_assert_m256i_i16(r, ==, test_vec[11].r);

  r = simde_mm256_slli_epi16(test_vec[12].a, 12);
  simde_assert_m256i_i16(r, ==, test_vec[12].r);

  r = simde_mm256_slli_epi16(test_vec[13].a, 13);
  simde_assert_m256i_i16(r, ==, test_vec[13].r);

  r = simde_mm256_slli_epi16(test_vec[14].a, 14);
  simde_assert_m256i_i16(r, ==, test_vec[14].r);

  r = simde_mm256_slli_epi16(test_vec[15].a, 15);
  simde_assert_m256i_i16(r, ==, test_vec[15].r);

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_slli_epi32(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi32(INT32_C( 1857969468), INT32_C( 1569141389), INT32_C(-1894985594), INT32_C( 1398609693),
                            INT32_C( 1177229575), INT32_C( 1655079421), INT32_C(-1753400065), INT32_C( -607538910)),
      simde_mm256_set_epi32(INT32_C(-1434991502), INT32_C(-1643531728), INT32_C( 1435031148), INT32_C( -241637048),
                            INT32_C(  325610914), INT32_C(  482634268), INT32_C(-1954026803), INT32_C( -489641480)),
      simde_mm256_set_epi32(INT32_C( -674519168), INT32_C(-1327083104), INT32_C( -509996864), INT32_C( 1805837216),
                            INT32_C( -983359264), INT32_C( 1422933920), INT32_C( -274227232), INT32_C( 2033591360)) },
    { simde_mm256_set_epi32(INT32_C(-1508060177), INT32_C( 2047506344), INT32_C( 1926956558), INT32_C( -567187171),
                            INT32_C( -718834191), INT32_C(  316061425), INT32_C(-1354037966), INT32_C(-2043187872)),
      simde_mm256_set_epi32(INT32_C( -787812104), INT32_C(-1305007947), INT32_C( 1142922615), INT32_C( 1342194494),
                            INT32_C(-1552966924), INT32_C(  272965007), INT32_C(-2116417663), INT32_C( 1446174254)),
      simde_mm256_set_epi32(INT32_C(-1013285408), INT32_C( 1095693568), INT32_C( 1533067712), INT32_C( -970120288),
                            INT32_C(-1527857632), INT32_C( 1524031008), INT32_C( -379541952), INT32_C( -957502464)) },
    { simde_mm256_set_epi32(INT32_C( 1315357752), INT32_C(-1727529785), INT32_C(-1290894210), INT32_C(-1585668235),
                            INT32_C( 1227224502), INT32_C( -793752248), INT32_C( -629408802), INT32_C( 1394059551)),
      simde_mm256_set_epi32(INT32_C(  743833146), INT32_C( -347973949), INT32_C(  521095178), INT32_C( -742841452),
                            INT32_C( -734810084), INT32_C(-1542766714), INT32_C(  575957526), INT32_C(-1816399246)),
      simde_mm256_set_epi32(INT32_C( -858224896), INT32_C(  553621728), INT32_C( 1641058240), INT32_C(  798224032),
                            INT32_C(  616478400), INT32_C(  369731840), INT32_C( 1333754816), INT32_C( 1660232672)) },
    { simde_mm256_set_epi32(INT32_C(  150628023), INT32_C(-2069974717), INT32_C( 1177413093), INT32_C(-2053792688),
                            INT32_C(-1561038597), INT32_C( -690144185), INT32_C( -416879322), INT32_C( 1986359122)),
      simde_mm256_set_epi32(INT32_C(  306184069), INT32_C( 2091432312), INT32_C( 1455569082), INT32_C( 1460019701),
                            INT32_C(-1968965681), INT32_C(-1344732712), INT32_C( 1352620988), INT32_C( 1100122997)),
      simde_mm256_set_epi32(INT32_C(  525129440), INT32_C(-1814681504), INT32_C( -977486688), INT32_C(-1296856576),
                            INT32_C( 1586372448), INT32_C( -609777440), INT32_C( -455236416), INT32_C( -861017536)) },
    { simde_mm256_set_epi32(INT32_C(-1165370523), INT32_C(  190390907), INT32_C( -318174800), INT32_C(-1752249068),
                            INT32_C( 1366077326), INT32_C( 1019085647), INT32_C( 1171551091), INT32_C(-1805589438)),
      simde_mm256_set_epi32(INT32_C(-1007170348), INT32_C( 2038045091), INT32_C(  483759032), INT32_C(-1769389731),
                            INT32_C( 1901958985), INT32_C(-1845366512), INT32_C(  234958311), INT32_C( -992749206)),
      simde_mm256_set_epi32(INT32_C( 1362848928), INT32_C( 1797541728), INT32_C(-1591659008), INT32_C( -237395328),
                            INT32_C(  764801472), INT32_C(-1748997664), INT32_C(-1165070752), INT32_C(-1944287168)) },
    { simde_mm256_set_epi32(INT32_C( -719890300), INT32_C(-1894949227), INT32_C( 1354912660), INT32_C(  262146704),
                            INT32_C(-2066437384), INT32_C( -277466785), INT32_C( 1307284092), INT32_C( -145490102)),
      simde_mm256_set_epi32(INT32_C( 1880856976), INT32_C( -113670921), INT32_C(-1146592891), INT32_C( -833902193),
                            INT32_C( -226567429), INT32_C(  -58637801), INT32_C( -547686157), INT32_C(  870297549)),
      simde_mm256_set_epi32(INT32_C(-1561653120), INT32_C( -508833120), INT32_C(  407532160), INT32_C( -201240064),
                            INT32_C(-1701486848), INT32_C( -289002528), INT32_C(-1116582016), INT32_C( -360715968)) },
    { simde_mm256_set_epi32(INT32_C( 1194726573), INT32_C( -714629781), INT32_C(  721069762), INT32_C(-1027424294),
                            INT32_C(-1451303753), INT32_C( -307072244), INT32_C(  760761319), INT32_C(-1826453170)),
      simde_mm256_set_epi32(INT32_C(-2121454006), INT32_C(  354423919), INT32_C( -610410351), INT32_C(-1822148121),
                            INT32_C( 2107148479), INT32_C(-1935868808), INT32_C( -573099828), INT32_C(  986406309)),
      simde_mm256_set_epi32(INT32_C( -423455328), INT32_C(-1393316512), INT32_C( 1599395904), INT32_C( 1482160960),
                            INT32_C(  802920160), INT32_C(-1236377216), INT32_C(-1425441568), INT32_C( 1683040704)) },
    { simde_mm256_set_epi32(INT32_C( -461263801), INT32_C( 1863945688), INT32_C(  508376318), INT32_C(-1101321410),
                            INT32_C( 1682501002), INT32_C(-1564690744), INT32_C(  469304116), INT32_C(  162493937)),
      simde_mm256_set_epi32(INT32_C( 1027297411), INT32_C(  436621801), INT32_C( 2048624604), INT32_C(  613668083),
                            INT32_C( 2064314140), INT32_C( -717287635), INT32_C( 1286678409), INT32_C(-1591587787)),
      simde_mm256_set_epi32(INT32_C(-1875539744), INT32_C( -483280128), INT32_C( -911827008), INT32_C( -882546752),
                            INT32_C(-1994542784), INT32_C( 1469503744), INT32_C( 2132829824), INT32_C(  904838688)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_slli_epi32(test_vec[i].a, 5);
    simde_assert_m256i_i32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_slli_epi64(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi64x(INT64_C(-1180812000753094585), INT64_C(-5675573813228216402),
                             INT64_C(-2208027268370360000), INT64_C( 6465428915389083026)),
      simde_mm256_set_epi64x(INT64_C( 8452611756027991400), INT64_C(-5020149848375082542),
                             INT64_C( 7925308354439905072), INT64_C(  953522845551677435)),
      simde_mm256_set_epi64x(INT64_C( -892495876679923488), INT64_C( 2849078713792591296),
                             INT64_C( 3130103706986686464), INT64_C( 3979540481645589056)) },
    { simde_mm256_set_epi64x(INT64_C(-4047432104007102232), INT64_C(-7778060476316871326),
                             INT64_C( 2270807563927334286), INT64_C(-5320870512275475361)),
      simde_mm256_set_epi64x(INT64_C( 5866182958150697676), INT64_C(-5938517638175025937),
                             INT64_C( 6284264256050873550), INT64_C( 1402097755121835442)),
      simde_mm256_set_epi64x(INT64_C( -390618812260410112), INT64_C(-9090262283915711424),
                             INT64_C(-1121134249163509312), INT64_C(-4247159729429247008)) },
    { simde_mm256_set_epi64x(INT64_C(-5299935544215164629), INT64_C(-5358218550815045801),
                             INT64_C(-2743808865442122704), INT64_C(-5577727586229156383)),
      simde_mm256_set_epi64x(INT64_C(-1628942167927235670), INT64_C( 2616318076895434913),
                             INT64_C(-3093772338434873461), INT64_C( 5967250390824240978)),
      simde_mm256_set_epi64x(INT64_C(-3577240751499303584), INT64_C(-5442296962695501088),
                             INT64_C( 4431836674399831552), INT64_C( 5980157977762511904)) },
    { simde_mm256_set_epi64x(INT64_C( 5567340862163337259), INT64_C(-5967855323816927748),
                             INT64_C(-3043785185238641430), INT64_C( 8117316208405658103)),
      simde_mm256_set_epi64x(INT64_C( 8644099717862406948), INT64_C(-2019559086403734381),
                             INT64_C(-4658546452517300382), INT64_C(-8872814693937714953)),
      simde_mm256_set_epi64x(INT64_C(-6312533147868723872), INT64_C(-6503929625046171776),
                             INT64_C(-5167405559088767680), INT64_C( 1499701637047336672)) },
    { simde_mm256_set_epi64x(INT64_C(-8259641032964555923), INT64_C( 6678157623055419482),
                             INT64_C( -532130775756370858), INT64_C(-6271412084163076656)),
      simde_mm256_set_epi64x(INT64_C( 6145157523311970224), INT64_C(-5190146230173537442),
                             INT64_C(-7773875053091172024), INT64_C(-4385818839583220370)),
      simde_mm256_set_epi64x(INT64_C(-6054096022932066912), INT64_C(-7659884946741195968),
                             INT64_C( 1418559249505684160), INT64_C( 2228998117586614784)) },
    { simde_mm256_set_epi64x(INT64_C(-3893461849415744807), INT64_C(-9064502035867553709),
                             INT64_C( 3098807305629640641), INT64_C( 6650302822439097584)),
      simde_mm256_set_epi64x(INT64_C( 2307018380829868937), INT64_C( 8592643653599303501),
                             INT64_C( 8944692494744620746), INT64_C(-7922755342769649115)),
      simde_mm256_set_epi64x(INT64_C( 4536429334663027488), INT64_C( 5083840031591107168),
                             INT64_C( 6928113411600742432), INT64_C(-8551238566463496704)) },
    { simde_mm256_set_epi64x(INT64_C(-1984148929379503272), INT64_C(-5205661836978001324),
                             INT64_C( 6359749525414039769), INT64_C(-1541764205226378294)),
      simde_mm256_set_epi64x(INT64_C(-1490660722702882908), INT64_C( -633122769786086240),
                             INT64_C(-8686691198507413769), INT64_C(-9123917909533884922)),
      simde_mm256_set_epi64x(INT64_C(-8152533519015449856), INT64_C( -560482119910077824),
                             INT64_C(  597800002444204832), INT64_C( 6003777653884549440)) },
    { simde_mm256_set_epi64x(INT64_C(-5232449947985336963), INT64_C( -518473474085028208),
                             INT64_C( 1841137168562663956), INT64_C( 5952445751598523173)),
      simde_mm256_set_epi64x(INT64_C(-2687140035203018503), INT64_C( -119809082612743153),
                             INT64_C( 6113467954286988131), INT64_C(-1537862337526048352)),
      simde_mm256_set_epi64x(INT64_C(-1417701672144818272), INT64_C( 1855592902988648960),
                             INT64_C( 3576157172876591744), INT64_C( 6010823314057225376)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_slli_epi64(test_vec[i].a,5);
    simde_assert_m256i_i64(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm_sllv_epi32(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m128i a;
    simde__m128i b;
    simde__m128i r;
  } test_vec[8] = {
    { simde_mm_set_epi32(INT32_C( 1355265632), INT32_C( 1126629442), INT32_C(  130687039), INT32_C( -680602946)),
      simde_mm_set_epi32(INT32_C(         29), INT32_C(         12), INT32_C(         25), INT32_C(         28)),
      simde_mm_set_epi32(INT32_C(          0), INT32_C( 1879318528), INT32_C( 2113929216), INT32_C( -536870912)) },
    { simde_mm_set_epi32(INT32_C( 1737379484), INT32_C( 1883980170), INT32_C( -705882711), INT32_C( 1718253197)),
      simde_mm_set_epi32(INT32_C(          1), INT32_C(         30), INT32_C(         30), INT32_C(-2112542540)),
      simde_mm_set_epi32(INT32_C( -820208328), INT32_MIN           , INT32_C( 1073741824), INT32_C(          0)) },
    { simde_mm_set_epi32(INT32_C(  329097328), INT32_C(-1602739192), INT32_C(-1512309543), INT32_C(-1399203732)),
      simde_mm_set_epi32(INT32_C(         24), INT32_C(          5), INT32_C(         13), INT32_C(         29)),
      simde_mm_set_epi32(INT32_C( 1879048192), INT32_C(  251953408), INT32_C( 2140872704), INT32_MIN          ) },
    { simde_mm_set_epi32(INT32_C( 1241289542), INT32_C(  668450526), INT32_C(-1156837735), INT32_C(    6941002)),
      simde_mm_set_epi32(INT32_C( 1273396233), INT32_C( 1711746946), INT32_C(         28), INT32_C(         28)),
      simde_mm_set_epi32(INT32_C(          0), INT32_C(          0), INT32_C(-1879048192), INT32_C(-1610612736)) },
    { simde_mm_set_epi32(INT32_C(-1594911645), INT32_C( -201864987), INT32_C(-1345215776), INT32_C(-1388228747)),
      simde_mm_set_epi32(INT32_C(         25), INT32_C(         21), INT32_C(          2), INT32_C(         30)),
      simde_mm_set_epi32(INT32_C( -973078528), INT32_C(  480247808), INT32_C(-1085895808), INT32_C( 1073741824)) },
    { simde_mm_set_epi32(INT32_C(   -2803715), INT32_C( -534114403), INT32_C( -330536019), INT32_C( 1118335664)),
      simde_mm_set_epi32(INT32_C(         10), INT32_C(          5), INT32_C(         21), INT32_C(         30)),
      simde_mm_set_epi32(INT32_C( 1423963136), INT32_C(   88208288), INT32_C( 1973420032), INT32_C(          0)) },
    { simde_mm_set_epi32(INT32_C( 1957597354), INT32_C( -483301922), INT32_C(-1795584966), INT32_C(  886123627)),
      simde_mm_set_epi32(INT32_C(          7), INT32_C(          6), INT32_C(         22), INT32_C(         29)),
      simde_mm_set_epi32(INT32_C( 1464358144), INT32_C( -866551936), INT32_C(  243269632), INT32_C( 1610612736)) },
    { simde_mm_set_epi32(INT32_C(-1580825747), INT32_C(-2024732896), INT32_C(-1162095669), INT32_C(  732464901)),
      simde_mm_set_epi32(INT32_C(         19), INT32_C(         12), INT32_C(         30), INT32_C( 2014545570)),
      simde_mm_set_epi32(INT32_C(  459800576), INT32_C(  275906560), INT32_C(-1073741824), INT32_C(          0)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m128i r = simde_mm_sllv_epi32(test_vec[i].a, test_vec[i].b);
    simde_assert_m128i_i32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_sllv_epi32(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi32(INT32_C( -907599535), INT32_C( 1816850761), INT32_C(-1813723808), INT32_C( 1682346964),
                            INT32_C(  297464492), INT32_C( 1204833268), INT32_C(-2121860190), INT32_C( 1275339488)),
      simde_mm256_set_epi32(INT32_C(         26), INT32_C(          9), INT32_C(         13), INT32_C( 1136705026),
                            INT32_C(         13), INT32_C(          1), INT32_C(         31), INT32_C(         21)),
      simde_mm256_set_epi32(INT32_C( 1140850688), INT32_C(-1780313600), INT32_C(-1733558272), INT32_C(          0),
                            INT32_C( 1582661632), INT32_C(-1885300760), INT32_C(          0), INT32_C( 1543503872)) },
    { simde_mm256_set_epi32(INT32_C(  829211350), INT32_C( -225754766), INT32_C(     -55839), INT32_C(-1551786022),
                            INT32_C(-1090517055), INT32_C(  692773880), INT32_C(-1952556964), INT32_C( -931315699)),
      simde_mm256_set_epi32(INT32_C(  920320477), INT32_C( 1278238897), INT32_C(          5), INT32_C(         17),
                            INT32_C(         14), INT32_C(         27), INT32_C(         10), INT32_C(          5)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(          0), INT32_C(   -1786848), INT32_C( 1068761088),
                            INT32_C(   32522240), INT32_C(-1073741824), INT32_C( 2036428800), INT32_C(  262668704)) },
    { simde_mm256_set_epi32(INT32_C(-1678489123), INT32_C(  600143956), INT32_C( 1432800149), INT32_C(-1881004909),
                            INT32_C(   -8633494), INT32_C(   61500000), INT32_C( 1965990355), INT32_C(  563956027)),
      simde_mm256_set_epi32(INT32_C(         23), INT32_C(          9), INT32_C(          1), INT32_C(         16),
                            INT32_C(          6), INT32_C(         10), INT32_C(          3), INT32_C(         12)),
      simde_mm256_set_epi32(INT32_C( -293601280), INT32_C(-1963939840), INT32_C(-1429366998), INT32_C(  613613568),
                            INT32_C( -552543616), INT32_C(-1448509440), INT32_C(-1451946344), INT32_C( -728518656)) },
    { simde_mm256_set_epi32(INT32_C(  338504320), INT32_C(  883906167), INT32_C( -890950152), INT32_C( -640473906),
                            INT32_C( -675244408), INT32_C( 1260399807), INT32_C( 1576784170), INT32_C( 1082002360)),
      simde_mm256_set_epi32(INT32_C(         28), INT32_C(         10), INT32_C(         31), INT32_C( -121273429),
                            INT32_C(         14), INT32_C(         14), INT32_C(         26), INT32_C(         17)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(-1118184448), INT32_C(          0), INT32_C(          0),
                            INT32_C(  631373824), INT32_C(  187678720), INT32_C(-1476395008), INT32_C(  393216000)) },
    { simde_mm256_set_epi32(INT32_C( 1222178972), INT32_C(  657678434), INT32_C( 1236396836), INT32_C( -851157565),
                            INT32_C(  991812030), INT32_C(  -17431900), INT32_C( 1566944363), INT32_C(  -95337079)),
      simde_mm256_set_epi32(INT32_C(         31), INT32_C(         30), INT32_C(-1114512709), INT32_C(          1),
                            INT32_C(          6), INT32_C(          9), INT32_C(         15), INT32_C(         25)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_MIN           , INT32_C(          0), INT32_C(-1702315130),
                            INT32_C( -948539520), INT32_C( -335198208), INT32_C( -701136896), INT32_C(  301989888)) },
    { simde_mm256_set_epi32(INT32_C( 1430218987), INT32_C(-1167579987), INT32_C(-1424112663), INT32_C(-2078521852),
                            INT32_C( -642033113), INT32_C( 1296873781), INT32_C( 1828392907), INT32_C( -832748013)),
      simde_mm256_set_epi32(INT32_C( 1237301658), INT32_C(         10), INT32_C(         25), INT32_C(          2),
                            INT32_C( 1381780746), INT32_C(          7), INT32_C(          0), INT32_C(          9)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(-1600998400), INT32_C( -771751936), INT32_C(  275847184),
                            INT32_C(          0), INT32_C(-1503880576), INT32_C( 1828392907), INT32_C(-1165220352)) },
    { simde_mm256_set_epi32(INT32_C(-1957098634), INT32_C( 2020272894), INT32_C(  274355604), INT32_C(-2023351499),
                            INT32_C( 1868935568), INT32_C( -188773630), INT32_C( 1217940242), INT32_C( -149131379)),
      simde_mm256_set_epi32(INT32_C(         31), INT32_C( -296627453), INT32_C(         26), INT32_C(         17),
                            INT32_C(          3), INT32_C(         30), INT32_C( 1792285256), INT32_C(         21)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(          0), INT32_C( 1342177280), INT32_C(  912916480),
                            INT32_C( 2066582656), INT32_MIN           , INT32_C(          0), INT32_C( -241172480)) },
    { simde_mm256_set_epi32(INT32_C( 1147857332), INT32_C( 1591168671), INT32_C(  670003425), INT32_C(-2025325767),
                            INT32_C( 1644550271), INT32_C( -644639924), INT32_C( -405472702), INT32_C(-1412280243)),
      simde_mm256_set_epi32(INT32_C(         17), INT32_C( -931471145), INT32_C(  903571660), INT32_C(          7),
                            INT32_C(          2), INT32_C(         26), INT32_C(         19), INT32_C(         29)),
      simde_mm256_set_epi32(INT32_C( -748158976), INT32_C(          0), INT32_C(          0), INT32_C(-1543660416),
                            INT32_C(-2011733508), INT32_C(  805306368), INT32_C( -770703360), INT32_C(-1610612736)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_sllv_epi32(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm_sllv_epi64(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m128i a;
    simde__m128i b;
    simde__m128i r;
  } test_vec[8] = {
    { simde_mm_set_epi64x(INT64_C(7972759472039988968), INT64_C(-4018394183250543798)),
      simde_mm_set_epi64x(INT64_C(                  0), INT64_C(                 14)),
      simde_mm_set_epi64x(INT64_C(7972759472039988968), INT64_C(-940699307519868928)) },
    { simde_mm_set_epi64x(INT64_C( 758988409686043336), INT64_C(-1495726894487680579)),
      simde_mm_set_epi64x(INT64_C(                  3), INT64_C(                 44)),
      simde_mm_set_epi64x(INT64_C(6071907277488346688), INT64_C( 332087695960440832)) },
    { simde_mm_set_epi64x(INT64_C(-2629933388658093644), INT64_C(-289252332092708880)),
      simde_mm_set_epi64x(INT64_C(                 10), INT64_C(-3585819117600524220)),
      simde_mm_set_epi64x(INT64_C( 172844775706644480), INT64_C(                  0)) },
    { simde_mm_set_epi64x(INT64_C(4426668050653871600), INT64_C(1900489733297038847)),
      simde_mm_set_epi64x(INT64_C(                 12), INT64_C(                  1)),
      simde_mm_set_epi64x(INT64_C(-1517088978231164928), INT64_C(3800979466594077694)) },
    { simde_mm_set_epi64x(INT64_C(-6094836834726644397), INT64_C(-5043635791122646072)),
      simde_mm_set_epi64x(INT64_C(                 24), INT64_C(                 28)),
      simde_mm_set_epi64x(INT64_C(3516791194124288000), INT64_C(-8765408141610319872)) },
    { simde_mm_set_epi64x(INT64_C(-5021615519821282876), INT64_C(7147251859786373177)),
      simde_mm_set_epi64x(INT64_C(                 19), INT64_C(                 38)),
      simde_mm_set_epi64x(INT64_C(1896775987578798080), INT64_C(-5456658230472081408)) },
    { simde_mm_set_epi64x(INT64_C(-5191993007641480010), INT64_C(-4233139431813518757)),
      simde_mm_set_epi64x(INT64_C(                 31), INT64_C(                  1)),
      simde_mm_set_epi64x(INT64_C(1701193368639373312), INT64_C(-8466278863627037514)) },
    { simde_mm_set_epi64x(INT64_C( 546100030060415122), INT64_C(-8171136833646680622)),
      simde_mm_set_epi64x(INT64_C(5414271824693851176), INT64_C(-2835576914550646887)),
      simde_mm_set_epi64x(INT64_C(                  0), INT64_C(                  0)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m128i r = simde_mm_sllv_epi64(test_vec[i].a, test_vec[i].b);
    simde_assert_m128i_i64(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_sllv_epi64(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
   { simde_mm256_set_epi64x(INT64_C(  -91881763986021568), INT64_C( 8531978069693998286),
                             INT64_C( 7972759472039988968), INT64_C(-4018394183250543798)),
      simde_mm256_set_epi64x(INT64_C(                   3), INT64_C(                  44),
                             INT64_C(                   8), INT64_C(                  61)),
      simde_mm256_set_epi64x(INT64_C( -735054111888172544), INT64_C(-8481157707640864768),
                             INT64_C(-6562167339523053568), INT64_C( 4611686018427387904)) },
    { simde_mm256_set_epi64x(INT64_C(  766349923467523082), INT64_C(-3585819117600524220),
                             INT64_C(-2629933388658093644), INT64_C( -289252332092708880)),
      simde_mm256_set_epi64x(INT64_C(                  12), INT64_C(                   1),
                             INT64_C(                  48), INT64_C( 1900489733297038847)),
      simde_mm256_set_epi64x(INT64_C( 3022793992350769152), INT64_C(-7171638235201048440),
                             INT64_C( 5887330612880080896), INT64_C(                   0)) },
    { simde_mm256_set_epi64x(INT64_C( 3582646241058391448), INT64_C( 5243361490463539228),
                             INT64_C(-6094836834726644397), INT64_C(-5043635791122646072)),
      simde_mm256_set_epi64x(INT64_C(                  19), INT64_C(                  38),
                             INT64_C(                   4), INT64_C(                  57)),
      simde_mm256_set_epi64x(INT64_C(-1282873453157810176), INT64_C(  193662480558325760),
                             INT64_C(-5283668987078552272), INT64_C(-8070450532247928832)) },
    { simde_mm256_set_epi64x(INT64_C(-3133121661023385633), INT64_C(   86614665799225345),
                             INT64_C(-5191993007641480010), INT64_C(-4233139431813518757)),
      simde_mm256_set_epi64x(INT64_C( 5414271824693851176), INT64_C(-2835576914550646887),
                             INT64_C(                  18), INT64_C(                  18)),
      simde_mm256_set_epi64x(INT64_C(                   0), INT64_C(                   0),
                             INT64_C( 6302995343711141888), INT64_C( 8680028822435528704)) },
    { simde_mm256_set_epi64x(INT64_C(-8035395454128872003), INT64_C( 7344605666715935137),
                             INT64_C(-1365449772765093192), INT64_C(  717291431309989344)),
      simde_mm256_set_epi64x(INT64_C(                  55), INT64_C(                  11),
                             INT64_C(                  42), INT64_C(                  47)),
      simde_mm256_set_epi64x(INT64_C(-2413929400270585856), INT64_C( 7655985360950593536),
                             INT64_C(-3779962646619488256), INT64_C(-1517713074423857152)) },
    { simde_mm256_set_epi64x(INT64_C(-1439191960592432599), INT64_C( 1735866133656124044),
                             INT64_C(-3359799274550972684), INT64_C(-8271287930321791084)),
      simde_mm256_set_epi64x(INT64_C(                  41), INT64_C(                  53),
                             INT64_C(                  16), INT64_C(                  10)),
      simde_mm256_set_epi64x(INT64_C(-7744975299216932864), INT64_C( 5872693914091126784),
                             INT64_C(-7467993175337730048), INT64_C(-2743310816829878272)) },
    { simde_mm256_set_epi64x(INT64_C( 6427900085291119138), INT64_C( 5786748734574497216),
                             INT64_C( 5043272528786026223), INT64_C( 3596044833449463138)),
      simde_mm256_set_epi64x(INT64_C(                  63), INT64_C(                  27),
                             INT64_C(                  24), INT64_C(                  24)),
      simde_mm256_set_epi64x(INT64_C(                   0), INT64_C(-8915429143793893376),
                             INT64_C(-6557303802913882112), INT64_C(-5103103612012199936)) },
    { simde_mm256_set_epi64x(INT64_C( 4490003779390629369), INT64_C( 8881591764214441368),
                             INT64_C(-2584940796434610056), INT64_C( 1109135920291955027)),
      simde_mm256_set_epi64x(INT64_C(                  14), INT64_C(                  34),
                             INT64_C(                   5), INT64_C(-3135683893925165551)),
      simde_mm256_set_epi64x(INT64_C(-1393444417620262912), INT64_C(-8636331371352031232),
                             INT64_C(-8931129191069315328), INT64_C(                   0)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_sllv_epi64(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i64(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_srai_epi16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i r1;
    simde__m256i r3;
    simde__m256i r5;
    simde__m256i r11;
    simde__m256i r13;
    simde__m256i r15;
    simde__m256i r16;
    simde__m256i r24;
  } test_vec[8] = {
    { simde_mm256_set_epi16(INT16_C( 15196), INT16_C(-26519), INT16_C(  2034), INT16_C(  3767),
                            INT16_C( 20039), INT16_C( 24955), INT16_C(  -829), INT16_C( 24412),
                            INT16_C(  5644), INT16_C(-14035), INT16_C( 32481), INT16_C(-26971),
                            INT16_C(-13019), INT16_C(-23412), INT16_C(-14153), INT16_C(-22092)),
      simde_mm256_set_epi16(INT16_C(  7598), INT16_C(-13260), INT16_C(  1017), INT16_C(  1883),
                            INT16_C( 10019), INT16_C( 12477), INT16_C(  -415), INT16_C( 12206),
                            INT16_C(  2822), INT16_C( -7018), INT16_C( 16240), INT16_C(-13486),
                            INT16_C( -6510), INT16_C(-11706), INT16_C( -7077), INT16_C(-11046)),
      simde_mm256_set_epi16(INT16_C(  1899), INT16_C( -3315), INT16_C(   254), INT16_C(   470),
                            INT16_C(  2504), INT16_C(  3119), INT16_C(  -104), INT16_C(  3051),
                            INT16_C(   705), INT16_C( -1755), INT16_C(  4060), INT16_C( -3372),
                            INT16_C( -1628), INT16_C( -2927), INT16_C( -1770), INT16_C( -2762)),
      simde_mm256_set_epi16(INT16_C(   474), INT16_C(  -829), INT16_C(    63), INT16_C(   117),
                            INT16_C(   626), INT16_C(   779), INT16_C(   -26), INT16_C(   762),
                            INT16_C(   176), INT16_C(  -439), INT16_C(  1015), INT16_C(  -843),
                            INT16_C(  -407), INT16_C(  -732), INT16_C(  -443), INT16_C(  -691)),
      simde_mm256_set_epi16(INT16_C(     7), INT16_C(   -13), INT16_C(     0), INT16_C(     1),
                            INT16_C(     9), INT16_C(    12), INT16_C(    -1), INT16_C(    11),
                            INT16_C(     2), INT16_C(    -7), INT16_C(    15), INT16_C(   -14),
                            INT16_C(    -7), INT16_C(   -12), INT16_C(    -7), INT16_C(   -11)),
      simde_mm256_set_epi16(INT16_C(     1), INT16_C(    -4), INT16_C(     0), INT16_C(     0),
                            INT16_C(     2), INT16_C(     3), INT16_C(    -1), INT16_C(     2),
                            INT16_C(     0), INT16_C(    -2), INT16_C(     3), INT16_C(    -4),
                            INT16_C(    -2), INT16_C(    -3), INT16_C(    -2), INT16_C(    -3)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(    -1), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(    -1), INT16_C(     0),
                            INT16_C(     0), INT16_C(    -1), INT16_C(     0), INT16_C(    -1),
                            INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(    -1), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(    -1), INT16_C(     0),
                            INT16_C(     0), INT16_C(    -1), INT16_C(     0), INT16_C(    -1),
                            INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(    -1), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(    -1), INT16_C(     0),
                            INT16_C(     0), INT16_C(    -1), INT16_C(     0), INT16_C(    -1),
                            INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1)) },
    { simde_mm256_set_epi16(INT16_C( 21167), INT16_C( 19648), INT16_C(  2514), INT16_C(  5742),
                            INT16_C( 10728), INT16_C( -8816), INT16_C( 21963), INT16_C( 23917),
                            INT16_C( 14277), INT16_C(-22184), INT16_C(  6487), INT16_C( -1330),
                            INT16_C( 12982), INT16_C(-12306), INT16_C( -2383), INT16_C(  -871)),
      simde_mm256_set_epi16(INT16_C( 10583), INT16_C(  9824), INT16_C(  1257), INT16_C(  2871),
                            INT16_C(  5364), INT16_C( -4408), INT16_C( 10981), INT16_C( 11958),
                            INT16_C(  7138), INT16_C(-11092), INT16_C(  3243), INT16_C(  -665),
                            INT16_C(  6491), INT16_C( -6153), INT16_C( -1192), INT16_C(  -436)),
      simde_mm256_set_epi16(INT16_C(  2645), INT16_C(  2456), INT16_C(   314), INT16_C(   717),
                            INT16_C(  1341), INT16_C( -1102), INT16_C(  2745), INT16_C(  2989),
                            INT16_C(  1784), INT16_C( -2773), INT16_C(   810), INT16_C(  -167),
                            INT16_C(  1622), INT16_C( -1539), INT16_C(  -298), INT16_C(  -109)),
      simde_mm256_set_epi16(INT16_C(   661), INT16_C(   614), INT16_C(    78), INT16_C(   179),
                            INT16_C(   335), INT16_C(  -276), INT16_C(   686), INT16_C(   747),
                            INT16_C(   446), INT16_C(  -694), INT16_C(   202), INT16_C(   -42),
                            INT16_C(   405), INT16_C(  -385), INT16_C(   -75), INT16_C(   -28)),
      simde_mm256_set_epi16(INT16_C(    10), INT16_C(     9), INT16_C(     1), INT16_C(     2),
                            INT16_C(     5), INT16_C(    -5), INT16_C(    10), INT16_C(    11),
                            INT16_C(     6), INT16_C(   -11), INT16_C(     3), INT16_C(    -1),
                            INT16_C(     6), INT16_C(    -7), INT16_C(    -2), INT16_C(    -1)),
      simde_mm256_set_epi16(INT16_C(     2), INT16_C(     2), INT16_C(     0), INT16_C(     0),
                            INT16_C(     1), INT16_C(    -2), INT16_C(     2), INT16_C(     2),
                            INT16_C(     1), INT16_C(    -3), INT16_C(     0), INT16_C(    -1),
                            INT16_C(     1), INT16_C(    -2), INT16_C(    -1), INT16_C(    -1)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(    -1), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(    -1), INT16_C(     0), INT16_C(    -1),
                            INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(    -1), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(    -1), INT16_C(     0), INT16_C(    -1),
                            INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(    -1), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(    -1), INT16_C(     0), INT16_C(    -1),
                            INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1)) },
    { simde_mm256_set_epi16(INT16_C(  2621), INT16_C(-27438), INT16_C(-25117), INT16_C(-30861),
                            INT16_C( 13622), INT16_C( 18856), INT16_C(  6824), INT16_C(-32482),
                            INT16_C(-22803), INT16_C( -6837), INT16_C( -6446), INT16_C(-26335),
                            INT16_C(-21911), INT16_C(-30376), INT16_C( -8706), INT16_C( -3742)),
      simde_mm256_set_epi16(INT16_C(  1310), INT16_C(-13719), INT16_C(-12559), INT16_C(-15431),
                            INT16_C(  6811), INT16_C(  9428), INT16_C(  3412), INT16_C(-16241),
                            INT16_C(-11402), INT16_C( -3419), INT16_C( -3223), INT16_C(-13168),
                            INT16_C(-10956), INT16_C(-15188), INT16_C( -4353), INT16_C( -1871)),
      simde_mm256_set_epi16(INT16_C(   327), INT16_C( -3430), INT16_C( -3140), INT16_C( -3858),
                            INT16_C(  1702), INT16_C(  2357), INT16_C(   853), INT16_C( -4061),
                            INT16_C( -2851), INT16_C(  -855), INT16_C(  -806), INT16_C( -3292),
                            INT16_C( -2739), INT16_C( -3797), INT16_C( -1089), INT16_C(  -468)),
      simde_mm256_set_epi16(INT16_C(    81), INT16_C(  -858), INT16_C(  -785), INT16_C(  -965),
                            INT16_C(   425), INT16_C(   589), INT16_C(   213), INT16_C( -1016),
                            INT16_C(  -713), INT16_C(  -214), INT16_C(  -202), INT16_C(  -823),
                            INT16_C(  -685), INT16_C(  -950), INT16_C(  -273), INT16_C(  -117)),
      simde_mm256_set_epi16(INT16_C(     1), INT16_C(   -14), INT16_C(   -13), INT16_C(   -16),
                            INT16_C(     6), INT16_C(     9), INT16_C(     3), INT16_C(   -16),
                            INT16_C(   -12), INT16_C(    -4), INT16_C(    -4), INT16_C(   -13),
                            INT16_C(   -11), INT16_C(   -15), INT16_C(    -5), INT16_C(    -2)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(    -4), INT16_C(    -4), INT16_C(    -4),
                            INT16_C(     1), INT16_C(     2), INT16_C(     0), INT16_C(    -4),
                            INT16_C(    -3), INT16_C(    -1), INT16_C(    -1), INT16_C(    -4),
                            INT16_C(    -3), INT16_C(    -4), INT16_C(    -2), INT16_C(    -1)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(    -1),
                            INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1),
                            INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(    -1),
                            INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1),
                            INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(    -1),
                            INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1),
                            INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1)) },
    { simde_mm256_set_epi16(INT16_C(-20091), INT16_C( -5864), INT16_C( -1105), INT16_C(  9308),
                            INT16_C( 14226), INT16_C( 20343), INT16_C( -8516), INT16_C( -8308),
                            INT16_C(  4189), INT16_C(-13071), INT16_C( -7355), INT16_C(-23705),
                            INT16_C( 28782), INT16_C( 17354), INT16_C(-20377), INT16_C( 15337)),
      simde_mm256_set_epi16(INT16_C(-10046), INT16_C( -2932), INT16_C(  -553), INT16_C(  4654),
                            INT16_C(  7113), INT16_C( 10171), INT16_C( -4258), INT16_C( -4154),
                            INT16_C(  2094), INT16_C( -6536), INT16_C( -3678), INT16_C(-11853),
                            INT16_C( 14391), INT16_C(  8677), INT16_C(-10189), INT16_C(  7668)),
      simde_mm256_set_epi16(INT16_C( -2512), INT16_C(  -733), INT16_C(  -139), INT16_C(  1163),
                            INT16_C(  1778), INT16_C(  2542), INT16_C( -1065), INT16_C( -1039),
                            INT16_C(   523), INT16_C( -1634), INT16_C(  -920), INT16_C( -2964),
                            INT16_C(  3597), INT16_C(  2169), INT16_C( -2548), INT16_C(  1917)),
      simde_mm256_set_epi16(INT16_C(  -628), INT16_C(  -184), INT16_C(   -35), INT16_C(   290),
                            INT16_C(   444), INT16_C(   635), INT16_C(  -267), INT16_C(  -260),
                            INT16_C(   130), INT16_C(  -409), INT16_C(  -230), INT16_C(  -741),
                            INT16_C(   899), INT16_C(   542), INT16_C(  -637), INT16_C(   479)),
      simde_mm256_set_epi16(INT16_C(   -10), INT16_C(    -3), INT16_C(    -1), INT16_C(     4),
                            INT16_C(     6), INT16_C(     9), INT16_C(    -5), INT16_C(    -5),
                            INT16_C(     2), INT16_C(    -7), INT16_C(    -4), INT16_C(   -12),
                            INT16_C(    14), INT16_C(     8), INT16_C(   -10), INT16_C(     7)),
      simde_mm256_set_epi16(INT16_C(    -3), INT16_C(    -1), INT16_C(    -1), INT16_C(     1),
                            INT16_C(     1), INT16_C(     2), INT16_C(    -2), INT16_C(    -2),
                            INT16_C(     0), INT16_C(    -2), INT16_C(    -1), INT16_C(    -3),
                            INT16_C(     3), INT16_C(     2), INT16_C(    -3), INT16_C(     1)),
      simde_mm256_set_epi16(INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(    -1), INT16_C(    -1),
                            INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1),
                            INT16_C(     0), INT16_C(     0), INT16_C(    -1), INT16_C(     0)),
      simde_mm256_set_epi16(INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(    -1), INT16_C(    -1),
                            INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1),
                            INT16_C(     0), INT16_C(     0), INT16_C(    -1), INT16_C(     0)),
      simde_mm256_set_epi16(INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(    -1), INT16_C(    -1),
                            INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1),
                            INT16_C(     0), INT16_C(     0), INT16_C(    -1), INT16_C(     0)) },
    { simde_mm256_set_epi16(INT16_C(-28903), INT16_C(-30383), INT16_C(-20860), INT16_C( 22246),
                            INT16_C( 20775), INT16_C(-18600), INT16_C(-18675), INT16_C(  2687),
                            INT16_C( 19939), INT16_C(-28692), INT16_C( -6959), INT16_C(-28677),
                            INT16_C(  8943), INT16_C(-16990), INT16_C( 17649), INT16_C(-10824)),
      simde_mm256_set_epi16(INT16_C(-14452), INT16_C(-15192), INT16_C(-10430), INT16_C( 11123),
                            INT16_C( 10387), INT16_C( -9300), INT16_C( -9338), INT16_C(  1343),
                            INT16_C(  9969), INT16_C(-14346), INT16_C( -3480), INT16_C(-14339),
                            INT16_C(  4471), INT16_C( -8495), INT16_C(  8824), INT16_C( -5412)),
      simde_mm256_set_epi16(INT16_C( -3613), INT16_C( -3798), INT16_C( -2608), INT16_C(  2780),
                            INT16_C(  2596), INT16_C( -2325), INT16_C( -2335), INT16_C(   335),
                            INT16_C(  2492), INT16_C( -3587), INT16_C(  -870), INT16_C( -3585),
                            INT16_C(  1117), INT16_C( -2124), INT16_C(  2206), INT16_C( -1353)),
      simde_mm256_set_epi16(INT16_C(  -904), INT16_C(  -950), INT16_C(  -652), INT16_C(   695),
                            INT16_C(   649), INT16_C(  -582), INT16_C(  -584), INT16_C(    83),
                            INT16_C(   623), INT16_C(  -897), INT16_C(  -218), INT16_C(  -897),
                            INT16_C(   279), INT16_C(  -531), INT16_C(   551), INT16_C(  -339)),
      simde_mm256_set_epi16(INT16_C(   -15), INT16_C(   -15), INT16_C(   -11), INT16_C(    10),
                            INT16_C(    10), INT16_C(   -10), INT16_C(   -10), INT16_C(     1),
                            INT16_C(     9), INT16_C(   -15), INT16_C(    -4), INT16_C(   -15),
                            INT16_C(     4), INT16_C(    -9), INT16_C(     8), INT16_C(    -6)),
      simde_mm256_set_epi16(INT16_C(    -4), INT16_C(    -4), INT16_C(    -3), INT16_C(     2),
                            INT16_C(     2), INT16_C(    -3), INT16_C(    -3), INT16_C(     0),
                            INT16_C(     2), INT16_C(    -4), INT16_C(    -1), INT16_C(    -4),
                            INT16_C(     1), INT16_C(    -3), INT16_C(     2), INT16_C(    -2)),
      simde_mm256_set_epi16(INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(     0),
                            INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(     0),
                            INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1),
                            INT16_C(     0), INT16_C(    -1), INT16_C(     0), INT16_C(    -1)),
      simde_mm256_set_epi16(INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(     0),
                            INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(     0),
                            INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1),
                            INT16_C(     0), INT16_C(    -1), INT16_C(     0), INT16_C(    -1)),
      simde_mm256_set_epi16(INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(     0),
                            INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(     0),
                            INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1),
                            INT16_C(     0), INT16_C(    -1), INT16_C(     0), INT16_C(    -1)) },
    { simde_mm256_set_epi16(INT16_C( 30610), INT16_C( 28790), INT16_C(   937), INT16_C(  9694),
                            INT16_C(-17401), INT16_C(-32454), INT16_C(-25761), INT16_C(  3568),
                            INT16_C( 18158), INT16_C(-22052), INT16_C( 13442), INT16_C(  1933),
                            INT16_C( 24532), INT16_C(-29992), INT16_C( -2718), INT16_C(   141)),
      simde_mm256_set_epi16(INT16_C( 15305), INT16_C( 14395), INT16_C(   468), INT16_C(  4847),
                            INT16_C( -8701), INT16_C(-16227), INT16_C(-12881), INT16_C(  1784),
                            INT16_C(  9079), INT16_C(-11026), INT16_C(  6721), INT16_C(   966),
                            INT16_C( 12266), INT16_C(-14996), INT16_C( -1359), INT16_C(    70)),
      simde_mm256_set_epi16(INT16_C(  3826), INT16_C(  3598), INT16_C(   117), INT16_C(  1211),
                            INT16_C( -2176), INT16_C( -4057), INT16_C( -3221), INT16_C(   446),
                            INT16_C(  2269), INT16_C( -2757), INT16_C(  1680), INT16_C(   241),
                            INT16_C(  3066), INT16_C( -3749), INT16_C(  -340), INT16_C(    17)),
      simde_mm256_set_epi16(INT16_C(   956), INT16_C(   899), INT16_C(    29), INT16_C(   302),
                            INT16_C(  -544), INT16_C( -1015), INT16_C(  -806), INT16_C(   111),
                            INT16_C(   567), INT16_C(  -690), INT16_C(   420), INT16_C(    60),
                            INT16_C(   766), INT16_C(  -938), INT16_C(   -85), INT16_C(     4)),
      simde_mm256_set_epi16(INT16_C(    14), INT16_C(    14), INT16_C(     0), INT16_C(     4),
                            INT16_C(    -9), INT16_C(   -16), INT16_C(   -13), INT16_C(     1),
                            INT16_C(     8), INT16_C(   -11), INT16_C(     6), INT16_C(     0),
                            INT16_C(    11), INT16_C(   -15), INT16_C(    -2), INT16_C(     0)),
      simde_mm256_set_epi16(INT16_C(     3), INT16_C(     3), INT16_C(     0), INT16_C(     1),
                            INT16_C(    -3), INT16_C(    -4), INT16_C(    -4), INT16_C(     0),
                            INT16_C(     2), INT16_C(    -3), INT16_C(     1), INT16_C(     0),
                            INT16_C(     2), INT16_C(    -4), INT16_C(    -1), INT16_C(     0)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(     0),
                            INT16_C(     0), INT16_C(    -1), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(     0)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(     0),
                            INT16_C(     0), INT16_C(    -1), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(     0)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(     0),
                            INT16_C(     0), INT16_C(    -1), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(     0)) },
    { simde_mm256_set_epi16(INT16_C( 15336), INT16_C( -3979), INT16_C(-24197), INT16_C(-21101),
                            INT16_C(-22510), INT16_C( 14686), INT16_C( 22575), INT16_C(  6813),
                            INT16_C( 16551), INT16_C(-31832), INT16_C( 12767), INT16_C(-32161),
                            INT16_C( 11852), INT16_C( -8546), INT16_C(-23397), INT16_C( 31365)),
      simde_mm256_set_epi16(INT16_C(  7668), INT16_C( -1990), INT16_C(-12099), INT16_C(-10551),
                            INT16_C(-11255), INT16_C(  7343), INT16_C( 11287), INT16_C(  3406),
                            INT16_C(  8275), INT16_C(-15916), INT16_C(  6383), INT16_C(-16081),
                            INT16_C(  5926), INT16_C( -4273), INT16_C(-11699), INT16_C( 15682)),
      simde_mm256_set_epi16(INT16_C(  1917), INT16_C(  -498), INT16_C( -3025), INT16_C( -2638),
                            INT16_C( -2814), INT16_C(  1835), INT16_C(  2821), INT16_C(   851),
                            INT16_C(  2068), INT16_C( -3979), INT16_C(  1595), INT16_C( -4021),
                            INT16_C(  1481), INT16_C( -1069), INT16_C( -2925), INT16_C(  3920)),
      simde_mm256_set_epi16(INT16_C(   479), INT16_C(  -125), INT16_C(  -757), INT16_C(  -660),
                            INT16_C(  -704), INT16_C(   458), INT16_C(   705), INT16_C(   212),
                            INT16_C(   517), INT16_C(  -995), INT16_C(   398), INT16_C( -1006),
                            INT16_C(   370), INT16_C(  -268), INT16_C(  -732), INT16_C(   980)),
      simde_mm256_set_epi16(INT16_C(     7), INT16_C(    -2), INT16_C(   -12), INT16_C(   -11),
                            INT16_C(   -11), INT16_C(     7), INT16_C(    11), INT16_C(     3),
                            INT16_C(     8), INT16_C(   -16), INT16_C(     6), INT16_C(   -16),
                            INT16_C(     5), INT16_C(    -5), INT16_C(   -12), INT16_C(    15)),
      simde_mm256_set_epi16(INT16_C(     1), INT16_C(    -1), INT16_C(    -3), INT16_C(    -3),
                            INT16_C(    -3), INT16_C(     1), INT16_C(     2), INT16_C(     0),
                            INT16_C(     2), INT16_C(    -4), INT16_C(     1), INT16_C(    -4),
                            INT16_C(     1), INT16_C(    -2), INT16_C(    -3), INT16_C(     3)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1),
                            INT16_C(    -1), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(    -1), INT16_C(     0), INT16_C(    -1),
                            INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(     0)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1),
                            INT16_C(    -1), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(    -1), INT16_C(     0), INT16_C(    -1),
                            INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(     0)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1),
                            INT16_C(    -1), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(    -1), INT16_C(     0), INT16_C(    -1),
                            INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(     0)) },
    { simde_mm256_set_epi16(INT16_C( 10638), INT16_C(-17208), INT16_C( -3442), INT16_C( 22577),
                            INT16_C(-18388), INT16_C( 22101), INT16_C(  9949), INT16_C(  9978),
                            INT16_C(-20527), INT16_C( -7864), INT16_C(-12143), INT16_C( -3713),
                            INT16_C( 32473), INT16_C( -9341), INT16_C( -1436), INT16_C( 17837)),
      simde_mm256_set_epi16(INT16_C(  5319), INT16_C( -8604), INT16_C( -1721), INT16_C( 11288),
                            INT16_C( -9194), INT16_C( 11050), INT16_C(  4974), INT16_C(  4989),
                            INT16_C(-10264), INT16_C( -3932), INT16_C( -6072), INT16_C( -1857),
                            INT16_C( 16236), INT16_C( -4671), INT16_C(  -718), INT16_C(  8918)),
      simde_mm256_set_epi16(INT16_C(  1329), INT16_C( -2151), INT16_C(  -431), INT16_C(  2822),
                            INT16_C( -2299), INT16_C(  2762), INT16_C(  1243), INT16_C(  1247),
                            INT16_C( -2566), INT16_C(  -983), INT16_C( -1518), INT16_C(  -465),
                            INT16_C(  4059), INT16_C( -1168), INT16_C(  -180), INT16_C(  2229)),
      simde_mm256_set_epi16(INT16_C(   332), INT16_C(  -538), INT16_C(  -108), INT16_C(   705),
                            INT16_C(  -575), INT16_C(   690), INT16_C(   310), INT16_C(   311),
                            INT16_C(  -642), INT16_C(  -246), INT16_C(  -380), INT16_C(  -117),
                            INT16_C(  1014), INT16_C(  -292), INT16_C(   -45), INT16_C(   557)),
      simde_mm256_set_epi16(INT16_C(     5), INT16_C(    -9), INT16_C(    -2), INT16_C(    11),
                            INT16_C(    -9), INT16_C(    10), INT16_C(     4), INT16_C(     4),
                            INT16_C(   -11), INT16_C(    -4), INT16_C(    -6), INT16_C(    -2),
                            INT16_C(    15), INT16_C(    -5), INT16_C(    -1), INT16_C(     8)),
      simde_mm256_set_epi16(INT16_C(     1), INT16_C(    -3), INT16_C(    -1), INT16_C(     2),
                            INT16_C(    -3), INT16_C(     2), INT16_C(     1), INT16_C(     1),
                            INT16_C(    -3), INT16_C(    -1), INT16_C(    -2), INT16_C(    -1),
                            INT16_C(     3), INT16_C(    -2), INT16_C(    -1), INT16_C(     2)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(     0),
                            INT16_C(    -1), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1),
                            INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(     0)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(     0),
                            INT16_C(    -1), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1),
                            INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(     0)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(     0),
                            INT16_C(    -1), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(    -1), INT16_C(    -1), INT16_C(    -1), INT16_C(    -1),
                            INT16_C(     0), INT16_C(    -1), INT16_C(    -1), INT16_C(     0)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r;
    r = simde_mm256_srai_epi16(test_vec[i].a, 0);
    simde_assert_m256i_i16(r, ==, test_vec[i].a);
    r = simde_mm256_srai_epi16(test_vec[i].a, 1);
    simde_assert_m256i_i16(r, ==, test_vec[i].r1);
    r = simde_mm256_srai_epi16(test_vec[i].a, 3);
    simde_assert_m256i_i16(r, ==, test_vec[i].r3);
    r = simde_mm256_srai_epi16(test_vec[i].a, 5);
    simde_assert_m256i_i16(r, ==, test_vec[i].r5);
    r = simde_mm256_srai_epi16(test_vec[i].a, 11);
    simde_assert_m256i_i16(r, ==, test_vec[i].r11);
    r = simde_mm256_srai_epi16(test_vec[i].a, 13);
    simde_assert_m256i_i16(r, ==, test_vec[i].r13);
    r = simde_mm256_srai_epi16(test_vec[i].a, 15);
    simde_assert_m256i_i16(r, ==, test_vec[i].r15);
    r = simde_mm256_srai_epi16(test_vec[i].a, 16);
    simde_assert_m256i_i16(r, ==, test_vec[i].r16);
    r = simde_mm256_srai_epi16(test_vec[i].a, 24);
    simde_assert_m256i_i16(r, ==, test_vec[i].r24);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_srai_epi32(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i r1;
    simde__m256i r3;
    simde__m256i r5;
    simde__m256i r11;
    simde__m256i r23;
    simde__m256i r31;
    simde__m256i r32;
    simde__m256i r55;
  } test_vec[8] = {
    { simde_mm256_set_epi32(INT32_C(  995924073), INT32_C(  133303991), INT32_C( 1313300859), INT32_C(  -54304932),
                            INT32_C(  369936685), INT32_C( 2128713381), INT32_C( -853171060), INT32_C( -927487564)),
      simde_mm256_set_epi32(INT32_C(  497962036), INT32_C(   66651995), INT32_C(  656650429), INT32_C(  -27152466),
                            INT32_C(  184968342), INT32_C( 1064356690), INT32_C( -426585530), INT32_C( -463743782)),
      simde_mm256_set_epi32(INT32_C(  124490509), INT32_C(   16662998), INT32_C(  164162607), INT32_C(   -6788117),
                            INT32_C(   46242085), INT32_C(  266089172), INT32_C( -106646383), INT32_C( -115935946)),
      simde_mm256_set_epi32(INT32_C(   31122627), INT32_C(    4165749), INT32_C(   41040651), INT32_C(   -1697030),
                            INT32_C(   11560521), INT32_C(   66522293), INT32_C(  -26661596), INT32_C(  -28983987)),
      simde_mm256_set_epi32(INT32_C(     486291), INT32_C(      65089), INT32_C(     641260), INT32_C(     -26517),
                            INT32_C(     180633), INT32_C(    1039410), INT32_C(    -416588), INT32_C(    -452875)),
      simde_mm256_set_epi32(INT32_C(        118), INT32_C(         15), INT32_C(        156), INT32_C(         -7),
                            INT32_C(         44), INT32_C(        253), INT32_C(       -102), INT32_C(       -111)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(          0), INT32_C(          0), INT32_C(         -1),
                            INT32_C(          0), INT32_C(          0), INT32_C(         -1), INT32_C(         -1)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(          0), INT32_C(          0), INT32_C(         -1),
                            INT32_C(          0), INT32_C(          0), INT32_C(         -1), INT32_C(         -1)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(          0), INT32_C(          0), INT32_C(         -1),
                            INT32_C(          0), INT32_C(          0), INT32_C(         -1), INT32_C(         -1)) },
    { simde_mm256_set_epi32(INT32_C( 1387220160), INT32_C(  164763246), INT32_C(  703126928), INT32_C( 1439391085),
                            INT32_C(  935700824), INT32_C(  425196238), INT32_C(  850841582), INT32_C( -156107623)),
      simde_mm256_set_epi32(INT32_C(  693610080), INT32_C(   82381623), INT32_C(  351563464), INT32_C(  719695542),
                            INT32_C(  467850412), INT32_C(  212598119), INT32_C(  425420791), INT32_C(  -78053812)),
      simde_mm256_set_epi32(INT32_C(  173402520), INT32_C(   20595405), INT32_C(   87890866), INT32_C(  179923885),
                            INT32_C(  116962603), INT32_C(   53149529), INT32_C(  106355197), INT32_C(  -19513453)),
      simde_mm256_set_epi32(INT32_C(   43350630), INT32_C(    5148851), INT32_C(   21972716), INT32_C(   44980971),
                            INT32_C(   29240650), INT32_C(   13287382), INT32_C(   26588799), INT32_C(   -4878364)),
      simde_mm256_set_epi32(INT32_C(     677353), INT32_C(      80450), INT32_C(     343323), INT32_C(     702827),
                            INT32_C(     456885), INT32_C(     207615), INT32_C(     415449), INT32_C(     -76225)),
      simde_mm256_set_epi32(INT32_C(        165), INT32_C(         19), INT32_C(         83), INT32_C(        171),
                            INT32_C(        111), INT32_C(         50), INT32_C(        101), INT32_C(        -19)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(          0), INT32_C(          0), INT32_C(          0),
                            INT32_C(          0), INT32_C(          0), INT32_C(          0), INT32_C(         -1)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(          0), INT32_C(          0), INT32_C(          0),
                            INT32_C(          0), INT32_C(          0), INT32_C(          0), INT32_C(         -1)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(          0), INT32_C(          0), INT32_C(          0),
                            INT32_C(          0), INT32_C(          0), INT32_C(          0), INT32_C(         -1)) },
    { simde_mm256_set_epi32(INT32_C(  171807954), INT32_C(-1646033037), INT32_C(  892750248), INT32_C(  447250718),
                            INT32_C(-1494358709), INT32_C( -422405855), INT32_C(-1435924136), INT32_C( -570494622)),
      simde_mm256_set_epi32(INT32_C(   85903977), INT32_C( -823016519), INT32_C(  446375124), INT32_C(  223625359),
                            INT32_C( -747179355), INT32_C( -211202928), INT32_C( -717962068), INT32_C( -285247311)),
      simde_mm256_set_epi32(INT32_C(   21475994), INT32_C( -205754130), INT32_C(  111593781), INT32_C(   55906339),
                            INT32_C( -186794839), INT32_C(  -52800732), INT32_C( -179490517), INT32_C(  -71311828)),
      simde_mm256_set_epi32(INT32_C(    5368998), INT32_C(  -51438533), INT32_C(   27898445), INT32_C(   13976584),
                            INT32_C(  -46698710), INT32_C(  -13200183), INT32_C(  -44872630), INT32_C(  -17827957)),
      simde_mm256_set_epi32(INT32_C(      83890), INT32_C(    -803728), INT32_C(     435913), INT32_C(     218384),
                            INT32_C(    -729668), INT32_C(    -206253), INT32_C(    -701135), INT32_C(    -278562)),
      simde_mm256_set_epi32(INT32_C(         20), INT32_C(       -197), INT32_C(        106), INT32_C(         53),
                            INT32_C(       -179), INT32_C(        -51), INT32_C(       -172), INT32_C(        -69)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(         -1), INT32_C(          0), INT32_C(          0),
                            INT32_C(         -1), INT32_C(         -1), INT32_C(         -1), INT32_C(         -1)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(         -1), INT32_C(          0), INT32_C(          0),
                            INT32_C(         -1), INT32_C(         -1), INT32_C(         -1), INT32_C(         -1)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(         -1), INT32_C(          0), INT32_C(          0),
                            INT32_C(         -1), INT32_C(         -1), INT32_C(         -1), INT32_C(         -1)) },
    { simde_mm256_set_epi32(INT32_C(-1316624104), INT32_C(  -72407972), INT32_C(  932335479), INT32_C( -558047348),
                            INT32_C(  274582769), INT32_C( -481975449), INT32_C( 1886274506), INT32_C(-1335411735)),
      simde_mm256_set_epi32(INT32_C( -658312052), INT32_C(  -36203986), INT32_C(  466167739), INT32_C( -279023674),
                            INT32_C(  137291384), INT32_C( -240987725), INT32_C(  943137253), INT32_C( -667705868)),
      simde_mm256_set_epi32(INT32_C( -164578013), INT32_C(   -9050997), INT32_C(  116541934), INT32_C(  -69755919),
                            INT32_C(   34322846), INT32_C(  -60246932), INT32_C(  235784313), INT32_C( -166926467)),
      simde_mm256_set_epi32(INT32_C(  -41144504), INT32_C(   -2262750), INT32_C(   29135483), INT32_C(  -17438980),
                            INT32_C(    8580711), INT32_C(  -15061733), INT32_C(   58946078), INT32_C(  -41731617)),
      simde_mm256_set_epi32(INT32_C(    -642883), INT32_C(     -35356), INT32_C(     455241), INT32_C(    -272485),
                            INT32_C(     134073), INT32_C(    -235340), INT32_C(     921032), INT32_C(    -652057)),
      simde_mm256_set_epi32(INT32_C(       -157), INT32_C(         -9), INT32_C(        111), INT32_C(        -67),
                            INT32_C(         32), INT32_C(        -58), INT32_C(        224), INT32_C(       -160)),
      simde_mm256_set_epi32(INT32_C(         -1), INT32_C(         -1), INT32_C(          0), INT32_C(         -1),
                            INT32_C(          0), INT32_C(         -1), INT32_C(          0), INT32_C(         -1)),
      simde_mm256_set_epi32(INT32_C(         -1), INT32_C(         -1), INT32_C(          0), INT32_C(         -1),
                            INT32_C(          0), INT32_C(         -1), INT32_C(          0), INT32_C(         -1)),
      simde_mm256_set_epi32(INT32_C(         -1), INT32_C(         -1), INT32_C(          0), INT32_C(         -1),
                            INT32_C(          0), INT32_C(         -1), INT32_C(          0), INT32_C(         -1)) },
    { simde_mm256_set_epi32(INT32_C(-1894151855), INT32_C(-1367058714), INT32_C( 1361557336), INT32_C(-1223882113),
                            INT32_C( 1306759148), INT32_C( -456028165), INT32_C(  586136994), INT32_C( 1156699576)),
      simde_mm256_set_epi32(INT32_C( -947075928), INT32_C( -683529357), INT32_C(  680778668), INT32_C( -611941057),
                            INT32_C(  653379574), INT32_C( -228014083), INT32_C(  293068497), INT32_C(  578349788)),
      simde_mm256_set_epi32(INT32_C( -236768982), INT32_C( -170882340), INT32_C(  170194667), INT32_C( -152985265),
                            INT32_C(  163344893), INT32_C(  -57003521), INT32_C(   73267124), INT32_C(  144587447)),
      simde_mm256_set_epi32(INT32_C(  -59192246), INT32_C(  -42720585), INT32_C(   42548666), INT32_C(  -38246317),
                            INT32_C(   40836223), INT32_C(  -14250881), INT32_C(   18316781), INT32_C(   36146861)),
      simde_mm256_set_epi32(INT32_C(    -924879), INT32_C(    -667510), INT32_C(     664822), INT32_C(    -597599),
                            INT32_C(     638065), INT32_C(    -222671), INT32_C(     286199), INT32_C(     564794)),
      simde_mm256_set_epi32(INT32_C(       -226), INT32_C(       -163), INT32_C(        162), INT32_C(       -146),
                            INT32_C(        155), INT32_C(        -55), INT32_C(         69), INT32_C(        137)),
      simde_mm256_set_epi32(INT32_C(         -1), INT32_C(         -1), INT32_C(          0), INT32_C(         -1),
                            INT32_C(          0), INT32_C(         -1), INT32_C(          0), INT32_C(          0)),
      simde_mm256_set_epi32(INT32_C(         -1), INT32_C(         -1), INT32_C(          0), INT32_C(         -1),
                            INT32_C(          0), INT32_C(         -1), INT32_C(          0), INT32_C(          0)),
      simde_mm256_set_epi32(INT32_C(         -1), INT32_C(         -1), INT32_C(          0), INT32_C(         -1),
                            INT32_C(          0), INT32_C(         -1), INT32_C(          0), INT32_C(          0)) },
    { simde_mm256_set_epi32(INT32_C( 2006085750), INT32_C(   61416926), INT32_C(-1140358854), INT32_C(-1688269328),
                            INT32_C( 1190046172), INT32_C(  880936845), INT32_C( 1607764696), INT32_C( -178126707)),
      simde_mm256_set_epi32(INT32_C( 1003042875), INT32_C(   30708463), INT32_C( -570179427), INT32_C( -844134664),
                            INT32_C(  595023086), INT32_C(  440468422), INT32_C(  803882348), INT32_C(  -89063354)),
      simde_mm256_set_epi32(INT32_C(  250760718), INT32_C(    7677115), INT32_C( -142544857), INT32_C( -211033666),
                            INT32_C(  148755771), INT32_C(  110117105), INT32_C(  200970587), INT32_C(  -22265839)),
      simde_mm256_set_epi32(INT32_C(   62690179), INT32_C(    1919278), INT32_C(  -35636215), INT32_C(  -52758417),
                            INT32_C(   37188942), INT32_C(   27529276), INT32_C(   50242646), INT32_C(   -5566460)),
      simde_mm256_set_epi32(INT32_C(     979534), INT32_C(      29988), INT32_C(    -556816), INT32_C(    -824351),
                            INT32_C(     581077), INT32_C(     430144), INT32_C(     785041), INT32_C(     -86976)),
      simde_mm256_set_epi32(INT32_C(        239), INT32_C(          7), INT32_C(       -136), INT32_C(       -202),
                            INT32_C(        141), INT32_C(        105), INT32_C(        191), INT32_C(        -22)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(          0), INT32_C(         -1), INT32_C(         -1),
                            INT32_C(          0), INT32_C(          0), INT32_C(          0), INT32_C(         -1)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(          0), INT32_C(         -1), INT32_C(         -1),
                            INT32_C(          0), INT32_C(          0), INT32_C(          0), INT32_C(         -1)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(          0), INT32_C(         -1), INT32_C(         -1),
                            INT32_C(          0), INT32_C(          0), INT32_C(          0), INT32_C(         -1)) },
    { simde_mm256_set_epi32(INT32_C( 1005121653), INT32_C(-1585730157), INT32_C(-1475200674), INT32_C( 1479482013),
                            INT32_C( 1084720040), INT32_C(  836731487), INT32_C(  776789662), INT32_C(-1533314427)),
      simde_mm256_set_epi32(INT32_C(  502560826), INT32_C( -792865079), INT32_C( -737600337), INT32_C(  739741006),
                            INT32_C(  542360020), INT32_C(  418365743), INT32_C(  388394831), INT32_C( -766657214)),
      simde_mm256_set_epi32(INT32_C(  125640206), INT32_C( -198216270), INT32_C( -184400085), INT32_C(  184935251),
                            INT32_C(  135590005), INT32_C(  104591435), INT32_C(   97098707), INT32_C( -191664304)),
      simde_mm256_set_epi32(INT32_C(   31410051), INT32_C(  -49554068), INT32_C(  -46100022), INT32_C(   46233812),
                            INT32_C(   33897501), INT32_C(   26147858), INT32_C(   24274676), INT32_C(  -47916076)),
      simde_mm256_set_epi32(INT32_C(     490782), INT32_C(    -774283), INT32_C(    -720313), INT32_C(     722403),
                            INT32_C(     529648), INT32_C(     408560), INT32_C(     379291), INT32_C(    -748689)),
      simde_mm256_set_epi32(INT32_C(        119), INT32_C(       -190), INT32_C(       -176), INT32_C(        176),
                            INT32_C(        129), INT32_C(         99), INT32_C(         92), INT32_C(       -183)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(         -1), INT32_C(         -1), INT32_C(          0),
                            INT32_C(          0), INT32_C(          0), INT32_C(          0), INT32_C(         -1)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(         -1), INT32_C(         -1), INT32_C(          0),
                            INT32_C(          0), INT32_C(          0), INT32_C(          0), INT32_C(         -1)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(         -1), INT32_C(         -1), INT32_C(          0),
                            INT32_C(          0), INT32_C(          0), INT32_C(          0), INT32_C(         -1)) },
    { simde_mm256_set_epi32(INT32_C(  697220296), INT32_C( -225552335), INT32_C(-1205053867), INT32_C(  652027642),
                            INT32_C(-1345199800), INT32_C( -795741825), INT32_C( 2128206723), INT32_C(  -94091859)),
      simde_mm256_set_epi32(INT32_C(  348610148), INT32_C( -112776168), INT32_C( -602526934), INT32_C(  326013821),
                            INT32_C( -672599900), INT32_C( -397870913), INT32_C( 1064103361), INT32_C(  -47045930)),
      simde_mm256_set_epi32(INT32_C(   87152537), INT32_C(  -28194042), INT32_C( -150631734), INT32_C(   81503455),
                            INT32_C( -168149975), INT32_C(  -99467729), INT32_C(  266025840), INT32_C(  -11761483)),
      simde_mm256_set_epi32(INT32_C(   21788134), INT32_C(   -7048511), INT32_C(  -37657934), INT32_C(   20375863),
                            INT32_C(  -42037494), INT32_C(  -24866933), INT32_C(   66506460), INT32_C(   -2940371)),
      simde_mm256_set_epi32(INT32_C(     340439), INT32_C(    -110133), INT32_C(    -588406), INT32_C(     318372),
                            INT32_C(    -656836), INT32_C(    -388546), INT32_C(    1039163), INT32_C(     -45944)),
      simde_mm256_set_epi32(INT32_C(         83), INT32_C(        -27), INT32_C(       -144), INT32_C(         77),
                            INT32_C(       -161), INT32_C(        -95), INT32_C(        253), INT32_C(        -12)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(         -1), INT32_C(         -1), INT32_C(          0),
                            INT32_C(         -1), INT32_C(         -1), INT32_C(          0), INT32_C(         -1)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(         -1), INT32_C(         -1), INT32_C(          0),
                            INT32_C(         -1), INT32_C(         -1), INT32_C(          0), INT32_C(         -1)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(         -1), INT32_C(         -1), INT32_C(          0),
                            INT32_C(         -1), INT32_C(         -1), INT32_C(          0), INT32_C(         -1)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r;
    r = simde_mm256_srai_epi32(test_vec[i].a, 0);
    simde_assert_m256i_i32(r, ==, test_vec[i].a);
    r = simde_mm256_srai_epi32(test_vec[i].a, 1);
    simde_assert_m256i_i32(r, ==, test_vec[i].r1);
    r = simde_mm256_srai_epi32(test_vec[i].a, 3);
    simde_assert_m256i_i32(r, ==, test_vec[i].r3);
    r = simde_mm256_srai_epi32(test_vec[i].a, 5);
    simde_assert_m256i_i32(r, ==, test_vec[i].r5);
    r = simde_mm256_srai_epi32(test_vec[i].a, 11);
    simde_assert_m256i_i32(r, ==, test_vec[i].r11);
    r = simde_mm256_srai_epi32(test_vec[i].a, 23);
    simde_assert_m256i_i32(r, ==, test_vec[i].r23);
    r = simde_mm256_srai_epi32(test_vec[i].a, 31);
    simde_assert_m256i_i32(r, ==, test_vec[i].r31);
    r = simde_mm256_srai_epi32(test_vec[i].a, 32);
    simde_assert_m256i_i32(r, ==, test_vec[i].r32);
    r = simde_mm256_srai_epi32(test_vec[i].a, 55);
    simde_assert_m256i_i32(r, ==, test_vec[i].r55);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_srli_epi16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i r1;
    simde__m256i r3;
    simde__m256i r5;
    simde__m256i r11;
    simde__m256i r13;
    simde__m256i r15;
    simde__m256i r16;
    simde__m256i r24;
  } test_vec[8] = {
    { simde_mm256_set_epi16(INT16_C(-13208), INT16_C( 32518), INT16_C(-12083), INT16_C( -4650),
                            INT16_C( 32616), INT16_C(-23415), INT16_C(-12219), INT16_C(-11043),
                            INT16_C( 17138), INT16_C( 18141), INT16_C( 29257), INT16_C(-17957),
                            INT16_C( -2929), INT16_C(-12343), INT16_C( -8291), INT16_C(-11958)),
      simde_mm256_set_epi16(INT16_C( 26164), INT16_C( 16259), INT16_C( 26726), INT16_C( 30443),
                            INT16_C( 16308), INT16_C( 21060), INT16_C( 26658), INT16_C( 27246),
                            INT16_C(  8569), INT16_C(  9070), INT16_C( 14628), INT16_C( 23789),
                            INT16_C( 31303), INT16_C( 26596), INT16_C( 28622), INT16_C( 26789)),
      simde_mm256_set_epi16(INT16_C(  6541), INT16_C(  4064), INT16_C(  6681), INT16_C(  7610),
                            INT16_C(  4077), INT16_C(  5265), INT16_C(  6664), INT16_C(  6811),
                            INT16_C(  2142), INT16_C(  2267), INT16_C(  3657), INT16_C(  5947),
                            INT16_C(  7825), INT16_C(  6649), INT16_C(  7155), INT16_C(  6697)),
      simde_mm256_set_epi16(INT16_C(  1635), INT16_C(  1016), INT16_C(  1670), INT16_C(  1902),
                            INT16_C(  1019), INT16_C(  1316), INT16_C(  1666), INT16_C(  1702),
                            INT16_C(   535), INT16_C(   566), INT16_C(   914), INT16_C(  1486),
                            INT16_C(  1956), INT16_C(  1662), INT16_C(  1788), INT16_C(  1674)),
      simde_mm256_set_epi16(INT16_C(    25), INT16_C(    15), INT16_C(    26), INT16_C(    29),
                            INT16_C(    15), INT16_C(    20), INT16_C(    26), INT16_C(    26),
                            INT16_C(     8), INT16_C(     8), INT16_C(    14), INT16_C(    23),
                            INT16_C(    30), INT16_C(    25), INT16_C(    27), INT16_C(    26)),
      simde_mm256_set_epi16(INT16_C(     6), INT16_C(     3), INT16_C(     6), INT16_C(     7),
                            INT16_C(     3), INT16_C(     5), INT16_C(     6), INT16_C(     6),
                            INT16_C(     2), INT16_C(     2), INT16_C(     3), INT16_C(     5),
                            INT16_C(     7), INT16_C(     6), INT16_C(     6), INT16_C(     6)),
      simde_mm256_set_epi16(INT16_C(     1), INT16_C(     0), INT16_C(     1), INT16_C(     1),
                            INT16_C(     0), INT16_C(     1), INT16_C(     1), INT16_C(     1),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     1),
                            INT16_C(     1), INT16_C(     1), INT16_C(     1), INT16_C(     1)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0)) },
    { simde_mm256_set_epi16(INT16_C(  9810), INT16_C( 24519), INT16_C(-20641), INT16_C( 29186),
                            INT16_C(-23300), INT16_C( -6682), INT16_C(-18375), INT16_C( 30920),
                            INT16_C( 29283), INT16_C( 14293), INT16_C( -6612), INT16_C( 11040),
                            INT16_C(-31748), INT16_C( -6890), INT16_C( 12929), INT16_C(-16870)),
      simde_mm256_set_epi16(INT16_C(  4905), INT16_C( 12259), INT16_C( 22447), INT16_C( 14593),
                            INT16_C( 21118), INT16_C( 29427), INT16_C( 23580), INT16_C( 15460),
                            INT16_C( 14641), INT16_C(  7146), INT16_C( 29462), INT16_C(  5520),
                            INT16_C( 16894), INT16_C( 29323), INT16_C(  6464), INT16_C( 24333)),
      simde_mm256_set_epi16(INT16_C(  1226), INT16_C(  3064), INT16_C(  5611), INT16_C(  3648),
                            INT16_C(  5279), INT16_C(  7356), INT16_C(  5895), INT16_C(  3865),
                            INT16_C(  3660), INT16_C(  1786), INT16_C(  7365), INT16_C(  1380),
                            INT16_C(  4223), INT16_C(  7330), INT16_C(  1616), INT16_C(  6083)),
      simde_mm256_set_epi16(INT16_C(   306), INT16_C(   766), INT16_C(  1402), INT16_C(   912),
                            INT16_C(  1319), INT16_C(  1839), INT16_C(  1473), INT16_C(   966),
                            INT16_C(   915), INT16_C(   446), INT16_C(  1841), INT16_C(   345),
                            INT16_C(  1055), INT16_C(  1832), INT16_C(   404), INT16_C(  1520)),
      simde_mm256_set_epi16(INT16_C(     4), INT16_C(    11), INT16_C(    21), INT16_C(    14),
                            INT16_C(    20), INT16_C(    28), INT16_C(    23), INT16_C(    15),
                            INT16_C(    14), INT16_C(     6), INT16_C(    28), INT16_C(     5),
                            INT16_C(    16), INT16_C(    28), INT16_C(     6), INT16_C(    23)),
      simde_mm256_set_epi16(INT16_C(     1), INT16_C(     2), INT16_C(     5), INT16_C(     3),
                            INT16_C(     5), INT16_C(     7), INT16_C(     5), INT16_C(     3),
                            INT16_C(     3), INT16_C(     1), INT16_C(     7), INT16_C(     1),
                            INT16_C(     4), INT16_C(     7), INT16_C(     1), INT16_C(     5)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(     0), INT16_C(     1), INT16_C(     0),
                            INT16_C(     1), INT16_C(     1), INT16_C(     1), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     1), INT16_C(     0),
                            INT16_C(     1), INT16_C(     1), INT16_C(     0), INT16_C(     1)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0)) },
    { simde_mm256_set_epi16(INT16_C(  4687), INT16_C( -4828), INT16_C(  9674), INT16_C(  8229),
                            INT16_C(-28519), INT16_C( 24429), INT16_C(-25708), INT16_C(-15646),
                            INT16_C( 27606), INT16_C(  -993), INT16_C( 27866), INT16_C(-11890),
                            INT16_C( 25757), INT16_C( -1957), INT16_C( 24727), INT16_C(-30230)),
      simde_mm256_set_epi16(INT16_C(  2343), INT16_C( 30354), INT16_C(  4837), INT16_C(  4114),
                            INT16_C( 18508), INT16_C( 12214), INT16_C( 19914), INT16_C( 24945),
                            INT16_C( 13803), INT16_C( 32271), INT16_C( 13933), INT16_C( 26823),
                            INT16_C( 12878), INT16_C( 31789), INT16_C( 12363), INT16_C( 17653)),
      simde_mm256_set_epi16(INT16_C(   585), INT16_C(  7588), INT16_C(  1209), INT16_C(  1028),
                            INT16_C(  4627), INT16_C(  3053), INT16_C(  4978), INT16_C(  6236),
                            INT16_C(  3450), INT16_C(  8067), INT16_C(  3483), INT16_C(  6705),
                            INT16_C(  3219), INT16_C(  7947), INT16_C(  3090), INT16_C(  4413)),
      simde_mm256_set_epi16(INT16_C(   146), INT16_C(  1897), INT16_C(   302), INT16_C(   257),
                            INT16_C(  1156), INT16_C(   763), INT16_C(  1244), INT16_C(  1559),
                            INT16_C(   862), INT16_C(  2016), INT16_C(   870), INT16_C(  1676),
                            INT16_C(   804), INT16_C(  1986), INT16_C(   772), INT16_C(  1103)),
      simde_mm256_set_epi16(INT16_C(     2), INT16_C(    29), INT16_C(     4), INT16_C(     4),
                            INT16_C(    18), INT16_C(    11), INT16_C(    19), INT16_C(    24),
                            INT16_C(    13), INT16_C(    31), INT16_C(    13), INT16_C(    26),
                            INT16_C(    12), INT16_C(    31), INT16_C(    12), INT16_C(    17)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(     7), INT16_C(     1), INT16_C(     1),
                            INT16_C(     4), INT16_C(     2), INT16_C(     4), INT16_C(     6),
                            INT16_C(     3), INT16_C(     7), INT16_C(     3), INT16_C(     6),
                            INT16_C(     3), INT16_C(     7), INT16_C(     3), INT16_C(     4)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(     1), INT16_C(     0), INT16_C(     0),
                            INT16_C(     1), INT16_C(     0), INT16_C(     1), INT16_C(     1),
                            INT16_C(     0), INT16_C(     1), INT16_C(     0), INT16_C(     1),
                            INT16_C(     0), INT16_C(     1), INT16_C(     0), INT16_C(     1)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0)) },
    { simde_mm256_set_epi16(INT16_C( 16592), INT16_C( -9654), INT16_C( -8076), INT16_C( 10592),
                            INT16_C( 20644), INT16_C( 25911), INT16_C( -1061), INT16_C( 18172),
                            INT16_C( 22556), INT16_C(-19191), INT16_C( 28031), INT16_C(  -883),
                            INT16_C(  5347), INT16_C( -3724), INT16_C(-32544), INT16_C(-24989)),
      simde_mm256_set_epi16(INT16_C(  8296), INT16_C( 27941), INT16_C( 28730), INT16_C(  5296),
                            INT16_C( 10322), INT16_C( 12955), INT16_C( 32237), INT16_C(  9086),
                            INT16_C( 11278), INT16_C( 23172), INT16_C( 14015), INT16_C( 32326),
                            INT16_C(  2673), INT16_C( 30906), INT16_C( 16496), INT16_C( 20273)),
      simde_mm256_set_epi16(INT16_C(  2074), INT16_C(  6985), INT16_C(  7182), INT16_C(  1324),
                            INT16_C(  2580), INT16_C(  3238), INT16_C(  8059), INT16_C(  2271),
                            INT16_C(  2819), INT16_C(  5793), INT16_C(  3503), INT16_C(  8081),
                            INT16_C(   668), INT16_C(  7726), INT16_C(  4124), INT16_C(  5068)),
      simde_mm256_set_epi16(INT16_C(   518), INT16_C(  1746), INT16_C(  1795), INT16_C(   331),
                            INT16_C(   645), INT16_C(   809), INT16_C(  2014), INT16_C(   567),
                            INT16_C(   704), INT16_C(  1448), INT16_C(   875), INT16_C(  2020),
                            INT16_C(   167), INT16_C(  1931), INT16_C(  1031), INT16_C(  1267)),
      simde_mm256_set_epi16(INT16_C(     8), INT16_C(    27), INT16_C(    28), INT16_C(     5),
                            INT16_C(    10), INT16_C(    12), INT16_C(    31), INT16_C(     8),
                            INT16_C(    11), INT16_C(    22), INT16_C(    13), INT16_C(    31),
                            INT16_C(     2), INT16_C(    30), INT16_C(    16), INT16_C(    19)),
      simde_mm256_set_epi16(INT16_C(     2), INT16_C(     6), INT16_C(     7), INT16_C(     1),
                            INT16_C(     2), INT16_C(     3), INT16_C(     7), INT16_C(     2),
                            INT16_C(     2), INT16_C(     5), INT16_C(     3), INT16_C(     7),
                            INT16_C(     0), INT16_C(     7), INT16_C(     4), INT16_C(     4)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(     1), INT16_C(     1), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     1), INT16_C(     0),
                            INT16_C(     0), INT16_C(     1), INT16_C(     0), INT16_C(     1),
                            INT16_C(     0), INT16_C(     1), INT16_C(     1), INT16_C(     1)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0)) },
    { simde_mm256_set_epi16(INT16_C( -4839), INT16_C(  3174), INT16_C(  7509), INT16_C( 28795),
                            INT16_C( -1732), INT16_C(-26609), INT16_C(-11656), INT16_C(  3035),
                            INT16_C(-10865), INT16_C(  2405), INT16_C( 29471), INT16_C( 19828),
                            INT16_C( 29576), INT16_C( 23078), INT16_C( 11200), INT16_C( 26322)),
      simde_mm256_set_epi16(INT16_C( 30348), INT16_C(  1587), INT16_C(  3754), INT16_C( 14397),
                            INT16_C( 31902), INT16_C( 19463), INT16_C( 26940), INT16_C(  1517),
                            INT16_C( 27335), INT16_C(  1202), INT16_C( 14735), INT16_C(  9914),
                            INT16_C( 14788), INT16_C( 11539), INT16_C(  5600), INT16_C( 13161)),
      simde_mm256_set_epi16(INT16_C(  7587), INT16_C(   396), INT16_C(   938), INT16_C(  3599),
                            INT16_C(  7975), INT16_C(  4865), INT16_C(  6735), INT16_C(   379),
                            INT16_C(  6833), INT16_C(   300), INT16_C(  3683), INT16_C(  2478),
                            INT16_C(  3697), INT16_C(  2884), INT16_C(  1400), INT16_C(  3290)),
      simde_mm256_set_epi16(INT16_C(  1896), INT16_C(    99), INT16_C(   234), INT16_C(   899),
                            INT16_C(  1993), INT16_C(  1216), INT16_C(  1683), INT16_C(    94),
                            INT16_C(  1708), INT16_C(    75), INT16_C(   920), INT16_C(   619),
                            INT16_C(   924), INT16_C(   721), INT16_C(   350), INT16_C(   822)),
      simde_mm256_set_epi16(INT16_C(    29), INT16_C(     1), INT16_C(     3), INT16_C(    14),
                            INT16_C(    31), INT16_C(    19), INT16_C(    26), INT16_C(     1),
                            INT16_C(    26), INT16_C(     1), INT16_C(    14), INT16_C(     9),
                            INT16_C(    14), INT16_C(    11), INT16_C(     5), INT16_C(    12)),
      simde_mm256_set_epi16(INT16_C(     7), INT16_C(     0), INT16_C(     0), INT16_C(     3),
                            INT16_C(     7), INT16_C(     4), INT16_C(     6), INT16_C(     0),
                            INT16_C(     6), INT16_C(     0), INT16_C(     3), INT16_C(     2),
                            INT16_C(     3), INT16_C(     2), INT16_C(     1), INT16_C(     3)),
      simde_mm256_set_epi16(INT16_C(     1), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     1), INT16_C(     1), INT16_C(     1), INT16_C(     0),
                            INT16_C(     1), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0)) },
    { simde_mm256_set_epi16(INT16_C(-25851), INT16_C(  6707), INT16_C(-23633), INT16_C( -4351),
                            INT16_C(  -641), INT16_C(-22303), INT16_C(  6727), INT16_C(  9129),
                            INT16_C(  1286), INT16_C(-28152), INT16_C(-22922), INT16_C(  -950),
                            INT16_C( -1798), INT16_C(-15465), INT16_C(   910), INT16_C(-23243)),
      simde_mm256_set_epi16(INT16_C( 19842), INT16_C(  3353), INT16_C( 20951), INT16_C( 30592),
                            INT16_C( 32447), INT16_C( 21616), INT16_C(  3363), INT16_C(  4564),
                            INT16_C(   643), INT16_C( 18692), INT16_C( 21307), INT16_C( 32293),
                            INT16_C( 31869), INT16_C( 25035), INT16_C(   455), INT16_C( 21146)),
      simde_mm256_set_epi16(INT16_C(  4960), INT16_C(   838), INT16_C(  5237), INT16_C(  7648),
                            INT16_C(  8111), INT16_C(  5404), INT16_C(   840), INT16_C(  1141),
                            INT16_C(   160), INT16_C(  4673), INT16_C(  5326), INT16_C(  8073),
                            INT16_C(  7967), INT16_C(  6258), INT16_C(   113), INT16_C(  5286)),
      simde_mm256_set_epi16(INT16_C(  1240), INT16_C(   209), INT16_C(  1309), INT16_C(  1912),
                            INT16_C(  2027), INT16_C(  1351), INT16_C(   210), INT16_C(   285),
                            INT16_C(    40), INT16_C(  1168), INT16_C(  1331), INT16_C(  2018),
                            INT16_C(  1991), INT16_C(  1564), INT16_C(    28), INT16_C(  1321)),
      simde_mm256_set_epi16(INT16_C(    19), INT16_C(     3), INT16_C(    20), INT16_C(    29),
                            INT16_C(    31), INT16_C(    21), INT16_C(     3), INT16_C(     4),
                            INT16_C(     0), INT16_C(    18), INT16_C(    20), INT16_C(    31),
                            INT16_C(    31), INT16_C(    24), INT16_C(     0), INT16_C(    20)),
      simde_mm256_set_epi16(INT16_C(     4), INT16_C(     0), INT16_C(     5), INT16_C(     7),
                            INT16_C(     7), INT16_C(     5), INT16_C(     0), INT16_C(     1),
                            INT16_C(     0), INT16_C(     4), INT16_C(     5), INT16_C(     7),
                            INT16_C(     7), INT16_C(     6), INT16_C(     0), INT16_C(     5)),
      simde_mm256_set_epi16(INT16_C(     1), INT16_C(     0), INT16_C(     1), INT16_C(     1),
                            INT16_C(     1), INT16_C(     1), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     1), INT16_C(     1), INT16_C(     1),
                            INT16_C(     1), INT16_C(     1), INT16_C(     0), INT16_C(     1)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0)) },
    { simde_mm256_set_epi16(INT16_C(  7674), INT16_C( 18879), INT16_C( 27446), INT16_C(-29225),
                            INT16_C( -2725), INT16_C( 23364), INT16_C( 12045), INT16_C(-28927),
                            INT16_C(-14599), INT16_C(-16964), INT16_C(   660), INT16_C( 23234),
                            INT16_C(-21987), INT16_C(-30631), INT16_C( 26152), INT16_C(-28363)),
      simde_mm256_set_epi16(INT16_C(  3837), INT16_C(  9439), INT16_C( 13723), INT16_C( 18155),
                            INT16_C( 31405), INT16_C( 11682), INT16_C(  6022), INT16_C( 18304),
                            INT16_C( 25468), INT16_C( 24286), INT16_C(   330), INT16_C( 11617),
                            INT16_C( 21774), INT16_C( 17452), INT16_C( 13076), INT16_C( 18586)),
      simde_mm256_set_epi16(INT16_C(   959), INT16_C(  2359), INT16_C(  3430), INT16_C(  4538),
                            INT16_C(  7851), INT16_C(  2920), INT16_C(  1505), INT16_C(  4576),
                            INT16_C(  6367), INT16_C(  6071), INT16_C(    82), INT16_C(  2904),
                            INT16_C(  5443), INT16_C(  4363), INT16_C(  3269), INT16_C(  4646)),
      simde_mm256_set_epi16(INT16_C(   239), INT16_C(   589), INT16_C(   857), INT16_C(  1134),
                            INT16_C(  1962), INT16_C(   730), INT16_C(   376), INT16_C(  1144),
                            INT16_C(  1591), INT16_C(  1517), INT16_C(    20), INT16_C(   726),
                            INT16_C(  1360), INT16_C(  1090), INT16_C(   817), INT16_C(  1161)),
      simde_mm256_set_epi16(INT16_C(     3), INT16_C(     9), INT16_C(    13), INT16_C(    17),
                            INT16_C(    30), INT16_C(    11), INT16_C(     5), INT16_C(    17),
                            INT16_C(    24), INT16_C(    23), INT16_C(     0), INT16_C(    11),
                            INT16_C(    21), INT16_C(    17), INT16_C(    12), INT16_C(    18)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(     2), INT16_C(     3), INT16_C(     4),
                            INT16_C(     7), INT16_C(     2), INT16_C(     1), INT16_C(     4),
                            INT16_C(     6), INT16_C(     5), INT16_C(     0), INT16_C(     2),
                            INT16_C(     5), INT16_C(     4), INT16_C(     3), INT16_C(     4)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     1),
                            INT16_C(     1), INT16_C(     0), INT16_C(     0), INT16_C(     1),
                            INT16_C(     1), INT16_C(     1), INT16_C(     0), INT16_C(     0),
                            INT16_C(     1), INT16_C(     1), INT16_C(     0), INT16_C(     1)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0)) },
    { simde_mm256_set_epi16(INT16_C(-13197), INT16_C( 24881), INT16_C(-10578), INT16_C(-21298),
                            INT16_C( 16303), INT16_C( -8332), INT16_C( 25558), INT16_C( 12717),
                            INT16_C( 18247), INT16_C(-30759), INT16_C(  9647), INT16_C( 18112),
                            INT16_C( -4632), INT16_C(  7524), INT16_C(-32339), INT16_C( 28325)),
      simde_mm256_set_epi16(INT16_C( 26169), INT16_C( 12440), INT16_C( 27479), INT16_C( 22119),
                            INT16_C(  8151), INT16_C( 28602), INT16_C( 12779), INT16_C(  6358),
                            INT16_C(  9123), INT16_C( 17388), INT16_C(  4823), INT16_C(  9056),
                            INT16_C( 30452), INT16_C(  3762), INT16_C( 16598), INT16_C( 14162)),
      simde_mm256_set_epi16(INT16_C(  6542), INT16_C(  3110), INT16_C(  6869), INT16_C(  5529),
                            INT16_C(  2037), INT16_C(  7150), INT16_C(  3194), INT16_C(  1589),
                            INT16_C(  2280), INT16_C(  4347), INT16_C(  1205), INT16_C(  2264),
                            INT16_C(  7613), INT16_C(   940), INT16_C(  4149), INT16_C(  3540)),
      simde_mm256_set_epi16(INT16_C(  1635), INT16_C(   777), INT16_C(  1717), INT16_C(  1382),
                            INT16_C(   509), INT16_C(  1787), INT16_C(   798), INT16_C(   397),
                            INT16_C(   570), INT16_C(  1086), INT16_C(   301), INT16_C(   566),
                            INT16_C(  1903), INT16_C(   235), INT16_C(  1037), INT16_C(   885)),
      simde_mm256_set_epi16(INT16_C(    25), INT16_C(    12), INT16_C(    26), INT16_C(    21),
                            INT16_C(     7), INT16_C(    27), INT16_C(    12), INT16_C(     6),
                            INT16_C(     8), INT16_C(    16), INT16_C(     4), INT16_C(     8),
                            INT16_C(    29), INT16_C(     3), INT16_C(    16), INT16_C(    13)),
      simde_mm256_set_epi16(INT16_C(     6), INT16_C(     3), INT16_C(     6), INT16_C(     5),
                            INT16_C(     1), INT16_C(     6), INT16_C(     3), INT16_C(     1),
                            INT16_C(     2), INT16_C(     4), INT16_C(     1), INT16_C(     2),
                            INT16_C(     7), INT16_C(     0), INT16_C(     4), INT16_C(     3)),
      simde_mm256_set_epi16(INT16_C(     1), INT16_C(     0), INT16_C(     1), INT16_C(     1),
                            INT16_C(     0), INT16_C(     1), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     1), INT16_C(     0), INT16_C(     0),
                            INT16_C(     1), INT16_C(     0), INT16_C(     1), INT16_C(     0)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0)),
      simde_mm256_set_epi16(INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0),
                            INT16_C(     0), INT16_C(     0), INT16_C(     0), INT16_C(     0)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r;
    r = simde_mm256_srli_epi16(test_vec[i].a, 0);
    simde_assert_m256i_i16(r, ==, test_vec[i].a);
    r = simde_mm256_srli_epi16(test_vec[i].a, 1);
    simde_assert_m256i_i16(r, ==, test_vec[i].r1);
    r = simde_mm256_srli_epi16(test_vec[i].a, 3);
    simde_assert_m256i_i16(r, ==, test_vec[i].r3);
    r = simde_mm256_srli_epi16(test_vec[i].a, 5);
    simde_assert_m256i_i16(r, ==, test_vec[i].r5);
    r = simde_mm256_srli_epi16(test_vec[i].a, 11);
    simde_assert_m256i_i16(r, ==, test_vec[i].r11);
    r = simde_mm256_srli_epi16(test_vec[i].a, 13);
    simde_assert_m256i_i16(r, ==, test_vec[i].r13);
    r = simde_mm256_srli_epi16(test_vec[i].a, 15);
    simde_assert_m256i_i16(r, ==, test_vec[i].r15);
    r = simde_mm256_srli_epi16(test_vec[i].a, 16);
    simde_assert_m256i_i16(r, ==, test_vec[i].r16);
    r = simde_mm256_srli_epi16(test_vec[i].a, 24);
    simde_assert_m256i_i16(r, ==, test_vec[i].r24);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_srli_epi32(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi32(INT32_C(  732419944), INT32_C(  -77147012), INT32_C(  489295522), INT32_C( -707244875),
                            INT32_C( 1759674836), INT32_C(  934163130), INT32_C( 1804082267), INT32_C(-1601331496)),
      simde_mm256_set_epi32(INT32_C(  849157488), INT32_C( 1818223314), INT32_C( -155475303), INT32_C(-1398665928),
                            INT32_C( 1594244161), INT32_C( -844009252), INT32_C( 1806417213), INT32_C(-2079022073)),
      simde_mm256_set_epi32(INT32_C(    5722030), INT32_C(   32951720), INT32_C(    3822621), INT32_C(   28029081),
                            INT32_C(   13747459), INT32_C(    7298149), INT32_C(   14094392), INT32_C(   21044029)) },
    { simde_mm256_set_epi32(INT32_C(-1876248297), INT32_C(-2075193364), INT32_C(  172214735), INT32_C( 1442116689),
                            INT32_C(-1288626413), INT32_C(  967081158), INT32_C(-1720117739), INT32_C(  578489253)),
      simde_mm256_set_epi32(INT32_C(  428131799), INT32_C( -748788150), INT32_C(-1439171179), INT32_C(-1390423819),
                            INT32_C(-1892283443), INT32_C( 1334337044), INT32_C(-1388554016), INT32_C( -267755914)),
      simde_mm256_set_epi32(INT32_C(   18896242), INT32_C(   17341983), INT32_C(    1345427), INT32_C(   11266536),
                            INT32_C(   23487038), INT32_C(    7555321), INT32_C(   20116012), INT32_C(    4519447)) },
    { simde_mm256_set_epi32(INT32_C( 2139550852), INT32_C( 1705221620), INT32_C( -794518741), INT32_C( 1217473420),
                            INT32_C( -178348948), INT32_C( -348930603), INT32_C( 1243233554), INT32_C(  409162556)),
      simde_mm256_set_epi32(INT32_C(-1403015061), INT32_C( 1726506153), INT32_C(-1594809223), INT32_C( -409985534),
                            INT32_C( 1511772803), INT32_C( 1304778026), INT32_C(  245063900), INT32_C(-1297537554)),
      simde_mm256_set_epi32(INT32_C(   16715241), INT32_C(   13322043), INT32_C(   27347254), INT32_C(    9511511),
                            INT32_C(   32161080), INT32_C(   30828411), INT32_C(    9712762), INT32_C(    3196582)) },
    { simde_mm256_set_epi32(INT32_C( -266647535), INT32_C(-1026471549), INT32_C( 2142406190), INT32_C(  988722559),
                            INT32_C( -185570336), INT32_C(  377523091), INT32_C(   41928420), INT32_C(  778993888)),
      simde_mm256_set_epi32(INT32_C( -589207043), INT32_C( 1553242780), INT32_C(-1285792025), INT32_C( -729017109),
                            INT32_C( 1574494207), INT32_C(  934652742), INT32_C(  140826824), INT32_C(-1967394389)),
      simde_mm256_set_epi32(INT32_C(   31471248), INT32_C(   25535123), INT32_C(   16737548), INT32_C(    7724394),
                            INT32_C(   32104663), INT32_C(    2949399), INT32_C(     327565), INT32_C(    6085889)) },
    { simde_mm256_set_epi32(INT32_C(-1791792894), INT32_C( 1191804972), INT32_C( -126480817), INT32_C( 1125707739),
                            INT32_C( -881879475), INT32_C(  143668756), INT32_C( -526899451), INT32_C( 1691821556)),
      simde_mm256_set_epi32(INT32_C( 1203771433), INT32_C(-1195415594), INT32_C(   39184838), INT32_C( 1288741747),
                            INT32_C(-1347767789), INT32_C( 1099277192), INT32_C( 1193566195), INT32_C( -378044470)),
      simde_mm256_set_epi32(INT32_C(   19556050), INT32_C(    9310976), INT32_C(   32566300), INT32_C(    8794591),
                            INT32_C(   26664748), INT32_C(    1122412), INT32_C(   29438030), INT32_C(   13217355)) },
    { simde_mm256_set_epi32(INT32_C(-2125943644), INT32_C(-1910893035), INT32_C(  262981568), INT32_C( 1406838420),
                            INT32_C( 1188023687), INT32_C( -157711585), INT32_C(-1355034011), INT32_C( 1720639911)),
      simde_mm256_set_epi32(INT32_C(-2060210004), INT32_C( 1988675682), INT32_C(-1866317501), INT32_C(-1240234337),
                            INT32_C(-1832718526), INT32_C(-1229749178), INT32_C(-1445633372), INT32_C(-1964281870)),
      simde_mm256_set_epi32(INT32_C(   16945497), INT32_C(   18625580), INT32_C(    2054543), INT32_C(   10990925),
                            INT32_C(    9281435), INT32_C(   32322310), INT32_C(   22968228), INT32_C(   13442499)) },
    { simde_mm256_set_epi32(INT32_C(-2026359983), INT32_C(  713896046), INT32_C(  968519053), INT32_C( 1906109584),
                            INT32_C(  -45372712), INT32_C( 1799473244), INT32_C( -655893602), INT32_C( 1170033241)),
      simde_mm256_set_epi32(INT32_C( -638177916), INT32_C( 1362453557), INT32_C( -397570420), INT32_C(-1865678794),
                            INT32_C( -397148457), INT32_C( -942451042), INT32_C(  944509801), INT32_C(  -43249903)),
      simde_mm256_set_epi32(INT32_C(   17723494), INT32_C(    5577312), INT32_C(    7566555), INT32_C(   14891481),
                            INT32_C(   33199957), INT32_C(   14058384), INT32_C(   28430263), INT32_C(    9140884)) },
    { simde_mm256_set_epi32(INT32_C(-1081998790), INT32_C(  485579923), INT32_C(-1608658429), INT32_C(-1749625928),
                            INT32_C( -779220060), INT32_C( 1164169772), INT32_C( 1589226288), INT32_C(-1216437245)),
      simde_mm256_set_epi32(INT32_C(  320527694), INT32_C( 1480004810), INT32_C(  343325687), INT32_C(  772720606),
                            INT32_C( 1014221898), INT32_C(-1455936050), INT32_C(-1191095377), INT32_C( 1501993218)),
      simde_mm256_set_epi32(INT32_C(   25101316), INT32_C(    3793593), INT32_C(   20986788), INT32_C(   19885479),
                            INT32_C(   27466775), INT32_C(    9095076), INT32_C(   12415830), INT32_C(   24051016)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_srli_epi32(test_vec[i].a, 7);
    simde_assert_m256i_i32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_srli_epi64(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi64x(HEDLEY_STATIC_CAST(int64_t, UINT64_C(13444540030250453406)), HEDLEY_STATIC_CAST(int64_t, UINT64_C( 3078071440592676417)),
                             HEDLEY_STATIC_CAST(int64_t, UINT64_C(12679412335333608791)), HEDLEY_STATIC_CAST(int64_t, UINT64_C(11535715936901372554))),
      simde_mm256_set_epi64x(HEDLEY_STATIC_CAST(int64_t, UINT64_C(    1641179202911432)), HEDLEY_STATIC_CAST(int64_t, UINT64_C(     375741142650473)),
                             HEDLEY_STATIC_CAST(int64_t, UINT64_C(    1547779826090528)), HEDLEY_STATIC_CAST(int64_t, UINT64_C(    1408168449328780))) },
    { simde_mm256_set_epi64x(HEDLEY_STATIC_CAST(int64_t, UINT64_C(  225928524470693751)), HEDLEY_STATIC_CAST(int64_t, UINT64_C( 2474929979316735680)),
                             HEDLEY_STATIC_CAST(int64_t, UINT64_C( 9996007191945919101)), HEDLEY_STATIC_CAST(int64_t, UINT64_C(17512962486882118479))),
      simde_mm256_set_epi64x(HEDLEY_STATIC_CAST(int64_t, UINT64_C(      27579165584801)), HEDLEY_STATIC_CAST(int64_t, UINT64_C(     302115475990812)),
                             HEDLEY_STATIC_CAST(int64_t, UINT64_C(    1220215721673085)), HEDLEY_STATIC_CAST(int64_t, UINT64_C(    2137812803574477))) },
    { simde_mm256_set_epi64x(HEDLEY_STATIC_CAST(int64_t, UINT64_C(  982097740378530081)), HEDLEY_STATIC_CAST(int64_t, UINT64_C(  970769818047416681)),
                             HEDLEY_STATIC_CAST(int64_t, UINT64_C(17255424662243862193)), HEDLEY_STATIC_CAST(int64_t, UINT64_C(11037271049098666112))),
      simde_mm256_set_epi64x(HEDLEY_STATIC_CAST(int64_t, UINT64_C(     119884978073551)), HEDLEY_STATIC_CAST(int64_t, UINT64_C(     118502175054616)),
                             HEDLEY_STATIC_CAST(int64_t, UINT64_C(    2106375080840315)), HEDLEY_STATIC_CAST(int64_t, UINT64_C(    1347323126110677))) },
    { simde_mm256_set_epi64x(HEDLEY_STATIC_CAST(int64_t, UINT64_C(11593238181509994155)), HEDLEY_STATIC_CAST(int64_t, UINT64_C( 7911460325067993277)),
                             HEDLEY_STATIC_CAST(int64_t, UINT64_C(14357185542824356538)), HEDLEY_STATIC_CAST(int64_t, UINT64_C( 8595783393340762736))),
      simde_mm256_set_epi64x(HEDLEY_STATIC_CAST(int64_t, UINT64_C(    1415190207703856)), HEDLEY_STATIC_CAST(int64_t, UINT64_C(     965754434212401)),
                             HEDLEY_STATIC_CAST(int64_t, UINT64_C(    1752586125833051)), HEDLEY_STATIC_CAST(int64_t, UINT64_C(    1049289965007417))) },
    { simde_mm256_set_epi64x(HEDLEY_STATIC_CAST(int64_t, UINT64_C( 1166612957385363389)), HEDLEY_STATIC_CAST(int64_t, UINT64_C(16938733438792705089)),
                             HEDLEY_STATIC_CAST(int64_t, UINT64_C(15575845187785487375)), HEDLEY_STATIC_CAST(int64_t, UINT64_C(10601739794903951841))),
      simde_mm256_set_epi64x(HEDLEY_STATIC_CAST(int64_t, UINT64_C(     142408808274580)), HEDLEY_STATIC_CAST(int64_t, UINT64_C(    2067716484227625)),
                             HEDLEY_STATIC_CAST(int64_t, UINT64_C(    1901348289524595)), HEDLEY_STATIC_CAST(int64_t, UINT64_C(    1294157689807611))) },
    { simde_mm256_set_epi64x(HEDLEY_STATIC_CAST(int64_t, UINT64_C(15633886144376419396)), HEDLEY_STATIC_CAST(int64_t, UINT64_C( 8542868240583792995)),
                             HEDLEY_STATIC_CAST(int64_t, UINT64_C(15596557227725823268)), HEDLEY_STATIC_CAST(int64_t, UINT64_C( 8048867687018942442))),
      simde_mm256_set_epi64x(HEDLEY_STATIC_CAST(int64_t, UINT64_C(    1908433367233449)), HEDLEY_STATIC_CAST(int64_t, UINT64_C(    1042830595774388)),
                             HEDLEY_STATIC_CAST(int64_t, UINT64_C(    1903876614712624)), HEDLEY_STATIC_CAST(int64_t, UINT64_C(     982527793825554))) },
    { simde_mm256_set_epi64x(HEDLEY_STATIC_CAST(int64_t, UINT64_C(15325764881028507458)), HEDLEY_STATIC_CAST(int64_t, UINT64_C(15687264368536599834)),
                             HEDLEY_STATIC_CAST(int64_t, UINT64_C(15848782944379583666)), HEDLEY_STATIC_CAST(int64_t, UINT64_C( 6713584830763153714))),
      simde_mm256_set_epi64x(HEDLEY_STATIC_CAST(int64_t, UINT64_C(    1870820908328675)), HEDLEY_STATIC_CAST(int64_t, UINT64_C(    1914949263737377)),
                             HEDLEY_STATIC_CAST(int64_t, UINT64_C(    1934665886765085)), HEDLEY_STATIC_CAST(int64_t, UINT64_C(     819529398286517))) },
    { simde_mm256_set_epi64x(HEDLEY_STATIC_CAST(int64_t, UINT64_C( 4987716052637776361)), HEDLEY_STATIC_CAST(int64_t, UINT64_C(12811672244172189341)),
                             HEDLEY_STATIC_CAST(int64_t, UINT64_C( 5840602719775879932)), HEDLEY_STATIC_CAST(int64_t, UINT64_C( 2103118507556192853))),
      simde_mm256_set_epi64x(HEDLEY_STATIC_CAST(int64_t, UINT64_C(     608852057206759)), HEDLEY_STATIC_CAST(int64_t, UINT64_C(    1563924834493675)),
                             HEDLEY_STATIC_CAST(int64_t, UINT64_C(     712964199191391)), HEDLEY_STATIC_CAST(int64_t, UINT64_C(     256728333441918))) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_srli_epi64(test_vec[i].a, 13);
    simde_assert_m256i_u64(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_srli_si256(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi8(INT8_C(  96), INT8_C(  17), INT8_C(  11), INT8_C( 103),
                           INT8_C(  75), INT8_C(  47), INT8_C( -18), INT8_C(   1),
                           INT8_C(  93), INT8_C( -43), INT8_C( -55), INT8_C( 100),
                           INT8_C( -48), INT8_C(  21), INT8_C( -29), INT8_C(  10),
                           INT8_C(  66), INT8_C(-116), INT8_C(  19), INT8_C( -92),
                           INT8_C( -95), INT8_C(  82), INT8_C( -36), INT8_C( -42),
                           INT8_C( 126), INT8_C(  88), INT8_C( -28), INT8_C(  -8),
                           INT8_C( -38), INT8_C(-106), INT8_C(  21), INT8_C(  13)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  96),
                           INT8_C(  17), INT8_C(  11), INT8_C( 103), INT8_C(  75),
                           INT8_C(  47), INT8_C( -18), INT8_C(   1), INT8_C(  93),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  66),
                           INT8_C(-116), INT8_C(  19), INT8_C( -92), INT8_C( -95),
                           INT8_C(  82), INT8_C( -36), INT8_C( -42), INT8_C( 126)) },
    { simde_mm256_set_epi8(INT8_C(-108), INT8_C( -86), INT8_C( -14), INT8_C( -95),
                           INT8_C( 109), INT8_C(  36), INT8_C(  47), INT8_C(-100),
                           INT8_C(  19), INT8_C(  29), INT8_C( -48), INT8_C(-125),
                           INT8_C( -86), INT8_C(  59), INT8_C(-103), INT8_C(  59),
                           INT8_C( 123), INT8_C( -73), INT8_C(-107), INT8_C( -42),
                           INT8_C(  68), INT8_C(  37), INT8_C( 115), INT8_C(  51),
                           INT8_C( -48), INT8_C(  56), INT8_C(  -7), INT8_C( -79),
                           INT8_C( -38), INT8_C(-103), INT8_C(  68), INT8_C(  60)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(-108),
                           INT8_C( -86), INT8_C( -14), INT8_C( -95), INT8_C( 109),
                           INT8_C(  36), INT8_C(  47), INT8_C(-100), INT8_C(  19),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( 123),
                           INT8_C( -73), INT8_C(-107), INT8_C( -42), INT8_C(  68),
                           INT8_C(  37), INT8_C( 115), INT8_C(  51), INT8_C( -48)) },
    { simde_mm256_set_epi8(INT8_C(  76), INT8_C(  16), INT8_C( -72), INT8_C( 118),
                           INT8_C(  21), INT8_C( -73), INT8_C( -17), INT8_C( -69),
                           INT8_C( 119), INT8_C(  79), INT8_C(  76), INT8_C(  29),
                           INT8_C(  50), INT8_C( -64), INT8_C( -33), INT8_C( 123),
                           INT8_C( -96), INT8_C(  33), INT8_C(  83), INT8_C( -25),
                           INT8_C(  49), INT8_C(   0), INT8_C( -75), INT8_C( 118),
                           INT8_C( -51), INT8_C( -18), INT8_C( -17), INT8_C(-114),
                           INT8_C(  65), INT8_C(  26), INT8_C( -78), INT8_C(  60)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  76),
                           INT8_C(  16), INT8_C( -72), INT8_C( 118), INT8_C(  21),
                           INT8_C( -73), INT8_C( -17), INT8_C( -69), INT8_C( 119),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -96),
                           INT8_C(  33), INT8_C(  83), INT8_C( -25), INT8_C(  49),
                           INT8_C(   0), INT8_C( -75), INT8_C( 118), INT8_C( -51)) },
    { simde_mm256_set_epi8(INT8_C( -24), INT8_C( -43), INT8_C( -68), INT8_C(  95),
                           INT8_C( -74), INT8_C(  73), INT8_C( 100), INT8_C( 109),
                           INT8_C(  96), INT8_C( -49), INT8_C( -75), INT8_C( 117),
                           INT8_C(  13), INT8_C( -72), INT8_C( -68), INT8_C(  14),
                           INT8_C( -76), INT8_C(  76), INT8_C(  21), INT8_C( -85),
                           INT8_C( -57), INT8_C(-103), INT8_C(  22), INT8_C( -25),
                           INT8_C( -64), INT8_C(   0), INT8_C(  92), INT8_C( -92),
                           INT8_C(-101), INT8_C( -65), INT8_C( -20), INT8_C(  63)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -24),
                           INT8_C( -43), INT8_C( -68), INT8_C(  95), INT8_C( -74),
                           INT8_C(  73), INT8_C( 100), INT8_C( 109), INT8_C(  96),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -76),
                           INT8_C(  76), INT8_C(  21), INT8_C( -85), INT8_C( -57),
                           INT8_C(-103), INT8_C(  22), INT8_C( -25), INT8_C( -64)) },
    { simde_mm256_set_epi8(INT8_C( -68), INT8_C( -24), INT8_C(  84), INT8_C(-116),
                           INT8_C( -43), INT8_C(  79), INT8_C( -39), INT8_C( -68),
                           INT8_C( 124), INT8_C( -14), INT8_C(  98), INT8_C(-100),
                           INT8_C( 125), INT8_C( 110), INT8_C(  79), INT8_C( -13),
                           INT8_C( -72), INT8_C(-119), INT8_C( -50), INT8_C(  -7),
                           INT8_C( 127), INT8_C( 126), INT8_C( -62), INT8_C(-124),
                           INT8_C( -36), INT8_C( -38), INT8_C(  -1), INT8_C(  11),
                           INT8_C(  -6), INT8_C(  75), INT8_C(   3), INT8_C(  46)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -68),
                           INT8_C( -24), INT8_C(  84), INT8_C(-116), INT8_C( -43),
                           INT8_C(  79), INT8_C( -39), INT8_C( -68), INT8_C( 124),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -72),
                           INT8_C(-119), INT8_C( -50), INT8_C(  -7), INT8_C( 127),
                           INT8_C( 126), INT8_C( -62), INT8_C(-124), INT8_C( -36)) },
    { simde_mm256_set_epi8(INT8_C(-121), INT8_C( -60), INT8_C(  94), INT8_C( 113),
                           INT8_C( -23), INT8_C( 116), INT8_C(  51), INT8_C(  98),
                           INT8_C(  52), INT8_C( -39), INT8_C( -43), INT8_C(  -8),
                           INT8_C(  98), INT8_C(  57), INT8_C( -33), INT8_C( -19),
                           INT8_C(   7), INT8_C( -17), INT8_C(  13), INT8_C( 106),
                           INT8_C(-115), INT8_C(-117), INT8_C(-118), INT8_C( -11),
                           INT8_C(  -1), INT8_C( 104), INT8_C( -53), INT8_C(  93),
                           INT8_C( -53), INT8_C(  34), INT8_C( -17), INT8_C( -60)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(-121),
                           INT8_C( -60), INT8_C(  94), INT8_C( 113), INT8_C( -23),
                           INT8_C( 116), INT8_C(  51), INT8_C(  98), INT8_C(  52),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   7),
                           INT8_C( -17), INT8_C(  13), INT8_C( 106), INT8_C(-115),
                           INT8_C(-117), INT8_C(-118), INT8_C( -11), INT8_C(  -1)) },
    { simde_mm256_set_epi8(INT8_C( -26), INT8_C( -15), INT8_C( -63), INT8_C(  20),
                           INT8_C( -47), INT8_C( -75), INT8_C( -93), INT8_C( -10),
                           INT8_C( -70), INT8_C( -68), INT8_C(  51), INT8_C( -33),
                           INT8_C( -77), INT8_C( -93), INT8_C(-109), INT8_C( -87),
                           INT8_C(-100), INT8_C( -94), INT8_C(  37), INT8_C( -30),
                           INT8_C( -77), INT8_C( -68), INT8_C( -55), INT8_C(-112),
                           INT8_C( -35), INT8_C(  48), INT8_C(  19), INT8_C( 104),
                           INT8_C(  67), INT8_C( 105), INT8_C(-110), INT8_C( 111)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( -26),
                           INT8_C( -15), INT8_C( -63), INT8_C(  20), INT8_C( -47),
                           INT8_C( -75), INT8_C( -93), INT8_C( -10), INT8_C( -70),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(-100),
                           INT8_C( -94), INT8_C(  37), INT8_C( -30), INT8_C( -77),
                           INT8_C( -68), INT8_C( -55), INT8_C(-112), INT8_C( -35)) },
    { simde_mm256_set_epi8(INT8_C(  45), INT8_C( -53), INT8_C(-119), INT8_C(  36),
                           INT8_C( -11), INT8_C( -24), INT8_C( 109), INT8_C( -22),
                           INT8_C( -79), INT8_C( -98), INT8_C( -10), INT8_C(  35),
                           INT8_C(  46), INT8_C(-121), INT8_C(   7), INT8_C(  38),
                           INT8_C( 124), INT8_C( -47), INT8_C(  -7), INT8_C(  41),
                           INT8_C(  33), INT8_C(  95), INT8_C(  12), INT8_C(   3),
                           INT8_C( 105), INT8_C(  16), INT8_C(  33), INT8_C(-106),
                           INT8_C(  94), INT8_C(  28), INT8_C(  14), INT8_C(  63)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(  45),
                           INT8_C( -53), INT8_C(-119), INT8_C(  36), INT8_C( -11),
                           INT8_C( -24), INT8_C( 109), INT8_C( -22), INT8_C( -79),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C(   0),
                           INT8_C(   0), INT8_C(   0), INT8_C(   0), INT8_C( 124),
                           INT8_C( -47), INT8_C(  -7), INT8_C(  41), INT8_C(  33),
                           INT8_C(  95), INT8_C(  12), INT8_C(   3), INT8_C( 105)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_srli_si256(test_vec[i].a, 7);
    simde_assert_m256i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm_srlv_epi32(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m128i a;
    simde__m128i b;
    simde__m128i r;
  } test_vec[8] = {
    { simde_mm_set_epi32(INT32_C(  750889845), INT32_C( 1061237522), INT32_C( -532194576), INT32_C(  369438034)),
      simde_mm_set_epi32(INT32_C(         24), INT32_C(          8), INT32_C(          6), INT32_C(         22)),
      simde_mm_set_epi32(INT32_C(         44), INT32_C(    4145459), INT32_C(   58793323), INT32_C(         88)) },
    { simde_mm_set_epi32(INT32_C(  258457925), INT32_C(  -26515586), INT32_C(  413932222), INT32_C( 1067196057)),
      simde_mm_set_epi32(INT32_C(         31), INT32_C(         28), INT32_C(          8), INT32_C(-1408300382)),
      simde_mm_set_epi32(INT32_C(          0), INT32_C(         15), INT32_C(    1616922), INT32_C(          0)) },
    { simde_mm_set_epi32(INT32_C(-1382618640), INT32_C(-1421089532), INT32_C(  108769767), INT32_C( -467052333)),
      simde_mm_set_epi32(INT32_C(         21), INT32_C(         14), INT32_C(         16), INT32_C(         14)),
      simde_mm_set_epi32(INT32_C(       1388), INT32_C(     175407), INT32_C(       1659), INT32_C(     233637)) },
    { simde_mm_set_epi32(INT32_C( -987735049), INT32_C( 1751785542), INT32_C( -871968813), INT32_C( -682701112)),
      simde_mm_set_epi32(INT32_C( 1275084561), INT32_C(  344565288), INT32_C(         29), INT32_C(         13)),
      simde_mm_set_epi32(INT32_C(          0), INT32_C(          0), INT32_C(          6), INT32_C(     440950)) },
    { simde_mm_set_epi32(INT32_C( -172652498), INT32_C(-1982996024), INT32_C( -540050425), INT32_C( -840529876)),
      simde_mm_set_epi32(INT32_C(         23), INT32_C(         23), INT32_C(         26), INT32_C(         22)),
      simde_mm_set_epi32(INT32_C(        491), INT32_C(        275), INT32_C(         55), INT32_C(        823)) },
    { simde_mm_set_epi32(INT32_C( 1748060455), INT32_C( 1899512955), INT32_C(  350293706), INT32_C(-1638949235)),
      simde_mm_set_epi32(INT32_C(          0), INT32_C(         10), INT32_C(         17), INT32_C(          6)),
      simde_mm_set_epi32(INT32_C( 1748060455), INT32_C(    1854993), INT32_C(       2672), INT32_C(   41500282)) },
    { simde_mm_set_epi32(INT32_C(-1740858648), INT32_C( 1128670113), INT32_C(-1204328910), INT32_C( -772579618)),
      simde_mm_set_epi32(INT32_C(          9), INT32_C(         28), INT32_C(         11), INT32_C(         14)),
      simde_mm_set_epi32(INT32_C(    4988493), INT32_C(          4), INT32_C(    1509100), INT32_C(     214989)) },
    { simde_mm_set_epi32(INT32_C( -969095340), INT32_C( 1833136862), INT32_C(-2029269927), INT32_C(  238413160)),
      simde_mm_set_epi32(INT32_C(          3), INT32_C(         20), INT32_C(         27), INT32_C(-1565782040)),
      simde_mm_set_epi32(INT32_C(  415733994), INT32_C(       1748), INT32_C(         16), INT32_C(          0)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m128i r = simde_mm_srlv_epi32(test_vec[i].a, test_vec[i].b);
    simde_assert_m128i_i32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_srlv_epi32(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi32(INT32_C(  861771480), INT32_C( 1241239464), INT32_C(  563960678), INT32_C(-1557457802),
                            INT32_C(  750889845), INT32_C( 1061237522), INT32_C( -532194576), INT32_C(  369438034)),
      simde_mm256_set_epi32(INT32_C(         31), INT32_C(         28), INT32_C(          8), INT32_C(-1408300382),
                            INT32_C(          5), INT32_C(         30), INT32_C(         30), INT32_C(         25)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(          4), INT32_C(    2202971), INT32_C(          0),
                            INT32_C(   23465307), INT32_C(          0), INT32_C(          3), INT32_C(         11)) },
    { simde_mm256_set_epi32(INT32_C( 1385973461), INT32_C( 1951417326), INT32_C( 1227312976), INT32_C( 1815104686),
                            INT32_C(-1382618640), INT32_C(-1421089532), INT32_C(  108769767), INT32_C( -467052333)),
      simde_mm256_set_epi32(INT32_C( 1275084561), INT32_C(  344565288), INT32_C(         29), INT32_C(         13),
                            INT32_C(         23), INT32_C(          6), INT32_C(         19), INT32_C(          8)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(          0), INT32_C(          2), INT32_C(     221570),
                            INT32_C(        347), INT32_C(   44904340), INT32_C(        207), INT32_C(   14952792)) },
    { simde_mm256_set_epi32(INT32_C(  585901719), INT32_C(  528891191), INT32_C( 1862281050), INT32_C( 2077782134),
                            INT32_C( -172652498), INT32_C(-1982996024), INT32_C( -540050425), INT32_C( -840529876)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(         10), INT32_C(         17), INT32_C(          6),
                            INT32_C(          7), INT32_C(         27), INT32_C(         10), INT32_C(         13)),
      simde_mm256_set_epi32(INT32_C(  585901719), INT32_C(     516495), INT32_C(      14208), INT32_C(   32465345),
                            INT32_C(   32205584), INT32_C(         17), INT32_C(    3666911), INT32_C(     421684)) },
    { simde_mm256_set_epi32(INT32_C( -594595895), INT32_C( 1620324892), INT32_C(  211976587), INT32_C(  477414606),
                            INT32_C(-1740858648), INT32_C( 1128670113), INT32_C(-1204328910), INT32_C( -772579618)),
      simde_mm256_set_epi32(INT32_C(          3), INT32_C(         20), INT32_C(         27), INT32_C(-1565782040),
                            INT32_C(         20), INT32_C(         30), INT32_C(         25), INT32_C(          8)),
      simde_mm256_set_epi32(INT32_C(  462546425), INT32_C(       1545), INT32_C(          1), INT32_C(          0),
                            INT32_C(       2435), INT32_C(          1), INT32_C(         92), INT32_C(   13759326)) },
    { simde_mm256_set_epi32(INT32_C( -889280255), INT32_C(  271958618), INT32_C( -251228133), INT32_C(  720482352),
                            INT32_C(-1904765782), INT32_C(  203744379), INT32_C( 1575427578), INT32_C( -282602589)),
      simde_mm256_set_epi32(INT32_C(         23), INT32_C(         13), INT32_C( 1563325862), INT32_C(         29),
                            INT32_C(         19), INT32_C(          7), INT32_C(         24), INT32_C(          3)),
      simde_mm256_set_epi32(INT32_C(        405), INT32_C(      33198), INT32_C(          0), INT32_C(          1),
                            INT32_C(       4558), INT32_C(    1591752), INT32_C(         93), INT32_C(  501545588)) },
    { simde_mm256_set_epi32(INT32_C( 1315029482), INT32_C(-1940519792), INT32_C(   49328210), INT32_C( -718320499),
                            INT32_C(-2013049672), INT32_C( -426567571), INT32_C( 1959340047), INT32_C(  359056326)),
      simde_mm256_set_epi32(INT32_C( -523938288), INT32_C(         12), INT32_C(          7), INT32_C(         25),
                            INT32_C(-1642052233), INT32_C(         14), INT32_C(         21), INT32_C(         28)),
      simde_mm256_set_epi32(INT32_C(          0), INT32_C(     574816), INT32_C(     385376), INT32_C(        106),
                            INT32_C(          0), INT32_C(     236108), INT32_C(        934), INT32_C(          1)) },
    { simde_mm256_set_epi32(INT32_C(-1635822813), INT32_C(  796954372), INT32_C(-1179699383), INT32_C(-1410308028),
                            INT32_C(-1961762130), INT32_C(  185876307), INT32_C(-1502255170), INT32_C( -357150625)),
      simde_mm256_set_epi32(INT32_C(          2), INT32_C(-2068185893), INT32_C(         15), INT32_C(         10),
                            INT32_C(         21), INT32_C(         20), INT32_C( -337949468), INT32_C(         29)),
      simde_mm256_set_epi32(INT32_C(  664786120), INT32_C(          0), INT32_C(      95070), INT32_C(    2817050),
                            INT32_C(       1112), INT32_C(        177), INT32_C(          0), INT32_C(          7)) },
    { simde_mm256_set_epi32(INT32_C( 1698380028), INT32_C(  -28278292), INT32_C( 1781848426), INT32_C( -350034661),
                            INT32_C(-1536163099), INT32_C( -584250792), INT32_C(-1013422776), INT32_C(  880343098)),
      simde_mm256_set_epi32(INT32_C(         23), INT32_C(  170594558), INT32_C( -142350595), INT32_C(         17),
                            INT32_C(         24), INT32_C(          3), INT32_C(         16), INT32_C(         14)),
      simde_mm256_set_epi32(INT32_C(        202), INT32_C(          0), INT32_C(          0), INT32_C(      30097),
                            INT32_C(        164), INT32_C(  463839563), INT32_C(      50072), INT32_C(      53731)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_srlv_epi32(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm_srlv_epi64(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m128i a;
    simde__m128i b;
    simde__m128i r;
  } test_vec[8] = {
    { simde_mm_set_epi64x(INT64_C(3225047328234746642), INT64_C(-2285758298659148462)),
      simde_mm_set_epi64x(INT64_C(                 40), INT64_C(                 54)),
      simde_mm_set_epi64x(INT64_C(            2933163), INT64_C(                897)) },
    { simde_mm_set_epi64x(INT64_C(1110068339535472510), INT64_C(1777825357317807769)),
      simde_mm_set_epi64x(INT64_C(                 28), INT64_C(                 34)),
      simde_mm_set_epi64x(INT64_C(         4135326815), INT64_C(          103483055)) },
    { simde_mm_set_epi64x(INT64_C(-5938301838766119676), INT64_C( 467162595886454995)),
      simde_mm_set_epi64x(INT64_C(                 46), INT64_C(5271269095691537582)),
      simde_mm_set_epi64x(INT64_C(             177755), INT64_C(                  0)) },
    { simde_mm_set_epi64x(INT64_C(-4242289730816171962), INT64_C(-3745077531354673464)),
      simde_mm_set_epi64x(INT64_C(                 40), INT64_C(                 45)),
      simde_mm_set_epi64x(INT64_C(           12918875), INT64_C(             417846)) },
    { simde_mm_set_epi64x(INT64_C(-741536830170734136), INT64_C(-2319498910111463380)),
      simde_mm_set_epi64x(INT64_C(                 55), INT64_C(                 54)),
      simde_mm_set_epi64x(INT64_C(                491), INT64_C(                895)) },
    { simde_mm_set_epi64x(INT64_C(7507862487555392635), INT64_C(1504500013920657037)),
      simde_mm_set_epi64x(INT64_C(                 10), INT64_C(                 38)),
      simde_mm_set_epi64x(INT64_C(   7331896960503313), INT64_C(            5473339)) },
    { simde_mm_set_epi64x(INT64_C(-7476930958990105695), INT64_C(-5172553278554939682)),
      simde_mm_set_epi64x(INT64_C(                 28), INT64_C(                 14)),
      simde_mm_set_epi64x(INT64_C(        40865738372), INT64_C(    810192309274573)) },
    { simde_mm_set_epi64x(INT64_C(-4162232790172863778), INT64_C(-8715647970982894232)),
      simde_mm_set_epi64x(INT64_C(-7347100370153245868), INT64_C(2854270594309689320)),
      simde_mm_set_epi64x(INT64_C(                  0), INT64_C(                  0)) },
  };

for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m128i r = simde_mm_srlv_epi64(test_vec[i].a, test_vec[i].b);
    simde_assert_m128i_i64(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_srlv_epi64(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi64x(INT64_C( 3701280324466757544), INT64_C( 2422192670977496182),
                             INT64_C( 3225047328234746642), INT64_C(-2285758298659148462)),
      simde_mm256_set_epi64x(INT64_C(                  28), INT64_C(                  34),
                             INT64_C(                  62), INT64_C(                  25)),
      simde_mm256_set_epi64x(INT64_C(         13788343684), INT64_C(           140990169),
                             INT64_C(                   0), INT64_C(        481634908171)) },
    { simde_mm256_set_epi64x(INT64_C( 5952710690070348782), INT64_C( 5271269095691537582),
                             INT64_C(-5938301838766119676), INT64_C(  467162595886454995)),
      simde_mm256_set_epi64x(INT64_C(                  40), INT64_C(                  45),
                             INT64_C(                   6), INT64_C(-3745077531354673464)),
      simde_mm256_set_epi64x(INT64_C(             5413958), INT64_C(              149818),
                             INT64_C(  195444409920991124), INT64_C(                   0)) },
    { simde_mm256_set_epi64x(INT64_C( 2516428722304073015), INT64_C( 7998436207788322934),
                             INT64_C( -741536830170734136), INT64_C(-2319498910111463380)),
      simde_mm256_set_epi64x(INT64_C(                  10), INT64_C(                  38),
                             INT64_C(                  59), INT64_C(                  13)),
      simde_mm256_set_epi64x(INT64_C(    2457449924125071), INT64_C(            29098141),
                             INT64_C(                  30), INT64_C(    1968657856884532)) },
    { simde_mm256_set_epi64x(INT64_C(-2553769921740525028), INT64_C(  910432509160113358),
                             INT64_C(-7476930958990105695), INT64_C(-5172553278554939682)),
      simde_mm256_set_epi64x(INT64_C(-7347100370153245868), INT64_C( 2854270594309689320),
                             INT64_C(                  30), INT64_C(                  40)),
      simde_mm256_set_epi64x(INT64_C(                   0), INT64_C(                   0),
                             INT64_C(         10216434593), INT64_C(            12072806)) },
    { simde_mm256_set_epi64x(INT64_C(-3819429611931581862), INT64_C(-1079016614349656016),
                             INT64_C(-8180906740026121093), INT64_C( 6766409928738853795)),
      simde_mm256_set_epi64x(INT64_C(                  13), INT64_C(                  61),
                             INT64_C(                  39), INT64_C(                   3)),
      simde_mm256_set_epi64x(INT64_C(    1785560847385006), INT64_C(                   7),
                             INT64_C(            18673449), INT64_C(  845801241092356724)) },
    { simde_mm256_set_epi64x(INT64_C( 5648008620820268176), INT64_C(  211863052296866957),
                             INT64_C(-8645982502595127187), INT64_C( 8415301423967159238)),
      simde_mm256_set_epi64x(INT64_C(                  12), INT64_C(                  25),
                             INT64_C(                  14), INT64_C(                  28)),
      simde_mm256_set_epi64x(INT64_C(    1378908354692448), INT64_C(          6314010986),
                             INT64_C(     598191013861964), INT64_C(         31349440753)) },
    { simde_mm256_set_epi64x(INT64_C(-7025805483088769276), INT64_C(-5066770266211719100),
                             INT64_C(-8425704190695424173), INT64_C(-6452136821459103649)),
      simde_mm256_set_epi64x(INT64_C(                  27), INT64_C(                  42),
                             INT64_C(                  52), INT64_C(                  29)),
      simde_mm256_set_epi64x(INT64_C(         85092623461), INT64_C(             3042253),
                             INT64_C(                2225), INT64_C(         22341697015)) },
    { simde_mm256_set_epi64x(INT64_C( 7294486680706253292), INT64_C( 7652980720044008731),
                             INT64_C(-6597770267816293800), INT64_C(-4352617679061190598)),
      simde_mm256_set_epi64x(INT64_C(                  62), INT64_C(                  17),
                             INT64_C(                  35), INT64_C(-3878551521611571282)),
      simde_mm256_set_epi64x(INT64_C(                   1), INT64_C(      58387609253265),
                             INT64_C(           344850524), INT64_C(                   0)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_srlv_epi64(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i64(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_sub_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
   { simde_mm256_set_epi8(INT8_C( -37), INT8_C(  -5), INT8_C( -23), INT8_C(  84),
                           INT8_C(-108), INT8_C( -92), INT8_C(  86), INT8_C( -77),
                           INT8_C(  77), INT8_C( -93), INT8_C( -37), INT8_C( 101),
                           INT8_C(  79), INT8_C( -45), INT8_C(  56), INT8_C( -51),
                           INT8_C( 103), INT8_C(-116), INT8_C( -58), INT8_C(  -2),
                           INT8_C(  39), INT8_C(-101), INT8_C(-113), INT8_C(  21),
                           INT8_C( -77), INT8_C(  26), INT8_C( -37), INT8_C( 126),
                           INT8_C( 102), INT8_C(  27), INT8_C( -92), INT8_C( -33)),
      simde_mm256_set_epi8(INT8_C(-122), INT8_C( -91), INT8_C(  24), INT8_C(-103),
                           INT8_C(  34), INT8_C(   5), INT8_C( 109), INT8_C(-120),
                           INT8_C(  -7), INT8_C(  86), INT8_C(   3), INT8_C(  90),
                           INT8_C(  98), INT8_C(-108), INT8_C(-128), INT8_C(  33),
                           INT8_C( -84), INT8_C( -73), INT8_C( -39), INT8_C(  33),
                           INT8_C( 103), INT8_C( -21), INT8_C(-117), INT8_C( -60),
                           INT8_C( -48), INT8_C( -88), INT8_C(  95), INT8_C( 100),
                           INT8_C( -66), INT8_C(  52), INT8_C( -40), INT8_C(  90)),
      simde_mm256_set_epi8(INT8_C(  85), INT8_C(  86), INT8_C( -47), INT8_C( -69),
                           INT8_C( 114), INT8_C( -97), INT8_C( -23), INT8_C(  43),
                           INT8_C(  84), INT8_C(  77), INT8_C( -40), INT8_C(  11),
                           INT8_C( -19), INT8_C(  63), INT8_C( -72), INT8_C( -84),
                           INT8_C( -69), INT8_C( -43), INT8_C( -19), INT8_C( -35),
                           INT8_C( -64), INT8_C( -80), INT8_C(   4), INT8_C(  81),
                           INT8_C( -29), INT8_C( 114), INT8_C( 124), INT8_C(  26),
                           INT8_C( -88), INT8_C( -25), INT8_C( -52), INT8_C(-123)) },
    { simde_mm256_set_epi8(INT8_C( -74), INT8_C( -43), INT8_C( -65), INT8_C(  71),
                           INT8_C(-122), INT8_C(-128), INT8_C(   4), INT8_C(  54),
                           INT8_C(  12), INT8_C(  60), INT8_C(  80), INT8_C( -43),
                           INT8_C( -85), INT8_C(  94), INT8_C( -70), INT8_C(  67),
                           INT8_C(  82), INT8_C(  40), INT8_C( -92), INT8_C( -55),
                           INT8_C( 114), INT8_C(  12), INT8_C( -43), INT8_C( -93),
                           INT8_C( -89), INT8_C( -90), INT8_C(  46), INT8_C( -34),
                           INT8_C( -53), INT8_C(   0), INT8_C(  91), INT8_C( -43)),
      simde_mm256_set_epi8(INT8_C(  34), INT8_C( -42), INT8_C(  32), INT8_C( -31),
                           INT8_C( 117), INT8_C( -44), INT8_C( 116), INT8_C( -46),
                           INT8_C( 114), INT8_C(  78), INT8_C(  -3), INT8_C( 123),
                           INT8_C( 103), INT8_C(   4), INT8_C( -99), INT8_C(-112),
                           INT8_C(  67), INT8_C(-113), INT8_C(  -1), INT8_C(-117),
                           INT8_C( -58), INT8_C( -63), INT8_C(-110), INT8_C(  65),
                           INT8_C(  53), INT8_C(-113), INT8_C(-123), INT8_C( -24),
                           INT8_C( -84), INT8_C( -96), INT8_C( 116), INT8_C(  23)),
      simde_mm256_set_epi8(INT8_C(-108), INT8_C(  -1), INT8_C( -97), INT8_C( 102),
                           INT8_C(  17), INT8_C( -84), INT8_C(-112), INT8_C( 100),
                           INT8_C(-102), INT8_C( -18), INT8_C(  83), INT8_C(  90),
                           INT8_C(  68), INT8_C(  90), INT8_C(  29), INT8_C( -77),
                           INT8_C(  15), INT8_C(-103), INT8_C( -91), INT8_C(  62),
                           INT8_C( -84), INT8_C(  75), INT8_C(  67), INT8_C(  98),
                           INT8_C( 114), INT8_C(  23), INT8_C( -87), INT8_C( -10),
                           INT8_C(  31), INT8_C(  96), INT8_C( -25), INT8_C( -66)) },
    { simde_mm256_set_epi8(INT8_C( -56), INT8_C( -54), INT8_C( -84), INT8_C( -79),
                           INT8_C(  25), INT8_C( -22), INT8_C( -93), INT8_C( -71),
                           INT8_C(-106), INT8_C(-125), INT8_C( -67), INT8_C(  53),
                           INT8_C( 101), INT8_C(-105), INT8_C( -28), INT8_C(  37),
                           INT8_C( -61), INT8_C( -39), INT8_C(-117), INT8_C(-116),
                           INT8_C( -16), INT8_C(-126), INT8_C(  25), INT8_C( 103),
                           INT8_C( -81), INT8_C(  88), INT8_C(   1), INT8_C(  20),
                           INT8_C(  36), INT8_C(  16), INT8_C( -44), INT8_C( 107)),
      simde_mm256_set_epi8(INT8_C(  73), INT8_C(-125), INT8_C(  72), INT8_C(  17),
                           INT8_C( -36), INT8_C(  20), INT8_C( -81), INT8_C(  10),
                           INT8_C( 119), INT8_C(  41), INT8_C( -90), INT8_C( -54),
                           INT8_C(-116), INT8_C(  15), INT8_C( -64), INT8_C(  60),
                           INT8_C( -43), INT8_C(   5), INT8_C(  93), INT8_C(  54),
                           INT8_C( -46), INT8_C(-106), INT8_C(-117), INT8_C( 127),
                           INT8_C(  81), INT8_C( -75), INT8_C(-105), INT8_C(  31),
                           INT8_C(  51), INT8_C(-105), INT8_C( -23), INT8_C(  95)),
      simde_mm256_set_epi8(INT8_C( 127), INT8_C(  71), INT8_C( 100), INT8_C( -96),
                           INT8_C(  61), INT8_C( -42), INT8_C( -12), INT8_C( -81),
                           INT8_C(  31), INT8_C(  90), INT8_C(  23), INT8_C( 107),
                           INT8_C( -39), INT8_C(-120), INT8_C(  36), INT8_C( -23),
                           INT8_C( -18), INT8_C( -44), INT8_C(  46), INT8_C(  86),
                           INT8_C(  30), INT8_C( -20), INT8_C(-114), INT8_C( -24),
                           INT8_C(  94), INT8_C( -93), INT8_C( 106), INT8_C( -11),
                           INT8_C( -15), INT8_C( 121), INT8_C( -21), INT8_C(  12)) },
    { simde_mm256_set_epi8(INT8_C( 114), INT8_C(  34), INT8_C(  26), INT8_C( -19),
                           INT8_C( -79), INT8_C( -66), INT8_C( -16), INT8_C(  14),
                           INT8_C(-119), INT8_C(  36), INT8_C(  48), INT8_C(-124),
                           INT8_C(  -3), INT8_C(  65), INT8_C(  48), INT8_C(-117),
                           INT8_C( -76), INT8_C( -16), INT8_C(  83), INT8_C(   8),
                           INT8_C(  76), INT8_C( -37), INT8_C( -88), INT8_C( -95),
                           INT8_C( -96), INT8_C(  84), INT8_C(  -4), INT8_C(  56),
                           INT8_C(  13), INT8_C( -84), INT8_C( 107), INT8_C( -97)),
      simde_mm256_set_epi8(INT8_C(-116), INT8_C( -40), INT8_C( 117), INT8_C(  -7),
                           INT8_C( -80), INT8_C(  53), INT8_C( -24), INT8_C(-123),
                           INT8_C(-119), INT8_C( -47), INT8_C( -64), INT8_C( -25),
                           INT8_C( 117), INT8_C(  45), INT8_C(  40), INT8_C( -91),
                           INT8_C(  19), INT8_C( 123), INT8_C(  36), INT8_C(  -6),
                           INT8_C(  29), INT8_C(  -9), INT8_C( 117), INT8_C( -17),
                           INT8_C( -12), INT8_C(  82), INT8_C( 121), INT8_C(   9),
                           INT8_C( -40), INT8_C(-118), INT8_C( -50), INT8_C( -94)),
      simde_mm256_set_epi8(INT8_C( -26), INT8_C(  74), INT8_C( -91), INT8_C( -12),
                           INT8_C(   1), INT8_C(-119), INT8_C(   8), INT8_C(-119),
                           INT8_C(   0), INT8_C(  83), INT8_C( 112), INT8_C( -99),
                           INT8_C(-120), INT8_C(  20), INT8_C(   8), INT8_C( -26),
                           INT8_C( -95), INT8_C( 117), INT8_C(  47), INT8_C(  14),
                           INT8_C(  47), INT8_C( -28), INT8_C(  51), INT8_C( -78),
                           INT8_C( -84), INT8_C(   2), INT8_C(-125), INT8_C(  47),
                           INT8_C(  53), INT8_C(  34), INT8_C( -99), INT8_C(  -3)) },
    { simde_mm256_set_epi8(INT8_C(  95), INT8_C( -54), INT8_C(  -5), INT8_C( -28),
                           INT8_C( -63), INT8_C(  54), INT8_C(-113), INT8_C( 127),
                           INT8_C( -25), INT8_C( -12), INT8_C(-108), INT8_C(-123),
                           INT8_C( -64), INT8_C(  68), INT8_C(  89), INT8_C(  72),
                           INT8_C( -46), INT8_C( -63), INT8_C(  56), INT8_C( 125),
                           INT8_C(  44), INT8_C(   8), INT8_C(  49), INT8_C( 105),
                           INT8_C(  43), INT8_C(  41), INT8_C( -46), INT8_C(-117),
                           INT8_C(  22), INT8_C(  27), INT8_C( -55), INT8_C( 106)),
      simde_mm256_set_epi8(INT8_C(  15), INT8_C( -64), INT8_C(   3), INT8_C( -17),
                           INT8_C( 127), INT8_C(-101), INT8_C(  76), INT8_C(  31),
                           INT8_C(  79), INT8_C( 115), INT8_C( -72), INT8_C( -19),
                           INT8_C(-105), INT8_C( 117), INT8_C( -69), INT8_C(  62),
                           INT8_C(  51), INT8_C( -12), INT8_C( -69), INT8_C(-109),
                           INT8_C(-101), INT8_C( -50), INT8_C(  90), INT8_C(  52),
                           INT8_C(  58), INT8_C( -94), INT8_C( -69), INT8_C(  88),
                           INT8_C(  -9), INT8_C(  25), INT8_C(  89), INT8_C(  31)),
      simde_mm256_set_epi8(INT8_C(  80), INT8_C(  10), INT8_C(  -8), INT8_C( -11),
                           INT8_C(  66), INT8_C(-101), INT8_C(  67), INT8_C(  96),
                           INT8_C(-104), INT8_C(-127), INT8_C( -36), INT8_C(-104),
                           INT8_C(  41), INT8_C( -49), INT8_C( -98), INT8_C(  10),
                           INT8_C( -97), INT8_C( -51), INT8_C( 125), INT8_C( -22),
                           INT8_C(-111), INT8_C(  58), INT8_C( -41), INT8_C(  53),
                           INT8_C( -15), INT8_C(-121), INT8_C(  23), INT8_C(  51),
                           INT8_C(  31), INT8_C(   2), INT8_C( 112), INT8_C(  75)) },
    { simde_mm256_set_epi8(INT8_C(  58), INT8_C( -35), INT8_C(  -9), INT8_C( -15),
                           INT8_C( -74), INT8_C( -92), INT8_C( -26), INT8_C( -48),
                           INT8_C( -14), INT8_C(  54), INT8_C(  39), INT8_C( 120),
                           INT8_C( -38), INT8_C( -90), INT8_C( 101), INT8_C(  25),
                           INT8_C(  90), INT8_C( 106), INT8_C(  24), INT8_C( -31),
                           INT8_C( -57), INT8_C(   7), INT8_C(  29), INT8_C( 106),
                           INT8_C( 124), INT8_C(  62), INT8_C(  44), INT8_C(  40),
                           INT8_C(  54), INT8_C(  54), INT8_C( -93), INT8_C( -77)),
      simde_mm256_set_epi8(INT8_C(  65), INT8_C(-103), INT8_C(  10), INT8_C( 103),
                           INT8_C(  65), INT8_C(  90), INT8_C( -56), INT8_C(  98),
                           INT8_C(  64), INT8_C( 110), INT8_C( -94), INT8_C(  23),
                           INT8_C( -62), INT8_C(  19), INT8_C( 115), INT8_C(  93),
                           INT8_C(  68), INT8_C(  91), INT8_C(  -1), INT8_C(   5),
                           INT8_C(  19), INT8_C( -54), INT8_C( -79), INT8_C(-124),
                           INT8_C( -14), INT8_C( 106), INT8_C( -71), INT8_C( -34),
                           INT8_C(  39), INT8_C( -20), INT8_C( 117), INT8_C( -23)),
      simde_mm256_set_epi8(INT8_C(  -7), INT8_C(  68), INT8_C( -19), INT8_C(-118),
                           INT8_C( 117), INT8_C(  74), INT8_C(  30), INT8_C( 110),
                           INT8_C( -78), INT8_C( -56), INT8_C(-123), INT8_C(  97),
                           INT8_C(  24), INT8_C(-109), INT8_C( -14), INT8_C( -68),
                           INT8_C(  22), INT8_C(  15), INT8_C(  25), INT8_C( -36),
                           INT8_C( -76), INT8_C(  61), INT8_C( 108), INT8_C( -26),
                           INT8_C(-118), INT8_C( -44), INT8_C( 115), INT8_C(  74),
                           INT8_C(  15), INT8_C(  74), INT8_C(  46), INT8_C( -54)) },
    { simde_mm256_set_epi8(INT8_C( -10), INT8_C(  24), INT8_C(-113), INT8_C( -36),
                           INT8_C( 115), INT8_C(  49), INT8_C(  18), INT8_C(  86),
                           INT8_C( 112), INT8_C(  85), INT8_C( -24), INT8_C( -37),
                           INT8_C( -39), INT8_C(  13), INT8_C(   8), INT8_C(  92),
                           INT8_C( -95), INT8_C(-112), INT8_C(  83), INT8_C(  16),
                           INT8_C( 106), INT8_C(-127), INT8_C( 122), INT8_C( -83),
                           INT8_C( -96), INT8_C( -94), INT8_C(  86), INT8_C( -10),
                           INT8_C( -44), INT8_C( -36), INT8_C(  93), INT8_C(  71)),
      simde_mm256_set_epi8(INT8_C( -12), INT8_C(-115), INT8_C( 101), INT8_C( -47),
                           INT8_C(  85), INT8_C( -78), INT8_C( -44), INT8_C(  16),
                           INT8_C(  71), INT8_C(   4), INT8_C( -58), INT8_C(   7),
                           INT8_C(  30), INT8_C(  54), INT8_C(  60), INT8_C(  -1),
                           INT8_C( -73), INT8_C( -28), INT8_C( -92), INT8_C( -36),
                           INT8_C(  82), INT8_C( -11), INT8_C( -69), INT8_C(   2),
                           INT8_C( -76), INT8_C( 100), INT8_C(  99), INT8_C(   0),
                           INT8_C( -87), INT8_C( -70), INT8_C(  29), INT8_C( 121)),
      simde_mm256_set_epi8(INT8_C(   2), INT8_C(-117), INT8_C(  42), INT8_C(  11),
                           INT8_C(  30), INT8_C( 127), INT8_C(  62), INT8_C(  70),
                           INT8_C(  41), INT8_C(  81), INT8_C(  34), INT8_C( -44),
                           INT8_C( -69), INT8_C( -41), INT8_C( -52), INT8_C(  93),
                           INT8_C( -22), INT8_C( -84), INT8_C( -81), INT8_C(  52),
                           INT8_C(  24), INT8_C(-116), INT8_C( -65), INT8_C( -85),
                           INT8_C( -20), INT8_C(  62), INT8_C( -13), INT8_C( -10),
                           INT8_C(  43), INT8_C(  34), INT8_C(  64), INT8_C( -50)) },
    { simde_mm256_set_epi8(INT8_C(   2), INT8_C( -33), INT8_C(  21), INT8_C(  39),
                           INT8_C(  -5), INT8_C(-110), INT8_C(-113), INT8_C(  98),
                           INT8_C(   6), INT8_C(  47), INT8_C( -26), INT8_C(  73),
                           INT8_C(-121), INT8_C( -53), INT8_C( 102), INT8_C( 110),
                           INT8_C( -38), INT8_C( -97), INT8_C( -70), INT8_C(-105),
                           INT8_C(-128), INT8_C(  48), INT8_C( -78), INT8_C( 108),
                           INT8_C( 118), INT8_C(   9), INT8_C(  40), INT8_C( 110),
                           INT8_C( -32), INT8_C( -25), INT8_C(  39), INT8_C(-123)),
      simde_mm256_set_epi8(INT8_C(  15), INT8_C(  27), INT8_C(  -7), INT8_C(-103),
                           INT8_C(  81), INT8_C( 127), INT8_C( -25), INT8_C(  51),
                           INT8_C( -31), INT8_C(  28), INT8_C(-102), INT8_C(  24),
                           INT8_C(  73), INT8_C( 119), INT8_C( 106), INT8_C(   1),
                           INT8_C(   5), INT8_C(-108), INT8_C( -84), INT8_C(  54),
                           INT8_C( -30), INT8_C(-120), INT8_C(  39), INT8_C(   6),
                           INT8_C(-115), INT8_C(-128), INT8_C( 110), INT8_C(  39),
                           INT8_C(-110), INT8_C(-102), INT8_C(   6), INT8_C( 126)),
      simde_mm256_set_epi8(INT8_C( -13), INT8_C( -60), INT8_C(  28), INT8_C(-114),
                           INT8_C( -86), INT8_C(  19), INT8_C( -88), INT8_C(  47),
                           INT8_C(  37), INT8_C(  19), INT8_C(  76), INT8_C(  49),
                           INT8_C(  62), INT8_C(  84), INT8_C(  -4), INT8_C( 109),
                           INT8_C( -43), INT8_C(  11), INT8_C(  14), INT8_C(  97),
                           INT8_C( -98), INT8_C( -88), INT8_C(-117), INT8_C( 102),
                           INT8_C( -23), INT8_C(-119), INT8_C( -70), INT8_C(  71),
                           INT8_C(  78), INT8_C(  77), INT8_C(  33), INT8_C(   7)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_sub_epi8(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_sub_epi16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
   { simde_mm256_set_epi16(INT16_C(-27953), INT16_C(-25893), INT16_C( 18102), INT16_C( -6593),
                            INT16_C(  7623), INT16_C( 27326), INT16_C(-15847), INT16_C( 25196),
                            INT16_C(  4150), INT16_C( 31494), INT16_C( 14922), INT16_C(  2426),
                            INT16_C(  8906), INT16_C( -8618), INT16_C(-26305), INT16_C(  2552)),
      simde_mm256_set_epi16(INT16_C(-20113), INT16_C( 26325), INT16_C( 23863), INT16_C(-13511),
                            INT16_C(  6653), INT16_C( 22833), INT16_C( 26506), INT16_C( 21325),
                            INT16_C(-18785), INT16_C( -8308), INT16_C( -2522), INT16_C(   805),
                            INT16_C(-27299), INT16_C( 31631), INT16_C( -9722), INT16_C(  3708)),
      simde_mm256_set_epi16(INT16_C( -7840), INT16_C( 13318), INT16_C( -5761), INT16_C(  6918),
                            INT16_C(   970), INT16_C(  4493), INT16_C( 23183), INT16_C(  3871),
                            INT16_C( 22935), INT16_C(-25734), INT16_C( 17444), INT16_C(  1621),
                            INT16_C(-29331), INT16_C( 25287), INT16_C(-16583), INT16_C( -1156)) },
    { simde_mm256_set_epi16(INT16_C(-11131), INT16_C(-17560), INT16_C( 30989), INT16_C( -1961),
                            INT16_C( 25635), INT16_C(-31167), INT16_C( 13893), INT16_C(-24056),
                            INT16_C( 29937), INT16_C( 24074), INT16_C(  3624), INT16_C( 30721),
                            INT16_C(  7318), INT16_C(-21871), INT16_C(-24159), INT16_C( 27811)),
      simde_mm256_set_epi16(INT16_C(-14801), INT16_C( 18665), INT16_C( 21171), INT16_C(  2083),
                            INT16_C(  9794), INT16_C(-14994), INT16_C( -7071), INT16_C(-14888),
                            INT16_C( 17983), INT16_C(-13129), INT16_C(-28994), INT16_C(  8299),
                            INT16_C( 22982), INT16_C(  2227), INT16_C(-21646), INT16_C(-28910)),
      simde_mm256_set_epi16(INT16_C(  3670), INT16_C( 29311), INT16_C(  9818), INT16_C( -4044),
                            INT16_C( 15841), INT16_C(-16173), INT16_C( 20964), INT16_C( -9168),
                            INT16_C( 11954), INT16_C(-28333), INT16_C( 32618), INT16_C( 22422),
                            INT16_C(-15664), INT16_C(-24098), INT16_C( -2513), INT16_C( -8815)) },
    { simde_mm256_set_epi16(INT16_C(-23995), INT16_C( 25905), INT16_C( -5982), INT16_C( 20058),
                            INT16_C(  2118), INT16_C(  -114), INT16_C(   287), INT16_C(-16504),
                            INT16_C( 12216), INT16_C( 31693), INT16_C(  7692), INT16_C(-10279),
                            INT16_C( -9654), INT16_C( 13919), INT16_C( 14030), INT16_C( -6049)),
      simde_mm256_set_epi16(INT16_C( 18387), INT16_C(  3058), INT16_C( 24810), INT16_C(-31587),
                            INT16_C( 19314), INT16_C(-13527), INT16_C( 20849), INT16_C(-15645),
                            INT16_C(  4064), INT16_C(  5808), INT16_C( 11755), INT16_C( 23823),
                            INT16_C(-12210), INT16_C(  -514), INT16_C(-10077), INT16_C(  8317)),
      simde_mm256_set_epi16(INT16_C( 23154), INT16_C( 22847), INT16_C(-30792), INT16_C(-13891),
                            INT16_C(-17196), INT16_C( 13413), INT16_C(-20562), INT16_C(  -859),
                            INT16_C(  8152), INT16_C( 25885), INT16_C( -4063), INT16_C( 31434),
                            INT16_C(  2556), INT16_C( 14433), INT16_C( 24107), INT16_C(-14366)) },
    { simde_mm256_set_epi16(INT16_C( 16733), INT16_C(-19192), INT16_C(-19177), INT16_C(-13201),
                            INT16_C(-14970), INT16_C(-23573), INT16_C( 23037), INT16_C(-14068),
                            INT16_C( 18230), INT16_C( 11141), INT16_C(  3822), INT16_C(  6182),
                            INT16_C(-23525), INT16_C(-16307), INT16_C( 26522), INT16_C( 21806)),
      simde_mm256_set_epi16(INT16_C(-30186), INT16_C( 24213), INT16_C( 29509), INT16_C(  2127),
                            INT16_C( -4444), INT16_C( 10965), INT16_C(-26578), INT16_C( -9065),
                            INT16_C( -2827), INT16_C( 31843), INT16_C( 28821), INT16_C(  8551),
                            INT16_C( -1781), INT16_C( 16565), INT16_C(-30183), INT16_C(  9876)),
      simde_mm256_set_epi16(INT16_C(-18617), INT16_C( 22131), INT16_C( 16850), INT16_C(-15328),
                            INT16_C(-10526), INT16_C( 30998), INT16_C(-15921), INT16_C( -5003),
                            INT16_C( 21057), INT16_C(-20702), INT16_C(-24999), INT16_C( -2369),
                            INT16_C(-21744), INT16_C( 32664), INT16_C( -8831), INT16_C( 11930)) },
    { simde_mm256_set_epi16(INT16_C(-10649), INT16_C(  1789), INT16_C( 27012), INT16_C(  5765),
                            INT16_C(-10851), INT16_C(  5376), INT16_C( -9175), INT16_C(-28947),
                            INT16_C(  7733), INT16_C(  7167), INT16_C(-27568), INT16_C(  2115),
                            INT16_C( 10120), INT16_C(-30644), INT16_C(-28345), INT16_C( 20915)),
      simde_mm256_set_epi16(INT16_C( 23043), INT16_C( 25420), INT16_C( 19475), INT16_C(-31775),
                            INT16_C(-12265), INT16_C( -4342), INT16_C( 11340), INT16_C( 16492),
                            INT16_C( 28872), INT16_C( -2502), INT16_C(-23877), INT16_C(-30231),
                            INT16_C(  1907), INT16_C(   764), INT16_C(  -427), INT16_C(-25788)),
      simde_mm256_set_epi16(INT16_C( 31844), INT16_C(-23631), INT16_C(  7537), INT16_C(-27996),
                            INT16_C(  1414), INT16_C(  9718), INT16_C(-20515), INT16_C( 20097),
                            INT16_C(-21139), INT16_C(  9669), INT16_C( -3691), INT16_C( 32346),
                            INT16_C(  8213), INT16_C(-31408), INT16_C(-27918), INT16_C(-18833)) },
    { simde_mm256_set_epi16(INT16_C( 10906), INT16_C( -7304), INT16_C(  1755), INT16_C(  4890),
                            INT16_C(-11395), INT16_C( -7564), INT16_C( 10816), INT16_C(-23172),
                            INT16_C(-11608), INT16_C(-11875), INT16_C(-15837), INT16_C(-17763),
                            INT16_C( 21395), INT16_C(  8598), INT16_C(-20063), INT16_C(-10275)),
      simde_mm256_set_epi16(INT16_C( -9448), INT16_C(  6330), INT16_C(-18331), INT16_C( -6901),
                            INT16_C(-14581), INT16_C( 32348), INT16_C(  9963), INT16_C( 31451),
                            INT16_C( 24178), INT16_C( 12481), INT16_C( 12230), INT16_C(-12978),
                            INT16_C(-27030), INT16_C( -1366), INT16_C(-22019), INT16_C( 19232)),
      simde_mm256_set_epi16(INT16_C( 20354), INT16_C(-13634), INT16_C( 20086), INT16_C( 11791),
                            INT16_C(  3186), INT16_C( 25624), INT16_C(   853), INT16_C( 10913),
                            INT16_C( 29750), INT16_C(-24356), INT16_C(-28067), INT16_C( -4785),
                            INT16_C(-17111), INT16_C(  9964), INT16_C(  1956), INT16_C(-29507)) },
    { simde_mm256_set_epi16(INT16_C( 30843), INT16_C( 21336), INT16_C(  5686), INT16_C(  2828),
                            INT16_C( 19954), INT16_C( 31539), INT16_C(-19646), INT16_C(   671),
                            INT16_C( 25132), INT16_C(  3458), INT16_C(-19712), INT16_C(  4606),
                            INT16_C(  5503), INT16_C(-15517), INT16_C(   355), INT16_C( 25145)),
      simde_mm256_set_epi16(INT16_C( -6584), INT16_C( 11532), INT16_C( 13185), INT16_C(-20125),
                            INT16_C( 10954), INT16_C( -8384), INT16_C(  2784), INT16_C( 19614),
                            INT16_C( 16337), INT16_C( 21741), INT16_C( 28414), INT16_C( 19897),
                            INT16_C(-27104), INT16_C( 23081), INT16_C( 17729), INT16_C( 27826)),
      simde_mm256_set_epi16(INT16_C(-28109), INT16_C(  9804), INT16_C( -7499), INT16_C( 22953),
                            INT16_C(  9000), INT16_C(-25613), INT16_C(-22430), INT16_C(-18943),
                            INT16_C(  8795), INT16_C(-18283), INT16_C( 17410), INT16_C(-15291),
                            INT16_C( 32607), INT16_C( 26938), INT16_C(-17374), INT16_C( -2681)) },
    { simde_mm256_set_epi16(INT16_C(-16362), INT16_C(-26163), INT16_C( -8945), INT16_C(  5119),
                            INT16_C( 30284), INT16_C( 12893), INT16_C(-21079), INT16_C(   124),
                            INT16_C( -1271), INT16_C(  3217), INT16_C( 20702), INT16_C(   647),
                            INT16_C(-30215), INT16_C( 25412), INT16_C(   851), INT16_C( 30446)),
      simde_mm256_set_epi16(INT16_C(  8605), INT16_C(-24114), INT16_C( -5979), INT16_C( -9101),
                            INT16_C(  6437), INT16_C(-25374), INT16_C( 24146), INT16_C(-14771),
                            INT16_C(-26765), INT16_C( 30576), INT16_C( 25327), INT16_C(  1225),
                            INT16_C(-13633), INT16_C(-15186), INT16_C(-14472), INT16_C( 31809)),
      simde_mm256_set_epi16(INT16_C(-24967), INT16_C( -2049), INT16_C( -2966), INT16_C( 14220),
                            INT16_C( 23847), INT16_C(-27269), INT16_C( 20311), INT16_C( 14895),
                            INT16_C( 25494), INT16_C(-27359), INT16_C( -4625), INT16_C(  -578),
                            INT16_C(-16582), INT16_C(-24938), INT16_C( 15323), INT16_C( -1363)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_sub_epi16(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_sub_epi32(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi32(INT32_C(  326943318), INT32_C(-1426446841), INT32_C( -705322739), INT32_C( 1382181134),
                            INT32_C( -752013979), INT32_C( 1926838871), INT32_C(-1267474220), INT32_C(-1807600682)),
      simde_mm256_set_epi32(INT32_C(  251701658), INT32_C( 1304570849), INT32_C(-1313346575), INT32_C(  548342496),
                            INT32_C(  350328631), INT32_C(  492623957), INT32_C(  209048435), INT32_C(  494519967)),
      simde_mm256_set_epi32(INT32_C(   75241660), INT32_C( 1563949606), INT32_C(  608023836), INT32_C(  833838638),
                            INT32_C(-1102342610), INT32_C( 1434214914), INT32_C(-1476522655), INT32_C( 1992846647)) },
    { simde_mm256_set_epi32(INT32_C( -933394757), INT32_C( 2044671684), INT32_C(  359818497), INT32_C( 1070534780),
                            INT32_C( -970998086), INT32_C(-1718071453), INT32_C( 1676992968), INT32_C(-1700643811)),
      simde_mm256_set_epi32(INT32_C( 1601497259), INT32_C( -783324799), INT32_C(  230836562), INT32_C( -793897628),
                            INT32_C( 2109010219), INT32_C( -500991481), INT32_C( 1633364343), INT32_C(-1085575788)),
      simde_mm256_set_epi32(INT32_C( 1760075280), INT32_C(-1466970813), INT32_C(  128981935), INT32_C( 1864432408),
                            INT32_C( 1214958991), INT32_C(-1217079972), INT32_C(   43628625), INT32_C( -615068023)) },
    { simde_mm256_set_epi32(INT32_C(  -51216759), INT32_C( -878749548), INT32_C(-1368701232), INT32_C(-2046658418),
                            INT32_C(-1669301170), INT32_C(-2003910541), INT32_C( 1329758066), INT32_C( 1724000039)),
      simde_mm256_set_epi32(INT32_C(-2019361399), INT32_C( 1441882288), INT32_C(-1015852054), INT32_C(-2140601122),
                            INT32_C( 1393090412), INT32_C(  -54787332), INT32_C(  -18616908), INT32_C(-2129018166)),
      simde_mm256_set_epi32(INT32_C( 1968144640), INT32_C( 1974335460), INT32_C( -352849178), INT32_C(   93942704),
                            INT32_C( 1232575714), INT32_C(-1949123209), INT32_C( 1348374974), INT32_C( -441949091)) },
    { simde_mm256_set_epi32(INT32_C( -198091267), INT32_C( -797938117), INT32_C( 1365606315), INT32_C( 1369771544),
                            INT32_C(  454471573), INT32_C(-1496770990), INT32_C(-1504062345), INT32_C(-1729521659)),
      simde_mm256_set_epi32(INT32_C(-1875378957), INT32_C( 1413357347), INT32_C(-2041380610), INT32_C( 1834864782),
                            INT32_C(  265860555), INT32_C(  367864932), INT32_C(-1203083960), INT32_C(  193499515)),
      simde_mm256_set_epi32(INT32_C( 1677287690), INT32_C( 2083671832), INT32_C( -887980371), INT32_C( -465093238),
                            INT32_C(  188611018), INT32_C(-1864635922), INT32_C( -300978385), INT32_C(-1923021174)) },
    { simde_mm256_set_epi32(INT32_C(-1042833230), INT32_C( 1624054732), INT32_C(  234631196), INT32_C(  738820353),
                            INT32_C(-1501237092), INT32_C(-1737761237), INT32_C(-1663334158), INT32_C( -439342149)),
      simde_mm256_set_epi32(INT32_C(  164170961), INT32_C( 1826341689), INT32_C(-1379584328), INT32_C( -883834236),
                            INT32_C( -145065229), INT32_C( 1276456429), INT32_C(  908937179), INT32_C( 1101978337)),
      simde_mm256_set_epi32(INT32_C(-1207004191), INT32_C( -202286957), INT32_C( 1614215524), INT32_C( 1622654589),
                            INT32_C(-1356171863), INT32_C( 1280749630), INT32_C( 1722695959), INT32_C(-1541320486)) },
    { simde_mm256_set_epi32(INT32_C( 1638607685), INT32_C(-2009128326), INT32_C( -563580109), INT32_C( 1319284819),
                            INT32_C(  -21113241), INT32_C( -656216704), INT32_C(  927278729), INT32_C(  414207795)),
      simde_mm256_set_epi32(INT32_C(-1371308348), INT32_C( 1761271665), INT32_C( 1358250649), INT32_C( -906482895),
                            INT32_C(  540611685), INT32_C(  776022210), INT32_C( 1935373704), INT32_C( -317327387)),
      simde_mm256_set_epi32(INT32_C(-1285051263), INT32_C(  524567305), INT32_C(-1921830758), INT32_C(-2069199582),
                            INT32_C( -561724926), INT32_C(-1432238914), INT32_C(-1008094975), INT32_C(  731535182)) },
    { simde_mm256_set_epi32(INT32_C(-2100986650), INT32_C( 1414058950), INT32_C(-1053542475), INT32_C( -736674814),
                            INT32_C(-2096553410), INT32_C(-1369794669), INT32_C(   26060713), INT32_C(-1294950753)),
      simde_mm256_set_epi32(INT32_C( 2012616977), INT32_C( 1553490078), INT32_C(  324319438), INT32_C(-1664423684),
                            INT32_C( 1284704444), INT32_C( 1334884932), INT32_C(-1343260831), INT32_C( -516360618)),
      simde_mm256_set_epi32(INT32_C(  181363669), INT32_C( -139431128), INT32_C(-1377861913), INT32_C(  927748870),
                            INT32_C(  913709442), INT32_C( 1590287695), INT32_C( 1369321544), INT32_C( -778590135)) },
    { simde_mm256_set_epi32(INT32_C(-1942786341), INT32_C(-1691503678), INT32_C(-1765167726), INT32_C( 1858759286),
                            INT32_C(  627375525), INT32_C(-1868274030), INT32_C(   12505540), INT32_C(  986732702)),
      simde_mm256_set_epi32(INT32_C(-1777720655), INT32_C(-2032047915), INT32_C(  -56259521), INT32_C( -952761137),
                            INT32_C(  805966046), INT32_C(  372017673), INT32_C(   20751226), INT32_C( -331388981)),
      simde_mm256_set_epi32(INT32_C( -165065686), INT32_C(  340544237), INT32_C(-1708908205), INT32_C(-1483446873),
                            INT32_C( -178590521), INT32_C( 2054675593), INT32_C(   -8245686), INT32_C( 1318121683)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_sub_epi32(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_sub_epi64(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi64x(INT64_C(-2885858146882597019), INT64_C(-3498254024691385676),
                             INT64_C( 7972223233728178657), INT64_C( 6231317733982512179)),
      simde_mm256_set_epi64x(INT64_C( 3826502112888397679), INT64_C(-8682306207824752089),
                             INT64_C( 8218291866756092637), INT64_C(  977663894185762148)),
      simde_mm256_set_epi64x(INT64_C(-6712360259770994698), INT64_C( 5184052183133366413),
                             INT64_C( -246068633027913980), INT64_C( 5253653839796750031)) },
    { simde_mm256_set_epi64x(INT64_C( 7921380973104735890), INT64_C(-5532460099708114375),
                             INT64_C(  865084101794303087), INT64_C(-7356844417578967355)),
      simde_mm256_set_epi64x(INT64_C(-3491207381975027904), INT64_C(-1030678116339367991),
                             INT64_C(-8175524911489530105), INT64_C(  323779015099665520)),
      simde_mm256_set_epi64x(INT64_C(-7034155718629787822), INT64_C(-4501781983368746384),
                             INT64_C( 9040609013283833192), INT64_C(-7680623432678632875)) },
    { simde_mm256_set_epi64x(INT64_C( 4341016735029725119), INT64_C(-4017352277952498418),
                             INT64_C( 7582500189708583283), INT64_C(-5892965129862928683)),
      simde_mm256_set_epi64x(INT64_C(-8237509791976513777), INT64_C( -470554251606780044),
                             INT64_C( 6040143329078659839), INT64_C( -424501583476695872)),
      simde_mm256_set_epi64x(INT64_C(-5868217546703312720), INT64_C(-3546798026345718374),
                             INT64_C( 1542356860629923444), INT64_C(-5468463546386232811)) },
    { simde_mm256_set_epi64x(INT64_C(-7392183468556786070), INT64_C(-6610175517365172355),
                             INT64_C(-3756419626009538740), INT64_C(-9036454621798279072)),
      simde_mm256_set_epi64x(INT64_C( 6035045015129345008), INT64_C( 8791627257213638823),
                             INT64_C(-8556126845609402343), INT64_C( 1314921607038438268)),
      simde_mm256_set_epi64x(INT64_C( 5019515590023420538), INT64_C( 3044941299130740438),
                             INT64_C( 4799707219599863603), INT64_C( 8095367844872834276)) },
    { simde_mm256_set_epi64x(INT64_C( 8174138309950782489), INT64_C(-3595444893239169269),
                             INT64_C(-6261543721635705717), INT64_C(-8089986319993999570)),
      simde_mm256_set_epi64x(INT64_C( 4668020520258365306), INT64_C( 1754255393252662962),
                             INT64_C( 1690801515152582572), INT64_C(-7136424812163547703)),
      simde_mm256_set_epi64x(INT64_C( 3506117789692417183), INT64_C(-5349700286491832231),
                             INT64_C(-7952345236788288289), INT64_C( -953561507830451867)) },
    { simde_mm256_set_epi64x(INT64_C( 6033172137928900790), INT64_C(-5612895834493214657),
                             INT64_C(-8524528714074059580), INT64_C(-3969628664745125304)),
      simde_mm256_set_epi64x(INT64_C( 7126793331936974199), INT64_C( 5665142255281704397),
                             INT64_C( 1602540828580772090), INT64_C( 8387594021483335882)),
      simde_mm256_set_epi64x(INT64_C(-1093621194008073409), INT64_C( 7168705983934632562),
                             INT64_C( 8319674531054719946), INT64_C( 6089521387481090430)) },
    { simde_mm256_set_epi64x(INT64_C( 3903790755083266798), INT64_C(-4529825138752859475),
                             INT64_C( -488451067611140207), INT64_C(  375847149564403603)),
      simde_mm256_set_epi64x(INT64_C(-7317636610137191039), INT64_C(-6404029010026237648),
                             INT64_C( 2684127196708781119), INT64_C(-4695910663442221977)),
      simde_mm256_set_epi64x(INT64_C(-7225316708489093779), INT64_C( 1874203871273378173),
                             INT64_C(-3172578264319921326), INT64_C( 5071757813006625580)) },
    { simde_mm256_set_epi64x(INT64_C( -634520004609695604), INT64_C(-4556943099082170660),
                             INT64_C(  407417976594608885), INT64_C(-2432518353344050945)),
      simde_mm256_set_epi64x(INT64_C( 8351025001768468670), INT64_C(-2893015942465040381),
                             INT64_C(-7482511571570747740), INT64_C( 2790733591573448110)),
      simde_mm256_set_epi64x(INT64_C(-8985545006378164274), INT64_C(-1663927156617130279),
                             INT64_C( 7889929548165356625), INT64_C(-5223251944917499055)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_sub_epi64(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i64(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_x_mm256_sub_epu32(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_x_mm256_set_epu32(UINT32_C( 107879378), UINT32_C(2256216441), UINT32_C(1547145394), UINT32_C(  23322183),
                              UINT32_C(  24183335), UINT32_C(2032217709), UINT32_C( 971024796), UINT32_C(3326705122)),
      simde_x_mm256_set_epu32(UINT32_C( 149466069), UINT32_C(3517994125), UINT32_C(1432270320), UINT32_C(2851287457),
                              UINT32_C(1208329282), UINT32_C( 158848810), UINT32_C(3819928804), UINT32_C(3738317239)),
      simde_x_mm256_set_epu32(UINT32_C(4253380605), UINT32_C(3033189612), UINT32_C( 114875074), UINT32_C(1467002022),
                              UINT32_C(3110821349), UINT32_C(1873368899), UINT32_C(1446063288), UINT32_C(3883355179)) },
    { simde_x_mm256_set_epu32(UINT32_C(2351108717), UINT32_C( 184367791), UINT32_C( 651012821), UINT32_C(1858699737),
                              UINT32_C(2120954292), UINT32_C( 432426176), UINT32_C( 314621009), UINT32_C( 683154820)),
      simde_x_mm256_set_epu32(UINT32_C(2061753916), UINT32_C(3341354567), UINT32_C(2475959533), UINT32_C( 982967416),
                              UINT32_C(2049417650), UINT32_C(1285751824), UINT32_C(3637636007), UINT32_C(1398995246)),
      simde_x_mm256_set_epu32(UINT32_C( 289354801), UINT32_C(1137980520), UINT32_C(2470020584), UINT32_C( 875732321),
                              UINT32_C(  71536642), UINT32_C(3441641648), UINT32_C( 971952298), UINT32_C(3579126870)) },
    { simde_x_mm256_set_epu32(UINT32_C(1897588552), UINT32_C( 447224664), UINT32_C(2771607020), UINT32_C( 619382757),
                              UINT32_C(2584621804), UINT32_C( 967633271), UINT32_C(2311738101), UINT32_C(1795187199)),
      simde_x_mm256_set_epu32(UINT32_C(1007929400), UINT32_C(2616961748), UINT32_C(1589771424), UINT32_C(3081473365),
                              UINT32_C(3569555574), UINT32_C(3120660078), UINT32_C( 775299967), UINT32_C( 379946438)),
      simde_x_mm256_set_epu32(UINT32_C( 889659152), UINT32_C(2125230212), UINT32_C(1181835596), UINT32_C(1832876688),
                              UINT32_C(3310033526), UINT32_C(2141940489), UINT32_C(1536438134), UINT32_C(1415240761)) },
    { simde_x_mm256_set_epu32(UINT32_C(1476738727), UINT32_C(1269851975), UINT32_C(2316737502), UINT32_C(  66699996),
                              UINT32_C( 467087828), UINT32_C(2161831335), UINT32_C(4149911179), UINT32_C( 504793551)),
      simde_x_mm256_set_epu32(UINT32_C(3396602389), UINT32_C(3482637302), UINT32_C(4215273460), UINT32_C( 993218468),
                              UINT32_C(2631972858), UINT32_C(3366478001), UINT32_C(3680212603), UINT32_C(3739565912)),
      simde_x_mm256_set_epu32(UINT32_C(2375103634), UINT32_C(2082181969), UINT32_C(2396431338), UINT32_C(3368448824),
                              UINT32_C(2130082266), UINT32_C(3090320630), UINT32_C( 469698576), UINT32_C(1060194935)) },
    { simde_x_mm256_set_epu32(UINT32_C( 179882245), UINT32_C(4021916078), UINT32_C(3627300617), UINT32_C(3248980610),
                              UINT32_C( 191409075), UINT32_C(3646970912), UINT32_C(2035553404), UINT32_C(4075300565)),
      simde_x_mm256_set_epu32(UINT32_C(4018869540), UINT32_C(3247000771), UINT32_C( 419518577), UINT32_C(1741182634),
                              UINT32_C( 293418594), UINT32_C(2336988215), UINT32_C(4218997823), UINT32_C( 205082086)),
      simde_x_mm256_set_epu32(UINT32_C( 455980001), UINT32_C( 774915307), UINT32_C(3207782040), UINT32_C(1507797976),
                              UINT32_C(4192957777), UINT32_C(1309982697), UINT32_C(2111522877), UINT32_C(3870218479)) },
    { simde_x_mm256_set_epu32(UINT32_C(  84590544), UINT32_C(4204381436), UINT32_C(3727353694), UINT32_C(2213501554),
                              UINT32_C(2836071016), UINT32_C(4047724580), UINT32_C(1001388660), UINT32_C(3282415970)),
      simde_x_mm256_set_epu32(UINT32_C(1074654014), UINT32_C(1012976116), UINT32_C(2090582329), UINT32_C(2908553801),
                              UINT32_C(1272437250), UINT32_C(3454899956), UINT32_C(3722866273), UINT32_C(4069029472)),
      simde_x_mm256_set_epu32(UINT32_C(3304903826), UINT32_C(3191405320), UINT32_C(1636771365), UINT32_C(3599915049),
                              UINT32_C(1563633766), UINT32_C( 592824624), UINT32_C(1573489683), UINT32_C(3508353794)) },
    { simde_x_mm256_set_epu32(UINT32_C(2451663057), UINT32_C( 104156540), UINT32_C( 918040827), UINT32_C( 534540183),
                              UINT32_C(3003822364), UINT32_C(4203020917), UINT32_C(1548649531), UINT32_C( 205808915)),
      simde_x_mm256_set_epu32(UINT32_C(3286644093), UINT32_C(3785715782), UINT32_C(  33333951), UINT32_C( 270641278),
                              UINT32_C( 533308511), UINT32_C(1335157821), UINT32_C(2324891096), UINT32_C(  26430848)),
      simde_x_mm256_set_epu32(UINT32_C(3459986260), UINT32_C( 613408054), UINT32_C( 884706876), UINT32_C( 263898905),
                              UINT32_C(2470513853), UINT32_C(2867863096), UINT32_C(3518725731), UINT32_C( 179378067)) },
    { simde_x_mm256_set_epu32(UINT32_C(2743667516), UINT32_C(3635884938), UINT32_C( 257447579), UINT32_C(2134094887),
                              UINT32_C( 404535734), UINT32_C(2034221371), UINT32_C(3960317580), UINT32_C( 591850571)),
      simde_x_mm256_set_epu32(UINT32_C( 570641927), UINT32_C(1821664575), UINT32_C(  96915915), UINT32_C(  55727396),
                              UINT32_C(4162444437), UINT32_C(1669109680), UINT32_C(1870162202), UINT32_C(3082396888)),
      simde_x_mm256_set_epu32(UINT32_C(2173025589), UINT32_C(1814220363), UINT32_C( 160531664), UINT32_C(2078367491),
                              UINT32_C( 537058593), UINT32_C( 365111691), UINT32_C(2090155378), UINT32_C(1804420979)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_x_mm256_sub_epu32(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_u32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_subs_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi8(INT8_C(  53), INT8_C(  22), INT8_C( -99), INT8_C( -90),
                           INT8_C(  42), INT8_C(  84), INT8_C(  24), INT8_C(  60),
                           INT8_C(-122), INT8_C(  44), INT8_C( -82), INT8_C(  91),
                           INT8_C( -59), INT8_C(-107), INT8_C( -72), INT8_C( -97),
                           INT8_C(-114), INT8_C(  65), INT8_C( -70), INT8_C( -44),
                           INT8_C( -34), INT8_C(  83), INT8_C(  30), INT8_C(   3),
                           INT8_C(  17), INT8_C(  66), INT8_C(  92), INT8_C(  52),
                           INT8_C( -56), INT8_C(  94), INT8_C( 119), INT8_C(  94)),
      simde_mm256_set_epi8(INT8_C(  56), INT8_C( -13), INT8_C( -72), INT8_C(  29),
                           INT8_C(  36), INT8_C(  53), INT8_C(  55), INT8_C(  96),
                           INT8_C(  22), INT8_C( 124), INT8_C(  55), INT8_C(  67),
                           INT8_C( 105), INT8_C(  -7), INT8_C(  41), INT8_C( -17),
                           INT8_C(  28), INT8_C(  17), INT8_C( -15), INT8_C(  70),
                           INT8_C(  15), INT8_C( -38), INT8_C(  93), INT8_C( 109),
                           INT8_C(  77), INT8_C(-109), INT8_C(   9), INT8_C(  58),
                           INT8_C( -56), INT8_C(   8), INT8_C(  92), INT8_C( -88)),
      simde_mm256_set_epi8(INT8_C(  -3), INT8_C(  35), INT8_C( -27), INT8_C(-119),
                           INT8_C(   6), INT8_C(  31), INT8_C( -31), INT8_C( -36),
                           INT8_C(-128), INT8_C( -80), INT8_C(-128), INT8_C(  24),
                           INT8_C(-128), INT8_C(-100), INT8_C(-113), INT8_C( -80),
                           INT8_C(-128), INT8_C(  48), INT8_C( -55), INT8_C(-114),
                           INT8_C( -49), INT8_C( 121), INT8_C( -63), INT8_C(-106),
                           INT8_C( -60), INT8_C( 127), INT8_C(  83), INT8_C(  -6),
                           INT8_C(   0), INT8_C(  86), INT8_C(  27), INT8_C( 127)) },
    { simde_mm256_set_epi8(INT8_C( -93), INT8_C( -26), INT8_C(   0), INT8_C(  17),
                           INT8_C(-120), INT8_C(  61), INT8_C(-102), INT8_C( 103),
                           INT8_C(  79), INT8_C( -49), INT8_C( -72), INT8_C(  47),
                           INT8_C( 110), INT8_C( -74), INT8_C( -56), INT8_C(  43),
                           INT8_C(  93), INT8_C( 101), INT8_C(   5), INT8_C( -56),
                           INT8_C( -87), INT8_C(  20), INT8_C(-114), INT8_C(-104),
                           INT8_C(-119), INT8_C(  75), INT8_C(-125), INT8_C( -24),
                           INT8_C( -47), INT8_C( -37), INT8_C( -74), INT8_C( -79)),
      simde_mm256_set_epi8(INT8_C(  29), INT8_C(  85), INT8_C(  95), INT8_C(  -5),
                           INT8_C(  -3), INT8_C( 113), INT8_C(  45), INT8_C( -94),
                           INT8_C( -94), INT8_C( -99), INT8_C(  85), INT8_C( 102),
                           INT8_C(  95), INT8_C(  76), INT8_C( -35), INT8_C( -63),
                           INT8_C(  20), INT8_C( -12), INT8_C(  14), INT8_C(-108),
                           INT8_C(  -3), INT8_C( -68), INT8_C(  90), INT8_C(  90),
                           INT8_C(  39), INT8_C(  15), INT8_C(  34), INT8_C( -85),
                           INT8_C(-115), INT8_C(-113), INT8_C( -50), INT8_C(  41)),
      simde_mm256_set_epi8(INT8_C(-122), INT8_C(-111), INT8_C( -95), INT8_C(  22),
                           INT8_C(-117), INT8_C( -52), INT8_C(-128), INT8_C( 127),
                           INT8_C( 127), INT8_C(  50), INT8_C(-128), INT8_C( -55),
                           INT8_C(  15), INT8_C(-128), INT8_C( -21), INT8_C( 106),
                           INT8_C(  73), INT8_C( 113), INT8_C(  -9), INT8_C(  52),
                           INT8_C( -84), INT8_C(  88), INT8_C(-128), INT8_C(-128),
                           INT8_C(-128), INT8_C(  60), INT8_C(-128), INT8_C(  61),
                           INT8_C(  68), INT8_C(  76), INT8_C( -24), INT8_C(-120)) },
    { simde_mm256_set_epi8(INT8_C(-118), INT8_C(   5), INT8_C(-122), INT8_C( -40),
                           INT8_C( -95), INT8_C(  64), INT8_C(  56), INT8_C(-112),
                           INT8_C( -70), INT8_C( -39), INT8_C(  82), INT8_C(  89),
                           INT8_C( -25), INT8_C( -48), INT8_C(   6), INT8_C(  73),
                           INT8_C( -25), INT8_C(  89), INT8_C(  45), INT8_C( -40),
                           INT8_C(   7), INT8_C( -14), INT8_C( 103), INT8_C(  37),
                           INT8_C( -51), INT8_C(  59), INT8_C( -30), INT8_C(  28),
                           INT8_C(  -3), INT8_C( -99), INT8_C(  87), INT8_C(  38)),
      simde_mm256_set_epi8(INT8_C(  -9), INT8_C(  27), INT8_C( -15), INT8_C(-127),
                           INT8_C(-108), INT8_C( -58), INT8_C( -97), INT8_C( -56),
                           INT8_C(  79), INT8_C( -35), INT8_C( -71), INT8_C(  22),
                           INT8_C( -63), INT8_C(-121), INT8_C( -22), INT8_C(  67),
                           INT8_C(  88), INT8_C( -40), INT8_C( -33), INT8_C(  36),
                           INT8_C( -18), INT8_C(  91), INT8_C( 119), INT8_C(  49),
                           INT8_C(  32), INT8_C(-120), INT8_C(-103), INT8_C( -96),
                           INT8_C(  75), INT8_C(  92), INT8_C(  46), INT8_C( -24)),
      simde_mm256_set_epi8(INT8_C(-109), INT8_C( -22), INT8_C(-107), INT8_C(  87),
                           INT8_C(  13), INT8_C( 122), INT8_C( 127), INT8_C( -56),
                           INT8_C(-128), INT8_C(  -4), INT8_C( 127), INT8_C(  67),
                           INT8_C(  38), INT8_C(  73), INT8_C(  28), INT8_C(   6),
                           INT8_C(-113), INT8_C( 127), INT8_C(  78), INT8_C( -76),
                           INT8_C(  25), INT8_C(-105), INT8_C( -16), INT8_C( -12),
                           INT8_C( -83), INT8_C( 127), INT8_C(  73), INT8_C( 124),
                           INT8_C( -78), INT8_C(-128), INT8_C(  41), INT8_C(  62)) },
    { simde_mm256_set_epi8(INT8_C(  44), INT8_C(  83), INT8_C( -32), INT8_C(   9),
                           INT8_C( -69), INT8_C(  91), INT8_C( -61), INT8_C(  48),
                           INT8_C( -44), INT8_C( 120), INT8_C( 118), INT8_C( -37),
                           INT8_C(-112), INT8_C( -30), INT8_C(  84), INT8_C(  76),
                           INT8_C( -78), INT8_C( 115), INT8_C( -63), INT8_C( -12),
                           INT8_C( -25), INT8_C( 117), INT8_C(  23), INT8_C( -38),
                           INT8_C(  -3), INT8_C(  33), INT8_C(  83), INT8_C( -23),
                           INT8_C( -34), INT8_C(  37), INT8_C( -85), INT8_C( -55)),
      simde_mm256_set_epi8(INT8_C(  88), INT8_C(-105), INT8_C( -90), INT8_C(  16),
                           INT8_C(-116), INT8_C( -66), INT8_C( 122), INT8_C( 120),
                           INT8_C( -39), INT8_C(  67), INT8_C( 124), INT8_C( 106),
                           INT8_C( -41), INT8_C(  52), INT8_C( -14), INT8_C( -22),
                           INT8_C(-117), INT8_C( -91), INT8_C( 105), INT8_C(   6),
                           INT8_C(-100), INT8_C(  20), INT8_C( -55), INT8_C( 105),
                           INT8_C( -43), INT8_C(  29), INT8_C(  33), INT8_C( -82),
                           INT8_C(-126), INT8_C(  41), INT8_C(  41), INT8_C( -12)),
      simde_mm256_set_epi8(INT8_C( -44), INT8_C( 127), INT8_C(  58), INT8_C(  -7),
                           INT8_C(  47), INT8_C( 127), INT8_C(-128), INT8_C( -72),
                           INT8_C(  -5), INT8_C(  53), INT8_C(  -6), INT8_C(-128),
                           INT8_C( -71), INT8_C( -82), INT8_C(  98), INT8_C(  98),
                           INT8_C(  39), INT8_C( 127), INT8_C(-128), INT8_C( -18),
                           INT8_C(  75), INT8_C(  97), INT8_C(  78), INT8_C(-128),
                           INT8_C(  40), INT8_C(   4), INT8_C(  50), INT8_C(  59),
                           INT8_C(  92), INT8_C(  -4), INT8_C(-126), INT8_C( -43)) },
    { simde_mm256_set_epi8(INT8_C(  69), INT8_C( -19), INT8_C( -92), INT8_C( -51),
                           INT8_C( 104), INT8_C(  20), INT8_C(  21), INT8_C( -35),
                           INT8_C( -76), INT8_C( -66), INT8_C(  37), INT8_C(  59),
                           INT8_C(  60), INT8_C(-100), INT8_C(  19), INT8_C( 125),
                           INT8_C(  63), INT8_C(  96), INT8_C( -20), INT8_C(  53),
                           INT8_C( 121), INT8_C( 115), INT8_C( -36), INT8_C(  95),
                           INT8_C(  62), INT8_C(  99), INT8_C( -61), INT8_C( -76),
                           INT8_C(  55), INT8_C(   5), INT8_C( -93), INT8_C( -19)),
      simde_mm256_set_epi8(INT8_C(-107), INT8_C(  27), INT8_C( 110), INT8_C( -66),
                           INT8_C(-108), INT8_C( 103), INT8_C( -63), INT8_C(  96),
                           INT8_C(  40), INT8_C( -37), INT8_C(   4), INT8_C( -24),
                           INT8_C( -32), INT8_C(  47), INT8_C(  83), INT8_C( -56),
                           INT8_C(  -5), INT8_C(-125), INT8_C(   8), INT8_C( -20),
                           INT8_C( -92), INT8_C( -17), INT8_C( -76), INT8_C(-105),
                           INT8_C( -38), INT8_C(  10), INT8_C(  27), INT8_C( -81),
                           INT8_C(  92), INT8_C(  92), INT8_C(  46), INT8_C(-100)),
      simde_mm256_set_epi8(INT8_C( 127), INT8_C( -46), INT8_C(-128), INT8_C(  15),
                           INT8_C( 127), INT8_C( -83), INT8_C(  84), INT8_C(-128),
                           INT8_C(-116), INT8_C( -29), INT8_C(  33), INT8_C(  83),
                           INT8_C(  92), INT8_C(-128), INT8_C( -64), INT8_C( 127),
                           INT8_C(  68), INT8_C( 127), INT8_C( -28), INT8_C(  73),
                           INT8_C( 127), INT8_C( 127), INT8_C(  40), INT8_C( 127),
                           INT8_C( 100), INT8_C(  89), INT8_C( -88), INT8_C(   5),
                           INT8_C( -37), INT8_C( -87), INT8_C(-128), INT8_C(  81)) },
    { simde_mm256_set_epi8(INT8_C( -50), INT8_C(  75), INT8_C( -14), INT8_C(  54),
                           INT8_C(  43), INT8_C( -80), INT8_C(-125), INT8_C( 103),
                           INT8_C(  80), INT8_C(  -1), INT8_C( -59), INT8_C( -13),
                           INT8_C(-111), INT8_C(  18), INT8_C( -92), INT8_C( 116),
                           INT8_C(  12), INT8_C( -97), INT8_C( -84), INT8_C( -83),
                           INT8_C( -61), INT8_C( 127), INT8_C( 102), INT8_C(-110),
                           INT8_C(   1), INT8_C(  91), INT8_C( -75), INT8_C( -20),
                           INT8_C( -58), INT8_C( -80), INT8_C( 101), INT8_C(  97)),
      simde_mm256_set_epi8(INT8_C(  15), INT8_C( -47), INT8_C(  64), INT8_C(  40),
                           INT8_C(  22), INT8_C(   0), INT8_C( -93), INT8_C(  62),
                           INT8_C( -55), INT8_C(  95), INT8_C( -45), INT8_C( -91),
                           INT8_C(  44), INT8_C(  98), INT8_C( -37), INT8_C( -63),
                           INT8_C( -64), INT8_C(  91), INT8_C(-118), INT8_C(  36),
                           INT8_C(-114), INT8_C(  60), INT8_C(  43), INT8_C( -14),
                           INT8_C(  -9), INT8_C( -85), INT8_C( -51), INT8_C( -99),
                           INT8_C(-120), INT8_C(  73), INT8_C( 109), INT8_C(  94)),
      simde_mm256_set_epi8(INT8_C( -65), INT8_C( 122), INT8_C( -78), INT8_C(  14),
                           INT8_C(  21), INT8_C( -80), INT8_C( -32), INT8_C(  41),
                           INT8_C( 127), INT8_C( -96), INT8_C( -14), INT8_C(  78),
                           INT8_C(-128), INT8_C( -80), INT8_C( -55), INT8_C( 127),
                           INT8_C(  76), INT8_C(-128), INT8_C(  34), INT8_C(-119),
                           INT8_C(  53), INT8_C(  67), INT8_C(  59), INT8_C( -96),
                           INT8_C(  10), INT8_C( 127), INT8_C( -24), INT8_C(  79),
                           INT8_C(  62), INT8_C(-128), INT8_C(  -8), INT8_C(   3)) },
    { simde_mm256_set_epi8(INT8_C( -90), INT8_C( -41), INT8_C(-125), INT8_C(  28),
                           INT8_C( -59), INT8_C( -49), INT8_C(  55), INT8_C(-108),
                           INT8_C( 114), INT8_C(-122), INT8_C(   4), INT8_C(-102),
                           INT8_C(  92), INT8_C( -39), INT8_C( -84), INT8_C( 119),
                           INT8_C( -87), INT8_C(   8), INT8_C(-125), INT8_C( -67),
                           INT8_C(  61), INT8_C(  70), INT8_C( -88), INT8_C(  46),
                           INT8_C(  -8), INT8_C( -33), INT8_C(   3), INT8_C( -52),
                           INT8_C( -90), INT8_C( 122), INT8_C(  12), INT8_C( -37)),
      simde_mm256_set_epi8(INT8_C(  27), INT8_C(-128), INT8_C( -93), INT8_C( -38),
                           INT8_C( 107), INT8_C(  58), INT8_C(  66), INT8_C( -13),
                           INT8_C( 126), INT8_C( 106), INT8_C(  57), INT8_C( -95),
                           INT8_C(-110), INT8_C(  38), INT8_C( -48), INT8_C(-109),
                           INT8_C(  83), INT8_C( -82), INT8_C(-119), INT8_C(  15),
                           INT8_C( 122), INT8_C(  -6), INT8_C( -15), INT8_C(  81),
                           INT8_C( -79), INT8_C( -92), INT8_C(   8), INT8_C(  40),
                           INT8_C(  33), INT8_C(  96), INT8_C(-114), INT8_C(-116)),
      simde_mm256_set_epi8(INT8_C(-117), INT8_C(  87), INT8_C( -32), INT8_C(  66),
                           INT8_C(-128), INT8_C(-107), INT8_C( -11), INT8_C( -95),
                           INT8_C( -12), INT8_C(-128), INT8_C( -53), INT8_C(  -7),
                           INT8_C( 127), INT8_C( -77), INT8_C( -36), INT8_C( 127),
                           INT8_C(-128), INT8_C(  90), INT8_C(  -6), INT8_C( -82),
                           INT8_C( -61), INT8_C(  76), INT8_C( -73), INT8_C( -35),
                           INT8_C(  71), INT8_C(  59), INT8_C(  -5), INT8_C( -92),
                           INT8_C(-123), INT8_C(  26), INT8_C( 126), INT8_C(  79)) },
    { simde_mm256_set_epi8(INT8_C( -33), INT8_C(  57), INT8_C(  32), INT8_C(  63),
                           INT8_C(  13), INT8_C(   3), INT8_C(-124), INT8_C(-110),
                           INT8_C(-104), INT8_C(  -9), INT8_C( -20), INT8_C( 115),
                           INT8_C(-123), INT8_C(-119), INT8_C( -41), INT8_C(-125),
                           INT8_C( 125), INT8_C( -55), INT8_C( 104), INT8_C( 103),
                           INT8_C(  40), INT8_C(   8), INT8_C(-109), INT8_C(  96),
                           INT8_C( 126), INT8_C(  21), INT8_C( -61), INT8_C(  85),
                           INT8_C( 120), INT8_C( 127), INT8_C(  54), INT8_C(  72)),
      simde_mm256_set_epi8(INT8_C(   8), INT8_C( -54), INT8_C( -21), INT8_C(  62),
                           INT8_C( -44), INT8_C( -59), INT8_C(   7), INT8_C(  68),
                           INT8_C( 127), INT8_C(  -4), INT8_C( 119), INT8_C(  63),
                           INT8_C( -49), INT8_C(  31), INT8_C(  25), INT8_C( -33),
                           INT8_C(  45), INT8_C(   7), INT8_C(   0), INT8_C(  88),
                           INT8_C(  47), INT8_C( -92), INT8_C( -21), INT8_C( 118),
                           INT8_C( -41), INT8_C(  85), INT8_C(  93), INT8_C(  38),
                           INT8_C(  60), INT8_C(  59), INT8_C( -96), INT8_C( -40)),
      simde_mm256_set_epi8(INT8_C( -41), INT8_C( 111), INT8_C(  53), INT8_C(   1),
                           INT8_C(  57), INT8_C(  62), INT8_C(-128), INT8_C(-128),
                           INT8_C(-128), INT8_C(  -5), INT8_C(-128), INT8_C(  52),
                           INT8_C( -74), INT8_C(-128), INT8_C( -66), INT8_C( -92),
                           INT8_C(  80), INT8_C( -62), INT8_C( 104), INT8_C(  15),
                           INT8_C(  -7), INT8_C( 100), INT8_C( -88), INT8_C( -22),
                           INT8_C( 127), INT8_C( -64), INT8_C(-128), INT8_C(  47),
                           INT8_C(  60), INT8_C(  68), INT8_C( 127), INT8_C( 112)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_subs_epi8(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_subs_epi16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi16(INT16_C( 13590), INT16_C(-25178), INT16_C( 10836), INT16_C(  6204),
                            INT16_C(-31188), INT16_C(-20901), INT16_C(-14955), INT16_C(-18273),
                            INT16_C(-29119), INT16_C(-17708), INT16_C( -8621), INT16_C(  7683),
                            INT16_C(  4418), INT16_C( 23604), INT16_C(-14242), INT16_C( 30558)),
      simde_mm256_set_epi16(INT16_C( 14579), INT16_C(-18403), INT16_C(  9269), INT16_C( 14176),
                            INT16_C(  5756), INT16_C( 14147), INT16_C( 27129), INT16_C( 10735),
                            INT16_C(  7185), INT16_C( -3770), INT16_C(  4058), INT16_C( 23917),
                            INT16_C( 19859), INT16_C(  2362), INT16_C(-14328), INT16_C( 23720)),
      simde_mm256_set_epi16(INT16_C(  -989), INT16_C( -6775), INT16_C(  1567), INT16_C( -7972),
                            INT16_C(-32768), INT16_C(-32768), INT16_C(-32768), INT16_C(-29008),
                            INT16_C(-32768), INT16_C(-13938), INT16_C(-12679), INT16_C(-16234),
                            INT16_C(-15441), INT16_C( 21242), INT16_C(    86), INT16_C(  6838)) },
    { simde_mm256_set_epi16(INT16_C(-23578), INT16_C(    17), INT16_C(-30659), INT16_C(-26009),
                            INT16_C( 20431), INT16_C(-18385), INT16_C( 28342), INT16_C(-14293),
                            INT16_C( 23909), INT16_C(  1480), INT16_C(-22252), INT16_C(-29032),
                            INT16_C(-30389), INT16_C(-31768), INT16_C(-11813), INT16_C(-18767)),
      simde_mm256_set_epi16(INT16_C(  7509), INT16_C( 24571), INT16_C(  -655), INT16_C( 11682),
                            INT16_C(-23907), INT16_C( 21862), INT16_C( 24396), INT16_C( -8767),
                            INT16_C(  5364), INT16_C(  3732), INT16_C(  -580), INT16_C( 23130),
                            INT16_C(  9999), INT16_C(  8875), INT16_C(-29297), INT16_C(-12759)),
      simde_mm256_set_epi16(INT16_C(-31087), INT16_C(-24554), INT16_C(-30004), INT16_C(-32768),
                            INT16_C( 32767), INT16_C(-32768), INT16_C(  3946), INT16_C( -5526),
                            INT16_C( 18545), INT16_C( -2252), INT16_C(-21672), INT16_C(-32768),
                            INT16_C(-32768), INT16_C(-32768), INT16_C( 17484), INT16_C( -6008)) },
    { simde_mm256_set_epi16(INT16_C(-30203), INT16_C(-31016), INT16_C(-24256), INT16_C( 14480),
                            INT16_C(-17703), INT16_C( 21081), INT16_C( -6192), INT16_C(  1609),
                            INT16_C( -6311), INT16_C( 11736), INT16_C(  2034), INT16_C( 26405),
                            INT16_C(-12997), INT16_C( -7652), INT16_C(  -611), INT16_C( 22310)),
      simde_mm256_set_epi16(INT16_C( -2277), INT16_C( -3711), INT16_C(-27450), INT16_C(-24632),
                            INT16_C( 20445), INT16_C(-18154), INT16_C(-15993), INT16_C( -5565),
                            INT16_C( 22744), INT16_C( -8412), INT16_C( -4517), INT16_C( 30513),
                            INT16_C(  8328), INT16_C(-26208), INT16_C( 19292), INT16_C( 12008)),
      simde_mm256_set_epi16(INT16_C(-27926), INT16_C(-27305), INT16_C(  3194), INT16_C( 32767),
                            INT16_C(-32768), INT16_C( 32767), INT16_C(  9801), INT16_C(  7174),
                            INT16_C(-29055), INT16_C( 20148), INT16_C(  6551), INT16_C( -4108),
                            INT16_C(-21325), INT16_C( 18556), INT16_C(-19903), INT16_C( 10302)) },
    { simde_mm256_set_epi16(INT16_C( 11347), INT16_C( -8183), INT16_C(-17573), INT16_C(-15568),
                            INT16_C(-11144), INT16_C( 30427), INT16_C(-28446), INT16_C( 21580),
                            INT16_C(-19853), INT16_C(-15884), INT16_C( -6283), INT16_C(  6106),
                            INT16_C(  -735), INT16_C( 21481), INT16_C( -8667), INT16_C(-21559)),
      simde_mm256_set_epi16(INT16_C( 22679), INT16_C(-23024), INT16_C(-29506), INT16_C( 31352),
                            INT16_C( -9917), INT16_C( 31850), INT16_C(-10444), INT16_C( -3350),
                            INT16_C(-29787), INT16_C( 26886), INT16_C(-25580), INT16_C(-13975),
                            INT16_C(-10979), INT16_C(  8622), INT16_C(-32215), INT16_C( 10740)),
      simde_mm256_set_epi16(INT16_C(-11332), INT16_C( 14841), INT16_C( 11933), INT16_C(-32768),
                            INT16_C( -1227), INT16_C( -1423), INT16_C(-18002), INT16_C( 24930),
                            INT16_C(  9934), INT16_C(-32768), INT16_C( 19297), INT16_C( 20081),
                            INT16_C( 10244), INT16_C( 12859), INT16_C( 23548), INT16_C(-32299)) },
    { simde_mm256_set_epi16(INT16_C( 17901), INT16_C(-23347), INT16_C( 26644), INT16_C(  5597),
                            INT16_C(-19266), INT16_C(  9531), INT16_C( 15516), INT16_C(  4989),
                            INT16_C( 16224), INT16_C( -5067), INT16_C( 31091), INT16_C( -9121),
                            INT16_C( 15971), INT16_C(-15436), INT16_C( 14085), INT16_C(-23571)),
      simde_mm256_set_epi16(INT16_C(-27365), INT16_C( 28350), INT16_C(-27545), INT16_C(-16032),
                            INT16_C( 10459), INT16_C(  1256), INT16_C( -8145), INT16_C( 21448),
                            INT16_C( -1149), INT16_C(  2284), INT16_C(-23313), INT16_C(-19305),
                            INT16_C( -9718), INT16_C(  7087), INT16_C( 23644), INT16_C( 11932)),
      simde_mm256_set_epi16(INT16_C( 32767), INT16_C(-32768), INT16_C( 32767), INT16_C( 21629),
                            INT16_C(-29725), INT16_C(  8275), INT16_C( 23661), INT16_C(-16459),
                            INT16_C( 17373), INT16_C( -7351), INT16_C( 32767), INT16_C( 10184),
                            INT16_C( 25689), INT16_C(-22523), INT16_C( -9559), INT16_C(-32768)) },
    { simde_mm256_set_epi16(INT16_C(-12725), INT16_C( -3530), INT16_C( 11184), INT16_C(-31897),
                            INT16_C( 20735), INT16_C(-14861), INT16_C(-28398), INT16_C(-23436),
                            INT16_C(  3231), INT16_C(-21331), INT16_C(-15489), INT16_C( 26258),
                            INT16_C(   347), INT16_C(-18964), INT16_C(-14672), INT16_C( 25953)),
      simde_mm256_set_epi16(INT16_C(  4049), INT16_C( 16424), INT16_C(  5632), INT16_C(-23746),
                            INT16_C(-13985), INT16_C(-11355), INT16_C( 11362), INT16_C( -9279),
                            INT16_C(-16293), INT16_C(-30172), INT16_C(-29124), INT16_C( 11250),
                            INT16_C( -2133), INT16_C(-12899), INT16_C(-30647), INT16_C( 27998)),
      simde_mm256_set_epi16(INT16_C(-16774), INT16_C(-19954), INT16_C(  5552), INT16_C( -8151),
                            INT16_C( 32767), INT16_C( -3506), INT16_C(-32768), INT16_C(-14157),
                            INT16_C( 19524), INT16_C(  8841), INT16_C( 13635), INT16_C( 15008),
                            INT16_C(  2480), INT16_C( -6065), INT16_C( 15975), INT16_C( -2045)) },
    { simde_mm256_set_epi16(INT16_C(-22825), INT16_C(-31972), INT16_C(-14897), INT16_C( 14228),
                            INT16_C( 29318), INT16_C(  1178), INT16_C( 23769), INT16_C(-21385),
                            INT16_C(-22264), INT16_C(-31811), INT16_C( 15686), INT16_C(-22482),
                            INT16_C( -1825), INT16_C(   972), INT16_C(-22918), INT16_C(  3291)),
      simde_mm256_set_epi16(INT16_C(  7040), INT16_C(-23590), INT16_C( 27450), INT16_C( 17139),
                            INT16_C( 32362), INT16_C( 14753), INT16_C(-28122), INT16_C(-12141),
                            INT16_C( 21422), INT16_C(-30449), INT16_C( 31482), INT16_C( -3759),
                            INT16_C(-20060), INT16_C(  2088), INT16_C(  8544), INT16_C(-29044)),
      simde_mm256_set_epi16(INT16_C(-29865), INT16_C( -8382), INT16_C(-32768), INT16_C( -2911),
                            INT16_C( -3044), INT16_C(-13575), INT16_C( 32767), INT16_C( -9244),
                            INT16_C(-32768), INT16_C( -1362), INT16_C(-15796), INT16_C(-18723),
                            INT16_C( 18235), INT16_C( -1116), INT16_C(-31462), INT16_C( 32335)) },
    { simde_mm256_set_epi16(INT16_C( -8391), INT16_C(  8255), INT16_C(  3331), INT16_C(-31598),
                            INT16_C(-26377), INT16_C( -5005), INT16_C(-31351), INT16_C(-10365),
                            INT16_C( 32201), INT16_C( 26727), INT16_C( 10248), INT16_C(-27808),
                            INT16_C( 32277), INT16_C(-15531), INT16_C( 30847), INT16_C( 13896)),
      simde_mm256_set_epi16(INT16_C(  2250), INT16_C( -5314), INT16_C(-11067), INT16_C(  1860),
                            INT16_C( 32764), INT16_C( 30527), INT16_C(-12513), INT16_C(  6623),
                            INT16_C( 11527), INT16_C(    88), INT16_C( 12196), INT16_C( -5258),
                            INT16_C(-10411), INT16_C( 23846), INT16_C( 15419), INT16_C(-24360)),
      simde_mm256_set_epi16(INT16_C(-10641), INT16_C( 13569), INT16_C( 14398), INT16_C(-32768),
                            INT16_C(-32768), INT16_C(-32768), INT16_C(-18838), INT16_C(-16988),
                            INT16_C( 20674), INT16_C( 26639), INT16_C( -1948), INT16_C(-22550),
                            INT16_C( 32767), INT16_C(-32768), INT16_C( 15428), INT16_C( 32767)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_subs_epi16(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_subs_epu8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_x_mm256_set_epu8(UINT8_C( 53), UINT8_C( 22), UINT8_C(157), UINT8_C(166),
                             UINT8_C( 42), UINT8_C( 84), UINT8_C( 24), UINT8_C( 60),
                             UINT8_C(134), UINT8_C( 44), UINT8_C(174), UINT8_C( 91),
                             UINT8_C(197), UINT8_C(149), UINT8_C(184), UINT8_C(159),
                             UINT8_C(142), UINT8_C( 65), UINT8_C(186), UINT8_C(212),
                             UINT8_C(222), UINT8_C( 83), UINT8_C( 30), UINT8_C(  3),
                             UINT8_C( 17), UINT8_C( 66), UINT8_C( 92), UINT8_C( 52),
                             UINT8_C(200), UINT8_C( 94), UINT8_C(119), UINT8_C( 94)),
      simde_x_mm256_set_epu8(UINT8_C( 56), UINT8_C(243), UINT8_C(184), UINT8_C( 29),
                             UINT8_C( 36), UINT8_C( 53), UINT8_C( 55), UINT8_C( 96),
                             UINT8_C( 22), UINT8_C(124), UINT8_C( 55), UINT8_C( 67),
                             UINT8_C(105), UINT8_C(249), UINT8_C( 41), UINT8_C(239),
                             UINT8_C( 28), UINT8_C( 17), UINT8_C(241), UINT8_C( 70),
                             UINT8_C( 15), UINT8_C(218), UINT8_C( 93), UINT8_C(109),
                             UINT8_C( 77), UINT8_C(147), UINT8_C(  9), UINT8_C( 58),
                             UINT8_C(200), UINT8_C(  8), UINT8_C( 92), UINT8_C(168)),
      simde_x_mm256_set_epu8(UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(137),
                             UINT8_C(  6), UINT8_C( 31), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(112), UINT8_C(  0), UINT8_C(119), UINT8_C( 24),
                             UINT8_C( 92), UINT8_C(  0), UINT8_C(143), UINT8_C(  0),
                             UINT8_C(114), UINT8_C( 48), UINT8_C(  0), UINT8_C(142),
                             UINT8_C(207), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C( 83), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 86), UINT8_C( 27), UINT8_C(  0)) },
    { simde_x_mm256_set_epu8(UINT8_C(163), UINT8_C(230), UINT8_C(  0), UINT8_C( 17),
                             UINT8_C(136), UINT8_C( 61), UINT8_C(154), UINT8_C(103),
                             UINT8_C( 79), UINT8_C(207), UINT8_C(184), UINT8_C( 47),
                             UINT8_C(110), UINT8_C(182), UINT8_C(200), UINT8_C( 43),
                             UINT8_C( 93), UINT8_C(101), UINT8_C(  5), UINT8_C(200),
                             UINT8_C(169), UINT8_C( 20), UINT8_C(142), UINT8_C(152),
                             UINT8_C(137), UINT8_C( 75), UINT8_C(131), UINT8_C(232),
                             UINT8_C(209), UINT8_C(219), UINT8_C(182), UINT8_C(177)),
      simde_x_mm256_set_epu8(UINT8_C( 29), UINT8_C( 85), UINT8_C( 95), UINT8_C(251),
                             UINT8_C(253), UINT8_C(113), UINT8_C( 45), UINT8_C(162),
                             UINT8_C(162), UINT8_C(157), UINT8_C( 85), UINT8_C(102),
                             UINT8_C( 95), UINT8_C( 76), UINT8_C(221), UINT8_C(193),
                             UINT8_C( 20), UINT8_C(244), UINT8_C( 14), UINT8_C(148),
                             UINT8_C(253), UINT8_C(188), UINT8_C( 90), UINT8_C( 90),
                             UINT8_C( 39), UINT8_C( 15), UINT8_C( 34), UINT8_C(171),
                             UINT8_C(141), UINT8_C(143), UINT8_C(206), UINT8_C( 41)),
      simde_x_mm256_set_epu8(UINT8_C(134), UINT8_C(145), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(109), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 50), UINT8_C( 99), UINT8_C(  0),
                             UINT8_C( 15), UINT8_C(106), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C( 73), UINT8_C(  0), UINT8_C(  0), UINT8_C( 52),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C( 52), UINT8_C( 62),
                             UINT8_C( 98), UINT8_C( 60), UINT8_C( 97), UINT8_C( 61),
                             UINT8_C( 68), UINT8_C( 76), UINT8_C(  0), UINT8_C(136)) },
    { simde_x_mm256_set_epu8(UINT8_C(138), UINT8_C(  5), UINT8_C(134), UINT8_C(216),
                             UINT8_C(161), UINT8_C( 64), UINT8_C( 56), UINT8_C(144),
                             UINT8_C(186), UINT8_C(217), UINT8_C( 82), UINT8_C( 89),
                             UINT8_C(231), UINT8_C(208), UINT8_C(  6), UINT8_C( 73),
                             UINT8_C(231), UINT8_C( 89), UINT8_C( 45), UINT8_C(216),
                             UINT8_C(  7), UINT8_C(242), UINT8_C(103), UINT8_C( 37),
                             UINT8_C(205), UINT8_C( 59), UINT8_C(226), UINT8_C( 28),
                             UINT8_C(253), UINT8_C(157), UINT8_C( 87), UINT8_C( 38)),
      simde_x_mm256_set_epu8(UINT8_C(247), UINT8_C( 27), UINT8_C(241), UINT8_C(129),
                             UINT8_C(148), UINT8_C(198), UINT8_C(159), UINT8_C(200),
                             UINT8_C( 79), UINT8_C(221), UINT8_C(185), UINT8_C( 22),
                             UINT8_C(193), UINT8_C(135), UINT8_C(234), UINT8_C( 67),
                             UINT8_C( 88), UINT8_C(216), UINT8_C(223), UINT8_C( 36),
                             UINT8_C(238), UINT8_C( 91), UINT8_C(119), UINT8_C( 49),
                             UINT8_C( 32), UINT8_C(136), UINT8_C(153), UINT8_C(160),
                             UINT8_C( 75), UINT8_C( 92), UINT8_C( 46), UINT8_C(232)),
      simde_x_mm256_set_epu8(UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C( 87),
                             UINT8_C( 13), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(107), UINT8_C(  0), UINT8_C(  0), UINT8_C( 67),
                             UINT8_C( 38), UINT8_C( 73), UINT8_C(  0), UINT8_C(  6),
                             UINT8_C(143), UINT8_C(  0), UINT8_C(  0), UINT8_C(180),
                             UINT8_C(  0), UINT8_C(151), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(173), UINT8_C(  0), UINT8_C( 73), UINT8_C(  0),
                             UINT8_C(178), UINT8_C( 65), UINT8_C( 41), UINT8_C(  0)) },
    { simde_x_mm256_set_epu8(UINT8_C( 44), UINT8_C( 83), UINT8_C(224), UINT8_C(  9),
                             UINT8_C(187), UINT8_C( 91), UINT8_C(195), UINT8_C( 48),
                             UINT8_C(212), UINT8_C(120), UINT8_C(118), UINT8_C(219),
                             UINT8_C(144), UINT8_C(226), UINT8_C( 84), UINT8_C( 76),
                             UINT8_C(178), UINT8_C(115), UINT8_C(193), UINT8_C(244),
                             UINT8_C(231), UINT8_C(117), UINT8_C( 23), UINT8_C(218),
                             UINT8_C(253), UINT8_C( 33), UINT8_C( 83), UINT8_C(233),
                             UINT8_C(222), UINT8_C( 37), UINT8_C(171), UINT8_C(201)),
      simde_x_mm256_set_epu8(UINT8_C( 88), UINT8_C(151), UINT8_C(166), UINT8_C( 16),
                             UINT8_C(140), UINT8_C(190), UINT8_C(122), UINT8_C(120),
                             UINT8_C(217), UINT8_C( 67), UINT8_C(124), UINT8_C(106),
                             UINT8_C(215), UINT8_C( 52), UINT8_C(242), UINT8_C(234),
                             UINT8_C(139), UINT8_C(165), UINT8_C(105), UINT8_C(  6),
                             UINT8_C(156), UINT8_C( 20), UINT8_C(201), UINT8_C(105),
                             UINT8_C(213), UINT8_C( 29), UINT8_C( 33), UINT8_C(174),
                             UINT8_C(130), UINT8_C( 41), UINT8_C( 41), UINT8_C(244)),
      simde_x_mm256_set_epu8(UINT8_C(  0), UINT8_C(  0), UINT8_C( 58), UINT8_C(  0),
                             UINT8_C( 47), UINT8_C(  0), UINT8_C( 73), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 53), UINT8_C(  0), UINT8_C(113),
                             UINT8_C(  0), UINT8_C(174), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C( 39), UINT8_C(  0), UINT8_C( 88), UINT8_C(238),
                             UINT8_C( 75), UINT8_C( 97), UINT8_C(  0), UINT8_C(113),
                             UINT8_C( 40), UINT8_C(  4), UINT8_C( 50), UINT8_C( 59),
                             UINT8_C( 92), UINT8_C(  0), UINT8_C(130), UINT8_C(  0)) },
    { simde_x_mm256_set_epu8(UINT8_C( 69), UINT8_C(237), UINT8_C(164), UINT8_C(205),
                             UINT8_C(104), UINT8_C( 20), UINT8_C( 21), UINT8_C(221),
                             UINT8_C(180), UINT8_C(190), UINT8_C( 37), UINT8_C( 59),
                             UINT8_C( 60), UINT8_C(156), UINT8_C( 19), UINT8_C(125),
                             UINT8_C( 63), UINT8_C( 96), UINT8_C(236), UINT8_C( 53),
                             UINT8_C(121), UINT8_C(115), UINT8_C(220), UINT8_C( 95),
                             UINT8_C( 62), UINT8_C( 99), UINT8_C(195), UINT8_C(180),
                             UINT8_C( 55), UINT8_C(  5), UINT8_C(163), UINT8_C(237)),
      simde_x_mm256_set_epu8(UINT8_C(149), UINT8_C( 27), UINT8_C(110), UINT8_C(190),
                             UINT8_C(148), UINT8_C(103), UINT8_C(193), UINT8_C( 96),
                             UINT8_C( 40), UINT8_C(219), UINT8_C(  4), UINT8_C(232),
                             UINT8_C(224), UINT8_C( 47), UINT8_C( 83), UINT8_C(200),
                             UINT8_C(251), UINT8_C(131), UINT8_C(  8), UINT8_C(236),
                             UINT8_C(164), UINT8_C(239), UINT8_C(180), UINT8_C(151),
                             UINT8_C(218), UINT8_C( 10), UINT8_C( 27), UINT8_C(175),
                             UINT8_C( 92), UINT8_C( 92), UINT8_C( 46), UINT8_C(156)),
      simde_x_mm256_set_epu8(UINT8_C(  0), UINT8_C(210), UINT8_C( 54), UINT8_C( 15),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(125),
                             UINT8_C(140), UINT8_C(  0), UINT8_C( 33), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(109), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(228), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C( 40), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 89), UINT8_C(168), UINT8_C(  5),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(117), UINT8_C( 81)) },
    { simde_x_mm256_set_epu8(UINT8_C(206), UINT8_C( 75), UINT8_C(242), UINT8_C( 54),
                             UINT8_C( 43), UINT8_C(176), UINT8_C(131), UINT8_C(103),
                             UINT8_C( 80), UINT8_C(255), UINT8_C(197), UINT8_C(243),
                             UINT8_C(145), UINT8_C( 18), UINT8_C(164), UINT8_C(116),
                             UINT8_C( 12), UINT8_C(159), UINT8_C(172), UINT8_C(173),
                             UINT8_C(195), UINT8_C(127), UINT8_C(102), UINT8_C(146),
                             UINT8_C(  1), UINT8_C( 91), UINT8_C(181), UINT8_C(236),
                             UINT8_C(198), UINT8_C(176), UINT8_C(101), UINT8_C( 97)),
      simde_x_mm256_set_epu8(UINT8_C( 15), UINT8_C(209), UINT8_C( 64), UINT8_C( 40),
                             UINT8_C( 22), UINT8_C(  0), UINT8_C(163), UINT8_C( 62),
                             UINT8_C(201), UINT8_C( 95), UINT8_C(211), UINT8_C(165),
                             UINT8_C( 44), UINT8_C( 98), UINT8_C(219), UINT8_C(193),
                             UINT8_C(192), UINT8_C( 91), UINT8_C(138), UINT8_C( 36),
                             UINT8_C(142), UINT8_C( 60), UINT8_C( 43), UINT8_C(242),
                             UINT8_C(247), UINT8_C(171), UINT8_C(205), UINT8_C(157),
                             UINT8_C(136), UINT8_C( 73), UINT8_C(109), UINT8_C( 94)),
      simde_x_mm256_set_epu8(UINT8_C(191), UINT8_C(  0), UINT8_C(178), UINT8_C( 14),
                             UINT8_C( 21), UINT8_C(176), UINT8_C(  0), UINT8_C( 41),
                             UINT8_C(  0), UINT8_C(160), UINT8_C(  0), UINT8_C( 78),
                             UINT8_C(101), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 68), UINT8_C( 34), UINT8_C(137),
                             UINT8_C( 53), UINT8_C( 67), UINT8_C( 59), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C( 79),
                             UINT8_C( 62), UINT8_C(103), UINT8_C(  0), UINT8_C(  3)) },
    { simde_x_mm256_set_epu8(UINT8_C(166), UINT8_C(215), UINT8_C(131), UINT8_C( 28),
                             UINT8_C(197), UINT8_C(207), UINT8_C( 55), UINT8_C(148),
                             UINT8_C(114), UINT8_C(134), UINT8_C(  4), UINT8_C(154),
                             UINT8_C( 92), UINT8_C(217), UINT8_C(172), UINT8_C(119),
                             UINT8_C(169), UINT8_C(  8), UINT8_C(131), UINT8_C(189),
                             UINT8_C( 61), UINT8_C( 70), UINT8_C(168), UINT8_C( 46),
                             UINT8_C(248), UINT8_C(223), UINT8_C(  3), UINT8_C(204),
                             UINT8_C(166), UINT8_C(122), UINT8_C( 12), UINT8_C(219)),
      simde_x_mm256_set_epu8(UINT8_C( 27), UINT8_C(128), UINT8_C(163), UINT8_C(218),
                             UINT8_C(107), UINT8_C( 58), UINT8_C( 66), UINT8_C(243),
                             UINT8_C(126), UINT8_C(106), UINT8_C( 57), UINT8_C(161),
                             UINT8_C(146), UINT8_C( 38), UINT8_C(208), UINT8_C(147),
                             UINT8_C( 83), UINT8_C(174), UINT8_C(137), UINT8_C( 15),
                             UINT8_C(122), UINT8_C(250), UINT8_C(241), UINT8_C( 81),
                             UINT8_C(177), UINT8_C(164), UINT8_C(  8), UINT8_C( 40),
                             UINT8_C( 33), UINT8_C( 96), UINT8_C(142), UINT8_C(140)),
      simde_x_mm256_set_epu8(UINT8_C(139), UINT8_C( 87), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C( 90), UINT8_C(149), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C( 28), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(179), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C( 86), UINT8_C(  0), UINT8_C(  0), UINT8_C(174),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C( 71), UINT8_C( 59), UINT8_C(  0), UINT8_C(164),
                             UINT8_C(133), UINT8_C( 26), UINT8_C(  0), UINT8_C( 79)) },
    { simde_x_mm256_set_epu8(UINT8_C(223), UINT8_C( 57), UINT8_C( 32), UINT8_C( 63),
                             UINT8_C( 13), UINT8_C(  3), UINT8_C(132), UINT8_C(146),
                             UINT8_C(152), UINT8_C(247), UINT8_C(236), UINT8_C(115),
                             UINT8_C(133), UINT8_C(137), UINT8_C(215), UINT8_C(131),
                             UINT8_C(125), UINT8_C(201), UINT8_C(104), UINT8_C(103),
                             UINT8_C( 40), UINT8_C(  8), UINT8_C(147), UINT8_C( 96),
                             UINT8_C(126), UINT8_C( 21), UINT8_C(195), UINT8_C( 85),
                             UINT8_C(120), UINT8_C(127), UINT8_C( 54), UINT8_C( 72)),
      simde_x_mm256_set_epu8(UINT8_C(  8), UINT8_C(202), UINT8_C(235), UINT8_C( 62),
                             UINT8_C(212), UINT8_C(197), UINT8_C(  7), UINT8_C( 68),
                             UINT8_C(127), UINT8_C(252), UINT8_C(119), UINT8_C( 63),
                             UINT8_C(207), UINT8_C( 31), UINT8_C( 25), UINT8_C(223),
                             UINT8_C( 45), UINT8_C(  7), UINT8_C(  0), UINT8_C( 88),
                             UINT8_C( 47), UINT8_C(164), UINT8_C(235), UINT8_C(118),
                             UINT8_C(215), UINT8_C( 85), UINT8_C( 93), UINT8_C( 38),
                             UINT8_C( 60), UINT8_C( 59), UINT8_C(160), UINT8_C(216)),
      simde_x_mm256_set_epu8(UINT8_C(215), UINT8_C(  0), UINT8_C(  0), UINT8_C(  1),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(125), UINT8_C( 78),
                             UINT8_C( 25), UINT8_C(  0), UINT8_C(117), UINT8_C( 52),
                             UINT8_C(  0), UINT8_C(106), UINT8_C(190), UINT8_C(  0),
                             UINT8_C( 80), UINT8_C(194), UINT8_C(104), UINT8_C( 15),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(  0), UINT8_C(  0),
                             UINT8_C(  0), UINT8_C(  0), UINT8_C(102), UINT8_C( 47),
                             UINT8_C( 60), UINT8_C( 68), UINT8_C(  0), UINT8_C(  0)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_subs_epu8(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_u8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_subs_epu16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_x_mm256_set_epu16(UINT16_C( 13590), UINT16_C( 40358), UINT16_C( 10836), UINT16_C(  6204),
                              UINT16_C( 34348), UINT16_C( 44635), UINT16_C( 50581), UINT16_C( 47263),
                              UINT16_C( 36417), UINT16_C( 47828), UINT16_C( 56915), UINT16_C(  7683),
                              UINT16_C(  4418), UINT16_C( 23604), UINT16_C( 51294), UINT16_C( 30558)),
      simde_x_mm256_set_epu16(UINT16_C( 14579), UINT16_C( 47133), UINT16_C(  9269), UINT16_C( 14176),
                              UINT16_C(  5756), UINT16_C( 14147), UINT16_C( 27129), UINT16_C( 10735),
                              UINT16_C(  7185), UINT16_C( 61766), UINT16_C(  4058), UINT16_C( 23917),
                              UINT16_C( 19859), UINT16_C(  2362), UINT16_C( 51208), UINT16_C( 23720)),
      simde_x_mm256_set_epu16(UINT16_C(     0), UINT16_C(     0), UINT16_C(  1567), UINT16_C(     0),
                              UINT16_C( 28592), UINT16_C( 30488), UINT16_C( 23452), UINT16_C( 36528),
                              UINT16_C( 29232), UINT16_C(     0), UINT16_C( 52857), UINT16_C(     0),
                              UINT16_C(     0), UINT16_C( 21242), UINT16_C(    86), UINT16_C(  6838)) },
    { simde_x_mm256_set_epu16(UINT16_C( 41958), UINT16_C(    17), UINT16_C( 34877), UINT16_C( 39527),
                              UINT16_C( 20431), UINT16_C( 47151), UINT16_C( 28342), UINT16_C( 51243),
                              UINT16_C( 23909), UINT16_C(  1480), UINT16_C( 43284), UINT16_C( 36504),
                              UINT16_C( 35147), UINT16_C( 33768), UINT16_C( 53723), UINT16_C( 46769)),
      simde_x_mm256_set_epu16(UINT16_C(  7509), UINT16_C( 24571), UINT16_C( 64881), UINT16_C( 11682),
                              UINT16_C( 41629), UINT16_C( 21862), UINT16_C( 24396), UINT16_C( 56769),
                              UINT16_C(  5364), UINT16_C(  3732), UINT16_C( 64956), UINT16_C( 23130),
                              UINT16_C(  9999), UINT16_C(  8875), UINT16_C( 36239), UINT16_C( 52777)),
      simde_x_mm256_set_epu16(UINT16_C( 34449), UINT16_C(     0), UINT16_C(     0), UINT16_C( 27845),
                              UINT16_C(     0), UINT16_C( 25289), UINT16_C(  3946), UINT16_C(     0),
                              UINT16_C( 18545), UINT16_C(     0), UINT16_C(     0), UINT16_C( 13374),
                              UINT16_C( 25148), UINT16_C( 24893), UINT16_C( 17484), UINT16_C(     0)) },
    { simde_x_mm256_set_epu16(UINT16_C( 35333), UINT16_C( 34520), UINT16_C( 41280), UINT16_C( 14480),
                              UINT16_C( 47833), UINT16_C( 21081), UINT16_C( 59344), UINT16_C(  1609),
                              UINT16_C( 59225), UINT16_C( 11736), UINT16_C(  2034), UINT16_C( 26405),
                              UINT16_C( 52539), UINT16_C( 57884), UINT16_C( 64925), UINT16_C( 22310)),
      simde_x_mm256_set_epu16(UINT16_C( 63259), UINT16_C( 61825), UINT16_C( 38086), UINT16_C( 40904),
                              UINT16_C( 20445), UINT16_C( 47382), UINT16_C( 49543), UINT16_C( 59971),
                              UINT16_C( 22744), UINT16_C( 57124), UINT16_C( 61019), UINT16_C( 30513),
                              UINT16_C(  8328), UINT16_C( 39328), UINT16_C( 19292), UINT16_C( 12008)),
      simde_x_mm256_set_epu16(UINT16_C(     0), UINT16_C(     0), UINT16_C(  3194), UINT16_C(     0),
                              UINT16_C( 27388), UINT16_C(     0), UINT16_C(  9801), UINT16_C(     0),
                              UINT16_C( 36481), UINT16_C(     0), UINT16_C(     0), UINT16_C(     0),
                              UINT16_C( 44211), UINT16_C( 18556), UINT16_C( 45633), UINT16_C( 10302)) },
    { simde_x_mm256_set_epu16(UINT16_C( 11347), UINT16_C( 57353), UINT16_C( 47963), UINT16_C( 49968),
                              UINT16_C( 54392), UINT16_C( 30427), UINT16_C( 37090), UINT16_C( 21580),
                              UINT16_C( 45683), UINT16_C( 49652), UINT16_C( 59253), UINT16_C(  6106),
                              UINT16_C( 64801), UINT16_C( 21481), UINT16_C( 56869), UINT16_C( 43977)),
      simde_x_mm256_set_epu16(UINT16_C( 22679), UINT16_C( 42512), UINT16_C( 36030), UINT16_C( 31352),
                              UINT16_C( 55619), UINT16_C( 31850), UINT16_C( 55092), UINT16_C( 62186),
                              UINT16_C( 35749), UINT16_C( 26886), UINT16_C( 39956), UINT16_C( 51561),
                              UINT16_C( 54557), UINT16_C(  8622), UINT16_C( 33321), UINT16_C( 10740)),
      simde_x_mm256_set_epu16(UINT16_C(     0), UINT16_C( 14841), UINT16_C( 11933), UINT16_C( 18616),
                              UINT16_C(     0), UINT16_C(     0), UINT16_C(     0), UINT16_C(     0),
                              UINT16_C(  9934), UINT16_C( 22766), UINT16_C( 19297), UINT16_C(     0),
                              UINT16_C( 10244), UINT16_C( 12859), UINT16_C( 23548), UINT16_C( 33237)) },
    { simde_x_mm256_set_epu16(UINT16_C( 17901), UINT16_C( 42189), UINT16_C( 26644), UINT16_C(  5597),
                              UINT16_C( 46270), UINT16_C(  9531), UINT16_C( 15516), UINT16_C(  4989),
                              UINT16_C( 16224), UINT16_C( 60469), UINT16_C( 31091), UINT16_C( 56415),
                              UINT16_C( 15971), UINT16_C( 50100), UINT16_C( 14085), UINT16_C( 41965)),
      simde_x_mm256_set_epu16(UINT16_C( 38171), UINT16_C( 28350), UINT16_C( 37991), UINT16_C( 49504),
                              UINT16_C( 10459), UINT16_C(  1256), UINT16_C( 57391), UINT16_C( 21448),
                              UINT16_C( 64387), UINT16_C(  2284), UINT16_C( 42223), UINT16_C( 46231),
                              UINT16_C( 55818), UINT16_C(  7087), UINT16_C( 23644), UINT16_C( 11932)),
      simde_x_mm256_set_epu16(UINT16_C(     0), UINT16_C( 13839), UINT16_C(     0), UINT16_C(     0),
                              UINT16_C( 35811), UINT16_C(  8275), UINT16_C(     0), UINT16_C(     0),
                              UINT16_C(     0), UINT16_C( 58185), UINT16_C(     0), UINT16_C( 10184),
                              UINT16_C(     0), UINT16_C( 43013), UINT16_C(     0), UINT16_C( 30033)) },
    { simde_x_mm256_set_epu16(UINT16_C( 52811), UINT16_C( 62006), UINT16_C( 11184), UINT16_C( 33639),
                              UINT16_C( 20735), UINT16_C( 50675), UINT16_C( 37138), UINT16_C( 42100),
                              UINT16_C(  3231), UINT16_C( 44205), UINT16_C( 50047), UINT16_C( 26258),
                              UINT16_C(   347), UINT16_C( 46572), UINT16_C( 50864), UINT16_C( 25953)),
      simde_x_mm256_set_epu16(UINT16_C(  4049), UINT16_C( 16424), UINT16_C(  5632), UINT16_C( 41790),
                              UINT16_C( 51551), UINT16_C( 54181), UINT16_C( 11362), UINT16_C( 56257),
                              UINT16_C( 49243), UINT16_C( 35364), UINT16_C( 36412), UINT16_C( 11250),
                              UINT16_C( 63403), UINT16_C( 52637), UINT16_C( 34889), UINT16_C( 27998)),
      simde_x_mm256_set_epu16(UINT16_C( 48762), UINT16_C( 45582), UINT16_C(  5552), UINT16_C(     0),
                              UINT16_C(     0), UINT16_C(     0), UINT16_C( 25776), UINT16_C(     0),
                              UINT16_C(     0), UINT16_C(  8841), UINT16_C( 13635), UINT16_C( 15008),
                              UINT16_C(     0), UINT16_C(     0), UINT16_C( 15975), UINT16_C(     0)) },
    { simde_x_mm256_set_epu16(UINT16_C( 42711), UINT16_C( 33564), UINT16_C( 50639), UINT16_C( 14228),
                              UINT16_C( 29318), UINT16_C(  1178), UINT16_C( 23769), UINT16_C( 44151),
                              UINT16_C( 43272), UINT16_C( 33725), UINT16_C( 15686), UINT16_C( 43054),
                              UINT16_C( 63711), UINT16_C(   972), UINT16_C( 42618), UINT16_C(  3291)),
      simde_x_mm256_set_epu16(UINT16_C(  7040), UINT16_C( 41946), UINT16_C( 27450), UINT16_C( 17139),
                              UINT16_C( 32362), UINT16_C( 14753), UINT16_C( 37414), UINT16_C( 53395),
                              UINT16_C( 21422), UINT16_C( 35087), UINT16_C( 31482), UINT16_C( 61777),
                              UINT16_C( 45476), UINT16_C(  2088), UINT16_C(  8544), UINT16_C( 36492)),
      simde_x_mm256_set_epu16(UINT16_C( 35671), UINT16_C(     0), UINT16_C( 23189), UINT16_C(     0),
                              UINT16_C(     0), UINT16_C(     0), UINT16_C(     0), UINT16_C(     0),
                              UINT16_C( 21850), UINT16_C(     0), UINT16_C(     0), UINT16_C(     0),
                              UINT16_C( 18235), UINT16_C(     0), UINT16_C( 34074), UINT16_C(     0)) },
    { simde_x_mm256_set_epu16(UINT16_C( 57145), UINT16_C(  8255), UINT16_C(  3331), UINT16_C( 33938),
                              UINT16_C( 39159), UINT16_C( 60531), UINT16_C( 34185), UINT16_C( 55171),
                              UINT16_C( 32201), UINT16_C( 26727), UINT16_C( 10248), UINT16_C( 37728),
                              UINT16_C( 32277), UINT16_C( 50005), UINT16_C( 30847), UINT16_C( 13896)),
      simde_x_mm256_set_epu16(UINT16_C(  2250), UINT16_C( 60222), UINT16_C( 54469), UINT16_C(  1860),
                              UINT16_C( 32764), UINT16_C( 30527), UINT16_C( 53023), UINT16_C(  6623),
                              UINT16_C( 11527), UINT16_C(    88), UINT16_C( 12196), UINT16_C( 60278),
                              UINT16_C( 55125), UINT16_C( 23846), UINT16_C( 15419), UINT16_C( 41176)),
      simde_x_mm256_set_epu16(UINT16_C( 54895), UINT16_C(     0), UINT16_C(     0), UINT16_C( 32078),
                              UINT16_C(  6395), UINT16_C( 30004), UINT16_C(     0), UINT16_C( 48548),
                              UINT16_C( 20674), UINT16_C( 26639), UINT16_C(     0), UINT16_C(     0),
                              UINT16_C(     0), UINT16_C( 26159), UINT16_C( 15428), UINT16_C(     0)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_subs_epu16(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_u16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_unpacklo_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi8(INT8_C(-101), INT8_C(  92), INT8_C( -29), INT8_C( 114),
                           INT8_C(  -9), INT8_C( 115), INT8_C( -85), INT8_C(  76),
                           INT8_C( 113), INT8_C( 104), INT8_C(  13), INT8_C( 120),
                           INT8_C( -16), INT8_C( 113), INT8_C( -42), INT8_C( -27),
                           INT8_C(  62), INT8_C(-102), INT8_C(-110), INT8_C( 104),
                           INT8_C( -25), INT8_C( -66), INT8_C(  36), INT8_C( -49),
                           INT8_C(  43), INT8_C(   7), INT8_C(-118), INT8_C(  87),
                           INT8_C(-107), INT8_C(-121), INT8_C(-123), INT8_C( -99)),
      simde_mm256_set_epi8(INT8_C( -70), INT8_C(  56), INT8_C( 114), INT8_C(-120),
                           INT8_C(   3), INT8_C( -84), INT8_C( -87), INT8_C(-109),
                           INT8_C(  89), INT8_C(  30), INT8_C( 125), INT8_C(  67),
                           INT8_C(  97), INT8_C( -34), INT8_C( -11), INT8_C( -10),
                           INT8_C( 107), INT8_C( 105), INT8_C(   6), INT8_C(  27),
                           INT8_C( -81), INT8_C(  56), INT8_C(  18), INT8_C( -60),
                           INT8_C(-101), INT8_C( -87), INT8_C(  94), INT8_C( -75),
                           INT8_C(  11), INT8_C(  36), INT8_C( -58), INT8_C(  50)),
      simde_mm256_set_epi8(INT8_C(  89), INT8_C( 113), INT8_C(  30), INT8_C( 104),
                           INT8_C( 125), INT8_C(  13), INT8_C(  67), INT8_C( 120),
                           INT8_C(  97), INT8_C( -16), INT8_C( -34), INT8_C( 113),
                           INT8_C( -11), INT8_C( -42), INT8_C( -10), INT8_C( -27),
                           INT8_C(-101), INT8_C(  43), INT8_C( -87), INT8_C(   7),
                           INT8_C(  94), INT8_C(-118), INT8_C( -75), INT8_C(  87),
                           INT8_C(  11), INT8_C(-107), INT8_C(  36), INT8_C(-121),
                           INT8_C( -58), INT8_C(-123), INT8_C(  50), INT8_C( -99)) },
    { simde_mm256_set_epi8(INT8_C( -67), INT8_C(  -9), INT8_C(  17), INT8_C(   1),
                           INT8_C(  81), INT8_C( -53), INT8_C(  31), INT8_C( -39),
                           INT8_C(  73), INT8_C(  67), INT8_C( -55), INT8_C(   6),
                           INT8_C(  10), INT8_C(  40), INT8_C(-106), INT8_C(  72),
                           INT8_C( -42), INT8_C( -10), INT8_C( -43), INT8_C(  90),
                           INT8_C( -58), INT8_C(-121), INT8_C(  29), INT8_C( -98),
                           INT8_C(-102), INT8_C(  94), INT8_C( -84), INT8_C( -30),
                           INT8_C(  85), INT8_C(  81), INT8_C(   3), INT8_C( -25)),
      simde_mm256_set_epi8(INT8_C( -61), INT8_C( -12), INT8_C( -31), INT8_C(  32),
                           INT8_C(-113), INT8_C(  84), INT8_C(-127), INT8_C( -26),
                           INT8_C(  16), INT8_C( -35), INT8_C(  19), INT8_C( 122),
                           INT8_C(  69), INT8_C( -65), INT8_C( 100), INT8_C(   2),
                           INT8_C(  26), INT8_C( -65), INT8_C(  14), INT8_C( 116),
                           INT8_C( 122), INT8_C(   9), INT8_C(   6), INT8_C( -16),
                           INT8_C(  63), INT8_C(  30), INT8_C(  83), INT8_C(  98),
                           INT8_C(  14), INT8_C( 101), INT8_C( -11), INT8_C( -35)),
      simde_mm256_set_epi8(INT8_C(  16), INT8_C(  73), INT8_C( -35), INT8_C(  67),
                           INT8_C(  19), INT8_C( -55), INT8_C( 122), INT8_C(   6),
                           INT8_C(  69), INT8_C(  10), INT8_C( -65), INT8_C(  40),
                           INT8_C( 100), INT8_C(-106), INT8_C(   2), INT8_C(  72),
                           INT8_C(  63), INT8_C(-102), INT8_C(  30), INT8_C(  94),
                           INT8_C(  83), INT8_C( -84), INT8_C(  98), INT8_C( -30),
                           INT8_C(  14), INT8_C(  85), INT8_C( 101), INT8_C(  81),
                           INT8_C( -11), INT8_C(   3), INT8_C( -35), INT8_C( -25)) },
    { simde_mm256_set_epi8(INT8_C(  79), INT8_C(  15), INT8_C(  49), INT8_C(-100),
                           INT8_C( -26), INT8_C( -68), INT8_C( -90), INT8_C( -20),
                           INT8_C( -86), INT8_C(  47), INT8_C( -77), INT8_C( -34),
                           INT8_C(   8), INT8_C( 109), INT8_C(  -5), INT8_C(   7),
                           INT8_C(  27), INT8_C(  55), INT8_C(   9), INT8_C( -91),
                           INT8_C(-121), INT8_C( -45), INT8_C(  90), INT8_C(  41),
                           INT8_C(  35), INT8_C(  41), INT8_C( -27), INT8_C(  76),
                           INT8_C(  18), INT8_C( 110), INT8_C(  20), INT8_C(  91)),
      simde_mm256_set_epi8(INT8_C(-107), INT8_C(   5), INT8_C(  63), INT8_C( -15),
                           INT8_C( -24), INT8_C(  33), INT8_C( -61), INT8_C(   5),
                           INT8_C( -26), INT8_C(  28), INT8_C( 111), INT8_C(  -8),
                           INT8_C(   5), INT8_C(  -1), INT8_C(  57), INT8_C( 116),
                           INT8_C( -59), INT8_C( 116), INT8_C(  15), INT8_C(-110),
                           INT8_C( -91), INT8_C( -64), INT8_C(  54), INT8_C(  99),
                           INT8_C(  58), INT8_C( -68), INT8_C( -48), INT8_C( -80),
                           INT8_C( -28), INT8_C( -99), INT8_C( 100), INT8_C( -81)),
      simde_mm256_set_epi8(INT8_C( -26), INT8_C( -86), INT8_C(  28), INT8_C(  47),
                           INT8_C( 111), INT8_C( -77), INT8_C(  -8), INT8_C( -34),
                           INT8_C(   5), INT8_C(   8), INT8_C(  -1), INT8_C( 109),
                           INT8_C(  57), INT8_C(  -5), INT8_C( 116), INT8_C(   7),
                           INT8_C(  58), INT8_C(  35), INT8_C( -68), INT8_C(  41),
                           INT8_C( -48), INT8_C( -27), INT8_C( -80), INT8_C(  76),
                           INT8_C( -28), INT8_C(  18), INT8_C( -99), INT8_C( 110),
                           INT8_C( 100), INT8_C(  20), INT8_C( -81), INT8_C(  91)) },
    { simde_mm256_set_epi8(INT8_C( 111), INT8_C(  64), INT8_C(  83), INT8_C(  89),
                           INT8_C(  53), INT8_C(  69), INT8_C(  18), INT8_C(-112),
                           INT8_C( -39), INT8_C(  62), INT8_C(-127), INT8_C(  93),
                           INT8_C(  40), INT8_C( -88), INT8_C(  34), INT8_C(  56),
                           INT8_C( -85), INT8_C(  98), INT8_C( 123), INT8_C( -14),
                           INT8_C( -70), INT8_C( -22), INT8_C(  32), INT8_C( 109),
                           INT8_C(  94), INT8_C(-121), INT8_C(-110), INT8_C( 114),
                           INT8_C( -62), INT8_C(  22), INT8_C( -32), INT8_C(  70)),
      simde_mm256_set_epi8(INT8_C( -35), INT8_C(  57), INT8_C( -30), INT8_C(  91),
                           INT8_C( -17), INT8_C(-121), INT8_C(-121), INT8_C( -63),
                           INT8_C( 125), INT8_C(  10), INT8_C( -28), INT8_C(-117),
                           INT8_C(  12), INT8_C( 112), INT8_C(  23), INT8_C(  38),
                           INT8_C( -40), INT8_C(  22), INT8_C(-121), INT8_C(-107),
                           INT8_C(   1), INT8_C(  89), INT8_C(  11), INT8_C(-119),
                           INT8_C( -63), INT8_C(  67), INT8_C(  93), INT8_C( -28),
                           INT8_C(  24), INT8_C( 106), INT8_C(-124), INT8_C(  25)),
      simde_mm256_set_epi8(INT8_C( 125), INT8_C( -39), INT8_C(  10), INT8_C(  62),
                           INT8_C( -28), INT8_C(-127), INT8_C(-117), INT8_C(  93),
                           INT8_C(  12), INT8_C(  40), INT8_C( 112), INT8_C( -88),
                           INT8_C(  23), INT8_C(  34), INT8_C(  38), INT8_C(  56),
                           INT8_C( -63), INT8_C(  94), INT8_C(  67), INT8_C(-121),
                           INT8_C(  93), INT8_C(-110), INT8_C( -28), INT8_C( 114),
                           INT8_C(  24), INT8_C( -62), INT8_C( 106), INT8_C(  22),
                           INT8_C(-124), INT8_C( -32), INT8_C(  25), INT8_C(  70)) },
    { simde_mm256_set_epi8(INT8_C(-124), INT8_C(  32), INT8_C(  75), INT8_C(  56),
                           INT8_C( -51), INT8_C( -59), INT8_C(  -9), INT8_C( -19),
                           INT8_C(  70), INT8_C(-112), INT8_C( -88), INT8_C( -25),
                           INT8_C(  65), INT8_C( -16), INT8_C(  87), INT8_C(  72),
                           INT8_C( -17), INT8_C( 111), INT8_C(-124), INT8_C( -55),
                           INT8_C(  48), INT8_C(   3), INT8_C( -70), INT8_C(  97),
                           INT8_C( -90), INT8_C(-126), INT8_C( -20), INT8_C( 124),
                           INT8_C(  -5), INT8_C( -13), INT8_C( 118), INT8_C(  93)),
      simde_mm256_set_epi8(INT8_C(-114), INT8_C(  -2), INT8_C(  68), INT8_C( -83),
                           INT8_C(  91), INT8_C( 102), INT8_C( -24), INT8_C(  67),
                           INT8_C( -95), INT8_C(   7), INT8_C(  96), INT8_C(  35),
                           INT8_C( -10), INT8_C( -45), INT8_C( -47), INT8_C( -75),
                           INT8_C(  15), INT8_C( 123), INT8_C( -29), INT8_C(-121),
                           INT8_C(-102), INT8_C(  78), INT8_C( 104), INT8_C(  76),
                           INT8_C(-103), INT8_C(  86), INT8_C(  88), INT8_C(-113),
                           INT8_C( -62), INT8_C(  94), INT8_C( -48), INT8_C(-103)),
      simde_mm256_set_epi8(INT8_C( -95), INT8_C(  70), INT8_C(   7), INT8_C(-112),
                           INT8_C(  96), INT8_C( -88), INT8_C(  35), INT8_C( -25),
                           INT8_C( -10), INT8_C(  65), INT8_C( -45), INT8_C( -16),
                           INT8_C( -47), INT8_C(  87), INT8_C( -75), INT8_C(  72),
                           INT8_C(-103), INT8_C( -90), INT8_C(  86), INT8_C(-126),
                           INT8_C(  88), INT8_C( -20), INT8_C(-113), INT8_C( 124),
                           INT8_C( -62), INT8_C(  -5), INT8_C(  94), INT8_C( -13),
                           INT8_C( -48), INT8_C( 118), INT8_C(-103), INT8_C(  93)) },
    { simde_mm256_set_epi8(INT8_C( -90), INT8_C(-125), INT8_C(-122), INT8_C(  -6),
                           INT8_C(  94), INT8_C(  38), INT8_C( -80), INT8_C(  45),
                           INT8_C( 120), INT8_C(   2), INT8_C(  29), INT8_C( -37),
                           INT8_C( -49), INT8_C( 112), INT8_C( -83), INT8_C(  43),
                           INT8_C(  51), INT8_C(  92), INT8_C(  -2), INT8_C( 110),
                           INT8_C( -26), INT8_C( -17), INT8_C( -37), INT8_C(-121),
                           INT8_C(-105), INT8_C(  -8), INT8_C(  57), INT8_C( -68),
                           INT8_C( 115), INT8_C( -11), INT8_C( -39), INT8_C( -63)),
      simde_mm256_set_epi8(INT8_C( -64), INT8_C(  39), INT8_C(  25), INT8_C(   3),
                           INT8_C( 122), INT8_C( -60), INT8_C( -66), INT8_C( -73),
                           INT8_C(   0), INT8_C(  41), INT8_C(  40), INT8_C(  56),
                           INT8_C(  75), INT8_C( -32), INT8_C( -94), INT8_C(  17),
                           INT8_C( 121), INT8_C(-101), INT8_C( 114), INT8_C( -11),
                           INT8_C(  87), INT8_C( -91), INT8_C( -73), INT8_C(-128),
                           INT8_C( -38), INT8_C(-107), INT8_C(  46), INT8_C( 109),
                           INT8_C( -12), INT8_C(-126), INT8_C( -31), INT8_C( -11)),
      simde_mm256_set_epi8(INT8_C(   0), INT8_C( 120), INT8_C(  41), INT8_C(   2),
                           INT8_C(  40), INT8_C(  29), INT8_C(  56), INT8_C( -37),
                           INT8_C(  75), INT8_C( -49), INT8_C( -32), INT8_C( 112),
                           INT8_C( -94), INT8_C( -83), INT8_C(  17), INT8_C(  43),
                           INT8_C( -38), INT8_C(-105), INT8_C(-107), INT8_C(  -8),
                           INT8_C(  46), INT8_C(  57), INT8_C( 109), INT8_C( -68),
                           INT8_C( -12), INT8_C( 115), INT8_C(-126), INT8_C( -11),
                           INT8_C( -31), INT8_C( -39), INT8_C( -11), INT8_C( -63)) },
    { simde_mm256_set_epi8(INT8_C(  63), INT8_C( 108), INT8_C( 117), INT8_C( 111),
                           INT8_C(-116), INT8_C(-118), INT8_C(  82), INT8_C(-121),
                           INT8_C(  68), INT8_C( -92), INT8_C( -35), INT8_C(   7),
                           INT8_C( -96), INT8_C(   9), INT8_C( -94), INT8_C( -59),
                           INT8_C(  32), INT8_C(  -9), INT8_C( -80), INT8_C(-123),
                           INT8_C(-100), INT8_C(  52), INT8_C(  39), INT8_C( -97),
                           INT8_C(  73), INT8_C( -67), INT8_C(  65), INT8_C(   4),
                           INT8_C( -56), INT8_C( -71), INT8_C(   7), INT8_C(  -5)),
      simde_mm256_set_epi8(INT8_C( 102), INT8_C(  68), INT8_C( -62), INT8_C(  99),
                           INT8_C(-116), INT8_C( -55), INT8_C(  58), INT8_C( -12),
                           INT8_C(  76), INT8_C(  54), INT8_C( 104), INT8_C(  91),
                           INT8_C(  97), INT8_C(-106), INT8_C(  52), INT8_C( 126),
                           INT8_C( -63), INT8_C(-121), INT8_C(  81), INT8_C( -68),
                           INT8_C(  43), INT8_C(  94), INT8_C( -45), INT8_C( -65),
                           INT8_C( 106), INT8_C(  44), INT8_C( 113), INT8_C( -16),
                           INT8_C(  99), INT8_C(  23), INT8_C(  -7), INT8_C( 117)),
      simde_mm256_set_epi8(INT8_C(  76), INT8_C(  68), INT8_C(  54), INT8_C( -92),
                           INT8_C( 104), INT8_C( -35), INT8_C(  91), INT8_C(   7),
                           INT8_C(  97), INT8_C( -96), INT8_C(-106), INT8_C(   9),
                           INT8_C(  52), INT8_C( -94), INT8_C( 126), INT8_C( -59),
                           INT8_C( 106), INT8_C(  73), INT8_C(  44), INT8_C( -67),
                           INT8_C( 113), INT8_C(  65), INT8_C( -16), INT8_C(   4),
                           INT8_C(  99), INT8_C( -56), INT8_C(  23), INT8_C( -71),
                           INT8_C(  -7), INT8_C(   7), INT8_C( 117), INT8_C(  -5)) },
    { simde_mm256_set_epi8(INT8_C( 104), INT8_C(  34), INT8_C( -70), INT8_C( -26),
                           INT8_C( -69), INT8_C(  81), INT8_C( -50), INT8_C(   4),
                           INT8_C( -60), INT8_C( -88), INT8_C(  -4), INT8_C( -63),
                           INT8_C( -86), INT8_C(-128), INT8_C(  17), INT8_C( -71),
                           INT8_C(  58), INT8_C(  49), INT8_C(  70), INT8_C(  -5),
                           INT8_C( -33), INT8_C( -24), INT8_C( -68), INT8_C(  51),
                           INT8_C( -53), INT8_C( -74), INT8_C( 121), INT8_C(  64),
                           INT8_C( 107), INT8_C(  46), INT8_C(  97), INT8_C( -31)),
      simde_mm256_set_epi8(INT8_C( -50), INT8_C(  41), INT8_C(  -4), INT8_C(  50),
                           INT8_C(  14), INT8_C(   6), INT8_C(   5), INT8_C( -94),
                           INT8_C( 117), INT8_C(-125), INT8_C( -37), INT8_C(-117),
                           INT8_C(  55), INT8_C(-105), INT8_C(  11), INT8_C(-118),
                           INT8_C( -38), INT8_C( 101), INT8_C(  50), INT8_C(  56),
                           INT8_C( -29), INT8_C(  -1), INT8_C(  78), INT8_C(  43),
                           INT8_C(  76), INT8_C( -69), INT8_C(  38), INT8_C( -37),
                           INT8_C(  55), INT8_C( -69), INT8_C(  85), INT8_C( 113)),
      simde_mm256_set_epi8(INT8_C( 117), INT8_C( -60), INT8_C(-125), INT8_C( -88),
                           INT8_C( -37), INT8_C(  -4), INT8_C(-117), INT8_C( -63),
                           INT8_C(  55), INT8_C( -86), INT8_C(-105), INT8_C(-128),
                           INT8_C(  11), INT8_C(  17), INT8_C(-118), INT8_C( -71),
                           INT8_C(  76), INT8_C( -53), INT8_C( -69), INT8_C( -74),
                           INT8_C(  38), INT8_C( 121), INT8_C( -37), INT8_C(  64),
                           INT8_C(  55), INT8_C( 107), INT8_C( -69), INT8_C(  46),
                           INT8_C(  85), INT8_C(  97), INT8_C( 113), INT8_C( -31)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_unpacklo_epi8(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_unpacklo_epi16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi16(INT16_C(-30282), INT16_C( 17545), INT16_C(  1397), INT16_C(-23688),
                            INT16_C(  7095), INT16_C(-13226), INT16_C( 16225), INT16_C( 24624),
                            INT16_C(-19105), INT16_C( 16354), INT16_C(-30269), INT16_C(-10683),
                            INT16_C(  8943), INT16_C(-21230), INT16_C(-20477), INT16_C(-15650)),
      simde_mm256_set_epi16(INT16_C(-25398), INT16_C(-19610), INT16_C(-11289), INT16_C( 28083),
                            INT16_C(-11420), INT16_C( -1651), INT16_C(-26110), INT16_C( 32276),
                            INT16_C(  2653), INT16_C( 16175), INT16_C(  2453), INT16_C(-13949),
                            INT16_C( -3232), INT16_C(-27909), INT16_C(   187), INT16_C( 30423)),
      simde_mm256_set_epi16(INT16_C(-11420), INT16_C(  7095), INT16_C( -1651), INT16_C(-13226),
                            INT16_C(-26110), INT16_C( 16225), INT16_C( 32276), INT16_C( 24624),
                            INT16_C( -3232), INT16_C(  8943), INT16_C(-27909), INT16_C(-21230),
                            INT16_C(   187), INT16_C(-20477), INT16_C( 30423), INT16_C(-15650)) },
    { simde_mm256_set_epi16(INT16_C( 21698), INT16_C(-28557), INT16_C(-10383), INT16_C(  5893),
                            INT16_C(   262), INT16_C(-15994), INT16_C( 10150), INT16_C(-16695),
                            INT16_C(-27992), INT16_C( 19356), INT16_C(-16467), INT16_C( 25602),
                            INT16_C( -8537), INT16_C( 32448), INT16_C(  8648), INT16_C( -2538)),
      simde_mm256_set_epi16(INT16_C(-10809), INT16_C( 31334), INT16_C(-23341), INT16_C(-23517),
                            INT16_C( 24971), INT16_C( -2967), INT16_C(    85), INT16_C( -6374),
                            INT16_C( 12369), INT16_C(  2809), INT16_C( 24485), INT16_C( 26961),
                            INT16_C(-13324), INT16_C(  1302), INT16_C( 20638), INT16_C(-30060)),
      simde_mm256_set_epi16(INT16_C( 24971), INT16_C(   262), INT16_C( -2967), INT16_C(-15994),
                            INT16_C(    85), INT16_C( 10150), INT16_C( -6374), INT16_C(-16695),
                            INT16_C(-13324), INT16_C( -8537), INT16_C(  1302), INT16_C( 32448),
                            INT16_C( 20638), INT16_C(  8648), INT16_C(-30060), INT16_C( -2538)) },
    { simde_mm256_set_epi16(INT16_C( 29708), INT16_C(   973), INT16_C(-18396), INT16_C( -4069),
                            INT16_C( -8794), INT16_C( 11568), INT16_C(   791), INT16_C(  2488),
                            INT16_C( -5218), INT16_C(-22271), INT16_C(-28848), INT16_C( 10219),
                            INT16_C( 23398), INT16_C( 32588), INT16_C( 20014), INT16_C( 27330)),
      simde_mm256_set_epi16(INT16_C(  2064), INT16_C(  8959), INT16_C( 21574), INT16_C(-11590),
                            INT16_C( 29752), INT16_C( -9389), INT16_C(-30933), INT16_C(  2430),
                            INT16_C(-26152), INT16_C( 21194), INT16_C(-30448), INT16_C( -9544),
                            INT16_C(-11845), INT16_C(-20406), INT16_C( 31145), INT16_C( 11486)),
      simde_mm256_set_epi16(INT16_C( 29752), INT16_C( -8794), INT16_C( -9389), INT16_C( 11568),
                            INT16_C(-30933), INT16_C(   791), INT16_C(  2430), INT16_C(  2488),
                            INT16_C(-11845), INT16_C( 23398), INT16_C(-20406), INT16_C( 32588),
                            INT16_C( 31145), INT16_C( 20014), INT16_C( 11486), INT16_C( 27330)) },
    { simde_mm256_set_epi16(INT16_C(  6440), INT16_C( 24154), INT16_C(  3465), INT16_C( -9568),
                            INT16_C( 32223), INT16_C(-15547), INT16_C(-13940), INT16_C(-23416),
                            INT16_C(  1226), INT16_C(  3044), INT16_C(-16083), INT16_C( -2151),
                            INT16_C( 18066), INT16_C( 29407), INT16_C( 22180), INT16_C(  8673)),
      simde_mm256_set_epi16(INT16_C( 32190), INT16_C( -2276), INT16_C( 14786), INT16_C( 21157),
                            INT16_C(-13808), INT16_C(-14345), INT16_C( -8569), INT16_C( 28230),
                            INT16_C(  4254), INT16_C(-24931), INT16_C(   188), INT16_C(-22513),
                            INT16_C( 28262), INT16_C(-17377), INT16_C(-27018), INT16_C(-20998)),
      simde_mm256_set_epi16(INT16_C(-13808), INT16_C( 32223), INT16_C(-14345), INT16_C(-15547),
                            INT16_C( -8569), INT16_C(-13940), INT16_C( 28230), INT16_C(-23416),
                            INT16_C( 28262), INT16_C( 18066), INT16_C(-17377), INT16_C( 29407),
                            INT16_C(-27018), INT16_C( 22180), INT16_C(-20998), INT16_C(  8673)) },
    { simde_mm256_set_epi16(INT16_C( 21433), INT16_C(-32745), INT16_C(-20857), INT16_C(  9689),
                            INT16_C(-19620), INT16_C( 27874), INT16_C(-12579), INT16_C(-11273),
                            INT16_C( -7990), INT16_C( -5188), INT16_C( -2308), INT16_C(-28807),
                            INT16_C( 30803), INT16_C(-31644), INT16_C(-17815), INT16_C( 25631)),
      simde_mm256_set_epi16(INT16_C( -6103), INT16_C( 30452), INT16_C( 26648), INT16_C(-28159),
                            INT16_C(  7856), INT16_C(-23604), INT16_C(-21584), INT16_C(  8163),
                            INT16_C(-18173), INT16_C(  4449), INT16_C(-19194), INT16_C( 32687),
                            INT16_C( 13328), INT16_C(  5053), INT16_C(-14292), INT16_C(  9840)),
      simde_mm256_set_epi16(INT16_C(  7856), INT16_C(-19620), INT16_C(-23604), INT16_C( 27874),
                            INT16_C(-21584), INT16_C(-12579), INT16_C(  8163), INT16_C(-11273),
                            INT16_C( 13328), INT16_C( 30803), INT16_C(  5053), INT16_C(-31644),
                            INT16_C(-14292), INT16_C(-17815), INT16_C(  9840), INT16_C( 25631)) },
    { simde_mm256_set_epi16(INT16_C( 12319), INT16_C(  2668), INT16_C( 15777), INT16_C(-15674),
                            INT16_C(-27625), INT16_C( -9913), INT16_C(-25103), INT16_C( 18516),
                            INT16_C( -2788), INT16_C(-28181), INT16_C(   690), INT16_C(-21029),
                            INT16_C( -9342), INT16_C( -7022), INT16_C( -3964), INT16_C( 27684)),
      simde_mm256_set_epi16(INT16_C(-23966), INT16_C( 20005), INT16_C(-26957), INT16_C(  9742),
                            INT16_C(-30820), INT16_C( 24145), INT16_C(  4042), INT16_C(  6816),
                            INT16_C(-17740), INT16_C(  1939), INT16_C( -2041), INT16_C(-32516),
                            INT16_C(-25602), INT16_C( 15914), INT16_C(  5185), INT16_C(-12371)),
      simde_mm256_set_epi16(INT16_C(-30820), INT16_C(-27625), INT16_C( 24145), INT16_C( -9913),
                            INT16_C(  4042), INT16_C(-25103), INT16_C(  6816), INT16_C( 18516),
                            INT16_C(-25602), INT16_C( -9342), INT16_C( 15914), INT16_C( -7022),
                            INT16_C(  5185), INT16_C( -3964), INT16_C(-12371), INT16_C( 27684)) },
    { simde_mm256_set_epi16(INT16_C( -5299), INT16_C( -9685), INT16_C(  9755), INT16_C(-16148),
                            INT16_C(-31255), INT16_C( 18778), INT16_C( 18350), INT16_C( 31236),
                            INT16_C(-10664), INT16_C( 12773), INT16_C( 30044), INT16_C(-23199),
                            INT16_C( 22014), INT16_C(  1980), INT16_C( 29718), INT16_C(-21712)),
      simde_mm256_set_epi16(INT16_C( 26040), INT16_C( 22288), INT16_C(  6550), INT16_C(-26515),
                            INT16_C(-19807), INT16_C(-18397), INT16_C(-22874), INT16_C(   407),
                            INT16_C(-20286), INT16_C( 30014), INT16_C( 13089), INT16_C( 23053),
                            INT16_C(-13726), INT16_C(  7887), INT16_C(-22384), INT16_C(-14795)),
      simde_mm256_set_epi16(INT16_C(-19807), INT16_C(-31255), INT16_C(-18397), INT16_C( 18778),
                            INT16_C(-22874), INT16_C( 18350), INT16_C(   407), INT16_C( 31236),
                            INT16_C(-13726), INT16_C( 22014), INT16_C(  7887), INT16_C(  1980),
                            INT16_C(-22384), INT16_C( 29718), INT16_C(-14795), INT16_C(-21712)) },
    { simde_mm256_set_epi16(INT16_C( 31115), INT16_C( -4108), INT16_C( -8080), INT16_C( 29018),
                            INT16_C(-17821), INT16_C(-27725), INT16_C(  1365), INT16_C( 15677),
                            INT16_C(  9784), INT16_C(-29292), INT16_C( 18208), INT16_C(-29194),
                            INT16_C( 11347), INT16_C( -8693), INT16_C( -8615), INT16_C( 13549)),
      simde_mm256_set_epi16(INT16_C(-31719), INT16_C(  9678), INT16_C(  3398), INT16_C( 25207),
                            INT16_C(-26413), INT16_C( -2632), INT16_C( 30768), INT16_C( 11317),
                            INT16_C( 21819), INT16_C( 22008), INT16_C( 24268), INT16_C(  4358),
                            INT16_C(-28281), INT16_C( 31671), INT16_C(  9126), INT16_C( -4199)),
      simde_mm256_set_epi16(INT16_C(-26413), INT16_C(-17821), INT16_C( -2632), INT16_C(-27725),
                            INT16_C( 30768), INT16_C(  1365), INT16_C( 11317), INT16_C( 15677),
                            INT16_C(-28281), INT16_C( 11347), INT16_C( 31671), INT16_C( -8693),
                            INT16_C(  9126), INT16_C( -8615), INT16_C( -4199), INT16_C( 13549)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_unpacklo_epi16(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_unpacklo_epi32(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi32(INT32_C( 1634006754), INT32_C( 2027673276), INT32_C(-1004966058), INT32_C(   31035471),
                            INT32_C(  582697150), INT32_C( -865564811), INT32_C(-1835008447), INT32_C( 1804896535)),
      simde_mm256_set_epi32(INT32_C(  250556499), INT32_C(-1998071312), INT32_C(-1032788603), INT32_C(-1564323608),
                            INT32_C(-2109612931), INT32_C(-1991486451), INT32_C(-1624617327), INT32_C( -572875248)),
      simde_mm256_set_epi32(INT32_C(-1032788603), INT32_C(-1004966058), INT32_C(-1564323608), INT32_C(   31035471),
                            INT32_C(-1624617327), INT32_C(-1835008447), INT32_C( -572875248), INT32_C( 1804896535)) },
    { simde_mm256_set_epi32(INT32_C(  949978713), INT32_C(-1147362485), INT32_C(  854099489), INT32_C( -769233801),
                            INT32_C(-2080267368), INT32_C( 2025215151), INT32_C( 1944502882), INT32_C( 1998396566)),
      simde_mm256_set_epi32(INT32_C( 1131236119), INT32_C(-1871822227), INT32_C(-1378954726), INT32_C( -808581099),
                            INT32_C(  114286940), INT32_C(-2068340600), INT32_C( 1176100740), INT32_C(-1711799535)),
      simde_mm256_set_epi32(INT32_C(-1378954726), INT32_C(  854099489), INT32_C( -808581099), INT32_C( -769233801),
                            INT32_C( 1176100740), INT32_C( 1944502882), INT32_C(-1711799535), INT32_C( 1998396566)) },
    { simde_mm256_set_epi32(INT32_C( -539215325), INT32_C( 1386192905), INT32_C( 2045489389), INT32_C( -233070788),
                            INT32_C(-1110980092), INT32_C(-1773587744), INT32_C(-1877041680), INT32_C( 1118926695)),
      simde_mm256_set_epi32(INT32_C( 1837258736), INT32_C(  777251927), INT32_C( -528822409), INT32_C(  652807806),
                            INT32_C( -855377965), INT32_C( 2001307829), INT32_C(  222072460), INT32_C( -954219379)),
      simde_mm256_set_epi32(INT32_C( -528822409), INT32_C( 2045489389), INT32_C(  652807806), INT32_C( -233070788),
                            INT32_C(  222072460), INT32_C(-1877041680), INT32_C( -954219379), INT32_C( 1118926695)) },
    { simde_mm256_set_epi32(INT32_C( 1171398216), INT32_C(-1815838821), INT32_C(  612082553), INT32_C( -598227397),
                            INT32_C( 1917370778), INT32_C(-1469217853), INT32_C(-1242194963), INT32_C(-1540218008)),
      simde_mm256_set_epi32(INT32_C( 1716361405), INT32_C( 1201391077), INT32_C( -200251042), INT32_C(   92359436),
                            INT32_C(-1697948463), INT32_C(-1859110046), INT32_C( 1319052809), INT32_C( -520980879)),
      simde_mm256_set_epi32(INT32_C( -200251042), INT32_C(  612082553), INT32_C(   92359436), INT32_C( -598227397),
                            INT32_C( 1319052809), INT32_C(-1242194963), INT32_C( -520980879), INT32_C(-1540218008)) },
    { simde_mm256_set_epi32(INT32_C(-1628276207), INT32_C(  -52307206), INT32_C( -204071811), INT32_C( -323316344),
                            INT32_C( -993779627), INT32_C( 1107422469), INT32_C(-2067672829), INT32_C(-1768371428)),
      simde_mm256_set_epi32(INT32_C(-1719696812), INT32_C(-1577841127), INT32_C(-1009880980), INT32_C( -766826796),
                            INT32_C( 1275907717), INT32_C(-1042662611), INT32_C( -491358494), INT32_C(  421707156)),
      simde_mm256_set_epi32(INT32_C(-1009880980), INT32_C( -204071811), INT32_C( -766826796), INT32_C( -323316344),
                            INT32_C( -491358494), INT32_C(-2067672829), INT32_C(  421707156), INT32_C(-1768371428)) },
    { simde_mm256_set_epi32(INT32_C(-1254036215), INT32_C(  377006130), INT32_C( 1193383293), INT32_C(-1422821080),
                            INT32_C( -739482809), INT32_C( 2014379887), INT32_C(-1242086604), INT32_C(-1197757953)),
      simde_mm256_set_epi32(INT32_C( 1288082582), INT32_C( 1674663179), INT32_C( -228351353), INT32_C( -941607417),
                            INT32_C(  416281156), INT32_C(-1292618170), INT32_C( 1488480694), INT32_C(  327047972)),
      simde_mm256_set_epi32(INT32_C( -228351353), INT32_C( 1193383293), INT32_C( -941607417), INT32_C(-1422821080),
                            INT32_C( 1488480694), INT32_C(-1242086604), INT32_C(  327047972), INT32_C(-1197757953)) },
    { simde_mm256_set_epi32(INT32_C( 1508573201), INT32_C(  969937333), INT32_C(   14444014), INT32_C(  108302280),
                            INT32_C(-1520907964), INT32_C(  -22983897), INT32_C( 1816713030), INT32_C(-1177538461)),
      simde_mm256_set_epi32(INT32_C(-1104336423), INT32_C(  271712214), INT32_C( -354649539), INT32_C( 1013182006),
                            INT32_C( 1412833129), INT32_C(-1419706355), INT32_C( 1282557791), INT32_C(-1472463953)),
      simde_mm256_set_epi32(INT32_C( -354649539), INT32_C(   14444014), INT32_C( 1013182006), INT32_C(  108302280),
                            INT32_C( 1282557791), INT32_C( 1816713030), INT32_C(-1472463953), INT32_C(-1177538461)) },
    { simde_mm256_set_epi32(INT32_C(  -66937609), INT32_C( -119592026), INT32_C( 1432494483), INT32_C( -124579914),
                            INT32_C( -238722129), INT32_C( -220704743), INT32_C(  419566334), INT32_C(  422590012)),
      simde_mm256_set_epi32(INT32_C( -454663334), INT32_C( 1184045083), INT32_C( 1025965918), INT32_C( -854328465),
                            INT32_C(  -19322018), INT32_C( 1969810936), INT32_C( -266337614), INT32_C(   51340398)),
      simde_mm256_set_epi32(INT32_C( 1025965918), INT32_C( 1432494483), INT32_C( -854328465), INT32_C( -124579914),
                            INT32_C( -266337614), INT32_C(  419566334), INT32_C(   51340398), INT32_C(  422590012)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_unpacklo_epi32(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_unpacklo_epi64(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi64x(INT64_C( 7018005571900790460), INT64_C(-4316296352669003697),
                             INT64_C( 2502665206151808885), INT64_C(-7881301265943852777)),
      simde_mm256_set_epi64x(INT64_C( 1076131971302152688), INT64_C(-4435793270835883800),
                             INT64_C(-9060718543560223731), INT64_C(-6977678284257845744)),
      simde_mm256_set_epi64x(INT64_C(-4435793270835883800), INT64_C(-4316296352669003697),
                             INT64_C(-6977678284257845744), INT64_C(-7881301265943852777)) },
    { simde_mm256_set_epi64x(INT64_C( 4080127507378774859), INT64_C( 3668329376311045239),
                             INT64_C(-8934680310470781777), INT64_C( 8351576287166143638)),
      simde_mm256_set_epi64x(INT64_C( 4858622137582109293), INT64_C(-5922565447348254699),
                             INT64_C(  490858671886540936), INT64_C( 5051314217684566801)),
      simde_mm256_set_epi64x(INT64_C(-5922565447348254699), INT64_C( 3668329376311045239),
                             INT64_C( 5051314217684566801), INT64_C( 8351576287166143638)) },
    { simde_mm256_set_epi64x(INT64_C(-2315912184990818295), INT64_C( 8785310034131918652),
                             INT64_C(-4771623159125691680), INT64_C(-8061832627709970585)),
      simde_mm256_set_epi64x(INT64_C( 7890966186187549783), INT64_C(-2271274951394128258),
                             INT64_C(-3673820383392724811), INT64_C(  953793956383016077)),
      simde_mm256_set_epi64x(INT64_C(-2271274951394128258), INT64_C( 8785310034131918652),
                             INT64_C(  953793956383016077), INT64_C(-8061832627709970585)) },
    { simde_mm256_set_epi64x(INT64_C( 5031117030791872411), INT64_C( 2628874551283926587),
                             INT64_C( 8235044788641825731), INT64_C(-5335186738586180760)),
      simde_mm256_set_epi64x(INT64_C( 7371716103793001957), INT64_C( -860071676287562996),
                             INT64_C(-7292633116442608798), INT64_C( 5665288680125920881)),
      simde_mm256_set_epi64x(INT64_C( -860071676287562996), INT64_C( 2628874551283926587),
                             INT64_C( 5665288680125920881), INT64_C(-5335186738586180760)) },
    { simde_mm256_set_epi64x(INT64_C(-6993393053677266182), INT64_C( -876481750308842104),
                             INT64_C(-4268250996288656123), INT64_C(-8880587176856204516)),
      simde_mm256_set_epi64x(INT64_C(-7386041563858334183), INT64_C(-4337405778424289580),
                             INT64_C( 5479981920481327917), INT64_C(-2110368661920105068)),
      simde_mm256_set_epi64x(INT64_C(-4337405778424289580), INT64_C( -876481750308842104),
                             INT64_C(-2110368661920105068), INT64_C(-8880587176856204516)) },
    { simde_mm256_set_epi64x(INT64_C(-5386044531047618510), INT64_C( 5125542217899931944),
                             INT64_C(-3176054478594834577), INT64_C(-5334721339882493441)),
      simde_mm256_set_epi64x(INT64_C( 5532272565911901451), INT64_C( -980761589778991609),
                             INT64_C( 1787913953963423302), INT64_C( 6392975901784431396)),
      simde_mm256_set_epi64x(INT64_C( -980761589778991609), INT64_C( 5125542217899931944),
                             INT64_C( 6392975901784431396), INT64_C(-5334721339882493441)) },
    { simde_mm256_set_epi64x(INT64_C( 6479272562886971829), INT64_C(   62036567861268424),
                             INT64_C(-6532249961333961945), INT64_C( 7802723053184495715)),
      simde_mm256_set_epi64x(INT64_C(-4743088820294909994), INT64_C(-1523208170533294538),
                             INT64_C( 6068072086635610125), INT64_C( 5508543770397506479)),
      simde_mm256_set_epi64x(INT64_C(-1523208170533294538), INT64_C(   62036567861268424),
                             INT64_C( 5508543770397506479), INT64_C( 7802723053184495715)) },
    { simde_mm256_set_epi64x(INT64_C( -287494837352059994), INT64_C( 6152516960355815350),
                             INT64_C(-1025303732812230631), INT64_C( 1802023683455202876)),
      simde_mm256_set_epi64x(INT64_C(-1952764149036279781), INT64_C( 4406490068061256559),
                             INT64_C(  -82987433432912392), INT64_C(-1143911341773331346)),
      simde_mm256_set_epi64x(INT64_C( 4406490068061256559), INT64_C( 6152516960355815350),
                             INT64_C(-1143911341773331346), INT64_C( 1802023683455202876)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_unpacklo_epi64(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i64(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_unpackhi_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi8(INT8_C(  87), INT8_C( 102), INT8_C(  -8), INT8_C( -64),
                           INT8_C( 127), INT8_C(  58), INT8_C(  96), INT8_C( 103),
                           INT8_C( -98), INT8_C(-118), INT8_C(  55), INT8_C( 100),
                           INT8_C( -28), INT8_C( 103), INT8_C( -55), INT8_C(  11),
                           INT8_C(   6), INT8_C(-121), INT8_C( -30), INT8_C( -49),
                           INT8_C( 125), INT8_C( 108), INT8_C(  76), INT8_C( -98),
                           INT8_C(  55), INT8_C( -83), INT8_C( -57), INT8_C( 124),
                           INT8_C( 121), INT8_C(  85), INT8_C( 102), INT8_C(  78)),
      simde_mm256_set_epi8(INT8_C(   3), INT8_C(  85), INT8_C(  69), INT8_C( -24),
                           INT8_C(-108), INT8_C( 112), INT8_C( 108), INT8_C( -48),
                           INT8_C(  87), INT8_C( 127), INT8_C( -59), INT8_C( -27),
                           INT8_C( -42), INT8_C(  90), INT8_C(-117), INT8_C( -35),
                           INT8_C(  78), INT8_C(-126), INT8_C(  39), INT8_C( 121),
                           INT8_C( 106), INT8_C( -53), INT8_C( -82), INT8_C( -49),
                           INT8_C( -76), INT8_C(  83), INT8_C(  68), INT8_C( 126),
                           INT8_C( -36), INT8_C(-105), INT8_C(  91), INT8_C( -27)),
      simde_mm256_set_epi8(INT8_C(   3), INT8_C(  87), INT8_C(  85), INT8_C( 102),
                           INT8_C(  69), INT8_C(  -8), INT8_C( -24), INT8_C( -64),
                           INT8_C(-108), INT8_C( 127), INT8_C( 112), INT8_C(  58),
                           INT8_C( 108), INT8_C(  96), INT8_C( -48), INT8_C( 103),
                           INT8_C(  78), INT8_C(   6), INT8_C(-126), INT8_C(-121),
                           INT8_C(  39), INT8_C( -30), INT8_C( 121), INT8_C( -49),
                           INT8_C( 106), INT8_C( 125), INT8_C( -53), INT8_C( 108),
                           INT8_C( -82), INT8_C(  76), INT8_C( -49), INT8_C( -98)) },
    { simde_mm256_set_epi8(INT8_C( 112), INT8_C(  90), INT8_C(  24), INT8_C( 102),
                           INT8_C(-123), INT8_C(  60), INT8_C( -57), INT8_C(  10),
                           INT8_C(  -8), INT8_C(  91), INT8_C(  56), INT8_C(  10),
                           INT8_C(-127), INT8_C( -25), INT8_C(  40), INT8_C(-120),
                           INT8_C(  99), INT8_C(-103), INT8_C(-112), INT8_C(  -7),
                           INT8_C( 115), INT8_C( -59), INT8_C(  49), INT8_C( -54),
                           INT8_C( -41), INT8_C( -25), INT8_C( -96), INT8_C(  16),
                           INT8_C( -43), INT8_C(  -2), INT8_C(-114), INT8_C(  89)),
      simde_mm256_set_epi8(INT8_C(  20), INT8_C(  32), INT8_C( -27), INT8_C( -28),
                           INT8_C(  86), INT8_C( -18), INT8_C(   1), INT8_C( -10),
                           INT8_C( -40), INT8_C(  83), INT8_C( -44), INT8_C(-102),
                           INT8_C(  46), INT8_C(  76), INT8_C(  10), INT8_C(  66),
                           INT8_C( -76), INT8_C(  18), INT8_C(  56), INT8_C(  13),
                           INT8_C(-103), INT8_C(  -2), INT8_C( -25), INT8_C(  -5),
                           INT8_C(  74), INT8_C(  -5), INT8_C(  -3), INT8_C(-123),
                           INT8_C( -35), INT8_C( -25), INT8_C(  43), INT8_C(  19)),
      simde_mm256_set_epi8(INT8_C(  20), INT8_C( 112), INT8_C(  32), INT8_C(  90),
                           INT8_C( -27), INT8_C(  24), INT8_C( -28), INT8_C( 102),
                           INT8_C(  86), INT8_C(-123), INT8_C( -18), INT8_C(  60),
                           INT8_C(   1), INT8_C( -57), INT8_C( -10), INT8_C(  10),
                           INT8_C( -76), INT8_C(  99), INT8_C(  18), INT8_C(-103),
                           INT8_C(  56), INT8_C(-112), INT8_C(  13), INT8_C(  -7),
                           INT8_C(-103), INT8_C( 115), INT8_C(  -2), INT8_C( -59),
                           INT8_C( -25), INT8_C(  49), INT8_C(  -5), INT8_C( -54)) },
    { simde_mm256_set_epi8(INT8_C(  95), INT8_C(  65), INT8_C(  44), INT8_C(-120),
                           INT8_C(  77), INT8_C(  80), INT8_C(  72), INT8_C(  -2),
                           INT8_C( 107), INT8_C( 115), INT8_C( 120), INT8_C( -13),
                           INT8_C(  12), INT8_C(  67), INT8_C( -69), INT8_C( -53),
                           INT8_C( -97), INT8_C( -94), INT8_C(-120), INT8_C(  83),
                           INT8_C(-103), INT8_C( -32), INT8_C(  93), INT8_C(-100),
                           INT8_C(  58), INT8_C(  69), INT8_C(-123), INT8_C(-102),
                           INT8_C( 123), INT8_C( -15), INT8_C( -31), INT8_C( -25)),
      simde_mm256_set_epi8(INT8_C(  12), INT8_C( 126), INT8_C(   6), INT8_C(  -7),
                           INT8_C(-106), INT8_C(  73), INT8_C(  64), INT8_C(  36),
                           INT8_C( -83), INT8_C(-127), INT8_C(  -5), INT8_C( -91),
                           INT8_C( -74), INT8_C(  98), INT8_C(  28), INT8_C(-104),
                           INT8_C(  56), INT8_C(-120), INT8_C( -84), INT8_C(  28),
                           INT8_C( -96), INT8_C(  47), INT8_C( -85), INT8_C(-104),
                           INT8_C(  96), INT8_C(  12), INT8_C( 123), INT8_C(-104),
                           INT8_C(  31), INT8_C(  37), INT8_C( -31), INT8_C( -17)),
      simde_mm256_set_epi8(INT8_C(  12), INT8_C(  95), INT8_C( 126), INT8_C(  65),
                           INT8_C(   6), INT8_C(  44), INT8_C(  -7), INT8_C(-120),
                           INT8_C(-106), INT8_C(  77), INT8_C(  73), INT8_C(  80),
                           INT8_C(  64), INT8_C(  72), INT8_C(  36), INT8_C(  -2),
                           INT8_C(  56), INT8_C( -97), INT8_C(-120), INT8_C( -94),
                           INT8_C( -84), INT8_C(-120), INT8_C(  28), INT8_C(  83),
                           INT8_C( -96), INT8_C(-103), INT8_C(  47), INT8_C( -32),
                           INT8_C( -85), INT8_C(  93), INT8_C(-104), INT8_C(-100)) },
    { simde_mm256_set_epi8(INT8_C( 105), INT8_C( -44), INT8_C(  72), INT8_C( -66),
                           INT8_C( 125), INT8_C( -29), INT8_C(  78), INT8_C( -12),
                           INT8_C( 124), INT8_C( -33), INT8_C(  94), INT8_C(  61),
                           INT8_C(  86), INT8_C(  37), INT8_C( -88), INT8_C(  37),
                           INT8_C( -27), INT8_C( -80), INT8_C(-110), INT8_C( -81),
                           INT8_C(  40), INT8_C( 113), INT8_C( -26), INT8_C( -57),
                           INT8_C(  -6), INT8_C( -99), INT8_C( -38), INT8_C(  24),
                           INT8_C(  86), INT8_C(-109), INT8_C( 116), INT8_C( 103)),
      simde_mm256_set_epi8(INT8_C( -71), INT8_C(  89), INT8_C(  75), INT8_C(  16),
                           INT8_C( -92), INT8_C(  95), INT8_C( -25), INT8_C(  57),
                           INT8_C( 114), INT8_C( -21), INT8_C(  26), INT8_C(  67),
                           INT8_C( -54), INT8_C(  93), INT8_C(  57), INT8_C( -16),
                           INT8_C( -68), INT8_C( -27), INT8_C(-121), INT8_C(  -7),
                           INT8_C( -78), INT8_C(-108), INT8_C(  94), INT8_C(  56),
                           INT8_C(  14), INT8_C( -83), INT8_C(-117), INT8_C(  -4),
                           INT8_C(  75), INT8_C( -63), INT8_C( 109), INT8_C(   6)),
      simde_mm256_set_epi8(INT8_C( -71), INT8_C( 105), INT8_C(  89), INT8_C( -44),
                           INT8_C(  75), INT8_C(  72), INT8_C(  16), INT8_C( -66),
                           INT8_C( -92), INT8_C( 125), INT8_C(  95), INT8_C( -29),
                           INT8_C( -25), INT8_C(  78), INT8_C(  57), INT8_C( -12),
                           INT8_C( -68), INT8_C( -27), INT8_C( -27), INT8_C( -80),
                           INT8_C(-121), INT8_C(-110), INT8_C(  -7), INT8_C( -81),
                           INT8_C( -78), INT8_C(  40), INT8_C(-108), INT8_C( 113),
                           INT8_C(  94), INT8_C( -26), INT8_C(  56), INT8_C( -57)) },
    { simde_mm256_set_epi8(INT8_C( -76), INT8_C( -96), INT8_C( 126), INT8_C(  70),
                           INT8_C(-109), INT8_C(  42), INT8_C( -56), INT8_C( -17),
                           INT8_C(  90), INT8_C(  30), INT8_C( 106), INT8_C(  47),
                           INT8_C(  58), INT8_C(   4), INT8_C(  49), INT8_C(  97),
                           INT8_C( -63), INT8_C( -41), INT8_C(  44), INT8_C( -24),
                           INT8_C(-126), INT8_C( -36), INT8_C(  48), INT8_C(  88),
                           INT8_C(-121), INT8_C(-109), INT8_C(   0), INT8_C( -48),
                           INT8_C( -14), INT8_C( 115), INT8_C(-117), INT8_C( -86)),
      simde_mm256_set_epi8(INT8_C(-115), INT8_C(  98), INT8_C( 106), INT8_C( -64),
                           INT8_C(  61), INT8_C(-124), INT8_C( -21), INT8_C(  59),
                           INT8_C(  18), INT8_C(  -3), INT8_C(  78), INT8_C(  77),
                           INT8_C( -11), INT8_C( 116), INT8_C( -63), INT8_C( -81),
                           INT8_C( -87), INT8_C( 116), INT8_C(  29), INT8_C(  58),
                           INT8_C(  66), INT8_C(   4), INT8_C( -71), INT8_C(  14),
                           INT8_C( -54), INT8_C( -76), INT8_C( -39), INT8_C(   8),
                           INT8_C(  12), INT8_C( -91), INT8_C( -14), INT8_C( -79)),
      simde_mm256_set_epi8(INT8_C(-115), INT8_C( -76), INT8_C(  98), INT8_C( -96),
                           INT8_C( 106), INT8_C( 126), INT8_C( -64), INT8_C(  70),
                           INT8_C(  61), INT8_C(-109), INT8_C(-124), INT8_C(  42),
                           INT8_C( -21), INT8_C( -56), INT8_C(  59), INT8_C( -17),
                           INT8_C( -87), INT8_C( -63), INT8_C( 116), INT8_C( -41),
                           INT8_C(  29), INT8_C(  44), INT8_C(  58), INT8_C( -24),
                           INT8_C(  66), INT8_C(-126), INT8_C(   4), INT8_C( -36),
                           INT8_C( -71), INT8_C(  48), INT8_C(  14), INT8_C(  88)) },
    { simde_mm256_set_epi8(INT8_C( -15), INT8_C(  20), INT8_C( -88), INT8_C(  19),
                           INT8_C(   9), INT8_C(  82), INT8_C( -23), INT8_C(  71),
                           INT8_C(  11), INT8_C(   4), INT8_C(-108), INT8_C(   0),
                           INT8_C(  68), INT8_C(  53), INT8_C(  89), INT8_C( -77),
                           INT8_C( -95), INT8_C(  -3), INT8_C(  96), INT8_C( -31),
                           INT8_C(-103), INT8_C( -16), INT8_C( 103), INT8_C(  19),
                           INT8_C( -35), INT8_C( -46), INT8_C(  38), INT8_C(-105),
                           INT8_C(  39), INT8_C( 111), INT8_C( 116), INT8_C( -83)),
      simde_mm256_set_epi8(INT8_C(-107), INT8_C(  48), INT8_C(  54), INT8_C(   1),
                           INT8_C(-111), INT8_C(  44), INT8_C(   1), INT8_C(-106),
                           INT8_C(  15), INT8_C(  70), INT8_C( -56), INT8_C(  61),
                           INT8_C(-114), INT8_C( 127), INT8_C(  -2), INT8_C(-115),
                           INT8_C(-128), INT8_C(-102), INT8_C( -98), INT8_C( -84),
                           INT8_C(  41), INT8_C( -64), INT8_C( -50), INT8_C(-121),
                           INT8_C( 127), INT8_C( -51), INT8_C( 114), INT8_C(  76),
                           INT8_C(  32), INT8_C(  -1), INT8_C( 123), INT8_C( 126)),
      simde_mm256_set_epi8(INT8_C(-107), INT8_C( -15), INT8_C(  48), INT8_C(  20),
                           INT8_C(  54), INT8_C( -88), INT8_C(   1), INT8_C(  19),
                           INT8_C(-111), INT8_C(   9), INT8_C(  44), INT8_C(  82),
                           INT8_C(   1), INT8_C( -23), INT8_C(-106), INT8_C(  71),
                           INT8_C(-128), INT8_C( -95), INT8_C(-102), INT8_C(  -3),
                           INT8_C( -98), INT8_C(  96), INT8_C( -84), INT8_C( -31),
                           INT8_C(  41), INT8_C(-103), INT8_C( -64), INT8_C( -16),
                           INT8_C( -50), INT8_C( 103), INT8_C(-121), INT8_C(  19)) },
    { simde_mm256_set_epi8(INT8_C(  55), INT8_C(-115), INT8_C( -83), INT8_C( -46),
                           INT8_C(  -9), INT8_C(-117), INT8_C( -90), INT8_C( 125),
                           INT8_C( 101), INT8_C( -65), INT8_C( -92), INT8_C( -40),
                           INT8_C(-123), INT8_C(-123), INT8_C( -75), INT8_C( -66),
                           INT8_C( -35), INT8_C(  99), INT8_C(   2), INT8_C( -14),
                           INT8_C( 112), INT8_C(  43), INT8_C(  61), INT8_C( 117),
                           INT8_C( -65), INT8_C( -59), INT8_C(  26), INT8_C(  65),
                           INT8_C(  77), INT8_C( -80), INT8_C( -44), INT8_C( -43)),
      simde_mm256_set_epi8(INT8_C(-100), INT8_C(  88), INT8_C( -93), INT8_C( -17),
                           INT8_C( -79), INT8_C( 101), INT8_C( -79), INT8_C( -53),
                           INT8_C( -78), INT8_C(  41), INT8_C(  93), INT8_C( -10),
                           INT8_C(  23), INT8_C( -80), INT8_C( -49), INT8_C(-125),
                           INT8_C(  90), INT8_C(  77), INT8_C( -52), INT8_C(-119),
                           INT8_C( -58), INT8_C(  -1), INT8_C( -56), INT8_C( -10),
                           INT8_C(-115), INT8_C(-128), INT8_C( -24), INT8_C( -90),
                           INT8_C( -73), INT8_C(  42), INT8_C(  53), INT8_C(  78)),
      simde_mm256_set_epi8(INT8_C(-100), INT8_C(  55), INT8_C(  88), INT8_C(-115),
                           INT8_C( -93), INT8_C( -83), INT8_C( -17), INT8_C( -46),
                           INT8_C( -79), INT8_C(  -9), INT8_C( 101), INT8_C(-117),
                           INT8_C( -79), INT8_C( -90), INT8_C( -53), INT8_C( 125),
                           INT8_C(  90), INT8_C( -35), INT8_C(  77), INT8_C(  99),
                           INT8_C( -52), INT8_C(   2), INT8_C(-119), INT8_C( -14),
                           INT8_C( -58), INT8_C( 112), INT8_C(  -1), INT8_C(  43),
                           INT8_C( -56), INT8_C(  61), INT8_C( -10), INT8_C( 117)) },
    { simde_mm256_set_epi8(INT8_C(  57), INT8_C( -60), INT8_C(  66), INT8_C(  39),
                           INT8_C(  35), INT8_C(  15), INT8_C(  40), INT8_C(   1),
                           INT8_C( -19), INT8_C(  90), INT8_C( -43), INT8_C(  35),
                           INT8_C(  49), INT8_C(-109), INT8_C( -79), INT8_C( -32),
                           INT8_C( -69), INT8_C(-121), INT8_C(  84), INT8_C( -95),
                           INT8_C( -83), INT8_C( 120), INT8_C( -35), INT8_C(  86),
                           INT8_C( -37), INT8_C(-127), INT8_C( -39), INT8_C( -49),
                           INT8_C( -98), INT8_C( 115), INT8_C(-116), INT8_C( -93)),
      simde_mm256_set_epi8(INT8_C(  71), INT8_C(  -6), INT8_C(  63), INT8_C(  38),
                           INT8_C(  88), INT8_C( -67), INT8_C(  37), INT8_C( -30),
                           INT8_C(  75), INT8_C(  31), INT8_C(  90), INT8_C(  41),
                           INT8_C(-128), INT8_C(  10), INT8_C( -34), INT8_C(  57),
                           INT8_C( -37), INT8_C( 100), INT8_C(   5), INT8_C(  -3),
                           INT8_C( -26), INT8_C(  30), INT8_C(  58), INT8_C(  60),
                           INT8_C(  84), INT8_C(  42), INT8_C(-111), INT8_C(-101),
                           INT8_C(  16), INT8_C( -45), INT8_C(  -2), INT8_C(  13)),
      simde_mm256_set_epi8(INT8_C(  71), INT8_C(  57), INT8_C(  -6), INT8_C( -60),
                           INT8_C(  63), INT8_C(  66), INT8_C(  38), INT8_C(  39),
                           INT8_C(  88), INT8_C(  35), INT8_C( -67), INT8_C(  15),
                           INT8_C(  37), INT8_C(  40), INT8_C( -30), INT8_C(   1),
                           INT8_C( -37), INT8_C( -69), INT8_C( 100), INT8_C(-121),
                           INT8_C(   5), INT8_C(  84), INT8_C(  -3), INT8_C( -95),
                           INT8_C( -26), INT8_C( -83), INT8_C(  30), INT8_C( 120),
                           INT8_C(  58), INT8_C( -35), INT8_C(  60), INT8_C(  86)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_unpackhi_epi8(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_unpackhi_epi16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi16(INT16_C( 28196), INT16_C(-19354), INT16_C(  9804), INT16_C(-14507),
                            INT16_C(-13536), INT16_C( 20917), INT16_C(   967), INT16_C(-20246),
                            INT16_C(-10186), INT16_C( -9535), INT16_C(-21783), INT16_C(  1947),
                            INT16_C(  2132), INT16_C(-31037), INT16_C( 14740), INT16_C(  1814)),
      simde_mm256_set_epi16(INT16_C(  5018), INT16_C(-30102), INT16_C(  8885), INT16_C(  7092),
                            INT16_C(-30176), INT16_C( -3016), INT16_C( 25065), INT16_C( 15182),
                            INT16_C( 20584), INT16_C( -3893), INT16_C(  9254), INT16_C(  -555),
                            INT16_C( -1863), INT16_C(-29928), INT16_C(-30040), INT16_C( 20077)),
      simde_mm256_set_epi16(INT16_C(  5018), INT16_C( 28196), INT16_C(-30102), INT16_C(-19354),
                            INT16_C(  8885), INT16_C(  9804), INT16_C(  7092), INT16_C(-14507),
                            INT16_C( 20584), INT16_C(-10186), INT16_C( -3893), INT16_C( -9535),
                            INT16_C(  9254), INT16_C(-21783), INT16_C(  -555), INT16_C(  1947)) },
    { simde_mm256_set_epi16(INT16_C( 24148), INT16_C(-26844), INT16_C(-25824), INT16_C( 11455),
                            INT16_C( -8659), INT16_C( 13962), INT16_C(   642), INT16_C( 30912),
                            INT16_C( 23855), INT16_C(-21952), INT16_C( -2538), INT16_C( 20285),
                            INT16_C( 13723), INT16_C(-27203), INT16_C(  7085), INT16_C(-26650)),
      simde_mm256_set_epi16(INT16_C( -2663), INT16_C(-15563), INT16_C(-16845), INT16_C(-25964),
                            INT16_C(-19994), INT16_C( 11205), INT16_C( -9585), INT16_C( 20135),
                            INT16_C(-16938), INT16_C(-17819), INT16_C(-19377), INT16_C(-10418),
                            INT16_C(  5652), INT16_C(   345), INT16_C(-24270), INT16_C( -4677)),
      simde_mm256_set_epi16(INT16_C( -2663), INT16_C( 24148), INT16_C(-15563), INT16_C(-26844),
                            INT16_C(-16845), INT16_C(-25824), INT16_C(-25964), INT16_C( 11455),
                            INT16_C(-16938), INT16_C( 23855), INT16_C(-17819), INT16_C(-21952),
                            INT16_C(-19377), INT16_C( -2538), INT16_C(-10418), INT16_C( 20285)) },
    { simde_mm256_set_epi16(INT16_C( -9935), INT16_C( -5807), INT16_C( -4566), INT16_C(  9296),
                            INT16_C(  7157), INT16_C( -7813), INT16_C( 31971), INT16_C( 26020),
                            INT16_C(-21643), INT16_C(-19740), INT16_C(  3735), INT16_C(-24663),
                            INT16_C( -5558), INT16_C( 18004), INT16_C(-25263), INT16_C(-18828)),
      simde_mm256_set_epi16(INT16_C( -3706), INT16_C(-10360), INT16_C( 12612), INT16_C(-20501),
                            INT16_C( 11831), INT16_C(-21556), INT16_C(-18710), INT16_C( 17184),
                            INT16_C( 12245), INT16_C(-30371), INT16_C(  2840), INT16_C(  8546),
                            INT16_C(-23833), INT16_C( 19149), INT16_C(   688), INT16_C(  6366)),
      simde_mm256_set_epi16(INT16_C( -3706), INT16_C( -9935), INT16_C(-10360), INT16_C( -5807),
                            INT16_C( 12612), INT16_C( -4566), INT16_C(-20501), INT16_C(  9296),
                            INT16_C( 12245), INT16_C(-21643), INT16_C(-30371), INT16_C(-19740),
                            INT16_C(  2840), INT16_C(  3735), INT16_C(  8546), INT16_C(-24663)) },
    { simde_mm256_set_epi16(INT16_C( 14882), INT16_C(-14375), INT16_C( -5870), INT16_C( -5698),
                            INT16_C(  1829), INT16_C(  5020), INT16_C(  8224), INT16_C( -7222),
                            INT16_C(-30958), INT16_C(-10885), INT16_C( 13942), INT16_C( 22894),
                            INT16_C( 26157), INT16_C(-23632), INT16_C( 26556), INT16_C( -3542)),
      simde_mm256_set_epi16(INT16_C(-10931), INT16_C( 19441), INT16_C( -4465), INT16_C(  4406),
                            INT16_C( 16020), INT16_C( 26201), INT16_C( 25476), INT16_C( 21164),
                            INT16_C(-22646), INT16_C(-29482), INT16_C(  6258), INT16_C(-24419),
                            INT16_C( 18662), INT16_C(-31207), INT16_C( 31969), INT16_C(-18662)),
      simde_mm256_set_epi16(INT16_C(-10931), INT16_C( 14882), INT16_C( 19441), INT16_C(-14375),
                            INT16_C( -4465), INT16_C( -5870), INT16_C(  4406), INT16_C( -5698),
                            INT16_C(-22646), INT16_C(-30958), INT16_C(-29482), INT16_C(-10885),
                            INT16_C(  6258), INT16_C( 13942), INT16_C(-24419), INT16_C( 22894)) },
    { simde_mm256_set_epi16(INT16_C( 29539), INT16_C(   676), INT16_C(   123), INT16_C(-11161),
                            INT16_C(-30201), INT16_C( -2387), INT16_C( 24111), INT16_C( 19679),
                            INT16_C( 23083), INT16_C(-21338), INT16_C( -7843), INT16_C( 32608),
                            INT16_C(-24773), INT16_C( 13353), INT16_C( 17164), INT16_C( -2488)),
      simde_mm256_set_epi16(INT16_C( -5138), INT16_C( 29730), INT16_C( 16993), INT16_C( 30231),
                            INT16_C( -2118), INT16_C( 20012), INT16_C(-32476), INT16_C(  2319),
                            INT16_C(-28250), INT16_C(-23799), INT16_C(  9274), INT16_C( 28645),
                            INT16_C(  5189), INT16_C( -5020), INT16_C( -4150), INT16_C(-15571)),
      simde_mm256_set_epi16(INT16_C( -5138), INT16_C( 29539), INT16_C( 29730), INT16_C(   676),
                            INT16_C( 16993), INT16_C(   123), INT16_C( 30231), INT16_C(-11161),
                            INT16_C(-28250), INT16_C( 23083), INT16_C(-23799), INT16_C(-21338),
                            INT16_C(  9274), INT16_C( -7843), INT16_C( 28645), INT16_C( 32608)) },
    { simde_mm256_set_epi16(INT16_C(-27710), INT16_C(-18125), INT16_C( 10296), INT16_C( 21376),
                            INT16_C( 23378), INT16_C(-22935), INT16_C(-22914), INT16_C(-31313),
                            INT16_C( 22251), INT16_C( 14011), INT16_C( -6668), INT16_C( 16302),
                            INT16_C( 11015), INT16_C( -1790), INT16_C(-19054), INT16_C( 25215)),
      simde_mm256_set_epi16(INT16_C( 32531), INT16_C( -2485), INT16_C(-25139), INT16_C( 32419),
                            INT16_C( -2942), INT16_C(-32258), INT16_C( -7635), INT16_C( 12558),
                            INT16_C( 15559), INT16_C( -1904), INT16_C( 27475), INT16_C(-12566),
                            INT16_C(-17567), INT16_C(-27853), INT16_C(-24500), INT16_C( 12726)),
      simde_mm256_set_epi16(INT16_C( 32531), INT16_C(-27710), INT16_C( -2485), INT16_C(-18125),
                            INT16_C(-25139), INT16_C( 10296), INT16_C( 32419), INT16_C( 21376),
                            INT16_C( 15559), INT16_C( 22251), INT16_C( -1904), INT16_C( 14011),
                            INT16_C( 27475), INT16_C( -6668), INT16_C(-12566), INT16_C( 16302)) },
    { simde_mm256_set_epi16(INT16_C(  4586), INT16_C(-13896), INT16_C( 23081), INT16_C(-20860),
                            INT16_C( 27330), INT16_C( 28170), INT16_C( 24215), INT16_C(  4688),
                            INT16_C( 19543), INT16_C( 27682), INT16_C(-31899), INT16_C( 32041),
                            INT16_C( -8944), INT16_C( 18325), INT16_C(-13926), INT16_C( 24617)),
      simde_mm256_set_epi16(INT16_C(-21223), INT16_C( -4083), INT16_C( 21224), INT16_C(-26984),
                            INT16_C( 30248), INT16_C( 30434), INT16_C( 22265), INT16_C(  8187),
                            INT16_C( 29805), INT16_C( -7428), INT16_C( 31794), INT16_C(  7354),
                            INT16_C(-23403), INT16_C( 17371), INT16_C(-31138), INT16_C( 16031)),
      simde_mm256_set_epi16(INT16_C(-21223), INT16_C(  4586), INT16_C( -4083), INT16_C(-13896),
                            INT16_C( 21224), INT16_C( 23081), INT16_C(-26984), INT16_C(-20860),
                            INT16_C( 29805), INT16_C( 19543), INT16_C( -7428), INT16_C( 27682),
                            INT16_C( 31794), INT16_C(-31899), INT16_C(  7354), INT16_C( 32041)) },
    { simde_mm256_set_epi16(INT16_C( -9151), INT16_C(-30324), INT16_C( 22631), INT16_C(   344),
                            INT16_C(  4713), INT16_C( 10238), INT16_C(-10751), INT16_C(-14572),
                            INT16_C(  3790), INT16_C(  8629), INT16_C(  9946), INT16_C( 31127),
                            INT16_C( -9819), INT16_C(  4727), INT16_C( 30741), INT16_C(-20627)),
      simde_mm256_set_epi16(INT16_C(-23421), INT16_C( -2678), INT16_C( 28254), INT16_C( -2905),
                            INT16_C(  6237), INT16_C( 10685), INT16_C( 27961), INT16_C( 15513),
                            INT16_C(  7306), INT16_C(-32072), INT16_C(-26874), INT16_C( 25112),
                            INT16_C( -3381), INT16_C(-22461), INT16_C( -7476), INT16_C(-19391)),
      simde_mm256_set_epi16(INT16_C(-23421), INT16_C( -9151), INT16_C( -2678), INT16_C(-30324),
                            INT16_C( 28254), INT16_C( 22631), INT16_C( -2905), INT16_C(   344),
                            INT16_C(  7306), INT16_C(  3790), INT16_C(-32072), INT16_C(  8629),
                            INT16_C(-26874), INT16_C(  9946), INT16_C( 25112), INT16_C( 31127)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_unpackhi_epi16(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_unpackhi_epi32(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi32(INT32_C( 1912850859), INT32_C(  967654585), INT32_C( 1199101495), INT32_C( 1020867807),
                            INT32_C(-1113017403), INT32_C( 1207205853), INT32_C(-1283015323), INT32_C( -865603422)),
      simde_mm256_set_epi32(INT32_C(  439671122), INT32_C( -834176430), INT32_C( 1316719462), INT32_C(  794894521),
                            INT32_C( -364012057), INT32_C(-1283491930), INT32_C( -229222523), INT32_C( -489560867)),
      simde_mm256_set_epi32(INT32_C(  439671122), INT32_C( 1912850859), INT32_C( -834176430), INT32_C(  967654585),
                            INT32_C( -364012057), INT32_C(-1113017403), INT32_C(-1283491930), INT32_C( 1207205853)) },
    { simde_mm256_set_epi32(INT32_C(-1043075301), INT32_C(-1205379203), INT32_C( -623218356), INT32_C(-1709643548),
                            INT32_C(  -53386540), INT32_C( 1999540953), INT32_C( 2146270924), INT32_C( 1577977486)),
      simde_mm256_set_epi32(INT32_C( 1416708497), INT32_C( 1977290590), INT32_C( -799631345), INT32_C( -699557932),
                            INT32_C( -779666453), INT32_C(-1556766589), INT32_C( 1459438848), INT32_C(  777616978)),
      simde_mm256_set_epi32(INT32_C( 1416708497), INT32_C(-1043075301), INT32_C( 1977290590), INT32_C(-1205379203),
                            INT32_C( -779666453), INT32_C(  -53386540), INT32_C(-1556766589), INT32_C( 1999540953)) },
    { simde_mm256_set_epi32(INT32_C(-1262008529), INT32_C(  995722237), INT32_C( 1921619936), INT32_C(-2112826366),
                            INT32_C( -393450028), INT32_C( 1344594991), INT32_C( 2093675145), INT32_C(  760241232)),
      simde_mm256_set_epi32(INT32_C( 1015857134), INT32_C( 1981903036), INT32_C( 1927114874), INT32_C( 1164834454),
                            INT32_C( -157704373), INT32_C(-1887449946), INT32_C(-1985956729), INT32_C(-2099334634)),
      simde_mm256_set_epi32(INT32_C( 1015857134), INT32_C(-1262008529), INT32_C( 1981903036), INT32_C(  995722237),
                            INT32_C( -157704373), INT32_C( -393450028), INT32_C(-1887449946), INT32_C( 1344594991)) },
    { simde_mm256_set_epi32(INT32_C(  212170692), INT32_C(  815869922), INT32_C(   20080222), INT32_C(  -75417640),
                            INT32_C( -503678651), INT32_C( -834592925), INT32_C( 1707747009), INT32_C( -254760969)),
      simde_mm256_set_epi32(INT32_C( -574627621), INT32_C( -890978529), INT32_C( 2077265887), INT32_C(  842919754),
                            INT32_C( -486905662), INT32_C(  988851226), INT32_C(-1518229684), INT32_C( 1816570667)),
      simde_mm256_set_epi32(INT32_C( -574627621), INT32_C(  212170692), INT32_C( -890978529), INT32_C(  815869922),
                            INT32_C( -486905662), INT32_C( -503678651), INT32_C(  988851226), INT32_C( -834592925)) },
    { simde_mm256_set_epi32(INT32_C( 1459349320), INT32_C( -943790006), INT32_C(  424384832), INT32_C(  113065932),
                            INT32_C(  -80059372), INT32_C(  814075306), INT32_C( 1255708904), INT32_C(  894835823)),
      simde_mm256_set_epi32(INT32_C( 1159658953), INT32_C(  513900351), INT32_C( 1274799760), INT32_C(  661217108),
                            INT32_C(-1116902016), INT32_C( 1264134407), INT32_C( 1996134185), INT32_C( -620124201)),
      simde_mm256_set_epi32(INT32_C( 1159658953), INT32_C( 1459349320), INT32_C(  513900351), INT32_C( -943790006),
                            INT32_C(-1116902016), INT32_C(  -80059372), INT32_C( 1264134407), INT32_C(  814075306)) },
    { simde_mm256_set_epi32(INT32_C( 1669821560), INT32_C( -524933447), INT32_C(-1923407638), INT32_C( 1748809176),
                            INT32_C(  -67073492), INT32_C(-1589224355), INT32_C(-1890395480), INT32_C(  650020033)),
      simde_mm256_set_epi32(INT32_C( 1449046752), INT32_C(   11693105), INT32_C(  225889559), INT32_C( 1195957602),
                            INT32_C( -790861669), INT32_C(  894225381), INT32_C( 1788797029), INT32_C( 1410983650)),
      simde_mm256_set_epi32(INT32_C( 1449046752), INT32_C( 1669821560), INT32_C(   11693105), INT32_C( -524933447),
                            INT32_C( -790861669), INT32_C(  -67073492), INT32_C(  894225381), INT32_C(-1589224355)) },
    { simde_mm256_set_epi32(INT32_C(  166836505), INT32_C(   35920603), INT32_C(  209405330), INT32_C(-1870274444),
                            INT32_C(-2065187438), INT32_C(-1749203354), INT32_C(-1834771489), INT32_C( 1795755804)),
      simde_mm256_set_epi32(INT32_C(  863607209), INT32_C(  671761907), INT32_C(-1319646828), INT32_C(  236938511),
                            INT32_C(  277292323), INT32_C(-1226502074), INT32_C( 1319858080), INT32_C( 1103529470)),
      simde_mm256_set_epi32(INT32_C(  863607209), INT32_C(  166836505), INT32_C(  671761907), INT32_C(   35920603),
                            INT32_C(  277292323), INT32_C(-2065187438), INT32_C(-1226502074), INT32_C(-1749203354)) },
    { simde_mm256_set_epi32(INT32_C(  -91786742), INT32_C(-1505313832), INT32_C( 1530067112), INT32_C(-1201437931),
                            INT32_C(-1252606163), INT32_C( 1723954910), INT32_C(  348258249), INT32_C( -864462904)),
      simde_mm256_set_epi32(INT32_C(  926816633), INT32_C( -705859720), INT32_C( 1728076763), INT32_C(-1714964607),
                            INT32_C( -194394697), INT32_C( -494196608), INT32_C( 1804204829), INT32_C(-1267214668)),
      simde_mm256_set_epi32(INT32_C(  926816633), INT32_C(  -91786742), INT32_C( -705859720), INT32_C(-1505313832),
                            INT32_C( -194394697), INT32_C(-1252606163), INT32_C( -494196608), INT32_C( 1723954910)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_unpackhi_epi32(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_unpackhi_epi64(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi64x(INT64_C( 8215631882498161849), INT64_C( 5150101706630575327),
                             INT64_C(-4780373344556646435), INT64_C(-5510508849122512734)),
      simde_mm256_set_epi64x(INT64_C( 1888373093446416978), INT64_C( 5655267028091609273),
                             INT64_C(-1563419877153212506), INT64_C( -984503235986201379)),
      simde_mm256_set_epi64x(INT64_C( 1888373093446416978), INT64_C( 8215631882498161849),
                             INT64_C(-1563419877153212506), INT64_C(-4780373344556646435)) },
    { simde_mm256_set_epi64x(INT64_C(-4479974301970768003), INT64_C(-2676702454701561628),
                             INT64_C( -229293441347054887), INT64_C( 9218163428513678990)),
      simde_mm256_set_epi64x(INT64_C( 6084716664557604702), INT64_C(-3434390472036083756),
                             INT64_C(-3348641914685120381), INT64_C( 6268242123449531986)),
      simde_mm256_set_epi64x(INT64_C( 6084716664557604702), INT64_C(-4479974301970768003),
                             INT64_C(-3348641914685120381), INT64_C( -229293441347054887)) },
    { simde_mm256_set_epi64x(INT64_C(-5420285358332345347), INT64_C( 8253294782643753986),
                             INT64_C(-1689855001525689297), INT64_C( 8992266276983299152)),
      simde_mm256_set_epi64x(INT64_C( 4363073169920192700), INT64_C( 8276895360629995158),
                             INT64_C( -677335122063668058), INT64_C(-8529619200130502122)),
      simde_mm256_set_epi64x(INT64_C( 4363073169920192700), INT64_C(-5420285358332345347),
                             INT64_C( -677335122063668058), INT64_C(-1689855001525689297)) },
    { simde_mm256_set_epi64x(INT64_C(  911266184125558754), INT64_C(   86243901005969368),
                             INT64_C(-2163283330278023325), INT64_C( 7334717557537023991)),
      simde_mm256_set_epi64x(INT64_C(-2468006836169294049), INT64_C( 8921789050604351306),
                             INT64_C(-2091243893538378726), INT64_C(-6520746838779843797)),
      simde_mm256_set_epi64x(INT64_C(-2468006836169294049), INT64_C(  911266184125558754),
                             INT64_C(-2091243893538378726), INT64_C(-2163283330278023325)) },
    { simde_mm256_set_epi64x(INT64_C( 6267857606191016010), INT64_C( 1822718974471520204),
                             INT64_C( -343852383664222806), INT64_C( 5393228676870839407)),
      simde_mm256_set_epi64x(INT64_C( 4980697278162501439), INT64_C( 5475223278809866068),
                             INT64_C(-4797057630292334329), INT64_C( 8573331046677456855)),
      simde_mm256_set_epi64x(INT64_C( 4980697278162501439), INT64_C( 6267857606191016010),
                             INT64_C(-4797057630292334329), INT64_C( -343852383664222806)) },
    { simde_mm256_set_epi64x(INT64_C( 7171828994125735609), INT64_C(-8260972900337797672),
                             INT64_C( -288078451862774691), INT64_C(-8119186762456202047)),
      simde_mm256_set_epi64x(INT64_C( 6223608410226715697), INT64_C(  970188269608820066),
                             INT64_C(-3396725003120751643), INT64_C( 7682824740147947234)),
      simde_mm256_set_epi64x(INT64_C( 6223608410226715697), INT64_C( 7171828994125735609),
                             INT64_C(-3396725003120751643), INT64_C( -288078451862774691)) },
    { simde_mm256_set_epi64x(INT64_C(  716557332789861083), INT64_C(  899389046382780532),
                             INT64_C(-8869912503774263706), INT64_C(-7880283539092467940)),
      simde_mm256_set_epi64x(INT64_C( 3709164719916598771), INT64_C(-5667839968293198577),
                             INT64_C( 1190961461785333830), INT64_C( 5668747290064881150)),
      simde_mm256_set_epi64x(INT64_C( 3709164719916598771), INT64_C(  716557332789861083),
                             INT64_C( 1190961461785333830), INT64_C(-8869912503774263706)) },
    { simde_mm256_set_epi64x(INT64_C( -394221052306736168), INT64_C( 6571588209818698517),
                             INT64_C(-5379902503129090338), INT64_C( 1495757793447729096)),
      simde_mm256_set_epi64x(INT64_C( 3980647131712941944), INT64_C( 7422033184642545537),
                             INT64_C( -834918862330058624), INT64_C( 7749000738868025012)),
      simde_mm256_set_epi64x(INT64_C( 3980647131712941944), INT64_C( -394221052306736168),
                             INT64_C( -834918862330058624), INT64_C(-5379902503129090338)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_unpackhi_epi64(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i64(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_xor_si256(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi64x(INT64_C( 5259297934522696228), INT64_C( -431388325374833226),
                             INT64_C(-9156654280217339654), INT64_C( 3013799969040676174)),
      simde_mm256_set_epi64x(INT64_C(-5610681863545377343), INT64_C(  612481038911101319),
                             INT64_C( 6883094940018615339), INT64_C( 5567527613349466758)),
      simde_mm256_set_epi64x(INT64_C( -369826194426859547), INT64_C( -973728768696970191),
                             INT64_C(-2348436908296831791), INT64_C( 7246573032282466248)) },
    { simde_mm256_set_epi64x(INT64_C( 3972970387578047990), INT64_C(-3229803026080205617),
                             INT64_C(-6416566799554918012), INT64_C( 7243493956554503841)),
      simde_mm256_set_epi64x(INT64_C(-2328069278528400967), INT64_C( -866344990039815627),
                             INT64_C( 5191362241164177707), INT64_C( 6965508020004735797)),
      simde_mm256_set_epi64x(INT64_C(-1687764814515086257), INT64_C( 2366483896335154938),
                             INT64_C(-1227043938297071441), INT64_C(  300751355152891284)) },
    { simde_mm256_set_epi64x(INT64_C(-2206747055975530789), INT64_C( 4273990306427029435),
                             INT64_C(-8066951550635951807), INT64_C(-6928425273442710875)),
      simde_mm256_set_epi64x(INT64_C(-4939687486626430761), INT64_C(-1679871113178117518),
                             INT64_C( -257233978894060261), INT64_C( 3512456176079583747)),
      simde_mm256_set_epi64x(INT64_C( 6490456006491962892), INT64_C(-3170633551353754167),
                             INT64_C( 7809929228804508762), INT64_C(-5807521855463853914)) },
    { simde_mm256_set_epi64x(INT64_C(-8921324304875098515), INT64_C( 7821700200964206339),
                             INT64_C( 2994261353466796408), INT64_C(-3540068018343188204)),
      simde_mm256_set_epi64x(INT64_C( 4294357400656496399), INT64_C( 3626952931332295508),
                             INT64_C(-7673859083891959013), INT64_C( 1757595472193292730)),
      simde_mm256_set_epi64x(INT64_C(-4636023147992241822), INT64_C( 6834710091372766295),
                             INT64_C(-4896194530503130525), INT64_C(-2973751098574872402)) },
    { simde_mm256_set_epi64x(INT64_C( 6035067220796971838), INT64_C(  776715589999365452),
                             INT64_C( 6384421609504908311), INT64_C(-8816267298986390401)),
      simde_mm256_set_epi64x(INT64_C(-5739247744839421985), INT64_C( 4653816358777581262),
                             INT64_C( 1021833051660996174), INT64_C(-2812490060666099514)),
      simde_mm256_set_epi64x(INT64_C(-2046106215006112543), INT64_C( 5355589079452705666),
                             INT64_C( 6247691286445288025), INT64_C( 6727907985691518137)) },
    { simde_mm256_set_epi64x(INT64_C( 8351942705843556286), INT64_C(-6873744911563016812),
                             INT64_C(-3359807879676804643), INT64_C( 8110291315370526762)),
      simde_mm256_set_epi64x(INT64_C( -126725188666547082), INT64_C( 4977977654704902461),
                             INT64_C(-7727661347289141755), INT64_C( 7453179086506187618)),
      simde_mm256_set_epi64x(INT64_C(-8226449520241153080), INT64_C(-1905346832462535511),
                             INT64_C( 5016522326789730264), INT64_C( 1721087647877354312)) },
    { simde_mm256_set_epi64x(INT64_C(-3541650301143541882), INT64_C( 2340510988864802758),
                             INT64_C(-2484352519219712887), INT64_C(-7823366500674586971)),
      simde_mm256_set_epi64x(INT64_C( 8787496485572343767), INT64_C( 5972980855318355117),
                             INT64_C( 1254817555351506981), INT64_C( 3585972827969393388)),
      simde_mm256_set_epi64x(INT64_C(-5248115586102763439), INT64_C( 8259425971222532971),
                             INT64_C(-3679494355159515988), INT64_C(-6724368097479220151)) },
    { simde_mm256_set_epi64x(INT64_C(-8306510049557921760), INT64_C(-3952727854475033325),
                             INT64_C(-2945542500559658351), INT64_C(  937552523927336948)),
      simde_mm256_set_epi64x(INT64_C( 4952101385331357252), INT64_C( 3142376059888144776),
                             INT64_C(-5526391810306106309), INT64_C( 1965153668529504230)),
      simde_mm256_set_epi64x(INT64_C(-4035158306098612636), INT64_C(-2108000641444326245),
                             INT64_C( 7228588967820590762), INT64_C( 1605387943167658002)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_xor_si256(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i64(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_max_epu16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
         { simde_x_mm256_set_epu16(UINT16_C( 46627), UINT16_C( 59720), UINT16_C( 61906), UINT16_C( 11658),
                              UINT16_C( 20044), UINT16_C( 39774), UINT16_C( 13081), UINT16_C( 26580),
                              UINT16_C( 18209), UINT16_C( 20949), UINT16_C( 29177), UINT16_C( 31372),
                              UINT16_C(  2292), UINT16_C(  1480), UINT16_C( 23053), UINT16_C( 14592)),
      simde_x_mm256_set_epu16(UINT16_C( 18663), UINT16_C( 17474), UINT16_C( 64035), UINT16_C( 52566),
                              UINT16_C( 14212), UINT16_C( 10671), UINT16_C( 65410), UINT16_C( 60796),
                              UINT16_C( 54296), UINT16_C( 44956), UINT16_C(  2247), UINT16_C(  1960),
                              UINT16_C( 42291), UINT16_C( 26784), UINT16_C( 22137), UINT16_C( 30865)),
      simde_x_mm256_set_epu16(UINT16_C( 46627), UINT16_C( 59720), UINT16_C( 64035), UINT16_C( 52566),
                              UINT16_C( 20044), UINT16_C( 39774), UINT16_C( 65410), UINT16_C( 60796),
                              UINT16_C( 54296), UINT16_C( 44956), UINT16_C( 29177), UINT16_C( 31372),
                              UINT16_C( 42291), UINT16_C( 26784), UINT16_C( 23053), UINT16_C( 30865)) },
    { simde_x_mm256_set_epu16(UINT16_C( 18263), UINT16_C( 58739), UINT16_C( 63639), UINT16_C( 55084),
                              UINT16_C( 26185), UINT16_C( 41545), UINT16_C( 59964), UINT16_C( 12474),
                              UINT16_C( 53086), UINT16_C( 18094), UINT16_C( 30753), UINT16_C( 29484),
                              UINT16_C( 20722), UINT16_C( 11313), UINT16_C( 13962), UINT16_C( 39972)),
      simde_x_mm256_set_epu16(UINT16_C( 58325), UINT16_C( 58948), UINT16_C( 43545), UINT16_C( 59756),
                              UINT16_C( 12295), UINT16_C( 57147), UINT16_C( 58632), UINT16_C( 46109),
                              UINT16_C( 49795), UINT16_C(  8909), UINT16_C(  2266), UINT16_C( 36324),
                              UINT16_C( 59196), UINT16_C( 64507), UINT16_C(  7734), UINT16_C( 45358)),
      simde_x_mm256_set_epu16(UINT16_C( 58325), UINT16_C( 58948), UINT16_C( 63639), UINT16_C( 59756),
                              UINT16_C( 26185), UINT16_C( 57147), UINT16_C( 59964), UINT16_C( 46109),
                              UINT16_C( 53086), UINT16_C( 18094), UINT16_C( 30753), UINT16_C( 36324),
                              UINT16_C( 59196), UINT16_C( 64507), UINT16_C( 13962), UINT16_C( 45358)) },
    { simde_x_mm256_set_epu16(UINT16_C( 39984), UINT16_C( 47951), UINT16_C( 65190), UINT16_C( 48692),
                              UINT16_C( 48663), UINT16_C( 53744), UINT16_C( 12623), UINT16_C( 35136),
                              UINT16_C(  1353), UINT16_C( 21406), UINT16_C( 10132), UINT16_C( 27940),
                              UINT16_C(  4906), UINT16_C( 10556), UINT16_C( 20269), UINT16_C( 18864)),
      simde_x_mm256_set_epu16(UINT16_C( 52708), UINT16_C( 50460), UINT16_C( 39275), UINT16_C( 31341),
                              UINT16_C( 59248), UINT16_C( 23377), UINT16_C( 29345), UINT16_C( 50829),
                              UINT16_C(  4977), UINT16_C( 15093), UINT16_C( 36151), UINT16_C( 58243),
                              UINT16_C( 16819), UINT16_C( 62076), UINT16_C( 48614), UINT16_C(  2944)),
      simde_x_mm256_set_epu16(UINT16_C( 52708), UINT16_C( 50460), UINT16_C( 65190), UINT16_C( 48692),
                              UINT16_C( 59248), UINT16_C( 53744), UINT16_C( 29345), UINT16_C( 50829),
                              UINT16_C(  4977), UINT16_C( 21406), UINT16_C( 36151), UINT16_C( 58243),
                              UINT16_C( 16819), UINT16_C( 62076), UINT16_C( 48614), UINT16_C( 18864)) },
    { simde_x_mm256_set_epu16(UINT16_C( 14954), UINT16_C( 41703), UINT16_C( 49393), UINT16_C( 33328),
                              UINT16_C( 13198), UINT16_C(  8963), UINT16_C( 20974), UINT16_C( 46796),
                              UINT16_C(  4895), UINT16_C(  2875), UINT16_C( 62027), UINT16_C( 51154),
                              UINT16_C( 19247), UINT16_C( 34899), UINT16_C( 65019), UINT16_C( 60032)),
      simde_x_mm256_set_epu16(UINT16_C( 58187), UINT16_C(  7429), UINT16_C( 29396), UINT16_C( 13821),
                              UINT16_C( 33371), UINT16_C(  1928), UINT16_C( 49379), UINT16_C(   722),
                              UINT16_C( 28382), UINT16_C( 55366), UINT16_C( 43323), UINT16_C( 47667),
                              UINT16_C(  5125), UINT16_C( 60684), UINT16_C( 59616), UINT16_C( 50280)),
      simde_x_mm256_set_epu16(UINT16_C( 58187), UINT16_C( 41703), UINT16_C( 49393), UINT16_C( 33328),
                              UINT16_C( 33371), UINT16_C(  8963), UINT16_C( 49379), UINT16_C( 46796),
                              UINT16_C( 28382), UINT16_C( 55366), UINT16_C( 62027), UINT16_C( 51154),
                              UINT16_C( 19247), UINT16_C( 60684), UINT16_C( 65019), UINT16_C( 60032)) },
    { simde_x_mm256_set_epu16(UINT16_C( 27739), UINT16_C( 29065), UINT16_C( 56947), UINT16_C( 55426),
                              UINT16_C( 46492), UINT16_C( 58959), UINT16_C( 17884), UINT16_C(   106),
                              UINT16_C( 40322), UINT16_C( 13650), UINT16_C( 50675), UINT16_C( 30885),
                              UINT16_C(  7879), UINT16_C(  4114), UINT16_C( 54484), UINT16_C( 15816)),
      simde_x_mm256_set_epu16(UINT16_C( 43597), UINT16_C( 65192), UINT16_C( 43740), UINT16_C( 54700),
                              UINT16_C( 31952), UINT16_C( 20957), UINT16_C( 20261), UINT16_C( 50955),
                              UINT16_C( 37051), UINT16_C( 36093), UINT16_C( 59438), UINT16_C( 28726),
                              UINT16_C(  6886), UINT16_C( 52003), UINT16_C( 19596), UINT16_C( 59577)),
      simde_x_mm256_set_epu16(UINT16_C( 43597), UINT16_C( 65192), UINT16_C( 56947), UINT16_C( 55426),
                              UINT16_C( 46492), UINT16_C( 58959), UINT16_C( 20261), UINT16_C( 50955),
                              UINT16_C( 40322), UINT16_C( 36093), UINT16_C( 59438), UINT16_C( 30885),
                              UINT16_C(  7879), UINT16_C( 52003), UINT16_C( 54484), UINT16_C( 59577)) },
    { simde_x_mm256_set_epu16(UINT16_C( 57657), UINT16_C( 13117), UINT16_C( 60292), UINT16_C( 65452),
                              UINT16_C(   694), UINT16_C( 21975), UINT16_C( 46000), UINT16_C( 22467),
                              UINT16_C( 60775), UINT16_C(  6084), UINT16_C( 52920), UINT16_C( 10893),
                              UINT16_C( 33722), UINT16_C( 16366), UINT16_C(   746), UINT16_C( 51289)),
      simde_x_mm256_set_epu16(UINT16_C( 18878), UINT16_C( 35582), UINT16_C( 34313), UINT16_C( 41553),
                              UINT16_C( 15025), UINT16_C( 13655), UINT16_C( 30842), UINT16_C( 55976),
                              UINT16_C( 55306), UINT16_C(  8486), UINT16_C( 20326), UINT16_C( 56205),
                              UINT16_C(  9516), UINT16_C(  5604), UINT16_C( 41707), UINT16_C( 23844)),
      simde_x_mm256_set_epu16(UINT16_C( 57657), UINT16_C( 35582), UINT16_C( 60292), UINT16_C( 65452),
                              UINT16_C( 15025), UINT16_C( 21975), UINT16_C( 46000), UINT16_C( 55976),
                              UINT16_C( 60775), UINT16_C(  8486), UINT16_C( 52920), UINT16_C( 56205),
                              UINT16_C( 33722), UINT16_C( 16366), UINT16_C( 41707), UINT16_C( 51289)) },
    { simde_x_mm256_set_epu16(UINT16_C( 35061), UINT16_C( 31271), UINT16_C( 44458), UINT16_C( 43999),
                              UINT16_C( 52764), UINT16_C( 24092), UINT16_C( 55278), UINT16_C(  9729),
                              UINT16_C( 30350), UINT16_C( 35228), UINT16_C( 24843), UINT16_C( 46927),
                              UINT16_C( 47959), UINT16_C(  8348), UINT16_C( 39137), UINT16_C( 59054)),
      simde_x_mm256_set_epu16(UINT16_C( 18920), UINT16_C( 22899), UINT16_C(  4131), UINT16_C( 54549),
                              UINT16_C( 33095), UINT16_C( 25760), UINT16_C(  6465), UINT16_C( 12263),
                              UINT16_C( 47803), UINT16_C( 61613), UINT16_C( 51708), UINT16_C( 45746),
                              UINT16_C( 59719), UINT16_C(  2919), UINT16_C( 24086), UINT16_C(  5665)),
      simde_x_mm256_set_epu16(UINT16_C( 35061), UINT16_C( 31271), UINT16_C( 44458), UINT16_C( 54549),
                              UINT16_C( 52764), UINT16_C( 25760), UINT16_C( 55278), UINT16_C( 12263),
                              UINT16_C( 47803), UINT16_C( 61613), UINT16_C( 51708), UINT16_C( 46927),
                              UINT16_C( 59719), UINT16_C(  8348), UINT16_C( 39137), UINT16_C( 59054)) },
    { simde_x_mm256_set_epu16(UINT16_C( 46764), UINT16_C( 51381), UINT16_C( 57954), UINT16_C( 11573),
                              UINT16_C( 40336), UINT16_C( 26367), UINT16_C( 17948), UINT16_C( 58963),
                              UINT16_C( 63320), UINT16_C( 30133), UINT16_C( 13248), UINT16_C(  4541),
                              UINT16_C( 43652), UINT16_C(  3442), UINT16_C(   602), UINT16_C( 59909)),
      simde_x_mm256_set_epu16(UINT16_C( 34844), UINT16_C( 11763), UINT16_C( 21582), UINT16_C( 37103),
                              UINT16_C( 62839), UINT16_C( 48595), UINT16_C( 34664), UINT16_C( 65307),
                              UINT16_C( 42742), UINT16_C(  1820), UINT16_C( 54309), UINT16_C( 55027),
                              UINT16_C( 64764), UINT16_C( 27300), UINT16_C( 20131), UINT16_C( 43537)),
      simde_x_mm256_set_epu16(UINT16_C( 46764), UINT16_C( 51381), UINT16_C( 57954), UINT16_C( 37103),
                              UINT16_C( 62839), UINT16_C( 48595), UINT16_C( 34664), UINT16_C( 65307),
                              UINT16_C( 63320), UINT16_C( 30133), UINT16_C( 54309), UINT16_C( 55027),
                              UINT16_C( 64764), UINT16_C( 27300), UINT16_C( 20131), UINT16_C( 59909)) }

  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_max_epu16(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_u16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_max_epu32(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_x_mm256_set_epu32(UINT32_C(3051572045), UINT32_C(3545123096), UINT32_C( 539532434), UINT32_C(2726067579),
                              UINT32_C(3419329411), UINT32_C(3056421163), UINT32_C(2937475413), UINT32_C( 891304178)),
      simde_x_mm256_set_epu32(UINT32_C(3684521838), UINT32_C(3664092042), UINT32_C( 648541541), UINT32_C( 272930365),
                              UINT32_C( 675916127), UINT32_C(1720002587), UINT32_C(1082929595), UINT32_C( 984837149)),
      simde_x_mm256_set_epu32(UINT32_C(3684521838), UINT32_C(3664092042), UINT32_C( 648541541), UINT32_C(2726067579),
                              UINT32_C(3419329411), UINT32_C(3056421163), UINT32_C(2937475413), UINT32_C( 984837149)) },
    { simde_x_mm256_set_epu32(UINT32_C(2114544969), UINT32_C( 863431180), UINT32_C(2929790297), UINT32_C(1508406092),
                              UINT32_C(1766188399), UINT32_C(3527468216), UINT32_C(1207097510), UINT32_C(3902158588)),
      simde_x_mm256_set_epu32(UINT32_C(4246012734), UINT32_C(1929345650), UINT32_C(3025365238), UINT32_C(3355971563),
                              UINT32_C(3310140776), UINT32_C(2715842442), UINT32_C(2891355465), UINT32_C(4115361740)),
      simde_x_mm256_set_epu32(UINT32_C(4246012734), UINT32_C(1929345650), UINT32_C(3025365238), UINT32_C(3355971563),
                              UINT32_C(3310140776), UINT32_C(3527468216), UINT32_C(2891355465), UINT32_C(4115361740)) },
    { simde_x_mm256_set_epu32(UINT32_C(1001663617), UINT32_C(3733133836), UINT32_C(2215256808), UINT32_C(2636746621),
                              UINT32_C(1004506231), UINT32_C(4292057274), UINT32_C(1794485537), UINT32_C(2483395991)),
      simde_x_mm256_set_epu32(UINT32_C(3187837407), UINT32_C( 282146620), UINT32_C(3384289392), UINT32_C(3287894196),
                              UINT32_C(1516921107), UINT32_C( 874312086), UINT32_C(1365725481), UINT32_C(2010925515)),
      simde_x_mm256_set_epu32(UINT32_C(3187837407), UINT32_C(3733133836), UINT32_C(3384289392), UINT32_C(3287894196),
                              UINT32_C(1516921107), UINT32_C(4292057274), UINT32_C(1794485537), UINT32_C(2483395991)) },
    { simde_x_mm256_set_epu32(UINT32_C(1825864990), UINT32_C(3651632677), UINT32_C(1848482644), UINT32_C(4217806782),
                              UINT32_C(3557654096), UINT32_C( 849332445), UINT32_C( 114697269), UINT32_C( 674786807)),
      simde_x_mm256_set_epu32(UINT32_C(1779504954), UINT32_C(1699927403), UINT32_C(2934040606), UINT32_C(4177282687),
                              UINT32_C(3450483742), UINT32_C(3231995683), UINT32_C(2093833738), UINT32_C( 336221368)),
      simde_x_mm256_set_epu32(UINT32_C(1825864990), UINT32_C(3651632677), UINT32_C(2934040606), UINT32_C(4217806782),
                              UINT32_C(3557654096), UINT32_C(3231995683), UINT32_C(2093833738), UINT32_C( 674786807)) },
    { simde_x_mm256_set_epu32(UINT32_C( 837260657), UINT32_C(3220613586), UINT32_C(2642631733), UINT32_C(2252900450),
                              UINT32_C(3061609531), UINT32_C(2252923032), UINT32_C(1030296341), UINT32_C(2720361240)),
      simde_x_mm256_set_epu32(UINT32_C( 273034038), UINT32_C(2374878315), UINT32_C( 248014486), UINT32_C( 363234795),
                              UINT32_C(2126760034), UINT32_C(4029819680), UINT32_C(2144543040), UINT32_C(4227450764)),
      simde_x_mm256_set_epu32(UINT32_C( 837260657), UINT32_C(3220613586), UINT32_C(2642631733), UINT32_C(2252900450),
                              UINT32_C(3061609531), UINT32_C(4029819680), UINT32_C(2144543040), UINT32_C(4227450764)) },
    { simde_x_mm256_set_epu32(UINT32_C(1832345572), UINT32_C(3528531140), UINT32_C(1174695155), UINT32_C( 287919562),
                              UINT32_C( 792094828), UINT32_C(2183085761), UINT32_C(4262203031), UINT32_C(3585219150)),
      simde_x_mm256_set_epu32(UINT32_C( 890341915), UINT32_C(2131853812), UINT32_C(2693768197), UINT32_C(1107526035),
                              UINT32_C(3439504205), UINT32_C( 751425977), UINT32_C(3946340711), UINT32_C(2999018213)),
      simde_x_mm256_set_epu32(UINT32_C(1832345572), UINT32_C(3528531140), UINT32_C(2693768197), UINT32_C(1107526035),
                              UINT32_C(3439504205), UINT32_C(2183085761), UINT32_C(4262203031), UINT32_C(3585219150)) },
    { simde_x_mm256_set_epu32(UINT32_C(3937957510), UINT32_C(1450021822), UINT32_C(1539281783), UINT32_C( 551303701),
                              UINT32_C(1703578262), UINT32_C(2645712321), UINT32_C(2567475981), UINT32_C(3368049591)),
      simde_x_mm256_set_epu32(UINT32_C(3778291576), UINT32_C(3382324216), UINT32_C(1328766962), UINT32_C(4275285368),
                              UINT32_C( 709773804), UINT32_C(1207236213), UINT32_C(1754387913), UINT32_C(3060418664)),
      simde_x_mm256_set_epu32(UINT32_C(3937957510), UINT32_C(3382324216), UINT32_C(1539281783), UINT32_C(4275285368),
                              UINT32_C(1703578262), UINT32_C(2645712321), UINT32_C(2567475981), UINT32_C(3368049591)) },
    { simde_x_mm256_set_epu32(UINT32_C(1036418017), UINT32_C(1863476858), UINT32_C(1083883567), UINT32_C(3943520867),
                              UINT32_C(  70129580), UINT32_C(1560905984), UINT32_C(2897296070), UINT32_C(2575520666)),
      simde_x_mm256_set_epu32(UINT32_C(2683682856), UINT32_C( 255193154), UINT32_C( 693351345), UINT32_C(1449340919),
                              UINT32_C(2448587623), UINT32_C(2723008994), UINT32_C(2741828276), UINT32_C(3254255853)),
      simde_x_mm256_set_epu32(UINT32_C(2683682856), UINT32_C(1863476858), UINT32_C(1083883567), UINT32_C(3943520867),
                              UINT32_C(2448587623), UINT32_C(2723008994), UINT32_C(2897296070), UINT32_C(3254255853)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_max_epu32(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_u32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm_blend_epi32(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m128i a;
    simde__m128i b;
    simde__m128i r;
  } test_vec[8] = {
    { simde_mm_set_epi32(INT32_C( -776446699), INT32_C( 1736036449), INT32_C( 1358627972), INT32_C(-1414521748)),
      simde_mm_set_epi32(INT32_C(  703500470), INT32_C(-1252293011), INT32_C(-1142834240), INT32_C( 1567373213)),
      simde_mm_set_epi32(INT32_C(  703500470), INT32_C(-1252293011), INT32_C( 1358627972), INT32_C( 1567373213)) },
    { simde_mm_set_epi32(INT32_C(  928555701), INT32_C( -221570804), INT32_C( 1766167688), INT32_C( 1538455167)),
      simde_mm_set_epi32(INT32_C(-2064241406), INT32_C(-1114629780), INT32_C(  844778923), INT32_C(  825239814)),
      simde_mm_set_epi32(INT32_C(-2064241406), INT32_C(-1114629780), INT32_C( 1766167688), INT32_C(  825239814)) },
    { simde_mm_set_epi32(INT32_C( -254776787), INT32_C(-1383921861), INT32_C(-1381573747), INT32_C(  385374117)),
      simde_mm_set_epi32(INT32_C(  783537896), INT32_C( -226088253), INT32_C( 1138968651), INT32_C(  521443914)),
      simde_mm_set_epi32(INT32_C(  783537896), INT32_C( -226088253), INT32_C(-1381573747), INT32_C(  521443914)) },
    { simde_mm_set_epi32(INT32_C(  484740492), INT32_C(-1346417719), INT32_C( 1029792501), INT32_C( 2033188015)),
      simde_mm_set_epi32(INT32_C(  465252472), INT32_C( -775119562), INT32_C( 1616675771), INT32_C(-1846026054)),
      simde_mm_set_epi32(INT32_C(  465252472), INT32_C( -775119562), INT32_C( 1029792501), INT32_C(-1846026054)) },
    { simde_mm_set_epi32(INT32_C( 2097910720), INT32_C(  985021972), INT32_C(-1164844515), INT32_C(-1048926956)),
      simde_mm_set_epi32(INT32_C( 1235766570), INT32_C( 1912005813), INT32_C( -678890313), INT32_C( -799232173)),
      simde_mm_set_epi32(INT32_C( 1235766570), INT32_C( 1912005813), INT32_C(-1164844515), INT32_C( -799232173)) },
    { simde_mm_set_epi32(INT32_C(  107952418), INT32_C(-1186034132), INT32_C(-1490121281), INT32_C(-1988190971)),
      simde_mm_set_epi32(INT32_C(  438665972), INT32_C(-1023182690), INT32_C(-1692406594), INT32_C( 2076129119)),
      simde_mm_set_epi32(INT32_C(  438665972), INT32_C(-1023182690), INT32_C(-1490121281), INT32_C( 2076129119)) },
    { simde_mm_set_epi32(INT32_C( -296997195), INT32_C( 1989906045), INT32_C(  861414748), INT32_C(  802028810)),
      simde_mm_set_epi32(INT32_C( 2010137226), INT32_C(-1001536035), INT32_C(  526065654), INT32_C( 2146580357)),
      simde_mm_set_epi32(INT32_C( 2010137226), INT32_C(-1001536035), INT32_C(  861414748), INT32_C( 2146580357)) },
    { simde_mm_set_epi32(INT32_C( 1671679906), INT32_C(   72341521), INT32_C(  697290912), INT32_C( 1581591761)),
      simde_mm_set_epi32(INT32_C( -765500720), INT32_C(  807300453), INT32_C(-1774452228), INT32_C( -386626305)),
      simde_mm_set_epi32(INT32_C( -765500720), INT32_C(  807300453), INT32_C(  697290912), INT32_C( -386626305)) },
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m128i r = simde_mm_blend_epi32(test_vec[i].a, test_vec[i].b, 13);
    simde_assert_m128i_i32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_min_epi8(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi8(INT8_C(-113), INT8_C( 124), INT8_C(  15), INT8_C(-126),
                           INT8_C( -14), INT8_C( -39), INT8_C(  -2), INT8_C( -33),
                           INT8_C(  77), INT8_C(-107), INT8_C( -95), INT8_C( -10),
                           INT8_C(  24), INT8_C( -89), INT8_C(  80), INT8_C(  69),
                           INT8_C( -99), INT8_C(  54), INT8_C(   5), INT8_C( 103),
                           INT8_C(  71), INT8_C(  11), INT8_C( -41), INT8_C( 122),
                           INT8_C(  57), INT8_C( -91), INT8_C(-106), INT8_C(  27),
                           INT8_C(  57), INT8_C(  -8), INT8_C( -10), INT8_C(  38)),
      simde_mm256_set_epi8(INT8_C(  58), INT8_C(-107), INT8_C(  43), INT8_C(-106),
                           INT8_C(-127), INT8_C(  87), INT8_C( 107), INT8_C( 115),
                           INT8_C(  91), INT8_C( 104), INT8_C( -95), INT8_C( -69),
                           INT8_C( -37), INT8_C( 126), INT8_C(  40), INT8_C(  53),
                           INT8_C(-103), INT8_C(  84), INT8_C(  99), INT8_C(  38),
                           INT8_C( 126), INT8_C( -61), INT8_C( 117), INT8_C(  48),
                           INT8_C(  65), INT8_C(  73), INT8_C(  55), INT8_C(  73),
                           INT8_C( -94), INT8_C( -78), INT8_C(  -6), INT8_C(  49)),
      simde_mm256_set_epi8(INT8_C(-113), INT8_C(-107), INT8_C(  15), INT8_C(-126),
                           INT8_C(-127), INT8_C( -39), INT8_C(  -2), INT8_C( -33),
                           INT8_C(  77), INT8_C(-107), INT8_C( -95), INT8_C( -69),
                           INT8_C( -37), INT8_C( -89), INT8_C(  40), INT8_C(  53),
                           INT8_C(-103), INT8_C(  54), INT8_C(   5), INT8_C(  38),
                           INT8_C(  71), INT8_C( -61), INT8_C( -41), INT8_C(  48),
                           INT8_C(  57), INT8_C( -91), INT8_C(-106), INT8_C(  27),
                           INT8_C( -94), INT8_C( -78), INT8_C( -10), INT8_C(  38)) },
    { simde_mm256_set_epi8(INT8_C(  53), INT8_C(  21), INT8_C(  98), INT8_C( 120),
                           INT8_C(-113), INT8_C(  39), INT8_C( -37), INT8_C(  99),
                           INT8_C(-124), INT8_C( -15), INT8_C( -78), INT8_C( 107),
                           INT8_C(  24), INT8_C( 124), INT8_C( -54), INT8_C(  81),
                           INT8_C( 115), INT8_C( -24), INT8_C(  66), INT8_C(  27),
                           INT8_C(  15), INT8_C(  61), INT8_C(  57), INT8_C(-118),
                           INT8_C(-113), INT8_C( -12), INT8_C(  -8), INT8_C( -69),
                           INT8_C( -18), INT8_C(  21), INT8_C(  83), INT8_C( 113)),
      simde_mm256_set_epi8(INT8_C(-103), INT8_C(-115), INT8_C( -82), INT8_C(  99),
                           INT8_C( 114), INT8_C(  96), INT8_C( 122), INT8_C(-112),
                           INT8_C(  16), INT8_C(  31), INT8_C(  14), INT8_C( -56),
                           INT8_C( -48), INT8_C(   2), INT8_C( -47), INT8_C(  23),
                           INT8_C( 105), INT8_C( -82), INT8_C(  84), INT8_C( 120),
                           INT8_C(  10), INT8_C(   6), INT8_C( -73), INT8_C( -69),
                           INT8_C( -15), INT8_C( -30), INT8_C( -84), INT8_C(   4),
                           INT8_C( 118), INT8_C(  78), INT8_C(-102), INT8_C(-121)),
      simde_mm256_set_epi8(INT8_C(-103), INT8_C(-115), INT8_C( -82), INT8_C(  99),
                           INT8_C(-113), INT8_C(  39), INT8_C( -37), INT8_C(-112),
                           INT8_C(-124), INT8_C( -15), INT8_C( -78), INT8_C( -56),
                           INT8_C( -48), INT8_C(   2), INT8_C( -54), INT8_C(  23),
                           INT8_C( 105), INT8_C( -82), INT8_C(  66), INT8_C(  27),
                           INT8_C(  10), INT8_C(   6), INT8_C( -73), INT8_C(-118),
                           INT8_C(-113), INT8_C( -30), INT8_C( -84), INT8_C( -69),
                           INT8_C( -18), INT8_C(  21), INT8_C(-102), INT8_C(-121)) },
    { simde_mm256_set_epi8(INT8_C(  99), INT8_C(  36), INT8_C( -33), INT8_C(-101),
                           INT8_C(-112), INT8_C(-121), INT8_C(  47), INT8_C( -29),
                           INT8_C( 104), INT8_C( 110), INT8_C( -84), INT8_C(  72),
                           INT8_C( -54), INT8_C( -40), INT8_C(  19), INT8_C(-103),
                           INT8_C( -69), INT8_C( -50), INT8_C(  26), INT8_C( -97),
                           INT8_C( -51), INT8_C( -78), INT8_C(  41), INT8_C( -85),
                           INT8_C(  36), INT8_C(  76), INT8_C( 111), INT8_C(  49),
                           INT8_C(  97), INT8_C(  -3), INT8_C(  36), INT8_C(  67)),
      simde_mm256_set_epi8(INT8_C(  66), INT8_C(  -8), INT8_C(  56), INT8_C(   7),
                           INT8_C(  58), INT8_C(-107), INT8_C( 110), INT8_C( -95),
                           INT8_C(  31), INT8_C( -56), INT8_C(  42), INT8_C(   8),
                           INT8_C( -46), INT8_C( -16), INT8_C(  21), INT8_C( 126),
                           INT8_C( -12), INT8_C( -94), INT8_C( 109), INT8_C(  67),
                           INT8_C(  47), INT8_C( 103), INT8_C(  21), INT8_C( 104),
                           INT8_C(  99), INT8_C( 106), INT8_C( -91), INT8_C(  87),
                           INT8_C( -83), INT8_C(   2), INT8_C( 105), INT8_C(-105)),
      simde_mm256_set_epi8(INT8_C(  66), INT8_C(  -8), INT8_C( -33), INT8_C(-101),
                           INT8_C(-112), INT8_C(-121), INT8_C(  47), INT8_C( -95),
                           INT8_C(  31), INT8_C( -56), INT8_C( -84), INT8_C(   8),
                           INT8_C( -54), INT8_C( -40), INT8_C(  19), INT8_C(-103),
                           INT8_C( -69), INT8_C( -94), INT8_C(  26), INT8_C( -97),
                           INT8_C( -51), INT8_C( -78), INT8_C(  21), INT8_C( -85),
                           INT8_C(  36), INT8_C(  76), INT8_C( -91), INT8_C(  49),
                           INT8_C( -83), INT8_C(  -3), INT8_C(  36), INT8_C(-105)) },
    { simde_mm256_set_epi8(INT8_C( -79), INT8_C( -25), INT8_C(  15), INT8_C(   2),
                           INT8_C( -84), INT8_C(   9), INT8_C(  54), INT8_C(  99),
                           INT8_C( -69), INT8_C( 117), INT8_C( -20), INT8_C(  47),
                           INT8_C(  21), INT8_C(  44), INT8_C( 113), INT8_C(  59),
                           INT8_C(   9), INT8_C(  65), INT8_C(  -7), INT8_C( -76),
                           INT8_C(-124), INT8_C( -64), INT8_C(  22), INT8_C( -79),
                           INT8_C( -58), INT8_C(  29), INT8_C(  40), INT8_C(  64),
                           INT8_C(  -9), INT8_C(-123), INT8_C( -13), INT8_C( -32)),
      simde_mm256_set_epi8(INT8_C(-114), INT8_C(  -7), INT8_C(   9), INT8_C( -63),
                           INT8_C(   0), INT8_C( -82), INT8_C( -19), INT8_C(  75),
                           INT8_C(  69), INT8_C(  48), INT8_C(  42), INT8_C( -52),
                           INT8_C( 119), INT8_C( -20), INT8_C(  26), INT8_C( -57),
                           INT8_C(  88), INT8_C(  87), INT8_C(  99), INT8_C(-127),
                           INT8_C(  48), INT8_C(  19), INT8_C(  54), INT8_C( -35),
                           INT8_C(   5), INT8_C(  23), INT8_C( -21), INT8_C(  88),
                           INT8_C(  87), INT8_C(-109), INT8_C( -46), INT8_C(-127)),
      simde_mm256_set_epi8(INT8_C(-114), INT8_C( -25), INT8_C(   9), INT8_C( -63),
                           INT8_C( -84), INT8_C( -82), INT8_C( -19), INT8_C(  75),
                           INT8_C( -69), INT8_C(  48), INT8_C( -20), INT8_C( -52),
                           INT8_C(  21), INT8_C( -20), INT8_C(  26), INT8_C( -57),
                           INT8_C(   9), INT8_C(  65), INT8_C(  -7), INT8_C(-127),
                           INT8_C(-124), INT8_C( -64), INT8_C(  22), INT8_C( -79),
                           INT8_C( -58), INT8_C(  23), INT8_C( -21), INT8_C(  64),
                           INT8_C(  -9), INT8_C(-123), INT8_C( -46), INT8_C(-127)) },
    { simde_mm256_set_epi8(INT8_C(  40), INT8_C(-101), INT8_C(-116), INT8_C( -63),
                           INT8_C( -76), INT8_C(  83), INT8_C( -41), INT8_C(  -2),
                           INT8_C(  74), INT8_C(  48), INT8_C(-104), INT8_C( -61),
                           INT8_C(  95), INT8_C(  50), INT8_C(  86), INT8_C(-110),
                           INT8_C( -24), INT8_C(  99), INT8_C( -15), INT8_C( 126),
                           INT8_C( -73), INT8_C( -17), INT8_C(-122), INT8_C(  -7),
                           INT8_C(  95), INT8_C( -91), INT8_C(  66), INT8_C(  -2),
                           INT8_C(  88), INT8_C( -54), INT8_C( 117), INT8_C( -86)),
      simde_mm256_set_epi8(INT8_C( -45), INT8_C( -41), INT8_C(  87), INT8_C( -75),
                           INT8_C( 104), INT8_C(  -1), INT8_C(  11), INT8_C( 125),
                           INT8_C(-123), INT8_C(  86), INT8_C(  26), INT8_C(  46),
                           INT8_C(   6), INT8_C(  54), INT8_C( -77), INT8_C(  63),
                           INT8_C(  79), INT8_C(-127), INT8_C(-118), INT8_C( 107),
                           INT8_C(-122), INT8_C( -36), INT8_C(  -2), INT8_C( -64),
                           INT8_C(  65), INT8_C( -89), INT8_C(  86), INT8_C(  99),
                           INT8_C( -49), INT8_C(  59), INT8_C( -15), INT8_C( 103)),
      simde_mm256_set_epi8(INT8_C( -45), INT8_C(-101), INT8_C(-116), INT8_C( -75),
                           INT8_C( -76), INT8_C(  -1), INT8_C( -41), INT8_C(  -2),
                           INT8_C(-123), INT8_C(  48), INT8_C(-104), INT8_C( -61),
                           INT8_C(   6), INT8_C(  50), INT8_C( -77), INT8_C(-110),
                           INT8_C( -24), INT8_C(-127), INT8_C(-118), INT8_C( 107),
                           INT8_C(-122), INT8_C( -36), INT8_C(-122), INT8_C( -64),
                           INT8_C(  65), INT8_C( -91), INT8_C(  66), INT8_C(  -2),
                           INT8_C( -49), INT8_C( -54), INT8_C( -15), INT8_C( -86)) },
    { simde_mm256_set_epi8(INT8_C(  -6), INT8_C(  22), INT8_C( -98), INT8_C(-111),
                           INT8_C( -27), INT8_C( -45), INT8_C( -60), INT8_C( -64),
                           INT8_C( -14), INT8_C( -15), INT8_C( -20), INT8_C(  52),
                           INT8_C(-110), INT8_C(  52), INT8_C( 120), INT8_C( 119),
                           INT8_C( -35), INT8_C(   3), INT8_C(  42), INT8_C( 109),
                           INT8_C(  16), INT8_C( -18), INT8_C( -49), INT8_C( 102),
                           INT8_C(  87), INT8_C( -69), INT8_C(  10), INT8_C(   0),
                           INT8_C(   1), INT8_C(  21), INT8_C(   6), INT8_C( -56)),
      simde_mm256_set_epi8(INT8_C( -60), INT8_C(  58), INT8_C(  68), INT8_C(-110),
                           INT8_C(  25), INT8_C(  53), INT8_C(-112), INT8_C(   1),
                           INT8_C( 104), INT8_C(  22), INT8_C( -20), INT8_C(-119),
                           INT8_C( -66), INT8_C( -43), INT8_C( 109), INT8_C( -61),
                           INT8_C( -86), INT8_C( -59), INT8_C( -31), INT8_C( -86),
                           INT8_C( -11), INT8_C(  72), INT8_C( 122), INT8_C(-127),
                           INT8_C(  21), INT8_C(  32), INT8_C( 109), INT8_C( 110),
                           INT8_C( 112), INT8_C( -23), INT8_C(  44), INT8_C(  69)),
      simde_mm256_set_epi8(INT8_C( -60), INT8_C(  22), INT8_C( -98), INT8_C(-111),
                           INT8_C( -27), INT8_C( -45), INT8_C(-112), INT8_C( -64),
                           INT8_C( -14), INT8_C( -15), INT8_C( -20), INT8_C(-119),
                           INT8_C(-110), INT8_C( -43), INT8_C( 109), INT8_C( -61),
                           INT8_C( -86), INT8_C( -59), INT8_C( -31), INT8_C( -86),
                           INT8_C( -11), INT8_C( -18), INT8_C( -49), INT8_C(-127),
                           INT8_C(  21), INT8_C( -69), INT8_C(  10), INT8_C(   0),
                           INT8_C(   1), INT8_C( -23), INT8_C(   6), INT8_C( -56)) },
    { simde_mm256_set_epi8(INT8_C( -81), INT8_C(  40), INT8_C(  34), INT8_C(-101),
                           INT8_C(  85), INT8_C( 102), INT8_C( -21), INT8_C(   6),
                           INT8_C(  23), INT8_C( -23), INT8_C( -36), INT8_C(  44),
                           INT8_C( -12), INT8_C( 110), INT8_C( -68), INT8_C(  47),
                           INT8_C(  45), INT8_C( -59), INT8_C(-112), INT8_C(  86),
                           INT8_C( -95), INT8_C(  -9), INT8_C(-101), INT8_C(  83),
                           INT8_C(  37), INT8_C(  85), INT8_C(  31), INT8_C(  -4),
                           INT8_C(  98), INT8_C( -87), INT8_C( -65), INT8_C( -71)),
      simde_mm256_set_epi8(INT8_C( -58), INT8_C(-110), INT8_C(   4), INT8_C(  10),
                           INT8_C( -39), INT8_C(  -8), INT8_C( 126), INT8_C(  76),
                           INT8_C(  85), INT8_C( -11), INT8_C(-106), INT8_C(  42),
                           INT8_C( 125), INT8_C(  46), INT8_C(  63), INT8_C(  35),
                           INT8_C( -24), INT8_C( -99), INT8_C(  71), INT8_C(-108),
                           INT8_C(  52), INT8_C(-105), INT8_C( -88), INT8_C( -28),
                           INT8_C(  12), INT8_C( -41), INT8_C(  81), INT8_C(  38),
                           INT8_C( -13), INT8_C(  29), INT8_C( -44), INT8_C(  59)),
      simde_mm256_set_epi8(INT8_C( -81), INT8_C(-110), INT8_C(   4), INT8_C(-101),
                           INT8_C( -39), INT8_C(  -8), INT8_C( -21), INT8_C(   6),
                           INT8_C(  23), INT8_C( -23), INT8_C(-106), INT8_C(  42),
                           INT8_C( -12), INT8_C(  46), INT8_C( -68), INT8_C(  35),
                           INT8_C( -24), INT8_C( -99), INT8_C(-112), INT8_C(-108),
                           INT8_C( -95), INT8_C(-105), INT8_C(-101), INT8_C( -28),
                           INT8_C(  12), INT8_C( -41), INT8_C(  31), INT8_C(  -4),
                           INT8_C( -13), INT8_C( -87), INT8_C( -65), INT8_C( -71)) },
    { simde_mm256_set_epi8(INT8_C( -36), INT8_C( -94), INT8_C( -61), INT8_C( 117),
                           INT8_C(   0), INT8_C(  -1), INT8_C( 118), INT8_C(  99),
                           INT8_C( -54), INT8_C(-123), INT8_C(  18), INT8_C( 111),
                           INT8_C(   8), INT8_C( -59), INT8_C( 107), INT8_C(  77),
                           INT8_C(   7), INT8_C(  91), INT8_C(  25), INT8_C(  70),
                           INT8_C(  80), INT8_C(  81), INT8_C(  11), INT8_C(  29),
                           INT8_C( 109), INT8_C( 125), INT8_C( -51), INT8_C(  58),
                           INT8_C(  66), INT8_C( 126), INT8_C(-122), INT8_C(  96)),
      simde_mm256_set_epi8(INT8_C( -91), INT8_C( -28), INT8_C(  59), INT8_C(  45),
                           INT8_C(  99), INT8_C(  67), INT8_C( -54), INT8_C( 122),
                           INT8_C(  -4), INT8_C(  -6), INT8_C( -77), INT8_C(  96),
                           INT8_C(  16), INT8_C(  37), INT8_C(-127), INT8_C(  76),
                           INT8_C(  56), INT8_C( -93), INT8_C(   7), INT8_C( -50),
                           INT8_C(  56), INT8_C(-112), INT8_C(   6), INT8_C( -49),
                           INT8_C( 107), INT8_C( -15), INT8_C( -42), INT8_C(-121),
                           INT8_C( -81), INT8_C(  97), INT8_C( -56), INT8_C(  97)),
      simde_mm256_set_epi8(INT8_C( -91), INT8_C( -94), INT8_C( -61), INT8_C(  45),
                           INT8_C(   0), INT8_C(  -1), INT8_C( -54), INT8_C(  99),
                           INT8_C( -54), INT8_C(-123), INT8_C( -77), INT8_C(  96),
                           INT8_C(   8), INT8_C( -59), INT8_C(-127), INT8_C(  76),
                           INT8_C(   7), INT8_C( -93), INT8_C(   7), INT8_C( -50),
                           INT8_C(  56), INT8_C(-112), INT8_C(   6), INT8_C( -49),
                           INT8_C( 107), INT8_C( -15), INT8_C( -51), INT8_C(-121),
                           INT8_C( -81), INT8_C(  97), INT8_C(-122), INT8_C(  96)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_min_epi8(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i8(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_min_epi16(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi16(INT16_C(-28804), INT16_C(  3970), INT16_C( -3367), INT16_C(  -289),
                            INT16_C( 19861), INT16_C(-24074), INT16_C(  6311), INT16_C( 20549),
                            INT16_C(-25290), INT16_C(  1383), INT16_C( 18187), INT16_C(-10374),
                            INT16_C( 14757), INT16_C(-27109), INT16_C( 14840), INT16_C( -2522)),
      simde_mm256_set_epi16(INT16_C( 14997), INT16_C( 11158), INT16_C(-32425), INT16_C( 27507),
                            INT16_C( 23400), INT16_C(-24133), INT16_C( -9346), INT16_C( 10293),
                            INT16_C(-26284), INT16_C( 25382), INT16_C( 32451), INT16_C( 30000),
                            INT16_C( 16713), INT16_C( 14153), INT16_C(-23886), INT16_C( -1487)),
      simde_mm256_set_epi16(INT16_C(-28804), INT16_C(  3970), INT16_C(-32425), INT16_C(  -289),
                            INT16_C( 19861), INT16_C(-24133), INT16_C( -9346), INT16_C( 10293),
                            INT16_C(-26284), INT16_C(  1383), INT16_C( 18187), INT16_C(-10374),
                            INT16_C( 14757), INT16_C(-27109), INT16_C(-23886), INT16_C( -2522)) },
    { simde_mm256_set_epi16(INT16_C( 13589), INT16_C( 25208), INT16_C(-28889), INT16_C( -9373),
                            INT16_C(-31503), INT16_C(-19861), INT16_C(  6268), INT16_C(-13743),
                            INT16_C( 29672), INT16_C( 16923), INT16_C(  3901), INT16_C( 14730),
                            INT16_C(-28684), INT16_C( -1861), INT16_C( -4587), INT16_C( 21361)),
      simde_mm256_set_epi16(INT16_C(-26227), INT16_C(-20893), INT16_C( 29280), INT16_C( 31376),
                            INT16_C(  4127), INT16_C(  3784), INT16_C(-12286), INT16_C(-12009),
                            INT16_C( 27054), INT16_C( 21624), INT16_C(  2566), INT16_C(-18501),
                            INT16_C( -3614), INT16_C(-21500), INT16_C( 30286), INT16_C(-25977)),
      simde_mm256_set_epi16(INT16_C(-26227), INT16_C(-20893), INT16_C(-28889), INT16_C( -9373),
                            INT16_C(-31503), INT16_C(-19861), INT16_C(-12286), INT16_C(-13743),
                            INT16_C( 27054), INT16_C( 16923), INT16_C(  2566), INT16_C(-18501),
                            INT16_C(-28684), INT16_C(-21500), INT16_C( -4587), INT16_C(-25977)) },
    { simde_mm256_set_epi16(INT16_C( 25380), INT16_C( -8293), INT16_C(-28537), INT16_C( 12259),
                            INT16_C( 26734), INT16_C(-21432), INT16_C(-13608), INT16_C(  5017),
                            INT16_C(-17458), INT16_C(  6815), INT16_C(-12878), INT16_C( 10667),
                            INT16_C(  9292), INT16_C( 28465), INT16_C( 25085), INT16_C(  9283)),
      simde_mm256_set_epi16(INT16_C( 17144), INT16_C( 14343), INT16_C( 14997), INT16_C( 28321),
                            INT16_C(  8136), INT16_C( 10760), INT16_C(-11536), INT16_C(  5502),
                            INT16_C( -2910), INT16_C( 27971), INT16_C( 12135), INT16_C(  5480),
                            INT16_C( 25450), INT16_C(-23209), INT16_C(-21246), INT16_C( 27031)),
      simde_mm256_set_epi16(INT16_C( 17144), INT16_C( -8293), INT16_C(-28537), INT16_C( 12259),
                            INT16_C(  8136), INT16_C(-21432), INT16_C(-13608), INT16_C(  5017),
                            INT16_C(-17458), INT16_C(  6815), INT16_C(-12878), INT16_C(  5480),
                            INT16_C(  9292), INT16_C(-23209), INT16_C(-21246), INT16_C(  9283)) },
    { simde_mm256_set_epi16(INT16_C(-19993), INT16_C(  3842), INT16_C(-21495), INT16_C( 13923),
                            INT16_C(-17547), INT16_C( -5073), INT16_C(  5420), INT16_C( 28987),
                            INT16_C(  2369), INT16_C( -1612), INT16_C(-31552), INT16_C(  5809),
                            INT16_C(-14819), INT16_C( 10304), INT16_C( -2171), INT16_C( -3104)),
      simde_mm256_set_epi16(INT16_C(-28935), INT16_C(  2497), INT16_C(   174), INT16_C( -4789),
                            INT16_C( 17712), INT16_C( 10956), INT16_C( 30700), INT16_C(  6855),
                            INT16_C( 22615), INT16_C( 25473), INT16_C( 12307), INT16_C( 14045),
                            INT16_C(  1303), INT16_C( -5288), INT16_C( 22419), INT16_C(-11647)),
      simde_mm256_set_epi16(INT16_C(-28935), INT16_C(  2497), INT16_C(-21495), INT16_C( -4789),
                            INT16_C(-17547), INT16_C( -5073), INT16_C(  5420), INT16_C(  6855),
                            INT16_C(  2369), INT16_C( -1612), INT16_C(-31552), INT16_C(  5809),
                            INT16_C(-14819), INT16_C( -5288), INT16_C( -2171), INT16_C(-11647)) },
    { simde_mm256_set_epi16(INT16_C( 10395), INT16_C(-29503), INT16_C(-19373), INT16_C(-10242),
                            INT16_C( 18992), INT16_C(-26429), INT16_C( 24370), INT16_C( 22162),
                            INT16_C( -6045), INT16_C( -3714), INT16_C(-18449), INT16_C(-30983),
                            INT16_C( 24485), INT16_C( 17150), INT16_C( 22730), INT16_C( 30122)),
      simde_mm256_set_epi16(INT16_C(-11305), INT16_C( 22453), INT16_C( 26879), INT16_C(  2941),
                            INT16_C(-31402), INT16_C(  6702), INT16_C(  1590), INT16_C(-19649),
                            INT16_C( 20353), INT16_C(-30101), INT16_C(-31012), INT16_C(  -320),
                            INT16_C( 16807), INT16_C( 22115), INT16_C(-12485), INT16_C( -3737)),
      simde_mm256_set_epi16(INT16_C(-11305), INT16_C(-29503), INT16_C(-19373), INT16_C(-10242),
                            INT16_C(-31402), INT16_C(-26429), INT16_C(  1590), INT16_C(-19649),
                            INT16_C( -6045), INT16_C(-30101), INT16_C(-31012), INT16_C(-30983),
                            INT16_C( 16807), INT16_C( 17150), INT16_C(-12485), INT16_C( -3737)) },
    { simde_mm256_set_epi16(INT16_C( -1514), INT16_C(-24943), INT16_C( -6701), INT16_C(-15168),
                            INT16_C( -3343), INT16_C( -5068), INT16_C(-28108), INT16_C( 30839),
                            INT16_C( -8957), INT16_C( 10861), INT16_C(  4334), INT16_C(-12442),
                            INT16_C( 22459), INT16_C(  2560), INT16_C(   277), INT16_C(  1736)),
      simde_mm256_set_epi16(INT16_C(-15302), INT16_C( 17554), INT16_C(  6453), INT16_C(-28671),
                            INT16_C( 26646), INT16_C( -4983), INT16_C(-16683), INT16_C( 28099),
                            INT16_C(-21819), INT16_C( -7766), INT16_C( -2744), INT16_C( 31361),
                            INT16_C(  5408), INT16_C( 28014), INT16_C( 28905), INT16_C( 11333)),
      simde_mm256_set_epi16(INT16_C(-15302), INT16_C(-24943), INT16_C( -6701), INT16_C(-28671),
                            INT16_C( -3343), INT16_C( -5068), INT16_C(-28108), INT16_C( 28099),
                            INT16_C(-21819), INT16_C( -7766), INT16_C( -2744), INT16_C(-12442),
                            INT16_C(  5408), INT16_C(  2560), INT16_C(   277), INT16_C(  1736)) },
    { simde_mm256_set_epi16(INT16_C(-20696), INT16_C(  8859), INT16_C( 21862), INT16_C( -5370),
                            INT16_C(  6121), INT16_C( -9172), INT16_C( -2962), INT16_C(-17361),
                            INT16_C( 11717), INT16_C(-28586), INT16_C(-24073), INT16_C(-25773),
                            INT16_C(  9557), INT16_C(  8188), INT16_C( 25257), INT16_C(-16455)),
      simde_mm256_set_epi16(INT16_C(-14702), INT16_C(  1034), INT16_C( -9736), INT16_C( 32332),
                            INT16_C( 22005), INT16_C(-27094), INT16_C( 32046), INT16_C( 16163),
                            INT16_C( -5987), INT16_C( 18324), INT16_C( 13463), INT16_C(-22300),
                            INT16_C(  3287), INT16_C( 20774), INT16_C( -3299), INT16_C(-11205)),
      simde_mm256_set_epi16(INT16_C(-20696), INT16_C(  1034), INT16_C( -9736), INT16_C( -5370),
                            INT16_C(  6121), INT16_C(-27094), INT16_C( -2962), INT16_C(-17361),
                            INT16_C( -5987), INT16_C(-28586), INT16_C(-24073), INT16_C(-25773),
                            INT16_C(  3287), INT16_C(  8188), INT16_C( -3299), INT16_C(-16455)) },
    { simde_mm256_set_epi16(INT16_C( -9054), INT16_C(-15499), INT16_C(   255), INT16_C( 30307),
                            INT16_C(-13691), INT16_C(  4719), INT16_C(  2245), INT16_C( 27469),
                            INT16_C(  1883), INT16_C(  6470), INT16_C( 20561), INT16_C(  2845),
                            INT16_C( 28029), INT16_C(-12998), INT16_C( 17022), INT16_C(-31136)),
      simde_mm256_set_epi16(INT16_C(-23068), INT16_C( 15149), INT16_C( 25411), INT16_C(-13702),
                            INT16_C(  -774), INT16_C(-19616), INT16_C(  4133), INT16_C(-32436),
                            INT16_C( 14499), INT16_C(  1998), INT16_C( 14480), INT16_C(  1743),
                            INT16_C( 27633), INT16_C(-10617), INT16_C(-20639), INT16_C(-14239)),
      simde_mm256_set_epi16(INT16_C(-23068), INT16_C(-15499), INT16_C(   255), INT16_C(-13702),
                            INT16_C(-13691), INT16_C(-19616), INT16_C(  2245), INT16_C(-32436),
                            INT16_C(  1883), INT16_C(  1998), INT16_C( 14480), INT16_C(  1743),
                            INT16_C( 27633), INT16_C(-12998), INT16_C(-20639), INT16_C(-31136)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_min_epi16(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i16(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

static MunitResult
test_simde_mm256_min_epi32(const MunitParameter params[], void* data) {
  (void) params;
  (void) data;

  const struct {
    simde__m256i a;
    simde__m256i b;
    simde__m256i r;
  } test_vec[8] = {
    { simde_mm256_set_epi32(INT32_C(-1887694974), INT32_C( -220594465), INT32_C( 1301651958), INT32_C(  413618245),
                            INT32_C(-1657404057), INT32_C( 1191958394), INT32_C(  967153179), INT32_C(  972617254)),
      simde_mm256_set_epi32(INT32_C(  982854550), INT32_C(-2124977293), INT32_C( 1533583803), INT32_C( -612489163),
                            INT32_C(-1722522842), INT32_C( 2126738736), INT32_C( 1095317321), INT32_C(-1565328847)),
      simde_mm256_set_epi32(INT32_C(-1887694974), INT32_C(-2124977293), INT32_C( 1301651958), INT32_C( -612489163),
                            INT32_C(-1722522842), INT32_C( 1191958394), INT32_C(  967153179), INT32_C(-1565328847)) },
    { simde_mm256_set_epi32(INT32_C(  890593912), INT32_C(-1893213341), INT32_C(-2064534933), INT32_C(  410831441),
                            INT32_C( 1944601115), INT32_C(  255670666), INT32_C(-1879770949), INT32_C( -300592271)),
      simde_mm256_set_epi32(INT32_C(-1718768029), INT32_C( 1918925456), INT32_C(  270470856), INT32_C( -805121769),
                            INT32_C( 1773032568), INT32_C(  168212411), INT32_C( -236803068), INT32_C( 1984862855)),
      simde_mm256_set_epi32(INT32_C(-1718768029), INT32_C(-1893213341), INT32_C(-2064534933), INT32_C( -805121769),
                            INT32_C( 1773032568), INT32_C(  168212411), INT32_C(-1879770949), INT32_C( -300592271)) },
    { simde_mm256_set_epi32(INT32_C( 1663360923), INT32_C(-1870188573), INT32_C( 1752083528), INT32_C( -891808871),
                            INT32_C(-1144120673), INT32_C( -843961941), INT32_C(  608988977), INT32_C( 1643979843)),
      simde_mm256_set_epi32(INT32_C( 1123563527), INT32_C(  982871713), INT32_C(  533211656), INT32_C( -756017794),
                            INT32_C( -190681789), INT32_C(  795284840), INT32_C( 1667933527), INT32_C(-1392350825)),
      simde_mm256_set_epi32(INT32_C( 1123563527), INT32_C(-1870188573), INT32_C(  533211656), INT32_C( -891808871),
                            INT32_C(-1144120673), INT32_C( -843961941), INT32_C(  608988977), INT32_C(-1392350825)) },
    { simde_mm256_set_epi32(INT32_C(-1310257406), INT32_C(-1408682397), INT32_C(-1149899729), INT32_C(  355234107),
                            INT32_C(  155318708), INT32_C(-2067786063), INT32_C( -971167680), INT32_C( -142216224)),
      simde_mm256_set_epi32(INT32_C(-1896281663), INT32_C(   11464011), INT32_C( 1160784588), INT32_C( 2011962055),
                            INT32_C( 1482122113), INT32_C(  806565597), INT32_C(   85453656), INT32_C( 1469305473)),
      simde_mm256_set_epi32(INT32_C(-1896281663), INT32_C(-1408682397), INT32_C(-1149899729), INT32_C(  355234107),
                            INT32_C(  155318708), INT32_C(-2067786063), INT32_C( -971167680), INT32_C( -142216224)) },
    { simde_mm256_set_epi32(INT32_C(  681282753), INT32_C(-1269573634), INT32_C( 1244698819), INT32_C( 1597134482),
                            INT32_C( -396103298), INT32_C(-1209039111), INT32_C( 1604666110), INT32_C( 1489663402)),
      simde_mm256_set_epi32(INT32_C( -740862027), INT32_C( 1761545085), INT32_C(-2057954770), INT32_C(  104248127),
                            INT32_C( 1333889643), INT32_C(-2032337216), INT32_C( 1101485667), INT32_C( -818155161)),
      simde_mm256_set_epi32(INT32_C( -740862027), INT32_C(-1269573634), INT32_C(-2057954770), INT32_C(  104248127),
                            INT32_C( -396103298), INT32_C(-2032337216), INT32_C( 1101485667), INT32_C( -818155161)) },
    { simde_mm256_set_epi32(INT32_C(  -99180911), INT32_C( -439106368), INT32_C( -219026380), INT32_C(-1842055049),
                            INT32_C( -586995091), INT32_C(  284086118), INT32_C( 1471875584), INT32_C(   18155208)),
      simde_mm256_set_epi32(INT32_C(-1002814318), INT32_C(  422940673), INT32_C( 1746332809), INT32_C(-1093308989),
                            INT32_C(-1429872214), INT32_C( -179799423), INT32_C(  354446702), INT32_C( 1894329413)),
      simde_mm256_set_epi32(INT32_C(-1002814318), INT32_C( -439106368), INT32_C( -219026380), INT32_C(-1842055049),
                            INT32_C(-1429872214), INT32_C( -179799423), INT32_C(  354446702), INT32_C(   18155208)) },
    { simde_mm256_set_epi32(INT32_C(-1356324197), INT32_C( 1432808198), INT32_C(  401202220), INT32_C( -194069457),
                            INT32_C(  767922262), INT32_C(-1577608365), INT32_C(  626335740), INT32_C( 1655291833)),
      simde_mm256_set_epi32(INT32_C( -963509238), INT32_C( -638026164), INT32_C( 1442158122), INT32_C( 2100182819),
                            INT32_C( -392345708), INT32_C(  882354404), INT32_C(  215437606), INT32_C( -216148933)),
      simde_mm256_set_epi32(INT32_C(-1356324197), INT32_C( -638026164), INT32_C(  401202220), INT32_C( -194069457),
                            INT32_C( -392345708), INT32_C(-1577608365), INT32_C(  215437606), INT32_C( -216148933)) },
    { simde_mm256_set_epi32(INT32_C( -593312907), INT32_C(   16741987), INT32_C( -897248657), INT32_C(  147155789),
                            INT32_C(  123410758), INT32_C( 1347488541), INT32_C( 1836961082), INT32_C( 1115588192)),
      simde_mm256_set_epi32(INT32_C(-1511769299), INT32_C( 1665387130), INT32_C(  -50678944), INT32_C(  270893388),
                            INT32_C(  950208462), INT32_C(  948963023), INT32_C( 1811011207), INT32_C(-1352546207)),
      simde_mm256_set_epi32(INT32_C(-1511769299), INT32_C(   16741987), INT32_C( -897248657), INT32_C(  147155789),
                            INT32_C(  123410758), INT32_C(  948963023), INT32_C( 1811011207), INT32_C(-1352546207)) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__m256i r = simde_mm256_min_epi32(test_vec[i].a, test_vec[i].b);
    simde_assert_m256i_i32(r, ==, test_vec[i].r);
  }

  return MUNIT_OK;
}

#endif /* defined(SIMDE_X86_AVX2_NATIVE) || defined(SIMDE_NO_NATIVE) || defined(SIMDE_ALWAYS_BUILD_NATIVE_TESTS) */

HEDLEY_DIAGNOSTIC_PUSH
HEDLEY_DIAGNOSTIC_DISABLE_CAST_QUAL

#if HEDLEY_HAS_WARNING("-Wold-style-cast")
  #pragma clang diagnostic ignored "-Wold-style-cast"
#endif
#if HEDLEY_HAS_WARNING("-Wzero-as-null-pointer-constant")
  #pragma clang diagnostic ignored "-Wzero-as-null-pointer-constant"
#endif

static MunitTest test_suite_tests[] = {
#if defined(SIMDE_X86_AVX2_NATIVE) || defined(SIMDE_NO_NATIVE) || defined(SIMDE_ALWAYS_BUILD_NATIVE_TESTS)
  SIMDE_TESTS_DEFINE_TEST(mm256_abs_epi8),
  SIMDE_TESTS_DEFINE_TEST(mm256_abs_epi16),
  SIMDE_TESTS_D