/*--------------------------------------------------------------------*//*:Ignore this sentence.
Copyright (C) 1999, 2001 SIL International. All rights reserved.

Distributable under the terms of either the Common Public License or the
GNU Lesser General Public License, as specified in the LICENSING.txt file.

File: Main.h
Responsibility: Sharon Correll
Last reviewed: Not yet.

Description:
	Main.header file for the Graphite engine.
----------------------------------------------------------------------------------------------*/
#ifdef _MSC_VER
#pragma once
#endif
#ifndef GRAPHITE_H
#define GRAPHITE_H 1

//:End Ignore

#define NO_EXCEPTIONS 1


#include "GrCommon.h"

//:>********************************************************************************************
//:>	Interfaces.
//:>********************************************************************************************
#include "GrData.h"

//:>********************************************************************************************
//:>	Implementations.
//:>********************************************************************************************

// For reading the font (FieldWorks's approach) and transduction logging:
#include <fstream>
#include <iostream>

#include <vector>
////#include <algorithm>
#include <string>


// Public headers.
#include "GrResult.h"
//////#include "IGrGraphics.h"
#include "ITextSource.h"
#include "IGrJustifier.h"
#include "IGrEngine.h"
#include "GrConstants.h"
#include "GrFeature.h"

// External helper classes.
#include "GrExt.h"


// Forward delcarations.
namespace gr
{
    class GrTableManager;
	class Segment;
	class GrEngine;
}

// Define after GrExt.h to avoid conflict with FW Rect class.
namespace gr
{
/*
struct Point
{
	float x;
	float y;

	Point()
	{
		x = y = 0;
	}

	Point(POINT & p)
	{
		x = (float)p.x;
		y = (float)p.y;
	}
};


struct Rect
{
	float top;
	float bottom;
	float left;
	float right;

	Rect()
	{
		top = bottom = left = right = 0;
	};

	Rect(RECT & r)
	{
		top = (float)r.top;
		bottom = (float)r.bottom;
		left = (float)r.left;
		right = (float)r.right;
	};
};
*/
}; // namespace gr

#include "GrFeatureValues.h"
#include "GrSlotState.h"

#include "SegmentAux.h"

// Internal headers
#include "FileInput.h"
#include "GrCharStream.h"
#include "GrGlyphTable.h"
#include "GrClassTable.h"
#include "GrPseudoMap.h"
#include "GrSlotStream.h"
#include "GrFSM.h"
#include "GrPass.h"
#include "GrTableManager.h"
#include "FontCache.h"


// Public headers
#include "Font.h"
#include "GraphiteProcess.h"
#include "GrEngine.h"
#include "FontFace.h"
#include "Segment.h"
#include "SegmentPainter.h"
#ifdef _WIN32
#include "HashMap.h"
#include "WinFont.h"
#include "WinSegmentPainter.h"
#endif

// Internal headers
#include "TtfUtil.h"
//#include "GrUtil.h"

#include "GrWrappers.h"

//#include "IGrDebug.h"
//#include "GrSegmentDebug.h"
//#include "GrEngineDebug.h"

/////<<<<<<< .mine
// clashes with non gr stuff
// using namespace gr;
///////>>>>>>> .r98

#endif // GRAPHITE_H

