/*--------------------------------------------------------------------*//*:Ignore this sentence.
Copyright (C) 1999, 2001 SIL International. All rights reserved.

Distributable under the terms of either the Common Public License or the
GNU Lesser General Public License, as specified in the LICENSING.txt file.

File: GrFeature.h
Responsibility: Sharon Correll
Last reviewed: Not yet.

Description:

Note:
	The body of methods not complete contained in this file are located in GrEngine.cpp.
----------------------------------------------------------------------------------------------*/
#ifdef _MSC_VER
#pragma once
#endif
#ifndef GR_FEATURE_INCLUDED
#define GR_FEATURE_INCLUDED

//:End Ignore

namespace gr
{


/*----------------------------------------------------------------------------------------------
	A valid setting and its UI labels in potentially various languages.

	Hungarian: fset
----------------------------------------------------------------------------------------------*/
/****
class GrFeatureSetting
{
	friend class GrFeature;
public:
	GrFeatureSetting()
	{
		m_hmnstuLabels.Clear();
	}
	GrFeatureSetting(GrFeatureSetting & fset)
	{
		m_hmnstuLabels.Clear();
	}
protected:
	int m_nVal;
	HashMap<int, std::wstring> m_hmnstuLabels;
};
****/

class GrEngine;

/*----------------------------------------------------------------------------------------------
	Each Graphite feature defines a way to customize or parameterize the rendering processs.

	Hungarian: feat
----------------------------------------------------------------------------------------------*/
class GrFeature
{
	friend class GrFeatureSetting;
public:
	GrFeature()
	{
		m_vnVal.clear();
		m_vnNameId.clear();
	}

	void Initialize(int nID, int nNameId, int cfset, int nDefault = 0);

	int ID()
	{
		return m_nID;
	}

	int DefaultValue()
	{
		return m_nDefault;
	}

	void SetDefault(int nDefault)
	{
		m_nDefault = nDefault;
	}

	void SetNameId(int n)
	{
		m_nNameId = n;
	}

	int NumberOfSettings()
	{
		return (int)m_vnVal.size();
	}

	int Settings(int cMax, int * prgnVal);
	void AddSetting(int nVal, int nNameId);
	bool IsValidSetting(int nVal);
	std::wstring Label(GrEngine * pgreng, int nLang);
	std::wstring SettingLabel(GrEngine * pgreng, int nVal, int nLang);
	int NthSetting(int ifset);
	std::wstring NthSettingLabel(GrEngine * pgreng, int ifset, int nLang);
//	void SetSettingLabel(int nVal, std::wstring stuLabel, int nLang);

protected:
	int m_nID;
	int m_nDefault;
	int m_nNameId;
//	HashMap<int, std::wstrng> m_hmnstuLabels;

	// These are parallel arrays. The first gives the setting value for a given feature,
	// the second gives the index into the name table that is used to read UI strings.
	std::vector<int> m_vnVal;
	std::vector<int> m_vnNameId;
};


} // namespace gr

#if defined(GR_NO_NAMESPACE)
using namespace gr;
#endif


#endif // !GR_FEATURE_INCLUDED
