/*--------------------------------------------------------------------*//*:Ignore this sentence.
Copyright (C) 1999, 2001 SIL International. All rights reserved.

Distributable under the terms of either the Common Public License or the
GNU Lesser General Public License, as specified in the LICENSING.txt file.

File: SimpleTextSrc.h
Responsibility: Sharon Correll
Last reviewed: Not yet.

Description:
	A simple text source that shows how to use this interface within Graphite.
-------------------------------------------------------------------------------*//*:End Ignore*/
#pragma once
#ifndef GRTXTSRC_INCLUDED
#define GRTXTSRC_INCLUDED

using namespace gr;

/*----------------------------------------------------------------------------------------------
	Class: SimpleTextSrc
	This class provides a simple implementation for a text source for the Graphite engine.
	There are no paragraph properties of interest and one set of character properties that
	apply to the entire string.
----------------------------------------------------------------------------------------------*/
class SimpleTextSrc : public IColorTextSource
{
public:
	// Constructor:
	SimpleTextSrc(gr::utf16 * pszText);
	~SimpleTextSrc();

	virtual long IncRefCount(void)
	{
		return InterlockedIncrement(&m_cref);
	}
	virtual long DecRefCount(void)
	{
		long cref = InterlockedDecrement(&m_cref);
		if (cref == 0) {
			m_cref = 1;
			delete this;
		}
		return cref;
	}

	// -------------------------------------------------------------------------------
	// Interface methods:

	virtual UtfType utfEncodingForm()
	{
		return kutf16;
	}
	virtual size_t getLength()
	{
		return m_cchLength;
	}
	virtual size_t fetch(toffset ichMin, size_t cch, utf32 * prgchBuffer)
	{
		throw;
	}
	virtual size_t fetch(toffset ichMin, size_t cch, gr::utf16 * prgchwBuffer);
	virtual size_t fetch(toffset ichMin, size_t cch, utf8  * prgchsBuffer)
	{
		throw;
	};

	virtual bool getRightToLeft(int ich);
	virtual unsigned int getDirectionDepth(int ich);
	virtual float getVerticalOffset(int ich);

	virtual std::pair<toffset, toffset> propertyRange(int ich)
	{
		std::pair<toffset, toffset> pairRet;
		pairRet.first = 0;
		pairRet.second = m_cchLength;
		return pairRet;
	}

	virtual size_t getFontFeatures(int ich, FeatureSetting * prgfset)
	{
		return 0; // no features in this simple implementation
	}
	virtual bool sameSegment(int ich1, int ich2)
	{
		return true;
	}

	virtual void getColors(int ich, int * pclrFore, int * pclrBack)
	{
		*pclrFore = kclrBlack;
		*pclrBack = kclrTransparent;
	}

protected:
	long m_cref;
	gr::utf16 * m_prgchText;
	int m_cchLength;
	//gr::utf16 m_rgchFontVar[64];
};


#endif // !GRTXTSRC_INCLUDED
