//  libsigcperl -- a helper library for writing XSUB wrappers of libsigc++
//  Copyright (C) 2002 Ron Steinke
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Library General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Library General Public License for more details.
//
//  You should have received a copy of the GNU Library General Public
//  License along with this library; if not, write to the 
//  Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
//  Boston, MA  02111-1307  USA.

// This is a generated file, do not edit. Generated from signal_array.h.m4.

/* This is a generated file, do not edit.  Generated from template.macros.m4 */








#ifndef SIGC_PERL_SIGNAL_ARRAY_H
#define SIGC_PERL_SIGNAL_ARRAY_H

#include <set>

#include <sigcperl/signal_base.h>
#include <sigc++/adaptor.h>


// This one is for a signal which emits a
// standard container of something

namespace SigCPerl {

// This is a workaround to allow for
// std::set<>, where you need insert()
// instead of push_back()
template<class C>
inline void PushBack(C& c, const typename C::value_type& val) {c.push_back(val);}
template<class C>
inline void PushBack(std::set<C>& c, const C& val) {c.insert(val);}

// A SignalArray0<> actually wraps a SigC::Signal1<>, so we only go
// up to 4 as the default instead of 5

// ---------- Perl Array Signal 0 ----------

template <class R,class C,class Marsh=SigC::Marshal<R> >
class SignalArray0 : public SignalBase
{
 public:
  typedef SigC::Signal1<R,C,Marsh> SignalType;
  typedef SigC::Slot1<R,C> SlotType;

  SignalArray0(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    R val = m_signal.emit(
      c);

    if(VoidContext(flags))
      return Data();
    return Returns<R>::getRetData(val);
  }

 private:
  static R conv_func(C c,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = Returns<R>::getFlags();
    R val;

    dSP;
    ENTER;
    SAVETMPS;

    

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    Data data_out =
      ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    try {
      val = Returns<R>::ret_val(data_out);
    }
    catch (BadConvertVal) {
      // FIXME find a way to ignore the return val
    }

    SPAGAIN;
    FREETMPS;
    LEAVE;
    return val;
  }

  SignalArray0(const SignalArray0&);
  SignalArray0& operator=(const SignalArray0&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class C,class Marsh>
class SignalArray0<void,C,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal1<void,C,Marsh> SignalType;
  typedef SigC::Slot1<void,C> SlotType;

  SignalArray0(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    m_signal.emit(
      c);

    return Data();
  }

 private:
  static void conv_func(C c,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = G_VOID;
    

    dSP;
    ENTER;
    SAVETMPS;

    

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    

    SPAGAIN;
    FREETMPS;
    LEAVE;
    
  }

  SignalArray0(const SignalArray0&);
  SignalArray0& operator=(const SignalArray0&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class R,class C,class Marsh>
class SignalArray0<R,C&,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal1<R,C&,Marsh> SignalType;
  typedef SigC::Slot1<R,C&> SlotType;

  SignalArray0(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    R val = m_signal.emit(
      c);

    if(VoidContext(flags))
      return Data();
    return Returns<R>::getRetData(val);
  }

 private:
  static R conv_func(C& c,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = Returns<R>::getFlags();
    R val;

    dSP;
    ENTER;
    SAVETMPS;

    

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    Data data_out =
      ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    try {
      val = Returns<R>::ret_val(data_out);
    }
    catch (BadConvertVal) {
      // FIXME find a way to ignore the return val
    }

    SPAGAIN;
    FREETMPS;
    LEAVE;
    return val;
  }

  SignalArray0(const SignalArray0&);
  SignalArray0& operator=(const SignalArray0&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class C,class Marsh>
class SignalArray0<void,C&,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal1<void,C&,Marsh> SignalType;
  typedef SigC::Slot1<void,C&> SlotType;

  SignalArray0(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    m_signal.emit(
      c);

    return Data();
  }

 private:
  static void conv_func(C& c,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = G_VOID;
    

    dSP;
    ENTER;
    SAVETMPS;

    

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    

    SPAGAIN;
    FREETMPS;
    LEAVE;
    
  }

  SignalArray0(const SignalArray0&);
  SignalArray0& operator=(const SignalArray0&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class R,class C,class Marsh>
class SignalArray0<R,const C&,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal1<R,const C&,Marsh> SignalType;
  typedef SigC::Slot1<R,const C&> SlotType;

  SignalArray0(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    R val = m_signal.emit(
      c);

    if(VoidContext(flags))
      return Data();
    return Returns<R>::getRetData(val);
  }

 private:
  static R conv_func(const C& c,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = Returns<R>::getFlags();
    R val;

    dSP;
    ENTER;
    SAVETMPS;

    

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    Data data_out =
      ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    try {
      val = Returns<R>::ret_val(data_out);
    }
    catch (BadConvertVal) {
      // FIXME find a way to ignore the return val
    }

    SPAGAIN;
    FREETMPS;
    LEAVE;
    return val;
  }

  SignalArray0(const SignalArray0&);
  SignalArray0& operator=(const SignalArray0&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class C,class Marsh>
class SignalArray0<void,const C&,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal1<void,const C&,Marsh> SignalType;
  typedef SigC::Slot1<void,const C&> SlotType;

  SignalArray0(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    m_signal.emit(
      c);

    return Data();
  }

 private:
  static void conv_func(const C& c,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = G_VOID;
    

    dSP;
    ENTER;
    SAVETMPS;

    

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    

    SPAGAIN;
    FREETMPS;
    LEAVE;
    
  }

  SignalArray0(const SignalArray0&);
  SignalArray0& operator=(const SignalArray0&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template<class R,class C,class Marsh>
SignalBase* WrapArraySignal(SigC::Signal1<R,C,Marsh> &signal,
	SV *parent = 0) throw()
{
  return new SignalArray0<R,C,Marsh>(signal, parent);
}

// ---------- Perl Array Signal 1 ----------

template <class R,class P1,class C,class Marsh=SigC::Marshal<R> >
class SignalArray1 : public SignalBase
{
 public:
  typedef SigC::Signal2<R,P1,C,Marsh> SignalType;
  typedef SigC::Slot2<R,P1,C> SlotType;

  SignalArray1(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    if(data.size() < 1)
      throw BadConvertVal();

    ArgBox<P1> p1(*itr++);

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    R val = m_signal.emit(
      p1.val(),c);

    if(VoidContext(flags))
      return Data();
    return Returns<R>::getRetData(val);
  }

 private:
  static R conv_func(typename SigC::Trait<P1>::ref p1,C c,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = Returns<R>::getFlags();
    R val;

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    Data data_out =
      ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    try {
      val = Returns<R>::ret_val(data_out);
    }
    catch (BadConvertVal) {
      // FIXME find a way to ignore the return val
    }

    SPAGAIN;
    FREETMPS;
    LEAVE;
    return val;
  }

  SignalArray1(const SignalArray1&);
  SignalArray1& operator=(const SignalArray1&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class P1,class C,class Marsh>
class SignalArray1<void,P1,C,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal2<void,P1,C,Marsh> SignalType;
  typedef SigC::Slot2<void,P1,C> SlotType;

  SignalArray1(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    if(data.size() < 1)
      throw BadConvertVal();

    ArgBox<P1> p1(*itr++);

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    m_signal.emit(
      p1.val(),c);

    return Data();
  }

 private:
  static void conv_func(typename SigC::Trait<P1>::ref p1,C c,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = G_VOID;
    

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    

    SPAGAIN;
    FREETMPS;
    LEAVE;
    
  }

  SignalArray1(const SignalArray1&);
  SignalArray1& operator=(const SignalArray1&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class R,class P1,class C,class Marsh>
class SignalArray1<R,P1,C&,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal2<R,P1,C&,Marsh> SignalType;
  typedef SigC::Slot2<R,P1,C&> SlotType;

  SignalArray1(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    if(data.size() < 1)
      throw BadConvertVal();

    ArgBox<P1> p1(*itr++);

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    R val = m_signal.emit(
      p1.val(),c);

    if(VoidContext(flags))
      return Data();
    return Returns<R>::getRetData(val);
  }

 private:
  static R conv_func(typename SigC::Trait<P1>::ref p1,C& c,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = Returns<R>::getFlags();
    R val;

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    Data data_out =
      ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    try {
      val = Returns<R>::ret_val(data_out);
    }
    catch (BadConvertVal) {
      // FIXME find a way to ignore the return val
    }

    SPAGAIN;
    FREETMPS;
    LEAVE;
    return val;
  }

  SignalArray1(const SignalArray1&);
  SignalArray1& operator=(const SignalArray1&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class P1,class C,class Marsh>
class SignalArray1<void,P1,C&,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal2<void,P1,C&,Marsh> SignalType;
  typedef SigC::Slot2<void,P1,C&> SlotType;

  SignalArray1(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    if(data.size() < 1)
      throw BadConvertVal();

    ArgBox<P1> p1(*itr++);

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    m_signal.emit(
      p1.val(),c);

    return Data();
  }

 private:
  static void conv_func(typename SigC::Trait<P1>::ref p1,C& c,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = G_VOID;
    

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    

    SPAGAIN;
    FREETMPS;
    LEAVE;
    
  }

  SignalArray1(const SignalArray1&);
  SignalArray1& operator=(const SignalArray1&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class R,class P1,class C,class Marsh>
class SignalArray1<R,P1,const C&,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal2<R,P1,const C&,Marsh> SignalType;
  typedef SigC::Slot2<R,P1,const C&> SlotType;

  SignalArray1(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    if(data.size() < 1)
      throw BadConvertVal();

    ArgBox<P1> p1(*itr++);

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    R val = m_signal.emit(
      p1.val(),c);

    if(VoidContext(flags))
      return Data();
    return Returns<R>::getRetData(val);
  }

 private:
  static R conv_func(typename SigC::Trait<P1>::ref p1,const C& c,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = Returns<R>::getFlags();
    R val;

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    Data data_out =
      ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    try {
      val = Returns<R>::ret_val(data_out);
    }
    catch (BadConvertVal) {
      // FIXME find a way to ignore the return val
    }

    SPAGAIN;
    FREETMPS;
    LEAVE;
    return val;
  }

  SignalArray1(const SignalArray1&);
  SignalArray1& operator=(const SignalArray1&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class P1,class C,class Marsh>
class SignalArray1<void,P1,const C&,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal2<void,P1,const C&,Marsh> SignalType;
  typedef SigC::Slot2<void,P1,const C&> SlotType;

  SignalArray1(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    if(data.size() < 1)
      throw BadConvertVal();

    ArgBox<P1> p1(*itr++);

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    m_signal.emit(
      p1.val(),c);

    return Data();
  }

 private:
  static void conv_func(typename SigC::Trait<P1>::ref p1,const C& c,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = G_VOID;
    

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    

    SPAGAIN;
    FREETMPS;
    LEAVE;
    
  }

  SignalArray1(const SignalArray1&);
  SignalArray1& operator=(const SignalArray1&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template<class R,class P1,class C,class Marsh>
SignalBase* WrapArraySignal(SigC::Signal2<R,P1,C,Marsh> &signal,
	SV *parent = 0) throw()
{
  return new SignalArray1<R,P1,C,Marsh>(signal, parent);
}

// ---------- Perl Array Signal 2 ----------

template <class R,class P1,class P2,class C,class Marsh=SigC::Marshal<R> >
class SignalArray2 : public SignalBase
{
 public:
  typedef SigC::Signal3<R,P1,P2,C,Marsh> SignalType;
  typedef SigC::Slot3<R,P1,P2,C> SlotType;

  SignalArray2(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    if(data.size() < 2)
      throw BadConvertVal();

    ArgBox<P1> p1(*itr++);
    ArgBox<P2> p2(*itr++);

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    R val = m_signal.emit(
      p1.val(), p2.val(),c);

    if(VoidContext(flags))
      return Data();
    return Returns<R>::getRetData(val);
  }

 private:
  static R conv_func(typename SigC::Trait<P1>::ref p1,typename SigC::Trait<P2>::ref p2,C c,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = Returns<R>::getFlags();
    R val;

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);
    data.push_back(p2);

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    Data data_out =
      ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    try {
      val = Returns<R>::ret_val(data_out);
    }
    catch (BadConvertVal) {
      // FIXME find a way to ignore the return val
    }

    SPAGAIN;
    FREETMPS;
    LEAVE;
    return val;
  }

  SignalArray2(const SignalArray2&);
  SignalArray2& operator=(const SignalArray2&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class P1,class P2,class C,class Marsh>
class SignalArray2<void,P1,P2,C,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal3<void,P1,P2,C,Marsh> SignalType;
  typedef SigC::Slot3<void,P1,P2,C> SlotType;

  SignalArray2(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    if(data.size() < 2)
      throw BadConvertVal();

    ArgBox<P1> p1(*itr++);
    ArgBox<P2> p2(*itr++);

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    m_signal.emit(
      p1.val(), p2.val(),c);

    return Data();
  }

 private:
  static void conv_func(typename SigC::Trait<P1>::ref p1,typename SigC::Trait<P2>::ref p2,C c,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = G_VOID;
    

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);
    data.push_back(p2);

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    

    SPAGAIN;
    FREETMPS;
    LEAVE;
    
  }

  SignalArray2(const SignalArray2&);
  SignalArray2& operator=(const SignalArray2&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class R,class P1,class P2,class C,class Marsh>
class SignalArray2<R,P1,P2,C&,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal3<R,P1,P2,C&,Marsh> SignalType;
  typedef SigC::Slot3<R,P1,P2,C&> SlotType;

  SignalArray2(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    if(data.size() < 2)
      throw BadConvertVal();

    ArgBox<P1> p1(*itr++);
    ArgBox<P2> p2(*itr++);

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    R val = m_signal.emit(
      p1.val(), p2.val(),c);

    if(VoidContext(flags))
      return Data();
    return Returns<R>::getRetData(val);
  }

 private:
  static R conv_func(typename SigC::Trait<P1>::ref p1,typename SigC::Trait<P2>::ref p2,C& c,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = Returns<R>::getFlags();
    R val;

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);
    data.push_back(p2);

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    Data data_out =
      ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    try {
      val = Returns<R>::ret_val(data_out);
    }
    catch (BadConvertVal) {
      // FIXME find a way to ignore the return val
    }

    SPAGAIN;
    FREETMPS;
    LEAVE;
    return val;
  }

  SignalArray2(const SignalArray2&);
  SignalArray2& operator=(const SignalArray2&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class P1,class P2,class C,class Marsh>
class SignalArray2<void,P1,P2,C&,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal3<void,P1,P2,C&,Marsh> SignalType;
  typedef SigC::Slot3<void,P1,P2,C&> SlotType;

  SignalArray2(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    if(data.size() < 2)
      throw BadConvertVal();

    ArgBox<P1> p1(*itr++);
    ArgBox<P2> p2(*itr++);

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    m_signal.emit(
      p1.val(), p2.val(),c);

    return Data();
  }

 private:
  static void conv_func(typename SigC::Trait<P1>::ref p1,typename SigC::Trait<P2>::ref p2,C& c,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = G_VOID;
    

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);
    data.push_back(p2);

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    

    SPAGAIN;
    FREETMPS;
    LEAVE;
    
  }

  SignalArray2(const SignalArray2&);
  SignalArray2& operator=(const SignalArray2&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class R,class P1,class P2,class C,class Marsh>
class SignalArray2<R,P1,P2,const C&,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal3<R,P1,P2,const C&,Marsh> SignalType;
  typedef SigC::Slot3<R,P1,P2,const C&> SlotType;

  SignalArray2(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    if(data.size() < 2)
      throw BadConvertVal();

    ArgBox<P1> p1(*itr++);
    ArgBox<P2> p2(*itr++);

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    R val = m_signal.emit(
      p1.val(), p2.val(),c);

    if(VoidContext(flags))
      return Data();
    return Returns<R>::getRetData(val);
  }

 private:
  static R conv_func(typename SigC::Trait<P1>::ref p1,typename SigC::Trait<P2>::ref p2,const C& c,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = Returns<R>::getFlags();
    R val;

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);
    data.push_back(p2);

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    Data data_out =
      ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    try {
      val = Returns<R>::ret_val(data_out);
    }
    catch (BadConvertVal) {
      // FIXME find a way to ignore the return val
    }

    SPAGAIN;
    FREETMPS;
    LEAVE;
    return val;
  }

  SignalArray2(const SignalArray2&);
  SignalArray2& operator=(const SignalArray2&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class P1,class P2,class C,class Marsh>
class SignalArray2<void,P1,P2,const C&,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal3<void,P1,P2,const C&,Marsh> SignalType;
  typedef SigC::Slot3<void,P1,P2,const C&> SlotType;

  SignalArray2(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    if(data.size() < 2)
      throw BadConvertVal();

    ArgBox<P1> p1(*itr++);
    ArgBox<P2> p2(*itr++);

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    m_signal.emit(
      p1.val(), p2.val(),c);

    return Data();
  }

 private:
  static void conv_func(typename SigC::Trait<P1>::ref p1,typename SigC::Trait<P2>::ref p2,const C& c,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = G_VOID;
    

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);
    data.push_back(p2);

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    

    SPAGAIN;
    FREETMPS;
    LEAVE;
    
  }

  SignalArray2(const SignalArray2&);
  SignalArray2& operator=(const SignalArray2&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template<class R,class P1,class P2,class C,class Marsh>
SignalBase* WrapArraySignal(SigC::Signal3<R,P1,P2,C,Marsh> &signal,
	SV *parent = 0) throw()
{
  return new SignalArray2<R,P1,P2,C,Marsh>(signal, parent);
}

// ---------- Perl Array Signal 3 ----------

template <class R,class P1,class P2,class P3,class C,class Marsh=SigC::Marshal<R> >
class SignalArray3 : public SignalBase
{
 public:
  typedef SigC::Signal4<R,P1,P2,P3,C,Marsh> SignalType;
  typedef SigC::Slot4<R,P1,P2,P3,C> SlotType;

  SignalArray3(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    if(data.size() < 3)
      throw BadConvertVal();

    ArgBox<P1> p1(*itr++);
    ArgBox<P2> p2(*itr++);
    ArgBox<P3> p3(*itr++);

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    R val = m_signal.emit(
      p1.val(), p2.val(), p3.val(),c);

    if(VoidContext(flags))
      return Data();
    return Returns<R>::getRetData(val);
  }

 private:
  static R conv_func(typename SigC::Trait<P1>::ref p1,typename SigC::Trait<P2>::ref p2,typename SigC::Trait<P3>::ref p3,C c,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = Returns<R>::getFlags();
    R val;

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);
    data.push_back(p2);
    data.push_back(p3);

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    Data data_out =
      ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    try {
      val = Returns<R>::ret_val(data_out);
    }
    catch (BadConvertVal) {
      // FIXME find a way to ignore the return val
    }

    SPAGAIN;
    FREETMPS;
    LEAVE;
    return val;
  }

  SignalArray3(const SignalArray3&);
  SignalArray3& operator=(const SignalArray3&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class P1,class P2,class P3,class C,class Marsh>
class SignalArray3<void,P1,P2,P3,C,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal4<void,P1,P2,P3,C,Marsh> SignalType;
  typedef SigC::Slot4<void,P1,P2,P3,C> SlotType;

  SignalArray3(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    if(data.size() < 3)
      throw BadConvertVal();

    ArgBox<P1> p1(*itr++);
    ArgBox<P2> p2(*itr++);
    ArgBox<P3> p3(*itr++);

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    m_signal.emit(
      p1.val(), p2.val(), p3.val(),c);

    return Data();
  }

 private:
  static void conv_func(typename SigC::Trait<P1>::ref p1,typename SigC::Trait<P2>::ref p2,typename SigC::Trait<P3>::ref p3,C c,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = G_VOID;
    

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);
    data.push_back(p2);
    data.push_back(p3);

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    

    SPAGAIN;
    FREETMPS;
    LEAVE;
    
  }

  SignalArray3(const SignalArray3&);
  SignalArray3& operator=(const SignalArray3&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class R,class P1,class P2,class P3,class C,class Marsh>
class SignalArray3<R,P1,P2,P3,C&,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal4<R,P1,P2,P3,C&,Marsh> SignalType;
  typedef SigC::Slot4<R,P1,P2,P3,C&> SlotType;

  SignalArray3(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    if(data.size() < 3)
      throw BadConvertVal();

    ArgBox<P1> p1(*itr++);
    ArgBox<P2> p2(*itr++);
    ArgBox<P3> p3(*itr++);

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    R val = m_signal.emit(
      p1.val(), p2.val(), p3.val(),c);

    if(VoidContext(flags))
      return Data();
    return Returns<R>::getRetData(val);
  }

 private:
  static R conv_func(typename SigC::Trait<P1>::ref p1,typename SigC::Trait<P2>::ref p2,typename SigC::Trait<P3>::ref p3,C& c,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = Returns<R>::getFlags();
    R val;

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);
    data.push_back(p2);
    data.push_back(p3);

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    Data data_out =
      ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    try {
      val = Returns<R>::ret_val(data_out);
    }
    catch (BadConvertVal) {
      // FIXME find a way to ignore the return val
    }

    SPAGAIN;
    FREETMPS;
    LEAVE;
    return val;
  }

  SignalArray3(const SignalArray3&);
  SignalArray3& operator=(const SignalArray3&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class P1,class P2,class P3,class C,class Marsh>
class SignalArray3<void,P1,P2,P3,C&,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal4<void,P1,P2,P3,C&,Marsh> SignalType;
  typedef SigC::Slot4<void,P1,P2,P3,C&> SlotType;

  SignalArray3(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    if(data.size() < 3)
      throw BadConvertVal();

    ArgBox<P1> p1(*itr++);
    ArgBox<P2> p2(*itr++);
    ArgBox<P3> p3(*itr++);

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    m_signal.emit(
      p1.val(), p2.val(), p3.val(),c);

    return Data();
  }

 private:
  static void conv_func(typename SigC::Trait<P1>::ref p1,typename SigC::Trait<P2>::ref p2,typename SigC::Trait<P3>::ref p3,C& c,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = G_VOID;
    

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);
    data.push_back(p2);
    data.push_back(p3);

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    

    SPAGAIN;
    FREETMPS;
    LEAVE;
    
  }

  SignalArray3(const SignalArray3&);
  SignalArray3& operator=(const SignalArray3&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class R,class P1,class P2,class P3,class C,class Marsh>
class SignalArray3<R,P1,P2,P3,const C&,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal4<R,P1,P2,P3,const C&,Marsh> SignalType;
  typedef SigC::Slot4<R,P1,P2,P3,const C&> SlotType;

  SignalArray3(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    if(data.size() < 3)
      throw BadConvertVal();

    ArgBox<P1> p1(*itr++);
    ArgBox<P2> p2(*itr++);
    ArgBox<P3> p3(*itr++);

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    R val = m_signal.emit(
      p1.val(), p2.val(), p3.val(),c);

    if(VoidContext(flags))
      return Data();
    return Returns<R>::getRetData(val);
  }

 private:
  static R conv_func(typename SigC::Trait<P1>::ref p1,typename SigC::Trait<P2>::ref p2,typename SigC::Trait<P3>::ref p3,const C& c,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = Returns<R>::getFlags();
    R val;

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);
    data.push_back(p2);
    data.push_back(p3);

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    Data data_out =
      ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    try {
      val = Returns<R>::ret_val(data_out);
    }
    catch (BadConvertVal) {
      // FIXME find a way to ignore the return val
    }

    SPAGAIN;
    FREETMPS;
    LEAVE;
    return val;
  }

  SignalArray3(const SignalArray3&);
  SignalArray3& operator=(const SignalArray3&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class P1,class P2,class P3,class C,class Marsh>
class SignalArray3<void,P1,P2,P3,const C&,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal4<void,P1,P2,P3,const C&,Marsh> SignalType;
  typedef SigC::Slot4<void,P1,P2,P3,const C&> SlotType;

  SignalArray3(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    if(data.size() < 3)
      throw BadConvertVal();

    ArgBox<P1> p1(*itr++);
    ArgBox<P2> p2(*itr++);
    ArgBox<P3> p3(*itr++);

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    m_signal.emit(
      p1.val(), p2.val(), p3.val(),c);

    return Data();
  }

 private:
  static void conv_func(typename SigC::Trait<P1>::ref p1,typename SigC::Trait<P2>::ref p2,typename SigC::Trait<P3>::ref p3,const C& c,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = G_VOID;
    

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);
    data.push_back(p2);
    data.push_back(p3);

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    

    SPAGAIN;
    FREETMPS;
    LEAVE;
    
  }

  SignalArray3(const SignalArray3&);
  SignalArray3& operator=(const SignalArray3&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template<class R,class P1,class P2,class P3,class C,class Marsh>
SignalBase* WrapArraySignal(SigC::Signal4<R,P1,P2,P3,C,Marsh> &signal,
	SV *parent = 0) throw()
{
  return new SignalArray3<R,P1,P2,P3,C,Marsh>(signal, parent);
}

// ---------- Perl Array Signal 4 ----------

template <class R,class P1,class P2,class P3,class P4,class C,class Marsh=SigC::Marshal<R> >
class SignalArray4 : public SignalBase
{
 public:
  typedef SigC::Signal5<R,P1,P2,P3,P4,C,Marsh> SignalType;
  typedef SigC::Slot5<R,P1,P2,P3,P4,C> SlotType;

  SignalArray4(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    if(data.size() < 4)
      throw BadConvertVal();

    ArgBox<P1> p1(*itr++);
    ArgBox<P2> p2(*itr++);
    ArgBox<P3> p3(*itr++);
    ArgBox<P4> p4(*itr++);

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    R val = m_signal.emit(
      p1.val(), p2.val(), p3.val(), p4.val(),c);

    if(VoidContext(flags))
      return Data();
    return Returns<R>::getRetData(val);
  }

 private:
  static R conv_func(typename SigC::Trait<P1>::ref p1,typename SigC::Trait<P2>::ref p2,typename SigC::Trait<P3>::ref p3,typename SigC::Trait<P4>::ref p4,C c,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = Returns<R>::getFlags();
    R val;

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);
    data.push_back(p2);
    data.push_back(p3);
    data.push_back(p4);

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    Data data_out =
      ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    try {
      val = Returns<R>::ret_val(data_out);
    }
    catch (BadConvertVal) {
      // FIXME find a way to ignore the return val
    }

    SPAGAIN;
    FREETMPS;
    LEAVE;
    return val;
  }

  SignalArray4(const SignalArray4&);
  SignalArray4& operator=(const SignalArray4&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class P1,class P2,class P3,class P4,class C,class Marsh>
class SignalArray4<void,P1,P2,P3,P4,C,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal5<void,P1,P2,P3,P4,C,Marsh> SignalType;
  typedef SigC::Slot5<void,P1,P2,P3,P4,C> SlotType;

  SignalArray4(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    if(data.size() < 4)
      throw BadConvertVal();

    ArgBox<P1> p1(*itr++);
    ArgBox<P2> p2(*itr++);
    ArgBox<P3> p3(*itr++);
    ArgBox<P4> p4(*itr++);

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    m_signal.emit(
      p1.val(), p2.val(), p3.val(), p4.val(),c);

    return Data();
  }

 private:
  static void conv_func(typename SigC::Trait<P1>::ref p1,typename SigC::Trait<P2>::ref p2,typename SigC::Trait<P3>::ref p3,typename SigC::Trait<P4>::ref p4,C c,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = G_VOID;
    

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);
    data.push_back(p2);
    data.push_back(p3);
    data.push_back(p4);

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    

    SPAGAIN;
    FREETMPS;
    LEAVE;
    
  }

  SignalArray4(const SignalArray4&);
  SignalArray4& operator=(const SignalArray4&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class R,class P1,class P2,class P3,class P4,class C,class Marsh>
class SignalArray4<R,P1,P2,P3,P4,C&,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal5<R,P1,P2,P3,P4,C&,Marsh> SignalType;
  typedef SigC::Slot5<R,P1,P2,P3,P4,C&> SlotType;

  SignalArray4(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    if(data.size() < 4)
      throw BadConvertVal();

    ArgBox<P1> p1(*itr++);
    ArgBox<P2> p2(*itr++);
    ArgBox<P3> p3(*itr++);
    ArgBox<P4> p4(*itr++);

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    R val = m_signal.emit(
      p1.val(), p2.val(), p3.val(), p4.val(),c);

    if(VoidContext(flags))
      return Data();
    return Returns<R>::getRetData(val);
  }

 private:
  static R conv_func(typename SigC::Trait<P1>::ref p1,typename SigC::Trait<P2>::ref p2,typename SigC::Trait<P3>::ref p3,typename SigC::Trait<P4>::ref p4,C& c,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = Returns<R>::getFlags();
    R val;

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);
    data.push_back(p2);
    data.push_back(p3);
    data.push_back(p4);

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    Data data_out =
      ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    try {
      val = Returns<R>::ret_val(data_out);
    }
    catch (BadConvertVal) {
      // FIXME find a way to ignore the return val
    }

    SPAGAIN;
    FREETMPS;
    LEAVE;
    return val;
  }

  SignalArray4(const SignalArray4&);
  SignalArray4& operator=(const SignalArray4&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class P1,class P2,class P3,class P4,class C,class Marsh>
class SignalArray4<void,P1,P2,P3,P4,C&,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal5<void,P1,P2,P3,P4,C&,Marsh> SignalType;
  typedef SigC::Slot5<void,P1,P2,P3,P4,C&> SlotType;

  SignalArray4(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    if(data.size() < 4)
      throw BadConvertVal();

    ArgBox<P1> p1(*itr++);
    ArgBox<P2> p2(*itr++);
    ArgBox<P3> p3(*itr++);
    ArgBox<P4> p4(*itr++);

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    m_signal.emit(
      p1.val(), p2.val(), p3.val(), p4.val(),c);

    return Data();
  }

 private:
  static void conv_func(typename SigC::Trait<P1>::ref p1,typename SigC::Trait<P2>::ref p2,typename SigC::Trait<P3>::ref p3,typename SigC::Trait<P4>::ref p4,C& c,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = G_VOID;
    

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);
    data.push_back(p2);
    data.push_back(p3);
    data.push_back(p4);

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    

    SPAGAIN;
    FREETMPS;
    LEAVE;
    
  }

  SignalArray4(const SignalArray4&);
  SignalArray4& operator=(const SignalArray4&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class R,class P1,class P2,class P3,class P4,class C,class Marsh>
class SignalArray4<R,P1,P2,P3,P4,const C&,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal5<R,P1,P2,P3,P4,const C&,Marsh> SignalType;
  typedef SigC::Slot5<R,P1,P2,P3,P4,const C&> SlotType;

  SignalArray4(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    if(data.size() < 4)
      throw BadConvertVal();

    ArgBox<P1> p1(*itr++);
    ArgBox<P2> p2(*itr++);
    ArgBox<P3> p3(*itr++);
    ArgBox<P4> p4(*itr++);

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    R val = m_signal.emit(
      p1.val(), p2.val(), p3.val(), p4.val(),c);

    if(VoidContext(flags))
      return Data();
    return Returns<R>::getRetData(val);
  }

 private:
  static R conv_func(typename SigC::Trait<P1>::ref p1,typename SigC::Trait<P2>::ref p2,typename SigC::Trait<P3>::ref p3,typename SigC::Trait<P4>::ref p4,const C& c,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = Returns<R>::getFlags();
    R val;

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);
    data.push_back(p2);
    data.push_back(p3);
    data.push_back(p4);

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    Data data_out =
      ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    try {
      val = Returns<R>::ret_val(data_out);
    }
    catch (BadConvertVal) {
      // FIXME find a way to ignore the return val
    }

    SPAGAIN;
    FREETMPS;
    LEAVE;
    return val;
  }

  SignalArray4(const SignalArray4&);
  SignalArray4& operator=(const SignalArray4&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template <class P1,class P2,class P3,class P4,class C,class Marsh>
class SignalArray4<void,P1,P2,P3,P4,const C&,Marsh> : public SignalBase
{
 public:
  typedef SigC::Signal5<void,P1,P2,P3,P4,const C&,Marsh> SignalType;
  typedef SigC::Slot5<void,P1,P2,P3,P4,const C&> SlotType;

  SignalArray4(SignalType &signal, SV *parent = 0) throw()
	: m_signal(signal), m_parent(parent) {}

  virtual SigC::Connection connect(const Slot &slot) throw()
  {
    return m_signal.connect(get_slot(slot));
  }

  // Note that this calls RetCode::check_ignore() if
  // the arguments don't match up, so the slot
  // created by this function should never be called
  // on its own, but only through a signal it's
  // been connected to.
  static SlotType get_slot(const Slot &slot) throw()
  {
    return new SigC::AdaptorSlotNode((SigC::FuncPtr) &conv_func, slot.slot());
  }

  virtual Data emit(const Data &data, I32 flags) throw(BadConvertVal)
  {
    Data::Iter itr = data.begin();
    if(data.size() < 4)
      throw BadConvertVal();

    ArgBox<P1> p1(*itr++);
    ArgBox<P2> p2(*itr++);
    ArgBox<P3> p3(*itr++);
    ArgBox<P4> p4(*itr++);

    C c;

    while(itr != data.end())
      PushBack(c, ArgBox<typename C::value_type>(*itr++).ret_val());

    m_signal.emit(
      p1.val(), p2.val(), p3.val(), p4.val(),c);

    return Data();
  }

 private:
  static void conv_func(typename SigC::Trait<P1>::ref p1,typename SigC::Trait<P2>::ref p2,typename SigC::Trait<P3>::ref p3,typename SigC::Trait<P4>::ref p4,const C& c,SigC::AdaptorSlotNode* node)
  {
    Data data;
    I32 flags = G_VOID;
    

    dSP;
    ENTER;
    SAVETMPS;

    data.push_back(p1);
    data.push_back(p2);
    data.push_back(p3);
    data.push_back(p4);

    for(typename C::const_iterator I = c.begin(); I != c.end(); ++I)
      data.push_back(*I);

    SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(node->slot_.impl());

    ((typename Slot::Proxy)(slot->proxy_))(data, flags, slot);

    

    SPAGAIN;
    FREETMPS;
    LEAVE;
    
  }

  SignalArray4(const SignalArray4&);
  SignalArray4& operator=(const SignalArray4&);

  SignalType &m_signal;
  ParentBox m_parent;
};

template<class R,class P1,class P2,class P3,class P4,class C,class Marsh>
SignalBase* WrapArraySignal(SigC::Signal5<R,P1,P2,P3,P4,C,Marsh> &signal,
	SV *parent = 0) throw()
{
  return new SignalArray4<R,P1,P2,P3,P4,C,Marsh>(signal, parent);
}


} // namespace SigCPerl

#endif // SIGC_PERL_SIGNAL_ARRAY_H
