/* qshutdown, a program to shutdown/reboot/suspend/hibernate the system
 * Copyright (C) 2009 2010 2011 Christian Metscher <hakaishi@web.de>

 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "passwd.h"
#include "ch_passwd.h"

PassWord::PassWord(QWidget *parent): QDialog(parent){

	setupUi(this);

     setWindowFlags(Qt::WindowStaysOnTopHint | Qt::Window);    //always in front

#ifdef Q_OS_WIN32
     file = QDesktopServices::storageLocation(QDesktopServices::DataLocation) + "/qshutdown/qshutdown.conf";
     settings = new QSettings(file, QSettings::NativeFormat);
#else //!Q_OS_WIN32
     file = QDir::homePath() + "/.qshutdown/qshutdown.conf";
     settings = new QSettings(file, QSettings::NativeFormat);
#endif //Q_OS_WIN32

     msgBox = new QMessageBox(this);
     msgBox->setWindowTitle("Error");
     msgBox->setIcon(QMessageBox::Warning);
     msgBox->setWindowFlags(Qt::WindowStaysOnTopHint | Qt::Window);
     msgBox->setInformativeText(tr("The password is not correct!"));

     chPW = new ChangePassword(this);

     update(); //enable password line if a password was set

     passwdLineEdit->setFocus();

     connect(passwdLineEdit, SIGNAL(returnPressed()), this, SLOT(checkPW()));
     connect(buttonBox, SIGNAL(accepted()), this, SLOT(checkPW()));
     connect(changePasswdButton, SIGNAL(clicked(bool)), chPW, SLOT(show()));
     connect(this, SIGNAL(rejected()), passwdLineEdit, SLOT(clear()));
     connect(chPW, SIGNAL(updatePasswordGui()), this, SLOT(update()));
}

PassWord::~PassWord(){ delete settings; }

void PassWord::checkPW(){
     if(settings->value("Password").toByteArray() == 
         QCryptographicHash::hash(passwdLineEdit->text().toUtf8(), QCryptographicHash::Sha1)){
                                   //check if the entered password matches the saved one
       success();
       accept();
       passwdLineEdit->clear();
     }
     else
       msgBox->exec();
}

void PassWord::update(){
     if(settings->contains("Password")){
       passwdLineEdit->setEnabled(true);
       changePasswdButton->setText(tr("&Change password"));
     }
}
